<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::statement("
            CREATE OR REPLACE VIEW court_bills AS
            SELECT
                fn_BillingMonthEx(b.BillingPeriod) AS BillMonth,
                b.BillingPeriod,
                CAST(b.BillingDate AS DATETIME) AS BillingDate,

                c.CustomerName,
                c.TenantName,
                c.ClientCode,

                c.Address1 AS Court,
                LEFT(c.Address3, 3) AS CourtID,

                p.PropName,
                b.BulkInvoiceID,

                CAST(b.DueDate AS DATETIME) AS DueDate,

                SUM(b.ConsumptionBilled) AS ConsumptionBilled,
                SUM(b.TotalBill) AS TotalBill,

                0 AS BalanceBF,
                0 AS TotalPayments,
                SUM(b.TotalBill) AS BalanceCF,

                CONCAT(c.ClientCode, '_', b.BillingPeriod) AS BillNo,
                COUNT(b.BillID) AS NoOfBills

            FROM Bill b
            INNER JOIN Customer c ON b.CustomerID = c.CustomerID
            INNER JOIN ProUnits pu ON c.UnitID = pu.UnitID
            INNER JOIN Property p ON pu.PropID = p.PropID

            GROUP BY
                fn_BillingMonthEx(b.BillingPeriod),
                b.BillingPeriod,
                b.BillingDate,
                b.DueDate,
                c.CustomerName,
                c.TenantName,
                c.ClientCode,
                c.Address1,
                LEFT(c.Address3, 3),
                p.PropName,
                b.BulkInvoiceID
        ");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement("DROP VIEW IF EXISTS court_bills");
    }
};
