<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('meter_readers', function (Blueprint $table) {
            $table->id();
            $table->string('username', 50)->unique();
            $table->string('first_name', 100);
            $table->string('last_name', 100);
            $table->string('email', 100)->unique();
            $table->string('phone_number', 20);
            $table->string('password');
            $table->unsignedBigInteger('company_id');
            $table->unsignedBigInteger('PropID')->nullable();
            $table->rememberToken();
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('company_id')
                  ->references('CompanyID')
                  ->on('company')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('meter_readers', function (Blueprint $table) {
            $table->dropForeign(['company_id']);
        });
        
        Schema::dropIfExists('meter_readers');
    }
};
