<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('tenancy_statuses', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique();
            $table->string('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        // Insert default statuses
        \Illuminate\Support\Facades\DB::table('tenancy_statuses')->insert([
            ['name' => 'pending', 'description' => 'Tenancy is pending', 'is_active' => true],
            ['name' => 'active', 'description' => 'Tenancy is active', 'is_active' => true],
            ['name' => 'terminated', 'description' => 'Tenancy has been terminated', 'is_active' => true],
            ['name' => 'completed', 'description' => 'Tenancy has been completed', 'is_active' => true],
        ]);
    }

    public function down()
    {
        Schema::dropIfExists('tenancy_statuses');
    }
};