<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('tenancy_services', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenancy_id')->constrained('tenancies');
            
            // Change this line to use the correct table and column names
            $table->unsignedBigInteger('service_id');
            $table->foreign('service_id')->references('IDService')->on('propservice');
            
            $table->decimal('price', 12, 2);
            $table->string('billing_cycle'); // e.g., 'monthly', 'quarterly'
            $table->date('start_date');
            $table->date('end_date')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('tenancy_services');
    }
};