<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('reading_code_statuses', function (Blueprint $table) {
            $table->id();
            $table->string('ReadingCode', 10);
            $table->string('ReadingCodeDefn', 100);
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('property_id')->nullable();
            $table->foreign('company_id')->references('CompanyID')->on('company');
            $table->foreign('property_id')->references('PropID')->on('property');
            $table->boolean('isActive');
            $table->engine = 'InnoDB';
        });

        DB::table('reading_code_statuses')->insert([
            ['ReadingCode' => 'NR', 'ReadingCodeDefn' => 'Normal Reading', 'isActive' => 1],
            ['ReadingCode' => 'GL', 'ReadingCodeDefn' => 'Gate Locked', 'isActive' => 0],
            ['ReadingCode' => 'INVR', 'ReadingCodeDefn' => 'Invisible Reading', 'isActive' => 0],
            ['ReadingCode' => 'MB', 'ReadingCodeDefn' => 'Meter Burried', 'isActive' => 0],
            ['ReadingCode' => 'MS', 'ReadingCodeDefn' => 'Meter Stalled', 'isActive' => 0],
            ['ReadingCode' => 'NM', 'ReadingCodeDefn' => 'New Meter', 'isActive' => 0],
            ['ReadingCode' => 'OFF', 'ReadingCodeDefn' => 'Meter Off', 'isActive' => 0],
        ]);
    }

    public function down()
    {
        Schema::dropIfExists('reading_code_statuses');
    }
};
