<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('rpt_reading_codes', function (Blueprint $table) {
            $table->id();
            $table->string('ReadingCode', 10);
            $table->string('ReadingCodeDefn', 100);
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('property_id')->nullable();
            $table->foreign('company_id')->references('CompanyID')->on('company');
            $table->foreign('property_id')->references('PropID')->on('property');
            $table->engine = 'InnoDB';
        });

        DB::table('rpt_reading_codes')->insert([
            ['ReadingCode' => 'IC', 'ReadingCodeDefn' => 'Illegal Connection'],
            ['ReadingCode' => 'OT', 'ReadingCodeDefn' => 'Other'],
            ['ReadingCode' => 'UM', 'ReadingCodeDefn' => 'Unregistered Meter'],
            ['ReadingCode' => 'WR', 'ReadingCodeDefn' => 'Wrong Location'],
        ]);
    }

    public function down()
    {
        Schema::dropIfExists('rpt_reading_codes');
    }
};
