<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        DB::unprepared('
            DROP TRIGGER IF EXISTS trg_updatecons;

            CREATE TRIGGER trg_updatecons
            BEFORE UPDATE ON tmp_meterreading
            FOR EACH ROW
            BEGIN
                DECLARE vMaxReading INT;
                DECLARE vAvgCons INT;
                DECLARE vCons INT;

                IF NEW.ConsType = "ENERGY" THEN
                    SELECT p.EMaxReading, c.EAvgCons
                    INTO vMaxReading, vAvgCons
                    FROM customer c
                    INNER JOIN prounits p ON c.UnitID = p.UnitID
                    WHERE c.CustomerID = NEW.CustomerID AND p.PropID = NEW.PropID
                    LIMIT 1;

                    SET vCons = NEW.Reading - NEW.PrvReading;

                    IF vCons < 0 THEN
                        IF ((vMaxReading - NEW.PrvReading) + NEW.Reading) < (vAvgCons * 3) THEN
                            SET vCons = (vMaxReading - NEW.PrvReading) + NEW.Reading;
                        END IF;

                        IF vCons > (4 * vAvgCons) THEN
                            SET vCons = NEW.Reading - NEW.PrvReading;
                        END IF;
                    END IF;

                    IF vCons IS NULL THEN
                        SET NEW.Consumption = 0;
                        SET NEW.BaseofBilling = "E";
                    ELSEIF vCons < 0 THEN
                        SET NEW.Consumption = vCons;
                        SET NEW.BaseofBilling = "E";
                    ELSE
                        SET NEW.Consumption = vCons;
                        SET NEW.BaseofBilling = "C";
                    END IF;
                END IF;
            END
        ');
    }

    public function down(): void
    {
        DB::unprepared('DROP TRIGGER IF EXISTS Trg_UpdateCons');
    }
};