<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reading_reports', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id');
            $table->unsignedBigInteger('prop_id');
            $table->string('readingCodeDfn')->nullable();
            $table->string('meterNumber')->nullable();
            $table->string('accountNumber')->nullable();
            $table->string('meterReading')->nullable();
            $table->string('comments')->nullable();
            $table->string('imagePath');
            $table->string('reportDate');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reading_reports');
    }
};
