-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Jan 28, 2026 at 03:27 PM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `propertymgtdatabase`
--

DELIMITER $$
--
-- Procedures
--
CREATE DEFINER=`root`@`localhost` PROCEDURE `SP_CREATE_EMETER_READING` (IN `p_CompanyID` INT, IN `p_BMonth` CHAR(6))   proc_label: BEGIN

    -- ======================
    -- 1. DECLARE VARIABLES
    -- ======================
    DECLARE v_done INT DEFAULT FALSE;
    DECLARE v_PrvReading INT;
    DECLARE v_PrvReadingDate DATE;
    DECLARE v_PrvReadingID INT;
    DECLARE v_MeterReadingID INT;
    DECLARE v_records_affected INT DEFAULT 0;

    DECLARE cur CURSOR FOR
        SELECT 
            m1.Reading, 
            m1.ReadingDate, 
            m1.MeterReadingID, 
            m2.MeterReadingID AS NewReadingID
        FROM MeterReading m1
        INNER JOIN (
            SELECT CustomerID, MAX(ReadingDate) AS MaxDate
            FROM MeterReading
            WHERE BillingPeriod <> p_BMonth
              AND CompanyID = p_CompanyID
            GROUP BY CustomerID
        ) latest ON m1.CustomerID = latest.CustomerID AND m1.ReadingDate = latest.MaxDate
        INNER JOIN MeterReading m2 ON m1.CustomerID = m2.CustomerID
        WHERE m2.BillingPeriod = p_BMonth
          AND m1.MeterReadingID <> m2.MeterReadingID;

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;

    -- ======================
    -- 2. SET COLLATION
    -- ======================
    SET collation_connection = 'utf8mb4_unicode_ci';

    -- ======================
    -- 3. DEBUG LOG TABLE
    -- ======================
    DROP  TABLE IF EXISTS SP_CREATE_EMETER_READING_log;
    CREATE  TABLE SP_CREATE_EMETER_READING_log (
        log_id INT AUTO_INCREMENT PRIMARY KEY,
        log_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        step_name VARCHAR(100),
        message TEXT,
        records_affected INT
    );

    INSERT INTO SP_CREATE_EMETER_READING_log (step_name, message)
    VALUES ('START', CONCAT('Starting SP_CREATE_EMETER_READING for CompanyID: ', p_CompanyID, ', BMonth: ', p_BMonth));

    -- ======================
    -- 4. START TRANSACTION
    -- ======================
    START TRANSACTION;

    -- Step 1: Clear tmp_meterreading
    DELETE FROM  tmp_meterreading WHERE CompanyID = p_CompanyID;
    SET v_records_affected = ROW_COUNT();
    INSERT INTO SP_CREATE_EMETER_READING_log (step_name, message, records_affected)
    VALUES ('CLEANUP', 'Cleared tmp_meterreading', v_records_affected);

    -- Step 2: Insert new meter reading records
    INSERT INTO MeterReading (
        BillingPeriod, ConsType, CustomerID, UnitID, 
        BaseOfBilling, MeterNo, CompanyID, ReadingDate
    )
    SELECT 
        p_BMonth, 'ENERGY', c.CustomerID, c.UnitID, 
        'E', c.EMeterNo, p.CompanyID, NOW()
    FROM CUSTOMER c 
    INNER JOIN ProUnits pu ON c.UnitID = pu.UnitID 
    INNER JOIN PROPERTY p ON pu.PropID = p.PropID
    WHERE c.AccountStatus = 'A' 
    AND p.CompanyID = p_CompanyID;

    SET v_records_affected = ROW_COUNT();
    INSERT INTO SP_CREATE_EMETER_READING_log (step_name, message, records_affected)
    VALUES ('INSERT', 'Created new meter reading records', v_records_affected);

    IF v_records_affected = 0 THEN
        ROLLBACK;
        INSERT INTO SP_CREATE_EMETER_READING_log (step_name, message)
        VALUES ('ERROR', 'No records were inserted into MeterReading');
        SELECT * FROM SP_CREATE_EMETER_READING_log ORDER BY log_id;
        LEAVE proc_label;
    END IF;

    -- Step 3: Clear temp table for current period
    DELETE FROM tmp_meterreading 
    WHERE BillingPeriod = p_BMonth
      AND CompanyID = p_CompanyID;

    SET v_records_affected = ROW_COUNT();
    INSERT INTO SP_CREATE_EMETER_READING_log (step_name, message, records_affected)
    VALUES ('CLEANUP', 'Cleared tmp_meterreading for current period', v_records_affected);

    -- Step 4: Update previous readings using cursor
    OPEN cur;
    SET v_records_affected = 0;

    read_loop: LOOP
        FETCH cur INTO v_PrvReading, v_PrvReadingDate, v_PrvReadingID, v_MeterReadingID;
        IF v_done THEN
            LEAVE read_loop;
        END IF;

        UPDATE MeterReading 
        SET 
            PrvReading = v_PrvReading, 
            PrvReadingDate = v_PrvReadingDate, 
            PrvReadingID = v_PrvReadingID
        WHERE MeterReadingID = v_MeterReadingID;

        SET v_records_affected = v_records_affected + 1;

        IF v_records_affected % 100 = 0 THEN
            INSERT INTO SP_CREATE_EMETER_READING_log (step_name, message) 
            VALUES ('PROCESSING', CONCAT('Processed ', v_records_affected, ' meter reading updates'));
        END IF;
    END LOOP;

    CLOSE cur;

    INSERT INTO SP_CREATE_EMETER_READING_log (step_name, message, records_affected)
    VALUES ('CURSOR', 'Completed updating previous readings', v_records_affected);

    -- Step 5: Copy to tmp_meterreading
    INSERT INTO tmp_meterreading
    SELECT 
        MeterReadingID, BillingPeriod, ConsType, CustomerID, 
        UnitID, Reading, ReadingDate, Consumption, 
        BaseOfBilling, ImagePath, PrvReading, PrvReadingDate, CompanyID
    FROM MeterReading
    WHERE CompanyID = p_CompanyID 
      AND BillingPeriod = p_BMonth;

    SET v_records_affected = ROW_COUNT();
    INSERT INTO SP_CREATE_EMETER_READING_log (step_name, message, records_affected)
    VALUES ('TEMP_TABLE', 'Copied records to tmp_meterreading', v_records_affected);

    IF v_records_affected = 0 THEN
        ROLLBACK;
        INSERT INTO SP_CREATE_EMETER_READING_log (step_name, message)
        VALUES ('ERROR', 'No records were inserted into tmp_meterreading');
        SELECT * FROM SP_CREATE_EMETER_READING_log ORDER BY log_id;
        LEAVE proc_label;
    END IF;

    -- Step 6: Commit
    COMMIT;

    INSERT INTO SP_CREATE_EMETER_READING_log (step_name, message)
    VALUES ('COMPLETE', 'SP_CREATE_EMETER_READING completed successfully');

    -- Return debug info
    SELECT * FROM SP_CREATE_EMETER_READING_log ORDER BY log_id;

    -- Return success
    SELECT CONCAT('Successfully created ', v_records_affected, ' meter readings') AS Result;

END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `SP_CREATE_PERIOD` (IN `p_CompanyID` INT, IN `p_PrvBMonth` CHAR(6), IN `p_BMonth` CHAR(6))   BEGIN
    /* ================================
       1. DECLARATIONS (MUST BE FIRST)
       ================================ */
    DECLARE v_BulkInvoiceNo INT DEFAULT NULL;

    DECLARE EXIT HANDLER FOR SQLEXCEPTION
    BEGIN
        INSERT INTO SP_CREATE_PERIOD
            (StepName, Message, CompanyID, PrvBMonth, BMonth)
        VALUES
            ('ERROR',
             'SQL Exception occurred',
             p_CompanyID, p_PrvBMonth, p_BMonth);
    END;

    /* ================================
       2. CREATE DEBUG LOG TABLE
       ================================ */
    CREATE TABLE IF NOT EXISTS SP_CREATE_PERIOD (
        LogID      BIGINT AUTO_INCREMENT PRIMARY KEY,
        StepName   VARCHAR(255),
        Message    TEXT,
        CompanyID  INT NULL,
        PrvBMonth  CHAR(6) NULL,
        BMonth     CHAR(6) NULL,
        LogTime    TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB;

    /* ================================
       3. LOG START
       ================================ */
    INSERT INTO SP_CREATE_PERIOD
        (StepName, Message, CompanyID, PrvBMonth, BMonth)
    VALUES
        ('START',
         'Procedure started',
         p_CompanyID, p_PrvBMonth, p_BMonth);

    /* ================================
       4. GET BULK INVOICE ID
       ================================ */
    SELECT BulkInvoiceID
    INTO v_BulkInvoiceNo
    FROM BulkInvoice
    WHERE CompanyID = p_CompanyID
      AND BillingPeriod = p_PrvBMonth
    LIMIT 1;

    INSERT INTO SP_CREATE_PERIOD
        (StepName, Message, CompanyID)
    VALUES
        ('FETCH_BULK_INVOICE',
         CONCAT('BulkInvoiceID = ', IFNULL(v_BulkInvoiceNo, 'NULL')),
         p_CompanyID);

    /* ================================
       5. UPDATE ELECTRICITY BALANCES
       ================================ */
    CALL SP_UPDATE_E_BALANCES(v_BulkInvoiceNo, p_PrvBMonth);

    INSERT INTO SP_CREATE_PERIOD
        (StepName, Message, CompanyID)
    VALUES
        ('SP_UPDATE_E_BALANCES',
         'Electricity balances updated',
         p_CompanyID);

    /* ================================
       6. CREATE NEW METER READINGS
       ================================ */
    CALL SP_CREATE_EMETER_READING(p_CompanyID, p_BMonth);

    INSERT INTO SP_CREATE_PERIOD
        (StepName, Message, CompanyID)
    VALUES
        ('SP_CREATE_EMETER_READING',
         'New meter readings created',
         p_CompanyID);

    /* ================================
       7. LOG END
       ================================ */
    INSERT INTO SP_CREATE_PERIOD
        (StepName, Message, CompanyID)
    VALUES
        ('END',
         'Procedure completed successfully',
         p_CompanyID);

END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `SP_DELETE_EBILLS` (IN `p_BulkInvoiceNo` INT, IN `p_BMonth` CHAR(6))   BEGIN
    -- Delete from BillLine2
    DELETE FROM BillLine2
    WHERE BillID IN (
        SELECT BillID 
        FROM Bill
        WHERE BillingPeriod = p_BMonth 
        AND BulkInvoiceID = p_BulkInvoiceNo
    );

    -- Delete from BillLine
    DELETE FROM BillLine
    WHERE BillID IN (
        SELECT BillID 
        FROM Bill
        WHERE BillingPeriod = p_BMonth 
        AND BulkInvoiceID = p_BulkInvoiceNo
    );

    -- Finally, delete from Bill
    DELETE FROM Bill
    WHERE BillingPeriod = p_BMonth 
    AND BulkInvoiceID = p_BulkInvoiceNo;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `SP_DO_BILLS` (IN `p_BulkInvoiceNo` INT, IN `p_BMonth` CHAR(6), IN `p_BillDate` DATETIME, IN `p_CompanyID` INT, IN `p_isDraftBills` CHAR(1))   BEGIN
    DECLARE v_CustID INT;
    DECLARE v_done INT DEFAULT FALSE;
    
    -- Cursor for first set of bills
    DECLARE Bill_Cursor CURSOR FOR
        SELECT m.CustomerID
        FROM PROPERTY p 
        INNER JOIN BulkInvoice b ON p.PropID = b.PropID 
        INNER JOIN ProUnits pu ON p.PropID = pu.PropID 
        INNER JOIN CUSTOMER c ON pu.UnitID = c.UnitID 
        INNER JOIN MeterReading m ON c.CustomerID = m.CustomerID AND b.BillingPeriod = m.BillingPeriod
        WHERE b.BulkInvoiceID = p_BulkInvoiceNo 
          AND b.BillingPeriod = p_BMonth 
          AND c.AccountStatus = 'A'
          AND m.Reading IS NOT NULL 
          AND m.Consumption <> 0
        ORDER BY c.Address2;
    
    -- Cursor for zero consumption bills
    DECLARE Bill2_Cursor CURSOR FOR
        SELECT m.CustomerID
        FROM PROPERTY p 
        INNER JOIN BulkInvoice b ON p.PropID = b.PropID 
        INNER JOIN ProUnits pu ON p.PropID = pu.PropID 
        INNER JOIN CUSTOMER c ON pu.UnitID = c.UnitID 
        INNER JOIN MeterReading m ON c.CustomerID = m.CustomerID AND b.BillingPeriod = m.BillingPeriod
        WHERE b.BulkInvoiceID = p_BulkInvoiceNo 
          AND b.BillingPeriod = p_BMonth 
          AND c.AccountStatus = 'A'
          AND m.Reading IS NOT NULL 
          AND m.Consumption = 0
          AND m.CustomerID = 0 
          AND p.CompanyID = 0  -- Disabled zero billing
        ORDER BY c.Address2;
    
    -- Handler for cursor loops
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;
    
    -- Update meter readings
    CALL SP_UPDATE_E_READINGS(p_CompanyID, p_BMonth);
    
    -- Delete old bills if draft
    IF p_isDraftBills = 'Y' THEN
        CALL SP_DELETE_EBILLS(p_BulkInvoiceNo, p_BMonth);
    END IF;
    
    -- Process non-zero consumption bills
    OPEN Bill_Cursor;
    read_loop: LOOP
        FETCH Bill_Cursor INTO v_CustID;
        IF v_done THEN
            LEAVE read_loop;
        END IF;
        
        CALL SP_PROCESS_EBILLS_NEW(p_BulkInvoiceNo, v_CustID, p_BMonth, p_BillDate);
    END LOOP;
    CLOSE Bill_Cursor;
    
    -- Reset done flag
    SET v_done = FALSE;
    
    -- Process zero consumption bills (currently disabled)
    OPEN Bill2_Cursor;
    read_loop2: LOOP
        FETCH Bill2_Cursor INTO v_CustID;
        IF v_done THEN
            LEAVE read_loop2;
        END IF;
        
        CALL SP_PROCESS_EBILLS2(p_BulkInvoiceNo, v_CustID, p_BMonth, p_BillDate);
    END LOOP;
    CLOSE Bill2_Cursor;
    
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `SP_GENERATE_INDIVIDUAL_BILL` (IN `p_CompanyID` INT, IN `p_CustomerID` INT, IN `p_BillingPeriod` CHAR(6), IN `p_User` VARCHAR(50))   BEGIN
    DECLARE v_UnitID INT;
    DECLARE v_Rent DECIMAL(12,2);
    DECLARE v_RentMonths INT DEFAULT 1;
    DECLARE v_BillID CHAR(11);
    DECLARE v_PreviousBalance DECIMAL(12,2);
    DECLARE v_CurrentCharges DECIMAL(12,2);
    DECLARE v_ServiceTotal DECIMAL(12,2);
    DECLARE v_TotalPayable DECIMAL(12,2);
    DECLARE v_CustomerName VARCHAR(100);
    DECLARE v_UnitName VARCHAR(50);

    -- Get customer and unit details
    SELECT 
        c.CustomerName, 
        c.UnitID, 
        u.UnitIdentity,
        u.MonthlyRent
    INTO 
        v_CustomerName,
        v_UnitID, 
        v_UnitName,
        v_Rent
    FROM customer c
    JOIN prounits u ON u.UnitID = c.UnitID
    WHERE c.CustomerID = p_CustomerID
      AND c.CompanyID = p_CompanyID
      AND c.AccountStatus = 'A'
      AND u.UnitActive = 1;

    -- If customer not found or inactive
    IF v_UnitID IS NULL THEN
        SIGNAL SQLSTATE '45000' 
        SET MESSAGE_TEXT = 'Customer not found or account is inactive';
    END IF;

    -- Debug log
    INSERT INTO debug_log (message, created_at)
    VALUES (CONCAT('Starting individual bill generation | CustomerID=', p_CustomerID, 
                  ' | Name=', v_CustomerName,
                  ' | Unit=', v_UnitName,
                  ' | Period=', p_BillingPeriod), NOW());

    -- Generate bill ID
    SET v_BillID = CONCAT(p_BillingPeriod, LPAD(p_CustomerID, 5, '0'));

    -- Check if bill already exists
    IF EXISTS (SELECT 1 FROM rentservicebill WHERE BillID = v_BillID) THEN
        SIGNAL SQLSTATE '45000' 
        SET MESSAGE_TEXT = 'Bill already exists for this customer and period';
    END IF;

    START TRANSACTION;

    -- =========================
    -- PREVIOUS BALANCE
    -- =========================
    SELECT IFNULL((SELECT TotalPayable
                   FROM rentservicebill
                   WHERE CustomerID = p_CustomerID
                     AND CompanyID = p_CompanyID
                     AND BillingPeriod < p_BillingPeriod
                   ORDER BY BillingPeriod DESC
                   LIMIT 1), 0)
    INTO v_PreviousBalance;

    -- =========================
    -- RENT CHARGES
    -- =========================
    SELECT IFNULL((SELECT NoMonthPerYear
                   FROM propservice
                   WHERE ServiceName = 'Monthly Rent'
                     AND CompanyID = p_CompanyID
                   LIMIT 1), 1)
    INTO v_RentMonths;

    SET v_CurrentCharges = v_Rent * v_RentMonths;

    -- =========================
    -- SERVICE CHARGES
    -- =========================
    SELECT IFNULL((SELECT SUM(
                            COALESCE(cps.Price, ps.Price)
                            * cps.Quantity
                            * ps.NoMonthPerYear)
                   FROM customer_prop_service cps
                   JOIN propservice ps
                       ON ps.IDService = cps.IDService
                      AND ps.CompanyID = p_CompanyID
                   WHERE cps.CustomerID = p_CustomerID
                     AND cps.IsActive = 1
                     AND ps.IDService <> 1
                     AND (cps.EndDate IS NULL OR cps.EndDate >= CURDATE())
                   ), 0)
    INTO v_ServiceTotal;

    SET v_CurrentCharges = v_CurrentCharges + v_ServiceTotal;
    SET v_TotalPayable = v_PreviousBalance + v_CurrentCharges;

    -- =========================
    -- INSERT BILL HEADER
    -- =========================
    INSERT INTO rentservicebill (
        BillID, CompanyID, CustomerID, UnitID,
        BillingPeriod, BillingDate,
        PreviousBalance, CurrentCharges,
        TotalPayable, BillStatus, CreatedBy
    )
    VALUES (
        v_BillID, p_CompanyID, p_CustomerID, v_UnitID,
        p_BillingPeriod, CURDATE(),
        v_PreviousBalance, v_CurrentCharges,
        v_TotalPayable, 'OPEN', p_User
    );

    -- =========================
    -- INSERT BILL LINES
    -- =========================

    -- RENT LINE
    INSERT INTO rentservicebillline (
        BillID, LineType, ItemID, ItemName,
        Units, UnitPrice, LineAmount, CreatedAt
    )
    VALUES (
        v_BillID, 'RENT', 1, 'Monthly Rent',
        v_RentMonths, v_Rent, v_Rent * v_RentMonths, NOW()
    );

    -- SERVICE LINES
    INSERT INTO rentservicebillline (
        BillID, LineType, ItemID, ItemName,
        Units, UnitPrice, LineAmount, CreatedAt
    )
    SELECT
        v_BillID,
        'SERVICE',
        ps.IDService,
        ps.ServiceName,
        cps.Quantity * ps.NoMonthPerYear,
        COALESCE(cps.Price, ps.Price),
        COALESCE(cps.Price, ps.Price) * cps.Quantity * ps.NoMonthPerYear,
        NOW()
    FROM customer_prop_service cps
    JOIN propservice ps
        ON ps.IDService = cps.IDService
       AND ps.CompanyID = p_CompanyID
    WHERE cps.CustomerID = p_CustomerID
      AND cps.IsActive = 1
      AND ps.IDService <> 1
      AND (cps.EndDate IS NULL OR cps.EndDate >= CURDATE());

    COMMIT;

    -- Log success
    INSERT INTO debug_log (message, created_at)
    VALUES (CONCAT('Successfully generated bill ', v_BillID, 
                  ' for customer ', v_CustomerName,
                  ' | Total: ', v_TotalPayable), NOW());

    SELECT 
        v_BillID AS BillID,
        v_CustomerName AS CustomerName,
        v_UnitName AS UnitName,
        v_PreviousBalance AS PreviousBalance,
        v_CurrentCharges AS CurrentCharges,
        v_TotalPayable AS TotalPayable,
        'Bill generated successfully' AS Message;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `SP_GET_CUSTOMER_RENT_AND_SERVICES` (IN `p_CompanyID` INT)   BEGIN
    /*
      =========================
      RENT LINES
      =========================
    */
    SELECT
        c.CustomerID,
        c.CustomerName,
        c.UnitID,
        u.UnitIdentity,
        'RENT' AS ChargeType,
        'Monthly Rent' AS ItemName,
        1 AS Units,
        u.MonthlyRent AS UnitPrice,
        u.MonthlyRent AS Amount
    FROM customer c
    JOIN prounits u 
        ON u.UnitID = c.UnitID
    WHERE c.AccountStatus = 'A'
      AND u.UnitActive = 1;

    /*
      =========================
      SERVICE LINES
      =========================
    */
    SELECT
        c.CustomerID,
        c.CustomerName,
        c.UnitID,
        u.UnitIdentity,
        'SERVICE' AS ChargeType,
        ps.ServiceName AS ItemName,
        1 AS Units,
        COALESCE(cps.Price, ps.Price) AS UnitPrice,
        COALESCE(cps.Price, ps.Price) AS Amount
    FROM customer c
    JOIN customer_prop_service cps
        ON cps.CustomerID = c.CustomerID
        AND cps.IsActive = 1
    JOIN propservice ps
        ON ps.IDService = cps.IDService
        AND ps.CompanyID = p_CompanyID
    JOIN prounits u
        ON u.UnitID = c.UnitID
    WHERE c.AccountStatus = 'A'
      AND (cps.EndDate IS NULL OR cps.EndDate >= CURDATE());

END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `SP_INIT_PERIOD` (IN `p_PrvBMonth` CHAR(6), IN `p_BMonth` CHAR(6))   BEGIN
    /* ================================
       1. DECLARATIONS (MUST BE FIRST)
       ================================ */
    DECLARE v_CompanyID INT;
    DECLARE done INT DEFAULT 0;

    DECLARE PD_cursor CURSOR FOR
        SELECT CompanyID
        FROM BulkInvoice
        WHERE BillingPeriod = p_PrvBMonth
        ORDER BY CompanyID;

    DECLARE CONTINUE HANDLER FOR NOT FOUND
        SET done = 1;

    DECLARE EXIT HANDLER FOR SQLEXCEPTION
    BEGIN
        INSERT INTO sp_debug_log
            (ProcedureName, StepName, Message, CompanyID)
        VALUES
            ('SP_INIT_PERIOD', 'ERROR',
             'SQL Exception occurred', v_CompanyID);
    END;

    /* ================================
       2. CREATE DEBUG TABLE
       ================================ */
    CREATE TABLE IF NOT EXISTS sp_debug_log (
        LogID          BIGINT AUTO_INCREMENT PRIMARY KEY,
        ProcedureName  VARCHAR(100),
        StepName       VARCHAR(255),
        Message        TEXT,
        CompanyID      INT NULL,
        PrvBMonth      CHAR(6) NULL,
        BMonth         CHAR(6) NULL,
        LogTime        TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB;

    /* ================================
       3. LOG START
       ================================ */
    INSERT INTO sp_debug_log
        (ProcedureName, StepName, Message, PrvBMonth, BMonth)
    VALUES
        ('SP_INIT_PERIOD', 'START',
         'Procedure execution started',
         p_PrvBMonth, p_BMonth);

    /* ================================
       4. CURSOR EXECUTION
       ================================ */
    OPEN PD_cursor;

    read_loop: LOOP
        FETCH PD_cursor INTO v_CompanyID;

        IF done = 1 THEN
            LEAVE read_loop;
        END IF;

        INSERT INTO sp_debug_log
            (ProcedureName, StepName, Message, CompanyID)
        VALUES
            ('SP_INIT_PERIOD', 'FETCH',
             'Fetched CompanyID', v_CompanyID);

        CALL SP_CREATE_PERIOD(v_CompanyID, p_PrvBMonth, p_BMonth);

        INSERT INTO sp_debug_log
            (ProcedureName, StepName, Message, CompanyID)
        VALUES
            ('SP_INIT_PERIOD', 'SP_CREATE_PERIOD_DONE',
             'SP_CREATE_PERIOD completed',
             v_CompanyID);
    END LOOP;

    CLOSE PD_cursor;

    INSERT INTO sp_debug_log
        (ProcedureName, StepName, Message)
    VALUES
        ('SP_INIT_PERIOD', 'END',
         'Procedure execution finished');

END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `SP_PROCESS_EBILLS_NEW` (IN `p_BulkInvoiceNo` INT, IN `p_CustomerID` INT, IN `p_BMonth` CHAR(6), IN `p_BillDate` DATETIME)   BEGIN
    -- Variable declarations
    DECLARE v_NewBillNo CHAR(10);
    DECLARE v_CompanyID INT;
    DECLARE v_TotalPayment DECIMAL(19,4) DEFAULT 0;
    DECLARE v_BalBF DECIMAL(19,4);
    DECLARE v_ErrLineNo VARCHAR(20);
    DECLARE v_ErrorCode CHAR(5) DEFAULT '00000';
    DECLARE v_ErrorMsg TEXT;
    
    -- Error handling
    DECLARE CONTINUE HANDLER FOR SQLEXCEPTION 
    BEGIN
        GET DIAGNOSTICS CONDITION 1
        v_ErrorCode = RETURNED_SQLSTATE, v_ErrorMsg = MESSAGE_TEXT;
        
        -- Log error
        INSERT INTO tblUserErrors (ErrID, ErrSeverity, ErrMessage, ErrSource, TransID)
        VALUES (v_ErrorCode, 1, CONCAT(v_ErrorMsg, ' # ', IFNULL(v_ErrLineNo, '')), 'SP_PROCESS_EBILLS_NEW', p_CustomerID);
        
        -- Rollback on error
        IF (SELECT @transaction_rollback = 1) THEN
            ROLLBACK;
        END IF;
    END;
    
    -- Set the new bill number
    SET v_NewBillNo = CONCAT(p_BMonth, LPAD(RIGHT(p_CustomerID, 4), 4, '0'));
    
    -- Get company ID
    SELECT b.CompanyID INTO v_CompanyID 
    FROM BulkInvoice b 
    INNER JOIN MeterReading m ON b.ConsType = m.ConsType
    WHERE b.BulkInvoiceID = p_BulkInvoiceNo 
    AND m.BillingPeriod = p_BMonth 
    AND m.CustomerID = p_CustomerID
    LIMIT 1;
    
    -- Start transaction
    START TRANSACTION;
    
    -- 1. Create the Bill Header
    SET v_ErrLineNo = '00-Bill Header';
    INSERT INTO Bill (
        BillID, BillingPeriod, BulkInvoiceID, CustomerID, BillingDate, 
        MeterReadingID, BillType, CurReading, PrvReading, CurReadingDate, 
        PrvReadingDate, BalanceBF, ConsumptionBilled, DueDate
    )
    SELECT 
        v_NewBillNo, 
        m.BillingPeriod, 
        b.BulkInvoiceID, 
        m.CustomerID, 
        p_BillDate, 
        m.MeterReadingID, 
        m.ConsType, 
        m.Reading, 
        m.PrvReading, 
        m.ReadingDate, 
        m.PrvReadingDate,
        c.AccountBalance, 
        m.Consumption, 
        DATE_ADD(p_BillDate, INTERVAL 7 DAY)
    FROM PROPERTY p 
    INNER JOIN BulkInvoice b ON p.PropID = b.PropID 
    INNER JOIN ProUnits pu ON p.PropID = pu.PropID 
    INNER JOIN MeterReading m ON m.CustomerID = p_CustomerID
    INNER JOIN CUSTOMER c ON pu.UnitID = c.UnitID AND c.CustomerID = p_CustomerID
    WHERE b.BulkInvoiceID = p_BulkInvoiceNo 
    AND m.BillingPeriod = p_BMonth
    AND m.CustomerID = p_CustomerID;
    
    
    -- 1. FIXED CHARGES
    SET v_ErrLineNo = '01-FIXED';
    INSERT INTO BillLine (
        BillID,  BLineID,BLineDesc, BLineUnits, BLineUnitPrice, 
        BLineAmount, BLineCategID, BLineTLineID
    )
    SELECT 
        v_NewBillNo, 
        tl.TLinePriority, 
        tl.TLineName, 
        1, 
        tl.TLinePricePerUnit, 
        tl.TLinePricePerUnit, 
        tl.CategoryID, 
        tl.TLineID
    FROM BulkInvoice bi 
    INNER JOIN BulkInvoiceLine bl ON bi.BulkInvoiceID = bl.BulkInvoiceID 
    INNER JOIN TariffLine tl ON bi.CompanyID = tl.CompanyID 
        AND bl.BulkCategID = tl.CategoryID 
        AND bl.BulkLineID = tl.TLineID 
        AND bi.ConsType = tl.TLineConsType 
    INNER JOIN MeterReading m ON bi.ConsType = m.ConsType 
        AND m.CustomerID = p_CustomerID 
        AND m.BillingPeriod = p_BMonth
    WHERE (tl.TLineBillingMode = 'FX') 
    AND (tl.TLineCalcMethod = 'FIX')   
    AND (tl.TLinePeriodicity = 1)
    AND (bi.BulkInvoiceID = p_BulkInvoiceNo);
    
    -- 3. CONSUMPTION CHARGES (without VAT)
    SET v_ErrLineNo = '03-CONSUMPTIONS - W/O VAT';
    INSERT INTO BillLine (
        BillID,  BLineID,BLineDesc, BLineUnits, BLineUnitPrice, 
        BLineAmount, BLineCategID, BLineTLineID
    )
    SELECT 
        v_NewBillNo,  
        tl.TLinePriority, 
        tl.TLineName, 
        m.Consumption, 
        ROUND(tl.TLinePricePerUnit, 2), 
        ROUND(m.Consumption * tl.TLinePricePerUnit, 2), 
        tl.CategoryID, 
        tl.TLineID
    FROM BulkInvoice bi 
    INNER JOIN BulkInvoiceLine bl ON bi.BulkInvoiceID = bl.BulkInvoiceID 
    INNER JOIN TariffLine tl ON bi.CompanyID = tl.CompanyID 
        AND bl.BulkCategID = tl.CategoryID 
        AND bl.BulkLineID = tl.TLineID 
        AND bi.ConsType = tl.TLineConsType 
    INNER JOIN MeterReading m ON bi.ConsType = m.ConsType
        AND m.CustomerID = p_CustomerID 
        AND m.BillingPeriod = p_BMonth
    WHERE (tl.TLineBillingMode = 'CO') 
    AND (bl.BulkLineAmount <> 0) 
    AND (tl.TLineCalcMethod = 'CON')   
    AND (tl.TLinePeriodicity = 1)
    AND (bi.BulkInvoiceID = p_BulkInvoiceNo);
    
    -- 5. MAX KVA CHARGES (without VAT)
    SET v_ErrLineNo = '05-MAX KVA -W/O VAT';
    INSERT INTO BillLine (
        BillID,  BLineID,BLineDesc, BLineUnits, BLineUnitPrice, 
        BLineAmount, BLineCategID, BLineTLineID
    )
    SELECT 
        v_NewBillNo,  
        tl.TLinePriority, 
        tl.TLineName, 
        m.Consumption, 
        ROUND((bl.BulkLineAmount / NULLIF(bi.Consumption, 0)), 2), 
        ROUND((m.Consumption * bl.BulkLineAmount / NULLIF(bi.Consumption, 0)), 2), 
        tl.CategoryID, 
        tl.TLineID
    FROM BulkInvoice bi 
    INNER JOIN BulkInvoiceLine bl ON bi.BulkInvoiceID = bl.BulkInvoiceID 
    INNER JOIN TariffLine tl ON bi.CompanyID = tl.CompanyID 
        AND bl.BulkCategID = tl.CategoryID 
        AND bl.BulkLineID = tl.TLineID 
        AND bi.ConsType = tl.TLineConsType 
    INNER JOIN MeterReading m ON bi.ConsType = m.ConsType
        AND m.CustomerID = p_CustomerID 
        AND m.BillingPeriod = p_BMonth
    WHERE (tl.TLineBillingMode = 'CO') 
    AND (bl.BulkLineAmount <> 0) 
    AND (tl.TLineCalcMethod = 'MAX')   
    AND (tl.TLinePeriodicity = 1)
    AND (bi.BulkInvoiceID = p_BulkInvoiceNo);
    
    -- 6. ERC + RCN CHARGES
    SET v_ErrLineNo = '06-ERC + RCN';
    INSERT INTO BillLine (
        BillID,  BLineID,BLineDesc, BLineUnits, BLineUnitPrice, 
        BLineAmount, BLineCategID, BLineTLineID
    )
    SELECT 
        v_NewBillNo,  
        tl.TLinePriority, 
        tl.TLineName, 
        m.Consumption, 
        ROUND(tl.TLinePricePerUnit, 2), 
        ROUND(m.Consumption * tl.TLinePricePerUnit, 2), 
        tl.CategoryID, 
        tl.TLineID
    FROM BulkInvoice bi 
    INNER JOIN BulkInvoiceLine bl ON bi.BulkInvoiceID = bl.BulkInvoiceID 
    INNER JOIN TariffLine tl ON bi.CompanyID = tl.CompanyID 
        AND bl.BulkCategID = tl.CategoryID 
        AND bl.BulkLineID = tl.TLineID 
        AND bi.ConsType = tl.TLineConsType 
    INNER JOIN MeterReading m ON bi.ConsType = m.ConsType
        AND m.CustomerID = p_CustomerID 
        AND m.BillingPeriod = p_BMonth
    WHERE (tl.TLineBillingMode = 'CO') 
    AND (bl.BulkLineAmount <> 0) 
    AND (tl.TLineCalcMethod = 'RCN')   
    AND (tl.TLinePeriodicity = 1)
    AND (bi.BulkInvoiceID = p_BulkInvoiceNo);
    
    -- 7. REP + RVL CHARGES
    SET v_ErrLineNo = '07-REP + RVL';
    INSERT INTO BillLine (
        BillID,  BLineID,BLineDesc, BLineUnits, BLineUnitPrice, 
        BLineAmount, BLineCategID, BLineTLineID
    )
    SELECT 
        v_NewBillNo,  
        tl.TLinePriority, 
        tl.TLineName,  
        ROUND(IFNULL((
            SELECT BLineAmount 
            FROM BillLine b 
            WHERE b.BLineTLineID = 'L02' 
            AND b.BillID = v_NewBillNo
            LIMIT 1
        ), 0), 2) AS tUnits,
        ROUND(tl.TLinePricePerUnit, 2), 
        ROUND(IFNULL((
            SELECT BLineAmount 
            FROM BillLine b 
            WHERE b.BLineTLineID = 'L02' 
            AND b.BillID = v_NewBillNo
            LIMIT 1
        ), 0) * tl.TLinePricePerUnit, 2) AS tPrice,				 
        tl.CategoryID, 
        tl.TLineID
    FROM BulkInvoice bi 
    INNER JOIN BulkInvoiceLine bl ON bi.BulkInvoiceID = bl.BulkInvoiceID 
    INNER JOIN TariffLine tl ON bi.CompanyID = tl.CompanyID 
        AND bl.BulkCategID = tl.CategoryID 
        AND bl.BulkLineID = tl.TLineID 
        AND bi.ConsType = tl.TLineConsType 
    INNER JOIN MeterReading m ON bi.ConsType = m.ConsType
        AND m.CustomerID = p_CustomerID 
        AND m.BillingPeriod = p_BMonth
    WHERE (tl.TLineBillingMode = 'CO') 
    AND (bl.BulkLineAmount <> 0) 
    AND (tl.TLineCalcMethod = 'RVL')    
    AND (tl.TLinePeriodicity = 1)
    AND (bi.BulkInvoiceID = p_BulkInvoiceNo);
    
    -- 8. VAT
    SET v_ErrLineNo = '08-VAT';
    INSERT INTO BillLine (
        BillID,  BLineID,BLineDesc, BLineUnits, BLineUnitPrice, 
        BLineAmount, BLineCategID, BLineTLineID
    )
    SELECT     
        v_NewBillNo, 
        tl.TLinePriority, 
        bl.BulkLineDesc, 
        ROUND(IFNULL((
            SELECT SUM(b.BLineAmount)
            FROM BillLine b 
            INNER JOIN TariffLine tl ON b.BLineCategID = tl.CategoryID 
                AND b.BLineTLineID = tl.TLineID
            WHERE (tl.TLineTaxID = 1) 
            AND (tl.CompanyID = v_CompanyID) 
            AND (b.BillID = v_NewBillNo)
        ), 0), 2) AS tUnits, 
        tl.TLinePricePerUnit, 
        ROUND(tl.TLinePricePerUnit * IFNULL((
            SELECT SUM(b.BLineAmount)
            FROM BillLine b 
            INNER JOIN TariffLine tl ON b.BLineCategID = tl.CategoryID 
                AND b.BLineTLineID = tl.TLineID
            WHERE (tl.TLineTaxID = 1) 
            AND (tl.CompanyID = v_CompanyID) 
            AND (b.BillID = v_NewBillNo)
        ), 0), 2) AS tPrice, 
        tl.CategoryID, 
        tl.TLineID
    FROM BulkInvoice bi 
    INNER JOIN BulkInvoiceLine bl ON bi.BulkInvoiceID = bl.BulkInvoiceID 
    INNER JOIN TariffLine tl ON bi.CompanyID = tl.CompanyID 
        AND bl.BulkCategID = tl.CategoryID 
        AND bl.BulkLineID = tl.TLineID 
        AND bi.ConsType = tl.TLineConsType 
    INNER JOIN MeterReading m ON bi.ConsType = m.ConsType
        AND m.CustomerID = p_CustomerID 
        AND m.BillingPeriod = p_BMonth
    WHERE (tl.TLineBillingMode = 'TX') 
    AND (tl.TLineCalcMethod = 'RRT')
    AND (bi.BulkInvoiceID = p_BulkInvoiceNo);
    
    -- Update Bill with payment information
    -- Get payments
    SELECT IFNULL(SUM(TotalPayment), 0) INTO v_TotalPayment 
    FROM Payment  
    WHERE CustomerID = p_CustomerID 
    AND Processed = 'N';
    
    -- Update Bill with total payments
    UPDATE Bill  
    SET TotalPayments = v_TotalPayment  
    WHERE BillID = v_NewBillNo;
    
    -- Get balance brought forward
    SELECT BalanceBF INTO v_BalBF 
    FROM Bill 
    WHERE BillID = v_NewBillNo;
    
    -- Update total bill amount
    UPDATE Bill  
    SET TotalBill = (
        SELECT IFNULL(SUM(BlineAmount), 0) 
        FROM BillLine 
        WHERE BillID = v_NewBillNo
    )  
    WHERE BillID = v_NewBillNo;
    
    -- Calculate and update balance carried forward
    IF v_TotalPayment < 0 THEN
        IF v_BalBF < 0 THEN
            UPDATE Bill  
            SET BalanceCF = v_BalBF - v_TotalPayment + TotalBill
            WHERE BillID = v_NewBillNo;
        ELSE
            UPDATE Bill  
            SET BalanceCF = ABS(v_TotalPayment) + TotalBill + v_BalBF
            WHERE BillID = v_NewBillNo;
        END IF;
    ELSE
        UPDATE Bill  
        SET BalanceCF = TotalBill + v_BalBF - v_TotalPayment
        WHERE BillID = v_NewBillNo;
    END IF;
    
    -- Commit the transaction
    COMMIT;
    
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `SP_PROCESS_RENT_AND_SERVICES_BILL` (IN `p_CompanyID` INT, IN `p_BillingPeriod` CHAR(6), IN `p_User` VARCHAR(50))   BEGIN
    DECLARE v_done INT DEFAULT 0;

    DECLARE v_CustomerID INT;
    DECLARE v_UnitID INT;
    DECLARE v_Rent DECIMAL(12,2);
    DECLARE v_RentMonths INT DEFAULT 1;

    DECLARE v_BillID CHAR(11);
    DECLARE v_PreviousBalance DECIMAL(12,2);
    DECLARE v_CurrentCharges DECIMAL(12,2);
    DECLARE v_ServiceTotal DECIMAL(12,2);
    DECLARE v_TotalPayable DECIMAL(12,2);

    DECLARE v_customer_count INT DEFAULT 0;
    DECLARE v_processed_count INT DEFAULT 0;

    -- =========================
    -- START DEBUG
    -- =========================
    INSERT INTO debug_log (message, created_at)
    VALUES (CONCAT('Starting bill generation | Company=', p_CompanyID,
                   ' Period=', p_BillingPeriod), NOW());

    SELECT COUNT(*)
    INTO v_customer_count
    FROM customer c
    JOIN prounits u ON u.UnitID = c.UnitID
    WHERE c.AccountStatus = 'A'
      AND u.UnitActive = 1
      AND c.CompanyID = p_CompanyID;

    INSERT INTO debug_log (message, created_at)
    VALUES (CONCAT('Found ', v_customer_count, ' active customers'), NOW());

    START TRANSACTION;

    -- =========================
    -- CURSOR LOOP
    -- =========================
    BEGIN
        DECLARE curCustomer CURSOR FOR
            SELECT c.CustomerID, c.UnitID, u.MonthlyRent
            FROM customer c
            JOIN prounits u ON u.UnitID = c.UnitID
            WHERE c.AccountStatus = 'A'
              AND u.UnitActive = 1
              AND c.CompanyID = p_CompanyID;

        DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = 1;

        OPEN curCustomer;

        read_loop: LOOP
            FETCH curCustomer INTO v_CustomerID, v_UnitID, v_Rent;
            IF v_done = 1 THEN
                LEAVE read_loop;
            END IF;

            -- RESET VALUES
            SET v_PreviousBalance = 0;
            SET v_CurrentCharges = 0;
            SET v_ServiceTotal = 0;
            SET v_TotalPayable = 0;

            SET v_BillID = CONCAT(p_BillingPeriod, LPAD(v_CustomerID, 5, '0'));

            INSERT INTO debug_log VALUES
            (NULL, CONCAT('Processing customer ', v_CustomerID), NOW());

            -- Skip existing bills
            IF EXISTS (SELECT 1 FROM rentservicebill WHERE BillID = v_BillID) THEN
                ITERATE read_loop;
            END IF;

            -- =========================
            -- PREVIOUS BALANCE
            -- =========================
            SELECT IFNULL((SELECT TotalPayable
                           FROM rentservicebill
                           WHERE CustomerID = v_CustomerID
                             AND CompanyID = p_CompanyID
                             AND BillingPeriod < p_BillingPeriod
                           ORDER BY BillingPeriod DESC
                           LIMIT 1), 0)
            INTO v_PreviousBalance;

            -- =========================
            -- RENT CHARGES
            -- =========================
            SELECT IFNULL((SELECT NoMonthPerYear
                           FROM propservice
                           WHERE ServiceName = 'Monthly Rent'
                             AND CompanyID = p_CompanyID
                           LIMIT 1), 1)
            INTO v_RentMonths;

            SET v_CurrentCharges = v_Rent * v_RentMonths;

            -- =========================
            -- SERVICE CHARGES
            -- =========================
            SELECT IFNULL((SELECT SUM(
                                COALESCE(cps.Price, ps.Price)
                                * cps.Quantity
                                * ps.NoMonthPerYear)
                           FROM customer_prop_service cps
                           JOIN propservice ps
                               ON ps.IDService = cps.IDService
                              AND ps.CompanyID = p_CompanyID
                           WHERE cps.CustomerID = v_CustomerID
                             AND cps.IsActive = 1
                             AND ps.IDService <> 1
                             AND (cps.EndDate IS NULL OR cps.EndDate >= CURDATE())
                           ), 0)
            INTO v_ServiceTotal;

            SET v_CurrentCharges = v_CurrentCharges + v_ServiceTotal;
            SET v_TotalPayable = v_PreviousBalance + v_CurrentCharges;

            -- =========================
            -- INSERT BILL HEADER
            -- =========================
            INSERT INTO rentservicebill (
                BillID, CompanyID, CustomerID, UnitID,
                BillingPeriod, BillingDate,
                PreviousBalance, CurrentCharges,
                TotalPayable, BillStatus, CreatedBy
            )
            VALUES (
                v_BillID, p_CompanyID, v_CustomerID, v_UnitID,
                p_BillingPeriod, CURDATE(),
                v_PreviousBalance, v_CurrentCharges,
                v_TotalPayable, 'OPEN', p_User
            );

            -- =========================
            -- INSERT BILL LINES
            -- =========================

            -- RENT LINE
            INSERT INTO rentservicebillline (
                BillID, LineType, ItemID, ItemName,
                Units, UnitPrice, LineAmount, CreatedAt
            )
            VALUES (
                v_BillID, 'RENT', 1, 'Monthly Rent',
                v_RentMonths, v_Rent, v_Rent * v_RentMonths, NOW()
            );

            -- SERVICE LINES
            INSERT INTO rentservicebillline (
                BillID, LineType, ItemID, ItemName,
                Units, UnitPrice, LineAmount, CreatedAt
            )
            SELECT
                v_BillID,
                'SERVICE',
                ps.IDService,
                ps.ServiceName,
                cps.Quantity * ps.NoMonthPerYear,
                COALESCE(cps.Price, ps.Price),
                COALESCE(cps.Price, ps.Price) * cps.Quantity * ps.NoMonthPerYear,
                NOW()
            FROM customer_prop_service cps
            JOIN propservice ps
                ON ps.IDService = cps.IDService
               AND ps.CompanyID = p_CompanyID
            WHERE cps.CustomerID = v_CustomerID
              AND cps.IsActive = 1
              AND ps.IDService <> 1
              AND (cps.EndDate IS NULL OR cps.EndDate >= CURDATE());

            SET v_processed_count = v_processed_count + 1;

        END LOOP;

        CLOSE curCustomer;
    END;

    COMMIT;

    INSERT INTO debug_log (message, created_at)
    VALUES (
        CONCAT('Completed billing: ', v_processed_count, ' of ', v_customer_count, ' customers'),
        NOW()
    );

    SELECT CONCAT('Successfully processed ', v_processed_count, ' of ', v_customer_count, ' customers') AS result;

END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `SP_UPDATE_E_BALANCES` (IN `p_BulkInvoiceNo` INT, IN `p_BMonth` CHAR(6))   BEGIN
    -- Updates Customer Balances after Billing
    DECLARE v_done INT DEFAULT FALSE;
    DECLARE v_CustomerID INT;
    DECLARE v_Balance DECIMAL(19,4);
    DECLARE v_BillNo INT;
    
    -- Cursor declaration
    DECLARE MTR_cursor CURSOR FOR
        SELECT CustomerID, BalanceCF, BillID 
        FROM Bill
        WHERE BillingPeriod = p_BMonth 
          AND BulkInvoiceID = p_BulkInvoiceNo 
          AND BillQuality = 'E';
    
    -- Declare continue handler for when no more rows
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;
    
    -- Open cursor
    OPEN MTR_cursor;
    
    -- Start processing
    read_loop: LOOP
        -- Get next record
        FETCH MTR_cursor INTO v_CustomerID, v_Balance, v_BillNo;
        
        -- Exit if no more rows
        IF v_done THEN
            LEAVE read_loop;
        END IF;
        
        -- Update Balances
        UPDATE CUSTOMER 
        SET AccountBalance = v_Balance 
        WHERE CustomerID = v_CustomerID;
        
        -- Update Bill status
        UPDATE Bill     
        SET BillQuality = 'N' 
        WHERE BillID = v_BillNo;
        
        -- Mark payments as processed
        UPDATE Payment  
        SET Processed = 'Y' 
        WHERE CustomerID = v_CustomerID 
          AND Processed = 'N';
        
    END LOOP;
    
    -- Clean up
    CLOSE MTR_cursor;
    
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `SP_UPDATE_E_READINGS` (IN `p_CompanyID` INT, IN `p_BMonth` CHAR(6))   BEGIN
            -- Variable declarations
            DECLARE v_Reading INT;
            DECLARE v_ReadingDate DATE;
            DECLARE v_Consumption INT;
            DECLARE v_BaseOfBilling CHAR(1);
            DECLARE v_PrvReading INT;
            DECLARE v_PrvReadingDate DATE;
            DECLARE v_MeterReadingID INT;
            DECLARE v_done INT DEFAULT FALSE;
            
            -- Debug table
            DROP TABLE IF EXISTS SP_UPDATE_E_READINGS_log;
            CREATE TABLE SP_UPDATE_E_READINGS_log (
                log_id INT AUTO_INCREMENT PRIMARY KEY,
                log_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                message TEXT
            );
            
            -- Clear old logs for this run
            DELETE FROM SP_UPDATE_E_READINGS_log;
            
            -- Log start
            INSERT INTO SP_UPDATE_E_READINGS_log (message)
            VALUES (CONCAT('Starting SP_UPDATE_E_READINGS for CompanyID: ', p_CompanyID, 
                          ', BMonth: ', p_BMonth));
            
            -- Cursor for processing meter readings
            BEGIN
                DECLARE mtr_cursor CURSOR FOR
                    SELECT 
                        tm.Reading, 
                        tm.ReadingDate, 
                        tm.Consumption, 
                        tm.BaseOfBilling, 
                        tm.PrvReading, 
                        tm.PrvReadingDate, 
                        m.MeterReadingID
                    FROM tmp_meterreading tm 
                    INNER JOIN MeterReading m 
                        ON tm.BillingPeriod = m.BillingPeriod 
                        AND tm.ConsType = m.ConsType 
                        AND tm.CustomerID = m.CustomerID
                    WHERE (tm.CompanyID = p_CompanyID) 
                      AND (tm.BillingPeriod = p_BMonth);
                
                -- Handler for when no more rows
                DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;
                
                -- Open cursor and start processing
                OPEN mtr_cursor;
                
                read_loop: LOOP
                    -- Fetch next record
                    FETCH mtr_cursor INTO 
                        v_Reading, 
                        v_ReadingDate, 
                        v_Consumption, 
                        v_BaseOfBilling, 
                        v_PrvReading, 
                        v_PrvReadingDate, 
                        v_MeterReadingID;
                    
                    -- Exit if no more rows
                    IF v_done THEN
                        LEAVE read_loop;
                    END IF;
                    
                    -- Log processing
                    INSERT INTO SP_UPDATE_E_READINGS_log (message)
                    VALUES (CONCAT('Updating MeterReadingID: ', v_MeterReadingID, 
                                  ', New Reading: ', IFNULL(v_Reading, 'NULL')));
                    
                    -- Update meter reading
                    UPDATE MeterReading 
                    SET 
                        Reading = v_Reading, 
                        ReadingDate = v_ReadingDate, 
                        Consumption = v_Consumption, 
                        BaseOfBilling = v_BaseOfBilling, 
                        PrvReading = v_PrvReading, 
                        PrvReadingDate = v_PrvReadingDate
                    WHERE MeterReadingID = v_MeterReadingID;
                    
                END LOOP;
                
                -- Clean up
                CLOSE mtr_cursor;
            END;
            
            -- Log completion
            INSERT INTO SP_UPDATE_E_READINGS_log (message)
            VALUES ('SP_UPDATE_E_READINGS completed successfully');
            
            -- Return log
            SELECT * FROM SP_UPDATE_E_READINGS_log ORDER BY log_id;
            
        END$$

--
-- Functions
--
CREATE DEFINER=`root`@`localhost` FUNCTION `fn_BillingMonthEx` (`BillingPeriod` INT) RETURNS VARCHAR(20) CHARSET utf8mb4 COLLATE utf8mb4_general_ci DETERMINISTIC BEGIN
    DECLARE period_str VARCHAR(6);
    DECLARE year_part INT;
    DECLARE month_part INT;
    
    SET period_str = CAST(BillingPeriod AS CHAR(6));
    SET year_part = SUBSTRING(period_str, 1, 4);
    SET month_part = SUBSTRING(period_str, 5, 2);
    
    RETURN CONCAT(
        CASE month_part
            WHEN 1 THEN 'January'
            WHEN 2 THEN 'February'
            WHEN 3 THEN 'March'
            WHEN 4 THEN 'April'
            WHEN 5 THEN 'May'
            WHEN 6 THEN 'June'
            WHEN 7 THEN 'July'
            WHEN 8 THEN 'August'
            WHEN 9 THEN 'September'
            WHEN 10 THEN 'October'
            WHEN 11 THEN 'November'
            WHEN 12 THEN 'December'
        END,
        ' ',
        year_part
    );
END$$

CREATE DEFINER=`root`@`localhost` FUNCTION `fn_BillingMonthEx2` (`BPeriod` CHAR(6)) RETURNS VARCHAR(20) CHARSET utf8mb4 COLLATE utf8mb4_general_ci DETERMINISTIC BEGIN
    /* 
       Returns billing month in format:
       Jan.2011
       Special cases handled explicitly
    */

    DECLARE tmp_Period VARCHAR(20);
    DECLARE tmp_Period2 VARCHAR(20);

    -- Get full billing month text
    SET tmp_Period = fn_BillingMonthEx(BPeriod);

    -- Special cases
    IF BPeriod = '201407' THEN
        SET tmp_Period2 = 'Apr-Jul.14';
    ELSEIF BPeriod = '201506' THEN
        SET tmp_Period2 = 'Jan-Jun 2015';
    ELSE
        SET tmp_Period2 = CONCAT(LEFT(tmp_Period, 3), '.', RIGHT(tmp_Period, 5));
    END IF;

    RETURN tmp_Period2;
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `bill`
--

CREATE TABLE `bill` (
  `BillID` int(10) UNSIGNED NOT NULL,
  `BillingPeriod` int(11) NOT NULL,
  `BulkInvoiceID` int(10) UNSIGNED DEFAULT NULL,
  `CustomerID` int(10) UNSIGNED NOT NULL,
  `BillingDate` date NOT NULL,
  `MeterReadingID` int(10) UNSIGNED DEFAULT NULL,
  `BillType` varchar(6) NOT NULL,
  `CurReading` int(11) DEFAULT NULL,
  `PrvReading` int(11) DEFAULT NULL,
  `CurReadingDate` date DEFAULT NULL,
  `PrvReadingDate` date DEFAULT NULL,
  `DueDate` date DEFAULT NULL,
  `ConsumptionBilled` int(11) NOT NULL DEFAULT 0,
  `BalanceBF` decimal(19,4) NOT NULL DEFAULT 0.0000,
  `TotalPayments` decimal(19,4) NOT NULL DEFAULT 0.0000,
  `TotalBill` decimal(19,4) NOT NULL DEFAULT 0.0000,
  `BalanceCF` decimal(19,4) NOT NULL DEFAULT 0.0000,
  `LastUpdateDate` datetime NOT NULL DEFAULT current_timestamp(),
  `LastUpdateUser` varchar(10) NOT NULL DEFAULT current_user(),
  `BillQuality` char(1) NOT NULL DEFAULT 'E'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `bill`
--

INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2014070001, 201407, 1, 1, '2015-02-01', 1, 'ENERGY', 70, 39, '2014-07-20', '2014-04-25', '2015-02-08', 31, 0.0000, 0.0000, 1640.3400, 1640.3400, '2015-02-06 07:34:50', 'dbo', ''),
(2014070002, 201407, 1, 2, '2015-02-01', 2, 'ENERGY', 124, 58, '2014-07-20', '2014-04-25', '2015-02-08', 66, 0.0000, 0.0000, 3164.9300, 3164.9300, '2015-02-06 07:34:50', 'dbo', ''),
(2014070003, 201407, 1, 3, '2015-02-01', 3, 'ENERGY', 50, 41, '2014-07-20', '2014-04-25', '2015-02-08', 9, 0.0000, 0.0000, 682.0300, 682.0300, '2015-02-06 07:34:50', 'dbo', ''),
(2014070004, 201407, 1, 4, '2015-02-01', 4, 'ENERGY', 72, 68, '2014-07-20', '2014-04-25', '2015-02-08', 4, 0.0000, 0.0000, 464.2400, 464.2400, '2015-02-06 07:34:50', 'dbo', ''),
(2014070005, 201407, 1, 5, '2015-02-01', 5, 'ENERGY', 50, 44, '2014-07-20', '2014-04-25', '2015-02-08', 6, 0.0000, 0.0000, 551.3600, 551.3600, '2015-02-06 07:34:50', 'dbo', ''),
(2014070006, 201407, 1, 6, '2015-02-01', 6, 'ENERGY', 44, 40, '2014-07-20', '2014-04-25', '2015-02-08', 4, 0.0000, 0.0000, 464.2400, 464.2400, '2015-02-06 07:34:50', 'dbo', ''),
(2014070007, 201407, 1, 7, '2015-02-01', 7, 'ENERGY', 52, 32, '2014-07-20', '2014-04-25', '2015-02-08', 20, 0.0000, 0.0000, 1161.1900, 1161.1900, '2015-02-06 07:34:50', 'dbo', ''),
(2014070008, 201407, 1, 8, '2015-02-01', 8, 'ENERGY', 49, 46, '2014-07-20', '2014-04-25', '2015-02-08', 3, 0.0000, 0.0000, 420.6800, 420.6800, '2015-02-06 07:34:50', 'dbo', ''),
(2014070009, 201407, 1, 9, '2015-02-01', 9, 'ENERGY', 37, 34, '2014-07-20', '2014-04-25', '2015-02-08', 3, 0.0000, 0.0000, 420.6800, 420.6800, '2015-02-06 07:34:50', 'dbo', ''),
(2014070010, 201407, 1, 10, '2015-02-01', 10, 'ENERGY', 30, 27, '2014-07-20', '2014-04-25', '2015-02-08', 3, 0.0000, 0.0000, 420.6800, 420.6800, '2015-02-06 07:34:50', 'dbo', ''),
(2014070011, 201407, 1, 11, '2015-02-01', 11, 'ENERGY', 70, 34, '2014-07-20', '2014-04-25', '2015-02-08', 36, 0.0000, 0.0000, 1858.1400, 1858.1400, '2015-02-06 07:34:50', 'dbo', ''),
(2014070012, 201407, 1, 12, '2015-02-01', 12, 'ENERGY', 33, 31, '2014-07-20', '2014-04-25', '2015-02-08', 2, 0.0000, 0.0000, 377.1100, 377.1100, '2015-02-06 07:34:50', 'dbo', ''),
(2014070013, 201407, 1, 13, '2015-02-01', 13, 'ENERGY', 73, 36, '2014-07-20', '2014-04-25', '2015-02-08', 37, 0.0000, 0.0000, 1901.7000, 1901.7000, '2015-02-06 07:34:50', 'dbo', ''),
(2014070014, 201407, 1, 14, '2015-02-01', 14, 'ENERGY', 63, 41, '2014-07-20', '2014-04-25', '2015-02-08', 22, 0.0000, 0.0000, 1248.3100, 1248.3100, '2015-02-06 07:34:50', 'dbo', ''),
(2014070015, 201407, 1, 15, '2015-02-01', 15, 'ENERGY', 68, 46, '2014-07-20', '2014-04-25', '2015-02-08', 22, 0.0000, 0.0000, 1248.3100, 1248.3100, '2015-02-06 07:34:50', 'dbo', ''),
(2014070016, 201407, 1, 16, '2015-02-01', 16, 'ENERGY', 43, 42, '2014-07-20', '2014-04-25', '2015-02-08', 1, 0.0000, 0.0000, 333.5600, 333.5600, '2015-02-06 07:34:50', 'dbo', ''),
(2014070017, 201407, 1, 17, '2015-02-01', 17, 'ENERGY', 25, 19, '2014-07-20', '2014-04-25', '2015-02-08', 6, 0.0000, 0.0000, 551.3600, 551.3600, '2015-02-06 07:34:50', 'dbo', ''),
(2014070018, 201407, 1, 18, '2015-02-01', 18, 'ENERGY', 44, 34, '2014-07-20', '2014-04-25', '2015-02-08', 10, 0.0000, 0.0000, 725.6000, 725.6000, '2015-02-06 07:34:50', 'dbo', ''),
(2014070019, 201407, 1, 19, '2015-02-01', 19, 'ENERGY', 33, 21, '2014-07-20', '2014-04-25', '2015-02-08', 12, 0.0000, 0.0000, 812.7100, 812.7100, '2015-02-06 07:34:50', 'dbo', ''),
(2014070020, 201407, 1, 20, '2015-02-01', 20, 'ENERGY', 61, 34, '2014-07-20', '2014-04-25', '2015-02-08', 27, 0.0000, 0.0000, 1466.1000, 1466.1000, '2015-02-06 07:34:50', 'dbo', ''),
(2014070021, 201407, 1, 21, '2015-02-01', 21, 'ENERGY', 5944, 1135, '2014-07-20', '2014-04-25', '2015-02-08', 4809, 0.0000, 0.0000, 209767.1900, 209767.1900, '2015-02-06 07:34:50', 'dbo', ''),
(2014070022, 201407, 1, 22, '2015-02-01', 22, 'ENERGY', 3551, 827, '2014-07-20', '2014-04-25', '2015-02-08', 2724, 0.0000, 0.0000, 118945.8200, 118945.8200, '2015-02-06 07:34:50', 'dbo', ''),
(2014070023, 201407, 1, 23, '2015-02-01', 23, 'ENERGY', 7610, 816, '2014-07-20', '2014-04-25', '2015-02-08', 6794, 0.0000, 0.0000, 296232.6200, 296232.6200, '2015-02-06 07:34:50', 'dbo', ''),
(2014070024, 201407, 1, 24, '2015-02-01', 24, 'ENERGY', 6704, 630, '2014-07-20', '2014-04-25', '2015-02-08', 6074, 0.0000, 0.0000, 264869.8400, 264869.8400, '2015-02-06 07:34:50', 'dbo', ''),
(2014070025, 201407, 1, 25, '2015-02-01', 25, 'ENERGY', 36, 32, '2014-07-20', '2014-04-25', '2015-02-08', 4, 0.0000, 0.0000, 464.2400, 464.2400, '2015-02-06 07:34:50', 'dbo', ''),
(2014070026, 201407, 1, 26, '2015-02-01', 26, 'ENERGY', 47, 40, '2014-07-20', '2014-04-25', '2015-02-08', 7, 0.0000, 0.0000, 594.9100, 594.9100, '2015-02-06 07:34:50', 'dbo', ''),
(2014070029, 201407, 1, 29, '2015-02-01', 29, 'ENERGY', 9942, 1423, '2014-07-20', '2014-04-25', '2015-02-08', 8519, 0.0000, 0.0000, 371372.6000, 371372.6000, '2015-02-06 07:34:50', 'dbo', ''),
(2014070030, 201407, 1, 30, '2015-02-01', 30, 'ENERGY', 4052, 834, '2014-07-20', '2014-04-25', '2015-02-08', 3218, 0.0000, 0.0000, 140464.1800, 140464.1800, '2015-02-06 07:34:50', 'dbo', ''),
(2014070031, 201407, 1, 31, '2015-02-01', 31, 'ENERGY', 65, 49, '2014-07-20', '2014-04-25', '2015-02-08', 16, 0.0000, 0.0000, 986.9600, 986.9600, '2015-02-06 07:34:50', 'dbo', ''),
(2014070032, 201407, 1, 32, '2015-02-01', 32, 'ENERGY', 36, 33, '2014-07-20', '2014-04-25', '2015-02-08', 3, 0.0000, 0.0000, 420.6800, 420.6800, '2015-02-06 07:34:50', 'dbo', ''),
(2014070033, 201407, 1, 33, '2015-02-01', 33, 'ENERGY', 35, 13, '2014-07-20', '2014-04-25', '2015-02-08', 22, 0.0000, 0.0000, 1248.3100, 1248.3100, '2015-02-06 07:34:50', 'dbo', ''),
(2014070034, 201407, 1, 34, '2015-02-01', 34, 'ENERGY', 18, 11, '2014-07-20', '2014-04-25', '2015-02-08', 7, 0.0000, 0.0000, 594.9100, 594.9100, '2015-02-06 07:34:50', 'dbo', ''),
(2014070035, 201407, 1, 35, '2015-02-01', 35, 'ENERGY', 223, 82, '2014-07-20', '2014-04-25', '2015-02-08', 141, 0.0000, 0.0000, 6431.8800, 6431.8800, '2015-02-06 07:34:50', 'dbo', ''),
(2014070036, 201407, 1, 36, '2015-02-01', 36, 'ENERGY', 57, 39, '2014-07-20', '2014-04-25', '2015-02-08', 18, 0.0000, 0.0000, 1074.0700, 1074.0700, '2015-02-06 07:34:50', 'dbo', ''),
(2014070037, 201407, 1, 37, '2015-02-01', 37, 'ENERGY', 69, 32, '2014-07-20', '2014-04-25', '2015-02-08', 37, 0.0000, 0.0000, 1901.7000, 1901.7000, '2015-02-06 07:34:50', 'dbo', ''),
(2014070038, 201407, 1, 38, '2015-02-01', 38, 'ENERGY', 31, 14, '2014-07-20', '2014-04-25', '2015-02-08', 17, 0.0000, 0.0000, 1030.5100, 1030.5100, '2015-02-06 07:34:51', 'dbo', ''),
(2014070039, 201407, 1, 39, '2015-02-01', 39, 'ENERGY', 40, 36, '2014-07-20', '2014-04-25', '2015-02-08', 4, 0.0000, 0.0000, 464.2400, 464.2400, '2015-02-06 07:34:51', 'dbo', ''),
(2014070040, 201407, 1, 40, '2015-02-01', 40, 'ENERGY', 52, 39, '2014-07-20', '2014-04-25', '2015-02-08', 13, 0.0000, 0.0000, 856.2700, 856.2700, '2015-02-06 07:34:51', 'dbo', ''),
(2014070041, 201407, 1, 41, '2015-02-01', 41, 'ENERGY', 20, 12, '2014-07-20', '2014-04-25', '2015-02-08', 8, 0.0000, 0.0000, 638.4700, 638.4700, '2015-02-06 07:34:50', 'dbo', ''),
(2014070042, 201407, 1, 42, '2015-02-01', 42, 'ENERGY', 40, 30, '2014-07-20', '2014-04-25', '2015-02-08', 10, 0.0000, 0.0000, 725.6000, 725.6000, '2015-02-06 07:34:50', 'dbo', ''),
(2014070043, 201407, 1, 43, '2015-02-01', 43, 'ENERGY', 117, 30, '2014-07-20', '2014-04-25', '2015-02-08', 87, 0.0000, 0.0000, 4079.6600, 4079.6600, '2015-02-06 07:34:50', 'dbo', ''),
(2014070044, 201407, 1, 44, '2015-02-01', 44, 'ENERGY', 36, 16, '2014-07-20', '2014-04-25', '2015-02-08', 20, 0.0000, 0.0000, 1161.1900, 1161.1900, '2015-02-06 07:34:50', 'dbo', ''),
(2014070045, 201407, 1, 45, '2015-02-01', 45, 'ENERGY', 1832, 54, '2014-07-20', '2014-04-25', '2015-02-08', 1778, 0.0000, 0.0000, 77738.6300, 77738.6300, '2015-02-06 07:34:50', 'dbo', ''),
(2014070046, 201407, 1, 46, '2015-02-01', 46, 'ENERGY', 2085, 30, '2014-07-20', '2014-04-25', '2015-02-08', 2055, 0.0000, 0.0000, 89804.5900, 89804.5900, '2015-02-06 07:34:50', 'dbo', ''),
(2014070047, 201407, 1, 47, '2015-02-01', 47, 'ENERGY', 2187, 333, '2014-07-20', '2014-04-25', '2015-02-08', 1854, 0.0000, 0.0000, 81049.1400, 81049.1400, '2015-02-06 07:34:50', 'dbo', ''),
(2014070048, 201407, 1, 48, '2015-02-01', 48, 'ENERGY', 43, 37, '2014-07-20', '2014-04-25', '2015-02-08', 6, 0.0000, 0.0000, 551.3600, 551.3600, '2015-02-06 07:34:50', 'dbo', ''),
(2014070049, 201407, 1, 49, '2015-02-01', 49, 'ENERGY', 35, 35, '2014-07-20', '2014-04-25', '2015-02-08', 0, 0.0000, 0.0000, 290.0000, 290.0000, '2015-02-06 07:34:50', 'dbo', ''),
(2014070050, 201407, 1, 50, '2015-02-01', 50, 'ENERGY', 38, 32, '2014-07-20', '2014-04-25', '2015-02-08', 6, 0.0000, 0.0000, 551.3600, 551.3600, '2015-02-06 07:34:50', 'dbo', ''),
(2014070051, 201407, 1, 51, '2015-02-01', 51, 'ENERGY', 138, 39, '2014-07-20', '2014-04-25', '2015-02-08', 99, 0.0000, 0.0000, 4602.3800, 4602.3800, '2015-02-06 07:34:50', 'dbo', ''),
(2014070052, 201407, 1, 52, '2015-02-01', 52, 'ENERGY', 64, 63, '2014-07-20', '2014-04-25', '2015-02-08', 1, 0.0000, 0.0000, 333.5600, 333.5600, '2015-02-06 07:34:50', 'dbo', ''),
(2014070053, 201407, 1, 53, '2015-02-01', 53, 'ENERGY', 34, 21, '2014-07-20', '2014-04-25', '2015-02-08', 13, 0.0000, 0.0000, 856.2700, 856.2700, '2015-02-06 07:34:51', 'dbo', ''),
(2014070054, 201407, 1, 54, '2015-02-01', 54, 'ENERGY', 181, 59, '2014-07-20', '2014-04-25', '2015-02-08', 122, 0.0000, 0.0000, 5604.2500, 5604.2500, '2015-02-06 07:34:51', 'dbo', ''),
(2014070055, 201407, 1, 55, '2015-02-01', 55, 'ENERGY', 56, 44, '2014-07-20', '2014-04-25', '2015-02-08', 12, 0.0000, 0.0000, 812.7100, 812.7100, '2015-02-06 07:34:51', 'dbo', ''),
(2014070056, 201407, 1, 56, '2015-02-01', 56, 'ENERGY', 39, 35, '2014-07-20', '2014-04-25', '2015-02-08', 4, 0.0000, 0.0000, 464.2400, 464.2400, '2015-02-06 07:34:51', 'dbo', ''),
(2014070059, 201407, 1, 59, '2015-02-01', 59, 'ENERGY', 1, 1, '2014-07-20', '2014-04-25', '2015-02-08', 0, 0.0000, 0.0000, 290.0000, 290.0000, '2015-02-06 07:34:50', 'dbo', ''),
(2014070060, 201407, 1, 60, '2015-02-01', 60, 'ENERGY', 2, 2, '2014-07-20', '2014-04-25', '2015-02-08', 0, 0.0000, 0.0000, 290.0000, 290.0000, '2015-02-06 07:34:50', 'dbo', ''),
(2014070061, 201407, 1, 61, '2015-02-01', 61, 'ENERGY', 3, 3, '2014-07-20', '2014-04-25', '2015-02-08', 0, 0.0000, 0.0000, 290.0000, 290.0000, '2015-02-06 07:34:50', 'dbo', ''),
(2014070062, 201407, 1, 62, '2015-02-01', 62, 'ENERGY', 30, 30, '2014-07-20', '2014-04-25', '2015-02-08', 0, 0.0000, 0.0000, 290.0000, 290.0000, '2015-02-06 07:34:50', 'dbo', ''),
(2014070063, 201407, 1, 63, '2015-02-01', 63, 'ENERGY', 1, 1, '2014-07-20', '2014-04-25', '2015-02-08', 0, 0.0000, 0.0000, 290.0000, 290.0000, '2015-02-06 07:34:50', 'dbo', ''),
(2014070064, 201407, 1, 64, '2015-02-01', 64, 'ENERGY', 2, 2, '2014-07-20', '2014-04-25', '2015-02-08', 0, 0.0000, 0.0000, 290.0000, 290.0000, '2015-02-06 07:34:50', 'dbo', ''),
(2014070065, 201407, 1, 65, '2015-02-01', 65, 'ENERGY', 9, 4, '2014-07-20', '2014-04-25', '2015-02-08', 5, 0.0000, 0.0000, 507.8000, 507.8000, '2015-02-06 07:34:50', 'dbo', ''),
(2014070066, 201407, 1, 66, '2015-02-01', 66, 'ENERGY', 6, 4, '2014-07-20', '2014-04-25', '2015-02-08', 2, 0.0000, 0.0000, 377.1100, 377.1100, '2015-02-06 07:34:50', 'dbo', ''),
(2014070067, 201407, 1, 67, '2015-02-01', 67, 'ENERGY', 64, 4, '2014-07-20', '2014-04-25', '2015-02-08', 60, 0.0000, 0.0000, 2903.5700, 2903.5700, '2015-02-06 07:34:51', 'dbo', ''),
(2014070068, 201407, 1, 68, '2015-02-01', 68, 'ENERGY', 17, 9, '2014-07-20', '2014-04-25', '2015-02-08', 8, 0.0000, 0.0000, 638.4700, 638.4700, '2015-02-06 07:34:51', 'dbo', ''),
(2014070069, 201407, 1, 69, '2015-02-01', 69, 'ENERGY', 1, 1, '2014-07-20', '2014-04-25', '2015-02-08', 0, 0.0000, 0.0000, 290.0000, 290.0000, '2015-02-06 07:34:50', 'dbo', ''),
(2014070070, 201407, 1, 70, '2015-02-01', 70, 'ENERGY', 41, 19, '2014-07-20', '2014-04-25', '2015-02-08', 22, 0.0000, 0.0000, 1248.3100, 1248.3100, '2015-02-06 07:34:50', 'dbo', ''),
(2014070071, 201407, 1, 71, '2015-02-01', 71, 'ENERGY', 40, 21, '2014-07-20', '2014-04-25', '2015-02-08', 19, 0.0000, 0.0000, 1117.6200, 1117.6200, '2015-02-06 07:34:50', 'dbo', ''),
(2014070072, 201407, 1, 72, '2015-02-01', 72, 'ENERGY', 31, 31, '2014-07-20', '2014-04-25', '2015-02-08', 0, 0.0000, 0.0000, 290.0000, 290.0000, '2015-02-06 07:34:50', 'dbo', ''),
(2014070073, 201407, 1, 73, '2015-02-01', 73, 'ENERGY', 217, 0, '2014-07-20', '2014-04-25', '2015-02-08', 217, 0.0000, 0.0000, 9742.3900, 9742.3900, '2015-02-06 07:34:50', 'dbo', ''),
(2014080001, 201408, 2, 1, '2015-02-02', 74, 'ENERGY', 70, 70, '2014-08-20', '2014-07-20', '2015-02-09', 0, 1640.3400, 0.0000, 290.0000, 1930.3400, '2015-02-06 11:07:00', 'dbo', ''),
(2014080002, 201408, 2, 2, '2015-02-02', 75, 'ENERGY', 144, 124, '2014-08-20', '2014-07-20', '2015-02-09', 20, 3164.9300, 0.0000, 1117.8800, 4282.8100, '2015-02-06 11:07:00', 'dbo', ''),
(2014080003, 201408, 2, 3, '2015-02-02', 76, 'ENERGY', 50, 50, '2014-08-20', '2014-07-20', '2015-02-09', 0, 682.0300, 0.0000, 290.0000, 972.0300, '2015-02-06 11:07:00', 'dbo', ''),
(2014080004, 201408, 2, 4, '2015-02-02', 77, 'ENERGY', 72, 72, '2014-08-20', '2014-07-20', '2015-02-09', 0, 464.2400, 0.0000, 290.0000, 754.2400, '2015-02-06 11:07:00', 'dbo', ''),
(2014080005, 201408, 2, 5, '2015-02-02', 78, 'ENERGY', 50, 50, '2014-08-20', '2014-07-20', '2015-02-09', 0, 551.3600, 0.0000, 290.0000, 841.3600, '2015-02-06 11:07:00', 'dbo', ''),
(2014080006, 201408, 2, 6, '2015-02-02', 79, 'ENERGY', 44, 44, '2014-08-20', '2014-07-20', '2015-02-09', 0, 464.2400, 0.0000, 290.0000, 754.2400, '2015-02-06 11:07:00', 'dbo', ''),
(2014080007, 201408, 2, 7, '2015-02-02', 80, 'ENERGY', 52, 52, '2014-08-20', '2014-07-20', '2015-02-09', 0, 1161.1900, 0.0000, 290.0000, 1451.1900, '2015-02-06 11:07:00', 'dbo', ''),
(2014080008, 201408, 2, 8, '2015-02-02', 81, 'ENERGY', 49, 49, '2014-08-20', '2014-07-20', '2015-02-09', 0, 420.6800, 0.0000, 290.0000, 710.6800, '2015-02-06 11:07:00', 'dbo', ''),
(2014080009, 201408, 2, 9, '2015-02-02', 82, 'ENERGY', 38, 37, '2014-08-20', '2014-07-20', '2015-02-09', 1, 420.6800, 0.0000, 331.3880, 752.0680, '2015-02-06 11:07:00', 'dbo', ''),
(2014080010, 201408, 2, 10, '2015-02-02', 83, 'ENERGY', 31, 30, '2014-08-20', '2014-07-20', '2015-02-09', 1, 420.6800, 0.0000, 331.3880, 752.0680, '2015-02-06 11:07:00', 'dbo', ''),
(2014080011, 201408, 2, 11, '2015-02-02', 84, 'ENERGY', 88, 70, '2014-08-20', '2014-07-20', '2015-02-09', 18, 1858.1400, 0.0000, 1035.0940, 2893.2340, '2015-02-06 11:07:00', 'dbo', ''),
(2014080012, 201408, 2, 12, '2015-02-02', 85, 'ENERGY', 33, 33, '2014-08-20', '2014-07-20', '2015-02-09', 0, 377.1100, 0.0000, 290.0000, 667.1100, '2015-02-06 11:07:00', 'dbo', ''),
(2014080013, 201408, 2, 13, '2015-02-02', 86, 'ENERGY', 76, 73, '2014-08-20', '2014-07-20', '2015-02-09', 3, 1901.7000, 0.0000, 414.1840, 2315.8840, '2015-02-06 11:07:00', 'dbo', ''),
(2014080014, 201408, 2, 14, '2015-02-02', 87, 'ENERGY', 65, 63, '2014-08-20', '2014-07-20', '2015-02-09', 2, 1248.3100, 0.0000, 372.7960, 1621.1060, '2015-02-06 11:07:00', 'dbo', ''),
(2014080015, 201408, 2, 15, '2015-02-02', 88, 'ENERGY', 69, 68, '2014-08-20', '2014-07-20', '2015-02-09', 1, 1248.3100, 0.0000, 331.3880, 1579.6980, '2015-02-06 11:07:00', 'dbo', ''),
(2014080016, 201408, 2, 16, '2015-02-02', 89, 'ENERGY', 43, 43, '2014-08-20', '2014-07-20', '2015-02-09', 0, 333.5600, 0.0000, 290.0000, 623.5600, '2015-02-06 11:07:00', 'dbo', ''),
(2014080017, 201408, 2, 17, '2015-02-02', 90, 'ENERGY', 37, 25, '2014-08-20', '2014-07-20', '2015-02-09', 12, 551.3600, 0.0000, 786.7260, 1338.0860, '2015-02-06 11:07:00', 'dbo', ''),
(2014080018, 201408, 2, 18, '2015-02-02', 91, 'ENERGY', 44, 44, '2014-08-20', '2014-07-20', '2015-02-09', 0, 725.6000, 0.0000, 290.0000, 1015.6000, '2015-02-06 11:07:00', 'dbo', ''),
(2014080019, 201408, 2, 19, '2015-02-02', 92, 'ENERGY', 33, 33, '2014-08-20', '2014-07-20', '2015-02-09', 0, 812.7100, 0.0000, 290.0000, 1102.7100, '2015-02-06 11:07:00', 'dbo', ''),
(2014080020, 201408, 2, 20, '2015-02-02', 93, 'ENERGY', 90, 61, '2014-08-20', '2014-07-20', '2015-02-09', 29, 1466.1000, 0.0000, 1490.4220, 2956.5220, '2015-02-06 11:07:00', 'dbo', ''),
(2014080021, 201408, 2, 21, '2015-02-02', 94, 'ENERGY', 7057, 5944, '2014-08-20', '2014-07-20', '2015-02-09', 1113, 209767.1900, 0.0000, 46361.2740, 256128.4640, '2015-02-06 11:07:00', 'dbo', ''),
(2014080022, 201408, 2, 22, '2015-02-02', 95, 'ENERGY', 4404, 3551, '2014-08-20', '2014-07-20', '2015-02-09', 853, 118945.8200, 0.0000, 35598.8940, 154544.7140, '2015-02-06 11:07:00', 'dbo', ''),
(2014080023, 201408, 2, 23, '2015-02-02', 96, 'ENERGY', 9430, 7610, '2014-08-20', '2014-07-20', '2015-02-09', 1820, 296232.6200, 0.0000, 75626.6800, 371859.3000, '2015-02-06 11:07:00', 'dbo', ''),
(2014080024, 201408, 2, 24, '2015-02-02', 97, 'ENERGY', 8228, 6704, '2014-08-20', '2014-07-20', '2015-02-09', 1524, 264869.8400, 0.0000, 63374.1220, 328243.9620, '2015-02-06 11:07:00', 'dbo', ''),
(2014080025, 201408, 2, 25, '2015-02-02', 98, 'ENERGY', 36, 36, '2014-08-20', '2014-07-20', '2015-02-09', 0, 464.2400, 0.0000, 290.0000, 754.2400, '2015-02-06 11:07:00', 'dbo', ''),
(2014080026, 201408, 2, 26, '2015-02-02', 99, 'ENERGY', 80, 47, '2014-08-20', '2014-07-20', '2015-02-09', 33, 594.9100, 0.0000, 1655.9940, 2250.9040, '2015-02-06 11:07:00', 'dbo', ''),
(2014080029, 201408, 2, 29, '2015-02-02', 102, 'ENERGY', 12238, 9942, '2014-08-20', '2014-07-20', '2015-02-09', 2296, 371372.6000, 0.0000, 95330.1180, 466702.7180, '2015-02-06 11:07:00', 'dbo', ''),
(2014080030, 201408, 2, 30, '2015-02-02', 103, 'ENERGY', 4872, 4052, '2014-08-20', '2014-07-20', '2015-02-09', 820, 140464.1800, 0.0000, 34232.9000, 174697.0800, '2015-02-06 11:07:00', 'dbo', ''),
(2014080031, 201408, 2, 31, '2015-02-02', 104, 'ENERGY', 65, 65, '2014-08-20', '2014-07-20', '2015-02-09', 0, 986.9600, 0.0000, 290.0000, 1276.9600, '2015-02-06 11:07:00', 'dbo', ''),
(2014080032, 201408, 2, 32, '2015-02-02', 105, 'ENERGY', 37, 36, '2014-08-20', '2014-07-20', '2015-02-09', 1, 420.6800, 0.0000, 331.3880, 752.0680, '2015-02-06 11:07:00', 'dbo', ''),
(2014080033, 201408, 2, 33, '2015-02-02', 106, 'ENERGY', 48, 35, '2014-08-20', '2014-07-20', '2015-02-09', 13, 1248.3100, 0.0000, 828.1140, 2076.4240, '2015-02-06 11:07:00', 'dbo', ''),
(2014080034, 201408, 2, 34, '2015-02-02', 107, 'ENERGY', 18, 18, '2014-08-20', '2014-07-20', '2015-02-09', 0, 594.9100, 0.0000, 290.0000, 884.9100, '2015-02-06 11:07:00', 'dbo', ''),
(2014080035, 201408, 2, 35, '2015-02-02', 108, 'ENERGY', 250, 223, '2014-08-20', '2014-07-20', '2015-02-09', 27, 6431.8800, 0.0000, 1407.6360, 7839.5160, '2015-02-06 11:07:00', 'dbo', ''),
(2014080036, 201408, 2, 36, '2015-02-02', 109, 'ENERGY', 57, 57, '2014-08-20', '2014-07-20', '2015-02-09', 0, 1074.0700, 0.0000, 290.0000, 1364.0700, '2015-02-06 11:07:00', 'dbo', ''),
(2014080037, 201408, 2, 37, '2015-02-02', 110, 'ENERGY', 85, 69, '2014-08-20', '2014-07-20', '2015-02-09', 16, 1901.7000, 0.0000, 952.2980, 2853.9980, '2015-02-06 11:07:00', 'dbo', ''),
(2014080038, 201408, 2, 38, '2015-02-02', 111, 'ENERGY', 31, 31, '2014-08-20', '2014-07-20', '2015-02-09', 0, 1030.5100, 0.0000, 290.0000, 1320.5100, '2015-02-06 11:07:00', 'dbo', ''),
(2014080039, 201408, 2, 39, '2015-02-02', 112, 'ENERGY', 40, 40, '2014-08-20', '2014-07-20', '2015-02-09', 0, 464.2400, 0.0000, 290.0000, 754.2400, '2015-02-06 11:07:00', 'dbo', ''),
(2014080040, 201408, 2, 40, '2015-02-02', 113, 'ENERGY', 52, 52, '2014-08-20', '2014-07-20', '2015-02-09', 0, 856.2700, 0.0000, 290.0000, 1146.2700, '2015-02-06 11:07:00', 'dbo', ''),
(2014080041, 201408, 2, 41, '2015-02-02', 114, 'ENERGY', 48, 20, '2014-08-20', '2014-07-20', '2015-02-09', 28, 638.4700, 0.0000, 1449.0240, 2087.4940, '2015-02-06 11:07:00', 'dbo', ''),
(2014080042, 201408, 2, 42, '2015-02-02', 115, 'ENERGY', 42, 40, '2014-08-20', '2014-07-20', '2015-02-09', 2, 725.6000, 0.0000, 372.7960, 1098.3960, '2015-02-06 11:07:00', 'dbo', ''),
(2014080043, 201408, 2, 43, '2015-02-02', 116, 'ENERGY', 275, 117, '2014-08-20', '2014-07-20', '2015-02-09', 158, 4079.6600, 0.0000, 6830.2240, 10909.8840, '2015-02-06 11:07:00', 'dbo', ''),
(2014080044, 201408, 2, 44, '2015-02-02', 117, 'ENERGY', 36, 36, '2014-08-20', '2014-07-20', '2015-02-09', 0, 1161.1900, 0.0000, 290.0000, 1451.1900, '2015-02-06 11:07:00', 'dbo', ''),
(2014080045, 201408, 2, 45, '2015-02-02', 118, 'ENERGY', 4160, 1832, '2014-08-20', '2014-07-20', '2015-02-09', 2328, 77738.6300, 0.0000, 96654.7240, 174393.3540, '2015-02-06 11:07:00', 'dbo', ''),
(2014080046, 201408, 2, 46, '2015-02-02', 119, 'ENERGY', 2702, 2085, '2014-08-20', '2014-07-20', '2015-02-09', 617, 89804.5900, 0.0000, 25829.9560, 115634.5460, '2015-02-06 11:07:00', 'dbo', ''),
(2014080047, 201408, 2, 47, '2015-02-02', 120, 'ENERGY', 2734, 2187, '2014-08-20', '2014-07-20', '2015-02-09', 547, 81049.1400, 0.0000, 22932.3960, 103981.5360, '2015-02-06 11:07:00', 'dbo', ''),
(2014080048, 201408, 2, 48, '2015-02-02', 121, 'ENERGY', 48, 43, '2014-08-20', '2014-07-20', '2015-02-09', 5, 551.3600, 0.0000, 496.9700, 1048.3300, '2015-02-06 11:07:00', 'dbo', ''),
(2014080049, 201408, 2, 49, '2015-02-02', 122, 'ENERGY', 35, 35, '2014-08-20', '2014-07-20', '2015-02-09', 0, 290.0000, 0.0000, 290.0000, 580.0000, '2015-02-06 11:07:00', 'dbo', ''),
(2014080050, 201408, 2, 50, '2015-02-02', 123, 'ENERGY', 38, 38, '2014-08-20', '2014-07-20', '2015-02-09', 0, 551.3600, 0.0000, 290.0000, 841.3600, '2015-02-06 11:07:00', 'dbo', ''),
(2014080051, 201408, 2, 51, '2015-02-02', 124, 'ENERGY', 162, 138, '2014-08-20', '2014-07-20', '2015-02-09', 24, 4602.3800, 0.0000, 1283.4520, 5885.8320, '2015-02-06 11:07:00', 'dbo', ''),
(2014080052, 201408, 2, 52, '2015-02-02', 125, 'ENERGY', 64, 64, '2014-08-20', '2014-07-20', '2015-02-09', 0, 333.5600, 0.0000, 290.0000, 623.5600, '2015-02-06 11:07:00', 'dbo', ''),
(2014080053, 201408, 2, 53, '2015-02-02', 126, 'ENERGY', 37, 34, '2014-08-20', '2014-07-20', '2015-02-09', 3, 856.2700, 0.0000, 414.1840, 1270.4540, '2015-02-06 11:07:00', 'dbo', ''),
(2014080054, 201408, 2, 54, '2015-02-02', 127, 'ENERGY', 529, 181, '2014-08-20', '2014-07-20', '2015-02-09', 348, 5604.2500, 0.0000, 14695.0340, 20299.2840, '2015-02-06 11:07:00', 'dbo', ''),
(2014080055, 201408, 2, 55, '2015-02-02', 128, 'ENERGY', 56, 56, '2014-08-20', '2014-07-20', '2015-02-09', 0, 812.7100, 0.0000, 290.0000, 1102.7100, '2015-02-06 11:07:00', 'dbo', ''),
(2014080056, 201408, 2, 56, '2015-02-02', 129, 'ENERGY', 39, 39, '2014-08-20', '2014-07-20', '2015-02-09', 0, 464.2400, 0.0000, 290.0000, 754.2400, '2015-02-06 11:07:00', 'dbo', ''),
(2014080059, 201408, 2, 59, '2015-02-02', 132, 'ENERGY', 1, 1, '2014-08-20', '2014-07-20', '2015-02-09', 0, 290.0000, 0.0000, 290.0000, 580.0000, '2015-02-06 11:07:00', 'dbo', ''),
(2014080060, 201408, 2, 60, '2015-02-02', 133, 'ENERGY', 2, 2, '2014-08-20', '2014-07-20', '2015-02-09', 0, 290.0000, 0.0000, 290.0000, 580.0000, '2015-02-06 11:07:00', 'dbo', ''),
(2014080061, 201408, 2, 61, '2015-02-02', 134, 'ENERGY', 3, 3, '2014-08-20', '2014-07-20', '2015-02-09', 0, 290.0000, 0.0000, 290.0000, 580.0000, '2015-02-06 11:07:00', 'dbo', ''),
(2014080062, 201408, 2, 62, '2015-02-02', 135, 'ENERGY', 30, 30, '2014-08-20', '2014-07-20', '2015-02-09', 0, 290.0000, 0.0000, 290.0000, 580.0000, '2015-02-06 11:07:00', 'dbo', ''),
(2014080063, 201408, 2, 63, '2015-02-02', 136, 'ENERGY', 1, 1, '2014-08-20', '2014-07-20', '2015-02-09', 0, 290.0000, 0.0000, 290.0000, 580.0000, '2015-02-06 11:07:00', 'dbo', ''),
(2014080064, 201408, 2, 64, '2015-02-02', 137, 'ENERGY', 2, 2, '2014-08-20', '2014-07-20', '2015-02-09', 0, 290.0000, 0.0000, 290.0000, 580.0000, '2015-02-06 11:07:00', 'dbo', ''),
(2014080065, 201408, 2, 65, '2015-02-02', 138, 'ENERGY', 10, 9, '2014-08-20', '2014-07-20', '2015-02-09', 1, 507.8000, 0.0000, 331.3880, 839.1880, '2015-02-06 11:07:00', 'dbo', ''),
(2014080066, 201408, 2, 66, '2015-02-02', 139, 'ENERGY', 6, 6, '2014-08-20', '2014-07-20', '2015-02-09', 0, 377.1100, 0.0000, 290.0000, 667.1100, '2015-02-06 11:07:00', 'dbo', ''),
(2014080067, 201408, 2, 67, '2015-02-02', 140, 'ENERGY', 64, 64, '2014-08-20', '2014-07-20', '2015-02-09', 0, 2903.5700, 0.0000, 290.0000, 3193.5700, '2015-02-06 11:07:00', 'dbo', ''),
(2014080068, 201408, 2, 68, '2015-02-02', 141, 'ENERGY', 17, 17, '2014-08-20', '2014-07-20', '2015-02-09', 0, 638.4700, 0.0000, 290.0000, 928.4700, '2015-02-06 11:07:00', 'dbo', ''),
(2014080069, 201408, 2, 69, '2015-02-02', 142, 'ENERGY', 1, 1, '2014-08-20', '2014-07-20', '2015-02-09', 0, 290.0000, 0.0000, 290.0000, 580.0000, '2015-02-06 11:07:00', 'dbo', ''),
(2014080070, 201408, 2, 70, '2015-02-02', 143, 'ENERGY', 41, 41, '2014-08-20', '2014-07-20', '2015-02-09', 0, 1248.3100, 0.0000, 290.0000, 1538.3100, '2015-02-06 11:07:00', 'dbo', ''),
(2014080071, 201408, 2, 71, '2015-02-02', 144, 'ENERGY', 54, 40, '2014-08-20', '2014-07-20', '2015-02-09', 14, 1117.6200, 0.0000, 869.5220, 1987.1420, '2015-02-06 11:07:00', 'dbo', ''),
(2014080072, 201408, 2, 72, '2015-02-02', 145, 'ENERGY', 31, 31, '2014-08-20', '2014-07-20', '2015-02-09', 0, 290.0000, 0.0000, 290.0000, 580.0000, '2015-02-06 11:07:00', 'dbo', ''),
(2014080073, 201408, 2, 73, '2015-02-02', 146, 'ENERGY', 222, 217, '2014-08-20', '2014-07-20', '2015-02-09', 5, 9742.3900, 0.0000, 496.9700, 10239.3600, '2015-02-06 11:07:00', 'dbo', ''),
(2014090001, 201409, 3, 1, '2015-02-03', 147, 'ENERGY', 71, 70, '2014-09-20', '2014-08-20', '2015-02-10', 1, 1930.3400, 0.0000, 332.1210, 2262.4610, '2015-02-06 11:14:41', 'dbo', ''),
(2014090002, 201409, 3, 2, '2015-02-03', 148, 'ENERGY', 155, 144, '2014-09-20', '2014-08-20', '2015-02-10', 11, 4282.8100, 0.0000, 753.4110, 5036.2210, '2015-02-06 11:14:41', 'dbo', ''),
(2014090003, 201409, 3, 3, '2015-02-03', 149, 'ENERGY', 50, 50, '2014-09-20', '2014-08-20', '2015-02-10', 0, 972.0300, 0.0000, 290.0000, 1262.0300, '2015-02-06 11:14:41', 'dbo', ''),
(2014090004, 201409, 3, 4, '2015-02-03', 150, 'ENERGY', 90, 72, '2014-09-20', '2014-08-20', '2015-02-10', 18, 754.2400, 0.0000, 1048.2980, 1802.5380, '2015-02-06 11:14:41', 'dbo', ''),
(2014090005, 201409, 3, 5, '2015-02-03', 151, 'ENERGY', 61, 50, '2014-09-20', '2014-08-20', '2015-02-10', 11, 841.3600, 0.0000, 753.4110, 1594.7710, '2015-02-06 11:14:41', 'dbo', ''),
(2014090006, 201409, 3, 6, '2015-02-03', 152, 'ENERGY', 44, 44, '2014-09-20', '2014-08-20', '2015-02-10', 0, 754.2400, 0.0000, 290.0000, 1044.2400, '2015-02-06 11:14:41', 'dbo', ''),
(2014090007, 201409, 3, 7, '2015-02-03', 153, 'ENERGY', 52, 52, '2014-09-20', '2014-08-20', '2015-02-10', 0, 1451.1900, 0.0000, 290.0000, 1741.1900, '2015-02-06 11:14:41', 'dbo', ''),
(2014090008, 201409, 3, 8, '2015-02-03', 154, 'ENERGY', 49, 49, '2014-09-20', '2014-08-20', '2015-02-10', 0, 710.6800, 0.0000, 290.0000, 1000.6800, '2015-02-06 11:14:41', 'dbo', ''),
(2014090009, 201409, 3, 9, '2015-02-03', 155, 'ENERGY', 43, 38, '2014-09-20', '2014-08-20', '2015-02-10', 5, 752.0680, 0.0000, 500.6350, 1252.7030, '2015-02-06 11:14:41', 'dbo', ''),
(2014090010, 201409, 3, 10, '2015-02-03', 156, 'ENERGY', 31, 31, '2014-09-20', '2014-08-20', '2015-02-10', 0, 752.0680, 0.0000, 290.0000, 1042.0680, '2015-02-06 11:14:41', 'dbo', ''),
(2014090011, 201409, 3, 11, '2015-02-03', 157, 'ENERGY', 105, 88, '2014-09-20', '2014-08-20', '2015-02-10', 17, 2893.2340, 0.0000, 1006.1770, 3899.4110, '2015-02-06 11:14:41', 'dbo', ''),
(2014090012, 201409, 3, 12, '2015-02-03', 158, 'ENERGY', 33, 33, '2014-09-20', '2014-08-20', '2015-02-10', 0, 667.1100, 0.0000, 290.0000, 957.1100, '2015-02-06 11:14:41', 'dbo', ''),
(2014090013, 201409, 3, 13, '2015-02-03', 159, 'ENERGY', 76, 76, '2014-09-20', '2014-08-20', '2015-02-10', 0, 2315.8840, 0.0000, 290.0000, 2605.8840, '2015-02-06 11:14:41', 'dbo', ''),
(2014090014, 201409, 3, 14, '2015-02-03', 160, 'ENERGY', 76, 65, '2014-09-20', '2014-08-20', '2015-02-10', 11, 1621.1060, 0.0000, 753.4110, 2374.5170, '2015-02-06 11:14:41', 'dbo', ''),
(2014090015, 201409, 3, 15, '2015-02-03', 161, 'ENERGY', 70, 69, '2014-09-20', '2014-08-20', '2015-02-10', 1, 1579.6980, 0.0000, 332.1210, 1911.8190, '2015-02-06 11:14:41', 'dbo', ''),
(2014090016, 201409, 3, 16, '2015-02-03', 162, 'ENERGY', 55, 43, '2014-09-20', '2014-08-20', '2015-02-10', 12, 623.5600, 0.0000, 795.5320, 1419.0920, '2015-02-06 11:14:41', 'dbo', ''),
(2014090017, 201409, 3, 17, '2015-02-03', 163, 'ENERGY', 38, 37, '2014-09-20', '2014-08-20', '2015-02-10', 1, 1338.0860, 0.0000, 332.1210, 1670.2070, '2015-02-06 11:14:41', 'dbo', ''),
(2014090018, 201409, 3, 18, '2015-02-03', 164, 'ENERGY', 44, 44, '2014-09-20', '2014-08-20', '2015-02-10', 0, 1015.6000, 0.0000, 290.0000, 1305.6000, '2015-02-06 11:14:41', 'dbo', ''),
(2014090019, 201409, 3, 19, '2015-02-03', 165, 'ENERGY', 48, 33, '2014-09-20', '2014-08-20', '2015-02-10', 15, 1102.7100, 0.0000, 921.9250, 2024.6350, '2015-02-06 11:14:41', 'dbo', ''),
(2014090020, 201409, 3, 20, '2015-02-03', 166, 'ENERGY', 101, 90, '2014-09-20', '2014-08-20', '2015-02-10', 11, 2956.5220, 0.0000, 753.4110, 3709.9330, '2015-02-06 11:14:41', 'dbo', ''),
(2014090021, 201409, 3, 21, '2015-02-03', 167, 'ENERGY', 8153, 7057, '2014-09-20', '2014-08-20', '2015-02-10', 1096, 256128.4640, 0.0000, 46462.3560, 302590.8200, '2015-02-06 11:14:41', 'dbo', ''),
(2014090022, 201409, 3, 22, '2015-02-03', 168, 'ENERGY', 5127, 4404, '2014-09-20', '2014-08-20', '2015-02-10', 723, 154544.7140, 0.0000, 30748.5930, 185293.3070, '2015-02-06 11:14:41', 'dbo', ''),
(2014090023, 201409, 3, 23, '2015-02-03', 169, 'ENERGY', 11179, 9430, '2014-09-20', '2014-08-20', '2015-02-10', 1749, 371859.3000, 0.0000, 73971.9790, 445831.2790, '2015-02-06 11:14:41', 'dbo', ''),
(2014090024, 201409, 3, 24, '2015-02-03', 170, 'ENERGY', 9668, 8228, '2014-09-20', '2014-08-20', '2015-02-10', 1440, 328243.9620, 0.0000, 60954.4100, 389198.3720, '2015-02-06 11:14:41', 'dbo', ''),
(2014090025, 201409, 3, 25, '2015-02-03', 171, 'ENERGY', 36, 36, '2014-09-20', '2014-08-20', '2015-02-10', 0, 754.2400, 0.0000, 290.0000, 1044.2400, '2015-02-06 11:14:41', 'dbo', ''),
(2014090026, 201409, 3, 26, '2015-02-03', 172, 'ENERGY', 108, 80, '2014-09-20', '2014-08-20', '2015-02-10', 28, 2250.9040, 0.0000, 1469.5880, 3720.4920, '2015-02-06 11:14:41', 'dbo', ''),
(2014090029, 201409, 3, 29, '2015-02-03', 175, 'ENERGY', 14336, 12238, '2014-09-20', '2014-08-20', '2015-02-10', 2098, 466702.7180, 0.0000, 88674.6680, 555377.3860, '2015-02-06 11:14:41', 'dbo', ''),
(2014090030, 201409, 3, 30, '2015-02-03', 176, 'ENERGY', 5663, 4872, '2014-09-20', '2014-08-20', '2015-02-10', 791, 174697.0800, 0.0000, 33613.3010, 208310.3810, '2015-02-06 11:14:41', 'dbo', ''),
(2014090031, 201409, 3, 31, '2015-02-03', 177, 'ENERGY', 65, 65, '2014-09-20', '2014-08-20', '2015-02-10', 0, 1276.9600, 0.0000, 290.0000, 1566.9600, '2015-02-06 11:14:41', 'dbo', ''),
(2014090032, 201409, 3, 32, '2015-02-03', 178, 'ENERGY', 39, 37, '2014-09-20', '2014-08-20', '2015-02-10', 2, 752.0680, 0.0000, 374.2520, 1126.3200, '2015-02-06 11:14:41', 'dbo', ''),
(2014090033, 201409, 3, 33, '2015-02-03', 179, 'ENERGY', 54, 48, '2014-09-20', '2014-08-20', '2015-02-10', 6, 2076.4240, 0.0000, 542.7660, 2619.1900, '2015-02-06 11:14:41', 'dbo', ''),
(2014090034, 201409, 3, 34, '2015-02-03', 180, 'ENERGY', 21, 18, '2014-09-20', '2014-08-20', '2015-02-10', 3, 884.9100, 0.0000, 416.3830, 1301.2930, '2015-02-06 11:14:41', 'dbo', ''),
(2014090035, 201409, 3, 35, '2015-02-03', 181, 'ENERGY', 284, 250, '2014-09-20', '2014-08-20', '2015-02-10', 34, 7839.5160, 0.0000, 1722.3540, 9561.8700, '2015-02-06 11:14:41', 'dbo', ''),
(2014090036, 201409, 3, 36, '2015-02-03', 182, 'ENERGY', 59, 57, '2014-09-20', '2014-08-20', '2015-02-10', 2, 1364.0700, 0.0000, 374.2520, 1738.3220, '2015-02-06 11:14:41', 'dbo', ''),
(2014090037, 201409, 3, 37, '2015-02-03', 183, 'ENERGY', 101, 85, '2014-09-20', '2014-08-20', '2015-02-10', 16, 2853.9980, 0.0000, 964.0460, 3818.0440, '2015-02-06 11:14:41', 'dbo', ''),
(2014090038, 201409, 3, 38, '2015-02-03', 184, 'ENERGY', 31, 31, '2014-09-20', '2014-08-20', '2015-02-10', 0, 1320.5100, 0.0000, 290.0000, 1610.5100, '2015-02-06 11:14:41', 'dbo', ''),
(2014090039, 201409, 3, 39, '2015-02-03', 185, 'ENERGY', 41, 40, '2014-09-20', '2014-08-20', '2015-02-10', 1, 754.2400, 0.0000, 332.1210, 1086.3610, '2015-02-06 11:14:41', 'dbo', ''),
(2014090040, 201409, 3, 40, '2015-02-03', 186, 'ENERGY', 54, 52, '2014-09-20', '2014-08-20', '2015-02-10', 2, 1146.2700, 0.0000, 374.2520, 1520.5220, '2015-02-06 11:14:41', 'dbo', ''),
(2014090041, 201409, 3, 41, '2015-02-03', 187, 'ENERGY', 54, 48, '2014-09-20', '2014-08-20', '2015-02-10', 6, 2087.4940, 0.0000, 542.7660, 2630.2600, '2015-02-06 11:14:41', 'dbo', ''),
(2014090042, 201409, 3, 42, '2015-02-03', 188, 'ENERGY', 42, 42, '2014-09-20', '2014-08-20', '2015-02-10', 0, 1098.3960, 0.0000, 290.0000, 1388.3960, '2015-02-06 11:14:41', 'dbo', ''),
(2014090043, 201409, 3, 43, '2015-02-03', 189, 'ENERGY', 1458, 275, '2014-09-20', '2014-08-20', '2015-02-10', 1183, 10909.8840, 0.0000, 50127.4930, 61037.3770, '2015-02-06 11:14:41', 'dbo', ''),
(2014090044, 201409, 3, 44, '2015-02-03', 190, 'ENERGY', 52, 36, '2014-09-20', '2014-08-20', '2015-02-10', 16, 1451.1900, 0.0000, 964.0460, 2415.2360, '2015-02-06 11:14:41', 'dbo', ''),
(2014090045, 201409, 3, 45, '2015-02-03', 191, 'ENERGY', 5256, 4160, '2014-09-20', '2014-08-20', '2015-02-10', 1096, 174393.3540, 0.0000, 46462.3560, 220855.7100, '2015-02-06 11:14:41', 'dbo', ''),
(2014090046, 201409, 3, 46, '2015-02-03', 192, 'ENERGY', 3639, 2702, '2014-09-20', '2014-08-20', '2015-02-10', 937, 115634.5460, 0.0000, 39763.9870, 155398.5330, '2015-02-06 11:14:41', 'dbo', ''),
(2014090047, 201409, 3, 47, '2015-02-03', 193, 'ENERGY', 3231, 2734, '2014-09-20', '2014-08-20', '2015-02-10', 497, 103981.5360, 0.0000, 21227.6470, 125209.1830, '2015-02-06 11:14:41', 'dbo', ''),
(2014090048, 201409, 3, 48, '2015-02-03', 194, 'ENERGY', 78, 48, '2014-09-20', '2014-08-20', '2015-02-10', 30, 1048.3300, 0.0000, 1553.8400, 2602.1700, '2015-02-06 11:14:41', 'dbo', ''),
(2014090049, 201409, 3, 49, '2015-02-03', 195, 'ENERGY', 41, 35, '2014-09-20', '2014-08-20', '2015-02-10', 6, 580.0000, 0.0000, 542.7660, 1122.7660, '2015-02-06 11:14:41', 'dbo', ''),
(2014090050, 201409, 3, 50, '2015-02-03', 196, 'ENERGY', 38, 38, '2014-09-20', '2014-08-20', '2015-02-10', 0, 841.3600, 0.0000, 290.0000, 1131.3600, '2015-02-06 11:14:41', 'dbo', ''),
(2014090051, 201409, 3, 51, '2015-02-03', 197, 'ENERGY', 189, 162, '2014-09-20', '2014-08-20', '2015-02-10', 27, 5885.8320, 0.0000, 1427.4570, 7313.2890, '2015-02-06 11:14:41', 'dbo', ''),
(2014090052, 201409, 3, 52, '2015-02-03', 198, 'ENERGY', 86, 64, '2014-09-20', '2014-08-20', '2015-02-10', 22, 623.5600, 0.0000, 1216.8120, 1840.3720, '2015-02-06 11:14:41', 'dbo', ''),
(2014090053, 201409, 3, 53, '2015-02-03', 199, 'ENERGY', 60, 37, '2014-09-20', '2014-08-20', '2015-02-10', 23, 1270.4540, 0.0000, 1258.9430, 2529.3970, '2015-02-06 11:14:41', 'dbo', ''),
(2014090054, 201409, 3, 54, '2015-02-03', 200, 'ENERGY', 970, 529, '2014-09-20', '2014-08-20', '2015-02-10', 441, 20299.2840, 0.0000, 18868.4710, 39167.7550, '2015-02-06 11:14:41', 'dbo', ''),
(2014090055, 201409, 3, 55, '2015-02-03', 201, 'ENERGY', 56, 56, '2014-09-20', '2014-08-20', '2015-02-10', 0, 1102.7100, 0.0000, 290.0000, 1392.7100, '2015-02-06 11:14:41', 'dbo', ''),
(2014090056, 201409, 3, 56, '2015-02-03', 202, 'ENERGY', 48, 39, '2014-09-20', '2014-08-20', '2015-02-10', 9, 754.2400, 0.0000, 669.1490, 1423.3890, '2015-02-06 11:14:41', 'dbo', ''),
(2014090059, 201409, 3, 59, '2015-02-03', 205, 'ENERGY', 1, 1, '2014-09-20', '2014-08-20', '2015-02-10', 0, 580.0000, 0.0000, 290.0000, 870.0000, '2015-02-06 11:14:41', 'dbo', ''),
(2014090060, 201409, 3, 60, '2015-02-03', 206, 'ENERGY', 2, 2, '2014-09-20', '2014-08-20', '2015-02-10', 0, 580.0000, 0.0000, 290.0000, 870.0000, '2015-02-06 11:14:41', 'dbo', ''),
(2014090061, 201409, 3, 61, '2015-02-03', 207, 'ENERGY', 3, 3, '2014-09-20', '2014-08-20', '2015-02-10', 0, 580.0000, 0.0000, 290.0000, 870.0000, '2015-02-06 11:14:41', 'dbo', ''),
(2014090062, 201409, 3, 62, '2015-02-03', 208, 'ENERGY', 30, 30, '2014-09-20', '2014-08-20', '2015-02-10', 0, 580.0000, 0.0000, 290.0000, 870.0000, '2015-02-06 11:14:41', 'dbo', ''),
(2014090063, 201409, 3, 63, '2015-02-03', 209, 'ENERGY', 1, 1, '2014-09-20', '2014-08-20', '2015-02-10', 0, 580.0000, 0.0000, 290.0000, 870.0000, '2015-02-06 11:14:41', 'dbo', ''),
(2014090064, 201409, 3, 64, '2015-02-03', 210, 'ENERGY', 2, 2, '2014-09-20', '2014-08-20', '2015-02-10', 0, 580.0000, 0.0000, 290.0000, 870.0000, '2015-02-06 11:14:41', 'dbo', ''),
(2014090065, 201409, 3, 65, '2015-02-03', 211, 'ENERGY', 10, 10, '2014-09-20', '2014-08-20', '2015-02-10', 0, 839.1880, 0.0000, 290.0000, 1129.1880, '2015-02-06 11:14:41', 'dbo', ''),
(2014090066, 201409, 3, 66, '2015-02-03', 212, 'ENERGY', 6, 6, '2014-09-20', '2014-08-20', '2015-02-10', 0, 667.1100, 0.0000, 290.0000, 957.1100, '2015-02-06 11:14:41', 'dbo', ''),
(2014090067, 201409, 3, 67, '2015-02-03', 213, 'ENERGY', 64, 64, '2014-09-20', '2014-08-20', '2015-02-10', 0, 3193.5700, 0.0000, 290.0000, 3483.5700, '2015-02-06 11:14:41', 'dbo', ''),
(2014090068, 201409, 3, 68, '2015-02-03', 214, 'ENERGY', 17, 17, '2014-09-20', '2014-08-20', '2015-02-10', 0, 928.4700, 0.0000, 290.0000, 1218.4700, '2015-02-06 11:14:41', 'dbo', ''),
(2014090069, 201409, 3, 69, '2015-02-03', 215, 'ENERGY', 1, 1, '2014-09-20', '2014-08-20', '2015-02-10', 0, 580.0000, 0.0000, 290.0000, 870.0000, '2015-02-06 11:14:41', 'dbo', ''),
(2014090070, 201409, 3, 70, '2015-02-03', 216, 'ENERGY', 41, 41, '2014-09-20', '2014-08-20', '2015-02-10', 0, 1538.3100, 0.0000, 290.0000, 1828.3100, '2015-02-06 11:14:41', 'dbo', ''),
(2014090071, 201409, 3, 71, '2015-02-03', 217, 'ENERGY', 54, 54, '2014-09-20', '2014-08-20', '2015-02-10', 0, 1987.1420, 0.0000, 290.0000, 2277.1420, '2015-02-06 11:14:41', 'dbo', ''),
(2014090072, 201409, 3, 72, '2015-02-03', 218, 'ENERGY', 31, 31, '2014-09-20', '2014-08-20', '2015-02-10', 0, 580.0000, 0.0000, 290.0000, 870.0000, '2015-02-06 11:14:41', 'dbo', ''),
(2014090073, 201409, 3, 73, '2015-02-03', 219, 'ENERGY', 233, 222, '2014-09-20', '2014-08-20', '2015-02-10', 11, 10239.3600, 0.0000, 753.4110, 10992.7710, '2015-02-06 11:14:41', 'dbo', ''),
(2014100001, 201410, 4, 1, '2015-02-04', 220, 'ENERGY', 71, 71, '2014-10-20', '2014-09-20', '2015-02-11', 0, 2262.4610, 0.0000, 290.0000, 2552.4610, '2015-02-06 11:16:54', 'dbo', ''),
(2014100002, 201410, 4, 2, '2015-02-04', 221, 'ENERGY', 159, 155, '2014-10-20', '2014-09-20', '2015-02-11', 4, 5036.2210, 0.0000, 436.7000, 5472.9210, '2015-02-06 11:16:54', 'dbo', ''),
(2014100003, 201410, 4, 3, '2015-02-04', 222, 'ENERGY', 51, 50, '2014-10-20', '2014-09-20', '2015-02-11', 1, 1262.0300, 0.0000, 326.6700, 1588.7000, '2015-02-06 11:16:54', 'dbo', ''),
(2014100004, 201410, 4, 4, '2015-02-04', 223, 'ENERGY', 105, 90, '2014-10-20', '2014-09-20', '2015-02-11', 15, 1802.5380, 0.0000, 840.1300, 2642.6680, '2015-02-06 11:16:54', 'dbo', ''),
(2014100005, 201410, 4, 5, '2015-02-04', 224, 'ENERGY', 83, 61, '2014-10-20', '2014-09-20', '2015-02-11', 22, 1594.7710, 0.0000, 1096.8500, 2691.6210, '2015-02-06 11:16:54', 'dbo', ''),
(2014100006, 201410, 4, 6, '2015-02-04', 225, 'ENERGY', 57, 44, '2014-10-20', '2014-09-20', '2015-02-11', 13, 1044.2400, 0.0000, 766.7700, 1811.0100, '2015-02-06 11:16:54', 'dbo', ''),
(2014100007, 201410, 4, 7, '2015-02-04', 226, 'ENERGY', 64, 52, '2014-10-20', '2014-09-20', '2015-02-11', 12, 1741.1900, 0.0000, 730.1000, 2471.2900, '2015-02-06 11:16:54', 'dbo', ''),
(2014100008, 201410, 4, 8, '2015-02-04', 227, 'ENERGY', 53, 49, '2014-10-20', '2014-09-20', '2015-02-11', 4, 1000.6800, 0.0000, 436.7000, 1437.3800, '2015-02-06 11:16:54', 'dbo', ''),
(2014100009, 201410, 4, 9, '2015-02-04', 228, 'ENERGY', 43, 43, '2014-10-20', '2014-09-20', '2015-02-11', 0, 1252.7030, 0.0000, 290.0000, 1542.7030, '2015-02-06 11:16:54', 'dbo', ''),
(2014100010, 201410, 4, 10, '2015-02-04', 229, 'ENERGY', 32, 31, '2014-10-20', '2014-09-20', '2015-02-11', 1, 1042.0680, 0.0000, 326.6700, 1368.7380, '2015-02-06 11:16:54', 'dbo', ''),
(2014100011, 201410, 4, 11, '2015-02-04', 230, 'ENERGY', 109, 105, '2014-10-20', '2014-09-20', '2015-02-11', 4, 3899.4110, 0.0000, 436.7000, 4336.1110, '2015-02-06 11:16:54', 'dbo', ''),
(2014100012, 201410, 4, 12, '2015-02-04', 231, 'ENERGY', 33, 33, '2014-10-20', '2014-09-20', '2015-02-11', 0, 957.1100, 0.0000, 290.0000, 1247.1100, '2015-02-06 11:16:54', 'dbo', ''),
(2014100013, 201410, 4, 13, '2015-02-04', 232, 'ENERGY', 77, 76, '2014-10-20', '2014-09-20', '2015-02-11', 1, 2605.8840, 0.0000, 326.6700, 2932.5540, '2015-02-06 11:16:54', 'dbo', ''),
(2014100014, 201410, 4, 14, '2015-02-04', 233, 'ENERGY', 84, 76, '2014-10-20', '2014-09-20', '2015-02-11', 8, 2374.5170, 0.0000, 583.4000, 2957.9170, '2015-02-06 11:16:54', 'dbo', ''),
(2014100015, 201410, 4, 15, '2015-02-04', 234, 'ENERGY', 73, 70, '2014-10-20', '2014-09-20', '2015-02-11', 3, 1911.8190, 0.0000, 400.0300, 2311.8490, '2015-02-06 11:16:54', 'dbo', ''),
(2014100016, 201410, 4, 16, '2015-02-04', 235, 'ENERGY', 60, 55, '2014-10-20', '2014-09-20', '2015-02-11', 5, 1419.0920, 0.0000, 473.3700, 1892.4620, '2015-02-06 11:16:54', 'dbo', ''),
(2014100017, 201410, 4, 17, '2015-02-04', 236, 'ENERGY', 38, 38, '2014-10-20', '2014-09-20', '2015-02-11', 0, 1670.2070, 0.0000, 290.0000, 1960.2070, '2015-02-06 11:16:54', 'dbo', ''),
(2014100018, 201410, 4, 18, '2015-02-04', 237, 'ENERGY', 44, 44, '2014-10-20', '2014-09-20', '2015-02-11', 0, 1305.6000, 0.0000, 290.0000, 1595.6000, '2015-02-06 11:16:54', 'dbo', ''),
(2014100019, 201410, 4, 19, '2015-02-04', 238, 'ENERGY', 59, 48, '2014-10-20', '2014-09-20', '2015-02-11', 11, 2024.6350, 0.0000, 693.4300, 2718.0650, '2015-02-06 11:16:54', 'dbo', ''),
(2014100020, 201410, 4, 20, '2015-02-04', 239, 'ENERGY', 101, 101, '2014-10-20', '2014-09-20', '2015-02-11', 0, 3709.9330, 0.0000, 290.0000, 3999.9330, '2015-02-06 11:16:54', 'dbo', ''),
(2014100021, 201410, 4, 21, '2015-02-04', 240, 'ENERGY', 9528, 8153, '2014-10-20', '2014-09-20', '2015-02-11', 1375, 302590.8200, 0.0000, 50717.9900, 353308.8100, '2015-02-06 11:16:54', 'dbo', ''),
(2014100022, 201410, 4, 22, '2015-02-04', 241, 'ENERGY', 6017, 5127, '2014-10-20', '2014-09-20', '2015-02-11', 890, 185293.3070, 0.0000, 32930.6700, 218223.9770, '2015-02-06 11:16:54', 'dbo', ''),
(2014100023, 201410, 4, 23, '2015-02-04', 242, 'ENERGY', 13164, 11179, '2014-10-20', '2014-09-20', '2015-02-11', 1985, 445831.2790, 0.0000, 73089.6700, 518920.9490, '2015-02-06 11:16:54', 'dbo', ''),
(2014100024, 201410, 4, 24, '2015-02-04', 243, 'ENERGY', 11306, 9668, '2014-10-20', '2014-09-20', '2015-02-11', 1638, 389198.3720, 0.0000, 60363.4900, 449561.8620, '2015-02-06 11:16:54', 'dbo', ''),
(2014100025, 201410, 4, 25, '2015-02-04', 244, 'ENERGY', 41, 36, '2014-10-20', '2014-09-20', '2015-02-11', 5, 1044.2400, 0.0000, 473.3700, 1517.6100, '2015-02-06 11:16:54', 'dbo', ''),
(2014100026, 201410, 4, 26, '2015-02-04', 245, 'ENERGY', 222, 108, '2014-10-20', '2014-09-20', '2015-02-11', 114, 3720.4920, 0.0000, 4470.9400, 8191.4320, '2015-02-06 11:16:54', 'dbo', ''),
(2014100029, 201410, 4, 29, '2015-02-04', 248, 'ENERGY', 16690, 14336, '2014-10-20', '2014-09-20', '2015-02-11', 2354, 555377.3860, 0.0000, 86622.7200, 642000.1060, '2015-02-06 11:16:54', 'dbo', ''),
(2014100030, 201410, 4, 30, '2015-02-04', 249, 'ENERGY', 6458, 5663, '2014-10-20', '2014-09-20', '2015-02-11', 795, 208310.3810, 0.0000, 29446.5500, 237756.9310, '2015-02-06 11:16:54', 'dbo', ''),
(2014100031, 201410, 4, 31, '2015-02-04', 250, 'ENERGY', 65, 65, '2014-10-20', '2014-09-20', '2015-02-11', 0, 1566.9600, 0.0000, 290.0000, 1856.9600, '2015-02-06 11:16:54', 'dbo', ''),
(2014100032, 201410, 4, 32, '2015-02-04', 251, 'ENERGY', 55, 39, '2014-10-20', '2014-09-20', '2015-02-11', 16, 1126.3200, 0.0000, 876.8000, 2003.1200, '2015-02-06 11:16:54', 'dbo', ''),
(2014100033, 201410, 4, 33, '2015-02-04', 252, 'ENERGY', 56, 54, '2014-10-20', '2014-09-20', '2015-02-11', 2, 2619.1900, 0.0000, 363.3500, 2982.5400, '2015-02-06 11:16:54', 'dbo', ''),
(2014100034, 201410, 4, 34, '2015-02-04', 253, 'ENERGY', 25, 21, '2014-10-20', '2014-09-20', '2015-02-11', 4, 1301.2930, 0.0000, 436.7000, 1737.9930, '2015-02-06 11:16:54', 'dbo', ''),
(2014100035, 201410, 4, 35, '2015-02-04', 254, 'ENERGY', 311, 284, '2014-10-20', '2014-09-20', '2015-02-11', 27, 9561.8700, 0.0000, 1280.2200, 10842.0900, '2015-02-06 11:16:54', 'dbo', ''),
(2014100036, 201410, 4, 36, '2015-02-04', 255, 'ENERGY', 61, 59, '2014-10-20', '2014-09-20', '2015-02-11', 2, 1738.3220, 0.0000, 363.3500, 2101.6720, '2015-02-06 11:16:54', 'dbo', ''),
(2014100037, 201410, 4, 37, '2015-02-04', 256, 'ENERGY', 116, 101, '2014-10-20', '2014-09-20', '2015-02-11', 15, 3818.0440, 0.0000, 840.1300, 4658.1740, '2015-02-06 11:16:54', 'dbo', ''),
(2014100038, 201410, 4, 38, '2015-02-04', 257, 'ENERGY', 31, 31, '2014-10-20', '2014-09-20', '2015-02-11', 0, 1610.5100, 0.0000, 290.0000, 1900.5100, '2015-02-06 11:16:54', 'dbo', ''),
(2014100039, 201410, 4, 39, '2015-02-04', 258, 'ENERGY', 42, 41, '2014-10-20', '2014-09-20', '2015-02-11', 1, 1086.3610, 0.0000, 326.6700, 1413.0310, '2015-02-06 11:16:54', 'dbo', ''),
(2014100040, 201410, 4, 40, '2015-02-04', 259, 'ENERGY', 54, 54, '2014-10-20', '2014-09-20', '2015-02-11', 0, 1520.5220, 0.0000, 290.0000, 1810.5220, '2015-02-06 11:16:54', 'dbo', ''),
(2014100041, 201410, 4, 41, '2015-02-04', 260, 'ENERGY', 57, 54, '2014-10-20', '2014-09-20', '2015-02-11', 3, 2630.2600, 0.0000, 400.0300, 3030.2900, '2015-02-06 11:16:54', 'dbo', ''),
(2014100042, 201410, 4, 42, '2015-02-04', 261, 'ENERGY', 42, 42, '2014-10-20', '2014-09-20', '2015-02-11', 0, 1388.3960, 0.0000, 290.0000, 1678.3960, '2015-02-06 11:16:54', 'dbo', ''),
(2014100043, 201410, 4, 43, '2015-02-04', 262, 'ENERGY', 3064, 1458, '2014-10-20', '2014-09-20', '2015-02-11', 1606, 61037.3770, 0.0000, 59189.8900, 120227.2670, '2015-02-06 11:16:54', 'dbo', ''),
(2014100044, 201410, 4, 44, '2015-02-04', 263, 'ENERGY', 55, 52, '2014-10-20', '2014-09-20', '2015-02-11', 3, 2415.2360, 0.0000, 400.0300, 2815.2660, '2015-02-06 11:16:54', 'dbo', ''),
(2014100045, 201410, 4, 45, '2015-02-04', 264, 'ENERGY', 6307, 5256, '2014-10-20', '2014-09-20', '2015-02-11', 1051, 220855.7100, 0.0000, 38835.3200, 259691.0300, '2015-02-06 11:16:54', 'dbo', ''),
(2014100046, 201410, 4, 46, '2015-02-04', 265, 'ENERGY', 4567, 3639, '2014-10-20', '2014-09-20', '2015-02-11', 928, 155398.5330, 0.0000, 34324.3100, 189722.8430, '2015-02-06 11:16:54', 'dbo', ''),
(2014100047, 201410, 4, 47, '2015-02-04', 266, 'ENERGY', 3748, 3231, '2014-10-20', '2014-09-20', '2015-02-11', 517, 125209.1830, 0.0000, 19250.9200, 144460.1030, '2015-02-06 11:16:54', 'dbo', ''),
(2014100048, 201410, 4, 48, '2015-02-04', 267, 'ENERGY', 85, 78, '2014-10-20', '2014-09-20', '2015-02-11', 7, 2602.1700, 0.0000, 546.7300, 3148.9000, '2015-02-06 11:16:54', 'dbo', ''),
(2014100049, 201410, 4, 49, '2015-02-04', 268, 'ENERGY', 56, 41, '2014-10-20', '2014-09-20', '2015-02-11', 15, 1122.7660, 0.0000, 840.1300, 1962.8960, '2015-02-06 11:16:54', 'dbo', ''),
(2014100050, 201410, 4, 50, '2015-02-04', 269, 'ENERGY', 38, 38, '2014-10-20', '2014-09-20', '2015-02-11', 0, 1131.3600, 0.0000, 290.0000, 1421.3600, '2015-02-06 11:16:54', 'dbo', ''),
(2014100051, 201410, 4, 51, '2015-02-04', 270, 'ENERGY', 211, 189, '2014-10-20', '2014-09-20', '2015-02-11', 22, 7313.2890, 0.0000, 1096.8500, 8410.1390, '2015-02-06 11:16:54', 'dbo', ''),
(2014100052, 201410, 4, 52, '2015-02-04', 271, 'ENERGY', 89, 86, '2014-10-20', '2014-09-20', '2015-02-11', 3, 1840.3720, 0.0000, 400.0300, 2240.4020, '2015-02-06 11:16:54', 'dbo', ''),
(2014100053, 201410, 4, 53, '2015-02-04', 272, 'ENERGY', 62, 60, '2014-10-20', '2014-09-20', '2015-02-11', 2, 2529.3970, 0.0000, 363.3500, 2892.7470, '2015-02-06 11:16:54', 'dbo', ''),
(2014100054, 201410, 4, 54, '2015-02-04', 273, 'ENERGY', 1805, 970, '2014-10-20', '2014-09-20', '2015-02-11', 835, 39167.7550, 0.0000, 30913.5400, 70081.2950, '2015-02-06 11:16:54', 'dbo', ''),
(2014100055, 201410, 4, 55, '2015-02-04', 274, 'ENERGY', 56, 56, '2014-10-20', '2014-09-20', '2015-02-11', 0, 1392.7100, 0.0000, 290.0000, 1682.7100, '2015-02-06 11:16:54', 'dbo', ''),
(2014100056, 201410, 4, 56, '2015-02-04', 275, 'ENERGY', 58, 48, '2014-10-20', '2014-09-20', '2015-02-11', 10, 1423.3890, 0.0000, 656.7500, 2080.1390, '2015-02-06 11:16:54', 'dbo', ''),
(2014100059, 201410, 4, 59, '2015-02-04', 278, 'ENERGY', 1, 1, '2014-10-20', '2014-09-20', '2015-02-11', 0, 870.0000, 0.0000, 290.0000, 1160.0000, '2015-02-06 11:16:54', 'dbo', ''),
(2014100060, 201410, 4, 60, '2015-02-04', 279, 'ENERGY', 2, 2, '2014-10-20', '2014-09-20', '2015-02-11', 0, 870.0000, 0.0000, 290.0000, 1160.0000, '2015-02-06 11:16:54', 'dbo', ''),
(2014100061, 201410, 4, 61, '2015-02-04', 280, 'ENERGY', 3, 3, '2014-10-20', '2014-09-20', '2015-02-11', 0, 870.0000, 0.0000, 290.0000, 1160.0000, '2015-02-06 11:16:54', 'dbo', ''),
(2014100062, 201410, 4, 62, '2015-02-04', 281, 'ENERGY', 30, 30, '2014-10-20', '2014-09-20', '2015-02-11', 0, 870.0000, 0.0000, 290.0000, 1160.0000, '2015-02-06 11:16:54', 'dbo', ''),
(2014100063, 201410, 4, 63, '2015-02-04', 282, 'ENERGY', 1, 1, '2014-10-20', '2014-09-20', '2015-02-11', 0, 870.0000, 0.0000, 290.0000, 1160.0000, '2015-02-06 11:16:54', 'dbo', ''),
(2014100064, 201410, 4, 64, '2015-02-04', 283, 'ENERGY', 2, 2, '2014-10-20', '2014-09-20', '2015-02-11', 0, 870.0000, 0.0000, 290.0000, 1160.0000, '2015-02-06 11:16:54', 'dbo', ''),
(2014100065, 201410, 4, 65, '2015-02-04', 284, 'ENERGY', 10, 10, '2014-10-20', '2014-09-20', '2015-02-11', 0, 1129.1880, 0.0000, 290.0000, 1419.1880, '2015-02-06 11:16:54', 'dbo', ''),
(2014100066, 201410, 4, 66, '2015-02-04', 285, 'ENERGY', 7, 6, '2014-10-20', '2014-09-20', '2015-02-11', 1, 957.1100, 0.0000, 326.6700, 1283.7800, '2015-02-06 11:16:54', 'dbo', ''),
(2014100067, 201410, 4, 67, '2015-02-04', 286, 'ENERGY', 64, 64, '2014-10-20', '2014-09-20', '2015-02-11', 0, 3483.5700, 0.0000, 290.0000, 3773.5700, '2015-02-06 11:16:54', 'dbo', '');
INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2014100068, 201410, 4, 68, '2015-02-04', 287, 'ENERGY', 17, 17, '2014-10-20', '2014-09-20', '2015-02-11', 0, 1218.4700, 0.0000, 290.0000, 1508.4700, '2015-02-06 11:16:54', 'dbo', ''),
(2014100069, 201410, 4, 69, '2015-02-04', 288, 'ENERGY', 1, 1, '2014-10-20', '2014-09-20', '2015-02-11', 0, 870.0000, 0.0000, 290.0000, 1160.0000, '2015-02-06 11:16:54', 'dbo', ''),
(2014100070, 201410, 4, 70, '2015-02-04', 289, 'ENERGY', 41, 41, '2014-10-20', '2014-09-20', '2015-02-11', 0, 1828.3100, 0.0000, 290.0000, 2118.3100, '2015-02-06 11:16:54', 'dbo', ''),
(2014100071, 201410, 4, 71, '2015-02-04', 290, 'ENERGY', 75, 54, '2014-10-20', '2014-09-20', '2015-02-11', 21, 2277.1420, 0.0000, 1060.1700, 3337.3120, '2015-02-06 11:16:54', 'dbo', ''),
(2014100072, 201410, 4, 72, '2015-02-04', 291, 'ENERGY', 31, 31, '2014-10-20', '2014-09-20', '2015-02-11', 0, 870.0000, 0.0000, 290.0000, 1160.0000, '2015-02-06 11:16:54', 'dbo', ''),
(2014100073, 201410, 4, 73, '2015-02-04', 292, 'ENERGY', 238, 233, '2014-10-20', '2014-09-20', '2015-02-11', 5, 10992.7710, 0.0000, 473.3700, 11466.1410, '2015-02-06 11:16:54', 'dbo', ''),
(2014110001, 201411, 5, 1, '2015-02-18', 293, 'ENERGY', 71, 71, '2014-11-20', '2014-10-20', '2015-02-25', 0, 2552.4610, 0.0000, 290.0000, 2842.4610, '2015-02-18 17:27:04', 'dbo', ''),
(2014110002, 201411, 5, 2, '2015-02-18', 294, 'ENERGY', 161, 159, '2014-11-20', '2014-10-20', '2015-02-25', 2, 5472.9210, 0.0000, 364.4600, 5837.3810, '2015-02-18 17:27:04', 'dbo', ''),
(2014110003, 201411, 5, 3, '2015-02-18', 295, 'ENERGY', 52, 51, '2014-11-20', '2014-10-20', '2015-02-25', 1, 1588.7000, 0.0000, 327.2300, 1915.9300, '2015-02-18 17:27:04', 'dbo', ''),
(2014110004, 201411, 5, 4, '2015-02-18', 296, 'ENERGY', 105, 105, '2014-11-20', '2014-10-20', '2015-02-25', 0, 2642.6680, 0.0000, 290.0000, 2932.6680, '2015-02-18 17:27:04', 'dbo', ''),
(2014110005, 201411, 5, 5, '2015-02-18', 297, 'ENERGY', 84, 83, '2014-11-20', '2014-10-20', '2015-02-25', 1, 2691.6210, 0.0000, 327.2300, 3018.8510, '2015-02-18 17:27:04', 'dbo', ''),
(2014110006, 201411, 5, 6, '2015-02-18', 298, 'ENERGY', 57, 57, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1811.0100, 0.0000, 290.0000, 2101.0100, '2015-02-18 17:27:04', 'dbo', ''),
(2014110007, 201411, 5, 7, '2015-02-18', 299, 'ENERGY', 65, 64, '2014-11-20', '2014-10-20', '2015-02-25', 1, 2471.2900, 0.0000, 327.2300, 2798.5200, '2015-02-18 17:27:04', 'dbo', ''),
(2014110008, 201411, 5, 8, '2015-02-18', 300, 'ENERGY', 54, 53, '2014-11-20', '2014-10-20', '2015-02-25', 1, 1437.3800, 0.0000, 327.2300, 1764.6100, '2015-02-18 17:27:04', 'dbo', ''),
(2014110009, 201411, 5, 9, '2015-02-18', 301, 'ENERGY', 46, 43, '2014-11-20', '2014-10-20', '2015-02-25', 3, 1542.7030, 0.0000, 401.7000, 1944.4030, '2015-02-18 17:27:04', 'dbo', ''),
(2014110010, 201411, 5, 10, '2015-02-18', 302, 'ENERGY', 32, 32, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1368.7380, 0.0000, 290.0000, 1658.7380, '2015-02-18 17:27:04', 'dbo', ''),
(2014110011, 201411, 5, 11, '2015-02-18', 303, 'ENERGY', 109, 109, '2014-11-20', '2014-10-20', '2015-02-25', 0, 4336.1110, 0.0000, 290.0000, 4626.1110, '2015-02-18 17:27:04', 'dbo', ''),
(2014110012, 201411, 5, 12, '2015-02-18', 304, 'ENERGY', 36, 33, '2014-11-20', '2014-10-20', '2015-02-25', 3, 1247.1100, 0.0000, 401.7000, 1648.8100, '2015-02-18 17:27:04', 'dbo', ''),
(2014110013, 201411, 5, 13, '2015-02-18', 305, 'ENERGY', 77, 77, '2014-11-20', '2014-10-20', '2015-02-25', 0, 2932.5540, 0.0000, 290.0000, 3222.5540, '2015-02-18 17:27:04', 'dbo', ''),
(2014110014, 201411, 5, 14, '2015-02-18', 306, 'ENERGY', 84, 84, '2014-11-20', '2014-10-20', '2015-02-25', 0, 2957.9170, 0.0000, 290.0000, 3247.9170, '2015-02-18 17:27:04', 'dbo', ''),
(2014110015, 201411, 5, 15, '2015-02-18', 307, 'ENERGY', 73, 73, '2014-11-20', '2014-10-20', '2015-02-25', 0, 2311.8490, 0.0000, 290.0000, 2601.8490, '2015-02-18 17:27:04', 'dbo', ''),
(2014110016, 201411, 5, 16, '2015-02-18', 308, 'ENERGY', 60, 60, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1892.4620, 0.0000, 290.0000, 2182.4620, '2015-02-18 17:27:04', 'dbo', ''),
(2014110017, 201411, 5, 17, '2015-02-18', 309, 'ENERGY', 38, 38, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1960.2070, 0.0000, 290.0000, 2250.2070, '2015-02-18 17:27:04', 'dbo', ''),
(2014110018, 201411, 5, 18, '2015-02-18', 310, 'ENERGY', 44, 44, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1595.6000, 0.0000, 290.0000, 1885.6000, '2015-02-18 17:27:04', 'dbo', ''),
(2014110019, 201411, 5, 19, '2015-02-18', 311, 'ENERGY', 59, 59, '2014-11-20', '2014-10-20', '2015-02-25', 0, 2718.0650, 0.0000, 290.0000, 3008.0650, '2015-02-18 17:27:04', 'dbo', ''),
(2014110020, 201411, 5, 20, '2015-02-18', 312, 'ENERGY', 101, 101, '2014-11-20', '2014-10-20', '2015-02-25', 0, 3999.9330, 0.0000, 290.0000, 4289.9330, '2015-02-18 17:27:04', 'dbo', ''),
(2014110021, 201411, 5, 21, '2015-02-18', 313, 'ENERGY', 10566, 9528, '2014-11-20', '2014-10-20', '2015-02-25', 1038, 353308.8100, 0.0000, 38936.5000, 392245.3100, '2015-02-18 17:27:04', 'dbo', ''),
(2014110022, 201411, 5, 22, '2015-02-18', 314, 'ENERGY', 6695, 6017, '2014-11-20', '2014-10-20', '2015-02-25', 678, 218223.9770, 0.0000, 25533.0900, 243757.0670, '2015-02-18 17:27:04', 'dbo', ''),
(2014110023, 201411, 5, 23, '2015-02-18', 315, 'ENERGY', 14834, 13164, '2014-11-20', '2014-10-20', '2015-02-25', 1670, 518920.9490, 0.0000, 62466.9300, 581387.8790, '2015-02-18 17:27:04', 'dbo', ''),
(2014110024, 201411, 5, 24, '2015-02-18', 316, 'ENERGY', 12675, 11306, '2014-11-20', '2014-10-20', '2015-02-25', 1369, 449561.8620, 0.0000, 51260.1900, 500822.0520, '2015-02-18 17:27:04', 'dbo', ''),
(2014110025, 201411, 5, 25, '2015-02-18', 317, 'ENERGY', 44, 41, '2014-11-20', '2014-10-20', '2015-02-25', 3, 1517.6100, 0.0000, 401.7000, 1919.3100, '2015-02-18 17:27:04', 'dbo', ''),
(2014110026, 201411, 5, 26, '2015-02-18', 318, 'ENERGY', 1049, 222, '2014-11-20', '2014-10-20', '2015-02-25', 827, 8191.4320, 0.0000, 31080.6200, 39272.0520, '2015-02-18 17:27:04', 'dbo', ''),
(2014110029, 201411, 5, 29, '2015-02-18', 321, 'ENERGY', 19007, 16690, '2014-11-20', '2014-10-20', '2015-02-25', 2317, 642000.1060, 0.0000, 86555.8500, 728555.9560, '2015-02-18 17:27:04', 'dbo', ''),
(2014110030, 201411, 5, 30, '2015-02-18', 322, 'ENERGY', 7194, 6458, '2014-11-20', '2014-10-20', '2015-02-25', 736, 237756.9310, 0.0000, 27692.5300, 265449.4610, '2015-02-18 17:27:04', 'dbo', ''),
(2014110031, 201411, 5, 31, '2015-02-18', 323, 'ENERGY', 65, 65, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1856.9600, 0.0000, 290.0000, 2146.9600, '2015-02-18 17:27:04', 'dbo', ''),
(2014110032, 201411, 5, 32, '2015-02-18', 324, 'ENERGY', 64, 55, '2014-11-20', '2014-10-20', '2015-02-25', 9, 2003.1200, 0.0000, 625.0800, 2628.2000, '2015-02-18 17:27:04', 'dbo', ''),
(2014110033, 201411, 5, 33, '2015-02-18', 325, 'ENERGY', 56, 56, '2014-11-20', '2014-10-20', '2015-02-25', 0, 2982.5400, 0.0000, 290.0000, 3272.5400, '2015-02-18 17:27:04', 'dbo', ''),
(2014110034, 201411, 5, 34, '2015-02-18', 326, 'ENERGY', 25, 25, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1737.9930, 0.0000, 290.0000, 2027.9930, '2015-02-18 17:27:04', 'dbo', ''),
(2014110035, 201411, 5, 35, '2015-02-18', 327, 'ENERGY', 335, 311, '2014-11-20', '2014-10-20', '2015-02-25', 24, 10842.0900, 0.0000, 1183.5600, 12025.6500, '2015-02-18 17:27:04', 'dbo', ''),
(2014110036, 201411, 5, 36, '2015-02-18', 328, 'ENERGY', 64, 61, '2014-11-20', '2014-10-20', '2015-02-25', 3, 2101.6720, 0.0000, 401.7000, 2503.3720, '2015-02-18 17:27:04', 'dbo', ''),
(2014110037, 201411, 5, 37, '2015-02-18', 329, 'ENERGY', 116, 116, '2014-11-20', '2014-10-20', '2015-02-25', 0, 4658.1740, 0.0000, 290.0000, 4948.1740, '2015-02-18 17:27:04', 'dbo', ''),
(2014110038, 201411, 5, 38, '2015-02-18', 330, 'ENERGY', 33, 31, '2014-11-20', '2014-10-20', '2015-02-25', 2, 1900.5100, 0.0000, 364.4600, 2264.9700, '2015-02-18 17:27:04', 'dbo', ''),
(2014110039, 201411, 5, 39, '2015-02-18', 331, 'ENERGY', 43, 42, '2014-11-20', '2014-10-20', '2015-02-25', 1, 1413.0310, 0.0000, 327.2300, 1740.2610, '2015-02-18 17:27:04', 'dbo', ''),
(2014110040, 201411, 5, 40, '2015-02-18', 332, 'ENERGY', 57, 54, '2014-11-20', '2014-10-20', '2015-02-25', 3, 1810.5220, 0.0000, 401.7000, 2212.2220, '2015-02-18 17:27:04', 'dbo', ''),
(2014110041, 201411, 5, 41, '2015-02-18', 333, 'ENERGY', 57, 57, '2014-11-20', '2014-10-20', '2015-02-25', 0, 3030.2900, 0.0000, 290.0000, 3320.2900, '2015-02-18 17:27:04', 'dbo', ''),
(2014110042, 201411, 5, 42, '2015-02-18', 334, 'ENERGY', 42, 42, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1678.3960, 0.0000, 290.0000, 1968.3960, '2015-02-18 17:27:04', 'dbo', ''),
(2014110043, 201411, 5, 43, '2015-02-18', 335, 'ENERGY', 4864, 3064, '2014-11-20', '2014-10-20', '2015-02-25', 1800, 120227.2670, 0.0000, 67307.0600, 187534.3270, '2015-02-18 17:27:04', 'dbo', ''),
(2014110044, 201411, 5, 44, '2015-02-18', 336, 'ENERGY', 88, 55, '2014-11-20', '2014-10-20', '2015-02-25', 33, 2815.2660, 0.0000, 1518.6400, 4333.9060, '2015-02-18 17:27:04', 'dbo', ''),
(2014110045, 201411, 5, 45, '2015-02-18', 337, 'ENERGY', 7292, 6307, '2014-11-20', '2014-10-20', '2015-02-25', 985, 259691.0300, 0.0000, 36963.2200, 296654.2500, '2015-02-18 17:27:04', 'dbo', ''),
(2014110046, 201411, 5, 46, '2015-02-18', 338, 'ENERGY', 5695, 4567, '2014-11-20', '2014-10-20', '2015-02-25', 1128, 189722.8430, 0.0000, 42287.3600, 232010.2030, '2015-02-18 17:27:04', 'dbo', ''),
(2014110047, 201411, 5, 47, '2015-02-18', 339, 'ENERGY', 4279, 3748, '2014-11-20', '2014-10-20', '2015-02-25', 531, 144460.1030, 0.0000, 20060.0400, 164520.1430, '2015-02-18 17:27:04', 'dbo', ''),
(2014110048, 201411, 5, 48, '2015-02-18', 340, 'ENERGY', 85, 85, '2014-11-20', '2014-10-20', '2015-02-25', 0, 3148.9000, 0.0000, 290.0000, 3438.9000, '2015-02-18 17:27:04', 'dbo', ''),
(2014110049, 201411, 5, 49, '2015-02-18', 341, 'ENERGY', 132, 56, '2014-11-20', '2014-10-20', '2015-02-25', 76, 1962.8960, 0.0000, 3119.6100, 5082.5060, '2015-02-18 17:27:04', 'dbo', ''),
(2014110050, 201411, 5, 50, '2015-02-18', 342, 'ENERGY', 38, 38, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1421.3600, 0.0000, 290.0000, 1711.3600, '2015-02-18 17:27:04', 'dbo', ''),
(2014110051, 201411, 5, 51, '2015-02-18', 343, 'ENERGY', 211, 211, '2014-11-20', '2014-10-20', '2015-02-25', 0, 8410.1390, 0.0000, 290.0000, 8700.1390, '2015-02-18 17:27:04', 'dbo', ''),
(2014110052, 201411, 5, 52, '2015-02-18', 344, 'ENERGY', 92, 89, '2014-11-20', '2014-10-20', '2015-02-25', 3, 2240.4020, 0.0000, 401.7000, 2642.1020, '2015-02-18 17:27:04', 'dbo', ''),
(2014110053, 201411, 5, 53, '2015-02-18', 345, 'ENERGY', 62, 62, '2014-11-20', '2014-10-20', '2015-02-25', 0, 2892.7470, 0.0000, 290.0000, 3182.7470, '2015-02-18 17:27:04', 'dbo', ''),
(2014110054, 201411, 5, 54, '2015-02-18', 346, 'ENERGY', 2442, 1805, '2014-11-20', '2014-10-20', '2015-02-25', 637, 70081.2950, 0.0000, 24006.5900, 94087.8850, '2015-02-18 17:27:04', 'dbo', ''),
(2014110055, 201411, 5, 55, '2015-02-18', 347, 'ENERGY', 59, 56, '2014-11-20', '2014-10-20', '2015-02-25', 3, 1682.7100, 0.0000, 401.7000, 2084.4100, '2015-02-18 17:27:04', 'dbo', ''),
(2014110056, 201411, 5, 56, '2015-02-18', 348, 'ENERGY', 58, 58, '2014-11-20', '2014-10-20', '2015-02-25', 0, 2080.1390, 0.0000, 290.0000, 2370.1390, '2015-02-18 17:27:04', 'dbo', ''),
(2014110059, 201411, 5, 59, '2015-02-18', 351, 'ENERGY', 1, 1, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1160.0000, 0.0000, 290.0000, 1450.0000, '2015-02-18 17:27:04', 'dbo', ''),
(2014110060, 201411, 5, 60, '2015-02-18', 352, 'ENERGY', 2, 2, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1160.0000, 0.0000, 290.0000, 1450.0000, '2015-02-18 17:27:04', 'dbo', ''),
(2014110061, 201411, 5, 61, '2015-02-18', 353, 'ENERGY', 3, 3, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1160.0000, 0.0000, 290.0000, 1450.0000, '2015-02-18 17:27:04', 'dbo', ''),
(2014110062, 201411, 5, 62, '2015-02-18', 354, 'ENERGY', 30, 30, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1160.0000, 0.0000, 290.0000, 1450.0000, '2015-02-18 17:27:04', 'dbo', ''),
(2014110063, 201411, 5, 63, '2015-02-18', 355, 'ENERGY', 1, 1, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1160.0000, 0.0000, 290.0000, 1450.0000, '2015-02-18 17:27:04', 'dbo', ''),
(2014110064, 201411, 5, 64, '2015-02-18', 356, 'ENERGY', 2, 2, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1160.0000, 0.0000, 290.0000, 1450.0000, '2015-02-18 17:27:04', 'dbo', ''),
(2014110065, 201411, 5, 65, '2015-02-18', 357, 'ENERGY', 10, 10, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1419.1880, 0.0000, 290.0000, 1709.1880, '2015-02-18 17:27:04', 'dbo', ''),
(2014110066, 201411, 5, 66, '2015-02-18', 358, 'ENERGY', 7, 7, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1283.7800, 0.0000, 290.0000, 1573.7800, '2015-02-18 17:27:04', 'dbo', ''),
(2014110067, 201411, 5, 67, '2015-02-18', 359, 'ENERGY', 64, 64, '2014-11-20', '2014-10-20', '2015-02-25', 0, 3773.5700, 0.0000, 290.0000, 4063.5700, '2015-02-18 17:27:04', 'dbo', ''),
(2014110068, 201411, 5, 68, '2015-02-18', 360, 'ENERGY', 17, 17, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1508.4700, 0.0000, 290.0000, 1798.4700, '2015-02-18 17:27:04', 'dbo', ''),
(2014110069, 201411, 5, 69, '2015-02-18', 361, 'ENERGY', 1, 1, '2014-11-20', '2014-10-20', '2015-02-25', 0, 1160.0000, 0.0000, 290.0000, 1450.0000, '2015-02-18 17:27:04', 'dbo', ''),
(2014110070, 201411, 5, 70, '2015-02-18', 362, 'ENERGY', 41, 41, '2014-11-20', '2014-10-20', '2015-02-25', 0, 2118.3100, 0.0000, 290.0000, 2408.3100, '2015-02-18 17:27:04', 'dbo', ''),
(2014110071, 201411, 5, 71, '2015-02-18', 363, 'ENERGY', 88, 75, '2014-11-20', '2014-10-20', '2015-02-25', 13, 3337.3120, 0.0000, 774.0100, 4111.3220, '2015-02-18 17:27:04', 'dbo', ''),
(2014110072, 201411, 5, 72, '2015-02-18', 364, 'ENERGY', 32, 31, '2014-11-20', '2014-10-20', '2015-02-25', 1, 1160.0000, 0.0000, 327.2300, 1487.2300, '2015-02-18 17:27:04', 'dbo', ''),
(2014110073, 201411, 5, 73, '2015-02-18', 365, 'ENERGY', 243, 238, '2014-11-20', '2014-10-20', '2015-02-25', 5, 11466.1410, 0.0000, 476.1600, 11942.3010, '2015-02-18 17:27:04', 'dbo', ''),
(2014120001, 201412, 6, 1, '2015-02-18', 366, 'ENERGY', 77, 71, '2014-12-20', '2014-11-20', '2015-02-25', 6, 2842.4610, 0.0000, 471.9404, 3314.4014, '2015-02-18 17:49:48', 'dbo', ''),
(2014120002, 201412, 6, 2, '2015-02-18', 367, 'ENERGY', 161, 161, '2014-12-20', '2014-11-20', '2015-02-25', 0, 5837.3810, 0.0000, 290.0000, 6127.3810, '2015-02-18 17:49:48', 'dbo', ''),
(2014120003, 201412, 6, 3, '2015-02-18', 368, 'ENERGY', 53, 52, '2014-12-20', '2014-11-20', '2015-02-25', 1, 1915.9300, 0.0000, 320.3234, 2236.2534, '2015-02-18 17:49:48', 'dbo', ''),
(2014120004, 201412, 6, 4, '2015-02-18', 369, 'ENERGY', 118, 105, '2014-12-20', '2014-11-20', '2015-02-25', 13, 2932.6680, 0.0000, 684.1842, 3616.8522, '2015-02-18 17:49:48', 'dbo', ''),
(2014120005, 201412, 6, 5, '2015-02-18', 370, 'ENERGY', 98, 84, '2014-12-20', '2014-11-20', '2015-02-25', 14, 3018.8510, 0.0000, 714.5176, 3733.3686, '2015-02-18 17:49:48', 'dbo', ''),
(2014120006, 201412, 6, 6, '2015-02-18', 371, 'ENERGY', 59, 57, '2014-12-20', '2014-11-20', '2015-02-25', 2, 2101.0100, 0.0000, 350.6468, 2451.6568, '2015-02-18 17:49:48', 'dbo', ''),
(2014120007, 201412, 6, 7, '2015-02-18', 372, 'ENERGY', 65, 65, '2014-12-20', '2014-11-20', '2015-02-25', 0, 2798.5200, 0.0000, 290.0000, 3088.5200, '2015-02-18 17:49:48', 'dbo', ''),
(2014120008, 201412, 6, 8, '2015-02-18', 373, 'ENERGY', 118, 54, '2014-12-20', '2014-11-20', '2015-02-25', 64, 1764.6100, 0.0000, 2230.6076, 3995.2176, '2015-02-18 17:49:48', 'dbo', ''),
(2014120009, 201412, 6, 9, '2015-02-18', 374, 'ENERGY', 47, 46, '2014-12-20', '2014-11-20', '2015-02-25', 1, 1944.4030, 0.0000, 320.3234, 2264.7264, '2015-02-18 17:49:48', 'dbo', ''),
(2014120010, 201412, 6, 10, '2015-02-18', 375, 'ENERGY', 32, 32, '2014-12-20', '2014-11-20', '2015-02-25', 0, 1658.7380, 0.0000, 290.0000, 1948.7380, '2015-02-18 17:49:48', 'dbo', ''),
(2014120011, 201412, 6, 11, '2015-02-18', 376, 'ENERGY', 109, 109, '2014-12-20', '2014-11-20', '2015-02-25', 0, 4626.1110, 0.0000, 290.0000, 4916.1110, '2015-02-18 17:49:48', 'dbo', ''),
(2014120012, 201412, 6, 12, '2015-02-18', 377, 'ENERGY', 36, 36, '2014-12-20', '2014-11-20', '2015-02-25', 0, 1648.8100, 0.0000, 290.0000, 1938.8100, '2015-02-18 17:49:48', 'dbo', ''),
(2014120013, 201412, 6, 13, '2015-02-18', 378, 'ENERGY', 77, 77, '2014-12-20', '2014-11-20', '2015-02-25', 0, 3222.5540, 0.0000, 290.0000, 3512.5540, '2015-02-18 17:49:48', 'dbo', ''),
(2014120014, 201412, 6, 14, '2015-02-18', 379, 'ENERGY', 110, 84, '2014-12-20', '2014-11-20', '2015-02-25', 26, 3247.9170, 0.0000, 1078.3784, 4326.2954, '2015-02-18 17:49:48', 'dbo', ''),
(2014120015, 201412, 6, 15, '2015-02-18', 380, 'ENERGY', 73, 73, '2014-12-20', '2014-11-20', '2015-02-25', 0, 2601.8490, 0.0000, 290.0000, 2891.8490, '2015-02-18 17:49:48', 'dbo', ''),
(2014120016, 201412, 6, 16, '2015-02-18', 381, 'ENERGY', 60, 60, '2014-12-20', '2014-11-20', '2015-02-25', 0, 2182.4620, 0.0000, 290.0000, 2472.4620, '2015-02-18 17:49:48', 'dbo', ''),
(2014120017, 201412, 6, 17, '2015-02-18', 382, 'ENERGY', 38, 38, '2014-12-20', '2014-11-20', '2015-02-25', 0, 2250.2070, 0.0000, 290.0000, 2540.2070, '2015-02-18 17:49:48', 'dbo', ''),
(2014120018, 201412, 6, 18, '2015-02-18', 383, 'ENERGY', 44, 44, '2014-12-20', '2014-11-20', '2015-02-25', 0, 1885.6000, 0.0000, 290.0000, 2175.6000, '2015-02-18 17:49:48', 'dbo', ''),
(2014120019, 201412, 6, 19, '2015-02-18', 384, 'ENERGY', 59, 59, '2014-12-20', '2014-11-20', '2015-02-25', 0, 3008.0650, 0.0000, 290.0000, 3298.0650, '2015-02-18 17:49:48', 'dbo', ''),
(2014120020, 201412, 6, 20, '2015-02-18', 385, 'ENERGY', 101, 101, '2014-12-20', '2014-11-20', '2015-02-25', 0, 4289.9330, 0.0000, 290.0000, 4579.9330, '2015-02-18 17:49:48', 'dbo', ''),
(2014120021, 201412, 6, 21, '2015-02-18', 386, 'ENERGY', 11635, 10566, '2014-12-20', '2014-11-20', '2015-02-25', 1069, 392245.3100, 0.0000, 32704.2646, 424949.5746, '2015-02-18 17:49:48', 'dbo', ''),
(2014120022, 201412, 6, 22, '2015-02-18', 387, 'ENERGY', 7264, 6695, '2014-12-20', '2014-11-20', '2015-02-25', 569, 243757.0670, 0.0000, 17543.2446, 261300.3116, '2015-02-18 17:49:48', 'dbo', ''),
(2014120023, 201412, 6, 23, '2015-02-18', 388, 'ENERGY', 16554, 14834, '2014-12-20', '2014-11-20', '2015-02-25', 1720, 581387.8790, 0.0000, 52443.9180, 633831.7970, '2015-02-18 17:49:48', 'dbo', ''),
(2014120024, 201412, 6, 24, '2015-02-18', 389, 'ENERGY', 13895, 12675, '2014-12-20', '2014-11-20', '2015-02-25', 1220, 500822.0520, 0.0000, 37282.8980, 538104.9500, '2015-02-18 17:49:48', 'dbo', ''),
(2014120025, 201412, 6, 25, '2015-02-18', 390, 'ENERGY', 44, 44, '2014-12-20', '2014-11-20', '2015-02-25', 0, 1919.3100, 0.0000, 290.0000, 2209.3100, '2015-02-18 17:49:48', 'dbo', ''),
(2014120026, 201412, 6, 26, '2015-02-18', 391, 'ENERGY', 2380, 1049, '2014-12-20', '2014-11-20', '2015-02-25', 1331, 39272.0520, 0.0000, 40648.6454, 79920.6974, '2015-02-18 17:49:48', 'dbo', ''),
(2014120029, 201412, 6, 29, '2015-02-18', 394, 'ENERGY', 21399, 19007, '2014-12-20', '2014-11-20', '2015-02-25', 2392, 728555.9560, 0.0000, 72820.3328, 801376.2888, '2015-02-18 17:49:48', 'dbo', ''),
(2014120030, 201412, 6, 30, '2015-02-18', 395, 'ENERGY', 7947, 7194, '2014-12-20', '2014-11-20', '2015-02-25', 753, 265449.4610, 0.0000, 23122.5002, 288571.9612, '2015-02-18 17:49:48', 'dbo', ''),
(2014120031, 201412, 6, 31, '2015-02-18', 396, 'ENERGY', 335, 65, '2014-12-20', '2014-11-20', '2015-02-25', 270, 2146.9600, 0.0000, 8476.9580, 10623.9180, '2015-02-18 17:49:48', 'dbo', ''),
(2014120032, 201412, 6, 32, '2015-02-18', 397, 'ENERGY', 699, 64, '2014-12-20', '2014-11-20', '2015-02-25', 635, 2628.2000, 0.0000, 19544.4990, 22172.6990, '2015-02-18 17:49:48', 'dbo', ''),
(2014120033, 201412, 6, 33, '2015-02-18', 398, 'ENERGY', 57, 56, '2014-12-20', '2014-11-20', '2015-02-25', 1, 3272.5400, 0.0000, 320.3234, 3592.8634, '2015-02-18 17:49:48', 'dbo', ''),
(2014120034, 201412, 6, 34, '2015-02-18', 399, 'ENERGY', 43, 25, '2014-12-20', '2014-11-20', '2015-02-25', 18, 2027.9930, 0.0000, 835.8012, 2863.7942, '2015-02-18 17:49:48', 'dbo', ''),
(2014120035, 201412, 6, 35, '2015-02-18', 400, 'ENERGY', 374, 335, '2014-12-20', '2014-11-20', '2015-02-25', 39, 12025.6500, 0.0000, 1472.5626, 13498.2126, '2015-02-18 17:49:48', 'dbo', ''),
(2014120036, 201412, 6, 36, '2015-02-18', 401, 'ENERGY', 91, 64, '2014-12-20', '2014-11-20', '2015-02-25', 27, 2503.3720, 0.0000, 1108.7018, 3612.0738, '2015-02-18 17:49:48', 'dbo', ''),
(2014120037, 201412, 6, 37, '2015-02-18', 402, 'ENERGY', 121, 116, '2014-12-20', '2014-11-20', '2015-02-25', 5, 4948.1740, 0.0000, 441.6070, 5389.7810, '2015-02-18 17:49:48', 'dbo', ''),
(2014120038, 201412, 6, 38, '2015-02-18', 403, 'ENERGY', 34, 33, '2014-12-20', '2014-11-20', '2015-02-25', 1, 2264.9700, 0.0000, 320.3234, 2585.2934, '2015-02-18 17:49:48', 'dbo', ''),
(2014120039, 201412, 6, 39, '2015-02-18', 404, 'ENERGY', 51, 43, '2014-12-20', '2014-11-20', '2015-02-25', 8, 1740.2610, 0.0000, 532.5772, 2272.8382, '2015-02-18 17:49:48', 'dbo', ''),
(2014120040, 201412, 6, 40, '2015-02-18', 405, 'ENERGY', 71, 57, '2014-12-20', '2014-11-20', '2015-02-25', 14, 2212.2220, 0.0000, 714.5176, 2926.7396, '2015-02-18 17:49:48', 'dbo', ''),
(2014120041, 201412, 6, 41, '2015-02-18', 406, 'ENERGY', 57, 57, '2014-12-20', '2014-11-20', '2015-02-25', 0, 3320.2900, 0.0000, 290.0000, 3610.2900, '2015-02-18 17:49:48', 'dbo', ''),
(2014120042, 201412, 6, 42, '2015-02-18', 407, 'ENERGY', 42, 42, '2014-12-20', '2014-11-20', '2015-02-25', 0, 1968.3960, 0.0000, 290.0000, 2258.3960, '2015-02-18 17:49:48', 'dbo', ''),
(2014120043, 201412, 6, 43, '2015-02-18', 408, 'ENERGY', 7912, 4864, '2014-12-20', '2014-11-20', '2015-02-25', 3048, 187534.3270, 0.0000, 92711.5932, 280245.9202, '2015-02-18 17:49:48', 'dbo', ''),
(2014120044, 201412, 6, 44, '2015-02-18', 409, 'ENERGY', 93, 88, '2014-12-20', '2014-11-20', '2015-02-25', 5, 4333.9060, 0.0000, 441.6070, 4775.5130, '2015-02-18 17:49:48', 'dbo', ''),
(2014120045, 201412, 6, 45, '2015-02-18', 410, 'ENERGY', 7922, 7292, '2014-12-20', '2014-11-20', '2015-02-25', 630, 296654.2500, 0.0000, 19392.8920, 316047.1420, '2015-02-18 17:49:48', 'dbo', ''),
(2014120046, 201412, 6, 46, '2015-02-18', 411, 'ENERGY', 6531, 5695, '2014-12-20', '2014-11-20', '2015-02-25', 836, 232010.2030, 0.0000, 25639.2324, 257649.4354, '2015-02-18 17:49:48', 'dbo', ''),
(2014120047, 201412, 6, 47, '2015-02-18', 412, 'ENERGY', 4799, 4279, '2014-12-20', '2014-11-20', '2015-02-25', 520, 164520.1430, 0.0000, 16057.4580, 180577.6010, '2015-02-18 17:49:48', 'dbo', ''),
(2014120048, 201412, 6, 48, '2015-02-18', 413, 'ENERGY', 85, 85, '2014-12-20', '2014-11-20', '2015-02-25', 0, 3438.9000, 0.0000, 290.0000, 3728.9000, '2015-02-18 17:49:48', 'dbo', ''),
(2014120049, 201412, 6, 49, '2015-02-18', 414, 'ENERGY', 177, 132, '2014-12-20', '2014-11-20', '2015-02-25', 45, 5082.5060, 0.0000, 1654.4930, 6736.9990, '2015-02-18 17:49:48', 'dbo', ''),
(2014120050, 201412, 6, 50, '2015-02-18', 415, 'ENERGY', 676, 38, '2014-12-20', '2014-11-20', '2015-02-25', 638, 1711.3600, 0.0000, 19635.4692, 21346.8292, '2015-02-18 17:49:48', 'dbo', ''),
(2014120051, 201412, 6, 51, '2015-02-18', 416, 'ENERGY', 211, 211, '2014-12-20', '2014-11-20', '2015-02-25', 0, 8700.1390, 0.0000, 290.0000, 8990.1390, '2015-02-18 17:49:48', 'dbo', ''),
(2014120052, 201412, 6, 52, '2015-02-18', 417, 'ENERGY', 92, 92, '2014-12-20', '2014-11-20', '2015-02-25', 0, 2642.1020, 0.0000, 290.0000, 2932.1020, '2015-02-18 17:49:48', 'dbo', ''),
(2014120053, 201412, 6, 53, '2015-02-18', 418, 'ENERGY', 62, 62, '2014-12-20', '2014-11-20', '2015-02-25', 0, 3182.7470, 0.0000, 290.0000, 3472.7470, '2015-02-18 17:49:48', 'dbo', ''),
(2014120054, 201412, 6, 54, '2015-02-18', 419, 'ENERGY', 3058, 2442, '2014-12-20', '2014-11-20', '2015-02-25', 616, 94087.8850, 0.0000, 18968.3744, 113056.2594, '2015-02-18 17:49:48', 'dbo', ''),
(2014120055, 201412, 6, 55, '2015-02-18', 420, 'ENERGY', 59, 59, '2014-12-20', '2014-11-20', '2015-02-25', 0, 2084.4100, 0.0000, 290.0000, 2374.4100, '2015-02-18 17:49:48', 'dbo', ''),
(2014120056, 201412, 6, 56, '2015-02-18', 421, 'ENERGY', 58, 58, '2014-12-20', '2014-11-20', '2015-02-25', 0, 2370.1390, 0.0000, 290.0000, 2660.1390, '2015-02-18 17:49:48', 'dbo', ''),
(2014120059, 201412, 6, 59, '2015-02-18', 424, 'ENERGY', 1, 1, '2014-12-20', '2014-11-20', '2015-02-25', 0, 1450.0000, 0.0000, 290.0000, 1740.0000, '2015-02-18 17:49:48', 'dbo', ''),
(2014120060, 201412, 6, 60, '2015-02-18', 425, 'ENERGY', 2, 2, '2014-12-20', '2014-11-20', '2015-02-25', 0, 1450.0000, 0.0000, 290.0000, 1740.0000, '2015-02-18 17:49:48', 'dbo', ''),
(2014120061, 201412, 6, 61, '2015-02-18', 426, 'ENERGY', 3, 3, '2014-12-20', '2014-11-20', '2015-02-25', 0, 1450.0000, 0.0000, 290.0000, 1740.0000, '2015-02-18 17:49:48', 'dbo', ''),
(2014120062, 201412, 6, 62, '2015-02-18', 427, 'ENERGY', 30, 30, '2014-12-20', '2014-11-20', '2015-02-25', 0, 1450.0000, 0.0000, 290.0000, 1740.0000, '2015-02-18 17:49:48', 'dbo', ''),
(2014120063, 201412, 6, 63, '2015-02-18', 428, 'ENERGY', 1, 1, '2014-12-20', '2014-11-20', '2015-02-25', 0, 1450.0000, 0.0000, 290.0000, 1740.0000, '2015-02-18 17:49:48', 'dbo', ''),
(2014120064, 201412, 6, 64, '2015-02-18', 429, 'ENERGY', 2, 2, '2014-12-20', '2014-11-20', '2015-02-25', 0, 1450.0000, 0.0000, 290.0000, 1740.0000, '2015-02-18 17:49:48', 'dbo', ''),
(2014120065, 201412, 6, 65, '2015-02-18', 430, 'ENERGY', 10, 10, '2014-12-20', '2014-11-20', '2015-02-25', 0, 1709.1880, 0.0000, 290.0000, 1999.1880, '2015-02-18 17:49:48', 'dbo', ''),
(2014120066, 201412, 6, 66, '2015-02-18', 431, 'ENERGY', 93, 7, '2014-12-20', '2014-11-20', '2015-02-25', 86, 1573.7800, 0.0000, 2897.7024, 4471.4824, '2015-02-18 17:49:48', 'dbo', ''),
(2014120067, 201412, 6, 67, '2015-02-18', 432, 'ENERGY', 71, 64, '2014-12-20', '2014-11-20', '2015-02-25', 7, 4063.5700, 0.0000, 502.2538, 4565.8238, '2015-02-18 17:49:48', 'dbo', ''),
(2014120068, 201412, 6, 68, '2015-02-18', 433, 'ENERGY', 17, 17, '2014-12-20', '2014-11-20', '2015-02-25', 0, 1798.4700, 0.0000, 290.0000, 2088.4700, '2015-02-18 17:49:48', 'dbo', ''),
(2014120069, 201412, 6, 69, '2015-02-18', 434, 'ENERGY', 1, 1, '2014-12-20', '2014-11-20', '2015-02-25', 0, 1450.0000, 0.0000, 290.0000, 1740.0000, '2015-02-18 17:49:48', 'dbo', ''),
(2014120070, 201412, 6, 70, '2015-02-18', 435, 'ENERGY', 41, 41, '2014-12-20', '2014-11-20', '2015-02-25', 0, 2408.3100, 0.0000, 290.0000, 2698.3100, '2015-02-18 17:49:48', 'dbo', ''),
(2014120071, 201412, 6, 71, '2015-02-18', 436, 'ENERGY', 101, 88, '2014-12-20', '2014-11-20', '2015-02-25', 13, 4111.3220, 0.0000, 684.1842, 4795.5062, '2015-02-18 17:49:48', 'dbo', ''),
(2014120072, 201412, 6, 72, '2015-02-18', 437, 'ENERGY', 32, 32, '2014-12-20', '2014-11-20', '2015-02-25', 0, 1487.2300, 0.0000, 290.0000, 1777.2300, '2015-02-18 17:49:48', 'dbo', ''),
(2014120073, 201412, 6, 73, '2015-02-18', 438, 'ENERGY', 248, 243, '2014-12-20', '2014-11-20', '2015-02-25', 5, 11942.3010, 0.0000, 441.6070, 12383.9080, '2015-02-18 17:49:48', 'dbo', ''),
(2015060001, 201506, 7, 1, '2015-08-24', 593, 'ENERGY', 86, 77, '2015-06-20', '2014-12-20', '2015-08-31', 9, 3314.4014, 0.0000, 451.4900, 3765.8914, '2015-08-24 10:00:32', 'dbo', ''),
(2015060002, 201506, 7, 2, '2015-08-24', 594, 'ENERGY', 172, 161, '2015-06-20', '2014-12-20', '2015-08-31', 11, 6127.3810, 0.0000, 487.3800, 6614.7610, '2015-08-24 10:00:32', 'dbo', ''),
(2015060003, 201506, 7, 3, '2015-08-24', 595, 'ENERGY', 66, 53, '2015-06-20', '2014-12-20', '2015-08-31', 13, 2236.2534, 0.0000, 523.2600, 2759.5134, '2015-08-24 10:00:32', 'dbo', ''),
(2015060004, 201506, 7, 4, '2015-08-24', 596, 'ENERGY', 126, 118, '2015-06-20', '2014-12-20', '2015-08-31', 8, 3616.8522, 0.0000, 433.5500, 4050.4022, '2015-08-24 10:00:32', 'dbo', ''),
(2015060005, 201506, 7, 5, '2015-08-24', 597, 'ENERGY', 109, 98, '2015-06-20', '2014-12-20', '2015-08-31', 11, 3733.3686, 0.0000, 487.3800, 4220.7486, '2015-08-24 10:00:32', 'dbo', ''),
(2015060006, 201506, 7, 6, '2015-08-24', 598, 'ENERGY', 70, 59, '2015-06-20', '2014-12-20', '2015-08-31', 11, 2451.6568, 0.0000, 487.3800, 2939.0368, '2015-08-24 10:00:32', 'dbo', ''),
(2015060007, 201506, 7, 7, '2015-08-24', 599, 'ENERGY', 70, 65, '2015-06-20', '2014-12-20', '2015-08-31', 5, 3088.5200, 0.0000, 379.7300, 3468.2500, '2015-08-24 10:00:32', 'dbo', ''),
(2015060008, 201506, 7, 8, '2015-08-24', 600, 'ENERGY', 118, 118, '2015-06-20', '2014-12-20', '2015-08-31', 0, 3995.2176, 0.0000, 290.0000, 4285.2176, '2015-08-24 10:00:32', 'dbo', ''),
(2015060009, 201506, 7, 9, '2015-08-24', 601, 'ENERGY', 62, 47, '2015-06-20', '2014-12-20', '2015-08-31', 15, 2264.7264, 0.0000, 559.1600, 2823.8864, '2015-08-24 10:00:32', 'dbo', ''),
(2015060010, 201506, 7, 10, '2015-08-24', 602, 'ENERGY', 58, 32, '2015-06-20', '2014-12-20', '2015-08-31', 26, 1948.7380, 0.0000, 756.5300, 2705.2680, '2015-08-24 10:00:32', 'dbo', ''),
(2015060011, 201506, 7, 11, '2015-08-24', 603, 'ENERGY', 129, 109, '2015-06-20', '2014-12-20', '2015-08-31', 20, 4916.1110, 0.0000, 648.8600, 5564.9710, '2015-08-24 10:00:32', 'dbo', ''),
(2015060012, 201506, 7, 12, '2015-08-24', 604, 'ENERGY', 42, 36, '2015-06-20', '2014-12-20', '2015-08-31', 6, 1938.8100, 0.0000, 397.6500, 2336.4600, '2015-08-24 10:00:32', 'dbo', ''),
(2015060013, 201506, 7, 13, '2015-08-24', 605, 'ENERGY', 78, 77, '2015-06-20', '2014-12-20', '2015-08-31', 1, 3512.5540, 0.0000, 307.9400, 3820.4940, '2015-08-24 10:00:32', 'dbo', ''),
(2015060014, 201506, 7, 14, '2015-08-24', 606, 'ENERGY', 133, 110, '2015-06-20', '2014-12-20', '2015-08-31', 23, 4326.2954, 0.0000, 702.7000, 5028.9954, '2015-08-24 10:00:32', 'dbo', ''),
(2015060015, 201506, 7, 15, '2015-08-24', 607, 'ENERGY', 106, 73, '2015-06-20', '2014-12-20', '2015-08-31', 33, 2891.8490, 0.0000, 882.1300, 3773.9790, '2015-08-24 10:00:32', 'dbo', ''),
(2015060016, 201506, 7, 16, '2015-08-24', 608, 'ENERGY', 65, 60, '2015-06-20', '2014-12-20', '2015-08-31', 5, 2472.4620, 0.0000, 379.7300, 2852.1920, '2015-08-24 10:00:32', 'dbo', ''),
(2015060017, 201506, 7, 17, '2015-08-24', 609, 'ENERGY', 146, 38, '2015-06-20', '2014-12-20', '2015-08-31', 108, 2540.2070, 0.0000, 2227.8800, 4768.0870, '2015-08-24 10:00:32', 'dbo', ''),
(2015060018, 201506, 7, 18, '2015-08-24', 610, 'ENERGY', 45, 44, '2015-06-20', '2014-12-20', '2015-08-31', 1, 2175.6000, 0.0000, 307.9400, 2483.5400, '2015-08-24 10:00:32', 'dbo', ''),
(2015060019, 201506, 7, 19, '2015-08-24', 611, 'ENERGY', 109, 59, '2015-06-20', '2014-12-20', '2015-08-31', 50, 3298.0650, 0.0000, 1187.1800, 4485.2450, '2015-08-24 10:00:32', 'dbo', ''),
(2015060020, 201506, 7, 20, '2015-08-24', 612, 'ENERGY', 105, 101, '2015-06-20', '2014-12-20', '2015-08-31', 4, 4579.9330, 0.0000, 361.7600, 4941.6930, '2015-08-24 10:00:32', 'dbo', ''),
(2015060021, 201506, 7, 21, '2015-08-24', 613, 'ENERGY', 18088, 11635, '2015-06-20', '2014-12-20', '2015-08-31', 6453, 424949.5746, 0.0000, 116078.9600, 541028.5346, '2015-08-24 10:00:32', 'dbo', ''),
(2015060022, 201506, 7, 22, '2015-08-24', 614, 'ENERGY', 11359, 7264, '2015-06-20', '2014-12-20', '2015-08-31', 4095, 261300.3116, 0.0000, 73768.3600, 335068.6716, '2015-08-24 10:00:32', 'dbo', ''),
(2015060023, 201506, 7, 23, '2015-08-24', 615, 'ENERGY', 26018, 16554, '2015-06-20', '2014-12-20', '2015-08-31', 9464, 633831.7970, 0.0000, 170106.6400, 803938.4370, '2015-08-24 10:00:32', 'dbo', ''),
(2015060024, 201506, 7, 24, '2015-08-24', 616, 'ENERGY', 22501, 13895, '2015-06-20', '2014-12-20', '2015-08-31', 8606, 538104.9500, 0.0000, 154711.1800, 692816.1300, '2015-08-24 10:00:32', 'dbo', ''),
(2015060025, 201506, 7, 25, '2015-08-24', 617, 'ENERGY', 55, 44, '2015-06-20', '2014-12-20', '2015-08-31', 11, 2209.3100, 2209.3100, 487.3800, 487.3800, '2015-08-24 10:00:32', 'dbo', ''),
(2015060026, 201506, 7, 26, '2015-08-24', 618, 'ENERGY', 10104, 2380, '2015-06-20', '2014-12-20', '2015-08-31', 7724, 79920.6974, 594.9100, 138885.0700, 218210.8574, '2015-08-24 10:00:32', 'dbo', ''),
(2015060029, 201506, 7, 29, '2015-08-24', 621, 'ENERGY', 32202, 21399, '2015-06-20', '2014-12-20', '2015-08-31', 10803, 801376.2888, 491428.0400, 194132.9100, 504081.1588, '2015-08-24 10:00:32', 'dbo', ''),
(2015060030, 201506, 7, 30, '2015-08-24', 622, 'ENERGY', 13405, 7947, '2015-06-20', '2014-12-20', '2015-08-31', 5458, 288571.9612, 288571.9600, 98225.2500, 98225.2512, '2015-08-24 10:00:32', 'dbo', ''),
(2015060031, 201506, 7, 31, '2015-08-24', 623, 'ENERGY', 10776, 335, '2015-06-20', '2014-12-20', '2015-08-31', 10441, 10623.9180, 0.0000, 187637.3800, 198261.2980, '2015-08-24 10:00:32', 'dbo', ''),
(2015060032, 201506, 7, 32, '2015-08-24', 624, 'ENERGY', 17224, 699, '2015-06-20', '2014-12-20', '2015-08-31', 16525, 22172.6990, 0.0000, 296805.2200, 318977.9190, '2015-08-24 10:00:32', 'dbo', ''),
(2015060033, 201506, 7, 33, '2015-08-24', 625, 'ENERGY', 1691, 57, '2015-06-20', '2014-12-20', '2015-08-31', 1634, 3592.8634, 3592.8600, 29609.5800, 29609.5834, '2015-08-24 10:00:32', 'dbo', ''),
(2015060034, 201506, 7, 34, '2015-08-24', 626, 'ENERGY', 998, 43, '2015-06-20', '2014-12-20', '2015-08-31', 955, 2863.7942, 2863.7900, 17425.9900, 17425.9942, '2015-08-24 10:00:32', 'dbo', ''),
(2015060035, 201506, 7, 35, '2015-08-24', 627, 'ENERGY', 2608, 374, '2015-06-20', '2014-12-20', '2015-08-31', 2234, 13498.2126, 13498.0000, 40375.6300, 40375.8426, '2015-08-24 10:00:32', 'dbo', ''),
(2015060036, 201506, 7, 36, '2015-08-24', 628, 'ENERGY', 4265, 91, '2015-06-20', '2014-12-20', '2015-08-31', 4174, 3612.0738, 3612.0700, 75185.8900, 75185.8938, '2015-08-24 10:00:32', 'dbo', ''),
(2015060037, 201506, 7, 37, '2015-08-24', 629, 'ENERGY', 3647, 121, '2015-06-20', '2014-12-20', '2015-08-31', 3526, 5389.7810, 5389.7800, 63558.5400, 63558.5410, '2015-08-24 10:00:32', 'dbo', ''),
(2015060038, 201506, 7, 38, '2015-08-24', 630, 'ENERGY', 1450, 34, '2015-06-20', '2014-12-20', '2015-08-31', 1416, 2585.2934, 2585.2900, 25697.9100, 25697.9134, '2015-08-24 10:00:32', 'dbo', ''),
(2015060039, 201506, 7, 39, '2015-08-24', 631, 'ENERGY', 34661, 51, '2015-06-20', '2014-12-20', '2015-08-31', 34610, 2272.8382, 2272.8400, 621312.1900, 621312.1882, '2015-08-24 10:00:32', 'dbo', ''),
(2015060040, 201506, 7, 40, '2015-08-24', 632, 'ENERGY', 2737, 71, '2015-06-20', '2014-12-20', '2015-08-31', 2666, 2926.7396, 2926.7400, 48127.1700, 48127.1696, '2015-08-24 10:00:32', 'dbo', ''),
(2015060041, 201506, 7, 41, '2015-08-24', 633, 'ENERGY', 75, 57, '2015-06-20', '2014-12-20', '2015-08-31', 18, 3610.2900, 0.0000, 612.9900, 4223.2800, '2015-08-24 10:00:32', 'dbo', ''),
(2015060042, 201506, 7, 42, '2015-08-24', 634, 'ENERGY', 100, 42, '2015-06-20', '2014-12-20', '2015-08-31', 58, 2258.3960, 0.0000, 1330.7200, 3589.1160, '2015-08-24 10:00:32', 'dbo', ''),
(2015060043, 201506, 7, 43, '2015-08-24', 635, 'ENERGY', 16339, 7912, '2015-06-20', '2014-12-20', '2015-08-31', 8427, 280245.9202, 0.0000, 151499.3100, 431745.2302, '2015-08-24 10:00:32', 'dbo', ''),
(2015060044, 201506, 7, 44, '2015-08-24', 636, 'ENERGY', 355, 93, '2015-06-20', '2014-12-20', '2015-08-31', 262, 4775.5130, 0.0000, 4991.1700, 9766.6830, '2015-08-24 10:00:32', 'dbo', ''),
(2015060045, 201506, 7, 45, '2015-08-24', 637, 'ENERGY', 12842, 7922, '2015-06-20', '2014-12-20', '2015-08-31', 4920, 316047.1420, 316047.1400, 88571.6900, 88571.6920, '2015-08-24 10:00:32', 'dbo', ''),
(2015060046, 201506, 7, 46, '2015-08-24', 638, 'ENERGY', 13648, 6531, '2015-06-20', '2014-12-20', '2015-08-31', 7117, 257649.4354, 200000.0000, 127993.3900, 185642.8254, '2015-08-24 10:00:32', 'dbo', ''),
(2015060047, 201506, 7, 47, '2015-08-24', 639, 'ENERGY', 8249, 4799, '2015-06-20', '2014-12-20', '2015-08-31', 3450, 180577.6010, 180577.6000, 62194.8300, 62194.8310, '2015-08-24 10:00:32', 'dbo', ''),
(2015060048, 201506, 7, 48, '2015-08-24', 640, 'ENERGY', 89, 85, '2015-06-20', '2014-12-20', '2015-08-31', 4, 3728.9000, 0.0000, 361.7600, 4090.6600, '2015-08-24 10:00:32', 'dbo', ''),
(2015060049, 201506, 7, 49, '2015-08-24', 641, 'ENERGY', 999, 177, '2015-06-20', '2014-12-20', '2015-08-31', 822, 6736.9990, 6737.0000, 15039.4900, 15039.4890, '2015-08-24 10:00:32', 'dbo', ''),
(2015060050, 201506, 7, 50, '2015-08-24', 642, 'ENERGY', 15903, 676, '2015-06-20', '2014-12-20', '2015-08-31', 15227, 21346.8292, 21346.8300, 273514.6500, 273514.6492, '2015-08-24 10:00:32', 'dbo', ''),
(2015060051, 201506, 7, 51, '2015-08-24', 643, 'ENERGY', 211, 211, '2015-06-20', '2014-12-20', '2015-08-31', 0, 8990.1390, 8990.1400, 290.0000, 289.9990, '2015-08-24 10:00:32', 'dbo', ''),
(2015060052, 201506, 7, 52, '2015-08-24', 644, 'ENERGY', 95, 92, '2015-06-20', '2014-12-20', '2015-08-31', 3, 2932.1020, 2932.1000, 343.8400, 343.8420, '2015-08-24 10:00:32', 'dbo', ''),
(2015060053, 201506, 7, 53, '2015-08-24', 645, 'ENERGY', 71, 62, '2015-06-20', '2014-12-20', '2015-08-31', 9, 3472.7470, 0.0000, 451.4900, 3924.2370, '2015-08-24 10:00:32', 'dbo', ''),
(2015060054, 201506, 7, 54, '2015-08-24', 646, 'ENERGY', 7316, 3058, '2015-06-20', '2014-12-20', '2015-08-31', 4258, 113056.2594, 0.0000, 76693.1400, 189749.3994, '2015-08-24 10:00:32', 'dbo', ''),
(2015060055, 201506, 7, 55, '2015-08-24', 647, 'ENERGY', 63, 59, '2015-06-20', '2014-12-20', '2015-08-31', 4, 2374.4100, 0.0000, 361.7600, 2736.1700, '2015-08-24 10:00:32', 'dbo', ''),
(2015060056, 201506, 7, 56, '2015-08-24', 648, 'ENERGY', 81, 58, '2015-06-20', '2014-12-20', '2015-08-31', 23, 2660.1390, 2661.0000, 702.7000, 701.8390, '2015-08-24 10:00:32', 'dbo', ''),
(2015060059, 201506, 7, 59, '2015-08-24', 651, 'ENERGY', 23, 1, '2015-06-20', '2014-12-20', '2015-08-31', 22, 1740.0000, 1740.0000, 684.7500, 684.7500, '2015-08-24 10:00:32', 'dbo', ''),
(2015060060, 201506, 7, 60, '2015-08-24', 652, 'ENERGY', 4922, 2, '2015-06-20', '2014-12-20', '2015-08-31', 4920, 1740.0000, 1740.0000, 88571.6900, 88571.6900, '2015-08-24 10:00:32', 'dbo', ''),
(2015060061, 201506, 7, 61, '2015-08-24', 653, 'ENERGY', 3, 3, '2015-06-20', '2014-12-20', '2015-08-31', 0, 1740.0000, 1740.0000, 290.0000, 290.0000, '2015-08-24 10:00:32', 'dbo', ''),
(2015060062, 201506, 7, 62, '2015-08-24', 654, 'ENERGY', 30, 30, '2015-06-20', '2014-12-20', '2015-08-31', 0, 1740.0000, 1740.0000, 290.0000, 290.0000, '2015-08-24 10:00:32', 'dbo', ''),
(2015060063, 201506, 7, 63, '2015-08-24', 655, 'ENERGY', 1, 1, '2015-06-20', '2014-12-20', '2015-08-31', 0, 1740.0000, 1740.0000, 290.0000, 290.0000, '2015-08-24 10:00:32', 'dbo', ''),
(2015060064, 201506, 7, 64, '2015-08-24', 656, 'ENERGY', 2, 2, '2015-06-20', '2014-12-20', '2015-08-31', 0, 1740.0000, 1740.0000, 290.0000, 290.0000, '2015-08-24 10:00:32', 'dbo', ''),
(2015060065, 201506, 7, 65, '2015-08-24', 657, 'ENERGY', 15, 10, '2015-06-20', '2014-12-20', '2015-08-31', 5, 1999.1880, 0.0000, 379.7300, 2378.9180, '2015-08-24 10:00:32', 'dbo', ''),
(2015060066, 201506, 7, 66, '2015-08-24', 658, 'ENERGY', 122, 93, '2015-06-20', '2014-12-20', '2015-08-31', 29, 4471.4824, 0.0000, 810.3500, 5281.8324, '2015-08-24 10:00:32', 'dbo', ''),
(2015060067, 201506, 7, 67, '2015-08-24', 659, 'ENERGY', 101, 71, '2015-06-20', '2014-12-20', '2015-08-31', 30, 4565.8238, 0.0000, 828.2900, 5394.1138, '2015-08-24 10:00:32', 'dbo', ''),
(2015060068, 201506, 7, 68, '2015-08-24', 660, 'ENERGY', 155, 17, '2015-06-20', '2014-12-20', '2015-08-31', 138, 2088.4700, 0.0000, 2766.1900, 4854.6600, '2015-08-24 10:00:32', 'dbo', ''),
(2015060069, 201506, 7, 69, '2015-08-24', 661, 'ENERGY', 1, 1, '2015-06-20', '2014-12-20', '2015-08-31', 0, 1740.0000, 0.0000, 290.0000, 2030.0000, '2015-08-24 10:00:32', 'dbo', ''),
(2015060070, 201506, 7, 70, '2015-08-24', 662, 'ENERGY', 166, 41, '2015-06-20', '2014-12-20', '2015-08-31', 125, 2698.3100, 0.0000, 2532.9200, 5231.2300, '2015-08-24 10:00:32', 'dbo', ''),
(2015060071, 201506, 7, 71, '2015-08-24', 663, 'ENERGY', 179, 101, '2015-06-20', '2014-12-20', '2015-08-31', 78, 4795.5062, 0.0000, 1689.5700, 6485.0762, '2015-08-24 10:00:32', 'dbo', ''),
(2015060072, 201506, 7, 72, '2015-08-24', 664, 'ENERGY', 32, 32, '2015-06-20', '2014-12-20', '2015-08-31', 0, 1777.2300, 0.0000, 290.0000, 2067.2300, '2015-08-24 10:00:32', 'dbo', ''),
(2015060073, 201506, 7, 73, '2015-08-24', 665, 'ENERGY', 280, 248, '2015-06-20', '2014-12-20', '2015-08-31', 32, 12383.9080, 0.0000, 864.1900, 13248.0980, '2015-08-24 10:00:32', 'dbo', ''),
(2015060075, 201506, 7, 75, '2015-08-24', 666, 'ENERGY', 138, 0, '2015-06-20', '2014-12-20', '2015-08-31', 138, 0.0000, 0.0000, 2766.1900, 2766.1900, '2015-08-24 10:00:32', 'dbo', ''),
(2015060076, 201506, 7, 76, '2015-08-24', 667, 'ENERGY', 242, 0, '2015-06-20', '2014-12-20', '2015-08-31', 242, 0.0000, 0.0000, 4632.3100, 4632.3100, '2015-08-24 10:00:32', 'dbo', ''),
(2015060077, 201506, 7, 77, '2015-08-24', 668, 'ENERGY', 244, 0, '2015-06-20', '2014-12-20', '2015-08-31', 244, 0.0000, 0.0000, 4668.1900, 4668.1900, '2015-08-24 10:00:32', 'dbo', ''),
(2015060078, 201506, 7, 78, '2015-08-24', 669, 'ENERGY', 25, 0, '2015-06-20', '2014-12-20', '2015-08-31', 25, 0.0000, 0.0000, 738.5800, 738.5800, '2015-08-24 10:00:32', 'dbo', ''),
(2015070001, 201507, 8, 1, '2016-04-25', 670, 'ENERGY', 86, 86, '2015-07-20', '2015-06-20', '2016-05-04', 0, 3765.8914, 0.0000, 290.0000, 4055.8914, '2016-04-10 14:04:05', 'dbo', ''),
(2015070002, 201507, 8, 2, '2016-04-25', 671, 'ENERGY', 172, 172, '2015-07-20', '2015-06-20', '2016-05-04', 0, 6614.7610, 0.0000, 290.0000, 6904.7610, '2016-04-10 14:04:05', 'dbo', ''),
(2015070003, 201507, 8, 3, '2016-04-25', 672, 'ENERGY', 68, 66, '2015-07-20', '2015-06-20', '2016-05-04', 2, 2759.5134, 0.0000, 329.0600, 3088.5734, '2016-04-10 14:04:05', 'dbo', ''),
(2015070004, 201507, 8, 4, '2016-04-25', 673, 'ENERGY', 127, 126, '2015-07-20', '2015-06-20', '2016-05-04', 1, 4050.4022, 0.0000, 309.5300, 4359.9322, '2016-04-10 14:04:05', 'dbo', ''),
(2015070005, 201507, 8, 5, '2016-04-25', 674, 'ENERGY', 112, 109, '2015-07-20', '2015-06-20', '2016-05-04', 3, 4220.7486, 0.0000, 348.5900, 4569.3386, '2016-04-10 14:04:05', 'dbo', ''),
(2015070006, 201507, 8, 6, '2016-04-25', 675, 'ENERGY', 70, 70, '2015-07-20', '2015-06-20', '2016-05-04', 0, 2939.0368, 0.0000, 290.0000, 3229.0368, '2016-04-10 14:04:05', 'dbo', ''),
(2015070007, 201507, 8, 7, '2016-04-25', 676, 'ENERGY', 70, 70, '2015-07-20', '2015-06-20', '2016-05-04', 0, 3468.2500, 0.0000, 290.0000, 3758.2500, '2016-04-10 14:04:05', 'dbo', ''),
(2015070008, 201507, 8, 8, '2016-04-25', 677, 'ENERGY', 118, 118, '2015-07-20', '2015-06-20', '2016-05-04', 0, 4285.2176, 0.0000, 290.0000, 4575.2176, '2016-04-10 14:04:05', 'dbo', ''),
(2015070009, 201507, 8, 9, '2016-04-25', 678, 'ENERGY', 63, 62, '2015-07-20', '2015-06-20', '2016-05-04', 1, 2823.8864, 0.0000, 309.5300, 3133.4164, '2016-04-10 14:04:05', 'dbo', ''),
(2015070010, 201507, 8, 10, '2016-04-25', 679, 'ENERGY', 67, 58, '2015-07-20', '2015-06-20', '2016-05-04', 9, 2705.2680, 0.0000, 465.7700, 3171.0380, '2016-04-10 14:04:05', 'dbo', ''),
(2015070011, 201507, 8, 11, '2016-04-25', 680, 'ENERGY', 129, 129, '2015-07-20', '2015-06-20', '2016-05-04', 0, 5564.9710, 0.0000, 290.0000, 5854.9710, '2016-04-10 14:04:05', 'dbo', ''),
(2015070012, 201507, 8, 12, '2016-04-25', 681, 'ENERGY', 43, 42, '2015-07-20', '2015-06-20', '2016-05-04', 1, 2336.4600, 0.0000, 309.5300, 2645.9900, '2016-04-10 14:04:05', 'dbo', ''),
(2015070013, 201507, 8, 13, '2016-04-25', 682, 'ENERGY', 78, 78, '2015-07-20', '2015-06-20', '2016-05-04', 0, 3820.4940, 0.0000, 290.0000, 4110.4940, '2016-04-10 14:04:05', 'dbo', ''),
(2015070014, 201507, 8, 14, '2016-04-25', 683, 'ENERGY', 147, 133, '2015-07-20', '2015-06-20', '2016-05-04', 14, 5028.9954, 0.0000, 563.4300, 5592.4254, '2016-04-10 14:04:05', 'dbo', ''),
(2015070015, 201507, 8, 15, '2016-04-25', 684, 'ENERGY', 107, 106, '2015-07-20', '2015-06-20', '2016-05-04', 1, 3773.9790, 0.0000, 309.5300, 4083.5090, '2016-04-10 14:04:05', 'dbo', ''),
(2015070016, 201507, 8, 16, '2016-04-25', 685, 'ENERGY', 67, 65, '2015-07-20', '2015-06-20', '2016-05-04', 2, 2852.1920, 0.0000, 329.0600, 3181.2520, '2016-04-10 14:04:05', 'dbo', ''),
(2015070017, 201507, 8, 17, '2016-04-25', 686, 'ENERGY', 147, 146, '2015-07-20', '2015-06-20', '2016-05-04', 1, 4768.0870, 0.0000, 309.5300, 5077.6170, '2016-04-10 14:04:05', 'dbo', ''),
(2015070018, 201507, 8, 18, '2016-04-25', 687, 'ENERGY', 46, 45, '2015-07-20', '2015-06-20', '2016-05-04', 1, 2483.5400, 0.0000, 309.5300, 2793.0700, '2016-04-10 14:04:05', 'dbo', ''),
(2015070019, 201507, 8, 19, '2016-04-25', 688, 'ENERGY', 74, 109, '2015-07-20', '2015-06-20', '2016-05-04', -35, 4485.2450, 0.0000, -393.5800, 4091.6650, '2016-04-10 14:04:05', 'dbo', ''),
(2015070020, 201507, 8, 20, '2016-04-25', 689, 'ENERGY', 110, 105, '2015-07-20', '2015-06-20', '2016-05-04', 5, 4941.6930, 0.0000, 387.6600, 5329.3530, '2016-04-10 14:04:05', 'dbo', ''),
(2015070021, 201507, 8, 21, '2016-04-25', 690, 'ENERGY', 19475, 18088, '2015-07-20', '2015-06-20', '2016-05-04', 1387, 541028.5346, 0.0000, 27379.1500, 568407.6846, '2016-04-10 14:04:05', 'dbo', ''),
(2015070022, 201507, 8, 22, '2016-04-25', 691, 'ENERGY', 12328, 11359, '2015-07-20', '2015-06-20', '2016-05-04', 969, 335068.6716, 0.0000, 19215.2900, 354283.9616, '2016-04-10 14:04:05', 'dbo', ''),
(2015070023, 201507, 8, 23, '2016-04-25', 692, 'ENERGY', 27805, 26018, '2015-07-20', '2015-06-20', '2016-05-04', 1787, 803938.4370, 0.0000, 35191.4500, 839129.8870, '2016-04-10 14:04:05', 'dbo', ''),
(2015070024, 201507, 8, 24, '2016-04-25', 693, 'ENERGY', 24405, 22501, '2015-07-20', '2015-06-20', '2016-05-04', 1904, 692816.1300, 0.0000, 37476.5400, 730292.6700, '2016-04-10 14:04:05', 'dbo', ''),
(2015070025, 201507, 8, 25, '2016-04-25', 694, 'ENERGY', 62, 55, '2015-07-20', '2015-06-20', '2016-05-04', 7, 487.3800, 0.0000, 426.7200, 914.1000, '2016-04-10 14:04:05', 'dbo', ''),
(2015070026, 201507, 8, 26, '2016-04-25', 695, 'ENERGY', 12233, 10104, '2015-07-20', '2015-06-20', '2016-05-04', 2129, 218210.8574, 0.0000, 41870.9600, 260081.8174, '2016-04-10 14:04:05', 'dbo', ''),
(2015070029, 201507, 8, 29, '2016-04-25', 698, 'ENERGY', 34089, 32202, '2015-07-20', '2015-06-20', '2016-05-04', 1887, 504081.1588, 0.0000, 37144.5200, 541225.6788, '2016-04-10 14:04:05', 'dbo', ''),
(2015070030, 201507, 8, 30, '2016-04-25', 699, 'ENERGY', 14471, 13405, '2015-07-20', '2015-06-20', '2016-05-04', 1066, 98225.2512, 0.0000, 21109.7700, 119335.0212, '2016-04-10 14:04:05', 'dbo', ''),
(2015070031, 201507, 8, 31, '2016-04-25', 700, 'ENERGY', 12409, 10776, '2015-07-20', '2015-06-20', '2016-05-04', 1633, 198261.2980, 0.0000, 32183.7100, 230445.0080, '2016-04-10 14:04:05', 'dbo', ''),
(2015070032, 201507, 8, 32, '2016-04-25', 701, 'ENERGY', 20362, 17224, '2015-07-20', '2015-06-20', '2016-05-04', 3138, 318977.9190, 0.0000, 61577.4900, 380555.4090, '2016-04-10 14:04:05', 'dbo', ''),
(2015070033, 201507, 8, 33, '2016-04-25', 702, 'ENERGY', 2189, 1691, '2015-07-20', '2015-06-20', '2016-05-04', 498, 29609.5834, 0.0000, 10016.3200, 39625.9034, '2016-04-10 14:04:05', 'dbo', ''),
(2015070034, 201507, 8, 34, '2016-04-25', 703, 'ENERGY', 1392, 998, '2015-07-20', '2015-06-20', '2016-05-04', 394, 17425.9942, 0.0000, 7985.1200, 25411.1142, '2016-04-10 14:04:05', 'dbo', ''),
(2015070035, 201507, 8, 35, '2016-04-25', 704, 'ENERGY', 3286, 2608, '2015-07-20', '2015-06-20', '2016-05-04', 678, 40375.8426, 0.0000, 13531.8500, 53907.6926, '2016-04-10 14:04:05', 'dbo', ''),
(2015070036, 201507, 8, 36, '2016-04-25', 705, 'ENERGY', 5506, 4265, '2015-07-20', '2015-06-20', '2016-05-04', 1241, 75185.8938, 0.0000, 24527.6600, 99713.5538, '2016-04-10 14:04:05', 'dbo', ''),
(2015070037, 201507, 8, 37, '2016-04-25', 706, 'ENERGY', 4520, 3647, '2015-07-20', '2015-06-20', '2016-05-04', 873, 63558.5410, 0.0000, 17340.3500, 80898.8910, '2016-04-10 14:04:05', 'dbo', ''),
(2015070038, 201507, 8, 38, '2016-04-25', 707, 'ENERGY', 1897, 1450, '2015-07-20', '2015-06-20', '2016-05-04', 447, 25697.9134, 0.0000, 9020.2500, 34718.1634, '2016-04-10 14:04:05', 'dbo', ''),
(2015070039, 201507, 8, 39, '2016-04-25', 708, 'ENERGY', 3886, 34661, '2015-07-20', '2015-06-20', '2016-05-04', -30775, 621312.1882, 0.0000, -600768.8200, 20543.3682, '2016-04-10 14:04:05', 'dbo', ''),
(2015070040, 201507, 8, 40, '2016-04-25', 709, 'ENERGY', 3504, 2737, '2015-07-20', '2015-06-20', '2016-05-04', 767, 48127.1696, 0.0000, 15270.0800, 63397.2496, '2016-04-10 14:04:05', 'dbo', ''),
(2015070041, 201507, 8, 41, '2016-04-25', 710, 'ENERGY', 75, 75, '2015-07-20', '2015-06-20', '2016-05-04', 0, 4223.2800, 0.0000, 290.0000, 4513.2800, '2016-04-10 14:04:05', 'dbo', ''),
(2015070042, 201507, 8, 42, '2016-04-25', 711, 'ENERGY', 126, 100, '2015-07-20', '2015-06-20', '2016-05-04', 26, 3589.1160, 0.0000, 797.7900, 4386.9060, '2016-04-10 14:04:05', 'dbo', ''),
(2015070043, 201507, 8, 43, '2016-04-25', 712, 'ENERGY', 18028, 16339, '2015-07-20', '2015-06-20', '2016-05-04', 1689, 431745.2302, 0.0000, 33277.4400, 465022.6702, '2016-04-10 14:04:05', 'dbo', ''),
(2015070044, 201507, 8, 44, '2016-04-25', 713, 'ENERGY', 788, 355, '2015-07-20', '2015-06-20', '2016-05-04', 433, 9766.6830, 0.0000, 8746.8200, 18513.5030, '2016-04-10 14:04:05', 'dbo', ''),
(2015070045, 201507, 8, 45, '2016-04-25', 714, 'ENERGY', 13722, 12842, '2015-07-20', '2015-06-20', '2016-05-04', 880, 88571.6920, 0.0000, 17477.0600, 106048.7520, '2016-04-10 14:04:05', 'dbo', ''),
(2015070046, 201507, 8, 46, '2016-04-25', 715, 'ENERGY', 15004, 13648, '2015-07-20', '2015-06-20', '2016-05-04', 1356, 185642.8254, 0.0000, 26773.6900, 212416.5154, '2016-04-10 14:04:05', 'dbo', ''),
(2015070047, 201507, 8, 47, '2016-04-25', 716, 'ENERGY', 8914, 8249, '2015-07-20', '2015-06-20', '2016-05-04', 665, 62194.8310, 0.0000, 13277.9500, 75472.7810, '2016-04-10 14:04:05', 'dbo', ''),
(2015070048, 201507, 8, 48, '2016-04-25', 717, 'ENERGY', 89, 89, '2015-07-20', '2015-06-20', '2016-05-04', 0, 4090.6600, 0.0000, 290.0000, 4380.6600, '2016-04-10 14:04:05', 'dbo', ''),
(2015070049, 201507, 8, 49, '2016-04-25', 718, 'ENERGY', 1186, 999, '2015-07-20', '2015-06-20', '2016-05-04', 187, 15039.4890, 0.0000, 3942.2500, 18981.7390, '2016-04-10 14:04:05', 'dbo', ''),
(2015070050, 201507, 8, 50, '2016-04-25', 719, 'ENERGY', 18559, 15903, '2015-07-20', '2015-06-20', '2016-05-04', 2656, 273514.6492, 0.0000, 52163.6700, 325678.3192, '2016-04-10 14:04:05', 'dbo', '');
INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2015070051, 201507, 8, 51, '2016-04-25', 720, 'ENERGY', 211, 211, '2015-07-20', '2015-06-20', '2016-05-04', 0, 289.9990, 0.0000, 290.0000, 579.9990, '2016-04-10 14:04:05', 'dbo', ''),
(2015070052, 201507, 8, 52, '2016-04-25', 721, 'ENERGY', 95, 95, '2015-07-20', '2015-06-20', '2016-05-04', 0, 343.8420, 0.0000, 290.0000, 633.8420, '2016-04-10 14:04:05', 'dbo', ''),
(2015070053, 201507, 8, 53, '2016-04-25', 722, 'ENERGY', 71, 71, '2015-07-20', '2015-06-20', '2016-05-04', 0, 3924.2370, 0.0000, 290.0000, 4214.2370, '2016-04-10 14:04:05', 'dbo', ''),
(2015070054, 201507, 8, 54, '2016-04-25', 723, 'ENERGY', 7973, 7316, '2015-07-20', '2015-06-20', '2016-05-04', 657, 189749.3994, 0.0000, 13121.7100, 202871.1094, '2016-04-10 14:04:05', 'dbo', ''),
(2015070055, 201507, 8, 55, '2016-04-25', 724, 'ENERGY', 114, 63, '2015-07-20', '2015-06-20', '2016-05-04', 51, 2736.1700, 0.0000, 1286.0700, 4022.2400, '2016-04-10 14:04:05', 'dbo', ''),
(2015070056, 201507, 8, 56, '2016-04-25', 725, 'ENERGY', 81, 81, '2015-07-20', '2015-06-20', '2016-05-04', 0, 701.8390, 0.0000, 290.0000, 991.8390, '2016-04-10 14:04:05', 'dbo', ''),
(2015070059, 201507, 8, 59, '2016-04-25', 728, 'ENERGY', 23, 23, '2015-07-20', '2015-06-20', '2016-05-04', 0, 684.7500, 0.0000, 290.0000, 974.7500, '2016-04-10 14:04:05', 'dbo', ''),
(2015070060, 201507, 8, 60, '2016-04-25', 729, 'ENERGY', 20539, 4922, '2015-07-20', '2015-06-20', '2016-05-04', 15617, 88571.6900, 0.0000, 305301.7100, 393873.4000, '2016-04-10 14:04:05', 'dbo', ''),
(2015070061, 201507, 8, 61, '2016-04-25', 730, 'ENERGY', 3, 3, '2015-07-20', '2015-06-20', '2016-05-04', 0, 290.0000, 0.0000, 290.0000, 580.0000, '2016-04-10 14:04:05', 'dbo', ''),
(2015070062, 201507, 8, 62, '2016-04-25', 731, 'ENERGY', 30, 30, '2015-07-20', '2015-06-20', '2016-05-04', 0, 290.0000, 0.0000, 290.0000, 580.0000, '2016-04-10 14:04:05', 'dbo', ''),
(2015070063, 201507, 8, 63, '2016-04-25', 732, 'ENERGY', 1, 1, '2015-07-20', '2015-06-20', '2016-05-04', 0, 290.0000, 0.0000, 290.0000, 580.0000, '2016-04-10 14:04:05', 'dbo', ''),
(2015070064, 201507, 8, 64, '2016-04-25', 733, 'ENERGY', 2, 2, '2015-07-20', '2015-06-20', '2016-05-04', 0, 290.0000, 0.0000, 290.0000, 580.0000, '2016-04-10 14:04:05', 'dbo', ''),
(2015070065, 201507, 8, 65, '2016-04-25', 734, 'ENERGY', 15, 15, '2015-07-20', '2015-06-20', '2016-05-04', 0, 2378.9180, 0.0000, 290.0000, 2668.9180, '2016-04-10 14:04:05', 'dbo', ''),
(2015070066, 201507, 8, 66, '2016-04-25', 735, 'ENERGY', 122, 122, '2015-07-20', '2015-06-20', '2016-05-04', 0, 5281.8324, 0.0000, 290.0000, 5571.8324, '2016-04-10 14:04:05', 'dbo', ''),
(2015070067, 201507, 8, 67, '2016-04-25', 736, 'ENERGY', 101, 101, '2015-07-20', '2015-06-20', '2016-05-04', 0, 5394.1138, 0.0000, 290.0000, 5684.1138, '2016-04-10 14:04:05', 'dbo', ''),
(2015070068, 201507, 8, 68, '2016-04-25', 737, 'ENERGY', 166, 155, '2015-07-20', '2015-06-20', '2016-05-04', 11, 4854.6600, 0.0000, 504.8300, 5359.4900, '2016-04-10 14:04:05', 'dbo', ''),
(2015070069, 201507, 8, 69, '2016-04-25', 738, 'ENERGY', 1, 1, '2015-07-20', '2015-06-20', '2016-05-04', 0, 2030.0000, 0.0000, 290.0000, 2320.0000, '2016-04-10 14:04:05', 'dbo', ''),
(2015070070, 201507, 8, 70, '2016-04-25', 739, 'ENERGY', 166, 166, '2015-07-20', '2015-06-20', '2016-05-04', 0, 5231.2300, 0.0000, 290.0000, 5521.2300, '2016-04-10 14:04:05', 'dbo', ''),
(2015070071, 201507, 8, 71, '2016-04-25', 740, 'ENERGY', 191, 179, '2015-07-20', '2015-06-20', '2016-05-04', 12, 6485.0762, 0.0000, 524.3700, 7009.4462, '2016-04-10 14:04:05', 'dbo', ''),
(2015070072, 201507, 8, 72, '2016-04-25', 741, 'ENERGY', 32, 32, '2015-07-20', '2015-06-20', '2016-05-04', 0, 2067.2300, 0.0000, 290.0000, 2357.2300, '2016-04-10 14:04:05', 'dbo', ''),
(2015070073, 201507, 8, 73, '2016-04-25', 742, 'ENERGY', 282, 280, '2015-07-20', '2015-06-20', '2016-05-04', 2, 13248.0980, 0.0000, 329.0600, 13577.1580, '2016-04-10 14:04:05', 'dbo', ''),
(2015070075, 201507, 8, 75, '2016-04-25', 743, 'ENERGY', 138, 138, '2015-07-20', '2015-06-20', '2016-05-04', 0, 2766.1900, 0.0000, 290.0000, 3056.1900, '2016-04-10 14:04:05', 'dbo', ''),
(2015070076, 201507, 8, 76, '2016-04-25', 744, 'ENERGY', 242, 242, '2015-07-20', '2015-06-20', '2016-05-04', 0, 4632.3100, 0.0000, 290.0000, 4922.3100, '2016-04-10 14:04:05', 'dbo', ''),
(2015070077, 201507, 8, 77, '2016-04-25', 745, 'ENERGY', 244, 244, '2015-07-20', '2015-06-20', '2016-05-04', 0, 4668.1900, 0.0000, 290.0000, 4958.1900, '2016-04-10 14:04:05', 'dbo', ''),
(2015070078, 201507, 8, 78, '2016-04-25', 746, 'ENERGY', 25, 25, '2015-07-20', '2015-06-20', '2016-05-04', 0, 738.5800, 0.0000, 290.0000, 1028.5800, '2016-04-10 14:04:05', 'dbo', ''),
(2015080001, 201508, 9, 1, '2016-04-25', 747, 'ENERGY', 86, 86, '2015-08-20', '2015-07-20', '2016-05-04', 0, 4055.8914, 0.0000, 290.0000, 4345.8914, '2016-04-10 14:27:06', 'dbo', ''),
(2015080002, 201508, 9, 2, '2016-04-25', 748, 'ENERGY', 180, 172, '2015-08-20', '2015-07-20', '2016-05-04', 8, 6904.7610, 0.0000, 445.4200, 7350.1810, '2016-04-10 14:27:06', 'dbo', ''),
(2015080003, 201508, 9, 3, '2016-04-25', 749, 'ENERGY', 69, 68, '2015-08-20', '2015-07-20', '2016-05-04', 1, 3088.5734, 0.0000, 309.4200, 3397.9934, '2016-04-10 14:27:06', 'dbo', ''),
(2015080004, 201508, 9, 4, '2016-04-25', 750, 'ENERGY', 128, 127, '2015-08-20', '2015-07-20', '2016-05-04', 1, 4359.9322, 0.0000, 309.4200, 4669.3522, '2016-04-10 14:27:06', 'dbo', ''),
(2015080005, 201508, 9, 5, '2016-04-25', 751, 'ENERGY', 113, 112, '2015-08-20', '2015-07-20', '2016-05-04', 1, 4569.3386, 0.0000, 309.4200, 4878.7586, '2016-04-10 14:27:06', 'dbo', ''),
(2015080006, 201508, 9, 6, '2016-04-25', 752, 'ENERGY', 70, 70, '2015-08-20', '2015-07-20', '2016-05-04', 0, 3229.0368, 0.0000, 290.0000, 3519.0368, '2016-04-10 14:27:06', 'dbo', ''),
(2015080007, 201508, 9, 7, '2016-04-25', 753, 'ENERGY', 70, 70, '2015-08-20', '2015-07-20', '2016-05-04', 0, 3758.2500, 0.0000, 290.0000, 4048.2500, '2016-04-10 14:27:06', 'dbo', ''),
(2015080008, 201508, 9, 8, '2016-04-25', 754, 'ENERGY', 118, 118, '2015-08-20', '2015-07-20', '2016-05-04', 0, 4575.2176, 0.0000, 290.0000, 4865.2176, '2016-04-10 14:27:06', 'dbo', ''),
(2015080009, 201508, 9, 9, '2016-04-25', 755, 'ENERGY', 63, 63, '2015-08-20', '2015-07-20', '2016-05-04', 0, 3133.4164, 0.0000, 290.0000, 3423.4164, '2016-04-10 14:27:06', 'dbo', ''),
(2015080010, 201508, 9, 10, '2016-04-25', 756, 'ENERGY', 70, 67, '2015-08-20', '2015-07-20', '2016-05-04', 3, 3171.0380, 0.0000, 348.2900, 3519.3280, '2016-04-10 14:27:06', 'dbo', ''),
(2015080011, 201508, 9, 11, '2016-04-25', 757, 'ENERGY', 130, 129, '2015-08-20', '2015-07-20', '2016-05-04', 1, 5854.9710, 0.0000, 309.4200, 6164.3910, '2016-04-10 14:27:06', 'dbo', ''),
(2015080012, 201508, 9, 12, '2016-04-25', 758, 'ENERGY', 46, 43, '2015-08-20', '2015-07-20', '2016-05-04', 3, 2645.9900, 0.0000, 348.2900, 2994.2800, '2016-04-10 14:27:06', 'dbo', ''),
(2015080013, 201508, 9, 13, '2016-04-25', 759, 'ENERGY', 78, 78, '2015-08-20', '2015-07-20', '2016-05-04', 0, 4110.4940, 0.0000, 290.0000, 4400.4940, '2016-04-10 14:27:06', 'dbo', ''),
(2015080014, 201508, 9, 14, '2016-04-25', 760, 'ENERGY', 149, 147, '2015-08-20', '2015-07-20', '2016-05-04', 2, 5592.4254, 0.0000, 328.8600, 5921.2854, '2016-04-10 14:27:06', 'dbo', ''),
(2015080015, 201508, 9, 15, '2016-04-25', 761, 'ENERGY', 107, 107, '2015-08-20', '2015-07-20', '2016-05-04', 0, 4083.5090, 0.0000, 290.0000, 4373.5090, '2016-04-10 14:27:06', 'dbo', ''),
(2015080016, 201508, 9, 16, '2016-04-25', 762, 'ENERGY', 67, 67, '2015-08-20', '2015-07-20', '2016-05-04', 0, 3181.2520, 0.0000, 290.0000, 3471.2520, '2016-04-10 14:27:06', 'dbo', ''),
(2015080017, 201508, 9, 17, '2016-04-25', 763, 'ENERGY', 154, 147, '2015-08-20', '2015-07-20', '2016-05-04', 7, 5077.6170, 0.0000, 426.0000, 5503.6170, '2016-04-10 14:27:06', 'dbo', ''),
(2015080018, 201508, 9, 18, '2016-04-25', 764, 'ENERGY', 46, 46, '2015-08-20', '2015-07-20', '2016-05-04', 0, 2793.0700, 0.0000, 290.0000, 3083.0700, '2016-04-10 14:27:06', 'dbo', ''),
(2015080019, 201508, 9, 19, '2016-04-25', 765, 'ENERGY', 74, 74, '2015-08-20', '2015-07-20', '2016-05-04', 0, 4091.6650, 0.0000, 290.0000, 4381.6650, '2016-04-10 14:27:06', 'dbo', ''),
(2015080020, 201508, 9, 20, '2016-04-25', 766, 'ENERGY', 131, 110, '2015-08-20', '2015-07-20', '2016-05-04', 21, 5329.3530, 0.0000, 697.9900, 6027.3430, '2016-04-10 14:27:06', 'dbo', ''),
(2015080021, 201508, 9, 21, '2016-04-25', 767, 'ENERGY', 20854, 19475, '2015-08-20', '2015-07-20', '2016-05-04', 1379, 568407.6846, 0.0000, 27081.4500, 595489.1346, '2016-04-10 14:27:06', 'dbo', ''),
(2015080022, 201508, 9, 22, '2016-04-25', 768, 'ENERGY', 13045, 12328, '2015-08-20', '2015-07-20', '2016-05-04', 717, 354283.9616, 0.0000, 14220.0100, 368503.9716, '2016-04-10 14:27:06', 'dbo', ''),
(2015080023, 201508, 9, 23, '2016-04-25', 769, 'ENERGY', 29526, 27805, '2015-08-20', '2015-07-20', '2016-05-04', 1721, 839129.8870, 0.0000, 33725.8900, 872855.7770, '2016-04-10 14:27:06', 'dbo', ''),
(2015080024, 201508, 9, 24, '2016-04-25', 770, 'ENERGY', 26280, 24405, '2015-08-20', '2015-07-20', '2016-05-04', 1875, 730292.6700, 0.0000, 36717.8200, 767010.4900, '2016-04-10 14:27:06', 'dbo', ''),
(2015080025, 201508, 9, 25, '2016-04-25', 771, 'ENERGY', 62, 62, '2015-08-20', '2015-07-20', '2016-05-04', 0, 914.1000, 0.0000, 290.0000, 1204.1000, '2016-04-10 14:27:06', 'dbo', ''),
(2015080026, 201508, 9, 26, '2016-04-25', 772, 'ENERGY', 13759, 12233, '2015-08-20', '2015-07-20', '2016-05-04', 1526, 260081.8174, 0.0000, 29937.4000, 290019.2174, '2016-04-10 14:27:06', 'dbo', ''),
(2015080029, 201508, 9, 29, '2016-04-25', 775, 'ENERGY', 35928, 34089, '2015-08-20', '2015-07-20', '2016-05-04', 1839, 541225.6788, 0.0000, 36018.4100, 577244.0888, '2016-04-10 14:27:06', 'dbo', ''),
(2015080030, 201508, 9, 30, '2016-04-25', 776, 'ENERGY', 15504, 14471, '2015-08-20', '2015-07-20', '2016-05-04', 1033, 119335.0212, 0.0000, 20359.3000, 139694.3212, '2016-04-10 14:27:06', 'dbo', ''),
(2015080031, 201508, 9, 31, '2016-04-25', 777, 'ENERGY', 13985, 12409, '2015-08-20', '2015-07-20', '2016-05-04', 1576, 230445.0080, 0.0000, 30908.8000, 261353.8080, '2016-04-10 14:27:06', 'dbo', ''),
(2015080032, 201508, 9, 32, '2016-04-25', 778, 'ENERGY', 23408, 20362, '2015-08-20', '2015-07-20', '2016-05-04', 3046, 380555.4090, 0.0000, 59468.2200, 440023.6290, '2016-04-10 14:27:06', 'dbo', ''),
(2015080033, 201508, 9, 33, '2016-04-25', 779, 'ENERGY', 2594, 2189, '2015-08-20', '2015-07-20', '2016-05-04', 405, 39625.9034, 0.0000, 8158.4100, 47784.3134, '2016-04-10 14:27:06', 'dbo', ''),
(2015080034, 201508, 9, 34, '2016-04-25', 780, 'ENERGY', 1781, 1392, '2015-08-20', '2015-07-20', '2016-05-04', 389, 25411.1142, 0.0000, 7847.5600, 33258.6742, '2016-04-10 14:27:06', 'dbo', ''),
(2015080035, 201508, 9, 35, '2016-04-25', 781, 'ENERGY', 3837, 3286, '2015-08-20', '2015-07-20', '2016-05-04', 551, 53907.6926, 0.0000, 10994.9200, 64902.6126, '2016-04-10 14:27:06', 'dbo', ''),
(2015080036, 201508, 9, 36, '2016-04-25', 782, 'ENERGY', 6824, 5506, '2015-08-20', '2015-07-20', '2016-05-04', 1318, 99713.5538, 0.0000, 25896.3300, 125609.8838, '2016-04-10 14:27:06', 'dbo', ''),
(2015080037, 201508, 9, 37, '2016-04-25', 783, 'ENERGY', 5363, 4520, '2015-08-20', '2015-07-20', '2016-05-04', 843, 80898.8910, 0.0000, 16667.9500, 97566.8410, '2016-04-10 14:27:06', 'dbo', ''),
(2015080038, 201508, 9, 38, '2016-04-25', 784, 'ENERGY', 2312, 1897, '2015-08-20', '2015-07-20', '2016-05-04', 415, 34718.1634, 0.0000, 8352.7000, 43070.8634, '2016-04-10 14:27:06', 'dbo', ''),
(2015080039, 201508, 9, 39, '2016-04-25', 785, 'ENERGY', 4316, 3886, '2015-08-20', '2015-07-20', '2016-05-04', 430, 20543.3682, 0.0000, 8644.1100, 29187.4782, '2016-04-10 14:27:06', 'dbo', ''),
(2015080040, 201508, 9, 40, '2016-04-25', 786, 'ENERGY', 4263, 3504, '2015-08-20', '2015-07-20', '2016-05-04', 759, 63397.2496, 0.0000, 15035.9900, 78433.2396, '2016-04-10 14:27:06', 'dbo', ''),
(2015080041, 201508, 9, 41, '2016-04-25', 787, 'ENERGY', 88, 75, '2015-08-20', '2015-07-20', '2016-05-04', 13, 4513.2800, 0.0000, 542.5700, 5055.8500, '2016-04-10 14:27:06', 'dbo', ''),
(2015080042, 201508, 9, 42, '2016-04-25', 788, 'ENERGY', 126, 126, '2015-08-20', '2015-07-20', '2016-05-04', 0, 4386.9060, 0.0000, 290.0000, 4676.9060, '2016-04-10 14:27:06', 'dbo', ''),
(2015080043, 201508, 9, 43, '2016-04-25', 789, 'ENERGY', 19829, 18028, '2015-08-20', '2015-07-20', '2016-05-04', 1801, 465022.6702, 0.0000, 35280.1400, 500302.8102, '2016-04-10 14:27:06', 'dbo', ''),
(2015080044, 201508, 9, 44, '2016-04-25', 790, 'ENERGY', 1509, 788, '2015-08-20', '2015-07-20', '2016-05-04', 721, 18513.5030, 0.0000, 14297.7200, 32811.2230, '2016-04-10 14:27:06', 'dbo', ''),
(2015080045, 201508, 9, 45, '2016-04-25', 791, 'ENERGY', 14456, 13722, '2015-08-20', '2015-07-20', '2016-05-04', 734, 106048.7520, 0.0000, 14550.2700, 120599.0220, '2016-04-10 14:27:06', 'dbo', ''),
(2015080046, 201508, 9, 46, '2016-04-25', 792, 'ENERGY', 16430, 15004, '2015-08-20', '2015-07-20', '2016-05-04', 1426, 212416.5154, 0.0000, 27994.5800, 240411.0954, '2016-04-10 14:27:06', 'dbo', ''),
(2015080047, 201508, 9, 47, '2016-04-25', 793, 'ENERGY', 9533, 8914, '2015-08-20', '2015-07-20', '2016-05-04', 619, 75472.7810, 0.0000, 12316.0400, 87788.8210, '2016-04-10 14:27:06', 'dbo', ''),
(2015080048, 201508, 9, 48, '2016-04-25', 794, 'ENERGY', 90, 89, '2015-08-20', '2015-07-20', '2016-05-04', 1, 4380.6600, 0.0000, 309.4200, 4690.0800, '2016-04-10 14:27:06', 'dbo', ''),
(2015080049, 201508, 9, 49, '2016-04-25', 795, 'ENERGY', 1367, 1186, '2015-08-20', '2015-07-20', '2016-05-04', 181, 18981.7390, 0.0000, 3806.5000, 22788.2390, '2016-04-10 14:27:06', 'dbo', ''),
(2015080050, 201508, 9, 50, '2016-04-25', 796, 'ENERGY', 21318, 18559, '2015-08-20', '2015-07-20', '2016-05-04', 2759, 325678.3192, 0.0000, 53892.3300, 379570.6492, '2016-04-10 14:27:06', 'dbo', ''),
(2015080051, 201508, 9, 51, '2016-04-25', 797, 'ENERGY', 211, 211, '2015-08-20', '2015-07-20', '2016-05-04', 0, 579.9990, 0.0000, 290.0000, 869.9990, '2016-04-10 14:27:06', 'dbo', ''),
(2015080052, 201508, 9, 52, '2016-04-25', 798, 'ENERGY', 95, 95, '2015-08-20', '2015-07-20', '2016-05-04', 0, 633.8420, 0.0000, 290.0000, 923.8420, '2016-04-10 14:27:06', 'dbo', ''),
(2015080053, 201508, 9, 53, '2016-04-25', 799, 'ENERGY', 71, 71, '2015-08-20', '2015-07-20', '2016-05-04', 0, 4214.2370, 0.0000, 290.0000, 4504.2370, '2016-04-10 14:27:06', 'dbo', ''),
(2015080054, 201508, 9, 54, '2016-04-25', 800, 'ENERGY', 8604, 7973, '2015-08-20', '2015-07-20', '2016-05-04', 631, 202871.1094, 0.0000, 12549.1800, 215420.2894, '2016-04-10 14:27:06', 'dbo', ''),
(2015080055, 201508, 9, 55, '2016-04-25', 801, 'ENERGY', 825, 114, '2015-08-20', '2015-07-20', '2016-05-04', 711, 4022.2400, 0.0000, 14103.4300, 18125.6700, '2016-04-10 14:27:06', 'dbo', ''),
(2015080056, 201508, 9, 56, '2016-04-25', 802, 'ENERGY', 81, 81, '2015-08-20', '2015-07-20', '2016-05-04', 0, 991.8390, 0.0000, 290.0000, 1281.8390, '2016-04-10 14:27:06', 'dbo', ''),
(2015080059, 201508, 9, 59, '2016-04-25', 805, 'ENERGY', 23, 23, '2015-08-20', '2015-07-20', '2016-05-04', 0, 974.7500, 0.0000, 290.0000, 1264.7500, '2016-04-10 14:27:06', 'dbo', ''),
(2015080060, 201508, 9, 60, '2016-04-25', 806, 'ENERGY', 26692, 20539, '2015-08-20', '2015-07-20', '2016-05-04', 6153, 393873.4000, 0.0000, 119831.5600, 513704.9600, '2016-04-10 14:27:06', 'dbo', ''),
(2015080061, 201508, 9, 61, '2016-04-25', 807, 'ENERGY', 3, 3, '2015-08-20', '2015-07-20', '2016-05-04', 0, 580.0000, 0.0000, 290.0000, 870.0000, '2016-04-10 14:27:06', 'dbo', ''),
(2015080062, 201508, 9, 62, '2016-04-25', 808, 'ENERGY', 30, 30, '2015-08-20', '2015-07-20', '2016-05-04', 0, 580.0000, 0.0000, 290.0000, 870.0000, '2016-04-10 14:27:06', 'dbo', ''),
(2015080063, 201508, 9, 63, '2016-04-25', 809, 'ENERGY', 1, 1, '2015-08-20', '2015-07-20', '2016-05-04', 0, 580.0000, 0.0000, 290.0000, 870.0000, '2016-04-10 14:27:06', 'dbo', ''),
(2015080064, 201508, 9, 64, '2016-04-25', 810, 'ENERGY', 2, 2, '2015-08-20', '2015-07-20', '2016-05-04', 0, 580.0000, 0.0000, 290.0000, 870.0000, '2016-04-10 14:27:06', 'dbo', ''),
(2015080065, 201508, 9, 65, '2016-04-25', 811, 'ENERGY', 15, 15, '2015-08-20', '2015-07-20', '2016-05-04', 0, 2668.9180, 0.0000, 290.0000, 2958.9180, '2016-04-10 14:27:06', 'dbo', ''),
(2015080066, 201508, 9, 66, '2016-04-25', 812, 'ENERGY', 122, 122, '2015-08-20', '2015-07-20', '2016-05-04', 0, 5571.8324, 0.0000, 290.0000, 5861.8324, '2016-04-10 14:27:06', 'dbo', ''),
(2015080067, 201508, 9, 67, '2016-04-25', 813, 'ENERGY', 101, 101, '2015-08-20', '2015-07-20', '2016-05-04', 0, 5684.1138, 0.0000, 290.0000, 5974.1138, '2016-04-10 14:27:06', 'dbo', ''),
(2015080068, 201508, 9, 68, '2016-04-25', 814, 'ENERGY', 176, 166, '2015-08-20', '2015-07-20', '2016-05-04', 10, 5359.4900, 0.0000, 484.2800, 5843.7700, '2016-04-10 14:27:06', 'dbo', ''),
(2015080069, 201508, 9, 69, '2016-04-25', 815, 'ENERGY', 1, 1, '2015-08-20', '2015-07-20', '2016-05-04', 0, 2320.0000, 0.0000, 290.0000, 2610.0000, '2016-04-10 14:27:06', 'dbo', ''),
(2015080070, 201508, 9, 70, '2016-04-25', 816, 'ENERGY', 211, 166, '2015-08-20', '2015-07-20', '2016-05-04', 45, 5521.2300, 0.0000, 1164.2700, 6685.5000, '2016-04-10 14:27:06', 'dbo', ''),
(2015080071, 201508, 9, 71, '2016-04-25', 817, 'ENERGY', 204, 191, '2015-08-20', '2015-07-20', '2016-05-04', 13, 7009.4462, 0.0000, 542.5700, 7552.0162, '2016-04-10 14:27:06', 'dbo', ''),
(2015080072, 201508, 9, 72, '2016-04-25', 818, 'ENERGY', 32, 32, '2015-08-20', '2015-07-20', '2016-05-04', 0, 2357.2300, 0.0000, 290.0000, 2647.2300, '2016-04-10 14:27:06', 'dbo', ''),
(2015080073, 201508, 9, 73, '2016-04-25', 819, 'ENERGY', 282, 282, '2015-08-20', '2015-07-20', '2016-05-04', 0, 13577.1580, 0.0000, 290.0000, 13867.1580, '2016-04-10 14:27:06', 'dbo', ''),
(2015080075, 201508, 9, 75, '2016-04-25', 820, 'ENERGY', 138, 138, '2015-08-20', '2015-07-20', '2016-05-04', 0, 3056.1900, 0.0000, 290.0000, 3346.1900, '2016-04-10 14:27:06', 'dbo', ''),
(2015080076, 201508, 9, 76, '2016-04-25', 821, 'ENERGY', 242, 242, '2015-08-20', '2015-07-20', '2016-05-04', 0, 4922.3100, 0.0000, 290.0000, 5212.3100, '2016-04-10 14:27:06', 'dbo', ''),
(2015080077, 201508, 9, 77, '2016-04-25', 822, 'ENERGY', 244, 244, '2015-08-20', '2015-07-20', '2016-05-04', 0, 4958.1900, 0.0000, 290.0000, 5248.1900, '2016-04-10 14:27:06', 'dbo', ''),
(2015080078, 201508, 9, 78, '2016-04-25', 823, 'ENERGY', 25, 25, '2015-08-20', '2015-07-20', '2016-05-04', 0, 1028.5800, 0.0000, 290.0000, 1318.5800, '2016-04-10 14:27:06', 'dbo', ''),
(2015090001, 201509, 10, 1, '2016-04-25', 824, 'ENERGY', 86, 86, '2015-09-20', '2015-08-20', '2016-05-04', 0, 4345.8914, 0.0000, 290.0000, 4635.8914, '2016-04-10 14:38:45', 'dbo', ''),
(2015090002, 201509, 10, 2, '2016-04-25', 825, 'ENERGY', 181, 180, '2015-09-20', '2015-08-20', '2016-05-04', 1, 7350.1810, 0.0000, 307.7200, 7657.9010, '2016-04-10 14:38:45', 'dbo', ''),
(2015090003, 201509, 10, 3, '2016-04-25', 826, 'ENERGY', 69, 69, '2015-09-20', '2015-08-20', '2016-05-04', 0, 3397.9934, 0.0000, 290.0000, 3687.9934, '2016-04-10 14:38:45', 'dbo', ''),
(2015090004, 201509, 10, 4, '2016-04-25', 827, 'ENERGY', 128, 128, '2015-09-20', '2015-08-20', '2016-05-04', 0, 4669.3522, 0.0000, 290.0000, 4959.3522, '2016-04-10 14:38:45', 'dbo', ''),
(2015090005, 201509, 10, 5, '2016-04-25', 828, 'ENERGY', 114, 113, '2015-09-20', '2015-08-20', '2016-05-04', 1, 4878.7586, 0.0000, 307.7200, 5186.4786, '2016-04-10 14:38:45', 'dbo', ''),
(2015090006, 201509, 10, 6, '2016-04-25', 829, 'ENERGY', 70, 70, '2015-09-20', '2015-08-20', '2016-05-04', 0, 3519.0368, 0.0000, 290.0000, 3809.0368, '2016-04-10 14:38:45', 'dbo', ''),
(2015090007, 201509, 10, 7, '2016-04-25', 830, 'ENERGY', 70, 70, '2015-09-20', '2015-08-20', '2016-05-04', 0, 4048.2500, 0.0000, 290.0000, 4338.2500, '2016-04-10 14:38:45', 'dbo', ''),
(2015090008, 201509, 10, 8, '2016-04-25', 831, 'ENERGY', 118, 118, '2015-09-20', '2015-08-20', '2016-05-04', 0, 4865.2176, 0.0000, 290.0000, 5155.2176, '2016-04-10 14:38:45', 'dbo', ''),
(2015090009, 201509, 10, 9, '2016-04-25', 832, 'ENERGY', 63, 63, '2015-09-20', '2015-08-20', '2016-05-04', 0, 3423.4164, 0.0000, 290.0000, 3713.4164, '2016-04-10 14:38:45', 'dbo', ''),
(2015090010, 201509, 10, 10, '2016-04-25', 833, 'ENERGY', 70, 70, '2015-09-20', '2015-08-20', '2016-05-04', 0, 3519.3280, 0.0000, 290.0000, 3809.3280, '2016-04-10 14:38:45', 'dbo', ''),
(2015090011, 201509, 10, 11, '2016-04-25', 834, 'ENERGY', 130, 130, '2015-09-20', '2015-08-20', '2016-05-04', 0, 6164.3910, 0.0000, 290.0000, 6454.3910, '2016-04-10 14:38:45', 'dbo', ''),
(2015090012, 201509, 10, 12, '2016-04-25', 835, 'ENERGY', 46, 46, '2015-09-20', '2015-08-20', '2016-05-04', 0, 2994.2800, 0.0000, 290.0000, 3284.2800, '2016-04-10 14:38:45', 'dbo', ''),
(2015090013, 201509, 10, 13, '2016-04-25', 836, 'ENERGY', 78, 78, '2015-09-20', '2015-08-20', '2016-05-04', 0, 4400.4940, 0.0000, 290.0000, 4690.4940, '2016-04-10 14:38:45', 'dbo', ''),
(2015090014, 201509, 10, 14, '2016-04-25', 837, 'ENERGY', 170, 149, '2015-09-20', '2015-08-20', '2016-05-04', 21, 5921.2854, 0.0000, 662.0900, 6583.3754, '2016-04-10 14:38:45', 'dbo', ''),
(2015090015, 201509, 10, 15, '2016-04-25', 838, 'ENERGY', 110, 107, '2015-09-20', '2015-08-20', '2016-05-04', 3, 4373.5090, 0.0000, 343.1600, 4716.6690, '2016-04-10 14:38:45', 'dbo', ''),
(2015090016, 201509, 10, 16, '2016-04-25', 839, 'ENERGY', 67, 67, '2015-09-20', '2015-08-20', '2016-05-04', 0, 3471.2520, 0.0000, 290.0000, 3761.2520, '2016-04-10 14:38:45', 'dbo', ''),
(2015090017, 201509, 10, 17, '2016-04-25', 840, 'ENERGY', 163, 154, '2015-09-20', '2015-08-20', '2016-05-04', 9, 5503.6170, 0.0000, 449.4600, 5953.0770, '2016-04-10 14:38:45', 'dbo', ''),
(2015090018, 201509, 10, 18, '2016-04-25', 841, 'ENERGY', 46, 46, '2015-09-20', '2015-08-20', '2016-05-04', 0, 3083.0700, 0.0000, 290.0000, 3373.0700, '2016-04-10 14:38:45', 'dbo', ''),
(2015090019, 201509, 10, 19, '2016-04-25', 842, 'ENERGY', 74, 74, '2015-09-20', '2015-08-20', '2016-05-04', 0, 4381.6650, 0.0000, 290.0000, 4671.6650, '2016-04-10 14:38:45', 'dbo', ''),
(2015090020, 201509, 10, 20, '2016-04-25', 843, 'ENERGY', 138, 131, '2015-09-20', '2015-08-20', '2016-05-04', 7, 6027.3430, 0.0000, 414.0300, 6441.3730, '2016-04-10 14:38:45', 'dbo', ''),
(2015090021, 201509, 10, 21, '2016-04-25', 844, 'ENERGY', 21932, 20854, '2015-09-20', '2015-08-20', '2016-05-04', 1078, 595489.1346, 0.0000, 19390.4600, 614879.5946, '2016-04-10 14:38:45', 'dbo', ''),
(2015090022, 201509, 10, 22, '2016-04-25', 845, 'ENERGY', 13649, 13045, '2015-09-20', '2015-08-20', '2016-05-04', 604, 368503.9716, 0.0000, 10991.9300, 379495.9016, '2016-04-10 14:38:45', 'dbo', ''),
(2015090023, 201509, 10, 23, '2016-04-25', 846, 'ENERGY', 31042, 29526, '2015-09-20', '2015-08-20', '2016-05-04', 1516, 872855.7770, 0.0000, 27151.1300, 900006.9070, '2016-04-10 14:38:45', 'dbo', ''),
(2015090024, 201509, 10, 24, '2016-04-25', 847, 'ENERGY', 27916, 26280, '2015-09-20', '2015-08-20', '2016-05-04', 1636, 767010.4900, 0.0000, 29277.3400, 796287.8300, '2016-04-10 14:38:45', 'dbo', ''),
(2015090025, 201509, 10, 25, '2016-04-25', 848, 'ENERGY', 62, 62, '2015-09-20', '2015-08-20', '2016-05-04', 0, 1204.1000, 0.0000, 290.0000, 1494.1000, '2016-04-10 14:38:45', 'dbo', ''),
(2015090026, 201509, 10, 26, '2016-04-25', 849, 'ENERGY', 15269, 13759, '2015-09-20', '2015-08-20', '2016-05-04', 1510, 290019.2174, 0.0000, 27044.8200, 317064.0374, '2016-04-10 14:38:45', 'dbo', ''),
(2015090029, 201509, 10, 29, '2016-04-25', 852, 'ENERGY', 37768, 35928, '2015-09-20', '2015-08-20', '2016-05-04', 1840, 577244.0888, 0.0000, 32891.8900, 610135.9788, '2016-04-10 14:38:45', 'dbo', ''),
(2015090030, 201509, 10, 30, '2016-04-25', 853, 'ENERGY', 16585, 15504, '2015-09-20', '2015-08-20', '2016-05-04', 1081, 139694.3212, 0.0000, 19443.6100, 159137.9312, '2016-04-10 14:38:45', 'dbo', ''),
(2015090031, 201509, 10, 31, '2016-04-25', 854, 'ENERGY', 15670, 13985, '2015-09-20', '2015-08-20', '2016-05-04', 1685, 261353.8080, 0.0000, 30145.5400, 291499.3480, '2016-04-10 14:38:45', 'dbo', ''),
(2015090032, 201509, 10, 32, '2016-04-25', 855, 'ENERGY', 26327, 23408, '2015-09-20', '2015-08-20', '2016-05-04', 2919, 440023.6290, 0.0000, 52010.0800, 492033.7090, '2016-04-10 14:38:45', 'dbo', ''),
(2015090033, 201509, 10, 33, '2016-04-25', 856, 'ENERGY', 2977, 2594, '2015-09-20', '2015-08-20', '2016-05-04', 383, 47784.3134, 0.0000, 7076.1500, 54860.4634, '2016-04-10 14:38:45', 'dbo', ''),
(2015090034, 201509, 10, 34, '2016-04-25', 857, 'ENERGY', 2104, 1781, '2015-09-20', '2015-08-20', '2016-05-04', 323, 33258.6742, 0.0000, 6013.0500, 39271.7242, '2016-04-10 14:38:45', 'dbo', ''),
(2015090035, 201509, 10, 35, '2016-04-25', 858, 'ENERGY', 4359, 3837, '2015-09-20', '2015-08-20', '2016-05-04', 522, 64902.6126, 0.0000, 9539.0200, 74441.6326, '2016-04-10 14:38:45', 'dbo', ''),
(2015090036, 201509, 10, 36, '2016-04-25', 859, 'ENERGY', 8027, 6824, '2015-09-20', '2015-08-20', '2016-05-04', 1203, 125609.8838, 0.0000, 21605.2600, 147215.1438, '2016-04-10 14:38:45', 'dbo', ''),
(2015090037, 201509, 10, 37, '2016-04-25', 860, 'ENERGY', 6255, 5363, '2015-09-20', '2015-08-20', '2016-05-04', 892, 97566.8410, 0.0000, 16094.8300, 113661.6710, '2016-04-10 14:38:45', 'dbo', ''),
(2015090038, 201509, 10, 38, '2016-04-25', 861, 'ENERGY', 2686, 2312, '2015-09-20', '2015-08-20', '2016-05-04', 374, 43070.8634, 0.0000, 6916.6900, 49987.5534, '2016-04-10 14:38:45', 'dbo', ''),
(2015090039, 201509, 10, 39, '2016-04-25', 862, 'ENERGY', 4997, 4316, '2015-09-20', '2015-08-20', '2016-05-04', 681, 29187.4782, 0.0000, 12356.2500, 41543.7282, '2016-04-10 14:38:45', 'dbo', ''),
(2015090040, 201509, 10, 40, '2016-04-25', 863, 'ENERGY', 4975, 4263, '2015-09-20', '2015-08-20', '2016-05-04', 712, 78433.2396, 0.0000, 12905.5200, 91338.7596, '2016-04-10 14:38:45', 'dbo', ''),
(2015090041, 201509, 10, 41, '2016-04-25', 864, 'ENERGY', 115, 88, '2015-09-20', '2015-08-20', '2016-05-04', 27, 5055.8500, 0.0000, 768.3900, 5824.2400, '2016-04-10 14:38:45', 'dbo', ''),
(2015090042, 201509, 10, 42, '2016-04-25', 865, 'ENERGY', 126, 126, '2015-09-20', '2015-08-20', '2016-05-04', 0, 4676.9060, 0.0000, 290.0000, 4966.9060, '2016-04-10 14:38:45', 'dbo', ''),
(2015090043, 201509, 10, 43, '2016-04-25', 866, 'ENERGY', 21595, 19829, '2015-09-20', '2015-08-20', '2016-05-04', 1766, 500302.8102, 0.0000, 31580.7400, 531883.5502, '2016-04-10 14:38:45', 'dbo', ''),
(2015090044, 201509, 10, 44, '2016-04-25', 867, 'ENERGY', 2455, 1509, '2015-09-20', '2015-08-20', '2016-05-04', 946, 32811.2230, 0.0000, 17051.6300, 49862.8530, '2016-04-10 14:38:45', 'dbo', ''),
(2015090045, 201509, 10, 45, '2016-04-25', 868, 'ENERGY', 15301, 14456, '2015-09-20', '2015-08-20', '2016-05-04', 845, 120599.0220, 0.0000, 15262.0600, 135861.0820, '2016-04-10 14:38:45', 'dbo', ''),
(2015090046, 201509, 10, 46, '2016-04-25', 869, 'ENERGY', 17729, 16430, '2015-09-20', '2015-08-20', '2016-05-04', 1299, 240411.0954, 0.0000, 23306.2300, 263717.3254, '2016-04-10 14:38:45', 'dbo', ''),
(2015090047, 201509, 10, 47, '2016-04-25', 870, 'ENERGY', 10170, 9533, '2015-09-20', '2015-08-20', '2016-05-04', 637, 87788.8210, 0.0000, 11576.6300, 99365.4510, '2016-04-10 14:38:45', 'dbo', ''),
(2015090048, 201509, 10, 48, '2016-04-25', 871, 'ENERGY', 90, 90, '2015-09-20', '2015-08-20', '2016-05-04', 0, 4690.0800, 0.0000, 290.0000, 4980.0800, '2016-04-10 14:38:45', 'dbo', ''),
(2015090049, 201509, 10, 49, '2016-04-25', 872, 'ENERGY', 1541, 1367, '2015-09-20', '2015-08-20', '2016-05-04', 174, 22788.2390, 0.0000, 3373.0000, 26161.2390, '2016-04-10 14:38:45', 'dbo', ''),
(2015090050, 201509, 10, 50, '2016-04-25', 873, 'ENERGY', 23538, 21318, '2015-09-20', '2015-08-20', '2016-05-04', 2220, 379570.6492, 0.0000, 39624.9000, 419195.5492, '2016-04-10 14:38:45', 'dbo', ''),
(2015090051, 201509, 10, 51, '2016-04-25', 874, 'ENERGY', 211, 211, '2015-09-20', '2015-08-20', '2016-05-04', 0, 869.9990, 0.0000, 290.0000, 1159.9990, '2016-04-10 14:38:45', 'dbo', ''),
(2015090052, 201509, 10, 52, '2016-04-25', 875, 'ENERGY', 108, 95, '2015-09-20', '2015-08-20', '2016-05-04', 13, 923.8420, 0.0000, 520.3400, 1444.1820, '2016-04-10 14:38:45', 'dbo', ''),
(2015090053, 201509, 10, 53, '2016-04-25', 876, 'ENERGY', 72, 71, '2015-09-20', '2015-08-20', '2016-05-04', 1, 4504.2370, 0.0000, 307.7200, 4811.9570, '2016-04-10 14:38:45', 'dbo', ''),
(2015090054, 201509, 10, 54, '2016-04-25', 877, 'ENERGY', 9266, 8604, '2015-09-20', '2015-08-20', '2016-05-04', 662, 215420.2894, 0.0000, 12019.6000, 227439.8894, '2016-04-10 14:38:45', 'dbo', ''),
(2015090055, 201509, 10, 55, '2016-04-25', 878, 'ENERGY', 1432, 825, '2015-09-20', '2015-08-20', '2016-05-04', 607, 18125.6700, 0.0000, 11045.0800, 29170.7500, '2016-04-10 14:38:45', 'dbo', ''),
(2015090056, 201509, 10, 56, '2016-04-25', 879, 'ENERGY', 81, 81, '2015-09-20', '2015-08-20', '2016-05-04', 0, 1281.8390, 0.0000, 290.0000, 1571.8390, '2016-04-10 14:38:45', 'dbo', ''),
(2015090059, 201509, 10, 59, '2016-04-25', 882, 'ENERGY', 23, 23, '2015-09-20', '2015-08-20', '2016-05-04', 0, 1264.7500, 0.0000, 290.0000, 1554.7500, '2016-04-10 14:38:45', 'dbo', ''),
(2015090060, 201509, 10, 60, '2016-04-25', 883, 'ENERGY', 32253, 26692, '2015-09-20', '2015-08-20', '2016-05-04', 5561, 513704.9600, 0.0000, 98822.1400, 612527.1000, '2016-04-10 14:38:45', 'dbo', ''),
(2015090061, 201509, 10, 61, '2016-04-25', 884, 'ENERGY', 3, 3, '2015-09-20', '2015-08-20', '2016-05-04', 0, 870.0000, 0.0000, 290.0000, 1160.0000, '2016-04-10 14:38:45', 'dbo', ''),
(2015090062, 201509, 10, 62, '2016-04-25', 885, 'ENERGY', 30, 30, '2015-09-20', '2015-08-20', '2016-05-04', 0, 870.0000, 0.0000, 290.0000, 1160.0000, '2016-04-10 14:38:45', 'dbo', ''),
(2015090063, 201509, 10, 63, '2016-04-25', 886, 'ENERGY', 1, 1, '2015-09-20', '2015-08-20', '2016-05-04', 0, 870.0000, 0.0000, 290.0000, 1160.0000, '2016-04-10 14:38:45', 'dbo', ''),
(2015090064, 201509, 10, 64, '2016-04-25', 887, 'ENERGY', 2, 2, '2015-09-20', '2015-08-20', '2016-05-04', 0, 870.0000, 0.0000, 290.0000, 1160.0000, '2016-04-10 14:38:45', 'dbo', ''),
(2015090065, 201509, 10, 65, '2016-04-25', 888, 'ENERGY', 15, 15, '2015-09-20', '2015-08-20', '2016-05-04', 0, 2958.9180, 0.0000, 290.0000, 3248.9180, '2016-04-10 14:38:45', 'dbo', ''),
(2015090066, 201509, 10, 66, '2016-04-25', 889, 'ENERGY', 122, 122, '2015-09-20', '2015-08-20', '2016-05-04', 0, 5861.8324, 0.0000, 290.0000, 6151.8324, '2016-04-10 14:38:45', 'dbo', ''),
(2015090067, 201509, 10, 67, '2016-04-25', 890, 'ENERGY', 101, 101, '2015-09-20', '2015-08-20', '2016-05-04', 0, 5974.1138, 0.0000, 290.0000, 6264.1138, '2016-04-10 14:38:45', 'dbo', ''),
(2015090068, 201509, 10, 68, '2016-04-25', 891, 'ENERGY', 186, 176, '2015-09-20', '2015-08-20', '2016-05-04', 10, 5843.7700, 0.0000, 467.1800, 6310.9500, '2016-04-10 14:38:45', 'dbo', ''),
(2015090069, 201509, 10, 69, '2016-04-25', 892, 'ENERGY', 1, 1, '2015-09-20', '2015-08-20', '2016-05-04', 0, 2610.0000, 0.0000, 290.0000, 2900.0000, '2016-04-10 14:38:45', 'dbo', ''),
(2015090070, 201509, 10, 70, '2016-04-25', 893, 'ENERGY', 211, 211, '2015-09-20', '2015-08-20', '2016-05-04', 0, 6685.5000, 0.0000, 290.0000, 6975.5000, '2016-04-10 14:38:45', 'dbo', ''),
(2015090071, 201509, 10, 71, '2016-04-25', 894, 'ENERGY', 204, 204, '2015-09-20', '2015-08-20', '2016-05-04', 0, 7552.0162, 0.0000, 290.0000, 7842.0162, '2016-04-10 14:38:45', 'dbo', ''),
(2015090072, 201509, 10, 72, '2016-04-25', 895, 'ENERGY', 32, 32, '2015-09-20', '2015-08-20', '2016-05-04', 0, 2647.2300, 0.0000, 290.0000, 2937.2300, '2016-04-10 14:38:45', 'dbo', ''),
(2015090073, 201509, 10, 73, '2016-04-25', 896, 'ENERGY', 290, 282, '2015-09-20', '2015-08-20', '2016-05-04', 8, 13867.1580, 0.0000, 431.7500, 14298.9080, '2016-04-10 14:38:45', 'dbo', ''),
(2015090075, 201509, 10, 75, '2016-04-25', 897, 'ENERGY', 138, 138, '2015-09-20', '2015-08-20', '2016-05-04', 0, 3346.1900, 0.0000, 290.0000, 3636.1900, '2016-04-10 14:38:45', 'dbo', ''),
(2015090076, 201509, 10, 76, '2016-04-25', 898, 'ENERGY', 242, 242, '2015-09-20', '2015-08-20', '2016-05-04', 0, 5212.3100, 0.0000, 290.0000, 5502.3100, '2016-04-10 14:38:45', 'dbo', ''),
(2015090077, 201509, 10, 77, '2016-04-25', 899, 'ENERGY', 244, 244, '2015-09-20', '2015-08-20', '2016-05-04', 0, 5248.1900, 0.0000, 290.0000, 5538.1900, '2016-04-10 14:38:45', 'dbo', ''),
(2015090078, 201509, 10, 78, '2016-04-25', 900, 'ENERGY', 25, 25, '2015-09-20', '2015-08-20', '2016-05-04', 0, 1318.5800, 0.0000, 290.0000, 1608.5800, '2016-04-10 14:38:45', 'dbo', ''),
(2015100001, 201510, 11, 1, '2016-04-25', 901, 'ENERGY', 133, 86, '2015-10-20', '2015-09-20', '2016-05-04', 47, 4635.8914, 0.0000, 909.8100, 5545.7014, '2016-04-25 07:49:28', 'dbo', ''),
(2015100002, 201510, 11, 2, '2016-04-25', 902, 'ENERGY', 185, 181, '2015-10-20', '2015-09-20', '2016-05-04', 4, 7657.9010, 0.0000, 77.4300, 7735.3310, '2016-04-25 07:49:28', 'dbo', ''),
(2015100003, 201510, 11, 3, '2016-04-25', 903, 'ENERGY', 94, 69, '2015-10-20', '2015-09-20', '2016-05-04', 25, 3687.9934, 0.0000, 483.9400, 4171.9334, '2016-04-25 07:49:28', 'dbo', ''),
(2015100004, 201510, 11, 4, '2016-04-25', 904, 'ENERGY', 150, 128, '2015-10-20', '2015-09-20', '2016-05-04', 22, 4959.3522, 0.0000, 425.8700, 5385.2222, '2016-04-25 07:49:28', 'dbo', ''),
(2015100005, 201510, 11, 5, '2016-04-25', 905, 'ENERGY', 132, 114, '2015-10-20', '2015-09-20', '2016-05-04', 18, 5186.4786, 0.0000, 348.4400, 5534.9186, '2016-04-25 07:49:28', 'dbo', ''),
(2015100006, 201510, 11, 6, '2016-04-25', 906, 'ENERGY', 79, 70, '2015-10-20', '2015-09-20', '2016-05-04', 9, 3809.0368, 0.0000, 174.2200, 3983.2568, '2016-04-25 07:49:28', 'dbo', ''),
(2015100007, 201510, 11, 7, '2016-04-25', 907, 'ENERGY', 78, 70, '2015-10-20', '2015-09-20', '2016-05-04', 8, 4338.2500, 0.0000, 154.8600, 4493.1100, '2016-04-25 07:49:28', 'dbo', ''),
(2015100008, 201510, 11, 8, '2016-04-25', 908, 'ENERGY', 121, 118, '2015-10-20', '2015-09-20', '2016-05-04', 3, 5155.2176, 0.0000, 58.0800, 5213.2976, '2016-04-25 07:49:28', 'dbo', ''),
(2015100009, 201510, 11, 9, '2016-04-25', 909, 'ENERGY', 63, 63, '2015-10-20', '2015-09-20', '2016-05-04', 0, 3713.4164, 0.0000, 0.0000, 3713.4164, '2016-04-25 07:49:28', 'dbo', ''),
(2015100010, 201510, 11, 10, '2016-04-25', 910, 'ENERGY', 70, 70, '2015-10-20', '2015-09-20', '2016-05-04', 0, 3809.3280, 0.0000, 0.0000, 3809.3280, '2016-04-25 07:49:28', 'dbo', ''),
(2015100011, 201510, 11, 11, '2016-04-25', 911, 'ENERGY', 130, 130, '2015-10-20', '2015-09-20', '2016-05-04', 0, 6454.3910, 0.0000, 0.0000, 6454.3910, '2016-04-25 07:49:28', 'dbo', ''),
(2015100012, 201510, 11, 12, '2016-04-25', 912, 'ENERGY', 46, 46, '2015-10-20', '2015-09-20', '2016-05-04', 0, 3284.2800, 0.0000, 0.0000, 3284.2800, '2016-04-25 07:49:28', 'dbo', ''),
(2015100013, 201510, 11, 13, '2016-04-25', 913, 'ENERGY', 78, 78, '2015-10-20', '2015-09-20', '2016-05-04', 0, 4690.4940, 0.0000, 0.0000, 4690.4940, '2016-04-25 07:49:28', 'dbo', ''),
(2015100014, 201510, 11, 14, '2016-04-25', 914, 'ENERGY', 170, 170, '2015-10-20', '2015-09-20', '2016-05-04', 0, 6583.3754, 0.0000, 0.0000, 6583.3754, '2016-04-25 07:49:28', 'dbo', ''),
(2015100015, 201510, 11, 15, '2016-04-25', 915, 'ENERGY', 121, 110, '2015-10-20', '2015-09-20', '2016-05-04', 11, 4716.6690, 0.0000, 212.9300, 4929.5990, '2016-04-25 07:49:28', 'dbo', ''),
(2015100016, 201510, 11, 16, '2016-04-25', 916, 'ENERGY', 68, 67, '2015-10-20', '2015-09-20', '2016-05-04', 1, 3761.2520, 0.0000, 19.3600, 3780.6120, '2016-04-25 07:49:28', 'dbo', ''),
(2015100017, 201510, 11, 17, '2016-04-25', 917, 'ENERGY', 163, 163, '2015-10-20', '2015-09-20', '2016-05-04', 0, 5953.0770, 0.0000, 0.0000, 5953.0770, '2016-04-25 07:49:28', 'dbo', ''),
(2015100018, 201510, 11, 18, '2016-04-25', 918, 'ENERGY', 46, 46, '2015-10-20', '2015-09-20', '2016-05-04', 0, 3373.0700, 0.0000, 0.0000, 3373.0700, '2016-04-25 07:49:28', 'dbo', ''),
(2015100019, 201510, 11, 19, '2016-04-25', 919, 'ENERGY', 74, 74, '2015-10-20', '2015-09-20', '2016-05-04', 0, 4671.6650, 0.0000, 0.0000, 4671.6650, '2016-04-25 07:49:28', 'dbo', ''),
(2015100020, 201510, 11, 20, '2016-04-25', 920, 'ENERGY', 138, 138, '2015-10-20', '2015-09-20', '2016-05-04', 0, 6441.3730, 0.0000, 0.0000, 6441.3730, '2016-04-25 07:49:28', 'dbo', ''),
(2015100021, 201510, 11, 21, '2016-04-25', 921, 'ENERGY', 22877, 21932, '2015-10-20', '2015-09-20', '2016-05-04', 945, 614879.5946, 0.0000, 18292.9100, 633172.5046, '2016-04-25 07:49:28', 'dbo', ''),
(2015100022, 201510, 11, 22, '2016-04-25', 922, 'ENERGY', 14138, 13649, '2015-10-20', '2015-09-20', '2016-05-04', 489, 379495.9016, 0.0000, 9465.8500, 388961.7516, '2016-04-25 07:49:28', 'dbo', ''),
(2015100023, 201510, 11, 23, '2016-04-25', 923, 'ENERGY', 32444, 31042, '2015-10-20', '2015-09-20', '2016-05-04', 1402, 900006.9070, 0.0000, 27139.3300, 927146.2370, '2016-04-25 07:49:28', 'dbo', ''),
(2015100024, 201510, 11, 24, '2016-04-25', 924, 'ENERGY', 29355, 27916, '2015-10-20', '2015-09-20', '2016-05-04', 1439, 796287.8300, 0.0000, 27855.5500, 824143.3800, '2016-04-25 07:49:28', 'dbo', ''),
(2015100025, 201510, 11, 25, '2016-04-25', 925, 'ENERGY', 63, 62, '2015-10-20', '2015-09-20', '2016-05-04', 1, 1494.1000, 0.0000, 19.3600, 1513.4600, '2016-04-25 07:49:28', 'dbo', ''),
(2015100026, 201510, 11, 26, '2016-04-25', 926, 'ENERGY', 16665, 15269, '2015-10-20', '2015-09-20', '2016-05-04', 1396, 317064.0374, 31797.4100, 27023.1900, 312289.8174, '2016-04-25 07:49:28', 'dbo', ''),
(2015100029, 201510, 11, 29, '2016-04-25', 929, 'ENERGY', 39539, 37768, '2015-10-20', '2015-09-20', '2016-05-04', 1771, 610135.9788, 0.0000, 34282.2800, 644418.2588, '2016-04-25 07:49:28', 'dbo', ''),
(2015100030, 201510, 11, 30, '2016-04-25', 930, 'ENERGY', 17588, 16585, '2015-10-20', '2015-09-20', '2016-05-04', 1003, 159137.9312, 0.0000, 19415.6600, 178553.5912, '2016-04-25 07:49:28', 'dbo', ''),
(2015100031, 201510, 11, 31, '2016-04-25', 931, 'ENERGY', 17310, 15670, '2015-10-20', '2015-09-20', '2016-05-04', 1640, 291499.3480, 0.0000, 31746.4400, 323245.7880, '2016-04-25 07:49:28', 'dbo', ''),
(2015100032, 201510, 11, 32, '2016-04-25', 932, 'ENERGY', 29009, 26327, '2015-10-20', '2015-09-20', '2016-05-04', 2682, 492033.7090, 0.0000, 51917.0400, 543950.7490, '2016-04-25 07:49:28', 'dbo', ''),
(2015100033, 201510, 11, 33, '2016-04-25', 933, 'ENERGY', 3404, 2977, '2015-10-20', '2015-09-20', '2016-05-04', 427, 54860.4634, 0.0000, 8265.6900, 63126.1534, '2016-04-25 07:49:28', 'dbo', ''),
(2015100034, 201510, 11, 34, '2016-04-25', 934, 'ENERGY', 2318, 2104, '2015-10-20', '2015-09-20', '2016-05-04', 214, 39271.7242, 0.0000, 4142.5200, 43414.2442, '2016-04-25 07:49:28', 'dbo', ''),
(2015100035, 201510, 11, 35, '2016-04-25', 935, 'ENERGY', 4904, 4359, '2015-10-20', '2015-09-20', '2016-05-04', 545, 74441.6326, 0.0000, 10549.8800, 84991.5126, '2016-04-25 07:49:28', 'dbo', ''),
(2015100036, 201510, 11, 36, '2016-04-25', 936, 'ENERGY', 9203, 8027, '2015-10-20', '2015-09-20', '2016-05-04', 1176, 147215.1438, 0.0000, 22764.5100, 169979.6538, '2016-04-25 07:49:28', 'dbo', ''),
(2015100037, 201510, 11, 37, '2016-04-25', 937, 'ENERGY', 6980, 6255, '2015-10-20', '2015-09-20', '2016-05-04', 725, 113661.6710, 0.0000, 14034.2500, 127695.9210, '2016-04-25 07:49:28', 'dbo', ''),
(2015100038, 201510, 11, 38, '2016-04-25', 938, 'ENERGY', 3082, 2686, '2015-10-20', '2015-09-20', '2016-05-04', 396, 49987.5534, 0.0000, 7665.6000, 57653.1534, '2016-04-25 07:49:28', 'dbo', ''),
(2015100039, 201510, 11, 39, '2016-04-25', 939, 'ENERGY', 6038, 4997, '2015-10-20', '2015-09-20', '2016-05-04', 1041, 41543.7282, 0.0000, 20151.2500, 61694.9782, '2016-04-25 07:49:29', 'dbo', ''),
(2015100040, 201510, 11, 40, '2016-04-25', 940, 'ENERGY', 5668, 4975, '2015-10-20', '2015-09-20', '2016-05-04', 693, 91338.7596, 0.0000, 13414.8000, 104753.5596, '2016-04-25 07:49:29', 'dbo', ''),
(2015100041, 201510, 11, 41, '2016-04-25', 941, 'ENERGY', 115, 115, '2015-10-20', '2015-09-20', '2016-05-04', 0, 5824.2400, 0.0000, 0.0000, 5824.2400, '2016-04-25 07:49:28', 'dbo', ''),
(2015100042, 201510, 11, 42, '2016-04-25', 942, 'ENERGY', 126, 126, '2015-10-20', '2015-09-20', '2016-05-04', 0, 4966.9060, 0.0000, 0.0000, 4966.9060, '2016-04-25 07:49:28', 'dbo', ''),
(2015100043, 201510, 11, 43, '2016-04-25', 943, 'ENERGY', 23172, 21595, '2015-10-20', '2015-09-20', '2016-05-04', 1577, 531883.5502, 280000.0000, 30526.9100, 282410.4602, '2016-04-25 07:49:28', 'dbo', ''),
(2015100044, 201510, 11, 44, '2016-04-25', 944, 'ENERGY', 3351, 2455, '2015-10-20', '2015-09-20', '2016-05-04', 896, 49862.8530, 0.0000, 17344.3900, 67207.2430, '2016-04-25 07:49:28', 'dbo', ''),
(2015100045, 201510, 11, 45, '2016-04-25', 945, 'ENERGY', 16024, 15301, '2015-10-20', '2015-09-20', '2016-05-04', 723, 135861.0820, 0.0000, 13995.5300, 149856.6120, '2016-04-25 07:49:28', 'dbo', ''),
(2015100046, 201510, 11, 46, '2016-04-25', 946, 'ENERGY', 18963, 17729, '2015-10-20', '2015-09-20', '2016-05-04', 1234, 263717.3254, 0.0000, 23887.2500, 287604.5754, '2016-04-25 07:49:28', 'dbo', ''),
(2015100047, 201510, 11, 47, '2016-04-25', 947, 'ENERGY', 10771, 10170, '2015-10-20', '2015-09-20', '2016-05-04', 601, 99365.4510, 62194.8300, 11633.9000, 48804.5210, '2016-04-25 07:49:28', 'dbo', ''),
(2015100048, 201510, 11, 48, '2016-04-25', 948, 'ENERGY', 90, 90, '2015-10-20', '2015-09-20', '2016-05-04', 0, 4980.0800, 4090.6300, 0.0000, 889.4500, '2016-04-25 07:49:28', 'dbo', ''),
(2015100049, 201510, 11, 49, '2016-04-25', 949, 'ENERGY', 1719, 1541, '2015-10-20', '2015-09-20', '2016-05-04', 178, 26161.2390, 0.0000, 3445.6500, 29606.8890, '2016-04-25 07:49:28', 'dbo', ''),
(2015100050, 201510, 11, 50, '2016-04-25', 950, 'ENERGY', 26029, 23538, '2015-10-20', '2015-09-20', '2016-05-04', 2491, 419195.5492, 0.0000, 48219.7300, 467415.2792, '2016-04-25 07:49:28', 'dbo', ''),
(2015100051, 201510, 11, 51, '2016-04-25', 951, 'ENERGY', 211, 211, '2015-10-20', '2015-09-20', '2016-05-04', 0, 1159.9990, 0.0000, 0.0000, 1159.9990, '2016-04-25 07:49:28', 'dbo', ''),
(2015100052, 201510, 11, 52, '2016-04-25', 952, 'ENERGY', 122, 108, '2015-10-20', '2015-09-20', '2016-05-04', 14, 1444.1820, 0.0000, 271.0100, 1715.1920, '2016-04-25 07:49:28', 'dbo', ''),
(2015100053, 201510, 11, 53, '2016-04-25', 953, 'ENERGY', 72, 72, '2015-10-20', '2015-09-20', '2016-05-04', 0, 4811.9570, 0.0000, 0.0000, 4811.9570, '2016-04-25 07:49:29', 'dbo', ''),
(2015100054, 201510, 11, 54, '2016-04-25', 954, 'ENERGY', 9968, 9266, '2015-10-20', '2015-09-20', '2016-05-04', 702, 227439.8894, 0.0000, 13589.0200, 241028.9094, '2016-04-25 07:49:29', 'dbo', ''),
(2015100055, 201510, 11, 55, '2016-04-25', 955, 'ENERGY', 1860, 1432, '2015-10-20', '2015-09-20', '2016-05-04', 428, 29170.7500, 0.0000, 8285.0500, 37455.8000, '2016-04-25 07:49:29', 'dbo', ''),
(2015100056, 201510, 11, 56, '2016-04-25', 956, 'ENERGY', 81, 81, '2015-10-20', '2015-09-20', '2016-05-04', 0, 1571.8390, 0.0000, 0.0000, 1571.8390, '2016-04-25 07:49:29', 'dbo', ''),
(2015100059, 201510, 11, 59, '2016-04-25', 959, 'ENERGY', 23, 23, '2015-10-20', '2015-09-20', '2016-05-04', 0, 1554.7500, 0.0000, 0.0000, 1554.7500, '2016-04-25 07:49:28', 'dbo', ''),
(2015100060, 201510, 11, 60, '2016-04-25', 960, 'ENERGY', 38371, 32253, '2015-10-20', '2015-09-20', '2016-05-04', 6118, 612527.1000, 0.0000, 118429.6800, 730956.7800, '2016-04-25 07:49:28', 'dbo', ''),
(2015100061, 201510, 11, 61, '2016-04-25', 961, 'ENERGY', 3, 3, '2015-10-20', '2015-09-20', '2016-05-04', 0, 1160.0000, 0.0000, 0.0000, 1160.0000, '2016-04-25 07:49:28', 'dbo', ''),
(2015100062, 201510, 11, 62, '2016-04-25', 962, 'ENERGY', 30, 30, '2015-10-20', '2015-09-20', '2016-05-04', 0, 1160.0000, 0.0000, 0.0000, 1160.0000, '2016-04-25 07:49:28', 'dbo', ''),
(2015100063, 201510, 11, 63, '2016-04-25', 963, 'ENERGY', 1, 1, '2015-10-20', '2015-09-20', '2016-05-04', 0, 1160.0000, 0.0000, 0.0000, 1160.0000, '2016-04-25 07:49:28', 'dbo', ''),
(2015100064, 201510, 11, 64, '2016-04-25', 964, 'ENERGY', 2, 2, '2015-10-20', '2015-09-20', '2016-05-04', 0, 1160.0000, 0.0000, 0.0000, 1160.0000, '2016-04-25 07:49:28', 'dbo', ''),
(2015100065, 201510, 11, 65, '2016-04-25', 965, 'ENERGY', 22, 15, '2015-10-20', '2015-09-20', '2016-05-04', 7, 3248.9180, 0.0000, 135.5000, 3384.4180, '2016-04-25 07:49:28', 'dbo', ''),
(2015100066, 201510, 11, 66, '2016-04-25', 966, 'ENERGY', 124, 122, '2015-10-20', '2015-09-20', '2016-05-04', 2, 6151.8324, 0.0000, 38.7100, 6190.5424, '2016-04-25 07:49:28', 'dbo', ''),
(2015100067, 201510, 11, 67, '2016-04-25', 967, 'ENERGY', 101, 101, '2015-10-20', '2015-09-20', '2016-05-04', 0, 6264.1138, 0.0000, 0.0000, 6264.1138, '2016-04-25 07:49:29', 'dbo', ''),
(2015100068, 201510, 11, 68, '2016-04-25', 968, 'ENERGY', 196, 186, '2015-10-20', '2015-09-20', '2016-05-04', 10, 6310.9500, 0.0000, 193.5800, 6504.5300, '2016-04-25 07:49:29', 'dbo', ''),
(2015100069, 201510, 11, 69, '2016-04-25', 969, 'ENERGY', 1, 1, '2015-10-20', '2015-09-20', '2016-05-04', 0, 2900.0000, 0.0000, 0.0000, 2900.0000, '2016-04-25 07:49:28', 'dbo', ''),
(2015100070, 201510, 11, 70, '2016-04-25', 970, 'ENERGY', 230, 211, '2015-10-20', '2015-09-20', '2016-05-04', 19, 6975.5000, 0.0000, 367.8000, 7343.3000, '2016-04-25 07:49:29', 'dbo', ''),
(2015100071, 201510, 11, 71, '2016-04-25', 971, 'ENERGY', 387, 204, '2015-10-20', '2015-09-20', '2016-05-04', 183, 7842.0162, 0.0000, 3542.4400, 11384.4562, '2016-04-25 07:49:28', 'dbo', ''),
(2015100072, 201510, 11, 72, '2016-04-25', 972, 'ENERGY', 39, 32, '2015-10-20', '2015-09-20', '2016-05-04', 7, 2937.2300, 0.0000, 135.5000, 3072.7300, '2016-04-25 07:49:28', 'dbo', ''),
(2015100073, 201510, 11, 73, '2016-04-25', 973, 'ENERGY', 295, 290, '2015-10-20', '2015-09-20', '2016-05-04', 5, 14298.9080, 0.0000, 96.7900, 14395.6980, '2016-04-25 07:49:28', 'dbo', ''),
(2015100075, 201510, 11, 75, '2016-04-25', 974, 'ENERGY', 138, 138, '2015-10-20', '2015-09-20', '2016-05-04', 0, 3636.1900, 0.0000, 0.0000, 3636.1900, '2016-04-25 07:49:28', 'dbo', ''),
(2015100076, 201510, 11, 76, '2016-04-25', 975, 'ENERGY', 242, 242, '2015-10-20', '2015-09-20', '2016-05-04', 0, 5502.3100, 0.0000, 0.0000, 5502.3100, '2016-04-25 07:49:28', 'dbo', ''),
(2015100077, 201510, 11, 77, '2016-04-25', 976, 'ENERGY', 244, 244, '2015-10-20', '2015-09-20', '2016-05-04', 0, 5538.1900, 0.0000, 0.0000, 5538.1900, '2016-04-25 07:49:28', 'dbo', ''),
(2015100078, 201510, 11, 78, '2016-04-25', 977, 'ENERGY', 25, 25, '2015-10-20', '2015-09-20', '2016-05-04', 0, 1608.5800, 0.0000, 0.0000, 1608.5800, '2016-04-25 07:49:28', 'dbo', ''),
(2015110001, 201511, 12, 1, '2016-04-25', 1055, 'ENERGY', 300, 133, '2015-11-20', '2015-10-20', '2016-05-04', 167, 5545.7014, 3765.8900, 3359.4800, 5139.2914, '2016-04-25 08:05:26', 'dbo', ''),
(2015110002, 201511, 12, 2, '2016-04-25', 1056, 'ENERGY', 187, 185, '2015-11-20', '2015-10-20', '2016-05-04', 2, 7735.3310, 6614.7600, 326.7600, 1447.3310, '2016-04-25 08:05:26', 'dbo', ''),
(2015110003, 201511, 12, 3, '2016-04-25', 1057, 'ENERGY', 259, 94, '2015-11-20', '2015-10-20', '2016-05-04', 165, 4171.9334, 2759.5100, 3322.7200, 4735.1434, '2016-04-25 08:05:26', 'dbo', ''),
(2015110004, 201511, 12, 4, '2016-04-25', 1058, 'ENERGY', 209, 150, '2015-11-20', '2015-10-20', '2016-05-04', 59, 5385.2222, 4050.4000, 1374.4300, 2709.2522, '2016-04-25 08:05:26', 'dbo', ''),
(2015110005, 201511, 12, 5, '2016-04-25', 1059, 'ENERGY', 179, 132, '2015-11-20', '2015-10-20', '2016-05-04', 47, 5534.9186, 4220.7500, 1153.8600, 2468.0286, '2016-04-25 08:05:26', 'dbo', ''),
(2015110006, 201511, 12, 6, '2016-04-25', 1060, 'ENERGY', 202, 79, '2015-11-20', '2015-10-20', '2016-05-04', 123, 3983.2568, 2939.0400, 2550.7600, 3594.9768, '2016-04-25 08:05:26', 'dbo', ''),
(2015110007, 201511, 12, 7, '2016-04-25', 1061, 'ENERGY', 176, 78, '2015-11-20', '2015-10-20', '2016-05-04', 98, 4493.1100, 3468.2500, 2091.2500, 3116.1100, '2016-04-25 08:05:26', 'dbo', ''),
(2015110008, 201511, 12, 8, '2016-04-25', 1062, 'ENERGY', 104, 121, '2015-11-20', '2015-10-20', '2016-05-04', -17, 5213.2976, 4285.2200, -22.4600, 905.6176, '2016-04-25 08:05:26', 'dbo', ''),
(2015110009, 201511, 12, 9, '2016-04-25', 1063, 'ENERGY', 63, 63, '2015-11-20', '2015-10-20', '2016-05-04', 0, 3713.4164, 0.0000, 290.0000, 4003.4164, '2016-04-25 08:05:26', 'dbo', ''),
(2015110010, 201511, 12, 10, '2016-04-25', 1064, 'ENERGY', 71, 70, '2015-11-20', '2015-10-20', '2016-05-04', 1, 3809.3280, 0.0000, 308.3800, 4117.7080, '2016-04-25 08:05:26', 'dbo', ''),
(2015110011, 201511, 12, 11, '2016-04-25', 1065, 'ENERGY', 131, 130, '2015-11-20', '2015-10-20', '2016-05-04', 1, 6454.3910, 0.0000, 308.3800, 6762.7710, '2016-04-25 08:05:26', 'dbo', ''),
(2015110012, 201511, 12, 12, '2016-04-25', 1066, 'ENERGY', 46, 46, '2015-11-20', '2015-10-20', '2016-05-04', 0, 3284.2800, 0.0000, 290.0000, 3574.2800, '2016-04-25 08:05:26', 'dbo', ''),
(2015110013, 201511, 12, 13, '2016-04-25', 1067, 'ENERGY', 78, 78, '2015-11-20', '2015-10-20', '2016-05-04', 0, 4690.4940, 0.0000, 290.0000, 4980.4940, '2016-04-25 08:05:26', 'dbo', ''),
(2015110014, 201511, 12, 14, '2016-04-25', 1068, 'ENERGY', 170, 170, '2015-11-20', '2015-10-20', '2016-05-04', 0, 6583.3754, 0.0000, 290.0000, 6873.3754, '2016-04-25 08:05:26', 'dbo', ''),
(2015110015, 201511, 12, 15, '2016-04-25', 1069, 'ENERGY', 121, 121, '2015-11-20', '2015-10-20', '2016-05-04', 0, 4929.5990, 0.0000, 290.0000, 5219.5990, '2016-04-25 08:05:26', 'dbo', ''),
(2015110016, 201511, 12, 16, '2016-04-25', 1070, 'ENERGY', 73, 68, '2015-11-20', '2015-10-20', '2016-05-04', 5, 3780.6120, 0.0000, 381.9000, 4162.5120, '2016-04-25 08:05:26', 'dbo', ''),
(2015110017, 201511, 12, 17, '2016-04-25', 1071, 'ENERGY', 163, 163, '2015-11-20', '2015-10-20', '2016-05-04', 0, 5953.0770, 0.0000, 290.0000, 6243.0770, '2016-04-25 08:05:26', 'dbo', ''),
(2015110018, 201511, 12, 18, '2016-04-25', 1072, 'ENERGY', 46, 46, '2015-11-20', '2015-10-20', '2016-05-04', 0, 3373.0700, 0.0000, 290.0000, 3663.0700, '2016-04-25 08:05:26', 'dbo', ''),
(2015110019, 201511, 12, 19, '2016-04-25', 1073, 'ENERGY', 74, 74, '2015-11-20', '2015-10-20', '2016-05-04', 0, 4671.6650, 0.0000, 290.0000, 4961.6650, '2016-04-25 08:05:26', 'dbo', ''),
(2015110020, 201511, 12, 20, '2016-04-25', 1074, 'ENERGY', 138, 138, '2015-11-20', '2015-10-20', '2016-05-04', 0, 6441.3730, 0.0000, 290.0000, 6731.3730, '2016-04-25 08:05:26', 'dbo', '');
INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2015110021, 201511, 12, 21, '2016-04-25', 1075, 'ENERGY', 23958, 22877, '2015-11-20', '2015-10-20', '2016-05-04', 1081, 633172.5046, 0.0000, 20158.9100, 653331.4146, '2016-04-25 08:05:26', 'dbo', ''),
(2015110022, 201511, 12, 22, '2016-04-25', 1076, 'ENERGY', 14816, 14138, '2015-11-20', '2015-10-20', '2016-05-04', 678, 388961.7516, 0.0000, 12751.7200, 401713.4716, '2016-04-25 08:05:26', 'dbo', ''),
(2015110023, 201511, 12, 23, '2016-04-25', 1077, 'ENERGY', 33953, 32444, '2015-11-20', '2015-10-20', '2016-05-04', 1509, 927146.2370, 0.0000, 28025.5900, 955171.8270, '2016-04-25 08:05:26', 'dbo', ''),
(2015110024, 201511, 12, 24, '2016-04-25', 1078, 'ENERGY', 30695, 29355, '2015-11-20', '2015-10-20', '2016-05-04', 1340, 824143.3800, 0.0000, 24919.3600, 849062.7400, '2016-04-25 08:05:26', 'dbo', ''),
(2015110025, 201511, 12, 25, '2016-04-25', 1079, 'ENERGY', 63, 63, '2015-11-20', '2015-10-20', '2016-05-04', 0, 1513.4600, 488.0000, 290.0000, 1315.4600, '2016-04-25 08:05:26', 'dbo', ''),
(2015110026, 201511, 12, 26, '2016-04-25', 1080, 'ENERGY', 18226, 16665, '2015-11-20', '2015-10-20', '2016-05-04', 1561, 312289.8174, 138885.1800, 28981.3600, 202385.9974, '2016-04-25 08:05:26', 'dbo', ''),
(2015110029, 201511, 12, 29, '2016-04-25', 1083, 'ENERGY', 41324, 39539, '2015-11-20', '2015-10-20', '2016-05-04', 1785, 644418.2588, 194133.0000, 33098.5100, 483383.7688, '2016-04-25 08:05:26', 'dbo', ''),
(2015110030, 201511, 12, 30, '2016-04-25', 1084, 'ENERGY', 18640, 17588, '2015-11-20', '2015-10-20', '2016-05-04', 1052, 178553.5912, 98225.0000, 19625.8800, 99954.4712, '2016-04-25 08:05:26', 'dbo', ''),
(2015110031, 201511, 12, 31, '2016-04-25', 1085, 'ENERGY', 19037, 17310, '2015-11-20', '2015-10-20', '2016-05-04', 1727, 323245.7880, 187637.3800, 32032.4700, 167640.8780, '2016-04-25 08:05:26', 'dbo', ''),
(2015110032, 201511, 12, 32, '2016-04-25', 1086, 'ENERGY', 32069, 29009, '2015-11-20', '2015-10-20', '2016-05-04', 3060, 543950.7490, 296805.2200, 56533.1600, 303678.6890, '2016-04-25 08:05:26', 'dbo', ''),
(2015110033, 201511, 12, 33, '2016-04-25', 1087, 'ENERGY', 3785, 3404, '2015-11-20', '2015-10-20', '2016-05-04', 381, 63126.1534, 0.0000, 7292.8300, 70418.9834, '2016-04-25 08:05:25', 'dbo', ''),
(2015110034, 201511, 12, 34, '2016-04-25', 1088, 'ENERGY', 2522, 2318, '2015-11-20', '2015-10-20', '2016-05-04', 204, 43414.2442, 0.0000, 4039.5400, 47453.7842, '2016-04-25 08:05:25', 'dbo', ''),
(2015110035, 201511, 12, 35, '2016-04-25', 1089, 'ENERGY', 5465, 4904, '2015-11-20', '2015-10-20', '2016-05-04', 561, 84991.5126, 0.0000, 10601.2500, 95592.7626, '2016-04-25 08:05:25', 'dbo', ''),
(2015110036, 201511, 12, 36, '2016-04-25', 1090, 'ENERGY', 10590, 9203, '2015-11-20', '2015-10-20', '2016-05-04', 1387, 169979.6538, 0.0000, 25783.2300, 195762.8838, '2016-04-25 08:05:25', 'dbo', ''),
(2015110037, 201511, 12, 37, '2016-04-25', 1091, 'ENERGY', 7705, 6980, '2015-11-20', '2015-10-20', '2016-05-04', 725, 127695.9210, 0.0000, 13615.5800, 141311.5010, '2016-04-25 08:05:26', 'dbo', ''),
(2015110038, 201511, 12, 38, '2016-04-25', 1092, 'ENERGY', 3504, 3082, '2015-11-20', '2015-10-20', '2016-05-04', 422, 57653.1534, 0.0000, 8046.4100, 65699.5634, '2016-04-25 08:05:26', 'dbo', ''),
(2015110039, 201511, 12, 39, '2016-04-25', 1093, 'ENERGY', 7966, 6038, '2015-11-20', '2015-10-20', '2016-05-04', 1928, 61694.9782, 0.0000, 35726.8700, 97421.8482, '2016-04-25 08:05:26', 'dbo', ''),
(2015110040, 201511, 12, 40, '2016-04-25', 1094, 'ENERGY', 6311, 5668, '2015-11-20', '2015-10-20', '2016-05-04', 643, 104753.5596, 0.0000, 12108.4100, 116861.9696, '2016-04-25 08:05:26', 'dbo', ''),
(2015110041, 201511, 12, 41, '2016-04-25', 1095, 'ENERGY', 115, 115, '2015-11-20', '2015-10-20', '2016-05-04', 0, 5824.2400, 0.0000, 290.0000, 6114.2400, '2016-04-25 08:05:25', 'dbo', ''),
(2015110042, 201511, 12, 42, '2016-04-25', 1096, 'ENERGY', 126, 126, '2015-11-20', '2015-10-20', '2016-05-04', 0, 4966.9060, 0.0000, 290.0000, 5256.9060, '2016-04-25 08:05:26', 'dbo', ''),
(2015110043, 201511, 12, 43, '2016-04-25', 1097, 'ENERGY', 24802, 23172, '2015-11-20', '2015-10-20', '2016-05-04', 1630, 282410.4602, 0.0000, 30249.5900, 312660.0502, '2016-04-25 08:05:26', 'dbo', ''),
(2015110044, 201511, 12, 44, '2016-04-25', 1098, 'ENERGY', 4394, 3351, '2015-11-20', '2015-10-20', '2016-05-04', 1043, 67207.2430, 9767.0000, 19460.4700, 76900.7130, '2016-04-25 08:05:26', 'dbo', ''),
(2015110045, 201511, 12, 45, '2016-04-25', 1099, 'ENERGY', 16943, 16024, '2015-11-20', '2015-10-20', '2016-05-04', 919, 149856.6120, 0.0000, 17181.3300, 167037.9420, '2016-04-25 08:05:26', 'dbo', ''),
(2015110046, 201511, 12, 46, '2016-04-25', 1100, 'ENERGY', 20279, 18963, '2015-11-20', '2015-10-20', '2016-05-04', 1316, 287604.5754, 0.0000, 24478.2400, 312082.8154, '2016-04-25 08:05:26', 'dbo', ''),
(2015110047, 201511, 12, 47, '2016-04-25', 1101, 'ENERGY', 11363, 10771, '2015-11-20', '2015-10-20', '2016-05-04', 592, 48804.5210, 0.0000, 11171.0300, 59975.5510, '2016-04-25 08:05:26', 'dbo', ''),
(2015110048, 201511, 12, 48, '2016-04-25', 1102, 'ENERGY', 91, 90, '2015-11-20', '2015-10-20', '2016-05-04', 1, 889.4500, 0.0000, 308.3800, 1197.8300, '2016-04-25 08:05:26', 'dbo', ''),
(2015110049, 201511, 12, 49, '2016-04-25', 1103, 'ENERGY', 1919, 1719, '2015-11-20', '2015-10-20', '2016-05-04', 200, 29606.8890, 15039.0000, 3966.0200, 18533.9090, '2016-04-25 08:05:25', 'dbo', ''),
(2015110050, 201511, 12, 50, '2016-04-25', 1104, 'ENERGY', 28804, 26029, '2015-11-20', '2015-10-20', '2016-05-04', 2775, 467415.2792, 273805.0000, 51294.8300, 244905.1092, '2016-04-25 08:05:25', 'dbo', ''),
(2015110051, 201511, 12, 51, '2016-04-25', 1105, 'ENERGY', 211, 211, '2015-11-20', '2015-10-20', '2016-05-04', 0, 1159.9990, 0.0000, 290.0000, 1449.9990, '2016-04-25 08:05:25', 'dbo', ''),
(2015110052, 201511, 12, 52, '2016-04-25', 1106, 'ENERGY', 136, 122, '2015-11-20', '2015-10-20', '2016-05-04', 14, 1715.1920, 0.0000, 547.3200, 2262.5120, '2016-04-25 08:05:25', 'dbo', ''),
(2015110053, 201511, 12, 53, '2016-04-25', 1107, 'ENERGY', 72, 72, '2015-11-20', '2015-10-20', '2016-05-04', 0, 4811.9570, 0.0000, 290.0000, 5101.9570, '2016-04-25 08:05:26', 'dbo', ''),
(2015110054, 201511, 12, 54, '2016-04-25', 1108, 'ENERGY', 10701, 9968, '2015-11-20', '2015-10-20', '2016-05-04', 733, 241028.9094, 0.0000, 13762.6300, 254791.5394, '2016-04-25 08:05:26', 'dbo', ''),
(2015110055, 201511, 12, 55, '2016-04-25', 1109, 'ENERGY', 2467, 1860, '2015-11-20', '2015-10-20', '2016-05-04', 607, 37455.8000, 0.0000, 11446.7300, 48902.5300, '2016-04-25 08:05:26', 'dbo', ''),
(2015110056, 201511, 12, 56, '2016-04-25', 1110, 'ENERGY', 81, 81, '2015-11-20', '2015-10-20', '2016-05-04', 0, 1571.8390, 0.0000, 290.0000, 1861.8390, '2016-04-25 08:05:26', 'dbo', ''),
(2015110059, 201511, 12, 59, '2016-04-25', 1113, 'ENERGY', 23, 23, '2015-11-20', '2015-10-20', '2016-05-04', 0, 1554.7500, 0.0000, 290.0000, 1844.7500, '2016-04-25 08:05:25', 'dbo', ''),
(2015110060, 201511, 12, 60, '2016-04-25', 1114, 'ENERGY', 45396, 38371, '2015-11-20', '2015-10-20', '2016-05-04', 7025, 730956.7800, 0.0000, 129410.3400, 860367.1200, '2016-04-25 08:05:25', 'dbo', ''),
(2015110061, 201511, 12, 61, '2016-04-25', 1115, 'ENERGY', 3, 3, '2015-11-20', '2015-10-20', '2016-05-04', 0, 1160.0000, 0.0000, 290.0000, 1450.0000, '2016-04-25 08:05:25', 'dbo', ''),
(2015110062, 201511, 12, 62, '2016-04-25', 1116, 'ENERGY', 30, 30, '2015-11-20', '2015-10-20', '2016-05-04', 0, 1160.0000, 0.0000, 290.0000, 1450.0000, '2016-04-25 08:05:25', 'dbo', ''),
(2015110063, 201511, 12, 63, '2016-04-25', 1117, 'ENERGY', 1, 1, '2015-11-20', '2015-10-20', '2016-05-04', 0, 1160.0000, 0.0000, 290.0000, 1450.0000, '2016-04-25 08:05:25', 'dbo', ''),
(2015110064, 201511, 12, 64, '2016-04-25', 1118, 'ENERGY', 2, 2, '2015-11-20', '2015-10-20', '2016-05-04', 0, 1160.0000, 0.0000, 290.0000, 1450.0000, '2016-04-25 08:05:25', 'dbo', ''),
(2015110065, 201511, 12, 65, '2016-04-25', 1119, 'ENERGY', 41, 22, '2015-11-20', '2015-10-20', '2016-05-04', 19, 3384.4180, 0.0000, 639.2200, 4023.6380, '2016-04-25 08:05:25', 'dbo', ''),
(2015110066, 201511, 12, 66, '2016-04-25', 1120, 'ENERGY', 213, 124, '2015-11-20', '2015-10-20', '2016-05-04', 89, 6190.5424, 0.0000, 1925.8300, 8116.3724, '2016-04-25 08:05:25', 'dbo', ''),
(2015110067, 201511, 12, 67, '2016-04-25', 1121, 'ENERGY', 102, 101, '2015-11-20', '2015-10-20', '2016-05-04', 1, 6264.1138, 0.0000, 308.3800, 6572.4938, '2016-04-25 08:05:26', 'dbo', ''),
(2015110068, 201511, 12, 68, '2016-04-25', 1122, 'ENERGY', 207, 196, '2015-11-20', '2015-10-20', '2016-05-04', 11, 6504.5300, 0.0000, 492.1800, 6996.7100, '2016-04-25 08:05:26', 'dbo', ''),
(2015110069, 201511, 12, 69, '2016-04-25', 1123, 'ENERGY', 1, 1, '2015-11-20', '2015-10-20', '2016-05-04', 0, 2900.0000, 0.0000, 290.0000, 3190.0000, '2016-04-25 08:05:25', 'dbo', ''),
(2015110070, 201511, 12, 70, '2016-04-25', 1124, 'ENERGY', 239, 230, '2015-11-20', '2015-10-20', '2016-05-04', 9, 7343.3000, 0.0000, 455.4200, 7798.7200, '2016-04-25 08:05:26', 'dbo', ''),
(2015110071, 201511, 12, 71, '2016-04-25', 1125, 'ENERGY', 463, 387, '2015-11-20', '2015-10-20', '2016-05-04', 76, 11384.4562, 0.0000, 1686.8900, 13071.3462, '2016-04-25 08:05:25', 'dbo', ''),
(2015110072, 201511, 12, 72, '2016-04-25', 1126, 'ENERGY', 39, 39, '2015-11-20', '2015-10-20', '2016-05-04', 0, 3072.7300, 0.0000, 290.0000, 3362.7300, '2016-04-25 08:05:25', 'dbo', ''),
(2015110073, 201511, 12, 73, '2016-04-25', 1127, 'ENERGY', 286, 295, '2015-11-20', '2015-10-20', '2016-05-04', -9, 14395.6980, 0.0000, 124.5800, 14520.2780, '2016-04-25 08:05:25', 'dbo', ''),
(2015110075, 201511, 12, 75, '2016-04-25', 1128, 'ENERGY', 138, 138, '2015-11-20', '2015-10-20', '2016-05-04', 0, 3636.1900, 0.0000, 290.0000, 3926.1900, '2016-04-25 08:05:25', 'dbo', ''),
(2015110076, 201511, 12, 76, '2016-04-25', 1129, 'ENERGY', 242, 242, '2015-11-20', '2015-10-20', '2016-05-04', 0, 5502.3100, 0.0000, 290.0000, 5792.3100, '2016-04-25 08:05:25', 'dbo', ''),
(2015110077, 201511, 12, 77, '2016-04-25', 1130, 'ENERGY', 244, 244, '2015-11-20', '2015-10-20', '2016-05-04', 0, 5538.1900, 0.0000, 290.0000, 5828.1900, '2016-04-25 08:05:25', 'dbo', ''),
(2015110078, 201511, 12, 78, '2016-04-25', 1131, 'ENERGY', 25, 25, '2015-11-20', '2015-10-20', '2016-05-04', 0, 1608.5800, 0.0000, 290.0000, 1898.5800, '2016-04-25 08:05:25', 'dbo', ''),
(2015120001, 201512, 14, 1, '2016-04-25', 1132, 'ENERGY', 342, 300, '2015-12-20', '2015-11-20', '2016-05-04', 42, 5139.2914, 0.0000, 1061.9500, 6201.2414, '2016-04-25 08:31:27', 'dbo', ''),
(2015120002, 201512, 14, 2, '2016-04-25', 1133, 'ENERGY', 553, 187, '2015-12-20', '2015-11-20', '2016-05-04', 366, 1447.3310, 0.0000, 7016.9600, 8464.2910, '2016-04-25 08:31:27', 'dbo', ''),
(2015120003, 201512, 14, 3, '2016-04-25', 1134, 'ENERGY', 564, 259, '2015-12-20', '2015-11-20', '2016-05-04', 305, 4735.1434, 0.0000, 5895.8000, 10630.9434, '2016-04-25 08:31:27', 'dbo', ''),
(2015120004, 201512, 14, 4, '2016-04-25', 1135, 'ENERGY', 323, 209, '2015-12-20', '2015-11-20', '2016-05-04', 114, 2709.2522, 0.0000, 2385.2800, 5094.5322, '2016-04-25 08:31:27', 'dbo', ''),
(2015120005, 201512, 14, 5, '2016-04-25', 1136, 'ENERGY', 492, 179, '2015-12-20', '2015-11-20', '2016-05-04', 313, 2468.0286, 0.0000, 6042.8300, 8510.8586, '2016-04-25 08:31:27', 'dbo', ''),
(2015120006, 201512, 14, 6, '2016-04-25', 1137, 'ENERGY', 565, 202, '2015-12-20', '2015-11-20', '2016-05-04', 363, 3594.9768, 0.0000, 6961.8200, 10556.7968, '2016-04-25 08:31:27', 'dbo', ''),
(2015120007, 201512, 14, 7, '2016-04-25', 1138, 'ENERGY', 270, 176, '2015-12-20', '2015-11-20', '2016-05-04', 94, 3116.1100, 0.0000, 2017.6900, 5133.8000, '2016-04-25 08:31:27', 'dbo', ''),
(2015120008, 201512, 14, 8, '2016-04-25', 1139, 'ENERGY', 148, 104, '2015-12-20', '2015-11-20', '2016-05-04', 44, 905.6176, 0.0000, 1098.7100, 2004.3276, '2016-04-25 08:31:27', 'dbo', ''),
(2015120009, 201512, 14, 9, '2016-04-25', 1140, 'ENERGY', 64, 63, '2015-12-20', '2015-11-20', '2016-05-04', 1, 4003.4164, 0.0000, 308.3800, 4311.7964, '2016-04-25 08:31:27', 'dbo', ''),
(2015120010, 201512, 14, 10, '2016-04-25', 1141, 'ENERGY', 74, 71, '2015-12-20', '2015-11-20', '2016-05-04', 3, 4117.7080, 0.0000, 345.1400, 4462.8480, '2016-04-25 08:31:27', 'dbo', ''),
(2015120011, 201512, 14, 11, '2016-04-25', 1142, 'ENERGY', 181, 131, '2015-12-20', '2015-11-20', '2016-05-04', 50, 6762.7710, 0.0000, 1208.9800, 7971.7510, '2016-04-25 08:31:27', 'dbo', ''),
(2015120012, 201512, 14, 12, '2016-04-25', 1143, 'ENERGY', 46, 46, '2015-12-20', '2015-11-20', '2016-05-04', 0, 3574.2800, 0.0000, 290.0000, 3864.2800, '2016-04-25 08:31:27', 'dbo', ''),
(2015120013, 201512, 14, 13, '2016-04-25', 1144, 'ENERGY', 81, 78, '2015-12-20', '2015-11-20', '2016-05-04', 3, 4980.4940, 0.0000, 345.1400, 5325.6340, '2016-04-25 08:31:27', 'dbo', ''),
(2015120014, 201512, 14, 14, '2016-04-25', 1145, 'ENERGY', 171, 170, '2015-12-20', '2015-11-20', '2016-05-04', 1, 6873.3754, 0.0000, 308.3800, 7181.7554, '2016-04-25 08:31:27', 'dbo', ''),
(2015120015, 201512, 14, 15, '2016-04-25', 1146, 'ENERGY', 153, 121, '2015-12-20', '2015-11-20', '2016-05-04', 32, 5219.5990, 0.0000, 878.1500, 6097.7490, '2016-04-25 08:31:27', 'dbo', ''),
(2015120016, 201512, 14, 16, '2016-04-25', 1147, 'ENERGY', 73, 73, '2015-12-20', '2015-11-20', '2016-05-04', 0, 4162.5120, 0.0000, 290.0000, 4452.5120, '2016-04-25 08:31:27', 'dbo', ''),
(2015120017, 201512, 14, 17, '2016-04-25', 1148, 'ENERGY', 163, 163, '2015-12-20', '2015-11-20', '2016-05-04', 0, 6243.0770, 4768.0900, 290.0000, 1764.9870, '2016-04-25 08:31:27', 'dbo', ''),
(2015120018, 201512, 14, 18, '2016-04-25', 1149, 'ENERGY', 46, 46, '2015-12-20', '2015-11-20', '2016-05-04', 0, 3663.0700, 2483.5400, 290.0000, 1469.5300, '2016-04-25 08:31:27', 'dbo', ''),
(2015120019, 201512, 14, 19, '2016-04-25', 1150, 'ENERGY', 74, 74, '2015-12-20', '2015-11-20', '2016-05-04', 0, 4961.6650, 4485.2500, 290.0000, 766.4150, '2016-04-25 08:31:27', 'dbo', ''),
(2015120020, 201512, 14, 20, '2016-04-25', 1151, 'ENERGY', 138, 138, '2015-12-20', '2015-11-20', '2016-05-04', 0, 6731.3730, 4941.6900, 290.0000, 2079.6830, '2016-04-25 08:31:27', 'dbo', ''),
(2015120021, 201512, 14, 21, '2016-04-25', 1152, 'ENERGY', 24771, 23958, '2015-12-20', '2015-11-20', '2016-05-04', 813, 653331.4146, 0.0000, 15232.6700, 668564.0846, '2016-04-25 08:31:27', 'dbo', ''),
(2015120022, 201512, 14, 22, '2016-04-25', 1153, 'ENERGY', 15337, 14816, '2015-12-20', '2015-11-20', '2016-05-04', 521, 401713.4716, 0.0000, 9865.8100, 411579.2816, '2016-04-25 08:31:27', 'dbo', ''),
(2015120023, 201512, 14, 23, '2016-04-25', 1154, 'ENERGY', 35378, 33953, '2015-12-20', '2015-11-20', '2016-05-04', 1425, 955171.8270, 0.0000, 26481.0300, 981652.8570, '2016-04-25 08:31:27', 'dbo', ''),
(2015120024, 201512, 14, 24, '2016-04-25', 1155, 'ENERGY', 31343, 30695, '2015-12-20', '2015-11-20', '2016-05-04', 648, 849062.7400, 0.0000, 12200.0300, 861262.7700, '2016-04-25 08:31:27', 'dbo', ''),
(2015120025, 201512, 14, 25, '2016-04-25', 1156, 'ENERGY', 63, 63, '2015-12-20', '2015-11-20', '2016-05-04', 0, 1315.4600, 0.0000, 290.0000, 1605.4600, '2016-04-25 08:31:27', 'dbo', ''),
(2015120026, 201512, 14, 26, '2016-04-25', 1157, 'ENERGY', 19915, 18226, '2015-12-20', '2015-11-20', '2016-05-04', 1689, 202385.9974, 0.0000, 31333.2600, 233719.2574, '2016-04-25 08:31:27', 'dbo', ''),
(2015120029, 201512, 14, 29, '2016-04-25', 1160, 'ENERGY', 43233, 41324, '2015-12-20', '2015-11-20', '2016-05-04', 1909, 483383.7688, 0.0000, 35376.7900, 518760.5588, '2016-04-25 08:31:27', 'dbo', ''),
(2015120030, 201512, 14, 30, '2016-04-25', 1161, 'ENERGY', 19717, 18640, '2015-12-20', '2015-11-20', '2016-05-04', 1077, 99954.4712, 0.0000, 20084.9000, 120039.3712, '2016-04-25 08:31:27', 'dbo', ''),
(2015120031, 201512, 14, 31, '2016-04-25', 1162, 'ENERGY', 20996, 19037, '2015-12-20', '2015-11-20', '2016-05-04', 1959, 167640.8780, 10623.9200, 36295.7700, 193312.7280, '2016-04-25 08:31:27', 'dbo', ''),
(2015120032, 201512, 14, 32, '2016-04-25', 1163, 'ENERGY', 35744, 32069, '2015-12-20', '2015-11-20', '2016-05-04', 3675, 303678.6890, 22172.7000, 67835.2800, 349341.2690, '2016-04-25 08:31:27', 'dbo', ''),
(2015120033, 201512, 14, 33, '2016-04-25', 1164, 'ENERGY', 4145, 3785, '2015-12-20', '2015-11-20', '2016-05-04', 360, 70418.9834, 29610.0000, 6906.6800, 47715.6634, '2016-04-25 08:31:27', 'dbo', ''),
(2015120034, 201512, 14, 34, '2016-04-25', 1165, 'ENERGY', 2789, 2522, '2015-12-20', '2015-11-20', '2016-05-04', 267, 47453.7842, 17426.0000, 5197.3700, 35225.1542, '2016-04-25 08:31:27', 'dbo', ''),
(2015120035, 201512, 14, 35, '2016-04-25', 1166, 'ENERGY', 5987, 5465, '2015-12-20', '2015-11-20', '2016-05-04', 522, 95592.7626, 40376.0000, 9884.1900, 65100.9526, '2016-04-25 08:31:27', 'dbo', ''),
(2015120036, 201512, 14, 36, '2016-04-25', 1167, 'ENERGY', 12198, 10590, '2015-12-20', '2015-11-20', '2016-05-04', 1608, 195762.8838, 75186.0000, 29844.5100, 150421.3938, '2016-04-25 08:31:27', 'dbo', ''),
(2015120037, 201512, 14, 37, '2016-04-25', 1168, 'ENERGY', 8442, 7705, '2015-12-20', '2015-11-20', '2016-05-04', 737, 141311.5010, 63558.0000, 13835.8100, 91589.3110, '2016-04-25 08:31:27', 'dbo', ''),
(2015120038, 201512, 14, 38, '2016-04-25', 1169, 'ENERGY', 3980, 3504, '2015-12-20', '2015-11-20', '2016-05-04', 476, 65699.5634, 25698.0000, 9038.7300, 49040.2934, '2016-04-25 08:31:27', 'dbo', ''),
(2015120039, 201512, 14, 39, '2016-04-25', 1170, 'ENERGY', 8621, 7966, '2015-12-20', '2015-11-20', '2016-05-04', 655, 97421.8482, 621312.0000, 12328.6800, -511561.4718, '2016-04-25 08:31:27', 'dbo', ''),
(2015120040, 201512, 14, 40, '2016-04-25', 1171, 'ENERGY', 6993, 6311, '2015-12-20', '2015-11-20', '2016-05-04', 682, 116861.9696, 48127.0000, 12824.9300, 81559.8996, '2016-04-25 08:31:27', 'dbo', ''),
(2015120041, 201512, 14, 41, '2016-04-25', 1172, 'ENERGY', 115, 115, '2015-12-20', '2015-11-20', '2016-05-04', 0, 6114.2400, 0.0000, 290.0000, 6404.2400, '2016-04-25 08:31:27', 'dbo', ''),
(2015120042, 201512, 14, 42, '2016-04-25', 1173, 'ENERGY', 183, 126, '2015-12-20', '2015-11-20', '2016-05-04', 57, 5256.9060, 0.0000, 1337.6400, 6594.5460, '2016-04-25 08:31:27', 'dbo', ''),
(2015120043, 201512, 14, 43, '2016-04-25', 1174, 'ENERGY', 26279, 24802, '2015-12-20', '2015-11-20', '2016-05-04', 1477, 312660.0502, 160000.0000, 27436.7700, 180096.8202, '2016-04-25 08:31:27', 'dbo', ''),
(2015120044, 201512, 14, 44, '2016-04-25', 1175, 'ENERGY', 5432, 4394, '2015-12-20', '2015-11-20', '2016-05-04', 1038, 76900.7130, 0.0000, 19368.1000, 96268.8130, '2016-04-25 08:31:27', 'dbo', ''),
(2015120045, 201512, 14, 45, '2016-04-25', 1176, 'ENERGY', 17634, 16943, '2015-12-20', '2015-11-20', '2016-05-04', 691, 167037.9420, 0.0000, 12990.3600, 180028.3020, '2016-04-25 08:31:27', 'dbo', ''),
(2015120046, 201512, 14, 46, '2016-04-25', 1177, 'ENERGY', 21324, 20279, '2015-12-20', '2015-11-20', '2016-05-04', 1045, 312082.8154, 0.0000, 19496.7500, 331579.5654, '2016-04-25 08:31:27', 'dbo', ''),
(2015120047, 201512, 14, 47, '2016-04-25', 1178, 'ENERGY', 11875, 11363, '2015-12-20', '2015-11-20', '2016-05-04', 512, 59975.5510, 0.0000, 9700.3900, 69675.9410, '2016-04-25 08:31:27', 'dbo', ''),
(2015120048, 201512, 14, 48, '2016-04-25', 1179, 'ENERGY', 91, 91, '2015-12-20', '2015-11-20', '2016-05-04', 0, 1197.8300, 0.0000, 290.0000, 1487.8300, '2016-04-25 08:31:27', 'dbo', ''),
(2015120049, 201512, 14, 49, '2016-04-25', 1180, 'ENERGY', 2120, 1919, '2015-12-20', '2015-11-20', '2016-05-04', 201, 18533.9090, 0.0000, 3984.3100, 22518.2190, '2016-04-25 08:31:27', 'dbo', ''),
(2015120050, 201512, 14, 50, '2016-04-25', 1181, 'ENERGY', 31598, 28804, '2015-12-20', '2015-11-20', '2016-05-04', 2794, 244905.1092, 0.0000, 51642.7900, 296547.8992, '2016-04-25 08:31:27', 'dbo', ''),
(2015120051, 201512, 14, 51, '2016-04-25', 1182, 'ENERGY', 211, 211, '2015-12-20', '2015-11-20', '2016-05-04', 0, 1449.9990, 0.0000, 290.0000, 1739.9990, '2016-04-25 08:31:27', 'dbo', ''),
(2015120052, 201512, 14, 52, '2016-04-25', 1183, 'ENERGY', 182, 136, '2015-12-20', '2015-11-20', '2016-05-04', 46, 2262.5120, 0.0000, 1135.4700, 3397.9820, '2016-04-25 08:31:27', 'dbo', ''),
(2015120053, 201512, 14, 53, '2016-04-25', 1184, 'ENERGY', 199, 72, '2015-12-20', '2015-11-20', '2016-05-04', 127, 5101.9570, 0.0000, 2624.2200, 7726.1770, '2016-04-25 08:31:27', 'dbo', ''),
(2015120054, 201512, 14, 54, '2016-04-25', 1185, 'ENERGY', 11398, 10701, '2015-12-20', '2015-11-20', '2016-05-04', 697, 254791.5394, 0.0000, 13100.6300, 267892.1694, '2016-04-25 08:31:27', 'dbo', ''),
(2015120055, 201512, 14, 55, '2016-04-25', 1186, 'ENERGY', 2760, 2467, '2015-12-20', '2015-11-20', '2016-05-04', 293, 48902.5300, 0.0000, 5675.2400, 54577.7700, '2016-04-25 08:31:27', 'dbo', ''),
(2015120056, 201512, 14, 56, '2016-04-25', 1187, 'ENERGY', 81, 81, '2015-12-20', '2015-11-20', '2016-05-04', 0, 1861.8390, 0.0000, 290.0000, 2151.8390, '2016-04-25 08:31:27', 'dbo', ''),
(2015120059, 201512, 14, 59, '2016-04-25', 1190, 'ENERGY', 23, 23, '2015-12-20', '2015-11-20', '2016-05-04', 0, 1844.7500, 0.0000, 290.0000, 2134.7500, '2016-04-25 08:31:27', 'dbo', ''),
(2015120060, 201512, 14, 60, '2016-04-25', 1191, 'ENERGY', 53273, 45396, '2015-12-20', '2015-11-20', '2016-05-04', 7877, 860367.1200, 89257.0000, 145066.6500, 916176.7700, '2016-04-25 08:31:27', 'dbo', ''),
(2015120061, 201512, 14, 61, '2016-04-25', 1192, 'ENERGY', 3, 3, '2015-12-20', '2015-11-20', '2016-05-04', 0, 1450.0000, 0.0000, 290.0000, 1740.0000, '2016-04-25 08:31:27', 'dbo', ''),
(2015120062, 201512, 14, 62, '2016-04-25', 1193, 'ENERGY', 30, 30, '2015-12-20', '2015-11-20', '2016-05-04', 0, 1450.0000, 0.0000, 290.0000, 1740.0000, '2016-04-25 08:31:27', 'dbo', ''),
(2015120063, 201512, 14, 63, '2016-04-25', 1194, 'ENERGY', 1, 1, '2015-12-20', '2015-11-20', '2016-05-04', 0, 1450.0000, 0.0000, 290.0000, 1740.0000, '2016-04-25 08:31:27', 'dbo', ''),
(2015120064, 201512, 14, 64, '2016-04-25', 1195, 'ENERGY', 2, 2, '2015-12-20', '2015-11-20', '2016-05-04', 0, 1450.0000, 0.0000, 290.0000, 1740.0000, '2016-04-25 08:31:27', 'dbo', ''),
(2015120065, 201512, 14, 65, '2016-04-25', 1196, 'ENERGY', 79, 41, '2015-12-20', '2015-11-20', '2016-05-04', 38, 4023.6380, 2378.9200, 988.4200, 2633.1380, '2016-04-25 08:31:27', 'dbo', ''),
(2015120066, 201512, 14, 66, '2016-04-25', 1197, 'ENERGY', 414, 213, '2015-12-20', '2015-11-20', '2016-05-04', 201, 8116.3724, 5281.8300, 3984.3100, 6818.8524, '2016-04-25 08:31:27', 'dbo', ''),
(2015120067, 201512, 14, 67, '2016-04-25', 1198, 'ENERGY', 102, 102, '2015-12-20', '2015-11-20', '2016-05-04', 0, 6572.4938, 4565.8200, 290.0000, 2296.6738, '2016-04-25 08:31:27', 'dbo', ''),
(2015120068, 201512, 14, 68, '2016-04-25', 1199, 'ENERGY', 211, 207, '2015-12-20', '2015-11-20', '2016-05-04', 4, 6996.7100, 2088.4700, 363.5200, 5271.7600, '2016-04-25 08:31:27', 'dbo', ''),
(2015120069, 201512, 14, 69, '2016-04-25', 1200, 'ENERGY', 1, 1, '2015-12-20', '2015-11-20', '2016-05-04', 0, 3190.0000, 0.0000, 290.0000, 3480.0000, '2016-04-25 08:31:27', 'dbo', ''),
(2015120070, 201512, 14, 70, '2016-04-25', 1201, 'ENERGY', 243, 239, '2015-12-20', '2015-11-20', '2016-05-04', 4, 7798.7200, 0.0000, 363.5200, 8162.2400, '2016-04-25 08:31:27', 'dbo', ''),
(2015120071, 201512, 14, 71, '2016-04-25', 1202, 'ENERGY', 566, 463, '2015-12-20', '2015-11-20', '2016-05-04', 103, 13071.3462, 0.0000, 2183.1100, 15254.4562, '2016-04-25 08:31:27', 'dbo', ''),
(2015120072, 201512, 14, 72, '2016-04-25', 1203, 'ENERGY', 39, 39, '2015-12-20', '2015-11-20', '2016-05-04', 0, 3362.7300, 0.0000, 290.0000, 3652.7300, '2016-04-25 08:31:27', 'dbo', ''),
(2015120073, 201512, 14, 73, '2016-04-25', 1204, 'ENERGY', 299, 286, '2015-12-20', '2015-11-20', '2016-05-04', 13, 14520.2780, 0.0000, 528.9400, 15049.2180, '2016-04-25 08:31:27', 'dbo', ''),
(2015120075, 201512, 14, 75, '2016-04-25', 1205, 'ENERGY', 459, 138, '2015-12-20', '2015-11-20', '2016-05-04', 321, 3926.1900, 0.0000, 6189.8800, 10116.0700, '2016-04-25 08:31:27', 'dbo', ''),
(2015120076, 201512, 14, 76, '2016-04-25', 1206, 'ENERGY', 562, 242, '2015-12-20', '2015-11-20', '2016-05-04', 320, 5792.3100, 0.0000, 6171.5000, 11963.8100, '2016-04-25 08:31:27', 'dbo', ''),
(2015120077, 201512, 14, 77, '2016-04-25', 1207, 'ENERGY', 244, 244, '2015-12-20', '2015-11-20', '2016-05-04', 0, 5828.1900, 0.0000, 290.0000, 6118.1900, '2016-04-25 08:31:27', 'dbo', ''),
(2015120078, 201512, 14, 78, '2016-04-25', 1208, 'ENERGY', 25, 25, '2015-12-20', '2015-11-20', '2016-05-04', 0, 1898.5800, 0.0000, 290.0000, 2188.5800, '2016-04-25 08:31:27', 'dbo', ''),
(2016010001, 201601, 15, 1, '2016-04-27', 1209, 'ENERGY', 804, 342, '2016-01-20', '2015-12-20', '2016-05-04', 462, 6201.2414, 0.0000, 8511.4500, 14712.6914, '2016-04-27 06:23:35', 'dbo', ''),
(2016010002, 201601, 15, 2, '2016-04-27', 1210, 'ENERGY', 1309, 553, '2016-01-20', '2015-12-20', '2016-05-04', 756, 8464.2910, 0.0000, 13743.2800, 22207.5710, '2016-04-27 06:23:35', 'dbo', ''),
(2016010003, 201601, 15, 3, '2016-04-27', 1211, 'ENERGY', 1452, 564, '2016-01-20', '2015-12-20', '2016-05-04', 888, 10630.9434, 0.0000, 16092.2600, 26723.2034, '2016-04-27 06:23:35', 'dbo', ''),
(2016010004, 201601, 15, 4, '2016-04-27', 1212, 'ENERGY', 1318, 323, '2016-01-20', '2015-12-20', '2016-05-04', 995, 5094.5322, 0.0000, 17996.3700, 23090.9022, '2016-04-27 06:23:35', 'dbo', ''),
(2016010005, 201601, 15, 5, '2016-04-27', 1213, 'ENERGY', 744, 492, '2016-01-20', '2015-12-20', '2016-05-04', 252, 8510.8586, 0.0000, 4774.4200, 13285.2786, '2016-04-27 06:23:36', 'dbo', ''),
(2016010006, 201601, 15, 6, '2016-04-27', 1214, 'ENERGY', 1655, 565, '2016-01-20', '2015-12-20', '2016-05-04', 1090, 10556.7968, 0.0000, 19686.9200, 30243.7168, '2016-04-27 06:23:36', 'dbo', ''),
(2016010007, 201601, 15, 7, '2016-04-27', 1215, 'ENERGY', 673, 270, '2016-01-20', '2015-12-20', '2016-05-04', 403, 5133.8000, 0.0000, 7461.5200, 12595.3200, '2016-04-27 06:23:36', 'dbo', ''),
(2016010008, 201601, 15, 8, '2016-04-27', 1216, 'ENERGY', 167, 148, '2016-01-20', '2015-12-20', '2016-05-04', 19, 2004.3276, 0.0000, 628.1100, 2632.4376, '2016-04-27 06:23:36', 'dbo', ''),
(2016010009, 201601, 15, 9, '2016-04-27', 1217, 'ENERGY', 64, 64, '2016-01-20', '2015-12-20', '2016-05-04', 0, 4311.7964, 0.0000, 290.0000, 4601.7964, '2016-04-27 06:23:35', 'dbo', ''),
(2016010010, 201601, 15, 10, '2016-04-27', 1218, 'ENERGY', 78, 74, '2016-01-20', '2015-12-20', '2016-05-04', 4, 4462.8480, 0.0000, 361.1800, 4824.0280, '2016-04-27 06:23:35', 'dbo', ''),
(2016010011, 201601, 15, 11, '2016-04-27', 1219, 'ENERGY', 184, 181, '2016-01-20', '2015-12-20', '2016-05-04', 3, 7971.7510, 0.0000, 343.3900, 8315.1410, '2016-04-27 06:23:35', 'dbo', ''),
(2016010012, 201601, 15, 12, '2016-04-27', 1220, 'ENERGY', 47, 46, '2016-01-20', '2015-12-20', '2016-05-04', 1, 3864.2800, 0.0000, 307.8000, 4172.0800, '2016-04-27 06:23:35', 'dbo', ''),
(2016010013, 201601, 15, 13, '2016-04-27', 1221, 'ENERGY', 81, 81, '2016-01-20', '2015-12-20', '2016-05-04', 0, 5325.6340, 0.0000, 290.0000, 5615.6340, '2016-04-27 06:23:36', 'dbo', ''),
(2016010014, 201601, 15, 14, '2016-04-27', 1222, 'ENERGY', 171, 171, '2016-01-20', '2015-12-20', '2016-05-04', 0, 7181.7554, 0.0000, 290.0000, 7471.7554, '2016-04-27 06:23:36', 'dbo', ''),
(2016010015, 201601, 15, 15, '2016-04-27', 1223, 'ENERGY', 157, 153, '2016-01-20', '2015-12-20', '2016-05-04', 4, 6097.7490, 0.0000, 361.1800, 6458.9290, '2016-04-27 06:23:36', 'dbo', ''),
(2016010016, 201601, 15, 16, '2016-04-27', 1224, 'ENERGY', 73, 73, '2016-01-20', '2015-12-20', '2016-05-04', 0, 4452.5120, 0.0000, 290.0000, 4742.5120, '2016-04-27 06:23:36', 'dbo', ''),
(2016010017, 201601, 15, 17, '2016-04-27', 1225, 'ENERGY', 163, 163, '2016-01-20', '2015-12-20', '2016-05-04', 0, 1764.9870, 0.0000, 290.0000, 2054.9870, '2016-04-27 06:23:35', 'dbo', ''),
(2016010018, 201601, 15, 18, '2016-04-27', 1226, 'ENERGY', 46, 46, '2016-01-20', '2015-12-20', '2016-05-04', 0, 1469.5300, 0.0000, 290.0000, 1759.5300, '2016-04-27 06:23:35', 'dbo', ''),
(2016010019, 201601, 15, 19, '2016-04-27', 1227, 'ENERGY', 74, 74, '2016-01-20', '2015-12-20', '2016-05-04', 0, 766.4150, 0.0000, 290.0000, 1056.4150, '2016-04-27 06:23:35', 'dbo', ''),
(2016010020, 201601, 15, 20, '2016-04-27', 1228, 'ENERGY', 152, 138, '2016-01-20', '2015-12-20', '2016-05-04', 14, 2079.6830, 0.0000, 539.1300, 2618.8130, '2016-04-27 06:23:35', 'dbo', ''),
(2016010021, 201601, 15, 21, '2016-04-27', 1229, 'ENERGY', 25764, 24771, '2016-01-20', '2015-12-20', '2016-05-04', 993, 668564.0846, 0.0000, 17960.7800, 686524.8646, '2016-04-27 06:23:36', 'dbo', ''),
(2016010022, 201601, 15, 22, '2016-04-27', 1230, 'ENERGY', 15846, 15337, '2016-01-20', '2015-12-20', '2016-05-04', 509, 411579.2816, 0.0000, 9347.8200, 420927.1016, '2016-04-27 06:23:36', 'dbo', ''),
(2016010023, 201601, 15, 23, '2016-04-27', 1231, 'ENERGY', 36263, 35378, '2016-01-20', '2015-12-20', '2016-05-04', 885, 981652.8570, 0.0000, 16038.8700, 997691.7270, '2016-04-27 06:23:36', 'dbo', ''),
(2016010024, 201601, 15, 24, '2016-04-27', 1232, 'ENERGY', 31917, 31343, '2016-01-20', '2015-12-20', '2016-05-04', 574, 861262.7700, 0.0000, 10504.5300, 871767.3000, '2016-04-27 06:23:36', 'dbo', ''),
(2016010025, 201601, 15, 25, '2016-04-27', 1233, 'ENERGY', 94, 63, '2016-01-20', '2015-12-20', '2016-05-04', 31, 1605.4600, 0.0000, 841.6500, 2447.1100, '2016-04-27 06:23:35', 'dbo', ''),
(2016010026, 201601, 15, 26, '2016-04-27', 1234, 'ENERGY', 21527, 19915, '2016-01-20', '2015-12-20', '2016-05-04', 1612, 233719.2574, 0.0000, 28976.0900, 262695.3474, '2016-04-27 06:23:35', 'dbo', ''),
(2016010029, 201601, 15, 29, '2016-04-27', 1237, 'ENERGY', 44724, 43233, '2016-01-20', '2015-12-20', '2016-05-04', 1491, 518760.5588, 0.0000, 26822.8500, 545583.4088, '2016-04-27 06:23:35', 'dbo', ''),
(2016010030, 201601, 15, 30, '2016-04-27', 1238, 'ENERGY', 20628, 19717, '2016-01-20', '2015-12-20', '2016-05-04', 911, 120039.3712, 0.0000, 16501.5500, 136540.9212, '2016-04-27 06:23:36', 'dbo', ''),
(2016010031, 201601, 15, 31, '2016-04-27', 1239, 'ENERGY', 22690, 20996, '2016-01-20', '2015-12-20', '2016-05-04', 1694, 193312.7280, 0.0000, 30435.3100, 223748.0380, '2016-04-27 06:23:36', 'dbo', ''),
(2016010032, 201601, 15, 32, '2016-04-27', 1240, 'ENERGY', 37811, 35744, '2016-01-20', '2015-12-20', '2016-05-04', 2067, 349341.2690, 0.0000, 37072.9700, 386414.2390, '2016-04-27 06:23:36', 'dbo', ''),
(2016010033, 201601, 15, 33, '2016-04-27', 1241, 'ENERGY', 4487, 4145, '2016-01-20', '2015-12-20', '2016-05-04', 342, 47715.6634, 0.0000, 6376.0100, 54091.6734, '2016-04-27 06:23:35', 'dbo', ''),
(2016010034, 201601, 15, 34, '2016-04-27', 1242, 'ENERGY', 3014, 2789, '2016-01-20', '2015-12-20', '2016-05-04', 225, 35225.1542, 0.0000, 4293.9500, 39519.1042, '2016-04-27 06:23:35', 'dbo', ''),
(2016010035, 201601, 15, 35, '2016-04-27', 1243, 'ENERGY', 6559, 5987, '2016-01-20', '2015-12-20', '2016-05-04', 572, 65100.9526, 0.0000, 10468.9400, 75569.8926, '2016-04-27 06:23:35', 'dbo', ''),
(2016010036, 201601, 15, 36, '2016-04-27', 1244, 'ENERGY', 13435, 12198, '2016-01-20', '2015-12-20', '2016-05-04', 1237, 150421.3938, 0.0000, 22302.8400, 172724.2338, '2016-04-27 06:23:35', 'dbo', ''),
(2016010037, 201601, 15, 37, '2016-04-27', 1245, 'ENERGY', 9099, 8442, '2016-01-20', '2015-12-20', '2016-05-04', 657, 91589.3110, 0.0000, 11981.5400, 103570.8510, '2016-04-27 06:23:36', 'dbo', ''),
(2016010038, 201601, 15, 38, '2016-04-27', 1246, 'ENERGY', 4325, 3980, '2016-01-20', '2015-12-20', '2016-05-04', 345, 49040.2934, 0.0000, 6429.4000, 55469.6934, '2016-04-27 06:23:36', 'dbo', ''),
(2016010039, 201601, 15, 39, '2016-04-27', 1247, 'ENERGY', 9282, 8621, '2016-01-20', '2015-12-20', '2016-05-04', 661, -511561.4718, 0.0000, 12052.7200, -499508.7518, '2016-04-27 06:23:36', 'dbo', ''),
(2016010040, 201601, 15, 40, '2016-04-27', 1248, 'ENERGY', 7603, 6993, '2016-01-20', '2015-12-20', '2016-05-04', 610, 81559.8996, 0.0000, 11145.1600, 92705.0596, '2016-04-27 06:23:36', 'dbo', ''),
(2016010041, 201601, 15, 41, '2016-04-27', 1249, 'ENERGY', 115, 115, '2016-01-20', '2015-12-20', '2016-05-04', 0, 6404.2400, 0.0000, 290.0000, 6694.2400, '2016-04-27 06:23:35', 'dbo', ''),
(2016010042, 201601, 15, 42, '2016-04-27', 1250, 'ENERGY', 183, 183, '2016-01-20', '2015-12-20', '2016-05-04', 0, 6594.5460, 0.0000, 290.0000, 6884.5460, '2016-04-27 06:23:35', 'dbo', ''),
(2016010043, 201601, 15, 43, '2016-04-27', 1251, 'ENERGY', 27965, 26279, '2016-01-20', '2015-12-20', '2016-05-04', 1686, 180096.8202, 0.0000, 30292.9400, 210389.7602, '2016-04-27 06:23:35', 'dbo', ''),
(2016010044, 201601, 15, 44, '2016-04-27', 1252, 'ENERGY', 6275, 5432, '2016-01-20', '2015-12-20', '2016-05-04', 843, 96268.8130, 0.0000, 15291.4700, 111560.2830, '2016-04-27 06:23:35', 'dbo', ''),
(2016010045, 201601, 15, 45, '2016-04-27', 1253, 'ENERGY', 18343, 17634, '2016-01-20', '2015-12-20', '2016-05-04', 709, 180028.3020, 0.0000, 12906.8900, 192935.1920, '2016-04-27 06:23:36', 'dbo', ''),
(2016010046, 201601, 15, 46, '2016-04-27', 1254, 'ENERGY', 22381, 21324, '2016-01-20', '2015-12-20', '2016-05-04', 1057, 331579.5654, 0.0000, 19099.6800, 350679.2454, '2016-04-27 06:23:36', 'dbo', ''),
(2016010047, 201601, 15, 47, '2016-04-27', 1255, 'ENERGY', 12402, 11875, '2016-01-20', '2015-12-20', '2016-05-04', 527, 69675.9410, 0.0000, 9668.1400, 79344.0810, '2016-04-27 06:23:36', 'dbo', ''),
(2016010048, 201601, 15, 48, '2016-04-27', 1256, 'ENERGY', 91, 91, '2016-01-20', '2015-12-20', '2016-05-04', 0, 1487.8300, 0.0000, 290.0000, 1777.8300, '2016-04-27 06:23:36', 'dbo', ''),
(2016010049, 201601, 15, 49, '2016-04-27', 1257, 'ENERGY', 2274, 2120, '2016-01-20', '2015-12-20', '2016-05-04', 154, 22518.2190, 0.0000, 3030.4900, 25548.7090, '2016-04-27 06:23:35', 'dbo', ''),
(2016010050, 201601, 15, 50, '2016-04-27', 1258, 'ENERGY', 33618, 31598, '2016-01-20', '2015-12-20', '2016-05-04', 2020, 296547.8992, 0.0000, 36236.5800, 332784.4792, '2016-04-27 06:23:35', 'dbo', ''),
(2016010051, 201601, 15, 51, '2016-04-27', 1259, 'ENERGY', 211, 211, '2016-01-20', '2015-12-20', '2016-05-04', 0, 1739.9990, 0.0000, 290.0000, 2029.9990, '2016-04-27 06:23:35', 'dbo', ''),
(2016010052, 201601, 15, 52, '2016-04-27', 1260, 'ENERGY', 202, 182, '2016-01-20', '2015-12-20', '2016-05-04', 20, 3397.9820, 0.0000, 645.9100, 4043.8920, '2016-04-27 06:23:35', 'dbo', ''),
(2016010053, 201601, 15, 53, '2016-04-27', 1261, 'ENERGY', 275, 199, '2016-01-20', '2015-12-20', '2016-05-04', 76, 7726.1770, 0.0000, 1642.4400, 9368.6170, '2016-04-27 06:23:36', 'dbo', ''),
(2016010054, 201601, 15, 54, '2016-04-27', 1262, 'ENERGY', 11946, 11398, '2016-01-20', '2015-12-20', '2016-05-04', 548, 267892.1694, 0.0000, 10041.8500, 277934.0194, '2016-04-27 06:23:36', 'dbo', ''),
(2016010055, 201601, 15, 55, '2016-04-27', 1263, 'ENERGY', 3083, 2760, '2016-01-20', '2015-12-20', '2016-05-04', 323, 54577.7700, 0.0000, 6037.9000, 60615.6700, '2016-04-27 06:23:36', 'dbo', ''),
(2016010056, 201601, 15, 56, '2016-04-27', 1264, 'ENERGY', 81, 81, '2016-01-20', '2015-12-20', '2016-05-04', 0, 2151.8390, 0.0000, 290.0000, 2441.8390, '2016-04-27 06:23:36', 'dbo', ''),
(2016010059, 201601, 15, 59, '2016-04-27', 1267, 'ENERGY', 23, 23, '2016-01-20', '2015-12-20', '2016-05-04', 0, 2134.7500, 0.0000, 290.0000, 2424.7500, '2016-04-27 06:23:35', 'dbo', ''),
(2016010060, 201601, 15, 60, '2016-04-27', 1268, 'ENERGY', 58770, 53273, '2016-01-20', '2015-12-20', '2016-05-04', 5497, 916176.7700, 0.0000, 98110.9900, 1014287.7600, '2016-04-27 06:23:35', 'dbo', ''),
(2016010061, 201601, 15, 61, '2016-04-27', 1269, 'ENERGY', 3, 3, '2016-01-20', '2015-12-20', '2016-05-04', 0, 1740.0000, 0.0000, 290.0000, 2030.0000, '2016-04-27 06:23:35', 'dbo', ''),
(2016010062, 201601, 15, 62, '2016-04-27', 1270, 'ENERGY', 30, 30, '2016-01-20', '2015-12-20', '2016-05-04', 0, 1740.0000, 0.0000, 290.0000, 2030.0000, '2016-04-27 06:23:35', 'dbo', ''),
(2016010063, 201601, 15, 63, '2016-04-27', 1271, 'ENERGY', 1, 1, '2016-01-20', '2015-12-20', '2016-05-04', 0, 1740.0000, 0.0000, 290.0000, 2030.0000, '2016-04-27 06:23:35', 'dbo', ''),
(2016010064, 201601, 15, 64, '2016-04-27', 1272, 'ENERGY', 2, 2, '2016-01-20', '2015-12-20', '2016-05-04', 0, 1740.0000, 0.0000, 290.0000, 2030.0000, '2016-04-27 06:23:35', 'dbo', ''),
(2016010065, 201601, 15, 65, '2016-04-27', 1273, 'ENERGY', 90, 79, '2016-01-20', '2015-12-20', '2016-05-04', 11, 2633.1380, 0.0000, 485.7500, 3118.8880, '2016-04-27 06:23:35', 'dbo', ''),
(2016010066, 201601, 15, 66, '2016-04-27', 1274, 'ENERGY', 599, 414, '2016-01-20', '2015-12-20', '2016-05-04', 185, 6818.8524, 0.0000, 3582.1400, 10400.9924, '2016-04-27 06:23:35', 'dbo', ''),
(2016010067, 201601, 15, 67, '2016-04-27', 1275, 'ENERGY', 102, 102, '2016-01-20', '2015-12-20', '2016-05-04', 0, 2296.6738, 0.0000, 290.0000, 2586.6738, '2016-04-27 06:23:36', 'dbo', ''),
(2016010068, 201601, 15, 68, '2016-04-27', 1276, 'ENERGY', 211, 211, '2016-01-20', '2015-12-20', '2016-05-04', 0, 5271.7600, 0.0000, 290.0000, 5561.7600, '2016-04-27 06:23:36', 'dbo', ''),
(2016010069, 201601, 15, 69, '2016-04-27', 1277, 'ENERGY', 1, 1, '2016-01-20', '2015-12-20', '2016-05-04', 0, 3480.0000, 0.0000, 290.0000, 3770.0000, '2016-04-27 06:23:35', 'dbo', ''),
(2016010070, 201601, 15, 70, '2016-04-27', 1278, 'ENERGY', 243, 243, '2016-01-20', '2015-12-20', '2016-05-04', 0, 8162.2400, 0.0000, 290.0000, 8452.2400, '2016-04-27 06:23:35', 'dbo', ''),
(2016010071, 201601, 15, 71, '2016-04-27', 1279, 'ENERGY', 821, 566, '2016-01-20', '2015-12-20', '2016-05-04', 255, 15254.4562, 0.0000, 4827.8100, 20082.2662, '2016-04-27 06:23:35', 'dbo', ''),
(2016010072, 201601, 15, 72, '2016-04-27', 1280, 'ENERGY', 39, 39, '2016-01-20', '2015-12-20', '2016-05-04', 0, 3652.7300, 0.0000, 290.0000, 3942.7300, '2016-04-27 06:23:35', 'dbo', ''),
(2016010073, 201601, 15, 73, '2016-04-27', 1281, 'ENERGY', 300, 299, '2016-01-20', '2015-12-20', '2016-05-04', 1, 15049.2180, 0.0000, 307.8000, 15357.0180, '2016-04-27 06:23:35', 'dbo', ''),
(2016010075, 201601, 15, 75, '2016-04-27', 1282, 'ENERGY', 491, 459, '2016-01-20', '2015-12-20', '2016-05-04', 32, 10116.0700, 0.0000, 859.4500, 10975.5200, '2016-04-27 06:23:35', 'dbo', ''),
(2016010076, 201601, 15, 76, '2016-04-27', 1283, 'ENERGY', 594, 562, '2016-01-20', '2015-12-20', '2016-05-04', 32, 11963.8100, 0.0000, 859.4500, 12823.2600, '2016-04-27 06:23:35', 'dbo', ''),
(2016010077, 201601, 15, 77, '2016-04-27', 1284, 'ENERGY', 244, 244, '2016-01-20', '2015-12-20', '2016-05-04', 0, 6118.1900, 0.0000, 290.0000, 6408.1900, '2016-04-27 06:23:35', 'dbo', ''),
(2016010078, 201601, 15, 78, '2016-04-27', 1285, 'ENERGY', 84, 25, '2016-01-20', '2015-12-20', '2016-05-04', 59, 2188.5800, 0.0000, 1339.9200, 3528.5000, '2016-04-27 06:23:35', 'dbo', ''),
(2016010079, 201601, 15, 79, '2016-04-27', 1286, 'ENERGY', 6895, 5709, '2016-01-20', '2015-12-20', '2016-05-04', 1186, 0.0000, 0.0000, 21395.2800, 21395.2800, '2016-04-27 06:23:35', 'dbo', ''),
(2016010080, 201601, 15, 80, '2016-04-27', 1287, 'ENERGY', 189, 170, '2016-01-20', '2015-12-20', '2016-05-04', 19, 0.0000, 0.0000, 628.1100, 628.1100, '2016-04-27 06:23:35', 'dbo', ''),
(2016020001, 201602, 16, 1, '2016-04-27', 1290, 'ENERGY', 3819, 804, '2016-02-20', '2016-01-20', '2016-05-04', 3015, 14712.6914, 0.0000, 54726.3300, 69439.0214, '2016-04-27 07:02:11', 'dbo', ''),
(2016020002, 201602, 16, 2, '2016-04-27', 1291, 'ENERGY', 2707, 1309, '2016-02-20', '2016-01-20', '2016-05-04', 1398, 22207.5710, 0.0000, 25531.1300, 47738.7010, '2016-04-27 07:02:11', 'dbo', ''),
(2016020003, 201602, 16, 3, '2016-04-27', 1292, 'ENERGY', 3354, 1452, '2016-02-20', '2016-01-20', '2016-05-04', 1902, 26723.2034, 0.0000, 34630.9200, 61354.1234, '2016-04-27 07:02:11', 'dbo', ''),
(2016020004, 201602, 16, 4, '2016-04-27', 1293, 'ENERGY', 2688, 1318, '2016-02-20', '2016-01-20', '2016-05-04', 1370, 23090.9022, 0.0000, 25025.5800, 48116.4822, '2016-04-27 07:02:11', 'dbo', ''),
(2016020005, 201602, 16, 5, '2016-04-27', 1294, 'ENERGY', 1684, 744, '2016-02-20', '2016-01-20', '2016-05-04', 940, 13285.2786, 0.0000, 17261.8600, 30547.1386, '2016-04-27 07:02:11', 'dbo', ''),
(2016020006, 201602, 16, 6, '2016-04-27', 1295, 'ENERGY', 4073, 1655, '2016-02-20', '2016-01-20', '2016-05-04', 2418, 30243.7168, 0.0000, 43947.3900, 74191.1068, '2016-04-27 07:02:11', 'dbo', ''),
(2016020007, 201602, 16, 7, '2016-04-27', 1296, 'ENERGY', 2530, 673, '2016-02-20', '2016-01-20', '2016-05-04', 1857, 12595.3200, 0.0000, 33818.4500, 46413.7700, '2016-04-27 07:02:11', 'dbo', ''),
(2016020008, 201602, 16, 8, '2016-04-27', 1297, 'ENERGY', 167, 167, '2016-02-20', '2016-01-20', '2016-05-04', 0, 2632.4376, 0.0000, 290.0000, 2922.4376, '2016-04-27 07:02:11', 'dbo', ''),
(2016020009, 201602, 16, 9, '2016-04-27', 1298, 'ENERGY', 64, 64, '2016-02-20', '2016-01-20', '2016-05-04', 0, 4601.7964, 0.0000, 290.0000, 4891.7964, '2016-04-27 07:02:11', 'dbo', ''),
(2016020010, 201602, 16, 10, '2016-04-27', 1299, 'ENERGY', 78, 78, '2016-02-20', '2016-01-20', '2016-05-04', 0, 4824.0280, 0.0000, 290.0000, 5114.0280, '2016-04-27 07:02:11', 'dbo', ''),
(2016020011, 201602, 16, 11, '2016-04-27', 1300, 'ENERGY', 184, 184, '2016-02-20', '2016-01-20', '2016-05-04', 0, 8315.1410, 0.0000, 290.0000, 8605.1410, '2016-04-27 07:02:11', 'dbo', ''),
(2016020012, 201602, 16, 12, '2016-04-27', 1301, 'ENERGY', 47, 47, '2016-02-20', '2016-01-20', '2016-05-04', 0, 4172.0800, 0.0000, 290.0000, 4462.0800, '2016-04-27 07:02:11', 'dbo', ''),
(2016020013, 201602, 16, 13, '2016-04-27', 1302, 'ENERGY', 81, 81, '2016-02-20', '2016-01-20', '2016-05-04', 0, 5615.6340, 0.0000, 290.0000, 5905.6340, '2016-04-27 07:02:11', 'dbo', ''),
(2016020014, 201602, 16, 14, '2016-04-27', 1303, 'ENERGY', 174, 171, '2016-02-20', '2016-01-20', '2016-05-04', 3, 7471.7554, 0.0000, 344.1700, 7815.9254, '2016-04-27 07:02:11', 'dbo', ''),
(2016020015, 201602, 16, 15, '2016-04-27', 1304, 'ENERGY', 158, 157, '2016-02-20', '2016-01-20', '2016-05-04', 1, 6458.9290, 0.0000, 308.0600, 6766.9890, '2016-04-27 07:02:11', 'dbo', ''),
(2016020016, 201602, 16, 16, '2016-04-27', 1305, 'ENERGY', 73, 73, '2016-02-20', '2016-01-20', '2016-05-04', 0, 4742.5120, 0.0000, 290.0000, 5032.5120, '2016-04-27 07:02:11', 'dbo', ''),
(2016020017, 201602, 16, 17, '2016-04-27', 1306, 'ENERGY', 163, 163, '2016-02-20', '2016-01-20', '2016-05-04', 0, 2054.9870, 0.0000, 290.0000, 2344.9870, '2016-04-27 07:02:11', 'dbo', ''),
(2016020018, 201602, 16, 18, '2016-04-27', 1307, 'ENERGY', 46, 46, '2016-02-20', '2016-01-20', '2016-05-04', 0, 1759.5300, 0.0000, 290.0000, 2049.5300, '2016-04-27 07:02:11', 'dbo', ''),
(2016020019, 201602, 16, 19, '2016-04-27', 1308, 'ENERGY', 74, 74, '2016-02-20', '2016-01-20', '2016-05-04', 0, 1056.4150, 0.0000, 290.0000, 1346.4150, '2016-04-27 07:02:11', 'dbo', ''),
(2016020020, 201602, 16, 20, '2016-04-27', 1309, 'ENERGY', 178, 152, '2016-02-20', '2016-01-20', '2016-05-04', 26, 2618.8130, 0.0000, 759.4300, 3378.2430, '2016-04-27 07:02:11', 'dbo', ''),
(2016020021, 201602, 16, 21, '2016-04-27', 1310, 'ENERGY', 26700, 25764, '2016-02-20', '2016-01-20', '2016-05-04', 936, 686524.8646, 0.0000, 17189.6400, 703714.5046, '2016-04-27 07:02:11', 'dbo', ''),
(2016020022, 201602, 16, 22, '2016-04-27', 1311, 'ENERGY', 16340, 15846, '2016-02-20', '2016-01-20', '2016-05-04', 494, 420927.1016, 0.0000, 9209.2600, 430136.3616, '2016-04-27 07:02:11', 'dbo', ''),
(2016020023, 201602, 16, 23, '2016-04-27', 1312, 'ENERGY', 37379, 36263, '2016-02-20', '2016-01-20', '2016-05-04', 1116, 997691.7270, 0.0000, 20439.5700, 1018131.2970, '2016-04-27 07:02:11', 'dbo', ''),
(2016020024, 201602, 16, 24, '2016-04-27', 1313, 'ENERGY', 32599, 31917, '2016-02-20', '2016-01-20', '2016-05-04', 682, 871767.3000, 0.0000, 12603.6200, 884370.9200, '2016-04-27 07:02:11', 'dbo', ''),
(2016020025, 201602, 16, 25, '2016-04-27', 1314, 'ENERGY', 94, 94, '2016-02-20', '2016-01-20', '2016-05-04', 0, 2447.1100, 0.0000, 290.0000, 2737.1100, '2016-04-27 07:02:11', 'dbo', ''),
(2016020026, 201602, 16, 26, '2016-04-27', 1315, 'ENERGY', 23334, 21527, '2016-02-20', '2016-01-20', '2016-05-04', 1807, 262695.3474, 0.0000, 32915.6800, 295611.0274, '2016-04-27 07:02:11', 'dbo', ''),
(2016020029, 201602, 16, 29, '2016-04-27', 1318, 'ENERGY', 46160, 44724, '2016-02-20', '2016-01-20', '2016-05-04', 1436, 545583.4088, 0.0000, 26217.2200, 571800.6288, '2016-04-27 07:02:11', 'dbo', ''),
(2016020030, 201602, 16, 30, '2016-04-27', 1319, 'ENERGY', 21448, 20628, '2016-02-20', '2016-01-20', '2016-05-04', 820, 136540.9212, 0.0000, 15095.2400, 151636.1612, '2016-04-27 07:02:11', 'dbo', ''),
(2016020031, 201602, 16, 31, '2016-04-27', 1320, 'ENERGY', 24275, 22690, '2016-02-20', '2016-01-20', '2016-05-04', 1585, 223748.0380, 0.0000, 28907.4400, 252655.4780, '2016-04-27 07:02:11', 'dbo', ''),
(2016020032, 201602, 16, 32, '2016-04-27', 1321, 'ENERGY', 40344, 37811, '2016-02-20', '2016-01-20', '2016-05-04', 2533, 386414.2390, 0.0000, 46023.7400, 432437.9790, '2016-04-27 07:02:11', 'dbo', ''),
(2016020033, 201602, 16, 33, '2016-04-27', 1322, 'ENERGY', 4868, 4487, '2016-02-20', '2016-01-20', '2016-05-04', 381, 54091.6734, 0.0000, 7169.0200, 61260.6934, '2016-04-27 07:02:11', 'dbo', ''),
(2016020034, 201602, 16, 34, '2016-04-27', 1323, 'ENERGY', 3255, 3014, '2016-02-20', '2016-01-20', '2016-05-04', 241, 39519.1042, 0.0000, 4641.3000, 44160.4042, '2016-04-27 07:02:11', 'dbo', ''),
(2016020035, 201602, 16, 35, '2016-04-27', 1324, 'ENERGY', 7173, 6559, '2016-02-20', '2016-01-20', '2016-05-04', 614, 75569.8926, 0.0000, 11375.8700, 86945.7626, '2016-04-27 07:02:11', 'dbo', ''),
(2016020036, 201602, 16, 36, '2016-04-27', 1325, 'ENERGY', 14790, 13435, '2016-02-20', '2016-01-20', '2016-05-04', 1355, 172724.2338, 0.0000, 24754.7500, 197478.9838, '2016-04-27 07:02:11', 'dbo', ''),
(2016020037, 201602, 16, 37, '2016-04-27', 1326, 'ENERGY', 9752, 9099, '2016-02-20', '2016-01-20', '2016-05-04', 653, 103570.8510, 0.0000, 12080.0200, 115650.8710, '2016-04-27 07:02:11', 'dbo', ''),
(2016020038, 201602, 16, 38, '2016-04-27', 1327, 'ENERGY', 4691, 4325, '2016-02-20', '2016-01-20', '2016-05-04', 366, 55469.6934, 0.0000, 6898.1900, 62367.8834, '2016-04-27 07:02:11', 'dbo', ''),
(2016020039, 201602, 16, 39, '2016-04-27', 1328, 'ENERGY', 10224, 9282, '2016-02-20', '2016-01-20', '2016-05-04', 942, -499508.7518, 0.0000, 17297.9600, -482210.7918, '2016-04-27 07:02:11', 'dbo', ''),
(2016020040, 201602, 16, 40, '2016-04-27', 1329, 'ENERGY', 8304, 7603, '2016-02-20', '2016-01-20', '2016-05-04', 701, 92705.0596, 0.0000, 12946.6800, 105651.7396, '2016-04-27 07:02:11', 'dbo', ''),
(2016020041, 201602, 16, 41, '2016-04-27', 1330, 'ENERGY', 115, 115, '2016-02-20', '2016-01-20', '2016-05-04', 0, 6694.2400, 0.0000, 290.0000, 6984.2400, '2016-04-27 07:02:11', 'dbo', ''),
(2016020042, 201602, 16, 42, '2016-04-27', 1331, 'ENERGY', 183, 183, '2016-02-20', '2016-01-20', '2016-05-04', 0, 6884.5460, 0.0000, 290.0000, 7174.5460, '2016-04-27 07:02:11', 'dbo', ''),
(2016020043, 201602, 16, 43, '2016-04-27', 1332, 'ENERGY', 29825, 27965, '2016-02-20', '2016-01-20', '2016-05-04', 1860, 210389.7602, 0.0000, 33872.6100, 244262.3702, '2016-04-27 07:02:11', 'dbo', ''),
(2016020044, 201602, 16, 44, '2016-04-27', 1333, 'ENERGY', 7526, 6275, '2016-02-20', '2016-01-20', '2016-05-04', 1251, 111560.2830, 0.0000, 22877.0100, 134437.2930, '2016-04-27 07:02:11', 'dbo', ''),
(2016020045, 201602, 16, 45, '2016-04-27', 1334, 'ENERGY', 19128, 18343, '2016-02-20', '2016-01-20', '2016-05-04', 785, 192935.1920, 0.0000, 14463.3100, 207398.5020, '2016-04-27 07:02:11', 'dbo', ''),
(2016020046, 201602, 16, 46, '2016-04-27', 1335, 'ENERGY', 23455, 22381, '2016-02-20', '2016-01-20', '2016-05-04', 1074, 350679.2454, 0.0000, 19681.2500, 370360.4954, '2016-04-27 07:02:11', 'dbo', ''),
(2016020047, 201602, 16, 47, '2016-04-27', 1336, 'ENERGY', 12979, 12402, '2016-02-20', '2016-01-20', '2016-05-04', 577, 79344.0810, 0.0000, 10707.8400, 90051.9210, '2016-04-27 07:02:11', 'dbo', ''),
(2016020048, 201602, 16, 48, '2016-04-27', 1337, 'ENERGY', 91, 91, '2016-02-20', '2016-01-20', '2016-05-04', 0, 1777.8300, 0.0000, 290.0000, 2067.8300, '2016-04-27 07:02:11', 'dbo', ''),
(2016020049, 201602, 16, 49, '2016-04-27', 1338, 'ENERGY', 2399, 2274, '2016-02-20', '2016-01-20', '2016-05-04', 125, 25548.7090, 0.0000, 2546.9000, 28095.6090, '2016-04-27 07:02:11', 'dbo', ''),
(2016020050, 201602, 16, 50, '2016-04-27', 1339, 'ENERGY', 35933, 33618, '2016-02-20', '2016-01-20', '2016-05-04', 2315, 332784.4792, 0.0000, 42087.7100, 374872.1892, '2016-04-27 07:02:11', 'dbo', ''),
(2016020051, 201602, 16, 51, '2016-04-27', 1340, 'ENERGY', 211, 211, '2016-02-20', '2016-01-20', '2016-05-04', 0, 2029.9990, 0.0000, 290.0000, 2319.9990, '2016-04-27 07:02:11', 'dbo', ''),
(2016020052, 201602, 16, 52, '2016-04-27', 1341, 'ENERGY', 214, 202, '2016-02-20', '2016-01-20', '2016-05-04', 12, 4043.8920, 0.0000, 506.6600, 4550.5520, '2016-04-27 07:02:11', 'dbo', ''),
(2016020053, 201602, 16, 53, '2016-04-27', 1342, 'ENERGY', 369, 275, '2016-02-20', '2016-01-20', '2016-05-04', 94, 9368.6170, 0.0000, 1987.1800, 11355.7970, '2016-04-27 07:02:11', 'dbo', ''),
(2016020054, 201602, 16, 54, '2016-04-27', 1343, 'ENERGY', 12635, 11946, '2016-02-20', '2016-01-20', '2016-05-04', 689, 277934.0194, 0.0000, 12730.0200, 290664.0394, '2016-04-27 07:02:11', 'dbo', ''),
(2016020055, 201602, 16, 55, '2016-04-27', 1344, 'ENERGY', 3712, 3083, '2016-02-20', '2016-01-20', '2016-05-04', 629, 60615.6700, 0.0000, 11646.7000, 72262.3700, '2016-04-27 07:02:11', 'dbo', ''),
(2016020056, 201602, 16, 56, '2016-04-27', 1345, 'ENERGY', 81, 81, '2016-02-20', '2016-01-20', '2016-05-04', 0, 2441.8390, 0.0000, 290.0000, 2731.8390, '2016-04-27 07:02:11', 'dbo', ''),
(2016020059, 201602, 16, 59, '2016-04-27', 1348, 'ENERGY', 56, 23, '2016-02-20', '2016-01-20', '2016-05-04', 33, 2424.7500, 0.0000, 885.8200, 3310.5700, '2016-04-27 07:02:10', 'dbo', ''),
(2016020060, 201602, 16, 60, '2016-04-27', 1349, 'ENERGY', 64875, 58770, '2016-02-20', '2016-01-20', '2016-05-04', 6105, 1014287.7600, 0.0000, 110516.8000, 1124804.5600, '2016-04-27 07:02:10', 'dbo', ''),
(2016020061, 201602, 16, 61, '2016-04-27', 1350, 'ENERGY', 3, 3, '2016-02-20', '2016-01-20', '2016-05-04', 0, 2030.0000, 0.0000, 290.0000, 2320.0000, '2016-04-27 07:02:11', 'dbo', '');
INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2016020062, 201602, 16, 62, '2016-04-27', 1351, 'ENERGY', 30, 30, '2016-02-20', '2016-01-20', '2016-05-04', 0, 2030.0000, 0.0000, 290.0000, 2320.0000, '2016-04-27 07:02:11', 'dbo', ''),
(2016020063, 201602, 16, 63, '2016-04-27', 1352, 'ENERGY', 1, 1, '2016-02-20', '2016-01-20', '2016-05-04', 0, 2030.0000, 0.0000, 290.0000, 2320.0000, '2016-04-27 07:02:11', 'dbo', ''),
(2016020064, 201602, 16, 64, '2016-04-27', 1353, 'ENERGY', 2, 2, '2016-02-20', '2016-01-20', '2016-05-04', 0, 2030.0000, 0.0000, 290.0000, 2320.0000, '2016-04-27 07:02:11', 'dbo', ''),
(2016020065, 201602, 16, 65, '2016-04-27', 1354, 'ENERGY', 219, 90, '2016-02-20', '2016-01-20', '2016-05-04', 129, 3118.8880, 0.0000, 2619.1200, 5738.0080, '2016-04-27 07:02:11', 'dbo', ''),
(2016020066, 201602, 16, 66, '2016-04-27', 1355, 'ENERGY', 798, 599, '2016-02-20', '2016-01-20', '2016-05-04', 199, 10400.9924, 0.0000, 3882.9800, 14283.9724, '2016-04-27 07:02:11', 'dbo', ''),
(2016020067, 201602, 16, 67, '2016-04-27', 1356, 'ENERGY', 102, 102, '2016-02-20', '2016-01-20', '2016-05-04', 0, 2586.6738, 0.0000, 290.0000, 2876.6738, '2016-04-27 07:02:11', 'dbo', ''),
(2016020068, 201602, 16, 68, '2016-04-27', 1357, 'ENERGY', 211, 211, '2016-02-20', '2016-01-20', '2016-05-04', 0, 5561.7600, 0.0000, 290.0000, 5851.7600, '2016-04-27 07:02:11', 'dbo', ''),
(2016020069, 201602, 16, 69, '2016-04-27', 1358, 'ENERGY', 1, 1, '2016-02-20', '2016-01-20', '2016-05-04', 0, 3770.0000, 0.0000, 290.0000, 4060.0000, '2016-04-27 07:02:11', 'dbo', ''),
(2016020070, 201602, 16, 70, '2016-04-27', 1359, 'ENERGY', 256, 243, '2016-02-20', '2016-01-20', '2016-05-04', 13, 8452.2400, 0.0000, 524.7200, 8976.9600, '2016-04-27 07:02:11', 'dbo', ''),
(2016020071, 201602, 16, 71, '2016-04-27', 1360, 'ENERGY', 1346, 821, '2016-02-20', '2016-01-20', '2016-05-04', 525, 20082.2662, 0.0000, 9768.9600, 29851.2262, '2016-04-27 07:02:10', 'dbo', ''),
(2016020072, 201602, 16, 72, '2016-04-27', 1361, 'ENERGY', 39, 39, '2016-02-20', '2016-01-20', '2016-05-04', 0, 3942.7300, 0.0000, 290.0000, 4232.7300, '2016-04-27 07:02:10', 'dbo', ''),
(2016020073, 201602, 16, 73, '2016-04-27', 1362, 'ENERGY', 315, 300, '2016-02-20', '2016-01-20', '2016-05-04', 15, 15357.0180, 0.0000, 560.8300, 15917.8480, '2016-04-27 07:02:10', 'dbo', ''),
(2016020075, 201602, 16, 75, '2016-04-27', 1363, 'ENERGY', 525, 491, '2016-02-20', '2016-01-20', '2016-05-04', 34, 10975.5200, 0.0000, 903.8800, 11879.4000, '2016-04-27 07:02:11', 'dbo', ''),
(2016020076, 201602, 16, 76, '2016-04-27', 1364, 'ENERGY', 630, 594, '2016-02-20', '2016-01-20', '2016-05-04', 36, 12823.2600, 0.0000, 939.9800, 13763.2400, '2016-04-27 07:02:11', 'dbo', ''),
(2016020077, 201602, 16, 77, '2016-04-27', 1365, 'ENERGY', 560, 244, '2016-02-20', '2016-01-20', '2016-05-04', 316, 6408.1900, 0.0000, 5995.4300, 12403.6200, '2016-04-27 07:02:10', 'dbo', ''),
(2016020078, 201602, 16, 78, '2016-04-27', 1366, 'ENERGY', 95, 84, '2016-02-20', '2016-01-20', '2016-05-04', 11, 3528.5000, 0.0000, 488.6000, 4017.1000, '2016-04-27 07:02:11', 'dbo', ''),
(2016020079, 201602, 16, 79, '2016-04-27', 1367, 'ENERGY', 8392, 6895, '2016-02-20', '2016-01-20', '2016-05-04', 1497, 21395.2800, 0.0000, 27318.5900, 48713.8700, '2016-04-27 07:02:11', 'dbo', ''),
(2016020080, 201602, 16, 80, '2016-04-27', 1368, 'ENERGY', 211, 189, '2016-02-20', '2016-01-20', '2016-05-04', 22, 628.1100, 0.0000, 687.2100, 1315.3200, '2016-04-27 07:02:11', 'dbo', ''),
(2016020081, 201602, 16, 81, '2016-04-27', 1369, 'ENERGY', 70, 70, '2016-02-20', '2016-01-20', '2016-05-04', 0, 0.0000, 0.0000, 290.0000, 290.0000, '2016-04-27 07:02:11', 'dbo', ''),
(2016020082, 201602, 16, 82, '2016-04-27', 1370, 'ENERGY', 18, 0, '2016-02-20', '2016-01-20', '2016-05-04', 18, 0.0000, 0.0000, 615.0000, 615.0000, '2016-04-27 07:02:11', 'dbo', ''),
(2016030001, 201603, 17, 1, '2016-04-27', 1371, 'ENERGY', 7745, 3819, '2016-03-20', '2016-02-20', '2016-05-04', 3926, 69439.0214, 0.0000, 70753.7300, 140192.7514, '2016-04-27 07:30:43', 'dbo', ''),
(2016030002, 201603, 17, 2, '2016-04-27', 1372, 'ENERGY', 4395, 2707, '2016-03-20', '2016-02-20', '2016-05-04', 1688, 47738.7010, 0.0000, 30420.8500, 78159.5510, '2016-04-27 07:30:43', 'dbo', ''),
(2016030003, 201603, 17, 3, '2016-04-27', 1373, 'ENERGY', 5575, 3354, '2016-03-20', '2016-02-20', '2016-05-04', 2221, 61354.1234, 0.0000, 40026.5000, 101380.6234, '2016-04-27 07:30:43', 'dbo', ''),
(2016030004, 201603, 17, 4, '2016-04-27', 1374, 'ENERGY', 4365, 2688, '2016-03-20', '2016-02-20', '2016-05-04', 1677, 48116.4822, 0.0000, 30222.6200, 78339.1022, '2016-04-27 07:30:43', 'dbo', ''),
(2016030005, 201603, 17, 5, '2016-04-27', 1375, 'ENERGY', 3115, 1684, '2016-03-20', '2016-02-20', '2016-05-04', 1431, 30547.1386, 0.0000, 25789.2400, 56336.3786, '2016-04-27 07:30:43', 'dbo', ''),
(2016030006, 201603, 17, 6, '2016-04-27', 1376, 'ENERGY', 8175, 4073, '2016-03-20', '2016-02-20', '2016-05-04', 4102, 74191.1068, 0.0000, 73925.5700, 148116.6768, '2016-04-27 07:30:43', 'dbo', ''),
(2016030007, 201603, 17, 7, '2016-04-27', 1377, 'ENERGY', 5394, 2530, '2016-03-20', '2016-02-20', '2016-05-04', 2864, 46413.7700, 0.0000, 51614.5400, 98028.3100, '2016-04-27 07:30:43', 'dbo', ''),
(2016030008, 201603, 17, 8, '2016-04-27', 1378, 'ENERGY', 167, 167, '2016-03-20', '2016-02-20', '2016-05-04', 0, 2922.4376, 0.0000, 0.0000, 2922.4376, '2016-04-27 07:30:43', 'dbo', ''),
(2016030009, 201603, 17, 9, '2016-04-27', 1379, 'ENERGY', 64, 64, '2016-03-20', '2016-02-20', '2016-05-04', 0, 4891.7964, 0.0000, 0.0000, 4891.7964, '2016-04-27 07:30:43', 'dbo', ''),
(2016030010, 201603, 17, 10, '2016-04-27', 1380, 'ENERGY', 81, 78, '2016-03-20', '2016-02-20', '2016-05-04', 3, 5114.0280, 0.0000, 54.0600, 5168.0880, '2016-04-27 07:30:43', 'dbo', ''),
(2016030011, 201603, 17, 11, '2016-04-27', 1381, 'ENERGY', 196, 184, '2016-03-20', '2016-02-20', '2016-05-04', 12, 8605.1410, 0.0000, 216.2700, 8821.4110, '2016-04-27 07:30:43', 'dbo', ''),
(2016030012, 201603, 17, 12, '2016-04-27', 1382, 'ENERGY', 51, 47, '2016-03-20', '2016-02-20', '2016-05-04', 4, 4462.0800, 0.0000, 72.0800, 4534.1600, '2016-04-27 07:30:43', 'dbo', ''),
(2016030013, 201603, 17, 13, '2016-04-27', 1383, 'ENERGY', 81, 81, '2016-03-20', '2016-02-20', '2016-05-04', 0, 5905.6340, 0.0000, 0.0000, 5905.6340, '2016-04-27 07:30:43', 'dbo', ''),
(2016030014, 201603, 17, 14, '2016-04-27', 1384, 'ENERGY', 176, 174, '2016-03-20', '2016-02-20', '2016-05-04', 2, 7815.9254, 0.0000, 36.0400, 7851.9654, '2016-04-27 07:30:43', 'dbo', ''),
(2016030015, 201603, 17, 15, '2016-04-27', 1385, 'ENERGY', 162, 158, '2016-03-20', '2016-02-20', '2016-05-04', 4, 6766.9890, 0.0000, 72.0800, 6839.0690, '2016-04-27 07:30:43', 'dbo', ''),
(2016030016, 201603, 17, 16, '2016-04-27', 1386, 'ENERGY', 75, 73, '2016-03-20', '2016-02-20', '2016-05-04', 2, 5032.5120, 0.0000, 36.0400, 5068.5520, '2016-04-27 07:30:43', 'dbo', ''),
(2016030017, 201603, 17, 17, '2016-04-27', 1387, 'ENERGY', 189, 163, '2016-03-20', '2016-02-20', '2016-05-04', 26, 2344.9870, 0.0000, 468.5600, 2813.5470, '2016-04-27 07:30:43', 'dbo', ''),
(2016030018, 201603, 17, 18, '2016-04-27', 1388, 'ENERGY', 46, 46, '2016-03-20', '2016-02-20', '2016-05-04', 0, 2049.5300, 0.0000, 0.0000, 2049.5300, '2016-04-27 07:30:43', 'dbo', ''),
(2016030019, 201603, 17, 19, '2016-04-27', 1389, 'ENERGY', 74, 74, '2016-03-20', '2016-02-20', '2016-05-04', 0, 1346.4150, 0.0000, 0.0000, 1346.4150, '2016-04-27 07:30:43', 'dbo', ''),
(2016030020, 201603, 17, 20, '2016-04-27', 1390, 'ENERGY', 196, 178, '2016-03-20', '2016-02-20', '2016-05-04', 18, 3378.2430, 0.0000, 324.3900, 3702.6330, '2016-04-27 07:30:43', 'dbo', ''),
(2016030021, 201603, 17, 21, '2016-04-27', 1391, 'ENERGY', 27828, 26700, '2016-03-20', '2016-02-20', '2016-05-04', 1128, 703714.5046, 0.0000, 20328.6300, 724043.1346, '2016-04-27 07:30:43', 'dbo', ''),
(2016030022, 201603, 17, 22, '2016-04-27', 1392, 'ENERGY', 16914, 16340, '2016-03-20', '2016-02-20', '2016-05-04', 574, 430136.3616, 0.0000, 10344.5300, 440480.8916, '2016-04-27 07:30:43', 'dbo', ''),
(2016030023, 201603, 17, 23, '2016-04-27', 1393, 'ENERGY', 38994, 37379, '2016-03-20', '2016-02-20', '2016-05-04', 1615, 1018131.2970, 0.0000, 29105.2600, 1047236.5570, '2016-04-27 07:30:43', 'dbo', ''),
(2016030024, 201603, 17, 24, '2016-04-27', 1394, 'ENERGY', 33373, 32599, '2016-03-20', '2016-02-20', '2016-05-04', 774, 884370.9200, 0.0000, 13948.9000, 898319.8200, '2016-04-27 07:30:43', 'dbo', ''),
(2016030025, 201603, 17, 25, '2016-04-27', 1395, 'ENERGY', 97, 94, '2016-03-20', '2016-02-20', '2016-05-04', 3, 2737.1100, 0.0000, 54.0600, 2791.1700, '2016-04-27 07:30:43', 'dbo', ''),
(2016030026, 201603, 17, 26, '2016-04-27', 1396, 'ENERGY', 26138, 23334, '2016-03-20', '2016-02-20', '2016-05-04', 2804, 295611.0274, 0.0000, 50533.2300, 346144.2574, '2016-04-27 07:30:43', 'dbo', ''),
(2016030029, 201603, 17, 29, '2016-04-27', 1399, 'ENERGY', 47981, 46160, '2016-03-20', '2016-02-20', '2016-05-04', 1821, 571800.6288, 0.0000, 32817.7700, 604618.3988, '2016-04-27 07:30:43', 'dbo', ''),
(2016030030, 201603, 17, 30, '2016-04-27', 1400, 'ENERGY', 22432, 21448, '2016-03-20', '2016-02-20', '2016-05-04', 984, 151636.1612, 0.0000, 17733.4900, 169369.6512, '2016-04-27 07:30:43', 'dbo', ''),
(2016030031, 201603, 17, 31, '2016-04-27', 1401, 'ENERGY', 26496, 24275, '2016-03-20', '2016-02-20', '2016-05-04', 2221, 252655.4780, 0.0000, 40026.5000, 292681.9780, '2016-04-27 07:30:43', 'dbo', ''),
(2016030032, 201603, 17, 32, '2016-04-27', 1402, 'ENERGY', 43413, 40344, '2016-03-20', '2016-02-20', '2016-05-04', 3069, 432437.9790, 0.0000, 55309.0100, 487746.9890, '2016-04-27 07:30:43', 'dbo', ''),
(2016030033, 201603, 17, 33, '2016-04-27', 1403, 'ENERGY', 5316, 4868, '2016-03-20', '2016-02-20', '2016-05-04', 448, 61260.6934, 0.0000, 8073.7900, 69334.4834, '2016-04-27 07:30:43', 'dbo', ''),
(2016030034, 201603, 17, 34, '2016-04-27', 1404, 'ENERGY', 3551, 3255, '2016-03-20', '2016-02-20', '2016-05-04', 296, 44160.4042, 0.0000, 5334.4600, 49494.8642, '2016-04-27 07:30:43', 'dbo', ''),
(2016030035, 201603, 17, 35, '2016-04-27', 1405, 'ENERGY', 7833, 7173, '2016-03-20', '2016-02-20', '2016-05-04', 660, 86945.7626, 0.0000, 11894.4100, 98840.1726, '2016-04-27 07:30:43', 'dbo', ''),
(2016030036, 201603, 17, 36, '2016-04-27', 1406, 'ENERGY', 16373, 14790, '2016-03-20', '2016-02-20', '2016-05-04', 1583, 197478.9838, 0.0000, 28528.5700, 226007.5538, '2016-04-27 07:30:43', 'dbo', ''),
(2016030037, 201603, 17, 37, '2016-04-27', 1407, 'ENERGY', 10542, 9752, '2016-03-20', '2016-02-20', '2016-05-04', 790, 115650.8710, 0.0000, 14237.2500, 129888.1210, '2016-04-27 07:30:43', 'dbo', ''),
(2016030038, 201603, 17, 38, '2016-04-27', 1408, 'ENERGY', 5109, 4691, '2016-03-20', '2016-02-20', '2016-05-04', 418, 62367.8834, 0.0000, 7533.1300, 69901.0134, '2016-04-27 07:30:43', 'dbo', ''),
(2016030039, 201603, 17, 39, '2016-04-27', 1409, 'ENERGY', 12559, 10224, '2016-03-20', '2016-02-20', '2016-05-04', 2335, -482210.7918, 0.0000, 42080.9900, -440129.8018, '2016-04-27 07:30:43', 'dbo', ''),
(2016030040, 201603, 17, 40, '2016-04-27', 1410, 'ENERGY', 10542, 8304, '2016-03-20', '2016-02-20', '2016-05-04', 2238, 105651.7396, 0.0000, 40332.8700, 145984.6096, '2016-04-27 07:30:43', 'dbo', ''),
(2016030041, 201603, 17, 41, '2016-04-27', 1411, 'ENERGY', 119, 115, '2016-03-20', '2016-02-20', '2016-05-04', 4, 6984.2400, 0.0000, 72.0800, 7056.3200, '2016-04-27 07:30:43', 'dbo', ''),
(2016030042, 201603, 17, 42, '2016-04-27', 1412, 'ENERGY', 183, 183, '2016-03-20', '2016-02-20', '2016-05-04', 0, 7174.5460, 0.0000, 0.0000, 7174.5460, '2016-04-27 07:30:43', 'dbo', ''),
(2016030043, 201603, 17, 43, '2016-04-27', 1413, 'ENERGY', 31828, 29825, '2016-03-20', '2016-02-20', '2016-05-04', 2003, 244262.3702, 0.0000, 36097.7400, 280360.1102, '2016-04-27 07:30:43', 'dbo', ''),
(2016030044, 201603, 17, 44, '2016-04-27', 1414, 'ENERGY', 9040, 7526, '2016-03-20', '2016-02-20', '2016-05-04', 1514, 134437.2930, 0.0000, 27285.0600, 161722.3530, '2016-04-27 07:30:43', 'dbo', ''),
(2016030045, 201603, 17, 45, '2016-04-27', 1415, 'ENERGY', 19851, 19128, '2016-03-20', '2016-02-20', '2016-05-04', 723, 207398.5020, 0.0000, 13029.7900, 220428.2920, '2016-04-27 07:30:43', 'dbo', ''),
(2016030046, 201603, 17, 46, '2016-04-27', 1416, 'ENERGY', 24653, 23455, '2016-03-20', '2016-02-20', '2016-05-04', 1198, 370360.4954, 0.0000, 21590.1600, 391950.6554, '2016-04-27 07:30:43', 'dbo', ''),
(2016030047, 201603, 17, 47, '2016-04-27', 1417, 'ENERGY', 13711, 12979, '2016-03-20', '2016-02-20', '2016-05-04', 732, 90051.9210, 0.0000, 13191.9800, 103243.9010, '2016-04-27 07:30:43', 'dbo', ''),
(2016030048, 201603, 17, 48, '2016-04-27', 1418, 'ENERGY', 91, 91, '2016-03-20', '2016-02-20', '2016-05-04', 0, 2067.8300, 0.0000, 0.0000, 2067.8300, '2016-04-27 07:30:43', 'dbo', ''),
(2016030049, 201603, 17, 49, '2016-04-27', 1419, 'ENERGY', 2574, 2399, '2016-03-20', '2016-02-20', '2016-05-04', 175, 28095.6090, 0.0000, 3153.8300, 31249.4390, '2016-04-27 07:30:43', 'dbo', ''),
(2016030050, 201603, 17, 50, '2016-04-27', 1420, 'ENERGY', 39301, 35933, '2016-03-20', '2016-02-20', '2016-05-04', 3368, 374872.1892, 0.0000, 60697.5400, 435569.7292, '2016-04-27 07:30:43', 'dbo', ''),
(2016030051, 201603, 17, 51, '2016-04-27', 1421, 'ENERGY', 211, 211, '2016-03-20', '2016-02-20', '2016-05-04', 0, 2319.9990, 0.0000, 0.0000, 2319.9990, '2016-04-27 07:30:43', 'dbo', ''),
(2016030052, 201603, 17, 52, '2016-04-27', 1422, 'ENERGY', 229, 214, '2016-03-20', '2016-02-20', '2016-05-04', 15, 4550.5520, 0.0000, 270.3300, 4820.8820, '2016-04-27 07:30:43', 'dbo', ''),
(2016030053, 201603, 17, 53, '2016-04-27', 1423, 'ENERGY', 538, 369, '2016-03-20', '2016-02-20', '2016-05-04', 169, 11355.7970, 0.0000, 3045.6900, 14401.4870, '2016-04-27 07:30:43', 'dbo', ''),
(2016030054, 201603, 17, 54, '2016-04-27', 1424, 'ENERGY', 13647, 12635, '2016-03-20', '2016-02-20', '2016-05-04', 1012, 290664.0394, 0.0000, 18238.0900, 308902.1294, '2016-04-27 07:30:43', 'dbo', ''),
(2016030055, 201603, 17, 55, '2016-04-27', 1425, 'ENERGY', 4486, 3712, '2016-03-20', '2016-02-20', '2016-05-04', 774, 72262.3700, 0.0000, 13948.9000, 86211.2700, '2016-04-27 07:30:43', 'dbo', ''),
(2016030056, 201603, 17, 56, '2016-04-27', 1426, 'ENERGY', 81, 81, '2016-03-20', '2016-02-20', '2016-05-04', 0, 2731.8390, 0.0000, 0.0000, 2731.8390, '2016-04-27 07:30:43', 'dbo', ''),
(2016030059, 201603, 17, 59, '2016-04-27', 1429, 'ENERGY', 128, 56, '2016-03-20', '2016-02-20', '2016-05-04', 72, 3310.5700, 0.0000, 1297.5700, 4608.1400, '2016-04-27 07:30:42', 'dbo', ''),
(2016030060, 201603, 17, 60, '2016-04-27', 1430, 'ENERGY', 72226, 64875, '2016-03-20', '2016-02-20', '2016-05-04', 7351, 1124804.5600, 0.0000, 132478.5200, 1257283.0800, '2016-04-27 07:30:42', 'dbo', ''),
(2016030061, 201603, 17, 61, '2016-04-27', 1431, 'ENERGY', 3, 3, '2016-03-20', '2016-02-20', '2016-05-04', 0, 2320.0000, 0.0000, 0.0000, 2320.0000, '2016-04-27 07:30:42', 'dbo', ''),
(2016030062, 201603, 17, 62, '2016-04-27', 1432, 'ENERGY', 30, 30, '2016-03-20', '2016-02-20', '2016-05-04', 0, 2320.0000, 0.0000, 0.0000, 2320.0000, '2016-04-27 07:30:42', 'dbo', ''),
(2016030063, 201603, 17, 63, '2016-04-27', 1433, 'ENERGY', 1, 1, '2016-03-20', '2016-02-20', '2016-05-04', 0, 2320.0000, 0.0000, 0.0000, 2320.0000, '2016-04-27 07:30:43', 'dbo', ''),
(2016030064, 201603, 17, 64, '2016-04-27', 1434, 'ENERGY', 2, 2, '2016-03-20', '2016-02-20', '2016-05-04', 0, 2320.0000, 0.0000, 0.0000, 2320.0000, '2016-04-27 07:30:43', 'dbo', ''),
(2016030065, 201603, 17, 65, '2016-04-27', 1435, 'ENERGY', 574, 219, '2016-03-20', '2016-02-20', '2016-05-04', 355, 5738.0080, 0.0000, 6397.7500, 12135.7580, '2016-04-27 07:30:43', 'dbo', ''),
(2016030066, 201603, 17, 66, '2016-04-27', 1436, 'ENERGY', 1042, 798, '2016-03-20', '2016-02-20', '2016-05-04', 244, 14283.9724, 0.0000, 4397.3200, 18681.2924, '2016-04-27 07:30:43', 'dbo', ''),
(2016030067, 201603, 17, 67, '2016-04-27', 1437, 'ENERGY', 107, 102, '2016-03-20', '2016-02-20', '2016-05-04', 5, 2876.6738, 0.0000, 90.1100, 2966.7838, '2016-04-27 07:30:43', 'dbo', ''),
(2016030068, 201603, 17, 68, '2016-04-27', 1438, 'ENERGY', 218, 211, '2016-03-20', '2016-02-20', '2016-05-04', 7, 5851.7600, 0.0000, 126.1500, 5977.9100, '2016-04-27 07:30:43', 'dbo', ''),
(2016030069, 201603, 17, 69, '2016-04-27', 1439, 'ENERGY', 1, 1, '2016-03-20', '2016-02-20', '2016-05-04', 0, 4060.0000, 0.0000, 0.0000, 4060.0000, '2016-04-27 07:30:43', 'dbo', ''),
(2016030070, 201603, 17, 70, '2016-04-27', 1440, 'ENERGY', 256, 256, '2016-03-20', '2016-02-20', '2016-05-04', 0, 8976.9600, 0.0000, 0.0000, 8976.9600, '2016-04-27 07:30:43', 'dbo', ''),
(2016030071, 201603, 17, 71, '2016-04-27', 1441, 'ENERGY', 4767, 1346, '2016-03-20', '2016-02-20', '2016-05-04', 3421, 29851.2262, 0.0000, 61652.6900, 91503.9162, '2016-04-27 07:30:42', 'dbo', ''),
(2016030072, 201603, 17, 72, '2016-04-27', 1442, 'ENERGY', 55, 39, '2016-03-20', '2016-02-20', '2016-05-04', 16, 4232.7300, 0.0000, 288.3500, 4521.0800, '2016-04-27 07:30:42', 'dbo', ''),
(2016030073, 201603, 17, 73, '2016-04-27', 1443, 'ENERGY', 322, 315, '2016-03-20', '2016-02-20', '2016-05-04', 7, 15917.8480, 0.0000, 126.1500, 16043.9980, '2016-04-27 07:30:42', 'dbo', ''),
(2016030075, 201603, 17, 75, '2016-04-27', 1444, 'ENERGY', 568, 525, '2016-03-20', '2016-02-20', '2016-05-04', 43, 11879.4000, 0.0000, 774.9300, 12654.3300, '2016-04-27 07:30:43', 'dbo', ''),
(2016030076, 201603, 17, 76, '2016-04-27', 1445, 'ENERGY', 670, 630, '2016-03-20', '2016-02-20', '2016-05-04', 40, 13763.2400, 0.0000, 720.8700, 14484.1100, '2016-04-27 07:30:43', 'dbo', ''),
(2016030078, 201603, 17, 78, '2016-04-27', 1447, 'ENERGY', 106, 95, '2016-03-20', '2016-02-20', '2016-05-04', 11, 4017.1000, 0.0000, 198.2400, 4215.3400, '2016-04-27 07:30:43', 'dbo', ''),
(2016030079, 201603, 17, 79, '2016-04-27', 1448, 'ENERGY', 10215, 8392, '2016-03-20', '2016-02-20', '2016-05-04', 1823, 48713.8700, 0.0000, 32853.8100, 81567.6800, '2016-04-27 07:30:43', 'dbo', ''),
(2016030080, 201603, 17, 80, '2016-04-27', 1449, 'ENERGY', 236, 211, '2016-03-20', '2016-02-20', '2016-05-04', 25, 1315.3200, 0.0000, 450.5400, 1765.8600, '2016-04-27 07:30:43', 'dbo', ''),
(2016030081, 201603, 17, 81, '2016-04-27', 1450, 'ENERGY', 161, 70, '2016-03-20', '2016-02-20', '2016-05-04', 91, 290.0000, 0.0000, 1639.9900, 1929.9900, '2016-04-27 07:30:43', 'dbo', ''),
(2016030082, 201603, 17, 82, '2016-04-27', 1451, 'ENERGY', 141, 18, '2016-03-20', '2016-02-20', '2016-05-04', 123, 615.0000, 0.0000, 2216.6900, 2831.6900, '2016-04-27 07:30:43', 'dbo', ''),
(2016040001, 201604, 18, 1, '2016-07-20', 1452, 'ENERGY', 11811, 7745, '2016-04-30', '2016-03-20', '2016-07-27', 4066, 140192.7514, 0.0000, 73727.1500, 213919.9014, '2016-07-20 08:02:47', 'dbo', ''),
(2016040002, 201604, 18, 2, '2016-07-20', 1453, 'ENERGY', 6178, 4395, '2016-04-30', '2016-03-20', '2016-07-27', 1783, 78159.5510, 0.0000, 32493.2700, 110652.8210, '2016-07-20 08:02:47', 'dbo', ''),
(2016040003, 201604, 18, 3, '2016-07-20', 1454, 'ENERGY', 7767, 5575, '2016-04-30', '2016-03-20', '2016-07-27', 2192, 101380.6234, 0.0000, 39880.3200, 141260.9434, '2016-07-20 08:02:47', 'dbo', ''),
(2016040004, 201604, 18, 4, '2016-07-20', 1455, 'ENERGY', 5895, 4365, '2016-04-30', '2016-03-20', '2016-07-27', 1530, 78339.1022, 0.0000, 27923.7400, 106262.8422, '2016-07-20 08:02:47', 'dbo', ''),
(2016040005, 201604, 18, 5, '2016-07-20', 1456, 'ENERGY', 4520, 3115, '2016-04-30', '2016-03-20', '2016-07-27', 1405, 56336.3786, 0.0000, 25666.0900, 82002.4686, '2016-07-20 08:02:47', 'dbo', ''),
(2016040006, 201604, 18, 6, '2016-07-20', 1457, 'ENERGY', 12092, 8175, '2016-04-30', '2016-03-20', '2016-07-27', 3917, 148116.6768, 0.0000, 71036.0200, 219152.6968, '2016-07-20 08:02:47', 'dbo', ''),
(2016040007, 201604, 18, 7, '2016-07-20', 1458, 'ENERGY', 8276, 5394, '2016-04-30', '2016-03-20', '2016-07-27', 2882, 98028.3100, 0.0000, 52342.5900, 150370.9000, '2016-07-20 08:02:47', 'dbo', ''),
(2016040008, 201604, 18, 8, '2016-07-20', 1459, 'ENERGY', 167, 167, '2016-04-30', '2016-03-20', '2016-07-27', 0, 2922.4376, 0.0000, 290.0000, 3212.4376, '2016-07-20 08:02:47', 'dbo', ''),
(2016040009, 201604, 18, 9, '2016-07-20', 1460, 'ENERGY', 64, 64, '2016-04-30', '2016-03-20', '2016-07-27', 0, 4891.7964, 0.0000, 290.0000, 5181.7964, '2016-07-20 08:02:47', 'dbo', ''),
(2016040010, 201604, 18, 10, '2016-07-20', 1461, 'ENERGY', 81, 81, '2016-04-30', '2016-03-20', '2016-07-27', 0, 5168.0880, 0.0000, 290.0000, 5458.0880, '2016-07-20 08:02:47', 'dbo', ''),
(2016040011, 201604, 18, 11, '2016-07-20', 1462, 'ENERGY', 199, 196, '2016-04-30', '2016-03-20', '2016-07-27', 3, 8821.4110, 0.0000, 344.1900, 9165.6010, '2016-07-20 08:02:47', 'dbo', ''),
(2016040012, 201604, 18, 12, '2016-07-20', 1463, 'ENERGY', 51, 51, '2016-04-30', '2016-03-20', '2016-07-27', 0, 4534.1600, 0.0000, 290.0000, 4824.1600, '2016-07-20 08:02:47', 'dbo', ''),
(2016040013, 201604, 18, 13, '2016-07-20', 1464, 'ENERGY', 81, 81, '2016-04-30', '2016-03-20', '2016-07-27', 0, 5905.6340, 0.0000, 290.0000, 6195.6340, '2016-07-20 08:02:47', 'dbo', ''),
(2016040014, 201604, 18, 14, '2016-07-20', 1465, 'ENERGY', 176, 176, '2016-04-30', '2016-03-20', '2016-07-27', 0, 7851.9654, 0.0000, 290.0000, 8141.9654, '2016-07-20 08:02:47', 'dbo', ''),
(2016040015, 201604, 18, 15, '2016-07-20', 1466, 'ENERGY', 162, 162, '2016-04-30', '2016-03-20', '2016-07-27', 0, 6839.0690, 0.0000, 290.0000, 7129.0690, '2016-07-20 08:02:47', 'dbo', ''),
(2016040016, 201604, 18, 16, '2016-07-20', 1467, 'ENERGY', 75, 75, '2016-04-30', '2016-03-20', '2016-07-27', 0, 5068.5520, 0.0000, 290.0000, 5358.5520, '2016-07-20 08:02:47', 'dbo', ''),
(2016040017, 201604, 18, 17, '2016-07-20', 1468, 'ENERGY', 204, 189, '2016-04-30', '2016-03-20', '2016-07-27', 15, 2813.5470, 0.0000, 560.9100, 3374.4570, '2016-07-20 08:02:47', 'dbo', ''),
(2016040018, 201604, 18, 18, '2016-07-20', 1469, 'ENERGY', 46, 46, '2016-04-30', '2016-03-20', '2016-07-27', 0, 2049.5300, 0.0000, 290.0000, 2339.5300, '2016-07-20 08:02:47', 'dbo', ''),
(2016040019, 201604, 18, 19, '2016-07-20', 1470, 'ENERGY', 74, 74, '2016-04-30', '2016-03-20', '2016-07-27', 0, 1346.4150, 0.0000, 290.0000, 1636.4150, '2016-07-20 08:02:47', 'dbo', ''),
(2016040020, 201604, 18, 20, '2016-07-20', 1471, 'ENERGY', 203, 196, '2016-04-30', '2016-03-20', '2016-07-27', 7, 3702.6330, 0.0000, 416.4400, 4119.0730, '2016-07-20 08:02:47', 'dbo', ''),
(2016040021, 201604, 18, 21, '2016-07-20', 1472, 'ENERGY', 29096, 27828, '2016-04-30', '2016-03-20', '2016-07-27', 1268, 724043.1346, 0.0000, 23191.7100, 747234.8446, '2016-07-20 08:02:47', 'dbo', ''),
(2016040022, 201604, 18, 22, '2016-07-20', 1473, 'ENERGY', 17413, 16914, '2016-04-30', '2016-03-20', '2016-07-27', 499, 440480.8916, 0.0000, 9302.5800, 449783.4716, '2016-07-20 08:02:47', 'dbo', ''),
(2016040023, 201604, 18, 23, '2016-07-20', 1474, 'ENERGY', 40621, 38994, '2016-04-30', '2016-03-20', '2016-07-27', 1627, 1047236.5570, 0.0000, 29675.6900, 1076912.2470, '2016-07-20 08:02:47', 'dbo', ''),
(2016040024, 201604, 18, 24, '2016-07-20', 1475, 'ENERGY', 34298, 33373, '2016-04-30', '2016-03-20', '2016-07-27', 925, 898319.8200, 0.0000, 16996.6900, 915316.5100, '2016-07-20 08:02:47', 'dbo', ''),
(2016040025, 201604, 18, 25, '2016-07-20', 1476, 'ENERGY', 97, 97, '2016-04-30', '2016-03-20', '2016-07-27', 0, 2791.1700, 0.0000, 290.0000, 3081.1700, '2016-07-20 08:02:47', 'dbo', ''),
(2016040026, 201604, 18, 26, '2016-07-20', 1477, 'ENERGY', 29140, 26138, '2016-04-30', '2016-03-20', '2016-07-27', 3002, 346144.2574, 0.0000, 54509.9600, 400654.2174, '2016-07-20 08:02:47', 'dbo', ''),
(2016040029, 201604, 18, 29, '2016-07-20', 1480, 'ENERGY', 49851, 47981, '2016-04-30', '2016-03-20', '2016-07-27', 1870, 604618.3988, 0.0000, 34064.5800, 638682.9788, '2016-07-20 08:02:47', 'dbo', ''),
(2016040030, 201604, 18, 30, '2016-07-20', 1481, 'ENERGY', 23457, 22432, '2016-04-30', '2016-03-20', '2016-07-27', 1025, 169369.6512, 0.0000, 18802.7800, 188172.4312, '2016-07-20 08:02:47', 'dbo', ''),
(2016040031, 201604, 18, 31, '2016-07-20', 1482, 'ENERGY', 28603, 26496, '2016-04-30', '2016-03-20', '2016-07-27', 2107, 292681.9780, 0.0000, 38345.1000, 331027.0780, '2016-07-20 08:02:47', 'dbo', ''),
(2016040032, 201604, 18, 32, '2016-07-20', 1483, 'ENERGY', 46641, 43413, '2016-04-30', '2016-03-20', '2016-07-27', 3228, 487746.9890, 0.0000, 58591.7900, 546338.7790, '2016-07-20 08:02:47', 'dbo', ''),
(2016040033, 201604, 18, 33, '2016-07-20', 1484, 'ENERGY', 5782, 5316, '2016-04-30', '2016-03-20', '2016-07-27', 466, 69334.4834, 0.0000, 8706.5400, 78041.0234, '2016-07-20 08:02:47', 'dbo', ''),
(2016040034, 201604, 18, 34, '2016-07-20', 1485, 'ENERGY', 3854, 3551, '2016-04-30', '2016-03-20', '2016-07-27', 303, 49494.8642, 0.0000, 5762.5500, 55257.4142, '2016-07-20 08:02:47', 'dbo', ''),
(2016040035, 201604, 18, 35, '2016-07-20', 1486, 'ENERGY', 8324, 7833, '2016-04-30', '2016-03-20', '2016-07-27', 491, 98840.1726, 0.0000, 9158.0700, 107998.2426, '2016-07-20 08:02:47', 'dbo', ''),
(2016040036, 201604, 18, 36, '2016-07-20', 1487, 'ENERGY', 17823, 16373, '2016-04-30', '2016-03-20', '2016-07-27', 1450, 226007.5538, 0.0000, 26478.8500, 252486.4038, '2016-07-20 08:02:47', 'dbo', ''),
(2016040037, 201604, 18, 37, '2016-07-20', 1488, 'ENERGY', 11198, 10542, '2016-04-30', '2016-03-20', '2016-07-27', 656, 129888.1210, 0.0000, 12138.1900, 142026.3110, '2016-07-20 08:02:47', 'dbo', ''),
(2016040038, 201604, 18, 38, '2016-07-20', 1489, 'ENERGY', 5499, 5109, '2016-04-30', '2016-03-20', '2016-07-27', 390, 69901.0134, 0.0000, 7333.9100, 77234.9234, '2016-07-20 08:02:48', 'dbo', ''),
(2016040039, 201604, 18, 39, '2016-07-20', 1490, 'ENERGY', 14152, 12559, '2016-04-30', '2016-03-20', '2016-07-27', 1593, -440129.8018, 0.0000, 29061.6100, -411068.1918, '2016-07-20 08:02:48', 'dbo', ''),
(2016040040, 201604, 18, 40, '2016-07-20', 1491, 'ENERGY', 10542, 10542, '2016-04-30', '2016-03-20', '2016-07-27', 0, 145984.6096, 0.0000, 290.0000, 146274.6096, '2016-07-20 08:02:48', 'dbo', ''),
(2016040041, 201604, 18, 41, '2016-07-20', 1492, 'ENERGY', 234, 119, '2016-04-30', '2016-03-20', '2016-07-27', 115, 7056.3200, 0.0000, 2367.0400, 9423.3600, '2016-07-20 08:02:47', 'dbo', ''),
(2016040042, 201604, 18, 42, '2016-07-20', 1493, 'ENERGY', 183, 183, '2016-04-30', '2016-03-20', '2016-07-27', 0, 7174.5460, 0.0000, 290.0000, 7464.5460, '2016-07-20 08:02:47', 'dbo', ''),
(2016040043, 201604, 18, 43, '2016-07-20', 1494, 'ENERGY', 33717, 31828, '2016-04-30', '2016-03-20', '2016-07-27', 1889, 280360.1102, 0.0000, 34407.7600, 314767.8702, '2016-07-20 08:02:47', 'dbo', ''),
(2016040044, 201604, 18, 44, '2016-07-20', 1495, 'ENERGY', 10522, 9040, '2016-04-30', '2016-03-20', '2016-07-27', 1482, 161722.3530, 0.0000, 27056.8100, 188779.1630, '2016-07-20 08:02:47', 'dbo', ''),
(2016040045, 201604, 18, 45, '2016-07-20', 1496, 'ENERGY', 20631, 19851, '2016-04-30', '2016-03-20', '2016-07-27', 780, 220428.2920, 0.0000, 14377.7900, 234806.0820, '2016-07-20 08:02:47', 'dbo', ''),
(2016040046, 201604, 18, 46, '2016-07-20', 1497, 'ENERGY', 25955, 24653, '2016-04-30', '2016-03-20', '2016-07-27', 1302, 391950.6554, 0.0000, 23805.7900, 415756.4454, '2016-07-20 08:02:47', 'dbo', ''),
(2016040047, 201604, 18, 47, '2016-07-20', 1498, 'ENERGY', 14396, 13711, '2016-04-30', '2016-03-20', '2016-07-27', 685, 103243.9010, 0.0000, 12661.9800, 115905.8810, '2016-07-20 08:02:47', 'dbo', ''),
(2016040048, 201604, 18, 48, '2016-07-20', 1499, 'ENERGY', 91, 91, '2016-04-30', '2016-03-20', '2016-07-27', 0, 2067.8300, 0.0000, 290.0000, 2357.8300, '2016-07-20 08:02:47', 'dbo', ''),
(2016040049, 201604, 18, 49, '2016-07-20', 1500, 'ENERGY', 2710, 2574, '2016-04-30', '2016-03-20', '2016-07-27', 136, 31249.4390, 0.0000, 2746.3400, 33995.7790, '2016-07-20 08:02:47', 'dbo', ''),
(2016040050, 201604, 18, 50, '2016-07-20', 1501, 'ENERGY', 41554, 39301, '2016-04-30', '2016-03-20', '2016-07-27', 2253, 435569.7292, 0.0000, 40982.0500, 476551.7792, '2016-07-20 08:02:47', 'dbo', ''),
(2016040051, 201604, 18, 51, '2016-07-20', 1502, 'ENERGY', 211, 211, '2016-04-30', '2016-03-20', '2016-07-27', 0, 2319.9990, 0.0000, 290.0000, 2609.9990, '2016-07-20 08:02:47', 'dbo', ''),
(2016040052, 201604, 18, 52, '2016-07-20', 1503, 'ENERGY', 245, 229, '2016-04-30', '2016-03-20', '2016-07-27', 16, 4820.8820, 0.0000, 578.9700, 5399.8520, '2016-07-20 08:02:47', 'dbo', ''),
(2016040053, 201604, 18, 53, '2016-07-20', 1504, 'ENERGY', 676, 538, '2016-04-30', '2016-03-20', '2016-07-27', 138, 14401.4870, 0.0000, 2782.4500, 17183.9370, '2016-07-20 08:02:48', 'dbo', ''),
(2016040054, 201604, 18, 54, '2016-07-20', 1505, 'ENERGY', 14251, 13647, '2016-04-30', '2016-03-20', '2016-07-27', 604, 308902.1294, 0.0000, 11199.0200, 320101.1494, '2016-07-20 08:02:48', 'dbo', ''),
(2016040055, 201604, 18, 55, '2016-07-20', 1506, 'ENERGY', 5301, 4486, '2016-04-30', '2016-03-20', '2016-07-27', 815, 86211.2700, 0.0000, 15009.9300, 101221.2000, '2016-07-20 08:02:48', 'dbo', ''),
(2016040056, 201604, 18, 56, '2016-07-20', 1507, 'ENERGY', 81, 81, '2016-04-30', '2016-03-20', '2016-07-27', 0, 2731.8390, 0.0000, 290.0000, 3021.8390, '2016-07-20 08:02:48', 'dbo', ''),
(2016040059, 201604, 18, 59, '2016-07-20', 1510, 'ENERGY', 128, 128, '2016-04-30', '2016-03-20', '2016-07-27', 0, 4608.1400, 0.0000, 290.0000, 4898.1400, '2016-07-20 08:02:47', 'dbo', ''),
(2016040060, 201604, 18, 60, '2016-07-20', 1511, 'ENERGY', 79901, 72226, '2016-04-30', '2016-03-20', '2016-07-27', 7675, 1257283.0800, 0.0000, 138910.2700, 1396193.3500, '2016-07-20 08:02:47', 'dbo', ''),
(2016040061, 201604, 18, 61, '2016-07-20', 1512, 'ENERGY', 3, 3, '2016-04-30', '2016-03-20', '2016-07-27', 0, 2320.0000, 0.0000, 290.0000, 2610.0000, '2016-07-20 08:02:47', 'dbo', ''),
(2016040062, 201604, 18, 62, '2016-07-20', 1513, 'ENERGY', 30, 30, '2016-04-30', '2016-03-20', '2016-07-27', 0, 2320.0000, 0.0000, 290.0000, 2610.0000, '2016-07-20 08:02:47', 'dbo', ''),
(2016040063, 201604, 18, 63, '2016-07-20', 1514, 'ENERGY', 1, 1, '2016-04-30', '2016-03-20', '2016-07-27', 0, 2320.0000, 0.0000, 290.0000, 2610.0000, '2016-07-20 08:02:47', 'dbo', ''),
(2016040064, 201604, 18, 64, '2016-07-20', 1515, 'ENERGY', 2, 2, '2016-04-30', '2016-03-20', '2016-07-27', 0, 2320.0000, 0.0000, 290.0000, 2610.0000, '2016-07-20 08:02:47', 'dbo', ''),
(2016040065, 201604, 18, 65, '2016-07-20', 1516, 'ENERGY', 950, 574, '2016-04-30', '2016-03-20', '2016-07-27', 376, 12135.7580, 0.0000, 7081.0400, 19216.7980, '2016-07-20 08:02:47', 'dbo', ''),
(2016040066, 201604, 18, 66, '2016-07-20', 1517, 'ENERGY', 1292, 1042, '2016-04-30', '2016-03-20', '2016-07-27', 250, 18681.2924, 0.0000, 4805.3300, 23486.6224, '2016-07-20 08:02:47', 'dbo', ''),
(2016040067, 201604, 18, 67, '2016-07-20', 1518, 'ENERGY', 114, 107, '2016-04-30', '2016-03-20', '2016-07-27', 7, 2966.7838, 0.0000, 416.4400, 3383.2238, '2016-07-20 08:02:48', 'dbo', ''),
(2016040068, 201604, 18, 68, '2016-07-20', 1519, 'ENERGY', 224, 218, '2016-04-30', '2016-03-20', '2016-07-27', 6, 5977.9100, 0.0000, 398.3700, 6376.2800, '2016-07-20 08:02:48', 'dbo', ''),
(2016040069, 201604, 18, 69, '2016-07-20', 1520, 'ENERGY', 1, 1, '2016-04-30', '2016-03-20', '2016-07-27', 0, 4060.0000, 0.0000, 290.0000, 4350.0000, '2016-07-20 08:02:47', 'dbo', ''),
(2016040070, 201604, 18, 70, '2016-07-20', 1521, 'ENERGY', 296, 256, '2016-04-30', '2016-03-20', '2016-07-27', 40, 8976.9600, 0.0000, 1012.4500, 9989.4100, '2016-07-20 08:02:47', 'dbo', ''),
(2016040071, 201604, 18, 71, '2016-07-20', 1522, 'ENERGY', 13605, 4767, '2016-04-30', '2016-03-20', '2016-07-27', 8838, 91503.9162, 0.0000, 159915.5400, 251419.4562, '2016-07-20 08:02:46', 'dbo', ''),
(2016040072, 201604, 18, 72, '2016-07-20', 1523, 'ENERGY', 195, 55, '2016-04-30', '2016-03-20', '2016-07-27', 140, 4521.0800, 0.0000, 2818.5700, 7339.6500, '2016-07-20 08:02:47', 'dbo', ''),
(2016040073, 201604, 18, 73, '2016-07-20', 1524, 'ENERGY', 328, 322, '2016-04-30', '2016-03-20', '2016-07-27', 6, 16043.9980, 0.0000, 398.3700, 16442.3680, '2016-07-20 08:02:47', 'dbo', ''),
(2016040075, 201604, 18, 75, '2016-07-20', 1525, 'ENERGY', 612, 568, '2016-04-30', '2016-03-20', '2016-07-27', 44, 12654.3300, 0.0000, 1084.7100, 13739.0400, '2016-07-20 08:02:47', 'dbo', ''),
(2016040076, 201604, 18, 76, '2016-07-20', 1526, 'ENERGY', 713, 670, '2016-04-30', '2016-03-20', '2016-07-27', 43, 14484.1100, 0.0000, 1066.6500, 15550.7600, '2016-07-20 08:02:47', 'dbo', ''),
(2016040077, 201604, 18, 77, '2016-07-20', 1527, 'ENERGY', 623, 560, '2016-04-30', '2016-03-20', '2016-07-27', 63, 12403.6200, 0.0000, 1427.8700, 13831.4900, '2016-07-20 08:02:47', 'dbo', ''),
(2016040078, 201604, 18, 78, '2016-07-20', 1528, 'ENERGY', 117, 106, '2016-04-30', '2016-03-20', '2016-07-27', 11, 4215.3400, 0.0000, 488.6800, 4704.0200, '2016-07-20 08:02:47', 'dbo', ''),
(2016040079, 201604, 18, 79, '2016-07-20', 1529, 'ENERGY', 11622, 10215, '2016-04-30', '2016-03-20', '2016-07-27', 1407, 81567.6800, 0.0000, 25702.2300, 107269.9100, '2016-07-20 08:02:47', 'dbo', ''),
(2016040080, 201604, 18, 80, '2016-07-20', 1530, 'ENERGY', 263, 236, '2016-04-30', '2016-03-20', '2016-07-27', 27, 1765.8600, 0.0000, 777.6600, 2543.5200, '2016-07-20 08:02:47', 'dbo', ''),
(2016040081, 201604, 18, 81, '2016-07-20', 1531, 'ENERGY', 278, 161, '2016-04-30', '2016-03-20', '2016-07-27', 117, 1929.9900, 0.0000, 2403.1700, 4333.1600, '2016-07-20 08:02:47', 'dbo', ''),
(2016040082, 201604, 18, 82, '2016-07-20', 1532, 'ENERGY', 275, 141, '2016-04-30', '2016-03-20', '2016-07-27', 134, 2831.6900, 0.0000, 2710.2200, 5541.9100, '2016-07-20 08:02:47', 'dbo', ''),
(2016050001, 201605, 19, 1, '2016-07-20', 1533, 'ENERGY', 14016, 11811, '2016-05-30', '2016-04-30', '2016-07-27', 2205, 213919.9014, 0.0000, 39816.5900, 253736.4914, '2016-07-20 08:15:23', 'dbo', ''),
(2016050002, 201605, 19, 2, '2016-07-20', 1534, 'ENERGY', 7081, 6178, '2016-05-30', '2016-04-30', '2016-07-27', 903, 110652.8210, 0.0000, 16477.0700, 127129.8910, '2016-07-20 08:15:23', 'dbo', ''),
(2016050003, 201605, 19, 3, '2016-07-20', 1535, 'ENERGY', 8948, 7767, '2016-05-30', '2016-04-30', '2016-07-27', 1181, 141260.9434, 0.0000, 21460.4700, 162721.4134, '2016-07-20 08:15:23', 'dbo', ''),
(2016050004, 201605, 19, 4, '2016-07-20', 1536, 'ENERGY', 6711, 5895, '2016-05-30', '2016-04-30', '2016-07-27', 816, 106262.8422, 0.0000, 14917.5200, 121180.3622, '2016-07-20 08:15:23', 'dbo', ''),
(2016050005, 201605, 19, 5, '2016-07-20', 1537, 'ENERGY', 5255, 4520, '2016-05-30', '2016-04-30', '2016-07-27', 735, 82002.4686, 0.0000, 13465.5300, 95467.9986, '2016-07-20 08:15:24', 'dbo', ''),
(2016050006, 201605, 19, 6, '2016-07-20', 1538, 'ENERGY', 13833, 12092, '2016-05-30', '2016-04-30', '2016-07-27', 1741, 219152.6968, 0.0000, 31498.9700, 250651.6668, '2016-07-20 08:15:24', 'dbo', ''),
(2016050007, 201605, 19, 7, '2016-07-20', 1539, 'ENERGY', 9652, 8276, '2016-05-30', '2016-04-30', '2016-07-27', 1376, 150370.9000, 0.0000, 24956.0200, 175326.9200, '2016-07-20 08:15:24', 'dbo', ''),
(2016050008, 201605, 19, 8, '2016-07-20', 1540, 'ENERGY', 167, 167, '2016-05-30', '2016-04-30', '2016-07-27', 0, 3212.4376, 0.0000, 290.0000, 3502.4376, '2016-07-20 08:15:24', 'dbo', ''),
(2016050009, 201605, 19, 9, '2016-07-20', 1541, 'ENERGY', 64, 64, '2016-05-30', '2016-04-30', '2016-07-27', 0, 5181.7964, 0.0000, 290.0000, 5471.7964, '2016-07-20 08:15:23', 'dbo', ''),
(2016050010, 201605, 19, 10, '2016-07-20', 1542, 'ENERGY', 81, 81, '2016-05-30', '2016-04-30', '2016-07-27', 0, 5458.0880, 0.0000, 290.0000, 5748.0880, '2016-07-20 08:15:23', 'dbo', ''),
(2016050011, 201605, 19, 11, '2016-07-20', 1543, 'ENERGY', 199, 199, '2016-05-30', '2016-04-30', '2016-07-27', 0, 9165.6010, 0.0000, 290.0000, 9455.6010, '2016-07-20 08:15:23', 'dbo', ''),
(2016050012, 201605, 19, 12, '2016-07-20', 1544, 'ENERGY', 51, 51, '2016-05-30', '2016-04-30', '2016-07-27', 0, 4824.1600, 0.0000, 290.0000, 5114.1600, '2016-07-20 08:15:23', 'dbo', ''),
(2016050013, 201605, 19, 13, '2016-07-20', 1545, 'ENERGY', 81, 81, '2016-05-30', '2016-04-30', '2016-07-27', 0, 6195.6340, 0.0000, 290.0000, 6485.6340, '2016-07-20 08:15:24', 'dbo', ''),
(2016050014, 201605, 19, 14, '2016-07-20', 1546, 'ENERGY', 176, 176, '2016-05-30', '2016-04-30', '2016-07-27', 0, 8141.9654, 0.0000, 290.0000, 8431.9654, '2016-07-20 08:15:24', 'dbo', ''),
(2016050015, 201605, 19, 15, '2016-07-20', 1547, 'ENERGY', 162, 162, '2016-05-30', '2016-04-30', '2016-07-27', 0, 7129.0690, 0.0000, 290.0000, 7419.0690, '2016-07-20 08:15:24', 'dbo', ''),
(2016050016, 201605, 19, 16, '2016-07-20', 1548, 'ENERGY', 75, 75, '2016-05-30', '2016-04-30', '2016-07-27', 0, 5358.5520, 0.0000, 290.0000, 5648.5520, '2016-07-20 08:15:24', 'dbo', ''),
(2016050017, 201605, 19, 17, '2016-07-20', 1549, 'ENERGY', 204, 204, '2016-05-30', '2016-04-30', '2016-07-27', 0, 3374.4570, 0.0000, 290.0000, 3664.4570, '2016-07-20 08:15:23', 'dbo', ''),
(2016050018, 201605, 19, 18, '2016-07-20', 1550, 'ENERGY', 66, 46, '2016-05-30', '2016-04-30', '2016-07-27', 20, 2339.5300, 0.0000, 648.5200, 2988.0500, '2016-07-20 08:15:23', 'dbo', ''),
(2016050019, 201605, 19, 19, '2016-07-20', 1551, 'ENERGY', 75, 74, '2016-05-30', '2016-04-30', '2016-07-27', 1, 1636.4150, 0.0000, 307.9300, 1944.3450, '2016-07-20 08:15:23', 'dbo', ''),
(2016050020, 201605, 19, 20, '2016-07-20', 1552, 'ENERGY', 203, 203, '2016-05-30', '2016-04-30', '2016-07-27', 0, 4119.0730, 0.0000, 290.0000, 4409.0730, '2016-07-20 08:15:23', 'dbo', ''),
(2016050021, 201605, 19, 21, '2016-07-20', 1553, 'ENERGY', 30320, 29096, '2016-05-30', '2016-04-30', '2016-07-27', 1224, 747234.8446, 0.0000, 22231.2900, 769466.1346, '2016-07-20 08:15:23', 'dbo', ''),
(2016050022, 201605, 19, 22, '2016-07-20', 1554, 'ENERGY', 17882, 17413, '2016-05-30', '2016-04-30', '2016-07-27', 469, 449783.4716, 0.0000, 8697.2400, 458480.7116, '2016-07-20 08:15:24', 'dbo', ''),
(2016050023, 201605, 19, 23, '2016-07-20', 1555, 'ENERGY', 41393, 40621, '2016-05-30', '2016-04-30', '2016-07-27', 772, 1076912.2470, 0.0000, 14128.7900, 1091041.0370, '2016-07-20 08:15:24', 'dbo', ''),
(2016050024, 201605, 19, 24, '2016-07-20', 1556, 'ENERGY', 35152, 34298, '2016-05-30', '2016-04-30', '2016-07-27', 854, 915316.5100, 0.0000, 15598.7100, 930915.2200, '2016-07-20 08:15:24', 'dbo', ''),
(2016050025, 201605, 19, 25, '2016-07-20', 1557, 'ENERGY', 97, 97, '2016-05-30', '2016-04-30', '2016-07-27', 0, 3081.1700, 0.0000, 290.0000, 3371.1700, '2016-07-20 08:15:23', 'dbo', ''),
(2016050026, 201605, 19, 26, '2016-07-20', 1558, 'ENERGY', 31368, 29140, '2016-05-30', '2016-04-30', '2016-07-27', 2228, 400654.2174, 0.0000, 40228.8800, 440883.0974, '2016-07-20 08:15:23', 'dbo', ''),
(2016050029, 201605, 19, 29, '2016-07-20', 1561, 'ENERGY', 51372, 49851, '2016-05-30', '2016-04-30', '2016-07-27', 1521, 638682.9788, 0.0000, 27555.2800, 666238.2588, '2016-07-20 08:15:23', 'dbo', ''),
(2016050030, 201605, 19, 30, '2016-07-20', 1562, 'ENERGY', 24358, 23457, '2016-05-30', '2016-04-30', '2016-07-27', 901, 188172.4312, 0.0000, 16441.2300, 204613.6612, '2016-07-20 08:15:23', 'dbo', ''),
(2016050031, 201605, 19, 31, '2016-07-20', 1563, 'ENERGY', 30218, 28603, '2016-05-30', '2016-04-30', '2016-07-27', 1615, 331027.0780, 0.0000, 29240.3100, 360267.3880, '2016-07-20 08:15:23', 'dbo', ''),
(2016050032, 201605, 19, 32, '2016-07-20', 1564, 'ENERGY', 49539, 46641, '2016-05-30', '2016-04-30', '2016-07-27', 2898, 546338.7790, 0.0000, 52239.2300, 598578.0090, '2016-07-20 08:15:23', 'dbo', ''),
(2016050033, 201605, 19, 33, '2016-07-20', 1565, 'ENERGY', 6251, 5782, '2016-05-30', '2016-04-30', '2016-07-27', 469, 78041.0234, 0.0000, 8697.2400, 86738.2634, '2016-07-20 08:15:23', 'dbo', ''),
(2016050034, 201605, 19, 34, '2016-07-20', 1566, 'ENERGY', 4093, 3854, '2016-05-30', '2016-04-30', '2016-07-27', 239, 55257.4142, 0.0000, 4574.2800, 59831.6942, '2016-07-20 08:15:23', 'dbo', ''),
(2016050035, 201605, 19, 35, '2016-07-20', 1567, 'ENERGY', 8771, 8324, '2016-05-30', '2016-04-30', '2016-07-27', 447, 107998.2426, 0.0000, 8302.8700, 116301.1126, '2016-07-20 08:15:23', 'dbo', ''),
(2016050036, 201605, 19, 36, '2016-07-20', 1568, 'ENERGY', 19048, 17823, '2016-05-30', '2016-04-30', '2016-07-27', 1225, 252486.4038, 0.0000, 22249.2200, 274735.6238, '2016-07-20 08:15:23', 'dbo', ''),
(2016050037, 201605, 19, 37, '2016-07-20', 1569, 'ENERGY', 11789, 11198, '2016-05-30', '2016-04-30', '2016-07-27', 591, 142026.3110, 0.0000, 10884.2000, 152910.5110, '2016-07-20 08:15:24', 'dbo', ''),
(2016050038, 201605, 19, 38, '2016-07-20', 1570, 'ENERGY', 5801, 5499, '2016-05-30', '2016-04-30', '2016-07-27', 302, 77234.9234, 0.0000, 5703.6200, 82938.5434, '2016-07-20 08:15:24', 'dbo', ''),
(2016050039, 201605, 19, 39, '2016-07-20', 1571, 'ENERGY', 14783, 14152, '2016-05-30', '2016-04-30', '2016-07-27', 631, -411068.1918, 0.0000, 11601.2300, -399466.9618, '2016-07-20 08:15:24', 'dbo', ''),
(2016050040, 201605, 19, 40, '2016-07-20', 1572, 'ENERGY', 10732, 10542, '2016-05-30', '2016-04-30', '2016-07-27', 190, 146274.6096, 0.0000, 3695.9200, 149970.5296, '2016-07-20 08:15:24', 'dbo', ''),
(2016050041, 201605, 19, 41, '2016-07-20', 1573, 'ENERGY', 241, 234, '2016-05-30', '2016-04-30', '2016-07-27', 7, 9423.3600, 0.0000, 415.4800, 9838.8400, '2016-07-20 08:15:23', 'dbo', ''),
(2016050042, 201605, 19, 42, '2016-07-20', 1574, 'ENERGY', 183, 183, '2016-05-30', '2016-04-30', '2016-07-27', 0, 7464.5460, 0.0000, 290.0000, 7754.5460, '2016-07-20 08:15:23', 'dbo', ''),
(2016050043, 201605, 19, 43, '2016-07-20', 1575, 'ENERGY', 35251, 33717, '2016-05-30', '2016-04-30', '2016-07-27', 1534, 314767.8702, 0.0000, 27788.3100, 342556.1802, '2016-07-20 08:15:23', 'dbo', ''),
(2016050044, 201605, 19, 44, '2016-07-20', 1576, 'ENERGY', 11813, 10522, '2016-05-30', '2016-04-30', '2016-07-27', 1291, 188779.1630, 0.0000, 23432.3200, 212211.4830, '2016-07-20 08:15:23', 'dbo', ''),
(2016050045, 201605, 19, 45, '2016-07-20', 1577, 'ENERGY', 21368, 20631, '2016-05-30', '2016-04-30', '2016-07-27', 737, 234806.0820, 0.0000, 13501.3700, 248307.4520, '2016-07-20 08:15:24', 'dbo', ''),
(2016050046, 201605, 19, 46, '2016-07-20', 1578, 'ENERGY', 27038, 25955, '2016-05-30', '2016-04-30', '2016-07-27', 1083, 415756.4454, 0.0000, 19703.7400, 435460.1854, '2016-07-20 08:15:24', 'dbo', ''),
(2016050047, 201605, 19, 47, '2016-07-20', 1579, 'ENERGY', 14938, 14396, '2016-05-30', '2016-04-30', '2016-07-27', 542, 115905.8810, 0.0000, 10005.8400, 125911.7210, '2016-07-20 08:15:24', 'dbo', ''),
(2016050048, 201605, 19, 48, '2016-07-20', 1580, 'ENERGY', 91, 91, '2016-05-30', '2016-04-30', '2016-07-27', 0, 2357.8300, 0.0000, 290.0000, 2647.8300, '2016-07-20 08:15:24', 'dbo', ''),
(2016050049, 201605, 19, 49, '2016-07-20', 1581, 'ENERGY', 2860, 2710, '2016-05-30', '2016-04-30', '2016-07-27', 150, 33995.7790, 0.0000, 2978.8900, 36974.6690, '2016-07-20 08:15:23', 'dbo', ''),
(2016050050, 201605, 19, 50, '2016-07-20', 1582, 'ENERGY', 43512, 41554, '2016-05-30', '2016-04-30', '2016-07-27', 1958, 476551.7792, 0.0000, 35388.8900, 511940.6692, '2016-07-20 08:15:23', 'dbo', ''),
(2016050051, 201605, 19, 51, '2016-07-20', 1583, 'ENERGY', 211, 211, '2016-05-30', '2016-04-30', '2016-07-27', 0, 2609.9990, 0.0000, 290.0000, 2899.9990, '2016-07-20 08:15:23', 'dbo', ''),
(2016050052, 201605, 19, 52, '2016-07-20', 1584, 'ENERGY', 257, 245, '2016-05-30', '2016-04-30', '2016-07-27', 12, 5399.8520, 0.0000, 505.1100, 5904.9620, '2016-07-20 08:15:23', 'dbo', ''),
(2016050053, 201605, 19, 53, '2016-07-20', 1585, 'ENERGY', 815, 676, '2016-05-30', '2016-04-30', '2016-07-27', 139, 17183.9370, 0.0000, 2781.7000, 19965.6370, '2016-07-20 08:15:24', 'dbo', ''),
(2016050054, 201605, 19, 54, '2016-07-20', 1586, 'ENERGY', 14892, 14251, '2016-05-30', '2016-04-30', '2016-07-27', 641, 320101.1494, 0.0000, 11780.4900, 331881.6394, '2016-07-20 08:15:24', 'dbo', ''),
(2016050055, 201605, 19, 55, '2016-07-20', 1587, 'ENERGY', 6005, 5301, '2016-05-30', '2016-04-30', '2016-07-27', 704, 101221.2000, 0.0000, 12909.8300, 114131.0300, '2016-07-20 08:15:24', 'dbo', ''),
(2016050056, 201605, 19, 56, '2016-07-20', 1588, 'ENERGY', 81, 81, '2016-05-30', '2016-04-30', '2016-07-27', 0, 3021.8390, 0.0000, 290.0000, 3311.8390, '2016-07-20 08:15:24', 'dbo', ''),
(2016050059, 201605, 19, 59, '2016-07-20', 1591, 'ENERGY', 128, 128, '2016-05-30', '2016-04-30', '2016-07-27', 0, 4898.1400, 0.0000, 290.0000, 5188.1400, '2016-07-20 08:15:23', 'dbo', ''),
(2016050060, 201605, 19, 60, '2016-07-20', 1592, 'ENERGY', 86274, 79901, '2016-05-30', '2016-04-30', '2016-07-27', 6373, 1396193.3500, 0.0000, 114531.6900, 1510725.0400, '2016-07-20 08:15:23', 'dbo', ''),
(2016050061, 201605, 19, 61, '2016-07-20', 1593, 'ENERGY', 3, 3, '2016-05-30', '2016-04-30', '2016-07-27', 0, 2610.0000, 0.0000, 290.0000, 2900.0000, '2016-07-20 08:15:23', 'dbo', ''),
(2016050062, 201605, 19, 62, '2016-07-20', 1594, 'ENERGY', 30, 30, '2016-05-30', '2016-04-30', '2016-07-27', 0, 2610.0000, 0.0000, 290.0000, 2900.0000, '2016-07-20 08:15:23', 'dbo', ''),
(2016050063, 201605, 19, 63, '2016-07-20', 1595, 'ENERGY', 1, 1, '2016-05-30', '2016-04-30', '2016-07-27', 0, 2610.0000, 0.0000, 290.0000, 2900.0000, '2016-07-20 08:15:23', 'dbo', ''),
(2016050064, 201605, 19, 64, '2016-07-20', 1596, 'ENERGY', 2, 2, '2016-05-30', '2016-04-30', '2016-07-27', 0, 2610.0000, 0.0000, 290.0000, 2900.0000, '2016-07-20 08:15:23', 'dbo', ''),
(2016050065, 201605, 19, 65, '2016-07-20', 1597, 'ENERGY', 1286, 950, '2016-05-30', '2016-04-30', '2016-07-27', 336, 19216.7980, 0.0000, 6313.1000, 25529.8980, '2016-07-20 08:15:23', 'dbo', ''),
(2016050066, 201605, 19, 66, '2016-07-20', 1598, 'ENERGY', 1527, 1292, '2016-05-30', '2016-04-30', '2016-07-27', 235, 23486.6224, 0.0000, 4502.5800, 27989.2024, '2016-07-20 08:15:23', 'dbo', ''),
(2016050067, 201605, 19, 67, '2016-07-20', 1599, 'ENERGY', 161, 114, '2016-05-30', '2016-04-30', '2016-07-27', 47, 3383.2238, 0.0000, 1132.5200, 4515.7438, '2016-07-20 08:15:24', 'dbo', ''),
(2016050068, 201605, 19, 68, '2016-07-20', 1600, 'ENERGY', 305, 224, '2016-05-30', '2016-04-30', '2016-07-27', 81, 6376.2800, 0.0000, 1741.9900, 8118.2700, '2016-07-20 08:15:24', 'dbo', ''),
(2016050069, 201605, 19, 69, '2016-07-20', 1601, 'ENERGY', 1, 1, '2016-05-30', '2016-04-30', '2016-07-27', 0, 4350.0000, 0.0000, 290.0000, 4640.0000, '2016-07-20 08:15:23', 'dbo', ''),
(2016050070, 201605, 19, 70, '2016-07-20', 1602, 'ENERGY', 314, 296, '2016-05-30', '2016-04-30', '2016-07-27', 18, 9989.4100, 0.0000, 612.6600, 10602.0700, '2016-07-20 08:15:23', 'dbo', ''),
(2016050071, 201605, 19, 71, '2016-07-20', 1603, 'ENERGY', 21432, 13605, '2016-05-30', '2016-04-30', '2016-07-27', 7827, 251419.4562, 0.0000, 140595.9200, 392015.3762, '2016-07-20 08:15:22', 'dbo', ''),
(2016050072, 201605, 19, 72, '2016-07-20', 1604, 'ENERGY', 337, 195, '2016-05-30', '2016-04-30', '2016-07-27', 142, 7339.6500, 0.0000, 2835.4700, 10175.1200, '2016-07-20 08:15:23', 'dbo', ''),
(2016050073, 201605, 19, 73, '2016-07-20', 1605, 'ENERGY', 358, 328, '2016-05-30', '2016-04-30', '2016-07-27', 30, 16442.3680, 0.0000, 827.7800, 17270.1480, '2016-07-20 08:15:23', 'dbo', ''),
(2016050075, 201605, 19, 75, '2016-07-20', 1606, 'ENERGY', 648, 612, '2016-05-30', '2016-04-30', '2016-07-27', 36, 13739.0400, 0.0000, 935.3300, 14674.3700, '2016-07-20 08:15:23', 'dbo', ''),
(2016050076, 201605, 19, 76, '2016-07-20', 1607, 'ENERGY', 749, 713, '2016-05-30', '2016-04-30', '2016-07-27', 36, 15550.7600, 0.0000, 935.3300, 16486.0900, '2016-07-20 08:15:23', 'dbo', ''),
(2016050077, 201605, 19, 77, '2016-07-20', 1608, 'ENERGY', 649, 623, '2016-05-30', '2016-04-30', '2016-07-27', 26, 13831.4900, 0.0000, 756.0700, 14587.5600, '2016-07-20 08:15:23', 'dbo', ''),
(2016050078, 201605, 19, 78, '2016-07-20', 1609, 'ENERGY', 128, 117, '2016-05-30', '2016-04-30', '2016-07-27', 11, 4704.0200, 0.0000, 487.1900, 5191.2100, '2016-07-20 08:15:23', 'dbo', ''),
(2016050079, 201605, 19, 79, '2016-07-20', 1610, 'ENERGY', 12295, 11622, '2016-05-30', '2016-04-30', '2016-07-27', 673, 107269.9100, 0.0000, 12354.1200, 119624.0300, '2016-07-20 08:15:23', 'dbo', ''),
(2016050080, 201605, 19, 80, '2016-07-20', 1611, 'ENERGY', 284, 263, '2016-05-30', '2016-04-30', '2016-07-27', 21, 2543.5200, 0.0000, 666.4400, 3209.9600, '2016-07-20 08:15:23', 'dbo', ''),
(2016050081, 201605, 19, 81, '2016-07-20', 1612, 'ENERGY', 362, 278, '2016-05-30', '2016-04-30', '2016-07-27', 84, 4333.1600, 0.0000, 1795.7800, 6128.9400, '2016-07-20 08:15:23', 'dbo', ''),
(2016050082, 201605, 19, 82, '2016-07-20', 1613, 'ENERGY', 384, 275, '2016-05-30', '2016-04-30', '2016-07-27', 109, 5541.9100, 0.0000, 2243.9200, 7785.8300, '2016-07-20 08:15:23', 'dbo', ''),
(2016060001, 201606, 20, 1, '2016-07-20', 1614, 'ENERGY', 14016, 14016, '2016-06-30', '2016-05-30', '2016-07-27', 0, 253736.4914, 0.0000, 290.0000, 254026.4914, '2016-07-20 08:22:50', 'dbo', ''),
(2016060002, 201606, 20, 2, '2016-07-20', 1615, 'ENERGY', 7081, 7081, '2016-06-30', '2016-05-30', '2016-07-27', 0, 127129.8910, 0.0000, 290.0000, 127419.8910, '2016-07-20 08:22:50', 'dbo', ''),
(2016060003, 201606, 20, 3, '2016-07-20', 1616, 'ENERGY', 8948, 8948, '2016-06-30', '2016-05-30', '2016-07-27', 0, 162721.4134, 0.0000, 290.0000, 163011.4134, '2016-07-20 08:22:50', 'dbo', ''),
(2016060004, 201606, 20, 4, '2016-07-20', 1617, 'ENERGY', 6711, 6711, '2016-06-30', '2016-05-30', '2016-07-27', 0, 121180.3622, 0.0000, 290.0000, 121470.3622, '2016-07-20 08:22:50', 'dbo', ''),
(2016060005, 201606, 20, 5, '2016-07-20', 1618, 'ENERGY', 5255, 5255, '2016-06-30', '2016-05-30', '2016-07-27', 0, 95467.9986, 0.0000, 290.0000, 95757.9986, '2016-07-20 08:22:50', 'dbo', ''),
(2016060006, 201606, 20, 6, '2016-07-20', 1619, 'ENERGY', 13833, 13833, '2016-06-30', '2016-05-30', '2016-07-27', 0, 250651.6668, 0.0000, 290.0000, 250941.6668, '2016-07-20 08:22:50', 'dbo', ''),
(2016060007, 201606, 20, 7, '2016-07-20', 1620, 'ENERGY', 9652, 9652, '2016-06-30', '2016-05-30', '2016-07-27', 0, 175326.9200, 0.0000, 290.0000, 175616.9200, '2016-07-20 08:22:50', 'dbo', ''),
(2016060008, 201606, 20, 8, '2016-07-20', 1621, 'ENERGY', 167, 167, '2016-06-30', '2016-05-30', '2016-07-27', 0, 3502.4376, 0.0000, 290.0000, 3792.4376, '2016-07-20 08:22:50', 'dbo', ''),
(2016060009, 201606, 20, 9, '2016-07-20', 1622, 'ENERGY', 64, 64, '2016-06-30', '2016-05-30', '2016-07-27', 0, 5471.7964, 0.0000, 290.0000, 5761.7964, '2016-07-20 08:22:50', 'dbo', '');
INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2016060010, 201606, 20, 10, '2016-07-20', 1623, 'ENERGY', 81, 81, '2016-06-30', '2016-05-30', '2016-07-27', 0, 5748.0880, 0.0000, 290.0000, 6038.0880, '2016-07-20 08:22:50', 'dbo', ''),
(2016060011, 201606, 20, 11, '2016-07-20', 1624, 'ENERGY', 199, 199, '2016-06-30', '2016-05-30', '2016-07-27', 0, 9455.6010, 0.0000, 290.0000, 9745.6010, '2016-07-20 08:22:50', 'dbo', ''),
(2016060012, 201606, 20, 12, '2016-07-20', 1625, 'ENERGY', 51, 51, '2016-06-30', '2016-05-30', '2016-07-27', 0, 5114.1600, 0.0000, 290.0000, 5404.1600, '2016-07-20 08:22:50', 'dbo', ''),
(2016060013, 201606, 20, 13, '2016-07-20', 1626, 'ENERGY', 81, 81, '2016-06-30', '2016-05-30', '2016-07-27', 0, 6485.6340, 0.0000, 290.0000, 6775.6340, '2016-07-20 08:22:50', 'dbo', ''),
(2016060014, 201606, 20, 14, '2016-07-20', 1627, 'ENERGY', 176, 176, '2016-06-30', '2016-05-30', '2016-07-27', 0, 8431.9654, 0.0000, 290.0000, 8721.9654, '2016-07-20 08:22:50', 'dbo', ''),
(2016060015, 201606, 20, 15, '2016-07-20', 1628, 'ENERGY', 162, 162, '2016-06-30', '2016-05-30', '2016-07-27', 0, 7419.0690, 0.0000, 290.0000, 7709.0690, '2016-07-20 08:22:50', 'dbo', ''),
(2016060016, 201606, 20, 16, '2016-07-20', 1629, 'ENERGY', 75, 75, '2016-06-30', '2016-05-30', '2016-07-27', 0, 5648.5520, 0.0000, 290.0000, 5938.5520, '2016-07-20 08:22:50', 'dbo', ''),
(2016060017, 201606, 20, 17, '2016-07-20', 1630, 'ENERGY', 204, 204, '2016-06-30', '2016-05-30', '2016-07-27', 0, 3664.4570, 0.0000, 290.0000, 3954.4570, '2016-07-20 08:22:50', 'dbo', ''),
(2016060018, 201606, 20, 18, '2016-07-20', 1631, 'ENERGY', 94, 66, '2016-06-30', '2016-05-30', '2016-07-27', 28, 2988.0500, 0.0000, 801.1500, 3789.2000, '2016-07-20 08:22:50', 'dbo', ''),
(2016060019, 201606, 20, 19, '2016-07-20', 1632, 'ENERGY', 75, 75, '2016-06-30', '2016-05-30', '2016-07-27', 0, 1944.3450, 0.0000, 290.0000, 2234.3450, '2016-07-20 08:22:50', 'dbo', ''),
(2016060020, 201606, 20, 20, '2016-07-20', 1633, 'ENERGY', 203, 203, '2016-06-30', '2016-05-30', '2016-07-27', 0, 4409.0730, 0.0000, 290.0000, 4699.0730, '2016-07-20 08:22:50', 'dbo', ''),
(2016060021, 201606, 20, 21, '2016-07-20', 1634, 'ENERGY', 31689, 30320, '2016-06-30', '2016-05-30', '2016-07-27', 1369, 769466.1346, 0.0000, 25281.5300, 794747.6646, '2016-07-20 08:22:50', 'dbo', ''),
(2016060022, 201606, 20, 22, '2016-07-20', 1635, 'ENERGY', 18457, 17882, '2016-06-30', '2016-05-30', '2016-07-27', 575, 458480.7116, 0.0000, 10786.8100, 469267.5216, '2016-07-20 08:22:50', 'dbo', ''),
(2016060023, 201606, 20, 23, '2016-07-20', 1636, 'ENERGY', 43300, 41393, '2016-06-30', '2016-05-30', '2016-07-27', 1907, 1091041.0370, 0.0000, 35102.8900, 1126143.9270, '2016-07-20 08:22:50', 'dbo', ''),
(2016060024, 201606, 20, 24, '2016-07-20', 1637, 'ENERGY', 35989, 35152, '2016-06-30', '2016-05-30', '2016-07-27', 837, 930915.2200, 0.0000, 15569.7000, 946484.9200, '2016-07-20 08:22:50', 'dbo', ''),
(2016060025, 201606, 20, 25, '2016-07-20', 1638, 'ENERGY', 97, 97, '2016-06-30', '2016-05-30', '2016-07-27', 0, 3371.1700, 0.0000, 290.0000, 3661.1700, '2016-07-20 08:22:50', 'dbo', ''),
(2016060026, 201606, 20, 26, '2016-07-20', 1639, 'ENERGY', 33963, 31368, '2016-06-30', '2016-05-30', '2016-07-27', 2595, 440883.0974, 0.0000, 47662.5500, 488545.6474, '2016-07-20 08:22:50', 'dbo', ''),
(2016060029, 201606, 20, 29, '2016-07-20', 1642, 'ENERGY', 53078, 51372, '2016-06-30', '2016-05-30', '2016-07-27', 1706, 666238.2588, 0.0000, 31433.5700, 697671.8288, '2016-07-20 08:22:50', 'dbo', ''),
(2016060030, 201606, 20, 30, '2016-07-20', 1643, 'ENERGY', 25329, 24358, '2016-06-30', '2016-05-30', '2016-07-27', 971, 204613.6612, 0.0000, 18015.9100, 222629.5712, '2016-07-20 08:22:50', 'dbo', ''),
(2016060031, 201606, 20, 31, '2016-07-20', 1644, 'ENERGY', 32000, 30218, '2016-06-30', '2016-05-30', '2016-07-27', 1782, 360267.3880, 0.0000, 32820.9700, 393088.3580, '2016-07-20 08:22:50', 'dbo', ''),
(2016060032, 201606, 20, 32, '2016-07-20', 1645, 'ENERGY', 52881, 49539, '2016-06-30', '2016-05-30', '2016-07-27', 3342, 598578.0090, 0.0000, 61299.2700, 659877.2790, '2016-07-20 08:22:50', 'dbo', ''),
(2016060033, 201606, 20, 33, '2016-07-20', 1646, 'ENERGY', 6740, 6251, '2016-06-30', '2016-05-30', '2016-07-27', 489, 86738.2634, 0.0000, 9216.8500, 95955.1134, '2016-07-20 08:22:50', 'dbo', ''),
(2016060034, 201606, 20, 34, '2016-07-20', 1647, 'ENERGY', 4352, 4093, '2016-06-30', '2016-05-30', '2016-07-27', 259, 59831.6942, 0.0000, 5018.1200, 64849.8142, '2016-07-20 08:22:50', 'dbo', ''),
(2016060035, 201606, 20, 35, '2016-07-20', 1648, 'ENERGY', 9424, 8771, '2016-06-30', '2016-05-30', '2016-07-27', 653, 116301.1126, 0.0000, 12210.7200, 128511.8326, '2016-07-20 08:22:50', 'dbo', ''),
(2016060036, 201606, 20, 36, '2016-07-20', 1649, 'ENERGY', 20442, 19048, '2016-06-30', '2016-05-30', '2016-07-27', 1394, 274735.6238, 0.0000, 25737.9200, 300473.5438, '2016-07-20 08:22:50', 'dbo', ''),
(2016060037, 201606, 20, 37, '2016-07-20', 1650, 'ENERGY', 12382, 11789, '2016-06-30', '2016-05-30', '2016-07-27', 593, 152910.5110, 0.0000, 11115.4000, 164025.9110, '2016-07-20 08:22:50', 'dbo', ''),
(2016060038, 201606, 20, 38, '2016-07-20', 1651, 'ENERGY', 6107, 5801, '2016-06-30', '2016-05-30', '2016-07-27', 306, 82938.5434, 0.0000, 5876.1300, 88814.6734, '2016-07-20 08:22:50', 'dbo', ''),
(2016060039, 201606, 20, 39, '2016-07-20', 1652, 'ENERGY', 15234, 14783, '2016-06-30', '2016-05-30', '2016-07-27', 451, -399466.9618, 0.0000, 8523.1400, -390943.8218, '2016-07-20 08:22:50', 'dbo', ''),
(2016060040, 201606, 20, 40, '2016-07-20', 1653, 'ENERGY', 10862, 10732, '2016-06-30', '2016-05-30', '2016-07-27', 130, 149970.5296, 0.0000, 2663.1900, 152633.7196, '2016-07-20 08:22:51', 'dbo', ''),
(2016060041, 201606, 20, 41, '2016-07-20', 1654, 'ENERGY', 241, 241, '2016-06-30', '2016-05-30', '2016-07-27', 0, 9838.8400, 0.0000, 290.0000, 10128.8400, '2016-07-20 08:22:50', 'dbo', ''),
(2016060042, 201606, 20, 42, '2016-07-20', 1655, 'ENERGY', 183, 183, '2016-06-30', '2016-05-30', '2016-07-27', 0, 7754.5460, 0.0000, 290.0000, 8044.5460, '2016-07-20 08:22:50', 'dbo', ''),
(2016060043, 201606, 20, 43, '2016-07-20', 1656, 'ENERGY', 36830, 35251, '2016-06-30', '2016-05-30', '2016-07-27', 1579, 342556.1802, 0.0000, 29115.1400, 371671.3202, '2016-07-20 08:22:50', 'dbo', ''),
(2016060044, 201606, 20, 44, '2016-07-20', 1657, 'ENERGY', 13281, 11813, '2016-06-30', '2016-05-30', '2016-07-27', 1468, 212211.4830, 0.0000, 27088.8100, 239300.2930, '2016-07-20 08:22:50', 'dbo', ''),
(2016060045, 201606, 20, 45, '2016-07-20', 1658, 'ENERGY', 22143, 21368, '2016-06-30', '2016-05-30', '2016-07-27', 775, 248307.4520, 0.0000, 14437.8800, 262745.3320, '2016-07-20 08:22:50', 'dbo', ''),
(2016060046, 201606, 20, 46, '2016-07-20', 1659, 'ENERGY', 28348, 27038, '2016-06-30', '2016-05-30', '2016-07-27', 1310, 435460.1854, 0.0000, 24204.4600, 459664.6454, '2016-07-20 08:22:50', 'dbo', ''),
(2016060047, 201606, 20, 47, '2016-07-20', 1660, 'ENERGY', 15505, 14938, '2016-06-30', '2016-05-30', '2016-07-27', 567, 125911.7210, 0.0000, 10640.7700, 136552.4910, '2016-07-20 08:22:50', 'dbo', ''),
(2016060048, 201606, 20, 48, '2016-07-20', 1661, 'ENERGY', 91, 91, '2016-06-30', '2016-05-30', '2016-07-27', 0, 2647.8300, 0.0000, 290.0000, 2937.8300, '2016-07-20 08:22:50', 'dbo', ''),
(2016060049, 201606, 20, 49, '2016-07-20', 1662, 'ENERGY', 2990, 2860, '2016-06-30', '2016-05-30', '2016-07-27', 130, 36974.6690, 0.0000, 2663.1900, 39637.8590, '2016-07-20 08:22:50', 'dbo', ''),
(2016060050, 201606, 20, 50, '2016-07-20', 1663, 'ENERGY', 45743, 43512, '2016-06-30', '2016-05-30', '2016-07-27', 2231, 511940.6692, 0.0000, 41017.6100, 552958.2792, '2016-07-20 08:22:50', 'dbo', ''),
(2016060051, 201606, 20, 51, '2016-07-20', 1664, 'ENERGY', 211, 211, '2016-06-30', '2016-05-30', '2016-07-27', 0, 2899.9990, 0.0000, 290.0000, 3189.9990, '2016-07-20 08:22:50', 'dbo', ''),
(2016060052, 201606, 20, 52, '2016-07-20', 1665, 'ENERGY', 271, 257, '2016-06-30', '2016-05-30', '2016-07-27', 14, 5904.9620, 0.0000, 545.5800, 6450.5420, '2016-07-20 08:22:50', 'dbo', ''),
(2016060053, 201606, 20, 53, '2016-07-20', 1666, 'ENERGY', 962, 815, '2016-06-30', '2016-05-30', '2016-07-27', 147, 19965.6370, 0.0000, 2973.5300, 22939.1670, '2016-07-20 08:22:51', 'dbo', ''),
(2016060054, 201606, 20, 54, '2016-07-20', 1667, 'ENERGY', 15554, 14892, '2016-06-30', '2016-05-30', '2016-07-27', 662, 331881.6394, 0.0000, 12375.0200, 344256.6594, '2016-07-20 08:22:51', 'dbo', ''),
(2016060055, 201606, 20, 55, '2016-07-20', 1668, 'ENERGY', 6895, 6005, '2016-06-30', '2016-05-30', '2016-07-27', 890, 114131.0300, 0.0000, 16537.2300, 130668.2600, '2016-07-20 08:22:51', 'dbo', ''),
(2016060056, 201606, 20, 56, '2016-07-20', 1669, 'ENERGY', 81, 81, '2016-06-30', '2016-05-30', '2016-07-27', 0, 3311.8390, 0.0000, 290.0000, 3601.8390, '2016-07-20 08:22:51', 'dbo', ''),
(2016060059, 201606, 20, 59, '2016-07-20', 1672, 'ENERGY', 128, 128, '2016-06-30', '2016-05-30', '2016-07-27', 0, 5188.1400, 0.0000, 290.0000, 5478.1400, '2016-07-20 08:22:50', 'dbo', ''),
(2016060060, 201606, 20, 60, '2016-07-20', 1673, 'ENERGY', 92983, 86274, '2016-06-30', '2016-05-30', '2016-07-27', 6709, 1510725.0400, 0.0000, 122764.9300, 1633489.9700, '2016-07-20 08:22:50', 'dbo', ''),
(2016060061, 201606, 20, 61, '2016-07-20', 1674, 'ENERGY', 3, 3, '2016-06-30', '2016-05-30', '2016-07-27', 0, 2900.0000, 0.0000, 290.0000, 3190.0000, '2016-07-20 08:22:50', 'dbo', ''),
(2016060062, 201606, 20, 62, '2016-07-20', 1675, 'ENERGY', 30, 30, '2016-06-30', '2016-05-30', '2016-07-27', 0, 2900.0000, 0.0000, 290.0000, 3190.0000, '2016-07-20 08:22:50', 'dbo', ''),
(2016060063, 201606, 20, 63, '2016-07-20', 1676, 'ENERGY', 1, 1, '2016-06-30', '2016-05-30', '2016-07-27', 0, 2900.0000, 0.0000, 290.0000, 3190.0000, '2016-07-20 08:22:50', 'dbo', ''),
(2016060064, 201606, 20, 64, '2016-07-20', 1677, 'ENERGY', 2, 2, '2016-06-30', '2016-05-30', '2016-07-27', 0, 2900.0000, 0.0000, 290.0000, 3190.0000, '2016-07-20 08:22:50', 'dbo', ''),
(2016060065, 201606, 20, 65, '2016-07-20', 1678, 'ENERGY', 1631, 1286, '2016-06-30', '2016-05-30', '2016-07-27', 345, 25529.8980, 0.0000, 6588.0800, 32117.9780, '2016-07-20 08:22:50', 'dbo', ''),
(2016060066, 201606, 20, 66, '2016-07-20', 1679, 'ENERGY', 1818, 1527, '2016-06-30', '2016-05-30', '2016-07-27', 291, 27989.2024, 0.0000, 5602.3000, 33591.5024, '2016-07-20 08:22:50', 'dbo', ''),
(2016060067, 201606, 20, 67, '2016-07-20', 1680, 'ENERGY', 214, 161, '2016-06-30', '2016-05-30', '2016-07-27', 53, 4515.7438, 0.0000, 1257.5400, 5773.2838, '2016-07-20 08:22:51', 'dbo', ''),
(2016060068, 201606, 20, 68, '2016-07-20', 1681, 'ENERGY', 419, 305, '2016-06-30', '2016-05-30', '2016-07-27', 114, 8118.2700, 0.0000, 2371.1100, 10489.3800, '2016-07-20 08:22:51', 'dbo', ''),
(2016060069, 201606, 20, 69, '2016-07-20', 1682, 'ENERGY', 1, 1, '2016-06-30', '2016-05-30', '2016-07-27', 0, 4640.0000, 0.0000, 290.0000, 4930.0000, '2016-07-20 08:22:50', 'dbo', ''),
(2016060070, 201606, 20, 70, '2016-07-20', 1683, 'ENERGY', 333, 314, '2016-06-30', '2016-05-30', '2016-07-27', 19, 10602.0700, 0.0000, 636.8500, 11238.9200, '2016-07-20 08:22:50', 'dbo', ''),
(2016060071, 201606, 20, 71, '2016-07-20', 1684, 'ENERGY', 29490, 21432, '2016-06-30', '2016-05-30', '2016-07-27', 8058, 392015.3762, 0.0000, 147391.3500, 539406.7262, '2016-07-20 08:22:50', 'dbo', ''),
(2016060072, 201606, 20, 72, '2016-07-20', 1685, 'ENERGY', 492, 337, '2016-06-30', '2016-05-30', '2016-07-27', 155, 10175.1200, 0.0000, 3119.5700, 13294.6900, '2016-07-20 08:22:50', 'dbo', ''),
(2016060073, 201606, 20, 73, '2016-07-20', 1686, 'ENERGY', 367, 358, '2016-06-30', '2016-05-30', '2016-07-27', 9, 17270.1480, 0.0000, 454.3000, 17724.4480, '2016-07-20 08:22:50', 'dbo', ''),
(2016060075, 201606, 20, 75, '2016-07-20', 1687, 'ENERGY', 688, 648, '2016-06-30', '2016-05-30', '2016-07-27', 40, 14674.3700, 0.0000, 1020.2100, 15694.5800, '2016-07-20 08:22:50', 'dbo', ''),
(2016060076, 201606, 20, 76, '2016-07-20', 1688, 'ENERGY', 788, 749, '2016-06-30', '2016-05-30', '2016-07-27', 39, 16486.0900, 0.0000, 1001.9600, 17488.0500, '2016-07-20 08:22:50', 'dbo', ''),
(2016060077, 201606, 20, 77, '2016-07-20', 1689, 'ENERGY', 678, 649, '2016-06-30', '2016-05-30', '2016-07-27', 29, 14587.5600, 0.0000, 819.4000, 15406.9600, '2016-07-20 08:22:50', 'dbo', ''),
(2016060078, 201606, 20, 78, '2016-07-20', 1690, 'ENERGY', 139, 128, '2016-06-30', '2016-05-30', '2016-07-27', 11, 5191.2100, 0.0000, 490.8100, 5682.0200, '2016-07-20 08:22:50', 'dbo', ''),
(2016060079, 201606, 20, 79, '2016-07-20', 1691, 'ENERGY', 13897, 12295, '2016-06-30', '2016-05-30', '2016-07-27', 1602, 119624.0300, 0.0000, 29535.0100, 149159.0400, '2016-07-20 08:22:50', 'dbo', ''),
(2016060080, 201606, 20, 80, '2016-07-20', 1692, 'ENERGY', 308, 284, '2016-06-30', '2016-05-30', '2016-07-27', 24, 3209.9600, 0.0000, 728.1200, 3938.0800, '2016-07-20 08:22:50', 'dbo', ''),
(2016060081, 201606, 20, 81, '2016-07-20', 1693, 'ENERGY', 430, 362, '2016-06-30', '2016-05-30', '2016-07-27', 68, 6128.9400, 0.0000, 1531.3600, 7660.3000, '2016-07-20 08:22:50', 'dbo', ''),
(2016060082, 201606, 20, 82, '2016-07-20', 1694, 'ENERGY', 503, 384, '2016-06-30', '2016-05-30', '2016-07-27', 119, 7785.8300, 0.0000, 2462.3900, 10248.2200, '2016-07-20 08:22:50', 'dbo', ''),
(2016070001, 201607, 21, 1, '2016-08-12', 1695, 'ENERGY', 14016, 14016, '2016-07-30', '2016-06-30', '2016-08-19', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2016-08-13 07:12:32', 'dbo', ''),
(2016070002, 201607, 21, 2, '2016-08-12', 1696, 'ENERGY', 7081, 7081, '2016-07-30', '2016-06-30', '2016-08-19', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2016-08-13 07:12:32', 'dbo', ''),
(2016070003, 201607, 21, 3, '2016-08-12', 1697, 'ENERGY', 8948, 8948, '2016-07-30', '2016-06-30', '2016-08-19', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2016-08-13 07:12:32', 'dbo', ''),
(2016070004, 201607, 21, 4, '2016-08-12', 1698, 'ENERGY', 6711, 6711, '2016-07-30', '2016-06-30', '2016-08-19', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2016-08-13 07:12:32', 'dbo', ''),
(2016070005, 201607, 21, 5, '2016-08-12', 1699, 'ENERGY', 5255, 5255, '2016-07-30', '2016-06-30', '2016-08-19', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2016-08-13 07:12:32', 'dbo', ''),
(2016070006, 201607, 21, 6, '2016-08-12', 1700, 'ENERGY', 13833, 13833, '2016-07-30', '2016-06-30', '2016-08-19', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2016-08-13 07:12:32', 'dbo', ''),
(2016070007, 201607, 21, 7, '2016-08-12', 1701, 'ENERGY', 9652, 9652, '2016-07-30', '2016-06-30', '2016-08-19', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2016-08-13 07:12:32', 'dbo', ''),
(2016070008, 201607, 21, 8, '2016-08-12', 1702, 'ENERGY', 167, 167, '2016-07-30', '2016-06-30', '2016-08-19', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2016-08-13 07:12:32', 'dbo', ''),
(2016070009, 201607, 21, 9, '2016-08-12', 1703, 'ENERGY', 65, 64, '2016-07-30', '2016-06-30', '2016-08-19', 1, 5761.7964, 0.0000, 307.9700, 6069.7664, '2016-08-13 07:12:32', 'dbo', ''),
(2016070010, 201607, 21, 10, '2016-08-12', 1704, 'ENERGY', 87, 81, '2016-07-30', '2016-06-30', '2016-08-19', 6, 6038.0880, 0.0000, 397.7900, 6435.8780, '2016-08-13 07:12:32', 'dbo', ''),
(2016070011, 201607, 21, 11, '2016-08-12', 1705, 'ENERGY', 201, 199, '2016-07-30', '2016-06-30', '2016-08-19', 2, 9745.6010, 0.0000, 325.9300, 10071.5310, '2016-08-13 07:12:32', 'dbo', ''),
(2016070012, 201607, 21, 12, '2016-08-12', 1706, 'ENERGY', 51, 51, '2016-07-30', '2016-06-30', '2016-08-19', 0, 5404.1600, 0.0000, 0.0000, 5404.1600, '2016-08-13 07:12:32', 'dbo', ''),
(2016070013, 201607, 21, 13, '2016-08-12', 1707, 'ENERGY', 84, 81, '2016-07-30', '2016-06-30', '2016-08-19', 3, 6775.6340, 0.0000, 343.9000, 7119.5340, '2016-08-13 07:12:32', 'dbo', ''),
(2016070014, 201607, 21, 14, '2016-08-12', 1708, 'ENERGY', 176, 176, '2016-07-30', '2016-06-30', '2016-08-19', 0, 8721.9654, 0.0000, 0.0000, 8721.9654, '2016-08-13 07:12:32', 'dbo', ''),
(2016070015, 201607, 21, 15, '2016-08-12', 1709, 'ENERGY', 162, 162, '2016-07-30', '2016-06-30', '2016-08-19', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2016-08-13 07:12:32', 'dbo', ''),
(2016070016, 201607, 21, 16, '2016-08-12', 1710, 'ENERGY', 77, 75, '2016-07-30', '2016-06-30', '2016-08-19', 2, 5938.5520, 0.0000, 325.9300, 6264.4820, '2016-08-13 07:12:32', 'dbo', ''),
(2016070017, 201607, 21, 17, '2016-08-12', 1711, 'ENERGY', 206, 204, '2016-07-30', '2016-06-30', '2016-08-19', 2, 3954.4570, 0.0000, 325.9300, 4280.3870, '2016-08-13 07:12:32', 'dbo', ''),
(2016070018, 201607, 21, 18, '2016-08-12', 1712, 'ENERGY', 99, 94, '2016-07-30', '2016-06-30', '2016-08-19', 5, 3789.2000, 0.0000, 379.8400, 4169.0400, '2016-08-13 07:12:32', 'dbo', ''),
(2016070019, 201607, 21, 19, '2016-08-12', 1713, 'ENERGY', 75, 75, '2016-07-30', '2016-06-30', '2016-08-19', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2016-08-13 07:12:32', 'dbo', ''),
(2016070020, 201607, 21, 20, '2016-08-12', 1714, 'ENERGY', 203, 203, '2016-07-30', '2016-06-30', '2016-08-19', 0, 4699.0730, 0.0000, 0.0000, 4699.0730, '2016-08-13 07:12:32', 'dbo', ''),
(2016070021, 201607, 21, 21, '2016-08-12', 1715, 'ENERGY', 33095, 31689, '2016-07-30', '2016-06-30', '2016-08-19', 1406, 794747.6646, 436605.0000, 25549.4600, 383692.1246, '2016-08-13 07:12:32', 'dbo', ''),
(2016070022, 201607, 21, 22, '2016-08-12', 1716, 'ENERGY', 19083, 18457, '2016-07-30', '2016-06-30', '2016-08-19', 626, 469267.5216, 265759.0000, 11536.3900, 215044.9116, '2016-08-13 07:12:32', 'dbo', ''),
(2016070023, 201607, 21, 23, '2016-08-12', 1717, 'ENERGY', 44699, 43300, '2016-07-30', '2016-06-30', '2016-08-19', 1399, 1126143.9270, 645416.0000, 25423.7100, 506151.6370, '2016-08-13 07:12:32', 'dbo', ''),
(2016070024, 201607, 21, 24, '2016-08-12', 1718, 'ENERGY', 36654, 35989, '2016-07-30', '2016-06-30', '2016-08-19', 665, 946484.9200, 550501.0000, 12237.0500, 408220.9700, '2016-08-13 07:12:32', 'dbo', ''),
(2016070025, 201607, 21, 25, '2016-08-12', 1719, 'ENERGY', 113, 97, '2016-07-30', '2016-06-30', '2016-08-19', 16, 3661.1700, 0.0000, 577.4500, 4238.6200, '2016-08-13 07:12:32', 'dbo', ''),
(2016070026, 201607, 21, 26, '2016-08-12', 1720, 'ENERGY', 36355, 33963, '2016-07-30', '2016-06-30', '2016-08-19', 2392, 488545.6474, 0.0000, 43263.4200, 531809.0674, '2016-08-13 07:12:32', 'dbo', ''),
(2016070029, 201607, 21, 29, '2016-08-12', 1723, 'ENERGY', 54822, 53078, '2016-07-30', '2016-06-30', '2016-08-19', 1744, 697671.8288, 0.0000, 31621.7900, 729293.6188, '2016-08-13 07:12:32', 'dbo', ''),
(2016070030, 201607, 21, 30, '2016-08-12', 1724, 'ENERGY', 26268, 25329, '2016-07-30', '2016-06-30', '2016-08-19', 939, 222629.5712, 0.0000, 17159.5900, 239789.1612, '2016-08-13 07:12:32', 'dbo', ''),
(2016070031, 201607, 21, 31, '2016-08-12', 1725, 'ENERGY', 33727, 32000, '2016-07-30', '2016-06-30', '2016-08-19', 1727, 393088.3580, 0.0000, 31316.3800, 424404.7380, '2016-08-13 07:12:32', 'dbo', ''),
(2016070032, 201607, 21, 32, '2016-08-12', 1726, 'ENERGY', 56007, 52881, '2016-07-30', '2016-06-30', '2016-08-19', 3126, 659877.2790, 0.0000, 56450.0800, 716327.3590, '2016-08-13 07:12:32', 'dbo', ''),
(2016070033, 201607, 21, 33, '2016-08-12', 1727, 'ENERGY', 7132, 6740, '2016-07-30', '2016-06-30', '2016-08-19', 392, 95955.1134, 0.0000, 7332.4700, 103287.5834, '2016-08-13 07:12:32', 'dbo', ''),
(2016070034, 201607, 21, 34, '2016-08-12', 1728, 'ENERGY', 4591, 4352, '2016-07-30', '2016-06-30', '2016-08-19', 239, 64849.8142, 0.0000, 4583.7500, 69433.5642, '2016-08-13 07:12:32', 'dbo', ''),
(2016070035, 201607, 21, 35, '2016-08-12', 1729, 'ENERGY', 10149, 9424, '2016-07-30', '2016-06-30', '2016-08-19', 725, 128511.8326, 0.0000, 13314.9800, 141826.8126, '2016-08-13 07:12:32', 'dbo', ''),
(2016070036, 201607, 21, 36, '2016-08-12', 1730, 'ENERGY', 21837, 20442, '2016-07-30', '2016-06-30', '2016-08-19', 1395, 300473.5438, 0.0000, 25351.8400, 325825.3838, '2016-08-13 07:12:32', 'dbo', ''),
(2016070037, 201607, 21, 37, '2016-08-12', 1731, 'ENERGY', 12918, 12382, '2016-07-30', '2016-06-30', '2016-08-19', 536, 164025.9110, 0.0000, 9919.4900, 173945.4010, '2016-08-13 07:12:32', 'dbo', ''),
(2016070038, 201607, 21, 38, '2016-08-12', 1732, 'ENERGY', 6407, 6107, '2016-07-30', '2016-06-30', '2016-08-19', 300, 88814.6734, 0.0000, 5679.6400, 94494.3134, '2016-08-13 07:12:32', 'dbo', ''),
(2016070039, 201607, 21, 39, '2016-08-12', 1733, 'ENERGY', 15620, 15234, '2016-07-30', '2016-06-30', '2016-08-19', 386, -390943.8218, 0.0000, 7224.6800, -383719.1418, '2016-08-13 07:12:32', 'dbo', ''),
(2016070040, 201607, 21, 40, '2016-08-12', 1734, 'ENERGY', 11510, 10862, '2016-07-30', '2016-06-30', '2016-08-19', 648, 152633.7196, 0.0000, 11931.6300, 164565.3496, '2016-08-13 07:12:32', 'dbo', ''),
(2016070041, 201607, 21, 41, '2016-08-12', 1735, 'ENERGY', 241, 241, '2016-07-30', '2016-06-30', '2016-08-19', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2016-08-13 07:12:32', 'dbo', ''),
(2016070042, 201607, 21, 42, '2016-08-12', 1736, 'ENERGY', 183, 183, '2016-07-30', '2016-06-30', '2016-08-19', 0, 8044.5460, 0.0000, 0.0000, 8044.5460, '2016-08-13 07:12:32', 'dbo', ''),
(2016070043, 201607, 21, 43, '2016-08-12', 1737, 'ENERGY', 38208, 36830, '2016-07-30', '2016-06-30', '2016-08-19', 1378, 371671.3202, 0.0000, 25046.4400, 396717.7602, '2016-08-13 07:12:32', 'dbo', ''),
(2016070044, 201607, 21, 44, '2016-08-12', 1738, 'ENERGY', 14611, 13281, '2016-07-30', '2016-06-30', '2016-08-19', 1330, 239300.2930, 0.0000, 24184.0900, 263484.3830, '2016-08-13 07:12:32', 'dbo', ''),
(2016070045, 201607, 21, 45, '2016-08-12', 1739, 'ENERGY', 22908, 22143, '2016-07-30', '2016-06-30', '2016-08-19', 765, 262745.3320, 131857.0000, 14033.6000, 144921.9320, '2016-08-13 07:12:32', 'dbo', ''),
(2016070046, 201607, 21, 46, '2016-08-12', 1740, 'ENERGY', 29615, 28348, '2016-07-30', '2016-06-30', '2016-08-19', 1267, 459664.6454, 0.0000, 23052.2600, 482716.9054, '2016-08-13 07:12:32', 'dbo', ''),
(2016070047, 201607, 21, 47, '2016-08-12', 1741, 'ENERGY', 16076, 15505, '2016-07-30', '2016-06-30', '2016-08-19', 571, 136552.4910, 0.0000, 10548.3000, 147100.7910, '2016-08-13 07:12:32', 'dbo', ''),
(2016070048, 201607, 21, 48, '2016-08-12', 1742, 'ENERGY', 324, 91, '2016-07-30', '2016-06-30', '2016-08-19', 233, 2937.8300, 0.0000, 4475.9600, 7413.7900, '2016-08-13 07:12:32', 'dbo', ''),
(2016070049, 201607, 21, 49, '2016-08-12', 1743, 'ENERGY', 3123, 2990, '2016-07-30', '2016-06-30', '2016-08-19', 133, 39637.8590, 0.0000, 2679.4200, 42317.2790, '2016-08-13 07:12:32', 'dbo', ''),
(2016070050, 201607, 21, 50, '2016-08-12', 1744, 'ENERGY', 48043, 45743, '2016-07-30', '2016-06-30', '2016-08-19', 2300, 552958.2792, 0.0000, 41610.6000, 594568.8792, '2016-08-13 07:12:32', 'dbo', ''),
(2016070051, 201607, 21, 51, '2016-08-12', 1745, 'ENERGY', 211, 211, '2016-07-30', '2016-06-30', '2016-08-19', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2016-08-13 07:12:32', 'dbo', ''),
(2016070052, 201607, 21, 52, '2016-08-12', 1746, 'ENERGY', 284, 271, '2016-07-30', '2016-06-30', '2016-08-19', 13, 6450.5420, 0.0000, 523.5600, 6974.1020, '2016-08-13 07:12:32', 'dbo', ''),
(2016070053, 201607, 21, 53, '2016-08-12', 1747, 'ENERGY', 1081, 962, '2016-07-30', '2016-06-30', '2016-08-19', 119, 22939.1670, 0.0000, 2427.9000, 25367.0670, '2016-08-13 07:12:32', 'dbo', ''),
(2016070054, 201607, 21, 54, '2016-08-12', 1748, 'ENERGY', 16182, 15554, '2016-07-30', '2016-06-30', '2016-08-19', 628, 344256.6594, 308734.8000, 11572.3200, 47094.1794, '2016-08-13 07:12:32', 'dbo', ''),
(2016070055, 201607, 21, 55, '2016-08-12', 1749, 'ENERGY', 7723, 6895, '2016-07-30', '2016-06-30', '2016-08-19', 828, 130668.2600, 0.0000, 15165.4100, 145833.6700, '2016-08-13 07:12:32', 'dbo', ''),
(2016070056, 201607, 21, 56, '2016-08-12', 1750, 'ENERGY', 81, 81, '2016-07-30', '2016-06-30', '2016-08-19', 0, 3601.8390, 0.0000, 0.0000, 3601.8390, '2016-08-13 07:12:32', 'dbo', ''),
(2016070059, 201607, 21, 59, '2016-08-12', 1753, 'ENERGY', 128, 128, '2016-07-30', '2016-06-30', '2016-08-19', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2016-08-13 07:12:32', 'dbo', ''),
(2016070060, 201607, 21, 60, '2016-08-12', 1754, 'ENERGY', 99080, 92983, '2016-07-30', '2016-06-30', '2016-08-19', 6097, 1633489.9700, 1218435.0000, 109825.5300, 524880.5000, '2016-08-13 07:12:32', 'dbo', ''),
(2016070061, 201607, 21, 61, '2016-08-12', 1755, 'ENERGY', 3, 3, '2016-07-30', '2016-06-30', '2016-08-19', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2016-08-13 07:12:32', 'dbo', ''),
(2016070062, 201607, 21, 62, '2016-08-12', 1756, 'ENERGY', 30, 30, '2016-07-30', '2016-06-30', '2016-08-19', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2016-08-13 07:12:32', 'dbo', ''),
(2016070063, 201607, 21, 63, '2016-08-12', 1757, 'ENERGY', 1, 1, '2016-07-30', '2016-06-30', '2016-08-19', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2016-08-13 07:12:32', 'dbo', ''),
(2016070064, 201607, 21, 64, '2016-08-12', 1758, 'ENERGY', 2, 2, '2016-07-30', '2016-06-30', '2016-08-19', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2016-08-13 07:12:32', 'dbo', ''),
(2016070065, 201607, 21, 65, '2016-08-12', 1759, 'ENERGY', 2054, 1631, '2016-07-30', '2016-06-30', '2016-08-19', 423, 32117.9780, 0.0000, 7889.4100, 40007.3880, '2016-08-13 07:12:32', 'dbo', ''),
(2016070066, 201607, 21, 66, '2016-08-12', 1760, 'ENERGY', 2090, 1818, '2016-07-30', '2016-06-30', '2016-08-19', 272, 33591.5024, 0.0000, 5176.6100, 38768.1124, '2016-08-13 07:12:32', 'dbo', ''),
(2016070067, 201607, 21, 67, '2016-08-12', 1761, 'ENERGY', 255, 214, '2016-07-30', '2016-06-30', '2016-08-19', 41, 5773.2838, 0.0000, 1026.5800, 6799.8638, '2016-08-13 07:12:32', 'dbo', ''),
(2016070068, 201607, 21, 68, '2016-08-12', 1762, 'ENERGY', 480, 419, '2016-07-30', '2016-06-30', '2016-08-19', 61, 10489.3800, 0.0000, 1385.8900, 11875.2700, '2016-08-13 07:12:32', 'dbo', ''),
(2016070069, 201607, 21, 69, '2016-08-12', 1763, 'ENERGY', 1, 1, '2016-07-30', '2016-06-30', '2016-08-19', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2016-08-13 07:12:32', 'dbo', ''),
(2016070070, 201607, 21, 70, '2016-08-12', 1764, 'ENERGY', 345, 333, '2016-07-30', '2016-06-30', '2016-08-19', 12, 11238.9200, 0.0000, 505.5800, 11744.5000, '2016-08-13 07:12:32', 'dbo', ''),
(2016070071, 201607, 21, 71, '2016-08-12', 1765, 'ENERGY', 36324, 29490, '2016-07-30', '2016-06-30', '2016-08-19', 6834, 539406.7262, 91504.0000, 123066.0800, 570968.8062, '2016-08-13 07:12:32', 'dbo', ''),
(2016070072, 201607, 21, 72, '2016-08-12', 1766, 'ENERGY', 634, 492, '2016-07-30', '2016-06-30', '2016-08-19', 142, 13294.6900, 0.0000, 2841.1000, 16135.7900, '2016-08-13 07:12:32', 'dbo', ''),
(2016070073, 201607, 21, 73, '2016-08-12', 1767, 'ENERGY', 369, 367, '2016-07-30', '2016-06-30', '2016-08-19', 2, 17724.4480, 0.0000, 325.9300, 18050.3780, '2016-08-13 07:12:32', 'dbo', ''),
(2016070075, 201607, 21, 75, '2016-08-12', 1768, 'ENERGY', 726, 688, '2016-07-30', '2016-06-30', '2016-08-19', 38, 15694.5800, 0.0000, 972.6800, 16667.2600, '2016-08-13 07:12:32', 'dbo', ''),
(2016070076, 201607, 21, 76, '2016-08-12', 1769, 'ENERGY', 825, 788, '2016-07-30', '2016-06-30', '2016-08-19', 37, 17488.0500, 0.0000, 954.7300, 18442.7800, '2016-08-13 07:12:32', 'dbo', ''),
(2016070077, 201607, 21, 77, '2016-08-12', 1770, 'ENERGY', 706, 678, '2016-07-30', '2016-06-30', '2016-08-19', 28, 15406.9600, 0.0000, 793.0400, 16200.0000, '2016-08-13 07:12:32', 'dbo', ''),
(2016070078, 201607, 21, 78, '2016-08-12', 1771, 'ENERGY', 149, 139, '2016-07-30', '2016-06-30', '2016-08-19', 10, 5682.0200, 0.0000, 469.6600, 6151.6800, '2016-08-13 07:12:32', 'dbo', ''),
(2016070079, 201607, 21, 79, '2016-08-12', 1772, 'ENERGY', 15469, 13897, '2016-07-30', '2016-06-30', '2016-08-19', 1572, 149159.0400, 0.0000, 28531.7400, 177690.7800, '2016-08-13 07:12:32', 'dbo', ''),
(2016070080, 201607, 21, 80, '2016-08-12', 1773, 'ENERGY', 311, 308, '2016-07-30', '2016-06-30', '2016-08-19', 3, 3938.0800, 0.0000, 343.9000, 4281.9800, '2016-08-13 07:12:32', 'dbo', ''),
(2016070081, 201607, 21, 81, '2016-08-12', 1774, 'ENERGY', 496, 430, '2016-07-30', '2016-06-30', '2016-08-19', 66, 7660.3000, 0.0000, 1475.7200, 9136.0200, '2016-08-13 07:12:32', 'dbo', ''),
(2016070082, 201607, 21, 82, '2016-08-12', 1775, 'ENERGY', 619, 503, '2016-07-30', '2016-06-30', '2016-08-19', 116, 10248.2200, 0.0000, 2374.0000, 12622.2200, '2016-08-13 07:12:32', 'dbo', ''),
(2016080001, 201608, 22, 1, '2016-09-15', 1776, 'ENERGY', 14016, 14016, '2016-08-31', '2016-07-30', '2016-09-22', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2016-09-15 14:30:59', 'dbo', ''),
(2016080002, 201608, 22, 2, '2016-09-15', 1777, 'ENERGY', 7081, 7081, '2016-08-31', '2016-07-30', '2016-09-22', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2016-09-15 14:30:59', 'dbo', ''),
(2016080003, 201608, 22, 3, '2016-09-15', 1778, 'ENERGY', 8948, 8948, '2016-08-31', '2016-07-30', '2016-09-22', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2016-09-15 14:30:59', 'dbo', ''),
(2016080004, 201608, 22, 4, '2016-09-15', 1779, 'ENERGY', 6711, 6711, '2016-08-31', '2016-07-30', '2016-09-22', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2016-09-15 14:30:59', 'dbo', ''),
(2016080005, 201608, 22, 5, '2016-09-15', 1780, 'ENERGY', 5255, 5255, '2016-08-31', '2016-07-30', '2016-09-22', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2016-09-15 14:30:59', 'dbo', ''),
(2016080006, 201608, 22, 6, '2016-09-15', 1781, 'ENERGY', 13833, 13833, '2016-08-31', '2016-07-30', '2016-09-22', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2016-09-15 14:30:59', 'dbo', ''),
(2016080007, 201608, 22, 7, '2016-09-15', 1782, 'ENERGY', 9652, 9652, '2016-08-31', '2016-07-30', '2016-09-22', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2016-09-15 14:30:59', 'dbo', ''),
(2016080008, 201608, 22, 8, '2016-09-15', 1783, 'ENERGY', 167, 167, '2016-08-31', '2016-07-30', '2016-09-22', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2016-09-15 14:30:59', 'dbo', ''),
(2016080009, 201608, 22, 9, '2016-09-15', 1784, 'ENERGY', 67, 65, '2016-08-31', '2016-07-30', '2016-09-22', 2, 6069.7664, 0.0000, 326.2500, 6396.0164, '2016-09-15 14:30:59', 'dbo', ''),
(2016080010, 201608, 22, 10, '2016-09-15', 1785, 'ENERGY', 87, 87, '2016-08-31', '2016-07-30', '2016-09-22', 0, 6435.8780, 0.0000, 0.0000, 6435.8780, '2016-09-15 14:30:59', 'dbo', ''),
(2016080011, 201608, 22, 11, '2016-09-15', 1786, 'ENERGY', 201, 201, '2016-08-31', '2016-07-30', '2016-09-22', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2016-09-15 14:30:59', 'dbo', ''),
(2016080012, 201608, 22, 12, '2016-09-15', 1787, 'ENERGY', 118, 51, '2016-08-31', '2016-07-30', '2016-09-22', 67, 5404.1600, 0.0000, 1504.0900, 6908.2500, '2016-09-15 14:30:59', 'dbo', ''),
(2016080013, 201608, 22, 13, '2016-09-15', 1788, 'ENERGY', 316, 84, '2016-08-31', '2016-07-30', '2016-09-22', 232, 7119.5340, 0.0000, 4494.0400, 11613.5740, '2016-09-15 14:30:59', 'dbo', ''),
(2016080014, 201608, 22, 14, '2016-09-15', 1789, 'ENERGY', 176, 176, '2016-08-31', '2016-07-30', '2016-09-22', 0, 8721.9654, 0.0000, 0.0000, 8721.9654, '2016-09-15 14:30:59', 'dbo', ''),
(2016080015, 201608, 22, 15, '2016-09-15', 1790, 'ENERGY', 162, 162, '2016-08-31', '2016-07-30', '2016-09-22', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2016-09-15 14:30:59', 'dbo', ''),
(2016080016, 201608, 22, 16, '2016-09-15', 1791, 'ENERGY', 78, 77, '2016-08-31', '2016-07-30', '2016-09-22', 1, 6264.4820, 0.0000, 308.1200, 6572.6020, '2016-09-15 14:30:59', 'dbo', ''),
(2016080017, 201608, 22, 17, '2016-09-15', 1792, 'ENERGY', 206, 206, '2016-08-31', '2016-07-30', '2016-09-22', 0, 4280.3870, 0.0000, 0.0000, 4280.3870, '2016-09-15 14:30:59', 'dbo', ''),
(2016080018, 201608, 22, 18, '2016-09-15', 1793, 'ENERGY', 99, 99, '2016-08-31', '2016-07-30', '2016-09-22', 0, 4169.0400, 0.0000, 0.0000, 4169.0400, '2016-09-15 14:30:59', 'dbo', ''),
(2016080019, 201608, 22, 19, '2016-09-15', 1794, 'ENERGY', 75, 75, '2016-08-31', '2016-07-30', '2016-09-22', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2016-09-15 14:30:59', 'dbo', ''),
(2016080020, 201608, 22, 20, '2016-09-15', 1795, 'ENERGY', 203, 203, '2016-08-31', '2016-07-30', '2016-09-22', 0, 4699.0730, 0.0000, 0.0000, 4699.0730, '2016-09-15 14:30:59', 'dbo', ''),
(2016080021, 201608, 22, 21, '2016-09-15', 1796, 'ENERGY', 34593, 33095, '2016-08-31', '2016-07-30', '2016-09-22', 1498, 383692.1246, 0.0000, 27435.0300, 411127.1546, '2016-09-15 14:30:59', 'dbo', ''),
(2016080022, 201608, 22, 22, '2016-09-15', 1797, 'ENERGY', 19806, 19083, '2016-08-31', '2016-07-30', '2016-09-22', 723, 215044.9116, 0.0000, 13391.3800, 228436.2916, '2016-09-15 14:30:59', 'dbo', ''),
(2016080023, 201608, 22, 23, '2016-09-15', 1798, 'ENERGY', 46487, 44699, '2016-08-31', '2016-07-30', '2016-09-22', 1788, 506151.6370, 0.0000, 32690.0700, 538841.7070, '2016-09-15 14:30:59', 'dbo', ''),
(2016080024, 201608, 22, 24, '2016-09-15', 1799, 'ENERGY', 37658, 36654, '2016-08-31', '2016-07-30', '2016-09-22', 1004, 408220.9700, 0.0000, 18483.3300, 426704.3000, '2016-09-15 14:30:59', 'dbo', ''),
(2016080025, 201608, 22, 25, '2016-09-15', 1800, 'ENERGY', 433, 113, '2016-08-31', '2016-07-30', '2016-09-22', 320, 4238.6200, 0.0000, 6088.6700, 10327.2900, '2016-09-15 14:30:59', 'dbo', ''),
(2016080026, 201608, 22, 26, '2016-09-15', 1801, 'ENERGY', 39127, 36355, '2016-08-31', '2016-07-30', '2016-09-22', 2772, 531809.0674, 0.0000, 50520.9900, 582330.0574, '2016-09-15 14:30:59', 'dbo', ''),
(2016080029, 201608, 22, 29, '2016-09-15', 1804, 'ENERGY', 56916, 54822, '2016-08-31', '2016-07-30', '2016-09-22', 2094, 729293.6188, 0.0000, 38235.0500, 767528.6688, '2016-09-15 14:30:59', 'dbo', ''),
(2016080030, 201608, 22, 30, '2016-09-15', 1805, 'ENERGY', 27356, 26268, '2016-08-31', '2016-07-30', '2016-09-22', 1088, 239789.1612, 0.0000, 20005.4800, 259794.6412, '2016-09-15 14:30:59', 'dbo', ''),
(2016080031, 201608, 22, 31, '2016-09-15', 1806, 'ENERGY', 35762, 33727, '2016-08-31', '2016-07-30', '2016-09-22', 2035, 424404.7380, 0.0000, 37165.9200, 461570.6580, '2016-09-15 14:30:59', 'dbo', ''),
(2016080032, 201608, 22, 32, '2016-09-15', 1807, 'ENERGY', 59731, 56007, '2016-08-31', '2016-07-30', '2016-09-22', 3724, 716327.3590, 0.0000, 67772.0300, 784099.3890, '2016-09-15 14:30:59', 'dbo', ''),
(2016080033, 201608, 22, 33, '2016-09-15', 1808, 'ENERGY', 7590, 7132, '2016-08-31', '2016-07-30', '2016-09-22', 458, 103287.5834, 0.0000, 8589.3400, 111876.9234, '2016-09-15 14:30:59', 'dbo', ''),
(2016080034, 201608, 22, 34, '2016-09-15', 1809, 'ENERGY', 4861, 4591, '2016-08-31', '2016-07-30', '2016-09-22', 270, 69433.5642, 0.0000, 5182.6300, 74616.1942, '2016-09-15 14:30:59', 'dbo', ''),
(2016080035, 201608, 22, 35, '2016-09-15', 1810, 'ENERGY', 10950, 10149, '2016-08-31', '2016-07-30', '2016-09-22', 801, 141826.8126, 0.0000, 14804.7900, 156631.6026, '2016-09-15 14:30:59', 'dbo', ''),
(2016080036, 201608, 22, 36, '2016-09-15', 1811, 'ENERGY', 23400, 21837, '2016-08-31', '2016-07-30', '2016-09-22', 1563, 325825.3838, 0.0000, 28612.8900, 354438.2738, '2016-09-15 14:30:59', 'dbo', ''),
(2016080037, 201608, 22, 37, '2016-09-15', 1812, 'ENERGY', 13566, 12918, '2016-08-31', '2016-07-30', '2016-09-22', 648, 173945.4010, 0.0000, 12032.3100, 185977.7110, '2016-09-15 14:30:59', 'dbo', ''),
(2016080038, 201608, 22, 38, '2016-09-15', 1813, 'ENERGY', 6762, 6407, '2016-08-31', '2016-07-30', '2016-09-22', 355, 94494.3134, 0.0000, 6722.9000, 101217.2134, '2016-09-15 14:30:59', 'dbo', ''),
(2016080039, 201608, 22, 39, '2016-09-15', 1814, 'ENERGY', 16083, 15620, '2016-08-31', '2016-07-30', '2016-09-22', 463, -383719.1418, 0.0000, 8679.9500, -375039.1918, '2016-09-15 14:30:59', 'dbo', ''),
(2016080040, 201608, 22, 40, '2016-09-15', 1815, 'ENERGY', 12189, 11510, '2016-08-31', '2016-07-30', '2016-09-22', 679, 164565.3496, 0.0000, 12594.0600, 177159.4096, '2016-09-15 14:30:59', 'dbo', ''),
(2016080041, 201608, 22, 41, '2016-09-15', 1816, 'ENERGY', 241, 241, '2016-08-31', '2016-07-30', '2016-09-22', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2016-09-15 14:30:59', 'dbo', ''),
(2016080042, 201608, 22, 42, '2016-09-15', 1817, 'ENERGY', 183, 183, '2016-08-31', '2016-07-30', '2016-09-22', 0, 8044.5460, 0.0000, 0.0000, 8044.5460, '2016-09-15 14:30:59', 'dbo', ''),
(2016080043, 201608, 22, 43, '2016-09-15', 1818, 'ENERGY', 40183, 38208, '2016-08-31', '2016-07-30', '2016-09-22', 1975, 396717.7602, 0.0000, 36078.6700, 432796.4302, '2016-09-15 14:30:59', 'dbo', ''),
(2016080044, 201608, 22, 44, '2016-09-15', 1819, 'ENERGY', 16073, 14611, '2016-08-31', '2016-07-30', '2016-09-22', 1462, 263484.3830, 0.0000, 26782.6800, 290267.0630, '2016-09-15 14:30:59', 'dbo', ''),
(2016080045, 201608, 22, 45, '2016-09-15', 1820, 'ENERGY', 23628, 22908, '2016-08-31', '2016-07-30', '2016-09-22', 720, 144921.9320, 0.0000, 13337.0100, 158258.9420, '2016-09-15 14:30:59', 'dbo', ''),
(2016080046, 201608, 22, 46, '2016-09-15', 1821, 'ENERGY', 31101, 29615, '2016-08-31', '2016-07-30', '2016-09-22', 1486, 482716.9054, 0.0000, 27217.5800, 509934.4854, '2016-09-15 14:30:59', 'dbo', ''),
(2016080047, 201608, 22, 47, '2016-09-15', 1822, 'ENERGY', 16681, 16076, '2016-08-31', '2016-07-30', '2016-09-22', 605, 147100.7910, 0.0000, 11253.1000, 158353.8910, '2016-09-15 14:30:59', 'dbo', ''),
(2016080048, 201608, 22, 48, '2016-09-15', 1823, 'ENERGY', 806, 324, '2016-08-31', '2016-07-30', '2016-09-22', 482, 7413.7900, 0.0000, 9024.2500, 16438.0400, '2016-09-15 14:30:59', 'dbo', ''),
(2016080049, 201608, 22, 49, '2016-09-15', 1824, 'ENERGY', 3260, 3123, '2016-08-31', '2016-07-30', '2016-09-22', 137, 42317.2790, 0.0000, 2772.5600, 45089.8390, '2016-09-15 14:30:59', 'dbo', ''),
(2016080050, 201608, 22, 50, '2016-09-15', 1825, 'ENERGY', 50778, 48043, '2016-08-31', '2016-07-30', '2016-09-22', 2735, 594568.8792, 0.0000, 49850.5100, 644419.3892, '2016-09-15 14:30:59', 'dbo', ''),
(2016080051, 201608, 22, 51, '2016-09-15', 1826, 'ENERGY', 211, 211, '2016-08-31', '2016-07-30', '2016-09-22', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2016-09-15 14:30:59', 'dbo', ''),
(2016080052, 201608, 22, 52, '2016-09-15', 1827, 'ENERGY', 299, 284, '2016-08-31', '2016-07-30', '2016-09-22', 15, 6974.1020, 0.0000, 561.8100, 7535.9120, '2016-09-15 14:30:59', 'dbo', ''),
(2016080053, 201608, 22, 53, '2016-09-15', 1828, 'ENERGY', 1131, 1081, '2016-08-31', '2016-07-30', '2016-09-22', 50, 25367.0670, 0.0000, 1196.0400, 26563.1070, '2016-09-15 14:30:59', 'dbo', ''),
(2016080054, 201608, 22, 54, '2016-09-15', 1829, 'ENERGY', 16899, 16182, '2016-08-31', '2016-07-30', '2016-09-22', 717, 47094.1794, 0.0000, 13282.6500, 60376.8294, '2016-09-15 14:30:59', 'dbo', ''),
(2016080055, 201608, 22, 55, '2016-09-15', 1830, 'ENERGY', 8656, 7723, '2016-08-31', '2016-07-30', '2016-09-22', 933, 145833.6700, 0.0000, 17196.7500, 163030.4200, '2016-09-15 14:30:59', 'dbo', ''),
(2016080056, 201608, 22, 56, '2016-09-15', 1831, 'ENERGY', 81, 81, '2016-08-31', '2016-07-30', '2016-09-22', 0, 3601.8390, 0.0000, 0.0000, 3601.8390, '2016-09-15 14:30:59', 'dbo', ''),
(2016080059, 201608, 22, 59, '2016-09-15', 1834, 'ENERGY', 128, 128, '2016-08-31', '2016-07-30', '2016-09-22', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2016-09-15 14:30:59', 'dbo', ''),
(2016080060, 201608, 22, 60, '2016-09-15', 1835, 'ENERGY', 106466, 99080, '2016-08-31', '2016-07-30', '2016-09-22', 7386, 524880.5000, 0.0000, 134130.5800, 659011.0800, '2016-09-15 14:30:59', 'dbo', ''),
(2016080061, 201608, 22, 61, '2016-09-15', 1836, 'ENERGY', 16, 3, '2016-08-31', '2016-07-30', '2016-09-22', 13, 3190.0000, 0.0000, 525.5700, 3715.5700, '2016-09-15 14:30:59', 'dbo', ''),
(2016080062, 201608, 22, 62, '2016-09-15', 1837, 'ENERGY', 30, 30, '2016-08-31', '2016-07-30', '2016-09-22', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2016-09-15 14:30:59', 'dbo', ''),
(2016080063, 201608, 22, 63, '2016-09-15', 1838, 'ENERGY', 1, 1, '2016-08-31', '2016-07-30', '2016-09-22', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2016-09-15 14:30:59', 'dbo', ''),
(2016080064, 201608, 22, 64, '2016-09-15', 1839, 'ENERGY', 2, 2, '2016-08-31', '2016-07-30', '2016-09-22', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2016-09-15 14:30:59', 'dbo', ''),
(2016080065, 201608, 22, 65, '2016-09-15', 1840, 'ENERGY', 2456, 2054, '2016-08-31', '2016-07-30', '2016-09-22', 402, 40007.3880, 0.0000, 7574.5800, 47581.9680, '2016-09-15 14:30:59', 'dbo', ''),
(2016080066, 201608, 22, 66, '2016-09-15', 1841, 'ENERGY', 2358, 2090, '2016-08-31', '2016-07-30', '2016-09-22', 268, 38768.1124, 0.0000, 5146.3800, 43914.4924, '2016-09-15 14:30:59', 'dbo', ''),
(2016080067, 201608, 22, 67, '2016-09-15', 1842, 'ENERGY', 285, 255, '2016-08-31', '2016-07-30', '2016-09-22', 30, 6799.8638, 0.0000, 833.6300, 7633.4938, '2016-09-15 14:30:59', 'dbo', ''),
(2016080068, 201608, 22, 68, '2016-09-15', 1843, 'ENERGY', 525, 480, '2016-08-31', '2016-07-30', '2016-09-22', 45, 11875.2700, 0.0000, 1105.4300, 12980.7000, '2016-09-15 14:30:59', 'dbo', ''),
(2016080069, 201608, 22, 69, '2016-09-15', 1844, 'ENERGY', 1, 1, '2016-08-31', '2016-07-30', '2016-09-22', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2016-09-15 14:30:59', 'dbo', ''),
(2016080070, 201608, 22, 70, '2016-09-15', 1845, 'ENERGY', 345, 345, '2016-08-31', '2016-07-30', '2016-09-22', 0, 11744.5000, 0.0000, 0.0000, 11744.5000, '2016-09-15 14:30:59', 'dbo', ''),
(2016080071, 201608, 22, 71, '2016-09-15', 1846, 'ENERGY', 43427, 36324, '2016-08-31', '2016-07-30', '2016-09-22', 7103, 570968.8062, 0.0000, 129002.3800, 699971.1862, '2016-09-15 14:30:59', 'dbo', ''),
(2016080072, 201608, 22, 72, '2016-09-15', 1847, 'ENERGY', 761, 634, '2016-08-31', '2016-07-30', '2016-09-22', 127, 16135.7900, 0.0000, 2591.3500, 18727.1400, '2016-09-15 14:30:59', 'dbo', ''),
(2016080073, 201608, 22, 73, '2016-09-15', 1848, 'ENERGY', 371, 369, '2016-08-31', '2016-07-30', '2016-09-22', 2, 18050.3780, 0.0000, 326.2500, 18376.6280, '2016-09-15 14:30:59', 'dbo', ''),
(2016080075, 201608, 22, 75, '2016-09-15', 1849, 'ENERGY', 771, 726, '2016-08-31', '2016-07-30', '2016-09-22', 45, 16667.2600, 0.0000, 1105.4300, 17772.6900, '2016-09-15 14:30:59', 'dbo', ''),
(2016080076, 201608, 22, 76, '2016-09-15', 1850, 'ENERGY', 870, 825, '2016-08-31', '2016-07-30', '2016-09-22', 45, 18442.7800, 0.0000, 1105.4300, 19548.2100, '2016-09-15 14:30:59', 'dbo', ''),
(2016080077, 201608, 22, 77, '2016-09-15', 1851, 'ENERGY', 738, 706, '2016-08-31', '2016-07-30', '2016-09-22', 32, 16200.0000, 0.0000, 869.8700, 17069.8700, '2016-09-15 14:30:59', 'dbo', ''),
(2016080078, 201608, 22, 78, '2016-09-15', 1852, 'ENERGY', 162, 149, '2016-08-31', '2016-07-30', '2016-09-22', 13, 6151.6800, 0.0000, 525.5700, 6677.2500, '2016-09-15 14:30:59', 'dbo', ''),
(2016080079, 201608, 22, 79, '2016-09-15', 1853, 'ENERGY', 17015, 15469, '2016-08-31', '2016-07-30', '2016-09-22', 1546, 177690.7800, 0.0000, 28304.8300, 205995.6100, '2016-09-15 14:30:59', 'dbo', ''),
(2016080080, 201608, 22, 80, '2016-09-15', 1854, 'ENERGY', 311, 311, '2016-08-31', '2016-07-30', '2016-09-22', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2016-09-15 14:30:59', 'dbo', ''),
(2016080081, 201608, 22, 81, '2016-09-15', 1855, 'ENERGY', 573, 496, '2016-08-31', '2016-07-30', '2016-09-22', 77, 9136.0200, 0.0000, 1685.3100, 10821.3300, '2016-09-15 14:30:59', 'dbo', ''),
(2016080082, 201608, 22, 82, '2016-09-15', 1856, 'ENERGY', 750, 619, '2016-08-31', '2016-07-30', '2016-09-22', 131, 12622.2200, 0.0000, 2663.8300, 15286.0500, '2016-09-15 14:30:59', 'dbo', ''),
(2016090001, 201609, 23, 1, '2016-11-04', 1857, 'ENERGY', 14016, 14016, '2016-09-30', '2016-08-31', '2016-11-11', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2016-11-04 11:16:42', 'dbo', ''),
(2016090002, 201609, 23, 2, '2016-11-04', 1858, 'ENERGY', 7081, 7081, '2016-09-30', '2016-08-31', '2016-11-11', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2016-11-04 11:16:42', 'dbo', ''),
(2016090003, 201609, 23, 3, '2016-11-04', 1859, 'ENERGY', 8948, 8948, '2016-09-30', '2016-08-31', '2016-11-11', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2016-11-04 11:16:42', 'dbo', ''),
(2016090004, 201609, 23, 4, '2016-11-04', 1860, 'ENERGY', 6711, 6711, '2016-09-30', '2016-08-31', '2016-11-11', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2016-11-04 11:16:42', 'dbo', ''),
(2016090005, 201609, 23, 5, '2016-11-04', 1861, 'ENERGY', 5255, 5255, '2016-09-30', '2016-08-31', '2016-11-11', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2016-11-04 11:16:42', 'dbo', ''),
(2016090006, 201609, 23, 6, '2016-11-04', 1862, 'ENERGY', 13833, 13833, '2016-09-30', '2016-08-31', '2016-11-11', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2016-11-04 11:16:42', 'dbo', ''),
(2016090007, 201609, 23, 7, '2016-11-04', 1863, 'ENERGY', 9652, 9652, '2016-09-30', '2016-08-31', '2016-11-11', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2016-11-04 11:16:42', 'dbo', ''),
(2016090008, 201609, 23, 8, '2016-11-04', 1864, 'ENERGY', 167, 167, '2016-09-30', '2016-08-31', '2016-11-11', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2016-11-04 11:16:42', 'dbo', ''),
(2016090009, 201609, 23, 9, '2016-11-04', 1865, 'ENERGY', 95, 67, '2016-09-30', '2016-08-31', '2016-11-11', 28, 6396.0164, 0.0000, 797.4000, 7193.4164, '2016-11-04 11:16:42', 'dbo', ''),
(2016090010, 201609, 23, 10, '2016-11-04', 1866, 'ENERGY', 87, 87, '2016-09-30', '2016-08-31', '2016-11-11', 0, 6435.8780, 0.0000, 0.0000, 6435.8780, '2016-11-04 11:16:42', 'dbo', ''),
(2016090011, 201609, 23, 11, '2016-11-04', 1867, 'ENERGY', 201, 201, '2016-09-30', '2016-08-31', '2016-11-11', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2016-11-04 11:16:42', 'dbo', ''),
(2016090012, 201609, 23, 12, '2016-11-04', 1868, 'ENERGY', 118, 118, '2016-09-30', '2016-08-31', '2016-11-11', 0, 6908.2500, 0.0000, 0.0000, 6908.2500, '2016-11-04 11:16:42', 'dbo', ''),
(2016090013, 201609, 23, 13, '2016-11-04', 1869, 'ENERGY', 672, 316, '2016-09-30', '2016-08-31', '2016-11-11', 356, 11613.5740, 0.0000, 6741.1200, 18354.6940, '2016-11-04 11:16:42', 'dbo', ''),
(2016090014, 201609, 23, 14, '2016-11-04', 1870, 'ENERGY', 177, 176, '2016-09-30', '2016-08-31', '2016-11-11', 1, 8721.9654, 0.0000, 308.1300, 9030.0954, '2016-11-04 11:16:42', 'dbo', ''),
(2016090015, 201609, 23, 15, '2016-11-04', 1871, 'ENERGY', 162, 162, '2016-09-30', '2016-08-31', '2016-11-11', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2016-11-04 11:16:42', 'dbo', ''),
(2016090016, 201609, 23, 16, '2016-11-04', 1872, 'ENERGY', 78, 78, '2016-09-30', '2016-08-31', '2016-11-11', 0, 6572.6020, 0.0000, 0.0000, 6572.6020, '2016-11-04 11:16:42', 'dbo', ''),
(2016090017, 201609, 23, 17, '2016-11-04', 1873, 'ENERGY', 288, 206, '2016-09-30', '2016-08-31', '2016-11-11', 82, 4280.3870, 0.0000, 1775.9300, 6056.3170, '2016-11-04 11:16:42', 'dbo', ''),
(2016090018, 201609, 23, 18, '2016-11-04', 1874, 'ENERGY', 104, 99, '2016-09-30', '2016-08-31', '2016-11-11', 5, 4169.0400, 0.0000, 380.6100, 4549.6500, '2016-11-04 11:16:42', 'dbo', ''),
(2016090019, 201609, 23, 19, '2016-11-04', 1875, 'ENERGY', 75, 75, '2016-09-30', '2016-08-31', '2016-11-11', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2016-11-04 11:16:42', 'dbo', ''),
(2016090020, 201609, 23, 20, '2016-11-04', 1876, 'ENERGY', 203, 203, '2016-09-30', '2016-08-31', '2016-11-11', 0, 4699.0730, 0.0000, 0.0000, 4699.0730, '2016-11-04 11:16:42', 'dbo', ''),
(2016090021, 201609, 23, 21, '2016-11-04', 1877, 'ENERGY', 35788, 34593, '2016-09-30', '2016-08-31', '2016-11-11', 1195, 411127.1546, 0.0000, 21944.7700, 433071.9246, '2016-11-04 11:16:42', 'dbo', ''),
(2016090022, 201609, 23, 22, '2016-11-04', 1878, 'ENERGY', 20303, 19806, '2016-09-30', '2016-08-31', '2016-11-11', 497, 228436.2916, 0.0000, 9296.2100, 237732.5016, '2016-11-04 11:16:42', 'dbo', ''),
(2016090023, 201609, 23, 23, '2016-11-04', 1879, 'ENERGY', 48011, 46487, '2016-09-30', '2016-08-31', '2016-11-11', 1524, 538841.7070, 0.0000, 27906.6200, 566748.3270, '2016-11-04 11:16:42', 'dbo', ''),
(2016090024, 201609, 23, 24, '2016-11-04', 1880, 'ENERGY', 38253, 37658, '2016-09-30', '2016-08-31', '2016-11-11', 595, 426704.3000, 0.0000, 11072.0900, 437776.3900, '2016-11-04 11:16:42', 'dbo', ''),
(2016090025, 201609, 23, 25, '2016-11-04', 1881, 'ENERGY', 3776, 433, '2016-09-30', '2016-08-31', '2016-11-11', 3343, 10327.2900, 0.0000, 60868.9800, 71196.2700, '2016-11-04 11:16:42', 'dbo', ''),
(2016090026, 201609, 23, 26, '2016-11-04', 1882, 'ENERGY', 41216, 39127, '2016-09-30', '2016-08-31', '2016-11-11', 2089, 582330.0574, 0.0000, 38145.0700, 620475.1274, '2016-11-04 11:16:42', 'dbo', ''),
(2016090029, 201609, 23, 29, '2016-11-04', 1885, 'ENERGY', 58741, 56916, '2016-09-30', '2016-08-31', '2016-11-11', 1825, 767528.6688, 0.0000, 33361.0900, 800889.7588, '2016-11-04 11:16:42', 'dbo', ''),
(2016090030, 201609, 23, 30, '2016-11-04', 1886, 'ENERGY', 28352, 27356, '2016-09-30', '2016-08-31', '2016-11-11', 996, 259794.6412, 0.0000, 18338.6600, 278133.3012, '2016-11-04 11:16:42', 'dbo', ''),
(2016090031, 201609, 23, 31, '2016-11-04', 1887, 'ENERGY', 37641, 35762, '2016-09-30', '2016-08-31', '2016-11-11', 1879, 461570.6580, 0.0000, 34339.6300, 495910.2880, '2016-11-04 11:16:42', 'dbo', ''),
(2016090032, 201609, 23, 32, '2016-11-04', 1888, 'ENERGY', 63056, 59731, '2016-09-30', '2016-08-31', '2016-11-11', 3325, 784099.3890, 0.0000, 60542.8000, 844642.1890, '2016-11-04 11:16:42', 'dbo', ''),
(2016090033, 201609, 23, 33, '2016-11-04', 1889, 'ENERGY', 8028, 7590, '2016-09-30', '2016-08-31', '2016-11-11', 438, 111876.9234, 0.0000, 8227.0600, 120103.9834, '2016-11-04 11:16:42', 'dbo', ''),
(2016090034, 201609, 23, 34, '2016-11-04', 1890, 'ENERGY', 5117, 4861, '2016-09-30', '2016-08-31', '2016-11-11', 256, 74616.1942, 0.0000, 4929.0100, 79545.2042, '2016-11-04 11:16:42', 'dbo', ''),
(2016090035, 201609, 23, 35, '2016-11-04', 1891, 'ENERGY', 11702, 10950, '2016-09-30', '2016-08-31', '2016-11-11', 752, 156631.6026, 0.0000, 13917.1000, 170548.7026, '2016-11-04 11:16:42', 'dbo', ''),
(2016090036, 201609, 23, 36, '2016-11-04', 1892, 'ENERGY', 24716, 23400, '2016-09-30', '2016-08-31', '2016-11-11', 1316, 354438.2738, 0.0000, 24137.4200, 378575.6938, '2016-11-04 11:16:42', 'dbo', ''),
(2016090037, 201609, 23, 37, '2016-11-04', 1893, 'ENERGY', 14212, 13566, '2016-09-30', '2016-08-31', '2016-11-11', 646, 185977.7110, 0.0000, 11996.2600, 197973.9710, '2016-11-04 11:16:42', 'dbo', ''),
(2016090038, 201609, 23, 38, '2016-11-04', 1894, 'ENERGY', 7014, 6762, '2016-09-30', '2016-08-31', '2016-11-11', 252, 101217.2134, 0.0000, 4856.5200, 106073.7334, '2016-11-04 11:16:42', 'dbo', '');
INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2016090039, 201609, 23, 39, '2016-11-04', 1895, 'ENERGY', 16624, 16083, '2016-09-30', '2016-08-31', '2016-11-11', 541, -375039.1918, 0.0000, 10093.5400, -364945.6518, '2016-11-04 11:16:42', 'dbo', ''),
(2016090040, 201609, 23, 40, '2016-11-04', 1896, 'ENERGY', 12945, 12189, '2016-09-30', '2016-08-31', '2016-11-11', 756, 177159.4096, 0.0000, 13989.5900, 191148.9996, '2016-11-04 11:16:42', 'dbo', ''),
(2016090041, 201609, 23, 41, '2016-11-04', 1897, 'ENERGY', 241, 241, '2016-09-30', '2016-08-31', '2016-11-11', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2016-11-04 11:16:42', 'dbo', ''),
(2016090042, 201609, 23, 42, '2016-11-04', 1898, 'ENERGY', 183, 183, '2016-09-30', '2016-08-31', '2016-11-11', 0, 8044.5460, 0.0000, 0.0000, 8044.5460, '2016-11-04 11:16:42', 'dbo', ''),
(2016090043, 201609, 23, 43, '2016-11-04', 1899, 'ENERGY', 42089, 40183, '2016-09-30', '2016-08-31', '2016-11-11', 1906, 432796.4302, 0.0000, 34828.8900, 467625.3202, '2016-11-04 11:16:41', 'dbo', ''),
(2016090044, 201609, 23, 44, '2016-11-04', 1900, 'ENERGY', 17510, 16073, '2016-09-30', '2016-08-31', '2016-11-11', 1437, 290267.0630, 0.0000, 26330.0900, 316597.1530, '2016-11-04 11:16:41', 'dbo', ''),
(2016090045, 201609, 23, 45, '2016-11-04', 1901, 'ENERGY', 24358, 23628, '2016-09-30', '2016-08-31', '2016-11-11', 730, 158258.9420, 0.0000, 13518.4400, 171777.3820, '2016-11-04 11:16:42', 'dbo', ''),
(2016090046, 201609, 23, 46, '2016-11-04', 1902, 'ENERGY', 32334, 31101, '2016-09-30', '2016-08-31', '2016-11-11', 1233, 509934.4854, 0.0000, 22633.3700, 532567.8554, '2016-11-04 11:16:42', 'dbo', ''),
(2016090047, 201609, 23, 47, '2016-11-04', 1903, 'ENERGY', 17227, 16681, '2016-09-30', '2016-08-31', '2016-11-11', 546, 158353.8910, 0.0000, 10184.1400, 168538.0310, '2016-11-04 11:16:42', 'dbo', ''),
(2016090048, 201609, 23, 48, '2016-11-04', 1904, 'ENERGY', 1350, 806, '2016-09-30', '2016-08-31', '2016-11-11', 544, 16438.0400, 0.0000, 10147.9000, 26585.9400, '2016-11-04 11:16:42', 'dbo', ''),
(2016090049, 201609, 23, 49, '2016-11-04', 1905, 'ENERGY', 3393, 3260, '2016-09-30', '2016-08-31', '2016-11-11', 133, 45089.8390, 0.0000, 2700.1200, 47789.9590, '2016-11-04 11:16:41', 'dbo', ''),
(2016090050, 201609, 23, 50, '2016-11-04', 1906, 'ENERGY', 53011, 50778, '2016-09-30', '2016-08-31', '2016-11-11', 2233, 644419.3892, 0.0000, 40754.5100, 685173.8992, '2016-11-04 11:16:42', 'dbo', ''),
(2016090051, 201609, 23, 51, '2016-11-04', 1907, 'ENERGY', 211, 211, '2016-09-30', '2016-08-31', '2016-11-11', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2016-11-04 11:16:42', 'dbo', ''),
(2016090052, 201609, 23, 52, '2016-11-04', 1908, 'ENERGY', 313, 299, '2016-09-30', '2016-08-31', '2016-11-11', 14, 7535.9120, 0.0000, 543.7000, 8079.6120, '2016-11-04 11:16:42', 'dbo', ''),
(2016090053, 201609, 23, 53, '2016-11-04', 1909, 'ENERGY', 1261, 1131, '2016-09-30', '2016-08-31', '2016-11-11', 130, 26563.1070, 0.0000, 2645.7500, 29208.8570, '2016-11-04 11:16:42', 'dbo', ''),
(2016090054, 201609, 23, 54, '2016-11-04', 1910, 'ENERGY', 17622, 16899, '2016-09-30', '2016-08-31', '2016-11-11', 723, 60376.8294, 0.0000, 13391.5900, 73768.4194, '2016-11-04 11:16:42', 'dbo', ''),
(2016090055, 201609, 23, 55, '2016-11-04', 1911, 'ENERGY', 9449, 8656, '2016-09-30', '2016-08-31', '2016-11-11', 793, 163030.4200, 0.0000, 14660.0700, 177690.4900, '2016-11-04 11:16:42', 'dbo', ''),
(2016090056, 201609, 23, 56, '2016-11-04', 1912, 'ENERGY', 94, 81, '2016-09-30', '2016-08-31', '2016-11-11', 13, 3601.8390, 0.0000, 525.5800, 4127.4190, '2016-11-04 11:16:42', 'dbo', ''),
(2016090059, 201609, 23, 59, '2016-11-04', 1915, 'ENERGY', 128, 128, '2016-09-30', '2016-08-31', '2016-11-11', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2016-11-04 11:16:42', 'dbo', ''),
(2016090060, 201609, 23, 60, '2016-11-04', 1916, 'ENERGY', 114348, 106466, '2016-09-30', '2016-08-31', '2016-11-11', 7882, 659011.0800, 0.0000, 143120.8300, 802131.9100, '2016-11-04 11:16:41', 'dbo', ''),
(2016090061, 201609, 23, 61, '2016-11-04', 1917, 'ENERGY', 16, 16, '2016-09-30', '2016-08-31', '2016-11-11', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2016-11-04 11:16:42', 'dbo', ''),
(2016090062, 201609, 23, 62, '2016-11-04', 1918, 'ENERGY', 30, 30, '2016-09-30', '2016-08-31', '2016-11-11', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2016-11-04 11:16:42', 'dbo', ''),
(2016090063, 201609, 23, 63, '2016-11-04', 1919, 'ENERGY', 1, 1, '2016-09-30', '2016-08-31', '2016-11-11', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2016-11-04 11:16:42', 'dbo', ''),
(2016090064, 201609, 23, 64, '2016-11-04', 1920, 'ENERGY', 2, 2, '2016-09-30', '2016-08-31', '2016-11-11', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2016-11-04 11:16:42', 'dbo', ''),
(2016090065, 201609, 23, 65, '2016-11-04', 1921, 'ENERGY', 2812, 2456, '2016-09-30', '2016-08-31', '2016-11-11', 356, 47581.9680, 0.0000, 6741.1200, 54323.0880, '2016-11-04 11:16:41', 'dbo', ''),
(2016090066, 201609, 23, 66, '2016-11-04', 1922, 'ENERGY', 2679, 2358, '2016-09-30', '2016-08-31', '2016-11-11', 321, 43914.4924, 0.0000, 6106.8900, 50021.3824, '2016-11-04 11:16:41', 'dbo', ''),
(2016090067, 201609, 23, 67, '2016-11-04', 1923, 'ENERGY', 324, 285, '2016-09-30', '2016-08-31', '2016-11-11', 39, 7633.4938, 0.0000, 996.7300, 8630.2238, '2016-11-04 11:16:42', 'dbo', ''),
(2016090068, 201609, 23, 68, '2016-11-04', 1924, 'ENERGY', 589, 525, '2016-09-30', '2016-08-31', '2016-11-11', 64, 12980.7000, 0.0000, 1449.7500, 14430.4500, '2016-11-04 11:16:42', 'dbo', ''),
(2016090069, 201609, 23, 69, '2016-11-04', 1925, 'ENERGY', 1, 1, '2016-09-30', '2016-08-31', '2016-11-11', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2016-11-04 11:16:42', 'dbo', ''),
(2016090070, 201609, 23, 70, '2016-11-04', 1926, 'ENERGY', 345, 345, '2016-09-30', '2016-08-31', '2016-11-11', 0, 11744.5000, 0.0000, 0.0000, 11744.5000, '2016-11-04 11:16:42', 'dbo', ''),
(2016090071, 201609, 23, 71, '2016-11-04', 1927, 'ENERGY', 49781, 43427, '2016-09-30', '2016-08-31', '2016-11-11', 6354, 699971.1862, 0.0000, 115431.7400, 815402.9262, '2016-11-04 11:16:41', 'dbo', ''),
(2016090072, 201609, 23, 72, '2016-11-04', 1928, 'ENERGY', 842, 761, '2016-09-30', '2016-08-31', '2016-11-11', 81, 18727.1400, 0.0000, 1757.8100, 20484.9500, '2016-11-04 11:16:41', 'dbo', ''),
(2016090073, 201609, 23, 73, '2016-11-04', 1929, 'ENERGY', 378, 371, '2016-09-30', '2016-08-31', '2016-11-11', 7, 18376.6280, 0.0000, 416.8500, 18793.4780, '2016-11-04 11:16:41', 'dbo', ''),
(2016090075, 201609, 23, 75, '2016-11-04', 1930, 'ENERGY', 811, 771, '2016-09-30', '2016-08-31', '2016-11-11', 40, 17772.6900, 0.0000, 1014.8500, 18787.5400, '2016-11-04 11:16:41', 'dbo', ''),
(2016090076, 201609, 23, 76, '2016-11-04', 1931, 'ENERGY', 908, 870, '2016-09-30', '2016-08-31', '2016-11-11', 38, 19548.2100, 0.0000, 978.6000, 20526.8100, '2016-11-04 11:16:41', 'dbo', ''),
(2016090077, 201609, 23, 77, '2016-11-04', 1932, 'ENERGY', 768, 738, '2016-09-30', '2016-08-31', '2016-11-11', 30, 17069.8700, 0.0000, 833.6300, 17903.5000, '2016-11-04 11:16:41', 'dbo', ''),
(2016090078, 201609, 23, 78, '2016-11-04', 1933, 'ENERGY', 172, 162, '2016-09-30', '2016-08-31', '2016-11-11', 10, 6677.2500, 0.0000, 471.2100, 7148.4600, '2016-11-04 11:16:41', 'dbo', ''),
(2016090079, 201609, 23, 79, '2016-11-04', 1934, 'ENERGY', 18454, 17015, '2016-09-30', '2016-08-31', '2016-11-11', 1439, 205995.6100, 0.0000, 26366.3300, 232361.9400, '2016-11-04 11:16:42', 'dbo', ''),
(2016090080, 201609, 23, 80, '2016-11-04', 1935, 'ENERGY', 311, 311, '2016-09-30', '2016-08-31', '2016-11-11', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2016-11-04 11:16:42', 'dbo', ''),
(2016090081, 201609, 23, 81, '2016-11-04', 1936, 'ENERGY', 645, 573, '2016-09-30', '2016-08-31', '2016-11-11', 72, 10821.3300, 0.0000, 1594.7200, 12416.0500, '2016-11-04 11:16:42', 'dbo', ''),
(2016090082, 201609, 23, 82, '2016-11-04', 1937, 'ENERGY', 873, 750, '2016-09-30', '2016-08-31', '2016-11-11', 123, 15286.0500, 0.0000, 2518.9100, 17804.9600, '2016-11-04 11:16:42', 'dbo', ''),
(2016100001, 201610, 24, 1, '2016-12-05', 1938, 'ENERGY', 14016, 14016, '2016-10-30', '2016-09-30', '2016-12-12', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2016-12-05 20:22:15', 'dbo', ''),
(2016100002, 201610, 24, 2, '2016-12-05', 1939, 'ENERGY', 7081, 7081, '2016-10-30', '2016-09-30', '2016-12-12', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2016-12-05 20:22:15', 'dbo', ''),
(2016100003, 201610, 24, 3, '2016-12-05', 1940, 'ENERGY', 8948, 8948, '2016-10-30', '2016-09-30', '2016-12-12', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2016-12-05 20:22:15', 'dbo', ''),
(2016100004, 201610, 24, 4, '2016-12-05', 1941, 'ENERGY', 6711, 6711, '2016-10-30', '2016-09-30', '2016-12-12', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2016-12-05 20:22:15', 'dbo', ''),
(2016100005, 201610, 24, 5, '2016-12-05', 1942, 'ENERGY', 5255, 5255, '2016-10-30', '2016-09-30', '2016-12-12', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2016-12-05 20:22:15', 'dbo', ''),
(2016100006, 201610, 24, 6, '2016-12-05', 1943, 'ENERGY', 13833, 13833, '2016-10-30', '2016-09-30', '2016-12-12', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2016-12-05 20:22:15', 'dbo', ''),
(2016100007, 201610, 24, 7, '2016-12-05', 1944, 'ENERGY', 9652, 9652, '2016-10-30', '2016-09-30', '2016-12-12', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2016-12-05 20:22:15', 'dbo', ''),
(2016100008, 201610, 24, 8, '2016-12-05', 1945, 'ENERGY', 167, 167, '2016-10-30', '2016-09-30', '2016-12-12', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2016-12-05 20:22:15', 'dbo', ''),
(2016100009, 201610, 24, 9, '2016-12-05', 1946, 'ENERGY', 97, 95, '2016-10-30', '2016-09-30', '2016-12-12', 2, 7193.4164, 0.0000, 325.3100, 7518.7264, '2016-12-05 20:22:14', 'dbo', ''),
(2016100010, 201610, 24, 10, '2016-12-05', 1947, 'ENERGY', 87, 87, '2016-10-30', '2016-09-30', '2016-12-12', 0, 6435.8780, 0.0000, 0.0000, 6435.8780, '2016-12-05 20:22:15', 'dbo', ''),
(2016100011, 201610, 24, 11, '2016-12-05', 1948, 'ENERGY', 201, 201, '2016-10-30', '2016-09-30', '2016-12-12', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2016-12-05 20:22:15', 'dbo', ''),
(2016100012, 201610, 24, 12, '2016-12-05', 1949, 'ENERGY', 118, 118, '2016-10-30', '2016-09-30', '2016-12-12', 0, 6908.2500, 0.0000, 0.0000, 6908.2500, '2016-12-05 20:22:15', 'dbo', ''),
(2016100013, 201610, 24, 13, '2016-12-05', 1950, 'ENERGY', 978, 672, '2016-10-30', '2016-09-30', '2016-12-12', 306, 18354.6940, 0.0000, 5692.7900, 24047.4840, '2016-12-05 20:22:14', 'dbo', ''),
(2016100014, 201610, 24, 14, '2016-12-05', 1951, 'ENERGY', 244, 177, '2016-10-30', '2016-09-30', '2016-12-12', 67, 9030.0954, 0.0000, 1472.9700, 10503.0654, '2016-12-05 20:22:14', 'dbo', ''),
(2016100015, 201610, 24, 15, '2016-12-05', 1952, 'ENERGY', 162, 162, '2016-10-30', '2016-09-30', '2016-12-12', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2016-12-05 20:22:15', 'dbo', ''),
(2016100016, 201610, 24, 16, '2016-12-05', 1953, 'ENERGY', 197, 78, '2016-10-30', '2016-09-30', '2016-12-12', 119, 6572.6020, 0.0000, 2391.0900, 8963.6920, '2016-12-05 20:22:14', 'dbo', ''),
(2016100017, 201610, 24, 17, '2016-12-05', 1954, 'ENERGY', 957, 288, '2016-10-30', '2016-09-30', '2016-12-12', 669, 6056.3170, 0.0000, 12101.9900, 18158.3070, '2016-12-05 20:22:14', 'dbo', ''),
(2016100018, 201610, 24, 18, '2016-12-05', 1955, 'ENERGY', 810, 104, '2016-10-30', '2016-09-30', '2016-12-12', 706, 4549.6500, 0.0000, 12755.2600, 17304.9100, '2016-12-05 20:22:14', 'dbo', ''),
(2016100019, 201610, 24, 19, '2016-12-05', 1956, 'ENERGY', 75, 75, '2016-10-30', '2016-09-30', '2016-12-12', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2016-12-05 20:22:15', 'dbo', ''),
(2016100020, 201610, 24, 20, '2016-12-05', 1957, 'ENERGY', 225, 203, '2016-10-30', '2016-09-30', '2016-12-12', 22, 4699.0730, 0.0000, 678.4300, 5377.5030, '2016-12-05 20:22:14', 'dbo', ''),
(2016100021, 201610, 24, 21, '2016-12-05', 1958, 'ENERGY', 36762, 35788, '2016-10-30', '2016-09-30', '2016-12-12', 974, 433071.9246, 0.0000, 17487.1200, 450559.0446, '2016-12-05 20:22:14', 'dbo', ''),
(2016100022, 201610, 24, 22, '2016-12-05', 1959, 'ENERGY', 20852, 20303, '2016-10-30', '2016-09-30', '2016-12-12', 549, 237732.5016, 0.0000, 9983.2500, 247715.7516, '2016-12-05 20:22:14', 'dbo', ''),
(2016100023, 201610, 24, 23, '2016-12-05', 1960, 'ENERGY', 49693, 48011, '2016-10-30', '2016-09-30', '2016-12-12', 1682, 566748.3270, 0.0000, 29987.6900, 596736.0170, '2016-12-05 20:22:14', 'dbo', ''),
(2016100024, 201610, 24, 24, '2016-12-05', 1961, 'ENERGY', 38898, 38253, '2016-10-30', '2016-09-30', '2016-12-12', 645, 437776.3900, 0.0000, 11678.2400, 449454.6300, '2016-12-05 20:22:14', 'dbo', ''),
(2016100025, 201610, 24, 25, '2016-12-05', 1962, 'ENERGY', 7654, 3776, '2016-10-30', '2016-09-30', '2016-12-12', 3878, 71196.2700, 0.0000, 68760.6600, 139956.9300, '2016-12-05 20:22:14', 'dbo', ''),
(2016100026, 201610, 24, 26, '2016-12-05', 1963, 'ENERGY', 42973, 41216, '2016-10-30', '2016-09-30', '2016-12-12', 1757, 620475.1274, 0.0000, 31311.9100, 651787.0374, '2016-12-05 20:22:14', 'dbo', ''),
(2016100029, 201610, 24, 29, '2016-12-05', 1966, 'ENERGY', 60612, 58741, '2016-10-30', '2016-09-30', '2016-12-12', 1871, 800889.7588, 0.0000, 33324.7200, 834214.4788, '2016-12-05 20:22:14', 'dbo', ''),
(2016100030, 201610, 24, 30, '2016-12-05', 1967, 'ENERGY', 29290, 28352, '2016-10-30', '2016-09-30', '2016-12-12', 938, 278133.3012, 0.0000, 16851.4900, 294984.7912, '2016-12-05 20:22:14', 'dbo', ''),
(2016100031, 201610, 24, 31, '2016-12-05', 1968, 'ENERGY', 39755, 37641, '2016-10-30', '2016-09-30', '2016-12-12', 2114, 495910.2880, 0.0000, 37615.1600, 533525.4480, '2016-12-05 20:22:14', 'dbo', ''),
(2016100032, 201610, 24, 32, '2016-12-05', 1969, 'ENERGY', 66238, 63056, '2016-10-30', '2016-09-30', '2016-12-12', 3182, 844642.1890, 0.0000, 56471.9500, 901114.1390, '2016-12-05 20:22:15', 'dbo', ''),
(2016100033, 201610, 24, 33, '2016-12-05', 1970, 'ENERGY', 8406, 8028, '2016-10-30', '2016-09-30', '2016-12-12', 378, 120103.9834, 0.0000, 6964.0400, 127068.0234, '2016-12-05 20:22:14', 'dbo', ''),
(2016100034, 201610, 24, 34, '2016-12-05', 1971, 'ENERGY', 5362, 5117, '2016-10-30', '2016-09-30', '2016-12-12', 245, 79545.2042, 0.0000, 4615.7600, 84160.9642, '2016-12-05 20:22:14', 'dbo', ''),
(2016100035, 201610, 24, 35, '2016-12-05', 1972, 'ENERGY', 12325, 11702, '2016-10-30', '2016-09-30', '2016-12-12', 623, 170548.7026, 0.0000, 11289.8000, 181838.5026, '2016-12-05 20:22:14', 'dbo', ''),
(2016100036, 201610, 24, 36, '2016-12-05', 1973, 'ENERGY', 26016, 24716, '2016-10-30', '2016-09-30', '2016-12-12', 1300, 378575.6938, 0.0000, 23243.0300, 401818.7238, '2016-12-05 20:22:14', 'dbo', ''),
(2016100037, 201610, 24, 37, '2016-12-05', 1974, 'ENERGY', 14820, 14212, '2016-10-30', '2016-09-30', '2016-12-12', 608, 197973.9710, 0.0000, 11024.9500, 208998.9210, '2016-12-05 20:22:14', 'dbo', ''),
(2016100038, 201610, 24, 38, '2016-12-05', 1975, 'ENERGY', 7226, 7014, '2016-10-30', '2016-09-30', '2016-12-12', 212, 106073.7334, 0.0000, 4033.1100, 110106.8434, '2016-12-05 20:22:14', 'dbo', ''),
(2016100039, 201610, 24, 39, '2016-12-05', 1976, 'ENERGY', 17348, 16624, '2016-10-30', '2016-09-30', '2016-12-12', 724, -364945.6518, 0.0000, 13073.0700, -351872.5818, '2016-12-05 20:22:14', 'dbo', ''),
(2016100040, 201610, 24, 40, '2016-12-05', 1977, 'ENERGY', 13686, 12945, '2016-10-30', '2016-09-30', '2016-12-12', 741, 191148.9996, 0.0000, 13373.2400, 204522.2396, '2016-12-05 20:22:14', 'dbo', ''),
(2016100041, 201610, 24, 41, '2016-12-05', 1978, 'ENERGY', 241, 241, '2016-10-30', '2016-09-30', '2016-12-12', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2016-12-05 20:22:15', 'dbo', ''),
(2016100042, 201610, 24, 42, '2016-12-05', 1979, 'ENERGY', 183, 183, '2016-10-30', '2016-09-30', '2016-12-12', 0, 8044.5460, 0.0000, 0.0000, 8044.5460, '2016-12-05 20:22:15', 'dbo', ''),
(2016100043, 201610, 24, 43, '2016-12-05', 1980, 'ENERGY', 43785, 42089, '2016-10-30', '2016-09-30', '2016-12-12', 1696, 467625.3202, 0.0000, 30234.8700, 497860.1902, '2016-12-05 20:22:14', 'dbo', ''),
(2016100044, 201610, 24, 44, '2016-12-05', 1981, 'ENERGY', 18898, 17510, '2016-10-30', '2016-09-30', '2016-12-12', 1388, 316597.1530, 0.0000, 24796.7700, 341393.9230, '2016-12-05 20:22:14', 'dbo', ''),
(2016100045, 201610, 24, 45, '2016-12-05', 1982, 'ENERGY', 25077, 24358, '2016-10-30', '2016-09-30', '2016-12-12', 719, 171777.3820, 0.0000, 12984.7900, 184762.1720, '2016-12-05 20:22:14', 'dbo', ''),
(2016100046, 201610, 24, 46, '2016-12-05', 1983, 'ENERGY', 33709, 32334, '2016-10-30', '2016-09-30', '2016-12-12', 1375, 532567.8554, 0.0000, 24567.2500, 557135.1054, '2016-12-05 20:22:14', 'dbo', ''),
(2016100047, 201610, 24, 47, '2016-12-05', 1984, 'ENERGY', 17785, 17227, '2016-10-30', '2016-09-30', '2016-12-12', 558, 168538.0310, 0.0000, 10142.1500, 178680.1810, '2016-12-05 20:22:14', 'dbo', ''),
(2016100048, 201610, 24, 48, '2016-12-05', 1985, 'ENERGY', 1963, 1350, '2016-10-30', '2016-09-30', '2016-12-12', 613, 26585.9400, 0.0000, 11113.2500, 37699.1900, '2016-12-05 20:22:14', 'dbo', ''),
(2016100049, 201610, 24, 49, '2016-12-05', 1986, 'ENERGY', 3517, 3393, '2016-10-30', '2016-09-30', '2016-12-12', 124, 47789.9590, 0.0000, 2479.3600, 50269.3190, '2016-12-05 20:22:14', 'dbo', ''),
(2016100050, 201610, 24, 50, '2016-12-05', 1987, 'ENERGY', 55269, 53011, '2016-10-30', '2016-09-30', '2016-12-12', 2258, 685173.8992, 0.0000, 40157.6500, 725331.5492, '2016-12-05 20:22:14', 'dbo', ''),
(2016100051, 201610, 24, 51, '2016-12-05', 1988, 'ENERGY', 211, 211, '2016-10-30', '2016-09-30', '2016-12-12', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2016-12-05 20:22:15', 'dbo', ''),
(2016100052, 201610, 24, 52, '2016-12-05', 1989, 'ENERGY', 321, 313, '2016-10-30', '2016-09-30', '2016-12-12', 8, 8079.6120, 0.0000, 431.2600, 8510.8720, '2016-12-05 20:22:14', 'dbo', ''),
(2016100053, 201610, 24, 53, '2016-12-05', 1990, 'ENERGY', 1400, 1261, '2016-10-30', '2016-09-30', '2016-12-12', 139, 29208.8570, 0.0000, 2744.2200, 31953.0770, '2016-12-05 20:22:15', 'dbo', ''),
(2016100054, 201610, 24, 54, '2016-12-05', 1991, 'ENERGY', 18395, 17622, '2016-10-30', '2016-09-30', '2016-12-12', 773, 73768.4194, 0.0000, 13938.2300, 87706.6494, '2016-12-05 20:22:15', 'dbo', ''),
(2016100055, 201610, 24, 55, '2016-12-05', 1992, 'ENERGY', 10083, 9449, '2016-10-30', '2016-09-30', '2016-12-12', 634, 177690.4900, 0.0000, 11484.0200, 189174.5100, '2016-12-05 20:22:15', 'dbo', ''),
(2016100056, 201610, 24, 56, '2016-12-05', 1993, 'ENERGY', 121, 94, '2016-10-30', '2016-09-30', '2016-12-12', 27, 4127.4190, 0.0000, 766.7300, 4894.1490, '2016-12-05 20:22:15', 'dbo', ''),
(2016100059, 201610, 24, 59, '2016-12-05', 1996, 'ENERGY', 128, 128, '2016-10-30', '2016-09-30', '2016-12-12', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2016-12-05 20:22:15', 'dbo', ''),
(2016100060, 201610, 24, 60, '2016-12-05', 1997, 'ENERGY', 121903, 114348, '2016-10-30', '2016-09-30', '2016-12-12', 7555, 802131.9100, 0.0000, 133682.4200, 935814.3300, '2016-12-05 20:22:14', 'dbo', ''),
(2016100061, 201610, 24, 61, '2016-12-05', 1998, 'ENERGY', 16, 16, '2016-10-30', '2016-09-30', '2016-12-12', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2016-12-05 20:22:15', 'dbo', ''),
(2016100062, 201610, 24, 62, '2016-12-05', 1999, 'ENERGY', 30, 30, '2016-10-30', '2016-09-30', '2016-12-12', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2016-12-05 20:22:15', 'dbo', ''),
(2016100063, 201610, 24, 63, '2016-12-05', 2000, 'ENERGY', 1, 1, '2016-10-30', '2016-09-30', '2016-12-12', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2016-12-05 20:22:15', 'dbo', ''),
(2016100064, 201610, 24, 64, '2016-12-05', 2001, 'ENERGY', 2, 2, '2016-10-30', '2016-09-30', '2016-12-12', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2016-12-05 20:22:15', 'dbo', ''),
(2016100065, 201610, 24, 65, '2016-12-05', 2002, 'ENERGY', 3136, 2812, '2016-10-30', '2016-09-30', '2016-12-12', 324, 54323.0880, 0.0000, 6010.6000, 60333.6880, '2016-12-05 20:22:14', 'dbo', ''),
(2016100066, 201610, 24, 66, '2016-12-05', 2003, 'ENERGY', 2935, 2679, '2016-10-30', '2016-09-30', '2016-12-12', 256, 50021.3824, 0.0000, 4809.9800, 54831.3624, '2016-12-05 20:22:14', 'dbo', ''),
(2016100067, 201610, 24, 67, '2016-12-05', 2004, 'ENERGY', 367, 324, '2016-10-30', '2016-09-30', '2016-12-12', 43, 8630.2238, 0.0000, 1049.2300, 9679.4538, '2016-12-05 20:22:15', 'dbo', ''),
(2016100068, 201610, 24, 68, '2016-12-05', 2005, 'ENERGY', 669, 589, '2016-10-30', '2016-09-30', '2016-12-12', 80, 14430.4500, 0.0000, 1702.4900, 16132.9400, '2016-12-05 20:22:15', 'dbo', ''),
(2016100069, 201610, 24, 69, '2016-12-05', 2006, 'ENERGY', 1, 1, '2016-10-30', '2016-09-30', '2016-12-12', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2016-12-05 20:22:15', 'dbo', ''),
(2016100070, 201610, 24, 70, '2016-12-05', 2007, 'ENERGY', 345, 345, '2016-10-30', '2016-09-30', '2016-12-12', 0, 11744.5000, 0.0000, 0.0000, 11744.5000, '2016-12-05 20:22:15', 'dbo', ''),
(2016100071, 201610, 24, 71, '2016-12-05', 2008, 'ENERGY', 56705, 49781, '2016-10-30', '2016-09-30', '2016-12-12', 6924, 815402.9262, 0.0000, 122541.3600, 937944.2862, '2016-12-05 20:22:14', 'dbo', ''),
(2016100072, 201610, 24, 72, '2016-12-05', 2009, 'ENERGY', 922, 842, '2016-10-30', '2016-09-30', '2016-12-12', 80, 20484.9500, 0.0000, 1702.4900, 22187.4400, '2016-12-05 20:22:14', 'dbo', ''),
(2016100073, 201610, 24, 73, '2016-12-05', 2010, 'ENERGY', 383, 378, '2016-10-30', '2016-09-30', '2016-12-12', 5, 18793.4780, 0.0000, 378.2800, 19171.7580, '2016-12-05 20:22:14', 'dbo', ''),
(2016100075, 201610, 24, 75, '2016-12-05', 2011, 'ENERGY', 852, 811, '2016-10-30', '2016-09-30', '2016-12-12', 41, 18787.5400, 0.0000, 1013.9100, 19801.4500, '2016-12-05 20:22:14', 'dbo', ''),
(2016100076, 201610, 24, 76, '2016-12-05', 2012, 'ENERGY', 947, 908, '2016-10-30', '2016-09-30', '2016-12-12', 39, 20526.8100, 0.0000, 978.6000, 21505.4100, '2016-12-05 20:22:14', 'dbo', ''),
(2016100077, 201610, 24, 77, '2016-12-05', 2013, 'ENERGY', 797, 768, '2016-10-30', '2016-09-30', '2016-12-12', 29, 17903.5000, 0.0000, 802.0300, 18705.5300, '2016-12-05 20:22:14', 'dbo', ''),
(2016100078, 201610, 24, 78, '2016-12-05', 2014, 'ENERGY', 183, 172, '2016-10-30', '2016-09-30', '2016-12-12', 11, 7148.4600, 0.0000, 484.2300, 7632.6900, '2016-12-05 20:22:14', 'dbo', ''),
(2016100079, 201610, 24, 79, '2016-12-05', 2015, 'ENERGY', 19879, 18454, '2016-10-30', '2016-09-30', '2016-12-12', 1425, 232361.9400, 0.0000, 25450.0600, 257812.0000, '2016-12-05 20:22:14', 'dbo', ''),
(2016100080, 201610, 24, 80, '2016-12-05', 2016, 'ENERGY', 311, 311, '2016-10-30', '2016-09-30', '2016-12-12', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2016-12-05 20:22:15', 'dbo', ''),
(2016100081, 201610, 24, 81, '2016-12-05', 2017, 'ENERGY', 698, 645, '2016-10-30', '2016-09-30', '2016-12-12', 53, 12416.0500, 0.0000, 1225.7800, 13641.8300, '2016-12-05 20:22:14', 'dbo', ''),
(2016100082, 201610, 24, 82, '2016-12-05', 2018, 'ENERGY', 993, 873, '2016-10-30', '2016-09-30', '2016-12-12', 120, 17804.9600, 0.0000, 2408.7500, 20213.7100, '2016-12-05 20:22:14', 'dbo', ''),
(2016110001, 201611, 25, 1, '2016-12-06', 2019, 'ENERGY', 14016, 14016, '2016-11-30', '2016-10-30', '2016-12-13', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2016-12-06 10:27:24', 'dbo', ''),
(2016110002, 201611, 25, 2, '2016-12-06', 2020, 'ENERGY', 7081, 7081, '2016-11-30', '2016-10-30', '2016-12-13', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2016-12-06 10:27:24', 'dbo', ''),
(2016110003, 201611, 25, 3, '2016-12-06', 2021, 'ENERGY', 8948, 8948, '2016-11-30', '2016-10-30', '2016-12-13', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2016-12-06 10:27:24', 'dbo', ''),
(2016110004, 201611, 25, 4, '2016-12-06', 2022, 'ENERGY', 6711, 6711, '2016-11-30', '2016-10-30', '2016-12-13', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2016-12-06 10:27:24', 'dbo', ''),
(2016110005, 201611, 25, 5, '2016-12-06', 2023, 'ENERGY', 5255, 5255, '2016-11-30', '2016-10-30', '2016-12-13', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2016-12-06 10:27:24', 'dbo', ''),
(2016110006, 201611, 25, 6, '2016-12-06', 2024, 'ENERGY', 13833, 13833, '2016-11-30', '2016-10-30', '2016-12-13', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2016-12-06 10:27:24', 'dbo', ''),
(2016110007, 201611, 25, 7, '2016-12-06', 2025, 'ENERGY', 9652, 9652, '2016-11-30', '2016-10-30', '2016-12-13', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2016-12-06 10:27:24', 'dbo', ''),
(2016110008, 201611, 25, 8, '2016-12-06', 2026, 'ENERGY', 167, 167, '2016-11-30', '2016-10-30', '2016-12-13', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2016-12-06 10:27:24', 'dbo', ''),
(2016110009, 201611, 25, 9, '2016-12-06', 2027, 'ENERGY', 105, 97, '2016-11-30', '2016-10-30', '2016-12-13', 8, 7518.7264, 0.0000, 433.4100, 7952.1364, '2016-12-06 10:27:24', 'dbo', ''),
(2016110010, 201611, 25, 10, '2016-12-06', 2028, 'ENERGY', 87, 87, '2016-11-30', '2016-10-30', '2016-12-13', 0, 6435.8780, 0.0000, 0.0000, 6435.8780, '2016-12-06 10:27:24', 'dbo', ''),
(2016110011, 201611, 25, 11, '2016-12-06', 2029, 'ENERGY', 201, 201, '2016-11-30', '2016-10-30', '2016-12-13', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2016-12-06 10:27:24', 'dbo', ''),
(2016110012, 201611, 25, 12, '2016-12-06', 2030, 'ENERGY', 119, 118, '2016-11-30', '2016-10-30', '2016-12-13', 1, 6908.2500, 0.0000, 307.9200, 7216.1700, '2016-12-06 10:27:24', 'dbo', ''),
(2016110013, 201611, 25, 13, '2016-12-06', 2031, 'ENERGY', 1384, 978, '2016-11-30', '2016-10-30', '2016-12-13', 406, 24047.4840, 0.0000, 7568.5900, 31616.0740, '2016-12-06 10:27:24', 'dbo', ''),
(2016110014, 201611, 25, 14, '2016-12-06', 2032, 'ENERGY', 380, 244, '2016-11-30', '2016-10-30', '2016-12-13', 136, 10503.0654, 0.0000, 2728.1400, 13231.2054, '2016-12-06 10:27:24', 'dbo', ''),
(2016110015, 201611, 25, 15, '2016-12-06', 2033, 'ENERGY', 162, 162, '2016-11-30', '2016-10-30', '2016-12-13', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2016-12-06 10:27:24', 'dbo', ''),
(2016110016, 201611, 25, 16, '2016-12-06', 2034, 'ENERGY', 746, 197, '2016-11-30', '2016-10-30', '2016-12-13', 549, 8963.6920, 0.0000, 10132.2500, 19095.9420, '2016-12-06 10:27:24', 'dbo', ''),
(2016110017, 201611, 25, 17, '2016-12-06', 2035, 'ENERGY', 1799, 957, '2016-11-30', '2016-10-30', '2016-12-13', 842, 18158.3070, 0.0000, 15385.0300, 33543.3370, '2016-12-06 10:27:24', 'dbo', ''),
(2016110018, 201611, 25, 18, '2016-12-06', 2036, 'ENERGY', 1102, 810, '2016-11-30', '2016-10-30', '2016-12-13', 292, 17304.9100, 0.0000, 5524.8600, 22829.7700, '2016-12-06 10:27:24', 'dbo', ''),
(2016110019, 201611, 25, 19, '2016-12-06', 2037, 'ENERGY', 75, 75, '2016-11-30', '2016-10-30', '2016-12-13', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2016-12-06 10:27:24', 'dbo', ''),
(2016110020, 201611, 25, 20, '2016-12-06', 2038, 'ENERGY', 225, 225, '2016-11-30', '2016-10-30', '2016-12-13', 0, 5377.5030, 0.0000, 0.0000, 5377.5030, '2016-12-06 10:27:24', 'dbo', ''),
(2016110021, 201611, 25, 21, '2016-12-06', 2039, 'ENERGY', 37385, 36762, '2016-11-30', '2016-10-30', '2016-12-13', 623, 450559.0446, 0.0000, 11458.8900, 462017.9346, '2016-12-06 10:27:24', 'dbo', ''),
(2016110022, 201611, 25, 22, '2016-12-06', 2040, 'ENERGY', 21389, 20852, '2016-11-30', '2016-10-30', '2016-12-13', 537, 247715.7516, 0.0000, 9917.1200, 257632.8716, '2016-12-06 10:27:24', 'dbo', ''),
(2016110023, 201611, 25, 23, '2016-12-06', 2041, 'ENERGY', 51389, 49693, '2016-11-30', '2016-10-30', '2016-12-13', 1696, 596736.0170, 0.0000, 30695.1800, 627431.1970, '2016-12-06 10:27:24', 'dbo', ''),
(2016110024, 201611, 25, 24, '2016-12-06', 2042, 'ENERGY', 39332, 38898, '2016-11-30', '2016-10-30', '2016-12-13', 434, 449454.6300, 0.0000, 8070.5700, 457525.2000, '2016-12-06 10:27:24', 'dbo', ''),
(2016110025, 201611, 25, 25, '2016-12-06', 2043, 'ENERGY', 11964, 7654, '2016-11-30', '2016-10-30', '2016-12-13', 4310, 139956.9300, 0.0000, 77557.9000, 217514.8300, '2016-12-06 10:27:24', 'dbo', ''),
(2016110026, 201611, 25, 26, '2016-12-06', 2044, 'ENERGY', 44584, 42973, '2016-11-30', '2016-10-30', '2016-12-13', 1611, 651787.0374, 0.0000, 29171.3400, 680958.3774, '2016-12-06 10:27:24', 'dbo', ''),
(2016110029, 201611, 25, 29, '2016-12-06', 2047, 'ENERGY', 62651, 60612, '2016-11-30', '2016-10-30', '2016-12-13', 2039, 834214.4788, 0.0000, 36844.3500, 871058.8288, '2016-12-06 10:27:24', 'dbo', ''),
(2016110030, 201611, 25, 30, '2016-12-06', 2048, 'ENERGY', 30418, 29290, '2016-11-30', '2016-10-30', '2016-12-13', 1128, 294984.7912, 0.0000, 20512.3100, 315497.1012, '2016-12-06 10:27:24', 'dbo', ''),
(2016110031, 201611, 25, 31, '2016-12-06', 2049, 'ENERGY', 41981, 39755, '2016-11-30', '2016-10-30', '2016-12-13', 2226, 533525.4480, 0.0000, 40196.8000, 573722.2480, '2016-12-06 10:27:24', 'dbo', ''),
(2016110032, 201611, 25, 32, '2016-12-06', 2050, 'ENERGY', 69763, 66238, '2016-11-30', '2016-10-30', '2016-12-13', 3525, 901114.1390, 0.0000, 63484.7300, 964598.8690, '2016-12-06 10:27:24', 'dbo', ''),
(2016110033, 201611, 25, 33, '2016-12-06', 2051, 'ENERGY', 8817, 8406, '2016-11-30', '2016-10-30', '2016-12-13', 411, 127068.0234, 0.0000, 7658.2300, 134726.2534, '2016-12-06 10:27:24', 'dbo', ''),
(2016110034, 201611, 25, 34, '2016-12-06', 2052, 'ENERGY', 5640, 5362, '2016-11-30', '2016-10-30', '2016-12-13', 278, 84160.9642, 0.0000, 5273.8700, 89434.8342, '2016-12-06 10:27:24', 'dbo', ''),
(2016110035, 201611, 25, 35, '2016-12-06', 2053, 'ENERGY', 13160, 12325, '2016-11-30', '2016-10-30', '2016-12-13', 835, 181838.5026, 0.0000, 15259.5300, 197098.0326, '2016-12-06 10:27:24', 'dbo', ''),
(2016110036, 201611, 25, 36, '2016-12-06', 2054, 'ENERGY', 27329, 26016, '2016-11-30', '2016-10-30', '2016-12-13', 1313, 401818.7238, 0.0000, 23828.9200, 425647.6438, '2016-12-06 10:27:24', 'dbo', ''),
(2016110037, 201611, 25, 37, '2016-12-06', 2055, 'ENERGY', 15522, 14820, '2016-11-30', '2016-10-30', '2016-12-13', 702, 208998.9210, 0.0000, 12875.1700, 221874.0910, '2016-12-06 10:27:24', 'dbo', ''),
(2016110038, 201611, 25, 38, '2016-12-06', 2056, 'ENERGY', 7522, 7226, '2016-11-30', '2016-10-30', '2016-12-13', 296, 110106.8434, 0.0000, 5596.5700, 115703.4134, '2016-12-06 10:27:24', 'dbo', ''),
(2016110039, 201611, 25, 39, '2016-12-06', 2057, 'ENERGY', 18105, 17348, '2016-11-30', '2016-10-30', '2016-12-13', 757, -351872.5818, 0.0000, 13861.1900, -338011.3918, '2016-12-06 10:27:24', 'dbo', ''),
(2016110040, 201611, 25, 40, '2016-12-06', 2058, 'ENERGY', 14540, 13686, '2016-11-30', '2016-10-30', '2016-12-13', 854, 204522.2396, 0.0000, 15600.1600, 220122.3996, '2016-12-06 10:27:24', 'dbo', ''),
(2016110041, 201611, 25, 41, '2016-12-06', 2059, 'ENERGY', 241, 241, '2016-11-30', '2016-10-30', '2016-12-13', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2016-12-06 10:27:24', 'dbo', ''),
(2016110042, 201611, 25, 42, '2016-12-06', 2060, 'ENERGY', 183, 183, '2016-11-30', '2016-10-30', '2016-12-13', 0, 8044.5460, 0.0000, 0.0000, 8044.5460, '2016-12-06 10:27:24', 'dbo', ''),
(2016110043, 201611, 25, 43, '2016-12-06', 2061, 'ENERGY', 45739, 43785, '2016-11-30', '2016-10-30', '2016-12-13', 1954, 497860.1902, 0.0000, 35320.5000, 533180.6902, '2016-12-06 10:27:24', 'dbo', ''),
(2016110044, 201611, 25, 44, '2016-12-06', 2062, 'ENERGY', 20609, 18898, '2016-11-30', '2016-10-30', '2016-12-13', 1711, 341393.9230, 0.0000, 30964.1000, 372358.0230, '2016-12-06 10:27:24', 'dbo', ''),
(2016110045, 201611, 25, 45, '2016-12-06', 2063, 'ENERGY', 25845, 25077, '2016-11-30', '2016-10-30', '2016-12-13', 768, 184762.1720, 0.0000, 14058.3800, 198820.5520, '2016-12-06 10:27:24', 'dbo', ''),
(2016110046, 201611, 25, 46, '2016-12-06', 2064, 'ENERGY', 35022, 33709, '2016-11-30', '2016-10-30', '2016-12-13', 1313, 557135.1054, 0.0000, 23828.9200, 580964.0254, '2016-12-06 10:27:24', 'dbo', ''),
(2016110047, 201611, 25, 47, '2016-12-06', 2065, 'ENERGY', 18384, 17785, '2016-11-30', '2016-10-30', '2016-12-13', 599, 178680.1810, 0.0000, 11028.6300, 189708.8110, '2016-12-06 10:27:24', 'dbo', ''),
(2016110048, 201611, 25, 48, '2016-12-06', 2066, 'ENERGY', 2759, 1963, '2016-11-30', '2016-10-30', '2016-12-13', 796, 37699.1900, 0.0000, 14560.3500, 52259.5400, '2016-12-06 10:27:24', 'dbo', ''),
(2016110049, 201611, 25, 49, '2016-12-06', 2067, 'ENERGY', 3671, 3517, '2016-11-30', '2016-10-30', '2016-12-13', 154, 50269.3190, 0.0000, 3050.8500, 53320.1690, '2016-12-06 10:27:24', 'dbo', ''),
(2016110050, 201611, 25, 50, '2016-12-06', 2068, 'ENERGY', 57743, 55269, '2016-11-30', '2016-10-30', '2016-12-13', 2474, 725331.5492, 0.0000, 44642.8500, 769974.3992, '2016-12-06 10:27:24', 'dbo', ''),
(2016110051, 201611, 25, 51, '2016-12-06', 2069, 'ENERGY', 211, 211, '2016-11-30', '2016-10-30', '2016-12-13', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2016-12-06 10:27:24', 'dbo', ''),
(2016110052, 201611, 25, 52, '2016-12-06', 2070, 'ENERGY', 321, 321, '2016-11-30', '2016-10-30', '2016-12-13', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2016-12-06 10:27:24', 'dbo', ''),
(2016110053, 201611, 25, 53, '2016-12-06', 2071, 'ENERGY', 1547, 1400, '2016-11-30', '2016-10-30', '2016-12-13', 147, 31953.0770, 0.0000, 2925.3600, 34878.4370, '2016-12-06 10:27:24', 'dbo', ''),
(2016110054, 201611, 25, 54, '2016-12-06', 2072, 'ENERGY', 19260, 18395, '2016-11-30', '2016-10-30', '2016-12-13', 865, 87706.6494, 0.0000, 15797.3600, 103504.0094, '2016-12-06 10:27:24', 'dbo', ''),
(2016110055, 201611, 25, 55, '2016-12-06', 2073, 'ENERGY', 10829, 10083, '2016-11-30', '2016-10-30', '2016-12-13', 746, 189174.5100, 0.0000, 13663.9800, 202838.4900, '2016-12-06 10:27:24', 'dbo', ''),
(2016110056, 201611, 25, 56, '2016-12-06', 2074, 'ENERGY', 149, 121, '2016-11-30', '2016-10-30', '2016-12-13', 28, 4894.1490, 0.0000, 791.9700, 5686.1190, '2016-12-06 10:27:24', 'dbo', ''),
(2016110059, 201611, 25, 59, '2016-12-06', 2077, 'ENERGY', 128, 128, '2016-11-30', '2016-10-30', '2016-12-13', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2016-12-06 10:27:24', 'dbo', ''),
(2016110060, 201611, 25, 60, '2016-12-06', 2078, 'ENERGY', 130100, 121903, '2016-11-30', '2016-10-30', '2016-12-13', 8197, 935814.3300, 0.0000, 147242.4200, 1083056.7500, '2016-12-06 10:27:24', 'dbo', ''),
(2016110061, 201611, 25, 61, '2016-12-06', 2079, 'ENERGY', 16, 16, '2016-11-30', '2016-10-30', '2016-12-13', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2016-12-06 10:27:24', 'dbo', ''),
(2016110062, 201611, 25, 62, '2016-12-06', 2080, 'ENERGY', 30, 30, '2016-11-30', '2016-10-30', '2016-12-13', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2016-12-06 10:27:24', 'dbo', ''),
(2016110063, 201611, 25, 63, '2016-12-06', 2081, 'ENERGY', 1, 1, '2016-11-30', '2016-10-30', '2016-12-13', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2016-12-06 10:27:24', 'dbo', ''),
(2016110064, 201611, 25, 64, '2016-12-06', 2082, 'ENERGY', 2, 2, '2016-11-30', '2016-10-30', '2016-12-13', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2016-12-06 10:27:24', 'dbo', ''),
(2016110065, 201611, 25, 65, '2016-12-06', 2083, 'ENERGY', 3496, 3136, '2016-11-30', '2016-10-30', '2016-12-13', 360, 60333.6880, 0.0000, 6743.9400, 67077.6280, '2016-12-06 10:27:24', 'dbo', ''),
(2016110066, 201611, 25, 66, '2016-12-06', 2084, 'ENERGY', 3232, 2935, '2016-11-30', '2016-10-30', '2016-12-13', 297, 54831.3624, 0.0000, 5614.5000, 60445.8624, '2016-12-06 10:27:24', 'dbo', ''),
(2016110067, 201611, 25, 67, '2016-12-06', 2085, 'ENERGY', 413, 367, '2016-11-30', '2016-10-30', '2016-12-13', 46, 9679.4538, 0.0000, 1114.6700, 10794.1238, '2016-12-06 10:27:24', 'dbo', ''),
(2016110068, 201611, 25, 68, '2016-12-06', 2086, 'ENERGY', 750, 669, '2016-11-30', '2016-10-30', '2016-12-13', 81, 16132.9400, 0.0000, 1742.1300, 17875.0700, '2016-12-06 10:27:24', 'dbo', ''),
(2016110069, 201611, 25, 69, '2016-12-06', 2087, 'ENERGY', 1, 1, '2016-11-30', '2016-10-30', '2016-12-13', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2016-12-06 10:27:24', 'dbo', ''),
(2016110070, 201611, 25, 70, '2016-12-06', 2088, 'ENERGY', 345, 345, '2016-11-30', '2016-10-30', '2016-12-13', 0, 11744.5000, 0.0000, 0.0000, 11744.5000, '2016-12-06 10:27:24', 'dbo', ''),
(2016110071, 201611, 25, 71, '2016-12-06', 2089, 'ENERGY', 64471, 56705, '2016-11-30', '2016-10-30', '2016-12-13', 7766, 937944.2862, 0.0000, 139515.6200, 1077459.9062, '2016-12-06 10:27:24', 'dbo', ''),
(2016110072, 201611, 25, 72, '2016-12-06', 2090, 'ENERGY', 987, 922, '2016-11-30', '2016-10-30', '2016-12-13', 65, 22187.4400, 0.0000, 1455.2900, 23642.7300, '2016-12-06 10:27:24', 'dbo', ''),
(2016110073, 201611, 25, 73, '2016-12-06', 2091, 'ENERGY', 384, 383, '2016-11-30', '2016-10-30', '2016-12-13', 1, 19171.7580, 0.0000, 307.9200, 19479.6780, '2016-12-06 10:27:24', 'dbo', ''),
(2016110075, 201611, 25, 75, '2016-12-06', 2092, 'ENERGY', 895, 852, '2016-11-30', '2016-10-30', '2016-12-13', 43, 19801.4500, 0.0000, 1060.8800, 20862.3300, '2016-12-06 10:27:24', 'dbo', ''),
(2016110076, 201611, 25, 76, '2016-12-06', 2093, 'ENERGY', 989, 947, '2016-11-30', '2016-10-30', '2016-12-13', 42, 21505.4100, 0.0000, 1042.9600, 22548.3700, '2016-12-06 10:27:24', 'dbo', ''),
(2016110077, 201611, 25, 77, '2016-12-06', 2094, 'ENERGY', 827, 797, '2016-11-30', '2016-10-30', '2016-12-13', 30, 18705.5300, 0.0000, 827.8300, 19533.3600, '2016-12-06 10:27:24', 'dbo', ''),
(2016110078, 201611, 25, 78, '2016-12-06', 2095, 'ENERGY', 195, 183, '2016-11-30', '2016-10-30', '2016-12-13', 12, 7632.6900, 0.0000, 505.1300, 8137.8200, '2016-12-06 10:27:24', 'dbo', ''),
(2016110079, 201611, 25, 79, '2016-12-06', 2096, 'ENERGY', 21387, 19879, '2016-11-30', '2016-10-30', '2016-12-13', 1508, 257812.0000, 0.0000, 27324.8000, 285136.8000, '2016-12-06 10:27:24', 'dbo', ''),
(2016110080, 201611, 25, 80, '2016-12-06', 2097, 'ENERGY', 311, 311, '2016-11-30', '2016-10-30', '2016-12-13', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2016-12-06 10:27:24', 'dbo', ''),
(2016110081, 201611, 25, 81, '2016-12-06', 2098, 'ENERGY', 752, 698, '2016-11-30', '2016-10-30', '2016-12-13', 54, 13641.8300, 0.0000, 1258.0900, 14899.9200, '2016-12-06 10:27:24', 'dbo', ''),
(2016110082, 201611, 25, 82, '2016-12-06', 2099, 'ENERGY', 1120, 993, '2016-11-30', '2016-10-30', '2016-12-13', 127, 20213.7100, 0.0000, 2566.8100, 22780.5200, '2016-12-06 10:27:24', 'dbo', ''),
(2016110083, 201611, 25, 83, '2016-12-06', 2100, 'ENERGY', 25, 0, '2016-11-30', '2016-10-30', '2016-12-13', 25, 0.0000, 0.0000, 738.1900, 738.1900, '2016-12-06 10:27:24', 'dbo', ''),
(2016110084, 201611, 25, 84, '2016-12-06', 2101, 'ENERGY', 11, 0, '2016-11-30', '2016-10-30', '2016-12-13', 11, 0.0000, 0.0000, 487.2000, 487.2000, '2016-12-06 10:27:24', 'dbo', ''),
(2016110085, 201611, 25, 85, '2016-12-06', 2102, 'ENERGY', 0, 0, '2016-11-30', '2016-10-30', '2016-12-13', 0, 0.0000, 0.0000, 0.0000, 0.0000, '2016-12-06 10:27:24', 'dbo', ''),
(2016120001, 201612, 26, 1, '2017-02-01', 2103, 'ENERGY', 14016, 14016, '2016-12-31', '2016-11-30', '2017-02-08', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2017-02-01 21:20:40', 'dbo', ''),
(2016120002, 201612, 26, 2, '2017-02-01', 2104, 'ENERGY', 7081, 7081, '2016-12-31', '2016-11-30', '2017-02-08', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2017-02-01 21:20:40', 'dbo', ''),
(2016120003, 201612, 26, 3, '2017-02-01', 2105, 'ENERGY', 8948, 8948, '2016-12-31', '2016-11-30', '2017-02-08', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2017-02-01 21:20:40', 'dbo', ''),
(2016120004, 201612, 26, 4, '2017-02-01', 2106, 'ENERGY', 6711, 6711, '2016-12-31', '2016-11-30', '2017-02-08', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2017-02-01 21:20:40', 'dbo', ''),
(2016120005, 201612, 26, 5, '2017-02-01', 2107, 'ENERGY', 5255, 5255, '2016-12-31', '2016-11-30', '2017-02-08', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2017-02-01 21:20:40', 'dbo', ''),
(2016120006, 201612, 26, 6, '2017-02-01', 2108, 'ENERGY', 13833, 13833, '2016-12-31', '2016-11-30', '2017-02-08', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2017-02-01 21:20:41', 'dbo', ''),
(2016120007, 201612, 26, 7, '2017-02-01', 2109, 'ENERGY', 9652, 9652, '2016-12-31', '2016-11-30', '2017-02-08', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2017-02-01 21:20:41', 'dbo', ''),
(2016120008, 201612, 26, 8, '2017-02-01', 2110, 'ENERGY', 167, 167, '2016-12-31', '2016-11-30', '2017-02-08', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2017-02-01 21:20:41', 'dbo', ''),
(2016120009, 201612, 26, 9, '2017-02-01', 2111, 'ENERGY', 115, 105, '2016-12-31', '2016-11-30', '2017-02-08', 10, 7952.1364, 0.0000, 474.4700, 8426.6064, '2017-02-01 21:20:40', 'dbo', ''),
(2016120010, 201612, 26, 10, '2017-02-01', 2112, 'ENERGY', 87, 87, '2016-12-31', '2016-11-30', '2017-02-08', 0, 6435.8780, 0.0000, 0.0000, 6435.8780, '2017-02-01 21:20:40', 'dbo', ''),
(2016120011, 201612, 26, 11, '2017-02-01', 2113, 'ENERGY', 201, 201, '2016-12-31', '2016-11-30', '2017-02-08', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2017-02-01 21:20:40', 'dbo', ''),
(2016120012, 201612, 26, 12, '2017-02-01', 2114, 'ENERGY', 119, 119, '2016-12-31', '2016-11-30', '2017-02-08', 0, 7216.1700, 0.0000, 0.0000, 7216.1700, '2017-02-01 21:20:40', 'dbo', ''),
(2016120013, 201612, 26, 13, '2017-02-01', 2115, 'ENERGY', 1764, 1384, '2016-12-31', '2016-11-30', '2017-02-08', 380, 31616.0740, 0.0000, 7300.0200, 38916.0940, '2017-02-01 21:20:40', 'dbo', ''),
(2016120014, 201612, 26, 14, '2017-02-01', 2116, 'ENERGY', 604, 380, '2016-12-31', '2016-11-30', '2017-02-08', 224, 13231.2054, 0.0000, 4422.2100, 17653.4154, '2017-02-01 21:20:40', 'dbo', ''),
(2016120015, 201612, 26, 15, '2017-02-01', 2117, 'ENERGY', 162, 162, '2016-12-31', '2016-11-30', '2017-02-08', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2017-02-01 21:20:40', 'dbo', ''),
(2016120016, 201612, 26, 16, '2017-02-01', 2118, 'ENERGY', 1237, 746, '2016-12-31', '2016-11-30', '2017-02-08', 491, 19095.9420, 0.0000, 9347.6700, 28443.6120, '2017-02-01 21:20:40', 'dbo', ''),
(2016120017, 201612, 26, 17, '2017-02-01', 2119, 'ENERGY', 3120, 1799, '2016-12-31', '2016-11-30', '2017-02-08', 1321, 33543.3370, 0.0000, 24659.0000, 58202.3370, '2017-02-01 21:20:40', 'dbo', ''),
(2016120018, 201612, 26, 18, '2017-02-01', 2120, 'ENERGY', 1355, 1102, '2016-12-31', '2016-11-30', '2017-02-08', 253, 22829.7700, 0.0000, 4957.1900, 27786.9600, '2017-02-01 21:20:40', 'dbo', ''),
(2016120019, 201612, 26, 19, '2017-02-01', 2121, 'ENERGY', 75, 75, '2016-12-31', '2016-11-30', '2017-02-08', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2017-02-01 21:20:40', 'dbo', ''),
(2016120020, 201612, 26, 20, '2017-02-01', 2122, 'ENERGY', 237, 225, '2016-12-31', '2016-11-30', '2017-02-08', 12, 5377.5030, 0.0000, 511.3700, 5888.8730, '2017-02-01 21:20:40', 'dbo', ''),
(2016120021, 201612, 26, 21, '2017-02-01', 2123, 'ENERGY', 38245, 37385, '2016-12-31', '2016-11-30', '2017-02-08', 860, 462017.9346, 0.0000, 16154.7600, 478172.6946, '2017-02-01 21:20:40', 'dbo', ''),
(2016120022, 201612, 26, 22, '2017-02-01', 2124, 'ENERGY', 21732, 21389, '2016-12-31', '2016-11-30', '2017-02-08', 343, 257632.8716, 0.0000, 6617.4600, 264250.3316, '2017-02-01 21:20:40', 'dbo', ''),
(2016120023, 201612, 26, 23, '2017-02-01', 2125, 'ENERGY', 53824, 51389, '2016-12-31', '2016-11-30', '2017-02-08', 2435, 627431.1970, 0.0000, 45209.4100, 672640.6070, '2017-02-01 21:20:40', 'dbo', ''),
(2016120024, 201612, 26, 24, '2017-02-01', 2126, 'ENERGY', 39614, 39332, '2016-12-31', '2016-11-30', '2017-02-08', 282, 457525.2000, 0.0000, 5492.1600, 463017.3600, '2017-02-01 21:20:40', 'dbo', ''),
(2016120025, 201612, 26, 25, '2017-02-01', 2127, 'ENERGY', 16252, 11964, '2016-12-31', '2016-11-30', '2017-02-08', 4288, 217514.8300, 0.0000, 79392.4300, 296907.2600, '2017-02-01 21:20:40', 'dbo', ''),
(2016120026, 201612, 26, 26, '2017-02-01', 2128, 'ENERGY', 45915, 44584, '2016-12-31', '2016-11-30', '2017-02-08', 1331, 680958.3774, 0.0000, 24843.4900, 705801.8674, '2017-02-01 21:20:40', 'dbo', ''),
(2016120029, 201612, 26, 29, '2017-02-01', 2131, 'ENERGY', 64693, 62651, '2016-12-31', '2016-11-30', '2017-02-08', 2042, 871058.8288, 0.0000, 37959.5800, 909018.4088, '2017-02-01 21:20:40', 'dbo', ''),
(2016120030, 201612, 26, 30, '2017-02-01', 2132, 'ENERGY', 31298, 30418, '2016-12-31', '2016-11-30', '2017-02-08', 880, 315497.1012, 0.0000, 16523.7100, 332020.8112, '2017-02-01 21:20:40', 'dbo', ''),
(2016120031, 201612, 26, 31, '2017-02-01', 2133, 'ENERGY', 44204, 41981, '2016-12-31', '2016-11-30', '2017-02-08', 2223, 573722.2480, 0.0000, 41298.5600, 615020.8080, '2017-02-01 21:20:40', 'dbo', ''),
(2016120032, 201612, 26, 32, '2017-02-01', 2134, 'ENERGY', 73042, 69763, '2016-12-31', '2016-11-30', '2017-02-08', 3279, 964598.8690, 0.0000, 60779.0100, 1025377.8790, '2017-02-01 21:20:40', 'dbo', ''),
(2016120033, 201612, 26, 33, '2017-02-01', 2135, 'ENERGY', 9140, 8817, '2016-12-31', '2016-11-30', '2017-02-08', 323, 134726.2534, 0.0000, 6248.5100, 140974.7634, '2017-02-01 21:20:40', 'dbo', ''),
(2016120034, 201612, 26, 34, '2017-02-01', 2136, 'ENERGY', 5905, 5640, '2016-12-31', '2016-11-30', '2017-02-08', 265, 89434.8342, 0.0000, 5178.5600, 94613.3942, '2017-02-01 21:20:40', 'dbo', ''),
(2016120035, 201612, 26, 35, '2017-02-01', 2137, 'ENERGY', 13595, 13160, '2016-12-31', '2016-11-30', '2017-02-08', 435, 197098.0326, 0.0000, 8314.6100, 205412.6426, '2017-02-01 21:20:40', 'dbo', ''),
(2016120036, 201612, 26, 36, '2017-02-01', 2138, 'ENERGY', 28485, 27329, '2016-12-31', '2016-11-30', '2017-02-08', 1156, 425647.6438, 0.0000, 21615.2000, 447262.8438, '2017-02-01 21:20:40', 'dbo', ''),
(2016120037, 201612, 26, 37, '2017-02-01', 2139, 'ENERGY', 16089, 15522, '2016-12-31', '2016-11-30', '2017-02-08', 567, 221874.0910, 0.0000, 10749.6800, 232623.7710, '2017-02-01 21:20:40', 'dbo', ''),
(2016120038, 201612, 26, 38, '2017-02-01', 2140, 'ENERGY', 7731, 7522, '2016-12-31', '2016-11-30', '2017-02-08', 209, 115703.4134, 0.0000, 4145.5000, 119848.9134, '2017-02-01 21:20:40', 'dbo', ''),
(2016120039, 201612, 26, 39, '2017-02-01', 2141, 'ENERGY', 18729, 18105, '2016-12-31', '2016-11-30', '2017-02-08', 624, -338011.3918, 0.0000, 11801.1700, -326210.2218, '2017-02-01 21:20:40', 'dbo', ''),
(2016120040, 201612, 26, 40, '2017-02-01', 2142, 'ENERGY', 15325, 14540, '2016-12-31', '2016-11-30', '2017-02-08', 785, 220122.3996, 0.0000, 14771.2000, 234893.5996, '2017-02-01 21:20:40', 'dbo', ''),
(2016120041, 201612, 26, 41, '2017-02-01', 2143, 'ENERGY', 241, 241, '2016-12-31', '2016-11-30', '2017-02-08', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2017-02-01 21:20:40', 'dbo', ''),
(2016120042, 201612, 26, 42, '2017-02-01', 2144, 'ENERGY', 183, 183, '2016-12-31', '2016-11-30', '2017-02-08', 0, 8044.5460, 0.0000, 0.0000, 8044.5460, '2017-02-01 21:20:40', 'dbo', ''),
(2016120043, 201612, 26, 43, '2017-02-01', 2145, 'ENERGY', 47183, 45739, '2016-12-31', '2016-11-30', '2017-02-08', 1444, 533180.6902, 0.0000, 26928.0400, 560108.7302, '2017-02-01 21:20:40', 'dbo', ''),
(2016120044, 201612, 26, 44, '2017-02-01', 2146, 'ENERGY', 22120, 20609, '2016-12-31', '2016-11-30', '2017-02-08', 1511, 372358.0230, 0.0000, 28164.0100, 400522.0330, '2017-02-01 21:20:40', 'dbo', ''),
(2016120045, 201612, 26, 45, '2017-02-01', 2147, 'ENERGY', 26290, 25845, '2016-12-31', '2016-11-30', '2017-02-08', 445, 198820.5520, 0.0000, 8499.0800, 207319.6320, '2017-02-01 21:20:40', 'dbo', ''),
(2016120046, 201612, 26, 46, '2017-02-01', 2148, 'ENERGY', 36121, 35022, '2016-12-31', '2016-11-30', '2017-02-08', 1099, 580964.0254, 0.0000, 20563.6900, 601527.7154, '2017-02-01 21:20:40', 'dbo', ''),
(2016120047, 201612, 26, 47, '2017-02-01', 2149, 'ENERGY', 18828, 18384, '2016-12-31', '2016-11-30', '2017-02-08', 444, 189708.8110, 0.0000, 8480.6400, 198189.4510, '2017-02-01 21:20:40', 'dbo', ''),
(2016120048, 201612, 26, 48, '2017-02-01', 2150, 'ENERGY', 3476, 2759, '2016-12-31', '2016-11-30', '2017-02-08', 717, 52259.5400, 0.0000, 13516.7900, 65776.3300, '2017-02-01 21:20:40', 'dbo', ''),
(2016120049, 201612, 26, 49, '2017-02-01', 2151, 'ENERGY', 3802, 3671, '2016-12-31', '2016-11-30', '2017-02-08', 131, 53320.1690, 0.0000, 2706.6100, 56026.7790, '2017-02-01 21:20:40', 'dbo', ''),
(2016120050, 201612, 26, 50, '2017-02-01', 2152, 'ENERGY', 60110, 57743, '2016-12-31', '2016-11-30', '2017-02-08', 2367, 769974.3992, 0.0000, 43954.9800, 813929.3792, '2017-02-01 21:20:40', 'dbo', ''),
(2016120051, 201612, 26, 51, '2017-02-01', 2153, 'ENERGY', 211, 211, '2016-12-31', '2016-11-30', '2017-02-08', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2017-02-01 21:20:40', 'dbo', ''),
(2016120052, 201612, 26, 52, '2017-02-01', 2154, 'ENERGY', 321, 321, '2016-12-31', '2016-11-30', '2017-02-08', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2017-02-01 21:20:40', 'dbo', ''),
(2016120053, 201612, 26, 53, '2017-02-01', 2155, 'ENERGY', 1628, 1547, '2016-12-31', '2016-11-30', '2017-02-08', 81, 34878.4370, 0.0000, 1784.2400, 36662.6770, '2017-02-01 21:20:40', 'dbo', ''),
(2016120054, 201612, 26, 54, '2017-02-01', 2156, 'ENERGY', 19976, 19260, '2016-12-31', '2016-11-30', '2017-02-08', 716, 103504.0094, 0.0000, 13498.3400, 117002.3494, '2017-02-01 21:20:40', 'dbo', ''),
(2016120055, 201612, 26, 55, '2017-02-01', 2157, 'ENERGY', 11280, 10829, '2016-12-31', '2016-11-30', '2017-02-08', 451, 202838.4900, 0.0000, 8609.7800, 211448.2700, '2017-02-01 21:20:40', 'dbo', ''),
(2016120056, 201612, 26, 56, '2017-02-01', 2158, 'ENERGY', 179, 149, '2016-12-31', '2016-11-30', '2017-02-08', 30, 5686.1190, 0.0000, 843.4200, 6529.5390, '2017-02-01 21:20:40', 'dbo', ''),
(2016120059, 201612, 26, 59, '2017-02-01', 2161, 'ENERGY', 128, 128, '2016-12-31', '2016-11-30', '2017-02-08', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2017-02-01 21:20:40', 'dbo', ''),
(2016120060, 201612, 26, 60, '2017-02-01', 2162, 'ENERGY', 138874, 130100, '2016-12-31', '2016-11-30', '2017-02-08', 8774, 1083056.7500, 0.0000, 162147.4500, 1245204.2000, '2017-02-01 21:20:40', 'dbo', ''),
(2016120061, 201612, 26, 61, '2017-02-01', 2163, 'ENERGY', 16, 16, '2016-12-31', '2016-11-30', '2017-02-08', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2017-02-01 21:20:40', 'dbo', ''),
(2016120062, 201612, 26, 62, '2017-02-01', 2164, 'ENERGY', 30, 30, '2016-12-31', '2016-11-30', '2017-02-08', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-02-01 21:20:40', 'dbo', ''),
(2016120063, 201612, 26, 63, '2017-02-01', 2165, 'ENERGY', 1, 1, '2016-12-31', '2016-11-30', '2017-02-08', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-02-01 21:20:40', 'dbo', ''),
(2016120064, 201612, 26, 64, '2017-02-01', 2166, 'ENERGY', 2, 2, '2016-12-31', '2016-11-30', '2017-02-08', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-02-01 21:20:40', 'dbo', '');
INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2016120065, 201612, 26, 65, '2017-02-01', 2167, 'ENERGY', 3835, 3496, '2016-12-31', '2016-11-30', '2017-02-08', 339, 67077.6280, 0.0000, 6543.6700, 73621.2980, '2017-02-01 21:20:40', 'dbo', ''),
(2016120066, 201612, 26, 66, '2017-02-01', 2168, 'ENERGY', 3429, 3232, '2016-12-31', '2016-11-30', '2017-02-08', 197, 60445.8624, 0.0000, 3924.1300, 64369.9924, '2017-02-01 21:20:40', 'dbo', ''),
(2016120067, 201612, 26, 67, '2017-02-01', 2169, 'ENERGY', 455, 413, '2016-12-31', '2016-11-30', '2017-02-08', 42, 10794.1238, 0.0000, 1064.7900, 11858.9138, '2017-02-01 21:20:40', 'dbo', ''),
(2016120068, 201612, 26, 68, '2017-02-01', 2170, 'ENERGY', 820, 750, '2016-12-31', '2016-11-30', '2017-02-08', 70, 17875.0700, 0.0000, 1581.3200, 19456.3900, '2017-02-01 21:20:40', 'dbo', ''),
(2016120069, 201612, 26, 69, '2017-02-01', 2171, 'ENERGY', 1, 1, '2016-12-31', '2016-11-30', '2017-02-08', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2017-02-01 21:20:40', 'dbo', ''),
(2016120070, 201612, 26, 70, '2017-02-01', 2172, 'ENERGY', 345, 345, '2016-12-31', '2016-11-30', '2017-02-08', 0, 11744.5000, 0.0000, 0.0000, 11744.5000, '2017-02-01 21:20:40', 'dbo', ''),
(2016120071, 201612, 26, 71, '2017-02-01', 2173, 'ENERGY', 70994, 64471, '2016-12-31', '2016-11-30', '2017-02-08', 6523, 1077459.9062, 0.0000, 120622.3600, 1198082.2662, '2017-02-01 21:20:39', 'dbo', ''),
(2016120072, 201612, 26, 72, '2017-02-01', 2174, 'ENERGY', 1033, 987, '2016-12-31', '2016-11-30', '2017-02-08', 46, 23642.7300, 0.0000, 1138.5800, 24781.3100, '2017-02-01 21:20:39', 'dbo', ''),
(2016120073, 201612, 26, 73, '2017-02-01', 2175, 'ENERGY', 387, 384, '2016-12-31', '2016-11-30', '2017-02-08', 3, 19479.6780, 0.0000, 345.3400, 19825.0180, '2017-02-01 21:20:39', 'dbo', ''),
(2016120075, 201612, 26, 75, '2017-02-01', 2176, 'ENERGY', 942, 895, '2016-12-31', '2016-11-30', '2017-02-08', 47, 20862.3300, 0.0000, 1157.0300, 22019.3600, '2017-02-01 21:20:40', 'dbo', ''),
(2016120076, 201612, 26, 76, '2017-02-01', 2177, 'ENERGY', 1034, 989, '2016-12-31', '2016-11-30', '2017-02-08', 45, 22548.3700, 0.0000, 1120.1300, 23668.5000, '2017-02-01 21:20:40', 'dbo', ''),
(2016120077, 201612, 26, 77, '2017-02-01', 2178, 'ENERGY', 860, 827, '2016-12-31', '2016-11-30', '2017-02-08', 33, 19533.3600, 0.0000, 898.7600, 20432.1200, '2017-02-01 21:20:39', 'dbo', ''),
(2016120078, 201612, 26, 78, '2017-02-01', 2179, 'ENERGY', 207, 195, '2016-12-31', '2016-11-30', '2017-02-08', 12, 8137.8200, 0.0000, 511.3700, 8649.1900, '2017-02-01 21:20:40', 'dbo', ''),
(2016120079, 201612, 26, 79, '2017-02-01', 2180, 'ENERGY', 22988, 21387, '2016-12-31', '2016-11-30', '2017-02-08', 1601, 285136.8000, 0.0000, 29824.2800, 314961.0800, '2017-02-01 21:20:40', 'dbo', ''),
(2016120080, 201612, 26, 80, '2017-02-01', 2181, 'ENERGY', 311, 311, '2016-12-31', '2016-11-30', '2017-02-08', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2017-02-01 21:20:40', 'dbo', ''),
(2016120081, 201612, 26, 81, '2017-02-01', 2182, 'ENERGY', 809, 752, '2016-12-31', '2016-11-30', '2017-02-08', 57, 14899.9200, 0.0000, 1341.5100, 16241.4300, '2017-02-01 21:20:40', 'dbo', ''),
(2016120082, 201612, 26, 82, '2017-02-01', 2183, 'ENERGY', 1254, 1120, '2016-12-31', '2016-11-30', '2017-02-08', 134, 22780.5200, 0.0000, 2761.9400, 25542.4600, '2017-02-01 21:20:40', 'dbo', ''),
(2016120083, 201612, 26, 83, '2017-02-01', 2184, 'ENERGY', 29, 25, '2016-12-31', '2016-11-30', '2017-02-08', 4, 738.1900, 0.0000, 363.7900, 1101.9800, '2017-02-01 21:20:40', 'dbo', ''),
(2016120084, 201612, 26, 84, '2017-02-01', 2185, 'ENERGY', 18, 11, '2016-12-31', '2016-11-30', '2017-02-08', 7, 487.2000, 0.0000, 419.1400, 906.3400, '2017-02-01 21:20:40', 'dbo', ''),
(2016120085, 201612, 26, 85, '2017-02-01', 2186, 'ENERGY', 0, 0, '2016-12-31', '2016-11-30', '2017-02-08', 0, 0.0000, 0.0000, 0.0000, 0.0000, '2017-02-01 21:20:40', 'dbo', ''),
(2017010001, 201701, 27, 1, '2017-02-27', 2187, 'ENERGY', 14016, 14016, '2017-02-01', '2016-12-31', '2017-03-06', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2017-02-27 07:25:40', 'dbo', ''),
(2017010002, 201701, 27, 2, '2017-02-27', 2188, 'ENERGY', 7081, 7081, '2017-02-01', '2016-12-31', '2017-03-06', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2017-02-27 07:25:40', 'dbo', ''),
(2017010003, 201701, 27, 3, '2017-02-27', 2189, 'ENERGY', 8948, 8948, '2017-02-01', '2016-12-31', '2017-03-06', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2017-02-27 07:25:40', 'dbo', ''),
(2017010004, 201701, 27, 4, '2017-02-27', 2190, 'ENERGY', 6711, 6711, '2017-02-01', '2016-12-31', '2017-03-06', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2017-02-27 07:25:40', 'dbo', ''),
(2017010005, 201701, 27, 5, '2017-02-27', 2191, 'ENERGY', 5255, 5255, '2017-02-01', '2016-12-31', '2017-03-06', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2017-02-27 07:25:40', 'dbo', ''),
(2017010006, 201701, 27, 6, '2017-02-27', 2192, 'ENERGY', 13833, 13833, '2017-02-01', '2016-12-31', '2017-03-06', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2017-02-27 07:25:40', 'dbo', ''),
(2017010007, 201701, 27, 7, '2017-02-27', 2193, 'ENERGY', 9652, 9652, '2017-02-01', '2016-12-31', '2017-03-06', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2017-02-27 07:25:40', 'dbo', ''),
(2017010008, 201701, 27, 8, '2017-02-27', 2194, 'ENERGY', 167, 167, '2017-02-01', '2016-12-31', '2017-03-06', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2017-02-27 07:25:40', 'dbo', ''),
(2017010009, 201701, 27, 9, '2017-02-27', 2195, 'ENERGY', 116, 115, '2017-02-01', '2016-12-31', '2017-03-06', 1, 8426.6064, 0.0000, 308.3000, 8734.9064, '2017-02-27 07:25:39', 'dbo', ''),
(2017010010, 201701, 27, 10, '2017-02-27', 2196, 'ENERGY', 87, 87, '2017-02-01', '2016-12-31', '2017-03-06', 0, 6435.8780, 0.0000, 0.0000, 6435.8780, '2017-02-27 07:25:40', 'dbo', ''),
(2017010011, 201701, 27, 11, '2017-02-27', 2197, 'ENERGY', 201, 201, '2017-02-01', '2016-12-31', '2017-03-06', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2017-02-27 07:25:40', 'dbo', ''),
(2017010012, 201701, 27, 12, '2017-02-27', 2198, 'ENERGY', 119, 119, '2017-02-01', '2016-12-31', '2017-03-06', 0, 7216.1700, 0.0000, 0.0000, 7216.1700, '2017-02-27 07:25:40', 'dbo', ''),
(2017010013, 201701, 27, 13, '2017-02-27', 2199, 'ENERGY', 2100, 1764, '2017-02-01', '2016-12-31', '2017-03-06', 336, 38916.0940, 0.0000, 6442.4700, 45358.5640, '2017-02-27 07:25:39', 'dbo', ''),
(2017010014, 201701, 27, 14, '2017-02-27', 2200, 'ENERGY', 803, 604, '2017-02-01', '2016-12-31', '2017-03-06', 199, 17653.4154, 0.0000, 3933.8800, 21587.2954, '2017-02-27 07:25:39', 'dbo', ''),
(2017010015, 201701, 27, 15, '2017-02-27', 2201, 'ENERGY', 162, 162, '2017-02-01', '2016-12-31', '2017-03-06', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2017-02-27 07:25:40', 'dbo', ''),
(2017010016, 201701, 27, 16, '2017-02-27', 2202, 'ENERGY', 1715, 1237, '2017-02-01', '2016-12-31', '2017-03-06', 478, 28443.6120, 0.0000, 9042.6300, 37486.2420, '2017-02-27 07:25:39', 'dbo', ''),
(2017010017, 201701, 27, 17, '2017-02-27', 2203, 'ENERGY', 4589, 3120, '2017-02-01', '2016-12-31', '2017-03-06', 1469, 58202.3370, 0.0000, 27188.7500, 85391.0870, '2017-02-27 07:25:39', 'dbo', ''),
(2017010018, 201701, 27, 18, '2017-02-27', 2204, 'ENERGY', 1704, 1355, '2017-02-01', '2016-12-31', '2017-03-06', 349, 27786.9600, 0.0000, 6680.5100, 34467.4700, '2017-02-27 07:25:39', 'dbo', ''),
(2017010019, 201701, 27, 19, '2017-02-27', 2205, 'ENERGY', 75, 75, '2017-02-01', '2016-12-31', '2017-03-06', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2017-02-27 07:25:40', 'dbo', ''),
(2017010020, 201701, 27, 20, '2017-02-27', 2206, 'ENERGY', 239, 237, '2017-02-01', '2016-12-31', '2017-03-06', 2, 5888.8730, 0.0000, 326.6200, 6215.4930, '2017-02-27 07:25:39', 'dbo', ''),
(2017010021, 201701, 27, 21, '2017-02-27', 2207, 'ENERGY', 38962, 38245, '2017-02-01', '2016-12-31', '2017-03-06', 717, 478172.6946, 0.0000, 13418.9400, 491591.6346, '2017-02-27 07:25:39', 'dbo', ''),
(2017010022, 201701, 27, 22, '2017-02-27', 2208, 'ENERGY', 22172, 21732, '2017-02-01', '2016-12-31', '2017-03-06', 440, 264250.3316, 0.0000, 8346.8100, 272597.1416, '2017-02-27 07:25:39', 'dbo', ''),
(2017010023, 201701, 27, 23, '2017-02-27', 2209, 'ENERGY', 55415, 53824, '2017-02-01', '2016-12-31', '2017-03-06', 1591, 672640.6070, 0.0000, 29422.6900, 702063.2970, '2017-02-27 07:25:39', 'dbo', ''),
(2017010024, 201701, 27, 24, '2017-02-27', 2210, 'ENERGY', 40045, 39614, '2017-02-01', '2016-12-31', '2017-03-06', 431, 463017.3600, 0.0000, 8182.0000, 471199.3600, '2017-02-27 07:25:39', 'dbo', ''),
(2017010025, 201701, 27, 25, '2017-02-27', 2211, 'ENERGY', 19955, 16252, '2017-02-01', '2016-12-31', '2017-03-06', 3703, 296907.2600, 0.0000, 68095.3700, 365002.6300, '2017-02-27 07:25:39', 'dbo', ''),
(2017010026, 201701, 27, 26, '2017-02-27', 2212, 'ENERGY', 47284, 45915, '2017-02-01', '2016-12-31', '2017-03-06', 1369, 705801.8674, 0.0000, 25357.6700, 731159.5374, '2017-02-27 07:25:39', 'dbo', ''),
(2017010029, 201701, 27, 29, '2017-02-27', 2215, 'ENERGY', 66552, 64693, '2017-02-01', '2016-12-31', '2017-03-06', 1859, 909018.4088, 0.0000, 34330.0200, 943348.4288, '2017-02-27 07:25:39', 'dbo', ''),
(2017010030, 201701, 27, 30, '2017-02-27', 2216, 'ENERGY', 32187, 31298, '2017-02-01', '2016-12-31', '2017-03-06', 889, 332020.8112, 0.0000, 16568.4200, 348589.2312, '2017-02-27 07:25:39', 'dbo', ''),
(2017010031, 201701, 27, 31, '2017-02-27', 2217, 'ENERGY', 46136, 44204, '2017-02-01', '2016-12-31', '2017-03-06', 1932, 615020.8080, 0.0000, 35666.7100, 650687.5180, '2017-02-27 07:25:39', 'dbo', ''),
(2017010032, 201701, 27, 32, '2017-02-27', 2218, 'ENERGY', 76027, 73042, '2017-02-01', '2016-12-31', '2017-03-06', 2985, 1025377.8790, 0.0000, 54948.1200, 1080325.9990, '2017-02-27 07:25:39', 'dbo', ''),
(2017010033, 201701, 27, 33, '2017-02-27', 2219, 'ENERGY', 9252, 9140, '2017-02-01', '2016-12-31', '2017-03-06', 112, 140974.7634, 0.0000, 2340.8200, 143315.5834, '2017-02-27 07:25:39', 'dbo', ''),
(2017010034, 201701, 27, 34, '2017-02-27', 2220, 'ENERGY', 6183, 5905, '2017-02-01', '2016-12-31', '2017-03-06', 278, 94613.3942, 0.0000, 5380.4500, 99993.8442, '2017-02-27 07:25:39', 'dbo', ''),
(2017010035, 201701, 27, 35, '2017-02-27', 2221, 'ENERGY', 13642, 13595, '2017-02-01', '2016-12-31', '2017-03-06', 47, 205412.6426, 0.0000, 1150.6100, 206563.2526, '2017-02-27 07:25:39', 'dbo', ''),
(2017010036, 201701, 27, 36, '2017-02-27', 2222, 'ENERGY', 29664, 28485, '2017-02-01', '2016-12-31', '2017-03-06', 1179, 447262.8438, 0.0000, 21878.5900, 469141.4338, '2017-02-27 07:25:39', 'dbo', ''),
(2017010037, 201701, 27, 37, '2017-02-27', 2223, 'ENERGY', 16653, 16089, '2017-02-01', '2016-12-31', '2017-03-06', 564, 232623.7710, 0.0000, 10617.3600, 243241.1310, '2017-02-27 07:25:39', 'dbo', ''),
(2017010038, 201701, 27, 38, '2017-02-27', 2224, 'ENERGY', 7949, 7731, '2017-02-01', '2016-12-31', '2017-03-06', 218, 119848.9134, 0.0000, 4281.7900, 124130.7034, '2017-02-27 07:25:39', 'dbo', ''),
(2017010039, 201701, 27, 39, '2017-02-27', 2225, 'ENERGY', 19519, 18729, '2017-02-01', '2016-12-31', '2017-03-06', 790, -326210.2218, 0.0000, 14755.6400, -311454.5818, '2017-02-27 07:25:39', 'dbo', ''),
(2017010040, 201701, 27, 40, '2017-02-27', 2226, 'ENERGY', 16257, 15325, '2017-02-01', '2016-12-31', '2017-03-06', 932, 234893.5996, 0.0000, 17355.7800, 252249.3796, '2017-02-27 07:25:39', 'dbo', ''),
(2017010041, 201701, 27, 41, '2017-02-27', 2227, 'ENERGY', 241, 241, '2017-02-01', '2016-12-31', '2017-03-06', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2017-02-27 07:25:40', 'dbo', ''),
(2017010042, 201701, 27, 42, '2017-02-27', 2228, 'ENERGY', 183, 183, '2017-02-01', '2016-12-31', '2017-03-06', 0, 8044.5460, 0.0000, 0.0000, 8044.5460, '2017-02-27 07:25:40', 'dbo', ''),
(2017010043, 201701, 27, 43, '2017-02-27', 2229, 'ENERGY', 48933, 47183, '2017-02-01', '2016-12-31', '2017-03-06', 1750, 560108.7302, 0.0000, 32334.1200, 592442.8502, '2017-02-27 07:25:39', 'dbo', ''),
(2017010044, 201701, 27, 44, '2017-02-27', 2230, 'ENERGY', 23947, 22120, '2017-02-01', '2016-12-31', '2017-03-06', 1827, 400522.0330, 0.0000, 33744.0700, 434266.1030, '2017-02-27 07:25:39', 'dbo', ''),
(2017010045, 201701, 27, 45, '2017-02-27', 2231, 'ENERGY', 26904, 26290, '2017-02-01', '2016-12-31', '2017-03-06', 614, 207319.6320, 0.0000, 11532.9100, 218852.5420, '2017-02-27 07:25:39', 'dbo', ''),
(2017010046, 201701, 27, 46, '2017-02-27', 2232, 'ENERGY', 37290, 36121, '2017-02-01', '2016-12-31', '2017-03-06', 1169, 601527.7154, 0.0000, 21695.4700, 623223.1854, '2017-02-27 07:25:39', 'dbo', ''),
(2017010047, 201701, 27, 47, '2017-02-27', 2233, 'ENERGY', 19290, 18828, '2017-02-01', '2016-12-31', '2017-03-06', 462, 198189.4510, 0.0000, 8749.6400, 206939.0910, '2017-02-27 07:25:39', 'dbo', ''),
(2017010048, 201701, 27, 48, '2017-02-27', 2234, 'ENERGY', 4247, 3476, '2017-02-01', '2016-12-31', '2017-03-06', 771, 65776.3300, 0.0000, 14407.7300, 80184.0600, '2017-02-27 07:25:39', 'dbo', ''),
(2017010049, 201701, 27, 49, '2017-02-27', 2235, 'ENERGY', 3931, 3802, '2017-02-01', '2016-12-31', '2017-03-06', 129, 56026.7790, 0.0000, 2652.1200, 58678.8990, '2017-02-27 07:25:39', 'dbo', ''),
(2017010050, 201701, 27, 50, '2017-02-27', 2236, 'ENERGY', 62118, 60110, '2017-02-01', '2016-12-31', '2017-03-06', 2008, 813929.3792, 0.0000, 37058.3500, 850987.7292, '2017-02-27 07:25:39', 'dbo', ''),
(2017010051, 201701, 27, 51, '2017-02-27', 2237, 'ENERGY', 211, 211, '2017-02-01', '2016-12-31', '2017-03-06', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2017-02-27 07:25:40', 'dbo', ''),
(2017010052, 201701, 27, 52, '2017-02-27', 2238, 'ENERGY', 321, 321, '2017-02-01', '2016-12-31', '2017-03-06', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2017-02-27 07:25:40', 'dbo', ''),
(2017010053, 201701, 27, 53, '2017-02-27', 2239, 'ENERGY', 1739, 1628, '2017-02-01', '2016-12-31', '2017-03-06', 111, 36662.6770, 0.0000, 2322.5100, 38985.1870, '2017-02-27 07:25:39', 'dbo', ''),
(2017010054, 201701, 27, 54, '2017-02-27', 2240, 'ENERGY', 20700, 19976, '2017-02-01', '2016-12-31', '2017-03-06', 724, 117002.3494, 0.0000, 13547.1100, 130549.4594, '2017-02-27 07:25:39', 'dbo', ''),
(2017010055, 201701, 27, 55, '2017-02-27', 2241, 'ENERGY', 11681, 11280, '2017-02-01', '2016-12-31', '2017-03-06', 401, 211448.2700, 0.0000, 7632.6800, 219080.9500, '2017-02-27 07:25:39', 'dbo', ''),
(2017010056, 201701, 27, 56, '2017-02-27', 2242, 'ENERGY', 203, 179, '2017-02-01', '2016-12-31', '2017-03-06', 24, 6529.5390, 0.0000, 729.4500, 7258.9890, '2017-02-27 07:25:39', 'dbo', ''),
(2017010059, 201701, 27, 59, '2017-02-27', 2245, 'ENERGY', 128, 128, '2017-02-01', '2016-12-31', '2017-03-06', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2017-02-27 07:25:40', 'dbo', ''),
(2017010060, 201701, 27, 60, '2017-02-27', 2246, 'ENERGY', 145742, 138874, '2017-02-01', '2016-12-31', '2017-03-06', 6868, 1245204.2000, 0.0000, 126049.4800, 1371253.6800, '2017-02-27 07:25:39', 'dbo', ''),
(2017010061, 201701, 27, 61, '2017-02-27', 2247, 'ENERGY', 16, 16, '2017-02-01', '2016-12-31', '2017-03-06', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2017-02-27 07:25:40', 'dbo', ''),
(2017010062, 201701, 27, 62, '2017-02-27', 2248, 'ENERGY', 30, 30, '2017-02-01', '2016-12-31', '2017-03-06', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-02-27 07:25:40', 'dbo', ''),
(2017010063, 201701, 27, 63, '2017-02-27', 2249, 'ENERGY', 1, 1, '2017-02-01', '2016-12-31', '2017-03-06', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-02-27 07:25:40', 'dbo', ''),
(2017010064, 201701, 27, 64, '2017-02-27', 2250, 'ENERGY', 2, 2, '2017-02-01', '2016-12-31', '2017-03-06', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-02-27 07:25:40', 'dbo', ''),
(2017010065, 201701, 27, 65, '2017-02-27', 2251, 'ENERGY', 4147, 3835, '2017-02-01', '2016-12-31', '2017-03-06', 312, 73621.2980, 0.0000, 6003.0100, 79624.3080, '2017-02-27 07:25:39', 'dbo', ''),
(2017010066, 201701, 27, 66, '2017-02-27', 2252, 'ENERGY', 3678, 3429, '2017-02-01', '2016-12-31', '2017-03-06', 249, 64369.9924, 0.0000, 4849.4300, 69219.4224, '2017-02-27 07:25:39', 'dbo', ''),
(2017010067, 201701, 27, 67, '2017-02-27', 2253, 'ENERGY', 485, 455, '2017-02-01', '2016-12-31', '2017-03-06', 30, 11858.9138, 0.0000, 839.3200, 12698.2338, '2017-02-27 07:25:39', 'dbo', ''),
(2017010068, 201701, 27, 68, '2017-02-27', 2254, 'ENERGY', 891, 820, '2017-02-01', '2016-12-31', '2017-03-06', 71, 19456.3900, 0.0000, 1590.0800, 21046.4700, '2017-02-27 07:25:39', 'dbo', ''),
(2017010069, 201701, 27, 69, '2017-02-27', 2255, 'ENERGY', 1, 1, '2017-02-01', '2016-12-31', '2017-03-06', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2017-02-27 07:25:40', 'dbo', ''),
(2017010070, 201701, 27, 70, '2017-02-27', 2256, 'ENERGY', 345, 345, '2017-02-01', '2016-12-31', '2017-03-06', 0, 11744.5000, 0.0000, 0.0000, 11744.5000, '2017-02-27 07:25:40', 'dbo', ''),
(2017010071, 201701, 27, 71, '2017-02-27', 2257, 'ENERGY', 77543, 70994, '2017-02-01', '2016-12-31', '2017-03-06', 6549, 1198082.2662, 0.0000, 120208.2800, 1318290.5462, '2017-02-27 07:25:39', 'dbo', ''),
(2017010072, 201701, 27, 72, '2017-02-27', 2258, 'ENERGY', 1067, 1033, '2017-02-01', '2016-12-31', '2017-03-06', 34, 24781.3100, 0.0000, 912.5700, 25693.8800, '2017-02-27 07:25:39', 'dbo', ''),
(2017010073, 201701, 27, 73, '2017-02-27', 2259, 'ENERGY', 389, 387, '2017-02-01', '2016-12-31', '2017-03-06', 2, 19825.0180, 0.0000, 326.6200, 20151.6380, '2017-02-27 07:25:39', 'dbo', ''),
(2017010075, 201701, 27, 75, '2017-02-27', 2260, 'ENERGY', 979, 942, '2017-02-01', '2016-12-31', '2017-03-06', 37, 22019.3600, 0.0000, 967.5100, 22986.8700, '2017-02-27 07:25:39', 'dbo', ''),
(2017010076, 201701, 27, 76, '2017-02-27', 2261, 'ENERGY', 1069, 1034, '2017-02-01', '2016-12-31', '2017-03-06', 35, 23668.5000, 0.0000, 930.8800, 24599.3800, '2017-02-27 07:25:39', 'dbo', ''),
(2017010077, 201701, 27, 77, '2017-02-27', 2262, 'ENERGY', 886, 860, '2017-02-01', '2016-12-31', '2017-03-06', 26, 20432.1200, 0.0000, 766.0800, 21198.2000, '2017-02-27 07:25:39', 'dbo', ''),
(2017010078, 201701, 27, 78, '2017-02-27', 2263, 'ENERGY', 217, 207, '2017-02-01', '2016-12-31', '2017-03-06', 10, 8649.1900, 0.0000, 473.1100, 9122.3000, '2017-02-27 07:25:39', 'dbo', ''),
(2017010079, 201701, 27, 79, '2017-02-27', 2264, 'ENERGY', 24300, 22988, '2017-02-01', '2016-12-31', '2017-03-06', 1312, 314961.0800, 0.0000, 24313.9300, 339275.0100, '2017-02-27 07:25:39', 'dbo', ''),
(2017010080, 201701, 27, 80, '2017-02-27', 2265, 'ENERGY', 311, 311, '2017-02-01', '2016-12-31', '2017-03-06', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2017-02-27 07:25:40', 'dbo', ''),
(2017010081, 201701, 27, 81, '2017-02-27', 2266, 'ENERGY', 854, 809, '2017-02-01', '2016-12-31', '2017-03-06', 45, 16241.4300, 0.0000, 1113.9800, 17355.4100, '2017-02-27 07:25:39', 'dbo', ''),
(2017010082, 201701, 27, 82, '2017-02-27', 2267, 'ENERGY', 1361, 1254, '2017-02-01', '2016-12-31', '2017-03-06', 107, 25542.4600, 0.0000, 2249.2700, 27791.7300, '2017-02-27 07:25:39', 'dbo', ''),
(2017010083, 201701, 27, 83, '2017-02-27', 2268, 'ENERGY', 32, 29, '2017-02-01', '2016-12-31', '2017-03-06', 3, 1101.9800, 0.0000, 344.9200, 1446.9000, '2017-02-27 07:25:39', 'dbo', ''),
(2017010084, 201701, 27, 84, '2017-02-27', 2269, 'ENERGY', 20, 18, '2017-02-01', '2016-12-31', '2017-03-06', 2, 906.3400, 0.0000, 326.6200, 1232.9600, '2017-02-27 07:25:39', 'dbo', ''),
(2017010085, 201701, 27, 85, '2017-02-27', 2270, 'ENERGY', 0, 0, '2017-02-01', '2016-12-31', '2017-03-06', 0, 0.0000, 0.0000, 0.0000, 0.0000, '2017-02-27 07:25:40', 'dbo', ''),
(2017010086, 201701, 27, 86, '2017-02-27', 2271, 'ENERGY', 21, 0, '2017-02-01', '2016-12-31', '2017-03-06', 21, 0.0000, 0.0000, 674.5300, 674.5300, '2017-02-27 07:25:39', 'dbo', ''),
(2017020001, 201702, 28, 1, '2017-04-03', 2272, 'ENERGY', 14016, 14016, '2017-03-01', '2017-02-01', '2017-04-10', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2017-04-03 07:34:16', 'dbo', ''),
(2017020002, 201702, 28, 2, '2017-04-03', 2273, 'ENERGY', 7081, 7081, '2017-03-01', '2017-02-01', '2017-04-10', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2017-04-03 07:34:16', 'dbo', ''),
(2017020003, 201702, 28, 3, '2017-04-03', 2274, 'ENERGY', 8948, 8948, '2017-03-01', '2017-02-01', '2017-04-10', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2017-04-03 07:34:16', 'dbo', ''),
(2017020004, 201702, 28, 4, '2017-04-03', 2275, 'ENERGY', 6711, 6711, '2017-03-01', '2017-02-01', '2017-04-10', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2017-04-03 07:34:16', 'dbo', ''),
(2017020005, 201702, 28, 5, '2017-04-03', 2276, 'ENERGY', 5255, 5255, '2017-03-01', '2017-02-01', '2017-04-10', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2017-04-03 07:34:16', 'dbo', ''),
(2017020006, 201702, 28, 6, '2017-04-03', 2277, 'ENERGY', 13833, 13833, '2017-03-01', '2017-02-01', '2017-04-10', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2017-04-03 07:34:16', 'dbo', ''),
(2017020007, 201702, 28, 7, '2017-04-03', 2278, 'ENERGY', 9652, 9652, '2017-03-01', '2017-02-01', '2017-04-10', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2017-04-03 07:34:16', 'dbo', ''),
(2017020008, 201702, 28, 8, '2017-04-03', 2279, 'ENERGY', 167, 167, '2017-03-01', '2017-02-01', '2017-04-10', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2017-04-03 07:34:16', 'dbo', ''),
(2017020009, 201702, 28, 9, '2017-04-03', 2280, 'ENERGY', 119, 116, '2017-03-01', '2017-02-01', '2017-04-10', 3, 8734.9064, 0.0000, 347.0000, 9081.9064, '2017-04-03 07:34:15', 'dbo', ''),
(2017020010, 201702, 28, 10, '2017-04-03', 2281, 'ENERGY', 87, 87, '2017-03-01', '2017-02-01', '2017-04-10', 0, 6435.8780, 0.0000, 0.0000, 6435.8780, '2017-04-03 07:34:16', 'dbo', ''),
(2017020011, 201702, 28, 11, '2017-04-03', 2282, 'ENERGY', 201, 201, '2017-03-01', '2017-02-01', '2017-04-10', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2017-04-03 07:34:16', 'dbo', ''),
(2017020012, 201702, 28, 12, '2017-04-03', 2283, 'ENERGY', 124, 119, '2017-03-01', '2017-02-01', '2017-04-10', 5, 7216.1700, 0.0000, 385.0200, 7601.1900, '2017-04-03 07:34:15', 'dbo', ''),
(2017020013, 201702, 28, 13, '2017-04-03', 2284, 'ENERGY', 2521, 2100, '2017-03-01', '2017-02-01', '2017-04-10', 421, 45358.5640, 0.0000, 8289.5400, 53648.1040, '2017-04-03 07:34:15', 'dbo', ''),
(2017020014, 201702, 28, 14, '2017-04-03', 2285, 'ENERGY', 1056, 803, '2017-03-01', '2017-02-01', '2017-04-10', 253, 21587.2954, 0.0000, 5097.3300, 26684.6254, '2017-04-03 07:34:15', 'dbo', ''),
(2017020015, 201702, 28, 15, '2017-04-03', 2286, 'ENERGY', 162, 162, '2017-03-01', '2017-02-01', '2017-04-10', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2017-04-03 07:34:16', 'dbo', ''),
(2017020016, 201702, 28, 16, '2017-04-03', 2287, 'ENERGY', 2244, 1715, '2017-03-01', '2017-02-01', '2017-04-10', 529, 37486.2420, 0.0000, 10341.6700, 47827.9120, '2017-04-03 07:34:15', 'dbo', ''),
(2017020017, 201702, 28, 17, '2017-04-03', 2288, 'ENERGY', 5583, 4589, '2017-03-01', '2017-02-01', '2017-04-10', 994, 85391.0870, 0.0000, 19177.2800, 104568.3670, '2017-04-03 07:34:15', 'dbo', ''),
(2017020018, 201702, 28, 18, '2017-04-03', 2289, 'ENERGY', 2149, 1704, '2017-03-01', '2017-02-01', '2017-04-10', 445, 34467.4700, 0.0000, 8745.5800, 43213.0500, '2017-04-03 07:34:15', 'dbo', ''),
(2017020019, 201702, 28, 19, '2017-04-03', 2290, 'ENERGY', 75, 75, '2017-03-01', '2017-02-01', '2017-04-10', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2017-04-03 07:34:16', 'dbo', ''),
(2017020020, 201702, 28, 20, '2017-04-03', 2291, 'ENERGY', 239, 239, '2017-03-01', '2017-02-01', '2017-04-10', 0, 6215.4930, 0.0000, 0.0000, 6215.4930, '2017-04-03 07:34:16', 'dbo', ''),
(2017020021, 201702, 28, 21, '2017-04-03', 2292, 'ENERGY', 39662, 38962, '2017-03-01', '2017-02-01', '2017-04-10', 700, 491591.6346, 0.0000, 13590.8900, 505182.5246, '2017-04-03 07:34:15', 'dbo', ''),
(2017020022, 201702, 28, 22, '2017-04-03', 2293, 'ENERGY', 22519, 22172, '2017-03-01', '2017-02-01', '2017-04-10', 347, 272597.1416, 0.0000, 6883.4400, 279480.5816, '2017-04-03 07:34:15', 'dbo', ''),
(2017020023, 201702, 28, 23, '2017-04-03', 2294, 'ENERGY', 56998, 55415, '2017-03-01', '2017-02-01', '2017-04-10', 1583, 702063.2970, 0.0000, 30369.0300, 732432.3270, '2017-04-03 07:34:15', 'dbo', ''),
(2017020024, 201702, 28, 24, '2017-04-03', 2295, 'ENERGY', 40469, 40045, '2017-03-01', '2017-02-01', '2017-04-10', 424, 471199.3600, 0.0000, 8346.5500, 479545.9100, '2017-04-03 07:34:15', 'dbo', ''),
(2017020025, 201702, 28, 25, '2017-04-03', 2296, 'ENERGY', 23968, 19955, '2017-03-01', '2017-02-01', '2017-04-10', 4013, 365002.6300, 0.0000, 76542.1600, 441544.7900, '2017-04-03 07:34:15', 'dbo', ''),
(2017020026, 201702, 28, 26, '2017-04-03', 2297, 'ENERGY', 48749, 47284, '2017-03-01', '2017-02-01', '2017-04-10', 1465, 731159.5374, 0.0000, 28126.8900, 759286.4274, '2017-04-03 07:34:15', 'dbo', ''),
(2017020029, 201702, 28, 29, '2017-04-03', 2300, 'ENERGY', 68554, 66552, '2017-03-01', '2017-02-01', '2017-04-10', 2002, 943348.4288, 0.0000, 38330.5700, 981678.9988, '2017-04-03 07:34:15', 'dbo', ''),
(2017020030, 201702, 28, 30, '2017-04-03', 2301, 'ENERGY', 33180, 32187, '2017-03-01', '2017-02-01', '2017-04-10', 993, 348589.2312, 0.0000, 19158.2800, 367747.5112, '2017-04-03 07:34:15', 'dbo', ''),
(2017020031, 201702, 28, 31, '2017-04-03', 2302, 'ENERGY', 48271, 46136, '2017-03-01', '2017-02-01', '2017-04-10', 2135, 650687.5180, 0.0000, 40857.7500, 691545.2680, '2017-04-03 07:34:15', 'dbo', ''),
(2017020032, 201702, 28, 32, '2017-04-03', 2303, 'ENERGY', 79114, 76027, '2017-03-01', '2017-02-01', '2017-04-10', 3087, 1080325.9990, 0.0000, 58946.9700, 1139272.9690, '2017-04-03 07:34:15', 'dbo', ''),
(2017020033, 201702, 28, 33, '2017-04-03', 2304, 'ENERGY', 9377, 9252, '2017-03-01', '2017-02-01', '2017-04-10', 125, 143315.5834, 0.0000, 2665.1700, 145980.7534, '2017-04-03 07:34:15', 'dbo', ''),
(2017020034, 201702, 28, 34, '2017-04-03', 2305, 'ENERGY', 6523, 6183, '2017-03-01', '2017-02-01', '2017-04-10', 340, 99993.8442, 0.0000, 6750.4400, 106744.2842, '2017-04-03 07:34:15', 'dbo', ''),
(2017020035, 201702, 28, 35, '2017-04-03', 2306, 'ENERGY', 13974, 13642, '2017-03-01', '2017-02-01', '2017-04-10', 332, 206563.2526, 0.0000, 6598.4200, 213161.6726, '2017-04-03 07:34:15', 'dbo', ''),
(2017020036, 201702, 28, 36, '2017-04-03', 2307, 'ENERGY', 30949, 29664, '2017-03-01', '2017-02-01', '2017-04-10', 1285, 469141.4338, 0.0000, 24706.6500, 493848.0838, '2017-04-03 07:34:15', 'dbo', ''),
(2017020037, 201702, 28, 37, '2017-04-03', 2308, 'ENERGY', 17230, 16653, '2017-03-01', '2017-02-01', '2017-04-10', 577, 243241.1310, 0.0000, 11253.7400, 254494.8710, '2017-04-03 07:34:15', 'dbo', ''),
(2017020038, 201702, 28, 38, '2017-04-03', 2309, 'ENERGY', 8193, 7949, '2017-03-01', '2017-02-01', '2017-04-10', 244, 124130.7034, 0.0000, 4926.3200, 129057.0234, '2017-04-03 07:34:15', 'dbo', ''),
(2017020039, 201702, 28, 39, '2017-04-03', 2310, 'ENERGY', 21196, 19519, '2017-03-01', '2017-02-01', '2017-04-10', 1677, -311454.5818, 0.0000, 32155.1600, -279299.4218, '2017-04-03 07:34:15', 'dbo', ''),
(2017020040, 201702, 28, 40, '2017-04-03', 2311, 'ENERGY', 17569, 16257, '2017-03-01', '2017-02-01', '2017-04-10', 1312, 252249.3796, 0.0000, 25219.6800, 277469.0596, '2017-04-03 07:34:15', 'dbo', ''),
(2017020041, 201702, 28, 41, '2017-04-03', 2312, 'ENERGY', 241, 241, '2017-03-01', '2017-02-01', '2017-04-10', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2017-04-03 07:34:16', 'dbo', ''),
(2017020042, 201702, 28, 42, '2017-04-03', 2313, 'ENERGY', 183, 183, '2017-03-01', '2017-02-01', '2017-04-10', 0, 8044.5460, 0.0000, 0.0000, 8044.5460, '2017-04-03 07:34:16', 'dbo', ''),
(2017020043, 201702, 28, 43, '2017-04-03', 2314, 'ENERGY', 51009, 48933, '2017-03-01', '2017-02-01', '2017-04-10', 2076, 592442.8502, 0.0000, 39736.6600, 632179.5102, '2017-04-03 07:34:15', 'dbo', ''),
(2017020044, 201702, 28, 44, '2017-04-03', 2315, 'ENERGY', 25556, 23947, '2017-03-01', '2017-02-01', '2017-04-10', 1609, 434266.1030, 0.0000, 30863.0700, 465129.1730, '2017-04-03 07:34:15', 'dbo', ''),
(2017020045, 201702, 28, 45, '2017-04-03', 2316, 'ENERGY', 27573, 26904, '2017-03-01', '2017-02-01', '2017-04-10', 669, 218852.5420, 0.0000, 13001.8600, 231854.4020, '2017-04-03 07:34:15', 'dbo', ''),
(2017020046, 201702, 28, 46, '2017-04-03', 2317, 'ENERGY', 38502, 37290, '2017-03-01', '2017-02-01', '2017-04-10', 1212, 623223.1854, 0.0000, 23319.5500, 646542.7354, '2017-04-03 07:34:15', 'dbo', ''),
(2017020047, 201702, 28, 47, '2017-04-03', 2318, 'ENERGY', 19797, 19290, '2017-03-01', '2017-02-01', '2017-04-10', 507, 206939.0910, 0.0000, 9923.6500, 216862.7410, '2017-04-03 07:34:15', 'dbo', ''),
(2017020048, 201702, 28, 48, '2017-04-03', 2319, 'ENERGY', 5087, 4247, '2017-03-01', '2017-02-01', '2017-04-10', 840, 80184.0600, 0.0000, 16251.0800, 96435.1400, '2017-04-03 07:34:15', 'dbo', ''),
(2017020049, 201702, 28, 49, '2017-04-03', 2320, 'ENERGY', 4121, 3931, '2017-03-01', '2017-02-01', '2017-04-10', 190, 58678.8990, 0.0000, 3900.2500, 62579.1490, '2017-04-03 07:34:15', 'dbo', ''),
(2017020050, 201702, 28, 50, '2017-04-03', 2321, 'ENERGY', 64342, 62118, '2017-03-01', '2017-02-01', '2017-04-10', 2224, 850987.7292, 0.0000, 42548.8600, 893536.5892, '2017-04-03 07:34:15', 'dbo', ''),
(2017020051, 201702, 28, 51, '2017-04-03', 2322, 'ENERGY', 211, 211, '2017-03-01', '2017-02-01', '2017-04-10', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2017-04-03 07:34:16', 'dbo', ''),
(2017020052, 201702, 28, 52, '2017-04-03', 2323, 'ENERGY', 321, 321, '2017-03-01', '2017-02-01', '2017-04-10', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2017-04-03 07:34:16', 'dbo', ''),
(2017020053, 201702, 28, 53, '2017-04-03', 2324, 'ENERGY', 1776, 1739, '2017-03-01', '2017-02-01', '2017-04-10', 37, 38985.1870, 0.0000, 993.0400, 39978.2270, '2017-04-03 07:34:15', 'dbo', ''),
(2017020054, 201702, 28, 54, '2017-04-03', 2325, 'ENERGY', 21508, 20700, '2017-03-01', '2017-02-01', '2017-04-10', 808, 130549.4594, 0.0000, 15643.0500, 146192.5094, '2017-04-03 07:34:15', 'dbo', ''),
(2017020055, 201702, 28, 55, '2017-04-03', 2326, 'ENERGY', 11963, 11681, '2017-03-01', '2017-02-01', '2017-04-10', 282, 219080.9500, 0.0000, 5648.3500, 224729.3000, '2017-04-03 07:34:15', 'dbo', ''),
(2017020056, 201702, 28, 56, '2017-04-03', 2327, 'ENERGY', 228, 203, '2017-03-01', '2017-02-01', '2017-04-10', 25, 7258.9890, 0.0000, 765.0300, 8024.0190, '2017-04-03 07:34:15', 'dbo', ''),
(2017020059, 201702, 28, 59, '2017-04-03', 2330, 'ENERGY', 128, 128, '2017-03-01', '2017-02-01', '2017-04-10', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2017-04-03 07:34:16', 'dbo', ''),
(2017020060, 201702, 28, 60, '2017-04-03', 2331, 'ENERGY', 153107, 145742, '2017-03-01', '2017-02-01', '2017-04-10', 7365, 1371253.6800, 0.0000, 140234.4700, 1511488.1500, '2017-04-03 07:34:15', 'dbo', ''),
(2017020061, 201702, 28, 61, '2017-04-03', 2332, 'ENERGY', 16, 16, '2017-03-01', '2017-02-01', '2017-04-10', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2017-04-03 07:34:16', 'dbo', ''),
(2017020062, 201702, 28, 62, '2017-04-03', 2333, 'ENERGY', 30, 30, '2017-03-01', '2017-02-01', '2017-04-10', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-04-03 07:34:16', 'dbo', ''),
(2017020063, 201702, 28, 63, '2017-04-03', 2334, 'ENERGY', 1, 1, '2017-03-01', '2017-02-01', '2017-04-10', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-04-03 07:34:16', 'dbo', ''),
(2017020064, 201702, 28, 64, '2017-04-03', 2335, 'ENERGY', 2, 2, '2017-03-01', '2017-02-01', '2017-04-10', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-04-03 07:34:16', 'dbo', ''),
(2017020065, 201702, 28, 65, '2017-04-03', 2336, 'ENERGY', 4532, 4147, '2017-03-01', '2017-02-01', '2017-04-10', 385, 79624.3080, 0.0000, 7605.5000, 87229.8080, '2017-04-03 07:34:15', 'dbo', ''),
(2017020066, 201702, 28, 66, '2017-04-03', 2337, 'ENERGY', 3932, 3678, '2017-03-01', '2017-02-01', '2017-04-10', 254, 69219.4224, 0.0000, 5116.3300, 74335.7524, '2017-04-03 07:34:15', 'dbo', ''),
(2017020067, 201702, 28, 67, '2017-04-03', 2338, 'ENERGY', 513, 485, '2017-03-01', '2017-02-01', '2017-04-10', 28, 12698.2338, 0.0000, 822.0400, 13520.2738, '2017-04-03 07:34:15', 'dbo', ''),
(2017020068, 201702, 28, 68, '2017-04-03', 2339, 'ENERGY', 968, 891, '2017-03-01', '2017-02-01', '2017-04-10', 77, 21046.4700, 0.0000, 1753.1000, 22799.5700, '2017-04-03 07:34:15', 'dbo', ''),
(2017020069, 201702, 28, 69, '2017-04-03', 2340, 'ENERGY', 1, 1, '2017-03-01', '2017-02-01', '2017-04-10', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2017-04-03 07:34:16', 'dbo', ''),
(2017020070, 201702, 28, 70, '2017-04-03', 2341, 'ENERGY', 345, 345, '2017-03-01', '2017-02-01', '2017-04-10', 0, 11744.5000, 0.0000, 0.0000, 11744.5000, '2017-04-03 07:34:16', 'dbo', ''),
(2017020071, 201702, 28, 71, '2017-04-03', 2342, 'ENERGY', 84727, 77543, '2017-03-01', '2017-02-01', '2017-04-10', 7184, 1318290.5462, 0.0000, 136795.2300, 1455085.7762, '2017-04-03 07:34:15', 'dbo', ''),
(2017020072, 201702, 28, 72, '2017-04-03', 2343, 'ENERGY', 1096, 1067, '2017-03-01', '2017-02-01', '2017-04-10', 29, 25693.8800, 0.0000, 841.0400, 26534.9200, '2017-04-03 07:34:15', 'dbo', ''),
(2017020073, 201702, 28, 73, '2017-04-03', 2344, 'ENERGY', 394, 389, '2017-03-01', '2017-02-01', '2017-04-10', 5, 20151.6380, 0.0000, 385.0200, 20536.6580, '2017-04-03 07:34:15', 'dbo', ''),
(2017020075, 201702, 28, 75, '2017-04-03', 2345, 'ENERGY', 1019, 979, '2017-03-01', '2017-02-01', '2017-04-10', 40, 22986.8700, 0.0000, 1050.0500, 24036.9200, '2017-04-03 07:34:15', 'dbo', ''),
(2017020076, 201702, 28, 76, '2017-04-03', 2346, 'ENERGY', 1107, 1069, '2017-03-01', '2017-02-01', '2017-04-10', 38, 24599.3800, 0.0000, 1012.0600, 25611.4400, '2017-04-03 07:34:15', 'dbo', ''),
(2017020077, 201702, 28, 77, '2017-04-03', 2347, 'ENERGY', 914, 886, '2017-03-01', '2017-02-01', '2017-04-10', 28, 21198.2000, 0.0000, 822.0400, 22020.2400, '2017-04-03 07:34:15', 'dbo', ''),
(2017020078, 201702, 28, 78, '2017-04-03', 2348, 'ENERGY', 227, 217, '2017-03-01', '2017-02-01', '2017-04-10', 10, 9122.3000, 0.0000, 480.0100, 9602.3100, '2017-04-03 07:34:15', 'dbo', ''),
(2017020079, 201702, 28, 79, '2017-04-03', 2349, 'ENERGY', 25722, 24300, '2017-03-01', '2017-02-01', '2017-04-10', 1422, 339275.0100, 0.0000, 27309.8200, 366584.8300, '2017-04-03 07:34:15', 'dbo', ''),
(2017020080, 201702, 28, 80, '2017-04-03', 2350, 'ENERGY', 311, 311, '2017-03-01', '2017-02-01', '2017-04-10', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2017-04-03 07:34:16', 'dbo', ''),
(2017020081, 201702, 28, 81, '2017-04-03', 2351, 'ENERGY', 903, 854, '2017-03-01', '2017-02-01', '2017-04-10', 49, 17355.4100, 0.0000, 1221.0600, 18576.4700, '2017-04-03 07:34:15', 'dbo', ''),
(2017020082, 201702, 28, 82, '2017-04-03', 2352, 'ENERGY', 1475, 1361, '2017-03-01', '2017-02-01', '2017-04-10', 114, 27791.7300, 0.0000, 2456.1500, 30247.8800, '2017-04-03 07:34:15', 'dbo', ''),
(2017020083, 201702, 28, 83, '2017-04-03', 2353, 'ENERGY', 35, 32, '2017-03-01', '2017-02-01', '2017-04-10', 3, 1446.9000, 0.0000, 347.0000, 1793.9000, '2017-04-03 07:34:15', 'dbo', ''),
(2017020084, 201702, 28, 84, '2017-04-03', 2354, 'ENERGY', 21, 20, '2017-03-01', '2017-02-01', '2017-04-10', 1, 1232.9600, 0.0000, 309.0000, 1541.9600, '2017-04-03 07:34:15', 'dbo', ''),
(2017020085, 201702, 28, 85, '2017-04-03', 2355, 'ENERGY', 0, 0, '2017-03-01', '2017-02-01', '2017-04-10', 0, 0.0000, 0.0000, 0.0000, 0.0000, '2017-04-03 07:34:16', 'dbo', ''),
(2017020086, 201702, 28, 86, '2017-04-03', 2356, 'ENERGY', 25, 21, '2017-03-01', '2017-02-01', '2017-04-10', 4, 674.5300, 0.0000, 366.0000, 1040.5300, '2017-04-03 07:34:15', 'dbo', ''),
(2017030001, 201703, 29, 1, '2017-04-25', 2357, 'ENERGY', 14016, 14016, '2017-04-01', '2017-03-01', '2017-05-02', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2017-04-25 12:32:04', 'dbo', ''),
(2017030002, 201703, 29, 2, '2017-04-25', 2358, 'ENERGY', 7081, 7081, '2017-04-01', '2017-03-01', '2017-05-02', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2017-04-25 12:32:04', 'dbo', ''),
(2017030003, 201703, 29, 3, '2017-04-25', 2359, 'ENERGY', 8948, 8948, '2017-04-01', '2017-03-01', '2017-05-02', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2017-04-25 12:32:04', 'dbo', ''),
(2017030004, 201703, 29, 4, '2017-04-25', 2360, 'ENERGY', 6711, 6711, '2017-04-01', '2017-03-01', '2017-05-02', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2017-04-25 12:32:04', 'dbo', ''),
(2017030005, 201703, 29, 5, '2017-04-25', 2361, 'ENERGY', 5255, 5255, '2017-04-01', '2017-03-01', '2017-05-02', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2017-04-25 12:32:04', 'dbo', ''),
(2017030006, 201703, 29, 6, '2017-04-25', 2362, 'ENERGY', 13833, 13833, '2017-04-01', '2017-03-01', '2017-05-02', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2017-04-25 12:32:04', 'dbo', ''),
(2017030007, 201703, 29, 7, '2017-04-25', 2363, 'ENERGY', 9652, 9652, '2017-04-01', '2017-03-01', '2017-05-02', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2017-04-25 12:32:04', 'dbo', ''),
(2017030008, 201703, 29, 8, '2017-04-25', 2364, 'ENERGY', 167, 167, '2017-04-01', '2017-03-01', '2017-05-02', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2017-04-25 12:32:04', 'dbo', ''),
(2017030009, 201703, 29, 9, '2017-04-25', 2365, 'ENERGY', 122, 119, '2017-04-01', '2017-03-01', '2017-05-02', 3, 9081.9064, 0.0000, 345.3000, 9427.2064, '2017-04-25 12:32:03', 'dbo', ''),
(2017030010, 201703, 29, 10, '2017-04-25', 2366, 'ENERGY', 87, 87, '2017-04-01', '2017-03-01', '2017-05-02', 0, 6435.8780, 0.0000, 0.0000, 6435.8780, '2017-04-25 12:32:04', 'dbo', ''),
(2017030011, 201703, 29, 11, '2017-04-25', 2367, 'ENERGY', 201, 201, '2017-04-01', '2017-03-01', '2017-05-02', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2017-04-25 12:32:04', 'dbo', ''),
(2017030012, 201703, 29, 12, '2017-04-25', 2368, 'ENERGY', 125, 124, '2017-04-01', '2017-03-01', '2017-05-02', 1, 7601.1900, 0.0000, 308.4300, 7909.6200, '2017-04-25 12:32:03', 'dbo', ''),
(2017030013, 201703, 29, 13, '2017-04-25', 2369, 'ENERGY', 3001, 2521, '2017-04-01', '2017-03-01', '2017-05-02', 480, 53648.1040, 0.0000, 9137.2600, 62785.3640, '2017-04-25 12:32:03', 'dbo', ''),
(2017030014, 201703, 29, 14, '2017-04-25', 2370, 'ENERGY', 1330, 1056, '2017-04-01', '2017-03-01', '2017-05-02', 274, 26684.6254, 0.0000, 5340.3100, 32024.9354, '2017-04-25 12:32:03', 'dbo', ''),
(2017030015, 201703, 29, 15, '2017-04-25', 2371, 'ENERGY', 162, 162, '2017-04-01', '2017-03-01', '2017-05-02', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2017-04-25 12:32:04', 'dbo', ''),
(2017030016, 201703, 29, 16, '2017-04-25', 2372, 'ENERGY', 2779, 2244, '2017-04-01', '2017-03-01', '2017-05-02', 535, 47827.9120, 0.0000, 10151.0100, 57978.9220, '2017-04-25 12:32:03', 'dbo', ''),
(2017030017, 201703, 29, 17, '2017-04-25', 2373, 'ENERGY', 7091, 5583, '2017-04-01', '2017-03-01', '2017-05-02', 1508, 104568.3670, 0.0000, 28085.1600, 132653.5270, '2017-04-25 12:32:03', 'dbo', ''),
(2017030018, 201703, 29, 18, '2017-04-25', 2374, 'ENERGY', 2837, 2149, '2017-04-01', '2017-03-01', '2017-05-02', 688, 43213.0500, 0.0000, 12971.0800, 56184.1300, '2017-04-25 12:32:03', 'dbo', ''),
(2017030019, 201703, 29, 19, '2017-04-25', 2375, 'ENERGY', 75, 75, '2017-04-01', '2017-03-01', '2017-05-02', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2017-04-25 12:32:04', 'dbo', ''),
(2017030020, 201703, 29, 20, '2017-04-25', 2376, 'ENERGY', 239, 239, '2017-04-01', '2017-03-01', '2017-05-02', 0, 6215.4930, 0.0000, 0.0000, 6215.4930, '2017-04-25 12:32:04', 'dbo', ''),
(2017030021, 201703, 29, 21, '2017-04-25', 2377, 'ENERGY', 40264, 39662, '2017-04-01', '2017-03-01', '2017-05-02', 602, 505182.5246, 0.0000, 11385.9400, 516568.4646, '2017-04-25 12:32:03', 'dbo', ''),
(2017030022, 201703, 29, 22, '2017-04-25', 2378, 'ENERGY', 22845, 22519, '2017-04-01', '2017-03-01', '2017-05-02', 326, 279480.5816, 0.0000, 6298.7700, 285779.3516, '2017-04-25 12:32:03', 'dbo', ''),
(2017030023, 201703, 29, 23, '2017-04-25', 2379, 'ENERGY', 58596, 56998, '2017-04-01', '2017-03-01', '2017-05-02', 1598, 732432.3270, 0.0000, 29744.0200, 762176.3470, '2017-04-25 12:32:03', 'dbo', ''),
(2017030024, 201703, 29, 24, '2017-04-25', 2380, 'ENERGY', 40881, 40469, '2017-04-01', '2017-03-01', '2017-05-02', 412, 479545.9100, 0.0000, 7883.9000, 487429.8100, '2017-04-25 12:32:03', 'dbo', ''),
(2017030025, 201703, 29, 25, '2017-04-25', 2381, 'ENERGY', 28145, 23968, '2017-04-01', '2017-03-01', '2017-05-02', 4177, 441544.7900, 0.0000, 77279.6300, 518824.4200, '2017-04-25 12:32:03', 'dbo', ''),
(2017030026, 201703, 29, 26, '2017-04-25', 2382, 'ENERGY', 50419, 48749, '2017-04-01', '2017-03-01', '2017-05-02', 1670, 759286.4274, 0.0000, 31071.1100, 790357.5374, '2017-04-25 12:32:03', 'dbo', ''),
(2017030029, 201703, 29, 29, '2017-04-25', 2385, 'ENERGY', 70683, 68554, '2017-04-01', '2017-03-01', '2017-05-02', 2129, 981678.9988, 0.0000, 39531.3000, 1021210.2988, '2017-04-25 12:32:03', 'dbo', ''),
(2017030030, 201703, 29, 30, '2017-04-25', 2386, 'ENERGY', 34207, 33180, '2017-04-01', '2017-03-01', '2017-05-02', 1027, 367747.5112, 0.0000, 19219.4600, 386966.9712, '2017-04-25 12:32:03', 'dbo', ''),
(2017030031, 201703, 29, 31, '2017-04-25', 2387, 'ENERGY', 50527, 48271, '2017-04-01', '2017-03-01', '2017-05-02', 2256, 691545.2680, 0.0000, 41872.1400, 733417.4080, '2017-04-25 12:32:03', 'dbo', ''),
(2017030032, 201703, 29, 32, '2017-04-25', 2388, 'ENERGY', 82301, 79114, '2017-04-01', '2017-03-01', '2017-05-02', 3187, 1139272.9690, 0.0000, 59032.1400, 1198305.1090, '2017-04-25 12:32:03', 'dbo', ''),
(2017030033, 201703, 29, 33, '2017-04-25', 2389, 'ENERGY', 9506, 9377, '2017-04-01', '2017-03-01', '2017-05-02', 129, 145980.7534, 0.0000, 2667.7000, 148648.4534, '2017-04-25 12:32:03', 'dbo', ''),
(2017030034, 201703, 29, 34, '2017-04-25', 2390, 'ENERGY', 6860, 6523, '2017-04-01', '2017-03-01', '2017-05-02', 337, 106744.2842, 0.0000, 6501.5100, 113245.7942, '2017-04-25 12:32:03', 'dbo', ''),
(2017030035, 201703, 29, 35, '2017-04-25', 2391, 'ENERGY', 14288, 13974, '2017-04-01', '2017-03-01', '2017-05-02', 314, 213161.6726, 0.0000, 6077.5800, 219239.2526, '2017-04-25 12:32:03', 'dbo', ''),
(2017030036, 201703, 29, 36, '2017-04-25', 2392, 'ENERGY', 32573, 30949, '2017-04-01', '2017-03-01', '2017-05-02', 1624, 493848.0838, 0.0000, 30223.2400, 524071.3238, '2017-04-25 12:32:03', 'dbo', ''),
(2017030037, 201703, 29, 37, '2017-04-25', 2393, 'ENERGY', 17817, 17230, '2017-04-01', '2017-03-01', '2017-05-02', 587, 254494.8710, 0.0000, 11109.4600, 265604.3310, '2017-04-25 12:32:03', 'dbo', ''),
(2017030038, 201703, 29, 38, '2017-04-25', 2394, 'ENERGY', 8432, 8193, '2017-04-01', '2017-03-01', '2017-05-02', 239, 129057.0234, 0.0000, 4695.1900, 133752.2134, '2017-04-25 12:32:03', 'dbo', ''),
(2017030039, 201703, 29, 39, '2017-04-25', 2395, 'ENERGY', 22705, 21196, '2017-04-01', '2017-03-01', '2017-05-02', 1509, -279299.4218, 0.0000, 28103.5800, -251195.8418, '2017-04-25 12:32:03', 'dbo', ''),
(2017030040, 201703, 29, 40, '2017-04-25', 2396, 'ENERGY', 18803, 17569, '2017-04-01', '2017-03-01', '2017-05-02', 1234, 277469.0596, 0.0000, 23034.8300, 300503.8896, '2017-04-25 12:32:03', 'dbo', ''),
(2017030041, 201703, 29, 41, '2017-04-25', 2397, 'ENERGY', 241, 241, '2017-04-01', '2017-03-01', '2017-05-02', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2017-04-25 12:32:04', 'dbo', ''),
(2017030042, 201703, 29, 42, '2017-04-25', 2398, 'ENERGY', 183, 183, '2017-04-01', '2017-03-01', '2017-05-02', 0, 8044.5460, 0.0000, 0.0000, 8044.5460, '2017-04-25 12:32:04', 'dbo', ''),
(2017030043, 201703, 29, 43, '2017-04-25', 2399, 'ENERGY', 52995, 51009, '2017-04-01', '2017-03-01', '2017-05-02', 1986, 632179.5102, 0.0000, 36895.5600, 669075.0702, '2017-04-25 12:32:03', 'dbo', ''),
(2017030044, 201703, 29, 44, '2017-04-25', 2400, 'ENERGY', 27330, 25556, '2017-04-01', '2017-03-01', '2017-05-02', 1774, 465129.1730, 0.0000, 32988.0100, 498117.1830, '2017-04-25 12:32:03', 'dbo', ''),
(2017030045, 201703, 29, 45, '2017-04-25', 2401, 'ENERGY', 28264, 27573, '2017-04-01', '2017-03-01', '2017-05-02', 691, 231854.4020, 0.0000, 13026.3700, 244880.7720, '2017-04-25 12:32:03', 'dbo', ''),
(2017030046, 201703, 29, 46, '2017-04-25', 2402, 'ENERGY', 39846, 38502, '2017-04-01', '2017-03-01', '2017-05-02', 1344, 646542.7354, 0.0000, 25062.3300, 671605.0654, '2017-04-25 12:32:03', 'dbo', ''),
(2017030047, 201703, 29, 47, '2017-04-25', 2403, 'ENERGY', 20372, 19797, '2017-04-01', '2017-03-01', '2017-05-02', 575, 216862.7410, 0.0000, 10888.2800, 227751.0210, '2017-04-25 12:32:03', 'dbo', ''),
(2017030048, 201703, 29, 48, '2017-04-25', 2404, 'ENERGY', 5926, 5087, '2017-04-01', '2017-03-01', '2017-05-02', 839, 96435.1400, 0.0000, 15754.2800, 112189.4200, '2017-04-25 12:32:03', 'dbo', ''),
(2017030049, 201703, 29, 49, '2017-04-25', 2405, 'ENERGY', 4303, 4121, '2017-04-01', '2017-03-01', '2017-05-02', 182, 62579.1490, 0.0000, 3644.5900, 66223.7390, '2017-04-25 12:32:03', 'dbo', ''),
(2017030050, 201703, 29, 50, '2017-04-25', 2406, 'ENERGY', 66734, 64342, '2017-04-01', '2017-03-01', '2017-05-02', 2392, 893536.5892, 0.0000, 44378.8700, 937915.4592, '2017-04-25 12:32:03', 'dbo', ''),
(2017030051, 201703, 29, 51, '2017-04-25', 2407, 'ENERGY', 211, 211, '2017-04-01', '2017-03-01', '2017-05-02', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2017-04-25 12:32:04', 'dbo', ''),
(2017030052, 201703, 29, 52, '2017-04-25', 2408, 'ENERGY', 321, 321, '2017-04-01', '2017-03-01', '2017-05-02', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2017-04-25 12:32:04', 'dbo', ''),
(2017030053, 201703, 29, 53, '2017-04-25', 2409, 'ENERGY', 1776, 1776, '2017-04-01', '2017-03-01', '2017-05-02', 0, 39978.2270, 0.0000, 0.0000, 39978.2270, '2017-04-25 12:32:04', 'dbo', ''),
(2017030054, 201703, 29, 54, '2017-04-25', 2410, 'ENERGY', 22326, 21508, '2017-04-01', '2017-03-01', '2017-05-02', 818, 146192.5094, 0.0000, 15367.2100, 161559.7194, '2017-04-25 12:32:03', 'dbo', ''),
(2017030055, 201703, 29, 55, '2017-04-25', 2411, 'ENERGY', 12155, 11963, '2017-04-01', '2017-03-01', '2017-05-02', 192, 224729.3000, 0.0000, 3828.9000, 228558.2000, '2017-04-25 12:32:03', 'dbo', ''),
(2017030056, 201703, 29, 56, '2017-04-25', 2412, 'ENERGY', 239, 228, '2017-04-01', '2017-03-01', '2017-05-02', 11, 8024.0190, 0.0000, 492.7600, 8516.7790, '2017-04-25 12:32:03', 'dbo', ''),
(2017030059, 201703, 29, 59, '2017-04-25', 2415, 'ENERGY', 128, 128, '2017-04-01', '2017-03-01', '2017-05-02', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2017-04-25 12:32:04', 'dbo', ''),
(2017030060, 201703, 29, 60, '2017-04-25', 2416, 'ENERGY', 160627, 153107, '2017-04-01', '2017-03-01', '2017-05-02', 7520, 1511488.1500, 0.0000, 138897.1400, 1650385.2900, '2017-04-25 12:32:03', 'dbo', ''),
(2017030061, 201703, 29, 61, '2017-04-25', 2417, 'ENERGY', 16, 16, '2017-04-01', '2017-03-01', '2017-05-02', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2017-04-25 12:32:04', 'dbo', ''),
(2017030062, 201703, 29, 62, '2017-04-25', 2418, 'ENERGY', 30, 30, '2017-04-01', '2017-03-01', '2017-05-02', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-04-25 12:32:04', 'dbo', ''),
(2017030063, 201703, 29, 63, '2017-04-25', 2419, 'ENERGY', 1, 1, '2017-04-01', '2017-03-01', '2017-05-02', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-04-25 12:32:04', 'dbo', ''),
(2017030064, 201703, 29, 64, '2017-04-25', 2420, 'ENERGY', 2, 2, '2017-04-01', '2017-03-01', '2017-05-02', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-04-25 12:32:04', 'dbo', ''),
(2017030065, 201703, 29, 65, '2017-04-25', 2421, 'ENERGY', 4951, 4532, '2017-04-01', '2017-03-01', '2017-05-02', 419, 87229.8080, 0.0000, 8012.9200, 95242.7280, '2017-04-25 12:32:03', 'dbo', ''),
(2017030066, 201703, 29, 66, '2017-04-25', 2422, 'ENERGY', 4200, 3932, '2017-04-01', '2017-03-01', '2017-05-02', 268, 74335.7524, 0.0000, 5229.7300, 79565.4824, '2017-04-25 12:32:03', 'dbo', ''),
(2017030067, 201703, 29, 67, '2017-04-25', 2423, 'ENERGY', 540, 513, '2017-04-01', '2017-03-01', '2017-05-02', 27, 13520.2738, 0.0000, 787.6600, 14307.9338, '2017-04-25 12:32:03', 'dbo', ''),
(2017030068, 201703, 29, 68, '2017-04-25', 2424, 'ENERGY', 1024, 968, '2017-04-01', '2017-03-01', '2017-05-02', 56, 22799.5700, 0.0000, 1322.1800, 24121.7500, '2017-04-25 12:32:03', 'dbo', ''),
(2017030069, 201703, 29, 69, '2017-04-25', 2425, 'ENERGY', 1, 1, '2017-04-01', '2017-03-01', '2017-05-02', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2017-04-25 12:32:04', 'dbo', ''),
(2017030070, 201703, 29, 70, '2017-04-25', 2426, 'ENERGY', 345, 345, '2017-04-01', '2017-03-01', '2017-05-02', 0, 11744.5000, 0.0000, 0.0000, 11744.5000, '2017-04-25 12:32:04', 'dbo', ''),
(2017030071, 201703, 29, 71, '2017-04-25', 2427, 'ENERGY', 91880, 84727, '2017-04-01', '2017-03-01', '2017-05-02', 7153, 1455085.7762, 0.0000, 132132.6800, 1587218.4562, '2017-04-25 12:32:03', 'dbo', ''),
(2017030072, 201703, 29, 72, '2017-04-25', 2428, 'ENERGY', 1131, 1096, '2017-04-01', '2017-03-01', '2017-05-02', 35, 26534.9200, 0.0000, 935.1100, 27470.0300, '2017-04-25 12:32:03', 'dbo', ''),
(2017030073, 201703, 29, 73, '2017-04-25', 2429, 'ENERGY', 394, 394, '2017-04-01', '2017-03-01', '2017-05-02', 0, 20536.6580, 0.0000, 0.0000, 20536.6580, '2017-04-25 12:32:03', 'dbo', ''),
(2017030075, 201703, 29, 75, '2017-04-25', 2430, 'ENERGY', 1060, 1019, '2017-04-01', '2017-03-01', '2017-05-02', 41, 24036.9200, 0.0000, 1045.7000, 25082.6200, '2017-04-25 12:32:03', 'dbo', ''),
(2017030076, 201703, 29, 76, '2017-04-25', 2431, 'ENERGY', 1147, 1107, '2017-04-01', '2017-03-01', '2017-05-02', 40, 25611.4400, 0.0000, 1027.2700, 26638.7100, '2017-04-25 12:32:03', 'dbo', ''),
(2017030077, 201703, 29, 77, '2017-04-25', 2432, 'ENERGY', 943, 914, '2017-04-01', '2017-03-01', '2017-05-02', 29, 22020.2400, 0.0000, 824.5200, 22844.7600, '2017-04-25 12:32:03', 'dbo', ''),
(2017030078, 201703, 29, 78, '2017-04-25', 2433, 'ENERGY', 238, 227, '2017-04-01', '2017-03-01', '2017-05-02', 11, 9602.3100, 0.0000, 492.7600, 10095.0700, '2017-04-25 12:32:03', 'dbo', ''),
(2017030079, 201703, 29, 79, '2017-04-25', 2434, 'ENERGY', 27199, 25722, '2017-04-01', '2017-03-01', '2017-05-02', 1477, 366584.8300, 0.0000, 27513.7700, 394098.6000, '2017-04-25 12:32:03', 'dbo', ''),
(2017030080, 201703, 29, 80, '2017-04-25', 2435, 'ENERGY', 311, 311, '2017-04-01', '2017-03-01', '2017-05-02', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2017-04-25 12:32:04', 'dbo', ''),
(2017030081, 201703, 29, 81, '2017-04-25', 2436, 'ENERGY', 955, 903, '2017-04-01', '2017-03-01', '2017-05-02', 52, 18576.4700, 0.0000, 1248.4500, 19824.9200, '2017-04-25 12:32:03', 'dbo', '');
INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2017030082, 201703, 29, 82, '2017-04-25', 2437, 'ENERGY', 1594, 1475, '2017-04-01', '2017-03-01', '2017-05-02', 119, 30247.8800, 0.0000, 2483.3800, 32731.2600, '2017-04-25 12:32:03', 'dbo', ''),
(2017030083, 201703, 29, 83, '2017-04-25', 2438, 'ENERGY', 392, 35, '2017-04-01', '2017-03-01', '2017-05-02', 357, 1793.9000, 0.0000, 6870.1500, 8664.0500, '2017-04-25 12:32:03', 'dbo', ''),
(2017030084, 201703, 29, 84, '2017-04-25', 2439, 'ENERGY', 23, 21, '2017-04-01', '2017-03-01', '2017-05-02', 2, 1541.9600, 0.0000, 326.8700, 1868.8300, '2017-04-25 12:32:03', 'dbo', ''),
(2017030085, 201703, 29, 85, '2017-04-25', 2440, 'ENERGY', 0, 0, '2017-04-01', '2017-03-01', '2017-05-02', 0, 0.0000, 0.0000, 0.0000, 0.0000, '2017-04-25 12:32:04', 'dbo', ''),
(2017030086, 201703, 29, 86, '2017-04-25', 2441, 'ENERGY', 30, 25, '2017-04-01', '2017-03-01', '2017-05-02', 5, 1040.5300, 0.0000, 382.1600, 1422.6900, '2017-04-25 12:32:03', 'dbo', ''),
(2017040001, 201704, 30, 1, '2017-05-17', 2442, 'ENERGY', 14016, 14016, '2017-05-01', '2017-04-01', '2017-05-24', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2017-05-17 12:15:49', 'dbo', ''),
(2017040002, 201704, 30, 2, '2017-05-17', 2443, 'ENERGY', 7081, 7081, '2017-05-01', '2017-04-01', '2017-05-24', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2017-05-17 12:15:49', 'dbo', ''),
(2017040003, 201704, 30, 3, '2017-05-17', 2444, 'ENERGY', 8948, 8948, '2017-05-01', '2017-04-01', '2017-05-24', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2017-05-17 12:15:49', 'dbo', ''),
(2017040004, 201704, 30, 4, '2017-05-17', 2445, 'ENERGY', 6711, 6711, '2017-05-01', '2017-04-01', '2017-05-24', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2017-05-17 12:15:49', 'dbo', ''),
(2017040005, 201704, 30, 5, '2017-05-17', 2446, 'ENERGY', 5255, 5255, '2017-05-01', '2017-04-01', '2017-05-24', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2017-05-17 12:15:49', 'dbo', ''),
(2017040006, 201704, 30, 6, '2017-05-17', 2447, 'ENERGY', 13833, 13833, '2017-05-01', '2017-04-01', '2017-05-24', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2017-05-17 12:15:49', 'dbo', ''),
(2017040007, 201704, 30, 7, '2017-05-17', 2448, 'ENERGY', 9652, 9652, '2017-05-01', '2017-04-01', '2017-05-24', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2017-05-17 12:15:49', 'dbo', ''),
(2017040008, 201704, 30, 8, '2017-05-17', 2449, 'ENERGY', 167, 167, '2017-05-01', '2017-04-01', '2017-05-24', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2017-05-17 12:15:49', 'dbo', ''),
(2017040009, 201704, 30, 9, '2017-05-17', 2450, 'ENERGY', 122, 122, '2017-05-01', '2017-04-01', '2017-05-24', 0, 9427.2064, 0.0000, 0.0000, 9427.2064, '2017-05-17 12:15:49', 'dbo', ''),
(2017040010, 201704, 30, 10, '2017-05-17', 2451, 'ENERGY', 87, 87, '2017-05-01', '2017-04-01', '2017-05-24', 0, 6435.8780, 0.0000, 0.0000, 6435.8780, '2017-05-17 12:15:49', 'dbo', ''),
(2017040011, 201704, 30, 11, '2017-05-17', 2452, 'ENERGY', 201, 201, '2017-05-01', '2017-04-01', '2017-05-24', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2017-05-17 12:15:49', 'dbo', ''),
(2017040012, 201704, 30, 12, '2017-05-17', 2453, 'ENERGY', 125, 125, '2017-05-01', '2017-04-01', '2017-05-24', 0, 7909.6200, 0.0000, 0.0000, 7909.6200, '2017-05-17 12:15:49', 'dbo', ''),
(2017040013, 201704, 30, 13, '2017-05-17', 2454, 'ENERGY', 3444, 3001, '2017-05-01', '2017-04-01', '2017-05-24', 443, 62785.3640, 0.0000, 8742.3200, 71527.6840, '2017-05-17 12:15:48', 'dbo', ''),
(2017040014, 201704, 30, 14, '2017-05-17', 2455, 'ENERGY', 1455, 1330, '2017-05-01', '2017-04-01', '2017-05-24', 125, 32024.9354, 0.0000, 2674.9600, 34699.8954, '2017-05-17 12:15:48', 'dbo', ''),
(2017040015, 201704, 30, 15, '2017-05-17', 2456, 'ENERGY', 162, 162, '2017-05-01', '2017-04-01', '2017-05-24', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2017-05-17 12:15:49', 'dbo', ''),
(2017040016, 201704, 30, 16, '2017-05-17', 2457, 'ENERGY', 3283, 2779, '2017-05-01', '2017-04-01', '2017-05-24', 504, 57978.9220, 0.0000, 9906.1800, 67885.1020, '2017-05-17 12:15:48', 'dbo', ''),
(2017040017, 201704, 30, 17, '2017-05-17', 2458, 'ENERGY', 8890, 7091, '2017-05-01', '2017-04-01', '2017-05-24', 1799, 132653.5270, 0.0000, 34614.4500, 167267.9770, '2017-05-17 12:15:48', 'dbo', ''),
(2017040018, 201704, 30, 18, '2017-05-17', 2459, 'ENERGY', 3273, 2837, '2017-05-01', '2017-04-01', '2017-05-24', 436, 56184.1300, 0.0000, 8608.7700, 64792.9000, '2017-05-17 12:15:48', 'dbo', ''),
(2017040019, 201704, 30, 19, '2017-05-17', 2460, 'ENERGY', 75, 75, '2017-05-01', '2017-04-01', '2017-05-24', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2017-05-17 12:15:49', 'dbo', ''),
(2017040020, 201704, 30, 20, '2017-05-17', 2461, 'ENERGY', 249, 239, '2017-05-01', '2017-04-01', '2017-05-24', 10, 6215.4930, 0.0000, 480.8000, 6696.2930, '2017-05-17 12:15:48', 'dbo', ''),
(2017040021, 201704, 30, 21, '2017-05-17', 2462, 'ENERGY', 40753, 40264, '2017-05-01', '2017-04-01', '2017-05-24', 489, 516568.4646, 0.0000, 9619.9800, 526188.4446, '2017-05-17 12:15:48', 'dbo', ''),
(2017040022, 201704, 30, 22, '2017-05-17', 2463, 'ENERGY', 23177, 22845, '2017-05-01', '2017-04-01', '2017-05-24', 332, 285779.3516, 0.0000, 6624.4800, 292403.8316, '2017-05-17 12:15:48', 'dbo', ''),
(2017040023, 201704, 30, 23, '2017-05-17', 2464, 'ENERGY', 60170, 58596, '2017-05-01', '2017-04-01', '2017-05-24', 1574, 762176.3470, 0.0000, 30321.5100, 792497.8570, '2017-05-17 12:15:48', 'dbo', ''),
(2017040024, 201704, 30, 24, '2017-05-17', 2465, 'ENERGY', 41358, 40881, '2017-05-01', '2017-04-01', '2017-05-24', 477, 487429.8100, 0.0000, 9391.0300, 496820.8400, '2017-05-17 12:15:48', 'dbo', ''),
(2017040025, 201704, 30, 25, '2017-05-17', 2466, 'ENERGY', 32202, 28145, '2017-05-01', '2017-04-01', '2017-05-24', 4057, 518824.4200, 0.0000, 77696.5000, 596520.9200, '2017-05-17 12:15:48', 'dbo', ''),
(2017040026, 201704, 30, 26, '2017-05-17', 2467, 'ENERGY', 51792, 50419, '2017-05-01', '2017-04-01', '2017-05-24', 1373, 790357.5374, 0.0000, 26486.4800, 816844.0174, '2017-05-17 12:15:48', 'dbo', ''),
(2017040029, 201704, 30, 29, '2017-05-17', 2470, 'ENERGY', 72709, 70683, '2017-05-01', '2017-04-01', '2017-05-24', 2026, 1021210.2988, 0.0000, 38945.5500, 1060155.8488, '2017-05-17 12:15:48', 'dbo', ''),
(2017040030, 201704, 30, 30, '2017-05-17', 2471, 'ENERGY', 35194, 34207, '2017-05-01', '2017-04-01', '2017-05-24', 987, 386966.9712, 0.0000, 19121.7000, 406088.6712, '2017-05-17 12:15:48', 'dbo', ''),
(2017040031, 201704, 30, 31, '2017-05-17', 2472, 'ENERGY', 52718, 50527, '2017-05-01', '2017-04-01', '2017-05-24', 2191, 733417.4080, 0.0000, 42093.7000, 775511.1080, '2017-05-17 12:15:48', 'dbo', ''),
(2017040032, 201704, 30, 32, '2017-05-17', 2473, 'ENERGY', 85380, 82301, '2017-05-01', '2017-04-01', '2017-05-24', 3079, 1198305.1090, 0.0000, 59036.5100, 1257341.6190, '2017-05-17 12:15:48', 'dbo', ''),
(2017040033, 201704, 30, 33, '2017-05-17', 2474, 'ENERGY', 9786, 9506, '2017-05-01', '2017-04-01', '2017-05-24', 280, 148648.4534, 0.0000, 5632.3300, 154280.7834, '2017-05-17 12:15:48', 'dbo', ''),
(2017040034, 201704, 30, 34, '2017-05-17', 2475, 'ENERGY', 7178, 6860, '2017-05-01', '2017-04-01', '2017-05-24', 318, 113245.7942, 0.0000, 6357.3600, 119603.1542, '2017-05-17 12:15:48', 'dbo', ''),
(2017040035, 201704, 30, 35, '2017-05-17', 2476, 'ENERGY', 14612, 14288, '2017-05-01', '2017-04-01', '2017-05-24', 324, 219239.2526, 0.0000, 6471.8400, 225711.0926, '2017-05-17 12:15:48', 'dbo', ''),
(2017040036, 201704, 30, 36, '2017-05-17', 2477, 'ENERGY', 33902, 32573, '2017-05-01', '2017-04-01', '2017-05-24', 1329, 524071.3238, 0.0000, 25646.9700, 549718.2938, '2017-05-17 12:15:48', 'dbo', ''),
(2017040037, 201704, 30, 37, '2017-05-17', 2478, 'ENERGY', 18430, 17817, '2017-05-01', '2017-04-01', '2017-05-24', 613, 265604.3310, 0.0000, 11985.8800, 277590.2110, '2017-05-17 12:15:48', 'dbo', ''),
(2017040038, 201704, 30, 38, '2017-05-17', 2479, 'ENERGY', 8685, 8432, '2017-05-01', '2017-04-01', '2017-05-24', 253, 133752.2134, 0.0000, 5117.1600, 138869.3734, '2017-05-17 12:15:48', 'dbo', ''),
(2017040039, 201704, 30, 39, '2017-05-17', 2480, 'ENERGY', 23570, 22705, '2017-05-01', '2017-04-01', '2017-05-24', 865, -251195.8418, 0.0000, 16793.9700, -234401.8718, '2017-05-17 12:15:48', 'dbo', ''),
(2017040040, 201704, 30, 40, '2017-05-17', 2481, 'ENERGY', 19650, 18803, '2017-05-01', '2017-04-01', '2017-05-24', 847, 300503.8896, 0.0000, 16450.5300, 316954.4196, '2017-05-17 12:15:48', 'dbo', ''),
(2017040041, 201704, 30, 41, '2017-05-17', 2482, 'ENERGY', 241, 241, '2017-05-01', '2017-04-01', '2017-05-24', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2017-05-17 12:15:49', 'dbo', ''),
(2017040042, 201704, 30, 42, '2017-05-17', 2483, 'ENERGY', 183, 183, '2017-05-01', '2017-04-01', '2017-05-24', 0, 8044.5460, 0.0000, 0.0000, 8044.5460, '2017-05-17 12:15:49', 'dbo', ''),
(2017040043, 201704, 30, 43, '2017-05-17', 2484, 'ENERGY', 54496, 52995, '2017-05-01', '2017-04-01', '2017-05-24', 1501, 669075.0702, 0.0000, 28928.6800, 698003.7502, '2017-05-17 12:15:48', 'dbo', ''),
(2017040044, 201704, 30, 44, '2017-05-17', 2485, 'ENERGY', 28903, 27330, '2017-05-01', '2017-04-01', '2017-05-24', 1573, 498117.1830, 0.0000, 30302.4300, 528419.6130, '2017-05-17 12:15:48', 'dbo', ''),
(2017040045, 201704, 30, 45, '2017-05-17', 2486, 'ENERGY', 28879, 28264, '2017-05-01', '2017-04-01', '2017-05-24', 615, 244880.7720, 0.0000, 12024.0300, 256904.8020, '2017-05-17 12:15:49', 'dbo', ''),
(2017040046, 201704, 30, 46, '2017-05-17', 2487, 'ENERGY', 40946, 39846, '2017-05-01', '2017-04-01', '2017-05-24', 1100, 671605.0654, 0.0000, 21277.7200, 692882.7854, '2017-05-17 12:15:49', 'dbo', ''),
(2017040047, 201704, 30, 47, '2017-05-17', 2488, 'ENERGY', 20915, 20372, '2017-05-01', '2017-04-01', '2017-05-24', 543, 227751.0210, 0.0000, 10650.2900, 238401.3110, '2017-05-17 12:15:49', 'dbo', ''),
(2017040048, 201704, 30, 48, '2017-05-17', 2489, 'ENERGY', 6750, 5926, '2017-05-01', '2017-04-01', '2017-05-24', 824, 112189.4200, 0.0000, 16011.7100, 128201.1300, '2017-05-17 12:15:49', 'dbo', ''),
(2017040049, 201704, 30, 49, '2017-05-17', 2490, 'ENERGY', 4495, 4303, '2017-05-01', '2017-04-01', '2017-05-24', 192, 66223.7390, 0.0000, 3953.3100, 70177.0490, '2017-05-17 12:15:48', 'dbo', ''),
(2017040050, 201704, 30, 50, '2017-05-17', 2491, 'ENERGY', 68857, 66734, '2017-05-01', '2017-04-01', '2017-05-24', 2123, 937915.4592, 0.0000, 40796.2900, 978711.7492, '2017-05-17 12:15:48', 'dbo', ''),
(2017040051, 201704, 30, 51, '2017-05-17', 2492, 'ENERGY', 211, 211, '2017-05-01', '2017-04-01', '2017-05-24', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2017-05-17 12:15:49', 'dbo', ''),
(2017040052, 201704, 30, 52, '2017-05-17', 2493, 'ENERGY', 321, 321, '2017-05-01', '2017-04-01', '2017-05-24', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2017-05-17 12:15:49', 'dbo', ''),
(2017040053, 201704, 30, 53, '2017-05-17', 2494, 'ENERGY', 1776, 1776, '2017-05-01', '2017-04-01', '2017-05-24', 0, 39978.2270, 0.0000, 0.0000, 39978.2270, '2017-05-17 12:15:49', 'dbo', ''),
(2017040054, 201704, 30, 54, '2017-05-17', 2495, 'ENERGY', 23043, 22326, '2017-05-01', '2017-04-01', '2017-05-24', 717, 161559.7194, 0.0000, 13970.1700, 175529.8894, '2017-05-17 12:15:48', 'dbo', ''),
(2017040055, 201704, 30, 55, '2017-05-17', 2496, 'ENERGY', 12207, 12155, '2017-05-01', '2017-04-01', '2017-05-24', 52, 228558.2000, 0.0000, 1282.1500, 229840.3500, '2017-05-17 12:15:49', 'dbo', ''),
(2017040056, 201704, 30, 56, '2017-05-17', 2497, 'ENERGY', 239, 239, '2017-05-01', '2017-04-01', '2017-05-24', 0, 8516.7790, 0.0000, 0.0000, 8516.7790, '2017-05-17 12:15:49', 'dbo', ''),
(2017040059, 201704, 30, 59, '2017-05-17', 2500, 'ENERGY', 128, 128, '2017-05-01', '2017-04-01', '2017-05-24', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2017-05-17 12:15:49', 'dbo', ''),
(2017040060, 201704, 30, 60, '2017-05-17', 2501, 'ENERGY', 168394, 160627, '2017-05-01', '2017-04-01', '2017-05-24', 7767, 1650385.2900, 0.0000, 148482.3300, 1798867.6200, '2017-05-17 12:15:48', 'dbo', ''),
(2017040061, 201704, 30, 61, '2017-05-17', 2502, 'ENERGY', 16, 16, '2017-05-01', '2017-04-01', '2017-05-24', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2017-05-17 12:15:49', 'dbo', ''),
(2017040062, 201704, 30, 62, '2017-05-17', 2503, 'ENERGY', 30, 30, '2017-05-01', '2017-04-01', '2017-05-24', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-05-17 12:15:49', 'dbo', ''),
(2017040063, 201704, 30, 63, '2017-05-17', 2504, 'ENERGY', 1, 1, '2017-05-01', '2017-04-01', '2017-05-24', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-05-17 12:15:49', 'dbo', ''),
(2017040064, 201704, 30, 64, '2017-05-17', 2505, 'ENERGY', 2, 2, '2017-05-01', '2017-04-01', '2017-05-24', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-05-17 12:15:49', 'dbo', ''),
(2017040065, 201704, 30, 65, '2017-05-17', 2506, 'ENERGY', 5317, 4951, '2017-05-01', '2017-04-01', '2017-05-24', 366, 95242.7280, 0.0000, 7273.1800, 102515.9080, '2017-05-17 12:15:48', 'dbo', ''),
(2017040066, 201704, 30, 66, '2017-05-17', 2507, 'ENERGY', 4436, 4200, '2017-05-01', '2017-04-01', '2017-05-24', 236, 79565.4824, 0.0000, 4792.8200, 84358.3024, '2017-05-17 12:15:48', 'dbo', ''),
(2017040067, 201704, 30, 67, '2017-05-17', 2508, 'ENERGY', 564, 540, '2017-05-01', '2017-04-01', '2017-05-24', 24, 14307.9338, 0.0000, 747.9100, 15055.8438, '2017-05-17 12:15:49', 'dbo', ''),
(2017040068, 201704, 30, 68, '2017-05-17', 2509, 'ENERGY', 1077, 1024, '2017-05-01', '2017-04-01', '2017-05-24', 53, 24121.7500, 0.0000, 1301.2200, 25422.9700, '2017-05-17 12:15:49', 'dbo', ''),
(2017040069, 201704, 30, 69, '2017-05-17', 2510, 'ENERGY', 1, 1, '2017-05-01', '2017-04-01', '2017-05-24', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2017-05-17 12:15:49', 'dbo', ''),
(2017040070, 201704, 30, 70, '2017-05-17', 2511, 'ENERGY', 345, 345, '2017-05-01', '2017-04-01', '2017-05-24', 0, 11744.5000, 0.0000, 0.0000, 11744.5000, '2017-05-17 12:15:49', 'dbo', ''),
(2017040071, 201704, 30, 71, '2017-05-17', 2512, 'ENERGY', 99190, 91880, '2017-05-01', '2017-04-01', '2017-05-24', 7310, 1587218.4562, 0.0000, 139762.9000, 1726981.3562, '2017-05-17 12:15:48', 'dbo', ''),
(2017040072, 201704, 30, 72, '2017-05-17', 2513, 'ENERGY', 1168, 1131, '2017-05-01', '2017-04-01', '2017-05-24', 37, 27470.0300, 0.0000, 995.9500, 28465.9800, '2017-05-17 12:15:48', 'dbo', ''),
(2017040073, 201704, 30, 73, '2017-05-17', 2514, 'ENERGY', 408, 394, '2017-05-01', '2017-04-01', '2017-05-24', 14, 20536.6580, 0.0000, 557.1200, 21093.7780, '2017-05-17 12:15:48', 'dbo', ''),
(2017040075, 201704, 30, 75, '2017-05-17', 2515, 'ENERGY', 1103, 1060, '2017-05-01', '2017-04-01', '2017-05-24', 43, 25082.6200, 0.0000, 1110.4300, 26193.0500, '2017-05-17 12:15:48', 'dbo', ''),
(2017040076, 201704, 30, 76, '2017-05-17', 2516, 'ENERGY', 1188, 1147, '2017-05-01', '2017-04-01', '2017-05-24', 41, 26638.7100, 0.0000, 1072.2600, 27710.9700, '2017-05-17 12:15:48', 'dbo', ''),
(2017040077, 201704, 30, 77, '2017-05-17', 2517, 'ENERGY', 973, 943, '2017-05-01', '2017-04-01', '2017-05-24', 30, 22844.7600, 0.0000, 862.3900, 23707.1500, '2017-05-17 12:15:48', 'dbo', ''),
(2017040078, 201704, 30, 78, '2017-05-17', 2518, 'ENERGY', 249, 238, '2017-05-01', '2017-04-01', '2017-05-24', 11, 10095.0700, 0.0000, 499.8700, 10594.9400, '2017-05-17 12:15:48', 'dbo', ''),
(2017040079, 201704, 30, 79, '2017-05-17', 2519, 'ENERGY', 28730, 27199, '2017-05-01', '2017-04-01', '2017-05-24', 1531, 394098.6000, 0.0000, 29501.0700, 423599.6700, '2017-05-17 12:15:48', 'dbo', ''),
(2017040080, 201704, 30, 80, '2017-05-17', 2520, 'ENERGY', 311, 311, '2017-05-01', '2017-04-01', '2017-05-24', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2017-05-17 12:15:49', 'dbo', ''),
(2017040081, 201704, 30, 81, '2017-05-17', 2521, 'ENERGY', 1007, 955, '2017-05-01', '2017-04-01', '2017-05-24', 52, 19824.9200, 0.0000, 1282.1500, 21107.0700, '2017-05-17 12:15:48', 'dbo', ''),
(2017040082, 201704, 30, 82, '2017-05-17', 2522, 'ENERGY', 1718, 1594, '2017-05-01', '2017-04-01', '2017-05-24', 124, 32731.2600, 0.0000, 2655.8900, 35387.1500, '2017-05-17 12:15:48', 'dbo', ''),
(2017040083, 201704, 30, 83, '2017-05-17', 2523, 'ENERGY', 42, 392, '2017-05-01', '2017-04-01', '2017-05-24', -350, 8664.0500, 0.0000, -6387.9100, 2276.1400, '2017-05-17 12:15:48', 'dbo', ''),
(2017040084, 201704, 30, 84, '2017-05-17', 2524, 'ENERGY', 25, 23, '2017-05-01', '2017-04-01', '2017-05-24', 2, 1868.8300, 0.0000, 328.1600, 2196.9900, '2017-05-17 12:15:48', 'dbo', ''),
(2017040085, 201704, 30, 85, '2017-05-17', 2525, 'ENERGY', 0, 0, '2017-05-01', '2017-04-01', '2017-05-24', 0, 0.0000, 0.0000, 0.0000, 0.0000, '2017-05-17 12:15:49', 'dbo', ''),
(2017040086, 201704, 30, 86, '2017-05-17', 2526, 'ENERGY', 35, 30, '2017-05-01', '2017-04-01', '2017-05-24', 5, 1422.6900, 0.0000, 385.3900, 1808.0800, '2017-05-17 12:15:48', 'dbo', ''),
(2017050001, 201705, 31, 1, '2017-06-27', 2527, 'ENERGY', 14016, 14016, '2017-06-01', '2017-05-01', '2017-07-04', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2017-06-27 07:52:33', 'dbo', ''),
(2017050002, 201705, 31, 2, '2017-06-27', 2528, 'ENERGY', 7081, 7081, '2017-06-01', '2017-05-01', '2017-07-04', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2017-06-27 07:52:33', 'dbo', ''),
(2017050003, 201705, 31, 3, '2017-06-27', 2529, 'ENERGY', 8948, 8948, '2017-06-01', '2017-05-01', '2017-07-04', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2017-06-27 07:52:33', 'dbo', ''),
(2017050004, 201705, 31, 4, '2017-06-27', 2530, 'ENERGY', 6711, 6711, '2017-06-01', '2017-05-01', '2017-07-04', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2017-06-27 07:52:33', 'dbo', ''),
(2017050005, 201705, 31, 5, '2017-06-27', 2531, 'ENERGY', 5255, 5255, '2017-06-01', '2017-05-01', '2017-07-04', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2017-06-27 07:52:33', 'dbo', ''),
(2017050006, 201705, 31, 6, '2017-06-27', 2532, 'ENERGY', 13833, 13833, '2017-06-01', '2017-05-01', '2017-07-04', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2017-06-27 07:52:33', 'dbo', ''),
(2017050007, 201705, 31, 7, '2017-06-27', 2533, 'ENERGY', 9652, 9652, '2017-06-01', '2017-05-01', '2017-07-04', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2017-06-27 07:52:33', 'dbo', ''),
(2017050008, 201705, 31, 8, '2017-06-27', 2534, 'ENERGY', 167, 167, '2017-06-01', '2017-05-01', '2017-07-04', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2017-06-27 07:52:33', 'dbo', ''),
(2017050009, 201705, 31, 9, '2017-06-27', 2535, 'ENERGY', 140, 122, '2017-06-01', '2017-05-01', '2017-07-04', 18, 9427.2064, 0.0000, 625.7400, 10052.9464, '2017-06-27 07:52:33', 'dbo', ''),
(2017050010, 201705, 31, 10, '2017-06-27', 2536, 'ENERGY', 87, 87, '2017-06-01', '2017-05-01', '2017-07-04', 0, 6435.8780, 0.0000, 0.0000, 6435.8780, '2017-06-27 07:52:33', 'dbo', ''),
(2017050011, 201705, 31, 11, '2017-06-27', 2537, 'ENERGY', 201, 201, '2017-06-01', '2017-05-01', '2017-07-04', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2017-06-27 07:52:33', 'dbo', ''),
(2017050012, 201705, 31, 12, '2017-06-27', 2538, 'ENERGY', 125, 125, '2017-06-01', '2017-05-01', '2017-07-04', 0, 7909.6200, 0.0000, 0.0000, 7909.6200, '2017-06-27 07:52:33', 'dbo', ''),
(2017050013, 201705, 31, 13, '2017-06-27', 2539, 'ENERGY', 4027, 3444, '2017-06-01', '2017-05-01', '2017-07-04', 583, 71527.6840, 0.0000, 11164.4000, 82692.0840, '2017-06-27 07:52:33', 'dbo', ''),
(2017050014, 201705, 31, 14, '2017-06-27', 2540, 'ENERGY', 1607, 1455, '2017-06-01', '2017-05-01', '2017-07-04', 152, 34699.8954, 0.0000, 3125.1800, 37825.0754, '2017-06-27 07:52:33', 'dbo', ''),
(2017050015, 201705, 31, 15, '2017-06-27', 2541, 'ENERGY', 162, 162, '2017-06-01', '2017-05-01', '2017-07-04', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2017-06-27 07:52:33', 'dbo', ''),
(2017050016, 201705, 31, 16, '2017-06-27', 2542, 'ENERGY', 3870, 3283, '2017-06-01', '2017-05-01', '2017-07-04', 587, 67885.1020, 0.0000, 11239.0100, 79124.1120, '2017-06-27 07:52:33', 'dbo', ''),
(2017050017, 201705, 31, 17, '2017-06-27', 2543, 'ENERGY', 10599, 8890, '2017-06-01', '2017-05-01', '2017-07-04', 1709, 167267.9770, 0.0000, 32167.1000, 199435.0770, '2017-06-27 07:52:33', 'dbo', ''),
(2017050018, 201705, 31, 18, '2017-06-27', 2544, 'ENERGY', 3667, 3273, '2017-06-01', '2017-05-01', '2017-07-04', 394, 64792.9000, 0.0000, 7639.0800, 72431.9800, '2017-06-27 07:52:33', 'dbo', ''),
(2017050019, 201705, 31, 19, '2017-06-27', 2545, 'ENERGY', 75, 75, '2017-06-01', '2017-05-01', '2017-07-04', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2017-06-27 07:52:33', 'dbo', ''),
(2017050020, 201705, 31, 20, '2017-06-27', 2546, 'ENERGY', 249, 249, '2017-06-01', '2017-05-01', '2017-07-04', 0, 6696.2930, 0.0000, 0.0000, 6696.2930, '2017-06-27 07:52:33', 'dbo', ''),
(2017050021, 201705, 31, 21, '2017-06-27', 2547, 'ENERGY', 41380, 40753, '2017-06-01', '2017-05-01', '2017-07-04', 627, 526188.4446, 0.0000, 11985.1100, 538173.5546, '2017-06-27 07:52:33', 'dbo', ''),
(2017050022, 201705, 31, 22, '2017-06-27', 2548, 'ENERGY', 23597, 23177, '2017-06-01', '2017-05-01', '2017-07-04', 420, 292403.8316, 0.0000, 8124.0400, 300527.8716, '2017-06-27 07:52:33', 'dbo', ''),
(2017050023, 201705, 31, 23, '2017-06-27', 2549, 'ENERGY', 61681, 60170, '2017-06-01', '2017-05-01', '2017-07-04', 1511, 792497.8570, 0.0000, 28473.8900, 820971.7470, '2017-06-27 07:52:33', 'dbo', ''),
(2017050024, 201705, 31, 24, '2017-06-27', 2550, 'ENERGY', 41828, 41358, '2017-06-01', '2017-05-01', '2017-07-04', 470, 496820.8400, 0.0000, 9056.6600, 505877.5000, '2017-06-27 07:52:33', 'dbo', ''),
(2017050025, 201705, 31, 25, '2017-06-27', 2551, 'ENERGY', 36619, 32202, '2017-06-01', '2017-05-01', '2017-07-04', 4417, 596520.9200, 0.0000, 82678.0000, 679198.9200, '2017-06-27 07:52:33', 'dbo', ''),
(2017050026, 201705, 31, 26, '2017-06-27', 2552, 'ENERGY', 53178, 51792, '2017-06-01', '2017-05-01', '2017-07-04', 1386, 816844.0174, 0.0000, 26142.3300, 842986.3474, '2017-06-27 07:52:33', 'dbo', ''),
(2017050029, 201705, 31, 29, '2017-06-27', 2555, 'ENERGY', 74715, 72709, '2017-06-01', '2017-05-01', '2017-07-04', 2006, 1060155.8488, 0.0000, 37706.8700, 1097862.7188, '2017-06-27 07:52:33', 'dbo', ''),
(2017050030, 201705, 31, 30, '2017-06-27', 2556, 'ENERGY', 36200, 35194, '2017-06-01', '2017-05-01', '2017-07-04', 1006, 406088.6712, 0.0000, 19054.3900, 425143.0612, '2017-06-27 07:52:33', 'dbo', ''),
(2017050031, 201705, 31, 31, '2017-06-27', 2557, 'ENERGY', 54800, 52718, '2017-06-01', '2017-05-01', '2017-07-04', 2082, 775511.1080, 0.0000, 39124.4600, 814635.5680, '2017-06-27 07:52:33', 'dbo', ''),
(2017050032, 201705, 31, 32, '2017-06-27', 2558, 'ENERGY', 88691, 85380, '2017-06-01', '2017-05-01', '2017-07-04', 3311, 1257341.6190, 0.0000, 62048.3500, 1319389.9690, '2017-06-27 07:52:33', 'dbo', ''),
(2017050033, 201705, 31, 33, '2017-06-27', 2559, 'ENERGY', 10153, 9786, '2017-06-01', '2017-05-01', '2017-07-04', 367, 154280.7834, 0.0000, 7135.4600, 161416.2434, '2017-06-27 07:52:33', 'dbo', ''),
(2017050034, 201705, 31, 34, '2017-06-27', 2560, 'ENERGY', 7583, 7178, '2017-06-01', '2017-05-01', '2017-07-04', 405, 119603.1542, 0.0000, 7844.2500, 127447.4042, '2017-06-27 07:52:33', 'dbo', ''),
(2017050035, 201705, 31, 35, '2017-06-27', 2561, 'ENERGY', 15000, 14612, '2017-06-01', '2017-05-01', '2017-07-04', 388, 225711.0926, 0.0000, 7527.1600, 233238.2526, '2017-06-27 07:52:33', 'dbo', ''),
(2017050036, 201705, 31, 36, '2017-06-27', 2562, 'ENERGY', 35210, 33902, '2017-06-01', '2017-05-01', '2017-07-04', 1308, 549718.2938, 0.0000, 24687.4400, 574405.7338, '2017-06-27 07:52:33', 'dbo', ''),
(2017050037, 201705, 31, 37, '2017-06-27', 2563, 'ENERGY', 18963, 18430, '2017-06-01', '2017-05-01', '2017-07-04', 533, 277590.2110, 0.0000, 10231.7700, 287821.9810, '2017-06-27 07:52:33', 'dbo', ''),
(2017050038, 201705, 31, 38, '2017-06-27', 2564, 'ENERGY', 8992, 8685, '2017-06-01', '2017-05-01', '2017-07-04', 307, 138869.3734, 0.0000, 6016.3100, 144885.6834, '2017-06-27 07:52:33', 'dbo', ''),
(2017050039, 201705, 31, 39, '2017-06-27', 2565, 'ENERGY', 24211, 23570, '2017-06-01', '2017-05-01', '2017-07-04', 641, -234401.8718, 0.0000, 12246.2400, -222155.6318, '2017-06-27 07:52:33', 'dbo', ''),
(2017050040, 201705, 31, 40, '2017-06-27', 2566, 'ENERGY', 20532, 19650, '2017-06-01', '2017-05-01', '2017-07-04', 882, 316954.4196, 0.0000, 16741.4900, 333695.9096, '2017-06-27 07:52:33', 'dbo', ''),
(2017050041, 201705, 31, 41, '2017-06-27', 2567, 'ENERGY', 241, 241, '2017-06-01', '2017-05-01', '2017-07-04', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2017-06-27 07:52:33', 'dbo', ''),
(2017050042, 201705, 31, 42, '2017-06-27', 2568, 'ENERGY', 183, 183, '2017-06-01', '2017-05-01', '2017-07-04', 0, 8044.5460, 0.0000, 0.0000, 8044.5460, '2017-06-27 07:52:33', 'dbo', ''),
(2017050043, 201705, 31, 43, '2017-06-27', 2569, 'ENERGY', 56260, 54496, '2017-06-01', '2017-05-01', '2017-07-04', 1764, 698003.7502, 0.0000, 33192.9700, 731196.7202, '2017-06-27 07:52:33', 'dbo', ''),
(2017050044, 201705, 31, 44, '2017-06-27', 2570, 'ENERGY', 30560, 28903, '2017-06-01', '2017-05-01', '2017-07-04', 1657, 528419.6130, 0.0000, 31197.1600, 559616.7730, '2017-06-27 07:52:33', 'dbo', ''),
(2017050045, 201705, 31, 45, '2017-06-27', 2571, 'ENERGY', 29578, 28879, '2017-06-01', '2017-05-01', '2017-07-04', 699, 256904.8020, 0.0000, 13328.0800, 270232.8820, '2017-06-27 07:52:33', 'dbo', ''),
(2017050046, 201705, 31, 46, '2017-06-27', 2572, 'ENERGY', 42278, 40946, '2017-06-01', '2017-05-01', '2017-07-04', 1332, 692882.7854, 0.0000, 25135.1000, 718017.8854, '2017-06-27 07:52:33', 'dbo', ''),
(2017050047, 201705, 31, 47, '2017-06-27', 2573, 'ENERGY', 21493, 20915, '2017-06-01', '2017-05-01', '2017-07-04', 578, 238401.3110, 0.0000, 11071.1300, 249472.4410, '2017-06-27 07:52:33', 'dbo', ''),
(2017050048, 201705, 31, 48, '2017-06-27', 2574, 'ENERGY', 7634, 6750, '2017-06-01', '2017-05-01', '2017-07-04', 884, 128201.1300, 0.0000, 16778.7900, 144979.9200, '2017-06-27 07:52:33', 'dbo', ''),
(2017050049, 201705, 31, 49, '2017-06-27', 2575, 'ENERGY', 4682, 4495, '2017-06-01', '2017-05-01', '2017-07-04', 187, 70177.0490, 0.0000, 3778.0200, 73955.0690, '2017-06-27 07:52:33', 'dbo', ''),
(2017050050, 201705, 31, 50, '2017-06-27', 2576, 'ENERGY', 70976, 68857, '2017-06-01', '2017-05-01', '2017-07-04', 2119, 978711.7492, 0.0000, 39814.6000, 1018526.3492, '2017-06-27 07:52:33', 'dbo', ''),
(2017050051, 201705, 31, 51, '2017-06-27', 2577, 'ENERGY', 211, 211, '2017-06-01', '2017-05-01', '2017-07-04', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2017-06-27 07:52:33', 'dbo', ''),
(2017050052, 201705, 31, 52, '2017-06-27', 2578, 'ENERGY', 321, 321, '2017-06-01', '2017-05-01', '2017-07-04', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2017-06-27 07:52:33', 'dbo', ''),
(2017050053, 201705, 31, 53, '2017-06-27', 2579, 'ENERGY', 1811, 1776, '2017-06-01', '2017-05-01', '2017-07-04', 35, 39978.2270, 0.0000, 942.8300, 40921.0570, '2017-06-27 07:52:33', 'dbo', ''),
(2017050054, 201705, 31, 54, '2017-06-27', 2580, 'ENERGY', 23785, 23043, '2017-06-01', '2017-05-01', '2017-07-04', 742, 175529.8894, 0.0000, 14130.1400, 189660.0294, '2017-06-27 07:52:33', 'dbo', ''),
(2017050055, 201705, 31, 55, '2017-06-27', 2581, 'ENERGY', 12618, 12207, '2017-06-01', '2017-05-01', '2017-07-04', 411, 229840.3500, 0.0000, 7956.1600, 237796.5100, '2017-06-27 07:52:33', 'dbo', ''),
(2017050056, 201705, 31, 56, '2017-06-27', 2582, 'ENERGY', 239, 239, '2017-06-01', '2017-05-01', '2017-07-04', 0, 8516.7790, 0.0000, 0.0000, 8516.7790, '2017-06-27 07:52:33', 'dbo', ''),
(2017050059, 201705, 31, 59, '2017-06-27', 2585, 'ENERGY', 128, 128, '2017-06-01', '2017-05-01', '2017-07-04', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2017-06-27 07:52:33', 'dbo', ''),
(2017050060, 201705, 31, 60, '2017-06-27', 2586, 'ENERGY', 176040, 168394, '2017-06-01', '2017-05-01', '2017-07-04', 7646, 1798867.6200, 0.0000, 142906.8500, 1941774.4700, '2017-06-27 07:52:33', 'dbo', ''),
(2017050061, 201705, 31, 61, '2017-06-27', 2587, 'ENERGY', 16, 16, '2017-06-01', '2017-05-01', '2017-07-04', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2017-06-27 07:52:33', 'dbo', ''),
(2017050062, 201705, 31, 62, '2017-06-27', 2588, 'ENERGY', 30, 30, '2017-06-01', '2017-05-01', '2017-07-04', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-06-27 07:52:33', 'dbo', ''),
(2017050063, 201705, 31, 63, '2017-06-27', 2589, 'ENERGY', 1, 1, '2017-06-01', '2017-05-01', '2017-07-04', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-06-27 07:52:33', 'dbo', ''),
(2017050064, 201705, 31, 64, '2017-06-27', 2590, 'ENERGY', 2, 2, '2017-06-01', '2017-05-01', '2017-07-04', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-06-27 07:52:33', 'dbo', ''),
(2017050065, 201705, 31, 65, '2017-06-27', 2591, 'ENERGY', 5720, 5317, '2017-06-01', '2017-05-01', '2017-07-04', 403, 102515.9080, 0.0000, 7806.9400, 110322.8480, '2017-06-27 07:52:33', 'dbo', ''),
(2017050066, 201705, 31, 66, '2017-06-27', 2592, 'ENERGY', 4683, 4436, '2017-06-01', '2017-05-01', '2017-07-04', 247, 84358.3024, 0.0000, 4897.1600, 89255.4624, '2017-06-27 07:52:33', 'dbo', ''),
(2017050067, 201705, 31, 67, '2017-06-27', 2593, 'ENERGY', 593, 564, '2017-06-01', '2017-05-01', '2017-07-04', 29, 15055.8438, 0.0000, 830.9200, 15886.7638, '2017-06-27 07:52:33', 'dbo', ''),
(2017050068, 201705, 31, 68, '2017-06-27', 2594, 'ENERGY', 1139, 1077, '2017-06-01', '2017-05-01', '2017-07-04', 62, 25422.9700, 0.0000, 1446.4500, 26869.4200, '2017-06-27 07:52:33', 'dbo', ''),
(2017050069, 201705, 31, 69, '2017-06-27', 2595, 'ENERGY', 1, 1, '2017-06-01', '2017-05-01', '2017-07-04', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2017-06-27 07:52:33', 'dbo', ''),
(2017050070, 201705, 31, 70, '2017-06-27', 2596, 'ENERGY', 345, 345, '2017-06-01', '2017-05-01', '2017-07-04', 0, 11744.5000, 0.0000, 0.0000, 11744.5000, '2017-06-27 07:52:33', 'dbo', ''),
(2017050071, 201705, 31, 71, '2017-06-27', 2597, 'ENERGY', 106224, 99190, '2017-06-01', '2017-05-01', '2017-07-04', 7034, 1726981.3562, 0.0000, 131491.5400, 1858472.8962, '2017-06-27 07:52:33', 'dbo', ''),
(2017050072, 201705, 31, 72, '2017-06-27', 2598, 'ENERGY', 1220, 1168, '2017-06-01', '2017-05-01', '2017-07-04', 52, 28465.9800, 0.0000, 1259.9300, 29725.9100, '2017-06-27 07:52:33', 'dbo', ''),
(2017050073, 201705, 31, 73, '2017-06-27', 2599, 'ENERGY', 413, 408, '2017-06-01', '2017-05-01', '2017-07-04', 5, 21093.7780, 0.0000, 383.2700, 21477.0480, '2017-06-27 07:52:33', 'dbo', ''),
(2017050075, 201705, 31, 75, '2017-06-27', 2600, 'ENERGY', 1145, 1103, '2017-06-01', '2017-05-01', '2017-07-04', 42, 26193.0500, 0.0000, 1073.4100, 27266.4600, '2017-06-27 07:52:33', 'dbo', ''),
(2017050076, 201705, 31, 76, '2017-06-27', 2601, 'ENERGY', 1228, 1188, '2017-06-01', '2017-05-01', '2017-07-04', 40, 27710.9700, 0.0000, 1036.1000, 28747.0700, '2017-06-27 07:52:33', 'dbo', ''),
(2017050077, 201705, 31, 77, '2017-06-27', 2602, 'ENERGY', 1003, 973, '2017-06-01', '2017-05-01', '2017-07-04', 30, 23707.1500, 0.0000, 849.5800, 24556.7300, '2017-06-27 07:52:33', 'dbo', ''),
(2017050078, 201705, 31, 78, '2017-06-27', 2603, 'ENERGY', 261, 249, '2017-06-01', '2017-05-01', '2017-07-04', 12, 10594.9400, 0.0000, 513.8300, 11108.7700, '2017-06-27 07:52:33', 'dbo', ''),
(2017050079, 201705, 31, 79, '2017-06-27', 2604, 'ENERGY', 30121, 28730, '2017-06-01', '2017-05-01', '2017-07-04', 1391, 423599.6700, 0.0000, 26235.5900, 449835.2600, '2017-06-27 07:52:33', 'dbo', ''),
(2017050080, 201705, 31, 80, '2017-06-27', 2605, 'ENERGY', 311, 311, '2017-06-01', '2017-05-01', '2017-07-04', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2017-06-27 07:52:33', 'dbo', ''),
(2017050081, 201705, 31, 81, '2017-06-27', 2606, 'ENERGY', 1060, 1007, '2017-06-01', '2017-05-01', '2017-07-04', 53, 21107.0700, 0.0000, 1278.5800, 22385.6500, '2017-06-27 07:52:33', 'dbo', ''),
(2017050082, 201705, 31, 82, '2017-06-27', 2607, 'ENERGY', 1843, 1718, '2017-06-01', '2017-05-01', '2017-07-04', 125, 35387.1500, 0.0000, 2621.5700, 38008.7200, '2017-06-27 07:52:33', 'dbo', ''),
(2017050083, 201705, 31, 83, '2017-06-27', 2608, 'ENERGY', 46, 42, '2017-06-01', '2017-05-01', '2017-07-04', 4, 2276.1400, 0.0000, 364.6100, 2640.7500, '2017-06-27 07:52:33', 'dbo', ''),
(2017050084, 201705, 31, 84, '2017-06-27', 2609, 'ENERGY', 28, 25, '2017-06-01', '2017-05-01', '2017-07-04', 3, 2196.9900, 0.0000, 345.9600, 2542.9500, '2017-06-27 07:52:33', 'dbo', ''),
(2017050085, 201705, 31, 85, '2017-06-27', 2610, 'ENERGY', 0, 0, '2017-06-01', '2017-05-01', '2017-07-04', 0, 0.0000, 0.0000, 0.0000, 0.0000, '2017-06-27 07:52:33', 'dbo', ''),
(2017050086, 201705, 31, 86, '2017-06-27', 2611, 'ENERGY', 39, 35, '2017-06-01', '2017-05-01', '2017-07-04', 4, 1808.0800, 0.0000, 364.6100, 2172.6900, '2017-06-27 07:52:33', 'dbo', ''),
(2017060001, 201706, 32, 1, '2017-07-15', 2612, 'ENERGY', 14016, 14016, '2017-07-01', '2017-06-01', '2017-07-22', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2017-07-15 09:05:53', 'dbo', ''),
(2017060002, 201706, 32, 2, '2017-07-15', 2613, 'ENERGY', 7081, 7081, '2017-07-01', '2017-06-01', '2017-07-22', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2017-07-15 09:05:53', 'dbo', ''),
(2017060003, 201706, 32, 3, '2017-07-15', 2614, 'ENERGY', 8948, 8948, '2017-07-01', '2017-06-01', '2017-07-22', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2017-07-15 09:05:53', 'dbo', ''),
(2017060004, 201706, 32, 4, '2017-07-15', 2615, 'ENERGY', 6711, 6711, '2017-07-01', '2017-06-01', '2017-07-22', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2017-07-15 09:05:53', 'dbo', ''),
(2017060005, 201706, 32, 5, '2017-07-15', 2616, 'ENERGY', 5255, 5255, '2017-07-01', '2017-06-01', '2017-07-22', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2017-07-15 09:05:53', 'dbo', ''),
(2017060006, 201706, 32, 6, '2017-07-15', 2617, 'ENERGY', 13833, 13833, '2017-07-01', '2017-06-01', '2017-07-22', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2017-07-15 09:05:53', 'dbo', ''),
(2017060007, 201706, 32, 7, '2017-07-15', 2618, 'ENERGY', 9652, 9652, '2017-07-01', '2017-06-01', '2017-07-22', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2017-07-15 09:05:53', 'dbo', ''),
(2017060008, 201706, 32, 8, '2017-07-15', 2619, 'ENERGY', 167, 167, '2017-07-01', '2017-06-01', '2017-07-22', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2017-07-15 09:05:53', 'dbo', ''),
(2017060009, 201706, 32, 9, '2017-07-15', 2620, 'ENERGY', 194, 140, '2017-07-01', '2017-06-01', '2017-07-22', 54, 10052.9464, 0.0000, 1295.6600, 11348.6064, '2017-07-15 09:05:52', 'dbo', ''),
(2017060010, 201706, 32, 10, '2017-07-15', 2621, 'ENERGY', 87, 87, '2017-07-01', '2017-06-01', '2017-07-22', 0, 6435.8780, 0.0000, 0.0000, 6435.8780, '2017-07-15 09:05:53', 'dbo', ''),
(2017060011, 201706, 32, 11, '2017-07-15', 2622, 'ENERGY', 201, 201, '2017-07-01', '2017-06-01', '2017-07-22', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2017-07-15 09:05:53', 'dbo', ''),
(2017060012, 201706, 32, 12, '2017-07-15', 2623, 'ENERGY', 137, 125, '2017-07-01', '2017-06-01', '2017-07-22', 12, 7909.6200, 0.0000, 513.4800, 8423.1000, '2017-07-15 09:05:52', 'dbo', ''),
(2017060013, 201706, 32, 13, '2017-07-15', 2624, 'ENERGY', 4542, 4027, '2017-07-01', '2017-06-01', '2017-07-22', 515, 82692.0840, 0.0000, 9881.0400, 92573.1240, '2017-07-15 09:05:52', 'dbo', ''),
(2017060014, 201706, 32, 14, '2017-07-15', 2625, 'ENERGY', 1771, 1607, '2017-07-01', '2017-06-01', '2017-07-22', 164, 37825.0754, 0.0000, 3344.2400, 41169.3154, '2017-07-15 09:05:52', 'dbo', ''),
(2017060015, 201706, 32, 15, '2017-07-15', 2626, 'ENERGY', 162, 162, '2017-07-01', '2017-06-01', '2017-07-22', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2017-07-15 09:05:53', 'dbo', ''),
(2017060016, 201706, 32, 16, '2017-07-15', 2627, 'ENERGY', 4452, 3870, '2017-07-01', '2017-06-01', '2017-07-22', 582, 79124.1120, 0.0000, 11128.8100, 90252.9220, '2017-07-15 09:05:52', 'dbo', ''),
(2017060017, 201706, 32, 17, '2017-07-15', 2628, 'ENERGY', 12027, 10599, '2017-07-01', '2017-06-01', '2017-07-22', 1428, 199435.0770, 0.0000, 26884.2000, 226319.2770, '2017-07-15 09:05:52', 'dbo', ''),
(2017060018, 201706, 32, 18, '2017-07-15', 2629, 'ENERGY', 4049, 3667, '2017-07-01', '2017-06-01', '2017-07-22', 382, 72431.9800, 0.0000, 7404.1300, 79836.1100, '2017-07-15 09:05:52', 'dbo', ''),
(2017060019, 201706, 32, 19, '2017-07-15', 2630, 'ENERGY', 75, 75, '2017-07-01', '2017-06-01', '2017-07-22', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2017-07-15 09:05:53', 'dbo', ''),
(2017060020, 201706, 32, 20, '2017-07-15', 2631, 'ENERGY', 254, 249, '2017-07-01', '2017-06-01', '2017-07-22', 5, 6696.2930, 0.0000, 383.1200, 7079.4130, '2017-07-15 09:05:52', 'dbo', ''),
(2017060021, 201706, 32, 21, '2017-07-15', 2632, 'ENERGY', 41956, 41380, '2017-07-01', '2017-06-01', '2017-07-22', 576, 538173.5546, 0.0000, 11017.0800, 549190.6346, '2017-07-15 09:05:52', 'dbo', ''),
(2017060022, 201706, 32, 22, '2017-07-15', 2633, 'ENERGY', 24024, 23597, '2017-07-01', '2017-06-01', '2017-07-22', 427, 300527.8716, 0.0000, 8242.1800, 308770.0516, '2017-07-15 09:05:52', 'dbo', ''),
(2017060023, 201706, 32, 23, '2017-07-15', 2634, 'ENERGY', 63075, 61681, '2017-07-01', '2017-06-01', '2017-07-22', 1394, 820971.7470, 0.0000, 26251.0000, 847222.7470, '2017-07-15 09:05:52', 'dbo', ''),
(2017060024, 201706, 32, 24, '2017-07-15', 2635, 'ENERGY', 42322, 41828, '2017-07-01', '2017-06-01', '2017-07-22', 494, 505877.5000, 0.0000, 9489.9500, 515367.4500, '2017-07-15 09:05:52', 'dbo', ''),
(2017060025, 201706, 32, 25, '2017-07-15', 2636, 'ENERGY', 40752, 36619, '2017-07-01', '2017-06-01', '2017-07-22', 4133, 679198.9200, 0.0000, 77260.4600, 756459.3800, '2017-07-15 09:05:52', 'dbo', ''),
(2017060026, 201706, 32, 26, '2017-07-15', 2637, 'ENERGY', 54430, 53178, '2017-07-01', '2017-06-01', '2017-07-22', 1252, 842986.3474, 0.0000, 23606.4800, 866592.8274, '2017-07-15 09:05:52', 'dbo', ''),
(2017060029, 201706, 32, 29, '2017-07-15', 2640, 'ENERGY', 76542, 74715, '2017-07-01', '2017-06-01', '2017-07-22', 1827, 1097862.7188, 0.0000, 34314.9200, 1132177.6388, '2017-07-15 09:05:52', 'dbo', ''),
(2017060030, 201706, 32, 30, '2017-07-15', 2641, 'ENERGY', 37090, 36200, '2017-07-01', '2017-06-01', '2017-07-22', 890, 425143.0612, 0.0000, 16864.8200, 442007.8812, '2017-07-15 09:05:52', 'dbo', ''),
(2017060031, 201706, 32, 31, '2017-07-15', 2642, 'ENERGY', 56683, 54800, '2017-07-01', '2017-06-01', '2017-07-22', 1883, 814635.5680, 0.0000, 35357.8300, 849993.3980, '2017-07-15 09:05:52', 'dbo', ''),
(2017060032, 201706, 32, 32, '2017-07-15', 2643, 'ENERGY', 91785, 88691, '2017-07-01', '2017-06-01', '2017-07-22', 3094, 1319389.9690, 0.0000, 57910.7700, 1377300.7390, '2017-07-15 09:05:52', 'dbo', ''),
(2017060033, 201706, 32, 33, '2017-07-15', 2644, 'ENERGY', 10651, 10153, '2017-07-01', '2017-06-01', '2017-07-22', 498, 161416.2434, 0.0000, 9564.4500, 170980.6934, '2017-07-15 09:05:52', 'dbo', ''),
(2017060034, 201706, 32, 34, '2017-07-15', 2645, 'ENERGY', 7991, 7583, '2017-07-01', '2017-06-01', '2017-07-22', 408, 127447.4042, 0.0000, 7888.3400, 135335.7442, '2017-07-15 09:05:52', 'dbo', ''),
(2017060035, 201706, 32, 35, '2017-07-15', 2646, 'ENERGY', 15388, 15000, '2017-07-01', '2017-06-01', '2017-07-22', 388, 233238.2526, 0.0000, 7515.8800, 240754.1326, '2017-07-15 09:05:52', 'dbo', ''),
(2017060036, 201706, 32, 36, '2017-07-15', 2647, 'ENERGY', 36480, 35210, '2017-07-01', '2017-06-01', '2017-07-22', 1270, 574405.7338, 0.0000, 23941.7000, 598347.4338, '2017-07-15 09:05:52', 'dbo', ''),
(2017060037, 201706, 32, 37, '2017-07-15', 2648, 'ENERGY', 19483, 18963, '2017-07-01', '2017-06-01', '2017-07-22', 520, 287821.9810, 0.0000, 9974.1700, 297796.1510, '2017-07-15 09:05:52', 'dbo', ''),
(2017060038, 201706, 32, 38, '2017-07-15', 2649, 'ENERGY', 9402, 8992, '2017-07-01', '2017-06-01', '2017-07-22', 410, 144885.6834, 0.0000, 7925.5900, 152811.2734, '2017-07-15 09:05:52', 'dbo', ''),
(2017060039, 201706, 32, 39, '2017-07-15', 2650, 'ENERGY', 24797, 24211, '2017-07-01', '2017-06-01', '2017-07-22', 586, -222155.6318, 0.0000, 11203.3100, -210952.3218, '2017-07-15 09:05:52', 'dbo', ''),
(2017060040, 201706, 32, 40, '2017-07-15', 2651, 'ENERGY', 21336, 20532, '2017-07-01', '2017-06-01', '2017-07-22', 804, 333695.9096, 0.0000, 15263.2100, 348959.1196, '2017-07-15 09:05:52', 'dbo', ''),
(2017060041, 201706, 32, 41, '2017-07-15', 2652, 'ENERGY', 241, 241, '2017-07-01', '2017-06-01', '2017-07-22', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2017-07-15 09:05:53', 'dbo', ''),
(2017060042, 201706, 32, 42, '2017-07-15', 2653, 'ENERGY', 183, 183, '2017-07-01', '2017-06-01', '2017-07-22', 0, 8044.5460, 0.0000, 0.0000, 8044.5460, '2017-07-15 09:05:53', 'dbo', ''),
(2017060043, 201706, 32, 43, '2017-07-15', 2654, 'ENERGY', 57699, 56260, '2017-07-01', '2017-06-01', '2017-07-22', 1439, 731196.7202, 0.0000, 27089.0500, 758285.7702, '2017-07-15 09:05:52', 'dbo', ''),
(2017060044, 201706, 32, 44, '2017-07-15', 2655, 'ENERGY', 32154, 30560, '2017-07-01', '2017-06-01', '2017-07-22', 1594, 559616.7730, 0.0000, 29975.6900, 589592.4630, '2017-07-15 09:05:52', 'dbo', ''),
(2017060045, 201706, 32, 45, '2017-07-15', 2656, 'ENERGY', 30207, 29578, '2017-07-01', '2017-06-01', '2017-07-22', 629, 270232.8820, 0.0000, 12004.1100, 282236.9920, '2017-07-15 09:05:52', 'dbo', ''),
(2017060046, 201706, 32, 46, '2017-07-15', 2657, 'ENERGY', 43446, 42278, '2017-07-01', '2017-06-01', '2017-07-22', 1168, 718017.8854, 0.0000, 22042.1100, 740059.9954, '2017-07-15 09:05:52', 'dbo', ''),
(2017060047, 201706, 32, 47, '2017-07-15', 2658, 'ENERGY', 22017, 21493, '2017-07-01', '2017-06-01', '2017-07-22', 524, 249472.4410, 0.0000, 10048.6500, 259521.0910, '2017-07-15 09:05:52', 'dbo', ''),
(2017060048, 201706, 32, 48, '2017-07-15', 2659, 'ENERGY', 8424, 7634, '2017-07-01', '2017-06-01', '2017-07-22', 790, 144979.9200, 0.0000, 15002.4800, 159982.4000, '2017-07-15 09:05:52', 'dbo', ''),
(2017060049, 201706, 32, 49, '2017-07-15', 2660, 'ENERGY', 4865, 4682, '2017-07-01', '2017-06-01', '2017-07-22', 183, 73955.0690, 0.0000, 3698.0700, 77653.1390, '2017-07-15 09:05:52', 'dbo', ''),
(2017060050, 201706, 32, 50, '2017-07-15', 2661, 'ENERGY', 72984, 70976, '2017-07-01', '2017-06-01', '2017-07-22', 2008, 1018526.3492, 0.0000, 37685.7700, 1056212.1192, '2017-07-15 09:05:52', 'dbo', ''),
(2017060051, 201706, 32, 51, '2017-07-15', 2662, 'ENERGY', 211, 211, '2017-07-01', '2017-06-01', '2017-07-22', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2017-07-15 09:05:53', 'dbo', ''),
(2017060052, 201706, 32, 52, '2017-07-15', 2663, 'ENERGY', 321, 321, '2017-07-01', '2017-06-01', '2017-07-22', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2017-07-15 09:05:53', 'dbo', ''),
(2017060053, 201706, 32, 53, '2017-07-15', 2664, 'ENERGY', 1817, 1811, '2017-07-01', '2017-06-01', '2017-07-22', 6, 40921.0570, 0.0000, 401.7500, 41322.8070, '2017-07-15 09:05:52', 'dbo', ''),
(2017060054, 201706, 32, 54, '2017-07-15', 2665, 'ENERGY', 24449, 23785, '2017-07-01', '2017-06-01', '2017-07-22', 664, 189660.0294, 0.0000, 12655.9400, 202315.9694, '2017-07-15 09:05:52', 'dbo', ''),
(2017060055, 201706, 32, 55, '2017-07-15', 2666, 'ENERGY', 12689, 12618, '2017-07-01', '2017-06-01', '2017-07-22', 71, 237796.5100, 0.0000, 1612.2600, 239408.7700, '2017-07-15 09:05:52', 'dbo', ''),
(2017060056, 201706, 32, 56, '2017-07-15', 2667, 'ENERGY', 239, 239, '2017-07-01', '2017-06-01', '2017-07-22', 0, 8516.7790, 0.0000, 0.0000, 8516.7790, '2017-07-15 09:05:53', 'dbo', ''),
(2017060059, 201706, 32, 59, '2017-07-15', 2670, 'ENERGY', 128, 128, '2017-07-01', '2017-06-01', '2017-07-22', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2017-07-15 09:05:53', 'dbo', ''),
(2017060060, 201706, 32, 60, '2017-07-15', 2671, 'ENERGY', 183211, 176040, '2017-07-01', '2017-06-01', '2017-07-22', 7171, 1941774.4700, 0.0000, 133838.3100, 2075612.7800, '2017-07-15 09:05:52', 'dbo', ''),
(2017060061, 201706, 32, 61, '2017-07-15', 2672, 'ENERGY', 16, 16, '2017-07-01', '2017-06-01', '2017-07-22', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2017-07-15 09:05:53', 'dbo', ''),
(2017060062, 201706, 32, 62, '2017-07-15', 2673, 'ENERGY', 30, 30, '2017-07-01', '2017-06-01', '2017-07-22', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-07-15 09:05:53', 'dbo', ''),
(2017060063, 201706, 32, 63, '2017-07-15', 2674, 'ENERGY', 1, 1, '2017-07-01', '2017-06-01', '2017-07-22', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-07-15 09:05:53', 'dbo', ''),
(2017060064, 201706, 32, 64, '2017-07-15', 2675, 'ENERGY', 2, 2, '2017-07-01', '2017-06-01', '2017-07-22', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-07-15 09:05:53', 'dbo', ''),
(2017060065, 201706, 32, 65, '2017-07-15', 2676, 'ENERGY', 6090, 5720, '2017-07-01', '2017-06-01', '2017-07-22', 370, 110322.8480, 0.0000, 7180.6500, 117503.4980, '2017-07-15 09:05:52', 'dbo', ''),
(2017060066, 201706, 32, 66, '2017-07-15', 2677, 'ENERGY', 4897, 4683, '2017-07-01', '2017-06-01', '2017-07-22', 214, 89255.4624, 0.0000, 4275.4000, 93530.8624, '2017-07-15 09:05:52', 'dbo', ''),
(2017060067, 201706, 32, 67, '2017-07-15', 2678, 'ENERGY', 619, 593, '2017-07-01', '2017-06-01', '2017-07-22', 26, 15886.7638, 0.0000, 774.2100, 16660.9738, '2017-07-15 09:05:53', 'dbo', ''),
(2017060068, 201706, 32, 68, '2017-07-15', 2679, 'ENERGY', 1209, 1139, '2017-07-01', '2017-06-01', '2017-07-22', 70, 26869.4200, 0.0000, 1593.6400, 28463.0600, '2017-07-15 09:05:53', 'dbo', ''),
(2017060069, 201706, 32, 69, '2017-07-15', 2680, 'ENERGY', 1, 1, '2017-07-01', '2017-06-01', '2017-07-22', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2017-07-15 09:05:53', 'dbo', ''),
(2017060070, 201706, 32, 70, '2017-07-15', 2681, 'ENERGY', 345, 345, '2017-07-01', '2017-06-01', '2017-07-22', 0, 11744.5000, 0.0000, 0.0000, 11744.5000, '2017-07-15 09:05:53', 'dbo', ''),
(2017060071, 201706, 32, 71, '2017-07-15', 2682, 'ENERGY', 112532, 106224, '2017-07-01', '2017-06-01', '2017-07-22', 6308, 1858472.8962, 0.0000, 117766.3400, 1976239.2362, '2017-07-15 09:05:52', 'dbo', ''),
(2017060072, 201706, 32, 72, '2017-07-15', 2683, 'ENERGY', 1277, 1220, '2017-07-01', '2017-06-01', '2017-07-22', 57, 29725.9100, 0.0000, 1351.5300, 31077.4400, '2017-07-15 09:05:52', 'dbo', ''),
(2017060073, 201706, 32, 73, '2017-07-15', 2684, 'ENERGY', 426, 413, '2017-07-01', '2017-06-01', '2017-07-22', 13, 21477.0480, 0.0000, 532.1000, 22009.1480, '2017-07-15 09:05:52', 'dbo', ''),
(2017060075, 201706, 32, 75, '2017-07-15', 2685, 'ENERGY', 1185, 1145, '2017-07-01', '2017-06-01', '2017-07-22', 40, 27266.4600, 0.0000, 1034.9300, 28301.3900, '2017-07-15 09:05:52', 'dbo', ''),
(2017060076, 201706, 32, 76, '2017-07-15', 2686, 'ENERGY', 1266, 1228, '2017-07-01', '2017-06-01', '2017-07-22', 38, 28747.0700, 0.0000, 997.6800, 29744.7500, '2017-07-15 09:05:52', 'dbo', ''),
(2017060077, 201706, 32, 77, '2017-07-15', 2687, 'ENERGY', 1030, 1003, '2017-07-01', '2017-06-01', '2017-07-22', 27, 24556.7300, 0.0000, 792.8300, 25349.5600, '2017-07-15 09:05:52', 'dbo', ''),
(2017060078, 201706, 32, 78, '2017-07-15', 2688, 'ENERGY', 271, 261, '2017-07-01', '2017-06-01', '2017-07-22', 10, 11108.7700, 0.0000, 476.2300, 11585.0000, '2017-07-15 09:05:52', 'dbo', ''),
(2017060079, 201706, 32, 79, '2017-07-15', 2689, 'ENERGY', 31550, 30121, '2017-07-01', '2017-06-01', '2017-07-22', 1429, 449835.2600, 0.0000, 26902.8200, 476738.0800, '2017-07-15 09:05:52', 'dbo', ''),
(2017060080, 201706, 32, 80, '2017-07-15', 2690, 'ENERGY', 311, 311, '2017-07-01', '2017-06-01', '2017-07-22', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2017-07-15 09:05:53', 'dbo', ''),
(2017060081, 201706, 32, 81, '2017-07-15', 2691, 'ENERGY', 1109, 1060, '2017-07-01', '2017-06-01', '2017-07-22', 49, 22385.6500, 0.0000, 1202.5500, 23588.2000, '2017-07-15 09:05:52', 'dbo', ''),
(2017060082, 201706, 32, 82, '2017-07-15', 2692, 'ENERGY', 1964, 1843, '2017-07-01', '2017-06-01', '2017-07-22', 121, 38008.7200, 0.0000, 2543.4300, 40552.1500, '2017-07-15 09:05:52', 'dbo', ''),
(2017060083, 201706, 32, 83, '2017-07-15', 2693, 'ENERGY', 49, 46, '2017-07-01', '2017-06-01', '2017-07-22', 3, 2640.7500, 0.0000, 345.8700, 2986.6200, '2017-07-15 09:05:52', 'dbo', ''),
(2017060084, 201706, 32, 84, '2017-07-15', 2694, 'ENERGY', 30, 28, '2017-07-01', '2017-06-01', '2017-07-22', 2, 2542.9500, 0.0000, 327.2500, 2870.2000, '2017-07-15 09:05:52', 'dbo', ''),
(2017060085, 201706, 32, 85, '2017-07-15', 2695, 'ENERGY', 0, 0, '2017-07-01', '2017-06-01', '2017-07-22', 0, 0.0000, 0.0000, 0.0000, 0.0000, '2017-07-15 09:05:53', 'dbo', ''),
(2017060086, 201706, 32, 86, '2017-07-15', 2696, 'ENERGY', 43, 39, '2017-07-01', '2017-06-01', '2017-07-22', 4, 2172.6900, 0.0000, 364.5000, 2537.1900, '2017-07-15 09:05:52', 'dbo', ''),
(2017070001, 201707, 33, 1, '2017-09-06', 2697, 'ENERGY', 14016, 14016, '2017-08-01', '2017-07-01', '2017-09-13', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2017-09-06 14:24:42', 'dbo', ''),
(2017070002, 201707, 33, 2, '2017-09-06', 2698, 'ENERGY', 7081, 7081, '2017-08-01', '2017-07-01', '2017-09-13', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2017-09-06 14:24:42', 'dbo', ''),
(2017070003, 201707, 33, 3, '2017-09-06', 2699, 'ENERGY', 8948, 8948, '2017-08-01', '2017-07-01', '2017-09-13', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2017-09-06 14:24:42', 'dbo', ''),
(2017070004, 201707, 33, 4, '2017-09-06', 2700, 'ENERGY', 6711, 6711, '2017-08-01', '2017-07-01', '2017-09-13', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2017-09-06 14:24:42', 'dbo', ''),
(2017070005, 201707, 33, 5, '2017-09-06', 2701, 'ENERGY', 5255, 5255, '2017-08-01', '2017-07-01', '2017-09-13', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2017-09-06 14:24:42', 'dbo', ''),
(2017070006, 201707, 33, 6, '2017-09-06', 2702, 'ENERGY', 13833, 13833, '2017-08-01', '2017-07-01', '2017-09-13', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2017-09-06 14:24:42', 'dbo', ''),
(2017070007, 201707, 33, 7, '2017-09-06', 2703, 'ENERGY', 9652, 9652, '2017-08-01', '2017-07-01', '2017-09-13', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2017-09-06 14:24:42', 'dbo', ''),
(2017070008, 201707, 33, 8, '2017-09-06', 2704, 'ENERGY', 167, 167, '2017-08-01', '2017-07-01', '2017-09-13', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2017-09-06 14:24:42', 'dbo', ''),
(2017070009, 201707, 33, 9, '2017-09-06', 2705, 'ENERGY', 194, 194, '2017-08-01', '2017-07-01', '2017-09-13', 0, 11348.6064, 0.0000, 0.0000, 11348.6064, '2017-09-06 14:24:42', 'dbo', ''),
(2017070010, 201707, 33, 10, '2017-09-06', 2706, 'ENERGY', 87, 87, '2017-08-01', '2017-07-01', '2017-09-13', 0, 6435.8780, 0.0000, 0.0000, 6435.8780, '2017-09-06 14:24:42', 'dbo', '');
INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2017070011, 201707, 33, 11, '2017-09-06', 2707, 'ENERGY', 201, 201, '2017-08-01', '2017-07-01', '2017-09-13', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2017-09-06 14:24:42', 'dbo', ''),
(2017070012, 201707, 33, 12, '2017-09-06', 2708, 'ENERGY', 137, 137, '2017-08-01', '2017-07-01', '2017-09-13', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2017-09-06 14:24:42', 'dbo', ''),
(2017070013, 201707, 33, 13, '2017-09-06', 2709, 'ENERGY', 5121, 4542, '2017-08-01', '2017-07-01', '2017-09-13', 579, 92573.1240, 0.0000, 11149.9100, 103723.0340, '2017-09-06 14:24:41', 'dbo', ''),
(2017070014, 201707, 33, 14, '2017-09-06', 2710, 'ENERGY', 1932, 1771, '2017-08-01', '2017-07-01', '2017-09-13', 161, 41169.3154, 0.0000, 3309.7600, 44479.0754, '2017-09-06 14:24:41', 'dbo', ''),
(2017070015, 201707, 33, 15, '2017-09-06', 2711, 'ENERGY', 162, 162, '2017-08-01', '2017-07-01', '2017-09-13', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2017-09-06 14:24:42', 'dbo', ''),
(2017070016, 201707, 33, 16, '2017-09-06', 2712, 'ENERGY', 5168, 4452, '2017-08-01', '2017-07-01', '2017-09-13', 716, 90252.9220, 0.0000, 13719.5200, 103972.4420, '2017-09-06 14:24:41', 'dbo', ''),
(2017070017, 201707, 33, 17, '2017-09-06', 2713, 'ENERGY', 13451, 12027, '2017-08-01', '2017-07-01', '2017-09-13', 1424, 226319.2770, 0.0000, 26999.0000, 253318.2770, '2017-09-06 14:24:41', 'dbo', ''),
(2017070018, 201707, 33, 18, '2017-09-06', 2714, 'ENERGY', 4544, 4049, '2017-08-01', '2017-07-01', '2017-09-13', 495, 79836.1100, 0.0000, 9574.3800, 89410.4900, '2017-09-06 14:24:41', 'dbo', ''),
(2017070019, 201707, 33, 19, '2017-09-06', 2715, 'ENERGY', 75, 75, '2017-08-01', '2017-07-01', '2017-09-13', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2017-09-06 14:24:42', 'dbo', ''),
(2017070020, 201707, 33, 20, '2017-09-06', 2716, 'ENERGY', 254, 254, '2017-08-01', '2017-07-01', '2017-09-13', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2017-09-06 14:24:42', 'dbo', ''),
(2017070021, 201707, 33, 21, '2017-09-06', 2717, 'ENERGY', 42579, 41956, '2017-08-01', '2017-07-01', '2017-09-13', 623, 549190.6346, 0.0000, 11975.1900, 561165.8246, '2017-09-06 14:24:41', 'dbo', ''),
(2017070022, 201707, 33, 22, '2017-09-06', 2718, 'ENERGY', 24526, 24024, '2017-08-01', '2017-07-01', '2017-09-13', 502, 308770.0516, 0.0000, 9705.6600, 318475.7116, '2017-09-06 14:24:41', 'dbo', ''),
(2017070023, 201707, 33, 23, '2017-09-06', 2719, 'ENERGY', 64469, 63075, '2017-08-01', '2017-07-01', '2017-09-13', 1394, 847222.7470, 0.0000, 26436.3200, 873659.0670, '2017-09-06 14:24:41', 'dbo', ''),
(2017070024, 201707, 33, 24, '2017-09-06', 2720, 'ENERGY', 42782, 42322, '2017-08-01', '2017-07-01', '2017-09-13', 460, 515367.4500, 0.0000, 8917.9000, 524285.3500, '2017-09-06 14:24:41', 'dbo', ''),
(2017070025, 201707, 33, 25, '2017-09-06', 2721, 'ENERGY', 45396, 40752, '2017-08-01', '2017-07-01', '2017-09-13', 4644, 756459.3800, 0.0000, 87394.3500, 843853.7300, '2017-09-06 14:24:41', 'dbo', ''),
(2017070026, 201707, 33, 26, '2017-09-06', 2722, 'ENERGY', 55852, 54430, '2017-08-01', '2017-07-01', '2017-09-13', 1422, 866592.8274, 0.0000, 26961.4800, 893554.3074, '2017-09-06 14:24:41', 'dbo', ''),
(2017070029, 201707, 33, 29, '2017-09-06', 2725, 'ENERGY', 78662, 76542, '2017-08-01', '2017-07-01', '2017-09-13', 2120, 1132177.6388, 0.0000, 40053.3900, 1172231.0288, '2017-09-06 14:24:41', 'dbo', ''),
(2017070030, 201707, 33, 30, '2017-09-06', 2726, 'ENERGY', 38085, 37090, '2017-08-01', '2017-07-01', '2017-09-13', 995, 442007.8812, 0.0000, 18952.5400, 460960.4212, '2017-09-06 14:24:41', 'dbo', ''),
(2017070031, 201707, 33, 31, '2017-09-06', 2727, 'ENERGY', 58701, 56683, '2017-08-01', '2017-07-01', '2017-09-13', 2018, 849993.3980, 0.0000, 38140.2600, 888133.6580, '2017-09-06 14:24:41', 'dbo', ''),
(2017070032, 201707, 33, 32, '2017-09-06', 2728, 'ENERGY', 95301, 91785, '2017-08-01', '2017-07-01', '2017-09-13', 3516, 1377300.7390, 0.0000, 66237.2200, 1443537.9590, '2017-09-06 14:24:41', 'dbo', ''),
(2017070033, 201707, 33, 33, '2017-09-06', 2729, 'ENERGY', 11375, 10651, '2017-08-01', '2017-07-01', '2017-09-13', 724, 170980.6934, 0.0000, 13869.5700, 184850.2634, '2017-09-06 14:24:41', 'dbo', ''),
(2017070034, 201707, 33, 34, '2017-09-06', 2730, 'ENERGY', 8460, 7991, '2017-08-01', '2017-07-01', '2017-09-13', 469, 135335.7442, 0.0000, 9086.7200, 144422.4642, '2017-09-06 14:24:41', 'dbo', ''),
(2017070035, 201707, 33, 35, '2017-09-06', 2731, 'ENERGY', 15830, 15388, '2017-08-01', '2017-07-01', '2017-09-13', 442, 240754.1326, 0.0000, 8580.2900, 249334.4226, '2017-09-06 14:24:41', 'dbo', ''),
(2017070036, 201707, 33, 36, '2017-09-06', 2732, 'ENERGY', 37645, 36480, '2017-08-01', '2017-07-01', '2017-09-13', 1165, 598347.4338, 0.0000, 22141.1100, 620488.5438, '2017-09-06 14:24:41', 'dbo', ''),
(2017070037, 201707, 33, 37, '2017-09-06', 2733, 'ENERGY', 19989, 19483, '2017-08-01', '2017-07-01', '2017-09-13', 506, 297796.1510, 0.0000, 9780.7000, 307576.8510, '2017-09-06 14:24:41', 'dbo', ''),
(2017070038, 201707, 33, 38, '2017-09-06', 2734, 'ENERGY', 9888, 9402, '2017-08-01', '2017-07-01', '2017-09-13', 486, 152811.2734, 0.0000, 9405.5700, 162216.8434, '2017-09-06 14:24:41', 'dbo', ''),
(2017070039, 201707, 33, 39, '2017-09-06', 2735, 'ENERGY', 25198, 24797, '2017-08-01', '2017-07-01', '2017-09-13', 401, -210952.3218, 0.0000, 7811.2800, -203141.0418, '2017-09-06 14:24:41', 'dbo', ''),
(2017070040, 201707, 33, 40, '2017-09-06', 2736, 'ENERGY', 22231, 21336, '2017-08-01', '2017-07-01', '2017-09-13', 895, 348959.1196, 0.0000, 17076.9000, 366036.0196, '2017-09-06 14:24:41', 'dbo', ''),
(2017070041, 201707, 33, 41, '2017-09-06', 2737, 'ENERGY', 241, 241, '2017-08-01', '2017-07-01', '2017-09-13', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2017-09-06 14:24:42', 'dbo', ''),
(2017070042, 201707, 33, 42, '2017-09-06', 2738, 'ENERGY', 199, 183, '2017-08-01', '2017-07-01', '2017-09-13', 16, 8044.5460, 0.0000, 590.0900, 8634.6360, '2017-09-06 14:24:41', 'dbo', ''),
(2017070043, 201707, 33, 43, '2017-09-06', 2739, 'ENERGY', 59183, 57699, '2017-08-01', '2017-07-01', '2017-09-13', 1484, 758285.7702, 0.0000, 28124.3800, 786410.1502, '2017-09-06 14:24:41', 'dbo', ''),
(2017070044, 201707, 33, 44, '2017-09-06', 2740, 'ENERGY', 33813, 32154, '2017-08-01', '2017-07-01', '2017-09-13', 1659, 589592.4630, 0.0000, 31406.7300, 620999.1930, '2017-09-06 14:24:41', 'dbo', ''),
(2017070045, 201707, 33, 45, '2017-09-06', 2741, 'ENERGY', 30900, 30207, '2017-08-01', '2017-07-01', '2017-09-13', 693, 282236.9920, 0.0000, 13288.1300, 295525.1220, '2017-09-06 14:24:41', 'dbo', ''),
(2017070046, 201707, 33, 46, '2017-09-06', 2742, 'ENERGY', 44735, 43446, '2017-08-01', '2017-07-01', '2017-09-13', 1289, 740059.9954, 0.0000, 24466.9000, 764526.8954, '2017-09-06 14:24:42', 'dbo', ''),
(2017070047, 201707, 33, 47, '2017-09-06', 2743, 'ENERGY', 22629, 22017, '2017-08-01', '2017-07-01', '2017-09-13', 612, 259521.0910, 0.0000, 11768.8700, 271289.9610, '2017-09-06 14:24:42', 'dbo', ''),
(2017070048, 201707, 33, 48, '2017-09-06', 2744, 'ENERGY', 9415, 8424, '2017-08-01', '2017-07-01', '2017-09-13', 991, 159982.4000, 0.0000, 18877.5100, 178859.9100, '2017-09-06 14:24:42', 'dbo', ''),
(2017070049, 201707, 33, 49, '2017-09-06', 2745, 'ENERGY', 5077, 4865, '2017-08-01', '2017-07-01', '2017-09-13', 212, 77653.1390, 0.0000, 4266.3300, 81919.4690, '2017-09-06 14:24:41', 'dbo', ''),
(2017070050, 201707, 33, 50, '2017-09-06', 2746, 'ENERGY', 75126, 72984, '2017-08-01', '2017-07-01', '2017-09-13', 2142, 1056212.1192, 0.0000, 40466.0300, 1096678.1492, '2017-09-06 14:24:41', 'dbo', ''),
(2017070051, 201707, 33, 51, '2017-09-06', 2747, 'ENERGY', 211, 211, '2017-08-01', '2017-07-01', '2017-09-13', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2017-09-06 14:24:42', 'dbo', ''),
(2017070052, 201707, 33, 52, '2017-09-06', 2748, 'ENERGY', 321, 321, '2017-08-01', '2017-07-01', '2017-09-13', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2017-09-06 14:24:42', 'dbo', ''),
(2017070053, 201707, 33, 53, '2017-09-06', 2749, 'ENERGY', 1817, 1817, '2017-08-01', '2017-07-01', '2017-09-13', 0, 41322.8070, 0.0000, 0.0000, 41322.8070, '2017-09-06 14:24:42', 'dbo', ''),
(2017070054, 201707, 33, 54, '2017-09-06', 2750, 'ENERGY', 25171, 24449, '2017-08-01', '2017-07-01', '2017-09-13', 722, 202315.9694, 0.0000, 13832.0600, 216148.0294, '2017-09-06 14:24:41', 'dbo', ''),
(2017070055, 201707, 33, 55, '2017-09-06', 2751, 'ENERGY', 12689, 12689, '2017-08-01', '2017-07-01', '2017-09-13', 0, 239408.7700, 0.0000, 0.0000, 239408.7700, '2017-09-06 14:24:42', 'dbo', ''),
(2017070056, 201707, 33, 56, '2017-09-06', 2752, 'ENERGY', 239, 239, '2017-08-01', '2017-07-01', '2017-09-13', 0, 8516.7790, 0.0000, 0.0000, 8516.7790, '2017-09-06 14:24:42', 'dbo', ''),
(2017070059, 201707, 33, 59, '2017-09-06', 2755, 'ENERGY', 128, 128, '2017-08-01', '2017-07-01', '2017-09-13', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2017-09-06 14:24:42', 'dbo', ''),
(2017070060, 201707, 33, 60, '2017-09-06', 2756, 'ENERGY', 190840, 183211, '2017-08-01', '2017-07-01', '2017-09-13', 7629, 2075612.7800, 0.0000, 143381.9600, 2218994.7400, '2017-09-06 14:24:41', 'dbo', ''),
(2017070061, 201707, 33, 61, '2017-09-06', 2757, 'ENERGY', 16, 16, '2017-08-01', '2017-07-01', '2017-09-13', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2017-09-06 14:24:42', 'dbo', ''),
(2017070062, 201707, 33, 62, '2017-09-06', 2758, 'ENERGY', 30, 30, '2017-08-01', '2017-07-01', '2017-09-13', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-09-06 14:24:42', 'dbo', ''),
(2017070063, 201707, 33, 63, '2017-09-06', 2759, 'ENERGY', 1, 1, '2017-08-01', '2017-07-01', '2017-09-13', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-09-06 14:24:42', 'dbo', ''),
(2017070064, 201707, 33, 64, '2017-09-06', 2760, 'ENERGY', 2, 2, '2017-08-01', '2017-07-01', '2017-09-13', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-09-06 14:24:42', 'dbo', ''),
(2017070065, 201707, 33, 65, '2017-09-06', 2761, 'ENERGY', 6462, 6090, '2017-08-01', '2017-07-01', '2017-09-13', 372, 117503.4980, 0.0000, 7267.3500, 124770.8480, '2017-09-06 14:24:41', 'dbo', ''),
(2017070066, 201707, 33, 66, '2017-09-06', 2762, 'ENERGY', 5157, 4897, '2017-08-01', '2017-07-01', '2017-09-13', 260, 93530.8624, 0.0000, 5166.6500, 98697.5124, '2017-09-06 14:24:41', 'dbo', ''),
(2017070067, 201707, 33, 67, '2017-09-06', 2763, 'ENERGY', 642, 619, '2017-08-01', '2017-07-01', '2017-09-13', 23, 16660.9738, 0.0000, 721.4000, 17382.3738, '2017-09-06 14:24:42', 'dbo', ''),
(2017070068, 201707, 33, 68, '2017-09-06', 2764, 'ENERGY', 1252, 1209, '2017-08-01', '2017-07-01', '2017-09-13', 43, 28463.0600, 0.0000, 1096.5300, 29559.5900, '2017-09-06 14:24:42', 'dbo', ''),
(2017070069, 201707, 33, 69, '2017-09-06', 2765, 'ENERGY', 1, 1, '2017-08-01', '2017-07-01', '2017-09-13', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2017-09-06 14:24:42', 'dbo', ''),
(2017070070, 201707, 33, 70, '2017-09-06', 2766, 'ENERGY', 345, 345, '2017-08-01', '2017-07-01', '2017-09-13', 0, 11744.5000, 0.0000, 0.0000, 11744.5000, '2017-09-06 14:24:42', 'dbo', ''),
(2017070071, 201707, 33, 71, '2017-09-06', 2767, 'ENERGY', 119549, 112532, '2017-08-01', '2017-07-01', '2017-09-13', 7017, 1976239.2362, 0.0000, 131903.0800, 2108142.3162, '2017-09-06 14:24:40', 'dbo', ''),
(2017070072, 201707, 33, 72, '2017-09-06', 2768, 'ENERGY', 1327, 1277, '2017-08-01', '2017-07-01', '2017-09-13', 50, 31077.4400, 0.0000, 1227.8100, 32305.2500, '2017-09-06 14:24:41', 'dbo', ''),
(2017070073, 201707, 33, 73, '2017-09-06', 2769, 'ENERGY', 427, 426, '2017-08-01', '2017-07-01', '2017-09-13', 1, 22009.1480, 0.0000, 308.7600, 22317.9080, '2017-09-06 14:24:41', 'dbo', ''),
(2017070075, 201707, 33, 75, '2017-09-06', 2770, 'ENERGY', 1227, 1185, '2017-08-01', '2017-07-01', '2017-09-13', 42, 28301.3900, 0.0000, 1077.7600, 29379.1500, '2017-09-06 14:24:41', 'dbo', ''),
(2017070076, 201707, 33, 76, '2017-09-06', 2771, 'ENERGY', 1307, 1266, '2017-08-01', '2017-07-01', '2017-09-13', 41, 29744.7500, 0.0000, 1059.0100, 30803.7600, '2017-09-06 14:24:41', 'dbo', ''),
(2017070077, 201707, 33, 77, '2017-09-06', 2772, 'ENERGY', 1060, 1030, '2017-08-01', '2017-07-01', '2017-09-13', 30, 25349.5600, 0.0000, 852.6800, 26202.2400, '2017-09-06 14:24:41', 'dbo', ''),
(2017070078, 201707, 33, 78, '2017-09-06', 2773, 'ENERGY', 282, 271, '2017-08-01', '2017-07-01', '2017-09-13', 11, 11585.0000, 0.0000, 496.3200, 12081.3200, '2017-09-06 14:24:41', 'dbo', ''),
(2017070079, 201707, 33, 79, '2017-09-06', 2774, 'ENERGY', 32976, 31550, '2017-08-01', '2017-07-01', '2017-09-13', 1426, 476738.0800, 0.0000, 27036.5100, 503774.5900, '2017-09-06 14:24:41', 'dbo', ''),
(2017070080, 201707, 33, 80, '2017-09-06', 2775, 'ENERGY', 311, 311, '2017-08-01', '2017-07-01', '2017-09-13', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2017-09-06 14:24:42', 'dbo', ''),
(2017070081, 201707, 33, 81, '2017-09-06', 2776, 'ENERGY', 1161, 1109, '2017-08-01', '2017-07-01', '2017-09-13', 52, 23588.2000, 0.0000, 1265.3300, 24853.5300, '2017-09-06 14:24:41', 'dbo', ''),
(2017070082, 201707, 33, 82, '2017-09-06', 2777, 'ENERGY', 2094, 1964, '2017-08-01', '2017-07-01', '2017-09-13', 130, 40552.1500, 0.0000, 2728.3200, 43280.4700, '2017-09-06 14:24:41', 'dbo', ''),
(2017070083, 201707, 33, 83, '2017-09-06', 2778, 'ENERGY', 52, 49, '2017-08-01', '2017-07-01', '2017-09-13', 3, 2986.6200, 0.0000, 346.2700, 3332.8900, '2017-09-06 14:24:41', 'dbo', ''),
(2017070084, 201707, 33, 84, '2017-09-06', 2779, 'ENERGY', 31, 30, '2017-08-01', '2017-07-01', '2017-09-13', 1, 2870.2000, 0.0000, 308.7600, 3178.9600, '2017-09-06 14:24:41', 'dbo', ''),
(2017070085, 201707, 33, 85, '2017-09-06', 2780, 'ENERGY', 0, 0, '2017-08-01', '2017-07-01', '2017-09-13', 0, 0.0000, 0.0000, 0.0000, 0.0000, '2017-09-06 14:24:42', 'dbo', ''),
(2017070086, 201707, 33, 86, '2017-09-06', 2781, 'ENERGY', 48, 43, '2017-08-01', '2017-07-01', '2017-09-13', 5, 2537.1900, 0.0000, 383.7800, 2920.9700, '2017-09-06 14:24:41', 'dbo', ''),
(2017080001, 201708, 34, 1, '2017-09-30', 2782, 'ENERGY', 14016, 14016, '2017-09-01', '2017-08-01', '2017-10-07', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2017-09-30 13:19:46', 'dbo', ''),
(2017080002, 201708, 34, 2, '2017-09-30', 2783, 'ENERGY', 7081, 7081, '2017-09-01', '2017-08-01', '2017-10-07', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2017-09-30 13:19:46', 'dbo', ''),
(2017080003, 201708, 34, 3, '2017-09-30', 2784, 'ENERGY', 8948, 8948, '2017-09-01', '2017-08-01', '2017-10-07', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2017-09-30 13:19:47', 'dbo', ''),
(2017080004, 201708, 34, 4, '2017-09-30', 2785, 'ENERGY', 6711, 6711, '2017-09-01', '2017-08-01', '2017-10-07', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2017-09-30 13:19:47', 'dbo', ''),
(2017080005, 201708, 34, 5, '2017-09-30', 2786, 'ENERGY', 5255, 5255, '2017-09-01', '2017-08-01', '2017-10-07', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2017-09-30 13:19:47', 'dbo', ''),
(2017080006, 201708, 34, 6, '2017-09-30', 2787, 'ENERGY', 13833, 13833, '2017-09-01', '2017-08-01', '2017-10-07', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2017-09-30 13:19:47', 'dbo', ''),
(2017080007, 201708, 34, 7, '2017-09-30', 2788, 'ENERGY', 9652, 9652, '2017-09-01', '2017-08-01', '2017-10-07', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2017-09-30 13:19:47', 'dbo', ''),
(2017080008, 201708, 34, 8, '2017-09-30', 2789, 'ENERGY', 167, 167, '2017-09-01', '2017-08-01', '2017-10-07', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2017-09-30 13:19:47', 'dbo', ''),
(2017080009, 201708, 34, 9, '2017-09-30', 2790, 'ENERGY', 194, 194, '2017-09-01', '2017-08-01', '2017-10-07', 0, 11348.6064, 0.0000, 0.0000, 11348.6064, '2017-09-30 13:19:46', 'dbo', ''),
(2017080010, 201708, 34, 10, '2017-09-30', 2791, 'ENERGY', 87, 87, '2017-09-01', '2017-08-01', '2017-10-07', 0, 6435.8780, 0.0000, 0.0000, 6435.8780, '2017-09-30 13:19:46', 'dbo', ''),
(2017080011, 201708, 34, 11, '2017-09-30', 2792, 'ENERGY', 201, 201, '2017-09-01', '2017-08-01', '2017-10-07', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2017-09-30 13:19:46', 'dbo', ''),
(2017080012, 201708, 34, 12, '2017-09-30', 2793, 'ENERGY', 137, 137, '2017-09-01', '2017-08-01', '2017-10-07', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2017-09-30 13:19:46', 'dbo', ''),
(2017080013, 201708, 34, 13, '2017-09-30', 2794, 'ENERGY', 5841, 5121, '2017-09-01', '2017-08-01', '2017-10-07', 720, 103723.0340, 0.0000, 14959.5900, 118682.6240, '2017-09-30 13:19:46', 'dbo', ''),
(2017080014, 201708, 34, 14, '2017-09-30', 2795, 'ENERGY', 2159, 1932, '2017-09-01', '2017-08-01', '2017-10-07', 227, 44479.0754, 0.0000, 4914.9900, 49394.0654, '2017-09-30 13:19:46', 'dbo', ''),
(2017080015, 201708, 34, 15, '2017-09-30', 2796, 'ENERGY', 162, 162, '2017-09-01', '2017-08-01', '2017-10-07', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2017-09-30 13:19:47', 'dbo', ''),
(2017080016, 201708, 34, 16, '2017-09-30', 2797, 'ENERGY', 5828, 5168, '2017-09-01', '2017-08-01', '2017-10-07', 660, 103972.4420, 0.0000, 13737.1200, 117709.5620, '2017-09-30 13:19:46', 'dbo', ''),
(2017080017, 201708, 34, 17, '2017-09-30', 2798, 'ENERGY', 15009, 13451, '2017-09-01', '2017-08-01', '2017-10-07', 1558, 253318.2770, 0.0000, 32033.3600, 285351.6370, '2017-09-30 13:19:45', 'dbo', ''),
(2017080018, 201708, 34, 18, '2017-09-30', 2799, 'ENERGY', 4840, 4544, '2017-09-01', '2017-08-01', '2017-10-07', 296, 89410.4900, 0.0000, 6320.8200, 95731.3100, '2017-09-30 13:19:45', 'dbo', ''),
(2017080019, 201708, 34, 19, '2017-09-30', 2800, 'ENERGY', 75, 75, '2017-09-01', '2017-08-01', '2017-10-07', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2017-09-30 13:19:47', 'dbo', ''),
(2017080020, 201708, 34, 20, '2017-09-30', 2801, 'ENERGY', 254, 254, '2017-09-01', '2017-08-01', '2017-10-07', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2017-09-30 13:19:47', 'dbo', ''),
(2017080021, 201708, 34, 21, '2017-09-30', 2802, 'ENERGY', 43175, 42579, '2017-09-01', '2017-08-01', '2017-10-07', 596, 561165.8246, 0.0000, 12433.1500, 573598.9746, '2017-09-30 13:19:45', 'dbo', ''),
(2017080022, 201708, 34, 22, '2017-09-30', 2803, 'ENERGY', 25037, 24526, '2017-09-01', '2017-08-01', '2017-10-07', 511, 318475.7116, 0.0000, 10701.3200, 329177.0316, '2017-09-30 13:19:45', 'dbo', ''),
(2017080023, 201708, 34, 23, '2017-09-30', 2804, 'ENERGY', 65815, 64469, '2017-09-01', '2017-08-01', '2017-10-07', 1346, 873659.0670, 0.0000, 27713.9700, 901373.0370, '2017-09-30 13:19:45', 'dbo', ''),
(2017080024, 201708, 34, 24, '2017-09-30', 2805, 'ENERGY', 43200, 42782, '2017-09-01', '2017-08-01', '2017-10-07', 418, 524285.3500, 0.0000, 8806.5100, 533091.8600, '2017-09-30 13:19:46', 'dbo', ''),
(2017080025, 201708, 34, 25, '2017-09-30', 2806, 'ENERGY', 50340, 45396, '2017-09-01', '2017-08-01', '2017-10-07', 4944, 843853.7300, 0.0000, 101021.1300, 944874.8600, '2017-09-30 13:19:45', 'dbo', ''),
(2017080026, 201708, 34, 26, '2017-09-30', 2807, 'ENERGY', 57263, 55852, '2017-09-01', '2017-08-01', '2017-10-07', 1411, 893554.3074, 0.0000, 29038.3000, 922592.6074, '2017-09-30 13:19:45', 'dbo', ''),
(2017080029, 201708, 34, 29, '2017-09-30', 2810, 'ENERGY', 80889, 78662, '2017-09-01', '2017-08-01', '2017-10-07', 2227, 1172231.0288, 0.0000, 45663.8300, 1217894.8588, '2017-09-30 13:19:45', 'dbo', ''),
(2017080030, 201708, 34, 30, '2017-09-30', 2811, 'ENERGY', 39203, 38085, '2017-09-01', '2017-08-01', '2017-10-07', 1118, 460960.4212, 0.0000, 23068.6000, 484029.0212, '2017-09-30 13:19:45', 'dbo', ''),
(2017080031, 201708, 34, 31, '2017-09-30', 2812, 'ENERGY', 60853, 58701, '2017-09-01', '2017-08-01', '2017-10-07', 2152, 888133.6580, 0.0000, 44135.7400, 932269.3980, '2017-09-30 13:19:45', 'dbo', ''),
(2017080032, 201708, 34, 32, '2017-09-30', 2813, 'ENERGY', 99144, 95301, '2017-09-01', '2017-08-01', '2017-10-07', 3843, 1443537.9590, 0.0000, 78588.9000, 1522126.8590, '2017-09-30 13:19:45', 'dbo', ''),
(2017080033, 201708, 34, 33, '2017-09-30', 2814, 'ENERGY', 12128, 11375, '2017-09-01', '2017-08-01', '2017-10-07', 753, 184850.2634, 0.0000, 15631.9400, 200482.2034, '2017-09-30 13:19:45', 'dbo', ''),
(2017080034, 201708, 34, 34, '2017-09-30', 2815, 'ENERGY', 9011, 8460, '2017-09-01', '2017-08-01', '2017-10-07', 551, 144422.4642, 0.0000, 11516.3000, 155938.7642, '2017-09-30 13:19:45', 'dbo', ''),
(2017080035, 201708, 34, 35, '2017-09-30', 2816, 'ENERGY', 16224, 15830, '2017-09-01', '2017-08-01', '2017-10-07', 394, 249334.4226, 0.0000, 8317.5200, 257651.9426, '2017-09-30 13:19:45', 'dbo', ''),
(2017080036, 201708, 34, 36, '2017-09-30', 2817, 'ENERGY', 38965, 37645, '2017-09-01', '2017-08-01', '2017-10-07', 1320, 620488.5438, 0.0000, 27184.2300, 647672.7738, '2017-09-30 13:19:45', 'dbo', ''),
(2017080037, 201708, 34, 37, '2017-09-30', 2818, 'ENERGY', 20494, 19989, '2017-09-01', '2017-08-01', '2017-10-07', 505, 307576.8510, 0.0000, 10579.0900, 318155.9410, '2017-09-30 13:19:45', 'dbo', ''),
(2017080038, 201708, 34, 38, '2017-09-30', 2819, 'ENERGY', 10432, 9888, '2017-09-01', '2017-08-01', '2017-10-07', 544, 162216.8434, 0.0000, 11373.6900, 173590.5334, '2017-09-30 13:19:45', 'dbo', ''),
(2017080039, 201708, 34, 39, '2017-09-30', 2820, 'ENERGY', 25502, 25198, '2017-09-01', '2017-08-01', '2017-10-07', 304, -203141.0418, 0.0000, 6483.8200, -196657.2218, '2017-09-30 13:19:45', 'dbo', ''),
(2017080040, 201708, 34, 40, '2017-09-30', 2821, 'ENERGY', 23171, 22231, '2017-09-01', '2017-08-01', '2017-10-07', 940, 366036.0196, 0.0000, 19441.9500, 385477.9696, '2017-09-30 13:19:45', 'dbo', ''),
(2017080041, 201708, 34, 41, '2017-09-30', 2822, 'ENERGY', 241, 241, '2017-09-01', '2017-08-01', '2017-10-07', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2017-09-30 13:19:47', 'dbo', ''),
(2017080042, 201708, 34, 42, '2017-09-30', 2823, 'ENERGY', 296, 199, '2017-09-01', '2017-08-01', '2017-10-07', 97, 8634.6360, 0.0000, 2266.3200, 10900.9560, '2017-09-30 13:19:45', 'dbo', ''),
(2017080043, 201708, 34, 43, '2017-09-30', 2824, 'ENERGY', 61004, 59183, '2017-09-01', '2017-08-01', '2017-10-07', 1821, 786410.1502, 0.0000, 37391.8100, 823801.9602, '2017-09-30 13:19:45', 'dbo', ''),
(2017080044, 201708, 34, 44, '2017-09-30', 2825, 'ENERGY', 35150, 33813, '2017-09-01', '2017-08-01', '2017-10-07', 1337, 620999.1930, 0.0000, 27530.6000, 648529.7930, '2017-09-30 13:19:45', 'dbo', ''),
(2017080045, 201708, 34, 45, '2017-09-30', 2826, 'ENERGY', 31482, 30900, '2017-09-01', '2017-08-01', '2017-10-07', 582, 295525.1220, 0.0000, 12147.9100, 307673.0320, '2017-09-30 13:19:46', 'dbo', ''),
(2017080046, 201708, 34, 46, '2017-09-30', 2827, 'ENERGY', 46157, 44735, '2017-09-01', '2017-08-01', '2017-10-07', 1422, 764526.8954, 0.0000, 29262.4300, 793789.3254, '2017-09-30 13:19:46', 'dbo', ''),
(2017080047, 201708, 34, 47, '2017-09-30', 2828, 'ENERGY', 23283, 22629, '2017-09-01', '2017-08-01', '2017-10-07', 654, 271289.9610, 0.0000, 13614.8700, 284904.8310, '2017-09-30 13:19:46', 'dbo', ''),
(2017080048, 201708, 34, 48, '2017-09-30', 2829, 'ENERGY', 10327, 9415, '2017-09-01', '2017-08-01', '2017-10-07', 912, 178859.9100, 0.0000, 18871.4600, 197731.3700, '2017-09-30 13:19:46', 'dbo', ''),
(2017080049, 201708, 34, 49, '2017-09-30', 2830, 'ENERGY', 5336, 5077, '2017-09-01', '2017-08-01', '2017-10-07', 259, 81919.4690, 0.0000, 5566.9700, 87486.4390, '2017-09-30 13:19:45', 'dbo', ''),
(2017080050, 201708, 34, 50, '2017-09-30', 2831, 'ENERGY', 77451, 75126, '2017-09-01', '2017-08-01', '2017-10-07', 2325, 1096678.1492, 0.0000, 47660.5300, 1144338.6792, '2017-09-30 13:19:45', 'dbo', ''),
(2017080051, 201708, 34, 51, '2017-09-30', 2832, 'ENERGY', 211, 211, '2017-09-01', '2017-08-01', '2017-10-07', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2017-09-30 13:19:47', 'dbo', ''),
(2017080052, 201708, 34, 52, '2017-09-30', 2833, 'ENERGY', 321, 321, '2017-09-01', '2017-08-01', '2017-10-07', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2017-09-30 13:19:47', 'dbo', ''),
(2017080053, 201708, 34, 53, '2017-09-30', 2834, 'ENERGY', 1817, 1817, '2017-09-01', '2017-08-01', '2017-10-07', 0, 41322.8070, 0.0000, 0.0000, 41322.8070, '2017-09-30 13:19:47', 'dbo', ''),
(2017080054, 201708, 34, 54, '2017-09-30', 2835, 'ENERGY', 25906, 25171, '2017-09-01', '2017-08-01', '2017-10-07', 735, 216148.0294, 0.0000, 15265.2000, 231413.2294, '2017-09-30 13:19:46', 'dbo', ''),
(2017080055, 201708, 34, 55, '2017-09-30', 2836, 'ENERGY', 12689, 12689, '2017-09-01', '2017-08-01', '2017-10-07', 0, 239408.7700, 0.0000, 0.0000, 239408.7700, '2017-09-30 13:19:47', 'dbo', ''),
(2017080056, 201708, 34, 56, '2017-09-30', 2837, 'ENERGY', 239, 239, '2017-09-01', '2017-08-01', '2017-10-07', 0, 8516.7790, 0.0000, 0.0000, 8516.7790, '2017-09-30 13:19:47', 'dbo', ''),
(2017080059, 201708, 34, 59, '2017-09-30', 2840, 'ENERGY', 128, 128, '2017-09-01', '2017-08-01', '2017-10-07', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2017-09-30 13:19:46', 'dbo', ''),
(2017080060, 201708, 34, 60, '2017-09-30', 2841, 'ENERGY', 199515, 190840, '2017-09-01', '2017-08-01', '2017-10-07', 8675, 2218994.7400, 0.0000, 177038.1000, 2396032.8400, '2017-09-30 13:19:45', 'dbo', ''),
(2017080061, 201708, 34, 61, '2017-09-30', 2842, 'ENERGY', 16, 16, '2017-09-01', '2017-08-01', '2017-10-07', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2017-09-30 13:19:46', 'dbo', ''),
(2017080062, 201708, 34, 62, '2017-09-30', 2843, 'ENERGY', 30, 30, '2017-09-01', '2017-08-01', '2017-10-07', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-09-30 13:19:46', 'dbo', ''),
(2017080063, 201708, 34, 63, '2017-09-30', 2844, 'ENERGY', 1, 1, '2017-09-01', '2017-08-01', '2017-10-07', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-09-30 13:19:46', 'dbo', ''),
(2017080064, 201708, 34, 64, '2017-09-30', 2845, 'ENERGY', 2, 2, '2017-09-01', '2017-08-01', '2017-10-07', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-09-30 13:19:46', 'dbo', ''),
(2017080065, 201708, 34, 65, '2017-09-30', 2846, 'ENERGY', 6859, 6462, '2017-09-01', '2017-08-01', '2017-10-07', 397, 124770.8480, 0.0000, 8378.6400, 133149.4880, '2017-09-30 13:19:45', 'dbo', ''),
(2017080066, 201708, 34, 66, '2017-09-30', 2847, 'ENERGY', 5352, 5157, '2017-09-01', '2017-08-01', '2017-10-07', 195, 98697.5124, 0.0000, 4263.0100, 102960.5224, '2017-09-30 13:19:45', 'dbo', ''),
(2017080067, 201708, 34, 67, '2017-09-30', 2848, 'ENERGY', 666, 642, '2017-09-01', '2017-08-01', '2017-10-07', 24, 17382.3738, 0.0000, 778.9800, 18161.3538, '2017-09-30 13:19:46', 'dbo', ''),
(2017080068, 201708, 34, 68, '2017-09-30', 2849, 'ENERGY', 1297, 1252, '2017-09-01', '2017-08-01', '2017-10-07', 45, 29559.5900, 0.0000, 1206.8500, 30766.4400, '2017-09-30 13:19:46', 'dbo', ''),
(2017080069, 201708, 34, 69, '2017-09-30', 2850, 'ENERGY', 1, 1, '2017-09-01', '2017-08-01', '2017-10-07', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2017-09-30 13:19:46', 'dbo', ''),
(2017080070, 201708, 34, 70, '2017-09-30', 2851, 'ENERGY', 345, 345, '2017-09-01', '2017-08-01', '2017-10-07', 0, 11744.5000, 0.0000, 0.0000, 11744.5000, '2017-09-30 13:19:47', 'dbo', ''),
(2017080071, 201708, 34, 71, '2017-09-30', 2852, 'ENERGY', 126286, 119549, '2017-09-01', '2017-08-01', '2017-10-07', 6737, 2108142.3162, 0.0000, 137552.4700, 2245694.7862, '2017-09-30 13:19:44', 'dbo', ''),
(2017080072, 201708, 34, 72, '2017-09-30', 2853, 'ENERGY', 1366, 1327, '2017-09-01', '2017-08-01', '2017-10-07', 39, 32305.2500, 0.0000, 1084.6000, 33389.8500, '2017-09-30 13:19:45', 'dbo', ''),
(2017080073, 201708, 34, 73, '2017-09-30', 2854, 'ENERGY', 430, 427, '2017-09-01', '2017-08-01', '2017-10-07', 3, 22317.9080, 0.0000, 351.1200, 22669.0280, '2017-09-30 13:19:45', 'dbo', ''),
(2017080075, 201708, 34, 75, '2017-09-30', 2855, 'ENERGY', 1274, 1227, '2017-09-01', '2017-08-01', '2017-10-07', 47, 29379.1500, 0.0000, 1247.6000, 30626.7500, '2017-09-30 13:19:45', 'dbo', ''),
(2017080076, 201708, 34, 76, '2017-09-30', 2856, 'ENERGY', 1351, 1307, '2017-09-01', '2017-08-01', '2017-10-07', 44, 30803.7600, 0.0000, 1186.4700, 31990.2300, '2017-09-30 13:19:45', 'dbo', ''),
(2017080077, 201708, 34, 77, '2017-09-30', 2857, 'ENERGY', 1093, 1060, '2017-09-01', '2017-08-01', '2017-10-07', 33, 26202.2400, 0.0000, 962.3600, 27164.6000, '2017-09-30 13:19:45', 'dbo', ''),
(2017080078, 201708, 34, 78, '2017-09-30', 2858, 'ENERGY', 282, 282, '2017-09-01', '2017-08-01', '2017-10-07', 0, 12081.3200, 0.0000, 0.0000, 12081.3200, '2017-09-30 13:19:46', 'dbo', ''),
(2017080079, 201708, 34, 79, '2017-09-30', 2859, 'ENERGY', 34580, 32976, '2017-09-01', '2017-08-01', '2017-10-07', 1604, 503774.5900, 0.0000, 32970.5700, 536745.1600, '2017-09-30 13:19:45', 'dbo', ''),
(2017080080, 201708, 34, 80, '2017-09-30', 2860, 'ENERGY', 311, 311, '2017-09-01', '2017-08-01', '2017-10-07', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2017-09-30 13:19:47', 'dbo', ''),
(2017080081, 201708, 34, 81, '2017-09-30', 2861, 'ENERGY', 1219, 1161, '2017-09-01', '2017-08-01', '2017-10-07', 58, 24853.5300, 0.0000, 1471.7200, 26325.2500, '2017-09-30 13:19:45', 'dbo', ''),
(2017080082, 201708, 34, 82, '2017-09-30', 2862, 'ENERGY', 2238, 2094, '2017-09-01', '2017-08-01', '2017-10-07', 144, 43280.4700, 0.0000, 3223.9200, 46504.3900, '2017-09-30 13:19:45', 'dbo', ''),
(2017080083, 201708, 34, 83, '2017-09-30', 2863, 'ENERGY', 56, 52, '2017-09-01', '2017-08-01', '2017-10-07', 4, 3332.8900, 0.0000, 371.5000, 3704.3900, '2017-09-30 13:19:45', 'dbo', ''),
(2017080084, 201708, 34, 84, '2017-09-30', 2864, 'ENERGY', 31, 31, '2017-09-01', '2017-08-01', '2017-10-07', 0, 3178.9600, 0.0000, 0.0000, 3178.9600, '2017-09-30 13:19:47', 'dbo', ''),
(2017080085, 201708, 34, 85, '2017-09-30', 2865, 'ENERGY', 0, 0, '2017-09-01', '2017-08-01', '2017-10-07', 0, 0.0000, 0.0000, 0.0000, 0.0000, '2017-09-30 13:19:47', 'dbo', ''),
(2017080086, 201708, 34, 86, '2017-09-30', 2866, 'ENERGY', 53, 48, '2017-09-01', '2017-08-01', '2017-10-07', 5, 2920.9700, 0.0000, 391.8800, 3312.8500, '2017-09-30 13:19:45', 'dbo', ''),
(2017090001, 201709, 35, 1, '2017-11-07', 2867, 'ENERGY', 14016, 14016, '2017-10-01', '2017-09-01', '2017-11-14', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2017-11-07 08:55:32', 'dbo', ''),
(2017090002, 201709, 35, 2, '2017-11-07', 2868, 'ENERGY', 7081, 7081, '2017-10-01', '2017-09-01', '2017-11-14', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2017-11-07 08:55:32', 'dbo', ''),
(2017090003, 201709, 35, 3, '2017-11-07', 2869, 'ENERGY', 8948, 8948, '2017-10-01', '2017-09-01', '2017-11-14', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2017-11-07 08:55:32', 'dbo', ''),
(2017090004, 201709, 35, 4, '2017-11-07', 2870, 'ENERGY', 6711, 6711, '2017-10-01', '2017-09-01', '2017-11-14', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2017-11-07 08:55:32', 'dbo', ''),
(2017090005, 201709, 35, 5, '2017-11-07', 2871, 'ENERGY', 5255, 5255, '2017-10-01', '2017-09-01', '2017-11-14', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2017-11-07 08:55:32', 'dbo', ''),
(2017090006, 201709, 35, 6, '2017-11-07', 2872, 'ENERGY', 13833, 13833, '2017-10-01', '2017-09-01', '2017-11-14', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2017-11-07 08:55:32', 'dbo', ''),
(2017090007, 201709, 35, 7, '2017-11-07', 2873, 'ENERGY', 9652, 9652, '2017-10-01', '2017-09-01', '2017-11-14', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2017-11-07 08:55:32', 'dbo', ''),
(2017090008, 201709, 35, 8, '2017-11-07', 2874, 'ENERGY', 167, 167, '2017-10-01', '2017-09-01', '2017-11-14', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2017-11-07 08:55:32', 'dbo', ''),
(2017090009, 201709, 35, 9, '2017-11-07', 2875, 'ENERGY', 236, 194, '2017-10-01', '2017-09-01', '2017-11-14', 42, 11348.6064, 0.0000, 1085.6000, 12434.2064, '2017-11-07 08:55:31', 'dbo', ''),
(2017090010, 201709, 35, 10, '2017-11-07', 2876, 'ENERGY', 89, 87, '2017-10-01', '2017-09-01', '2017-11-14', 2, 6435.8780, 0.0000, 327.8800, 6763.7580, '2017-11-07 08:55:31', 'dbo', ''),
(2017090011, 201709, 35, 11, '2017-11-07', 2877, 'ENERGY', 201, 201, '2017-10-01', '2017-09-01', '2017-11-14', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2017-11-07 08:55:32', 'dbo', ''),
(2017090012, 201709, 35, 12, '2017-11-07', 2878, 'ENERGY', 137, 137, '2017-10-01', '2017-09-01', '2017-11-14', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2017-11-07 08:55:32', 'dbo', ''),
(2017090013, 201709, 35, 13, '2017-11-07', 2879, 'ENERGY', 6661, 5841, '2017-10-01', '2017-09-01', '2017-11-14', 820, 118682.6240, 0.0000, 15823.1000, 134505.7240, '2017-11-07 08:55:32', 'dbo', ''),
(2017090014, 201709, 35, 14, '2017-11-07', 2880, 'ENERGY', 2412, 2159, '2017-10-01', '2017-09-01', '2017-11-14', 253, 49394.0654, 0.0000, 5082.5300, 54476.5954, '2017-11-07 08:55:32', 'dbo', ''),
(2017090015, 201709, 35, 15, '2017-11-07', 2881, 'ENERGY', 162, 162, '2017-10-01', '2017-09-01', '2017-11-14', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2017-11-07 08:55:32', 'dbo', ''),
(2017090016, 201709, 35, 16, '2017-11-07', 2882, 'ENERGY', 6388, 5828, '2017-10-01', '2017-09-01', '2017-11-14', 560, 117709.5620, 0.0000, 10897.9800, 128607.5420, '2017-11-07 08:55:32', 'dbo', ''),
(2017090017, 201709, 35, 17, '2017-11-07', 2883, 'ENERGY', 16470, 15009, '2017-10-01', '2017-09-01', '2017-11-14', 1461, 285351.6370, 0.0000, 27965.4400, 313317.0770, '2017-11-07 08:55:31', 'dbo', ''),
(2017090018, 201709, 35, 18, '2017-11-07', 2884, 'ENERGY', 5174, 4840, '2017-10-01', '2017-09-01', '2017-11-14', 334, 95731.3100, 0.0000, 6616.9000, 102348.2100, '2017-11-07 08:55:31', 'dbo', ''),
(2017090019, 201709, 35, 19, '2017-11-07', 2885, 'ENERGY', 75, 75, '2017-10-01', '2017-09-01', '2017-11-14', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2017-11-07 08:55:32', 'dbo', ''),
(2017090020, 201709, 35, 20, '2017-11-07', 2886, 'ENERGY', 254, 254, '2017-10-01', '2017-09-01', '2017-11-14', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2017-11-07 08:55:32', 'dbo', ''),
(2017090021, 201709, 35, 21, '2017-11-07', 2887, 'ENERGY', 43711, 43175, '2017-10-01', '2017-09-01', '2017-11-14', 536, 573598.9746, 0.0000, 10443.3500, 584042.3246, '2017-11-07 08:55:31', 'dbo', ''),
(2017090022, 201709, 35, 22, '2017-11-07', 2888, 'ENERGY', 25503, 25037, '2017-10-01', '2017-09-01', '2017-11-14', 466, 329177.0316, 0.0000, 9117.3500, 338294.3816, '2017-11-07 08:55:31', 'dbo', ''),
(2017090023, 201709, 35, 23, '2017-11-07', 2889, 'ENERGY', 66987, 65815, '2017-10-01', '2017-09-01', '2017-11-14', 1172, 901373.0370, 0.0000, 22490.9600, 923863.9970, '2017-11-07 08:55:31', 'dbo', ''),
(2017090024, 201709, 35, 24, '2017-11-07', 2890, 'ENERGY', 43645, 43200, '2017-10-01', '2017-09-01', '2017-11-14', 445, 533091.8600, 0.0000, 8719.5500, 541811.4100, '2017-11-07 08:55:32', 'dbo', ''),
(2017090025, 201709, 35, 25, '2017-11-07', 2891, 'ENERGY', 54247, 50340, '2017-10-01', '2017-09-01', '2017-11-14', 3907, 944874.8600, 0.0000, 74299.5300, 1019174.3900, '2017-11-07 08:55:31', 'dbo', ''),
(2017090026, 201709, 35, 26, '2017-11-07', 2892, 'ENERGY', 58547, 57263, '2017-10-01', '2017-09-01', '2017-11-14', 1284, 922592.6074, 0.0000, 24612.5600, 947205.1674, '2017-11-07 08:55:31', 'dbo', ''),
(2017090029, 201709, 35, 29, '2017-11-07', 2895, 'ENERGY', 82681, 80889, '2017-10-01', '2017-09-01', '2017-11-14', 1792, 1217894.8588, 0.0000, 34235.5000, 1252130.3588, '2017-11-07 08:55:32', 'dbo', ''),
(2017090030, 201709, 35, 30, '2017-11-07', 2896, 'ENERGY', 40055, 39203, '2017-10-01', '2017-09-01', '2017-11-14', 852, 484029.0212, 0.0000, 16429.2700, 500458.2912, '2017-11-07 08:55:32', 'dbo', ''),
(2017090031, 201709, 35, 31, '2017-11-07', 2897, 'ENERGY', 62613, 60853, '2017-10-01', '2017-09-01', '2017-11-14', 1760, 932269.3980, 0.0000, 33629.3400, 965898.7380, '2017-11-07 08:55:32', 'dbo', ''),
(2017090032, 201709, 35, 32, '2017-11-07', 2898, 'ENERGY', 102253, 99144, '2017-10-01', '2017-09-01', '2017-11-14', 3109, 1522126.8590, 0.0000, 59183.1800, 1581310.0390, '2017-11-07 08:55:32', 'dbo', ''),
(2017090033, 201709, 35, 33, '2017-11-07', 2899, 'ENERGY', 12684, 12128, '2017-10-01', '2017-09-01', '2017-11-14', 556, 200482.2034, 0.0000, 10822.2000, 211304.4034, '2017-11-07 08:55:31', 'dbo', ''),
(2017090034, 201709, 35, 34, '2017-11-07', 2900, 'ENERGY', 9465, 9011, '2017-10-01', '2017-09-01', '2017-11-14', 454, 155938.7642, 0.0000, 8890.0300, 164828.7942, '2017-11-07 08:55:31', 'dbo', ''),
(2017090035, 201709, 35, 35, '2017-11-07', 2901, 'ENERGY', 16560, 16224, '2017-10-01', '2017-09-01', '2017-11-14', 336, 257651.9426, 0.0000, 6654.7900, 264306.7326, '2017-11-07 08:55:31', 'dbo', ''),
(2017090036, 201709, 35, 36, '2017-11-07', 2902, 'ENERGY', 40016, 38965, '2017-10-01', '2017-09-01', '2017-11-14', 1051, 647672.7738, 0.0000, 20198.8800, 667871.6538, '2017-11-07 08:55:31', 'dbo', ''),
(2017090037, 201709, 35, 37, '2017-11-07', 2903, 'ENERGY', 20920, 20494, '2017-10-01', '2017-09-01', '2017-11-14', 426, 318155.9410, 0.0000, 8359.6400, 326515.5810, '2017-11-07 08:55:31', 'dbo', ''),
(2017090038, 201709, 35, 38, '2017-11-07', 2904, 'ENERGY', 10843, 10432, '2017-10-01', '2017-09-01', '2017-11-14', 411, 173590.5334, 0.0000, 8075.4900, 181666.0234, '2017-11-07 08:55:31', 'dbo', ''),
(2017090039, 201709, 35, 39, '2017-11-07', 2905, 'ENERGY', 25881, 25502, '2017-10-01', '2017-09-01', '2017-11-14', 379, -196657.2218, 0.0000, 7469.3300, -189187.8918, '2017-11-07 08:55:31', 'dbo', ''),
(2017090040, 201709, 35, 40, '2017-11-07', 2906, 'ENERGY', 23979, 23171, '2017-10-01', '2017-09-01', '2017-11-14', 808, 385477.9696, 0.0000, 15595.7800, 401073.7496, '2017-11-07 08:55:31', 'dbo', ''),
(2017090041, 201709, 35, 41, '2017-11-07', 2907, 'ENERGY', 241, 241, '2017-10-01', '2017-09-01', '2017-11-14', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2017-11-07 08:55:32', 'dbo', ''),
(2017090042, 201709, 35, 42, '2017-11-07', 2908, 'ENERGY', 334, 296, '2017-10-01', '2017-09-01', '2017-11-14', 38, 10900.9560, 0.0000, 1009.8400, 11910.7960, '2017-11-07 08:55:31', 'dbo', ''),
(2017090043, 201709, 35, 43, '2017-11-07', 2909, 'ENERGY', 62684, 61004, '2017-10-01', '2017-09-01', '2017-11-14', 1680, 823801.9602, 0.0000, 32113.9100, 855915.8702, '2017-11-07 08:55:31', 'dbo', ''),
(2017090044, 201709, 35, 44, '2017-11-07', 2910, 'ENERGY', 36326, 35150, '2017-10-01', '2017-09-01', '2017-11-14', 1176, 648529.7930, 0.0000, 22566.7300, 671096.5230, '2017-11-07 08:55:31', 'dbo', ''),
(2017090045, 201709, 35, 45, '2017-11-07', 2911, 'ENERGY', 32037, 31482, '2017-10-01', '2017-09-01', '2017-11-14', 555, 307673.0320, 0.0000, 10803.2600, 318476.2920, '2017-11-07 08:55:32', 'dbo', ''),
(2017090046, 201709, 35, 46, '2017-11-07', 2912, 'ENERGY', 47319, 46157, '2017-10-01', '2017-09-01', '2017-11-14', 1162, 793789.3254, 0.0000, 22301.5200, 816090.8454, '2017-11-07 08:55:32', 'dbo', ''),
(2017090047, 201709, 35, 47, '2017-11-07', 2913, 'ENERGY', 23815, 23283, '2017-10-01', '2017-09-01', '2017-11-14', 532, 284904.8310, 0.0000, 10367.5800, 295272.4110, '2017-11-07 08:55:32', 'dbo', ''),
(2017090048, 201709, 35, 48, '2017-11-07', 2914, 'ENERGY', 11146, 10327, '2017-10-01', '2017-09-01', '2017-11-14', 819, 197731.3700, 0.0000, 15804.1500, 213535.5200, '2017-11-07 08:55:32', 'dbo', ''),
(2017090049, 201709, 35, 49, '2017-11-07', 2915, 'ENERGY', 5545, 5336, '2017-10-01', '2017-09-01', '2017-11-14', 209, 87486.4390, 0.0000, 4249.0500, 91735.4890, '2017-11-07 08:55:31', 'dbo', ''),
(2017090050, 201709, 35, 50, '2017-11-07', 2916, 'ENERGY', 79238, 77451, '2017-10-01', '2017-09-01', '2017-11-14', 1787, 1144338.6792, 0.0000, 34140.7900, 1178479.4692, '2017-11-07 08:55:31', 'dbo', ''),
(2017090051, 201709, 35, 51, '2017-11-07', 2917, 'ENERGY', 211, 211, '2017-10-01', '2017-09-01', '2017-11-14', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2017-11-07 08:55:32', 'dbo', ''),
(2017090052, 201709, 35, 52, '2017-11-07', 2918, 'ENERGY', 321, 321, '2017-10-01', '2017-09-01', '2017-11-14', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2017-11-07 08:55:32', 'dbo', ''),
(2017090053, 201709, 35, 53, '2017-11-07', 2919, 'ENERGY', 1817, 1817, '2017-10-01', '2017-09-01', '2017-11-14', 0, 41322.8070, 0.0000, 0.0000, 41322.8070, '2017-11-07 08:55:32', 'dbo', ''),
(2017090054, 201709, 35, 54, '2017-11-07', 2920, 'ENERGY', 26626, 25906, '2017-10-01', '2017-09-01', '2017-11-14', 720, 231413.2294, 0.0000, 13928.8300, 245342.0594, '2017-11-07 08:55:32', 'dbo', ''),
(2017090055, 201709, 35, 55, '2017-11-07', 2921, 'ENERGY', 12689, 12689, '2017-10-01', '2017-09-01', '2017-11-14', 0, 239408.7700, 0.0000, 0.0000, 239408.7700, '2017-11-07 08:55:32', 'dbo', ''),
(2017090056, 201709, 35, 56, '2017-11-07', 2922, 'ENERGY', 239, 239, '2017-10-01', '2017-09-01', '2017-11-14', 0, 8516.7790, 0.0000, 0.0000, 8516.7790, '2017-11-07 08:55:32', 'dbo', ''),
(2017090059, 201709, 35, 59, '2017-11-07', 2925, 'ENERGY', 128, 128, '2017-10-01', '2017-09-01', '2017-11-14', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2017-11-07 08:55:32', 'dbo', ''),
(2017090060, 201709, 35, 60, '2017-11-07', 2926, 'ENERGY', 205700, 199515, '2017-10-01', '2017-09-01', '2017-11-14', 6185, 2396032.8400, 0.0000, 117451.2300, 2513484.0700, '2017-11-07 08:55:31', 'dbo', ''),
(2017090061, 201709, 35, 61, '2017-11-07', 2927, 'ENERGY', 16, 16, '2017-10-01', '2017-09-01', '2017-11-14', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2017-11-07 08:55:32', 'dbo', ''),
(2017090062, 201709, 35, 62, '2017-11-07', 2928, 'ENERGY', 30, 30, '2017-10-01', '2017-09-01', '2017-11-14', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-11-07 08:55:32', 'dbo', ''),
(2017090063, 201709, 35, 63, '2017-11-07', 2929, 'ENERGY', 1, 1, '2017-10-01', '2017-09-01', '2017-11-14', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-11-07 08:55:32', 'dbo', ''),
(2017090064, 201709, 35, 64, '2017-11-07', 2930, 'ENERGY', 2, 2, '2017-10-01', '2017-09-01', '2017-11-14', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-11-07 08:55:32', 'dbo', ''),
(2017090065, 201709, 35, 65, '2017-11-07', 2931, 'ENERGY', 7223, 6859, '2017-10-01', '2017-09-01', '2017-11-14', 364, 133149.4880, 0.0000, 7185.1800, 140334.6680, '2017-11-07 08:55:31', 'dbo', ''),
(2017090066, 201709, 35, 66, '2017-11-07', 2932, 'ENERGY', 5578, 5352, '2017-10-01', '2017-09-01', '2017-11-14', 226, 102960.5224, 0.0000, 4571.0700, 107531.5924, '2017-11-07 08:55:31', 'dbo', ''),
(2017090067, 201709, 35, 67, '2017-11-07', 2933, 'ENERGY', 689, 666, '2017-10-01', '2017-09-01', '2017-11-14', 23, 18161.3538, 0.0000, 725.6800, 18887.0338, '2017-11-07 08:55:32', 'dbo', ''),
(2017090068, 201709, 35, 68, '2017-11-07', 2934, 'ENERGY', 1337, 1297, '2017-10-01', '2017-09-01', '2017-11-14', 40, 30766.4400, 0.0000, 1047.7100, 31814.1500, '2017-11-07 08:55:32', 'dbo', ''),
(2017090069, 201709, 35, 69, '2017-11-07', 2935, 'ENERGY', 1, 1, '2017-10-01', '2017-09-01', '2017-11-14', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2017-11-07 08:55:32', 'dbo', ''),
(2017090070, 201709, 35, 70, '2017-11-07', 2936, 'ENERGY', 345, 345, '2017-10-01', '2017-09-01', '2017-11-14', 0, 11744.5000, 0.0000, 0.0000, 11744.5000, '2017-11-07 08:55:32', 'dbo', ''),
(2017090071, 201709, 35, 71, '2017-11-07', 2937, 'ENERGY', 132161, 126286, '2017-10-01', '2017-09-01', '2017-11-14', 5875, 2245694.7862, 0.0000, 111578.9600, 2357273.7462, '2017-11-07 08:55:31', 'dbo', ''),
(2017090072, 201709, 35, 72, '2017-11-07', 2938, 'ENERGY', 1398, 1366, '2017-10-01', '2017-09-01', '2017-11-14', 32, 33389.8500, 0.0000, 896.1700, 34286.0200, '2017-11-07 08:55:31', 'dbo', ''),
(2017090073, 201709, 35, 73, '2017-11-07', 2939, 'ENERGY', 430, 430, '2017-10-01', '2017-09-01', '2017-11-14', 0, 22669.0280, 0.0000, 0.0000, 22669.0280, '2017-11-07 08:55:32', 'dbo', ''),
(2017090075, 201709, 35, 75, '2017-11-07', 2940, 'ENERGY', 1310, 1274, '2017-10-01', '2017-09-01', '2017-11-14', 36, 30626.7500, 0.0000, 971.9400, 31598.6900, '2017-11-07 08:55:31', 'dbo', ''),
(2017090076, 201709, 35, 76, '2017-11-07', 2941, 'ENERGY', 1386, 1351, '2017-10-01', '2017-09-01', '2017-11-14', 35, 31990.2300, 0.0000, 953.0000, 32943.2300, '2017-11-07 08:55:31', 'dbo', ''),
(2017090077, 201709, 35, 77, '2017-11-07', 2942, 'ENERGY', 1118, 1093, '2017-10-01', '2017-09-01', '2017-11-14', 25, 27164.6000, 0.0000, 763.5700, 27928.1700, '2017-11-07 08:55:31', 'dbo', ''),
(2017090078, 201709, 35, 78, '2017-11-07', 2943, 'ENERGY', 305, 282, '2017-10-01', '2017-09-01', '2017-11-14', 23, 12081.3200, 0.0000, 725.6800, 12807.0000, '2017-11-07 08:55:31', 'dbo', ''),
(2017090079, 201709, 35, 79, '2017-11-07', 2944, 'ENERGY', 35810, 34580, '2017-10-01', '2017-09-01', '2017-11-14', 1230, 536745.1600, 0.0000, 23589.6400, 560334.8000, '2017-11-07 08:55:31', 'dbo', ''),
(2017090080, 201709, 35, 80, '2017-11-07', 2945, 'ENERGY', 311, 311, '2017-10-01', '2017-09-01', '2017-11-14', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2017-11-07 08:55:32', 'dbo', ''),
(2017090081, 201709, 35, 81, '2017-11-07', 2946, 'ENERGY', 1263, 1219, '2017-10-01', '2017-09-01', '2017-11-14', 44, 26325.2500, 0.0000, 1123.4800, 27448.7300, '2017-11-07 08:55:31', 'dbo', ''),
(2017090082, 201709, 35, 82, '2017-11-07', 2947, 'ENERGY', 2348, 2238, '2017-10-01', '2017-09-01', '2017-11-14', 110, 46504.3900, 0.0000, 2373.7100, 48878.1000, '2017-11-07 08:55:31', 'dbo', ''),
(2017090083, 201709, 35, 83, '2017-11-07', 2948, 'ENERGY', 58, 56, '2017-10-01', '2017-09-01', '2017-11-14', 2, 3704.3900, 0.0000, 327.8800, 4032.2700, '2017-11-07 08:55:31', 'dbo', ''),
(2017090084, 201709, 35, 84, '2017-11-07', 2949, 'ENERGY', 31, 31, '2017-10-01', '2017-09-01', '2017-11-14', 0, 3178.9600, 0.0000, 0.0000, 3178.9600, '2017-11-07 08:55:32', 'dbo', ''),
(2017090085, 201709, 35, 85, '2017-11-07', 2950, 'ENERGY', 0, 0, '2017-10-01', '2017-09-01', '2017-11-14', 0, 0.0000, 0.0000, 0.0000, 0.0000, '2017-11-07 08:55:32', 'dbo', ''),
(2017090086, 201709, 35, 86, '2017-11-07', 2951, 'ENERGY', 56, 53, '2017-10-01', '2017-09-01', '2017-11-14', 3, 3312.8500, 0.0000, 346.8300, 3659.6800, '2017-11-07 08:55:31', 'dbo', ''),
(2017100001, 201710, 36, 1, '2017-11-23', 2952, 'ENERGY', 14016, 14016, '2017-11-01', '2017-10-01', '2017-11-30', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2017-11-23 22:01:40', 'dbo', ''),
(2017100002, 201710, 36, 2, '2017-11-23', 2953, 'ENERGY', 7081, 7081, '2017-11-01', '2017-10-01', '2017-11-30', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2017-11-23 22:01:40', 'dbo', ''),
(2017100003, 201710, 36, 3, '2017-11-23', 2954, 'ENERGY', 8948, 8948, '2017-11-01', '2017-10-01', '2017-11-30', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2017-11-23 22:01:40', 'dbo', ''),
(2017100004, 201710, 36, 4, '2017-11-23', 2955, 'ENERGY', 6711, 6711, '2017-11-01', '2017-10-01', '2017-11-30', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2017-11-23 22:01:40', 'dbo', ''),
(2017100005, 201710, 36, 5, '2017-11-23', 2956, 'ENERGY', 5255, 5255, '2017-11-01', '2017-10-01', '2017-11-30', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2017-11-23 22:01:40', 'dbo', ''),
(2017100006, 201710, 36, 6, '2017-11-23', 2957, 'ENERGY', 13833, 13833, '2017-11-01', '2017-10-01', '2017-11-30', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2017-11-23 22:01:40', 'dbo', ''),
(2017100007, 201710, 36, 7, '2017-11-23', 2958, 'ENERGY', 9652, 9652, '2017-11-01', '2017-10-01', '2017-11-30', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2017-11-23 22:01:40', 'dbo', ''),
(2017100008, 201710, 36, 8, '2017-11-23', 2959, 'ENERGY', 167, 167, '2017-11-01', '2017-10-01', '2017-11-30', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2017-11-23 22:01:40', 'dbo', ''),
(2017100009, 201710, 36, 9, '2017-11-23', 2960, 'ENERGY', 503, 236, '2017-11-01', '2017-10-01', '2017-11-30', 267, 12434.2064, 0.0000, 5444.8000, 17879.0064, '2017-11-23 22:01:39', 'dbo', ''),
(2017100010, 201710, 36, 10, '2017-11-23', 2961, 'ENERGY', 146, 89, '2017-11-01', '2017-10-01', '2017-11-30', 57, 6763.7580, 0.0000, 1390.4700, 8154.2280, '2017-11-23 22:01:39', 'dbo', ''),
(2017100011, 201710, 36, 11, '2017-11-23', 2962, 'ENERGY', 201, 201, '2017-11-01', '2017-10-01', '2017-11-30', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2017-11-23 22:01:40', 'dbo', ''),
(2017100012, 201710, 36, 12, '2017-11-23', 2963, 'ENERGY', 137, 137, '2017-11-01', '2017-10-01', '2017-11-30', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2017-11-23 22:01:40', 'dbo', ''),
(2017100013, 201710, 36, 13, '2017-11-23', 2964, 'ENERGY', 7476, 6661, '2017-11-01', '2017-10-01', '2017-11-30', 815, 134505.7240, 0.0000, 16024.7100, 150530.4340, '2017-11-23 22:01:39', 'dbo', ''),
(2017100014, 201710, 36, 14, '2017-11-23', 2965, 'ENERGY', 2679, 2412, '2017-11-01', '2017-10-01', '2017-11-30', 267, 54476.5954, 0.0000, 5444.8000, 59921.3954, '2017-11-23 22:01:39', 'dbo', ''),
(2017100015, 201710, 36, 15, '2017-11-23', 2966, 'ENERGY', 162, 162, '2017-11-01', '2017-10-01', '2017-11-30', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2017-11-23 22:01:40', 'dbo', ''),
(2017100016, 201710, 36, 16, '2017-11-23', 2967, 'ENERGY', 7040, 6388, '2017-11-01', '2017-10-01', '2017-11-30', 652, 128607.5420, 0.0000, 12877.7600, 141485.3020, '2017-11-23 22:01:40', 'dbo', ''),
(2017100017, 201710, 36, 17, '2017-11-23', 2968, 'ENERGY', 18209, 16470, '2017-11-01', '2017-10-01', '2017-11-30', 1739, 313317.0770, 0.0000, 33863.8200, 347180.8970, '2017-11-23 22:01:39', 'dbo', ''),
(2017100018, 201710, 36, 18, '2017-11-23', 2969, 'ENERGY', 5468, 5174, '2017-11-01', '2017-10-01', '2017-11-30', 294, 102348.2100, 0.0000, 5966.0800, 108314.2900, '2017-11-23 22:01:39', 'dbo', ''),
(2017100019, 201710, 36, 19, '2017-11-23', 2970, 'ENERGY', 75, 75, '2017-11-01', '2017-10-01', '2017-11-30', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2017-11-23 22:01:40', 'dbo', ''),
(2017100020, 201710, 36, 20, '2017-11-23', 2971, 'ENERGY', 254, 254, '2017-11-01', '2017-10-01', '2017-11-30', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2017-11-23 22:01:40', 'dbo', ''),
(2017100021, 201710, 36, 21, '2017-11-23', 2972, 'ENERGY', 44228, 43711, '2017-11-01', '2017-10-01', '2017-11-30', 517, 584042.3246, 0.0000, 10271.4000, 594313.7246, '2017-11-23 22:01:39', 'dbo', ''),
(2017100022, 201710, 36, 22, '2017-11-23', 2973, 'ENERGY', 25889, 25503, '2017-11-01', '2017-10-01', '2017-11-30', 386, 338294.3816, 0.0000, 7742.2600, 346036.6416, '2017-11-23 22:01:39', 'dbo', ''),
(2017100023, 201710, 36, 23, '2017-11-23', 2974, 'ENERGY', 68394, 66987, '2017-11-01', '2017-10-01', '2017-11-30', 1407, 923863.9970, 0.0000, 27454.0800, 951318.0770, '2017-11-23 22:01:39', 'dbo', ''),
(2017100024, 201710, 36, 24, '2017-11-23', 2975, 'ENERGY', 44002, 43645, '2017-11-01', '2017-10-01', '2017-11-30', 357, 541811.4100, 0.0000, 7182.3800, 548993.7900, '2017-11-23 22:01:39', 'dbo', '');
INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2017100025, 201710, 36, 25, '2017-11-23', 2976, 'ENERGY', 59264, 54247, '2017-11-01', '2017-10-01', '2017-11-30', 5017, 1019174.3900, 0.0000, 97150.1700, 1116324.5600, '2017-11-23 22:01:39', 'dbo', ''),
(2017100026, 201710, 36, 26, '2017-11-23', 2977, 'ENERGY', 60080, 58547, '2017-11-01', '2017-10-01', '2017-11-30', 1533, 947205.1674, 0.0000, 29886.6900, 977091.8574, '2017-11-23 22:01:39', 'dbo', ''),
(2017100029, 201710, 36, 29, '2017-11-23', 2980, 'ENERGY', 84644, 82681, '2017-11-01', '2017-10-01', '2017-11-30', 1963, 1252130.3588, 0.0000, 38188.4400, 1290318.7988, '2017-11-23 22:01:40', 'dbo', ''),
(2017100030, 201710, 36, 30, '2017-11-23', 2981, 'ENERGY', 41019, 40055, '2017-11-01', '2017-10-01', '2017-11-30', 964, 500458.2912, 0.0000, 18901.3600, 519359.6512, '2017-11-23 22:01:40', 'dbo', ''),
(2017100031, 201710, 36, 31, '2017-11-23', 2982, 'ENERGY', 64790, 62613, '2017-11-01', '2017-10-01', '2017-11-30', 2177, 965898.7380, 0.0000, 42320.0200, 1008218.7580, '2017-11-23 22:01:40', 'dbo', ''),
(2017100032, 201710, 36, 32, '2017-11-23', 2983, 'ENERGY', 105573, 102253, '2017-11-01', '2017-10-01', '2017-11-30', 3320, 1581310.0390, 0.0000, 64387.2100, 1645697.2490, '2017-11-23 22:01:40', 'dbo', ''),
(2017100033, 201710, 36, 33, '2017-11-23', 2984, 'ENERGY', 13321, 12684, '2017-11-01', '2017-10-01', '2017-11-30', 637, 211304.4034, 0.0000, 12588.1600, 223892.5634, '2017-11-23 22:01:39', 'dbo', ''),
(2017100034, 201710, 36, 34, '2017-11-23', 2985, 'ENERGY', 9941, 9465, '2017-11-01', '2017-10-01', '2017-11-30', 476, 164828.7942, 0.0000, 9479.8400, 174308.6342, '2017-11-23 22:01:39', 'dbo', ''),
(2017100035, 201710, 36, 35, '2017-11-23', 2986, 'ENERGY', 16852, 16560, '2017-11-01', '2017-10-01', '2017-11-30', 292, 264306.7326, 0.0000, 5927.4600, 270234.1926, '2017-11-23 22:01:39', 'dbo', ''),
(2017100036, 201710, 36, 36, '2017-11-23', 2987, 'ENERGY', 41465, 40016, '2017-11-01', '2017-10-01', '2017-11-30', 1449, 667871.6538, 0.0000, 28264.9600, 696136.6138, '2017-11-23 22:01:39', 'dbo', ''),
(2017100037, 201710, 36, 37, '2017-11-23', 2988, 'ENERGY', 21405, 20920, '2017-11-01', '2017-10-01', '2017-11-30', 485, 326515.5810, 0.0000, 9653.6000, 336169.1810, '2017-11-23 22:01:39', 'dbo', ''),
(2017100038, 201710, 36, 38, '2017-11-23', 2989, 'ENERGY', 11234, 10843, '2017-11-01', '2017-10-01', '2017-11-30', 391, 181666.0234, 0.0000, 7838.7900, 189504.8134, '2017-11-23 22:01:39', 'dbo', ''),
(2017100039, 201710, 36, 39, '2017-11-23', 2990, 'ENERGY', 26441, 25881, '2017-11-01', '2017-10-01', '2017-11-30', 560, -189187.8918, 0.0000, 11101.5700, -178086.3218, '2017-11-23 22:01:39', 'dbo', ''),
(2017100040, 201710, 36, 40, '2017-11-23', 2991, 'ENERGY', 24900, 23979, '2017-11-01', '2017-10-01', '2017-11-30', 921, 401073.7496, 0.0000, 18071.1900, 419144.9396, '2017-11-23 22:01:39', 'dbo', ''),
(2017100041, 201710, 36, 41, '2017-11-23', 2992, 'ENERGY', 241, 241, '2017-11-01', '2017-10-01', '2017-11-30', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2017-11-23 22:01:40', 'dbo', ''),
(2017100042, 201710, 36, 42, '2017-11-23', 2993, 'ENERGY', 334, 334, '2017-11-01', '2017-10-01', '2017-11-30', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2017-11-23 22:01:40', 'dbo', ''),
(2017100043, 201710, 36, 43, '2017-11-23', 2994, 'ENERGY', 64725, 62684, '2017-11-01', '2017-10-01', '2017-11-30', 2041, 855915.8702, 0.0000, 39694.3400, 895610.2102, '2017-11-23 22:01:39', 'dbo', ''),
(2017100044, 201710, 36, 44, '2017-11-23', 2995, 'ENERGY', 37473, 36326, '2017-11-01', '2017-10-01', '2017-11-30', 1147, 671096.5230, 0.0000, 22434.4300, 693530.9530, '2017-11-23 22:01:39', 'dbo', ''),
(2017100045, 201710, 36, 45, '2017-11-23', 2996, 'ENERGY', 32653, 32037, '2017-11-01', '2017-10-01', '2017-11-30', 616, 318476.2920, 0.0000, 12182.7300, 330659.0220, '2017-11-23 22:01:40', 'dbo', ''),
(2017100046, 201710, 36, 46, '2017-11-23', 2997, 'ENERGY', 48593, 47319, '2017-11-01', '2017-10-01', '2017-11-30', 1274, 816090.8454, 0.0000, 24886.3500, 840977.1954, '2017-11-23 22:01:40', 'dbo', ''),
(2017100047, 201710, 36, 47, '2017-11-23', 2998, 'ENERGY', 24454, 23815, '2017-11-01', '2017-10-01', '2017-11-30', 639, 295272.4110, 0.0000, 12626.7800, 307899.1910, '2017-11-23 22:01:40', 'dbo', ''),
(2017100048, 201710, 36, 48, '2017-11-23', 2999, 'ENERGY', 11954, 11146, '2017-11-01', '2017-10-01', '2017-11-30', 808, 213535.5200, 0.0000, 15889.5700, 229425.0900, '2017-11-23 22:01:40', 'dbo', ''),
(2017100049, 201710, 36, 49, '2017-11-23', 3000, 'ENERGY', 5750, 5545, '2017-11-01', '2017-10-01', '2017-11-30', 205, 91735.4890, 0.0000, 4247.8100, 95983.2990, '2017-11-23 22:01:39', 'dbo', ''),
(2017100050, 201710, 36, 50, '2017-11-23', 3001, 'ENERGY', 81645, 79238, '2017-11-01', '2017-10-01', '2017-11-30', 2407, 1178479.4692, 0.0000, 46760.4800, 1225239.9492, '2017-11-23 22:01:39', 'dbo', ''),
(2017100051, 201710, 36, 51, '2017-11-23', 3002, 'ENERGY', 211, 211, '2017-11-01', '2017-10-01', '2017-11-30', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2017-11-23 22:01:40', 'dbo', ''),
(2017100052, 201710, 36, 52, '2017-11-23', 3003, 'ENERGY', 321, 321, '2017-11-01', '2017-10-01', '2017-11-30', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2017-11-23 22:01:40', 'dbo', ''),
(2017100053, 201710, 36, 53, '2017-11-23', 3004, 'ENERGY', 1817, 1817, '2017-11-01', '2017-10-01', '2017-11-30', 0, 41322.8070, 0.0000, 0.0000, 41322.8070, '2017-11-23 22:01:40', 'dbo', ''),
(2017100054, 201710, 36, 54, '2017-11-23', 3005, 'ENERGY', 27480, 26626, '2017-11-01', '2017-10-01', '2017-11-30', 854, 245342.0594, 0.0000, 16777.6600, 262119.7194, '2017-11-23 22:01:39', 'dbo', ''),
(2017100055, 201710, 36, 55, '2017-11-23', 3006, 'ENERGY', 12689, 12689, '2017-11-01', '2017-10-01', '2017-11-30', 0, 239408.7700, 0.0000, 0.0000, 239408.7700, '2017-11-23 22:01:40', 'dbo', ''),
(2017100056, 201710, 36, 56, '2017-11-23', 3007, 'ENERGY', 239, 239, '2017-11-01', '2017-10-01', '2017-11-30', 0, 8516.7790, 0.0000, 0.0000, 8516.7790, '2017-11-23 22:01:40', 'dbo', ''),
(2017100059, 201710, 36, 59, '2017-11-23', 3010, 'ENERGY', 128, 128, '2017-11-01', '2017-10-01', '2017-11-30', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2017-11-23 22:01:40', 'dbo', ''),
(2017100060, 201710, 36, 60, '2017-11-23', 3011, 'ENERGY', 214177, 205700, '2017-11-01', '2017-10-01', '2017-11-30', 8477, 2513484.0700, 0.0000, 163950.2700, 2677434.3400, '2017-11-23 22:01:39', 'dbo', ''),
(2017100061, 201710, 36, 61, '2017-11-23', 3012, 'ENERGY', 16, 16, '2017-11-01', '2017-10-01', '2017-11-30', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2017-11-23 22:01:40', 'dbo', ''),
(2017100062, 201710, 36, 62, '2017-11-23', 3013, 'ENERGY', 30, 30, '2017-11-01', '2017-10-01', '2017-11-30', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-11-23 22:01:40', 'dbo', ''),
(2017100063, 201710, 36, 63, '2017-11-23', 3014, 'ENERGY', 1, 1, '2017-11-01', '2017-10-01', '2017-11-30', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-11-23 22:01:40', 'dbo', ''),
(2017100064, 201710, 36, 64, '2017-11-23', 3015, 'ENERGY', 2, 2, '2017-11-01', '2017-10-01', '2017-11-30', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-11-23 22:01:40', 'dbo', ''),
(2017100065, 201710, 36, 65, '2017-11-23', 3016, 'ENERGY', 7628, 7223, '2017-11-01', '2017-10-01', '2017-11-30', 405, 140334.6680, 0.0000, 8109.0800, 148443.7480, '2017-11-23 22:01:39', 'dbo', ''),
(2017100066, 201710, 36, 66, '2017-11-23', 3017, 'ENERGY', 5844, 5578, '2017-11-01', '2017-10-01', '2017-11-30', 266, 107531.5924, 0.0000, 5425.5000, 112957.0924, '2017-11-23 22:01:39', 'dbo', ''),
(2017100067, 201710, 36, 67, '2017-11-23', 3018, 'ENERGY', 716, 689, '2017-11-01', '2017-10-01', '2017-11-30', 27, 18887.0338, 0.0000, 811.2700, 19698.3038, '2017-11-23 22:01:40', 'dbo', ''),
(2017100068, 201710, 36, 68, '2017-11-23', 3019, 'ENERGY', 1392, 1337, '2017-11-01', '2017-10-01', '2017-11-30', 55, 31814.1500, 0.0000, 1351.8500, 33166.0000, '2017-11-23 22:01:40', 'dbo', ''),
(2017100069, 201710, 36, 69, '2017-11-23', 3020, 'ENERGY', 1, 1, '2017-11-01', '2017-10-01', '2017-11-30', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2017-11-23 22:01:40', 'dbo', ''),
(2017100070, 201710, 36, 70, '2017-11-23', 3021, 'ENERGY', 345, 345, '2017-11-01', '2017-10-01', '2017-11-30', 0, 11744.5000, 0.0000, 0.0000, 11744.5000, '2017-11-23 22:01:40', 'dbo', ''),
(2017100071, 201710, 36, 71, '2017-11-23', 3022, 'ENERGY', 139114, 132161, '2017-11-01', '2017-10-01', '2017-11-30', 6953, 2357273.7462, 0.0000, 134527.3300, 2491801.0762, '2017-11-23 22:01:39', 'dbo', ''),
(2017100072, 201710, 36, 72, '2017-11-23', 3023, 'ENERGY', 1433, 1398, '2017-11-01', '2017-10-01', '2017-11-30', 35, 34286.0200, 0.0000, 965.7200, 35251.7400, '2017-11-23 22:01:39', 'dbo', ''),
(2017100073, 201710, 36, 73, '2017-11-23', 3024, 'ENERGY', 465, 430, '2017-11-01', '2017-10-01', '2017-11-30', 35, 22669.0280, 0.0000, 965.7200, 23634.7480, '2017-11-23 22:01:39', 'dbo', ''),
(2017100075, 201710, 36, 75, '2017-11-23', 3025, 'ENERGY', 1356, 1310, '2017-11-01', '2017-10-01', '2017-11-30', 46, 31598.6900, 0.0000, 1178.0900, 32776.7800, '2017-11-23 22:01:39', 'dbo', ''),
(2017100076, 201710, 36, 76, '2017-11-23', 3026, 'ENERGY', 1430, 1386, '2017-11-01', '2017-10-01', '2017-11-30', 44, 32943.2300, 0.0000, 1139.4900, 34082.7200, '2017-11-23 22:01:39', 'dbo', ''),
(2017100077, 201710, 36, 77, '2017-11-23', 3027, 'ENERGY', 1150, 1118, '2017-11-01', '2017-10-01', '2017-11-30', 32, 27928.1700, 0.0000, 907.8000, 28835.9700, '2017-11-23 22:01:39', 'dbo', ''),
(2017100078, 201710, 36, 78, '2017-11-23', 3028, 'ENERGY', 318, 305, '2017-11-01', '2017-10-01', '2017-11-30', 13, 12807.0000, 0.0000, 540.9800, 13347.9800, '2017-11-23 22:01:39', 'dbo', ''),
(2017100079, 201710, 36, 79, '2017-11-23', 3029, 'ENERGY', 37346, 35810, '2017-11-01', '2017-10-01', '2017-11-30', 1536, 560334.8000, 0.0000, 29944.6100, 590279.4100, '2017-11-23 22:01:39', 'dbo', ''),
(2017100080, 201710, 36, 80, '2017-11-23', 3030, 'ENERGY', 311, 311, '2017-11-01', '2017-10-01', '2017-11-30', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2017-11-23 22:01:40', 'dbo', ''),
(2017100081, 201710, 36, 81, '2017-11-23', 3031, 'ENERGY', 1319, 1263, '2017-11-01', '2017-10-01', '2017-11-30', 56, 27448.7300, 0.0000, 1371.1500, 28819.8800, '2017-11-23 22:01:39', 'dbo', ''),
(2017100082, 201710, 36, 82, '2017-11-23', 3032, 'ENERGY', 2489, 2348, '2017-11-01', '2017-10-01', '2017-11-30', 141, 48878.1000, 0.0000, 3012.2000, 51890.3000, '2017-11-23 22:01:39', 'dbo', ''),
(2017100083, 201710, 36, 83, '2017-11-23', 3033, 'ENERGY', 62, 58, '2017-11-01', '2017-10-01', '2017-11-30', 4, 4032.2700, 0.0000, 367.2300, 4399.5000, '2017-11-23 22:01:39', 'dbo', ''),
(2017100084, 201710, 36, 84, '2017-11-23', 3034, 'ENERGY', 37, 31, '2017-11-01', '2017-10-01', '2017-11-30', 6, 3178.9600, 0.0000, 405.8400, 3584.8000, '2017-11-23 22:01:39', 'dbo', ''),
(2017100085, 201710, 36, 85, '2017-11-23', 3035, 'ENERGY', 0, 0, '2017-11-01', '2017-10-01', '2017-11-30', 0, 0.0000, 0.0000, 0.0000, 0.0000, '2017-11-23 22:01:40', 'dbo', ''),
(2017100086, 201710, 36, 86, '2017-11-23', 3036, 'ENERGY', 61, 56, '2017-11-01', '2017-10-01', '2017-11-30', 5, 3659.6800, 0.0000, 386.5200, 4046.2000, '2017-11-23 22:01:39', 'dbo', ''),
(2017110001, 201711, 37, 1, '2017-12-08', 3037, 'ENERGY', 14016, 14016, '2017-12-01', '2017-11-01', '2017-12-15', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2017-12-08 07:17:27', 'dbo', ''),
(2017110002, 201711, 37, 2, '2017-12-08', 3038, 'ENERGY', 7081, 7081, '2017-12-01', '2017-11-01', '2017-12-15', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2017-12-08 07:17:27', 'dbo', ''),
(2017110003, 201711, 37, 3, '2017-12-08', 3039, 'ENERGY', 8948, 8948, '2017-12-01', '2017-11-01', '2017-12-15', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2017-12-08 07:17:27', 'dbo', ''),
(2017110004, 201711, 37, 4, '2017-12-08', 3040, 'ENERGY', 6711, 6711, '2017-12-01', '2017-11-01', '2017-12-15', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2017-12-08 07:17:27', 'dbo', ''),
(2017110005, 201711, 37, 5, '2017-12-08', 3041, 'ENERGY', 5255, 5255, '2017-12-01', '2017-11-01', '2017-12-15', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2017-12-08 07:17:27', 'dbo', ''),
(2017110006, 201711, 37, 6, '2017-12-08', 3042, 'ENERGY', 13833, 13833, '2017-12-01', '2017-11-01', '2017-12-15', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2017-12-08 07:17:27', 'dbo', ''),
(2017110007, 201711, 37, 7, '2017-12-08', 3043, 'ENERGY', 9652, 9652, '2017-12-01', '2017-11-01', '2017-12-15', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2017-12-08 07:17:27', 'dbo', ''),
(2017110008, 201711, 37, 8, '2017-12-08', 3044, 'ENERGY', 167, 167, '2017-12-01', '2017-11-01', '2017-12-15', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2017-12-08 07:17:27', 'dbo', ''),
(2017110009, 201711, 37, 9, '2017-12-08', 3045, 'ENERGY', 2263, 503, '2017-12-01', '2017-11-01', '2017-12-15', 1760, 17879.0064, 0.0000, 35817.6300, 53696.6364, '2017-12-08 07:17:26', 'dbo', ''),
(2017110010, 201711, 37, 10, '2017-12-08', 3046, 'ENERGY', 446, 146, '2017-12-01', '2017-11-01', '2017-12-15', 300, 8154.2280, 0.0000, 6345.8400, 14500.0680, '2017-12-08 07:17:26', 'dbo', ''),
(2017110011, 201711, 37, 11, '2017-12-08', 3047, 'ENERGY', 201, 201, '2017-12-01', '2017-11-01', '2017-12-15', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2017-12-08 07:17:27', 'dbo', ''),
(2017110012, 201711, 37, 12, '2017-12-08', 3048, 'ENERGY', 137, 137, '2017-12-01', '2017-11-01', '2017-12-15', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2017-12-08 07:17:27', 'dbo', ''),
(2017110013, 201711, 37, 13, '2017-12-08', 3049, 'ENERGY', 8419, 7476, '2017-12-01', '2017-11-01', '2017-12-15', 943, 150530.4340, 0.0000, 19325.5500, 169855.9840, '2017-12-08 07:17:26', 'dbo', ''),
(2017110014, 201711, 37, 14, '2017-12-08', 3050, 'ENERGY', 3159, 2679, '2017-12-01', '2017-11-01', '2017-12-15', 480, 59921.3954, 0.0000, 9979.3600, 69900.7554, '2017-12-08 07:17:26', 'dbo', ''),
(2017110015, 201711, 37, 15, '2017-12-08', 3051, 'ENERGY', 162, 162, '2017-12-01', '2017-11-01', '2017-12-15', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2017-12-08 07:17:27', 'dbo', ''),
(2017110016, 201711, 37, 16, '2017-12-08', 3052, 'ENERGY', 7604, 7040, '2017-12-01', '2017-11-01', '2017-12-15', 564, 141485.3020, 0.0000, 11674.9900, 153160.2920, '2017-12-08 07:17:26', 'dbo', ''),
(2017110017, 201711, 37, 17, '2017-12-08', 3053, 'ENERGY', 19782, 18209, '2017-12-01', '2017-11-01', '2017-12-15', 1573, 347180.8970, 0.0000, 32042.8200, 379223.7170, '2017-12-08 07:17:26', 'dbo', ''),
(2017110018, 201711, 37, 18, '2017-12-08', 3054, 'ENERGY', 5843, 5468, '2017-12-01', '2017-11-01', '2017-12-15', 375, 108314.2900, 0.0000, 7859.8100, 116174.1000, '2017-12-08 07:17:26', 'dbo', ''),
(2017110019, 201711, 37, 19, '2017-12-08', 3055, 'ENERGY', 75, 75, '2017-12-01', '2017-11-01', '2017-12-15', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2017-12-08 07:17:27', 'dbo', ''),
(2017110020, 201711, 37, 20, '2017-12-08', 3056, 'ENERGY', 254, 254, '2017-12-01', '2017-11-01', '2017-12-15', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2017-12-08 07:17:27', 'dbo', ''),
(2017110021, 201711, 37, 21, '2017-12-08', 3057, 'ENERGY', 44795, 44228, '2017-12-01', '2017-11-01', '2017-12-15', 567, 594313.7246, 0.0000, 11735.5500, 606049.2746, '2017-12-08 07:17:26', 'dbo', ''),
(2017110022, 201711, 37, 22, '2017-12-08', 3058, 'ENERGY', 26261, 25889, '2017-12-01', '2017-11-01', '2017-12-15', 372, 346036.6416, 0.0000, 7799.2500, 353835.8916, '2017-12-08 07:17:26', 'dbo', ''),
(2017110023, 201711, 37, 23, '2017-12-08', 3059, 'ENERGY', 69727, 68394, '2017-12-01', '2017-11-01', '2017-12-15', 1333, 951318.0770, 0.0000, 27198.1500, 978516.2270, '2017-12-08 07:17:26', 'dbo', ''),
(2017110024, 201711, 37, 24, '2017-12-08', 3060, 'ENERGY', 44346, 44002, '2017-12-01', '2017-11-01', '2017-12-15', 344, 548993.7900, 0.0000, 7234.0400, 556227.8300, '2017-12-08 07:17:26', 'dbo', ''),
(2017110025, 201711, 37, 25, '2017-12-08', 3061, 'ENERGY', 64302, 59264, '2017-12-01', '2017-11-01', '2017-12-15', 5038, 1116324.5600, 0.0000, 101987.8700, 1218312.4300, '2017-12-08 07:17:26', 'dbo', ''),
(2017110026, 201711, 37, 26, '2017-12-08', 3062, 'ENERGY', 61555, 60080, '2017-12-01', '2017-11-01', '2017-12-15', 1475, 977091.8574, 0.0000, 30064.5800, 1007156.4374, '2017-12-08 07:17:26', 'dbo', ''),
(2017110029, 201711, 37, 29, '2017-12-08', 3065, 'ENERGY', 86590, 84644, '2017-12-01', '2017-11-01', '2017-12-15', 1946, 1290318.7988, 0.0000, 39572.2600, 1329891.0588, '2017-12-08 07:17:26', 'dbo', ''),
(2017110030, 201711, 37, 30, '2017-12-08', 3066, 'ENERGY', 42029, 41019, '2017-12-01', '2017-11-01', '2017-12-15', 1010, 519359.6512, 0.0000, 20678.0300, 540037.6812, '2017-12-08 07:17:26', 'dbo', ''),
(2017110031, 201711, 37, 31, '2017-12-08', 3067, 'ENERGY', 66886, 64790, '2017-12-01', '2017-11-01', '2017-12-15', 2096, 1008218.7580, 0.0000, 42600.1900, 1050818.9480, '2017-12-08 07:17:26', 'dbo', ''),
(2017110032, 201711, 37, 32, '2017-12-08', 3068, 'ENERGY', 109116, 105573, '2017-12-01', '2017-11-01', '2017-12-15', 3543, 1645697.2490, 0.0000, 71809.5500, 1717506.7990, '2017-12-08 07:17:26', 'dbo', ''),
(2017110033, 201711, 37, 33, '2017-12-08', 3069, 'ENERGY', 13929, 13321, '2017-12-01', '2017-11-01', '2017-12-15', 608, 223892.5634, 0.0000, 12563.1900, 236455.7534, '2017-12-08 07:17:26', 'dbo', ''),
(2017110034, 201711, 37, 34, '2017-12-08', 3070, 'ENERGY', 10513, 9941, '2017-12-01', '2017-11-01', '2017-12-15', 572, 174308.6342, 0.0000, 11836.4900, 186145.1242, '2017-12-08 07:17:26', 'dbo', ''),
(2017110035, 201711, 37, 35, '2017-12-08', 3071, 'ENERGY', 17156, 16852, '2017-12-01', '2017-11-01', '2017-12-15', 304, 270234.1926, 0.0000, 6426.5900, 276660.7826, '2017-12-08 07:17:26', 'dbo', ''),
(2017110036, 201711, 37, 36, '2017-12-08', 3072, 'ENERGY', 42604, 41465, '2017-12-01', '2017-11-01', '2017-12-15', 1139, 696136.6138, 0.0000, 23282.0200, 719418.6338, '2017-12-08 07:17:26', 'dbo', ''),
(2017110037, 201711, 37, 37, '2017-12-08', 3073, 'ENERGY', 21784, 21405, '2017-12-01', '2017-11-01', '2017-12-15', 379, 336169.1810, 0.0000, 7940.5600, 344109.7410, '2017-12-08 07:17:26', 'dbo', ''),
(2017110038, 201711, 37, 38, '2017-12-08', 3074, 'ENERGY', 11573, 11234, '2017-12-01', '2017-11-01', '2017-12-15', 339, 189504.8134, 0.0000, 7133.1100, 196637.9234, '2017-12-08 07:17:26', 'dbo', ''),
(2017110039, 201711, 37, 39, '2017-12-08', 3075, 'ENERGY', 26728, 26441, '2017-12-01', '2017-11-01', '2017-12-15', 287, -178086.3218, 0.0000, 6083.4400, -172002.8818, '2017-12-08 07:17:26', 'dbo', ''),
(2017110040, 201711, 37, 40, '2017-12-08', 3076, 'ENERGY', 25811, 24900, '2017-12-01', '2017-11-01', '2017-12-15', 911, 419144.9396, 0.0000, 18679.6000, 437824.5396, '2017-12-08 07:17:26', 'dbo', ''),
(2017110041, 201711, 37, 41, '2017-12-08', 3077, 'ENERGY', 241, 241, '2017-12-01', '2017-11-01', '2017-12-15', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2017-12-08 07:17:27', 'dbo', ''),
(2017110042, 201711, 37, 42, '2017-12-08', 3078, 'ENERGY', 334, 334, '2017-12-01', '2017-11-01', '2017-12-15', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2017-12-08 07:17:27', 'dbo', ''),
(2017110043, 201711, 37, 43, '2017-12-08', 3079, 'ENERGY', 66699, 64725, '2017-12-01', '2017-11-01', '2017-12-15', 1974, 895610.2102, 0.0000, 40137.4800, 935747.6902, '2017-12-08 07:17:26', 'dbo', ''),
(2017110044, 201711, 37, 44, '2017-12-08', 3080, 'ENERGY', 38524, 37473, '2017-12-01', '2017-11-01', '2017-12-15', 1051, 693530.9530, 0.0000, 21505.6500, 715036.6030, '2017-12-08 07:17:26', 'dbo', ''),
(2017110045, 201711, 37, 45, '2017-12-08', 3081, 'ENERGY', 33222, 32653, '2017-12-01', '2017-11-01', '2017-12-15', 569, 330659.0220, 0.0000, 11775.9300, 342434.9520, '2017-12-08 07:17:26', 'dbo', ''),
(2017110046, 201711, 37, 46, '2017-12-08', 3082, 'ENERGY', 49848, 48593, '2017-12-01', '2017-11-01', '2017-12-15', 1255, 840977.1954, 0.0000, 25623.6300, 866600.8254, '2017-12-08 07:17:26', 'dbo', ''),
(2017110047, 201711, 37, 47, '2017-12-08', 3083, 'ENERGY', 25101, 24454, '2017-12-01', '2017-11-01', '2017-12-15', 647, 307899.1910, 0.0000, 13350.4500, 321249.6410, '2017-12-08 07:17:26', 'dbo', ''),
(2017110048, 201711, 37, 48, '2017-12-08', 3084, 'ENERGY', 12850, 11954, '2017-12-01', '2017-11-01', '2017-12-15', 896, 229425.0900, 0.0000, 18376.8000, 247801.8900, '2017-12-08 07:17:26', 'dbo', ''),
(2017110049, 201711, 37, 49, '2017-12-08', 3085, 'ENERGY', 5916, 5750, '2017-12-01', '2017-11-01', '2017-12-15', 166, 95983.2990, 0.0000, 3640.9100, 99624.2090, '2017-12-08 07:17:26', 'dbo', ''),
(2017110050, 201711, 37, 50, '2017-12-08', 3086, 'ENERGY', 83547, 81645, '2017-12-01', '2017-11-01', '2017-12-15', 1902, 1225239.9492, 0.0000, 38684.0700, 1263924.0192, '2017-12-08 07:17:26', 'dbo', ''),
(2017110051, 201711, 37, 51, '2017-12-08', 3087, 'ENERGY', 211, 211, '2017-12-01', '2017-11-01', '2017-12-15', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2017-12-08 07:17:27', 'dbo', ''),
(2017110052, 201711, 37, 52, '2017-12-08', 3088, 'ENERGY', 321, 321, '2017-12-01', '2017-11-01', '2017-12-15', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2017-12-08 07:17:27', 'dbo', ''),
(2017110053, 201711, 37, 53, '2017-12-08', 3089, 'ENERGY', 1817, 1817, '2017-12-01', '2017-11-01', '2017-12-15', 0, 41322.8070, 0.0000, 0.0000, 41322.8070, '2017-12-08 07:17:27', 'dbo', ''),
(2017110054, 201711, 37, 54, '2017-12-08', 3090, 'ENERGY', 28339, 27480, '2017-12-01', '2017-11-01', '2017-12-15', 859, 262119.7194, 0.0000, 17629.9100, 279749.6294, '2017-12-08 07:17:26', 'dbo', ''),
(2017110055, 201711, 37, 55, '2017-12-08', 3091, 'ENERGY', 12689, 12689, '2017-12-01', '2017-11-01', '2017-12-15', 0, 239408.7700, 0.0000, 0.0000, 239408.7700, '2017-12-08 07:17:27', 'dbo', ''),
(2017110056, 201711, 37, 56, '2017-12-08', 3092, 'ENERGY', 266, 239, '2017-12-01', '2017-11-01', '2017-12-15', 27, 8516.7790, 0.0000, 835.0300, 9351.8090, '2017-12-08 07:17:26', 'dbo', ''),
(2017110059, 201711, 37, 59, '2017-12-08', 3095, 'ENERGY', 128, 128, '2017-12-01', '2017-11-01', '2017-12-15', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2017-12-08 07:17:27', 'dbo', ''),
(2017110060, 201711, 37, 60, '2017-12-08', 3096, 'ENERGY', 221458, 214177, '2017-12-01', '2017-11-01', '2017-12-15', 7281, 2677434.3400, 0.0000, 147265.4200, 2824699.7600, '2017-12-08 07:17:25', 'dbo', ''),
(2017110061, 201711, 37, 61, '2017-12-08', 3097, 'ENERGY', 16, 16, '2017-12-01', '2017-11-01', '2017-12-15', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2017-12-08 07:17:27', 'dbo', ''),
(2017110062, 201711, 37, 62, '2017-12-08', 3098, 'ENERGY', 30, 30, '2017-12-01', '2017-11-01', '2017-12-15', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-12-08 07:17:27', 'dbo', ''),
(2017110063, 201711, 37, 63, '2017-12-08', 3099, 'ENERGY', 1, 1, '2017-12-01', '2017-11-01', '2017-12-15', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-12-08 07:17:27', 'dbo', ''),
(2017110064, 201711, 37, 64, '2017-12-08', 3100, 'ENERGY', 2, 2, '2017-12-01', '2017-11-01', '2017-12-15', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2017-12-08 07:17:27', 'dbo', ''),
(2017110065, 201711, 37, 65, '2017-12-08', 3101, 'ENERGY', 8036, 7628, '2017-12-01', '2017-11-01', '2017-12-15', 408, 148443.7480, 0.0000, 8525.9600, 156969.7080, '2017-12-08 07:17:26', 'dbo', ''),
(2017110066, 201711, 37, 66, '2017-12-08', 3102, 'ENERGY', 6098, 5844, '2017-12-01', '2017-11-01', '2017-12-15', 254, 112957.0924, 0.0000, 5417.2800, 118374.3724, '2017-12-08 07:17:26', 'dbo', ''),
(2017110067, 201711, 37, 67, '2017-12-08', 3103, 'ENERGY', 739, 716, '2017-12-01', '2017-11-01', '2017-12-15', 23, 19698.3038, 0.0000, 754.2900, 20452.5938, '2017-12-08 07:17:26', 'dbo', ''),
(2017110068, 201711, 37, 68, '2017-12-08', 3104, 'ENERGY', 1444, 1392, '2017-12-01', '2017-11-01', '2017-12-15', 52, 33166.0000, 0.0000, 1339.6700, 34505.6700, '2017-12-08 07:17:26', 'dbo', ''),
(2017110069, 201711, 37, 69, '2017-12-08', 3105, 'ENERGY', 1, 1, '2017-12-01', '2017-11-01', '2017-12-15', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2017-12-08 07:17:27', 'dbo', ''),
(2017110070, 201711, 37, 70, '2017-12-08', 3106, 'ENERGY', 401, 345, '2017-12-01', '2017-11-01', '2017-12-15', 56, 11744.5000, 0.0000, 1420.4200, 13164.9200, '2017-12-08 07:17:26', 'dbo', ''),
(2017110071, 201711, 37, 71, '2017-12-08', 3107, 'ENERGY', 147094, 139114, '2017-12-01', '2017-11-01', '2017-12-15', 7980, 2491801.0762, 0.0000, 161375.5500, 2653176.6262, '2017-12-08 07:17:25', 'dbo', ''),
(2017110072, 201711, 37, 72, '2017-12-08', 3108, 'ENERGY', 1473, 1433, '2017-12-01', '2017-11-01', '2017-12-15', 40, 35251.7400, 0.0000, 1097.4500, 36349.1900, '2017-12-08 07:17:25', 'dbo', ''),
(2017110073, 201711, 37, 73, '2017-12-08', 3109, 'ENERGY', 466, 465, '2017-12-01', '2017-11-01', '2017-12-15', 1, 23634.7480, 0.0000, 310.1900, 23944.9380, '2017-12-08 07:17:25', 'dbo', ''),
(2017110075, 201711, 37, 75, '2017-12-08', 3110, 'ENERGY', 1400, 1356, '2017-12-01', '2017-11-01', '2017-12-15', 44, 32776.7800, 0.0000, 1178.2000, 33954.9800, '2017-12-08 07:17:25', 'dbo', ''),
(2017110076, 201711, 37, 76, '2017-12-08', 3111, 'ENERGY', 1472, 1430, '2017-12-01', '2017-11-01', '2017-12-15', 42, 34082.7200, 0.0000, 1137.8200, 35220.5400, '2017-12-08 07:17:25', 'dbo', ''),
(2017110077, 201711, 37, 77, '2017-12-08', 3112, 'ENERGY', 1181, 1150, '2017-12-01', '2017-11-01', '2017-12-15', 31, 28835.9700, 0.0000, 915.7800, 29751.7500, '2017-12-08 07:17:25', 'dbo', ''),
(2017110078, 201711, 37, 78, '2017-12-08', 3113, 'ENERGY', 331, 318, '2017-12-01', '2017-11-01', '2017-12-15', 13, 13347.9800, 0.0000, 552.4200, 13900.4000, '2017-12-08 07:17:25', 'dbo', ''),
(2017110079, 201711, 37, 79, '2017-12-08', 3114, 'ENERGY', 38839, 37346, '2017-12-01', '2017-11-01', '2017-12-15', 1493, 590279.4100, 0.0000, 30427.9300, 620707.3400, '2017-12-08 07:17:26', 'dbo', ''),
(2017110080, 201711, 37, 80, '2017-12-08', 3115, 'ENERGY', 311, 311, '2017-12-01', '2017-11-01', '2017-12-15', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2017-12-08 07:17:27', 'dbo', ''),
(2017110081, 201711, 37, 81, '2017-12-08', 3116, 'ENERGY', 1374, 1319, '2017-12-01', '2017-11-01', '2017-12-15', 55, 28819.8800, 0.0000, 1400.2400, 30220.1200, '2017-12-08 07:17:26', 'dbo', ''),
(2017110082, 201711, 37, 82, '2017-12-08', 3117, 'ENERGY', 2624, 2489, '2017-12-01', '2017-11-01', '2017-12-15', 135, 51890.3000, 0.0000, 3015.1300, 54905.4300, '2017-12-08 07:17:26', 'dbo', ''),
(2017110083, 201711, 37, 83, '2017-12-08', 3118, 'ENERGY', 66, 62, '2017-12-01', '2017-11-01', '2017-12-15', 4, 4399.5000, 0.0000, 370.7500, 4770.2500, '2017-12-08 07:17:26', 'dbo', ''),
(2017110084, 201711, 37, 84, '2017-12-08', 3119, 'ENERGY', 49, 37, '2017-12-01', '2017-11-01', '2017-12-15', 12, 3584.8000, 0.0000, 532.2400, 4117.0400, '2017-12-08 07:17:26', 'dbo', ''),
(2017110085, 201711, 37, 85, '2017-12-08', 3120, 'ENERGY', 0, 0, '2017-12-01', '2017-11-01', '2017-12-15', 0, 0.0000, 0.0000, 0.0000, 0.0000, '2017-12-08 07:17:27', 'dbo', ''),
(2017110086, 201711, 37, 86, '2017-12-08', 3121, 'ENERGY', 65, 61, '2017-12-01', '2017-11-01', '2017-12-15', 4, 4046.2000, 0.0000, 370.7500, 4416.9500, '2017-12-08 07:17:26', 'dbo', ''),
(2017120001, 201712, 38, 1, '2018-01-25', 3122, 'ENERGY', 14016, 14016, '2018-01-06', '2017-12-01', '2018-02-01', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2018-01-25 06:45:19', 'dbo', ''),
(2017120002, 201712, 38, 2, '2018-01-25', 3123, 'ENERGY', 7081, 7081, '2018-01-06', '2017-12-01', '2018-02-01', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2018-01-25 06:45:19', 'dbo', ''),
(2017120003, 201712, 38, 3, '2018-01-25', 3124, 'ENERGY', 8948, 8948, '2018-01-06', '2017-12-01', '2018-02-01', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2018-01-25 06:45:19', 'dbo', ''),
(2017120004, 201712, 38, 4, '2018-01-25', 3125, 'ENERGY', 6711, 6711, '2018-01-06', '2017-12-01', '2018-02-01', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2018-01-25 06:45:19', 'dbo', ''),
(2017120005, 201712, 38, 5, '2018-01-25', 3126, 'ENERGY', 5255, 5255, '2018-01-06', '2017-12-01', '2018-02-01', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2018-01-25 06:45:19', 'dbo', ''),
(2017120006, 201712, 38, 6, '2018-01-25', 3127, 'ENERGY', 13833, 13833, '2018-01-06', '2017-12-01', '2018-02-01', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2018-01-25 06:45:19', 'dbo', ''),
(2017120007, 201712, 38, 7, '2018-01-25', 3128, 'ENERGY', 9652, 9652, '2018-01-06', '2017-12-01', '2018-02-01', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2018-01-25 06:45:20', 'dbo', ''),
(2017120008, 201712, 38, 8, '2018-01-25', 3129, 'ENERGY', 167, 167, '2018-01-06', '2017-12-01', '2018-02-01', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2018-01-25 06:45:20', 'dbo', ''),
(2017120009, 201712, 38, 9, '2018-01-25', 3130, 'ENERGY', 3680, 2263, '2018-01-06', '2017-12-01', '2018-02-01', 1417, 53696.6364, 0.0000, 29605.7300, 83302.3664, '2018-01-25 06:45:18', 'dbo', ''),
(2017120010, 201712, 38, 10, '2018-01-25', 3131, 'ENERGY', 517, 446, '2018-01-06', '2017-12-01', '2018-02-01', 71, 14500.0680, 0.0000, 1758.8900, 16258.9580, '2018-01-25 06:45:18', 'dbo', ''),
(2017120011, 201712, 38, 11, '2018-01-25', 3132, 'ENERGY', 201, 201, '2018-01-06', '2017-12-01', '2018-02-01', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2018-01-25 06:45:19', 'dbo', ''),
(2017120012, 201712, 38, 12, '2018-01-25', 3133, 'ENERGY', 137, 137, '2018-01-06', '2017-12-01', '2018-02-01', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2018-01-25 06:45:19', 'dbo', ''),
(2017120013, 201712, 38, 13, '2018-01-25', 3134, 'ENERGY', 9374, 8419, '2018-01-06', '2017-12-01', '2018-02-01', 955, 169855.9840, 0.0000, 20047.6000, 189903.5840, '2018-01-25 06:45:19', 'dbo', ''),
(2017120014, 201712, 38, 14, '2018-01-25', 3135, 'ENERGY', 3717, 3159, '2018-01-06', '2017-12-01', '2018-02-01', 558, 69900.7554, 0.0000, 11834.2300, 81734.9854, '2018-01-25 06:45:19', 'dbo', ''),
(2017120015, 201712, 38, 15, '2018-01-25', 3136, 'ENERGY', 162, 162, '2018-01-06', '2017-12-01', '2018-02-01', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2018-01-25 06:45:19', 'dbo', ''),
(2017120016, 201712, 38, 16, '2018-01-25', 3137, 'ENERGY', 8236, 7604, '2018-01-06', '2017-12-01', '2018-02-01', 632, 153160.2920, 0.0000, 13365.1900, 166525.4820, '2018-01-25 06:45:19', 'dbo', ''),
(2017120017, 201712, 38, 17, '2018-01-25', 3138, 'ENERGY', 21334, 19782, '2018-01-06', '2017-12-01', '2018-02-01', 1552, 379223.7170, 0.0000, 32398.6800, 411622.3970, '2018-01-25 06:45:18', 'dbo', ''),
(2017120018, 201712, 38, 18, '2018-01-25', 3139, 'ENERGY', 6166, 5843, '2018-01-06', '2017-12-01', '2018-02-01', 323, 116174.1000, 0.0000, 6972.4200, 123146.5200, '2018-01-25 06:45:18', 'dbo', ''),
(2017120019, 201712, 38, 19, '2018-01-25', 3140, 'ENERGY', 75, 75, '2018-01-06', '2017-12-01', '2018-02-01', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2018-01-25 06:45:19', 'dbo', ''),
(2017120020, 201712, 38, 20, '2018-01-25', 3141, 'ENERGY', 254, 254, '2018-01-06', '2017-12-01', '2018-02-01', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2018-01-25 06:45:19', 'dbo', ''),
(2017120021, 201712, 38, 21, '2018-01-25', 3142, 'ENERGY', 45365, 44795, '2018-01-06', '2017-12-01', '2018-02-01', 570, 606049.2746, 0.0000, 12082.4900, 618131.7646, '2018-01-25 06:45:19', 'dbo', ''),
(2017120022, 201712, 38, 22, '2018-01-25', 3143, 'ENERGY', 26617, 26261, '2018-01-06', '2017-12-01', '2018-02-01', 356, 353835.8916, 0.0000, 7655.1400, 361491.0316, '2018-01-25 06:45:19', 'dbo', ''),
(2017120023, 201712, 38, 23, '2018-01-25', 3144, 'ENERGY', 71254, 69727, '2018-01-06', '2017-12-01', '2018-02-01', 1527, 978516.2270, 0.0000, 31881.4600, 1010397.6870, '2018-01-25 06:45:19', 'dbo', ''),
(2017120024, 201712, 38, 24, '2018-01-25', 3145, 'ENERGY', 44790, 44346, '2018-01-06', '2017-12-01', '2018-02-01', 444, 556227.8300, 0.0000, 9475.7300, 565703.5600, '2018-01-25 06:45:19', 'dbo', ''),
(2017120025, 201712, 38, 25, '2018-01-25', 3146, 'ENERGY', 70217, 64302, '2018-01-06', '2017-12-01', '2018-02-01', 5915, 1218312.4300, 0.0000, 122662.9700, 1340975.4000, '2018-01-25 06:45:18', 'dbo', ''),
(2017120026, 201712, 38, 26, '2018-01-25', 3147, 'ENERGY', 63263, 61555, '2018-01-06', '2017-12-01', '2018-02-01', 1708, 1007156.4374, 0.0000, 35626.0900, 1042782.5274, '2018-01-25 06:45:18', 'dbo', ''),
(2017120029, 201712, 38, 29, '2018-01-25', 3150, 'ENERGY', 88941, 86590, '2018-01-06', '2017-12-01', '2018-02-01', 2351, 1329891.0588, 0.0000, 48928.8600, 1378819.9188, '2018-01-25 06:45:19', 'dbo', ''),
(2017120030, 201712, 38, 30, '2018-01-25', 3151, 'ENERGY', 43182, 42029, '2018-01-06', '2017-12-01', '2018-02-01', 1153, 540037.6812, 0.0000, 24143.9400, 564181.6212, '2018-01-25 06:45:19', 'dbo', ''),
(2017120031, 201712, 38, 31, '2018-01-25', 3152, 'ENERGY', 69208, 66886, '2018-01-06', '2017-12-01', '2018-02-01', 2322, 1050818.9480, 0.0000, 48328.9000, 1099147.8480, '2018-01-25 06:45:19', 'dbo', ''),
(2017120032, 201712, 38, 32, '2018-01-25', 3153, 'ENERGY', 113051, 109116, '2018-01-06', '2017-12-01', '2018-02-01', 3935, 1717506.7990, 0.0000, 81699.5800, 1799206.3790, '2018-01-25 06:45:19', 'dbo', ''),
(2017120033, 201712, 38, 33, '2018-01-25', 3154, 'ENERGY', 14550, 13929, '2018-01-06', '2017-12-01', '2018-02-01', 621, 236455.7534, 0.0000, 13137.6100, 249593.3634, '2018-01-25 06:45:18', 'dbo', ''),
(2017120034, 201712, 38, 34, '2018-01-25', 3155, 'ENERGY', 11032, 10513, '2018-01-06', '2017-12-01', '2018-02-01', 519, 186145.1242, 0.0000, 11027.3800, 197172.5042, '2018-01-25 06:45:18', 'dbo', ''),
(2017120035, 201712, 38, 35, '2018-01-25', 3156, 'ENERGY', 17500, 17156, '2018-01-06', '2017-12-01', '2018-02-01', 344, 276660.7826, 0.0000, 7406.8600, 284067.6426, '2018-01-25 06:45:18', 'dbo', ''),
(2017120036, 201712, 38, 36, '2018-01-25', 3157, 'ENERGY', 43929, 42604, '2018-01-06', '2017-12-01', '2018-02-01', 1325, 719418.6338, 0.0000, 27702.3800, 747121.0138, '2018-01-25 06:45:18', 'dbo', ''),
(2017120037, 201712, 38, 37, '2018-01-25', 3158, 'ENERGY', 22244, 21784, '2018-01-06', '2017-12-01', '2018-02-01', 460, 344109.7410, 0.0000, 9806.7500, 353916.4910, '2018-01-25 06:45:18', 'dbo', ''),
(2017120038, 201712, 38, 38, '2018-01-25', 3159, 'ENERGY', 11913, 11573, '2018-01-06', '2017-12-01', '2018-02-01', 340, 196637.9234, 0.0000, 7324.1100, 203962.0334, '2018-01-25 06:45:18', 'dbo', ''),
(2017120039, 201712, 38, 39, '2018-01-25', 3160, 'ENERGY', 27008, 26728, '2018-01-06', '2017-12-01', '2018-02-01', 280, -172002.8818, 0.0000, 6082.8000, -165920.0818, '2018-01-25 06:45:18', 'dbo', ''),
(2017120040, 201712, 38, 40, '2018-01-25', 3161, 'ENERGY', 26805, 25811, '2018-01-06', '2017-12-01', '2018-02-01', 994, 437824.5396, 0.0000, 20854.4500, 458678.9896, '2018-01-25 06:45:19', 'dbo', ''),
(2017120041, 201712, 38, 41, '2018-01-25', 3162, 'ENERGY', 241, 241, '2018-01-06', '2017-12-01', '2018-02-01', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2018-01-25 06:45:19', 'dbo', ''),
(2017120042, 201712, 38, 42, '2018-01-25', 3163, 'ENERGY', 334, 334, '2018-01-06', '2017-12-01', '2018-02-01', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2018-01-25 06:45:19', 'dbo', ''),
(2017120043, 201712, 38, 43, '2018-01-25', 3164, 'ENERGY', 69018, 66699, '2018-01-06', '2017-12-01', '2018-02-01', 2319, 935747.6902, 0.0000, 48266.8300, 984014.5202, '2018-01-25 06:45:18', 'dbo', ''),
(2017120044, 201712, 38, 44, '2018-01-25', 3165, 'ENERGY', 39215, 38524, '2018-01-06', '2017-12-01', '2018-02-01', 691, 715036.6030, 0.0000, 14585.8100, 729622.4130, '2018-01-25 06:45:18', 'dbo', ''),
(2017120045, 201712, 38, 45, '2018-01-25', 3166, 'ENERGY', 33722, 33222, '2018-01-06', '2017-12-01', '2018-02-01', 500, 342434.9520, 0.0000, 10634.3000, 353069.2520, '2018-01-25 06:45:19', 'dbo', ''),
(2017120046, 201712, 38, 46, '2018-01-25', 3167, 'ENERGY', 51082, 49848, '2018-01-06', '2017-12-01', '2018-02-01', 1234, 866600.8254, 0.0000, 25819.7100, 892420.5354, '2018-01-25 06:45:19', 'dbo', ''),
(2017120047, 201712, 38, 47, '2018-01-25', 3168, 'ENERGY', 25805, 25101, '2018-01-06', '2017-12-01', '2018-02-01', 704, 321249.6410, 0.0000, 14854.7600, 336104.4010, '2018-01-25 06:45:19', 'dbo', ''),
(2017120048, 201712, 38, 48, '2018-01-25', 3169, 'ENERGY', 13702, 12850, '2018-01-06', '2017-12-01', '2018-02-01', 852, 247801.8900, 0.0000, 17916.6800, 265718.5700, '2018-01-25 06:45:19', 'dbo', ''),
(2017120049, 201712, 38, 49, '2018-01-25', 3170, 'ENERGY', 6083, 5916, '2018-01-06', '2017-12-01', '2018-02-01', 167, 99624.2090, 0.0000, 3745.0000, 103369.2090, '2018-01-25 06:45:18', 'dbo', ''),
(2017120050, 201712, 38, 50, '2018-01-25', 3171, 'ENERGY', 85861, 83547, '2018-01-06', '2017-12-01', '2018-02-01', 2314, 1263924.0192, 0.0000, 48163.3800, 1312087.3992, '2018-01-25 06:45:18', 'dbo', ''),
(2017120051, 201712, 38, 51, '2018-01-25', 3172, 'ENERGY', 211, 211, '2018-01-06', '2017-12-01', '2018-02-01', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2018-01-25 06:45:19', 'dbo', ''),
(2017120052, 201712, 38, 52, '2018-01-25', 3173, 'ENERGY', 321, 321, '2018-01-06', '2017-12-01', '2018-02-01', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2018-01-25 06:45:19', 'dbo', ''),
(2017120053, 201712, 38, 53, '2018-01-25', 3174, 'ENERGY', 1817, 1817, '2018-01-06', '2017-12-01', '2018-02-01', 0, 41322.8070, 0.0000, 0.0000, 41322.8070, '2018-01-25 06:45:19', 'dbo', ''),
(2017120054, 201712, 38, 54, '2018-01-25', 3175, 'ENERGY', 29195, 28339, '2018-01-06', '2017-12-01', '2018-02-01', 856, 279749.6294, 0.0000, 17999.4300, 297749.0594, '2018-01-25 06:45:19', 'dbo', ''),
(2017120055, 201712, 38, 55, '2018-01-25', 3176, 'ENERGY', 12689, 12689, '2018-01-06', '2017-12-01', '2018-02-01', 0, 239408.7700, 0.0000, 0.0000, 239408.7700, '2018-01-25 06:45:19', 'dbo', ''),
(2017120056, 201712, 38, 56, '2018-01-25', 3177, 'ENERGY', 618, 266, '2018-01-06', '2017-12-01', '2018-02-01', 352, 9351.8090, 0.0000, 7572.3900, 16924.1990, '2018-01-25 06:45:19', 'dbo', ''),
(2017120059, 201712, 38, 59, '2018-01-25', 3180, 'ENERGY', 128, 128, '2018-01-06', '2017-12-01', '2018-02-01', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2018-01-25 06:45:19', 'dbo', ''),
(2017120060, 201712, 38, 60, '2018-01-25', 3181, 'ENERGY', 230677, 221458, '2018-01-06', '2017-12-01', '2018-02-01', 9219, 2824699.7600, 0.0000, 191018.0600, 3015717.8200, '2018-01-25 06:45:18', 'dbo', ''),
(2017120061, 201712, 38, 61, '2018-01-25', 3182, 'ENERGY', 16, 16, '2018-01-06', '2017-12-01', '2018-02-01', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2018-01-25 06:45:19', 'dbo', ''),
(2017120062, 201712, 38, 62, '2018-01-25', 3183, 'ENERGY', 30, 30, '2018-01-06', '2017-12-01', '2018-02-01', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-01-25 06:45:19', 'dbo', ''),
(2017120063, 201712, 38, 63, '2018-01-25', 3184, 'ENERGY', 1, 1, '2018-01-06', '2017-12-01', '2018-02-01', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-01-25 06:45:19', 'dbo', ''),
(2017120064, 201712, 38, 64, '2018-01-25', 3185, 'ENERGY', 2, 2, '2018-01-06', '2017-12-01', '2018-02-01', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-01-25 06:45:19', 'dbo', ''),
(2017120065, 201712, 38, 65, '2018-01-25', 3186, 'ENERGY', 8488, 8036, '2018-01-06', '2017-12-01', '2018-02-01', 452, 156969.7080, 0.0000, 9641.2400, 166610.9480, '2018-01-25 06:45:18', 'dbo', ''),
(2017120066, 201712, 38, 66, '2018-01-25', 3187, 'ENERGY', 6217, 6098, '2018-01-06', '2017-12-01', '2018-02-01', 119, 118374.3724, 0.0000, 2751.9400, 121126.3124, '2018-01-25 06:45:18', 'dbo', ''),
(2017120067, 201712, 38, 67, '2018-01-25', 3188, 'ENERGY', 769, 739, '2018-01-06', '2017-12-01', '2018-02-01', 30, 20452.5938, 0.0000, 910.6600, 21363.2538, '2018-01-25 06:45:19', 'dbo', ''),
(2017120068, 201712, 38, 68, '2018-01-25', 3189, 'ENERGY', 1512, 1444, '2018-01-06', '2017-12-01', '2018-02-01', 68, 34505.6700, 0.0000, 1696.8200, 36202.4900, '2018-01-25 06:45:19', 'dbo', ''),
(2017120069, 201712, 38, 69, '2018-01-25', 3190, 'ENERGY', 1, 1, '2018-01-06', '2017-12-01', '2018-02-01', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2018-01-25 06:45:19', 'dbo', ''),
(2017120070, 201712, 38, 70, '2018-01-25', 3191, 'ENERGY', 484, 401, '2018-01-06', '2017-12-01', '2018-02-01', 83, 13164.9200, 0.0000, 2007.1500, 15172.0700, '2018-01-25 06:45:19', 'dbo', ''),
(2017120071, 201712, 38, 71, '2018-01-25', 3192, 'ENERGY', 155288, 147094, '2018-01-06', '2017-12-01', '2018-02-01', 8194, 2653176.6262, 0.0000, 169812.2600, 2822988.8862, '2018-01-25 06:45:17', 'dbo', ''),
(2017120072, 201712, 38, 72, '2018-01-25', 3193, 'ENERGY', 1503, 1473, '2018-01-06', '2017-12-01', '2018-02-01', 30, 36349.1900, 0.0000, 910.6600, 37259.8500, '2018-01-25 06:45:18', 'dbo', ''),
(2017120073, 201712, 38, 73, '2018-01-25', 3194, 'ENERGY', 466, 466, '2018-01-06', '2017-12-01', '2018-02-01', 0, 23944.9380, 0.0000, 0.0000, 23944.9380, '2018-01-25 06:45:19', 'dbo', ''),
(2017120075, 201712, 38, 75, '2018-01-25', 3195, 'ENERGY', 1454, 1400, '2018-01-06', '2017-12-01', '2018-02-01', 54, 33954.9800, 0.0000, 1407.1800, 35362.1600, '2018-01-25 06:45:18', 'dbo', ''),
(2017120076, 201712, 38, 76, '2018-01-25', 3196, 'ENERGY', 1472, 1472, '2018-01-06', '2017-12-01', '2018-02-01', 0, 35220.5400, 0.0000, 0.0000, 35220.5400, '2018-01-25 06:45:19', 'dbo', ''),
(2017120077, 201712, 38, 77, '2018-01-25', 3197, 'ENERGY', 1219, 1181, '2018-01-06', '2017-12-01', '2018-02-01', 38, 29751.7500, 0.0000, 1076.1600, 30827.9100, '2018-01-25 06:45:18', 'dbo', ''),
(2017120078, 201712, 38, 78, '2018-01-25', 3198, 'ENERGY', 346, 331, '2018-01-06', '2017-12-01', '2018-02-01', 15, 13900.4000, 0.0000, 600.3300, 14500.7300, '2018-01-25 06:45:18', 'dbo', ''),
(2017120079, 201712, 38, 79, '2018-01-25', 3199, 'ENERGY', 40655, 38839, '2018-01-06', '2017-12-01', '2018-02-01', 1816, 620707.3400, 0.0000, 37860.4600, 658567.8000, '2018-01-25 06:45:18', 'dbo', ''),
(2017120080, 201712, 38, 80, '2018-01-25', 3200, 'ENERGY', 311, 311, '2018-01-06', '2017-12-01', '2018-02-01', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2018-01-25 06:45:19', 'dbo', ''),
(2017120081, 201712, 38, 81, '2018-01-25', 3201, 'ENERGY', 1440, 1374, '2018-01-06', '2017-12-01', '2018-02-01', 66, 30220.1200, 0.0000, 1655.4400, 31875.5600, '2018-01-25 06:45:18', 'dbo', ''),
(2017120082, 201712, 38, 82, '2018-01-25', 3202, 'ENERGY', 2790, 2624, '2018-01-06', '2017-12-01', '2018-02-01', 166, 54905.4300, 0.0000, 3724.3000, 58629.7300, '2018-01-25 06:45:18', 'dbo', ''),
(2017120083, 201712, 38, 83, '2018-01-25', 3203, 'ENERGY', 70, 66, '2018-01-06', '2017-12-01', '2018-02-01', 4, 4770.2500, 0.0000, 372.7500, 5143.0000, '2018-01-25 06:45:18', 'dbo', ''),
(2017120084, 201712, 38, 84, '2018-01-25', 3204, 'ENERGY', 65, 49, '2018-01-06', '2017-12-01', '2018-02-01', 16, 4117.0400, 0.0000, 621.0100, 4738.0500, '2018-01-25 06:45:18', 'dbo', ''),
(2017120085, 201712, 38, 85, '2018-01-25', 3205, 'ENERGY', 0, 0, '2018-01-06', '2017-12-01', '2018-02-01', 0, 0.0000, 0.0000, 0.0000, 0.0000, '2018-01-25 06:45:19', 'dbo', ''),
(2017120086, 201712, 38, 86, '2018-01-25', 3206, 'ENERGY', 71, 65, '2018-01-06', '2017-12-01', '2018-02-01', 6, 4416.9500, 0.0000, 414.1300, 4831.0800, '2018-01-25 06:45:18', 'dbo', ''),
(2018010001, 201801, 39, 1, '2018-02-24', 3207, 'ENERGY', 14016, 14016, '2018-02-01', '2018-01-06', '2018-03-03', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2018-02-24 08:24:58', 'dbo', ''),
(2018010002, 201801, 39, 2, '2018-02-24', 3208, 'ENERGY', 7081, 7081, '2018-02-01', '2018-01-06', '2018-03-03', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2018-02-24 08:24:58', 'dbo', ''),
(2018010003, 201801, 39, 3, '2018-02-24', 3209, 'ENERGY', 8948, 8948, '2018-02-01', '2018-01-06', '2018-03-03', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2018-02-24 08:24:58', 'dbo', ''),
(2018010004, 201801, 39, 4, '2018-02-24', 3210, 'ENERGY', 6711, 6711, '2018-02-01', '2018-01-06', '2018-03-03', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2018-02-24 08:24:58', 'dbo', ''),
(2018010005, 201801, 39, 5, '2018-02-24', 3211, 'ENERGY', 5255, 5255, '2018-02-01', '2018-01-06', '2018-03-03', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2018-02-24 08:24:58', 'dbo', ''),
(2018010006, 201801, 39, 6, '2018-02-24', 3212, 'ENERGY', 13833, 13833, '2018-02-01', '2018-01-06', '2018-03-03', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2018-02-24 08:24:58', 'dbo', ''),
(2018010007, 201801, 39, 7, '2018-02-24', 3213, 'ENERGY', 9652, 9652, '2018-02-01', '2018-01-06', '2018-03-03', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2018-02-24 08:24:58', 'dbo', ''),
(2018010008, 201801, 39, 8, '2018-02-24', 3214, 'ENERGY', 167, 167, '2018-02-01', '2018-01-06', '2018-03-03', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2018-02-24 08:24:58', 'dbo', ''),
(2018010009, 201801, 39, 9, '2018-02-24', 3215, 'ENERGY', 4642, 3680, '2018-02-01', '2018-01-06', '2018-03-03', 962, 83302.3664, 0.0000, 20186.6200, 103488.9864, '2018-02-24 08:24:57', 'dbo', ''),
(2018010010, 201801, 39, 10, '2018-02-24', 3216, 'ENERGY', 562, 517, '2018-02-01', '2018-01-06', '2018-03-03', 45, 16258.9580, 0.0000, 1220.7200, 17479.6780, '2018-02-24 08:24:57', 'dbo', ''),
(2018010011, 201801, 39, 11, '2018-02-24', 3217, 'ENERGY', 201, 201, '2018-02-01', '2018-01-06', '2018-03-03', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2018-02-24 08:24:58', 'dbo', ''),
(2018010012, 201801, 39, 12, '2018-02-24', 3218, 'ENERGY', 137, 137, '2018-02-01', '2018-01-06', '2018-03-03', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2018-02-24 08:24:58', 'dbo', ''),
(2018010013, 201801, 39, 13, '2018-02-24', 3219, 'ENERGY', 9978, 9374, '2018-02-01', '2018-01-06', '2018-03-03', 604, 189903.5840, 0.0000, 12782.2700, 202685.8540, '2018-02-24 08:24:58', 'dbo', ''),
(2018010014, 201801, 39, 14, '2018-02-24', 3220, 'ENERGY', 4134, 3717, '2018-02-01', '2018-01-06', '2018-03-03', 417, 81734.9854, 0.0000, 8914.6300, 90649.6154, '2018-02-24 08:24:58', 'dbo', ''),
(2018010015, 201801, 39, 15, '2018-02-24', 3221, 'ENERGY', 162, 162, '2018-02-01', '2018-01-06', '2018-03-03', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2018-02-24 08:24:58', 'dbo', ''),
(2018010016, 201801, 39, 16, '2018-02-24', 3222, 'ENERGY', 8728, 8236, '2018-02-01', '2018-01-06', '2018-03-03', 492, 166525.4820, 0.0000, 10465.8200, 176991.3020, '2018-02-24 08:24:58', 'dbo', ''),
(2018010017, 201801, 39, 17, '2018-02-24', 3223, 'ENERGY', 22650, 21334, '2018-02-01', '2018-01-06', '2018-03-03', 1316, 411622.3970, 0.0000, 27508.2400, 439130.6370, '2018-02-24 08:24:57', 'dbo', ''),
(2018010018, 201801, 39, 18, '2018-02-24', 3224, 'ENERGY', 6395, 6166, '2018-02-01', '2018-01-06', '2018-03-03', 229, 123146.5200, 0.0000, 5026.3000, 128172.8200, '2018-02-24 08:24:57', 'dbo', ''),
(2018010019, 201801, 39, 19, '2018-02-24', 3225, 'ENERGY', 75, 75, '2018-02-01', '2018-01-06', '2018-03-03', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2018-02-24 08:24:58', 'dbo', ''),
(2018010020, 201801, 39, 20, '2018-02-24', 3226, 'ENERGY', 254, 254, '2018-02-01', '2018-01-06', '2018-03-03', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2018-02-24 08:24:58', 'dbo', ''),
(2018010021, 201801, 39, 21, '2018-02-24', 3227, 'ENERGY', 45781, 45365, '2018-02-01', '2018-01-06', '2018-03-03', 416, 618131.7646, 0.0000, 8893.9400, 627025.7046, '2018-02-24 08:24:58', 'dbo', ''),
(2018010022, 201801, 39, 22, '2018-02-24', 3228, 'ENERGY', 26876, 26617, '2018-02-01', '2018-01-06', '2018-03-03', 259, 361491.0316, 0.0000, 5646.7800, 367137.8116, '2018-02-24 08:24:58', 'dbo', ''),
(2018010023, 201801, 39, 23, '2018-02-24', 3229, 'ENERGY', 72234, 71254, '2018-02-01', '2018-01-06', '2018-03-03', 980, 1010397.6870, 0.0000, 20558.9000, 1030956.5870, '2018-02-24 08:24:58', 'dbo', ''),
(2018010024, 201801, 39, 24, '2018-02-24', 3230, 'ENERGY', 45056, 44790, '2018-02-01', '2018-01-06', '2018-03-03', 266, 565703.5600, 0.0000, 5791.5600, 571495.1200, '2018-02-24 08:24:58', 'dbo', ''),
(2018010025, 201801, 39, 25, '2018-02-24', 3231, 'ENERGY', 74210, 70217, '2018-02-01', '2018-01-06', '2018-03-03', 3993, 1340975.4000, 0.0000, 82875.4200, 1423850.8200, '2018-02-24 08:24:57', 'dbo', ''),
(2018010026, 201801, 39, 26, '2018-02-24', 3232, 'ENERGY', 64533, 63263, '2018-02-01', '2018-01-06', '2018-03-03', 1270, 1042782.5274, 0.0000, 26556.8400, 1069339.3674, '2018-02-24 08:24:57', 'dbo', ''),
(2018010029, 201801, 39, 29, '2018-02-24', 3235, 'ENERGY', 90548, 88941, '2018-02-01', '2018-01-06', '2018-03-03', 1607, 1378819.9188, 0.0000, 33526.8600, 1412346.7788, '2018-02-24 08:24:58', 'dbo', ''),
(2018010030, 201801, 39, 30, '2018-02-24', 3236, 'ENERGY', 43967, 43182, '2018-02-01', '2018-01-06', '2018-03-03', 785, 564181.6212, 0.0000, 16525.8000, 580707.4212, '2018-02-24 08:24:58', 'dbo', ''),
(2018010031, 201801, 39, 31, '2018-02-24', 3237, 'ENERGY', 70697, 69208, '2018-02-01', '2018-01-06', '2018-03-03', 1489, 1099147.8480, 0.0000, 31086.3200, 1130234.1680, '2018-02-24 08:24:58', 'dbo', ''),
(2018010032, 201801, 39, 32, '2018-02-24', 3238, 'ENERGY', 115609, 113051, '2018-02-01', '2018-01-06', '2018-03-03', 2558, 1799206.3790, 0.0000, 53195.9600, 1852402.3390, '2018-02-24 08:24:58', 'dbo', ''),
(2018010033, 201801, 39, 33, '2018-02-24', 3239, 'ENERGY', 14909, 14550, '2018-02-01', '2018-01-06', '2018-03-03', 359, 249593.3634, 0.0000, 7715.0400, 257308.4034, '2018-02-24 08:24:57', 'dbo', ''),
(2018010034, 201801, 39, 34, '2018-02-24', 3240, 'ENERGY', 11390, 11032, '2018-02-01', '2018-01-06', '2018-03-03', 358, 197172.5042, 0.0000, 7694.3600, 204866.8642, '2018-02-24 08:24:57', 'dbo', ''),
(2018010035, 201801, 39, 35, '2018-02-24', 3241, 'ENERGY', 17744, 17500, '2018-02-01', '2018-01-06', '2018-03-03', 244, 284067.6426, 0.0000, 5336.5500, 289404.1926, '2018-02-24 08:24:57', 'dbo', ''),
(2018010036, 201801, 39, 36, '2018-02-24', 3242, 'ENERGY', 44787, 43929, '2018-02-01', '2018-01-06', '2018-03-03', 858, 747121.0138, 0.0000, 18035.6300, 765156.6438, '2018-02-24 08:24:57', 'dbo', ''),
(2018010037, 201801, 39, 37, '2018-02-24', 3243, 'ENERGY', 22571, 22244, '2018-02-01', '2018-01-06', '2018-03-03', 327, 353916.4910, 0.0000, 7053.1900, 360969.6810, '2018-02-24 08:24:57', 'dbo', ''),
(2018010038, 201801, 39, 38, '2018-02-24', 3244, 'ENERGY', 12108, 11913, '2018-02-01', '2018-01-06', '2018-03-03', 195, 203962.0334, 0.0000, 4323.1000, 208285.1334, '2018-02-24 08:24:57', 'dbo', ''),
(2018010039, 201801, 39, 39, '2018-02-24', 3245, 'ENERGY', 27290, 27008, '2018-02-01', '2018-01-06', '2018-03-03', 282, -165920.0818, 0.0000, 6122.4700, -159797.6118, '2018-02-24 08:24:57', 'dbo', '');
INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2018010040, 201801, 39, 40, '2018-02-24', 3246, 'ENERGY', 27506, 26805, '2018-02-01', '2018-01-06', '2018-03-03', 701, 458678.9896, 0.0000, 14788.4800, 473467.4696, '2018-02-24 08:24:58', 'dbo', ''),
(2018010041, 201801, 39, 41, '2018-02-24', 3247, 'ENERGY', 241, 241, '2018-02-01', '2018-01-06', '2018-03-03', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2018-02-24 08:24:58', 'dbo', ''),
(2018010042, 201801, 39, 42, '2018-02-24', 3248, 'ENERGY', 334, 334, '2018-02-01', '2018-01-06', '2018-03-03', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2018-02-24 08:24:58', 'dbo', ''),
(2018010043, 201801, 39, 43, '2018-02-24', 3249, 'ENERGY', 70755, 69018, '2018-02-01', '2018-01-06', '2018-03-03', 1737, 984014.5202, 0.0000, 36215.5900, 1020230.1102, '2018-02-24 08:24:57', 'dbo', ''),
(2018010044, 201801, 39, 44, '2018-02-24', 3250, 'ENERGY', 40002, 39215, '2018-02-01', '2018-01-06', '2018-03-03', 787, 729622.4130, 0.0000, 16567.1600, 746189.5730, '2018-02-24 08:24:57', 'dbo', ''),
(2018010045, 201801, 39, 45, '2018-02-24', 3251, 'ENERGY', 34141, 33722, '2018-02-01', '2018-01-06', '2018-03-03', 419, 353069.2520, 0.0000, 8955.9900, 362025.2420, '2018-02-24 08:24:58', 'dbo', ''),
(2018010046, 201801, 39, 46, '2018-02-24', 3252, 'ENERGY', 52087, 51082, '2018-02-01', '2018-01-06', '2018-03-03', 1005, 892420.5354, 0.0000, 21075.9600, 913496.4954, '2018-02-24 08:24:58', 'dbo', ''),
(2018010047, 201801, 39, 47, '2018-02-24', 3253, 'ENERGY', 26305, 25805, '2018-02-01', '2018-01-06', '2018-03-03', 500, 336104.4010, 0.0000, 10631.2700, 346735.6710, '2018-02-24 08:24:58', 'dbo', ''),
(2018010048, 201801, 39, 48, '2018-02-24', 3254, 'ENERGY', 14307, 13702, '2018-02-01', '2018-01-06', '2018-03-03', 605, 265718.5700, 0.0000, 12802.9400, 278521.5100, '2018-02-24 08:24:58', 'dbo', ''),
(2018010049, 201801, 39, 49, '2018-02-24', 3255, 'ENERGY', 6233, 6083, '2018-02-01', '2018-01-06', '2018-03-03', 150, 103369.2090, 0.0000, 3392.3800, 106761.5890, '2018-02-24 08:24:57', 'dbo', ''),
(2018010050, 201801, 39, 50, '2018-02-24', 3256, 'ENERGY', 87377, 85861, '2018-02-01', '2018-01-06', '2018-03-03', 1516, 1312087.3992, 0.0000, 31644.7500, 1343732.1492, '2018-02-24 08:24:57', 'dbo', ''),
(2018010051, 201801, 39, 51, '2018-02-24', 3257, 'ENERGY', 211, 211, '2018-02-01', '2018-01-06', '2018-03-03', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2018-02-24 08:24:58', 'dbo', ''),
(2018010052, 201801, 39, 52, '2018-02-24', 3258, 'ENERGY', 321, 321, '2018-02-01', '2018-01-06', '2018-03-03', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2018-02-24 08:24:58', 'dbo', ''),
(2018010053, 201801, 39, 53, '2018-02-24', 3259, 'ENERGY', 1817, 1817, '2018-02-01', '2018-01-06', '2018-03-03', 0, 41322.8070, 0.0000, 0.0000, 41322.8070, '2018-02-24 08:24:58', 'dbo', ''),
(2018010054, 201801, 39, 54, '2018-02-24', 3260, 'ENERGY', 29843, 29195, '2018-02-01', '2018-01-06', '2018-03-03', 648, 297749.0594, 0.0000, 13692.2900, 311441.3494, '2018-02-24 08:24:58', 'dbo', ''),
(2018010055, 201801, 39, 55, '2018-02-24', 3261, 'ENERGY', 12689, 12689, '2018-02-01', '2018-01-06', '2018-03-03', 0, 239408.7700, 0.0000, 0.0000, 239408.7700, '2018-02-24 08:24:58', 'dbo', ''),
(2018010056, 201801, 39, 56, '2018-02-24', 3262, 'ENERGY', 620, 618, '2018-02-01', '2018-01-06', '2018-03-03', 2, 16924.1990, 0.0000, 331.3700, 17255.5690, '2018-02-24 08:24:58', 'dbo', ''),
(2018010059, 201801, 39, 59, '2018-02-24', 3265, 'ENERGY', 128, 128, '2018-02-01', '2018-01-06', '2018-03-03', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2018-02-24 08:24:58', 'dbo', ''),
(2018010060, 201801, 39, 60, '2018-02-24', 3266, 'ENERGY', 236538, 230677, '2018-02-01', '2018-01-06', '2018-03-03', 5861, 3015717.8200, 0.0000, 121510.4300, 3137228.2500, '2018-02-24 08:24:57', 'dbo', ''),
(2018010061, 201801, 39, 61, '2018-02-24', 3267, 'ENERGY', 16, 16, '2018-02-01', '2018-01-06', '2018-03-03', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2018-02-24 08:24:58', 'dbo', ''),
(2018010062, 201801, 39, 62, '2018-02-24', 3268, 'ENERGY', 30, 30, '2018-02-01', '2018-01-06', '2018-03-03', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-02-24 08:24:58', 'dbo', ''),
(2018010063, 201801, 39, 63, '2018-02-24', 3269, 'ENERGY', 1, 1, '2018-02-01', '2018-01-06', '2018-03-03', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-02-24 08:24:58', 'dbo', ''),
(2018010064, 201801, 39, 64, '2018-02-24', 3270, 'ENERGY', 2, 2, '2018-02-01', '2018-01-06', '2018-03-03', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-02-24 08:24:58', 'dbo', ''),
(2018010065, 201801, 39, 65, '2018-02-24', 3271, 'ENERGY', 8826, 8488, '2018-02-01', '2018-01-06', '2018-03-03', 338, 166610.9480, 0.0000, 7280.7000, 173891.6480, '2018-02-24 08:24:57', 'dbo', ''),
(2018010066, 201801, 39, 66, '2018-02-24', 3272, 'ENERGY', 6223, 6217, '2018-02-01', '2018-01-06', '2018-03-03', 6, 121126.3124, 0.0000, 414.1000, 121540.4124, '2018-02-24 08:24:57', 'dbo', ''),
(2018010067, 201801, 39, 67, '2018-02-24', 3273, 'ENERGY', 799, 769, '2018-02-01', '2018-01-06', '2018-03-03', 30, 21363.2538, 0.0000, 910.4800, 22273.7338, '2018-02-24 08:24:58', 'dbo', ''),
(2018010068, 201801, 39, 68, '2018-02-24', 3274, 'ENERGY', 1593, 1512, '2018-02-01', '2018-01-06', '2018-03-03', 81, 36202.4900, 0.0000, 1965.2800, 38167.7700, '2018-02-24 08:24:58', 'dbo', ''),
(2018010069, 201801, 39, 69, '2018-02-24', 3275, 'ENERGY', 1, 1, '2018-02-01', '2018-01-06', '2018-03-03', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2018-02-24 08:24:58', 'dbo', ''),
(2018010070, 201801, 39, 70, '2018-02-24', 3276, 'ENERGY', 623, 484, '2018-02-01', '2018-01-06', '2018-03-03', 139, 15172.0700, 0.0000, 3164.8800, 18336.9500, '2018-02-24 08:24:58', 'dbo', ''),
(2018010071, 201801, 39, 71, '2018-02-24', 3277, 'ENERGY', 162410, 155288, '2018-02-01', '2018-01-06', '2018-03-03', 7122, 2822988.8862, 0.0000, 147591.1300, 2970580.0162, '2018-02-24 08:24:57', 'dbo', ''),
(2018010072, 201801, 39, 72, '2018-02-24', 3278, 'ENERGY', 1527, 1503, '2018-02-01', '2018-01-06', '2018-03-03', 24, 37259.8500, 0.0000, 786.3800, 38046.2300, '2018-02-24 08:24:57', 'dbo', ''),
(2018010073, 201801, 39, 73, '2018-02-24', 3279, 'ENERGY', 467, 466, '2018-02-01', '2018-01-06', '2018-03-03', 1, 23944.9380, 0.0000, 310.6800, 24255.6180, '2018-02-24 08:24:57', 'dbo', ''),
(2018010075, 201801, 39, 75, '2018-02-24', 3280, 'ENERGY', 1489, 1454, '2018-02-01', '2018-01-06', '2018-03-03', 35, 35362.1600, 0.0000, 1013.8900, 36376.0500, '2018-02-24 08:24:57', 'dbo', ''),
(2018010076, 201801, 39, 76, '2018-02-24', 3281, 'ENERGY', 1557, 1472, '2018-02-01', '2018-01-06', '2018-03-03', 85, 35220.5400, 0.0000, 2048.0200, 37268.5600, '2018-02-24 08:24:57', 'dbo', ''),
(2018010077, 201801, 39, 77, '2018-02-24', 3282, 'ENERGY', 1243, 1219, '2018-02-01', '2018-01-06', '2018-03-03', 24, 30827.9100, 0.0000, 786.3800, 31614.2900, '2018-02-24 08:24:57', 'dbo', ''),
(2018010078, 201801, 39, 78, '2018-02-24', 3283, 'ENERGY', 346, 346, '2018-02-01', '2018-01-06', '2018-03-03', 0, 14500.7300, 0.0000, 0.0000, 14500.7300, '2018-02-24 08:24:58', 'dbo', ''),
(2018010079, 201801, 39, 79, '2018-02-24', 3284, 'ENERGY', 41814, 40655, '2018-02-01', '2018-01-06', '2018-03-03', 1159, 658567.8000, 0.0000, 24261.0800, 682828.8800, '2018-02-24 08:24:57', 'dbo', ''),
(2018010080, 201801, 39, 80, '2018-02-24', 3285, 'ENERGY', 311, 311, '2018-02-01', '2018-01-06', '2018-03-03', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2018-02-24 08:24:58', 'dbo', ''),
(2018010081, 201801, 39, 81, '2018-02-24', 3286, 'ENERGY', 1483, 1440, '2018-02-01', '2018-01-06', '2018-03-03', 43, 31875.5600, 0.0000, 1179.3400, 33054.9000, '2018-02-24 08:24:57', 'dbo', ''),
(2018010082, 201801, 39, 82, '2018-02-24', 3287, 'ENERGY', 2895, 2790, '2018-02-01', '2018-01-06', '2018-03-03', 105, 58629.7300, 0.0000, 2461.6600, 61091.3900, '2018-02-24 08:24:57', 'dbo', ''),
(2018010083, 201801, 39, 83, '2018-02-24', 3288, 'ENERGY', 72, 70, '2018-02-01', '2018-01-06', '2018-03-03', 2, 5143.0000, 0.0000, 331.3700, 5474.3700, '2018-02-24 08:24:57', 'dbo', ''),
(2018010084, 201801, 39, 84, '2018-02-24', 3289, 'ENERGY', 75, 65, '2018-02-01', '2018-01-06', '2018-03-03', 10, 4738.0500, 0.0000, 496.8300, 5234.8800, '2018-02-24 08:24:57', 'dbo', ''),
(2018010085, 201801, 39, 85, '2018-02-24', 3290, 'ENERGY', 355, 0, '2018-02-01', '2018-01-06', '2018-03-03', 355, 0.0000, 0.0000, 7632.3100, 7632.3100, '2018-02-24 08:24:57', 'dbo', ''),
(2018010086, 201801, 39, 86, '2018-02-24', 3291, 'ENERGY', 74, 71, '2018-02-01', '2018-01-06', '2018-03-03', 3, 4831.0800, 0.0000, 352.0500, 5183.1300, '2018-02-24 08:24:57', 'dbo', ''),
(2018020001, 201802, 40, 1, '2018-04-24', 3292, 'ENERGY', 14016, 14016, '2018-03-01', '2018-02-01', '2018-05-01', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2018-04-24 11:49:35', 'dbo', ''),
(2018020002, 201802, 40, 2, '2018-04-24', 3293, 'ENERGY', 7081, 7081, '2018-03-01', '2018-02-01', '2018-05-01', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2018-04-24 11:49:35', 'dbo', ''),
(2018020003, 201802, 40, 3, '2018-04-24', 3294, 'ENERGY', 8948, 8948, '2018-03-01', '2018-02-01', '2018-05-01', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2018-04-24 11:49:35', 'dbo', ''),
(2018020004, 201802, 40, 4, '2018-04-24', 3295, 'ENERGY', 6711, 6711, '2018-03-01', '2018-02-01', '2018-05-01', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2018-04-24 11:49:35', 'dbo', ''),
(2018020005, 201802, 40, 5, '2018-04-24', 3296, 'ENERGY', 5255, 5255, '2018-03-01', '2018-02-01', '2018-05-01', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2018-04-24 11:49:35', 'dbo', ''),
(2018020006, 201802, 40, 6, '2018-04-24', 3297, 'ENERGY', 13833, 13833, '2018-03-01', '2018-02-01', '2018-05-01', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2018-04-24 11:49:35', 'dbo', ''),
(2018020007, 201802, 40, 7, '2018-04-24', 3298, 'ENERGY', 9652, 9652, '2018-03-01', '2018-02-01', '2018-05-01', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2018-04-24 11:49:35', 'dbo', ''),
(2018020008, 201802, 40, 8, '2018-04-24', 3299, 'ENERGY', 167, 167, '2018-03-01', '2018-02-01', '2018-05-01', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2018-04-24 11:49:35', 'dbo', ''),
(2018020009, 201802, 40, 9, '2018-04-24', 3300, 'ENERGY', 5662, 4642, '2018-03-01', '2018-02-01', '2018-05-01', 1020, 103488.9864, 0.0000, 21681.1300, 125170.1164, '2018-04-24 11:49:34', 'dbo', ''),
(2018020010, 201802, 40, 10, '2018-04-24', 3301, 'ENERGY', 611, 562, '2018-03-01', '2018-02-01', '2018-05-01', 49, 17479.6780, 0.0000, 1317.6200, 18797.2980, '2018-04-24 11:49:34', 'dbo', ''),
(2018020011, 201802, 40, 11, '2018-04-24', 3302, 'ENERGY', 201, 201, '2018-03-01', '2018-02-01', '2018-05-01', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2018-04-24 11:49:35', 'dbo', ''),
(2018020012, 201802, 40, 12, '2018-04-24', 3303, 'ENERGY', 137, 137, '2018-03-01', '2018-02-01', '2018-05-01', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2018-04-24 11:49:35', 'dbo', ''),
(2018020013, 201802, 40, 13, '2018-04-24', 3304, 'ENERGY', 10726, 9978, '2018-03-01', '2018-02-01', '2018-05-01', 748, 202685.8540, 0.0000, 15976.8200, 218662.6740, '2018-04-24 11:49:34', 'dbo', ''),
(2018020014, 201802, 40, 14, '2018-04-24', 3305, 'ENERGY', 4620, 4134, '2018-03-01', '2018-02-01', '2018-05-01', 486, 90649.6154, 0.0000, 10482.2400, 101131.8554, '2018-04-24 11:49:34', 'dbo', ''),
(2018020015, 201802, 40, 15, '2018-04-24', 3306, 'ENERGY', 162, 162, '2018-03-01', '2018-02-01', '2018-05-01', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2018-04-24 11:49:35', 'dbo', ''),
(2018020016, 201802, 40, 16, '2018-04-24', 3307, 'ENERGY', 9217, 8728, '2018-03-01', '2018-02-01', '2018-05-01', 489, 176991.3020, 0.0000, 10545.1500, 187536.4520, '2018-04-24 11:49:34', 'dbo', ''),
(2018020017, 201802, 40, 17, '2018-04-24', 3308, 'ENERGY', 24258, 22650, '2018-03-01', '2018-02-01', '2018-05-01', 1608, 439130.6370, 0.0000, 34012.4800, 473143.1170, '2018-04-24 11:49:34', 'dbo', ''),
(2018020018, 201802, 40, 18, '2018-04-24', 3309, 'ENERGY', 6807, 6395, '2018-03-01', '2018-02-01', '2018-05-01', 412, 128172.8200, 0.0000, 8930.3400, 137103.1600, '2018-04-24 11:49:34', 'dbo', ''),
(2018020019, 201802, 40, 19, '2018-04-24', 3310, 'ENERGY', 75, 75, '2018-03-01', '2018-02-01', '2018-05-01', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2018-04-24 11:49:35', 'dbo', ''),
(2018020020, 201802, 40, 20, '2018-04-24', 3311, 'ENERGY', 254, 254, '2018-03-01', '2018-02-01', '2018-05-01', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2018-04-24 11:49:35', 'dbo', ''),
(2018020021, 201802, 40, 21, '2018-04-24', 3312, 'ENERGY', 46286, 45781, '2018-03-01', '2018-02-01', '2018-05-01', 505, 627025.7046, 0.0000, 10880.7000, 637906.4046, '2018-04-24 11:49:34', 'dbo', ''),
(2018020022, 201802, 40, 22, '2018-04-24', 3313, 'ENERGY', 27184, 26876, '2018-03-01', '2018-02-01', '2018-05-01', 308, 367137.8116, 0.0000, 6749.2900, 373887.1016, '2018-04-24 11:49:34', 'dbo', ''),
(2018020023, 201802, 40, 23, '2018-04-24', 3314, 'ENERGY', 73640, 72234, '2018-03-01', '2018-02-01', '2018-05-01', 1406, 1030956.5870, 0.0000, 29776.2000, 1060732.7870, '2018-04-24 11:49:34', 'dbo', ''),
(2018020024, 201802, 40, 24, '2018-04-24', 3315, 'ENERGY', 45408, 45056, '2018-03-01', '2018-02-01', '2018-05-01', 352, 571495.1200, 0.0000, 7672.0300, 579167.1500, '2018-04-24 11:49:34', 'dbo', ''),
(2018020025, 201802, 40, 25, '2018-04-24', 3316, 'ENERGY', 78655, 74210, '2018-03-01', '2018-02-01', '2018-05-01', 4445, 1423850.8200, 0.0000, 93509.1700, 1517359.9900, '2018-04-24 11:49:34', 'dbo', ''),
(2018020026, 201802, 40, 26, '2018-04-24', 3317, 'ENERGY', 65963, 64533, '2018-03-01', '2018-02-01', '2018-05-01', 1430, 1069339.3674, 0.0000, 30279.5200, 1099618.8874, '2018-04-24 11:49:34', 'dbo', ''),
(2018020029, 201802, 40, 29, '2018-04-24', 3320, 'ENERGY', 92438, 90548, '2018-03-01', '2018-02-01', '2018-05-01', 1890, 1412346.7788, 0.0000, 39926.5000, 1452273.2788, '2018-04-24 11:49:34', 'dbo', ''),
(2018020030, 201802, 40, 30, '2018-04-24', 3321, 'ENERGY', 44928, 43967, '2018-03-01', '2018-02-01', '2018-05-01', 961, 580707.4212, 0.0000, 20443.7900, 601151.2112, '2018-04-24 11:49:34', 'dbo', ''),
(2018020031, 201802, 40, 31, '2018-04-24', 3322, 'ENERGY', 72476, 70697, '2018-03-01', '2018-02-01', '2018-05-01', 1779, 1130234.1680, 0.0000, 37598.6400, 1167832.8080, '2018-04-24 11:49:34', 'dbo', ''),
(2018020032, 201802, 40, 32, '2018-04-24', 3323, 'ENERGY', 118511, 115609, '2018-03-01', '2018-02-01', '2018-05-01', 2902, 1852402.3390, 0.0000, 61149.8500, 1913552.1890, '2018-04-24 11:49:34', 'dbo', ''),
(2018020033, 201802, 40, 33, '2018-04-24', 3324, 'ENERGY', 15324, 14909, '2018-03-01', '2018-02-01', '2018-05-01', 415, 257308.4034, 0.0000, 8993.2600, 266301.6634, '2018-04-24 11:49:34', 'dbo', ''),
(2018020034, 201802, 40, 34, '2018-04-24', 3325, 'ENERGY', 11793, 11390, '2018-03-01', '2018-02-01', '2018-05-01', 403, 204866.8642, 0.0000, 8741.5900, 213608.4542, '2018-04-24 11:49:34', 'dbo', ''),
(2018020035, 201802, 40, 35, '2018-04-24', 3326, 'ENERGY', 17952, 17744, '2018-03-01', '2018-02-01', '2018-05-01', 208, 289404.1926, 0.0000, 4652.1200, 294056.3126, '2018-04-24 11:49:34', 'dbo', ''),
(2018020036, 201802, 40, 36, '2018-04-24', 3327, 'ENERGY', 45991, 44787, '2018-03-01', '2018-02-01', '2018-05-01', 1204, 765156.6438, 0.0000, 25539.9200, 790696.5638, '2018-04-24 11:49:34', 'dbo', ''),
(2018020037, 201802, 40, 37, '2018-04-24', 3328, 'ENERGY', 22966, 22571, '2018-03-01', '2018-02-01', '2018-05-01', 395, 360969.6810, 0.0000, 8573.8300, 369543.5110, '2018-04-24 11:49:34', 'dbo', ''),
(2018020038, 201802, 40, 38, '2018-04-24', 3329, 'ENERGY', 12332, 12108, '2018-03-01', '2018-02-01', '2018-05-01', 224, 208285.1334, 0.0000, 4987.6600, 213272.7934, '2018-04-24 11:49:34', 'dbo', ''),
(2018020039, 201802, 40, 39, '2018-04-24', 3330, 'ENERGY', 27961, 27290, '2018-03-01', '2018-02-01', '2018-05-01', 671, -159797.6118, 0.0000, 14362.0000, -145435.6118, '2018-04-24 11:49:34', 'dbo', ''),
(2018020040, 201802, 40, 40, '2018-04-24', 3331, 'ENERGY', 28400, 27506, '2018-03-01', '2018-02-01', '2018-05-01', 894, 473467.4696, 0.0000, 19038.6900, 492506.1596, '2018-04-24 11:49:34', 'dbo', ''),
(2018020041, 201802, 40, 41, '2018-04-24', 3332, 'ENERGY', 241, 241, '2018-03-01', '2018-02-01', '2018-05-01', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2018-04-24 11:49:35', 'dbo', ''),
(2018020042, 201802, 40, 42, '2018-04-24', 3333, 'ENERGY', 334, 334, '2018-03-01', '2018-02-01', '2018-05-01', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2018-04-24 11:49:35', 'dbo', ''),
(2018020043, 201802, 40, 43, '2018-04-24', 3334, 'ENERGY', 72838, 70755, '2018-03-01', '2018-02-01', '2018-05-01', 2083, 1020230.1102, 0.0000, 43974.0300, 1064204.1402, '2018-04-24 11:49:34', 'dbo', ''),
(2018020044, 201802, 40, 44, '2018-04-24', 3335, 'ENERGY', 41137, 40002, '2018-03-01', '2018-02-01', '2018-05-01', 1135, 746189.5730, 0.0000, 24092.8700, 770282.4430, '2018-04-24 11:49:34', 'dbo', ''),
(2018020045, 201802, 40, 45, '2018-04-24', 3336, 'ENERGY', 34608, 34141, '2018-03-01', '2018-02-01', '2018-05-01', 467, 362025.2420, 0.0000, 10083.7800, 372109.0220, '2018-04-24 11:49:34', 'dbo', ''),
(2018020046, 201802, 40, 46, '2018-04-24', 3337, 'ENERGY', 53333, 52087, '2018-03-01', '2018-02-01', '2018-05-01', 1246, 913496.4954, 0.0000, 26420.7200, 939917.2154, '2018-04-24 11:49:34', 'dbo', ''),
(2018020047, 201802, 40, 47, '2018-04-24', 3338, 'ENERGY', 26924, 26305, '2018-03-01', '2018-02-01', '2018-05-01', 619, 346735.6710, 0.0000, 13271.4700, 360007.1410, '2018-04-24 11:49:34', 'dbo', ''),
(2018020048, 201802, 40, 48, '2018-04-24', 3339, 'ENERGY', 15008, 14307, '2018-03-01', '2018-02-01', '2018-05-01', 701, 278521.5100, 0.0000, 14991.1600, 293512.6700, '2018-04-24 11:49:34', 'dbo', ''),
(2018020049, 201802, 40, 49, '2018-04-24', 3340, 'ENERGY', 6406, 6233, '2018-03-01', '2018-02-01', '2018-05-01', 173, 106761.5890, 0.0000, 3918.1000, 110679.6890, '2018-04-24 11:49:34', 'dbo', ''),
(2018020050, 201802, 40, 50, '2018-04-24', 3341, 'ENERGY', 89158, 87377, '2018-03-01', '2018-02-01', '2018-05-01', 1781, 1343732.1492, 0.0000, 37640.5900, 1381372.7392, '2018-04-24 11:49:34', 'dbo', ''),
(2018020051, 201802, 40, 51, '2018-04-24', 3342, 'ENERGY', 211, 211, '2018-03-01', '2018-02-01', '2018-05-01', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2018-04-24 11:49:35', 'dbo', ''),
(2018020052, 201802, 40, 52, '2018-04-24', 3343, 'ENERGY', 321, 321, '2018-03-01', '2018-02-01', '2018-05-01', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2018-04-24 11:49:35', 'dbo', ''),
(2018020053, 201802, 40, 53, '2018-04-24', 3344, 'ENERGY', 1953, 1817, '2018-03-01', '2018-02-01', '2018-05-01', 136, 41322.8070, 0.0000, 3142.1500, 44464.9570, '2018-04-24 11:49:34', 'dbo', ''),
(2018020054, 201802, 40, 54, '2018-04-24', 3345, 'ENERGY', 31461, 29843, '2018-03-01', '2018-02-01', '2018-05-01', 1618, 311441.3494, 0.0000, 34222.1900, 345663.5394, '2018-04-24 11:49:34', 'dbo', ''),
(2018020055, 201802, 40, 55, '2018-04-24', 3346, 'ENERGY', 12689, 12689, '2018-03-01', '2018-02-01', '2018-05-01', 0, 239408.7700, 0.0000, 0.0000, 239408.7700, '2018-04-24 11:49:35', 'dbo', ''),
(2018020056, 201802, 40, 56, '2018-04-24', 3347, 'ENERGY', 629, 620, '2018-03-01', '2018-02-01', '2018-05-01', 9, 17255.5690, 0.0000, 478.7500, 17734.3190, '2018-04-24 11:49:34', 'dbo', ''),
(2018020059, 201802, 40, 59, '2018-04-24', 3350, 'ENERGY', 128, 128, '2018-03-01', '2018-02-01', '2018-05-01', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2018-04-24 11:49:35', 'dbo', ''),
(2018020060, 201802, 40, 60, '2018-04-24', 3351, 'ENERGY', 243188, 236538, '2018-03-01', '2018-02-01', '2018-05-01', 6650, 3137228.2500, 0.0000, 139751.7500, 3276980.0000, '2018-04-24 11:49:34', 'dbo', ''),
(2018020061, 201802, 40, 61, '2018-04-24', 3352, 'ENERGY', 16, 16, '2018-03-01', '2018-02-01', '2018-05-01', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2018-04-24 11:49:35', 'dbo', ''),
(2018020062, 201802, 40, 62, '2018-04-24', 3353, 'ENERGY', 30, 30, '2018-03-01', '2018-02-01', '2018-05-01', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-04-24 11:49:35', 'dbo', ''),
(2018020063, 201802, 40, 63, '2018-04-24', 3354, 'ENERGY', 1, 1, '2018-03-01', '2018-02-01', '2018-05-01', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-04-24 11:49:35', 'dbo', ''),
(2018020064, 201802, 40, 64, '2018-04-24', 3355, 'ENERGY', 2, 2, '2018-03-01', '2018-02-01', '2018-05-01', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-04-24 11:49:35', 'dbo', ''),
(2018020065, 201802, 40, 65, '2018-04-24', 3356, 'ENERGY', 9226, 8826, '2018-03-01', '2018-02-01', '2018-05-01', 400, 173891.6480, 0.0000, 8678.6800, 182570.3280, '2018-04-24 11:49:34', 'dbo', ''),
(2018020066, 201802, 40, 66, '2018-04-24', 3357, 'ENERGY', 6240, 6223, '2018-03-01', '2018-02-01', '2018-05-01', 17, 121540.4124, 0.0000, 646.5100, 122186.9224, '2018-04-24 11:49:34', 'dbo', ''),
(2018020067, 201802, 40, 67, '2018-04-24', 3358, 'ENERGY', 830, 799, '2018-03-01', '2018-02-01', '2018-05-01', 31, 22273.7338, 0.0000, 940.1300, 23213.8638, '2018-04-24 11:49:34', 'dbo', ''),
(2018020068, 201802, 40, 68, '2018-04-24', 3359, 'ENERGY', 1717, 1593, '2018-03-01', '2018-02-01', '2018-05-01', 124, 38167.7700, 0.0000, 2890.4900, 41058.2600, '2018-04-24 11:49:34', 'dbo', ''),
(2018020069, 201802, 40, 69, '2018-04-24', 3360, 'ENERGY', 1, 1, '2018-03-01', '2018-02-01', '2018-05-01', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2018-04-24 11:49:35', 'dbo', ''),
(2018020070, 201802, 40, 70, '2018-04-24', 3361, 'ENERGY', 799, 623, '2018-03-01', '2018-02-01', '2018-05-01', 176, 18336.9500, 0.0000, 3981.0100, 22317.9600, '2018-04-24 11:49:34', 'dbo', ''),
(2018020071, 201802, 40, 71, '2018-04-24', 3362, 'ENERGY', 170811, 162410, '2018-03-01', '2018-02-01', '2018-05-01', 8401, 2970580.0162, 0.0000, 176473.1700, 3147053.1862, '2018-04-24 11:49:34', 'dbo', ''),
(2018020072, 201802, 40, 72, '2018-04-24', 3363, 'ENERGY', 1549, 1527, '2018-03-01', '2018-02-01', '2018-05-01', 22, 38046.2300, 0.0000, 751.3800, 38797.6100, '2018-04-24 11:49:34', 'dbo', ''),
(2018020073, 201802, 40, 73, '2018-04-24', 3364, 'ENERGY', 468, 467, '2018-03-01', '2018-02-01', '2018-05-01', 1, 24255.6180, 0.0000, 310.9600, 24566.5780, '2018-04-24 11:49:34', 'dbo', ''),
(2018020075, 201802, 40, 75, '2018-04-24', 3365, 'ENERGY', 1528, 1489, '2018-03-01', '2018-02-01', '2018-05-01', 39, 36376.0500, 0.0000, 1107.8900, 37483.9400, '2018-04-24 11:49:34', 'dbo', ''),
(2018020076, 201802, 40, 76, '2018-04-24', 3366, 'ENERGY', 1594, 1557, '2018-03-01', '2018-02-01', '2018-05-01', 37, 37268.5600, 0.0000, 1065.9500, 38334.5100, '2018-04-24 11:49:34', 'dbo', ''),
(2018020077, 201802, 40, 77, '2018-04-24', 3367, 'ENERGY', 1271, 1243, '2018-03-01', '2018-02-01', '2018-05-01', 28, 31614.2900, 0.0000, 877.2100, 32491.5000, '2018-04-24 11:49:34', 'dbo', ''),
(2018020078, 201802, 40, 78, '2018-04-24', 3368, 'ENERGY', 366, 346, '2018-03-01', '2018-02-01', '2018-05-01', 20, 14500.7300, 0.0000, 709.4300, 15210.1600, '2018-04-24 11:49:34', 'dbo', ''),
(2018020079, 201802, 40, 79, '2018-04-24', 3369, 'ENERGY', 43149, 41814, '2018-03-01', '2018-02-01', '2018-05-01', 1335, 682828.8800, 0.0000, 28287.2000, 711116.0800, '2018-04-24 11:49:34', 'dbo', ''),
(2018020080, 201802, 40, 80, '2018-04-24', 3370, 'ENERGY', 311, 311, '2018-03-01', '2018-02-01', '2018-05-01', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2018-04-24 11:49:35', 'dbo', ''),
(2018020081, 201802, 40, 81, '2018-04-24', 3371, 'ENERGY', 1531, 1483, '2018-03-01', '2018-02-01', '2018-05-01', 48, 33054.9000, 0.0000, 1296.6400, 34351.5400, '2018-04-24 11:49:34', 'dbo', ''),
(2018020082, 201802, 40, 82, '2018-04-24', 3372, 'ENERGY', 3014, 2895, '2018-03-01', '2018-02-01', '2018-05-01', 119, 61091.3900, 0.0000, 2785.6300, 63877.0200, '2018-04-24 11:49:34', 'dbo', ''),
(2018020083, 201802, 40, 83, '2018-04-24', 3373, 'ENERGY', 76, 72, '2018-03-01', '2018-02-01', '2018-05-01', 4, 5474.3700, 0.0000, 373.8900, 5848.2600, '2018-04-24 11:49:34', 'dbo', ''),
(2018020084, 201802, 40, 84, '2018-04-24', 3374, 'ENERGY', 87, 75, '2018-03-01', '2018-02-01', '2018-05-01', 12, 5234.8800, 0.0000, 541.6600, 5776.5400, '2018-04-24 11:49:34', 'dbo', ''),
(2018020085, 201802, 40, 85, '2018-04-24', 3375, 'ENERGY', 355, 355, '2018-03-01', '2018-02-01', '2018-05-01', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2018-04-24 11:49:35', 'dbo', ''),
(2018020086, 201802, 40, 86, '2018-04-24', 3376, 'ENERGY', 78, 74, '2018-03-01', '2018-02-01', '2018-05-01', 4, 5183.1300, 0.0000, 373.8900, 5557.0200, '2018-04-24 11:49:34', 'dbo', ''),
(2018030001, 201803, 41, 1, '2018-04-24', 3377, 'ENERGY', 14016, 14016, '2018-04-01', '2018-03-01', '2018-05-01', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2018-04-24 17:04:08', 'dbo', ''),
(2018030002, 201803, 41, 2, '2018-04-24', 3378, 'ENERGY', 7081, 7081, '2018-04-01', '2018-03-01', '2018-05-01', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2018-04-24 17:04:08', 'dbo', ''),
(2018030003, 201803, 41, 3, '2018-04-24', 3379, 'ENERGY', 8948, 8948, '2018-04-01', '2018-03-01', '2018-05-01', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2018-04-24 17:04:08', 'dbo', ''),
(2018030004, 201803, 41, 4, '2018-04-24', 3380, 'ENERGY', 6711, 6711, '2018-04-01', '2018-03-01', '2018-05-01', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2018-04-24 17:04:08', 'dbo', ''),
(2018030005, 201803, 41, 5, '2018-04-24', 3381, 'ENERGY', 5255, 5255, '2018-04-01', '2018-03-01', '2018-05-01', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2018-04-24 17:04:08', 'dbo', ''),
(2018030006, 201803, 41, 6, '2018-04-24', 3382, 'ENERGY', 13833, 13833, '2018-04-01', '2018-03-01', '2018-05-01', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2018-04-24 17:04:08', 'dbo', ''),
(2018030007, 201803, 41, 7, '2018-04-24', 3383, 'ENERGY', 9652, 9652, '2018-04-01', '2018-03-01', '2018-05-01', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2018-04-24 17:04:08', 'dbo', ''),
(2018030008, 201803, 41, 8, '2018-04-24', 3384, 'ENERGY', 167, 167, '2018-04-01', '2018-03-01', '2018-05-01', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2018-04-24 17:04:08', 'dbo', ''),
(2018030009, 201803, 41, 9, '2018-04-24', 3385, 'ENERGY', 6787, 5662, '2018-04-01', '2018-03-01', '2018-05-01', 1125, 125170.1164, 0.0000, 24271.2400, 149441.3564, '2018-04-24 17:04:07', 'dbo', ''),
(2018030010, 201803, 41, 10, '2018-04-24', 3386, 'ENERGY', 650, 611, '2018-04-01', '2018-03-01', '2018-05-01', 39, 18797.2980, 0.0000, 1121.3500, 19918.6480, '2018-04-24 17:04:07', 'dbo', ''),
(2018030011, 201803, 41, 11, '2018-04-24', 3387, 'ENERGY', 201, 201, '2018-04-01', '2018-03-01', '2018-05-01', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2018-04-24 17:04:08', 'dbo', ''),
(2018030012, 201803, 41, 12, '2018-04-24', 3388, 'ENERGY', 137, 137, '2018-04-01', '2018-03-01', '2018-05-01', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2018-04-24 17:04:08', 'dbo', ''),
(2018030013, 201803, 41, 13, '2018-04-24', 3389, 'ENERGY', 11507, 10726, '2018-04-01', '2018-03-01', '2018-05-01', 781, 218662.6740, 0.0000, 16938.3200, 235600.9940, '2018-04-24 17:04:08', 'dbo', ''),
(2018030014, 201803, 41, 14, '2018-04-24', 3390, 'ENERGY', 5021, 4620, '2018-04-01', '2018-03-01', '2018-05-01', 401, 101131.8554, 0.0000, 8837.9800, 109969.8354, '2018-04-24 17:04:08', 'dbo', ''),
(2018030015, 201803, 41, 15, '2018-04-24', 3391, 'ENERGY', 162, 162, '2018-04-01', '2018-03-01', '2018-05-01', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2018-04-24 17:04:08', 'dbo', ''),
(2018030016, 201803, 41, 16, '2018-04-24', 3392, 'ENERGY', 9653, 9217, '2018-04-01', '2018-03-01', '2018-05-01', 436, 187536.4520, 0.0000, 9584.0700, 197120.5220, '2018-04-24 17:04:08', 'dbo', ''),
(2018030017, 201803, 41, 17, '2018-04-24', 3393, 'ENERGY', 25700, 24258, '2018-04-01', '2018-03-01', '2018-05-01', 1442, 473143.1170, 0.0000, 31028.6100, 504171.7270, '2018-04-24 17:04:07', 'dbo', ''),
(2018030018, 201803, 41, 18, '2018-04-24', 3394, 'ENERGY', 7149, 6807, '2018-04-01', '2018-03-01', '2018-05-01', 342, 137103.1600, 0.0000, 7580.2800, 144683.4400, '2018-04-24 17:04:07', 'dbo', ''),
(2018030019, 201803, 41, 19, '2018-04-24', 3395, 'ENERGY', 75, 75, '2018-04-01', '2018-03-01', '2018-05-01', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2018-04-24 17:04:08', 'dbo', ''),
(2018030020, 201803, 41, 20, '2018-04-24', 3396, 'ENERGY', 254, 254, '2018-04-01', '2018-03-01', '2018-05-01', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2018-04-24 17:04:08', 'dbo', ''),
(2018030021, 201803, 41, 21, '2018-04-24', 3397, 'ENERGY', 46726, 46286, '2018-04-01', '2018-03-01', '2018-05-01', 440, 637906.4046, 0.0000, 9669.3300, 647575.7346, '2018-04-24 17:04:08', 'dbo', ''),
(2018030022, 201803, 41, 22, '2018-04-24', 3398, 'ENERGY', 27575, 27184, '2018-04-01', '2018-03-01', '2018-05-01', 391, 373887.1016, 0.0000, 8624.8100, 382511.9116, '2018-04-24 17:04:08', 'dbo', ''),
(2018030023, 201803, 41, 23, '2018-04-24', 3399, 'ENERGY', 74467, 73640, '2018-04-01', '2018-03-01', '2018-05-01', 827, 1060732.7870, 0.0000, 17918.8700, 1078651.6570, '2018-04-24 17:04:08', 'dbo', ''),
(2018030024, 201803, 41, 24, '2018-04-24', 3400, 'ENERGY', 45761, 45408, '2018-04-01', '2018-03-01', '2018-05-01', 353, 579167.1500, 0.0000, 7814.7800, 586981.9300, '2018-04-24 17:04:08', 'dbo', ''),
(2018030025, 201803, 41, 25, '2018-04-24', 3401, 'ENERGY', 82819, 78655, '2018-04-01', '2018-03-01', '2018-05-01', 4164, 1517359.9900, 0.0000, 89052.5600, 1606412.5500, '2018-04-24 17:04:07', 'dbo', ''),
(2018030026, 201803, 41, 26, '2018-04-24', 3402, 'ENERGY', 67151, 65963, '2018-04-01', '2018-03-01', '2018-05-01', 1188, 1099618.8874, 0.0000, 25614.1900, 1125233.0774, '2018-04-24 17:04:07', 'dbo', ''),
(2018030029, 201803, 41, 29, '2018-04-24', 3405, 'ENERGY', 94212, 92438, '2018-04-01', '2018-03-01', '2018-05-01', 1774, 1452273.2788, 0.0000, 38105.7600, 1490379.0388, '2018-04-24 17:04:08', 'dbo', ''),
(2018030030, 201803, 41, 30, '2018-04-24', 3406, 'ENERGY', 45764, 44928, '2018-04-01', '2018-03-01', '2018-05-01', 836, 601151.2112, 0.0000, 18110.7300, 619261.9412, '2018-04-24 17:04:08', 'dbo', ''),
(2018030031, 201803, 41, 31, '2018-04-24', 3407, 'ENERGY', 74001, 72476, '2018-04-01', '2018-03-01', '2018-05-01', 1525, 1167832.8080, 0.0000, 32797.8900, 1200630.6980, '2018-04-24 17:04:08', 'dbo', ''),
(2018030032, 201803, 41, 32, '2018-04-24', 3408, 'ENERGY', 121418, 118511, '2018-04-01', '2018-03-01', '2018-05-01', 2907, 1913552.1890, 0.0000, 62257.5200, 1975809.7090, '2018-04-24 17:04:08', 'dbo', ''),
(2018030033, 201803, 41, 33, '2018-04-24', 3409, 'ENERGY', 15896, 15324, '2018-04-01', '2018-03-01', '2018-05-01', 572, 266301.6634, 0.0000, 12483.1200, 278784.7834, '2018-04-24 17:04:08', 'dbo', ''),
(2018030034, 201803, 41, 34, '2018-04-24', 3410, 'ENERGY', 12181, 11793, '2018-04-01', '2018-03-01', '2018-05-01', 388, 213608.4542, 0.0000, 8560.8700, 222169.3242, '2018-04-24 17:04:08', 'dbo', ''),
(2018030035, 201803, 41, 35, '2018-04-24', 3411, 'ENERGY', 18259, 17952, '2018-04-01', '2018-03-01', '2018-05-01', 307, 294056.3126, 0.0000, 6834.2200, 300890.5326, '2018-04-24 17:04:08', 'dbo', ''),
(2018030036, 201803, 41, 36, '2018-04-24', 3412, 'ENERGY', 46980, 45991, '2018-04-01', '2018-03-01', '2018-05-01', 989, 790696.5638, 0.0000, 21372.1700, 812068.7338, '2018-04-24 17:04:08', 'dbo', ''),
(2018030037, 201803, 41, 37, '2018-04-24', 3413, 'ENERGY', 23431, 22966, '2018-04-01', '2018-03-01', '2018-05-01', 465, 369543.5110, 0.0000, 10202.2500, 379745.7610, '2018-04-24 17:04:08', 'dbo', ''),
(2018030038, 201803, 41, 38, '2018-04-24', 3414, 'ENERGY', 12583, 12332, '2018-04-01', '2018-03-01', '2018-05-01', 251, 213272.7934, 0.0000, 5640.4600, 218913.2534, '2018-04-24 17:04:08', 'dbo', ''),
(2018030039, 201803, 41, 39, '2018-04-24', 3415, 'ENERGY', 28296, 27961, '2018-04-01', '2018-03-01', '2018-05-01', 335, -145435.6118, 0.0000, 7431.0900, -138004.5218, '2018-04-24 17:04:08', 'dbo', ''),
(2018030040, 201803, 41, 40, '2018-04-24', 3416, 'ENERGY', 29155, 28400, '2018-04-01', '2018-03-01', '2018-05-01', 755, 492506.1596, 0.0000, 16384.0800, 508890.2396, '2018-04-24 17:04:08', 'dbo', ''),
(2018030041, 201803, 41, 41, '2018-04-24', 3417, 'ENERGY', 241, 241, '2018-04-01', '2018-03-01', '2018-05-01', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2018-04-24 17:04:08', 'dbo', ''),
(2018030042, 201803, 41, 42, '2018-04-24', 3418, 'ENERGY', 334, 334, '2018-04-01', '2018-03-01', '2018-05-01', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2018-04-24 17:04:08', 'dbo', ''),
(2018030043, 201803, 41, 43, '2018-04-24', 3419, 'ENERGY', 74548, 72838, '2018-04-01', '2018-03-01', '2018-05-01', 1710, 1064204.1402, 0.0000, 36741.4800, 1100945.6202, '2018-04-24 17:04:07', 'dbo', ''),
(2018030044, 201803, 41, 44, '2018-04-24', 3420, 'ENERGY', 42026, 41137, '2018-04-01', '2018-03-01', '2018-05-01', 889, 770282.4430, 0.0000, 19240.5100, 789522.9530, '2018-04-24 17:04:07', 'dbo', ''),
(2018030045, 201803, 41, 45, '2018-04-24', 3421, 'ENERGY', 35086, 34608, '2018-04-01', '2018-03-01', '2018-05-01', 478, 372109.0220, 0.0000, 10479.3700, 382588.3920, '2018-04-24 17:04:08', 'dbo', ''),
(2018030046, 201803, 41, 46, '2018-04-24', 3422, 'ENERGY', 54501, 53333, '2018-04-01', '2018-03-01', '2018-05-01', 1168, 939917.2154, 0.0000, 25187.8600, 965105.0754, '2018-04-24 17:04:08', 'dbo', ''),
(2018030047, 201803, 41, 47, '2018-04-24', 3423, 'ENERGY', 27426, 26924, '2018-04-01', '2018-03-01', '2018-05-01', 502, 360007.1410, 0.0000, 10990.9700, 370998.1110, '2018-04-24 17:04:08', 'dbo', ''),
(2018030048, 201803, 41, 48, '2018-04-24', 3424, 'ENERGY', 15711, 15008, '2018-04-01', '2018-03-01', '2018-05-01', 703, 293512.6700, 0.0000, 15275.6100, 308788.2800, '2018-04-24 17:04:08', 'dbo', ''),
(2018030049, 201803, 41, 49, '2018-04-24', 3425, 'ENERGY', 6568, 6406, '2018-04-01', '2018-03-01', '2018-05-01', 162, 110679.6890, 0.0000, 3743.3100, 114422.9990, '2018-04-24 17:04:07', 'dbo', ''),
(2018030050, 201803, 41, 50, '2018-04-24', 3426, 'ENERGY', 90846, 89158, '2018-04-01', '2018-03-01', '2018-05-01', 1688, 1381372.7392, 0.0000, 36272.5100, 1417645.2492, '2018-04-24 17:04:07', 'dbo', ''),
(2018030051, 201803, 41, 51, '2018-04-24', 3427, 'ENERGY', 211, 211, '2018-04-01', '2018-03-01', '2018-05-01', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2018-04-24 17:04:08', 'dbo', ''),
(2018030052, 201803, 41, 52, '2018-04-24', 3428, 'ENERGY', 321, 321, '2018-04-01', '2018-03-01', '2018-05-01', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2018-04-24 17:04:08', 'dbo', ''),
(2018030053, 201803, 41, 53, '2018-04-24', 3429, 'ENERGY', 2284, 1953, '2018-04-01', '2018-03-01', '2018-05-01', 331, 44464.9570, 0.0000, 7345.8200, 51810.7770, '2018-04-24 17:04:08', 'dbo', ''),
(2018030054, 201803, 41, 54, '2018-04-24', 3430, 'ENERGY', 32403, 31461, '2018-04-01', '2018-03-01', '2018-05-01', 942, 345663.5394, 0.0000, 20370.2900, 366033.8294, '2018-04-24 17:04:08', 'dbo', ''),
(2018030055, 201803, 41, 55, '2018-04-24', 3431, 'ENERGY', 12689, 12689, '2018-04-01', '2018-03-01', '2018-05-01', 0, 239408.7700, 0.0000, 0.0000, 239408.7700, '2018-04-24 17:04:08', 'dbo', ''),
(2018030056, 201803, 41, 56, '2018-04-24', 3432, 'ENERGY', 631, 629, '2018-04-01', '2018-03-01', '2018-05-01', 2, 17734.3190, 0.0000, 332.6300, 18066.9490, '2018-04-24 17:04:08', 'dbo', ''),
(2018030059, 201803, 41, 59, '2018-04-24', 3435, 'ENERGY', 128, 128, '2018-04-01', '2018-03-01', '2018-05-01', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2018-04-24 17:04:08', 'dbo', ''),
(2018030060, 201803, 41, 60, '2018-04-24', 3436, 'ENERGY', 250399, 243188, '2018-04-01', '2018-03-01', '2018-05-01', 7211, 3276980.0000, 0.0000, 154004.4200, 3430984.4200, '2018-04-24 17:04:07', 'dbo', ''),
(2018030061, 201803, 41, 61, '2018-04-24', 3437, 'ENERGY', 16, 16, '2018-04-01', '2018-03-01', '2018-05-01', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2018-04-24 17:04:08', 'dbo', ''),
(2018030062, 201803, 41, 62, '2018-04-24', 3438, 'ENERGY', 30, 30, '2018-04-01', '2018-03-01', '2018-05-01', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-04-24 17:04:08', 'dbo', ''),
(2018030063, 201803, 41, 63, '2018-04-24', 3439, 'ENERGY', 1, 1, '2018-04-01', '2018-03-01', '2018-05-01', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-04-24 17:04:08', 'dbo', ''),
(2018030064, 201803, 41, 64, '2018-04-24', 3440, 'ENERGY', 2, 2, '2018-04-01', '2018-03-01', '2018-05-01', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-04-24 17:04:08', 'dbo', ''),
(2018030065, 201803, 41, 65, '2018-04-24', 3441, 'ENERGY', 9604, 9226, '2018-04-01', '2018-03-01', '2018-05-01', 378, 182570.3280, 0.0000, 8347.7100, 190918.0380, '2018-04-24 17:04:07', 'dbo', ''),
(2018030066, 201803, 41, 66, '2018-04-24', 3442, 'ENERGY', 6473, 6240, '2018-04-01', '2018-03-01', '2018-05-01', 233, 122186.9224, 0.0000, 5256.7800, 127443.7024, '2018-04-24 17:04:07', 'dbo', ''),
(2018030067, 201803, 41, 67, '2018-04-24', 3443, 'ENERGY', 879, 830, '2018-04-01', '2018-03-01', '2018-05-01', 49, 23213.8638, 0.0000, 1334.5200, 24548.3838, '2018-04-24 17:04:08', 'dbo', ''),
(2018030068, 201803, 41, 68, '2018-04-24', 3444, 'ENERGY', 1804, 1717, '2018-04-01', '2018-03-01', '2018-05-01', 87, 41058.2600, 0.0000, 2144.5500, 43202.8100, '2018-04-24 17:04:08', 'dbo', ''),
(2018030069, 201803, 41, 69, '2018-04-24', 3445, 'ENERGY', 1, 1, '2018-04-01', '2018-03-01', '2018-05-01', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2018-04-24 17:04:08', 'dbo', ''),
(2018030070, 201803, 41, 70, '2018-04-24', 3446, 'ENERGY', 965, 799, '2018-04-01', '2018-03-01', '2018-05-01', 166, 22317.9600, 0.0000, 3828.5500, 26146.5100, '2018-04-24 17:04:08', 'dbo', ''),
(2018030071, 201803, 41, 71, '2018-04-24', 3447, 'ENERGY', 179075, 170811, '2018-04-01', '2018-03-01', '2018-05-01', 8264, 3147053.1862, 0.0000, 176450.8600, 3323504.0462, '2018-04-24 17:04:07', 'dbo', ''),
(2018030072, 201803, 41, 72, '2018-04-24', 3448, 'ENERGY', 1600, 1549, '2018-04-01', '2018-03-01', '2018-05-01', 51, 38797.6100, 0.0000, 1377.1500, 40174.7600, '2018-04-24 17:04:07', 'dbo', ''),
(2018030073, 201803, 41, 73, '2018-04-24', 3449, 'ENERGY', 469, 468, '2018-04-01', '2018-03-01', '2018-05-01', 1, 24566.5780, 0.0000, 311.3200, 24877.8980, '2018-04-24 17:04:07', 'dbo', ''),
(2018030075, 201803, 41, 75, '2018-04-24', 3450, 'ENERGY', 1566, 1528, '2018-04-01', '2018-03-01', '2018-05-01', 38, 37483.9400, 0.0000, 1100.0300, 38583.9700, '2018-04-24 17:04:07', 'dbo', ''),
(2018030076, 201803, 41, 76, '2018-04-24', 3451, 'ENERGY', 1631, 1594, '2018-04-01', '2018-03-01', '2018-05-01', 37, 38334.5100, 0.0000, 1078.7100, 39413.2200, '2018-04-24 17:04:07', 'dbo', ''),
(2018030077, 201803, 41, 77, '2018-04-24', 3452, 'ENERGY', 1298, 1271, '2018-04-01', '2018-03-01', '2018-05-01', 27, 32491.5000, 0.0000, 865.5500, 33357.0500, '2018-04-24 17:04:07', 'dbo', ''),
(2018030078, 201803, 41, 78, '2018-04-24', 3453, 'ENERGY', 377, 366, '2018-04-01', '2018-03-01', '2018-05-01', 11, 15210.1600, 0.0000, 524.4900, 15734.6500, '2018-04-24 17:04:07', 'dbo', ''),
(2018030079, 201803, 41, 79, '2018-04-24', 3454, 'ENERGY', 44316, 43149, '2018-04-01', '2018-03-01', '2018-05-01', 1167, 711116.0800, 0.0000, 25166.5300, 736282.6100, '2018-04-24 17:04:08', 'dbo', ''),
(2018030080, 201803, 41, 80, '2018-04-24', 3455, 'ENERGY', 311, 311, '2018-04-01', '2018-03-01', '2018-05-01', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2018-04-24 17:04:08', 'dbo', ''),
(2018030081, 201803, 41, 81, '2018-04-24', 3456, 'ENERGY', 1579, 1531, '2018-04-01', '2018-03-01', '2018-05-01', 48, 34351.5400, 0.0000, 1313.2000, 35664.7400, '2018-04-24 17:04:08', 'dbo', ''),
(2018030082, 201803, 41, 82, '2018-04-24', 3457, 'ENERGY', 3134, 3014, '2018-04-01', '2018-03-01', '2018-05-01', 120, 63877.0200, 0.0000, 2848.0000, 66725.0200, '2018-04-24 17:04:08', 'dbo', ''),
(2018030083, 201803, 41, 83, '2018-04-24', 3458, 'ENERGY', 79, 76, '2018-04-01', '2018-03-01', '2018-05-01', 3, 5848.2600, 0.0000, 353.9500, 6202.2100, '2018-04-24 17:04:07', 'dbo', ''),
(2018030084, 201803, 41, 84, '2018-04-24', 3459, 'ENERGY', 96, 87, '2018-04-01', '2018-03-01', '2018-05-01', 9, 5776.5400, 0.0000, 481.8500, 6258.3900, '2018-04-24 17:04:08', 'dbo', ''),
(2018030085, 201803, 41, 85, '2018-04-24', 3460, 'ENERGY', 355, 355, '2018-04-01', '2018-03-01', '2018-05-01', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2018-04-24 17:04:08', 'dbo', ''),
(2018030086, 201803, 41, 86, '2018-04-24', 3461, 'ENERGY', 82, 78, '2018-04-01', '2018-03-01', '2018-05-01', 4, 5557.0200, 0.0000, 375.2700, 5932.2900, '2018-04-24 17:04:08', 'dbo', ''),
(2018040001, 201804, 42, 1, '2018-05-30', 3462, 'ENERGY', 14016, 14016, '2018-05-01', '2018-04-01', '2018-06-06', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2018-06-18 15:48:19', 'dbo', ''),
(2018040002, 201804, 42, 2, '2018-05-30', 3463, 'ENERGY', 7081, 7081, '2018-05-01', '2018-04-01', '2018-06-06', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2018-06-18 15:48:19', 'dbo', ''),
(2018040003, 201804, 42, 3, '2018-05-30', 3464, 'ENERGY', 8948, 8948, '2018-05-01', '2018-04-01', '2018-06-06', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2018-06-18 15:48:19', 'dbo', ''),
(2018040004, 201804, 42, 4, '2018-05-30', 3465, 'ENERGY', 6711, 6711, '2018-05-01', '2018-04-01', '2018-06-06', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2018-06-18 15:48:19', 'dbo', ''),
(2018040005, 201804, 42, 5, '2018-05-30', 3466, 'ENERGY', 5255, 5255, '2018-05-01', '2018-04-01', '2018-06-06', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2018-06-18 15:48:19', 'dbo', ''),
(2018040006, 201804, 42, 6, '2018-05-30', 3467, 'ENERGY', 13833, 13833, '2018-05-01', '2018-04-01', '2018-06-06', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2018-06-18 15:48:19', 'dbo', ''),
(2018040007, 201804, 42, 7, '2018-05-30', 3468, 'ENERGY', 9652, 9652, '2018-05-01', '2018-04-01', '2018-06-06', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2018-06-18 15:48:19', 'dbo', ''),
(2018040008, 201804, 42, 8, '2018-05-30', 3469, 'ENERGY', 167, 167, '2018-05-01', '2018-04-01', '2018-06-06', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2018-06-18 15:48:19', 'dbo', ''),
(2018040009, 201804, 42, 9, '2018-05-30', 3470, 'ENERGY', 7894, 6787, '2018-05-01', '2018-04-01', '2018-06-06', 1107, 149441.3564, 0.0000, 24945.1000, 174386.4564, '2018-06-18 15:48:18', 'dbo', ''),
(2018040010, 201804, 42, 10, '2018-05-30', 3471, 'ENERGY', 682, 650, '2018-05-01', '2018-04-01', '2018-06-06', 32, 19918.6480, 0.0000, 1002.7100, 20921.3580, '2018-06-18 15:48:19', 'dbo', ''),
(2018040011, 201804, 42, 11, '2018-05-30', 3472, 'ENERGY', 201, 201, '2018-05-01', '2018-04-01', '2018-06-06', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2018-06-18 15:48:19', 'dbo', ''),
(2018040012, 201804, 42, 12, '2018-05-30', 3473, 'ENERGY', 137, 137, '2018-05-01', '2018-04-01', '2018-06-06', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2018-06-18 15:48:19', 'dbo', ''),
(2018040013, 201804, 42, 13, '2018-05-30', 3474, 'ENERGY', 12346, 11507, '2018-05-01', '2018-04-01', '2018-06-06', 839, 235600.9940, 0.0000, 18976.2100, 254577.2040, '2018-06-18 15:48:19', 'dbo', ''),
(2018040014, 201804, 42, 14, '2018-05-30', 3475, 'ENERGY', 5417, 5021, '2018-05-01', '2018-04-01', '2018-06-06', 396, 109969.8354, 0.0000, 9109.7200, 119079.5554, '2018-06-18 15:48:19', 'dbo', ''),
(2018040015, 201804, 42, 15, '2018-05-30', 3476, 'ENERGY', 162, 162, '2018-05-01', '2018-04-01', '2018-06-06', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2018-06-18 15:48:19', 'dbo', ''),
(2018040016, 201804, 42, 16, '2018-05-30', 3477, 'ENERGY', 10128, 9653, '2018-05-01', '2018-04-01', '2018-06-06', 475, 197120.5220, 0.0000, 10869.2100, 207989.7320, '2018-06-18 15:48:19', 'dbo', ''),
(2018040017, 201804, 42, 17, '2018-05-30', 3478, 'ENERGY', 27229, 25700, '2018-05-01', '2018-04-01', '2018-06-06', 1529, 504171.7270, 0.0000, 34343.8900, 538515.6170, '2018-06-18 15:48:19', 'dbo', ''),
(2018040018, 201804, 42, 18, '2018-05-30', 3479, 'ENERGY', 7538, 7149, '2018-05-01', '2018-04-01', '2018-06-06', 389, 144683.4400, 0.0000, 8953.8100, 153637.2500, '2018-06-18 15:48:19', 'dbo', ''),
(2018040019, 201804, 42, 19, '2018-05-30', 3480, 'ENERGY', 75, 75, '2018-05-01', '2018-04-01', '2018-06-06', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2018-06-18 15:48:19', 'dbo', ''),
(2018040020, 201804, 42, 20, '2018-05-30', 3481, 'ENERGY', 254, 254, '2018-05-01', '2018-04-01', '2018-06-06', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2018-06-18 15:48:19', 'dbo', ''),
(2018040021, 201804, 42, 21, '2018-05-30', 3482, 'ENERGY', 47175, 46726, '2018-05-01', '2018-04-01', '2018-06-06', 449, 647575.7346, 0.0000, 10290.1300, 657865.8646, '2018-06-18 15:48:19', 'dbo', ''),
(2018040022, 201804, 42, 22, '2018-05-30', 3483, 'ENERGY', 27921, 27575, '2018-05-01', '2018-04-01', '2018-06-06', 346, 382511.9116, 0.0000, 7996.1100, 390508.0216, '2018-06-18 15:48:19', 'dbo', ''),
(2018040023, 201804, 42, 23, '2018-05-30', 3484, 'ENERGY', 75236, 74467, '2018-05-01', '2018-04-01', '2018-06-06', 769, 1078651.6570, 0.0000, 17417.1800, 1096068.8370, '2018-06-18 15:48:19', 'dbo', ''),
(2018040024, 201804, 42, 24, '2018-05-30', 3485, 'ENERGY', 46136, 45761, '2018-05-01', '2018-04-01', '2018-06-06', 375, 586981.9300, 0.0000, 8642.0100, 595623.9400, '2018-06-18 15:48:19', 'dbo', ''),
(2018040025, 201804, 42, 25, '2018-05-30', 3486, 'ENERGY', 87163, 82819, '2018-05-01', '2018-04-01', '2018-06-06', 4344, 1606412.5500, 0.0000, 97039.5900, 1703452.1400, '2018-06-18 15:48:18', 'dbo', ''),
(2018040026, 201804, 42, 26, '2018-05-30', 3487, 'ENERGY', 68390, 67151, '2018-05-01', '2018-04-01', '2018-06-06', 1239, 1125233.0774, 0.0000, 27885.0100, 1153118.0874, '2018-06-18 15:48:18', 'dbo', ''),
(2018040029, 201804, 42, 29, '2018-05-30', 3490, 'ENERGY', 95922, 94212, '2018-05-01', '2018-04-01', '2018-06-06', 1710, 1490379.0388, 0.0000, 38375.1300, 1528754.1688, '2018-06-18 15:48:19', 'dbo', ''),
(2018040030, 201804, 42, 30, '2018-05-30', 3491, 'ENERGY', 46639, 45764, '2018-05-01', '2018-04-01', '2018-06-06', 875, 619261.9412, 0.0000, 19778.0100, 639039.9512, '2018-06-18 15:48:19', 'dbo', ''),
(2018040031, 201804, 42, 31, '2018-05-30', 3492, 'ENERGY', 75645, 74001, '2018-05-01', '2018-04-01', '2018-06-06', 1644, 1200630.6980, 0.0000, 36905.1700, 1237535.8680, '2018-06-18 15:48:19', 'dbo', ''),
(2018040032, 201804, 42, 32, '2018-05-30', 3493, 'ENERGY', 124255, 121418, '2018-05-01', '2018-04-01', '2018-06-06', 2837, 1975809.7090, 0.0000, 63475.6900, 2039285.3990, '2018-06-18 15:48:19', 'dbo', ''),
(2018040033, 201804, 42, 33, '2018-05-30', 3494, 'ENERGY', 16513, 15896, '2018-05-01', '2018-04-01', '2018-06-06', 617, 278784.7834, 0.0000, 14031.8400, 292816.6234, '2018-06-18 15:48:19', 'dbo', ''),
(2018040034, 201804, 42, 34, '2018-05-30', 3495, 'ENERGY', 12507, 12181, '2018-05-01', '2018-04-01', '2018-06-06', 326, 222169.3242, 0.0000, 7550.6700, 229719.9942, '2018-06-18 15:48:19', 'dbo', ''),
(2018040035, 201804, 42, 35, '2018-05-30', 3496, 'ENERGY', 18555, 18259, '2018-05-01', '2018-04-01', '2018-06-06', 296, 300890.5326, 0.0000, 6882.5100, 307773.0426, '2018-06-18 15:48:19', 'dbo', ''),
(2018040036, 201804, 42, 36, '2018-05-30', 3497, 'ENERGY', 47924, 46980, '2018-05-01', '2018-04-01', '2018-06-06', 944, 812068.7338, 0.0000, 21314.7700, 833383.5038, '2018-06-18 15:48:19', 'dbo', ''),
(2018040037, 201804, 42, 37, '2018-05-30', 3498, 'ENERGY', 23967, 23431, '2018-05-01', '2018-04-01', '2018-06-06', 536, 379745.7610, 0.0000, 12227.7900, 391973.5510, '2018-06-18 15:48:19', 'dbo', ''),
(2018040038, 201804, 42, 38, '2018-05-30', 3499, 'ENERGY', 12847, 12583, '2018-05-01', '2018-04-01', '2018-06-06', 264, 218913.2534, 0.0000, 6169.8200, 225083.0734, '2018-06-18 15:48:19', 'dbo', ''),
(2018040039, 201804, 42, 39, '2018-05-30', 3500, 'ENERGY', 28577, 28296, '2018-05-01', '2018-04-01', '2018-06-06', 281, -138004.5218, 0.0000, 6548.4300, -131456.0918, '2018-06-18 15:48:19', 'dbo', ''),
(2018040040, 201804, 42, 40, '2018-05-30', 3501, 'ENERGY', 29964, 29155, '2018-05-01', '2018-04-01', '2018-06-06', 809, 508890.2396, 0.0000, 18308.0500, 527198.2896, '2018-06-18 15:48:19', 'dbo', ''),
(2018040041, 201804, 42, 41, '2018-05-30', 3502, 'ENERGY', 241, 241, '2018-05-01', '2018-04-01', '2018-06-06', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2018-06-18 15:48:19', 'dbo', ''),
(2018040042, 201804, 42, 42, '2018-05-30', 3503, 'ENERGY', 334, 334, '2018-05-01', '2018-04-01', '2018-06-06', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2018-06-18 15:48:19', 'dbo', ''),
(2018040043, 201804, 42, 43, '2018-05-30', 3504, 'ENERGY', 76154, 74548, '2018-05-01', '2018-04-01', '2018-06-06', 1606, 1100945.6202, 0.0000, 36058.8400, 1137004.4602, '2018-06-18 15:48:18', 'dbo', ''),
(2018040044, 201804, 42, 44, '2018-05-30', 3505, 'ENERGY', 42899, 42026, '2018-05-01', '2018-04-01', '2018-06-06', 873, 789522.9530, 0.0000, 19733.4600, 809256.4130, '2018-06-18 15:48:18', 'dbo', ''),
(2018040045, 201804, 42, 45, '2018-05-30', 3506, 'ENERGY', 35614, 35086, '2018-05-01', '2018-04-01', '2018-06-06', 528, 382588.3920, 0.0000, 12049.6100, 394638.0020, '2018-06-18 15:48:19', 'dbo', ''),
(2018040046, 201804, 42, 46, '2018-05-30', 3507, 'ENERGY', 55662, 54501, '2018-05-01', '2018-04-01', '2018-06-06', 1161, 965105.0754, 0.0000, 26147.8000, 991252.8754, '2018-06-18 15:48:19', 'dbo', ''),
(2018040047, 201804, 42, 47, '2018-05-30', 3508, 'ENERGY', 27886, 27426, '2018-05-01', '2018-04-01', '2018-06-06', 460, 370998.1110, 0.0000, 10535.1200, 381533.2310, '2018-06-18 15:48:19', 'dbo', ''),
(2018040048, 201804, 42, 48, '2018-05-30', 3509, 'ENERGY', 16437, 15711, '2018-05-01', '2018-04-01', '2018-06-06', 726, 308788.2800, 0.0000, 16459.4700, 325247.7500, '2018-06-18 15:48:19', 'dbo', ''),
(2018040049, 201804, 42, 49, '2018-05-30', 3510, 'ENERGY', 6756, 6568, '2018-05-01', '2018-04-01', '2018-06-06', 188, 114422.9990, 0.0000, 4477.1400, 118900.1390, '2018-06-18 15:48:18', 'dbo', ''),
(2018040050, 201804, 42, 50, '2018-05-30', 3511, 'ENERGY', 92540, 90846, '2018-05-01', '2018-04-01', '2018-06-06', 1694, 1417645.2492, 0.0000, 38018.7700, 1455664.0192, '2018-06-18 15:48:18', 'dbo', ''),
(2018040051, 201804, 42, 51, '2018-05-30', 3512, 'ENERGY', 211, 211, '2018-05-01', '2018-04-01', '2018-06-06', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2018-06-18 15:48:19', 'dbo', ''),
(2018040052, 201804, 42, 52, '2018-05-30', 3513, 'ENERGY', 321, 321, '2018-05-01', '2018-04-01', '2018-06-06', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2018-06-18 15:48:19', 'dbo', '');
INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2018040053, 201804, 42, 53, '2018-05-30', 3514, 'ENERGY', 2670, 2284, '2018-05-01', '2018-04-01', '2018-06-06', 386, 51810.7770, 0.0000, 8886.9900, 60697.7670, '2018-06-18 15:48:19', 'dbo', ''),
(2018040054, 201804, 42, 54, '2018-05-30', 3515, 'ENERGY', 33158, 32403, '2018-05-01', '2018-04-01', '2018-06-06', 755, 366033.8294, 0.0000, 17105.3700, 383139.1994, '2018-06-18 15:48:19', 'dbo', ''),
(2018040055, 201804, 42, 55, '2018-05-30', 3516, 'ENERGY', 12689, 12689, '2018-05-01', '2018-04-01', '2018-06-06', 0, 239408.7700, 0.0000, 0.0000, 239408.7700, '2018-06-18 15:48:19', 'dbo', ''),
(2018040056, 201804, 42, 56, '2018-05-30', 3517, 'ENERGY', 633, 631, '2018-05-01', '2018-04-01', '2018-06-06', 2, 18066.9490, 0.0000, 334.5400, 18401.4890, '2018-06-18 15:48:19', 'dbo', ''),
(2018040059, 201804, 42, 59, '2018-05-30', 3520, 'ENERGY', 128, 128, '2018-05-01', '2018-04-01', '2018-06-06', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2018-06-18 15:48:19', 'dbo', ''),
(2018040060, 201804, 42, 60, '2018-05-30', 3521, 'ENERGY', 257522, 250399, '2018-05-01', '2018-04-01', '2018-06-06', 7123, 3430984.4200, 0.0000, 158933.5000, 3589917.9200, '2018-06-18 15:48:18', 'dbo', ''),
(2018040061, 201804, 42, 61, '2018-05-30', 3522, 'ENERGY', 16, 16, '2018-05-01', '2018-04-01', '2018-06-06', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2018-06-18 15:48:19', 'dbo', ''),
(2018040062, 201804, 42, 62, '2018-05-30', 3523, 'ENERGY', 30, 30, '2018-05-01', '2018-04-01', '2018-06-06', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-06-18 15:48:19', 'dbo', ''),
(2018040063, 201804, 42, 63, '2018-05-30', 3524, 'ENERGY', 1, 1, '2018-05-01', '2018-04-01', '2018-06-06', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-06-18 15:48:19', 'dbo', ''),
(2018040064, 201804, 42, 64, '2018-05-30', 3525, 'ENERGY', 2, 2, '2018-05-01', '2018-04-01', '2018-06-06', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-06-18 15:48:19', 'dbo', ''),
(2018040065, 201804, 42, 65, '2018-05-30', 3526, 'ENERGY', 10011, 9604, '2018-05-01', '2018-04-01', '2018-06-06', 407, 190918.0380, 0.0000, 9354.7100, 200272.7480, '2018-06-18 15:48:18', 'dbo', ''),
(2018040066, 201804, 42, 66, '2018-05-30', 3527, 'ENERGY', 6746, 6473, '2018-05-01', '2018-04-01', '2018-06-06', 273, 127443.7024, 0.0000, 6370.2600, 133813.9624, '2018-06-18 15:48:18', 'dbo', ''),
(2018040067, 201804, 42, 67, '2018-05-30', 3528, 'ENERGY', 906, 879, '2018-05-01', '2018-04-01', '2018-06-06', 27, 24548.3838, 0.0000, 891.3500, 25439.7338, '2018-06-18 15:48:19', 'dbo', ''),
(2018040068, 201804, 42, 68, '2018-05-30', 3529, 'ENERGY', 1871, 1804, '2018-05-01', '2018-04-01', '2018-06-06', 67, 43202.8100, 0.0000, 1782.2300, 44985.0400, '2018-06-18 15:48:19', 'dbo', ''),
(2018040069, 201804, 42, 69, '2018-05-30', 3530, 'ENERGY', 1, 1, '2018-05-01', '2018-04-01', '2018-06-06', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2018-06-18 15:48:19', 'dbo', ''),
(2018040070, 201804, 42, 70, '2018-05-30', 3531, 'ENERGY', 1141, 965, '2018-05-01', '2018-04-01', '2018-06-06', 176, 26146.5100, 0.0000, 4209.8700, 30356.3800, '2018-06-18 15:48:19', 'dbo', ''),
(2018040071, 201804, 42, 71, '2018-05-30', 3532, 'ENERGY', 187091, 179075, '2018-05-01', '2018-04-01', '2018-06-06', 8016, 3323504.0462, 0.0000, 178822.4100, 3502326.4562, '2018-06-18 15:48:18', 'dbo', ''),
(2018040072, 201804, 42, 72, '2018-05-30', 3533, 'ENERGY', 1660, 1600, '2018-05-01', '2018-04-01', '2018-06-06', 60, 40174.7600, 0.0000, 1626.3200, 41801.0800, '2018-06-18 15:48:18', 'dbo', ''),
(2018040073, 201804, 42, 73, '2018-05-30', 3534, 'ENERGY', 470, 469, '2018-05-01', '2018-04-01', '2018-06-06', 1, 24877.8980, 0.0000, 312.2700, 25190.1680, '2018-06-18 15:48:18', 'dbo', ''),
(2018040075, 201804, 42, 75, '2018-05-30', 3535, 'ENERGY', 1603, 1566, '2018-05-01', '2018-04-01', '2018-06-06', 37, 38583.9700, 0.0000, 1114.0600, 39698.0300, '2018-06-18 15:48:18', 'dbo', ''),
(2018040076, 201804, 42, 76, '2018-05-30', 3536, 'ENERGY', 1667, 1631, '2018-05-01', '2018-04-01', '2018-06-06', 36, 39413.2200, 0.0000, 1091.7900, 40505.0100, '2018-06-18 15:48:18', 'dbo', ''),
(2018040077, 201804, 42, 77, '2018-05-30', 3537, 'ENERGY', 1324, 1298, '2018-05-01', '2018-04-01', '2018-06-06', 26, 33357.0500, 0.0000, 869.0700, 34226.1200, '2018-06-18 15:48:18', 'dbo', ''),
(2018040078, 201804, 42, 78, '2018-05-30', 3538, 'ENERGY', 377, 377, '2018-05-01', '2018-04-01', '2018-06-06', 0, 15734.6500, 0.0000, 0.0000, 15734.6500, '2018-06-18 15:48:19', 'dbo', ''),
(2018040079, 201804, 42, 79, '2018-05-30', 3539, 'ENERGY', 45310, 44316, '2018-05-01', '2018-04-01', '2018-06-06', 994, 736282.6100, 0.0000, 22428.3700, 758710.9800, '2018-06-18 15:48:19', 'dbo', ''),
(2018040080, 201804, 42, 80, '2018-05-30', 3540, 'ENERGY', 311, 311, '2018-05-01', '2018-04-01', '2018-06-06', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2018-06-18 15:48:19', 'dbo', ''),
(2018040081, 201804, 42, 81, '2018-05-30', 3541, 'ENERGY', 1624, 1579, '2018-05-01', '2018-04-01', '2018-06-06', 45, 35664.7400, 0.0000, 1292.2400, 36956.9800, '2018-06-18 15:48:19', 'dbo', ''),
(2018040082, 201804, 42, 82, '2018-05-30', 3542, 'ENERGY', 3249, 3134, '2018-05-01', '2018-04-01', '2018-06-06', 115, 66725.0200, 0.0000, 2851.2800, 69576.3000, '2018-06-18 15:48:19', 'dbo', ''),
(2018040083, 201804, 42, 83, '2018-05-30', 3543, 'ENERGY', 82, 79, '2018-05-01', '2018-04-01', '2018-06-06', 3, 6202.2100, 0.0000, 356.8200, 6559.0300, '2018-06-18 15:48:18', 'dbo', ''),
(2018040084, 201804, 42, 84, '2018-05-30', 3544, 'ENERGY', 108, 96, '2018-05-01', '2018-04-01', '2018-06-06', 12, 6258.3900, 0.0000, 557.2600, 6815.6500, '2018-06-18 15:48:19', 'dbo', ''),
(2018040085, 201804, 42, 85, '2018-05-30', 3545, 'ENERGY', 355, 355, '2018-05-01', '2018-04-01', '2018-06-06', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2018-06-18 15:48:19', 'dbo', ''),
(2018040086, 201804, 42, 86, '2018-05-30', 3546, 'ENERGY', 86, 82, '2018-05-01', '2018-04-01', '2018-06-06', 4, 5932.2900, 0.0000, 379.0800, 6311.3700, '2018-06-18 15:48:19', 'dbo', ''),
(2018050001, 201805, 43, 1, '2018-06-22', 3547, 'ENERGY', 14016, 14016, '2018-06-01', '2018-05-01', '2018-06-29', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2018-06-26 12:00:27', 'dbo', ''),
(2018050002, 201805, 43, 2, '2018-06-22', 3548, 'ENERGY', 7081, 7081, '2018-06-01', '2018-05-01', '2018-06-29', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2018-06-26 12:00:27', 'dbo', ''),
(2018050003, 201805, 43, 3, '2018-06-22', 3549, 'ENERGY', 8948, 8948, '2018-06-01', '2018-05-01', '2018-06-29', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2018-06-26 12:00:27', 'dbo', ''),
(2018050004, 201805, 43, 4, '2018-06-22', 3550, 'ENERGY', 6711, 6711, '2018-06-01', '2018-05-01', '2018-06-29', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2018-06-26 12:00:27', 'dbo', ''),
(2018050005, 201805, 43, 5, '2018-06-22', 3551, 'ENERGY', 5255, 5255, '2018-06-01', '2018-05-01', '2018-06-29', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2018-06-26 12:00:27', 'dbo', ''),
(2018050006, 201805, 43, 6, '2018-06-22', 3552, 'ENERGY', 13833, 13833, '2018-06-01', '2018-05-01', '2018-06-29', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2018-06-26 12:00:27', 'dbo', ''),
(2018050007, 201805, 43, 7, '2018-06-22', 3553, 'ENERGY', 9652, 9652, '2018-06-01', '2018-05-01', '2018-06-29', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2018-06-26 12:00:27', 'dbo', ''),
(2018050008, 201805, 43, 8, '2018-06-22', 3554, 'ENERGY', 167, 167, '2018-06-01', '2018-05-01', '2018-06-29', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2018-06-26 12:00:27', 'dbo', ''),
(2018050009, 201805, 43, 9, '2018-06-22', 3555, 'ENERGY', 9086, 7894, '2018-06-01', '2018-05-01', '2018-06-29', 1192, 174386.4564, 0.0000, 25708.3700, 200094.8264, '2018-06-26 12:00:26', 'dbo', ''),
(2018050010, 201805, 43, 10, '2018-06-22', 3556, 'ENERGY', 715, 682, '2018-06-01', '2018-05-01', '2018-06-29', 33, 20921.3580, 0.0000, 993.7100, 21915.0680, '2018-06-26 12:00:26', 'dbo', ''),
(2018050011, 201805, 43, 11, '2018-06-22', 3557, 'ENERGY', 201, 201, '2018-06-01', '2018-05-01', '2018-06-29', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2018-06-26 12:00:27', 'dbo', ''),
(2018050012, 201805, 43, 12, '2018-06-22', 3558, 'ENERGY', 137, 137, '2018-06-01', '2018-05-01', '2018-06-29', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2018-06-26 12:00:27', 'dbo', ''),
(2018050013, 201805, 43, 13, '2018-06-22', 3559, 'ENERGY', 13391, 12346, '2018-06-01', '2018-05-01', '2018-06-29', 1045, 254577.2040, 0.0000, 22573.7300, 277150.9340, '2018-06-26 12:00:27', 'dbo', ''),
(2018050014, 201805, 43, 14, '2018-06-22', 3560, 'ENERGY', 6071, 5417, '2018-06-01', '2018-05-01', '2018-06-29', 654, 119079.5554, 0.0000, 14235.9900, 133315.5454, '2018-06-26 12:00:27', 'dbo', ''),
(2018050015, 201805, 43, 15, '2018-06-22', 3561, 'ENERGY', 162, 162, '2018-06-01', '2018-05-01', '2018-06-29', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2018-06-26 12:00:27', 'dbo', ''),
(2018050016, 201805, 43, 16, '2018-06-22', 3562, 'ENERGY', 10676, 10128, '2018-06-01', '2018-05-01', '2018-06-29', 548, 207989.7320, 0.0000, 11975.6300, 219965.3620, '2018-06-26 12:00:27', 'dbo', ''),
(2018050017, 201805, 43, 17, '2018-06-22', 3563, 'ENERGY', 29199, 27229, '2018-06-01', '2018-05-01', '2018-06-29', 1970, 538515.6170, 0.0000, 42298.5500, 580814.1670, '2018-06-26 12:00:26', 'dbo', ''),
(2018050018, 201805, 43, 18, '2018-06-22', 3564, 'ENERGY', 7987, 7538, '2018-06-01', '2018-05-01', '2018-06-29', 449, 153637.2500, 0.0000, 9864.5300, 163501.7800, '2018-06-26 12:00:26', 'dbo', ''),
(2018050019, 201805, 43, 19, '2018-06-22', 3565, 'ENERGY', 75, 75, '2018-06-01', '2018-05-01', '2018-06-29', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2018-06-26 12:00:27', 'dbo', ''),
(2018050020, 201805, 43, 20, '2018-06-22', 3566, 'ENERGY', 254, 254, '2018-06-01', '2018-05-01', '2018-06-29', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2018-06-26 12:00:27', 'dbo', ''),
(2018050021, 201805, 43, 21, '2018-06-22', 3567, 'ENERGY', 47777, 47175, '2018-06-01', '2018-05-01', '2018-06-29', 602, 657865.8646, 0.0000, 13127.1300, 670992.9946, '2018-06-26 12:00:27', 'dbo', ''),
(2018050022, 201805, 43, 22, '2018-06-22', 3568, 'ENERGY', 28414, 27921, '2018-06-01', '2018-05-01', '2018-06-29', 493, 390508.0216, 0.0000, 10802.8000, 401310.8216, '2018-06-26 12:00:27', 'dbo', ''),
(2018050023, 201805, 43, 23, '2018-06-22', 3569, 'ENERGY', 76291, 75236, '2018-06-01', '2018-05-01', '2018-06-29', 1055, 1096068.8370, 0.0000, 22786.9700, 1118855.8070, '2018-06-26 12:00:27', 'dbo', ''),
(2018050024, 201805, 43, 24, '2018-06-22', 3570, 'ENERGY', 46673, 46136, '2018-06-01', '2018-05-01', '2018-06-29', 537, 595623.9400, 0.0000, 11741.0600, 607365.0000, '2018-06-26 12:00:27', 'dbo', ''),
(2018050025, 201805, 43, 25, '2018-06-22', 3571, 'ENERGY', 92698, 87163, '2018-06-01', '2018-05-01', '2018-06-29', 5535, 1703452.1400, 0.0000, 118319.1000, 1821771.2400, '2018-06-26 12:00:26', 'dbo', ''),
(2018050026, 201805, 43, 26, '2018-06-22', 3572, 'ENERGY', 69996, 68390, '2018-06-01', '2018-05-01', '2018-06-29', 1606, 1153118.0874, 0.0000, 34536.5700, 1187654.6574, '2018-06-26 12:00:26', 'dbo', ''),
(2018050029, 201805, 43, 29, '2018-06-22', 3573, 'ENERGY', 98123, 95922, '2018-06-01', '2018-05-01', '2018-06-29', 2201, 1528754.1688, 0.0000, 47224.4200, 1575978.5888, '2018-06-26 12:00:27', 'dbo', ''),
(2018050030, 201805, 43, 30, '2018-06-22', 3574, 'ENERGY', 47734, 46639, '2018-06-01', '2018-05-01', '2018-06-29', 1095, 639039.9512, 0.0000, 23639.9300, 662679.8812, '2018-06-26 12:00:27', 'dbo', ''),
(2018050031, 201805, 43, 31, '2018-06-22', 3575, 'ENERGY', 77749, 75645, '2018-06-01', '2018-05-01', '2018-06-29', 2104, 1237535.8680, 0.0000, 45155.9800, 1282691.8480, '2018-06-26 12:00:27', 'dbo', ''),
(2018050032, 201805, 43, 32, '2018-06-22', 3576, 'ENERGY', 127981, 124255, '2018-06-01', '2018-05-01', '2018-06-29', 3726, 2039285.3990, 0.0000, 79743.7400, 2119029.1390, '2018-06-26 12:00:27', 'dbo', ''),
(2018050033, 201805, 43, 33, '2018-06-22', 3577, 'ENERGY', 17357, 16513, '2018-06-01', '2018-05-01', '2018-06-29', 844, 292816.6234, 0.0000, 18287.5700, 311104.1934, '2018-06-26 12:00:26', 'dbo', ''),
(2018050034, 201805, 43, 34, '2018-06-22', 3578, 'ENERGY', 12916, 12507, '2018-06-01', '2018-05-01', '2018-06-29', 409, 229719.9942, 0.0000, 9011.5700, 238731.5642, '2018-06-26 12:00:26', 'dbo', ''),
(2018050035, 201805, 43, 35, '2018-06-22', 3579, 'ENERGY', 18927, 18555, '2018-06-01', '2018-05-01', '2018-06-29', 372, 307773.0426, 0.0000, 8222.5800, 315995.6226, '2018-06-26 12:00:26', 'dbo', ''),
(2018050036, 201805, 43, 36, '2018-06-22', 3580, 'ENERGY', 49166, 47924, '2018-06-01', '2018-05-01', '2018-06-29', 1242, 833383.5038, 0.0000, 26774.5800, 860158.0838, '2018-06-26 12:00:26', 'dbo', ''),
(2018050037, 201805, 43, 37, '2018-06-22', 3581, 'ENERGY', 24510, 23967, '2018-06-01', '2018-05-01', '2018-06-29', 543, 391973.5510, 0.0000, 11869.0000, 403842.5510, '2018-06-26 12:00:27', 'dbo', ''),
(2018050038, 201805, 43, 38, '2018-06-22', 3582, 'ENERGY', 13161, 12847, '2018-06-01', '2018-05-01', '2018-06-29', 314, 225083.0734, 0.0000, 6985.7800, 232068.8534, '2018-06-26 12:00:27', 'dbo', ''),
(2018050039, 201805, 43, 39, '2018-06-22', 3583, 'ENERGY', 28960, 28577, '2018-06-01', '2018-05-01', '2018-06-29', 383, -131456.0918, 0.0000, 8457.1400, -122998.9518, '2018-06-26 12:00:27', 'dbo', ''),
(2018050040, 201805, 43, 40, '2018-06-22', 3584, 'ENERGY', 31024, 29964, '2018-06-01', '2018-05-01', '2018-06-29', 1060, 527198.2896, 0.0000, 22893.5900, 550091.8796, '2018-06-26 12:00:27', 'dbo', ''),
(2018050041, 201805, 43, 41, '2018-06-22', 3585, 'ENERGY', 241, 241, '2018-06-01', '2018-05-01', '2018-06-29', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2018-06-26 12:00:27', 'dbo', ''),
(2018050042, 201805, 43, 42, '2018-06-22', 3586, 'ENERGY', 334, 334, '2018-06-01', '2018-05-01', '2018-06-29', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2018-06-26 12:00:27', 'dbo', ''),
(2018050043, 201805, 43, 43, '2018-06-22', 3587, 'ENERGY', 78130, 76154, '2018-06-01', '2018-05-01', '2018-06-29', 1976, 1137004.4602, 0.0000, 42426.4900, 1179430.9502, '2018-06-26 12:00:26', 'dbo', ''),
(2018050044, 201805, 43, 44, '2018-06-22', 3588, 'ENERGY', 44085, 42899, '2018-06-01', '2018-05-01', '2018-06-29', 1186, 809256.4130, 0.0000, 25580.4300, 834836.8430, '2018-06-26 12:00:26', 'dbo', ''),
(2018050045, 201805, 43, 45, '2018-06-22', 3589, 'ENERGY', 36269, 35614, '2018-06-01', '2018-05-01', '2018-06-29', 655, 394638.0020, 0.0000, 14257.3100, 408895.3120, '2018-06-26 12:00:27', 'dbo', ''),
(2018050046, 201805, 43, 46, '2018-06-22', 3590, 'ENERGY', 56995, 55662, '2018-06-01', '2018-05-01', '2018-06-29', 1333, 991252.8754, 0.0000, 28715.0800, 1019967.9554, '2018-06-26 12:00:27', 'dbo', ''),
(2018050047, 201805, 43, 47, '2018-06-22', 3591, 'ENERGY', 28583, 27886, '2018-06-01', '2018-05-01', '2018-06-29', 697, 381533.2310, 0.0000, 15152.9200, 396686.1510, '2018-06-26 12:00:27', 'dbo', ''),
(2018050048, 201805, 43, 48, '2018-06-22', 3592, 'ENERGY', 17346, 16437, '2018-06-01', '2018-05-01', '2018-06-29', 909, 325247.7500, 0.0000, 19673.6400, 344921.3900, '2018-06-26 12:00:27', 'dbo', ''),
(2018050049, 201805, 43, 49, '2018-06-22', 3593, 'ENERGY', 7002, 6756, '2018-06-01', '2018-05-01', '2018-06-29', 246, 118900.1390, 0.0000, 5535.7400, 124435.8790, '2018-06-26 12:00:26', 'dbo', ''),
(2018050050, 201805, 43, 50, '2018-06-22', 3594, 'ENERGY', 94514, 92540, '2018-06-01', '2018-05-01', '2018-06-29', 1974, 1455664.0192, 0.0000, 42383.8500, 1498047.8692, '2018-06-26 12:00:26', 'dbo', ''),
(2018050051, 201805, 43, 51, '2018-06-22', 3595, 'ENERGY', 211, 211, '2018-06-01', '2018-05-01', '2018-06-29', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2018-06-26 12:00:27', 'dbo', ''),
(2018050052, 201805, 43, 52, '2018-06-22', 3596, 'ENERGY', 321, 321, '2018-06-01', '2018-05-01', '2018-06-29', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2018-06-26 12:00:27', 'dbo', ''),
(2018050053, 201805, 43, 53, '2018-06-22', 3597, 'ENERGY', 3269, 2670, '2018-06-01', '2018-05-01', '2018-06-29', 599, 60697.7670, 0.0000, 13063.1600, 73760.9270, '2018-06-26 12:00:27', 'dbo', ''),
(2018050054, 201805, 43, 54, '2018-06-22', 3598, 'ENERGY', 34063, 33158, '2018-06-01', '2018-05-01', '2018-06-29', 905, 383139.1994, 0.0000, 19588.3500, 402727.5494, '2018-06-26 12:00:27', 'dbo', ''),
(2018050055, 201805, 43, 55, '2018-06-22', 3599, 'ENERGY', 12689, 12689, '2018-06-01', '2018-05-01', '2018-06-29', 0, 239408.7700, 0.0000, 0.0000, 239408.7700, '2018-06-26 12:00:27', 'dbo', ''),
(2018050056, 201805, 43, 56, '2018-06-22', 3600, 'ENERGY', 634, 633, '2018-06-01', '2018-05-01', '2018-06-29', 1, 18401.4890, 0.0000, 311.3200, 18712.8090, '2018-06-26 12:00:27', 'dbo', ''),
(2018050059, 201805, 43, 59, '2018-06-22', 3601, 'ENERGY', 128, 128, '2018-06-01', '2018-05-01', '2018-06-29', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2018-06-26 12:00:27', 'dbo', ''),
(2018050060, 201805, 43, 60, '2018-06-22', 3602, 'ENERGY', 266871, 257522, '2018-06-01', '2018-05-01', '2018-06-29', 9349, 3589917.9200, 0.0000, 199649.3500, 3789567.2700, '2018-06-26 12:00:26', 'dbo', ''),
(2018050061, 201805, 43, 61, '2018-06-22', 3603, 'ENERGY', 16, 16, '2018-06-01', '2018-05-01', '2018-06-29', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2018-06-26 12:00:27', 'dbo', ''),
(2018050062, 201805, 43, 62, '2018-06-22', 3604, 'ENERGY', 30, 30, '2018-06-01', '2018-05-01', '2018-06-29', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-06-26 12:00:27', 'dbo', ''),
(2018050063, 201805, 43, 63, '2018-06-22', 3605, 'ENERGY', 1, 1, '2018-06-01', '2018-05-01', '2018-06-29', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-06-26 12:00:27', 'dbo', ''),
(2018050064, 201805, 43, 64, '2018-06-22', 3606, 'ENERGY', 2, 2, '2018-06-01', '2018-05-01', '2018-06-29', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-06-26 12:00:27', 'dbo', ''),
(2018050065, 201805, 43, 65, '2018-06-22', 3607, 'ENERGY', 10537, 10011, '2018-06-01', '2018-05-01', '2018-06-29', 526, 200272.7480, 0.0000, 11506.5000, 211779.2480, '2018-06-26 12:00:26', 'dbo', ''),
(2018050066, 201805, 43, 66, '2018-06-22', 3608, 'ENERGY', 7066, 6746, '2018-06-01', '2018-05-01', '2018-06-29', 320, 133813.9624, 0.0000, 7113.7200, 140927.6824, '2018-06-26 12:00:26', 'dbo', ''),
(2018050067, 201805, 43, 67, '2018-06-22', 3609, 'ENERGY', 947, 906, '2018-06-01', '2018-05-01', '2018-06-29', 41, 25439.7338, 0.0000, 1164.2900, 26604.0238, '2018-06-26 12:00:27', 'dbo', ''),
(2018050068, 201805, 43, 68, '2018-06-22', 3610, 'ENERGY', 2004, 1871, '2018-06-01', '2018-05-01', '2018-06-29', 133, 44985.0400, 0.0000, 3126.1100, 48111.1500, '2018-06-26 12:00:27', 'dbo', ''),
(2018050069, 201805, 43, 69, '2018-06-22', 3611, 'ENERGY', 1, 1, '2018-06-01', '2018-05-01', '2018-06-29', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2018-06-26 12:00:27', 'dbo', ''),
(2018050070, 201805, 43, 70, '2018-06-22', 3612, 'ENERGY', 1368, 1141, '2018-06-01', '2018-05-01', '2018-06-29', 227, 30356.3800, 0.0000, 5130.5800, 35486.9600, '2018-06-26 12:00:27', 'dbo', ''),
(2018050071, 201805, 43, 71, '2018-06-22', 3613, 'ENERGY', 197264, 187091, '2018-06-01', '2018-05-01', '2018-06-29', 10173, 3502326.4562, 0.0000, 217220.4500, 3719546.9062, '2018-06-26 12:00:26', 'dbo', ''),
(2018050072, 201805, 43, 72, '2018-06-22', 3614, 'ENERGY', 1721, 1660, '2018-06-01', '2018-05-01', '2018-06-29', 61, 41801.0800, 0.0000, 1590.7800, 43391.8600, '2018-06-26 12:00:26', 'dbo', ''),
(2018050073, 201805, 43, 73, '2018-06-22', 3615, 'ENERGY', 471, 470, '2018-06-01', '2018-05-01', '2018-06-29', 1, 25190.1680, 0.0000, 311.3200, 25501.4880, '2018-06-26 12:00:26', 'dbo', ''),
(2018050075, 201805, 43, 75, '2018-06-22', 3616, 'ENERGY', 1645, 1603, '2018-06-01', '2018-05-01', '2018-06-29', 42, 39698.0300, 0.0000, 1185.6200, 40883.6500, '2018-06-26 12:00:26', 'dbo', ''),
(2018050076, 201805, 43, 76, '2018-06-22', 3617, 'ENERGY', 1714, 1667, '2018-06-01', '2018-05-01', '2018-06-29', 47, 40505.0100, 0.0000, 1292.2400, 41797.2500, '2018-06-26 12:00:26', 'dbo', ''),
(2018050077, 201805, 43, 77, '2018-06-22', 3618, 'ENERGY', 1358, 1324, '2018-06-01', '2018-05-01', '2018-06-29', 34, 34226.1200, 0.0000, 1015.0300, 35241.1500, '2018-06-26 12:00:26', 'dbo', ''),
(2018050078, 201805, 43, 78, '2018-06-22', 3619, 'ENERGY', 401, 377, '2018-06-01', '2018-05-01', '2018-06-29', 24, 15734.6500, 0.0000, 801.7800, 16536.4300, '2018-06-26 12:00:26', 'dbo', ''),
(2018050079, 201805, 43, 79, '2018-06-22', 3620, 'ENERGY', 46037, 45310, '2018-06-01', '2018-05-01', '2018-06-29', 727, 758710.9800, 0.0000, 15792.6400, 774503.6200, '2018-06-26 12:00:27', 'dbo', ''),
(2018050080, 201805, 43, 80, '2018-06-22', 3621, 'ENERGY', 311, 311, '2018-06-01', '2018-05-01', '2018-06-29', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2018-06-26 12:00:27', 'dbo', ''),
(2018050081, 201805, 43, 81, '2018-06-22', 3622, 'ENERGY', 1684, 1624, '2018-06-01', '2018-05-01', '2018-06-29', 60, 36956.9800, 0.0000, 1569.4600, 38526.4400, '2018-06-26 12:00:27', 'dbo', ''),
(2018050082, 201805, 43, 82, '2018-06-22', 3623, 'ENERGY', 3399, 3249, '2018-06-01', '2018-05-01', '2018-06-29', 150, 69576.3000, 0.0000, 3488.6200, 73064.9200, '2018-06-26 12:00:27', 'dbo', ''),
(2018050083, 201805, 43, 83, '2018-06-22', 3624, 'ENERGY', 91, 82, '2018-06-01', '2018-05-01', '2018-06-29', 9, 6559.0300, 0.0000, 481.9200, 7040.9500, '2018-06-26 12:00:26', 'dbo', ''),
(2018050084, 201805, 43, 84, '2018-06-22', 3625, 'ENERGY', 122, 108, '2018-06-01', '2018-05-01', '2018-06-29', 14, 6815.6500, 0.0000, 588.5400, 7404.1900, '2018-06-26 12:00:27', 'dbo', ''),
(2018050085, 201805, 43, 85, '2018-06-22', 3626, 'ENERGY', 355, 355, '2018-06-01', '2018-05-01', '2018-06-29', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2018-06-26 12:00:27', 'dbo', ''),
(2018050086, 201805, 43, 86, '2018-06-22', 3627, 'ENERGY', 86, 86, '2018-06-01', '2018-05-01', '2018-06-29', 0, 6311.3700, 0.0000, 0.0000, 6311.3700, '2018-06-26 12:00:27', 'dbo', ''),
(2018060001, 201806, 44, 1, '2018-07-16', 3628, 'ENERGY', 14016, 14016, '2018-07-01', '2018-06-01', '2018-07-23', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2018-07-16 16:57:35', 'dbo', ''),
(2018060002, 201806, 44, 2, '2018-07-16', 3629, 'ENERGY', 7081, 7081, '2018-07-01', '2018-06-01', '2018-07-23', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2018-07-16 16:57:35', 'dbo', ''),
(2018060003, 201806, 44, 3, '2018-07-16', 3630, 'ENERGY', 8948, 8948, '2018-07-01', '2018-06-01', '2018-07-23', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2018-07-16 16:57:35', 'dbo', ''),
(2018060004, 201806, 44, 4, '2018-07-16', 3631, 'ENERGY', 6711, 6711, '2018-07-01', '2018-06-01', '2018-07-23', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2018-07-16 16:57:35', 'dbo', ''),
(2018060005, 201806, 44, 5, '2018-07-16', 3632, 'ENERGY', 5255, 5255, '2018-07-01', '2018-06-01', '2018-07-23', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2018-07-16 16:57:35', 'dbo', ''),
(2018060006, 201806, 44, 6, '2018-07-16', 3633, 'ENERGY', 13833, 13833, '2018-07-01', '2018-06-01', '2018-07-23', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2018-07-16 16:57:35', 'dbo', ''),
(2018060007, 201806, 44, 7, '2018-07-16', 3634, 'ENERGY', 9652, 9652, '2018-07-01', '2018-06-01', '2018-07-23', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2018-07-16 16:57:35', 'dbo', ''),
(2018060008, 201806, 44, 8, '2018-07-16', 3635, 'ENERGY', 167, 167, '2018-07-01', '2018-06-01', '2018-07-23', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2018-07-16 16:57:35', 'dbo', ''),
(2018060009, 201806, 44, 9, '2018-07-16', 3636, 'ENERGY', 10070, 9086, '2018-07-01', '2018-06-01', '2018-07-23', 984, 200094.8264, 0.0000, 21185.3500, 221280.1764, '2018-07-16 16:57:34', 'dbo', ''),
(2018060010, 201806, 44, 10, '2018-07-16', 3637, 'ENERGY', 744, 715, '2018-07-01', '2018-06-01', '2018-07-23', 29, 21915.0680, 0.0000, 905.8200, 22820.8880, '2018-07-16 16:57:34', 'dbo', ''),
(2018060011, 201806, 44, 11, '2018-07-16', 3638, 'ENERGY', 201, 201, '2018-07-01', '2018-06-01', '2018-07-23', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2018-07-16 16:57:35', 'dbo', ''),
(2018060012, 201806, 44, 12, '2018-07-16', 3639, 'ENERGY', 137, 137, '2018-07-01', '2018-06-01', '2018-07-23', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2018-07-16 16:57:35', 'dbo', ''),
(2018060013, 201806, 44, 13, '2018-07-16', 3640, 'ENERGY', 14465, 13391, '2018-07-01', '2018-06-01', '2018-07-23', 1074, 277150.9340, 0.0000, 23096.5300, 300247.4640, '2018-07-16 16:57:34', 'dbo', ''),
(2018060014, 201806, 44, 14, '2018-07-16', 3641, 'ENERGY', 6760, 6071, '2018-07-01', '2018-06-01', '2018-07-23', 689, 133315.5454, 0.0000, 14920.9900, 148236.5354, '2018-07-16 16:57:34', 'dbo', ''),
(2018060015, 201806, 44, 15, '2018-07-16', 3642, 'ENERGY', 162, 162, '2018-07-01', '2018-06-01', '2018-07-23', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2018-07-16 16:57:35', 'dbo', ''),
(2018060016, 201806, 44, 16, '2018-07-16', 3643, 'ENERGY', 11114, 10676, '2018-07-01', '2018-06-01', '2018-07-23', 438, 219965.3620, 0.0000, 9590.9800, 229556.3420, '2018-07-16 16:57:34', 'dbo', ''),
(2018060017, 201806, 44, 17, '2018-07-16', 3644, 'ENERGY', 31464, 29199, '2018-07-01', '2018-06-01', '2018-07-23', 2265, 580814.1670, 0.0000, 48387.5300, 629201.6970, '2018-07-16 16:57:34', 'dbo', ''),
(2018060018, 201806, 44, 18, '2018-07-16', 3645, 'ENERGY', 8341, 7987, '2018-07-01', '2018-06-01', '2018-07-23', 354, 163501.7800, 0.0000, 7807.2300, 171309.0100, '2018-07-16 16:57:34', 'dbo', ''),
(2018060019, 201806, 44, 19, '2018-07-16', 3646, 'ENERGY', 75, 75, '2018-07-01', '2018-06-01', '2018-07-23', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2018-07-16 16:57:35', 'dbo', ''),
(2018060020, 201806, 44, 20, '2018-07-16', 3647, 'ENERGY', 254, 254, '2018-07-01', '2018-06-01', '2018-07-23', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2018-07-16 16:57:35', 'dbo', ''),
(2018060021, 201806, 44, 21, '2018-07-16', 3648, 'ENERGY', 48339, 47777, '2018-07-01', '2018-06-01', '2018-07-23', 562, 670992.9946, 0.0000, 12224.1400, 683217.1346, '2018-07-16 16:57:34', 'dbo', ''),
(2018060022, 201806, 44, 22, '2018-07-16', 3649, 'ENERGY', 28867, 28414, '2018-07-01', '2018-06-01', '2018-07-23', 453, 401310.8216, 0.0000, 9909.5000, 411220.3216, '2018-07-16 16:57:34', 'dbo', ''),
(2018060023, 201806, 44, 23, '2018-07-16', 3650, 'ENERGY', 77091, 76291, '2018-07-01', '2018-06-01', '2018-07-23', 800, 1118855.8070, 0.0000, 17278.0900, 1136133.8970, '2018-07-16 16:57:34', 'dbo', ''),
(2018060024, 201806, 44, 24, '2018-07-16', 3651, 'ENERGY', 47033, 46673, '2018-07-01', '2018-06-01', '2018-07-23', 360, 607365.0000, 0.0000, 7934.6400, 615299.6400, '2018-07-16 16:57:34', 'dbo', ''),
(2018060025, 201806, 44, 25, '2018-07-16', 3652, 'ENERGY', 96913, 92698, '2018-07-01', '2018-06-01', '2018-07-23', 4215, 1821771.2400, 0.0000, 89796.0100, 1911567.2500, '2018-07-16 16:57:34', 'dbo', ''),
(2018060026, 201806, 44, 26, '2018-07-16', 3653, 'ENERGY', 71355, 69996, '2018-07-01', '2018-06-01', '2018-07-23', 1359, 1187654.6574, 0.0000, 29148.5200, 1216803.1774, '2018-07-16 16:57:34', 'dbo', ''),
(2018060029, 201806, 44, 29, '2018-07-16', 3654, 'ENERGY', 99980, 98123, '2018-07-01', '2018-06-01', '2018-07-23', 1857, 1575978.5888, 0.0000, 39723.6100, 1615702.1988, '2018-07-16 16:57:34', 'dbo', ''),
(2018060030, 201806, 44, 30, '2018-07-16', 3655, 'ENERGY', 48612, 47734, '2018-07-01', '2018-06-01', '2018-07-23', 878, 662679.8812, 0.0000, 18934.4300, 681614.3112, '2018-07-16 16:57:34', 'dbo', ''),
(2018060031, 201806, 44, 31, '2018-07-16', 3656, 'ENERGY', 79350, 77749, '2018-07-01', '2018-06-01', '2018-07-23', 1601, 1282691.8480, 0.0000, 34287.4200, 1316979.2680, '2018-07-16 16:57:35', 'dbo', ''),
(2018060032, 201806, 44, 32, '2018-07-16', 3657, 'ENERGY', 131160, 127981, '2018-07-01', '2018-06-01', '2018-07-23', 3179, 2119029.1390, 0.0000, 67796.4400, 2186825.5790, '2018-07-16 16:57:35', 'dbo', ''),
(2018060033, 201806, 44, 33, '2018-07-16', 3658, 'ENERGY', 18133, 17357, '2018-07-01', '2018-06-01', '2018-07-23', 776, 311104.1934, 0.0000, 16768.4500, 327872.6434, '2018-07-16 16:57:34', 'dbo', ''),
(2018060034, 201806, 44, 34, '2018-07-16', 3659, 'ENERGY', 12921, 12916, '2018-07-01', '2018-06-01', '2018-07-23', 5, 238731.5642, 0.0000, 396.1700, 239127.7342, '2018-07-16 16:57:34', 'dbo', ''),
(2018060035, 201806, 44, 35, '2018-07-16', 3660, 'ENERGY', 19293, 18927, '2018-07-01', '2018-06-01', '2018-07-23', 366, 315995.6226, 0.0000, 8062.0600, 324057.6826, '2018-07-16 16:57:34', 'dbo', ''),
(2018060036, 201806, 44, 36, '2018-07-16', 3661, 'ENERGY', 49594, 49166, '2018-07-01', '2018-06-01', '2018-07-23', 428, 860158.0838, 0.0000, 9378.6200, 869536.7038, '2018-07-16 16:57:34', 'dbo', ''),
(2018060037, 201806, 44, 37, '2018-07-16', 3662, 'ENERGY', 25221, 24510, '2018-07-01', '2018-06-01', '2018-07-23', 711, 403842.5510, 0.0000, 15388.1700, 419230.7210, '2018-07-16 16:57:34', 'dbo', ''),
(2018060038, 201806, 44, 38, '2018-07-16', 3663, 'ENERGY', 13587, 13161, '2018-07-01', '2018-06-01', '2018-07-23', 426, 232068.8534, 0.0000, 9336.1600, 241405.0134, '2018-07-16 16:57:34', 'dbo', ''),
(2018060039, 201806, 44, 39, '2018-07-16', 3664, 'ENERGY', 29424, 28960, '2018-07-01', '2018-06-01', '2018-07-23', 464, -122998.9518, 0.0000, 10143.1000, -112855.8518, '2018-07-16 16:57:34', 'dbo', ''),
(2018060040, 201806, 44, 40, '2018-07-16', 3665, 'ENERGY', 32256, 31024, '2018-07-01', '2018-06-01', '2018-07-23', 1232, 550091.8796, 0.0000, 26451.6700, 576543.5496, '2018-07-16 16:57:34', 'dbo', ''),
(2018060041, 201806, 44, 41, '2018-07-16', 3666, 'ENERGY', 241, 241, '2018-07-01', '2018-06-01', '2018-07-23', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2018-07-16 16:57:35', 'dbo', ''),
(2018060042, 201806, 44, 42, '2018-07-16', 3667, 'ENERGY', 334, 334, '2018-07-01', '2018-06-01', '2018-07-23', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2018-07-16 16:57:35', 'dbo', ''),
(2018060043, 201806, 44, 43, '2018-07-16', 3668, 'ENERGY', 79395, 78130, '2018-07-01', '2018-06-01', '2018-07-23', 1265, 1179430.9502, 0.0000, 27152.4200, 1206583.3702, '2018-07-16 16:57:34', 'dbo', ''),
(2018060044, 201806, 44, 44, '2018-07-16', 3669, 'ENERGY', 45143, 44085, '2018-07-01', '2018-06-01', '2018-07-23', 1058, 834836.8430, 0.0000, 22756.7600, 857593.6030, '2018-07-16 16:57:34', 'dbo', ''),
(2018060045, 201806, 44, 45, '2018-07-16', 3670, 'ENERGY', 36882, 36269, '2018-07-01', '2018-06-01', '2018-07-23', 613, 408895.3120, 0.0000, 13307.1300, 422202.4420, '2018-07-16 16:57:34', 'dbo', ''),
(2018060046, 201806, 44, 46, '2018-07-16', 3671, 'ENERGY', 58182, 56995, '2018-07-01', '2018-06-01', '2018-07-23', 1187, 1019967.9554, 0.0000, 25496.0900, 1045464.0454, '2018-07-16 16:57:34', 'dbo', ''),
(2018060047, 201806, 44, 47, '2018-07-16', 3672, 'ENERGY', 29220, 28583, '2018-07-01', '2018-06-01', '2018-07-23', 637, 396686.1510, 0.0000, 13816.7700, 410502.9210, '2018-07-16 16:57:34', 'dbo', ''),
(2018060048, 201806, 44, 48, '2018-07-16', 3673, 'ENERGY', 18295, 17346, '2018-07-01', '2018-06-01', '2018-07-23', 949, 344921.3900, 0.0000, 20442.1300, 365363.5200, '2018-07-16 16:57:34', 'dbo', ''),
(2018060049, 201806, 44, 49, '2018-07-16', 3674, 'ENERGY', 7220, 7002, '2018-07-01', '2018-06-01', '2018-07-23', 218, 124435.8790, 0.0000, 4919.2600, 129355.1390, '2018-07-16 16:57:34', 'dbo', ''),
(2018060050, 201806, 44, 50, '2018-07-16', 3675, 'ENERGY', 96331, 94514, '2018-07-01', '2018-06-01', '2018-07-23', 1817, 1498047.8692, 0.0000, 38874.2100, 1536922.0792, '2018-07-16 16:57:34', 'dbo', ''),
(2018060051, 201806, 44, 51, '2018-07-16', 3676, 'ENERGY', 211, 211, '2018-07-01', '2018-06-01', '2018-07-23', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2018-07-16 16:57:35', 'dbo', ''),
(2018060052, 201806, 44, 52, '2018-07-16', 3677, 'ENERGY', 321, 321, '2018-07-01', '2018-06-01', '2018-07-23', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2018-07-16 16:57:35', 'dbo', ''),
(2018060053, 201806, 44, 53, '2018-07-16', 3678, 'ENERGY', 3802, 3269, '2018-07-01', '2018-06-01', '2018-07-23', 533, 73760.9270, 0.0000, 11608.3200, 85369.2470, '2018-07-16 16:57:35', 'dbo', ''),
(2018060054, 201806, 44, 54, '2018-07-16', 3679, 'ENERGY', 34936, 34063, '2018-07-01', '2018-06-01', '2018-07-23', 873, 402727.5494, 0.0000, 18828.2500, 421555.7994, '2018-07-16 16:57:35', 'dbo', ''),
(2018060055, 201806, 44, 55, '2018-07-16', 3680, 'ENERGY', 12689, 12689, '2018-07-01', '2018-06-01', '2018-07-23', 0, 239408.7700, 0.0000, 0.0000, 239408.7700, '2018-07-16 16:57:35', 'dbo', ''),
(2018060056, 201806, 44, 56, '2018-07-16', 3681, 'ENERGY', 752, 634, '2018-07-01', '2018-06-01', '2018-07-23', 118, 18712.8090, 0.0000, 2795.7500, 21508.5590, '2018-07-16 16:57:35', 'dbo', ''),
(2018060059, 201806, 44, 59, '2018-07-16', 3682, 'ENERGY', 128, 128, '2018-07-01', '2018-06-01', '2018-07-23', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2018-07-16 16:57:35', 'dbo', ''),
(2018060060, 201806, 44, 60, '2018-07-16', 3683, 'ENERGY', 274193, 266871, '2018-07-01', '2018-06-01', '2018-07-23', 7322, 3789567.2700, 0.0000, 155773.5300, 3945340.8000, '2018-07-16 16:57:34', 'dbo', ''),
(2018060061, 201806, 44, 61, '2018-07-16', 3684, 'ENERGY', 16, 16, '2018-07-01', '2018-06-01', '2018-07-23', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2018-07-16 16:57:35', 'dbo', ''),
(2018060062, 201806, 44, 62, '2018-07-16', 3685, 'ENERGY', 30, 30, '2018-07-01', '2018-06-01', '2018-07-23', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-07-16 16:57:35', 'dbo', ''),
(2018060063, 201806, 44, 63, '2018-07-16', 3686, 'ENERGY', 1, 1, '2018-07-01', '2018-06-01', '2018-07-23', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-07-16 16:57:35', 'dbo', ''),
(2018060064, 201806, 44, 64, '2018-07-16', 3687, 'ENERGY', 2, 2, '2018-07-01', '2018-06-01', '2018-07-23', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-07-16 16:57:35', 'dbo', ''),
(2018060065, 201806, 44, 65, '2018-07-16', 3688, 'ENERGY', 10967, 10537, '2018-07-01', '2018-06-01', '2018-07-23', 430, 211779.2480, 0.0000, 9421.1000, 221200.3480, '2018-07-16 16:57:34', 'dbo', ''),
(2018060066, 201806, 44, 66, '2018-07-16', 3689, 'ENERGY', 7436, 7066, '2018-07-01', '2018-06-01', '2018-07-23', 370, 140927.6824, 0.0000, 8147.0000, 149074.6824, '2018-07-16 16:57:34', 'dbo', ''),
(2018060067, 201806, 44, 67, '2018-07-16', 3690, 'ENERGY', 985, 947, '2018-07-01', '2018-06-01', '2018-07-23', 38, 26604.0238, 0.0000, 1096.9300, 27700.9538, '2018-07-16 16:57:35', 'dbo', ''),
(2018060068, 201806, 44, 68, '2018-07-16', 3691, 'ENERGY', 2153, 2004, '2018-07-01', '2018-06-01', '2018-07-23', 149, 48111.1500, 0.0000, 3454.0400, 51565.1900, '2018-07-16 16:57:35', 'dbo', ''),
(2018060069, 201806, 44, 69, '2018-07-16', 3692, 'ENERGY', 1, 1, '2018-07-01', '2018-06-01', '2018-07-23', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2018-07-16 16:57:35', 'dbo', ''),
(2018060070, 201806, 44, 70, '2018-07-16', 3693, 'ENERGY', 1567, 1368, '2018-07-01', '2018-06-01', '2018-07-23', 199, 35486.9600, 0.0000, 4515.8000, 40002.7600, '2018-07-16 16:57:35', 'dbo', ''),
(2018060071, 201806, 44, 71, '2018-07-16', 3694, 'ENERGY', 205646, 197264, '2018-07-01', '2018-06-01', '2018-07-23', 8382, 3719546.9062, 0.0000, 178282.7400, 3897829.6462, '2018-07-16 16:57:34', 'dbo', ''),
(2018060072, 201806, 44, 72, '2018-07-16', 3695, 'ENERGY', 1760, 1721, '2018-07-01', '2018-06-01', '2018-07-23', 39, 43391.8600, 0.0000, 1118.1700, 44510.0300, '2018-07-16 16:57:34', 'dbo', ''),
(2018060073, 201806, 44, 73, '2018-07-16', 3696, 'ENERGY', 474, 471, '2018-07-01', '2018-06-01', '2018-07-23', 3, 25501.4880, 0.0000, 353.7000, 25855.1880, '2018-07-16 16:57:34', 'dbo', ''),
(2018060075, 201806, 44, 75, '2018-07-16', 3697, 'ENERGY', 1672, 1645, '2018-07-01', '2018-06-01', '2018-07-23', 27, 40883.6500, 0.0000, 863.3400, 41746.9900, '2018-07-16 16:57:34', 'dbo', ''),
(2018060076, 201806, 44, 76, '2018-07-16', 3698, 'ENERGY', 1751, 1714, '2018-07-01', '2018-06-01', '2018-07-23', 37, 41797.2500, 0.0000, 1075.7100, 42872.9600, '2018-07-16 16:57:34', 'dbo', ''),
(2018060077, 201806, 44, 77, '2018-07-16', 3699, 'ENERGY', 1385, 1358, '2018-07-01', '2018-06-01', '2018-07-23', 27, 35241.1500, 0.0000, 863.3400, 36104.4900, '2018-07-16 16:57:34', 'dbo', ''),
(2018060078, 201806, 44, 78, '2018-07-16', 3700, 'ENERGY', 401, 401, '2018-07-01', '2018-06-01', '2018-07-23', 0, 16536.4300, 0.0000, 0.0000, 16536.4300, '2018-07-16 16:57:35', 'dbo', ''),
(2018060079, 201806, 44, 79, '2018-07-16', 3701, 'ENERGY', 46622, 46037, '2018-07-01', '2018-06-01', '2018-07-23', 585, 774503.6200, 0.0000, 12712.5500, 787216.1700, '2018-07-16 16:57:34', 'dbo', ''),
(2018060080, 201806, 44, 80, '2018-07-16', 3702, 'ENERGY', 311, 311, '2018-07-01', '2018-06-01', '2018-07-23', 0, 4281.9800, 0.0000, 0.0000, 4281.9800, '2018-07-16 16:57:35', 'dbo', ''),
(2018060081, 201806, 44, 81, '2018-07-16', 3703, 'ENERGY', 1731, 1684, '2018-07-01', '2018-06-01', '2018-07-23', 47, 38526.4400, 0.0000, 1288.0500, 39814.4900, '2018-07-16 16:57:34', 'dbo', ''),
(2018060082, 201806, 44, 82, '2018-07-16', 3704, 'ENERGY', 3518, 3399, '2018-07-01', '2018-06-01', '2018-07-23', 119, 73064.9200, 0.0000, 2816.9800, 75881.9000, '2018-07-16 16:57:34', 'dbo', ''),
(2018060083, 201806, 44, 83, '2018-07-16', 3705, 'ENERGY', 95, 91, '2018-07-01', '2018-06-01', '2018-07-23', 4, 7040.9500, 0.0000, 374.9400, 7415.8900, '2018-07-16 16:57:34', 'dbo', ''),
(2018060084, 201806, 44, 84, '2018-07-16', 3706, 'ENERGY', 134, 122, '2018-07-01', '2018-06-01', '2018-07-23', 12, 7404.1900, 0.0000, 544.8300, 7949.0200, '2018-07-16 16:57:34', 'dbo', ''),
(2018060085, 201806, 44, 85, '2018-07-16', 3707, 'ENERGY', 355, 355, '2018-07-01', '2018-06-01', '2018-07-23', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2018-07-16 16:57:35', 'dbo', ''),
(2018060086, 201806, 44, 86, '2018-07-16', 3708, 'ENERGY', 88, 86, '2018-07-01', '2018-06-01', '2018-07-23', 2, 6311.3700, 0.0000, 332.4700, 6643.8400, '2018-07-16 16:57:34', 'dbo', ''),
(2018070001, 201807, 45, 1, '2018-08-03', 3709, 'ENERGY', 14016, 14016, '2018-08-01', '2018-07-01', '2018-08-10', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2018-08-03 09:46:08', 'dbo', ''),
(2018070002, 201807, 45, 2, '2018-08-03', 3710, 'ENERGY', 7081, 7081, '2018-08-01', '2018-07-01', '2018-08-10', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2018-08-03 09:46:08', 'dbo', ''),
(2018070003, 201807, 45, 3, '2018-08-03', 3711, 'ENERGY', 8948, 8948, '2018-08-01', '2018-07-01', '2018-08-10', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2018-08-03 09:46:08', 'dbo', ''),
(2018070004, 201807, 45, 4, '2018-08-03', 3712, 'ENERGY', 6711, 6711, '2018-08-01', '2018-07-01', '2018-08-10', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2018-08-03 09:46:08', 'dbo', ''),
(2018070005, 201807, 45, 5, '2018-08-03', 3713, 'ENERGY', 5255, 5255, '2018-08-01', '2018-07-01', '2018-08-10', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2018-08-03 09:46:08', 'dbo', ''),
(2018070006, 201807, 45, 6, '2018-08-03', 3714, 'ENERGY', 13833, 13833, '2018-08-01', '2018-07-01', '2018-08-10', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2018-08-03 09:46:08', 'dbo', ''),
(2018070007, 201807, 45, 7, '2018-08-03', 3715, 'ENERGY', 9652, 9652, '2018-08-01', '2018-07-01', '2018-08-10', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2018-08-03 09:46:08', 'dbo', ''),
(2018070008, 201807, 45, 8, '2018-08-03', 3716, 'ENERGY', 167, 167, '2018-08-01', '2018-07-01', '2018-08-10', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2018-08-03 09:46:08', 'dbo', ''),
(2018070009, 201807, 45, 9, '2018-08-03', 3717, 'ENERGY', 10632, 10070, '2018-08-01', '2018-07-01', '2018-08-10', 562, 221280.1764, 0.0000, 12011.5800, 233291.7564, '2018-08-03 09:46:07', 'dbo', ''),
(2018070010, 201807, 45, 10, '2018-08-03', 3718, 'ENERGY', 755, 744, '2018-08-01', '2018-07-01', '2018-08-10', 11, 22820.8880, 0.0000, 519.4200, 23340.3080, '2018-08-03 09:46:07', 'dbo', ''),
(2018070011, 201807, 45, 11, '2018-08-03', 3719, 'ENERGY', 201, 201, '2018-08-01', '2018-07-01', '2018-08-10', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2018-08-03 09:46:08', 'dbo', ''),
(2018070012, 201807, 45, 12, '2018-08-03', 3720, 'ENERGY', 137, 137, '2018-08-01', '2018-07-01', '2018-08-10', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2018-08-03 09:46:08', 'dbo', ''),
(2018070013, 201807, 45, 13, '2018-08-03', 3721, 'ENERGY', 15839, 14465, '2018-08-01', '2018-07-01', '2018-08-10', 1374, 300247.4640, 0.0000, 28947.3600, 329194.8240, '2018-08-03 09:46:07', 'dbo', ''),
(2018070014, 201807, 45, 14, '2018-08-03', 3722, 'ENERGY', 7618, 6760, '2018-08-01', '2018-07-01', '2018-08-10', 858, 148236.5354, 0.0000, 18185.2000, 166421.7354, '2018-08-03 09:46:07', 'dbo', ''),
(2018070015, 201807, 45, 15, '2018-08-03', 3723, 'ENERGY', 162, 162, '2018-08-01', '2018-07-01', '2018-08-10', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2018-08-03 09:46:08', 'dbo', ''),
(2018070016, 201807, 45, 16, '2018-08-03', 3724, 'ENERGY', 11597, 11114, '2018-08-01', '2018-07-01', '2018-08-10', 483, 229556.3420, 0.0000, 10363.8800, 239920.2220, '2018-08-03 09:46:07', 'dbo', ''),
(2018070017, 201807, 45, 17, '2018-08-03', 3725, 'ENERGY', 34521, 31464, '2018-08-01', '2018-07-01', '2018-08-10', 3057, 629201.6970, 0.0000, 64049.4900, 693251.1870, '2018-08-03 09:46:07', 'dbo', ''),
(2018070018, 201807, 45, 18, '2018-08-03', 3726, 'ENERGY', 8838, 8341, '2018-08-01', '2018-07-01', '2018-08-10', 497, 171309.0100, 0.0000, 10655.8700, 181964.8800, '2018-08-03 09:46:07', 'dbo', ''),
(2018070019, 201807, 45, 19, '2018-08-03', 3727, 'ENERGY', 75, 75, '2018-08-01', '2018-07-01', '2018-08-10', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2018-08-03 09:46:08', 'dbo', ''),
(2018070020, 201807, 45, 20, '2018-08-03', 3728, 'ENERGY', 254, 254, '2018-08-01', '2018-07-01', '2018-08-10', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2018-08-03 09:46:08', 'dbo', ''),
(2018070021, 201807, 45, 21, '2018-08-03', 3729, 'ENERGY', 48754, 48339, '2018-08-01', '2018-07-01', '2018-08-10', 415, 683217.1346, 0.0000, 8945.6000, 692162.7346, '2018-08-03 09:46:07', 'dbo', ''),
(2018070022, 201807, 45, 22, '2018-08-03', 3730, 'ENERGY', 29187, 28867, '2018-08-01', '2018-07-01', '2018-08-10', 320, 411220.3216, 0.0000, 6964.2000, 418184.5216, '2018-08-03 09:46:07', 'dbo', ''),
(2018070023, 201807, 45, 23, '2018-08-03', 3731, 'ENERGY', 77425, 77091, '2018-08-01', '2018-07-01', '2018-08-10', 334, 1136133.8970, 0.0000, 7256.2000, 1143390.0970, '2018-08-03 09:46:07', 'dbo', ''),
(2018070024, 201807, 45, 24, '2018-08-03', 3732, 'ENERGY', 47443, 47033, '2018-08-01', '2018-07-01', '2018-08-10', 410, 615299.6400, 0.0000, 8841.3200, 624140.9600, '2018-08-03 09:46:07', 'dbo', ''),
(2018070025, 201807, 45, 25, '2018-08-03', 3733, 'ENERGY', 101783, 96913, '2018-08-01', '2018-07-01', '2018-08-10', 4870, 1911567.2500, 0.0000, 101863.0200, 2013430.2700, '2018-08-03 09:46:07', 'dbo', ''),
(2018070026, 201807, 45, 26, '2018-08-03', 3734, 'ENERGY', 73227, 71355, '2018-08-01', '2018-07-01', '2018-08-10', 1872, 1216803.1774, 0.0000, 39334.0900, 1256137.2674, '2018-08-03 09:46:07', 'dbo', ''),
(2018070029, 201807, 45, 29, '2018-08-03', 3735, 'ENERGY', 102025, 99980, '2018-08-01', '2018-07-01', '2018-08-10', 2045, 1615702.1988, 0.0000, 42942.3400, 1658644.5388, '2018-08-03 09:46:07', 'dbo', ''),
(2018070030, 201807, 45, 30, '2018-08-03', 3736, 'ENERGY', 49698, 48612, '2018-08-01', '2018-07-01', '2018-08-10', 1086, 681614.3112, 0.0000, 22940.5800, 704554.8912, '2018-08-03 09:46:07', 'dbo', ''),
(2018070031, 201807, 45, 31, '2018-08-03', 3737, 'ENERGY', 81066, 79350, '2018-08-01', '2018-07-01', '2018-08-10', 1716, 1316979.2680, 0.0000, 36080.4100, 1353059.6780, '2018-08-03 09:46:07', 'dbo', ''),
(2018070032, 201807, 45, 32, '2018-08-03', 3738, 'ENERGY', 134601, 131160, '2018-08-01', '2018-07-01', '2018-08-10', 3441, 2186825.5790, 0.0000, 72058.5400, 2258884.1190, '2018-08-03 09:46:07', 'dbo', ''),
(2018070033, 201807, 45, 33, '2018-08-03', 3739, 'ENERGY', 18938, 18133, '2018-08-01', '2018-07-01', '2018-08-10', 805, 327872.6434, 0.0000, 17079.7900, 344952.4334, '2018-08-03 09:46:07', 'dbo', ''),
(2018070034, 201807, 45, 34, '2018-08-03', 3740, 'ENERGY', 12921, 12921, '2018-08-01', '2018-07-01', '2018-08-10', 0, 239127.7342, 0.0000, 0.0000, 239127.7342, '2018-08-03 09:46:08', 'dbo', ''),
(2018070035, 201807, 45, 35, '2018-08-03', 3741, 'ENERGY', 19711, 19293, '2018-08-01', '2018-07-01', '2018-08-10', 418, 324057.6826, 0.0000, 9008.1700, 333065.8526, '2018-08-03 09:46:07', 'dbo', ''),
(2018070036, 201807, 45, 36, '2018-08-03', 3742, 'ENERGY', 50041, 49594, '2018-08-01', '2018-07-01', '2018-08-10', 447, 869536.7038, 0.0000, 9613.0300, 879149.7338, '2018-08-03 09:46:07', 'dbo', ''),
(2018070037, 201807, 45, 37, '2018-08-03', 3743, 'ENERGY', 25955, 25221, '2018-08-01', '2018-07-01', '2018-08-10', 734, 419230.7210, 0.0000, 15598.9600, 434829.6810, '2018-08-03 09:46:07', 'dbo', ''),
(2018070038, 201807, 45, 38, '2018-08-03', 3744, 'ENERGY', 14476, 13587, '2018-08-01', '2018-07-01', '2018-08-10', 889, 241405.0134, 0.0000, 18831.7700, 260236.7834, '2018-08-03 09:46:07', 'dbo', ''),
(2018070039, 201807, 45, 39, '2018-08-03', 3745, 'ENERGY', 29991, 29424, '2018-08-01', '2018-07-01', '2018-08-10', 567, -112855.8518, 0.0000, 12115.8500, -100740.0018, '2018-08-03 09:46:07', 'dbo', ''),
(2018070040, 201807, 45, 40, '2018-08-03', 3746, 'ENERGY', 33930, 32256, '2018-08-01', '2018-07-01', '2018-08-10', 1674, 576543.5496, 0.0000, 35204.4200, 611747.9696, '2018-08-03 09:46:07', 'dbo', ''),
(2018070041, 201807, 45, 41, '2018-08-03', 3747, 'ENERGY', 241, 241, '2018-08-01', '2018-07-01', '2018-08-10', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2018-08-03 09:46:08', 'dbo', ''),
(2018070042, 201807, 45, 42, '2018-08-03', 3748, 'ENERGY', 334, 334, '2018-08-01', '2018-07-01', '2018-08-10', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2018-08-03 09:46:08', 'dbo', ''),
(2018070043, 201807, 45, 43, '2018-08-03', 3749, 'ENERGY', 81066, 79395, '2018-08-01', '2018-07-01', '2018-08-10', 1671, 1206583.3702, 0.0000, 35141.8500, 1241725.2202, '2018-08-03 09:46:07', 'dbo', ''),
(2018070044, 201807, 45, 44, '2018-08-03', 3750, 'ENERGY', 46263, 45143, '2018-08-01', '2018-07-01', '2018-08-10', 1120, 857593.6030, 0.0000, 23649.7100, 881243.3130, '2018-08-03 09:46:07', 'dbo', ''),
(2018070045, 201807, 45, 45, '2018-08-03', 3751, 'ENERGY', 37617, 36882, '2018-08-01', '2018-07-01', '2018-08-10', 735, 422202.4420, 0.0000, 15619.8200, 437822.2620, '2018-08-03 09:46:07', 'dbo', ''),
(2018070046, 201807, 45, 46, '2018-08-03', 3752, 'ENERGY', 59505, 58182, '2018-08-01', '2018-07-01', '2018-08-10', 1323, 1045464.0454, 0.0000, 27883.6600, 1073347.7054, '2018-08-03 09:46:07', 'dbo', ''),
(2018070047, 201807, 45, 47, '2018-08-03', 3753, 'ENERGY', 30179, 29220, '2018-08-01', '2018-07-01', '2018-08-10', 959, 410502.9210, 0.0000, 20291.7600, 430794.6810, '2018-08-03 09:46:07', 'dbo', ''),
(2018070048, 201807, 45, 48, '2018-08-03', 3754, 'ENERGY', 19553, 18295, '2018-08-01', '2018-07-01', '2018-08-10', 1258, 365363.5200, 0.0000, 26527.9500, 391891.4700, '2018-08-03 09:46:07', 'dbo', ''),
(2018070049, 201807, 45, 49, '2018-08-03', 3755, 'ENERGY', 7496, 7220, '2018-08-01', '2018-07-01', '2018-08-10', 276, 129355.1390, 0.0000, 6046.5000, 135401.6390, '2018-08-03 09:46:07', 'dbo', ''),
(2018070050, 201807, 45, 50, '2018-08-03', 3756, 'ENERGY', 98271, 96331, '2018-08-01', '2018-07-01', '2018-08-10', 1940, 1536922.0792, 0.0000, 40752.3600, 1577674.4392, '2018-08-03 09:46:07', 'dbo', ''),
(2018070051, 201807, 45, 51, '2018-08-03', 3757, 'ENERGY', 211, 211, '2018-08-01', '2018-07-01', '2018-08-10', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2018-08-03 09:46:08', 'dbo', ''),
(2018070052, 201807, 45, 52, '2018-08-03', 3758, 'ENERGY', 321, 321, '2018-08-01', '2018-07-01', '2018-08-10', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2018-08-03 09:46:08', 'dbo', ''),
(2018070053, 201807, 45, 53, '2018-08-03', 3759, 'ENERGY', 4391, 3802, '2018-08-01', '2018-07-01', '2018-08-10', 589, 85369.2470, 0.0000, 12574.7100, 97943.9570, '2018-08-03 09:46:07', 'dbo', ''),
(2018070054, 201807, 45, 54, '2018-08-03', 3760, 'ENERGY', 35859, 34936, '2018-08-01', '2018-07-01', '2018-08-10', 923, 421555.7994, 0.0000, 19540.9100, 441096.7094, '2018-08-03 09:46:07', 'dbo', ''),
(2018070055, 201807, 45, 55, '2018-08-03', 3761, 'ENERGY', 12689, 12689, '2018-08-01', '2018-07-01', '2018-08-10', 0, 239408.7700, 0.0000, 0.0000, 239408.7700, '2018-08-03 09:46:08', 'dbo', ''),
(2018070056, 201807, 45, 56, '2018-08-03', 3762, 'ENERGY', 1119, 752, '2018-08-01', '2018-07-01', '2018-08-10', 367, 21508.5590, 0.0000, 7944.4900, 29453.0490, '2018-08-03 09:46:07', 'dbo', ''),
(2018070059, 201807, 45, 59, '2018-08-03', 3763, 'ENERGY', 128, 128, '2018-08-01', '2018-07-01', '2018-08-10', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2018-08-03 09:46:08', 'dbo', ''),
(2018070060, 201807, 45, 60, '2018-08-03', 3764, 'ENERGY', 281811, 274193, '2018-08-01', '2018-07-01', '2018-08-10', 7618, 3945340.8000, 0.0000, 159177.7400, 4104518.5400, '2018-08-03 09:46:07', 'dbo', ''),
(2018070061, 201807, 45, 61, '2018-08-03', 3765, 'ENERGY', 16, 16, '2018-08-01', '2018-07-01', '2018-08-10', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2018-08-03 09:46:08', 'dbo', ''),
(2018070062, 201807, 45, 62, '2018-08-03', 3766, 'ENERGY', 30, 30, '2018-08-01', '2018-07-01', '2018-08-10', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-08-03 09:46:08', 'dbo', ''),
(2018070063, 201807, 45, 63, '2018-08-03', 3767, 'ENERGY', 1, 1, '2018-08-01', '2018-07-01', '2018-08-10', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-08-03 09:46:08', 'dbo', ''),
(2018070064, 201807, 45, 64, '2018-08-03', 3768, 'ENERGY', 2, 2, '2018-08-01', '2018-07-01', '2018-08-10', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-08-03 09:46:08', 'dbo', ''),
(2018070065, 201807, 45, 65, '2018-08-03', 3769, 'ENERGY', 11455, 10967, '2018-08-01', '2018-07-01', '2018-08-10', 488, 221200.3480, 0.0000, 10468.1700, 231668.5180, '2018-08-03 09:46:07', 'dbo', ''),
(2018070066, 201807, 45, 66, '2018-08-03', 3770, 'ENERGY', 8140, 7436, '2018-08-01', '2018-07-01', '2018-08-10', 704, 149074.6824, 0.0000, 14973.2500, 164047.9324, '2018-08-03 09:46:07', 'dbo', ''),
(2018070067, 201807, 45, 67, '2018-08-03', 3771, 'ENERGY', 1028, 985, '2018-08-01', '2018-07-01', '2018-08-10', 43, 27700.9538, 0.0000, 1186.8400, 28887.7938, '2018-08-03 09:46:08', 'dbo', '');
INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2018070068, 201807, 45, 68, '2018-08-03', 3772, 'ENERGY', 2258, 2153, '2018-08-01', '2018-07-01', '2018-08-10', 105, 51565.1900, 0.0000, 2479.9800, 54045.1700, '2018-08-03 09:46:08', 'dbo', ''),
(2018070069, 201807, 45, 69, '2018-08-03', 3773, 'ENERGY', 1, 1, '2018-08-01', '2018-07-01', '2018-08-10', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2018-08-03 09:46:08', 'dbo', ''),
(2018070070, 201807, 45, 70, '2018-08-03', 3774, 'ENERGY', 1765, 1567, '2018-08-01', '2018-07-01', '2018-08-10', 198, 40002.7600, 0.0000, 4419.6500, 44422.4100, '2018-08-03 09:46:08', 'dbo', ''),
(2018070071, 201807, 45, 71, '2018-08-03', 3775, 'ENERGY', 215186, 205646, '2018-08-01', '2018-07-01', '2018-08-10', 9540, 3897829.6462, 0.0000, 199264.6800, 4097094.3262, '2018-08-03 09:46:07', 'dbo', ''),
(2018070072, 201807, 45, 72, '2018-08-03', 3776, 'ENERGY', 1825, 1760, '2018-08-01', '2018-07-01', '2018-08-10', 65, 44510.0300, 0.0000, 1645.7000, 46155.7300, '2018-08-03 09:46:07', 'dbo', ''),
(2018070073, 201807, 45, 73, '2018-08-03', 3777, 'ENERGY', 475, 474, '2018-08-01', '2018-07-01', '2018-08-10', 1, 25855.1880, 0.0000, 310.8700, 26166.0580, '2018-08-03 09:46:07', 'dbo', ''),
(2018070075, 201807, 45, 75, '2018-08-03', 3778, 'ENERGY', 1702, 1672, '2018-08-01', '2018-07-01', '2018-08-10', 30, 41746.9900, 0.0000, 915.7100, 42662.7000, '2018-08-03 09:46:07', 'dbo', ''),
(2018070076, 201807, 45, 76, '2018-08-03', 3779, 'ENERGY', 1791, 1751, '2018-08-01', '2018-07-01', '2018-08-10', 40, 42872.9600, 0.0000, 1124.2800, 43997.2400, '2018-08-03 09:46:07', 'dbo', ''),
(2018070077, 201807, 45, 77, '2018-08-03', 3780, 'ENERGY', 1414, 1385, '2018-08-01', '2018-07-01', '2018-08-10', 29, 36104.4900, 0.0000, 894.8500, 36999.3400, '2018-08-03 09:46:07', 'dbo', ''),
(2018070078, 201807, 45, 78, '2018-08-03', 3781, 'ENERGY', 423, 401, '2018-08-01', '2018-07-01', '2018-08-10', 22, 16536.4300, 0.0000, 748.8600, 17285.2900, '2018-08-03 09:46:07', 'dbo', ''),
(2018070079, 201807, 45, 79, '2018-08-03', 3782, 'ENERGY', 47956, 46622, '2018-08-01', '2018-07-01', '2018-08-10', 1334, 787216.1700, 0.0000, 28113.0800, 815329.2500, '2018-08-03 09:46:07', 'dbo', ''),
(2018070081, 201807, 45, 81, '2018-08-03', 3784, 'ENERGY', 1782, 1731, '2018-08-01', '2018-07-01', '2018-08-10', 51, 39814.4900, 0.0000, 1353.7000, 41168.1900, '2018-08-03 09:46:07', 'dbo', ''),
(2018070082, 201807, 45, 82, '2018-08-03', 3785, 'ENERGY', 3646, 3518, '2018-08-01', '2018-07-01', '2018-08-10', 128, 75881.9000, 0.0000, 2959.6900, 78841.5900, '2018-08-03 09:46:07', 'dbo', ''),
(2018070083, 201807, 45, 83, '2018-08-03', 3786, 'ENERGY', 92, 95, '2018-08-01', '2018-07-01', '2018-08-10', -3, 7415.8900, 0.0000, 227.4300, 7643.3200, '2018-08-03 09:46:07', 'dbo', ''),
(2018070084, 201807, 45, 84, '2018-08-03', 3787, 'ENERGY', 147, 134, '2018-08-01', '2018-07-01', '2018-08-10', 13, 7949.0200, 0.0000, 561.1500, 8510.1700, '2018-08-03 09:46:07', 'dbo', ''),
(2018070085, 201807, 45, 85, '2018-08-03', 3788, 'ENERGY', 355, 355, '2018-08-01', '2018-07-01', '2018-08-10', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2018-08-03 09:46:08', 'dbo', ''),
(2018070086, 201807, 45, 86, '2018-08-03', 3789, 'ENERGY', 100, 88, '2018-08-01', '2018-07-01', '2018-08-10', 12, 6643.8400, 0.0000, 540.2800, 7184.1200, '2018-08-03 09:46:07', 'dbo', ''),
(2018080001, 201808, 46, 1, '2018-09-07', 3790, 'ENERGY', 0, 0, '2018-09-01', '2018-08-01', '2018-09-14', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2018-09-07 18:27:44', 'dbo', ''),
(2018080002, 201808, 46, 2, '2018-09-07', 3791, 'ENERGY', 0, 0, '2018-09-01', '2018-08-01', '2018-09-14', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2018-09-07 18:27:44', 'dbo', ''),
(2018080003, 201808, 46, 3, '2018-09-07', 3792, 'ENERGY', 0, 0, '2018-09-01', '2018-08-01', '2018-09-14', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2018-09-07 18:27:44', 'dbo', ''),
(2018080004, 201808, 46, 4, '2018-09-07', 3793, 'ENERGY', 0, 0, '2018-09-01', '2018-08-01', '2018-09-14', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2018-09-07 18:27:44', 'dbo', ''),
(2018080005, 201808, 46, 5, '2018-09-07', 3794, 'ENERGY', 0, 0, '2018-09-01', '2018-08-01', '2018-09-14', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2018-09-07 18:27:44', 'dbo', ''),
(2018080006, 201808, 46, 6, '2018-09-07', 3795, 'ENERGY', 0, 0, '2018-09-01', '2018-08-01', '2018-09-14', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2018-09-07 18:27:44', 'dbo', ''),
(2018080007, 201808, 46, 7, '2018-09-07', 3796, 'ENERGY', 0, 0, '2018-09-01', '2018-08-01', '2018-09-14', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2018-09-07 18:27:44', 'dbo', ''),
(2018080008, 201808, 46, 8, '2018-09-07', 3797, 'ENERGY', 0, 0, '2018-09-01', '2018-08-01', '2018-09-14', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2018-09-07 18:27:44', 'dbo', ''),
(2018080009, 201808, 46, 9, '2018-09-07', 3798, 'ENERGY', 10798, 10632, '2018-09-01', '2018-08-01', '2018-09-14', 166, 233291.7564, 0.0000, 3322.7800, 236614.5364, '2018-09-07 18:27:43', 'dbo', ''),
(2018080010, 201808, 46, 10, '2018-09-07', 3799, 'ENERGY', 759, 755, '2018-09-01', '2018-08-01', '2018-09-14', 4, 23340.3080, 0.0000, 80.0600, 23420.3680, '2018-09-07 18:27:43', 'dbo', ''),
(2018080011, 201808, 46, 11, '2018-09-07', 3800, 'ENERGY', 201, 201, '2018-09-01', '2018-08-01', '2018-09-14', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2018-09-07 18:27:44', 'dbo', ''),
(2018080012, 201808, 46, 12, '2018-09-07', 3801, 'ENERGY', 137, 137, '2018-09-01', '2018-08-01', '2018-09-14', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2018-09-07 18:27:44', 'dbo', ''),
(2018080013, 201808, 46, 13, '2018-09-07', 3802, 'ENERGY', 17112, 15839, '2018-09-01', '2018-08-01', '2018-09-14', 1273, 329194.8240, 0.0000, 25481.2900, 354676.1140, '2018-09-07 18:27:44', 'dbo', ''),
(2018080014, 201808, 46, 14, '2018-09-07', 3803, 'ENERGY', 8501, 7618, '2018-09-01', '2018-08-01', '2018-09-14', 883, 166421.7354, 0.0000, 17674.7600, 184096.4954, '2018-09-07 18:27:44', 'dbo', ''),
(2018080015, 201808, 46, 15, '2018-09-07', 3804, 'ENERGY', 162, 162, '2018-09-01', '2018-08-01', '2018-09-14', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2018-09-07 18:27:44', 'dbo', ''),
(2018080016, 201808, 46, 16, '2018-09-07', 3805, 'ENERGY', 12059, 11597, '2018-09-01', '2018-08-01', '2018-09-14', 462, 239920.2220, 0.0000, 9247.7300, 249167.9520, '2018-09-07 18:27:44', 'dbo', ''),
(2018080017, 201808, 46, 17, '2018-09-07', 3806, 'ENERGY', 37559, 34521, '2018-09-01', '2018-08-01', '2018-09-14', 3038, 693251.1870, 0.0000, 60810.7900, 754061.9770, '2018-09-07 18:27:43', 'dbo', ''),
(2018080018, 201808, 46, 18, '2018-09-07', 3807, 'ENERGY', 9278, 8838, '2018-09-01', '2018-08-01', '2018-09-14', 440, 181964.8800, 0.0000, 8807.3600, 190772.2400, '2018-09-07 18:27:43', 'dbo', ''),
(2018080019, 201808, 46, 19, '2018-09-07', 3808, 'ENERGY', 75, 75, '2018-09-01', '2018-08-01', '2018-09-14', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2018-09-07 18:27:44', 'dbo', ''),
(2018080020, 201808, 46, 20, '2018-09-07', 3809, 'ENERGY', 254, 254, '2018-09-01', '2018-08-01', '2018-09-14', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2018-09-07 18:27:44', 'dbo', ''),
(2018080021, 201808, 46, 21, '2018-09-07', 3810, 'ENERGY', 48754, 48754, '2018-09-01', '2018-08-01', '2018-09-14', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2018-09-07 18:27:44', 'dbo', ''),
(2018080022, 201808, 46, 22, '2018-09-07', 3811, 'ENERGY', 29187, 29187, '2018-09-01', '2018-08-01', '2018-09-14', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2018-09-07 18:27:44', 'dbo', ''),
(2018080023, 201808, 46, 23, '2018-09-07', 3812, 'ENERGY', 77425, 77425, '2018-09-01', '2018-08-01', '2018-09-14', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2018-09-07 18:27:44', 'dbo', ''),
(2018080024, 201808, 46, 24, '2018-09-07', 3813, 'ENERGY', 47443, 47443, '2018-09-01', '2018-08-01', '2018-09-14', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2018-09-07 18:27:44', 'dbo', ''),
(2018080025, 201808, 46, 25, '2018-09-07', 3814, 'ENERGY', 107016, 101783, '2018-09-01', '2018-08-01', '2018-09-14', 5233, 2013430.2700, 0.0000, 104747.4900, 2118177.7600, '2018-09-07 18:27:44', 'dbo', ''),
(2018080026, 201808, 46, 26, '2018-09-07', 3815, 'ENERGY', 74955, 73227, '2018-09-01', '2018-08-01', '2018-09-14', 1728, 1256137.2674, 0.0000, 34588.9000, 1290726.1674, '2018-09-07 18:27:44', 'dbo', ''),
(2018080029, 201808, 46, 29, '2018-09-07', 3816, 'ENERGY', 104222, 102025, '2018-09-01', '2018-08-01', '2018-09-14', 2197, 1658644.5388, 0.0000, 43976.7300, 1702621.2688, '2018-09-07 18:27:44', 'dbo', ''),
(2018080030, 201808, 46, 30, '2018-09-07', 3817, 'ENERGY', 50831, 49698, '2018-09-01', '2018-08-01', '2018-09-14', 1133, 704554.8912, 0.0000, 22678.9300, 727233.8212, '2018-09-07 18:27:44', 'dbo', ''),
(2018080031, 201808, 46, 31, '2018-09-07', 3818, 'ENERGY', 82928, 81066, '2018-09-01', '2018-08-01', '2018-09-14', 1862, 1353059.6780, 0.0000, 37271.1400, 1390330.8180, '2018-09-07 18:27:44', 'dbo', ''),
(2018080032, 201808, 46, 32, '2018-09-07', 3819, 'ENERGY', 138308, 134601, '2018-09-01', '2018-08-01', '2018-09-14', 3707, 2258884.1190, 0.0000, 74201.9800, 2333086.0990, '2018-09-07 18:27:44', 'dbo', ''),
(2018080033, 201808, 46, 33, '2018-09-07', 3820, 'ENERGY', 19740, 18938, '2018-09-01', '2018-08-01', '2018-09-14', 802, 344952.4334, 0.0000, 16053.4100, 361005.8434, '2018-09-07 18:27:44', 'dbo', ''),
(2018080034, 201808, 46, 34, '2018-09-07', 3821, 'ENERGY', 12922, 12921, '2018-09-01', '2018-08-01', '2018-09-14', 1, 239127.7342, 0.0000, 20.0200, 239147.7542, '2018-09-07 18:27:44', 'dbo', ''),
(2018080035, 201808, 46, 35, '2018-09-07', 3822, 'ENERGY', 20188, 19711, '2018-09-01', '2018-08-01', '2018-09-14', 477, 333065.8526, 0.0000, 9547.9700, 342613.8226, '2018-09-07 18:27:44', 'dbo', ''),
(2018080036, 201808, 46, 36, '2018-09-07', 3823, 'ENERGY', 50376, 50041, '2018-09-01', '2018-08-01', '2018-09-14', 335, 879149.7338, 0.0000, 6705.6000, 885855.3338, '2018-09-07 18:27:44', 'dbo', ''),
(2018080037, 201808, 46, 37, '2018-09-07', 3824, 'ENERGY', 26807, 25955, '2018-09-01', '2018-08-01', '2018-09-14', 852, 434829.6810, 0.0000, 17054.2500, 451883.9310, '2018-09-07 18:27:44', 'dbo', ''),
(2018080038, 201808, 46, 38, '2018-09-07', 3825, 'ENERGY', 15471, 14476, '2018-09-01', '2018-08-01', '2018-09-14', 995, 260236.7834, 0.0000, 19916.6300, 280153.4134, '2018-09-07 18:27:44', 'dbo', ''),
(2018080039, 201808, 46, 39, '2018-09-07', 3826, 'ENERGY', 30493, 29991, '2018-09-01', '2018-08-01', '2018-09-14', 502, -100740.0018, 0.0000, 10048.3900, -90691.6118, '2018-09-07 18:27:44', 'dbo', ''),
(2018080040, 201808, 46, 40, '2018-09-07', 3827, 'ENERGY', 35817, 33930, '2018-09-01', '2018-08-01', '2018-09-14', 1887, 611747.9696, 0.0000, 37771.5500, 649519.5196, '2018-09-07 18:27:44', 'dbo', ''),
(2018080041, 201808, 46, 41, '2018-09-07', 3828, 'ENERGY', 241, 241, '2018-09-01', '2018-08-01', '2018-09-14', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2018-09-07 18:27:44', 'dbo', ''),
(2018080042, 201808, 46, 42, '2018-09-07', 3829, 'ENERGY', 334, 334, '2018-09-01', '2018-08-01', '2018-09-14', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2018-09-07 18:27:44', 'dbo', ''),
(2018080043, 201808, 46, 43, '2018-09-07', 3830, 'ENERGY', 82890, 81066, '2018-09-01', '2018-08-01', '2018-09-14', 1824, 1241725.2202, 0.0000, 36510.4900, 1278235.7102, '2018-09-07 18:27:43', 'dbo', ''),
(2018080044, 201808, 46, 44, '2018-09-07', 3831, 'ENERGY', 47446, 46263, '2018-09-01', '2018-08-01', '2018-09-14', 1183, 881243.3130, 0.0000, 23679.7800, 904923.0930, '2018-09-07 18:27:43', 'dbo', ''),
(2018080045, 201808, 46, 45, '2018-09-07', 3832, 'ENERGY', 38346, 37617, '2018-09-01', '2018-08-01', '2018-09-14', 729, 437822.2620, 0.0000, 14592.1900, 452414.4520, '2018-09-07 18:27:44', 'dbo', ''),
(2018080046, 201808, 46, 46, '2018-09-07', 3833, 'ENERGY', 60732, 59505, '2018-09-01', '2018-08-01', '2018-09-14', 1227, 1073347.7054, 0.0000, 24560.5200, 1097908.2254, '2018-09-07 18:27:44', 'dbo', ''),
(2018080047, 201808, 46, 47, '2018-09-07', 3834, 'ENERGY', 31119, 30179, '2018-09-01', '2018-08-01', '2018-09-14', 940, 430794.6810, 0.0000, 18815.7200, 449610.4010, '2018-09-07 18:27:44', 'dbo', ''),
(2018080048, 201808, 46, 48, '2018-09-07', 3835, 'ENERGY', 20705, 19553, '2018-09-01', '2018-08-01', '2018-09-14', 1152, 391891.4700, 0.0000, 23059.2700, 414950.7400, '2018-09-07 18:27:44', 'dbo', ''),
(2018080049, 201808, 46, 49, '2018-09-07', 3836, 'ENERGY', 7749, 7496, '2018-09-01', '2018-08-01', '2018-09-14', 253, 135401.6390, 0.0000, 5064.2200, 140465.8590, '2018-09-07 18:27:43', 'dbo', ''),
(2018080050, 201808, 46, 50, '2018-09-07', 3837, 'ENERGY', 100447, 98271, '2018-09-01', '2018-08-01', '2018-09-14', 2176, 1577674.4392, 0.0000, 43556.3900, 1621230.8292, '2018-09-07 18:27:43', 'dbo', ''),
(2018080051, 201808, 46, 51, '2018-09-07', 3838, 'ENERGY', 211, 211, '2018-09-01', '2018-08-01', '2018-09-14', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2018-09-07 18:27:44', 'dbo', ''),
(2018080052, 201808, 46, 52, '2018-09-07', 3839, 'ENERGY', 321, 321, '2018-09-01', '2018-08-01', '2018-09-14', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2018-09-07 18:27:44', 'dbo', ''),
(2018080053, 201808, 46, 53, '2018-09-07', 3840, 'ENERGY', 5274, 4391, '2018-09-01', '2018-08-01', '2018-09-14', 883, 97943.9570, 0.0000, 17674.7600, 115618.7170, '2018-09-07 18:27:44', 'dbo', ''),
(2018080054, 201808, 46, 54, '2018-09-07', 3841, 'ENERGY', 36675, 35859, '2018-09-01', '2018-08-01', '2018-09-14', 816, 441096.7094, 0.0000, 16333.6500, 457430.3594, '2018-09-07 18:27:44', 'dbo', ''),
(2018080055, 201808, 46, 55, '2018-09-07', 3842, 'ENERGY', 13022, 12689, '2018-09-01', '2018-08-01', '2018-09-14', 333, 239408.7700, 0.0000, 6665.5600, 246074.3300, '2018-09-07 18:27:44', 'dbo', ''),
(2018080056, 201808, 46, 56, '2018-09-07', 3843, 'ENERGY', 1497, 1119, '2018-09-01', '2018-08-01', '2018-09-14', 378, 29453.0490, 0.0000, 7566.3200, 37019.3690, '2018-09-07 18:27:44', 'dbo', ''),
(2018080059, 201808, 46, 59, '2018-09-07', 3844, 'ENERGY', 128, 128, '2018-09-01', '2018-08-01', '2018-09-14', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2018-09-07 18:27:44', 'dbo', ''),
(2018080060, 201808, 46, 60, '2018-09-07', 3845, 'ENERGY', 290458, 281811, '2018-09-01', '2018-08-01', '2018-09-14', 8647, 4104518.5400, 0.0000, 173084.5800, 4277603.1200, '2018-09-07 18:27:43', 'dbo', ''),
(2018080061, 201808, 46, 61, '2018-09-07', 3846, 'ENERGY', 16, 16, '2018-09-01', '2018-08-01', '2018-09-14', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2018-09-07 18:27:44', 'dbo', ''),
(2018080062, 201808, 46, 62, '2018-09-07', 3847, 'ENERGY', 30, 30, '2018-09-01', '2018-08-01', '2018-09-14', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-09-07 18:27:44', 'dbo', ''),
(2018080063, 201808, 46, 63, '2018-09-07', 3848, 'ENERGY', 1, 1, '2018-09-01', '2018-08-01', '2018-09-14', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-09-07 18:27:44', 'dbo', ''),
(2018080064, 201808, 46, 64, '2018-09-07', 3849, 'ENERGY', 2, 2, '2018-09-01', '2018-08-01', '2018-09-14', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-09-07 18:27:44', 'dbo', ''),
(2018080065, 201808, 46, 65, '2018-09-07', 3850, 'ENERGY', 11983, 11455, '2018-09-01', '2018-08-01', '2018-09-14', 528, 231668.5180, 0.0000, 10568.8400, 242237.3580, '2018-09-07 18:27:43', 'dbo', ''),
(2018080066, 201808, 46, 66, '2018-09-07', 3851, 'ENERGY', 8783, 8140, '2018-09-01', '2018-08-01', '2018-09-14', 643, 164047.9324, 0.0000, 12870.7400, 176918.6724, '2018-09-07 18:27:43', 'dbo', ''),
(2018080067, 201808, 46, 67, '2018-09-07', 3852, 'ENERGY', 1082, 1028, '2018-09-01', '2018-08-01', '2018-09-14', 54, 28887.7938, 0.0000, 1080.9000, 29968.6938, '2018-09-07 18:27:44', 'dbo', ''),
(2018080068, 201808, 46, 68, '2018-09-07', 3853, 'ENERGY', 2366, 2258, '2018-09-01', '2018-08-01', '2018-09-14', 108, 54045.1700, 0.0000, 2161.8100, 56206.9800, '2018-09-07 18:27:44', 'dbo', ''),
(2018080069, 201808, 46, 69, '2018-09-07', 3854, 'ENERGY', 1, 1, '2018-09-01', '2018-08-01', '2018-09-14', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2018-09-07 18:27:44', 'dbo', ''),
(2018080070, 201808, 46, 70, '2018-09-07', 3855, 'ENERGY', 1925, 1765, '2018-09-01', '2018-08-01', '2018-09-14', 160, 44422.4100, 0.0000, 3202.6700, 47625.0800, '2018-09-07 18:27:44', 'dbo', ''),
(2018080071, 201808, 46, 71, '2018-09-07', 3856, 'ENERGY', 224365, 215186, '2018-09-01', '2018-08-01', '2018-09-14', 9179, 4097094.3262, 0.0000, 183733.4800, 4280827.8062, '2018-09-07 18:27:43', 'dbo', ''),
(2018080072, 201808, 46, 72, '2018-09-07', 3857, 'ENERGY', 1900, 1825, '2018-09-01', '2018-08-01', '2018-09-14', 75, 46155.7300, 0.0000, 1501.2500, 47656.9800, '2018-09-07 18:27:43', 'dbo', ''),
(2018080073, 201808, 46, 73, '2018-09-07', 3858, 'ENERGY', 482, 475, '2018-09-01', '2018-08-01', '2018-09-14', 7, 26166.0580, 0.0000, 140.1200, 26306.1780, '2018-09-07 18:27:43', 'dbo', ''),
(2018080075, 201808, 46, 75, '2018-09-07', 3859, 'ENERGY', 1734, 1702, '2018-09-01', '2018-08-01', '2018-09-14', 32, 42662.7000, 0.0000, 640.5300, 43303.2300, '2018-09-07 18:27:43', 'dbo', ''),
(2018080076, 201808, 46, 76, '2018-09-07', 3860, 'ENERGY', 1834, 1791, '2018-09-01', '2018-08-01', '2018-09-14', 43, 43997.2400, 0.0000, 860.7200, 44857.9600, '2018-09-07 18:27:43', 'dbo', ''),
(2018080077, 201808, 46, 77, '2018-09-07', 3861, 'ENERGY', 1445, 1414, '2018-09-01', '2018-08-01', '2018-09-14', 31, 36999.3400, 0.0000, 620.5200, 37619.8600, '2018-09-07 18:27:43', 'dbo', ''),
(2018080078, 201808, 46, 78, '2018-09-07', 3862, 'ENERGY', 435, 423, '2018-09-01', '2018-08-01', '2018-09-14', 12, 17285.2900, 0.0000, 240.1900, 17525.4800, '2018-09-07 18:27:43', 'dbo', ''),
(2018080079, 201808, 46, 79, '2018-09-07', 3863, 'ENERGY', 49340, 47956, '2018-09-01', '2018-08-01', '2018-09-14', 1384, 815329.2500, 0.0000, 27703.1400, 843032.3900, '2018-09-07 18:27:44', 'dbo', ''),
(2018080081, 201808, 46, 81, '2018-09-07', 3865, 'ENERGY', 1837, 1782, '2018-09-01', '2018-08-01', '2018-09-14', 55, 41168.1900, 0.0000, 1100.9200, 42269.1100, '2018-09-07 18:27:44', 'dbo', ''),
(2018080082, 201808, 46, 82, '2018-09-07', 3866, 'ENERGY', 3786, 3646, '2018-09-01', '2018-08-01', '2018-09-14', 140, 78841.5900, 0.0000, 2802.3400, 81643.9300, '2018-09-07 18:27:44', 'dbo', ''),
(2018080083, 201808, 46, 83, '2018-09-07', 3867, 'ENERGY', 95, 92, '2018-09-01', '2018-08-01', '2018-09-14', 3, 7643.3200, 0.0000, 60.0500, 7703.3700, '2018-09-07 18:27:43', 'dbo', ''),
(2018080084, 201808, 46, 84, '2018-09-07', 3868, 'ENERGY', 161, 147, '2018-09-01', '2018-08-01', '2018-09-14', 14, 8510.1700, 0.0000, 280.2400, 8790.4100, '2018-09-07 18:27:44', 'dbo', ''),
(2018080085, 201808, 46, 85, '2018-09-07', 3869, 'ENERGY', 355, 355, '2018-09-01', '2018-08-01', '2018-09-14', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2018-09-07 18:27:44', 'dbo', ''),
(2018080086, 201808, 46, 86, '2018-09-07', 3870, 'ENERGY', 105, 100, '2018-09-01', '2018-08-01', '2018-09-14', 5, 7184.1200, 0.0000, 100.0900, 7284.2100, '2018-09-07 18:27:44', 'dbo', ''),
(2018090001, 201809, 47, 1, '2018-10-08', 3871, 'ENERGY', 0, 0, '2018-10-01', '2018-09-01', '2018-10-15', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2018-10-08 09:37:13', 'dbo', ''),
(2018090002, 201809, 47, 2, '2018-10-08', 3872, 'ENERGY', 0, 0, '2018-10-01', '2018-09-01', '2018-10-15', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2018-10-08 09:37:13', 'dbo', ''),
(2018090003, 201809, 47, 3, '2018-10-08', 3873, 'ENERGY', 0, 0, '2018-10-01', '2018-09-01', '2018-10-15', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2018-10-08 09:37:13', 'dbo', ''),
(2018090004, 201809, 47, 4, '2018-10-08', 3874, 'ENERGY', 0, 0, '2018-10-01', '2018-09-01', '2018-10-15', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2018-10-08 09:37:13', 'dbo', ''),
(2018090005, 201809, 47, 5, '2018-10-08', 3875, 'ENERGY', 0, 0, '2018-10-01', '2018-09-01', '2018-10-15', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2018-10-08 09:37:14', 'dbo', ''),
(2018090006, 201809, 47, 6, '2018-10-08', 3876, 'ENERGY', 0, 0, '2018-10-01', '2018-09-01', '2018-10-15', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2018-10-08 09:37:14', 'dbo', ''),
(2018090007, 201809, 47, 7, '2018-10-08', 3877, 'ENERGY', 0, 0, '2018-10-01', '2018-09-01', '2018-10-15', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2018-10-08 09:37:14', 'dbo', ''),
(2018090008, 201809, 47, 8, '2018-10-08', 3878, 'ENERGY', 0, 0, '2018-10-01', '2018-09-01', '2018-10-15', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2018-10-08 09:37:14', 'dbo', ''),
(2018090009, 201809, 47, 9, '2018-10-08', 3879, 'ENERGY', 10896, 10798, '2018-10-01', '2018-09-01', '2018-10-15', 98, 236614.5364, 0.0000, 1967.0200, 238581.5564, '2018-10-08 09:37:13', 'dbo', ''),
(2018090010, 201809, 47, 10, '2018-10-08', 3880, 'ENERGY', 774, 759, '2018-10-01', '2018-09-01', '2018-10-15', 15, 23420.3680, 0.0000, 301.0700, 23721.4380, '2018-10-08 09:37:13', 'dbo', ''),
(2018090011, 201809, 47, 11, '2018-10-08', 3881, 'ENERGY', 201, 201, '2018-10-01', '2018-09-01', '2018-10-15', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2018-10-08 09:37:13', 'dbo', ''),
(2018090012, 201809, 47, 12, '2018-10-08', 3882, 'ENERGY', 137, 137, '2018-10-01', '2018-09-01', '2018-10-15', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2018-10-08 09:37:13', 'dbo', ''),
(2018090013, 201809, 47, 13, '2018-10-08', 3883, 'ENERGY', 17950, 17112, '2018-10-01', '2018-09-01', '2018-10-15', 838, 354676.1140, 0.0000, 16819.9500, 371496.0640, '2018-10-08 09:37:13', 'dbo', ''),
(2018090014, 201809, 47, 14, '2018-10-08', 3884, 'ENERGY', 9042, 8501, '2018-10-01', '2018-09-01', '2018-10-15', 541, 184096.4954, 0.0000, 10858.6900, 194955.1854, '2018-10-08 09:37:13', 'dbo', ''),
(2018090015, 201809, 47, 15, '2018-10-08', 3885, 'ENERGY', 162, 162, '2018-10-01', '2018-09-01', '2018-10-15', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2018-10-08 09:37:14', 'dbo', ''),
(2018090016, 201809, 47, 16, '2018-10-08', 3886, 'ENERGY', 12460, 12059, '2018-10-01', '2018-09-01', '2018-10-15', 401, 249167.9520, 0.0000, 8048.7000, 257216.6520, '2018-10-08 09:37:13', 'dbo', ''),
(2018090017, 201809, 47, 17, '2018-10-08', 3887, 'ENERGY', 39416, 37559, '2018-10-01', '2018-09-01', '2018-10-15', 1857, 754061.9770, 0.0000, 37272.8300, 791334.8070, '2018-10-08 09:37:13', 'dbo', ''),
(2018090018, 201809, 47, 18, '2018-10-08', 3888, 'ENERGY', 9698, 9278, '2018-10-01', '2018-09-01', '2018-10-15', 420, 190772.2400, 0.0000, 8430.0400, 199202.2800, '2018-10-08 09:37:13', 'dbo', ''),
(2018090019, 201809, 47, 19, '2018-10-08', 3889, 'ENERGY', 75, 75, '2018-10-01', '2018-09-01', '2018-10-15', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2018-10-08 09:37:13', 'dbo', ''),
(2018090020, 201809, 47, 20, '2018-10-08', 3890, 'ENERGY', 254, 254, '2018-10-01', '2018-09-01', '2018-10-15', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2018-10-08 09:37:13', 'dbo', ''),
(2018090021, 201809, 47, 21, '2018-10-08', 3891, 'ENERGY', 48754, 48754, '2018-10-01', '2018-09-01', '2018-10-15', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2018-10-08 09:37:14', 'dbo', ''),
(2018090022, 201809, 47, 22, '2018-10-08', 3892, 'ENERGY', 29187, 29187, '2018-10-01', '2018-09-01', '2018-10-15', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2018-10-08 09:37:14', 'dbo', ''),
(2018090023, 201809, 47, 23, '2018-10-08', 3893, 'ENERGY', 77425, 77425, '2018-10-01', '2018-09-01', '2018-10-15', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2018-10-08 09:37:14', 'dbo', ''),
(2018090024, 201809, 47, 24, '2018-10-08', 3894, 'ENERGY', 47443, 47443, '2018-10-01', '2018-09-01', '2018-10-15', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2018-10-08 09:37:14', 'dbo', ''),
(2018090025, 201809, 47, 25, '2018-10-08', 3895, 'ENERGY', 111696, 107016, '2018-10-01', '2018-09-01', '2018-10-15', 4680, 2118177.7600, 0.0000, 93934.7700, 2212112.5300, '2018-10-08 09:37:13', 'dbo', ''),
(2018090026, 201809, 47, 26, '2018-10-08', 3896, 'ENERGY', 76426, 74955, '2018-10-01', '2018-09-01', '2018-10-15', 1471, 1290726.1674, 0.0000, 29525.2300, 1320251.3974, '2018-10-08 09:37:13', 'dbo', ''),
(2018090029, 201809, 47, 29, '2018-10-08', 3897, 'ENERGY', 106145, 104222, '2018-10-01', '2018-09-01', '2018-10-15', 1923, 1702621.2688, 0.0000, 38597.5500, 1741218.8188, '2018-10-08 09:37:13', 'dbo', ''),
(2018090030, 201809, 47, 30, '2018-10-08', 3898, 'ENERGY', 51776, 50831, '2018-10-01', '2018-09-01', '2018-10-15', 945, 727233.8212, 0.0000, 18967.6000, 746201.4212, '2018-10-08 09:37:13', 'dbo', ''),
(2018090031, 201809, 47, 31, '2018-10-08', 3899, 'ENERGY', 84669, 82928, '2018-10-01', '2018-09-01', '2018-10-15', 1741, 1390330.8180, 0.0000, 34944.5300, 1425275.3480, '2018-10-08 09:37:13', 'dbo', ''),
(2018090032, 201809, 47, 32, '2018-10-08', 3900, 'ENERGY', 141373, 138308, '2018-10-01', '2018-09-01', '2018-10-15', 3065, 2333086.0990, 0.0000, 61519.2600, 2394605.3590, '2018-10-08 09:37:13', 'dbo', ''),
(2018090033, 201809, 47, 33, '2018-10-08', 3901, 'ENERGY', 20339, 19740, '2018-10-01', '2018-09-01', '2018-10-15', 599, 361005.8434, 0.0000, 12022.8400, 373028.6834, '2018-10-08 09:37:13', 'dbo', ''),
(2018090034, 201809, 47, 34, '2018-10-08', 3902, 'ENERGY', 12922, 12922, '2018-10-01', '2018-09-01', '2018-10-15', 0, 239147.7542, 0.0000, 0.0000, 239147.7542, '2018-10-08 09:37:13', 'dbo', ''),
(2018090035, 201809, 47, 35, '2018-10-08', 3903, 'ENERGY', 20561, 20188, '2018-10-01', '2018-09-01', '2018-10-15', 373, 342613.8226, 0.0000, 7486.6800, 350100.5026, '2018-10-08 09:37:13', 'dbo', ''),
(2018090036, 201809, 47, 36, '2018-10-08', 3904, 'ENERGY', 50669, 50376, '2018-10-01', '2018-09-01', '2018-10-15', 293, 885855.3338, 0.0000, 5880.9500, 891736.2838, '2018-10-08 09:37:13', 'dbo', ''),
(2018090037, 201809, 47, 37, '2018-10-08', 3905, 'ENERGY', 27407, 26807, '2018-10-01', '2018-09-01', '2018-10-15', 600, 451883.9310, 0.0000, 12042.9200, 463926.8510, '2018-10-08 09:37:13', 'dbo', ''),
(2018090038, 201809, 47, 38, '2018-10-08', 3906, 'ENERGY', 16208, 15471, '2018-10-01', '2018-09-01', '2018-10-15', 737, 280153.4134, 0.0000, 14792.7300, 294946.1434, '2018-10-08 09:37:13', 'dbo', ''),
(2018090039, 201809, 47, 39, '2018-10-08', 3907, 'ENERGY', 30890, 30493, '2018-10-01', '2018-09-01', '2018-10-15', 397, -90691.6118, 0.0000, 7968.3900, -82723.2218, '2018-10-08 09:37:13', 'dbo', ''),
(2018090040, 201809, 47, 40, '2018-10-08', 3908, 'ENERGY', 37334, 35817, '2018-10-01', '2018-09-01', '2018-10-15', 1517, 649519.5196, 0.0000, 30448.5200, 679968.0396, '2018-10-08 09:37:13', 'dbo', ''),
(2018090041, 201809, 47, 41, '2018-10-08', 3909, 'ENERGY', 241, 241, '2018-10-01', '2018-09-01', '2018-10-15', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2018-10-08 09:37:14', 'dbo', ''),
(2018090042, 201809, 47, 42, '2018-10-08', 3910, 'ENERGY', 334, 334, '2018-10-01', '2018-09-01', '2018-10-15', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2018-10-08 09:37:14', 'dbo', ''),
(2018090043, 201809, 47, 43, '2018-10-08', 3911, 'ENERGY', 84520, 82890, '2018-10-01', '2018-09-01', '2018-10-15', 1630, 1278235.7102, 0.0000, 32716.6000, 1310952.3102, '2018-10-08 09:37:13', 'dbo', ''),
(2018090044, 201809, 47, 44, '2018-10-08', 3912, 'ENERGY', 48397, 47446, '2018-10-01', '2018-09-01', '2018-10-15', 951, 904923.0930, 0.0000, 19088.0200, 924011.1130, '2018-10-08 09:37:13', 'dbo', ''),
(2018090045, 201809, 47, 45, '2018-10-08', 3913, 'ENERGY', 38973, 38346, '2018-10-01', '2018-09-01', '2018-10-15', 627, 452414.4520, 0.0000, 12584.8600, 464999.3120, '2018-10-08 09:37:13', 'dbo', ''),
(2018090046, 201809, 47, 46, '2018-10-08', 3914, 'ENERGY', 61616, 60732, '2018-10-01', '2018-09-01', '2018-10-15', 884, 1097908.2254, 0.0000, 17743.2400, 1115651.4654, '2018-10-08 09:37:13', 'dbo', ''),
(2018090047, 201809, 47, 47, '2018-10-08', 3915, 'ENERGY', 31816, 31119, '2018-10-01', '2018-09-01', '2018-10-15', 697, 449610.4010, 0.0000, 13989.8500, 463600.2510, '2018-10-08 09:37:13', 'dbo', ''),
(2018090048, 201809, 47, 48, '2018-10-08', 3916, 'ENERGY', 21635, 20705, '2018-10-01', '2018-09-01', '2018-10-15', 930, 414950.7400, 0.0000, 18666.5400, 433617.2800, '2018-10-08 09:37:13', 'dbo', ''),
(2018090049, 201809, 47, 49, '2018-10-08', 3917, 'ENERGY', 7932, 7749, '2018-10-01', '2018-09-01', '2018-10-15', 183, 140465.8590, 0.0000, 3673.0900, 144138.9490, '2018-10-08 09:37:13', 'dbo', ''),
(2018090050, 201809, 47, 50, '2018-10-08', 3918, 'ENERGY', 102174, 100447, '2018-10-01', '2018-09-01', '2018-10-15', 1727, 1621230.8292, 0.0000, 34663.5400, 1655894.3692, '2018-10-08 09:37:13', 'dbo', ''),
(2018090051, 201809, 47, 51, '2018-10-08', 3919, 'ENERGY', 211, 211, '2018-10-01', '2018-09-01', '2018-10-15', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2018-10-08 09:37:14', 'dbo', ''),
(2018090052, 201809, 47, 52, '2018-10-08', 3920, 'ENERGY', 321, 321, '2018-10-01', '2018-09-01', '2018-10-15', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2018-10-08 09:37:14', 'dbo', ''),
(2018090053, 201809, 47, 53, '2018-10-08', 3921, 'ENERGY', 6020, 5274, '2018-10-01', '2018-09-01', '2018-10-15', 746, 115618.7170, 0.0000, 14973.3700, 130592.0870, '2018-10-08 09:37:13', 'dbo', ''),
(2018090054, 201809, 47, 54, '2018-10-08', 3922, 'ENERGY', 37363, 36675, '2018-10-01', '2018-09-01', '2018-10-15', 688, 457430.3594, 0.0000, 13809.2200, 471239.5794, '2018-10-08 09:37:13', 'dbo', ''),
(2018090055, 201809, 47, 55, '2018-10-08', 3923, 'ENERGY', 13289, 13022, '2018-10-01', '2018-09-01', '2018-10-15', 267, 246074.3300, 0.0000, 5359.0900, 251433.4200, '2018-10-08 09:37:13', 'dbo', ''),
(2018090056, 201809, 47, 56, '2018-10-08', 3924, 'ENERGY', 1923, 1497, '2018-10-01', '2018-09-01', '2018-10-15', 426, 37019.3690, 0.0000, 8550.4800, 45569.8490, '2018-10-08 09:37:13', 'dbo', ''),
(2018090059, 201809, 47, 59, '2018-10-08', 3925, 'ENERGY', 128, 128, '2018-10-01', '2018-09-01', '2018-10-15', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2018-10-08 09:37:13', 'dbo', ''),
(2018090060, 201809, 47, 60, '2018-10-08', 3926, 'ENERGY', 290458, 290458, '2018-10-01', '2018-09-01', '2018-10-15', 0, 4277603.1200, 0.0000, 0.0000, 4277603.1200, '2018-10-08 09:37:13', 'dbo', ''),
(2018090061, 201809, 47, 61, '2018-10-08', 3927, 'ENERGY', 16, 16, '2018-10-01', '2018-09-01', '2018-10-15', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2018-10-08 09:37:13', 'dbo', ''),
(2018090062, 201809, 47, 62, '2018-10-08', 3928, 'ENERGY', 30, 30, '2018-10-01', '2018-09-01', '2018-10-15', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-10-08 09:37:13', 'dbo', ''),
(2018090063, 201809, 47, 63, '2018-10-08', 3929, 'ENERGY', 1, 1, '2018-10-01', '2018-09-01', '2018-10-15', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-10-08 09:37:13', 'dbo', ''),
(2018090064, 201809, 47, 64, '2018-10-08', 3930, 'ENERGY', 2, 2, '2018-10-01', '2018-09-01', '2018-10-15', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-10-08 09:37:13', 'dbo', ''),
(2018090065, 201809, 47, 65, '2018-10-08', 3931, 'ENERGY', 12385, 11983, '2018-10-01', '2018-09-01', '2018-10-15', 402, 242237.3580, 0.0000, 8068.7600, 250306.1180, '2018-10-08 09:37:13', 'dbo', ''),
(2018090066, 201809, 47, 66, '2018-10-08', 3932, 'ENERGY', 9215, 8783, '2018-10-01', '2018-09-01', '2018-10-15', 432, 176918.6724, 0.0000, 8670.9100, 185589.5824, '2018-10-08 09:37:13', 'dbo', ''),
(2018090067, 201809, 47, 67, '2018-10-08', 3933, 'ENERGY', 1131, 1082, '2018-10-01', '2018-09-01', '2018-10-15', 49, 29968.6938, 0.0000, 983.5000, 30952.1938, '2018-10-08 09:37:13', 'dbo', ''),
(2018090068, 201809, 47, 68, '2018-10-08', 3934, 'ENERGY', 2529, 2366, '2018-10-01', '2018-09-01', '2018-10-15', 163, 56206.9800, 0.0000, 3271.6500, 59478.6300, '2018-10-08 09:37:13', 'dbo', ''),
(2018090069, 201809, 47, 69, '2018-10-08', 3935, 'ENERGY', 1, 1, '2018-10-01', '2018-09-01', '2018-10-15', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2018-10-08 09:37:13', 'dbo', ''),
(2018090070, 201809, 47, 70, '2018-10-08', 3936, 'ENERGY', 2090, 1925, '2018-10-01', '2018-09-01', '2018-10-15', 165, 47625.0800, 0.0000, 3311.8100, 50936.8900, '2018-10-08 09:37:13', 'dbo', ''),
(2018090071, 201809, 47, 71, '2018-10-08', 3937, 'ENERGY', 232301, 224365, '2018-10-01', '2018-09-01', '2018-10-15', 7936, 4280827.8062, 0.0000, 159287.7000, 4440115.5062, '2018-10-08 09:37:13', 'dbo', ''),
(2018090072, 201809, 47, 72, '2018-10-08', 3938, 'ENERGY', 1967, 1900, '2018-10-01', '2018-09-01', '2018-10-15', 67, 47656.9800, 0.0000, 1344.7900, 49001.7700, '2018-10-08 09:37:13', 'dbo', ''),
(2018090073, 201809, 47, 73, '2018-10-08', 3939, 'ENERGY', 483, 482, '2018-10-01', '2018-09-01', '2018-10-15', 1, 26306.1780, 0.0000, 20.0800, 26326.2580, '2018-10-08 09:37:13', 'dbo', ''),
(2018090075, 201809, 47, 75, '2018-10-08', 3940, 'ENERGY', 1762, 1734, '2018-10-01', '2018-09-01', '2018-10-15', 28, 43303.2300, 0.0000, 562.0000, 43865.2300, '2018-10-08 09:37:13', 'dbo', ''),
(2018090076, 201809, 47, 76, '2018-10-08', 3941, 'ENERGY', 1871, 1834, '2018-10-01', '2018-09-01', '2018-10-15', 37, 44857.9600, 0.0000, 742.6500, 45600.6100, '2018-10-08 09:37:13', 'dbo', ''),
(2018090077, 201809, 47, 77, '2018-10-08', 3942, 'ENERGY', 1472, 1445, '2018-10-01', '2018-09-01', '2018-10-15', 27, 37619.8600, 0.0000, 541.9300, 38161.7900, '2018-10-08 09:37:13', 'dbo', ''),
(2018090078, 201809, 47, 78, '2018-10-08', 3943, 'ENERGY', 445, 435, '2018-10-01', '2018-09-01', '2018-10-15', 10, 17525.4800, 0.0000, 200.7200, 17726.2000, '2018-10-08 09:37:13', 'dbo', ''),
(2018090079, 201809, 47, 79, '2018-10-08', 3944, 'ENERGY', 50407, 49340, '2018-10-01', '2018-09-01', '2018-10-15', 1067, 843032.3900, 0.0000, 21416.3300, 864448.7200, '2018-10-08 09:37:13', 'dbo', ''),
(2018090081, 201809, 47, 81, '2018-10-08', 3946, 'ENERGY', 1885, 1837, '2018-10-01', '2018-09-01', '2018-10-15', 48, 42269.1100, 0.0000, 963.4400, 43232.5500, '2018-10-08 09:37:13', 'dbo', ''),
(2018090082, 201809, 47, 82, '2018-10-08', 3947, 'ENERGY', 3905, 3786, '2018-10-01', '2018-09-01', '2018-10-15', 119, 81643.9300, 0.0000, 2388.5200, 84032.4500, '2018-10-08 09:37:13', 'dbo', ''),
(2018090083, 201809, 47, 83, '2018-10-08', 3948, 'ENERGY', 98, 95, '2018-10-01', '2018-09-01', '2018-10-15', 3, 7703.3700, 0.0000, 60.2200, 7763.5900, '2018-10-08 09:37:13', 'dbo', ''),
(2018090084, 201809, 47, 84, '2018-10-08', 3949, 'ENERGY', 162, 161, '2018-10-01', '2018-09-01', '2018-10-15', 1, 8790.4100, 0.0000, 20.0800, 8810.4900, '2018-10-08 09:37:13', 'dbo', ''),
(2018090085, 201809, 47, 85, '2018-10-08', 3950, 'ENERGY', 355, 355, '2018-10-01', '2018-09-01', '2018-10-15', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2018-10-08 09:37:14', 'dbo', ''),
(2018090086, 201809, 47, 86, '2018-10-08', 3951, 'ENERGY', 109, 105, '2018-10-01', '2018-09-01', '2018-10-15', 4, 7284.2100, 0.0000, 80.2900, 7364.5000, '2018-10-08 09:37:13', 'dbo', ''),
(2018100001, 201810, 48, 1, '2018-11-15', 3952, 'ENERGY', 0, 0, '2018-10-01', '2018-10-01', '2018-11-22', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2018-11-15 13:25:05', 'dbo', ''),
(2018100002, 201810, 48, 2, '2018-11-15', 3953, 'ENERGY', 0, 0, '2018-10-01', '2018-10-01', '2018-11-22', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2018-11-15 13:25:05', 'dbo', ''),
(2018100003, 201810, 48, 3, '2018-11-15', 3954, 'ENERGY', 0, 0, '2018-10-01', '2018-10-01', '2018-11-22', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2018-11-15 13:25:05', 'dbo', ''),
(2018100004, 201810, 48, 4, '2018-11-15', 3955, 'ENERGY', 0, 0, '2018-10-01', '2018-10-01', '2018-11-22', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2018-11-15 13:25:05', 'dbo', ''),
(2018100005, 201810, 48, 5, '2018-11-15', 3956, 'ENERGY', 0, 0, '2018-10-01', '2018-10-01', '2018-11-22', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2018-11-15 13:25:05', 'dbo', ''),
(2018100006, 201810, 48, 6, '2018-11-15', 3957, 'ENERGY', 0, 0, '2018-10-01', '2018-10-01', '2018-11-22', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2018-11-15 13:25:05', 'dbo', ''),
(2018100007, 201810, 48, 7, '2018-11-15', 3958, 'ENERGY', 0, 0, '2018-10-01', '2018-10-01', '2018-11-22', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2018-11-15 13:25:05', 'dbo', ''),
(2018100008, 201810, 48, 8, '2018-11-15', 3959, 'ENERGY', 0, 0, '2018-10-01', '2018-10-01', '2018-11-22', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2018-11-15 13:25:05', 'dbo', ''),
(2018100009, 201810, 48, 9, '2018-11-15', 3960, 'ENERGY', 11030, 10896, '2018-10-01', '2018-10-01', '2018-11-22', 134, 238581.5564, 0.0000, 2657.3500, 241238.9064, '2018-11-15 13:25:04', 'dbo', ''),
(2018100010, 201810, 48, 10, '2018-11-15', 3961, 'ENERGY', 775, 774, '2018-10-01', '2018-10-01', '2018-11-22', 1, 23721.4380, 0.0000, 19.8200, 23741.2580, '2018-11-15 13:25:04', 'dbo', ''),
(2018100011, 201810, 48, 11, '2018-11-15', 3962, 'ENERGY', 201, 201, '2018-10-01', '2018-10-01', '2018-11-22', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2018-11-15 13:25:05', 'dbo', ''),
(2018100012, 201810, 48, 12, '2018-11-15', 3963, 'ENERGY', 137, 137, '2018-10-01', '2018-10-01', '2018-11-22', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2018-11-15 13:25:05', 'dbo', ''),
(2018100013, 201810, 48, 13, '2018-11-15', 3964, 'ENERGY', 19008, 17950, '2018-10-01', '2018-10-01', '2018-11-22', 1058, 371496.0640, 0.0000, 20981.2300, 392477.2940, '2018-11-15 13:25:04', 'dbo', ''),
(2018100014, 201810, 48, 14, '2018-11-15', 3965, 'ENERGY', 9651, 9042, '2018-10-01', '2018-10-01', '2018-11-22', 609, 194955.1854, 0.0000, 12077.0900, 207032.2754, '2018-11-15 13:25:04', 'dbo', ''),
(2018100015, 201810, 48, 15, '2018-11-15', 3966, 'ENERGY', 162, 162, '2018-10-01', '2018-10-01', '2018-11-22', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2018-11-15 13:25:05', 'dbo', ''),
(2018100016, 201810, 48, 16, '2018-11-15', 3967, 'ENERGY', 13065, 12460, '2018-10-01', '2018-10-01', '2018-11-22', 605, 257216.6520, 0.0000, 11997.7700, 269214.4220, '2018-11-15 13:25:04', 'dbo', ''),
(2018100017, 201810, 48, 17, '2018-11-15', 3968, 'ENERGY', 41724, 39416, '2018-10-01', '2018-10-01', '2018-11-22', 2308, 791334.8070, 0.0000, 45770.0100, 837104.8170, '2018-11-15 13:25:04', 'dbo', ''),
(2018100018, 201810, 48, 18, '2018-11-15', 3969, 'ENERGY', 10201, 9698, '2018-10-01', '2018-10-01', '2018-11-22', 503, 199202.2800, 0.0000, 9975.0000, 209177.2800, '2018-11-15 13:25:04', 'dbo', ''),
(2018100019, 201810, 48, 19, '2018-11-15', 3970, 'ENERGY', 75, 75, '2018-10-01', '2018-10-01', '2018-11-22', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2018-11-15 13:25:05', 'dbo', ''),
(2018100020, 201810, 48, 20, '2018-11-15', 3971, 'ENERGY', 254, 254, '2018-10-01', '2018-10-01', '2018-11-22', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2018-11-15 13:25:05', 'dbo', ''),
(2018100021, 201810, 48, 21, '2018-11-15', 3972, 'ENERGY', 48754, 48754, '2018-10-01', '2018-10-01', '2018-11-22', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2018-11-15 13:25:05', 'dbo', ''),
(2018100022, 201810, 48, 22, '2018-11-15', 3973, 'ENERGY', 29187, 29187, '2018-10-01', '2018-10-01', '2018-11-22', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2018-11-15 13:25:05', 'dbo', ''),
(2018100023, 201810, 48, 23, '2018-11-15', 3974, 'ENERGY', 77425, 77425, '2018-10-01', '2018-10-01', '2018-11-22', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2018-11-15 13:25:05', 'dbo', ''),
(2018100024, 201810, 48, 24, '2018-11-15', 3975, 'ENERGY', 47443, 47443, '2018-10-01', '2018-10-01', '2018-11-22', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2018-11-15 13:25:05', 'dbo', ''),
(2018100025, 201810, 48, 25, '2018-11-15', 3976, 'ENERGY', 117084, 111696, '2018-10-01', '2018-10-01', '2018-11-22', 5388, 2212112.5300, 0.0000, 106849.5400, 2318962.0700, '2018-11-15 13:25:04', 'dbo', ''),
(2018100026, 201810, 48, 26, '2018-11-15', 3977, 'ENERGY', 77968, 76426, '2018-10-01', '2018-10-01', '2018-11-22', 1542, 1320251.3974, 0.0000, 30579.4300, 1350830.8274, '2018-11-15 13:25:04', 'dbo', ''),
(2018100029, 201810, 48, 29, '2018-11-15', 3978, 'ENERGY', 108274, 106145, '2018-10-01', '2018-10-01', '2018-11-22', 2129, 1741218.8188, 0.0000, 42220.2400, 1783439.0588, '2018-11-15 13:25:04', 'dbo', ''),
(2018100030, 201810, 48, 30, '2018-11-15', 3979, 'ENERGY', 52879, 51776, '2018-10-01', '2018-10-01', '2018-11-22', 1103, 746201.4212, 0.0000, 21873.6000, 768075.0212, '2018-11-15 13:25:04', 'dbo', ''),
(2018100031, 201810, 48, 31, '2018-11-15', 3980, 'ENERGY', 86762, 84669, '2018-10-01', '2018-10-01', '2018-11-22', 2093, 1425275.3480, 0.0000, 41506.3400, 1466781.6880, '2018-11-15 13:25:04', 'dbo', ''),
(2018100032, 201810, 48, 32, '2018-11-15', 3981, 'ENERGY', 144813, 141373, '2018-10-01', '2018-10-01', '2018-11-22', 3440, 2394605.3590, 0.0000, 68218.7200, 2462824.0790, '2018-11-15 13:25:04', 'dbo', ''),
(2018100033, 201810, 48, 33, '2018-11-15', 3982, 'ENERGY', 21042, 20339, '2018-10-01', '2018-10-01', '2018-11-22', 703, 373028.6834, 0.0000, 13941.2100, 386969.8934, '2018-11-15 13:25:04', 'dbo', ''),
(2018100034, 201810, 48, 34, '2018-11-15', 3983, 'ENERGY', 12922, 12922, '2018-10-01', '2018-10-01', '2018-11-22', 0, 239147.7542, 0.0000, 0.0000, 239147.7542, '2018-11-15 13:25:05', 'dbo', ''),
(2018100035, 201810, 48, 35, '2018-11-15', 3984, 'ENERGY', 20983, 20561, '2018-10-01', '2018-10-01', '2018-11-22', 422, 350100.5026, 0.0000, 8368.6900, 358469.1926, '2018-11-15 13:25:04', 'dbo', ''),
(2018100036, 201810, 48, 36, '2018-11-15', 3985, 'ENERGY', 51050, 50669, '2018-10-01', '2018-10-01', '2018-11-22', 381, 891736.2838, 0.0000, 7555.6300, 899291.9138, '2018-11-15 13:25:04', 'dbo', ''),
(2018100037, 201810, 48, 37, '2018-11-15', 3986, 'ENERGY', 28223, 27407, '2018-10-01', '2018-10-01', '2018-11-22', 816, 463926.8510, 0.0000, 16182.1200, 480108.9710, '2018-11-15 13:25:04', 'dbo', ''),
(2018100038, 201810, 48, 38, '2018-11-15', 3987, 'ENERGY', 16872, 16208, '2018-10-01', '2018-10-01', '2018-11-22', 664, 294946.1434, 0.0000, 13167.8000, 308113.9434, '2018-11-15 13:25:04', 'dbo', ''),
(2018100039, 201810, 48, 39, '2018-11-15', 3988, 'ENERGY', 31450, 30890, '2018-10-01', '2018-10-01', '2018-11-22', 560, -82723.2218, 0.0000, 11105.3700, -71617.8518, '2018-11-15 13:25:04', 'dbo', ''),
(2018100040, 201810, 48, 40, '2018-11-15', 3989, 'ENERGY', 39064, 37334, '2018-10-01', '2018-10-01', '2018-11-22', 1730, 679968.0396, 0.0000, 34307.6600, 714275.6996, '2018-11-15 13:25:04', 'dbo', ''),
(2018100041, 201810, 48, 41, '2018-11-15', 3990, 'ENERGY', 241, 241, '2018-10-01', '2018-10-01', '2018-11-22', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2018-11-15 13:25:05', 'dbo', ''),
(2018100042, 201810, 48, 42, '2018-11-15', 3991, 'ENERGY', 334, 334, '2018-10-01', '2018-10-01', '2018-11-22', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2018-11-15 13:25:05', 'dbo', ''),
(2018100043, 201810, 48, 43, '2018-11-15', 3992, 'ENERGY', 86486, 84520, '2018-10-01', '2018-10-01', '2018-11-22', 1966, 1310952.3102, 0.0000, 38987.7900, 1349940.1002, '2018-11-15 13:25:04', 'dbo', ''),
(2018100044, 201810, 48, 44, '2018-11-15', 3993, 'ENERGY', 49446, 48397, '2018-10-01', '2018-10-01', '2018-11-22', 1049, 924011.1130, 0.0000, 20802.7500, 944813.8630, '2018-11-15 13:25:04', 'dbo', ''),
(2018100045, 201810, 48, 45, '2018-11-15', 3994, 'ENERGY', 39643, 38973, '2018-10-01', '2018-10-01', '2018-11-22', 670, 464999.3120, 0.0000, 13286.7800, 478286.0920, '2018-11-15 13:25:04', 'dbo', ''),
(2018100046, 201810, 48, 46, '2018-11-15', 3995, 'ENERGY', 62583, 61616, '2018-10-01', '2018-10-01', '2018-11-22', 967, 1115651.4654, 0.0000, 19176.5800, 1134828.0454, '2018-11-15 13:25:04', 'dbo', ''),
(2018100047, 201810, 48, 47, '2018-11-15', 3996, 'ENERGY', 32521, 31816, '2018-10-01', '2018-10-01', '2018-11-22', 705, 463600.2510, 0.0000, 13980.8700, 477581.1210, '2018-11-15 13:25:05', 'dbo', ''),
(2018100048, 201810, 48, 48, '2018-11-15', 3997, 'ENERGY', 22626, 21635, '2018-10-01', '2018-10-01', '2018-11-22', 991, 433617.2800, 0.0000, 19652.5400, 453269.8200, '2018-11-15 13:25:05', 'dbo', ''),
(2018100049, 201810, 48, 49, '2018-11-15', 3998, 'ENERGY', 8132, 7932, '2018-10-01', '2018-10-01', '2018-11-22', 200, 144138.9490, 0.0000, 3966.2000, 148105.1490, '2018-11-15 13:25:04', 'dbo', ''),
(2018100050, 201810, 48, 50, '2018-11-15', 3999, 'ENERGY', 104162, 102174, '2018-10-01', '2018-10-01', '2018-11-22', 1988, 1655894.3692, 0.0000, 39424.0700, 1695318.4392, '2018-11-15 13:25:04', 'dbo', ''),
(2018100051, 201810, 48, 51, '2018-11-15', 4000, 'ENERGY', 211, 211, '2018-10-01', '2018-10-01', '2018-11-22', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2018-11-15 13:25:05', 'dbo', ''),
(2018100052, 201810, 48, 52, '2018-11-15', 4001, 'ENERGY', 321, 321, '2018-10-01', '2018-10-01', '2018-11-22', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2018-11-15 13:25:05', 'dbo', ''),
(2018100053, 201810, 48, 53, '2018-11-15', 4002, 'ENERGY', 6852, 6020, '2018-10-01', '2018-10-01', '2018-11-22', 832, 130592.0870, 0.0000, 16499.4100, 147091.4970, '2018-11-15 13:25:04', 'dbo', ''),
(2018100054, 201810, 48, 54, '2018-11-15', 4003, 'ENERGY', 38137, 37363, '2018-10-01', '2018-10-01', '2018-11-22', 774, 471239.5794, 0.0000, 15349.2100, 486588.7894, '2018-11-15 13:25:04', 'dbo', ''),
(2018100055, 201810, 48, 55, '2018-11-15', 4004, 'ENERGY', 13690, 13289, '2018-10-01', '2018-10-01', '2018-11-22', 401, 251433.4200, 0.0000, 7952.2400, 259385.6600, '2018-11-15 13:25:04', 'dbo', ''),
(2018100056, 201810, 48, 56, '2018-11-15', 4005, 'ENERGY', 2646, 1923, '2018-10-01', '2018-10-01', '2018-11-22', 723, 45569.8490, 0.0000, 14337.8100, 59907.6590, '2018-11-15 13:25:04', 'dbo', ''),
(2018100059, 201810, 48, 59, '2018-11-15', 4006, 'ENERGY', 128, 128, '2018-10-01', '2018-10-01', '2018-11-22', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2018-11-15 13:25:05', 'dbo', ''),
(2018100060, 201810, 48, 60, '2018-11-15', 4007, 'ENERGY', 305749, 290458, '2018-10-01', '2018-10-01', '2018-11-22', 15291, 4277603.1200, 0.0000, 303236.1500, 4580839.2700, '2018-11-15 13:25:04', 'dbo', ''),
(2018100061, 201810, 48, 61, '2018-11-15', 4008, 'ENERGY', 16, 16, '2018-10-01', '2018-10-01', '2018-11-22', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2018-11-15 13:25:05', 'dbo', ''),
(2018100062, 201810, 48, 62, '2018-11-15', 4009, 'ENERGY', 30, 30, '2018-10-01', '2018-10-01', '2018-11-22', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-11-15 13:25:05', 'dbo', ''),
(2018100063, 201810, 48, 63, '2018-11-15', 4010, 'ENERGY', 1, 1, '2018-10-01', '2018-10-01', '2018-11-22', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-11-15 13:25:05', 'dbo', ''),
(2018100064, 201810, 48, 64, '2018-11-15', 4011, 'ENERGY', 2, 2, '2018-10-01', '2018-10-01', '2018-11-22', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-11-15 13:25:05', 'dbo', ''),
(2018100065, 201810, 48, 65, '2018-11-15', 4012, 'ENERGY', 12881, 12385, '2018-10-01', '2018-10-01', '2018-11-22', 496, 250306.1180, 0.0000, 9836.1800, 260142.2980, '2018-11-15 13:25:04', 'dbo', ''),
(2018100066, 201810, 48, 66, '2018-11-15', 4013, 'ENERGY', 9644, 9215, '2018-10-01', '2018-10-01', '2018-11-22', 429, 185589.5824, 0.0000, 8507.5000, 194097.0824, '2018-11-15 13:25:04', 'dbo', ''),
(2018100067, 201810, 48, 67, '2018-11-15', 4014, 'ENERGY', 1171, 1131, '2018-10-01', '2018-10-01', '2018-11-22', 40, 30952.1938, 0.0000, 793.2400, 31745.4338, '2018-11-15 13:25:05', 'dbo', ''),
(2018100068, 201810, 48, 68, '2018-11-15', 4015, 'ENERGY', 2686, 2529, '2018-10-01', '2018-10-01', '2018-11-22', 157, 59478.6300, 0.0000, 3113.4700, 62592.1000, '2018-11-15 13:25:05', 'dbo', ''),
(2018100069, 201810, 48, 69, '2018-11-15', 4016, 'ENERGY', 1, 1, '2018-10-01', '2018-10-01', '2018-11-22', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2018-11-15 13:25:05', 'dbo', ''),
(2018100070, 201810, 48, 70, '2018-11-15', 4017, 'ENERGY', 2244, 2090, '2018-10-01', '2018-10-01', '2018-11-22', 154, 50936.8900, 0.0000, 3053.9700, 53990.8600, '2018-11-15 13:25:05', 'dbo', ''),
(2018100071, 201810, 48, 71, '2018-11-15', 4018, 'ENERGY', 241222, 232301, '2018-10-01', '2018-10-01', '2018-11-22', 8921, 4440115.5062, 0.0000, 176912.5400, 4617028.0462, '2018-11-15 13:25:04', 'dbo', ''),
(2018100072, 201810, 48, 72, '2018-11-15', 4019, 'ENERGY', 2083, 1967, '2018-10-01', '2018-10-01', '2018-11-22', 116, 49001.7700, 0.0000, 2300.3900, 51302.1600, '2018-11-15 13:25:04', 'dbo', ''),
(2018100073, 201810, 48, 73, '2018-11-15', 4020, 'ENERGY', 484, 483, '2018-10-01', '2018-10-01', '2018-11-22', 1, 26326.2580, 0.0000, 19.8200, 26346.0780, '2018-11-15 13:25:04', 'dbo', ''),
(2018100075, 201810, 48, 75, '2018-11-15', 4021, 'ENERGY', 1794, 1762, '2018-10-01', '2018-10-01', '2018-11-22', 32, 43865.2300, 0.0000, 634.5900, 44499.8200, '2018-11-15 13:25:04', 'dbo', ''),
(2018100076, 201810, 48, 76, '2018-11-15', 4022, 'ENERGY', 1914, 1871, '2018-10-01', '2018-10-01', '2018-11-22', 43, 45600.6100, 0.0000, 852.7400, 46453.3500, '2018-11-15 13:25:04', 'dbo', ''),
(2018100077, 201810, 48, 77, '2018-11-15', 4023, 'ENERGY', 1503, 1472, '2018-10-01', '2018-10-01', '2018-11-22', 31, 38161.7900, 0.0000, 614.7500, 38776.5400, '2018-11-15 13:25:04', 'dbo', ''),
(2018100078, 201810, 48, 78, '2018-11-15', 4024, 'ENERGY', 458, 445, '2018-10-01', '2018-10-01', '2018-11-22', 13, 17726.2000, 0.0000, 257.8000, 17984.0000, '2018-11-15 13:25:04', 'dbo', ''),
(2018100079, 201810, 48, 79, '2018-11-15', 4025, 'ENERGY', 51691, 50407, '2018-10-01', '2018-10-01', '2018-11-22', 1284, 864448.7200, 0.0000, 25463.0300, 889911.7500, '2018-11-15 13:25:04', 'dbo', ''),
(2018100081, 201810, 48, 81, '2018-11-15', 4027, 'ENERGY', 1940, 1885, '2018-10-01', '2018-10-01', '2018-11-22', 55, 43232.5500, 0.0000, 1090.7000, 44323.2500, '2018-11-15 13:25:04', 'dbo', ''),
(2018100082, 201810, 48, 82, '2018-11-15', 4028, 'ENERGY', 4041, 3905, '2018-10-01', '2018-10-01', '2018-11-22', 136, 84032.4500, 0.0000, 2697.0200, 86729.4700, '2018-11-15 13:25:04', 'dbo', ''),
(2018100083, 201810, 48, 83, '2018-11-15', 4029, 'ENERGY', 102, 98, '2018-10-01', '2018-10-01', '2018-11-22', 4, 7763.5900, 0.0000, 79.3200, 7842.9100, '2018-11-15 13:25:04', 'dbo', ''),
(2018100084, 201810, 48, 84, '2018-11-15', 4030, 'ENERGY', 162, 162, '2018-10-01', '2018-10-01', '2018-11-22', 0, 8810.4900, 0.0000, 0.0000, 8810.4900, '2018-11-15 13:25:05', 'dbo', ''),
(2018100085, 201810, 48, 85, '2018-11-15', 4031, 'ENERGY', 355, 355, '2018-10-01', '2018-10-01', '2018-11-22', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2018-11-15 13:25:05', 'dbo', ''),
(2018100086, 201810, 48, 86, '2018-11-15', 4032, 'ENERGY', 114, 109, '2018-10-01', '2018-10-01', '2018-11-22', 5, 7364.5000, 0.0000, 99.1600, 7463.6600, '2018-11-15 13:25:04', 'dbo', '');
INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2018110001, 201811, 49, 1, '2018-12-10', 4033, 'ENERGY', 0, 0, '2018-11-01', '2018-10-01', '2018-12-17', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2018-12-10 09:49:34', 'dbo', ''),
(2018110002, 201811, 49, 2, '2018-12-10', 4034, 'ENERGY', 0, 0, '2018-11-01', '2018-10-01', '2018-12-17', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2018-12-10 09:49:34', 'dbo', ''),
(2018110003, 201811, 49, 3, '2018-12-10', 4035, 'ENERGY', 0, 0, '2018-11-01', '2018-10-01', '2018-12-17', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2018-12-10 09:49:34', 'dbo', ''),
(2018110004, 201811, 49, 4, '2018-12-10', 4036, 'ENERGY', 0, 0, '2018-11-01', '2018-10-01', '2018-12-17', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2018-12-10 09:49:34', 'dbo', ''),
(2018110005, 201811, 49, 5, '2018-12-10', 4037, 'ENERGY', 0, 0, '2018-11-01', '2018-10-01', '2018-12-17', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2018-12-10 09:49:34', 'dbo', ''),
(2018110006, 201811, 49, 6, '2018-12-10', 4038, 'ENERGY', 0, 0, '2018-11-01', '2018-10-01', '2018-12-17', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2018-12-10 09:49:34', 'dbo', ''),
(2018110007, 201811, 49, 7, '2018-12-10', 4039, 'ENERGY', 0, 0, '2018-11-01', '2018-10-01', '2018-12-17', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2018-12-10 09:49:34', 'dbo', ''),
(2018110008, 201811, 49, 8, '2018-12-10', 4040, 'ENERGY', 0, 0, '2018-11-01', '2018-10-01', '2018-12-17', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2018-12-10 09:49:34', 'dbo', ''),
(2018110009, 201811, 49, 9, '2018-12-10', 4041, 'ENERGY', 11173, 11030, '2018-11-01', '2018-10-01', '2018-12-17', 143, 241238.9064, 0.0000, 2875.5000, 244114.4064, '2018-12-10 09:49:33', 'dbo', ''),
(2018110010, 201811, 49, 10, '2018-12-10', 4042, 'ENERGY', 776, 775, '2018-11-01', '2018-10-01', '2018-12-17', 1, 23741.2580, 0.0000, 20.1100, 23761.3680, '2018-12-10 09:49:33', 'dbo', ''),
(2018110011, 201811, 49, 11, '2018-12-10', 4043, 'ENERGY', 201, 201, '2018-11-01', '2018-10-01', '2018-12-17', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2018-12-10 09:49:34', 'dbo', ''),
(2018110012, 201811, 49, 12, '2018-12-10', 4044, 'ENERGY', 137, 137, '2018-11-01', '2018-10-01', '2018-12-17', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2018-12-10 09:49:34', 'dbo', ''),
(2018110013, 201811, 49, 13, '2018-12-10', 4045, 'ENERGY', 19994, 19008, '2018-11-01', '2018-10-01', '2018-12-17', 986, 392477.2940, 0.0000, 19826.8800, 412304.1740, '2018-12-10 09:49:34', 'dbo', ''),
(2018110014, 201811, 49, 14, '2018-12-10', 4046, 'ENERGY', 10185, 9651, '2018-11-01', '2018-10-01', '2018-12-17', 534, 207032.2754, 0.0000, 10737.8800, 217770.1554, '2018-12-10 09:49:34', 'dbo', ''),
(2018110015, 201811, 49, 15, '2018-12-10', 4047, 'ENERGY', 162, 162, '2018-11-01', '2018-10-01', '2018-12-17', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2018-12-10 09:49:34', 'dbo', ''),
(2018110016, 201811, 49, 16, '2018-12-10', 4048, 'ENERGY', 13569, 13065, '2018-11-01', '2018-10-01', '2018-12-17', 504, 269214.4220, 0.0000, 10134.6300, 279349.0520, '2018-12-10 09:49:34', 'dbo', ''),
(2018110017, 201811, 49, 17, '2018-12-10', 4049, 'ENERGY', 43543, 41724, '2018-11-01', '2018-10-01', '2018-12-17', 1819, 837104.8170, 0.0000, 36577.1700, 873681.9870, '2018-12-10 09:49:33', 'dbo', ''),
(2018110018, 201811, 49, 18, '2018-12-10', 4050, 'ENERGY', 10707, 10201, '2018-11-01', '2018-10-01', '2018-12-17', 506, 209177.2800, 0.0000, 10174.8500, 219352.1300, '2018-12-10 09:49:33', 'dbo', ''),
(2018110019, 201811, 49, 19, '2018-12-10', 4051, 'ENERGY', 75, 75, '2018-11-01', '2018-10-01', '2018-12-17', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2018-12-10 09:49:34', 'dbo', ''),
(2018110020, 201811, 49, 20, '2018-12-10', 4052, 'ENERGY', 254, 254, '2018-11-01', '2018-10-01', '2018-12-17', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2018-12-10 09:49:34', 'dbo', ''),
(2018110021, 201811, 49, 21, '2018-12-10', 4053, 'ENERGY', 48754, 48754, '2018-11-01', '2018-10-01', '2018-12-17', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2018-12-10 09:49:34', 'dbo', ''),
(2018110022, 201811, 49, 22, '2018-12-10', 4054, 'ENERGY', 29187, 29187, '2018-11-01', '2018-10-01', '2018-12-17', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2018-12-10 09:49:34', 'dbo', ''),
(2018110023, 201811, 49, 23, '2018-12-10', 4055, 'ENERGY', 77425, 77425, '2018-11-01', '2018-10-01', '2018-12-17', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2018-12-10 09:49:34', 'dbo', ''),
(2018110024, 201811, 49, 24, '2018-12-10', 4056, 'ENERGY', 47443, 47443, '2018-11-01', '2018-10-01', '2018-12-17', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2018-12-10 09:49:34', 'dbo', ''),
(2018110025, 201811, 49, 25, '2018-12-10', 4057, 'ENERGY', 122131, 117084, '2018-11-01', '2018-10-01', '2018-12-17', 5047, 2318962.0700, 0.0000, 101487.0700, 2420449.1400, '2018-12-10 09:49:33', 'dbo', ''),
(2018110026, 201811, 49, 26, '2018-12-10', 4058, 'ENERGY', 79530, 77968, '2018-11-01', '2018-10-01', '2018-12-17', 1562, 1350830.8274, 0.0000, 31409.3200, 1382240.1474, '2018-12-10 09:49:33', 'dbo', ''),
(2018110029, 201811, 49, 29, '2018-12-10', 4059, 'ENERGY', 110262, 108274, '2018-11-01', '2018-10-01', '2018-12-17', 1988, 1783439.0588, 0.0000, 39975.4800, 1823414.5388, '2018-12-10 09:49:33', 'dbo', ''),
(2018110030, 201811, 49, 30, '2018-12-10', 4060, 'ENERGY', 53918, 52879, '2018-11-01', '2018-10-01', '2018-12-17', 1039, 768075.0212, 0.0000, 20892.6200, 788967.6412, '2018-12-10 09:49:34', 'dbo', ''),
(2018110031, 201811, 49, 31, '2018-12-10', 4061, 'ENERGY', 88842, 86762, '2018-11-01', '2018-10-01', '2018-12-17', 2080, 1466781.6880, 0.0000, 41825.4700, 1508607.1580, '2018-12-10 09:49:34', 'dbo', ''),
(2018110032, 201811, 49, 32, '2018-12-10', 4062, 'ENERGY', 147858, 144813, '2018-11-01', '2018-10-01', '2018-12-17', 3045, 2462824.0790, 0.0000, 61230.0600, 2524054.1390, '2018-12-10 09:49:34', 'dbo', ''),
(2018110033, 201811, 49, 33, '2018-12-10', 4063, 'ENERGY', 21742, 21042, '2018-11-01', '2018-10-01', '2018-12-17', 700, 386969.8934, 0.0000, 14075.8800, 401045.7734, '2018-12-10 09:49:33', 'dbo', ''),
(2018110034, 201811, 49, 34, '2018-12-10', 4064, 'ENERGY', 12923, 12922, '2018-11-01', '2018-10-01', '2018-12-17', 1, 239147.7542, 0.0000, 20.1100, 239167.8642, '2018-12-10 09:49:33', 'dbo', ''),
(2018110035, 201811, 49, 35, '2018-12-10', 4065, 'ENERGY', 21376, 20983, '2018-11-01', '2018-10-01', '2018-12-17', 393, 358469.1926, 0.0000, 7902.5900, 366371.7826, '2018-12-10 09:49:33', 'dbo', ''),
(2018110036, 201811, 49, 36, '2018-12-10', 4066, 'ENERGY', 51430, 51050, '2018-11-01', '2018-10-01', '2018-12-17', 380, 899291.9138, 0.0000, 7641.1900, 906933.1038, '2018-12-10 09:49:33', 'dbo', ''),
(2018110037, 201811, 49, 37, '2018-12-10', 4067, 'ENERGY', 28786, 28223, '2018-11-01', '2018-10-01', '2018-12-17', 563, 480108.9710, 0.0000, 11321.0200, 491429.9910, '2018-12-10 09:49:33', 'dbo', ''),
(2018110038, 201811, 49, 38, '2018-12-10', 4068, 'ENERGY', 17203, 16872, '2018-11-01', '2018-10-01', '2018-12-17', 331, 308113.9434, 0.0000, 6655.8900, 314769.8334, '2018-12-10 09:49:33', 'dbo', ''),
(2018110039, 201811, 49, 39, '2018-12-10', 4069, 'ENERGY', 31993, 31450, '2018-11-01', '2018-10-01', '2018-12-17', 543, -71617.8518, 0.0000, 10918.8500, -60699.0018, '2018-12-10 09:49:33', 'dbo', ''),
(2018110040, 201811, 49, 40, '2018-12-10', 4070, 'ENERGY', 40663, 39064, '2018-11-01', '2018-10-01', '2018-12-17', 1599, 714275.6996, 0.0000, 32153.3300, 746429.0296, '2018-12-10 09:49:33', 'dbo', ''),
(2018110041, 201811, 49, 41, '2018-12-10', 4071, 'ENERGY', 241, 241, '2018-11-01', '2018-10-01', '2018-12-17', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2018-12-10 09:49:34', 'dbo', ''),
(2018110042, 201811, 49, 42, '2018-12-10', 4072, 'ENERGY', 334, 334, '2018-11-01', '2018-10-01', '2018-12-17', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2018-12-10 09:49:34', 'dbo', ''),
(2018110043, 201811, 49, 43, '2018-12-10', 4073, 'ENERGY', 88626, 86486, '2018-11-01', '2018-10-01', '2018-12-17', 2140, 1349940.1002, 0.0000, 43031.9600, 1392972.0602, '2018-12-10 09:49:33', 'dbo', ''),
(2018110044, 201811, 49, 44, '2018-12-10', 4074, 'ENERGY', 50524, 49446, '2018-11-01', '2018-10-01', '2018-12-17', 1078, 944813.8630, 0.0000, 21676.8600, 966490.7230, '2018-12-10 09:49:33', 'dbo', ''),
(2018110045, 201811, 49, 45, '2018-12-10', 4075, 'ENERGY', 40223, 39643, '2018-11-01', '2018-10-01', '2018-12-17', 580, 478286.0920, 0.0000, 11662.8800, 489948.9720, '2018-12-10 09:49:34', 'dbo', ''),
(2018110046, 201811, 49, 46, '2018-12-10', 4076, 'ENERGY', 63481, 62583, '2018-11-01', '2018-10-01', '2018-12-17', 898, 1134828.0454, 0.0000, 18057.3400, 1152885.3854, '2018-12-10 09:49:34', 'dbo', ''),
(2018110047, 201811, 49, 47, '2018-12-10', 4077, 'ENERGY', 33368, 32521, '2018-11-01', '2018-10-01', '2018-12-17', 847, 477581.1210, 0.0000, 17031.8100, 494612.9310, '2018-12-10 09:49:34', 'dbo', ''),
(2018110048, 201811, 49, 48, '2018-12-10', 4078, 'ENERGY', 23591, 22626, '2018-11-01', '2018-10-01', '2018-12-17', 965, 453269.8200, 0.0000, 19404.6000, 472674.4200, '2018-12-10 09:49:34', 'dbo', ''),
(2018110049, 201811, 49, 49, '2018-12-10', 4079, 'ENERGY', 8335, 8132, '2018-11-01', '2018-10-01', '2018-12-17', 203, 148105.1490, 0.0000, 4082.0100, 152187.1590, '2018-12-10 09:49:33', 'dbo', ''),
(2018110050, 201811, 49, 50, '2018-12-10', 4080, 'ENERGY', 106170, 104162, '2018-11-01', '2018-10-01', '2018-12-17', 2008, 1695318.4392, 0.0000, 40377.6500, 1735696.0892, '2018-12-10 09:49:33', 'dbo', ''),
(2018110051, 201811, 49, 51, '2018-12-10', 4081, 'ENERGY', 211, 211, '2018-11-01', '2018-10-01', '2018-12-17', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2018-12-10 09:49:34', 'dbo', ''),
(2018110052, 201811, 49, 52, '2018-12-10', 4082, 'ENERGY', 321, 321, '2018-11-01', '2018-10-01', '2018-12-17', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2018-12-10 09:49:34', 'dbo', ''),
(2018110053, 201811, 49, 53, '2018-12-10', 4083, 'ENERGY', 7742, 6852, '2018-11-01', '2018-10-01', '2018-12-17', 890, 147091.4970, 0.0000, 17896.4800, 164987.9770, '2018-12-10 09:49:34', 'dbo', ''),
(2018110054, 201811, 49, 54, '2018-12-10', 4084, 'ENERGY', 38834, 38137, '2018-11-01', '2018-10-01', '2018-12-17', 697, 486588.7894, 0.0000, 14015.5500, 500604.3394, '2018-12-10 09:49:34', 'dbo', ''),
(2018110055, 201811, 49, 55, '2018-12-10', 4085, 'ENERGY', 14094, 13690, '2018-11-01', '2018-10-01', '2018-12-17', 404, 259385.6600, 0.0000, 8123.7900, 267509.4500, '2018-12-10 09:49:34', 'dbo', ''),
(2018110056, 201811, 49, 56, '2018-12-10', 4086, 'ENERGY', 3486, 2646, '2018-11-01', '2018-10-01', '2018-12-17', 840, 59907.6590, 0.0000, 16891.0400, 76798.6990, '2018-12-10 09:49:34', 'dbo', ''),
(2018110059, 201811, 49, 59, '2018-12-10', 4087, 'ENERGY', 128, 128, '2018-11-01', '2018-10-01', '2018-12-17', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2018-12-10 09:49:34', 'dbo', ''),
(2018110060, 201811, 49, 60, '2018-12-10', 4088, 'ENERGY', 311510, 305749, '2018-11-01', '2018-10-01', '2018-12-17', 5761, 4580839.2700, 0.0000, 115844.4500, 4696683.7200, '2018-12-10 09:49:33', 'dbo', ''),
(2018110061, 201811, 49, 61, '2018-12-10', 4089, 'ENERGY', 16, 16, '2018-11-01', '2018-10-01', '2018-12-17', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2018-12-10 09:49:34', 'dbo', ''),
(2018110062, 201811, 49, 62, '2018-12-10', 4090, 'ENERGY', 30, 30, '2018-11-01', '2018-10-01', '2018-12-17', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-12-10 09:49:34', 'dbo', ''),
(2018110063, 201811, 49, 63, '2018-12-10', 4091, 'ENERGY', 1, 1, '2018-11-01', '2018-10-01', '2018-12-17', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-12-10 09:49:34', 'dbo', ''),
(2018110064, 201811, 49, 64, '2018-12-10', 4092, 'ENERGY', 2, 2, '2018-11-01', '2018-10-01', '2018-12-17', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2018-12-10 09:49:34', 'dbo', ''),
(2018110065, 201811, 49, 65, '2018-12-10', 4093, 'ENERGY', 13338, 12881, '2018-11-01', '2018-10-01', '2018-12-17', 457, 260142.2980, 0.0000, 9189.5400, 269331.8380, '2018-12-10 09:49:33', 'dbo', ''),
(2018110066, 201811, 49, 66, '2018-12-10', 4094, 'ENERGY', 10024, 9644, '2018-11-01', '2018-10-01', '2018-12-17', 380, 194097.0824, 0.0000, 7641.1900, 201738.2724, '2018-12-10 09:49:33', 'dbo', ''),
(2018110067, 201811, 49, 67, '2018-12-10', 4095, 'ENERGY', 1206, 1171, '2018-11-01', '2018-10-01', '2018-12-17', 35, 31745.4338, 0.0000, 703.8000, 32449.2338, '2018-12-10 09:49:34', 'dbo', ''),
(2018110068, 201811, 49, 68, '2018-12-10', 4096, 'ENERGY', 2838, 2686, '2018-11-01', '2018-10-01', '2018-12-17', 152, 62592.1000, 0.0000, 3056.4800, 65648.5800, '2018-12-10 09:49:34', 'dbo', ''),
(2018110069, 201811, 49, 69, '2018-12-10', 4097, 'ENERGY', 1, 1, '2018-11-01', '2018-10-01', '2018-12-17', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2018-12-10 09:49:34', 'dbo', ''),
(2018110070, 201811, 49, 70, '2018-12-10', 4098, 'ENERGY', 2244, 2244, '2018-11-01', '2018-10-01', '2018-12-17', 0, 53990.8600, 0.0000, 0.0000, 53990.8600, '2018-12-10 09:49:34', 'dbo', ''),
(2018110071, 201811, 49, 71, '2018-12-10', 4099, 'ENERGY', 241222, 241222, '2018-11-01', '2018-10-01', '2018-12-17', 0, 4617028.0462, 0.0000, 0.0000, 4617028.0462, '2018-12-10 09:49:34', 'dbo', ''),
(2018110072, 201811, 49, 72, '2018-12-10', 4100, 'ENERGY', 2083, 2083, '2018-11-01', '2018-10-01', '2018-12-17', 0, 51302.1600, 0.0000, 0.0000, 51302.1600, '2018-12-10 09:49:34', 'dbo', ''),
(2018110073, 201811, 49, 73, '2018-12-10', 4101, 'ENERGY', 484, 484, '2018-11-01', '2018-10-01', '2018-12-17', 0, 26346.0780, 0.0000, 0.0000, 26346.0780, '2018-12-10 09:49:34', 'dbo', ''),
(2018110075, 201811, 49, 75, '2018-12-10', 4102, 'ENERGY', 1794, 1794, '2018-11-01', '2018-10-01', '2018-12-17', 0, 44499.8200, 0.0000, 0.0000, 44499.8200, '2018-12-10 09:49:34', 'dbo', ''),
(2018110076, 201811, 49, 76, '2018-12-10', 4103, 'ENERGY', 1914, 1914, '2018-11-01', '2018-10-01', '2018-12-17', 0, 46453.3500, 0.0000, 0.0000, 46453.3500, '2018-12-10 09:49:34', 'dbo', ''),
(2018110077, 201811, 49, 77, '2018-12-10', 4104, 'ENERGY', 1503, 1503, '2018-11-01', '2018-10-01', '2018-12-17', 0, 38776.5400, 0.0000, 0.0000, 38776.5400, '2018-12-10 09:49:34', 'dbo', ''),
(2018110078, 201811, 49, 78, '2018-12-10', 4105, 'ENERGY', 458, 458, '2018-11-01', '2018-10-01', '2018-12-17', 0, 17984.0000, 0.0000, 0.0000, 17984.0000, '2018-12-10 09:49:34', 'dbo', ''),
(2018110079, 201811, 49, 79, '2018-12-10', 4106, 'ENERGY', 51691, 51691, '2018-11-01', '2018-10-01', '2018-12-17', 0, 889911.7500, 0.0000, 0.0000, 889911.7500, '2018-12-10 09:49:34', 'dbo', ''),
(2018110081, 201811, 49, 81, '2018-12-10', 4108, 'ENERGY', 1940, 1940, '2018-11-01', '2018-10-01', '2018-12-17', 0, 44323.2500, 0.0000, 0.0000, 44323.2500, '2018-12-10 09:49:34', 'dbo', ''),
(2018110082, 201811, 49, 82, '2018-12-10', 4109, 'ENERGY', 4041, 4041, '2018-11-01', '2018-10-01', '2018-12-17', 0, 86729.4700, 0.0000, 0.0000, 86729.4700, '2018-12-10 09:49:34', 'dbo', ''),
(2018110083, 201811, 49, 83, '2018-12-10', 4110, 'ENERGY', 102, 102, '2018-11-01', '2018-10-01', '2018-12-17', 0, 7842.9100, 0.0000, 0.0000, 7842.9100, '2018-12-10 09:49:34', 'dbo', ''),
(2018110084, 201811, 49, 84, '2018-12-10', 4111, 'ENERGY', 162, 162, '2018-11-01', '2018-10-01', '2018-12-17', 0, 8810.4900, 0.0000, 0.0000, 8810.4900, '2018-12-10 09:49:34', 'dbo', ''),
(2018110085, 201811, 49, 85, '2018-12-10', 4112, 'ENERGY', 355, 355, '2018-11-01', '2018-10-01', '2018-12-17', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2018-12-10 09:49:34', 'dbo', ''),
(2018110086, 201811, 49, 86, '2018-12-10', 4113, 'ENERGY', 114, 114, '2018-11-01', '2018-10-01', '2018-12-17', 0, 7463.6600, 0.0000, 0.0000, 7463.6600, '2018-12-10 09:49:34', 'dbo', ''),
(2018120001, 201812, 50, 1, '2019-01-07', 4114, 'ENERGY', 0, 0, '2018-12-01', '2018-11-01', '2019-01-14', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2019-01-09 09:47:11', 'dbo', ''),
(2018120002, 201812, 50, 2, '2019-01-07', 4115, 'ENERGY', 0, 0, '2018-12-01', '2018-11-01', '2019-01-14', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2019-01-09 09:47:11', 'dbo', ''),
(2018120003, 201812, 50, 3, '2019-01-07', 4116, 'ENERGY', 0, 0, '2018-12-01', '2018-11-01', '2019-01-14', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2019-01-09 09:47:11', 'dbo', ''),
(2018120004, 201812, 50, 4, '2019-01-07', 4117, 'ENERGY', 0, 0, '2018-12-01', '2018-11-01', '2019-01-14', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2019-01-09 09:47:11', 'dbo', ''),
(2018120005, 201812, 50, 5, '2019-01-07', 4118, 'ENERGY', 0, 0, '2018-12-01', '2018-11-01', '2019-01-14', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2019-01-09 09:47:11', 'dbo', ''),
(2018120006, 201812, 50, 6, '2019-01-07', 4119, 'ENERGY', 0, 0, '2018-12-01', '2018-11-01', '2019-01-14', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2019-01-09 09:47:11', 'dbo', ''),
(2018120007, 201812, 50, 7, '2019-01-07', 4120, 'ENERGY', 0, 0, '2018-12-01', '2018-11-01', '2019-01-14', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2019-01-09 09:47:11', 'dbo', ''),
(2018120008, 201812, 50, 8, '2019-01-07', 4121, 'ENERGY', 0, 0, '2018-12-01', '2018-11-01', '2019-01-14', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2019-01-09 09:47:11', 'dbo', ''),
(2018120009, 201812, 50, 9, '2019-01-07', 4122, 'ENERGY', 11321, 11173, '2018-12-01', '2018-11-01', '2019-01-14', 148, 244114.4064, 0.0000, 3010.8600, 247125.2664, '2019-01-09 09:47:10', 'dbo', ''),
(2018120010, 201812, 50, 10, '2019-01-07', 4123, 'ENERGY', 776, 776, '2018-12-01', '2018-11-01', '2019-01-14', 0, 23761.3680, 0.0000, 0.0000, 23761.3680, '2019-01-09 09:47:11', 'dbo', ''),
(2018120011, 201812, 50, 11, '2019-01-07', 4124, 'ENERGY', 201, 201, '2018-12-01', '2018-11-01', '2019-01-14', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2019-01-09 09:47:11', 'dbo', ''),
(2018120012, 201812, 50, 12, '2019-01-07', 4125, 'ENERGY', 137, 137, '2018-12-01', '2018-11-01', '2019-01-14', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2019-01-09 09:47:11', 'dbo', ''),
(2018120013, 201812, 50, 13, '2019-01-07', 4126, 'ENERGY', 20656, 19994, '2018-12-01', '2018-11-01', '2019-01-14', 662, 412304.1740, 0.0000, 13467.5200, 425771.6940, '2019-01-09 09:47:11', 'dbo', ''),
(2018120014, 201812, 50, 14, '2019-01-07', 4127, 'ENERGY', 10616, 10185, '2018-12-01', '2018-11-01', '2019-01-14', 431, 217770.1554, 0.0000, 8768.1400, 226538.2954, '2019-01-09 09:47:11', 'dbo', ''),
(2018120015, 201812, 50, 15, '2019-01-07', 4128, 'ENERGY', 162, 162, '2018-12-01', '2018-11-01', '2019-01-14', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2019-01-09 09:47:11', 'dbo', ''),
(2018120016, 201812, 50, 16, '2019-01-07', 4129, 'ENERGY', 13939, 13569, '2018-12-01', '2018-11-01', '2019-01-14', 370, 279349.0520, 0.0000, 7527.1700, 286876.2220, '2019-01-09 09:47:11', 'dbo', ''),
(2018120017, 201812, 50, 17, '2019-01-07', 4130, 'ENERGY', 45049, 43543, '2018-12-01', '2018-11-01', '2019-01-14', 1506, 873681.9870, 0.0000, 30637.5900, 904319.5770, '2019-01-09 09:47:10', 'dbo', ''),
(2018120018, 201812, 50, 18, '2019-01-07', 4131, 'ENERGY', 10977, 10707, '2018-12-01', '2018-11-01', '2019-01-14', 270, 219352.1300, 0.0000, 5492.8100, 224844.9400, '2019-01-09 09:47:10', 'dbo', ''),
(2018120019, 201812, 50, 19, '2019-01-07', 4132, 'ENERGY', 75, 75, '2018-12-01', '2018-11-01', '2019-01-14', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2019-01-09 09:47:11', 'dbo', ''),
(2018120020, 201812, 50, 20, '2019-01-07', 4133, 'ENERGY', 254, 254, '2018-12-01', '2018-11-01', '2019-01-14', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2019-01-09 09:47:11', 'dbo', ''),
(2018120021, 201812, 50, 21, '2019-01-07', 4134, 'ENERGY', 48754, 48754, '2018-12-01', '2018-11-01', '2019-01-14', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2019-01-09 09:47:11', 'dbo', ''),
(2018120022, 201812, 50, 22, '2019-01-07', 4135, 'ENERGY', 29187, 29187, '2018-12-01', '2018-11-01', '2019-01-14', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2019-01-09 09:47:11', 'dbo', ''),
(2018120023, 201812, 50, 23, '2019-01-07', 4136, 'ENERGY', 77425, 77425, '2018-12-01', '2018-11-01', '2019-01-14', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2019-01-09 09:47:11', 'dbo', ''),
(2018120024, 201812, 50, 24, '2019-01-07', 4137, 'ENERGY', 47443, 47443, '2018-12-01', '2018-11-01', '2019-01-14', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2019-01-09 09:47:11', 'dbo', ''),
(2018120025, 201812, 50, 25, '2019-01-07', 4138, 'ENERGY', 126720, 122131, '2018-12-01', '2018-11-01', '2019-01-14', 4589, 2420449.1400, 0.0000, 93357.1800, 2513806.3200, '2019-01-09 09:47:10', 'dbo', ''),
(2018120026, 201812, 50, 26, '2019-01-07', 4139, 'ENERGY', 80781, 79530, '2018-12-01', '2018-11-01', '2019-01-14', 1251, 1382240.1474, 0.0000, 25449.9600, 1407690.1074, '2019-01-09 09:47:10', 'dbo', ''),
(2018120029, 201812, 50, 29, '2019-01-07', 4140, 'ENERGY', 111978, 110262, '2018-12-01', '2018-11-01', '2019-01-14', 1716, 1823414.5388, 0.0000, 34909.7700, 1858324.3088, '2019-01-09 09:47:10', 'dbo', ''),
(2018120030, 201812, 50, 30, '2019-01-07', 4141, 'ENERGY', 54738, 53918, '2018-12-01', '2018-11-01', '2019-01-14', 820, 788967.6412, 0.0000, 16681.8300, 805649.4712, '2019-01-09 09:47:10', 'dbo', ''),
(2018120031, 201812, 50, 31, '2019-01-07', 4142, 'ENERGY', 90728, 88842, '2018-12-01', '2018-11-01', '2019-01-14', 1886, 1508607.1580, 0.0000, 38368.2000, 1546975.3580, '2019-01-09 09:47:10', 'dbo', ''),
(2018120032, 201812, 50, 32, '2019-01-07', 4143, 'ENERGY', 150692, 147858, '2018-12-01', '2018-11-01', '2019-01-14', 2834, 2524054.1390, 0.0000, 57654.0100, 2581708.1490, '2019-01-09 09:47:10', 'dbo', ''),
(2018120033, 201812, 50, 33, '2019-01-07', 4144, 'ENERGY', 22297, 21742, '2018-12-01', '2018-11-01', '2019-01-14', 555, 401045.7734, 0.0000, 11290.7500, 412336.5234, '2019-01-09 09:47:10', 'dbo', ''),
(2018120034, 201812, 50, 34, '2019-01-07', 4145, 'ENERGY', 12924, 12923, '2018-12-01', '2018-11-01', '2019-01-14', 1, 239167.8642, 0.0000, 20.3400, 239188.2042, '2019-01-09 09:47:10', 'dbo', ''),
(2018120035, 201812, 50, 35, '2019-01-07', 4146, 'ENERGY', 21631, 21376, '2018-12-01', '2018-11-01', '2019-01-14', 255, 366371.7826, 0.0000, 5187.6400, 371559.4226, '2019-01-09 09:47:10', 'dbo', ''),
(2018120036, 201812, 50, 36, '2019-01-07', 4147, 'ENERGY', 51716, 51430, '2018-12-01', '2018-11-01', '2019-01-14', 286, 906933.1038, 0.0000, 5818.2900, 912751.3938, '2019-01-09 09:47:10', 'dbo', ''),
(2018120037, 201812, 50, 37, '2019-01-07', 4148, 'ENERGY', 29178, 28786, '2018-12-01', '2018-11-01', '2019-01-14', 392, 491429.9910, 0.0000, 7974.7200, 499404.7110, '2019-01-09 09:47:10', 'dbo', ''),
(2018120038, 201812, 50, 38, '2019-01-07', 4149, 'ENERGY', 17538, 17203, '2018-12-01', '2018-11-01', '2019-01-14', 335, 314769.8334, 0.0000, 6815.1300, 321584.9634, '2019-01-09 09:47:10', 'dbo', ''),
(2018120039, 201812, 50, 39, '2019-01-07', 4150, 'ENERGY', 32375, 31993, '2018-12-01', '2018-11-01', '2019-01-14', 382, -60699.0018, 0.0000, 7771.2900, -52927.7118, '2019-01-09 09:47:10', 'dbo', ''),
(2018120040, 201812, 50, 40, '2019-01-07', 4151, 'ENERGY', 41891, 40663, '2018-12-01', '2018-11-01', '2019-01-14', 1228, 746429.0296, 0.0000, 24982.0600, 771411.0896, '2019-01-09 09:47:10', 'dbo', ''),
(2018120041, 201812, 50, 41, '2019-01-07', 4152, 'ENERGY', 241, 241, '2018-12-01', '2018-11-01', '2019-01-14', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2019-01-09 09:47:11', 'dbo', ''),
(2018120042, 201812, 50, 42, '2019-01-07', 4153, 'ENERGY', 334, 334, '2018-12-01', '2018-11-01', '2019-01-14', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2019-01-09 09:47:11', 'dbo', ''),
(2018120043, 201812, 50, 43, '2019-01-07', 4154, 'ENERGY', 90102, 88626, '2018-12-01', '2018-11-01', '2019-01-14', 1476, 1392972.0602, 0.0000, 30027.2800, 1422999.3402, '2019-01-09 09:47:10', 'dbo', ''),
(2018120044, 201812, 50, 44, '2019-01-07', 4155, 'ENERGY', 51361, 50524, '2018-12-01', '2018-11-01', '2019-01-14', 837, 966490.7230, 0.0000, 17027.6700, 983518.3930, '2019-01-09 09:47:10', 'dbo', ''),
(2018120045, 201812, 50, 45, '2019-01-07', 4156, 'ENERGY', 40652, 40223, '2018-12-01', '2018-11-01', '2019-01-14', 429, 489948.9720, 0.0000, 8727.4400, 498676.4120, '2019-01-09 09:47:10', 'dbo', ''),
(2018120046, 201812, 50, 46, '2019-01-07', 4157, 'ENERGY', 64171, 63481, '2018-12-01', '2018-11-01', '2019-01-14', 690, 1152885.3854, 0.0000, 14037.1400, 1166922.5254, '2019-01-09 09:47:11', 'dbo', ''),
(2018120047, 201812, 50, 47, '2019-01-07', 4158, 'ENERGY', 33887, 33368, '2018-12-01', '2018-11-01', '2019-01-14', 519, 494612.9310, 0.0000, 10558.3700, 505171.3010, '2019-01-09 09:47:11', 'dbo', ''),
(2018120048, 201812, 50, 48, '2019-01-07', 4159, 'ENERGY', 24364, 23591, '2018-12-01', '2018-11-01', '2019-01-14', 773, 472674.4200, 0.0000, 15725.6700, 488400.0900, '2019-01-09 09:47:11', 'dbo', ''),
(2018120049, 201812, 50, 49, '2019-01-07', 4160, 'ENERGY', 8486, 8335, '2018-12-01', '2018-11-01', '2019-01-14', 151, 152187.1590, 0.0000, 3071.9000, 155259.0590, '2019-01-09 09:47:10', 'dbo', ''),
(2018120050, 201812, 50, 50, '2019-01-07', 4161, 'ENERGY', 107882, 106170, '2018-12-01', '2018-11-01', '2019-01-14', 1712, 1735696.0892, 0.0000, 34828.4000, 1770524.4892, '2019-01-09 09:47:10', 'dbo', ''),
(2018120051, 201812, 50, 51, '2019-01-07', 4162, 'ENERGY', 211, 211, '2018-12-01', '2018-11-01', '2019-01-14', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2019-01-09 09:47:11', 'dbo', ''),
(2018120052, 201812, 50, 52, '2019-01-07', 4163, 'ENERGY', 321, 321, '2018-12-01', '2018-11-01', '2019-01-14', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2019-01-09 09:47:11', 'dbo', ''),
(2018120053, 201812, 50, 53, '2019-01-07', 4164, 'ENERGY', 8317, 7742, '2018-12-01', '2018-11-01', '2019-01-14', 575, 164987.9770, 0.0000, 11697.6200, 176685.5970, '2019-01-09 09:47:11', 'dbo', ''),
(2018120054, 201812, 50, 54, '2019-01-07', 4165, 'ENERGY', 39355, 38834, '2018-12-01', '2018-11-01', '2019-01-14', 521, 500604.3394, 0.0000, 10599.0600, 511203.3994, '2019-01-09 09:47:11', 'dbo', ''),
(2018120055, 201812, 50, 55, '2019-01-07', 4166, 'ENERGY', 14361, 14094, '2018-12-01', '2018-11-01', '2019-01-14', 267, 267509.4500, 0.0000, 5431.7600, 272941.2100, '2019-01-09 09:47:11', 'dbo', ''),
(2018120056, 201812, 50, 56, '2019-01-07', 4167, 'ENERGY', 4091, 3486, '2018-12-01', '2018-11-01', '2019-01-14', 605, 76798.6990, 0.0000, 12307.9300, 89106.6290, '2019-01-09 09:47:11', 'dbo', ''),
(2018120059, 201812, 50, 59, '2019-01-07', 4168, 'ENERGY', 128, 128, '2018-12-01', '2018-11-01', '2019-01-14', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2019-01-09 09:47:11', 'dbo', ''),
(2018120060, 201812, 50, 60, '2019-01-07', 4169, 'ENERGY', 316976, 311510, '2018-12-01', '2018-11-01', '2019-01-14', 5466, 4696683.7200, 0.0000, 111198.6100, 4807882.3300, '2019-01-09 09:47:10', 'dbo', ''),
(2018120061, 201812, 50, 61, '2019-01-07', 4170, 'ENERGY', 16, 16, '2018-12-01', '2018-11-01', '2019-01-14', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2019-01-09 09:47:11', 'dbo', ''),
(2018120062, 201812, 50, 62, '2019-01-07', 4171, 'ENERGY', 30, 30, '2018-12-01', '2018-11-01', '2019-01-14', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-01-09 09:47:11', 'dbo', ''),
(2018120063, 201812, 50, 63, '2019-01-07', 4172, 'ENERGY', 1, 1, '2018-12-01', '2018-11-01', '2019-01-14', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-01-09 09:47:11', 'dbo', ''),
(2018120064, 201812, 50, 64, '2019-01-07', 4173, 'ENERGY', 2, 2, '2018-12-01', '2018-11-01', '2019-01-14', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-01-09 09:47:11', 'dbo', ''),
(2018120065, 201812, 50, 65, '2019-01-07', 4174, 'ENERGY', 13693, 13338, '2018-12-01', '2018-11-01', '2019-01-14', 355, 269331.8380, 0.0000, 7222.0100, 276553.8480, '2019-01-09 09:47:10', 'dbo', ''),
(2018120066, 201812, 50, 66, '2019-01-07', 4175, 'ENERGY', 10296, 10024, '2018-12-01', '2018-11-01', '2019-01-14', 272, 201738.2724, 0.0000, 5533.4800, 207271.7524, '2019-01-09 09:47:10', 'dbo', ''),
(2018120067, 201812, 50, 67, '2019-01-07', 4176, 'ENERGY', 1234, 1206, '2018-12-01', '2018-11-01', '2019-01-14', 28, 32449.2338, 0.0000, 569.6300, 33018.8638, '2019-01-09 09:47:11', 'dbo', ''),
(2018120068, 201812, 50, 68, '2019-01-07', 4177, 'ENERGY', 2931, 2838, '2018-12-01', '2018-11-01', '2019-01-14', 93, 65648.5800, 0.0000, 1891.9600, 67540.5400, '2019-01-09 09:47:11', 'dbo', ''),
(2018120069, 201812, 50, 69, '2019-01-07', 4178, 'ENERGY', 1, 1, '2018-12-01', '2018-11-01', '2019-01-14', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2019-01-09 09:47:11', 'dbo', ''),
(2018120070, 201812, 50, 70, '2019-01-07', 4179, 'ENERGY', 2510, 2244, '2018-12-01', '2018-11-01', '2019-01-14', 266, 53990.8600, 0.0000, 5411.4300, 59402.2900, '2019-01-09 09:47:11', 'dbo', ''),
(2018120071, 201812, 50, 71, '2019-01-07', 4180, 'ENERGY', 256224, 241222, '2018-12-01', '2018-11-01', '2019-01-14', 15002, 4617028.0462, 0.0000, 305196.0200, 4922224.0662, '2019-01-09 09:47:10', 'dbo', ''),
(2018120072, 201812, 50, 72, '2019-01-07', 4181, 'ENERGY', 2240, 2083, '2018-12-01', '2018-11-01', '2019-01-14', 157, 51302.1600, 0.0000, 3193.9700, 54496.1300, '2019-01-09 09:47:10', 'dbo', ''),
(2018120073, 201812, 50, 73, '2019-01-07', 4182, 'ENERGY', 489, 484, '2018-12-01', '2018-11-01', '2019-01-14', 5, 26346.0780, 0.0000, 101.7100, 26447.7880, '2019-01-09 09:47:10', 'dbo', ''),
(2018120075, 201812, 50, 75, '2019-01-07', 4183, 'ENERGY', 1853, 1794, '2018-12-01', '2018-11-01', '2019-01-14', 59, 44499.8200, 0.0000, 1200.2700, 45700.0900, '2019-01-09 09:47:10', 'dbo', ''),
(2018120076, 201812, 50, 76, '2019-01-07', 4184, 'ENERGY', 1994, 1914, '2018-12-01', '2018-11-01', '2019-01-14', 80, 46453.3500, 0.0000, 1627.4900, 48080.8400, '2019-01-09 09:47:10', 'dbo', ''),
(2018120077, 201812, 50, 77, '2019-01-07', 4185, 'ENERGY', 1561, 1503, '2018-12-01', '2018-11-01', '2019-01-14', 58, 38776.5400, 0.0000, 1179.9300, 39956.4700, '2019-01-09 09:47:10', 'dbo', ''),
(2018120078, 201812, 50, 78, '2019-01-07', 4186, 'ENERGY', 481, 458, '2018-12-01', '2018-11-01', '2019-01-14', 23, 17984.0000, 0.0000, 467.9200, 18451.9200, '2019-01-09 09:47:10', 'dbo', ''),
(2018120079, 201812, 50, 79, '2019-01-07', 4187, 'ENERGY', 54207, 51691, '2018-12-01', '2018-11-01', '2019-01-14', 2516, 889911.7500, 0.0000, 51184.7200, 941096.4700, '2019-01-09 09:47:10', 'dbo', ''),
(2018120081, 201812, 50, 81, '2019-01-07', 4189, 'ENERGY', 2044, 1940, '2018-12-01', '2018-11-01', '2019-01-14', 104, 44323.2500, 0.0000, 2115.7400, 46438.9900, '2019-01-09 09:47:10', 'dbo', ''),
(2018120082, 201812, 50, 82, '2019-01-07', 4190, 'ENERGY', 4297, 4041, '2018-12-01', '2018-11-01', '2019-01-14', 256, 86729.4700, 0.0000, 5207.9900, 91937.4600, '2019-01-09 09:47:10', 'dbo', ''),
(2018120083, 201812, 50, 83, '2019-01-07', 4191, 'ENERGY', 108, 102, '2018-12-01', '2018-11-01', '2019-01-14', 6, 7842.9100, 0.0000, 122.0600, 7964.9700, '2019-01-09 09:47:10', 'dbo', ''),
(2018120084, 201812, 50, 84, '2019-01-07', 4192, 'ENERGY', 162, 162, '2018-12-01', '2018-11-01', '2019-01-14', 0, 8810.4900, 0.0000, 0.0000, 8810.4900, '2019-01-09 09:47:11', 'dbo', ''),
(2018120085, 201812, 50, 85, '2019-01-07', 4193, 'ENERGY', 355, 355, '2018-12-01', '2018-11-01', '2019-01-14', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2019-01-09 09:47:11', 'dbo', ''),
(2018120086, 201812, 50, 86, '2019-01-07', 4194, 'ENERGY', 122, 114, '2018-12-01', '2018-11-01', '2019-01-14', 8, 7463.6600, 0.0000, 162.7500, 7626.4100, '2019-01-09 09:47:10', 'dbo', ''),
(2019010001, 201901, 51, 1, '2019-02-12', 4195, 'ENERGY', 0, 0, '2019-01-01', '2018-12-01', '2019-02-19', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2019-02-12 09:21:19', 'dbo', ''),
(2019010002, 201901, 51, 2, '2019-02-12', 4196, 'ENERGY', 0, 0, '2019-01-01', '2018-12-01', '2019-02-19', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2019-02-12 09:21:19', 'dbo', ''),
(2019010003, 201901, 51, 3, '2019-02-12', 4197, 'ENERGY', 0, 0, '2019-01-01', '2018-12-01', '2019-02-19', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2019-02-12 09:21:19', 'dbo', ''),
(2019010004, 201901, 51, 4, '2019-02-12', 4198, 'ENERGY', 0, 0, '2019-01-01', '2018-12-01', '2019-02-19', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2019-02-12 09:21:19', 'dbo', ''),
(2019010005, 201901, 51, 5, '2019-02-12', 4199, 'ENERGY', 0, 0, '2019-01-01', '2018-12-01', '2019-02-19', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2019-02-12 09:21:19', 'dbo', ''),
(2019010006, 201901, 51, 6, '2019-02-12', 4200, 'ENERGY', 0, 0, '2019-01-01', '2018-12-01', '2019-02-19', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2019-02-12 09:21:19', 'dbo', ''),
(2019010007, 201901, 51, 7, '2019-02-12', 4201, 'ENERGY', 0, 0, '2019-01-01', '2018-12-01', '2019-02-19', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2019-02-12 09:21:19', 'dbo', ''),
(2019010008, 201901, 51, 8, '2019-02-12', 4202, 'ENERGY', 0, 0, '2019-01-01', '2018-12-01', '2019-02-19', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2019-02-12 09:21:19', 'dbo', ''),
(2019010009, 201901, 51, 9, '2019-02-12', 4203, 'ENERGY', 11321, 11321, '2019-01-01', '2018-12-01', '2019-02-19', 0, 247125.2664, 0.0000, 0.0000, 247125.2664, '2019-02-12 09:21:19', 'dbo', ''),
(2019010010, 201901, 51, 10, '2019-02-12', 4204, 'ENERGY', 776, 776, '2019-01-01', '2018-12-01', '2019-02-19', 0, 23761.3680, 0.0000, 0.0000, 23761.3680, '2019-02-12 09:21:19', 'dbo', ''),
(2019010011, 201901, 51, 11, '2019-02-12', 4205, 'ENERGY', 201, 201, '2019-01-01', '2018-12-01', '2019-02-19', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2019-02-12 09:21:19', 'dbo', ''),
(2019010012, 201901, 51, 12, '2019-02-12', 4206, 'ENERGY', 137, 137, '2019-01-01', '2018-12-01', '2019-02-19', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2019-02-12 09:21:19', 'dbo', ''),
(2019010013, 201901, 51, 13, '2019-02-12', 4207, 'ENERGY', 21562, 20656, '2019-01-01', '2018-12-01', '2019-02-19', 906, 425771.6940, 0.0000, 18267.3500, 444039.0440, '2019-02-12 09:21:18', 'dbo', ''),
(2019010014, 201901, 51, 14, '2019-02-12', 4208, 'ENERGY', 11018, 10616, '2019-01-01', '2018-12-01', '2019-02-19', 402, 226538.2954, 0.0000, 8105.3900, 234643.6854, '2019-02-12 09:21:18', 'dbo', ''),
(2019010015, 201901, 51, 15, '2019-02-12', 4209, 'ENERGY', 162, 162, '2019-01-01', '2018-12-01', '2019-02-19', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2019-02-12 09:21:19', 'dbo', ''),
(2019010016, 201901, 51, 16, '2019-02-12', 4210, 'ENERGY', 14593, 13939, '2019-01-01', '2018-12-01', '2019-02-19', 654, 286876.2220, 0.0000, 13186.3700, 300062.5920, '2019-02-12 09:21:18', 'dbo', ''),
(2019010017, 201901, 51, 17, '2019-02-12', 4211, 'ENERGY', 47123, 45049, '2019-01-01', '2018-12-01', '2019-02-19', 2074, 904319.5770, 0.0000, 41817.3200, 946136.8970, '2019-02-12 09:21:18', 'dbo', ''),
(2019010018, 201901, 51, 18, '2019-02-12', 4212, 'ENERGY', 11462, 10977, '2019-01-01', '2018-12-01', '2019-02-19', 485, 224844.9400, 0.0000, 9778.8900, 234623.8300, '2019-02-12 09:21:18', 'dbo', ''),
(2019010019, 201901, 51, 19, '2019-02-12', 4213, 'ENERGY', 75, 75, '2019-01-01', '2018-12-01', '2019-02-19', 0, 2234.3450, 0.0000, 0.0000, 2234.3450, '2019-02-12 09:21:19', 'dbo', ''),
(2019010020, 201901, 51, 20, '2019-02-12', 4214, 'ENERGY', 254, 254, '2019-01-01', '2018-12-01', '2019-02-19', 0, 7079.4130, 0.0000, 0.0000, 7079.4130, '2019-02-12 09:21:19', 'dbo', ''),
(2019010021, 201901, 51, 21, '2019-02-12', 4215, 'ENERGY', 48754, 48754, '2019-01-01', '2018-12-01', '2019-02-19', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2019-02-12 09:21:19', 'dbo', ''),
(2019010022, 201901, 51, 22, '2019-02-12', 4216, 'ENERGY', 29187, 29187, '2019-01-01', '2018-12-01', '2019-02-19', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2019-02-12 09:21:19', 'dbo', ''),
(2019010023, 201901, 51, 23, '2019-02-12', 4217, 'ENERGY', 77425, 77425, '2019-01-01', '2018-12-01', '2019-02-19', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2019-02-12 09:21:19', 'dbo', ''),
(2019010024, 201901, 51, 24, '2019-02-12', 4218, 'ENERGY', 47443, 47443, '2019-01-01', '2018-12-01', '2019-02-19', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2019-02-12 09:21:19', 'dbo', ''),
(2019010025, 201901, 51, 25, '2019-02-12', 4219, 'ENERGY', 132041, 126720, '2019-01-01', '2018-12-01', '2019-02-19', 5321, 2513806.3200, 0.0000, 107285.4500, 2621091.7700, '2019-02-12 09:21:18', 'dbo', ''),
(2019010026, 201901, 51, 26, '2019-02-12', 4220, 'ENERGY', 82373, 80781, '2019-01-01', '2018-12-01', '2019-02-19', 1592, 1407690.1074, 0.0000, 32098.9400, 1439789.0474, '2019-02-12 09:21:18', 'dbo', ''),
(2019010029, 201901, 51, 29, '2019-02-12', 4221, 'ENERGY', 113974, 111978, '2019-01-01', '2018-12-01', '2019-02-19', 1996, 1858324.3088, 0.0000, 40244.6300, 1898568.9388, '2019-02-12 09:21:19', 'dbo', ''),
(2019010030, 201901, 51, 30, '2019-02-12', 4222, 'ENERGY', 55800, 54738, '2019-01-01', '2018-12-01', '2019-02-19', 1062, 805649.4712, 0.0000, 21412.7200, 827062.1912, '2019-02-12 09:21:19', 'dbo', ''),
(2019010031, 201901, 51, 31, '2019-02-12', 4223, 'ENERGY', 92897, 90728, '2019-01-01', '2018-12-01', '2019-02-19', 2169, 1546975.3580, 0.0000, 43732.7800, 1590708.1380, '2019-02-12 09:21:19', 'dbo', ''),
(2019010032, 201901, 51, 32, '2019-02-12', 4224, 'ENERGY', 153860, 150692, '2019-01-01', '2018-12-01', '2019-02-19', 3168, 2581708.1490, 0.0000, 63875.2700, 2645583.4190, '2019-02-12 09:21:19', 'dbo', ''),
(2019010033, 201901, 51, 33, '2019-02-12', 4225, 'ENERGY', 22945, 22297, '2019-01-01', '2018-12-01', '2019-02-19', 648, 412336.5234, 0.0000, 13065.3900, 425401.9134, '2019-02-12 09:21:18', 'dbo', ''),
(2019010034, 201901, 51, 34, '2019-02-12', 4226, 'ENERGY', 12924, 12924, '2019-01-01', '2018-12-01', '2019-02-19', 0, 239188.2042, 0.0000, 0.0000, 239188.2042, '2019-02-12 09:21:19', 'dbo', ''),
(2019010035, 201901, 51, 35, '2019-02-12', 4227, 'ENERGY', 21961, 21631, '2019-01-01', '2018-12-01', '2019-02-19', 330, 371559.4226, 0.0000, 6653.6800, 378213.1026, '2019-02-12 09:21:18', 'dbo', ''),
(2019010036, 201901, 51, 36, '2019-02-12', 4228, 'ENERGY', 52077, 51716, '2019-01-01', '2018-12-01', '2019-02-19', 361, 912751.3938, 0.0000, 7278.7100, 920030.1038, '2019-02-12 09:21:18', 'dbo', ''),
(2019010037, 201901, 51, 37, '2019-02-12', 4229, 'ENERGY', 29722, 29178, '2019-01-01', '2018-12-01', '2019-02-19', 544, 499404.7110, 0.0000, 10968.4900, 510373.2010, '2019-02-12 09:21:19', 'dbo', ''),
(2019010038, 201901, 51, 38, '2019-02-12', 4230, 'ENERGY', 17901, 17538, '2019-01-01', '2018-12-01', '2019-02-19', 363, 321584.9634, 0.0000, 7319.0400, 328904.0034, '2019-02-12 09:21:19', 'dbo', ''),
(2019010039, 201901, 51, 39, '2019-02-12', 4231, 'ENERGY', 32852, 32375, '2019-01-01', '2018-12-01', '2019-02-19', 477, -52927.7118, 0.0000, 9617.5900, -43310.1218, '2019-02-12 09:21:19', 'dbo', ''),
(2019010040, 201901, 51, 40, '2019-02-12', 4232, 'ENERGY', 43502, 41891, '2019-01-01', '2018-12-01', '2019-02-19', 1611, 771411.0896, 0.0000, 32482.0200, 803893.1096, '2019-02-12 09:21:19', 'dbo', ''),
(2019010041, 201901, 51, 41, '2019-02-12', 4233, 'ENERGY', 241, 241, '2019-01-01', '2018-12-01', '2019-02-19', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2019-02-12 09:21:19', 'dbo', ''),
(2019010042, 201901, 51, 42, '2019-02-12', 4234, 'ENERGY', 334, 334, '2019-01-01', '2018-12-01', '2019-02-19', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2019-02-12 09:21:19', 'dbo', ''),
(2019010043, 201901, 51, 43, '2019-02-12', 4235, 'ENERGY', 92303, 90102, '2019-01-01', '2018-12-01', '2019-02-19', 2201, 1422999.3402, 0.0000, 44377.9900, 1467377.3302, '2019-02-12 09:21:18', 'dbo', ''),
(2019010044, 201901, 51, 44, '2019-02-12', 4236, 'ENERGY', 52732, 51361, '2019-01-01', '2018-12-01', '2019-02-19', 1371, 983518.3930, 0.0000, 27642.9800, 1011161.3730, '2019-02-12 09:21:18', 'dbo', ''),
(2019010045, 201901, 51, 45, '2019-02-12', 4237, 'ENERGY', 41260, 40652, '2019-01-01', '2018-12-01', '2019-02-19', 608, 498676.4120, 0.0000, 12258.8700, 510935.2820, '2019-02-12 09:21:18', 'dbo', ''),
(2019010046, 201901, 51, 46, '2019-02-12', 4238, 'ENERGY', 65030, 64171, '2019-01-01', '2018-12-01', '2019-02-19', 859, 1166922.5254, 0.0000, 17319.7200, 1184242.2454, '2019-02-12 09:21:19', 'dbo', ''),
(2019010047, 201901, 51, 47, '2019-02-12', 4239, 'ENERGY', 34464, 33887, '2019-01-01', '2018-12-01', '2019-02-19', 577, 505171.3010, 0.0000, 11633.8500, 516805.1510, '2019-02-12 09:21:19', 'dbo', ''),
(2019010048, 201901, 51, 48, '2019-02-12', 4240, 'ENERGY', 25329, 24364, '2019-01-01', '2018-12-01', '2019-02-19', 965, 488400.0900, 0.0000, 19456.9500, 507857.0400, '2019-02-12 09:21:19', 'dbo', ''),
(2019010049, 201901, 51, 49, '2019-02-12', 4241, 'ENERGY', 8666, 8486, '2019-01-01', '2018-12-01', '2019-02-19', 180, 155259.0590, 0.0000, 3629.2800, 158888.3390, '2019-02-12 09:21:18', 'dbo', ''),
(2019010050, 201901, 51, 50, '2019-02-12', 4242, 'ENERGY', 109855, 107882, '2019-01-01', '2018-12-01', '2019-02-19', 1973, 1770524.4892, 0.0000, 39780.9000, 1810305.3892, '2019-02-12 09:21:18', 'dbo', ''),
(2019010051, 201901, 51, 51, '2019-02-12', 4243, 'ENERGY', 211, 211, '2019-01-01', '2018-12-01', '2019-02-19', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2019-02-12 09:21:19', 'dbo', ''),
(2019010052, 201901, 51, 52, '2019-02-12', 4244, 'ENERGY', 321, 321, '2019-01-01', '2018-12-01', '2019-02-19', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2019-02-12 09:21:19', 'dbo', ''),
(2019010053, 201901, 51, 53, '2019-02-12', 4245, 'ENERGY', 9014, 8317, '2019-01-01', '2018-12-01', '2019-02-19', 697, 176685.5970, 0.0000, 14053.3800, 190738.9770, '2019-02-12 09:21:18', 'dbo', ''),
(2019010054, 201901, 51, 54, '2019-02-12', 4246, 'ENERGY', 39901, 39355, '2019-01-01', '2018-12-01', '2019-02-19', 546, 511203.3994, 0.0000, 11008.8000, 522212.1994, '2019-02-12 09:21:18', 'dbo', ''),
(2019010055, 201901, 51, 55, '2019-02-12', 4247, 'ENERGY', 14712, 14361, '2019-01-01', '2018-12-01', '2019-02-19', 351, 272941.2100, 0.0000, 7077.0900, 280018.3000, '2019-02-12 09:21:18', 'dbo', ''),
(2019010056, 201901, 51, 56, '2019-02-12', 4248, 'ENERGY', 4986, 4091, '2019-01-01', '2018-12-01', '2019-02-19', 895, 89106.6290, 0.0000, 18045.5700, 107152.1990, '2019-02-12 09:21:18', 'dbo', ''),
(2019010059, 201901, 51, 59, '2019-02-12', 4249, 'ENERGY', 128, 128, '2019-01-01', '2018-12-01', '2019-02-19', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2019-02-12 09:21:19', 'dbo', ''),
(2019010060, 201901, 51, 60, '2019-02-12', 4250, 'ENERGY', 323070, 316976, '2019-01-01', '2018-12-01', '2019-02-19', 6094, 4807882.3300, 0.0000, 122871.1600, 4930753.4900, '2019-02-12 09:21:18', 'dbo', ''),
(2019010061, 201901, 51, 61, '2019-02-12', 4251, 'ENERGY', 16, 16, '2019-01-01', '2018-12-01', '2019-02-19', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2019-02-12 09:21:19', 'dbo', ''),
(2019010062, 201901, 51, 62, '2019-02-12', 4252, 'ENERGY', 30, 30, '2019-01-01', '2018-12-01', '2019-02-19', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-02-12 09:21:19', 'dbo', ''),
(2019010063, 201901, 51, 63, '2019-02-12', 4253, 'ENERGY', 1, 1, '2019-01-01', '2018-12-01', '2019-02-19', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-02-12 09:21:19', 'dbo', ''),
(2019010064, 201901, 51, 64, '2019-02-12', 4254, 'ENERGY', 2, 2, '2019-01-01', '2018-12-01', '2019-02-19', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-02-12 09:21:19', 'dbo', ''),
(2019010065, 201901, 51, 65, '2019-02-12', 4255, 'ENERGY', 14089, 13693, '2019-01-01', '2018-12-01', '2019-02-19', 396, 276553.8480, 0.0000, 7984.4100, 284538.2580, '2019-02-12 09:21:18', 'dbo', ''),
(2019010066, 201901, 51, 66, '2019-02-12', 4256, 'ENERGY', 10636, 10296, '2019-01-01', '2018-12-01', '2019-02-19', 340, 207271.7524, 0.0000, 6855.3100, 214127.0624, '2019-02-12 09:21:18', 'dbo', ''),
(2019010067, 201901, 51, 67, '2019-02-12', 4257, 'ENERGY', 1276, 1234, '2019-01-01', '2018-12-01', '2019-02-19', 42, 33018.8638, 0.0000, 846.8400, 33865.7038, '2019-02-12 09:21:18', 'dbo', ''),
(2019010068, 201901, 51, 68, '2019-02-12', 4258, 'ENERGY', 3094, 2931, '2019-01-01', '2018-12-01', '2019-02-19', 163, 67540.5400, 0.0000, 3286.5100, 70827.0500, '2019-02-12 09:21:18', 'dbo', ''),
(2019010069, 201901, 51, 69, '2019-02-12', 4259, 'ENERGY', 1, 1, '2019-01-01', '2018-12-01', '2019-02-19', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2019-02-12 09:21:19', 'dbo', ''),
(2019010070, 201901, 51, 70, '2019-02-12', 4260, 'ENERGY', 2644, 2510, '2019-01-01', '2018-12-01', '2019-02-19', 134, 59402.2900, 0.0000, 2701.7900, 62104.0800, '2019-02-12 09:21:18', 'dbo', ''),
(2019010071, 201901, 51, 71, '2019-02-12', 4261, 'ENERGY', 263540, 256224, '2019-01-01', '2018-12-01', '2019-02-19', 7316, 4922224.0662, 0.0000, 147509.9200, 5069733.9862, '2019-02-12 09:21:18', 'dbo', ''),
(2019010072, 201901, 51, 72, '2019-02-12', 4262, 'ENERGY', 2298, 2240, '2019-01-01', '2018-12-01', '2019-02-19', 58, 54496.1300, 0.0000, 1169.4300, 55665.5600, '2019-02-12 09:21:18', 'dbo', ''),
(2019010073, 201901, 51, 73, '2019-02-12', 4263, 'ENERGY', 489, 489, '2019-01-01', '2018-12-01', '2019-02-19', 0, 26447.7880, 0.0000, 0.0000, 26447.7880, '2019-02-12 09:21:19', 'dbo', ''),
(2019010075, 201901, 51, 75, '2019-02-12', 4264, 'ENERGY', 1884, 1853, '2019-01-01', '2018-12-01', '2019-02-19', 31, 45700.0900, 0.0000, 625.0500, 46325.1400, '2019-02-12 09:21:18', 'dbo', ''),
(2019010076, 201901, 51, 76, '2019-02-12', 4265, 'ENERGY', 2035, 1994, '2019-01-01', '2018-12-01', '2019-02-19', 41, 48080.8400, 0.0000, 826.6800, 48907.5200, '2019-02-12 09:21:18', 'dbo', ''),
(2019010077, 201901, 51, 77, '2019-02-12', 4266, 'ENERGY', 1591, 1561, '2019-01-01', '2018-12-01', '2019-02-19', 30, 39956.4700, 0.0000, 604.8800, 40561.3500, '2019-02-12 09:21:18', 'dbo', ''),
(2019010078, 201901, 51, 78, '2019-02-12', 4267, 'ENERGY', 492, 481, '2019-01-01', '2018-12-01', '2019-02-19', 11, 18451.9200, 0.0000, 221.7800, 18673.7000, '2019-02-12 09:21:18', 'dbo', ''),
(2019010079, 201901, 51, 79, '2019-02-12', 4268, 'ENERGY', 55490, 54207, '2019-01-01', '2018-12-01', '2019-02-19', 1283, 941096.4700, 0.0000, 25868.6600, 966965.1300, '2019-02-12 09:21:18', 'dbo', ''),
(2019010081, 201901, 51, 81, '2019-02-12', 4270, 'ENERGY', 2097, 2044, '2019-01-01', '2018-12-01', '2019-02-19', 53, 46438.9900, 0.0000, 1068.6200, 47507.6100, '2019-02-12 09:21:18', 'dbo', ''),
(2019010082, 201901, 51, 82, '2019-02-12', 4271, 'ENERGY', 4428, 4297, '2019-01-01', '2018-12-01', '2019-02-19', 131, 91937.4600, 0.0000, 2641.3000, 94578.7600, '2019-02-12 09:21:18', 'dbo', ''),
(2019010083, 201901, 51, 83, '2019-02-12', 4272, 'ENERGY', 112, 108, '2019-01-01', '2018-12-01', '2019-02-19', 4, 7964.9700, 0.0000, 80.6500, 8045.6200, '2019-02-12 09:21:18', 'dbo', ''),
(2019010084, 201901, 51, 84, '2019-02-12', 4273, 'ENERGY', 162, 162, '2019-01-01', '2018-12-01', '2019-02-19', 0, 8810.4900, 0.0000, 0.0000, 8810.4900, '2019-02-12 09:21:19', 'dbo', ''),
(2019010085, 201901, 51, 85, '2019-02-12', 4274, 'ENERGY', 355, 355, '2019-01-01', '2018-12-01', '2019-02-19', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2019-02-12 09:21:19', 'dbo', ''),
(2019010086, 201901, 51, 86, '2019-02-12', 4275, 'ENERGY', 126, 122, '2019-01-01', '2018-12-01', '2019-02-19', 4, 7626.4100, 0.0000, 80.6500, 7707.0600, '2019-02-12 09:21:18', 'dbo', ''),
(2019020001, 201902, 52, 1, '2019-03-29', 4276, 'ENERGY', 0, 0, '2019-02-01', '2019-01-01', '2019-04-05', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2019-04-01 13:10:31', 'dbo', ''),
(2019020002, 201902, 52, 2, '2019-03-29', 4277, 'ENERGY', 0, 0, '2019-02-01', '2019-01-01', '2019-04-05', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2019-04-01 13:10:31', 'dbo', ''),
(2019020003, 201902, 52, 3, '2019-03-29', 4278, 'ENERGY', 0, 0, '2019-02-01', '2019-01-01', '2019-04-05', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2019-04-01 13:10:31', 'dbo', ''),
(2019020004, 201902, 52, 4, '2019-03-29', 4279, 'ENERGY', 0, 0, '2019-02-01', '2019-01-01', '2019-04-05', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2019-04-01 13:10:31', 'dbo', ''),
(2019020005, 201902, 52, 5, '2019-03-29', 4280, 'ENERGY', 0, 0, '2019-02-01', '2019-01-01', '2019-04-05', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2019-04-01 13:10:31', 'dbo', ''),
(2019020006, 201902, 52, 6, '2019-03-29', 4281, 'ENERGY', 0, 0, '2019-02-01', '2019-01-01', '2019-04-05', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2019-04-01 13:10:31', 'dbo', ''),
(2019020007, 201902, 52, 7, '2019-03-29', 4282, 'ENERGY', 0, 0, '2019-02-01', '2019-01-01', '2019-04-05', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2019-04-01 13:10:31', 'dbo', ''),
(2019020008, 201902, 52, 8, '2019-03-29', 4283, 'ENERGY', 0, 0, '2019-02-01', '2019-01-01', '2019-04-05', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2019-04-01 13:10:31', 'dbo', ''),
(2019020009, 201902, 52, 9, '2019-03-29', 4284, 'ENERGY', 11321, 11321, '2019-02-01', '2019-01-01', '2019-04-05', 0, 247125.2664, 0.0000, 0.0000, 247125.2664, '2019-04-01 13:10:31', 'dbo', ''),
(2019020010, 201902, 52, 10, '2019-03-29', 4285, 'ENERGY', 776, 776, '2019-02-01', '2019-01-01', '2019-04-05', 0, 23761.3680, 0.0000, 0.0000, 23761.3680, '2019-04-01 13:10:31', 'dbo', ''),
(2019020011, 201902, 52, 11, '2019-03-29', 4286, 'ENERGY', 201, 201, '2019-02-01', '2019-01-01', '2019-04-05', 0, 10071.5310, 0.0000, 0.0000, 10071.5310, '2019-04-01 13:10:31', 'dbo', ''),
(2019020012, 201902, 52, 12, '2019-03-29', 4287, 'ENERGY', 137, 137, '2019-02-01', '2019-01-01', '2019-04-05', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2019-04-01 13:10:31', 'dbo', ''),
(2019020013, 201902, 52, 13, '2019-03-29', 4288, 'ENERGY', 22380, 21562, '2019-02-01', '2019-01-01', '2019-04-05', 818, 444039.0440, 0.0000, 17497.2800, 461536.3240, '2019-04-01 13:10:31', 'dbo', ''),
(2019020014, 201902, 52, 14, '2019-03-29', 4289, 'ENERGY', 11452, 11018, '2019-02-01', '2019-01-01', '2019-04-05', 434, 234643.6854, 0.0000, 9283.4100, 243927.0954, '2019-04-01 13:10:31', 'dbo', ''),
(2019020015, 201902, 52, 15, '2019-03-29', 4290, 'ENERGY', 162, 162, '2019-02-01', '2019-01-01', '2019-04-05', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2019-04-01 13:10:31', 'dbo', ''),
(2019020016, 201902, 52, 16, '2019-03-29', 4291, 'ENERGY', 15214, 14593, '2019-02-01', '2019-01-01', '2019-04-05', 621, 300062.5920, 0.0000, 13283.3900, 313345.9820, '2019-04-01 13:10:31', 'dbo', ''),
(2019020017, 201902, 52, 17, '2019-03-29', 4292, 'ENERGY', 49648, 47123, '2019-02-01', '2019-01-01', '2019-04-05', 2525, 946136.8970, 0.0000, 54010.5700, 1000147.4670, '2019-04-01 13:10:30', 'dbo', ''),
(2019020018, 201902, 52, 18, '2019-03-29', 4293, 'ENERGY', 12015, 11462, '2019-02-01', '2019-01-01', '2019-04-05', 553, 234623.8300, 0.0000, 11828.8500, 246452.6800, '2019-04-01 13:10:30', 'dbo', '');
INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2019020019, 201902, 52, 19, '2019-03-29', 4294, 'ENERGY', 103, 75, '2019-02-01', '2019-01-01', '2019-04-05', 28, 2234.3450, 0.0000, 598.9200, 2833.2650, '2019-04-01 13:10:30', 'dbo', ''),
(2019020020, 201902, 52, 20, '2019-03-29', 4295, 'ENERGY', 322, 254, '2019-02-01', '2019-01-01', '2019-04-05', 68, 7079.4130, 0.0000, 1454.5400, 8533.9530, '2019-04-01 13:10:30', 'dbo', ''),
(2019020021, 201902, 52, 21, '2019-03-29', 4296, 'ENERGY', 48754, 48754, '2019-02-01', '2019-01-01', '2019-04-05', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2019-04-01 13:10:31', 'dbo', ''),
(2019020022, 201902, 52, 22, '2019-03-29', 4297, 'ENERGY', 29187, 29187, '2019-02-01', '2019-01-01', '2019-04-05', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2019-04-01 13:10:31', 'dbo', ''),
(2019020023, 201902, 52, 23, '2019-03-29', 4298, 'ENERGY', 77425, 77425, '2019-02-01', '2019-01-01', '2019-04-05', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2019-04-01 13:10:31', 'dbo', ''),
(2019020024, 201902, 52, 24, '2019-03-29', 4299, 'ENERGY', 47443, 47443, '2019-02-01', '2019-01-01', '2019-04-05', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2019-04-01 13:10:31', 'dbo', ''),
(2019020025, 201902, 52, 25, '2019-03-29', 4300, 'ENERGY', 136784, 132041, '2019-02-01', '2019-01-01', '2019-04-05', 4743, 2621091.7700, 0.0000, 101454.3000, 2722546.0700, '2019-04-01 13:10:30', 'dbo', ''),
(2019020026, 201902, 52, 26, '2019-03-29', 4301, 'ENERGY', 83605, 82373, '2019-02-01', '2019-01-01', '2019-04-05', 1232, 1439789.0474, 0.0000, 26352.8800, 1466141.9274, '2019-04-01 13:10:30', 'dbo', ''),
(2019020029, 201902, 52, 29, '2019-03-29', 4302, 'ENERGY', 115853, 113974, '2019-02-01', '2019-01-01', '2019-04-05', 1879, 1898568.9388, 0.0000, 40192.4100, 1938761.3488, '2019-04-01 13:10:31', 'dbo', ''),
(2019020030, 201902, 52, 30, '2019-03-29', 4303, 'ENERGY', 56711, 55800, '2019-02-01', '2019-01-01', '2019-04-05', 911, 827062.1912, 0.0000, 19486.5800, 846548.7712, '2019-04-01 13:10:31', 'dbo', ''),
(2019020031, 201902, 52, 31, '2019-03-29', 4304, 'ENERGY', 94884, 92897, '2019-02-01', '2019-01-01', '2019-04-05', 1987, 1590708.1380, 0.0000, 42502.5700, 1633210.7080, '2019-04-01 13:10:31', 'dbo', ''),
(2019020032, 201902, 52, 32, '2019-03-29', 4305, 'ENERGY', 156677, 153860, '2019-02-01', '2019-01-01', '2019-04-05', 2817, 2645583.4190, 0.0000, 60256.5400, 2705839.9590, '2019-04-01 13:10:31', 'dbo', ''),
(2019020033, 201902, 52, 33, '2019-03-29', 4306, 'ENERGY', 23516, 22945, '2019-02-01', '2019-01-01', '2019-04-05', 571, 425401.9134, 0.0000, 12213.8800, 437615.7934, '2019-04-01 13:10:30', 'dbo', ''),
(2019020034, 201902, 52, 34, '2019-03-29', 4307, 'ENERGY', 12925, 12924, '2019-02-01', '2019-01-01', '2019-04-05', 1, 239188.2042, 0.0000, 21.3900, 239209.5942, '2019-04-01 13:10:30', 'dbo', ''),
(2019020035, 201902, 52, 35, '2019-03-29', 4308, 'ENERGY', 22320, 21961, '2019-02-01', '2019-01-01', '2019-04-05', 359, 378213.1026, 0.0000, 7679.1300, 385892.2326, '2019-04-01 13:10:30', 'dbo', ''),
(2019020036, 201902, 52, 36, '2019-03-29', 4309, 'ENERGY', 52440, 52077, '2019-02-01', '2019-01-01', '2019-04-05', 363, 920030.1038, 0.0000, 7764.6900, 927794.7938, '2019-04-01 13:10:30', 'dbo', ''),
(2019020037, 201902, 52, 37, '2019-03-29', 4310, 'ENERGY', 30473, 29722, '2019-02-01', '2019-01-01', '2019-04-05', 751, 510373.2010, 0.0000, 16064.1200, 526437.3210, '2019-04-01 13:10:31', 'dbo', ''),
(2019020038, 201902, 52, 38, '2019-03-29', 4311, 'ENERGY', 18329, 17901, '2019-02-01', '2019-01-01', '2019-04-05', 428, 328904.0034, 0.0000, 9155.0600, 338059.0634, '2019-04-01 13:10:31', 'dbo', ''),
(2019020039, 201902, 52, 39, '2019-03-29', 4312, 'ENERGY', 33397, 32852, '2019-02-01', '2019-01-01', '2019-04-05', 545, -43310.1218, 0.0000, 11657.7200, -31652.4018, '2019-04-01 13:10:31', 'dbo', ''),
(2019020040, 201902, 52, 40, '2019-03-29', 4313, 'ENERGY', 45130, 43502, '2019-02-01', '2019-01-01', '2019-04-05', 1628, 803893.1096, 0.0000, 34823.4500, 838716.5596, '2019-04-01 13:10:31', 'dbo', ''),
(2019020041, 201902, 52, 41, '2019-03-29', 4314, 'ENERGY', 241, 241, '2019-02-01', '2019-01-01', '2019-04-05', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2019-04-01 13:10:31', 'dbo', ''),
(2019020042, 201902, 52, 42, '2019-03-29', 4315, 'ENERGY', 334, 334, '2019-02-01', '2019-01-01', '2019-04-05', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2019-04-01 13:10:31', 'dbo', ''),
(2019020043, 201902, 52, 43, '2019-03-29', 4316, 'ENERGY', 94542, 92303, '2019-02-01', '2019-01-01', '2019-04-05', 2239, 1467377.3302, 0.0000, 47892.9300, 1515270.2602, '2019-04-01 13:10:30', 'dbo', ''),
(2019020044, 201902, 52, 44, '2019-03-29', 4317, 'ENERGY', 53533, 52732, '2019-02-01', '2019-01-01', '2019-04-05', 801, 1011161.3730, 0.0000, 17133.6500, 1028295.0230, '2019-04-01 13:10:30', 'dbo', ''),
(2019020045, 201902, 52, 45, '2019-03-29', 4318, 'ENERGY', 41870, 41260, '2019-02-01', '2019-01-01', '2019-04-05', 610, 510935.2820, 0.0000, 13048.1100, 523983.3920, '2019-04-01 13:10:31', 'dbo', ''),
(2019020046, 201902, 52, 46, '2019-03-29', 4319, 'ENERGY', 65859, 65030, '2019-02-01', '2019-01-01', '2019-04-05', 829, 1184242.2454, 0.0000, 17732.5600, 1201974.8054, '2019-04-01 13:10:31', 'dbo', ''),
(2019020047, 201902, 52, 47, '2019-03-29', 4320, 'ENERGY', 35026, 34464, '2019-02-01', '2019-01-01', '2019-04-05', 562, 516805.1510, 0.0000, 12021.3700, 528826.5210, '2019-04-01 13:10:31', 'dbo', ''),
(2019020048, 201902, 52, 48, '2019-03-29', 4321, 'ENERGY', 26184, 25329, '2019-02-01', '2019-01-01', '2019-04-05', 855, 507857.0400, 0.0000, 18288.7300, 526145.7700, '2019-04-01 13:10:31', 'dbo', ''),
(2019020049, 201902, 52, 49, '2019-03-29', 4322, 'ENERGY', 8852, 8666, '2019-02-01', '2019-01-01', '2019-04-05', 186, 158888.3390, 0.0000, 3978.6000, 162866.9390, '2019-04-01 13:10:30', 'dbo', ''),
(2019020050, 201902, 52, 50, '2019-03-29', 4323, 'ENERGY', 111906, 109855, '2019-02-01', '2019-01-01', '2019-04-05', 2051, 1810305.3892, 0.0000, 43871.5500, 1854176.9392, '2019-04-01 13:10:30', 'dbo', ''),
(2019020051, 201902, 52, 51, '2019-03-29', 4324, 'ENERGY', 211, 211, '2019-02-01', '2019-01-01', '2019-04-05', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2019-04-01 13:10:31', 'dbo', ''),
(2019020052, 201902, 52, 52, '2019-03-29', 4325, 'ENERGY', 321, 321, '2019-02-01', '2019-01-01', '2019-04-05', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2019-04-01 13:10:31', 'dbo', ''),
(2019020053, 201902, 52, 53, '2019-03-29', 4326, 'ENERGY', 9781, 9014, '2019-02-01', '2019-01-01', '2019-04-05', 767, 190738.9770, 0.0000, 16406.3700, 207145.3470, '2019-04-01 13:10:31', 'dbo', ''),
(2019020054, 201902, 52, 54, '2019-03-29', 4327, 'ENERGY', 40200, 39901, '2019-02-01', '2019-01-01', '2019-04-05', 299, 522212.1994, 0.0000, 6395.7100, 528607.9094, '2019-04-01 13:10:31', 'dbo', ''),
(2019020055, 201902, 52, 55, '2019-03-29', 4328, 'ENERGY', 15068, 14712, '2019-02-01', '2019-01-01', '2019-04-05', 356, 280018.3000, 0.0000, 7614.9600, 287633.2600, '2019-04-01 13:10:31', 'dbo', ''),
(2019020056, 201902, 52, 56, '2019-03-29', 4329, 'ENERGY', 5799, 4986, '2019-02-01', '2019-01-01', '2019-04-05', 813, 107152.1990, 0.0000, 17390.3300, 124542.5290, '2019-04-01 13:10:31', 'dbo', ''),
(2019020059, 201902, 52, 59, '2019-03-29', 4330, 'ENERGY', 128, 128, '2019-02-01', '2019-01-01', '2019-04-05', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2019-04-01 13:10:31', 'dbo', ''),
(2019020060, 201902, 52, 60, '2019-03-29', 4331, 'ENERGY', 329401, 323070, '2019-02-01', '2019-01-01', '2019-04-05', 6331, 4930753.4900, 0.0000, 135422.1300, 5066175.6200, '2019-04-01 13:10:30', 'dbo', ''),
(2019020061, 201902, 52, 61, '2019-03-29', 4332, 'ENERGY', 16, 16, '2019-02-01', '2019-01-01', '2019-04-05', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2019-04-01 13:10:31', 'dbo', ''),
(2019020062, 201902, 52, 62, '2019-03-29', 4333, 'ENERGY', 30, 30, '2019-02-01', '2019-01-01', '2019-04-05', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-04-01 13:10:31', 'dbo', ''),
(2019020063, 201902, 52, 63, '2019-03-29', 4334, 'ENERGY', 1, 1, '2019-02-01', '2019-01-01', '2019-04-05', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-04-01 13:10:31', 'dbo', ''),
(2019020064, 201902, 52, 64, '2019-03-29', 4335, 'ENERGY', 2, 2, '2019-02-01', '2019-01-01', '2019-04-05', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-04-01 13:10:31', 'dbo', ''),
(2019020065, 201902, 52, 65, '2019-03-29', 4336, 'ENERGY', 14501, 14089, '2019-02-01', '2019-01-01', '2019-04-05', 412, 284538.2580, 0.0000, 8812.8100, 293351.0680, '2019-04-01 13:10:30', 'dbo', ''),
(2019020066, 201902, 52, 66, '2019-03-29', 4337, 'ENERGY', 10960, 10636, '2019-02-01', '2019-01-01', '2019-04-05', 324, 214127.0624, 0.0000, 6930.4700, 221057.5324, '2019-04-01 13:10:30', 'dbo', ''),
(2019020067, 201902, 52, 67, '2019-03-29', 4338, 'ENERGY', 1310, 1276, '2019-02-01', '2019-01-01', '2019-04-05', 34, 33865.7038, 0.0000, 727.2800, 34592.9838, '2019-04-01 13:10:31', 'dbo', ''),
(2019020068, 201902, 52, 68, '2019-03-29', 4339, 'ENERGY', 3251, 3094, '2019-02-01', '2019-01-01', '2019-04-05', 157, 70827.0500, 0.0000, 3358.2900, 74185.3400, '2019-04-01 13:10:31', 'dbo', ''),
(2019020069, 201902, 52, 69, '2019-03-29', 4340, 'ENERGY', 1, 1, '2019-02-01', '2019-01-01', '2019-04-05', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2019-04-01 13:10:31', 'dbo', ''),
(2019020070, 201902, 52, 70, '2019-03-29', 4341, 'ENERGY', 2785, 2644, '2019-02-01', '2019-01-01', '2019-04-05', 141, 62104.0800, 0.0000, 3016.0400, 65120.1200, '2019-04-01 13:10:31', 'dbo', ''),
(2019020071, 201902, 52, 71, '2019-03-29', 4342, 'ENERGY', 269951, 263540, '2019-02-01', '2019-01-01', '2019-04-05', 6411, 5069733.9862, 0.0000, 137133.3500, 5206867.3362, '2019-04-01 13:10:30', 'dbo', ''),
(2019020072, 201902, 52, 72, '2019-03-29', 4343, 'ENERGY', 2353, 2298, '2019-02-01', '2019-01-01', '2019-04-05', 55, 55665.5600, 0.0000, 1176.4800, 56842.0400, '2019-04-01 13:10:30', 'dbo', ''),
(2019020073, 201902, 52, 73, '2019-03-29', 4344, 'ENERGY', 491, 489, '2019-02-01', '2019-01-01', '2019-04-05', 2, 26447.7880, 0.0000, 42.7800, 26490.5680, '2019-04-01 13:10:30', 'dbo', ''),
(2019020075, 201902, 52, 75, '2019-03-29', 4345, 'ENERGY', 1911, 1884, '2019-02-01', '2019-01-01', '2019-04-05', 27, 46325.1400, 0.0000, 577.5300, 46902.6700, '2019-04-01 13:10:30', 'dbo', ''),
(2019020076, 201902, 52, 76, '2019-03-29', 4346, 'ENERGY', 2072, 2035, '2019-02-01', '2019-01-01', '2019-04-05', 37, 48907.5200, 0.0000, 791.4400, 49698.9600, '2019-04-01 13:10:30', 'dbo', ''),
(2019020077, 201902, 52, 77, '2019-03-29', 4347, 'ENERGY', 1618, 1591, '2019-02-01', '2019-01-01', '2019-04-05', 27, 40561.3500, 0.0000, 577.5300, 41138.8800, '2019-04-01 13:10:30', 'dbo', ''),
(2019020078, 201902, 52, 78, '2019-03-29', 4348, 'ENERGY', 503, 492, '2019-02-01', '2019-01-01', '2019-04-05', 11, 18673.7000, 0.0000, 235.2900, 18908.9900, '2019-04-01 13:10:30', 'dbo', ''),
(2019020079, 201902, 52, 79, '2019-03-29', 4349, 'ENERGY', 56624, 55490, '2019-02-01', '2019-01-01', '2019-04-05', 1134, 966965.1300, 0.0000, 24256.6300, 991221.7600, '2019-04-01 13:10:30', 'dbo', ''),
(2019020081, 201902, 52, 81, '2019-03-29', 4351, 'ENERGY', 2146, 2097, '2019-02-01', '2019-01-01', '2019-04-05', 49, 47507.6100, 0.0000, 1048.1300, 48555.7400, '2019-04-01 13:10:30', 'dbo', ''),
(2019020082, 201902, 52, 82, '2019-03-29', 4352, 'ENERGY', 4546, 4428, '2019-02-01', '2019-01-01', '2019-04-05', 118, 94578.7600, 0.0000, 2524.0600, 97102.8200, '2019-04-01 13:10:30', 'dbo', ''),
(2019020083, 201902, 52, 83, '2019-03-29', 4353, 'ENERGY', 115, 112, '2019-02-01', '2019-01-01', '2019-04-05', 3, 8045.6200, 0.0000, 64.1700, 8109.7900, '2019-04-01 13:10:30', 'dbo', ''),
(2019020084, 201902, 52, 84, '2019-03-29', 4354, 'ENERGY', 162, 162, '2019-02-01', '2019-01-01', '2019-04-05', 0, 8810.4900, 0.0000, 0.0000, 8810.4900, '2019-04-01 13:10:31', 'dbo', ''),
(2019020085, 201902, 52, 85, '2019-03-29', 4355, 'ENERGY', 355, 355, '2019-02-01', '2019-01-01', '2019-04-05', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2019-04-01 13:10:31', 'dbo', ''),
(2019020086, 201902, 52, 86, '2019-03-29', 4356, 'ENERGY', 130, 126, '2019-02-01', '2019-01-01', '2019-04-05', 4, 7707.0600, 0.0000, 85.5500, 7792.6100, '2019-04-01 13:10:31', 'dbo', ''),
(2019030001, 201903, 53, 1, '2019-04-05', 4357, 'ENERGY', 0, 0, '2019-03-01', '2019-02-01', '2019-04-12', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2019-04-05 17:09:59', 'dbo', ''),
(2019030002, 201903, 53, 2, '2019-04-05', 4358, 'ENERGY', 0, 0, '2019-03-01', '2019-02-01', '2019-04-12', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2019-04-05 17:09:59', 'dbo', ''),
(2019030003, 201903, 53, 3, '2019-04-05', 4359, 'ENERGY', 0, 0, '2019-03-01', '2019-02-01', '2019-04-12', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2019-04-05 17:09:59', 'dbo', ''),
(2019030004, 201903, 53, 4, '2019-04-05', 4360, 'ENERGY', 0, 0, '2019-03-01', '2019-02-01', '2019-04-12', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2019-04-05 17:09:59', 'dbo', ''),
(2019030005, 201903, 53, 5, '2019-04-05', 4361, 'ENERGY', 0, 0, '2019-03-01', '2019-02-01', '2019-04-12', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2019-04-05 17:09:59', 'dbo', ''),
(2019030006, 201903, 53, 6, '2019-04-05', 4362, 'ENERGY', 0, 0, '2019-03-01', '2019-02-01', '2019-04-12', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2019-04-05 17:09:59', 'dbo', ''),
(2019030007, 201903, 53, 7, '2019-04-05', 4363, 'ENERGY', 0, 0, '2019-03-01', '2019-02-01', '2019-04-12', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2019-04-05 17:09:59', 'dbo', ''),
(2019030008, 201903, 53, 8, '2019-04-05', 4364, 'ENERGY', 0, 0, '2019-03-01', '2019-02-01', '2019-04-12', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2019-04-05 17:09:59', 'dbo', ''),
(2019030009, 201903, 53, 9, '2019-04-05', 4365, 'ENERGY', 11321, 11321, '2019-03-01', '2019-02-01', '2019-04-12', 0, 247125.2664, 0.0000, 0.0000, 247125.2664, '2019-04-05 17:09:59', 'dbo', ''),
(2019030010, 201903, 53, 10, '2019-04-05', 4366, 'ENERGY', 776, 776, '2019-03-01', '2019-02-01', '2019-04-12', 0, 23761.3680, 0.0000, 0.0000, 23761.3680, '2019-04-05 17:09:59', 'dbo', ''),
(2019030011, 201903, 53, 11, '2019-04-05', 4367, 'ENERGY', 223, 201, '2019-03-01', '2019-02-01', '2019-04-12', 22, 10071.5310, 0.0000, 448.5000, 10520.0310, '2019-04-05 17:09:59', 'dbo', ''),
(2019030012, 201903, 53, 12, '2019-04-05', 4368, 'ENERGY', 137, 137, '2019-03-01', '2019-02-01', '2019-04-12', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2019-04-05 17:09:59', 'dbo', ''),
(2019030013, 201903, 53, 13, '2019-04-05', 4369, 'ENERGY', 23135, 22380, '2019-03-01', '2019-02-01', '2019-04-12', 755, 461536.3240, 0.0000, 15391.3700, 476927.6940, '2019-04-05 17:09:59', 'dbo', ''),
(2019030014, 201903, 53, 14, '2019-04-05', 4370, 'ENERGY', 11876, 11452, '2019-03-01', '2019-02-01', '2019-04-12', 424, 243927.0954, 0.0000, 8643.6200, 252570.7154, '2019-04-05 17:09:59', 'dbo', ''),
(2019030015, 201903, 53, 15, '2019-04-05', 4371, 'ENERGY', 162, 162, '2019-03-01', '2019-02-01', '2019-04-12', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2019-04-05 17:09:59', 'dbo', ''),
(2019030016, 201903, 53, 16, '2019-04-05', 4372, 'ENERGY', 15973, 15214, '2019-03-01', '2019-02-01', '2019-04-12', 759, 313345.9820, 0.0000, 15472.9100, 328818.8920, '2019-04-05 17:09:59', 'dbo', ''),
(2019030017, 201903, 53, 17, '2019-04-05', 4373, 'ENERGY', 51804, 49648, '2019-03-01', '2019-02-01', '2019-04-12', 2156, 1000147.4670, 0.0000, 43952.0300, 1044099.4970, '2019-04-05 17:09:59', 'dbo', ''),
(2019030018, 201903, 53, 18, '2019-04-05', 4374, 'ENERGY', 12695, 12015, '2019-03-01', '2019-02-01', '2019-04-12', 680, 246452.6800, 0.0000, 13862.4200, 260315.1000, '2019-04-05 17:09:59', 'dbo', ''),
(2019030019, 201903, 53, 19, '2019-04-05', 4375, 'ENERGY', 312, 103, '2019-03-01', '2019-02-01', '2019-04-12', 209, 2833.2650, 0.0000, 4260.6500, 7093.9150, '2019-04-05 17:09:59', 'dbo', ''),
(2019030020, 201903, 53, 20, '2019-04-05', 4376, 'ENERGY', 566, 322, '2019-03-01', '2019-02-01', '2019-04-12', 244, 8533.9530, 0.0000, 4974.1600, 13508.1130, '2019-04-05 17:09:59', 'dbo', ''),
(2019030021, 201903, 53, 21, '2019-04-05', 4377, 'ENERGY', 48754, 48754, '2019-03-01', '2019-02-01', '2019-04-12', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2019-04-05 17:09:59', 'dbo', ''),
(2019030022, 201903, 53, 22, '2019-04-05', 4378, 'ENERGY', 29187, 29187, '2019-03-01', '2019-02-01', '2019-04-12', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2019-04-05 17:09:59', 'dbo', ''),
(2019030023, 201903, 53, 23, '2019-04-05', 4379, 'ENERGY', 77425, 77425, '2019-03-01', '2019-02-01', '2019-04-12', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2019-04-05 17:09:59', 'dbo', ''),
(2019030024, 201903, 53, 24, '2019-04-05', 4380, 'ENERGY', 47443, 47443, '2019-03-01', '2019-02-01', '2019-04-12', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2019-04-05 17:09:59', 'dbo', ''),
(2019030025, 201903, 53, 25, '2019-04-05', 4381, 'ENERGY', 141913, 136784, '2019-03-01', '2019-02-01', '2019-04-12', 5129, 2722546.0700, 0.0000, 104559.3400, 2827105.4100, '2019-04-05 17:09:59', 'dbo', ''),
(2019030026, 201903, 53, 26, '2019-04-05', 4382, 'ENERGY', 84969, 83605, '2019-03-01', '2019-02-01', '2019-04-12', 1364, 1466141.9274, 0.0000, 27806.3800, 1493948.3074, '2019-04-05 17:09:59', 'dbo', ''),
(2019030029, 201903, 53, 29, '2019-04-05', 4383, 'ENERGY', 117805, 115853, '2019-03-01', '2019-02-01', '2019-04-12', 1952, 1938761.3488, 0.0000, 39793.3000, 1978554.6488, '2019-04-05 17:09:59', 'dbo', ''),
(2019030030, 201903, 53, 30, '2019-04-05', 4384, 'ENERGY', 57593, 56711, '2019-03-01', '2019-02-01', '2019-04-12', 882, 846548.7712, 0.0000, 17980.3800, 864529.1512, '2019-04-05 17:09:59', 'dbo', ''),
(2019030031, 201903, 53, 31, '2019-04-05', 4385, 'ENERGY', 97160, 94884, '2019-03-01', '2019-02-01', '2019-04-12', 2276, 1633210.7080, 0.0000, 46398.3400, 1679609.0480, '2019-04-05 17:09:59', 'dbo', ''),
(2019030032, 201903, 53, 32, '2019-04-05', 4386, 'ENERGY', 159685, 156677, '2019-03-01', '2019-02-01', '2019-04-12', 3008, 2705839.9590, 0.0000, 61320.8200, 2767160.7790, '2019-04-05 17:09:59', 'dbo', ''),
(2019030033, 201903, 53, 33, '2019-04-05', 4387, 'ENERGY', 24130, 23516, '2019-03-01', '2019-02-01', '2019-04-12', 614, 437615.7934, 0.0000, 12516.9500, 450132.7434, '2019-04-05 17:09:59', 'dbo', ''),
(2019030034, 201903, 53, 34, '2019-04-05', 4388, 'ENERGY', 12925, 12925, '2019-03-01', '2019-02-01', '2019-04-12', 0, 239209.5942, 0.0000, 0.0000, 239209.5942, '2019-04-05 17:09:59', 'dbo', ''),
(2019030035, 201903, 53, 35, '2019-04-05', 4389, 'ENERGY', 22701, 22320, '2019-03-01', '2019-02-01', '2019-04-12', 381, 385892.2326, 0.0000, 7767.0300, 393659.2626, '2019-04-05 17:09:59', 'dbo', ''),
(2019030036, 201903, 53, 36, '2019-04-05', 4390, 'ENERGY', 52757, 52440, '2019-03-01', '2019-02-01', '2019-04-12', 317, 927794.7938, 0.0000, 6462.3300, 934257.1238, '2019-04-05 17:09:59', 'dbo', ''),
(2019030037, 201903, 53, 37, '2019-04-05', 4391, 'ENERGY', 31304, 30473, '2019-03-01', '2019-02-01', '2019-04-12', 831, 526437.3210, 0.0000, 16940.7000, 543378.0210, '2019-04-05 17:09:59', 'dbo', ''),
(2019030038, 201903, 53, 38, '2019-04-05', 4392, 'ENERGY', 18713, 18329, '2019-03-01', '2019-02-01', '2019-04-12', 384, 338059.0634, 0.0000, 7828.1900, 345887.2534, '2019-04-05 17:09:59', 'dbo', ''),
(2019030039, 201903, 53, 39, '2019-04-05', 4393, 'ENERGY', 33972, 33397, '2019-03-01', '2019-02-01', '2019-04-12', 575, -31652.4018, 0.0000, 11721.9000, -19930.5018, '2019-04-05 17:09:59', 'dbo', ''),
(2019030040, 201903, 53, 40, '2019-04-05', 4394, 'ENERGY', 46966, 45130, '2019-03-01', '2019-02-01', '2019-04-12', 1836, 838716.5596, 0.0000, 37428.5400, 876145.0996, '2019-04-05 17:09:59', 'dbo', ''),
(2019030041, 201903, 53, 41, '2019-04-05', 4395, 'ENERGY', 241, 241, '2019-03-01', '2019-02-01', '2019-04-12', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2019-04-05 17:09:59', 'dbo', ''),
(2019030042, 201903, 53, 42, '2019-04-05', 4396, 'ENERGY', 334, 334, '2019-03-01', '2019-02-01', '2019-04-12', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2019-04-05 17:09:59', 'dbo', ''),
(2019030043, 201903, 53, 43, '2019-04-05', 4397, 'ENERGY', 96834, 94542, '2019-03-01', '2019-02-01', '2019-04-12', 2292, 1515270.2602, 0.0000, 46724.5100, 1561994.7702, '2019-04-05 17:09:59', 'dbo', ''),
(2019030044, 201903, 53, 44, '2019-04-05', 4398, 'ENERGY', 54219, 53533, '2019-03-01', '2019-02-01', '2019-04-12', 686, 1028295.0230, 0.0000, 13984.7400, 1042279.7630, '2019-04-05 17:09:59', 'dbo', ''),
(2019030045, 201903, 53, 45, '2019-04-05', 4399, 'ENERGY', 42426, 41870, '2019-03-01', '2019-02-01', '2019-04-12', 556, 523983.3920, 0.0000, 11334.5700, 535317.9620, '2019-04-05 17:09:59', 'dbo', ''),
(2019030046, 201903, 53, 46, '2019-04-05', 4400, 'ENERGY', 66793, 65859, '2019-03-01', '2019-02-01', '2019-04-12', 934, 1201974.8054, 0.0000, 19040.4500, 1221015.2554, '2019-04-05 17:09:59', 'dbo', ''),
(2019030047, 201903, 53, 47, '2019-04-05', 4401, 'ENERGY', 35646, 35026, '2019-03-01', '2019-02-01', '2019-04-12', 620, 528826.5210, 0.0000, 12639.2600, 541465.7810, '2019-04-05 17:09:59', 'dbo', ''),
(2019030048, 201903, 53, 48, '2019-04-05', 4402, 'ENERGY', 27164, 26184, '2019-03-01', '2019-02-01', '2019-04-12', 980, 526145.7700, 0.0000, 19978.2000, 546123.9700, '2019-04-05 17:09:59', 'dbo', ''),
(2019030049, 201903, 53, 49, '2019-04-05', 4403, 'ENERGY', 9049, 8852, '2019-03-01', '2019-02-01', '2019-04-12', 197, 162866.9390, 0.0000, 4016.0200, 166882.9590, '2019-04-05 17:09:59', 'dbo', ''),
(2019030050, 201903, 53, 50, '2019-04-05', 4404, 'ENERGY', 113198, 111906, '2019-03-01', '2019-02-01', '2019-04-12', 1292, 1854176.9392, 0.0000, 26338.6000, 1880515.5392, '2019-04-05 17:09:59', 'dbo', ''),
(2019030051, 201903, 53, 51, '2019-04-05', 4405, 'ENERGY', 211, 211, '2019-03-01', '2019-02-01', '2019-04-12', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2019-04-05 17:09:59', 'dbo', ''),
(2019030052, 201903, 53, 52, '2019-04-05', 4406, 'ENERGY', 321, 321, '2019-03-01', '2019-02-01', '2019-04-12', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2019-04-05 17:09:59', 'dbo', ''),
(2019030053, 201903, 53, 53, '2019-04-05', 4407, 'ENERGY', 10632, 9781, '2019-03-01', '2019-02-01', '2019-04-12', 851, 207145.3470, 0.0000, 17348.4200, 224493.7670, '2019-04-05 17:09:59', 'dbo', ''),
(2019030054, 201903, 53, 54, '2019-04-05', 4408, 'ENERGY', 40501, 40200, '2019-03-01', '2019-02-01', '2019-04-12', 301, 528607.9094, 0.0000, 6136.1600, 534744.0694, '2019-04-05 17:09:59', 'dbo', ''),
(2019030055, 201903, 53, 55, '2019-04-05', 4409, 'ENERGY', 15427, 15068, '2019-03-01', '2019-02-01', '2019-04-12', 359, 287633.2600, 0.0000, 7318.5400, 294951.8000, '2019-04-05 17:09:59', 'dbo', ''),
(2019030056, 201903, 53, 56, '2019-04-05', 4410, 'ENERGY', 6689, 5799, '2019-03-01', '2019-02-01', '2019-04-12', 890, 124542.5290, 0.0000, 18143.4600, 142685.9890, '2019-04-05 17:09:59', 'dbo', ''),
(2019030059, 201903, 53, 59, '2019-04-05', 4411, 'ENERGY', 128, 128, '2019-03-01', '2019-02-01', '2019-04-12', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2019-04-05 17:09:59', 'dbo', ''),
(2019030060, 201903, 53, 60, '2019-04-05', 4412, 'ENERGY', 336183, 329401, '2019-03-01', '2019-02-01', '2019-04-12', 6782, 5066175.6200, 0.0000, 138257.2600, 5204432.8800, '2019-04-05 17:09:59', 'dbo', ''),
(2019030061, 201903, 53, 61, '2019-04-05', 4413, 'ENERGY', 16, 16, '2019-03-01', '2019-02-01', '2019-04-12', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2019-04-05 17:09:59', 'dbo', ''),
(2019030062, 201903, 53, 62, '2019-04-05', 4414, 'ENERGY', 30, 30, '2019-03-01', '2019-02-01', '2019-04-12', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-04-05 17:09:59', 'dbo', ''),
(2019030063, 201903, 53, 63, '2019-04-05', 4415, 'ENERGY', 1, 1, '2019-03-01', '2019-02-01', '2019-04-12', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-04-05 17:09:59', 'dbo', ''),
(2019030064, 201903, 53, 64, '2019-04-05', 4416, 'ENERGY', 2, 2, '2019-03-01', '2019-02-01', '2019-04-12', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-04-05 17:09:59', 'dbo', ''),
(2019030065, 201903, 53, 65, '2019-04-05', 4417, 'ENERGY', 14885, 14501, '2019-03-01', '2019-02-01', '2019-04-12', 384, 293351.0680, 0.0000, 7828.1900, 301179.2580, '2019-04-05 17:09:59', 'dbo', ''),
(2019030066, 201903, 53, 66, '2019-04-05', 4418, 'ENERGY', 11304, 10960, '2019-03-01', '2019-02-01', '2019-04-12', 344, 221057.5324, 0.0000, 7012.7500, 228070.2824, '2019-04-05 17:09:59', 'dbo', ''),
(2019030067, 201903, 53, 67, '2019-04-05', 4419, 'ENERGY', 1345, 1310, '2019-03-01', '2019-02-01', '2019-04-12', 35, 34592.9838, 0.0000, 713.5000, 35306.4838, '2019-04-05 17:09:59', 'dbo', ''),
(2019030068, 201903, 53, 68, '2019-04-05', 4420, 'ENERGY', 3324, 3251, '2019-03-01', '2019-02-01', '2019-04-12', 73, 74185.3400, 0.0000, 1488.1700, 75673.5100, '2019-04-05 17:09:59', 'dbo', ''),
(2019030069, 201903, 53, 69, '2019-04-05', 4421, 'ENERGY', 1, 1, '2019-03-01', '2019-02-01', '2019-04-12', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2019-04-05 17:09:59', 'dbo', ''),
(2019030070, 201903, 53, 70, '2019-04-05', 4422, 'ENERGY', 2912, 2785, '2019-03-01', '2019-02-01', '2019-04-12', 127, 65120.1200, 0.0000, 2589.0200, 67709.1400, '2019-04-05 17:09:59', 'dbo', ''),
(2019030071, 201903, 53, 71, '2019-04-05', 4423, 'ENERGY', 277255, 269951, '2019-03-01', '2019-02-01', '2019-04-12', 7304, 5206867.3362, 0.0000, 148898.7100, 5355766.0462, '2019-04-05 17:09:59', 'dbo', ''),
(2019030072, 201903, 53, 72, '2019-04-05', 4424, 'ENERGY', 2406, 2353, '2019-03-01', '2019-02-01', '2019-04-12', 53, 56842.0400, 0.0000, 1080.4600, 57922.5000, '2019-04-05 17:09:59', 'dbo', ''),
(2019030073, 201903, 53, 73, '2019-04-05', 4425, 'ENERGY', 494, 491, '2019-03-01', '2019-02-01', '2019-04-12', 3, 26490.5680, 0.0000, 61.1600, 26551.7280, '2019-04-05 17:09:59', 'dbo', ''),
(2019030075, 201903, 53, 75, '2019-04-05', 4426, 'ENERGY', 1942, 1911, '2019-03-01', '2019-02-01', '2019-04-12', 31, 46902.6700, 0.0000, 631.9700, 47534.6400, '2019-04-05 17:09:59', 'dbo', ''),
(2019030076, 201903, 53, 76, '2019-04-05', 4427, 'ENERGY', 2113, 2072, '2019-03-01', '2019-02-01', '2019-04-12', 41, 49698.9600, 0.0000, 835.8200, 50534.7800, '2019-04-05 17:09:59', 'dbo', ''),
(2019030077, 201903, 53, 77, '2019-04-05', 4428, 'ENERGY', 1648, 1618, '2019-03-01', '2019-02-01', '2019-04-12', 30, 41138.8800, 0.0000, 611.5700, 41750.4500, '2019-04-05 17:09:59', 'dbo', ''),
(2019030078, 201903, 53, 78, '2019-04-05', 4429, 'ENERGY', 515, 503, '2019-03-01', '2019-02-01', '2019-04-12', 12, 18908.9900, 0.0000, 244.6300, 19153.6200, '2019-04-05 17:09:59', 'dbo', ''),
(2019030079, 201903, 53, 79, '2019-04-05', 4430, 'ENERGY', 57878, 56624, '2019-03-01', '2019-02-01', '2019-04-12', 1254, 991221.7600, 0.0000, 25563.9300, 1016785.6900, '2019-04-05 17:09:59', 'dbo', ''),
(2019030081, 201903, 53, 81, '2019-04-05', 4432, 'ENERGY', 2200, 2146, '2019-03-01', '2019-02-01', '2019-04-12', 54, 48555.7400, 0.0000, 1100.8300, 49656.5700, '2019-04-05 17:09:59', 'dbo', ''),
(2019030082, 201903, 53, 82, '2019-04-05', 4433, 'ENERGY', 4676, 4546, '2019-03-01', '2019-02-01', '2019-04-12', 130, 97102.8200, 0.0000, 2650.1600, 99752.9800, '2019-04-05 17:09:59', 'dbo', ''),
(2019030083, 201903, 53, 83, '2019-04-05', 4434, 'ENERGY', 115, 115, '2019-03-01', '2019-02-01', '2019-04-12', 0, 8109.7900, 0.0000, 0.0000, 8109.7900, '2019-04-05 17:09:59', 'dbo', ''),
(2019030085, 201903, 53, 85, '2019-04-05', 4436, 'ENERGY', 355, 355, '2019-03-01', '2019-02-01', '2019-04-12', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2019-04-05 17:09:59', 'dbo', ''),
(2019030086, 201903, 53, 86, '2019-04-05', 4437, 'ENERGY', 135, 130, '2019-03-01', '2019-02-01', '2019-04-12', 5, 7792.6100, 0.0000, 101.9200, 7894.5300, '2019-04-05 17:09:59', 'dbo', ''),
(2019040001, 201904, 54, 1, '2019-05-07', 4438, 'ENERGY', 0, 0, '2019-04-01', '2019-03-01', '2019-05-14', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2019-05-07 10:57:54', 'dbo', ''),
(2019040002, 201904, 54, 2, '2019-05-07', 4439, 'ENERGY', 0, 0, '2019-04-01', '2019-03-01', '2019-05-14', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2019-05-07 10:57:54', 'dbo', ''),
(2019040003, 201904, 54, 3, '2019-05-07', 4440, 'ENERGY', 0, 0, '2019-04-01', '2019-03-01', '2019-05-14', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2019-05-07 10:57:54', 'dbo', ''),
(2019040004, 201904, 54, 4, '2019-05-07', 4441, 'ENERGY', 0, 0, '2019-04-01', '2019-03-01', '2019-05-14', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2019-05-07 10:57:54', 'dbo', ''),
(2019040005, 201904, 54, 5, '2019-05-07', 4442, 'ENERGY', 0, 0, '2019-04-01', '2019-03-01', '2019-05-14', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2019-05-07 10:57:54', 'dbo', ''),
(2019040006, 201904, 54, 6, '2019-05-07', 4443, 'ENERGY', 0, 0, '2019-04-01', '2019-03-01', '2019-05-14', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2019-05-07 10:57:54', 'dbo', ''),
(2019040007, 201904, 54, 7, '2019-05-07', 4444, 'ENERGY', 0, 0, '2019-04-01', '2019-03-01', '2019-05-14', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2019-05-07 10:57:54', 'dbo', ''),
(2019040008, 201904, 54, 8, '2019-05-07', 4445, 'ENERGY', 0, 0, '2019-04-01', '2019-03-01', '2019-05-14', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2019-05-07 10:57:54', 'dbo', ''),
(2019040009, 201904, 54, 9, '2019-05-07', 4446, 'ENERGY', 11321, 11321, '2019-04-01', '2019-03-01', '2019-05-14', 0, 247125.2664, 0.0000, 0.0000, 247125.2664, '2019-05-07 10:57:54', 'dbo', ''),
(2019040010, 201904, 54, 10, '2019-05-07', 4447, 'ENERGY', 776, 776, '2019-04-01', '2019-03-01', '2019-05-14', 0, 23761.3680, 0.0000, 0.0000, 23761.3680, '2019-05-07 10:57:54', 'dbo', ''),
(2019040011, 201904, 54, 11, '2019-05-07', 4448, 'ENERGY', 334, 223, '2019-04-01', '2019-03-01', '2019-05-14', 111, 10520.0310, 0.0000, 2259.5200, 12779.5510, '2019-05-07 10:57:53', 'dbo', ''),
(2019040012, 201904, 54, 12, '2019-05-07', 4449, 'ENERGY', 137, 137, '2019-04-01', '2019-03-01', '2019-05-14', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2019-05-07 10:57:54', 'dbo', ''),
(2019040013, 201904, 54, 13, '2019-05-07', 4450, 'ENERGY', 23905, 23135, '2019-04-01', '2019-03-01', '2019-05-14', 770, 476927.6940, 0.0000, 15674.1100, 492601.8040, '2019-05-07 10:57:54', 'dbo', ''),
(2019040014, 201904, 54, 14, '2019-05-07', 4451, 'ENERGY', 12261, 11876, '2019-04-01', '2019-03-01', '2019-05-14', 385, 252570.7154, 0.0000, 7837.0600, 260407.7754, '2019-05-07 10:57:54', 'dbo', ''),
(2019040015, 201904, 54, 15, '2019-05-07', 4452, 'ENERGY', 162, 162, '2019-04-01', '2019-03-01', '2019-05-14', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2019-05-07 10:57:54', 'dbo', ''),
(2019040016, 201904, 54, 16, '2019-05-07', 4453, 'ENERGY', 16626, 15973, '2019-04-01', '2019-03-01', '2019-05-14', 653, 328818.8920, 0.0000, 13292.4800, 342111.3720, '2019-05-07 10:57:54', 'dbo', ''),
(2019040017, 201904, 54, 17, '2019-05-07', 4454, 'ENERGY', 54301, 51804, '2019-04-01', '2019-03-01', '2019-05-14', 2497, 1044099.4970, 0.0000, 50828.9100, 1094928.4070, '2019-05-07 10:57:53', 'dbo', ''),
(2019040018, 201904, 54, 18, '2019-05-07', 4455, 'ENERGY', 13377, 12695, '2019-04-01', '2019-03-01', '2019-05-14', 682, 260315.1000, 0.0000, 13882.7800, 274197.8800, '2019-05-07 10:57:53', 'dbo', ''),
(2019040019, 201904, 54, 19, '2019-05-07', 4456, 'ENERGY', 1099, 312, '2019-04-01', '2019-03-01', '2019-05-14', 787, 7093.9150, 0.0000, 16020.1700, 23114.0850, '2019-05-07 10:57:53', 'dbo', ''),
(2019040020, 201904, 54, 20, '2019-05-07', 4457, 'ENERGY', 780, 566, '2019-04-01', '2019-03-01', '2019-05-14', 214, 13508.1130, 0.0000, 4356.1700, 17864.2830, '2019-05-07 10:57:53', 'dbo', ''),
(2019040021, 201904, 54, 21, '2019-05-07', 4458, 'ENERGY', 48754, 48754, '2019-04-01', '2019-03-01', '2019-05-14', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2019-05-07 10:57:54', 'dbo', ''),
(2019040022, 201904, 54, 22, '2019-05-07', 4459, 'ENERGY', 29187, 29187, '2019-04-01', '2019-03-01', '2019-05-14', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2019-05-07 10:57:54', 'dbo', ''),
(2019040023, 201904, 54, 23, '2019-05-07', 4460, 'ENERGY', 77425, 77425, '2019-04-01', '2019-03-01', '2019-05-14', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2019-05-07 10:57:54', 'dbo', ''),
(2019040024, 201904, 54, 24, '2019-05-07', 4461, 'ENERGY', 47443, 47443, '2019-04-01', '2019-03-01', '2019-05-14', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2019-05-07 10:57:54', 'dbo', ''),
(2019040025, 201904, 54, 25, '2019-05-07', 4462, 'ENERGY', 146996, 141913, '2019-04-01', '2019-03-01', '2019-05-14', 5083, 2827105.4100, 0.0000, 103469.5100, 2930574.9200, '2019-05-07 10:57:54', 'dbo', ''),
(2019040026, 201904, 54, 26, '2019-05-07', 4463, 'ENERGY', 86363, 84969, '2019-04-01', '2019-03-01', '2019-05-14', 1394, 1493948.3074, 0.0000, 28376.2500, 1522324.5574, '2019-05-07 10:57:54', 'dbo', ''),
(2019040029, 201904, 54, 29, '2019-05-07', 4464, 'ENERGY', 119773, 117805, '2019-04-01', '2019-03-01', '2019-05-14', 1968, 1978554.6488, 0.0000, 40060.5900, 2018615.2388, '2019-05-07 10:57:54', 'dbo', ''),
(2019040030, 201904, 54, 30, '2019-05-07', 4465, 'ENERGY', 58449, 57593, '2019-04-01', '2019-03-01', '2019-05-14', 856, 864529.1512, 0.0000, 17424.7400, 881953.8912, '2019-05-07 10:57:54', 'dbo', ''),
(2019040031, 201904, 54, 31, '2019-05-07', 4466, 'ENERGY', 99272, 97160, '2019-04-01', '2019-03-01', '2019-05-14', 2112, 1679609.0480, 0.0000, 42991.8500, 1722600.8980, '2019-05-07 10:57:54', 'dbo', ''),
(2019040032, 201904, 54, 32, '2019-05-07', 4467, 'ENERGY', 162615, 159685, '2019-04-01', '2019-03-01', '2019-05-14', 2930, 2767160.7790, 0.0000, 59643.0500, 2826803.8290, '2019-05-07 10:57:54', 'dbo', ''),
(2019040033, 201904, 54, 33, '2019-05-07', 4468, 'ENERGY', 24733, 24130, '2019-04-01', '2019-03-01', '2019-05-14', 603, 450132.7434, 0.0000, 12274.6700, 462407.4134, '2019-05-07 10:57:54', 'dbo', ''),
(2019040034, 201904, 54, 34, '2019-05-07', 4469, 'ENERGY', 12926, 12925, '2019-04-01', '2019-03-01', '2019-05-14', 1, 239209.5942, 0.0000, 20.3700, 239229.9642, '2019-05-07 10:57:54', 'dbo', ''),
(2019040035, 201904, 54, 35, '2019-05-07', 4470, 'ENERGY', 23102, 22701, '2019-04-01', '2019-03-01', '2019-05-14', 401, 393659.2626, 0.0000, 8162.7600, 401822.0226, '2019-05-07 10:57:54', 'dbo', ''),
(2019040036, 201904, 54, 36, '2019-05-07', 4471, 'ENERGY', 53091, 52757, '2019-04-01', '2019-03-01', '2019-05-14', 334, 934257.1238, 0.0000, 6798.9100, 941056.0338, '2019-05-07 10:57:54', 'dbo', ''),
(2019040037, 201904, 54, 37, '2019-05-07', 4472, 'ENERGY', 32199, 31304, '2019-04-01', '2019-03-01', '2019-05-14', 895, 543378.0210, 0.0000, 18218.6200, 561596.6410, '2019-05-07 10:57:54', 'dbo', ''),
(2019040038, 201904, 54, 38, '2019-05-07', 4473, 'ENERGY', 19049, 18713, '2019-04-01', '2019-03-01', '2019-05-14', 336, 345887.2534, 0.0000, 6839.6100, 352726.8634, '2019-05-07 10:57:54', 'dbo', ''),
(2019040039, 201904, 54, 39, '2019-05-07', 4474, 'ENERGY', 34486, 33972, '2019-04-01', '2019-03-01', '2019-05-14', 514, -19930.5018, 0.0000, 10462.9800, -9467.5218, '2019-05-07 10:57:54', 'dbo', ''),
(2019040040, 201904, 54, 40, '2019-05-07', 4475, 'ENERGY', 48701, 46966, '2019-04-01', '2019-03-01', '2019-05-14', 1735, 876145.0996, 0.0000, 35317.6500, 911462.7496, '2019-05-07 10:57:54', 'dbo', ''),
(2019040041, 201904, 54, 41, '2019-05-07', 4476, 'ENERGY', 241, 241, '2019-04-01', '2019-03-01', '2019-05-14', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2019-05-07 10:57:54', 'dbo', ''),
(2019040042, 201904, 54, 42, '2019-05-07', 4477, 'ENERGY', 334, 334, '2019-04-01', '2019-03-01', '2019-05-14', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2019-05-07 10:57:54', 'dbo', ''),
(2019040043, 201904, 54, 43, '2019-05-07', 4478, 'ENERGY', 98921, 96834, '2019-04-01', '2019-03-01', '2019-05-14', 2087, 1561994.7702, 0.0000, 42482.9600, 1604477.7302, '2019-05-07 10:57:53', 'dbo', ''),
(2019040044, 201904, 54, 44, '2019-05-07', 4479, 'ENERGY', 54863, 54219, '2019-04-01', '2019-03-01', '2019-05-14', 644, 1042279.7630, 0.0000, 13109.2600, 1055389.0230, '2019-05-07 10:57:53', 'dbo', ''),
(2019040045, 201904, 54, 45, '2019-05-07', 4480, 'ENERGY', 42991, 42426, '2019-04-01', '2019-03-01', '2019-05-14', 565, 535317.9620, 0.0000, 11501.1500, 546819.1120, '2019-05-07 10:57:54', 'dbo', ''),
(2019040046, 201904, 54, 46, '2019-05-07', 4481, 'ENERGY', 67685, 66793, '2019-04-01', '2019-03-01', '2019-05-14', 892, 1221015.2554, 0.0000, 18157.5500, 1239172.8054, '2019-05-07 10:57:54', 'dbo', ''),
(2019040047, 201904, 54, 47, '2019-05-07', 4482, 'ENERGY', 36213, 35646, '2019-04-01', '2019-03-01', '2019-05-14', 567, 541465.7810, 0.0000, 11541.8500, 553007.6310, '2019-05-07 10:57:54', 'dbo', ''),
(2019040048, 201904, 54, 48, '2019-05-07', 4483, 'ENERGY', 28120, 27164, '2019-04-01', '2019-03-01', '2019-05-14', 956, 546123.9700, 0.0000, 19460.3400, 565584.3100, '2019-05-07 10:57:54', 'dbo', ''),
(2019040049, 201904, 54, 49, '2019-05-07', 4484, 'ENERGY', 9231, 9049, '2019-04-01', '2019-03-01', '2019-05-14', 182, 166882.9590, 0.0000, 3704.7900, 170587.7490, '2019-05-07 10:57:53', 'dbo', ''),
(2019040050, 201904, 54, 50, '2019-05-07', 4485, 'ENERGY', 115529, 113198, '2019-04-01', '2019-03-01', '2019-05-14', 2331, 1880515.5392, 0.0000, 47449.8300, 1927965.3692, '2019-05-07 10:57:53', 'dbo', ''),
(2019040051, 201904, 54, 51, '2019-05-07', 4486, 'ENERGY', 211, 211, '2019-04-01', '2019-03-01', '2019-05-14', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2019-05-07 10:57:54', 'dbo', ''),
(2019040052, 201904, 54, 52, '2019-05-07', 4487, 'ENERGY', 321, 321, '2019-04-01', '2019-03-01', '2019-05-14', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2019-05-07 10:57:54', 'dbo', ''),
(2019040053, 201904, 54, 53, '2019-05-07', 4488, 'ENERGY', 11481, 10632, '2019-04-01', '2019-03-01', '2019-05-14', 849, 224493.7670, 0.0000, 17282.2500, 241776.0170, '2019-05-07 10:57:54', 'dbo', ''),
(2019040054, 201904, 54, 54, '2019-05-07', 4489, 'ENERGY', 40809, 40501, '2019-04-01', '2019-03-01', '2019-05-14', 308, 534744.0694, 0.0000, 6269.6500, 541013.7194, '2019-05-07 10:57:54', 'dbo', ''),
(2019040055, 201904, 54, 55, '2019-05-07', 4490, 'ENERGY', 15756, 15427, '2019-04-01', '2019-03-01', '2019-05-14', 329, 294951.8000, 0.0000, 6697.1300, 301648.9300, '2019-05-07 10:57:54', 'dbo', ''),
(2019040056, 201904, 54, 56, '2019-05-07', 4491, 'ENERGY', 7445, 6689, '2019-04-01', '2019-03-01', '2019-05-14', 756, 142685.9890, 0.0000, 15389.1300, 158075.1190, '2019-05-07 10:57:54', 'dbo', ''),
(2019040059, 201904, 54, 59, '2019-05-07', 4492, 'ENERGY', 128, 128, '2019-04-01', '2019-03-01', '2019-05-14', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2019-05-07 10:57:54', 'dbo', ''),
(2019040060, 201904, 54, 60, '2019-05-07', 4493, 'ENERGY', 343026, 336183, '2019-04-01', '2019-03-01', '2019-05-14', 6843, 5204432.8800, 0.0000, 139296.0600, 5343728.9400, '2019-05-07 10:57:53', 'dbo', ''),
(2019040061, 201904, 54, 61, '2019-05-07', 4494, 'ENERGY', 16, 16, '2019-04-01', '2019-03-01', '2019-05-14', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2019-05-07 10:57:54', 'dbo', ''),
(2019040062, 201904, 54, 62, '2019-05-07', 4495, 'ENERGY', 30, 30, '2019-04-01', '2019-03-01', '2019-05-14', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-05-07 10:57:54', 'dbo', ''),
(2019040063, 201904, 54, 63, '2019-05-07', 4496, 'ENERGY', 1, 1, '2019-04-01', '2019-03-01', '2019-05-14', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-05-07 10:57:54', 'dbo', ''),
(2019040064, 201904, 54, 64, '2019-05-07', 4497, 'ENERGY', 2, 2, '2019-04-01', '2019-03-01', '2019-05-14', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-05-07 10:57:54', 'dbo', ''),
(2019040065, 201904, 54, 65, '2019-05-07', 4498, 'ENERGY', 15136, 14885, '2019-04-01', '2019-03-01', '2019-05-14', 251, 301179.2580, 0.0000, 5109.3600, 306288.6180, '2019-05-07 10:57:53', 'dbo', ''),
(2019040066, 201904, 54, 66, '2019-05-07', 4499, 'ENERGY', 11639, 11304, '2019-04-01', '2019-03-01', '2019-05-14', 335, 228070.2824, 0.0000, 6819.2600, 234889.5424, '2019-05-07 10:57:53', 'dbo', ''),
(2019040067, 201904, 54, 67, '2019-05-07', 4500, 'ENERGY', 1384, 1345, '2019-04-01', '2019-03-01', '2019-05-14', 39, 35306.4838, 0.0000, 793.8800, 36100.3638, '2019-05-07 10:57:54', 'dbo', ''),
(2019040068, 201904, 54, 68, '2019-05-07', 4501, 'ENERGY', 3438, 3324, '2019-04-01', '2019-03-01', '2019-05-14', 114, 75673.5100, 0.0000, 2320.5800, 77994.0900, '2019-05-07 10:57:54', 'dbo', ''),
(2019040069, 201904, 54, 69, '2019-05-07', 4502, 'ENERGY', 1, 1, '2019-04-01', '2019-03-01', '2019-05-14', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2019-05-07 10:57:54', 'dbo', ''),
(2019040070, 201904, 54, 70, '2019-05-07', 4503, 'ENERGY', 3005, 2912, '2019-04-01', '2019-03-01', '2019-05-14', 93, 67709.1400, 0.0000, 1893.1100, 69602.2500, '2019-05-07 10:57:54', 'dbo', ''),
(2019040071, 201904, 54, 71, '2019-05-07', 4504, 'ENERGY', 284727, 277255, '2019-04-01', '2019-03-01', '2019-05-14', 7472, 5355766.0462, 0.0000, 152099.9700, 5507866.0162, '2019-05-07 10:57:53', 'dbo', ''),
(2019040072, 201904, 54, 72, '2019-05-07', 4505, 'ENERGY', 2455, 2406, '2019-04-01', '2019-03-01', '2019-05-14', 49, 57922.5000, 0.0000, 997.4500, 58919.9500, '2019-05-07 10:57:53', 'dbo', ''),
(2019040073, 201904, 54, 73, '2019-05-07', 4506, 'ENERGY', 520, 494, '2019-04-01', '2019-03-01', '2019-05-14', 26, 26551.7280, 0.0000, 529.2500, 27080.9780, '2019-05-07 10:57:53', 'dbo', ''),
(2019040075, 201904, 54, 75, '2019-05-07', 4507, 'ENERGY', 1973, 1942, '2019-04-01', '2019-03-01', '2019-05-14', 31, 47534.6400, 0.0000, 631.0500, 48165.6900, '2019-05-07 10:57:53', 'dbo', ''),
(2019040076, 201904, 54, 76, '2019-05-07', 4508, 'ENERGY', 2154, 2113, '2019-04-01', '2019-03-01', '2019-05-14', 41, 50534.7800, 0.0000, 834.6000, 51369.3800, '2019-05-07 10:57:53', 'dbo', ''),
(2019040077, 201904, 54, 77, '2019-05-07', 4509, 'ENERGY', 1678, 1648, '2019-04-01', '2019-03-01', '2019-05-14', 30, 41750.4500, 0.0000, 610.6800, 42361.1300, '2019-05-07 10:57:53', 'dbo', ''),
(2019040078, 201904, 54, 78, '2019-05-07', 4510, 'ENERGY', 528, 515, '2019-04-01', '2019-03-01', '2019-05-14', 13, 19153.6200, 0.0000, 264.6300, 19418.2500, '2019-05-07 10:57:53', 'dbo', ''),
(2019040079, 201904, 54, 79, '2019-05-07', 4511, 'ENERGY', 59159, 57878, '2019-04-01', '2019-03-01', '2019-05-14', 1281, 1016785.6900, 0.0000, 26076.0300, 1042861.7200, '2019-05-07 10:57:54', 'dbo', ''),
(2019040081, 201904, 54, 81, '2019-05-07', 4513, 'ENERGY', 2253, 2200, '2019-04-01', '2019-03-01', '2019-05-14', 53, 49656.5700, 0.0000, 1078.8800, 50735.4500, '2019-05-07 10:57:54', 'dbo', ''),
(2019040082, 201904, 54, 82, '2019-05-07', 4514, 'ENERGY', 4808, 4676, '2019-04-01', '2019-03-01', '2019-05-14', 132, 99752.9800, 0.0000, 2686.9800, 102439.9600, '2019-05-07 10:57:54', 'dbo', ''),
(2019040083, 201904, 54, 83, '2019-05-07', 4515, 'ENERGY', 115, 115, '2019-04-01', '2019-03-01', '2019-05-14', 0, 8109.7900, 0.0000, 0.0000, 8109.7900, '2019-05-07 10:57:54', 'dbo', ''),
(2019040085, 201904, 54, 85, '2019-05-07', 4517, 'ENERGY', 355, 355, '2019-04-01', '2019-03-01', '2019-05-14', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2019-05-07 10:57:54', 'dbo', ''),
(2019040086, 201904, 54, 86, '2019-05-07', 4518, 'ENERGY', 139, 135, '2019-04-01', '2019-03-01', '2019-05-14', 4, 7894.5300, 0.0000, 81.4200, 7975.9500, '2019-05-07 10:57:54', 'dbo', ''),
(2019050001, 201905, 55, 1, '2019-06-14', 4519, 'ENERGY', 0, 0, '2019-05-01', '2019-04-01', '2019-06-21', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2019-06-17 10:20:42', 'dbo', ''),
(2019050002, 201905, 55, 2, '2019-06-14', 4520, 'ENERGY', 0, 0, '2019-05-01', '2019-04-01', '2019-06-21', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2019-06-17 10:20:42', 'dbo', ''),
(2019050003, 201905, 55, 3, '2019-06-14', 4521, 'ENERGY', 0, 0, '2019-05-01', '2019-04-01', '2019-06-21', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2019-06-17 10:20:42', 'dbo', ''),
(2019050004, 201905, 55, 4, '2019-06-14', 4522, 'ENERGY', 0, 0, '2019-05-01', '2019-04-01', '2019-06-21', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2019-06-17 10:20:42', 'dbo', ''),
(2019050005, 201905, 55, 5, '2019-06-14', 4523, 'ENERGY', 0, 0, '2019-05-01', '2019-04-01', '2019-06-21', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2019-06-17 10:20:42', 'dbo', ''),
(2019050006, 201905, 55, 6, '2019-06-14', 4524, 'ENERGY', 0, 0, '2019-05-01', '2019-04-01', '2019-06-21', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2019-06-17 10:20:42', 'dbo', ''),
(2019050007, 201905, 55, 7, '2019-06-14', 4525, 'ENERGY', 0, 0, '2019-05-01', '2019-04-01', '2019-06-21', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2019-06-17 10:20:42', 'dbo', ''),
(2019050008, 201905, 55, 8, '2019-06-14', 4526, 'ENERGY', 0, 0, '2019-05-01', '2019-04-01', '2019-06-21', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2019-06-17 10:20:42', 'dbo', ''),
(2019050009, 201905, 55, 9, '2019-06-14', 4527, 'ENERGY', 11321, 11321, '2019-05-01', '2019-04-01', '2019-06-21', 0, 247125.2664, 0.0000, 0.0000, 247125.2664, '2019-06-17 10:20:42', 'dbo', ''),
(2019050010, 201905, 55, 10, '2019-06-14', 4528, 'ENERGY', 776, 776, '2019-05-01', '2019-04-01', '2019-06-21', 0, 23761.3680, 0.0000, 0.0000, 23761.3680, '2019-06-17 10:20:42', 'dbo', ''),
(2019050011, 201905, 55, 11, '2019-06-14', 4529, 'ENERGY', 677, 334, '2019-05-01', '2019-04-01', '2019-06-21', 343, 12779.5510, 0.0000, 7472.3300, 20251.8810, '2019-06-17 10:20:42', 'dbo', ''),
(2019050012, 201905, 55, 12, '2019-06-14', 4530, 'ENERGY', 137, 137, '2019-05-01', '2019-04-01', '2019-06-21', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2019-06-17 10:20:42', 'dbo', ''),
(2019050013, 201905, 55, 13, '2019-06-14', 4531, 'ENERGY', 24938, 23905, '2019-05-01', '2019-04-01', '2019-06-21', 1033, 492601.8040, 0.0000, 22504.1200, 515105.9240, '2019-06-17 10:20:42', 'dbo', ''),
(2019050014, 201905, 55, 14, '2019-06-14', 4532, 'ENERGY', 12697, 12261, '2019-05-01', '2019-04-01', '2019-06-21', 436, 260407.7754, 0.0000, 9498.3600, 269906.1354, '2019-06-17 10:20:42', 'dbo', ''),
(2019050015, 201905, 55, 15, '2019-06-14', 4533, 'ENERGY', 162, 162, '2019-05-01', '2019-04-01', '2019-06-21', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2019-06-17 10:20:42', 'dbo', ''),
(2019050016, 201905, 55, 16, '2019-06-14', 4534, 'ENERGY', 17305, 16626, '2019-05-01', '2019-04-01', '2019-06-21', 679, 342111.3720, 0.0000, 14792.1500, 356903.5220, '2019-06-17 10:20:42', 'dbo', ''),
(2019050017, 201905, 55, 17, '2019-06-14', 4535, 'ENERGY', 56764, 54301, '2019-05-01', '2019-04-01', '2019-06-21', 2463, 1094928.4070, 0.0000, 53656.9500, 1148585.3570, '2019-06-17 10:20:42', 'dbo', ''),
(2019050018, 201905, 55, 18, '2019-06-14', 4536, 'ENERGY', 14039, 13377, '2019-05-01', '2019-04-01', '2019-06-21', 662, 274197.8800, 0.0000, 14421.8000, 288619.6800, '2019-06-17 10:20:42', 'dbo', ''),
(2019050019, 201905, 55, 19, '2019-06-14', 4537, 'ENERGY', 1842, 1099, '2019-05-01', '2019-04-01', '2019-06-21', 743, 23114.0850, 0.0000, 16186.4000, 39300.4850, '2019-06-17 10:20:42', 'dbo', ''),
(2019050020, 201905, 55, 20, '2019-06-14', 4538, 'ENERGY', 928, 780, '2019-05-01', '2019-04-01', '2019-06-21', 148, 17864.2830, 0.0000, 3224.2200, 21088.5030, '2019-06-17 10:20:42', 'dbo', ''),
(2019050021, 201905, 55, 21, '2019-06-14', 4539, 'ENERGY', 48754, 48754, '2019-05-01', '2019-04-01', '2019-06-21', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2019-06-17 10:20:42', 'dbo', ''),
(2019050022, 201905, 55, 22, '2019-06-14', 4540, 'ENERGY', 29187, 29187, '2019-05-01', '2019-04-01', '2019-06-21', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2019-06-17 10:20:42', 'dbo', ''),
(2019050023, 201905, 55, 23, '2019-06-14', 4541, 'ENERGY', 77425, 77425, '2019-05-01', '2019-04-01', '2019-06-21', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2019-06-17 10:20:42', 'dbo', ''),
(2019050024, 201905, 55, 24, '2019-06-14', 4542, 'ENERGY', 47443, 47443, '2019-05-01', '2019-04-01', '2019-06-21', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2019-06-17 10:20:42', 'dbo', ''),
(2019050025, 201905, 55, 25, '2019-06-14', 4543, 'ENERGY', 152233, 146996, '2019-05-01', '2019-04-01', '2019-06-21', 5237, 2930574.9200, 0.0000, 114089.1200, 3044664.0400, '2019-06-17 10:20:42', 'dbo', ''),
(2019050026, 201905, 55, 26, '2019-06-14', 4544, 'ENERGY', 87828, 86363, '2019-05-01', '2019-04-01', '2019-06-21', 1465, 1522324.5574, 0.0000, 31915.3100, 1554239.8674, '2019-06-17 10:20:42', 'dbo', ''),
(2019050029, 201905, 55, 29, '2019-06-14', 4545, 'ENERGY', 121792, 119773, '2019-05-01', '2019-04-01', '2019-06-21', 2019, 2018615.2388, 0.0000, 43984.3400, 2062599.5788, '2019-06-17 10:20:42', 'dbo', ''),
(2019050030, 201905, 55, 30, '2019-06-14', 4546, 'ENERGY', 59451, 58449, '2019-05-01', '2019-04-01', '2019-06-21', 1002, 881953.8912, 0.0000, 21828.7700, 903782.6612, '2019-06-17 10:20:42', 'dbo', ''),
(2019050031, 201905, 55, 31, '2019-06-14', 4547, 'ENERGY', 101366, 99272, '2019-05-01', '2019-04-01', '2019-06-21', 2094, 1722600.8980, 0.0000, 45618.2200, 1768219.1180, '2019-06-17 10:20:42', 'dbo', ''),
(2019050032, 201905, 55, 32, '2019-06-14', 4548, 'ENERGY', 165943, 162615, '2019-05-01', '2019-04-01', '2019-06-21', 3328, 2826803.8290, 0.0000, 72501.1600, 2899304.9890, '2019-06-17 10:20:42', 'dbo', ''),
(2019050033, 201905, 55, 33, '2019-06-14', 4549, 'ENERGY', 25335, 24733, '2019-05-01', '2019-04-01', '2019-06-21', 602, 462407.4134, 0.0000, 13114.6900, 475522.1034, '2019-06-17 10:20:42', 'dbo', ''),
(2019050034, 201905, 55, 34, '2019-06-14', 4550, 'ENERGY', 12928, 12926, '2019-05-01', '2019-04-01', '2019-06-21', 2, 239229.9642, 0.0000, 43.5600, 239273.5242, '2019-06-17 10:20:42', 'dbo', ''),
(2019050035, 201905, 55, 35, '2019-06-14', 4551, 'ENERGY', 23555, 23102, '2019-05-01', '2019-04-01', '2019-06-21', 453, 401822.0226, 0.0000, 9868.6900, 411690.7126, '2019-06-17 10:20:42', 'dbo', ''),
(2019050036, 201905, 55, 36, '2019-06-14', 4552, 'ENERGY', 53426, 53091, '2019-05-01', '2019-04-01', '2019-06-21', 335, 941056.0338, 0.0000, 7298.0500, 948354.0838, '2019-06-17 10:20:42', 'dbo', ''),
(2019050037, 201905, 55, 37, '2019-06-14', 4553, 'ENERGY', 33224, 32199, '2019-05-01', '2019-04-01', '2019-06-21', 1025, 561596.6410, 0.0000, 22329.8400, 583926.4810, '2019-06-17 10:20:42', 'dbo', ''),
(2019050038, 201905, 55, 38, '2019-06-14', 4554, 'ENERGY', 19449, 19049, '2019-05-01', '2019-04-01', '2019-06-21', 400, 352726.8634, 0.0000, 8714.0800, 361440.9434, '2019-06-17 10:20:42', 'dbo', '');
INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2019050039, 201905, 55, 39, '2019-06-14', 4555, 'ENERGY', 35061, 34486, '2019-05-01', '2019-04-01', '2019-06-21', 575, -9467.5218, 0.0000, 12526.4800, 3058.9582, '2019-06-17 10:20:42', 'dbo', ''),
(2019050040, 201905, 55, 40, '2019-06-14', 4556, 'ENERGY', 50495, 48701, '2019-05-01', '2019-04-01', '2019-06-21', 1794, 911462.7496, 0.0000, 39082.6500, 950545.3996, '2019-06-17 10:20:42', 'dbo', ''),
(2019050041, 201905, 55, 41, '2019-06-14', 4557, 'ENERGY', 241, 241, '2019-05-01', '2019-04-01', '2019-06-21', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2019-06-17 10:20:42', 'dbo', ''),
(2019050042, 201905, 55, 42, '2019-06-14', 4558, 'ENERGY', 334, 334, '2019-05-01', '2019-04-01', '2019-06-21', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2019-06-17 10:20:42', 'dbo', ''),
(2019050043, 201905, 55, 43, '2019-06-14', 4559, 'ENERGY', 101106, 98921, '2019-05-01', '2019-04-01', '2019-06-21', 2185, 1604477.7302, 0.0000, 47600.6600, 1652078.3902, '2019-06-17 10:20:42', 'dbo', ''),
(2019050044, 201905, 55, 44, '2019-06-14', 4560, 'ENERGY', 55704, 54863, '2019-05-01', '2019-04-01', '2019-06-21', 841, 1055389.0230, 0.0000, 18321.3600, 1073710.3830, '2019-06-17 10:20:42', 'dbo', ''),
(2019050045, 201905, 55, 45, '2019-06-14', 4561, 'ENERGY', 43614, 42991, '2019-05-01', '2019-04-01', '2019-06-21', 623, 546819.1120, 0.0000, 13572.1800, 560391.2920, '2019-06-17 10:20:42', 'dbo', ''),
(2019050046, 201905, 55, 46, '2019-06-14', 4562, 'ENERGY', 68681, 67685, '2019-05-01', '2019-04-01', '2019-06-21', 996, 1239172.8054, 0.0000, 21698.0600, 1260870.8654, '2019-06-17 10:20:42', 'dbo', ''),
(2019050047, 201905, 55, 47, '2019-06-14', 4563, 'ENERGY', 36720, 36213, '2019-05-01', '2019-04-01', '2019-06-21', 507, 553007.6310, 0.0000, 11045.0900, 564052.7210, '2019-06-17 10:20:42', 'dbo', ''),
(2019050048, 201905, 55, 48, '2019-06-14', 4564, 'ENERGY', 29220, 28120, '2019-05-01', '2019-04-01', '2019-06-21', 1100, 565584.3100, 0.0000, 23963.7200, 589548.0300, '2019-06-17 10:20:42', 'dbo', ''),
(2019050049, 201905, 55, 49, '2019-06-14', 4565, 'ENERGY', 9440, 9231, '2019-05-01', '2019-04-01', '2019-06-21', 209, 170587.7490, 0.0000, 4553.1100, 175140.8590, '2019-06-17 10:20:42', 'dbo', ''),
(2019050050, 201905, 55, 50, '2019-06-14', 4566, 'ENERGY', 117277, 115529, '2019-05-01', '2019-04-01', '2019-06-21', 1748, 1927965.3692, 0.0000, 38080.5400, 1966045.9092, '2019-06-17 10:20:42', 'dbo', ''),
(2019050051, 201905, 55, 51, '2019-06-14', 4567, 'ENERGY', 211, 211, '2019-05-01', '2019-04-01', '2019-06-21', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2019-06-17 10:20:42', 'dbo', ''),
(2019050052, 201905, 55, 52, '2019-06-14', 4568, 'ENERGY', 321, 321, '2019-05-01', '2019-04-01', '2019-06-21', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2019-06-17 10:20:42', 'dbo', ''),
(2019050053, 201905, 55, 53, '2019-06-14', 4569, 'ENERGY', 12329, 11481, '2019-05-01', '2019-04-01', '2019-06-21', 848, 241776.0170, 0.0000, 18473.8600, 260249.8770, '2019-06-17 10:20:42', 'dbo', ''),
(2019050054, 201905, 55, 54, '2019-06-14', 4570, 'ENERGY', 41154, 40809, '2019-05-01', '2019-04-01', '2019-06-21', 345, 541013.7194, 0.0000, 7515.9000, 548529.6194, '2019-06-17 10:20:42', 'dbo', ''),
(2019050055, 201905, 55, 55, '2019-06-14', 4571, 'ENERGY', 16161, 15756, '2019-05-01', '2019-04-01', '2019-06-21', 405, 301648.9300, 0.0000, 8823.0100, 310471.9400, '2019-06-17 10:20:42', 'dbo', ''),
(2019050056, 201905, 55, 56, '2019-06-14', 4572, 'ENERGY', 8258, 7445, '2019-05-01', '2019-04-01', '2019-06-21', 813, 158075.1190, 0.0000, 17711.3700, 175786.4890, '2019-06-17 10:20:42', 'dbo', ''),
(2019050059, 201905, 55, 59, '2019-06-14', 4573, 'ENERGY', 128, 128, '2019-05-01', '2019-04-01', '2019-06-21', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2019-06-17 10:20:42', 'dbo', ''),
(2019050060, 201905, 55, 60, '2019-06-14', 4574, 'ENERGY', 350175, 343026, '2019-05-01', '2019-04-01', '2019-06-21', 7149, 5343728.9400, 0.0000, 155742.4200, 5499471.3600, '2019-06-17 10:20:42', 'dbo', ''),
(2019050061, 201905, 55, 61, '2019-06-14', 4575, 'ENERGY', 16, 16, '2019-05-01', '2019-04-01', '2019-06-21', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2019-06-17 10:20:42', 'dbo', ''),
(2019050062, 201905, 55, 62, '2019-06-14', 4576, 'ENERGY', 30, 30, '2019-05-01', '2019-04-01', '2019-06-21', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-06-17 10:20:42', 'dbo', ''),
(2019050063, 201905, 55, 63, '2019-06-14', 4577, 'ENERGY', 1, 1, '2019-05-01', '2019-04-01', '2019-06-21', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-06-17 10:20:42', 'dbo', ''),
(2019050064, 201905, 55, 64, '2019-06-14', 4578, 'ENERGY', 2, 2, '2019-05-01', '2019-04-01', '2019-06-21', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-06-17 10:20:42', 'dbo', ''),
(2019050065, 201905, 55, 65, '2019-06-14', 4579, 'ENERGY', 15408, 15136, '2019-05-01', '2019-04-01', '2019-06-21', 272, 306288.6180, 0.0000, 5925.5800, 312214.1980, '2019-06-17 10:20:42', 'dbo', ''),
(2019050066, 201905, 55, 66, '2019-06-14', 4580, 'ENERGY', 12058, 11639, '2019-05-01', '2019-04-01', '2019-06-21', 419, 234889.5424, 0.0000, 9128.0100, 244017.5524, '2019-06-17 10:20:42', 'dbo', ''),
(2019050067, 201905, 55, 67, '2019-06-14', 4581, 'ENERGY', 1416, 1384, '2019-05-01', '2019-04-01', '2019-06-21', 32, 36100.3638, 0.0000, 697.1300, 36797.4938, '2019-06-17 10:20:42', 'dbo', ''),
(2019050068, 201905, 55, 68, '2019-06-14', 4582, 'ENERGY', 3552, 3438, '2019-05-01', '2019-04-01', '2019-06-21', 114, 77994.0900, 0.0000, 2483.5200, 80477.6100, '2019-06-17 10:20:42', 'dbo', ''),
(2019050069, 201905, 55, 69, '2019-06-14', 4583, 'ENERGY', 1, 1, '2019-05-01', '2019-04-01', '2019-06-21', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2019-06-17 10:20:42', 'dbo', ''),
(2019050070, 201905, 55, 70, '2019-06-14', 4584, 'ENERGY', 3100, 3005, '2019-05-01', '2019-04-01', '2019-06-21', 95, 69602.2500, 0.0000, 2069.5900, 71671.8400, '2019-06-17 10:20:42', 'dbo', ''),
(2019050071, 201905, 55, 71, '2019-06-14', 4585, 'ENERGY', 286172, 284727, '2019-05-01', '2019-04-01', '2019-06-21', 1445, 5507866.0162, 0.0000, 31479.6300, 5539345.6462, '2019-06-17 10:20:42', 'dbo', ''),
(2019050072, 201905, 55, 72, '2019-06-14', 4586, 'ENERGY', 2464, 2455, '2019-05-01', '2019-04-01', '2019-06-21', 9, 58919.9500, 0.0000, 196.0700, 59116.0200, '2019-06-17 10:20:42', 'dbo', ''),
(2019050073, 201905, 55, 73, '2019-06-14', 4587, 'ENERGY', 521, 520, '2019-05-01', '2019-04-01', '2019-06-21', 1, 27080.9780, 0.0000, 21.7900, 27102.7680, '2019-06-17 10:20:42', 'dbo', ''),
(2019050075, 201905, 55, 75, '2019-06-14', 4588, 'ENERGY', 2005, 1973, '2019-05-01', '2019-04-01', '2019-06-21', 32, 48165.6900, 0.0000, 697.1300, 48862.8200, '2019-06-17 10:20:42', 'dbo', ''),
(2019050076, 201905, 55, 76, '2019-06-14', 4589, 'ENERGY', 2196, 2154, '2019-05-01', '2019-04-01', '2019-06-21', 42, 51369.3800, 0.0000, 914.9900, 52284.3700, '2019-06-17 10:20:42', 'dbo', ''),
(2019050077, 201905, 55, 77, '2019-06-14', 4590, 'ENERGY', 1709, 1678, '2019-05-01', '2019-04-01', '2019-06-21', 31, 42361.1300, 0.0000, 675.3500, 43036.4800, '2019-06-17 10:20:42', 'dbo', ''),
(2019050078, 201905, 55, 78, '2019-06-14', 4591, 'ENERGY', 540, 528, '2019-05-01', '2019-04-01', '2019-06-21', 12, 19418.2500, 0.0000, 261.4300, 19679.6800, '2019-06-17 10:20:42', 'dbo', ''),
(2019050079, 201905, 55, 79, '2019-06-14', 4592, 'ENERGY', 60466, 59159, '2019-05-01', '2019-04-01', '2019-06-21', 1307, 1042861.7200, 0.0000, 28473.2600, 1071334.9800, '2019-06-17 10:20:42', 'dbo', ''),
(2019050081, 201905, 55, 81, '2019-06-14', 4594, 'ENERGY', 2309, 2253, '2019-05-01', '2019-04-01', '2019-06-21', 56, 50735.4500, 0.0000, 1219.9700, 51955.4200, '2019-06-17 10:20:42', 'dbo', ''),
(2019050082, 201905, 55, 82, '2019-06-14', 4595, 'ENERGY', 4944, 4808, '2019-05-01', '2019-04-01', '2019-06-21', 136, 102439.9600, 0.0000, 2962.7900, 105402.7500, '2019-06-17 10:20:42', 'dbo', ''),
(2019050083, 201905, 55, 83, '2019-06-14', 4596, 'ENERGY', 115, 115, '2019-05-01', '2019-04-01', '2019-06-21', 0, 8109.7900, 0.0000, 0.0000, 8109.7900, '2019-06-17 10:20:42', 'dbo', ''),
(2019050085, 201905, 55, 85, '2019-06-14', 4598, 'ENERGY', 355, 355, '2019-05-01', '2019-04-01', '2019-06-21', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2019-06-17 10:20:42', 'dbo', ''),
(2019050086, 201905, 55, 86, '2019-06-14', 4599, 'ENERGY', 143, 139, '2019-05-01', '2019-04-01', '2019-06-21', 4, 7975.9500, 0.0000, 87.1500, 8063.1000, '2019-06-17 10:20:42', 'dbo', ''),
(2019060001, 201906, 56, 1, '2019-07-03', 5519, 'ENERGY', 0, 0, '2019-06-01', '2019-05-01', '2019-07-10', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2019-07-03 15:22:33', 'dbo', ''),
(2019060002, 201906, 56, 2, '2019-07-03', 5520, 'ENERGY', 0, 0, '2019-06-01', '2019-05-01', '2019-07-10', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2019-07-03 15:22:33', 'dbo', ''),
(2019060003, 201906, 56, 3, '2019-07-03', 5521, 'ENERGY', 0, 0, '2019-06-01', '2019-05-01', '2019-07-10', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2019-07-03 15:22:33', 'dbo', ''),
(2019060004, 201906, 56, 4, '2019-07-03', 5522, 'ENERGY', 0, 0, '2019-06-01', '2019-05-01', '2019-07-10', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2019-07-03 15:22:33', 'dbo', ''),
(2019060005, 201906, 56, 5, '2019-07-03', 5523, 'ENERGY', 0, 0, '2019-06-01', '2019-05-01', '2019-07-10', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2019-07-03 15:22:33', 'dbo', ''),
(2019060006, 201906, 56, 6, '2019-07-03', 5524, 'ENERGY', 0, 0, '2019-06-01', '2019-05-01', '2019-07-10', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2019-07-03 15:22:33', 'dbo', ''),
(2019060007, 201906, 56, 7, '2019-07-03', 5525, 'ENERGY', 0, 0, '2019-06-01', '2019-05-01', '2019-07-10', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2019-07-03 15:22:33', 'dbo', ''),
(2019060008, 201906, 56, 8, '2019-07-03', 5526, 'ENERGY', 0, 0, '2019-06-01', '2019-05-01', '2019-07-10', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2019-07-03 15:22:33', 'dbo', ''),
(2019060009, 201906, 56, 9, '2019-07-03', 5527, 'ENERGY', 11321, 11321, '2019-06-01', '2019-05-01', '2019-07-10', 0, 247125.2664, 0.0000, 0.0000, 247125.2664, '2019-07-03 15:22:33', 'dbo', ''),
(2019060010, 201906, 56, 10, '2019-07-03', 5528, 'ENERGY', 776, 776, '2019-06-01', '2019-05-01', '2019-07-10', 0, 23761.3680, 0.0000, 0.0000, 23761.3680, '2019-07-03 15:22:33', 'dbo', ''),
(2019060011, 201906, 56, 11, '2019-07-03', 5529, 'ENERGY', 1410, 677, '2019-06-01', '2019-05-01', '2019-07-10', 733, 20251.8810, 0.0000, 15962.5300, 36214.4110, '2019-07-03 15:22:32', 'dbo', ''),
(2019060012, 201906, 56, 12, '2019-07-03', 5530, 'ENERGY', 137, 137, '2019-06-01', '2019-05-01', '2019-07-10', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2019-07-03 15:22:33', 'dbo', ''),
(2019060013, 201906, 56, 13, '2019-07-03', 5531, 'ENERGY', 26772, 24938, '2019-06-01', '2019-05-01', '2019-07-10', 1834, 515105.9240, 0.0000, 39938.9900, 555044.9140, '2019-07-03 15:22:33', 'dbo', ''),
(2019060014, 201906, 56, 14, '2019-07-03', 5532, 'ENERGY', 13268, 12697, '2019-06-01', '2019-05-01', '2019-07-10', 571, 269906.1354, 0.0000, 12434.6700, 282340.8054, '2019-07-03 15:22:33', 'dbo', ''),
(2019060015, 201906, 56, 15, '2019-07-03', 5533, 'ENERGY', 162, 162, '2019-06-01', '2019-05-01', '2019-07-10', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2019-07-03 15:22:33', 'dbo', ''),
(2019060016, 201906, 56, 16, '2019-07-03', 5534, 'ENERGY', 17818, 17305, '2019-06-01', '2019-05-01', '2019-07-10', 513, 356903.5220, 0.0000, 11171.6000, 368075.1220, '2019-07-03 15:22:33', 'dbo', ''),
(2019060017, 201906, 56, 17, '2019-07-03', 5535, 'ENERGY', 59277, 56764, '2019-06-01', '2019-05-01', '2019-07-10', 2513, 1148585.3570, 0.0000, 54725.5700, 1203310.9270, '2019-07-03 15:22:32', 'dbo', ''),
(2019060018, 201906, 56, 18, '2019-07-03', 5536, 'ENERGY', 14493, 14039, '2019-06-01', '2019-05-01', '2019-07-10', 454, 288619.6800, 0.0000, 9886.7500, 298506.4300, '2019-07-03 15:22:32', 'dbo', ''),
(2019060019, 201906, 56, 19, '2019-07-03', 5537, 'ENERGY', 2477, 1842, '2019-06-01', '2019-05-01', '2019-07-10', 635, 39300.4850, 0.0000, 13828.3900, 53128.8750, '2019-07-03 15:22:32', 'dbo', ''),
(2019060020, 201906, 56, 20, '2019-07-03', 5538, 'ENERGY', 1225, 928, '2019-06-01', '2019-05-01', '2019-07-10', 297, 21088.5030, 0.0000, 6467.7700, 27556.2730, '2019-07-03 15:22:32', 'dbo', ''),
(2019060021, 201906, 56, 21, '2019-07-03', 5539, 'ENERGY', 48754, 48754, '2019-06-01', '2019-05-01', '2019-07-10', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2019-07-03 15:22:33', 'dbo', ''),
(2019060022, 201906, 56, 22, '2019-07-03', 5540, 'ENERGY', 29187, 29187, '2019-06-01', '2019-05-01', '2019-07-10', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2019-07-03 15:22:33', 'dbo', ''),
(2019060023, 201906, 56, 23, '2019-07-03', 5541, 'ENERGY', 77425, 77425, '2019-06-01', '2019-05-01', '2019-07-10', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2019-07-03 15:22:33', 'dbo', ''),
(2019060024, 201906, 56, 24, '2019-07-03', 5542, 'ENERGY', 47443, 47443, '2019-06-01', '2019-05-01', '2019-07-10', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2019-07-03 15:22:33', 'dbo', ''),
(2019060025, 201906, 56, 25, '2019-07-03', 5543, 'ENERGY', 157050, 152233, '2019-06-01', '2019-05-01', '2019-07-10', 4817, 3044664.0400, 0.0000, 104899.7500, 3149563.7900, '2019-07-03 15:22:32', 'dbo', ''),
(2019060026, 201906, 56, 26, '2019-07-03', 5544, 'ENERGY', 89456, 87828, '2019-06-01', '2019-05-01', '2019-07-10', 1628, 1554239.8674, 0.0000, 35452.9300, 1589692.7974, '2019-07-03 15:22:32', 'dbo', ''),
(2019060029, 201906, 56, 29, '2019-07-03', 5545, 'ENERGY', 123612, 121792, '2019-06-01', '2019-05-01', '2019-07-10', 1820, 2062599.5788, 0.0000, 39634.1100, 2102233.6888, '2019-07-03 15:22:33', 'dbo', ''),
(2019060030, 201906, 56, 30, '2019-07-03', 5546, 'ENERGY', 60425, 59451, '2019-06-01', '2019-05-01', '2019-07-10', 974, 903782.6612, 0.0000, 21210.7900, 924993.4512, '2019-07-03 15:22:33', 'dbo', ''),
(2019060031, 201906, 56, 31, '2019-07-03', 5547, 'ENERGY', 102911, 101366, '2019-06-01', '2019-05-01', '2019-07-10', 1545, 1768219.1180, 0.0000, 33645.4400, 1801864.5580, '2019-07-03 15:22:33', 'dbo', ''),
(2019060032, 201906, 56, 32, '2019-07-03', 5548, 'ENERGY', 169179, 165943, '2019-06-01', '2019-05-01', '2019-07-10', 3236, 2899304.9890, 0.0000, 70470.3300, 2969775.3190, '2019-07-03 15:22:33', 'dbo', ''),
(2019060033, 201906, 56, 33, '2019-07-03', 5549, 'ENERGY', 25868, 25335, '2019-06-01', '2019-05-01', '2019-07-10', 533, 475522.1034, 0.0000, 11607.1400, 487129.2434, '2019-07-03 15:22:32', 'dbo', ''),
(2019060034, 201906, 56, 34, '2019-07-03', 5550, 'ENERGY', 12929, 12928, '2019-06-01', '2019-05-01', '2019-07-10', 1, 239273.5242, 0.0000, 21.7800, 239295.3042, '2019-07-03 15:22:32', 'dbo', ''),
(2019060035, 201906, 56, 35, '2019-07-03', 5551, 'ENERGY', 23911, 23555, '2019-06-01', '2019-05-01', '2019-07-10', 356, 411690.7126, 0.0000, 7752.6100, 419443.3226, '2019-07-03 15:22:32', 'dbo', ''),
(2019060036, 201906, 56, 36, '2019-07-03', 5552, 'ENERGY', 53725, 53426, '2019-06-01', '2019-05-01', '2019-07-10', 299, 948354.0838, 0.0000, 6511.3200, 954865.4038, '2019-07-03 15:22:32', 'dbo', ''),
(2019060037, 201906, 56, 37, '2019-07-03', 5553, 'ENERGY', 34154, 33224, '2019-06-01', '2019-05-01', '2019-07-10', 930, 583926.4810, 0.0000, 20252.6100, 604179.0910, '2019-07-03 15:22:33', 'dbo', ''),
(2019060038, 201906, 56, 38, '2019-07-03', 5554, 'ENERGY', 19798, 19449, '2019-06-01', '2019-05-01', '2019-07-10', 349, 361440.9434, 0.0000, 7600.1700, 369041.1134, '2019-07-03 15:22:33', 'dbo', ''),
(2019060039, 201906, 56, 39, '2019-07-03', 5555, 'ENERGY', 35572, 35061, '2019-06-01', '2019-05-01', '2019-07-10', 511, 3058.9582, 0.0000, 11128.0400, 14186.9982, '2019-07-03 15:22:33', 'dbo', ''),
(2019060040, 201906, 56, 40, '2019-07-03', 5556, 'ENERGY', 52174, 50495, '2019-06-01', '2019-05-01', '2019-07-10', 1679, 950545.3996, 0.0000, 36563.5600, 987108.9596, '2019-07-03 15:22:33', 'dbo', ''),
(2019060041, 201906, 56, 41, '2019-07-03', 5557, 'ENERGY', 241, 241, '2019-06-01', '2019-05-01', '2019-07-10', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2019-07-03 15:22:33', 'dbo', ''),
(2019060042, 201906, 56, 42, '2019-07-03', 5558, 'ENERGY', 334, 334, '2019-06-01', '2019-05-01', '2019-07-10', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2019-07-03 15:22:33', 'dbo', ''),
(2019060043, 201906, 56, 43, '2019-07-03', 5559, 'ENERGY', 102644, 101106, '2019-06-01', '2019-05-01', '2019-07-10', 1538, 1652078.3902, 0.0000, 33493.0000, 1685571.3902, '2019-07-03 15:22:32', 'dbo', ''),
(2019060044, 201906, 56, 44, '2019-07-03', 5560, 'ENERGY', 56526, 55704, '2019-06-01', '2019-05-01', '2019-07-10', 822, 1073710.3830, 0.0000, 17900.6900, 1091611.0730, '2019-07-03 15:22:32', 'dbo', ''),
(2019060045, 201906, 56, 45, '2019-07-03', 5561, 'ENERGY', 44175, 43614, '2019-06-01', '2019-05-01', '2019-07-10', 561, 560391.2920, 0.0000, 12216.8900, 572608.1820, '2019-07-03 15:22:33', 'dbo', ''),
(2019060046, 201906, 56, 46, '2019-07-03', 5562, 'ENERGY', 69708, 68681, '2019-06-01', '2019-05-01', '2019-07-10', 1027, 1260870.8654, 0.0000, 22364.9600, 1283235.8254, '2019-07-03 15:22:33', 'dbo', ''),
(2019060047, 201906, 56, 47, '2019-07-03', 5563, 'ENERGY', 36936, 36720, '2019-06-01', '2019-05-01', '2019-07-10', 216, 564052.7210, 0.0000, 4703.8200, 568756.5410, '2019-07-03 15:22:33', 'dbo', ''),
(2019060048, 201906, 56, 48, '2019-07-03', 5564, 'ENERGY', 30487, 29220, '2019-06-01', '2019-05-01', '2019-07-10', 1267, 589548.0300, 0.0000, 27591.4500, 617139.4800, '2019-07-03 15:22:33', 'dbo', ''),
(2019060049, 201906, 56, 49, '2019-07-03', 5565, 'ENERGY', 9634, 9440, '2019-06-01', '2019-05-01', '2019-07-10', 194, 175140.8590, 0.0000, 4224.7300, 179365.5890, '2019-07-03 15:22:32', 'dbo', ''),
(2019060050, 201906, 56, 50, '2019-07-03', 5566, 'ENERGY', 118927, 117277, '2019-06-01', '2019-05-01', '2019-07-10', 1650, 1966045.9092, 0.0000, 35932.0300, 2001977.9392, '2019-07-03 15:22:32', 'dbo', ''),
(2019060051, 201906, 56, 51, '2019-07-03', 5567, 'ENERGY', 211, 211, '2019-06-01', '2019-05-01', '2019-07-10', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2019-07-03 15:22:33', 'dbo', ''),
(2019060052, 201906, 56, 52, '2019-07-03', 5568, 'ENERGY', 321, 321, '2019-06-01', '2019-05-01', '2019-07-10', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2019-07-03 15:22:33', 'dbo', ''),
(2019060053, 201906, 56, 53, '2019-07-03', 5569, 'ENERGY', 13191, 12329, '2019-06-01', '2019-05-01', '2019-07-10', 862, 260249.8770, 0.0000, 18771.7700, 279021.6470, '2019-07-03 15:22:33', 'dbo', ''),
(2019060054, 201906, 56, 54, '2019-07-03', 5570, 'ENERGY', 41436, 41154, '2019-06-01', '2019-05-01', '2019-07-10', 282, 548529.6194, 0.0000, 6141.1100, 554670.7294, '2019-07-03 15:22:33', 'dbo', ''),
(2019060055, 201906, 56, 55, '2019-07-03', 5571, 'ENERGY', 16560, 16161, '2019-06-01', '2019-05-01', '2019-07-10', 399, 310471.9400, 0.0000, 8689.0200, 319160.9600, '2019-07-03 15:22:33', 'dbo', ''),
(2019060056, 201906, 56, 56, '2019-07-03', 5572, 'ENERGY', 8937, 8258, '2019-06-01', '2019-05-01', '2019-07-10', 679, 175786.4890, 0.0000, 14786.5700, 190573.0590, '2019-07-03 15:22:33', 'dbo', ''),
(2019060059, 201906, 56, 59, '2019-07-03', 5573, 'ENERGY', 128, 128, '2019-06-01', '2019-05-01', '2019-07-10', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2019-07-03 15:22:33', 'dbo', ''),
(2019060060, 201906, 56, 60, '2019-07-03', 5574, 'ENERGY', 356499, 350175, '2019-06-01', '2019-05-01', '2019-07-10', 6324, 5499471.3600, 0.0000, 137717.6600, 5637189.0200, '2019-07-03 15:22:32', 'dbo', ''),
(2019060061, 201906, 56, 61, '2019-07-03', 5575, 'ENERGY', 16, 16, '2019-06-01', '2019-05-01', '2019-07-10', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2019-07-03 15:22:33', 'dbo', ''),
(2019060062, 201906, 56, 62, '2019-07-03', 5576, 'ENERGY', 30, 30, '2019-06-01', '2019-05-01', '2019-07-10', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-07-03 15:22:33', 'dbo', ''),
(2019060063, 201906, 56, 63, '2019-07-03', 5577, 'ENERGY', 1, 1, '2019-06-01', '2019-05-01', '2019-07-10', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-07-03 15:22:33', 'dbo', ''),
(2019060064, 201906, 56, 64, '2019-07-03', 5578, 'ENERGY', 2, 2, '2019-06-01', '2019-05-01', '2019-07-10', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-07-03 15:22:33', 'dbo', ''),
(2019060065, 201906, 56, 65, '2019-07-03', 5579, 'ENERGY', 15663, 15408, '2019-06-01', '2019-05-01', '2019-07-10', 255, 312214.1980, 0.0000, 5553.1300, 317767.3280, '2019-07-03 15:22:32', 'dbo', ''),
(2019060066, 201906, 56, 66, '2019-07-03', 5580, 'ENERGY', 12480, 12058, '2019-06-01', '2019-05-01', '2019-07-10', 422, 244017.5524, 0.0000, 9189.8900, 253207.4424, '2019-07-03 15:22:32', 'dbo', ''),
(2019060067, 201906, 56, 67, '2019-07-03', 5581, 'ENERGY', 1454, 1416, '2019-06-01', '2019-05-01', '2019-07-10', 38, 36797.4938, 0.0000, 827.5200, 37625.0138, '2019-07-03 15:22:33', 'dbo', ''),
(2019060068, 201906, 56, 68, '2019-07-03', 5582, 'ENERGY', 3709, 3552, '2019-06-01', '2019-05-01', '2019-07-10', 157, 80477.6100, 0.0000, 3418.9900, 83896.6000, '2019-07-03 15:22:33', 'dbo', ''),
(2019060069, 201906, 56, 69, '2019-07-03', 5583, 'ENERGY', 1, 1, '2019-06-01', '2019-05-01', '2019-07-10', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2019-07-03 15:22:33', 'dbo', ''),
(2019060070, 201906, 56, 70, '2019-07-03', 5584, 'ENERGY', 3229, 3100, '2019-06-01', '2019-05-01', '2019-07-10', 129, 71671.8400, 0.0000, 2809.2300, 74481.0700, '2019-07-03 15:22:33', 'dbo', ''),
(2019060071, 201906, 56, 71, '2019-07-03', 5585, 'ENERGY', 286172, 286172, '2019-06-01', '2019-05-01', '2019-07-10', 0, 5539345.6462, 0.0000, 0.0000, 5539345.6462, '2019-07-03 15:22:33', 'dbo', ''),
(2019060072, 201906, 56, 72, '2019-07-03', 5586, 'ENERGY', 2464, 2464, '2019-06-01', '2019-05-01', '2019-07-10', 0, 59116.0200, 0.0000, 0.0000, 59116.0200, '2019-07-03 15:22:33', 'dbo', ''),
(2019060073, 201906, 56, 73, '2019-07-03', 5587, 'ENERGY', 521, 521, '2019-06-01', '2019-05-01', '2019-07-10', 0, 27102.7680, 0.0000, 0.0000, 27102.7680, '2019-07-03 15:22:33', 'dbo', ''),
(2019060075, 201906, 56, 75, '2019-07-03', 5588, 'ENERGY', 2033, 2005, '2019-06-01', '2019-05-01', '2019-07-10', 28, 48862.8200, 0.0000, 609.7500, 49472.5700, '2019-07-03 15:22:32', 'dbo', ''),
(2019060076, 201906, 56, 76, '2019-07-03', 5589, 'ENERGY', 2234, 2196, '2019-06-01', '2019-05-01', '2019-07-10', 38, 52284.3700, 0.0000, 827.5200, 53111.8900, '2019-07-03 15:22:32', 'dbo', ''),
(2019060077, 201906, 56, 77, '2019-07-03', 5590, 'ENERGY', 1737, 1709, '2019-06-01', '2019-05-01', '2019-07-10', 28, 43036.4800, 0.0000, 609.7500, 43646.2300, '2019-07-03 15:22:32', 'dbo', ''),
(2019060078, 201906, 56, 78, '2019-07-03', 5591, 'ENERGY', 550, 540, '2019-06-01', '2019-05-01', '2019-07-10', 10, 19679.6800, 0.0000, 217.7800, 19897.4600, '2019-07-03 15:22:32', 'dbo', ''),
(2019060079, 201906, 56, 79, '2019-07-03', 5592, 'ENERGY', 61638, 60466, '2019-06-01', '2019-05-01', '2019-07-10', 1172, 1071334.9800, 0.0000, 25522.6300, 1096857.6100, '2019-07-03 15:22:32', 'dbo', ''),
(2019060081, 201906, 56, 81, '2019-07-03', 5594, 'ENERGY', 2358, 2309, '2019-06-01', '2019-05-01', '2019-07-10', 49, 51955.4200, 0.0000, 1067.0800, 53022.5000, '2019-07-03 15:22:32', 'dbo', ''),
(2019060082, 201906, 56, 82, '2019-07-03', 5595, 'ENERGY', 5067, 4944, '2019-06-01', '2019-05-01', '2019-07-10', 123, 105402.7500, 0.0000, 2678.5700, 108081.3200, '2019-07-03 15:22:32', 'dbo', ''),
(2019060083, 201906, 56, 83, '2019-07-03', 5596, 'ENERGY', 115, 115, '2019-06-01', '2019-05-01', '2019-07-10', 0, 8109.7900, 0.0000, 0.0000, 8109.7900, '2019-07-03 15:22:33', 'dbo', ''),
(2019060085, 201906, 56, 85, '2019-07-03', 5598, 'ENERGY', 355, 355, '2019-06-01', '2019-05-01', '2019-07-10', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2019-07-03 15:22:33', 'dbo', ''),
(2019060086, 201906, 56, 86, '2019-07-03', 5599, 'ENERGY', 147, 143, '2019-06-01', '2019-05-01', '2019-07-10', 4, 8063.1000, 0.0000, 87.1100, 8150.2100, '2019-07-03 15:22:32', 'dbo', ''),
(2019070001, 201907, 57, 1, '2019-08-14', 5600, 'ENERGY', 0, 0, '2019-07-01', '2019-06-01', '2019-08-21', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2019-08-22 12:47:46', 'dbo', ''),
(2019070002, 201907, 57, 2, '2019-08-14', 5601, 'ENERGY', 0, 0, '2019-07-01', '2019-06-01', '2019-08-21', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2019-08-22 12:47:46', 'dbo', ''),
(2019070003, 201907, 57, 3, '2019-08-14', 5602, 'ENERGY', 0, 0, '2019-07-01', '2019-06-01', '2019-08-21', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2019-08-22 12:47:46', 'dbo', ''),
(2019070004, 201907, 57, 4, '2019-08-14', 5603, 'ENERGY', 0, 0, '2019-07-01', '2019-06-01', '2019-08-21', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2019-08-22 12:47:46', 'dbo', ''),
(2019070005, 201907, 57, 5, '2019-08-14', 5604, 'ENERGY', 0, 0, '2019-07-01', '2019-06-01', '2019-08-21', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2019-08-22 12:47:46', 'dbo', ''),
(2019070006, 201907, 57, 6, '2019-08-14', 5605, 'ENERGY', 0, 0, '2019-07-01', '2019-06-01', '2019-08-21', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2019-08-22 12:47:46', 'dbo', ''),
(2019070007, 201907, 57, 7, '2019-08-14', 5606, 'ENERGY', 0, 0, '2019-07-01', '2019-06-01', '2019-08-21', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2019-08-22 12:47:46', 'dbo', ''),
(2019070008, 201907, 57, 8, '2019-08-14', 5607, 'ENERGY', 0, 0, '2019-07-01', '2019-06-01', '2019-08-21', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2019-08-22 12:47:46', 'dbo', ''),
(2019070009, 201907, 57, 9, '2019-08-14', 5608, 'ENERGY', 11411, 11321, '2019-07-01', '2019-06-01', '2019-08-21', 90, 247125.2664, 0.0000, 1951.0600, 249076.3264, '2019-08-22 12:47:44', 'dbo', ''),
(2019070010, 201907, 57, 10, '2019-08-14', 5609, 'ENERGY', 777, 776, '2019-07-01', '2019-06-01', '2019-08-21', 1, 23761.3680, 0.0000, 21.6900, 23783.0580, '2019-08-22 12:47:44', 'dbo', ''),
(2019070011, 201907, 57, 11, '2019-08-14', 5610, 'ENERGY', 2141, 1410, '2019-07-01', '2019-06-01', '2019-08-21', 731, 36214.4110, 0.0000, 15846.9500, 52061.3610, '2019-08-22 12:47:44', 'dbo', ''),
(2019070012, 201907, 57, 12, '2019-08-14', 5611, 'ENERGY', 137, 137, '2019-07-01', '2019-06-01', '2019-08-21', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2019-08-22 12:47:46', 'dbo', ''),
(2019070013, 201907, 57, 13, '2019-08-14', 5612, 'ENERGY', 28474, 26772, '2019-07-01', '2019-06-01', '2019-08-21', 1702, 555044.9140, 0.0000, 36896.7400, 591941.6540, '2019-08-22 12:47:45', 'dbo', ''),
(2019070014, 201907, 57, 14, '2019-08-14', 5613, 'ENERGY', 13924, 13268, '2019-07-01', '2019-06-01', '2019-08-21', 656, 282340.8054, 0.0000, 14221.0700, 296561.8754, '2019-08-22 12:47:45', 'dbo', ''),
(2019070015, 201907, 57, 15, '2019-08-14', 5614, 'ENERGY', 162, 162, '2019-07-01', '2019-06-01', '2019-08-21', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2019-08-22 12:47:46', 'dbo', ''),
(2019070016, 201907, 57, 16, '2019-08-14', 5615, 'ENERGY', 18156, 17818, '2019-07-01', '2019-06-01', '2019-08-21', 338, 368075.1220, 0.0000, 7327.3300, 375402.4520, '2019-08-22 12:47:45', 'dbo', ''),
(2019070017, 201907, 57, 17, '2019-08-14', 5616, 'ENERGY', 62305, 59277, '2019-07-01', '2019-06-01', '2019-08-21', 3028, 1203310.9270, 0.0000, 65642.3900, 1268953.3170, '2019-08-22 12:47:44', 'dbo', ''),
(2019070018, 201907, 57, 18, '2019-08-14', 5617, 'ENERGY', 15102, 14493, '2019-07-01', '2019-06-01', '2019-08-21', 609, 298506.4300, 0.0000, 13202.1900, 311708.6200, '2019-08-22 12:47:44', 'dbo', ''),
(2019070019, 201907, 57, 19, '2019-08-14', 5618, 'ENERGY', 3370, 2477, '2019-07-01', '2019-06-01', '2019-08-21', 893, 53128.8750, 0.0000, 19358.8700, 72487.7450, '2019-08-22 12:47:44', 'dbo', ''),
(2019070020, 201907, 57, 20, '2019-08-14', 5619, 'ENERGY', 1778, 1225, '2019-07-01', '2019-06-01', '2019-08-21', 553, 27556.2730, 0.0000, 11988.2000, 39544.4730, '2019-08-22 12:47:44', 'dbo', ''),
(2019070021, 201907, 57, 21, '2019-08-14', 5620, 'ENERGY', 48754, 48754, '2019-07-01', '2019-06-01', '2019-08-21', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2019-08-22 12:47:46', 'dbo', ''),
(2019070022, 201907, 57, 22, '2019-08-14', 5621, 'ENERGY', 29187, 29187, '2019-07-01', '2019-06-01', '2019-08-21', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2019-08-22 12:47:46', 'dbo', ''),
(2019070023, 201907, 57, 23, '2019-08-14', 5622, 'ENERGY', 77425, 77425, '2019-07-01', '2019-06-01', '2019-08-21', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2019-08-22 12:47:46', 'dbo', ''),
(2019070024, 201907, 57, 24, '2019-08-14', 5623, 'ENERGY', 47443, 47443, '2019-07-01', '2019-06-01', '2019-08-21', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2019-08-22 12:47:46', 'dbo', ''),
(2019070025, 201907, 57, 25, '2019-08-14', 5624, 'ENERGY', 162247, 157050, '2019-07-01', '2019-06-01', '2019-08-21', 5197, 3149563.7900, 0.0000, 112662.9900, 3262226.7800, '2019-08-22 12:47:44', 'dbo', ''),
(2019070026, 201907, 57, 26, '2019-08-14', 5625, 'ENERGY', 91130, 89456, '2019-07-01', '2019-06-01', '2019-08-21', 1674, 1589692.7974, 0.0000, 36289.7500, 1625982.5474, '2019-08-22 12:47:44', 'dbo', ''),
(2019070029, 201907, 57, 29, '2019-08-14', 5626, 'ENERGY', 125632, 123612, '2019-07-01', '2019-06-01', '2019-08-21', 2020, 2102233.6888, 0.0000, 43790.5000, 2146024.1888, '2019-08-22 12:47:45', 'dbo', ''),
(2019070030, 201907, 57, 30, '2019-08-14', 5627, 'ENERGY', 61505, 60425, '2019-07-01', '2019-06-01', '2019-08-21', 1080, 924993.4512, 0.0000, 23412.7500, 948406.2012, '2019-08-22 12:47:45', 'dbo', ''),
(2019070031, 201907, 57, 31, '2019-08-14', 5628, 'ENERGY', 104525, 102911, '2019-07-01', '2019-06-01', '2019-08-21', 1614, 1801864.5580, 0.0000, 34989.0400, 1836853.5980, '2019-08-22 12:47:45', 'dbo', ''),
(2019070032, 201907, 57, 32, '2019-08-14', 5629, 'ENERGY', 172530, 169179, '2019-07-01', '2019-06-01', '2019-08-21', 3351, 2969775.3190, 0.0000, 72644.5500, 3042419.8690, '2019-08-22 12:47:45', 'dbo', ''),
(2019070033, 201907, 57, 33, '2019-08-14', 5630, 'ENERGY', 26475, 25868, '2019-07-01', '2019-06-01', '2019-08-21', 607, 487129.2434, 0.0000, 13158.8300, 500288.0734, '2019-08-22 12:47:44', 'dbo', ''),
(2019070034, 201907, 57, 34, '2019-08-14', 5631, 'ENERGY', 12932, 12929, '2019-07-01', '2019-06-01', '2019-08-21', 3, 239295.3042, 0.0000, 65.0400, 239360.3442, '2019-08-22 12:47:44', 'dbo', ''),
(2019070035, 201907, 57, 35, '2019-08-14', 5632, 'ENERGY', 24391, 23911, '2019-07-01', '2019-06-01', '2019-08-21', 480, 419443.3226, 0.0000, 10405.6700, 429848.9926, '2019-08-22 12:47:45', 'dbo', ''),
(2019070036, 201907, 57, 36, '2019-08-14', 5633, 'ENERGY', 54038, 53725, '2019-07-01', '2019-06-01', '2019-08-21', 313, 954865.4038, 0.0000, 6785.3600, 961650.7638, '2019-08-22 12:47:45', 'dbo', ''),
(2019070037, 201907, 57, 37, '2019-08-14', 5634, 'ENERGY', 35399, 34154, '2019-07-01', '2019-06-01', '2019-08-21', 1245, 604179.0910, 0.0000, 26989.6900, 631168.7810, '2019-08-22 12:47:45', 'dbo', ''),
(2019070038, 201907, 57, 38, '2019-08-14', 5635, 'ENERGY', 20204, 19798, '2019-07-01', '2019-06-01', '2019-08-21', 406, 369041.1134, 0.0000, 8801.4600, 377842.5734, '2019-08-22 12:47:45', 'dbo', ''),
(2019070039, 201907, 57, 39, '2019-08-14', 5636, 'ENERGY', 36162, 35572, '2019-07-01', '2019-06-01', '2019-08-21', 590, 14186.9982, 0.0000, 12790.2900, 26977.2882, '2019-08-22 12:47:45', 'dbo', ''),
(2019070040, 201907, 57, 40, '2019-08-14', 5637, 'ENERGY', 53894, 52174, '2019-07-01', '2019-06-01', '2019-08-21', 1720, 987108.9596, 0.0000, 37286.9600, 1024395.9196, '2019-08-22 12:47:45', 'dbo', ''),
(2019070041, 201907, 57, 41, '2019-08-14', 5638, 'ENERGY', 241, 241, '2019-07-01', '2019-06-01', '2019-08-21', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2019-08-22 12:47:46', 'dbo', ''),
(2019070042, 201907, 57, 42, '2019-08-14', 5639, 'ENERGY', 334, 334, '2019-07-01', '2019-06-01', '2019-08-21', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2019-08-22 12:47:46', 'dbo', ''),
(2019070043, 201907, 57, 43, '2019-08-14', 5640, 'ENERGY', 104338, 102644, '2019-07-01', '2019-06-01', '2019-08-21', 1694, 1685571.3902, 0.0000, 36723.3200, 1722294.7102, '2019-08-22 12:47:44', 'dbo', ''),
(2019070044, 201907, 57, 44, '2019-08-14', 5641, 'ENERGY', 57391, 56526, '2019-07-01', '2019-06-01', '2019-08-21', 865, 1091611.0730, 0.0000, 18751.8700, 1110362.9430, '2019-08-22 12:47:44', 'dbo', ''),
(2019070045, 201907, 57, 45, '2019-08-14', 5642, 'ENERGY', 44787, 44175, '2019-07-01', '2019-06-01', '2019-08-21', 612, 572608.1820, 0.0000, 13267.2100, 585875.3920, '2019-08-22 12:47:45', 'dbo', ''),
(2019070046, 201907, 57, 46, '2019-08-14', 5643, 'ENERGY', 70690, 69708, '2019-07-01', '2019-06-01', '2019-08-21', 982, 1283235.8254, 0.0000, 21288.2600, 1304524.0854, '2019-08-22 12:47:45', 'dbo', ''),
(2019070047, 201907, 57, 47, '2019-08-14', 5644, 'ENERGY', 37158, 36936, '2019-07-01', '2019-06-01', '2019-08-21', 222, 568756.5410, 0.0000, 4812.6100, 573569.1510, '2019-08-22 12:47:45', 'dbo', ''),
(2019070048, 201907, 57, 48, '2019-08-14', 5645, 'ENERGY', 31800, 30487, '2019-07-01', '2019-06-01', '2019-08-21', 1313, 617139.4800, 0.0000, 28463.8300, 645603.3100, '2019-08-22 12:47:45', 'dbo', ''),
(2019070049, 201907, 57, 49, '2019-08-14', 5646, 'ENERGY', 9823, 9634, '2019-07-01', '2019-06-01', '2019-08-21', 189, 179365.5890, 0.0000, 4097.2200, 183462.8090, '2019-08-22 12:47:44', 'dbo', ''),
(2019070050, 201907, 57, 50, '2019-08-14', 5647, 'ENERGY', 120527, 118927, '2019-07-01', '2019-06-01', '2019-08-21', 1600, 2001977.9392, 0.0000, 34685.5500, 2036663.4892, '2019-08-22 12:47:44', 'dbo', ''),
(2019070051, 201907, 57, 51, '2019-08-14', 5648, 'ENERGY', 211, 211, '2019-07-01', '2019-06-01', '2019-08-21', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2019-08-22 12:47:46', 'dbo', ''),
(2019070052, 201907, 57, 52, '2019-08-14', 5649, 'ENERGY', 321, 321, '2019-07-01', '2019-06-01', '2019-08-21', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2019-08-22 12:47:46', 'dbo', ''),
(2019070053, 201907, 57, 53, '2019-08-14', 5650, 'ENERGY', 13996, 13191, '2019-07-01', '2019-06-01', '2019-08-21', 805, 279021.6470, 0.0000, 17451.1700, 296472.8170, '2019-08-22 12:47:45', 'dbo', ''),
(2019070054, 201907, 57, 54, '2019-08-14', 5651, 'ENERGY', 41752, 41436, '2019-07-01', '2019-06-01', '2019-08-21', 316, 554670.7294, 0.0000, 6850.4000, 561521.1294, '2019-08-22 12:47:45', 'dbo', ''),
(2019070055, 201907, 57, 55, '2019-08-14', 5652, 'ENERGY', 16946, 16560, '2019-07-01', '2019-06-01', '2019-08-21', 386, 319160.9600, 0.0000, 8367.8900, 327528.8500, '2019-08-22 12:47:45', 'dbo', ''),
(2019070056, 201907, 57, 56, '2019-08-14', 5653, 'ENERGY', 9664, 8937, '2019-07-01', '2019-06-01', '2019-08-21', 727, 190573.0590, 0.0000, 15760.2500, 206333.3090, '2019-08-22 12:47:45', 'dbo', ''),
(2019070059, 201907, 57, 59, '2019-08-14', 5654, 'ENERGY', 128, 128, '2019-07-01', '2019-06-01', '2019-08-21', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2019-08-22 12:47:45', 'dbo', ''),
(2019070060, 201907, 57, 60, '2019-08-14', 5655, 'ENERGY', 362940, 356499, '2019-07-01', '2019-06-01', '2019-08-21', 6441, 5637189.0200, 0.0000, 139630.9900, 5776820.0100, '2019-08-22 12:47:44', 'dbo', ''),
(2019070061, 201907, 57, 61, '2019-08-14', 5656, 'ENERGY', 16, 16, '2019-07-01', '2019-06-01', '2019-08-21', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2019-08-22 12:47:45', 'dbo', ''),
(2019070062, 201907, 57, 62, '2019-08-14', 5657, 'ENERGY', 30, 30, '2019-07-01', '2019-06-01', '2019-08-21', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-08-22 12:47:45', 'dbo', ''),
(2019070063, 201907, 57, 63, '2019-08-14', 5658, 'ENERGY', 1, 1, '2019-07-01', '2019-06-01', '2019-08-21', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-08-22 12:47:45', 'dbo', ''),
(2019070064, 201907, 57, 64, '2019-08-14', 5659, 'ENERGY', 2, 2, '2019-07-01', '2019-06-01', '2019-08-21', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-08-22 12:47:45', 'dbo', ''),
(2019070065, 201907, 57, 65, '2019-08-14', 5660, 'ENERGY', 15917, 15663, '2019-07-01', '2019-06-01', '2019-08-21', 254, 317767.3280, 0.0000, 5506.3300, 323273.6580, '2019-08-22 12:47:44', 'dbo', ''),
(2019070066, 201907, 57, 66, '2019-08-14', 5661, 'ENERGY', 12922, 12480, '2019-07-01', '2019-06-01', '2019-08-21', 442, 253207.4424, 0.0000, 9581.8800, 262789.3224, '2019-08-22 12:47:44', 'dbo', ''),
(2019070067, 201907, 57, 67, '2019-08-14', 5662, 'ENERGY', 1480, 1454, '2019-07-01', '2019-06-01', '2019-08-21', 26, 37625.0138, 0.0000, 563.6400, 38188.6538, '2019-08-22 12:47:45', 'dbo', ''),
(2019070068, 201907, 57, 68, '2019-08-14', 5663, 'ENERGY', 3821, 3709, '2019-07-01', '2019-06-01', '2019-08-21', 112, 83896.6000, 0.0000, 2427.9800, 86324.5800, '2019-08-22 12:47:45', 'dbo', ''),
(2019070069, 201907, 57, 69, '2019-08-14', 5664, 'ENERGY', 1, 1, '2019-07-01', '2019-06-01', '2019-08-21', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2019-08-22 12:47:46', 'dbo', ''),
(2019070070, 201907, 57, 70, '2019-08-14', 5665, 'ENERGY', 3392, 3229, '2019-07-01', '2019-06-01', '2019-08-21', 163, 74481.0700, 0.0000, 3533.5900, 78014.6600, '2019-08-22 12:47:45', 'dbo', ''),
(2019070071, 201907, 57, 71, '2019-08-14', 5666, 'ENERGY', 286172, 286172, '2019-07-01', '2019-06-01', '2019-08-21', 0, 5539345.6462, 0.0000, 0.0000, 5539345.6462, '2019-08-22 12:47:45', 'dbo', ''),
(2019070072, 201907, 57, 72, '2019-08-14', 5667, 'ENERGY', 2464, 2464, '2019-07-01', '2019-06-01', '2019-08-21', 0, 59116.0200, 0.0000, 0.0000, 59116.0200, '2019-08-22 12:47:45', 'dbo', ''),
(2019070073, 201907, 57, 73, '2019-08-14', 5668, 'ENERGY', 521, 521, '2019-07-01', '2019-06-01', '2019-08-21', 0, 27102.7680, 0.0000, 0.0000, 27102.7680, '2019-08-22 12:47:45', 'dbo', ''),
(2019070075, 201907, 57, 75, '2019-08-14', 5669, 'ENERGY', 2062, 2033, '2019-07-01', '2019-06-01', '2019-08-21', 29, 49472.5700, 0.0000, 628.6800, 50101.2500, '2019-08-22 12:47:44', 'dbo', ''),
(2019070076, 201907, 57, 76, '2019-08-14', 5670, 'ENERGY', 2274, 2234, '2019-07-01', '2019-06-01', '2019-08-21', 40, 53111.8900, 0.0000, 867.1500, 53979.0400, '2019-08-22 12:47:44', 'dbo', ''),
(2019070077, 201907, 57, 77, '2019-08-14', 5671, 'ENERGY', 1766, 1737, '2019-07-01', '2019-06-01', '2019-08-21', 29, 43646.2300, 0.0000, 628.6800, 44274.9100, '2019-08-22 12:47:43', 'dbo', ''),
(2019070078, 201907, 57, 78, '2019-08-14', 5672, 'ENERGY', 561, 550, '2019-07-01', '2019-06-01', '2019-08-21', 11, 19897.4600, 0.0000, 238.4700, 20135.9300, '2019-08-22 12:47:44', 'dbo', ''),
(2019070079, 201907, 57, 79, '2019-08-14', 5673, 'ENERGY', 62855, 61638, '2019-07-01', '2019-06-01', '2019-08-21', 1217, 1096857.6100, 0.0000, 26382.7000, 1123240.3100, '2019-08-22 12:47:45', 'dbo', ''),
(2019070081, 201907, 57, 81, '2019-08-14', 5675, 'ENERGY', 2409, 2358, '2019-07-01', '2019-06-01', '2019-08-21', 51, 53022.5000, 0.0000, 1105.6100, 54128.1100, '2019-08-22 12:47:45', 'dbo', ''),
(2019070082, 201907, 57, 82, '2019-08-14', 5676, 'ENERGY', 5194, 5067, '2019-07-01', '2019-06-01', '2019-08-21', 127, 108081.3200, 0.0000, 2753.1600, 110834.4800, '2019-08-22 12:47:45', 'dbo', ''),
(2019070083, 201907, 57, 83, '2019-08-14', 5677, 'ENERGY', 120, 115, '2019-07-01', '2019-06-01', '2019-08-21', 5, 8109.7900, 0.0000, 108.4000, 8218.1900, '2019-08-22 12:47:44', 'dbo', ''),
(2019070085, 201907, 57, 85, '2019-08-14', 5679, 'ENERGY', 355, 355, '2019-07-01', '2019-06-01', '2019-08-21', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2019-08-22 12:47:46', 'dbo', ''),
(2019070086, 201907, 57, 86, '2019-08-14', 5680, 'ENERGY', 151, 147, '2019-07-01', '2019-06-01', '2019-08-21', 4, 8150.2100, 0.0000, 86.7100, 8236.9200, '2019-08-22 12:47:45', 'dbo', ''),
(2019080001, 201908, 58, 1, '2019-09-04', 5681, 'ENERGY', 0, 0, '2019-08-01', '2019-07-01', '2019-09-11', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2019-09-04 14:13:22', 'dbo', ''),
(2019080002, 201908, 58, 2, '2019-09-04', 5682, 'ENERGY', 0, 0, '2019-08-01', '2019-07-01', '2019-09-11', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2019-09-04 14:13:22', 'dbo', ''),
(2019080003, 201908, 58, 3, '2019-09-04', 5683, 'ENERGY', 0, 0, '2019-08-01', '2019-07-01', '2019-09-11', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2019-09-04 14:13:22', 'dbo', ''),
(2019080004, 201908, 58, 4, '2019-09-04', 5684, 'ENERGY', 0, 0, '2019-08-01', '2019-07-01', '2019-09-11', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2019-09-04 14:13:22', 'dbo', ''),
(2019080005, 201908, 58, 5, '2019-09-04', 5685, 'ENERGY', 0, 0, '2019-08-01', '2019-07-01', '2019-09-11', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2019-09-04 14:13:22', 'dbo', ''),
(2019080006, 201908, 58, 6, '2019-09-04', 5686, 'ENERGY', 0, 0, '2019-08-01', '2019-07-01', '2019-09-11', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2019-09-04 14:13:22', 'dbo', ''),
(2019080007, 201908, 58, 7, '2019-09-04', 5687, 'ENERGY', 0, 0, '2019-08-01', '2019-07-01', '2019-09-11', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2019-09-04 14:13:22', 'dbo', ''),
(2019080008, 201908, 58, 8, '2019-09-04', 5688, 'ENERGY', 0, 0, '2019-08-01', '2019-07-01', '2019-09-11', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2019-09-04 14:13:22', 'dbo', ''),
(2019080009, 201908, 58, 9, '2019-09-04', 5689, 'ENERGY', 11653, 11411, '2019-08-01', '2019-07-01', '2019-09-11', 242, 249076.3264, 0.0000, 5322.1000, 254398.4264, '2019-09-04 14:13:21', 'dbo', ''),
(2019080010, 201908, 58, 10, '2019-09-04', 5690, 'ENERGY', 778, 777, '2019-08-01', '2019-07-01', '2019-09-11', 1, 23783.0580, 0.0000, 21.9900, 23805.0480, '2019-09-04 14:13:21', 'dbo', ''),
(2019080011, 201908, 58, 11, '2019-09-04', 5691, 'ENERGY', 2924, 2141, '2019-08-01', '2019-07-01', '2019-09-11', 783, 52061.3610, 0.0000, 17219.8700, 69281.2310, '2019-09-04 14:13:21', 'dbo', ''),
(2019080012, 201908, 58, 12, '2019-09-04', 5692, 'ENERGY', 137, 137, '2019-08-01', '2019-07-01', '2019-09-11', 0, 8423.1000, 0.0000, 0.0000, 8423.1000, '2019-09-04 14:13:22', 'dbo', ''),
(2019080013, 201908, 58, 13, '2019-09-04', 5693, 'ENERGY', 30027, 28474, '2019-08-01', '2019-07-01', '2019-09-11', 1553, 591941.6540, 0.0000, 34153.8500, 626095.5040, '2019-09-04 14:13:22', 'dbo', ''),
(2019080014, 201908, 58, 14, '2019-09-04', 5694, 'ENERGY', 14677, 13924, '2019-08-01', '2019-07-01', '2019-09-11', 753, 296561.8754, 0.0000, 16560.1100, 313121.9854, '2019-09-04 14:13:22', 'dbo', ''),
(2019080015, 201908, 58, 15, '2019-09-04', 5695, 'ENERGY', 162, 162, '2019-08-01', '2019-07-01', '2019-09-11', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2019-09-04 14:13:22', 'dbo', ''),
(2019080016, 201908, 58, 16, '2019-09-04', 5696, 'ENERGY', 18533, 18156, '2019-08-01', '2019-07-01', '2019-09-11', 377, 375402.4520, 0.0000, 8291.0500, 383693.5020, '2019-09-04 14:13:22', 'dbo', ''),
(2019080017, 201908, 58, 17, '2019-09-04', 5697, 'ENERGY', 64957, 62305, '2019-08-01', '2019-07-01', '2019-09-11', 2652, 1268953.3170, 0.0000, 58323.2500, 1327276.5670, '2019-09-04 14:13:21', 'dbo', ''),
(2019080018, 201908, 58, 18, '2019-09-04', 5698, 'ENERGY', 15953, 15102, '2019-08-01', '2019-07-01', '2019-09-11', 851, 311708.6200, 0.0000, 18715.3400, 330423.9600, '2019-09-04 14:13:21', 'dbo', ''),
(2019080019, 201908, 58, 19, '2019-09-04', 5699, 'ENERGY', 5038, 3370, '2019-08-01', '2019-07-01', '2019-09-11', 1668, 72487.7450, 0.0000, 36682.9300, 109170.6750, '2019-09-04 14:13:21', 'dbo', ''),
(2019080020, 201908, 58, 20, '2019-09-04', 5700, 'ENERGY', 2239, 1778, '2019-08-01', '2019-07-01', '2019-09-11', 461, 39544.4730, 0.0000, 10138.3900, 49682.8630, '2019-09-04 14:13:21', 'dbo', ''),
(2019080021, 201908, 58, 21, '2019-09-04', 5701, 'ENERGY', 48754, 48754, '2019-08-01', '2019-07-01', '2019-09-11', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2019-09-04 14:13:22', 'dbo', ''),
(2019080022, 201908, 58, 22, '2019-09-04', 5702, 'ENERGY', 29187, 29187, '2019-08-01', '2019-07-01', '2019-09-11', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2019-09-04 14:13:22', 'dbo', ''),
(2019080023, 201908, 58, 23, '2019-09-04', 5703, 'ENERGY', 77425, 77425, '2019-08-01', '2019-07-01', '2019-09-11', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2019-09-04 14:13:22', 'dbo', ''),
(2019080024, 201908, 58, 24, '2019-09-04', 5704, 'ENERGY', 47443, 47443, '2019-08-01', '2019-07-01', '2019-09-11', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2019-09-04 14:13:22', 'dbo', ''),
(2019080025, 201908, 58, 25, '2019-09-04', 5705, 'ENERGY', 167504, 162247, '2019-08-01', '2019-07-01', '2019-09-11', 5257, 3262226.7800, 0.0000, 115612.8600, 3377839.6400, '2019-09-04 14:13:21', 'dbo', ''),
(2019080026, 201908, 58, 26, '2019-09-04', 5706, 'ENERGY', 92816, 91130, '2019-08-01', '2019-07-01', '2019-09-11', 1686, 1625982.5474, 0.0000, 37078.8000, 1663061.3474, '2019-09-04 14:13:21', 'dbo', ''),
(2019080029, 201908, 58, 29, '2019-09-04', 5707, 'ENERGY', 127689, 125632, '2019-08-01', '2019-07-01', '2019-09-11', 2057, 2146024.1888, 0.0000, 45237.9000, 2191262.0888, '2019-09-04 14:13:22', 'dbo', ''),
(2019080030, 201908, 58, 30, '2019-09-04', 5708, 'ENERGY', 62539, 61505, '2019-08-01', '2019-07-01', '2019-09-11', 1034, 948406.2012, 0.0000, 22739.9000, 971146.1012, '2019-09-04 14:13:22', 'dbo', ''),
(2019080031, 201908, 58, 31, '2019-09-04', 5709, 'ENERGY', 106304, 104525, '2019-08-01', '2019-07-01', '2019-09-11', 1779, 1836853.5980, 0.0000, 39124.0800, 1875977.6780, '2019-09-04 14:13:22', 'dbo', ''),
(2019080032, 201908, 58, 32, '2019-09-04', 5710, 'ENERGY', 176148, 172530, '2019-08-01', '2019-07-01', '2019-09-11', 3618, 3042419.8690, 0.0000, 79567.6900, 3121987.5590, '2019-09-04 14:13:22', 'dbo', ''),
(2019080033, 201908, 58, 33, '2019-09-04', 5711, 'ENERGY', 27106, 26475, '2019-08-01', '2019-07-01', '2019-09-11', 631, 500288.0734, 0.0000, 13877.0600, 514165.1334, '2019-09-04 14:13:21', 'dbo', ''),
(2019080034, 201908, 58, 34, '2019-09-04', 5712, 'ENERGY', 12932, 12932, '2019-08-01', '2019-07-01', '2019-09-11', 0, 239360.3442, 0.0000, 0.0000, 239360.3442, '2019-09-04 14:13:22', 'dbo', ''),
(2019080035, 201908, 58, 35, '2019-09-04', 5713, 'ENERGY', 24882, 24391, '2019-08-01', '2019-07-01', '2019-09-11', 491, 429848.9926, 0.0000, 10798.1600, 440647.1526, '2019-09-04 14:13:21', 'dbo', ''),
(2019080036, 201908, 58, 36, '2019-09-04', 5714, 'ENERGY', 54354, 54038, '2019-08-01', '2019-07-01', '2019-09-11', 316, 961650.7638, 0.0000, 6949.5200, 968600.2838, '2019-09-04 14:13:21', 'dbo', ''),
(2019080037, 201908, 58, 37, '2019-09-04', 5715, 'ENERGY', 36894, 35399, '2019-08-01', '2019-07-01', '2019-09-11', 1495, 631168.7810, 0.0000, 32878.3000, 664047.0810, '2019-09-04 14:13:22', 'dbo', ''),
(2019080038, 201908, 58, 38, '2019-09-04', 5716, 'ENERGY', 20622, 20204, '2019-08-01', '2019-07-01', '2019-09-11', 418, 377842.5734, 0.0000, 9192.7200, 387035.2934, '2019-09-04 14:13:22', 'dbo', ''),
(2019080039, 201908, 58, 39, '2019-09-04', 5717, 'ENERGY', 36799, 36162, '2019-08-01', '2019-07-01', '2019-09-11', 637, 26977.2882, 0.0000, 14009.0200, 40986.3082, '2019-09-04 14:13:22', 'dbo', ''),
(2019080040, 201908, 58, 40, '2019-09-04', 5718, 'ENERGY', 55667, 53894, '2019-08-01', '2019-07-01', '2019-09-11', 1773, 1024395.9196, 0.0000, 38992.1300, 1063388.0496, '2019-09-04 14:13:22', 'dbo', ''),
(2019080041, 201908, 58, 41, '2019-09-04', 5719, 'ENERGY', 241, 241, '2019-08-01', '2019-07-01', '2019-09-11', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2019-09-04 14:13:22', 'dbo', ''),
(2019080042, 201908, 58, 42, '2019-09-04', 5720, 'ENERGY', 334, 334, '2019-08-01', '2019-07-01', '2019-09-11', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2019-09-04 14:13:22', 'dbo', ''),
(2019080043, 201908, 58, 43, '2019-09-04', 5721, 'ENERGY', 105918, 104338, '2019-08-01', '2019-07-01', '2019-09-11', 1580, 1722294.7102, 0.0000, 34747.6400, 1757042.3502, '2019-09-04 14:13:21', 'dbo', ''),
(2019080044, 201908, 58, 44, '2019-09-04', 5722, 'ENERGY', 58134, 57391, '2019-08-01', '2019-07-01', '2019-09-11', 743, 1110362.9430, 0.0000, 16340.1900, 1126703.1330, '2019-09-04 14:13:21', 'dbo', ''),
(2019080045, 201908, 58, 45, '2019-09-04', 5723, 'ENERGY', 45367, 44787, '2019-08-01', '2019-07-01', '2019-09-11', 580, 585875.3920, 0.0000, 12755.4600, 598630.8520, '2019-09-04 14:13:22', 'dbo', ''),
(2019080046, 201908, 58, 46, '2019-09-04', 5724, 'ENERGY', 71639, 70690, '2019-08-01', '2019-07-01', '2019-09-11', 949, 1304524.0854, 0.0000, 20870.5700, 1325394.6554, '2019-09-04 14:13:22', 'dbo', ''),
(2019080047, 201908, 58, 47, '2019-09-04', 5725, 'ENERGY', 37384, 37158, '2019-08-01', '2019-07-01', '2019-09-11', 226, 573569.1510, 0.0000, 4970.2200, 578539.3710, '2019-09-04 14:13:22', 'dbo', ''),
(2019080048, 201908, 58, 48, '2019-09-04', 5726, 'ENERGY', 33026, 31800, '2019-08-01', '2019-07-01', '2019-09-11', 1226, 645603.3100, 0.0000, 26962.4000, 672565.7100, '2019-09-04 14:13:22', 'dbo', ''),
(2019080049, 201908, 58, 49, '2019-09-04', 5727, 'ENERGY', 10059, 9823, '2019-08-01', '2019-07-01', '2019-09-11', 236, 183462.8090, 0.0000, 5190.1500, 188652.9590, '2019-09-04 14:13:21', 'dbo', ''),
(2019080050, 201908, 58, 50, '2019-09-04', 5728, 'ENERGY', 122403, 120527, '2019-08-01', '2019-07-01', '2019-09-11', 1876, 2036663.4892, 0.0000, 41257.3100, 2077920.7992, '2019-09-04 14:13:21', 'dbo', ''),
(2019080051, 201908, 58, 51, '2019-09-04', 5729, 'ENERGY', 211, 211, '2019-08-01', '2019-07-01', '2019-09-11', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2019-09-04 14:13:22', 'dbo', ''),
(2019080052, 201908, 58, 52, '2019-09-04', 5730, 'ENERGY', 321, 321, '2019-08-01', '2019-07-01', '2019-09-11', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2019-09-04 14:13:22', 'dbo', ''),
(2019080053, 201908, 58, 53, '2019-09-04', 5731, 'ENERGY', 14754, 13996, '2019-08-01', '2019-07-01', '2019-09-11', 758, 296472.8170, 0.0000, 16670.0700, 313142.8870, '2019-09-04 14:13:22', 'dbo', ''),
(2019080054, 201908, 58, 54, '2019-09-04', 5732, 'ENERGY', 42089, 41752, '2019-08-01', '2019-07-01', '2019-09-11', 337, 561521.1294, 0.0000, 7411.3600, 568932.4894, '2019-09-04 14:13:22', 'dbo', ''),
(2019080055, 201908, 58, 55, '2019-09-04', 5733, 'ENERGY', 17283, 16946, '2019-08-01', '2019-07-01', '2019-09-11', 337, 327528.8500, 0.0000, 7411.3600, 334940.2100, '2019-09-04 14:13:22', 'dbo', ''),
(2019080056, 201908, 58, 56, '2019-09-04', 5734, 'ENERGY', 10410, 9664, '2019-08-01', '2019-07-01', '2019-09-11', 746, 206333.3090, 0.0000, 16406.1700, 222739.4790, '2019-09-04 14:13:22', 'dbo', ''),
(2019080059, 201908, 58, 59, '2019-09-04', 5735, 'ENERGY', 128, 128, '2019-08-01', '2019-07-01', '2019-09-11', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2019-09-04 14:13:22', 'dbo', '');
INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2019080060, 201908, 58, 60, '2019-09-04', 5736, 'ENERGY', 362940, 362940, '2019-08-01', '2019-07-01', '2019-09-11', 0, 5776820.0100, 0.0000, 0.0000, 5776820.0100, '2019-09-04 14:13:22', 'dbo', ''),
(2019080061, 201908, 58, 61, '2019-09-04', 5737, 'ENERGY', 16, 16, '2019-08-01', '2019-07-01', '2019-09-11', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2019-09-04 14:13:22', 'dbo', ''),
(2019080062, 201908, 58, 62, '2019-09-04', 5738, 'ENERGY', 30, 30, '2019-08-01', '2019-07-01', '2019-09-11', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-09-04 14:13:22', 'dbo', ''),
(2019080063, 201908, 58, 63, '2019-09-04', 5739, 'ENERGY', 1, 1, '2019-08-01', '2019-07-01', '2019-09-11', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-09-04 14:13:22', 'dbo', ''),
(2019080064, 201908, 58, 64, '2019-09-04', 5740, 'ENERGY', 2, 2, '2019-08-01', '2019-07-01', '2019-09-11', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-09-04 14:13:22', 'dbo', ''),
(2019080065, 201908, 58, 65, '2019-09-04', 5741, 'ENERGY', 16170, 15917, '2019-08-01', '2019-07-01', '2019-09-11', 253, 323273.6580, 0.0000, 5564.0200, 328837.6780, '2019-09-04 14:13:21', 'dbo', ''),
(2019080066, 201908, 58, 66, '2019-09-04', 5742, 'ENERGY', 13363, 12922, '2019-08-01', '2019-07-01', '2019-09-11', 441, 262789.3224, 0.0000, 9698.5400, 272487.8624, '2019-09-04 14:13:21', 'dbo', ''),
(2019080067, 201908, 58, 67, '2019-09-04', 5743, 'ENERGY', 1513, 1480, '2019-08-01', '2019-07-01', '2019-09-11', 33, 38188.6538, 0.0000, 725.7300, 38914.3838, '2019-09-04 14:13:22', 'dbo', ''),
(2019080068, 201908, 58, 68, '2019-09-04', 5744, 'ENERGY', 3918, 3821, '2019-08-01', '2019-07-01', '2019-09-11', 97, 86324.5800, 0.0000, 2133.2400, 88457.8200, '2019-09-04 14:13:22', 'dbo', ''),
(2019080069, 201908, 58, 69, '2019-09-04', 5745, 'ENERGY', 1, 1, '2019-08-01', '2019-07-01', '2019-09-11', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2019-09-04 14:13:22', 'dbo', ''),
(2019080070, 201908, 58, 70, '2019-09-04', 5746, 'ENERGY', 3537, 3392, '2019-08-01', '2019-07-01', '2019-09-11', 145, 78014.6600, 0.0000, 3188.8800, 81203.5400, '2019-09-04 14:13:22', 'dbo', ''),
(2019080071, 201908, 58, 71, '2019-09-04', 5747, 'ENERGY', 286172, 286172, '2019-08-01', '2019-07-01', '2019-09-11', 0, 5539345.6462, 0.0000, 0.0000, 5539345.6462, '2019-09-04 14:13:22', 'dbo', ''),
(2019080072, 201908, 58, 72, '2019-09-04', 5748, 'ENERGY', 2464, 2464, '2019-08-01', '2019-07-01', '2019-09-11', 0, 59116.0200, 0.0000, 0.0000, 59116.0200, '2019-09-04 14:13:22', 'dbo', ''),
(2019080073, 201908, 58, 73, '2019-09-04', 5749, 'ENERGY', 523, 521, '2019-08-01', '2019-07-01', '2019-09-11', 2, 27102.7680, 0.0000, 43.9900, 27146.7580, '2019-09-04 14:13:21', 'dbo', ''),
(2019080075, 201908, 58, 75, '2019-09-04', 5750, 'ENERGY', 2094, 2062, '2019-08-01', '2019-07-01', '2019-09-11', 32, 50101.2500, 0.0000, 703.7600, 50805.0100, '2019-09-04 14:13:21', 'dbo', ''),
(2019080076, 201908, 58, 76, '2019-09-04', 5751, 'ENERGY', 2316, 2274, '2019-08-01', '2019-07-01', '2019-09-11', 42, 53979.0400, 0.0000, 923.6700, 54902.7100, '2019-09-04 14:13:21', 'dbo', ''),
(2019080077, 201908, 58, 77, '2019-09-04', 5752, 'ENERGY', 1796, 1766, '2019-08-01', '2019-07-01', '2019-09-11', 30, 44274.9100, 0.0000, 659.7700, 44934.6800, '2019-09-04 14:13:21', 'dbo', ''),
(2019080078, 201908, 58, 78, '2019-09-04', 5753, 'ENERGY', 573, 561, '2019-08-01', '2019-07-01', '2019-09-11', 12, 20135.9300, 0.0000, 263.9000, 20399.8300, '2019-09-04 14:13:21', 'dbo', ''),
(2019080079, 201908, 58, 79, '2019-09-04', 5754, 'ENERGY', 63745, 62855, '2019-08-01', '2019-07-01', '2019-09-11', 890, 1123240.3100, 0.0000, 19573.0300, 1142813.3400, '2019-09-04 14:13:22', 'dbo', ''),
(2019080081, 201908, 58, 81, '2019-09-04', 5756, 'ENERGY', 2464, 2409, '2019-08-01', '2019-07-01', '2019-09-11', 55, 54128.1100, 0.0000, 1209.5600, 55337.6700, '2019-09-04 14:13:22', 'dbo', ''),
(2019080082, 201908, 58, 82, '2019-09-04', 5757, 'ENERGY', 5330, 5194, '2019-08-01', '2019-07-01', '2019-09-11', 136, 110834.4800, 0.0000, 2990.9400, 113825.4200, '2019-09-04 14:13:22', 'dbo', ''),
(2019080083, 201908, 58, 83, '2019-09-04', 5758, 'ENERGY', 123, 120, '2019-08-01', '2019-07-01', '2019-09-11', 3, 8218.1900, 0.0000, 65.9800, 8284.1700, '2019-09-04 14:13:21', 'dbo', ''),
(2019080085, 201908, 58, 85, '2019-09-04', 5760, 'ENERGY', 355, 355, '2019-08-01', '2019-07-01', '2019-09-11', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2019-09-04 14:13:22', 'dbo', ''),
(2019080086, 201908, 58, 86, '2019-09-04', 5761, 'ENERGY', 151, 151, '2019-08-01', '2019-07-01', '2019-09-11', 0, 8236.9200, 0.0000, 0.0000, 8236.9200, '2019-09-04 14:13:22', 'dbo', ''),
(2019090001, 201909, 59, 1, '2019-10-07', 5762, 'ENERGY', 0, 0, '2019-09-01', '2019-08-01', '2019-10-14', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2019-10-07 12:40:45', 'dbo', ''),
(2019090002, 201909, 59, 2, '2019-10-07', 5763, 'ENERGY', 0, 0, '2019-09-01', '2019-08-01', '2019-10-14', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2019-10-07 12:40:45', 'dbo', ''),
(2019090003, 201909, 59, 3, '2019-10-07', 5764, 'ENERGY', 0, 0, '2019-09-01', '2019-08-01', '2019-10-14', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2019-10-07 12:40:45', 'dbo', ''),
(2019090004, 201909, 59, 4, '2019-10-07', 5765, 'ENERGY', 0, 0, '2019-09-01', '2019-08-01', '2019-10-14', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2019-10-07 12:40:45', 'dbo', ''),
(2019090005, 201909, 59, 5, '2019-10-07', 5766, 'ENERGY', 0, 0, '2019-09-01', '2019-08-01', '2019-10-14', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2019-10-07 12:40:45', 'dbo', ''),
(2019090006, 201909, 59, 6, '2019-10-07', 5767, 'ENERGY', 0, 0, '2019-09-01', '2019-08-01', '2019-10-14', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2019-10-07 12:40:45', 'dbo', ''),
(2019090007, 201909, 59, 7, '2019-10-07', 5768, 'ENERGY', 0, 0, '2019-09-01', '2019-08-01', '2019-10-14', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2019-10-07 12:40:45', 'dbo', ''),
(2019090008, 201909, 59, 8, '2019-10-07', 5769, 'ENERGY', 0, 0, '2019-09-01', '2019-08-01', '2019-10-14', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2019-10-07 12:40:45', 'dbo', ''),
(2019090009, 201909, 59, 9, '2019-10-07', 5770, 'ENERGY', 11976, 11653, '2019-09-01', '2019-08-01', '2019-10-14', 323, 254398.4264, 0.0000, 7073.5000, 261471.9264, '2019-10-07 12:40:45', 'dbo', ''),
(2019090010, 201909, 59, 10, '2019-10-07', 5771, 'ENERGY', 914, 778, '2019-09-01', '2019-08-01', '2019-10-14', 136, 23805.0480, 0.0000, 2978.3300, 26783.3780, '2019-10-07 12:40:45', 'dbo', ''),
(2019090011, 201909, 59, 11, '2019-10-07', 5772, 'ENERGY', 3723, 2924, '2019-09-01', '2019-08-01', '2019-10-14', 799, 69281.2310, 0.0000, 17497.6300, 86778.8610, '2019-10-07 12:40:45', 'dbo', ''),
(2019090012, 201909, 59, 12, '2019-10-07', 5773, 'ENERGY', 196, 137, '2019-09-01', '2019-08-01', '2019-10-14', 59, 8423.1000, 0.0000, 1292.0700, 9715.1700, '2019-10-07 12:40:45', 'dbo', ''),
(2019090013, 201909, 59, 13, '2019-10-07', 5774, 'ENERGY', 31310, 30027, '2019-09-01', '2019-08-01', '2019-10-14', 1283, 626095.5040, 0.0000, 28096.9500, 654192.4540, '2019-10-07 12:40:45', 'dbo', ''),
(2019090014, 201909, 59, 14, '2019-10-07', 5775, 'ENERGY', 15567, 14677, '2019-09-01', '2019-08-01', '2019-10-14', 890, 313121.9854, 0.0000, 19490.4700, 332612.4554, '2019-10-07 12:40:45', 'dbo', ''),
(2019090015, 201909, 59, 15, '2019-10-07', 5776, 'ENERGY', 162, 162, '2019-09-01', '2019-08-01', '2019-10-14', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2019-10-07 12:40:45', 'dbo', ''),
(2019090016, 201909, 59, 16, '2019-10-07', 5777, 'ENERGY', 18893, 18533, '2019-09-01', '2019-08-01', '2019-10-14', 360, 383693.5020, 0.0000, 7883.7900, 391577.2920, '2019-10-07 12:40:45', 'dbo', ''),
(2019090017, 201909, 59, 17, '2019-10-07', 5778, 'ENERGY', 67858, 64957, '2019-09-01', '2019-08-01', '2019-10-14', 2901, 1327276.5670, 0.0000, 63530.1900, 1390806.7570, '2019-10-07 12:40:45', 'dbo', ''),
(2019090018, 201909, 59, 18, '2019-10-07', 5779, 'ENERGY', 16587, 15953, '2019-09-01', '2019-08-01', '2019-10-14', 634, 330423.9600, 0.0000, 13884.2300, 344308.1900, '2019-10-07 12:40:45', 'dbo', ''),
(2019090019, 201909, 59, 19, '2019-10-07', 5780, 'ENERGY', 6678, 5038, '2019-09-01', '2019-08-01', '2019-10-14', 1640, 109170.6750, 0.0000, 35915.0400, 145085.7150, '2019-10-07 12:40:45', 'dbo', ''),
(2019090020, 201909, 59, 20, '2019-10-07', 5781, 'ENERGY', 2641, 2239, '2019-09-01', '2019-08-01', '2019-10-14', 402, 49682.8630, 0.0000, 8803.5700, 58486.4330, '2019-10-07 12:40:45', 'dbo', ''),
(2019090021, 201909, 59, 21, '2019-10-07', 5782, 'ENERGY', 48754, 48754, '2019-09-01', '2019-08-01', '2019-10-14', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2019-10-07 12:40:45', 'dbo', ''),
(2019090022, 201909, 59, 22, '2019-10-07', 5783, 'ENERGY', 29187, 29187, '2019-09-01', '2019-08-01', '2019-10-14', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2019-10-07 12:40:45', 'dbo', ''),
(2019090023, 201909, 59, 23, '2019-10-07', 5784, 'ENERGY', 77425, 77425, '2019-09-01', '2019-08-01', '2019-10-14', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2019-10-07 12:40:45', 'dbo', ''),
(2019090024, 201909, 59, 24, '2019-10-07', 5785, 'ENERGY', 47443, 47443, '2019-09-01', '2019-08-01', '2019-10-14', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2019-10-07 12:40:45', 'dbo', ''),
(2019090025, 201909, 59, 25, '2019-10-07', 5786, 'ENERGY', 172227, 167504, '2019-09-01', '2019-08-01', '2019-10-14', 4723, 3377839.6400, 0.0000, 103430.9100, 3481270.5500, '2019-10-07 12:40:45', 'dbo', ''),
(2019090026, 201909, 59, 26, '2019-10-07', 5787, 'ENERGY', 94597, 92816, '2019-09-01', '2019-08-01', '2019-10-14', 1781, 1663061.3474, 0.0000, 39002.8500, 1702064.1974, '2019-10-07 12:40:45', 'dbo', ''),
(2019090029, 201909, 59, 29, '2019-10-07', 5788, 'ENERGY', 129650, 127689, '2019-09-01', '2019-08-01', '2019-10-14', 1961, 2191262.0888, 0.0000, 42944.7500, 2234206.8388, '2019-10-07 12:40:45', 'dbo', ''),
(2019090030, 201909, 59, 30, '2019-10-07', 5789, 'ENERGY', 63569, 62539, '2019-09-01', '2019-08-01', '2019-10-14', 1030, 971146.1012, 0.0000, 22556.4000, 993702.5012, '2019-10-07 12:40:45', 'dbo', ''),
(2019090031, 201909, 59, 31, '2019-10-07', 5790, 'ENERGY', 108159, 106304, '2019-09-01', '2019-08-01', '2019-10-14', 1855, 1875977.6780, 0.0000, 40623.4100, 1916601.0880, '2019-10-07 12:40:45', 'dbo', ''),
(2019090032, 201909, 59, 32, '2019-10-07', 5791, 'ENERGY', 179435, 176148, '2019-09-01', '2019-08-01', '2019-10-14', 3287, 3121987.5590, 0.0000, 71983.3700, 3193970.9290, '2019-10-07 12:40:45', 'dbo', ''),
(2019090033, 201909, 59, 33, '2019-10-07', 5792, 'ENERGY', 27673, 27106, '2019-09-01', '2019-08-01', '2019-10-14', 567, 514165.1334, 0.0000, 12416.9700, 526582.1034, '2019-10-07 12:40:45', 'dbo', ''),
(2019090034, 201909, 59, 34, '2019-10-07', 5793, 'ENERGY', 12933, 12932, '2019-09-01', '2019-08-01', '2019-10-14', 1, 239360.3442, 0.0000, 21.8900, 239382.2342, '2019-10-07 12:40:45', 'dbo', ''),
(2019090035, 201909, 59, 35, '2019-10-07', 5794, 'ENERGY', 25337, 24882, '2019-09-01', '2019-08-01', '2019-10-14', 455, 440647.1526, 0.0000, 9964.2300, 450611.3826, '2019-10-07 12:40:45', 'dbo', ''),
(2019090036, 201909, 59, 36, '2019-10-07', 5795, 'ENERGY', 54651, 54354, '2019-09-01', '2019-08-01', '2019-10-14', 297, 968600.2838, 0.0000, 6504.1300, 975104.4138, '2019-10-07 12:40:45', 'dbo', ''),
(2019090037, 201909, 59, 37, '2019-10-07', 5796, 'ENERGY', 38158, 36894, '2019-09-01', '2019-08-01', '2019-10-14', 1264, 664047.0810, 0.0000, 27680.8500, 691727.9310, '2019-10-07 12:40:45', 'dbo', ''),
(2019090038, 201909, 59, 38, '2019-10-07', 5797, 'ENERGY', 21001, 20622, '2019-09-01', '2019-08-01', '2019-10-14', 379, 387035.2934, 0.0000, 8299.8800, 395335.1734, '2019-10-07 12:40:45', 'dbo', ''),
(2019090039, 201909, 59, 39, '2019-10-07', 5798, 'ENERGY', 37327, 36799, '2019-09-01', '2019-08-01', '2019-10-14', 528, 40986.3082, 0.0000, 11562.9000, 52549.2082, '2019-10-07 12:40:45', 'dbo', ''),
(2019090040, 201909, 59, 40, '2019-10-07', 5799, 'ENERGY', 57352, 55667, '2019-09-01', '2019-08-01', '2019-10-14', 1685, 1063388.0496, 0.0000, 36900.5100, 1100288.5596, '2019-10-07 12:40:45', 'dbo', ''),
(2019090041, 201909, 59, 41, '2019-10-07', 5800, 'ENERGY', 241, 241, '2019-09-01', '2019-08-01', '2019-10-14', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2019-10-07 12:40:45', 'dbo', ''),
(2019090042, 201909, 59, 42, '2019-10-07', 5801, 'ENERGY', 334, 334, '2019-09-01', '2019-08-01', '2019-10-14', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2019-10-07 12:40:45', 'dbo', ''),
(2019090043, 201909, 59, 43, '2019-10-07', 5802, 'ENERGY', 107677, 105918, '2019-09-01', '2019-08-01', '2019-10-14', 1759, 1757042.3502, 0.0000, 38521.0600, 1795563.4102, '2019-10-07 12:40:45', 'dbo', ''),
(2019090044, 201909, 59, 44, '2019-10-07', 5803, 'ENERGY', 58781, 58134, '2019-09-01', '2019-08-01', '2019-10-14', 647, 1126703.1330, 0.0000, 14168.9200, 1140872.0530, '2019-10-07 12:40:45', 'dbo', ''),
(2019090045, 201909, 59, 45, '2019-10-07', 5804, 'ENERGY', 45926, 45367, '2019-09-01', '2019-08-01', '2019-10-14', 559, 598630.8520, 0.0000, 12241.7700, 610872.6220, '2019-10-07 12:40:45', 'dbo', ''),
(2019090046, 201909, 59, 46, '2019-10-07', 5805, 'ENERGY', 72640, 71639, '2019-09-01', '2019-08-01', '2019-10-14', 1001, 1325394.6554, 0.0000, 21921.3000, 1347315.9554, '2019-10-07 12:40:45', 'dbo', ''),
(2019090047, 201909, 59, 47, '2019-10-07', 5806, 'ENERGY', 37621, 37384, '2019-09-01', '2019-08-01', '2019-10-14', 237, 578539.3710, 0.0000, 5190.1500, 583729.5210, '2019-10-07 12:40:45', 'dbo', ''),
(2019090048, 201909, 59, 48, '2019-10-07', 5807, 'ENERGY', 34227, 33026, '2019-09-01', '2019-08-01', '2019-10-14', 1201, 672565.7100, 0.0000, 26301.1800, 698866.8900, '2019-10-07 12:40:45', 'dbo', ''),
(2019090049, 201909, 59, 49, '2019-10-07', 5808, 'ENERGY', 10291, 10059, '2019-09-01', '2019-08-01', '2019-10-14', 232, 188652.9590, 0.0000, 5080.6800, 193733.6390, '2019-10-07 12:40:45', 'dbo', ''),
(2019090050, 201909, 59, 50, '2019-10-07', 5809, 'ENERGY', 124251, 122403, '2019-09-01', '2019-08-01', '2019-10-14', 1848, 2077920.7992, 0.0000, 40470.1100, 2118390.9092, '2019-10-07 12:40:45', 'dbo', ''),
(2019090051, 201909, 59, 51, '2019-10-07', 5810, 'ENERGY', 211, 211, '2019-09-01', '2019-08-01', '2019-10-14', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2019-10-07 12:40:45', 'dbo', ''),
(2019090052, 201909, 59, 52, '2019-10-07', 5811, 'ENERGY', 321, 321, '2019-09-01', '2019-08-01', '2019-10-14', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2019-10-07 12:40:45', 'dbo', ''),
(2019090053, 201909, 59, 53, '2019-10-07', 5812, 'ENERGY', 15615, 14754, '2019-09-01', '2019-08-01', '2019-10-14', 861, 313142.8870, 0.0000, 18855.4000, 331998.2870, '2019-10-07 12:40:45', 'dbo', ''),
(2019090054, 201909, 59, 54, '2019-10-07', 5813, 'ENERGY', 42493, 42089, '2019-09-01', '2019-08-01', '2019-10-14', 404, 568932.4894, 0.0000, 8847.3600, 577779.8494, '2019-10-07 12:40:45', 'dbo', ''),
(2019090055, 201909, 59, 55, '2019-10-07', 5814, 'ENERGY', 17664, 17283, '2019-09-01', '2019-08-01', '2019-10-14', 381, 334940.2100, 0.0000, 8343.6800, 343283.8900, '2019-10-07 12:40:45', 'dbo', ''),
(2019090056, 201909, 59, 56, '2019-10-07', 5815, 'ENERGY', 11142, 10410, '2019-09-01', '2019-08-01', '2019-10-14', 732, 222739.4790, 0.0000, 16030.3700, 238769.8490, '2019-10-07 12:40:45', 'dbo', ''),
(2019090059, 201909, 59, 59, '2019-10-07', 5816, 'ENERGY', 128, 128, '2019-09-01', '2019-08-01', '2019-10-14', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2019-10-07 12:40:45', 'dbo', ''),
(2019090060, 201909, 59, 60, '2019-10-07', 5817, 'ENERGY', 376259, 362940, '2019-09-01', '2019-08-01', '2019-10-14', 13319, 5776820.0100, 0.0000, 291678.2600, 6068498.2700, '2019-10-07 12:40:45', 'dbo', ''),
(2019090061, 201909, 59, 61, '2019-10-07', 5818, 'ENERGY', 16, 16, '2019-09-01', '2019-08-01', '2019-10-14', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2019-10-07 12:40:45', 'dbo', ''),
(2019090062, 201909, 59, 62, '2019-10-07', 5819, 'ENERGY', 30, 30, '2019-09-01', '2019-08-01', '2019-10-14', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-10-07 12:40:45', 'dbo', ''),
(2019090063, 201909, 59, 63, '2019-10-07', 5820, 'ENERGY', 1, 1, '2019-09-01', '2019-08-01', '2019-10-14', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-10-07 12:40:45', 'dbo', ''),
(2019090064, 201909, 59, 64, '2019-10-07', 5821, 'ENERGY', 2, 2, '2019-09-01', '2019-08-01', '2019-10-14', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-10-07 12:40:45', 'dbo', ''),
(2019090065, 201909, 59, 65, '2019-10-07', 5822, 'ENERGY', 16422, 16170, '2019-09-01', '2019-08-01', '2019-10-14', 252, 328837.6780, 0.0000, 5518.6500, 334356.3280, '2019-10-07 12:40:45', 'dbo', ''),
(2019090066, 201909, 59, 66, '2019-10-07', 5823, 'ENERGY', 13874, 13363, '2019-09-01', '2019-08-01', '2019-10-14', 511, 272487.8624, 0.0000, 11190.6000, 283678.4624, '2019-10-07 12:40:45', 'dbo', ''),
(2019090067, 201909, 59, 67, '2019-10-07', 5824, 'ENERGY', 1549, 1513, '2019-09-01', '2019-08-01', '2019-10-14', 36, 38914.3838, 0.0000, 788.3800, 39702.7638, '2019-10-07 12:40:45', 'dbo', ''),
(2019090068, 201909, 59, 68, '2019-10-07', 5825, 'ENERGY', 4038, 3918, '2019-09-01', '2019-08-01', '2019-10-14', 120, 88457.8200, 0.0000, 2627.9300, 91085.7500, '2019-10-07 12:40:45', 'dbo', ''),
(2019090069, 201909, 59, 69, '2019-10-07', 5826, 'ENERGY', 1, 1, '2019-09-01', '2019-08-01', '2019-10-14', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2019-10-07 12:40:45', 'dbo', ''),
(2019090070, 201909, 59, 70, '2019-10-07', 5827, 'ENERGY', 3691, 3537, '2019-09-01', '2019-08-01', '2019-10-14', 154, 81203.5400, 0.0000, 3372.5100, 84576.0500, '2019-10-07 12:40:45', 'dbo', ''),
(2019090071, 201909, 59, 71, '2019-10-07', 5828, 'ENERGY', 286172, 286172, '2019-09-01', '2019-08-01', '2019-10-14', 0, 5539345.6462, 0.0000, 0.0000, 5539345.6462, '2019-10-07 12:40:45', 'dbo', ''),
(2019090072, 201909, 59, 72, '2019-10-07', 5829, 'ENERGY', 2464, 2464, '2019-09-01', '2019-08-01', '2019-10-14', 0, 59116.0200, 0.0000, 0.0000, 59116.0200, '2019-10-07 12:40:45', 'dbo', ''),
(2019090073, 201909, 59, 73, '2019-10-07', 5830, 'ENERGY', 528, 523, '2019-09-01', '2019-08-01', '2019-10-14', 5, 27146.7580, 0.0000, 109.5000, 27256.2580, '2019-10-07 12:40:45', 'dbo', ''),
(2019090075, 201909, 59, 75, '2019-10-07', 5831, 'ENERGY', 2123, 2094, '2019-09-01', '2019-08-01', '2019-10-14', 29, 50805.0100, 0.0000, 635.0800, 51440.0900, '2019-10-07 12:40:45', 'dbo', ''),
(2019090076, 201909, 59, 76, '2019-10-07', 5832, 'ENERGY', 2356, 2316, '2019-09-01', '2019-08-01', '2019-10-14', 40, 54902.7100, 0.0000, 875.9800, 55778.6900, '2019-10-07 12:40:45', 'dbo', ''),
(2019090077, 201909, 59, 77, '2019-10-07', 5833, 'ENERGY', 1825, 1796, '2019-09-01', '2019-08-01', '2019-10-14', 29, 44934.6800, 0.0000, 635.0800, 45569.7600, '2019-10-07 12:40:45', 'dbo', ''),
(2019090078, 201909, 59, 78, '2019-10-07', 5834, 'ENERGY', 584, 573, '2019-09-01', '2019-08-01', '2019-10-14', 11, 20399.8300, 0.0000, 240.8900, 20640.7200, '2019-10-07 12:40:45', 'dbo', ''),
(2019090079, 201909, 59, 79, '2019-10-07', 5835, 'ENERGY', 64514, 63745, '2019-09-01', '2019-08-01', '2019-10-14', 769, 1142813.3400, 0.0000, 16840.6500, 1159653.9900, '2019-10-07 12:40:45', 'dbo', ''),
(2019090081, 201909, 59, 81, '2019-10-07', 5837, 'ENERGY', 2513, 2464, '2019-09-01', '2019-08-01', '2019-10-14', 49, 55337.6700, 0.0000, 1073.0700, 56410.7400, '2019-10-07 12:40:45', 'dbo', ''),
(2019090082, 201909, 59, 82, '2019-10-07', 5838, 'ENERGY', 5458, 5330, '2019-09-01', '2019-08-01', '2019-10-14', 128, 113825.4200, 0.0000, 2803.1200, 116628.5400, '2019-10-07 12:40:45', 'dbo', ''),
(2019090083, 201909, 59, 83, '2019-10-07', 5839, 'ENERGY', 127, 123, '2019-09-01', '2019-08-01', '2019-10-14', 4, 8284.1700, 0.0000, 87.6000, 8371.7700, '2019-10-07 12:40:45', 'dbo', ''),
(2019090084, 201909, 59, 84, '2019-10-07', 5840, 'ENERGY', 170, 162, '2019-09-01', '2019-08-01', '2019-10-14', 8, 8810.4900, 0.0000, 175.1900, 8985.6800, '2019-10-07 12:40:45', 'dbo', ''),
(2019090085, 201909, 59, 85, '2019-10-07', 5841, 'ENERGY', 355, 355, '2019-09-01', '2019-08-01', '2019-10-14', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2019-10-07 12:40:45', 'dbo', ''),
(2019090086, 201909, 59, 86, '2019-10-07', 5842, 'ENERGY', 151, 151, '2019-09-01', '2019-08-01', '2019-10-14', 0, 8236.9200, 0.0000, 0.0000, 8236.9200, '2019-10-07 12:40:45', 'dbo', ''),
(2019100001, 201910, 60, 1, '2019-11-04', 5843, 'ENERGY', 0, 0, '2019-10-01', '2019-09-01', '2019-11-11', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2019-11-05 10:01:56', 'dbo', ''),
(2019100002, 201910, 60, 2, '2019-11-04', 5844, 'ENERGY', 0, 0, '2019-10-01', '2019-09-01', '2019-11-11', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2019-11-05 10:01:56', 'dbo', ''),
(2019100003, 201910, 60, 3, '2019-11-04', 5845, 'ENERGY', 0, 0, '2019-10-01', '2019-09-01', '2019-11-11', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2019-11-05 10:01:56', 'dbo', ''),
(2019100004, 201910, 60, 4, '2019-11-04', 5846, 'ENERGY', 0, 0, '2019-10-01', '2019-09-01', '2019-11-11', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2019-11-05 10:01:56', 'dbo', ''),
(2019100005, 201910, 60, 5, '2019-11-04', 5847, 'ENERGY', 0, 0, '2019-10-01', '2019-09-01', '2019-11-11', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2019-11-05 10:01:56', 'dbo', ''),
(2019100006, 201910, 60, 6, '2019-11-04', 5848, 'ENERGY', 0, 0, '2019-10-01', '2019-09-01', '2019-11-11', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2019-11-05 10:01:56', 'dbo', ''),
(2019100007, 201910, 60, 7, '2019-11-04', 5849, 'ENERGY', 0, 0, '2019-10-01', '2019-09-01', '2019-11-11', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2019-11-05 10:01:56', 'dbo', ''),
(2019100008, 201910, 60, 8, '2019-11-04', 5850, 'ENERGY', 0, 0, '2019-10-01', '2019-09-01', '2019-11-11', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2019-11-05 10:01:56', 'dbo', ''),
(2019100009, 201910, 60, 9, '2019-11-04', 5851, 'ENERGY', 12829, 11976, '2019-10-01', '2019-09-01', '2019-11-11', 853, 261471.9264, 0.0000, 18422.0600, 279893.9864, '2019-11-05 10:01:56', 'dbo', ''),
(2019100010, 201910, 60, 10, '2019-11-04', 5852, 'ENERGY', 952, 914, '2019-10-01', '2019-09-01', '2019-11-11', 38, 26783.3780, 0.0000, 820.6700, 27604.0480, '2019-11-05 10:01:56', 'dbo', ''),
(2019100011, 201910, 60, 11, '2019-11-04', 5853, 'ENERGY', 4523, 3723, '2019-10-01', '2019-09-01', '2019-11-11', 800, 86778.8610, 0.0000, 17277.4300, 104056.2910, '2019-11-05 10:01:56', 'dbo', ''),
(2019100012, 201910, 60, 12, '2019-11-04', 5854, 'ENERGY', 428, 196, '2019-10-01', '2019-09-01', '2019-11-11', 232, 9715.1700, 0.0000, 5010.4500, 14725.6200, '2019-11-05 10:01:56', 'dbo', ''),
(2019100013, 201910, 60, 13, '2019-11-04', 5855, 'ENERGY', 32469, 31310, '2019-10-01', '2019-09-01', '2019-11-11', 1159, 654192.4540, 0.0000, 25030.6800, 679223.1340, '2019-11-05 10:01:56', 'dbo', ''),
(2019100014, 201910, 60, 14, '2019-11-04', 5856, 'ENERGY', 16261, 15567, '2019-10-01', '2019-09-01', '2019-11-11', 694, 332612.4554, 0.0000, 14988.1700, 347600.6254, '2019-11-05 10:01:56', 'dbo', ''),
(2019100015, 201910, 60, 15, '2019-11-04', 5857, 'ENERGY', 162, 162, '2019-10-01', '2019-09-01', '2019-11-11', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2019-11-05 10:01:56', 'dbo', ''),
(2019100016, 201910, 60, 16, '2019-11-04', 5858, 'ENERGY', 19343, 18893, '2019-10-01', '2019-09-01', '2019-11-11', 450, 391577.2920, 0.0000, 9718.5600, 401295.8520, '2019-11-05 10:01:56', 'dbo', ''),
(2019100017, 201910, 60, 17, '2019-11-04', 5859, 'ENERGY', 69719, 67858, '2019-10-01', '2019-09-01', '2019-11-11', 1861, 1390806.7570, 0.0000, 40191.6300, 1430998.3870, '2019-11-05 10:01:56', 'dbo', ''),
(2019100018, 201910, 60, 18, '2019-11-04', 5860, 'ENERGY', 17391, 16587, '2019-10-01', '2019-09-01', '2019-11-11', 804, 344308.1900, 0.0000, 17363.8300, 361672.0200, '2019-11-05 10:01:56', 'dbo', ''),
(2019100019, 201910, 60, 19, '2019-11-04', 5861, 'ENERGY', 8414, 6678, '2019-10-01', '2019-09-01', '2019-11-11', 1736, 145085.7150, 0.0000, 37492.0300, 182577.7450, '2019-11-05 10:01:56', 'dbo', ''),
(2019100020, 201910, 60, 20, '2019-11-04', 5862, 'ENERGY', 3165, 2641, '2019-10-01', '2019-09-01', '2019-11-11', 524, 58486.4330, 0.0000, 11316.7200, 69803.1530, '2019-11-05 10:01:56', 'dbo', ''),
(2019100021, 201910, 60, 21, '2019-11-04', 5863, 'ENERGY', 48754, 48754, '2019-10-01', '2019-09-01', '2019-11-11', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2019-11-05 10:01:56', 'dbo', ''),
(2019100022, 201910, 60, 22, '2019-11-04', 5864, 'ENERGY', 29187, 29187, '2019-10-01', '2019-09-01', '2019-11-11', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2019-11-05 10:01:56', 'dbo', ''),
(2019100023, 201910, 60, 23, '2019-11-04', 5865, 'ENERGY', 77425, 77425, '2019-10-01', '2019-09-01', '2019-11-11', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2019-11-05 10:01:56', 'dbo', ''),
(2019100024, 201910, 60, 24, '2019-11-04', 5866, 'ENERGY', 47443, 47443, '2019-10-01', '2019-09-01', '2019-11-11', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2019-11-05 10:01:56', 'dbo', ''),
(2019100025, 201910, 60, 25, '2019-11-04', 5867, 'ENERGY', 176892, 172227, '2019-10-01', '2019-09-01', '2019-11-11', 4665, 3481270.5500, 0.0000, 100749.0300, 3582019.5800, '2019-11-05 10:01:56', 'dbo', ''),
(2019100026, 201910, 60, 26, '2019-11-04', 5868, 'ENERGY', 96334, 94597, '2019-10-01', '2019-09-01', '2019-11-11', 1737, 1702064.1974, 0.0000, 37513.6300, 1739577.8274, '2019-11-05 10:01:56', 'dbo', ''),
(2019100029, 201910, 60, 29, '2019-11-04', 5869, 'ENERGY', 131669, 129650, '2019-10-01', '2019-09-01', '2019-11-11', 2019, 2234206.8388, 0.0000, 43603.9300, 2277810.7688, '2019-11-05 10:01:56', 'dbo', ''),
(2019100030, 201910, 60, 30, '2019-11-04', 5870, 'ENERGY', 64507, 63569, '2019-10-01', '2019-09-01', '2019-11-11', 938, 993702.5012, 0.0000, 20257.7800, 1013960.2812, '2019-11-05 10:01:56', 'dbo', ''),
(2019100031, 201910, 60, 31, '2019-11-04', 5871, 'ENERGY', 109945, 108159, '2019-10-01', '2019-09-01', '2019-11-11', 1786, 1916601.0880, 0.0000, 38571.8700, 1955172.9580, '2019-11-05 10:01:56', 'dbo', ''),
(2019100032, 201910, 60, 32, '2019-11-04', 5872, 'ENERGY', 182225, 179435, '2019-10-01', '2019-09-01', '2019-11-11', 2790, 3193970.9290, 0.0000, 60255.0400, 3254225.9690, '2019-11-05 10:01:56', 'dbo', ''),
(2019100033, 201910, 60, 33, '2019-11-04', 5873, 'ENERGY', 28252, 27673, '2019-10-01', '2019-09-01', '2019-11-11', 579, 526582.1034, 0.0000, 12504.5400, 539086.6434, '2019-11-05 10:01:56', 'dbo', ''),
(2019100034, 201910, 60, 34, '2019-11-04', 5874, 'ENERGY', 12933, 12933, '2019-10-01', '2019-09-01', '2019-11-11', 0, 239382.2342, 0.0000, 0.0000, 239382.2342, '2019-11-05 10:01:56', 'dbo', ''),
(2019100035, 201910, 60, 35, '2019-11-04', 5875, 'ENERGY', 25756, 25337, '2019-10-01', '2019-09-01', '2019-11-11', 419, 450611.3826, 0.0000, 9049.0600, 459660.4426, '2019-11-05 10:01:56', 'dbo', ''),
(2019100036, 201910, 60, 36, '2019-11-04', 5876, 'ENERGY', 54944, 54651, '2019-10-01', '2019-09-01', '2019-11-11', 293, 975104.4138, 0.0000, 6327.8600, 981432.2738, '2019-11-05 10:01:56', 'dbo', ''),
(2019100037, 201910, 60, 37, '2019-11-04', 5877, 'ENERGY', 39382, 38158, '2019-10-01', '2019-09-01', '2019-11-11', 1224, 691727.9310, 0.0000, 26434.4800, 718162.4110, '2019-11-05 10:01:56', 'dbo', ''),
(2019100038, 201910, 60, 38, '2019-11-04', 5878, 'ENERGY', 21401, 21001, '2019-10-01', '2019-09-01', '2019-11-11', 400, 395335.1734, 0.0000, 8638.7100, 403973.8834, '2019-11-05 10:01:56', 'dbo', ''),
(2019100039, 201910, 60, 39, '2019-11-04', 5879, 'ENERGY', 37800, 37327, '2019-10-01', '2019-09-01', '2019-11-11', 473, 52549.2082, 0.0000, 10215.2900, 62764.4982, '2019-11-05 10:01:56', 'dbo', ''),
(2019100040, 201910, 60, 40, '2019-11-04', 5880, 'ENERGY', 58853, 57352, '2019-10-01', '2019-09-01', '2019-11-11', 1501, 1100288.5596, 0.0000, 32416.7800, 1132705.3396, '2019-11-05 10:01:56', 'dbo', ''),
(2019100041, 201910, 60, 41, '2019-11-04', 5881, 'ENERGY', 241, 241, '2019-10-01', '2019-09-01', '2019-11-11', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2019-11-05 10:01:56', 'dbo', ''),
(2019100042, 201910, 60, 42, '2019-11-04', 5882, 'ENERGY', 334, 334, '2019-10-01', '2019-09-01', '2019-11-11', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2019-11-05 10:01:56', 'dbo', ''),
(2019100043, 201910, 60, 43, '2019-11-04', 5883, 'ENERGY', 109256, 107677, '2019-10-01', '2019-09-01', '2019-11-11', 1579, 1795563.4102, 0.0000, 34101.3300, 1829664.7402, '2019-11-05 10:01:56', 'dbo', ''),
(2019100044, 201910, 60, 44, '2019-11-04', 5884, 'ENERGY', 59401, 58781, '2019-10-01', '2019-09-01', '2019-11-11', 620, 1140872.0530, 0.0000, 13390.0100, 1154262.0630, '2019-11-05 10:01:56', 'dbo', ''),
(2019100045, 201910, 60, 45, '2019-11-04', 5885, 'ENERGY', 46419, 45926, '2019-10-01', '2019-09-01', '2019-11-11', 493, 610872.6220, 0.0000, 10647.2200, 621519.8420, '2019-11-05 10:01:56', 'dbo', ''),
(2019100046, 201910, 60, 46, '2019-11-04', 5886, 'ENERGY', 73544, 72640, '2019-10-01', '2019-09-01', '2019-11-11', 904, 1347315.9554, 0.0000, 19523.5000, 1366839.4554, '2019-11-05 10:01:56', 'dbo', ''),
(2019100047, 201910, 60, 47, '2019-11-04', 5887, 'ENERGY', 37853, 37621, '2019-10-01', '2019-09-01', '2019-11-11', 232, 583729.5210, 0.0000, 5010.4500, 588739.9710, '2019-11-05 10:01:56', 'dbo', ''),
(2019100048, 201910, 60, 48, '2019-11-04', 5888, 'ENERGY', 35371, 34227, '2019-10-01', '2019-09-01', '2019-11-11', 1144, 698866.8900, 0.0000, 24706.7200, 723573.6100, '2019-11-05 10:01:56', 'dbo', ''),
(2019100049, 201910, 60, 49, '2019-11-04', 5889, 'ENERGY', 10493, 10291, '2019-10-01', '2019-09-01', '2019-11-11', 202, 193733.6390, 0.0000, 4362.5500, 198096.1890, '2019-11-05 10:01:56', 'dbo', ''),
(2019100050, 201910, 60, 50, '2019-11-04', 5890, 'ENERGY', 126126, 124251, '2019-10-01', '2019-09-01', '2019-11-11', 1875, 2118390.9092, 0.0000, 40493.9900, 2158884.8992, '2019-11-05 10:01:56', 'dbo', ''),
(2019100051, 201910, 60, 51, '2019-11-04', 5891, 'ENERGY', 211, 211, '2019-10-01', '2019-09-01', '2019-11-11', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2019-11-05 10:01:56', 'dbo', ''),
(2019100052, 201910, 60, 52, '2019-11-04', 5892, 'ENERGY', 321, 321, '2019-10-01', '2019-09-01', '2019-11-11', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2019-11-05 10:01:56', 'dbo', ''),
(2019100053, 201910, 60, 53, '2019-11-04', 5893, 'ENERGY', 16449, 15615, '2019-10-01', '2019-09-01', '2019-11-11', 834, 331998.2870, 0.0000, 18011.7200, 350010.0070, '2019-11-05 10:01:56', 'dbo', ''),
(2019100054, 201910, 60, 54, '2019-11-04', 5894, 'ENERGY', 42866, 42493, '2019-10-01', '2019-09-01', '2019-11-11', 373, 577779.8494, 0.0000, 8055.6200, 585835.4694, '2019-11-05 10:01:56', 'dbo', ''),
(2019100055, 201910, 60, 55, '2019-11-04', 5895, 'ENERGY', 18044, 17664, '2019-10-01', '2019-09-01', '2019-11-11', 380, 343283.8900, 0.0000, 8206.7800, 351490.6700, '2019-11-05 10:01:56', 'dbo', ''),
(2019100056, 201910, 60, 56, '2019-11-04', 5896, 'ENERGY', 11856, 11142, '2019-10-01', '2019-09-01', '2019-11-11', 714, 238769.8490, 0.0000, 15420.1100, 254189.9590, '2019-11-05 10:01:56', 'dbo', ''),
(2019100059, 201910, 60, 59, '2019-11-04', 5897, 'ENERGY', 128, 128, '2019-10-01', '2019-09-01', '2019-11-11', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2019-11-05 10:01:56', 'dbo', ''),
(2019100060, 201910, 60, 60, '2019-11-04', 5898, 'ENERGY', 382603, 376259, '2019-10-01', '2019-09-01', '2019-11-11', 6344, 6068498.2700, 0.0000, 137010.0400, 6205508.3100, '2019-11-05 10:01:56', 'dbo', ''),
(2019100061, 201910, 60, 61, '2019-11-04', 5899, 'ENERGY', 16, 16, '2019-10-01', '2019-09-01', '2019-11-11', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2019-11-05 10:01:56', 'dbo', ''),
(2019100062, 201910, 60, 62, '2019-11-04', 5900, 'ENERGY', 30, 30, '2019-10-01', '2019-09-01', '2019-11-11', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-11-05 10:01:56', 'dbo', ''),
(2019100063, 201910, 60, 63, '2019-11-04', 5901, 'ENERGY', 1, 1, '2019-10-01', '2019-09-01', '2019-11-11', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-11-05 10:01:56', 'dbo', ''),
(2019100064, 201910, 60, 64, '2019-11-04', 5902, 'ENERGY', 2, 2, '2019-10-01', '2019-09-01', '2019-11-11', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-11-05 10:01:56', 'dbo', ''),
(2019100065, 201910, 60, 65, '2019-11-04', 5903, 'ENERGY', 16674, 16422, '2019-10-01', '2019-09-01', '2019-11-11', 252, 334356.3280, 0.0000, 5442.3900, 339798.7180, '2019-11-05 10:01:56', 'dbo', ''),
(2019100066, 201910, 60, 66, '2019-11-04', 5904, 'ENERGY', 14311, 13874, '2019-10-01', '2019-09-01', '2019-11-11', 437, 283678.4624, 0.0000, 9437.8100, 293116.2724, '2019-11-05 10:01:56', 'dbo', ''),
(2019100067, 201910, 60, 67, '2019-11-04', 5905, 'ENERGY', 1580, 1549, '2019-10-01', '2019-09-01', '2019-11-11', 31, 39702.7638, 0.0000, 669.5000, 40372.2638, '2019-11-05 10:01:56', 'dbo', ''),
(2019100068, 201910, 60, 68, '2019-11-04', 5906, 'ENERGY', 4159, 4038, '2019-10-01', '2019-09-01', '2019-11-11', 121, 91085.7500, 0.0000, 2613.2200, 93698.9700, '2019-11-05 10:01:56', 'dbo', ''),
(2019100069, 201910, 60, 69, '2019-11-04', 5907, 'ENERGY', 1, 1, '2019-10-01', '2019-09-01', '2019-11-11', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2019-11-05 10:01:56', 'dbo', ''),
(2019100070, 201910, 60, 70, '2019-11-04', 5908, 'ENERGY', 3840, 3691, '2019-10-01', '2019-09-01', '2019-11-11', 149, 84576.0500, 0.0000, 3217.9300, 87793.9800, '2019-11-05 10:01:56', 'dbo', ''),
(2019100071, 201910, 60, 71, '2019-11-04', 5909, 'ENERGY', 286172, 286172, '2019-10-01', '2019-09-01', '2019-11-11', 0, 5539345.6462, 0.0000, 0.0000, 5539345.6462, '2019-11-05 10:01:56', 'dbo', ''),
(2019100072, 201910, 60, 72, '2019-11-04', 5910, 'ENERGY', 2464, 2464, '2019-10-01', '2019-09-01', '2019-11-11', 0, 59116.0200, 0.0000, 0.0000, 59116.0200, '2019-11-05 10:01:56', 'dbo', ''),
(2019100073, 201910, 60, 73, '2019-11-04', 5911, 'ENERGY', 536, 528, '2019-10-01', '2019-09-01', '2019-11-11', 8, 27256.2580, 0.0000, 172.7700, 27429.0280, '2019-11-05 10:01:56', 'dbo', ''),
(2019100075, 201910, 60, 75, '2019-11-04', 5912, 'ENERGY', 2153, 2123, '2019-10-01', '2019-09-01', '2019-11-11', 30, 51440.0900, 0.0000, 647.9100, 52088.0000, '2019-11-05 10:01:56', 'dbo', ''),
(2019100076, 201910, 60, 76, '2019-11-04', 5913, 'ENERGY', 2395, 2356, '2019-10-01', '2019-09-01', '2019-11-11', 39, 55778.6900, 0.0000, 842.2700, 56620.9600, '2019-11-05 10:01:56', 'dbo', ''),
(2019100077, 201910, 60, 77, '2019-11-04', 5914, 'ENERGY', 1854, 1825, '2019-10-01', '2019-09-01', '2019-11-11', 29, 45569.7600, 0.0000, 626.3000, 46196.0600, '2019-11-05 10:01:56', 'dbo', ''),
(2019100078, 201910, 60, 78, '2019-11-04', 5915, 'ENERGY', 593, 584, '2019-10-01', '2019-09-01', '2019-11-11', 9, 20640.7200, 0.0000, 194.3700, 20835.0900, '2019-11-05 10:01:56', 'dbo', ''),
(2019100079, 201910, 60, 79, '2019-11-04', 5916, 'ENERGY', 65283, 64514, '2019-10-01', '2019-09-01', '2019-11-11', 769, 1159653.9900, 0.0000, 16607.9400, 1176261.9300, '2019-11-05 10:01:56', 'dbo', ''),
(2019100081, 201910, 60, 81, '2019-11-04', 5918, 'ENERGY', 2566, 2513, '2019-10-01', '2019-09-01', '2019-11-11', 53, 56410.7400, 0.0000, 1144.6200, 57555.3600, '2019-11-05 10:01:56', 'dbo', ''),
(2019100082, 201910, 60, 82, '2019-11-04', 5919, 'ENERGY', 5586, 5458, '2019-10-01', '2019-09-01', '2019-11-11', 128, 116628.5400, 0.0000, 2764.3900, 119392.9300, '2019-11-05 10:01:56', 'dbo', ''),
(2019100083, 201910, 60, 83, '2019-11-04', 5920, 'ENERGY', 130, 127, '2019-10-01', '2019-09-01', '2019-11-11', 3, 8371.7700, 0.0000, 64.7800, 8436.5500, '2019-11-05 10:01:56', 'dbo', ''),
(2019100084, 201910, 60, 84, '2019-11-04', 5921, 'ENERGY', 204, 170, '2019-10-01', '2019-09-01', '2019-11-11', 34, 8985.6800, 0.0000, 734.2900, 9719.9700, '2019-11-05 10:01:56', 'dbo', ''),
(2019100085, 201910, 60, 85, '2019-11-04', 5922, 'ENERGY', 355, 355, '2019-10-01', '2019-09-01', '2019-11-11', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2019-11-05 10:01:56', 'dbo', ''),
(2019100086, 201910, 60, 86, '2019-11-04', 5923, 'ENERGY', 151, 151, '2019-10-01', '2019-09-01', '2019-11-11', 0, 8236.9200, 0.0000, 0.0000, 8236.9200, '2019-11-05 10:01:56', 'dbo', ''),
(2019110001, 201911, 61, 1, '2019-12-10', 5924, 'ENERGY', 0, 0, '2019-11-01', '2019-10-01', '2019-12-17', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2019-12-10 13:29:22', 'dbo', ''),
(2019110002, 201911, 61, 2, '2019-12-10', 5925, 'ENERGY', 0, 0, '2019-11-01', '2019-10-01', '2019-12-17', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2019-12-10 13:29:22', 'dbo', ''),
(2019110003, 201911, 61, 3, '2019-12-10', 5926, 'ENERGY', 0, 0, '2019-11-01', '2019-10-01', '2019-12-17', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2019-12-10 13:29:22', 'dbo', ''),
(2019110004, 201911, 61, 4, '2019-12-10', 5927, 'ENERGY', 0, 0, '2019-11-01', '2019-10-01', '2019-12-17', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2019-12-10 13:29:22', 'dbo', ''),
(2019110005, 201911, 61, 5, '2019-12-10', 5928, 'ENERGY', 0, 0, '2019-11-01', '2019-10-01', '2019-12-17', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2019-12-10 13:29:22', 'dbo', ''),
(2019110006, 201911, 61, 6, '2019-12-10', 5929, 'ENERGY', 0, 0, '2019-11-01', '2019-10-01', '2019-12-17', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2019-12-10 13:29:22', 'dbo', ''),
(2019110007, 201911, 61, 7, '2019-12-10', 5930, 'ENERGY', 0, 0, '2019-11-01', '2019-10-01', '2019-12-17', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2019-12-10 13:29:22', 'dbo', ''),
(2019110008, 201911, 61, 8, '2019-12-10', 5931, 'ENERGY', 0, 0, '2019-11-01', '2019-10-01', '2019-12-17', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2019-12-10 13:29:22', 'dbo', ''),
(2019110009, 201911, 61, 9, '2019-12-10', 5932, 'ENERGY', 13652, 12829, '2019-11-01', '2019-10-01', '2019-12-17', 823, 279893.9864, 0.0000, 17376.1300, 297270.1164, '2019-12-10 13:29:22', 'dbo', ''),
(2019110010, 201911, 61, 10, '2019-12-10', 5933, 'ENERGY', 1012, 952, '2019-11-01', '2019-10-01', '2019-12-17', 60, 27604.0480, 0.0000, 1266.7800, 28870.8280, '2019-12-10 13:29:22', 'dbo', ''),
(2019110011, 201911, 61, 11, '2019-12-10', 5934, 'ENERGY', 5208, 4523, '2019-11-01', '2019-10-01', '2019-12-17', 685, 104056.2910, 0.0000, 14462.5000, 118518.7910, '2019-12-10 13:29:22', 'dbo', ''),
(2019110012, 201911, 61, 12, '2019-12-10', 5935, 'ENERGY', 906, 428, '2019-11-01', '2019-10-01', '2019-12-17', 478, 14725.6200, 0.0000, 10092.0800, 24817.7000, '2019-12-10 13:29:22', 'dbo', ''),
(2019110013, 201911, 61, 13, '2019-12-10', 5936, 'ENERGY', 33633, 32469, '2019-11-01', '2019-10-01', '2019-12-17', 1164, 679223.1340, 0.0000, 24575.7000, 703798.8340, '2019-12-10 13:29:22', 'dbo', ''),
(2019110014, 201911, 61, 14, '2019-12-10', 5937, 'ENERGY', 16988, 16261, '2019-11-01', '2019-10-01', '2019-12-17', 727, 347600.6254, 0.0000, 15349.2600, 362949.8854, '2019-12-10 13:29:22', 'dbo', ''),
(2019110015, 201911, 61, 15, '2019-12-10', 5938, 'ENERGY', 162, 162, '2019-11-01', '2019-10-01', '2019-12-17', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2019-12-10 13:29:22', 'dbo', ''),
(2019110016, 201911, 61, 16, '2019-12-10', 5939, 'ENERGY', 19739, 19343, '2019-11-01', '2019-10-01', '2019-12-17', 396, 401295.8520, 0.0000, 8360.8000, 409656.6520, '2019-12-10 13:29:22', 'dbo', ''),
(2019110017, 201911, 61, 17, '2019-12-10', 5940, 'ENERGY', 71605, 69719, '2019-11-01', '2019-10-01', '2019-12-17', 1886, 1430998.3870, 0.0000, 39819.4000, 1470817.7870, '2019-12-10 13:29:22', 'dbo', ''),
(2019110018, 201911, 61, 18, '2019-12-10', 5941, 'ENERGY', 18407, 17391, '2019-11-01', '2019-10-01', '2019-12-17', 1016, 361672.0200, 0.0000, 21450.9600, 383122.9800, '2019-12-10 13:29:22', 'dbo', ''),
(2019110019, 201911, 61, 19, '2019-12-10', 5942, 'ENERGY', 9771, 8414, '2019-11-01', '2019-10-01', '2019-12-17', 1357, 182577.7450, 0.0000, 28650.5400, 211228.2850, '2019-12-10 13:29:22', 'dbo', ''),
(2019110020, 201911, 61, 20, '2019-12-10', 5943, 'ENERGY', 3801, 3165, '2019-11-01', '2019-10-01', '2019-12-17', 636, 69803.1530, 0.0000, 13427.9500, 83231.1030, '2019-12-10 13:29:22', 'dbo', ''),
(2019110021, 201911, 61, 21, '2019-12-10', 5944, 'ENERGY', 48754, 48754, '2019-11-01', '2019-10-01', '2019-12-17', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2019-12-10 13:29:22', 'dbo', ''),
(2019110022, 201911, 61, 22, '2019-12-10', 5945, 'ENERGY', 29187, 29187, '2019-11-01', '2019-10-01', '2019-12-17', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2019-12-10 13:29:22', 'dbo', ''),
(2019110023, 201911, 61, 23, '2019-12-10', 5946, 'ENERGY', 77425, 77425, '2019-11-01', '2019-10-01', '2019-12-17', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2019-12-10 13:29:22', 'dbo', ''),
(2019110024, 201911, 61, 24, '2019-12-10', 5947, 'ENERGY', 47443, 47443, '2019-11-01', '2019-10-01', '2019-12-17', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2019-12-10 13:29:22', 'dbo', ''),
(2019110025, 201911, 61, 25, '2019-12-10', 5948, 'ENERGY', 181943, 176892, '2019-11-01', '2019-10-01', '2019-12-17', 5051, 3582019.5800, 0.0000, 106642.4900, 3688662.0700, '2019-12-10 13:29:22', 'dbo', ''),
(2019110026, 201911, 61, 26, '2019-12-10', 5949, 'ENERGY', 97809, 96334, '2019-11-01', '2019-10-01', '2019-12-17', 1475, 1739577.8274, 0.0000, 31141.8900, 1770719.7174, '2019-12-10 13:29:22', 'dbo', ''),
(2019110029, 201911, 61, 29, '2019-12-10', 5950, 'ENERGY', 133800, 131669, '2019-11-01', '2019-10-01', '2019-12-17', 2131, 2277810.7688, 0.0000, 44992.1100, 2322802.8788, '2019-12-10 13:29:22', 'dbo', ''),
(2019110030, 201911, 61, 30, '2019-12-10', 5951, 'ENERGY', 65516, 64507, '2019-11-01', '2019-10-01', '2019-12-17', 1009, 1013960.2812, 0.0000, 21303.1700, 1035263.4512, '2019-12-10 13:29:22', 'dbo', ''),
(2019110031, 201911, 61, 31, '2019-12-10', 5952, 'ENERGY', 111912, 109945, '2019-11-01', '2019-10-01', '2019-12-17', 1967, 1955172.9580, 0.0000, 41529.5500, 1996702.5080, '2019-12-10 13:29:22', 'dbo', ''),
(2019110032, 201911, 61, 32, '2019-12-10', 5953, 'ENERGY', 185368, 182225, '2019-11-01', '2019-10-01', '2019-12-17', 3143, 3254225.9690, 0.0000, 66358.6000, 3320584.5690, '2019-12-10 13:29:22', 'dbo', ''),
(2019110033, 201911, 61, 33, '2019-12-10', 5954, 'ENERGY', 28916, 28252, '2019-11-01', '2019-10-01', '2019-12-17', 664, 539086.6434, 0.0000, 14019.1300, 553105.7734, '2019-12-10 13:29:22', 'dbo', ''),
(2019110034, 201911, 61, 34, '2019-12-10', 5955, 'ENERGY', 12934, 12933, '2019-11-01', '2019-10-01', '2019-12-17', 1, 239382.2342, 0.0000, 21.1100, 239403.3442, '2019-12-10 13:29:22', 'dbo', ''),
(2019110035, 201911, 61, 35, '2019-12-10', 5956, 'ENERGY', 26219, 25756, '2019-11-01', '2019-10-01', '2019-12-17', 463, 459660.4426, 0.0000, 9775.3900, 469435.8326, '2019-12-10 13:29:22', 'dbo', ''),
(2019110036, 201911, 61, 36, '2019-12-10', 5957, 'ENERGY', 55246, 54944, '2019-11-01', '2019-10-01', '2019-12-17', 302, 981432.2738, 0.0000, 6376.1700, 987808.4438, '2019-12-10 13:29:22', 'dbo', ''),
(2019110037, 201911, 61, 37, '2019-12-10', 5958, 'ENERGY', 40538, 39382, '2019-11-01', '2019-10-01', '2019-12-17', 1156, 718162.4110, 0.0000, 24406.8000, 742569.2110, '2019-12-10 13:29:22', 'dbo', ''),
(2019110038, 201911, 61, 38, '2019-12-10', 5959, 'ENERGY', 21791, 21401, '2019-11-01', '2019-10-01', '2019-12-17', 390, 403973.8834, 0.0000, 8234.1300, 412208.0134, '2019-12-10 13:29:22', 'dbo', ''),
(2019110039, 201911, 61, 39, '2019-12-10', 5960, 'ENERGY', 38356, 37800, '2019-11-01', '2019-10-01', '2019-12-17', 556, 62764.4982, 0.0000, 11738.9200, 74503.4182, '2019-12-10 13:29:22', 'dbo', ''),
(2019110040, 201911, 61, 40, '2019-12-10', 5961, 'ENERGY', 60420, 58853, '2019-11-01', '2019-10-01', '2019-12-17', 1567, 1132705.3396, 0.0000, 33084.3000, 1165789.6396, '2019-12-10 13:29:22', 'dbo', ''),
(2019110041, 201911, 61, 41, '2019-12-10', 5962, 'ENERGY', 241, 241, '2019-11-01', '2019-10-01', '2019-12-17', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2019-12-10 13:29:22', 'dbo', ''),
(2019110042, 201911, 61, 42, '2019-12-10', 5963, 'ENERGY', 334, 334, '2019-11-01', '2019-10-01', '2019-12-17', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2019-12-10 13:29:22', 'dbo', ''),
(2019110043, 201911, 61, 43, '2019-12-10', 5964, 'ENERGY', 110908, 109256, '2019-11-01', '2019-10-01', '2019-12-17', 1652, 1829664.7402, 0.0000, 34878.9200, 1864543.6602, '2019-12-10 13:29:22', 'dbo', ''),
(2019110044, 201911, 61, 44, '2019-12-10', 5965, 'ENERGY', 60032, 59401, '2019-11-01', '2019-10-01', '2019-12-17', 631, 1154262.0630, 0.0000, 13322.3900, 1167584.4530, '2019-12-10 13:29:22', 'dbo', ''),
(2019110045, 201911, 61, 45, '2019-12-10', 5966, 'ENERGY', 46929, 46419, '2019-11-01', '2019-10-01', '2019-12-17', 510, 621519.8420, 0.0000, 10767.7000, 632287.5420, '2019-12-10 13:29:22', 'dbo', ''),
(2019110046, 201911, 61, 46, '2019-12-10', 5967, 'ENERGY', 74615, 73544, '2019-11-01', '2019-10-01', '2019-12-17', 1071, 1366839.4554, 0.0000, 22612.1800, 1389451.6354, '2019-12-10 13:29:22', 'dbo', ''),
(2019110047, 201911, 61, 47, '2019-12-10', 5968, 'ENERGY', 38099, 37853, '2019-11-01', '2019-10-01', '2019-12-17', 246, 588739.9710, 0.0000, 5193.8400, 593933.8110, '2019-12-10 13:29:22', 'dbo', ''),
(2019110048, 201911, 61, 48, '2019-12-10', 5969, 'ENERGY', 36452, 35371, '2019-11-01', '2019-10-01', '2019-12-17', 1081, 723573.6100, 0.0000, 22823.3200, 746396.9300, '2019-12-10 13:29:22', 'dbo', ''),
(2019110049, 201911, 61, 49, '2019-12-10', 5970, 'ENERGY', 10707, 10493, '2019-11-01', '2019-10-01', '2019-12-17', 214, 198096.1890, 0.0000, 4518.2100, 202614.3990, '2019-12-10 13:29:22', 'dbo', ''),
(2019110050, 201911, 61, 50, '2019-12-10', 5971, 'ENERGY', 127947, 126126, '2019-11-01', '2019-10-01', '2019-12-17', 1821, 2158884.8992, 0.0000, 38447.0400, 2197331.9392, '2019-12-10 13:29:22', 'dbo', ''),
(2019110051, 201911, 61, 51, '2019-12-10', 5972, 'ENERGY', 211, 211, '2019-11-01', '2019-10-01', '2019-12-17', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2019-12-10 13:29:22', 'dbo', ''),
(2019110052, 201911, 61, 52, '2019-12-10', 5973, 'ENERGY', 321, 321, '2019-11-01', '2019-10-01', '2019-12-17', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2019-12-10 13:29:22', 'dbo', ''),
(2019110053, 201911, 61, 53, '2019-12-10', 5974, 'ENERGY', 17351, 16449, '2019-11-01', '2019-10-01', '2019-12-17', 902, 350010.0070, 0.0000, 19044.0500, 369054.0570, '2019-12-10 13:29:22', 'dbo', ''),
(2019110054, 201911, 61, 54, '2019-12-10', 5975, 'ENERGY', 43262, 42866, '2019-11-01', '2019-10-01', '2019-12-17', 396, 585835.4694, 0.0000, 8360.8000, 594196.2694, '2019-12-10 13:29:22', 'dbo', ''),
(2019110055, 201911, 61, 55, '2019-12-10', 5976, 'ENERGY', 18472, 18044, '2019-11-01', '2019-10-01', '2019-12-17', 428, 351490.6700, 0.0000, 9036.4300, 360527.1000, '2019-12-10 13:29:22', 'dbo', ''),
(2019110056, 201911, 61, 56, '2019-12-10', 5977, 'ENERGY', 12465, 11856, '2019-11-01', '2019-10-01', '2019-12-17', 609, 254189.9590, 0.0000, 12857.9100, 267047.8690, '2019-12-10 13:29:22', 'dbo', ''),
(2019110059, 201911, 61, 59, '2019-12-10', 5978, 'ENERGY', 128, 128, '2019-11-01', '2019-10-01', '2019-12-17', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2019-12-10 13:29:22', 'dbo', ''),
(2019110060, 201911, 61, 60, '2019-12-10', 5979, 'ENERGY', 389432, 382603, '2019-11-01', '2019-10-01', '2019-12-17', 6829, 6205508.3100, 0.0000, 144181.6600, 6349689.9700, '2019-12-10 13:29:21', 'dbo', ''),
(2019110061, 201911, 61, 61, '2019-12-10', 5980, 'ENERGY', 16, 16, '2019-11-01', '2019-10-01', '2019-12-17', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2019-12-10 13:29:22', 'dbo', ''),
(2019110062, 201911, 61, 62, '2019-12-10', 5981, 'ENERGY', 30, 30, '2019-11-01', '2019-10-01', '2019-12-17', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-12-10 13:29:22', 'dbo', ''),
(2019110063, 201911, 61, 63, '2019-12-10', 5982, 'ENERGY', 1, 1, '2019-11-01', '2019-10-01', '2019-12-17', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-12-10 13:29:22', 'dbo', ''),
(2019110064, 201911, 61, 64, '2019-12-10', 5983, 'ENERGY', 2, 2, '2019-11-01', '2019-10-01', '2019-12-17', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2019-12-10 13:29:22', 'dbo', ''),
(2019110065, 201911, 61, 65, '2019-12-10', 5984, 'ENERGY', 16957, 16674, '2019-11-01', '2019-10-01', '2019-12-17', 283, 339798.7180, 0.0000, 5975.0200, 345773.7380, '2019-12-10 13:29:22', 'dbo', ''),
(2019110066, 201911, 61, 66, '2019-12-10', 5985, 'ENERGY', 14688, 14311, '2019-11-01', '2019-10-01', '2019-12-17', 377, 293116.2724, 0.0000, 7959.6500, 301075.9224, '2019-12-10 13:29:22', 'dbo', ''),
(2019110067, 201911, 61, 67, '2019-12-10', 5986, 'ENERGY', 1606, 1580, '2019-11-01', '2019-10-01', '2019-12-17', 26, 40372.2638, 0.0000, 548.9300, 40921.1938, '2019-12-10 13:29:22', 'dbo', ''),
(2019110068, 201911, 61, 68, '2019-12-10', 5987, 'ENERGY', 4219, 4159, '2019-11-01', '2019-10-01', '2019-12-17', 60, 93698.9700, 0.0000, 1266.7800, 94965.7500, '2019-12-10 13:29:22', 'dbo', ''),
(2019110069, 201911, 61, 69, '2019-12-10', 5988, 'ENERGY', 1, 1, '2019-11-01', '2019-10-01', '2019-12-17', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2019-12-10 13:29:22', 'dbo', ''),
(2019110070, 201911, 61, 70, '2019-12-10', 5989, 'ENERGY', 4005, 3840, '2019-11-01', '2019-10-01', '2019-12-17', 165, 87793.9800, 0.0000, 3483.6700, 91277.6500, '2019-12-10 13:29:22', 'dbo', ''),
(2019110071, 201911, 61, 71, '2019-12-10', 5990, 'ENERGY', 286172, 286172, '2019-11-01', '2019-10-01', '2019-12-17', 0, 5539345.6462, 0.0000, 0.0000, 5539345.6462, '2019-12-10 13:29:22', 'dbo', ''),
(2019110072, 201911, 61, 72, '2019-12-10', 5991, 'ENERGY', 2464, 2464, '2019-11-01', '2019-10-01', '2019-12-17', 0, 59116.0200, 0.0000, 0.0000, 59116.0200, '2019-12-10 13:29:22', 'dbo', ''),
(2019110073, 201911, 61, 73, '2019-12-10', 5992, 'ENERGY', 541, 536, '2019-11-01', '2019-10-01', '2019-12-17', 5, 27429.0280, 0.0000, 105.5700, 27534.5980, '2019-12-10 13:29:21', 'dbo', ''),
(2019110075, 201911, 61, 75, '2019-12-10', 5993, 'ENERGY', 2185, 2153, '2019-11-01', '2019-10-01', '2019-12-17', 32, 52088.0000, 0.0000, 675.6200, 52763.6200, '2019-12-10 13:29:22', 'dbo', ''),
(2019110076, 201911, 61, 76, '2019-12-10', 5994, 'ENERGY', 2437, 2395, '2019-11-01', '2019-10-01', '2019-12-17', 42, 56620.9600, 0.0000, 886.7500, 57507.7100, '2019-12-10 13:29:21', 'dbo', ''),
(2019110077, 201911, 61, 77, '2019-12-10', 5995, 'ENERGY', 1885, 1854, '2019-11-01', '2019-10-01', '2019-12-17', 31, 46196.0600, 0.0000, 654.5100, 46850.5700, '2019-12-10 13:29:21', 'dbo', '');
INSERT INTO `bill` (`BillID`, `BillingPeriod`, `BulkInvoiceID`, `CustomerID`, `BillingDate`, `MeterReadingID`, `BillType`, `CurReading`, `PrvReading`, `CurReadingDate`, `PrvReadingDate`, `DueDate`, `ConsumptionBilled`, `BalanceBF`, `TotalPayments`, `TotalBill`, `BalanceCF`, `LastUpdateDate`, `LastUpdateUser`, `BillQuality`) VALUES
(2019110078, 201911, 61, 78, '2019-12-10', 5996, 'ENERGY', 602, 593, '2019-11-01', '2019-10-01', '2019-12-17', 9, 20835.0900, 0.0000, 190.0200, 21025.1100, '2019-12-10 13:29:22', 'dbo', ''),
(2019110079, 201911, 61, 79, '2019-12-10', 5997, 'ENERGY', 66091, 65283, '2019-11-01', '2019-10-01', '2019-12-17', 808, 1176261.9300, 0.0000, 17059.4200, 1193321.3500, '2019-12-10 13:29:22', 'dbo', ''),
(2019110081, 201911, 61, 81, '2019-12-10', 5999, 'ENERGY', 2621, 2566, '2019-11-01', '2019-10-01', '2019-12-17', 55, 57555.3600, 0.0000, 1161.2200, 58716.5800, '2019-12-10 13:29:22', 'dbo', ''),
(2019110082, 201911, 61, 82, '2019-12-10', 6000, 'ENERGY', 5722, 5586, '2019-11-01', '2019-10-01', '2019-12-17', 136, 119392.9300, 0.0000, 2871.3900, 122264.3200, '2019-12-10 13:29:22', 'dbo', ''),
(2019110083, 201911, 61, 83, '2019-12-10', 6001, 'ENERGY', 133, 130, '2019-11-01', '2019-10-01', '2019-12-17', 3, 8436.5500, 0.0000, 63.3500, 8499.9000, '2019-12-10 13:29:22', 'dbo', ''),
(2019110084, 201911, 61, 84, '2019-12-10', 6002, 'ENERGY', 240, 204, '2019-11-01', '2019-10-01', '2019-12-17', 36, 9719.9700, 0.0000, 760.0700, 10480.0400, '2019-12-10 13:29:22', 'dbo', ''),
(2019110085, 201911, 61, 85, '2019-12-10', 6003, 'ENERGY', 355, 355, '2019-11-01', '2019-10-01', '2019-12-17', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2019-12-10 13:29:22', 'dbo', ''),
(2019110086, 201911, 61, 86, '2019-12-10', 6004, 'ENERGY', 151, 151, '2019-11-01', '2019-10-01', '2019-12-17', 0, 8236.9200, 0.0000, 0.0000, 8236.9200, '2019-12-10 13:29:22', 'dbo', ''),
(2019120001, 201912, 62, 1, '2020-01-22', 6005, 'ENERGY', 0, 0, '2019-12-01', '2019-11-01', '2020-01-29', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2020-01-31 16:47:56', 'dbo', ''),
(2019120002, 201912, 62, 2, '2020-01-22', 6006, 'ENERGY', 0, 0, '2019-12-01', '2019-11-01', '2020-01-29', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2020-01-31 16:47:56', 'dbo', ''),
(2019120003, 201912, 62, 3, '2020-01-22', 6007, 'ENERGY', 0, 0, '2019-12-01', '2019-11-01', '2020-01-29', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2020-01-31 16:47:56', 'dbo', ''),
(2019120004, 201912, 62, 4, '2020-01-22', 6008, 'ENERGY', 0, 0, '2019-12-01', '2019-11-01', '2020-01-29', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2020-01-31 16:47:56', 'dbo', ''),
(2019120005, 201912, 62, 5, '2020-01-22', 6009, 'ENERGY', 0, 0, '2019-12-01', '2019-11-01', '2020-01-29', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2020-01-31 16:47:56', 'dbo', ''),
(2019120006, 201912, 62, 6, '2020-01-22', 6010, 'ENERGY', 0, 0, '2019-12-01', '2019-11-01', '2020-01-29', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2020-01-31 16:47:56', 'dbo', ''),
(2019120007, 201912, 62, 7, '2020-01-22', 6011, 'ENERGY', 0, 0, '2019-12-01', '2019-11-01', '2020-01-29', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2020-01-31 16:47:56', 'dbo', ''),
(2019120008, 201912, 62, 8, '2020-01-22', 6012, 'ENERGY', 0, 0, '2019-12-01', '2019-11-01', '2020-01-29', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2020-01-31 16:47:56', 'dbo', ''),
(2019120009, 201912, 62, 9, '2020-01-22', 6013, 'ENERGY', 14644, 13652, '2019-12-01', '2019-11-01', '2020-01-29', 992, 297270.1164, 0.0000, 20756.6200, 318026.7364, '2020-01-31 16:47:56', 'dbo', ''),
(2019120010, 201912, 62, 10, '2020-01-22', 6014, 'ENERGY', 1102, 1012, '2019-12-01', '2019-11-01', '2020-01-29', 90, 28870.8280, 0.0000, 1883.1500, 30753.9780, '2020-01-31 16:47:56', 'dbo', ''),
(2019120011, 201912, 62, 11, '2020-01-22', 6015, 'ENERGY', 5941, 5208, '2019-12-01', '2019-11-01', '2020-01-29', 733, 118518.7910, 0.0000, 15337.2900, 133856.0810, '2020-01-31 16:47:56', 'dbo', ''),
(2019120012, 201912, 62, 12, '2020-01-22', 6016, 'ENERGY', 1313, 906, '2019-12-01', '2019-11-01', '2020-01-29', 407, 24817.7000, 0.0000, 8516.0800, 33333.7800, '2020-01-31 16:47:56', 'dbo', ''),
(2019120013, 201912, 62, 13, '2020-01-22', 6017, 'ENERGY', 35254, 33633, '2019-12-01', '2019-11-01', '2020-01-29', 1621, 703798.8340, 0.0000, 33917.8200, 737716.6540, '2020-01-31 16:47:56', 'dbo', ''),
(2019120014, 201912, 62, 14, '2020-01-22', 6018, 'ENERGY', 17695, 16988, '2019-12-01', '2019-11-01', '2020-01-29', 707, 362949.8854, 0.0000, 14793.2800, 377743.1654, '2020-01-31 16:47:56', 'dbo', ''),
(2019120015, 201912, 62, 15, '2020-01-22', 6019, 'ENERGY', 162, 162, '2019-12-01', '2019-11-01', '2020-01-29', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2020-01-31 16:47:56', 'dbo', ''),
(2019120016, 201912, 62, 16, '2020-01-22', 6020, 'ENERGY', 20164, 19739, '2019-12-01', '2019-11-01', '2020-01-29', 425, 409656.6520, 0.0000, 8892.7100, 418549.3620, '2020-01-31 16:47:56', 'dbo', ''),
(2019120017, 201912, 62, 17, '2020-01-22', 6021, 'ENERGY', 73955, 71605, '2019-12-01', '2019-11-01', '2020-01-29', 2350, 1470817.7870, 0.0000, 49171.4000, 1519989.1870, '2020-01-31 16:47:56', 'dbo', ''),
(2019120018, 201912, 62, 18, '2020-01-22', 6022, 'ENERGY', 19318, 18407, '2019-12-01', '2019-11-01', '2020-01-29', 911, 383122.9800, 0.0000, 19061.7700, 402184.7500, '2020-01-31 16:47:56', 'dbo', ''),
(2019120019, 201912, 62, 19, '2020-01-22', 6023, 'ENERGY', 11495, 9771, '2019-12-01', '2019-11-01', '2020-01-29', 1724, 211228.2850, 0.0000, 36072.9900, 247301.2750, '2020-01-31 16:47:56', 'dbo', ''),
(2019120020, 201912, 62, 20, '2020-01-22', 6024, 'ENERGY', 4355, 3801, '2019-12-01', '2019-11-01', '2020-01-29', 554, 83231.1030, 0.0000, 11591.9000, 94823.0030, '2020-01-31 16:47:56', 'dbo', ''),
(2019120021, 201912, 62, 21, '2020-01-22', 6025, 'ENERGY', 48754, 48754, '2019-12-01', '2019-11-01', '2020-01-29', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2020-01-31 16:47:56', 'dbo', ''),
(2019120022, 201912, 62, 22, '2020-01-22', 6026, 'ENERGY', 29187, 29187, '2019-12-01', '2019-11-01', '2020-01-29', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2020-01-31 16:47:56', 'dbo', ''),
(2019120023, 201912, 62, 23, '2020-01-22', 6027, 'ENERGY', 77425, 77425, '2019-12-01', '2019-11-01', '2020-01-29', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2020-01-31 16:47:56', 'dbo', ''),
(2019120024, 201912, 62, 24, '2020-01-22', 6028, 'ENERGY', 47443, 47443, '2019-12-01', '2019-11-01', '2020-01-29', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2020-01-31 16:47:56', 'dbo', ''),
(2019120025, 201912, 62, 25, '2020-01-22', 6029, 'ENERGY', 188126, 181943, '2019-12-01', '2019-11-01', '2020-01-29', 6183, 3688662.0700, 0.0000, 129373.1600, 3818035.2300, '2020-01-31 16:47:56', 'dbo', ''),
(2019120026, 201912, 62, 26, '2020-01-22', 6030, 'ENERGY', 99692, 97809, '2019-12-01', '2019-11-01', '2020-01-29', 1883, 1770719.7174, 0.0000, 39399.9200, 1810119.6374, '2020-01-31 16:47:56', 'dbo', ''),
(2019120029, 201912, 62, 29, '2020-01-22', 6031, 'ENERGY', 136513, 133800, '2019-12-01', '2019-11-01', '2020-01-29', 2713, 2322802.8788, 0.0000, 56766.8400, 2379569.7188, '2020-01-31 16:47:56', 'dbo', ''),
(2019120030, 201912, 62, 30, '2020-01-22', 6032, 'ENERGY', 66648, 65516, '2019-12-01', '2019-11-01', '2020-01-29', 1132, 1035263.4512, 0.0000, 23685.9700, 1058949.4212, '2020-01-31 16:47:56', 'dbo', ''),
(2019120031, 201912, 62, 31, '2020-01-22', 6033, 'ENERGY', 114184, 111912, '2019-12-01', '2019-11-01', '2020-01-29', 2272, 1996702.5080, 0.0000, 47539.3400, 2044241.8480, '2020-01-31 16:47:56', 'dbo', ''),
(2019120032, 201912, 62, 32, '2020-01-22', 6034, 'ENERGY', 189002, 185368, '2019-12-01', '2019-11-01', '2020-01-29', 3634, 3320584.5690, 0.0000, 76037.8600, 3396622.4290, '2020-01-31 16:47:56', 'dbo', ''),
(2019120033, 201912, 62, 33, '2020-01-22', 6035, 'ENERGY', 29568, 28916, '2019-12-01', '2019-11-01', '2020-01-29', 652, 553105.7734, 0.0000, 13642.4500, 566748.2234, '2020-01-31 16:47:56', 'dbo', ''),
(2019120034, 201912, 62, 34, '2020-01-22', 6036, 'ENERGY', 12934, 12934, '2019-12-01', '2019-11-01', '2020-01-29', 0, 239403.3442, 0.0000, 0.0000, 239403.3442, '2020-01-31 16:47:56', 'dbo', ''),
(2019120035, 201912, 62, 35, '2020-01-22', 6037, 'ENERGY', 26654, 26219, '2019-12-01', '2019-11-01', '2020-01-29', 435, 469435.8326, 0.0000, 9101.9500, 478537.7826, '2020-01-31 16:47:56', 'dbo', ''),
(2019120036, 201912, 62, 36, '2020-01-22', 6038, 'ENERGY', 55590, 55246, '2019-12-01', '2019-11-01', '2020-01-29', 344, 987808.4438, 0.0000, 7197.8600, 995006.3038, '2020-01-31 16:47:56', 'dbo', ''),
(2019120037, 201912, 62, 37, '2020-01-22', 6039, 'ENERGY', 41904, 40538, '2019-12-01', '2019-11-01', '2020-01-29', 1366, 742569.2110, 0.0000, 28582.1900, 771151.4010, '2020-01-31 16:47:56', 'dbo', ''),
(2019120038, 201912, 62, 38, '2020-01-22', 6040, 'ENERGY', 22260, 21791, '2019-12-01', '2019-11-01', '2020-01-29', 469, 412208.0134, 0.0000, 9813.3600, 422021.3734, '2020-01-31 16:47:56', 'dbo', ''),
(2019120039, 201912, 62, 39, '2020-01-22', 6041, 'ENERGY', 38889, 38356, '2019-12-01', '2019-11-01', '2020-01-29', 533, 74503.4182, 0.0000, 11152.4900, 85655.9082, '2020-01-31 16:47:56', 'dbo', ''),
(2019120040, 201912, 62, 40, '2020-01-22', 6042, 'ENERGY', 62068, 60420, '2019-12-01', '2019-11-01', '2020-01-29', 1648, 1165789.6396, 0.0000, 34482.7700, 1200272.4096, '2020-01-31 16:47:56', 'dbo', ''),
(2019120041, 201912, 62, 41, '2020-01-22', 6043, 'ENERGY', 241, 241, '2019-12-01', '2019-11-01', '2020-01-29', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2020-01-31 16:47:56', 'dbo', ''),
(2019120042, 201912, 62, 42, '2020-01-22', 6044, 'ENERGY', 334, 334, '2019-12-01', '2019-11-01', '2020-01-29', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2020-01-31 16:47:56', 'dbo', ''),
(2019120043, 201912, 62, 43, '2020-01-22', 6045, 'ENERGY', 112639, 110908, '2019-12-01', '2019-11-01', '2020-01-29', 1731, 1864543.6602, 0.0000, 36219.4600, 1900763.1202, '2020-01-31 16:47:56', 'dbo', ''),
(2019120044, 201912, 62, 44, '2020-01-22', 6046, 'ENERGY', 60659, 60032, '2019-12-01', '2019-11-01', '2020-01-29', 627, 1167584.4530, 0.0000, 13119.3500, 1180703.8030, '2020-01-31 16:47:56', 'dbo', ''),
(2019120045, 201912, 62, 45, '2020-01-22', 6047, 'ENERGY', 47391, 46929, '2019-12-01', '2019-11-01', '2020-01-29', 462, 632287.5420, 0.0000, 9666.9000, 641954.4420, '2020-01-31 16:47:56', 'dbo', ''),
(2019120046, 201912, 62, 46, '2020-01-22', 6048, 'ENERGY', 75629, 74615, '2019-12-01', '2019-11-01', '2020-01-29', 1014, 1389451.6354, 0.0000, 21216.9400, 1410668.5754, '2020-01-31 16:47:56', 'dbo', ''),
(2019120047, 201912, 62, 47, '2020-01-22', 6049, 'ENERGY', 38338, 38099, '2019-12-01', '2019-11-01', '2020-01-29', 239, 593933.8110, 0.0000, 5000.8400, 598934.6510, '2020-01-31 16:47:56', 'dbo', ''),
(2019120048, 201912, 62, 48, '2020-01-22', 6050, 'ENERGY', 37665, 36452, '2019-12-01', '2019-11-01', '2020-01-29', 1213, 746396.9300, 0.0000, 25380.8200, 771777.7500, '2020-01-31 16:47:56', 'dbo', ''),
(2019120049, 201912, 62, 49, '2020-01-22', 6051, 'ENERGY', 10940, 10707, '2019-12-01', '2019-11-01', '2020-01-29', 233, 202614.3990, 0.0000, 4875.2900, 207489.6890, '2020-01-31 16:47:56', 'dbo', ''),
(2019120050, 201912, 62, 50, '2020-01-22', 6052, 'ENERGY', 130022, 127947, '2019-12-01', '2019-11-01', '2020-01-29', 2075, 2197331.9392, 0.0000, 43417.3100, 2240749.2492, '2020-01-31 16:47:56', 'dbo', ''),
(2019120051, 201912, 62, 51, '2020-01-22', 6053, 'ENERGY', 211, 211, '2019-12-01', '2019-11-01', '2020-01-29', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2020-01-31 16:47:56', 'dbo', ''),
(2019120052, 201912, 62, 52, '2020-01-22', 6054, 'ENERGY', 321, 321, '2019-12-01', '2019-11-01', '2020-01-29', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2020-01-31 16:47:56', 'dbo', ''),
(2019120053, 201912, 62, 53, '2020-01-22', 6055, 'ENERGY', 18258, 17351, '2019-12-01', '2019-11-01', '2020-01-29', 907, 369054.0570, 0.0000, 18978.0800, 388032.1370, '2020-01-31 16:47:56', 'dbo', ''),
(2019120054, 201912, 62, 54, '2020-01-22', 6056, 'ENERGY', 43529, 43262, '2019-12-01', '2019-11-01', '2020-01-29', 267, 594196.2694, 0.0000, 5586.7100, 599782.9794, '2020-01-31 16:47:56', 'dbo', ''),
(2019120055, 201912, 62, 55, '2020-01-22', 6057, 'ENERGY', 18796, 18472, '2019-12-01', '2019-11-01', '2020-01-29', 324, 360527.1000, 0.0000, 6779.3800, 367306.4800, '2020-01-31 16:47:56', 'dbo', ''),
(2019120056, 201912, 62, 56, '2020-01-22', 6058, 'ENERGY', 13107, 12465, '2019-12-01', '2019-11-01', '2020-01-29', 642, 267047.8690, 0.0000, 13433.2100, 280481.0790, '2020-01-31 16:47:56', 'dbo', ''),
(2019120059, 201912, 62, 59, '2020-01-22', 6059, 'ENERGY', 128, 128, '2019-12-01', '2019-11-01', '2020-01-29', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2020-01-31 16:47:56', 'dbo', ''),
(2019120060, 201912, 62, 60, '2020-01-22', 6060, 'ENERGY', 398037, 389432, '2019-12-01', '2019-11-01', '2020-01-29', 8605, 6349689.9700, 0.0000, 180051.0900, 6529741.0600, '2020-01-31 16:47:55', 'dbo', ''),
(2019120061, 201912, 62, 61, '2020-01-22', 6061, 'ENERGY', 16, 16, '2019-12-01', '2019-11-01', '2020-01-29', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2020-01-31 16:47:56', 'dbo', ''),
(2019120062, 201912, 62, 62, '2020-01-22', 6062, 'ENERGY', 30, 30, '2019-12-01', '2019-11-01', '2020-01-29', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2020-01-31 16:47:56', 'dbo', ''),
(2019120063, 201912, 62, 63, '2020-01-22', 6063, 'ENERGY', 1, 1, '2019-12-01', '2019-11-01', '2020-01-29', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2020-01-31 16:47:56', 'dbo', ''),
(2019120064, 201912, 62, 64, '2020-01-22', 6064, 'ENERGY', 2, 2, '2019-12-01', '2019-11-01', '2020-01-29', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2020-01-31 16:47:56', 'dbo', ''),
(2019120065, 201912, 62, 65, '2020-01-22', 6065, 'ENERGY', 17302, 16957, '2019-12-01', '2019-11-01', '2020-01-29', 345, 345773.7380, 0.0000, 7218.7800, 352992.5180, '2020-01-31 16:47:55', 'dbo', ''),
(2019120066, 201912, 62, 66, '2020-01-22', 6066, 'ENERGY', 15107, 14688, '2019-12-01', '2019-11-01', '2020-01-29', 419, 301075.9224, 0.0000, 8767.1600, 309843.0824, '2020-01-31 16:47:56', 'dbo', ''),
(2019120067, 201912, 62, 67, '2020-01-22', 6067, 'ENERGY', 1640, 1606, '2019-12-01', '2019-11-01', '2020-01-29', 34, 40921.1938, 0.0000, 711.4200, 41632.6138, '2020-01-31 16:47:56', 'dbo', ''),
(2019120068, 201912, 62, 68, '2020-01-22', 6068, 'ENERGY', 4278, 4219, '2019-12-01', '2019-11-01', '2020-01-29', 59, 94965.7500, 0.0000, 1234.5300, 96200.2800, '2020-01-31 16:47:56', 'dbo', ''),
(2019120069, 201912, 62, 69, '2020-01-22', 6069, 'ENERGY', 1, 1, '2019-12-01', '2019-11-01', '2020-01-29', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2020-01-31 16:47:56', 'dbo', ''),
(2019120070, 201912, 62, 70, '2020-01-22', 6070, 'ENERGY', 4207, 4005, '2019-12-01', '2019-11-01', '2020-01-29', 202, 91277.6500, 0.0000, 4226.6500, 95504.3000, '2020-01-31 16:47:56', 'dbo', ''),
(2019120071, 201912, 62, 71, '2020-01-22', 6071, 'ENERGY', 286172, 286172, '2019-12-01', '2019-11-01', '2020-01-29', 0, 5539345.6462, 0.0000, 0.0000, 5539345.6462, '2020-01-31 16:47:56', 'dbo', ''),
(2019120072, 201912, 62, 72, '2020-01-22', 6072, 'ENERGY', 2464, 2464, '2019-12-01', '2019-11-01', '2020-01-29', 0, 59116.0200, 0.0000, 0.0000, 59116.0200, '2020-01-31 16:47:56', 'dbo', ''),
(2019120073, 201912, 62, 73, '2020-01-22', 6073, 'ENERGY', 548, 541, '2019-12-01', '2019-11-01', '2020-01-29', 7, 27534.5980, 0.0000, 146.4800, 27681.0780, '2020-01-31 16:47:55', 'dbo', ''),
(2019120075, 201912, 62, 75, '2020-01-22', 6074, 'ENERGY', 2225, 2185, '2019-12-01', '2019-11-01', '2020-01-29', 40, 52763.6200, 0.0000, 836.9700, 53600.5900, '2020-01-31 16:47:55', 'dbo', ''),
(2019120076, 201912, 62, 76, '2020-01-22', 6075, 'ENERGY', 2492, 2437, '2019-12-01', '2019-11-01', '2020-01-29', 55, 57507.7100, 0.0000, 1150.8200, 58658.5300, '2020-01-31 16:47:55', 'dbo', ''),
(2019120077, 201912, 62, 77, '2020-01-22', 6076, 'ENERGY', 1925, 1885, '2019-12-01', '2019-11-01', '2020-01-29', 40, 46850.5700, 0.0000, 836.9700, 47687.5400, '2020-01-31 16:47:55', 'dbo', ''),
(2019120078, 201912, 62, 78, '2020-01-22', 6077, 'ENERGY', 613, 602, '2019-12-01', '2019-11-01', '2020-01-29', 11, 21025.1100, 0.0000, 230.1600, 21255.2700, '2020-01-31 16:47:55', 'dbo', ''),
(2019120079, 201912, 62, 79, '2020-01-22', 6078, 'ENERGY', 67051, 66091, '2019-12-01', '2019-11-01', '2020-01-29', 960, 1193321.3500, 0.0000, 20087.0500, 1213408.4000, '2020-01-31 16:47:56', 'dbo', ''),
(2019120081, 201912, 62, 81, '2020-01-22', 6080, 'ENERGY', 2693, 2621, '2019-12-01', '2019-11-01', '2020-01-29', 72, 58716.5800, 0.0000, 1506.5200, 60223.1000, '2020-01-31 16:47:56', 'dbo', ''),
(2019120082, 201912, 62, 82, '2020-01-22', 6081, 'ENERGY', 5900, 5722, '2019-12-01', '2019-11-01', '2020-01-29', 178, 122264.3200, 0.0000, 3724.4700, 125988.7900, '2020-01-31 16:47:56', 'dbo', ''),
(2019120083, 201912, 62, 83, '2020-01-22', 6082, 'ENERGY', 137, 133, '2019-12-01', '2019-11-01', '2020-01-29', 4, 8499.9000, 0.0000, 83.7000, 8583.6000, '2020-01-31 16:47:55', 'dbo', ''),
(2019120084, 201912, 62, 84, '2020-01-22', 6083, 'ENERGY', 286, 240, '2019-12-01', '2019-11-01', '2020-01-29', 46, 10480.0400, 0.0000, 962.5000, 11442.5400, '2020-01-31 16:47:56', 'dbo', ''),
(2019120085, 201912, 62, 85, '2020-01-22', 6084, 'ENERGY', 355, 355, '2019-12-01', '2019-11-01', '2020-01-29', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2020-01-31 16:47:56', 'dbo', ''),
(2019120086, 201912, 62, 86, '2020-01-22', 6085, 'ENERGY', 151, 151, '2019-12-01', '2019-11-01', '2020-01-29', 0, 8236.9200, 0.0000, 0.0000, 8236.9200, '2020-01-31 16:47:56', 'dbo', ''),
(2020010001, 202001, 63, 1, '2020-02-12', 6086, 'ENERGY', 0, 0, '2020-01-01', '2019-12-01', '2020-02-19', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2020-02-12 11:20:03', 'dbo', ''),
(2020010002, 202001, 63, 2, '2020-02-12', 6087, 'ENERGY', 0, 0, '2020-01-01', '2019-12-01', '2020-02-19', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2020-02-12 11:20:03', 'dbo', ''),
(2020010003, 202001, 63, 3, '2020-02-12', 6088, 'ENERGY', 0, 0, '2020-01-01', '2019-12-01', '2020-02-19', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2020-02-12 11:20:03', 'dbo', ''),
(2020010004, 202001, 63, 4, '2020-02-12', 6089, 'ENERGY', 0, 0, '2020-01-01', '2019-12-01', '2020-02-19', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2020-02-12 11:20:03', 'dbo', ''),
(2020010005, 202001, 63, 5, '2020-02-12', 6090, 'ENERGY', 0, 0, '2020-01-01', '2019-12-01', '2020-02-19', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2020-02-12 11:20:03', 'dbo', ''),
(2020010006, 202001, 63, 6, '2020-02-12', 6091, 'ENERGY', 0, 0, '2020-01-01', '2019-12-01', '2020-02-19', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2020-02-12 11:20:03', 'dbo', ''),
(2020010007, 202001, 63, 7, '2020-02-12', 6092, 'ENERGY', 0, 0, '2020-01-01', '2019-12-01', '2020-02-19', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2020-02-12 11:20:03', 'dbo', ''),
(2020010008, 202001, 63, 8, '2020-02-12', 6093, 'ENERGY', 0, 0, '2020-01-01', '2019-12-01', '2020-02-19', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2020-02-12 11:20:03', 'dbo', ''),
(2020010009, 202001, 63, 9, '2020-02-12', 6094, 'ENERGY', 15158, 14644, '2020-01-01', '2019-12-01', '2020-02-19', 514, 318026.7364, 0.0000, 10524.2800, 328551.0164, '2020-02-12 11:20:03', 'dbo', ''),
(2020010010, 202001, 63, 10, '2020-02-12', 6095, 'ENERGY', 1147, 1102, '2020-01-01', '2019-12-01', '2020-02-19', 45, 30753.9780, 0.0000, 921.3900, 31675.3680, '2020-02-12 11:20:03', 'dbo', ''),
(2020010011, 202001, 63, 11, '2020-02-12', 6096, 'ENERGY', 6445, 5941, '2020-01-01', '2019-12-01', '2020-02-19', 504, 133856.0810, 0.0000, 10319.5300, 144175.6110, '2020-02-12 11:20:03', 'dbo', ''),
(2020010012, 202001, 63, 12, '2020-02-12', 6097, 'ENERGY', 1683, 1313, '2020-01-01', '2019-12-01', '2020-02-19', 370, 33333.7800, 0.0000, 7575.8400, 40909.6200, '2020-02-12 11:20:03', 'dbo', ''),
(2020010013, 202001, 63, 13, '2020-02-12', 6098, 'ENERGY', 36165, 35254, '2020-01-01', '2019-12-01', '2020-02-19', 911, 737716.6540, 0.0000, 18652.9700, 756369.6240, '2020-02-12 11:20:03', 'dbo', ''),
(2020010014, 202001, 63, 14, '2020-02-12', 6099, 'ENERGY', 18089, 17695, '2020-01-01', '2019-12-01', '2020-02-19', 394, 377743.1654, 0.0000, 8067.2500, 385810.4154, '2020-02-12 11:20:03', 'dbo', ''),
(2020010015, 202001, 63, 15, '2020-02-12', 6100, 'ENERGY', 162, 162, '2020-01-01', '2019-12-01', '2020-02-19', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2020-02-12 11:20:03', 'dbo', ''),
(2020010016, 202001, 63, 16, '2020-02-12', 6101, 'ENERGY', 20366, 20164, '2020-01-01', '2019-12-01', '2020-02-19', 202, 418549.3620, 0.0000, 4136.0100, 422685.3720, '2020-02-12 11:20:03', 'dbo', ''),
(2020010017, 202001, 63, 17, '2020-02-12', 6102, 'ENERGY', 75179, 73955, '2020-01-01', '2019-12-01', '2020-02-19', 1224, 1519989.1870, 0.0000, 25061.7400, 1545050.9270, '2020-02-12 11:20:03', 'dbo', ''),
(2020010018, 202001, 63, 18, '2020-02-12', 6103, 'ENERGY', 20039, 19318, '2020-01-01', '2019-12-01', '2020-02-19', 721, 402184.7500, 0.0000, 14762.6600, 416947.4100, '2020-02-12 11:20:03', 'dbo', ''),
(2020010019, 202001, 63, 19, '2020-02-12', 6104, 'ENERGY', 12203, 11495, '2020-01-01', '2019-12-01', '2020-02-19', 708, 247301.2750, 0.0000, 14496.4900, 261797.7650, '2020-02-12 11:20:03', 'dbo', ''),
(2020010020, 202001, 63, 20, '2020-02-12', 6105, 'ENERGY', 4720, 4355, '2020-01-01', '2019-12-01', '2020-02-19', 365, 94823.0030, 0.0000, 7473.4700, 102296.4730, '2020-02-12 11:20:03', 'dbo', ''),
(2020010021, 202001, 63, 21, '2020-02-12', 6106, 'ENERGY', 48754, 48754, '2020-01-01', '2019-12-01', '2020-02-19', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2020-02-12 11:20:03', 'dbo', ''),
(2020010022, 202001, 63, 22, '2020-02-12', 6107, 'ENERGY', 29187, 29187, '2020-01-01', '2019-12-01', '2020-02-19', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2020-02-12 11:20:03', 'dbo', ''),
(2020010023, 202001, 63, 23, '2020-02-12', 6108, 'ENERGY', 77425, 77425, '2020-01-01', '2019-12-01', '2020-02-19', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2020-02-12 11:20:03', 'dbo', ''),
(2020010024, 202001, 63, 24, '2020-02-12', 6109, 'ENERGY', 47443, 47443, '2020-01-01', '2019-12-01', '2020-02-19', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2020-02-12 11:20:03', 'dbo', ''),
(2020010025, 202001, 63, 25, '2020-02-12', 6110, 'ENERGY', 190898, 188126, '2020-01-01', '2019-12-01', '2020-02-19', 2772, 3818035.2300, 0.0000, 56757.4300, 3874792.6600, '2020-02-12 11:20:03', 'dbo', ''),
(2020010026, 202001, 63, 26, '2020-02-12', 6111, 'ENERGY', 100925, 99692, '2020-01-01', '2019-12-01', '2020-02-19', 1233, 1810119.6374, 0.0000, 25246.0000, 1835365.6374, '2020-02-12 11:20:03', 'dbo', ''),
(2020010029, 202001, 63, 29, '2020-02-12', 6112, 'ENERGY', 137969, 136513, '2020-01-01', '2019-12-01', '2020-02-19', 1456, 2379569.7188, 0.0000, 29811.9900, 2409381.7088, '2020-02-12 11:20:03', 'dbo', ''),
(2020010030, 202001, 63, 30, '2020-02-12', 6113, 'ENERGY', 67398, 66648, '2020-01-01', '2019-12-01', '2020-02-19', 750, 1058949.4212, 0.0000, 15356.4500, 1074305.8712, '2020-02-12 11:20:03', 'dbo', ''),
(2020010031, 202001, 63, 31, '2020-02-12', 6114, 'ENERGY', 115485, 114184, '2020-01-01', '2019-12-01', '2020-02-19', 1301, 2044241.8480, 0.0000, 26638.3200, 2070880.1680, '2020-02-12 11:20:03', 'dbo', ''),
(2020010032, 202001, 63, 32, '2020-02-12', 6115, 'ENERGY', 191047, 189002, '2020-01-01', '2019-12-01', '2020-02-19', 2045, 3396622.4290, 0.0000, 41871.9200, 3438494.3490, '2020-02-12 11:20:03', 'dbo', ''),
(2020010033, 202001, 63, 33, '2020-02-12', 6116, 'ENERGY', 29958, 29568, '2020-01-01', '2019-12-01', '2020-02-19', 390, 566748.2234, 0.0000, 7985.3600, 574733.5834, '2020-02-12 11:20:03', 'dbo', ''),
(2020010034, 202001, 63, 34, '2020-02-12', 6117, 'ENERGY', 12934, 12934, '2020-01-01', '2019-12-01', '2020-02-19', 0, 239403.3442, 0.0000, 0.0000, 239403.3442, '2020-02-12 11:20:03', 'dbo', ''),
(2020010035, 202001, 63, 35, '2020-02-12', 6118, 'ENERGY', 26984, 26654, '2020-01-01', '2019-12-01', '2020-02-19', 330, 478537.7826, 0.0000, 6756.8400, 485294.6226, '2020-02-12 11:20:03', 'dbo', ''),
(2020010036, 202001, 63, 36, '2020-02-12', 6119, 'ENERGY', 55778, 55590, '2020-01-01', '2019-12-01', '2020-02-19', 188, 995006.3038, 0.0000, 3849.3500, 998855.6538, '2020-02-12 11:20:03', 'dbo', ''),
(2020010037, 202001, 63, 37, '2020-02-12', 6120, 'ENERGY', 42743, 41904, '2020-01-01', '2019-12-01', '2020-02-19', 839, 771151.4010, 0.0000, 17178.7500, 788330.1510, '2020-02-12 11:20:03', 'dbo', ''),
(2020010038, 202001, 63, 38, '2020-02-12', 6121, 'ENERGY', 22533, 22260, '2020-01-01', '2019-12-01', '2020-02-19', 273, 422021.3734, 0.0000, 5589.7500, 427611.1234, '2020-02-12 11:20:03', 'dbo', ''),
(2020010039, 202001, 63, 39, '2020-02-12', 6122, 'ENERGY', 39203, 38889, '2020-01-01', '2019-12-01', '2020-02-19', 314, 85655.9082, 0.0000, 6429.2300, 92085.1382, '2020-02-12 11:20:03', 'dbo', ''),
(2020010040, 202001, 63, 40, '2020-02-12', 6123, 'ENERGY', 63074, 62068, '2020-01-01', '2019-12-01', '2020-02-19', 1006, 1200272.4096, 0.0000, 20598.1200, 1220870.5296, '2020-02-12 11:20:03', 'dbo', ''),
(2020010041, 202001, 63, 41, '2020-02-12', 6124, 'ENERGY', 241, 241, '2020-01-01', '2019-12-01', '2020-02-19', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2020-02-12 11:20:03', 'dbo', ''),
(2020010042, 202001, 63, 42, '2020-02-12', 6125, 'ENERGY', 334, 334, '2020-01-01', '2019-12-01', '2020-02-19', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2020-02-12 11:20:03', 'dbo', ''),
(2020010043, 202001, 63, 43, '2020-02-12', 6126, 'ENERGY', 114030, 112639, '2020-01-01', '2019-12-01', '2020-02-19', 1391, 1900763.1202, 0.0000, 28481.0900, 1929244.2102, '2020-02-12 11:20:03', 'dbo', ''),
(2020010044, 202001, 63, 44, '2020-02-12', 6127, 'ENERGY', 61090, 60659, '2020-01-01', '2019-12-01', '2020-02-19', 431, 1180703.8030, 0.0000, 8824.8300, 1189528.6330, '2020-02-12 11:20:03', 'dbo', ''),
(2020010045, 202001, 63, 45, '2020-02-12', 6128, 'ENERGY', 47710, 47391, '2020-01-01', '2019-12-01', '2020-02-19', 319, 641954.4420, 0.0000, 6531.6100, 648486.0520, '2020-02-12 11:20:03', 'dbo', ''),
(2020010046, 202001, 63, 46, '2020-02-12', 6129, 'ENERGY', 76300, 75629, '2020-01-01', '2019-12-01', '2020-02-19', 671, 1410668.5754, 0.0000, 13738.9000, 1424407.4754, '2020-02-12 11:20:03', 'dbo', ''),
(2020010047, 202001, 63, 47, '2020-02-12', 6130, 'ENERGY', 38503, 38338, '2020-01-01', '2019-12-01', '2020-02-19', 165, 598934.6510, 0.0000, 3378.4200, 602313.0710, '2020-02-12 11:20:03', 'dbo', ''),
(2020010048, 202001, 63, 48, '2020-02-12', 6131, 'ENERGY', 38440, 37665, '2020-01-01', '2019-12-01', '2020-02-19', 775, 771777.7500, 0.0000, 15868.3400, 787646.0900, '2020-02-12 11:20:03', 'dbo', ''),
(2020010049, 202001, 63, 49, '2020-02-12', 6132, 'ENERGY', 11089, 10940, '2020-01-01', '2019-12-01', '2020-02-19', 149, 207489.6890, 0.0000, 3050.8100, 210540.4990, '2020-02-12 11:20:03', 'dbo', ''),
(2020010050, 202001, 63, 50, '2020-02-12', 6133, 'ENERGY', 131196, 130022, '2020-01-01', '2019-12-01', '2020-02-19', 1174, 2240749.2492, 0.0000, 24037.9700, 2264787.2192, '2020-02-12 11:20:03', 'dbo', ''),
(2020010051, 202001, 63, 51, '2020-02-12', 6134, 'ENERGY', 211, 211, '2020-01-01', '2019-12-01', '2020-02-19', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2020-02-12 11:20:03', 'dbo', ''),
(2020010052, 202001, 63, 52, '2020-02-12', 6135, 'ENERGY', 321, 321, '2020-01-01', '2019-12-01', '2020-02-19', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2020-02-12 11:20:03', 'dbo', ''),
(2020010053, 202001, 63, 53, '2020-02-12', 6136, 'ENERGY', 18857, 18258, '2020-01-01', '2019-12-01', '2020-02-19', 599, 388032.1370, 0.0000, 12264.6800, 400296.8170, '2020-02-12 11:20:03', 'dbo', ''),
(2020010054, 202001, 63, 54, '2020-02-12', 6137, 'ENERGY', 43747, 43529, '2020-01-01', '2019-12-01', '2020-02-19', 218, 599782.9794, 0.0000, 4463.6200, 604246.5994, '2020-02-12 11:20:03', 'dbo', ''),
(2020010055, 202001, 63, 55, '2020-02-12', 6138, 'ENERGY', 19039, 18796, '2020-01-01', '2019-12-01', '2020-02-19', 243, 367306.4800, 0.0000, 4975.4900, 372281.9700, '2020-02-12 11:20:03', 'dbo', ''),
(2020010056, 202001, 63, 56, '2020-02-12', 6139, 'ENERGY', 13599, 13107, '2020-01-01', '2019-12-01', '2020-02-19', 492, 280481.0790, 0.0000, 10073.8200, 290554.8990, '2020-02-12 11:20:03', 'dbo', ''),
(2020010059, 202001, 63, 59, '2020-02-12', 6140, 'ENERGY', 128, 128, '2020-01-01', '2019-12-01', '2020-02-19', 0, 5478.1400, 0.0000, 0.0000, 5478.1400, '2020-02-12 11:20:03', 'dbo', ''),
(2020010060, 202001, 63, 60, '2020-02-12', 6141, 'ENERGY', 402499, 398037, '2020-01-01', '2019-12-01', '2020-02-19', 4462, 6529741.0600, 0.0000, 91360.6400, 6621101.7000, '2020-02-12 11:20:03', 'dbo', ''),
(2020010061, 202001, 63, 61, '2020-02-12', 6142, 'ENERGY', 16, 16, '2020-01-01', '2019-12-01', '2020-02-19', 0, 3715.5700, 0.0000, 0.0000, 3715.5700, '2020-02-12 11:20:03', 'dbo', ''),
(2020010062, 202001, 63, 62, '2020-02-12', 6143, 'ENERGY', 30, 30, '2020-01-01', '2019-12-01', '2020-02-19', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2020-02-12 11:20:03', 'dbo', ''),
(2020010063, 202001, 63, 63, '2020-02-12', 6144, 'ENERGY', 1, 1, '2020-01-01', '2019-12-01', '2020-02-19', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2020-02-12 11:20:03', 'dbo', ''),
(2020010064, 202001, 63, 64, '2020-02-12', 6145, 'ENERGY', 2, 2, '2020-01-01', '2019-12-01', '2020-02-19', 0, 3190.0000, 0.0000, 0.0000, 3190.0000, '2020-02-12 11:20:03', 'dbo', ''),
(2020010065, 202001, 63, 65, '2020-02-12', 6146, 'ENERGY', 17480, 17302, '2020-01-01', '2019-12-01', '2020-02-19', 178, 352992.5180, 0.0000, 3644.6100, 356637.1280, '2020-02-12 11:20:03', 'dbo', ''),
(2020010066, 202001, 63, 66, '2020-02-12', 6147, 'ENERGY', 15355, 15107, '2020-01-01', '2019-12-01', '2020-02-19', 248, 309843.0824, 0.0000, 5077.8600, 314920.9424, '2020-02-12 11:20:03', 'dbo', ''),
(2020010067, 202001, 63, 67, '2020-02-12', 6148, 'ENERGY', 1656, 1640, '2020-01-01', '2019-12-01', '2020-02-19', 16, 41632.6138, 0.0000, 327.6000, 41960.2138, '2020-02-12 11:20:03', 'dbo', ''),
(2020010068, 202001, 63, 68, '2020-02-12', 6149, 'ENERGY', 4295, 4278, '2020-01-01', '2019-12-01', '2020-02-19', 17, 96200.2800, 0.0000, 348.0700, 96548.3500, '2020-02-12 11:20:03', 'dbo', ''),
(2020010069, 202001, 63, 69, '2020-02-12', 6150, 'ENERGY', 1, 1, '2020-01-01', '2019-12-01', '2020-02-19', 0, 4930.0000, 0.0000, 0.0000, 4930.0000, '2020-02-12 11:20:03', 'dbo', ''),
(2020010070, 202001, 63, 70, '2020-02-12', 6151, 'ENERGY', 4327, 4207, '2020-01-01', '2019-12-01', '2020-02-19', 120, 95504.3000, 0.0000, 2457.0300, 97961.3300, '2020-02-12 11:20:03', 'dbo', ''),
(2020010071, 202001, 63, 71, '2020-02-12', 6152, 'ENERGY', 286172, 286172, '2020-01-01', '2019-12-01', '2020-02-19', 0, 5539345.6462, 0.0000, 0.0000, 5539345.6462, '2020-02-12 11:20:03', 'dbo', ''),
(2020010072, 202001, 63, 72, '2020-02-12', 6153, 'ENERGY', 2464, 2464, '2020-01-01', '2019-12-01', '2020-02-19', 0, 59116.0200, 0.0000, 0.0000, 59116.0200, '2020-02-12 11:20:03', 'dbo', ''),
(2020010073, 202001, 63, 73, '2020-02-12', 6154, 'ENERGY', 548, 548, '2020-01-01', '2019-12-01', '2020-02-19', 0, 27681.0780, 0.0000, 0.0000, 27681.0780, '2020-02-12 11:20:03', 'dbo', ''),
(2020010075, 202001, 63, 75, '2020-02-12', 6155, 'ENERGY', 2246, 2225, '2020-01-01', '2019-12-01', '2020-02-19', 21, 53600.5900, 0.0000, 429.9800, 54030.5700, '2020-02-12 11:20:03', 'dbo', ''),
(2020010076, 202001, 63, 76, '2020-02-12', 6156, 'ENERGY', 2520, 2492, '2020-01-01', '2019-12-01', '2020-02-19', 28, 58658.5300, 0.0000, 573.3100, 59231.8400, '2020-02-12 11:20:03', 'dbo', ''),
(2020010077, 202001, 63, 77, '2020-02-12', 6157, 'ENERGY', 1945, 1925, '2020-01-01', '2019-12-01', '2020-02-19', 20, 47687.5400, 0.0000, 409.5000, 48097.0400, '2020-02-12 11:20:03', 'dbo', ''),
(2020010078, 202001, 63, 78, '2020-02-12', 6158, 'ENERGY', 619, 613, '2020-01-01', '2019-12-01', '2020-02-19', 6, 21255.2700, 0.0000, 122.8400, 21378.1100, '2020-02-12 11:20:03', 'dbo', ''),
(2020010079, 202001, 63, 79, '2020-02-12', 6159, 'ENERGY', 67539, 67051, '2020-01-01', '2019-12-01', '2020-02-19', 488, 1213408.4000, 0.0000, 9991.9300, 1223400.3300, '2020-02-12 11:20:03', 'dbo', ''),
(2020010081, 202001, 63, 81, '2020-02-12', 6161, 'ENERGY', 2729, 2693, '2020-01-01', '2019-12-01', '2020-02-19', 36, 60223.1000, 0.0000, 737.1100, 60960.2100, '2020-02-12 11:20:03', 'dbo', ''),
(2020010082, 202001, 63, 82, '2020-02-12', 6162, 'ENERGY', 5990, 5900, '2020-01-01', '2019-12-01', '2020-02-19', 90, 125988.7900, 0.0000, 1842.7700, 127831.5600, '2020-02-12 11:20:03', 'dbo', ''),
(2020010083, 202001, 63, 83, '2020-02-12', 6163, 'ENERGY', 139, 137, '2020-01-01', '2019-12-01', '2020-02-19', 2, 8583.6000, 0.0000, 40.9500, 8624.5500, '2020-02-12 11:20:03', 'dbo', ''),
(2020010084, 202001, 63, 84, '2020-02-12', 6164, 'ENERGY', 309, 286, '2020-01-01', '2019-12-01', '2020-02-19', 23, 11442.5400, 0.0000, 470.9400, 11913.4800, '2020-02-12 11:20:03', 'dbo', ''),
(2020010085, 202001, 63, 85, '2020-02-12', 6165, 'ENERGY', 355, 355, '2020-01-01', '2019-12-01', '2020-02-19', 0, 7632.3100, 0.0000, 0.0000, 7632.3100, '2020-02-12 11:20:03', 'dbo', ''),
(2020010086, 202001, 63, 86, '2020-02-12', 6166, 'ENERGY', 151, 151, '2020-01-01', '2019-12-01', '2020-02-19', 0, 8236.9200, 0.0000, 0.0000, 8236.9200, '2020-02-12 11:20:03', 'dbo', ''),
(2020020001, 202002, 64, 1, '2020-03-05', 6167, 'ENERGY', 0, 0, '2020-02-01', '2020-01-01', '2020-03-12', 0, 254026.4914, 0.0000, 0.0000, 254026.4914, '2020-03-05 19:14:11', 'dbo', ''),
(2020020002, 202002, 64, 2, '2020-03-05', 6168, 'ENERGY', 0, 0, '2020-02-01', '2020-01-01', '2020-03-12', 0, 127419.8910, 0.0000, 0.0000, 127419.8910, '2020-03-05 19:14:11', 'dbo', ''),
(2020020003, 202002, 64, 3, '2020-03-05', 6169, 'ENERGY', 0, 0, '2020-02-01', '2020-01-01', '2020-03-12', 0, 163011.4134, 0.0000, 0.0000, 163011.4134, '2020-03-05 19:14:11', 'dbo', ''),
(2020020004, 202002, 64, 4, '2020-03-05', 6170, 'ENERGY', 0, 0, '2020-02-01', '2020-01-01', '2020-03-12', 0, 121470.3622, 0.0000, 0.0000, 121470.3622, '2020-03-05 19:14:11', 'dbo', ''),
(2020020005, 202002, 64, 5, '2020-03-05', 6171, 'ENERGY', 0, 0, '2020-02-01', '2020-01-01', '2020-03-12', 0, 95757.9986, 0.0000, 0.0000, 95757.9986, '2020-03-05 19:14:11', 'dbo', ''),
(2020020006, 202002, 64, 6, '2020-03-05', 6172, 'ENERGY', 0, 0, '2020-02-01', '2020-01-01', '2020-03-12', 0, 250941.6668, 0.0000, 0.0000, 250941.6668, '2020-03-05 19:14:11', 'dbo', ''),
(2020020007, 202002, 64, 7, '2020-03-05', 6173, 'ENERGY', 0, 0, '2020-02-01', '2020-01-01', '2020-03-12', 0, 175616.9200, 0.0000, 0.0000, 175616.9200, '2020-03-05 19:14:11', 'dbo', ''),
(2020020008, 202002, 64, 8, '2020-03-05', 6174, 'ENERGY', 0, 0, '2020-02-01', '2020-01-01', '2020-03-12', 0, 3792.4376, 0.0000, 0.0000, 3792.4376, '2020-03-05 19:14:11', 'dbo', ''),
(2020020009, 202002, 64, 9, '2020-03-05', 6175, 'ENERGY', 15743, 15158, '2020-02-01', '2020-01-01', '2020-03-12', 585, 328551.0164, 0.0000, 11972.2400, 340523.2564, '2020-03-05 19:14:10', 'dbo', ''),
(2020020010, 202002, 64, 10, '2020-03-05', 6176, 'ENERGY', 1173, 1147, '2020-02-01', '2020-01-01', '2020-03-12', 26, 31675.3680, 0.0000, 532.1000, 32207.4680, '2020-03-05 19:14:10', 'dbo', ''),
(2020020011, 202002, 64, 11, '2020-03-05', 6177, 'ENERGY', 7015, 6445, '2020-02-01', '2020-01-01', '2020-03-12', 570, 144175.6110, 0.0000, 11665.2700, 155840.8810, '2020-03-05 19:14:10', 'dbo', ''),
(2020020012, 202002, 64, 12, '2020-03-05', 6178, 'ENERGY', 2170, 1683, '2020-02-01', '2020-01-01', '2020-03-12', 487, 40909.6200, 0.0000, 9966.6500, 50876.2700, '2020-03-05 19:14:10', 'dbo', ''),
(2020020013, 202002, 64, 13, '2020-03-05', 6179, 'ENERGY', 37216, 36165, '2020-02-01', '2020-01-01', '2020-03-12', 1051, 756369.6240, 0.0000, 21509.1200, 777878.7440, '2020-03-05 19:14:10', 'dbo', ''),
(2020020014, 202002, 64, 14, '2020-03-05', 6180, 'ENERGY', 18472, 18089, '2020-02-01', '2020-01-01', '2020-03-12', 383, 385810.4154, 0.0000, 7838.2400, 393648.6554, '2020-03-05 19:14:10', 'dbo', ''),
(2020020015, 202002, 64, 15, '2020-03-05', 6181, 'ENERGY', 162, 162, '2020-02-01', '2020-01-01', '2020-03-12', 0, 7709.0690, 0.0000, 0.0000, 7709.0690, '2020-03-05 19:14:11', 'dbo', ''),
(2020020016, 202002, 64, 16, '2020-03-05', 6182, 'ENERGY', 20660, 20366, '2020-02-01', '2020-01-01', '2020-03-12', 294, 422685.3720, 0.0000, 6016.8100, 428702.1820, '2020-03-05 19:14:10', 'dbo', ''),
(2020020017, 202002, 64, 17, '2020-03-05', 6183, 'ENERGY', 77017, 75179, '2020-02-01', '2020-01-01', '2020-03-12', 1838, 1545050.9270, 0.0000, 37615.3600, 1582666.2870, '2020-03-05 19:14:10', 'dbo', ''),
(2020020018, 202002, 64, 18, '2020-03-05', 6184, 'ENERGY', 20887, 20039, '2020-02-01', '2020-01-01', '2020-03-12', 848, 416947.4100, 0.0000, 17354.6400, 434302.0500, '2020-03-05 19:14:10', 'dbo', ''),
(2020020019, 202002, 64, 19, '2020-03-05', 6185, 'ENERGY', 13304, 12203, '2020-02-01', '2020-01-01', '2020-03-12', 1101, 261797.7650, 0.0000, 22532.3800, 284330.1450, '2020-03-05 19:14:10', 'dbo', ''),
(2020020020, 202002, 64, 20, '2020-03-05', 6186, 'ENERGY', 5154, 4720, '2020-02-01', '2020-01-01', '2020-03-12', 434, 102296.4730, 0.0000, 8881.9800, 111178.4530, '2020-03-05 19:14:10', 'dbo', ''),
(2020020021, 202002, 64, 21, '2020-03-05', 6187, 'ENERGY', 48754, 48754, '2020-02-01', '2020-01-01', '2020-03-12', 0, 692162.7346, 0.0000, 0.0000, 692162.7346, '2020-03-05 19:14:11', 'dbo', ''),
(2020020022, 202002, 64, 22, '2020-03-05', 6188, 'ENERGY', 29187, 29187, '2020-02-01', '2020-01-01', '2020-03-12', 0, 418184.5216, 0.0000, 0.0000, 418184.5216, '2020-03-05 19:14:11', 'dbo', ''),
(2020020023, 202002, 64, 23, '2020-03-05', 6189, 'ENERGY', 77425, 77425, '2020-02-01', '2020-01-01', '2020-03-12', 0, 1143390.0970, 0.0000, 0.0000, 1143390.0970, '2020-03-05 19:14:11', 'dbo', ''),
(2020020024, 202002, 64, 24, '2020-03-05', 6190, 'ENERGY', 47443, 47443, '2020-02-01', '2020-01-01', '2020-03-12', 0, 624140.9600, 0.0000, 0.0000, 624140.9600, '2020-03-05 19:14:11', 'dbo', ''),
(2020020025, 202002, 64, 25, '2020-03-05', 6191, 'ENERGY', 191791, 190898, '2020-02-01', '2020-01-01', '2020-03-12', 893, 3874792.6600, 0.0000, 18275.5800, 3893068.2400, '2020-03-05 19:14:10', 'dbo', ''),
(2020020026, 202002, 64, 26, '2020-03-05', 6192, 'ENERGY', 105094, 100925, '2020-02-01', '2020-01-01', '2020-03-12', 4169, 1835365.6374, 0.0000, 85320.1700, 1920685.8074, '2020-03-05 19:14:10', 'dbo', ''),
(2020020029, 202002, 64, 29, '2020-03-05', 6193, 'ENERGY', 139629, 137969, '2020-02-01', '2020-01-01', '2020-03-12', 1660, 2409381.7088, 0.0000, 33972.5400, 2443354.2488, '2020-03-05 19:14:11', 'dbo', ''),
(2020020030, 202002, 64, 30, '2020-03-05', 6194, 'ENERGY', 68310, 67398, '2020-02-01', '2020-01-01', '2020-03-12', 912, 1074305.8712, 0.0000, 18664.4200, 1092970.2912, '2020-03-05 19:14:11', 'dbo', ''),
(2020020031, 202002, 64, 31, '2020-03-05', 6195, 'ENERGY', 117241, 115485, '2020-02-01', '2020-01-01', '2020-03-12', 1756, 2070880.1680, 0.0000, 35937.2100, 2106817.3780, '2020-03-05 19:14:11', 'dbo', ''),
(2020020032, 202002, 64, 32, '2020-03-05', 6196, 'ENERGY', 193625, 191047, '2020-02-01', '2020-01-01', '2020-03-12', 2578, 3438494.3490, 0.0000, 52759.7500, 3491254.0990, '2020-03-05 19:14:11', 'dbo', ''),
(2020020033, 202002, 64, 33, '2020-03-05', 6197, 'ENERGY', 30477, 29958, '2020-02-01', '2020-01-01', '2020-03-12', 519, 574733.5834, 0.0000, 10621.5300, 585355.1134, '2020-03-05 19:14:10', 'dbo', ''),
(2020020034, 202002, 64, 34, '2020-03-05', 6198, 'ENERGY', 12934, 12934, '2020-02-01', '2020-01-01', '2020-03-12', 0, 239403.3442, 0.0000, 0.0000, 239403.3442, '2020-03-05 19:14:11', 'dbo', ''),
(2020020035, 202002, 64, 35, '2020-03-05', 6199, 'ENERGY', 27266, 26984, '2020-02-01', '2020-01-01', '2020-03-12', 282, 485294.6226, 0.0000, 5771.2400, 491065.8626, '2020-03-05 19:14:10', 'dbo', ''),
(2020020036, 202002, 64, 36, '2020-03-05', 6200, 'ENERGY', 56013, 55778, '2020-02-01', '2020-01-01', '2020-03-12', 235, 998855.6538, 0.0000, 4809.3700, 1003665.0238, '2020-03-05 19:14:10', 'dbo', ''),
(2020020037, 202002, 64, 37, '2020-03-05', 6201, 'ENERGY', 43817, 42743, '2020-02-01', '2020-01-01', '2020-03-12', 1074, 788330.1510, 0.0000, 21979.8200, 810309.9710, '2020-03-05 19:14:10', 'dbo', ''),
(2020020038, 202002, 64, 38, '2020-03-05', 6202, 'ENERGY', 22871, 22533, '2020-02-01', '2020-01-01', '2020-03-12', 338, 427611.1234, 0.0000, 6917.3000, 434528.4234, '2020-03-05 19:14:10', 'dbo', ''),
(2020020039, 202002, 64, 39, '2020-03-05', 6203, 'ENERGY', 39584, 39203, '2020-02-01', '2020-01-01', '2020-03-12', 381, 92085.1382, 0.0000, 7797.3200, 99882.4582, '2020-03-05 19:14:10', 'dbo', ''),
(2020020040, 202002, 64, 40, '2020-03-05', 6204, 'ENERGY', 64381, 63074, '2020-02-01', '2020-01-01', '2020-03-12', 1307, 1220870.5296, 0.0000, 26748.2600, 1247618.7896, '2020-03-05 19:14:10', 'dbo', ''),
(2020020041, 202002, 64, 41, '2020-03-05', 6205, 'ENERGY', 241, 241, '2020-02-01', '2020-01-01', '2020-03-12', 0, 10128.8400, 0.0000, 0.0000, 10128.8400, '2020-03-05 19:14:11', 'dbo', ''),
(2020020042, 202002, 64, 42, '2020-03-05', 6206, 'ENERGY', 334, 334, '2020-02-01', '2020-01-01', '2020-03-12', 0, 11910.7960, 0.0000, 0.0000, 11910.7960, '2020-03-05 19:14:11', 'dbo', ''),
(2020020043, 202002, 64, 43, '2020-03-05', 6207, 'ENERGY', 115989, 114030, '2020-02-01', '2020-01-01', '2020-03-12', 1959, 1929244.2102, 0.0000, 40091.6600, 1969335.8702, '2020-03-05 19:14:10', 'dbo', ''),
(2020020044, 202002, 64, 44, '2020-03-05', 6208, 'ENERGY', 61520, 61090, '2020-02-01', '2020-01-01', '2020-03-12', 430, 1189528.6330, 0.0000, 8800.1100, 1198328.7430, '2020-03-05 19:14:10', 'dbo', ''),
(2020020045, 202002, 64, 45, '2020-03-05', 6209, 'ENERGY', 48139, 47710, '2020-02-01', '2020-01-01', '2020-03-12', 429, 648486.0520, 0.0000, 8779.6500, 657265.7020, '2020-03-05 19:14:10', 'dbo', ''),
(2020020046, 202002, 64, 46, '2020-03-05', 6210, 'ENERGY', 77162, 76300, '2020-02-01', '2020-01-01', '2020-03-12', 862, 1424407.4754, 0.0000, 17641.1600, 1442048.6354, '2020-03-05 19:14:10', 'dbo', ''),
(2020020047, 202002, 64, 47, '2020-03-05', 6211, 'ENERGY', 38503, 38503, '2020-02-01', '2020-01-01', '2020-03-12', 0, 602313.0710, 0.0000, 0.0000, 602313.0710, '2020-03-05 19:14:11', 'dbo', ''),
(2020020048, 202002, 64, 48, '2020-03-05', 6212, 'ENERGY', 305, 38440, '2020-02-01', '2020-01-01', '2020-03-12', 812, 787646.0900, 0.0000, 16617.8800, 804263.9700, '2020-03-05 19:14:10', 'dbo', ''),
(2020020049, 202002, 64, 49, '2020-03-05', 6213, 'ENERGY', 11247, 11089, '2020-02-01', '2020-01-01', '2020-03-12', 158, 210540.4990, 0.0000, 3233.5200, 213774.0190, '2020-03-05 19:14:10', 'dbo', ''),
(2020020050, 202002, 64, 50, '2020-03-05', 6214, 'ENERGY', 132708, 131196, '2020-02-01', '2020-01-01', '2020-03-12', 1512, 2264787.2192, 0.0000, 30943.6400, 2295730.8592, '2020-03-05 19:14:10', 'dbo', ''),
(2020020051, 202002, 64, 51, '2020-03-05', 6215, 'ENERGY', 211, 211, '2020-02-01', '2020-01-01', '2020-03-12', 0, 3189.9990, 0.0000, 0.0000, 3189.9990, '2020-03-05 19:14:11', 'dbo', ''),
(2020020052, 202002, 64, 52, '2020-03-05', 6216, 'ENERGY', 321, 321, '2020-02-01', '2020-01-01', '2020-03-12', 0, 8510.8720, 0.0000, 0.0000, 8510.8720, '2020-03-05 19:14:11', 'dbo', ''),
(2020020053, 202002, 64, 53, '2020-03-05', 6217, 'ENERGY', 19578, 18857, '2020-02-01', '2020-01-01', '2020-03-12', 721, 400296.8170, 0.0000, 14755.5400, 415052.3570, '2020-03-05 19:14:10', 'dbo', ''),
(2020020054, 202002, 64, 54, '2020-03-05', 6218, 'ENERGY', 44023, 43747, '2020-02-01', '2020-01-01', '2020-03-12', 276, 604246.5994, 0.0000, 5648.4400, 609895.0394, '2020-03-05 19:14:10', 'dbo', ''),
(2020020055, 202002, 64, 55, '2020-03-05', 6219, 'ENERGY', 19355, 19039, '2020-02-01', '2020-01-01', '2020-03-12', 316, 372281.9700, 0.0000, 6467.0700, 378749.0400, '2020-03-05 19:14:10', 'dbo', ''),
(2020020056, 202002, 64, 56, '2020-03-05', 6220, 'ENERGY', 14138, 13599, '2020-02-01', '2020-01-01', '2020-03-12', 53