<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BankDetailsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Insert default bank details
        DB::table('BankDetails')->insert([
            [
                'CompanyID' => 1, // Assuming 1 is the default company ID
                'PropID' => 1,    // Assuming 1 is the default property ID
                'BankName' => 'Cooperative Bank',
                'AccountNumber' => '01136031946700',
                'BankBranch' => 'KCOOKENA',
                'BankFullName' => 'Cooperative Bank of Kenya',
                'IsActive' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]
        ]);
    }
}
