<?php

namespace Database\Seeders;

use App\Models\Block;
use Illuminate\Database\Seeder;

class BlocksTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        // Only create blocks if the property exists
        if (!\App\Models\Property::exists()) {
            $this->command->info('No properties found. Skipping blocks seeding.');
            return;
        }

        $blocks = [
            [
                'BlockName' => 'Block A',
                'BlockCode' => 'BLA',
                'Description' => 'Main Residential Block',
                'Floors' => 5,
                'UnitsPerFloor' => 8,
                'HasLift' => true,
                'BlockStatus' => 'Active'
            ],
            [
                'BlockName' => 'Block B',
                'BlockCode' => 'BLB',
                'Description' => 'Executive Flats',
                'Floors' => 10,
                'UnitsPerFloor' => 6,
                'HasLift' => true,
                'BlockStatus' => 'Active'
            ],
            [
                'BlockName' => 'Annex',
                'BlockCode' => 'ANX',
                'Description' => 'Annex Building',
                'Floors' => 3,
                'UnitsPerFloor' => 4,
                'HasLift' => false,
                'BlockStatus' => 'Active'
            ],
        ];

        // Get the first property
        $property = \App\Models\Property::first();

        foreach ($blocks as $block) {
            Block::create(array_merge($block, [
                'PropID' => $property->PropID
            ]));
        }
    }
}
