<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $this->call([
            BankDetailsTableSeeder::class,
            TenancyStatusSeeder::class,
        ]);

        // Create default admin user if not exists
        $user = User::firstOrCreate(
            ['email' => 'test@example.com'],
            [
                'name' => 'Test User',
                'password' => bcrypt('password'),
            ]
        );

        // Seed roles and permissions
        $this->call([
            RoleAndPermissionSeeder::class,
            SmsTemplatesTableSeeder::class,
        ]);

        // Seed properties and blocks if in local environment
        if (app()->environment('local')) {
            $this->call([
                // Make sure Property seeder runs first
                \Database\Seeders\BlocksTableSeeder::class,
            ]);
        }
    }
}
