<?php

namespace Database\Seeders;

use App\Models\SmsTemplate;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class SmsTemplatesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $templates = [
            [
                'name' => 'Bill Notification',
                'slug' => 'bill-notification',
                'subject' => 'Your Monthly Bill',
                'body' => "Dear {customer_name},\n\nYour bill for {billing_month} is now available. The total amount due is KES {amount}. Please make your payment by {due_date}.\n\nThank you for your business.",
                'variables' => json_encode([
                    'customer_name' => 'Customer\'s full name',
                    'billing_month' => 'Billing month (e.g., January 2025)',
                    'amount' => 'Total amount due',
                    'due_date' => 'Payment due date',
                ]),
                'is_active' => true,
            ],
            [
                'name' => 'Bill Reminder',
                'slug' => 'bill-reminder',
                'subject' => 'Reminder: Payment Due',
                'body' => "Hello {tenant_name},\n\nThis is a friendly reminder that your payment of KES {total_amount} for {billing_period} is due on {due_date}.\n\nPlease ensure payment is made to avoid service interruption.\n\nThank you.",
                'variables' => json_encode([
                    'tenant_name' => 'Tenant\'s full name',
                    'billing_period' => 'Billing period',
                    'total_amount' => 'Total bill amount',
                    'due_date' => 'Payment due date',
                ]),
                'is_active' => true,
            ],
        ];

        foreach ($templates as $template) {
            SmsTemplate::updateOrCreate(
                ['slug' => $template['slug']],
                $template
            );
        }
    }
}
