<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TenancyStatusSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $statuses = [
            ['name' => 'pending', 'description' => 'Tenancy is pending activation', 'is_active' => true],
            ['name' => 'active', 'description' => 'Tenancy is currently active', 'is_active' => true],
            ['name' => 'terminated', 'description' => 'Tenancy has been terminated', 'is_active' => false],
            ['name' => 'completed', 'description' => 'Tenancy has been completed', 'is_active' => false],
        ];

        foreach ($statuses as $status) {
            DB::table('tenancy_statuses')->updateOrInsert(
                ['name' => $status['name']],
                $status
            );
        }
    }
}
