import './bootstrap';
import Alpine from 'alpinejs';
import Swal from 'sweetalert2';

// Make Swal available globally
window.Swal = Swal;

// Add a helper method to show toast messages
window.showAlert = function(type, message, title = '') {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 5000,
        timerProgressBar: true,
        didOpen: (toast) => {
            toast.addEventListener('mouseenter', Swal.stopTimer);
            toast.addEventListener('mouseleave', Swal.resumeTimer);
        }
    });

    Toast.fire({
        icon: type,
        title: title,
        text: message
    });
};

// Initialize Alpine.js
window.Alpine = Alpine;
Alpine.start();
