<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Login - SULIS</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --sulis-primary: #0056b3;      /* Sulis Blue */
            --sulis-secondary: #003366;    /* Darker Blue */
            --sulis-accent: #ffc107;       /* Gold/Yellow accent */
            --sulis-light: #f8f9fa;        /* Light background */
            --sulis-text: #2d3748;         /* Dark text */
            --sulis-border: #dee2e6;       /* Border color */
            --sulis-success: #28a745;      /* Success green */
            --sulis-danger: #dc3545;       /* Error red */
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #f0f4f8 0%, #e2e6ea 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--text);
            line-height: 1.6;
        }
        
        .login-container {
            display: flex;
            width: 100%;
            max-width: 1000px;
            min-height: 600px;
            background: white;
            border-radius: 1rem;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            margin: 1rem;
        }
        
        .login-illustration {
            flex: 1;
            background: linear-gradient(135deg, var(--sulis-primary) 0%, var(--sulis-secondary) 100%);
            color: white;
            padding: 3rem 2rem;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            position: relative;
            overflow: hidden;
            padding: 3rem 2rem;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        
        .login-illustration::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
            transform: rotate(30deg);
        }
        
        .login-illustration h1 {
            font-size: 2.5rem;
            font-weight: 800;
            margin-bottom: 1rem;
            color: var(--sulis-accent);
            position: relative;
            z-index: 1;
        }
        
        .login-illustration h1::after {
            content: '';
            display: block;
            width: 60px;
            height: 4px;
            background: var(--sulis-accent);
            margin: 0.75rem auto;
            border-radius: 2px;
        }
        
        .login-illustration p {
            color: rgba(255, 255, 255, 0.9);
            max-width: 80%;
            margin: 0 auto 2rem;
            position: relative;
            z-index: 1;
        }
        
        .illustration {
            width: 80%;
            max-width: 300px;
            margin: 2rem 0;
            position: relative;
            z-index: 1;
        }
        
        .login-form-container {
            flex: 1;
            padding: 3rem 2.5rem;
            display: flex;
            flex-direction: column;
            justify-content: center;
            background: white;
        }
        
        .login-form {
            width: 100%;
            max-width: 400px;
            margin: 0 auto;
        }
        
        .logo {
            text-align: center;
            margin-bottom: 3rem;
        }
        
        .logo h2 {
            color: var(--primary);
            font-weight: 700;
            font-size: 1.75rem;
            margin-bottom: 0.5rem;
        }
        
        .logo p {
            color: #64748b;
            font-size: 0.9rem;
            letter-spacing: 0.5px;
        }
        
        .input-group {
            margin-bottom: 1.5rem;
            position: relative;
        }
        
        .input-group label {
            display: block;
            color: var(--text);
            font-weight: 500;
            margin-bottom: 0.5rem;
            font-size: 0.875rem;
        }
        
        .input-field {
            width: 100%;
            padding: 0.85rem 1rem 0.85rem 2.5rem;
            border: 1px solid var(--border);
            border-radius: 8px;
            font-size: 0.95rem;
            transition: all 0.2s ease;
            background-color: var(--sulis-light);
            color: var(--text);
        }
        
        .input-field:focus {
            outline: none;
            border-color: var(--accent);
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
            background-color: white;
        }
        
        .input-icon {
            position: absolute;
            left: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: #94a3b8;
        }
        
        .btn-login {
            width: 100%;
            background-color: var(--sulis-primary);
            color: white;
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 0.5rem;
            font-weight: 600;
            font-size: 1rem;
            cursor: pointer;
            transition: all 0.2s ease;
            margin-top: 1rem;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        
        .btn-login:hover {
            background-color: var(--sulis-secondary);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        
        .remember-forgot {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin: 1.5rem 0;
            font-size: 0.875rem;
        }
        
        .remember-me {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: #64748b;
        }
        
        .forgot-password {
            color: var(--accent);
            text-decoration: none;
            font-weight: 500;
            transition: color 0.2s ease;
        }
        
        .forgot-password:hover {
            color: #2563eb;
            text-decoration: underline;
        }
        
        .divider {
            display: flex;
            align-items: center;
            margin: 1.5rem 0;
            color: #94a3b8;
            font-size: 0.875rem;
        }
        
        .divider::before,
        .divider::after {
            content: '';
            flex: 1;
            height: 1px;
            background: var(--border);
            margin: 0 1rem;
        }
        
        .social-login {
            display: flex;
            gap: 1rem;
            margin-bottom: 1.5rem;
        }
        
        .social-btn {
            flex: 1;
            padding: 0.75rem;
            border: 1px solid var(--border);
            border-radius: 6px;
            background: white;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.2s ease;
        }
        
        .social-btn:hover {
            background: var(--light-gray);
            border-color: #cbd5e1;
        }
        
        .social-btn i {
            font-size: 1.25rem;
        }
        
        .signup-link {
            text-align: center;
            margin-top: 1.5rem;
            font-size: 0.9rem;
            color: #64748b;
        }
        
        .signup-link a {
            color: var(--accent);
            font-weight: 500;
            text-decoration: none;
            margin-left: 0.25rem;
        }
        
        .signup-link a:hover {
            text-decoration: underline;
        }
        
        @media (max-width: 768px) {
            .login-container {
                flex-direction: column;
                max-width: 90%;
                margin: 2rem auto;
                min-height: auto;
            }
            
            .login-illustration {
                padding: 2.5rem 1.5rem;
                border-radius: 0.75rem 0.75rem 0 0;
            }
            
            .login-form-container {
                padding: 2.5rem 1.5rem;
                border-radius: 0 0 0.75rem 0.75rem;
            }
            
            .illustration {
                max-width: 180px;
                margin: 1.5rem 0;
            }
            
            .login-form {
                padding: 0;
            }
        }
        
        @media (max-width: 480px) {
            .login-container {
                margin: 1rem;
                max-width: 100%;
                border-radius: 0.5rem;
            }
            
            .login-form-container {
                padding: 2rem 1.25rem;
            }
            
            .login-illustration {
                padding: 2rem 1rem;
            }
            
            .social-login {
                flex-direction: column;
                gap: 0.75rem;
            }
            
            .logo h2 {
                font-size: 1.5rem;
            }
            
            .input-field {
                padding: 0.75rem 1rem 0.75rem 2.5rem;
            }
        }
            text-decoration: none;
            font-weight: 500;
            transition: color 0.2s ease;
        }
        .forgot-password:hover {
            color: #2563eb;
            text-decoration: underline;
        }
        .error-message {
            color: #ef4444;
            font-size: 0.8125rem;
            margin-top: 0.25rem;
        }
        .footer-text {
            text-align: center;
            margin-top: 1.5rem;
            color: #64748b;
            font-size: 0.8125rem;
        }
        @media (max-width: 480px) {
            .login-card {
                margin: 1rem;
                padding: 1.5rem;
            }
        }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center bg-gradient-to-br from-blue-50 to-blue-100 p-4">
    <div class="login-container">
        <!-- Left Side - Illustration -->
        <div class="login-illustration">
            <div class="text-center">
                <h1 class="text-4xl font-bold text-yellow-400 mb-2">SULIS</h1>
                <div class="w-16 h-1 bg-yellow-400 mx-auto mb-4"></div>
                <p class="text-blue-100 font-medium">Sustainable Utility Information Solutions</p>
                <div class="my-8">
                    <svg viewBox="0 0 200 200" class="w-40 h-40 mx-auto">
                        <path fill="#F9C74F" d="M100,40c33.1,0,60,26.9,60,60s-26.9,60-60,60s-60-26.9-60-60S66.9,40,100,40z M100,50c-27.6,0-50,22.4-50,50s22.4,50,50,50s50-22.4,50-50S127.6,50,100,50z"/>
                        <path fill="#F9C74F" d="M100,65c19.3,0,35,15.7,35,35s-15.7,35-35,35s-35-15.7-35-35S80.7,65,100,65z M100,70c-16.6,0-30,13.4-30,30s13.4,30,30,30s30-13.4,30-30S116.6,70,100,70z"/>
                        <path fill="#F9C74F" d="M100,85c8.3,0,15,6.7,15,15s-6.7,15-15,15s-15-6.7-15-15S91.7,85,100,85z"/>
                    </svg>
                </div>
                <p class="text-blue-100 max-w-xs mx-auto">Streamline your property management with our comprehensive solution</p>
            </div>
        </div>

        <!-- Right Side - Login Form -->
        <div class="login-form-container">
            <div class="text-center mb-8">
                <h2 class="text-2xl font-bold text-gray-800 mb-1">Welcome Back</h2>
                <p class="text-gray-500">Sign in to your account to continue</p>
            </div>

            <!-- Session Status -->
            @if (session('status'))
                <div class="mb-4 text-sm font-medium text-green-600">
                    {{ session('status') }}
                </div>
            @endif

            <form method="POST" action="{{ route('login') }}" class="login-form">
                @csrf
                
                <!-- Email -->
                <div class="input-group">
                    <label for="email">Email Address</label>
                    <div style="position: relative;">
                        <i class="fas fa-envelope input-icon"></i>
                        <input id="email" class="input-field" type="email" name="email" value="{{ old('email') }}" required autofocus autocomplete="username" placeholder="Enter your email">
                    </div>
                    @error('email')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Password -->
                <div class="input-group">
                    <label for="password">Password</label>
                    <div style="position: relative;">
                        <i class="fas fa-lock input-icon"></i>
                        <input id="password" class="input-field" type="password" name="password" required autocomplete="current-password" placeholder="••••••••">
                        <i class="fas fa-eye input-icon cursor-pointer" style="left: auto; right: 1rem;" onclick="togglePassword()"></i>
                    </div>
                    @error('password')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Remember Me -->
                <div class="remember-forgot">
                    <label class="remember-me">
                        <input type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                        <span>Remember me</span>
                    </label>
                    @if (Route::has('password.request'))
                        <a class="forgot-password" href="{{ route('password.request') }}">
                            Forgot password?
                        </a>
                    @endif
                </div>

                <button type="submit" class="btn-login">
                    <i class="fas fa-sign-in-alt"></i>
                    <span>Sign In</span>
                </button>
            </form>

<p class="signup-link">
                Don't have an account? 
                <a href="{{ route('register') }}" class="text-blue-600 font-medium hover:underline">Sign up</a>
            </p>
        </div>

        <!-- Session Status -->
        <x-auth-session-status class="mb-4" :status="session('status')" />

        
    </div>

    <script>
        function togglePassword() {
            const password = document.getElementById('password');
            const icon = document.querySelector('.fa-eye');
            if (password.type === 'password') {
                password.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                password.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        }
        
        // Auto-hide success/error messages after 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            // Auto-hide flash messages after 5 seconds
            const flashMessages = document.querySelectorAll('.alert');
            flashMessages.forEach(message => {
                setTimeout(() => {
                    message.style.transition = 'opacity 0.5s';
                    message.style.opacity = '0';
                    setTimeout(() => message.remove(), 500);
                }, 5000);
            });
            
            // Add focus effects for better UX
            document.querySelectorAll('.input-field').forEach(input => {
                input.addEventListener('focus', function() {
                    const label = this.parentElement.parentElement.querySelector('label');
                    if (label) {
                        label.style.color = '#1a365d';
                    }
                });
                
                input.addEventListener('blur', function() {
                    const label = this.parentElement.parentElement.querySelector('label');
                    if (label) {
                        label.style.color = '';
                    }
                });
            });
        });
    </script>
    </body>
    </div>
</body>
</html>
