@extends('layouts.app')

@section('content')
<div class="py-6">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 bg-white border-b border-gray-200">
                <h2 class="text-2xl font-semibold text-gray-800 mb-6">Bulk Process Rent Bills</h2>
                
                <form action="{{ route('bills.rent.bulk-store') }}" method="POST" id="bulkBillForm">
                    @csrf
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Billing Period -->
                        <div>
                            <label for="BillingPeriod" class="block text-sm font-medium text-gray-700">Billing Period <span class="text-red-500">*</span></label>
                            <input type="text" id="BillingPeriod" name="BillingPeriod" value="{{ old('BillingPeriod', $nextPeriod) }}" 
                                   class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                                   required>
                            @error('BillingPeriod')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Billing Date -->
                        <div>
                            <label for="BillingDate" class="block text-sm font-medium text-gray-700">Billing Date <span class="text-red-500">*</span></label>
                            <input type="date" id="BillingDate" name="BillingDate" value="{{ old('BillingDate', now()->format('Y-m-d')) }}" 
                                   class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                                   required>
                            @error('BillingDate')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Due Date -->
                        <div>
                            <label for="DueDate" class="block text-sm font-medium text-gray-700">Due Date <span class="text-red-500">*</span></label>
                            <input type="date" id="DueDate" name="DueDate" value="{{ old('DueDate', now()->addDays(14)->format('Y-m-d')) }}" 
                                   class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                                   required>
                            @error('DueDate')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Base Amount -->
                        <div>
                            <label for="BaseAmount" class="block text-sm font-medium text-gray-700">Base Amount <span class="text-red-500">*</span></label>
                            <div class="mt-1 relative rounded-md shadow-sm">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="text-gray-500 sm:text-sm">$</span>
                                </div>
                                <input type="number" step="0.01" id="BaseAmount" name="BaseAmount" value="{{ old('BaseAmount') }}" 
                                       class="focus:ring-indigo-500 focus:border-indigo-500 block w-full pl-7 pr-12 sm:text-sm border-gray-300 rounded-md"
                                       required>
                            </div>
                            @error('BaseAmount')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Notes -->
                        <div class="col-span-2">
                            <label for="Notes" class="block text-sm font-medium text-gray-700">Notes (will be added to all bills)</label>
                            <textarea id="Notes" name="Notes" rows="3" class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">{{ old('Notes') }}</textarea>
                            @error('Notes')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Confirmation Checkbox -->
                        <div class="col-span-2">
                            <div class="flex items-start">
                                <div class="flex items-center h-5">
                                    <input id="confirmBulk" name="confirmBulk" type="checkbox" 
                                           class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 rounded"
                                           required>
                                </div>
                                <div class="ml-3 text-sm">
                                    <label for="confirmBulk" class="font-medium text-gray-700">I confirm that I want to generate rent bills for all active customers</label>
                                    <p class="text-gray-500">This action cannot be undone. Bills will be generated for all active customers with the specified parameters.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="mt-6 flex justify-end space-x-4">
                        <a href="{{ route('bills.rent.index') }}" class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            Cancel
                        </a>
                        <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            Process Bulk Bills
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Auto-format billing period input (YYYYMM)
    document.getElementById('BillingPeriod').addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '');
        if (value.length > 6) value = value.slice(0, 6);
        e.target.value = value;
    });

    // Form submission confirmation
    document.getElementById('bulkBillForm').addEventListener('submit', function(e) {
        if (!confirm('Are you sure you want to generate rent bills for all active customers? This action cannot be undone.')) {
            e.preventDefault();
        }
    });
</script>
@endpush

@endsection
