@extends('layouts.app')

@section('content')
<div class="py-6">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 bg-white border-b border-gray-200">
                <h2 class="text-2xl font-semibold text-gray-800 mb-6">Create New Rent Bill</h2>
                
                <form action="{{ route('bills.rent.store') }}" method="POST">
                    @csrf
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Customer Selection -->
                        <div class="col-span-2">
                            <label for="CustomerID" class="block text-sm font-medium text-gray-700">Customer <span class="text-red-500">*</span></label>
                            <select id="CustomerID" name="CustomerID" required 
                                    class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
                                <option value="">-- Select Customer --</option>
                                @foreach($customers as $id => $name)
                                    <option value="{{ $id }}" {{ old('CustomerID') == $id ? 'selected' : '' }}>{{ $name }}</option>
                                @endforeach
                            </select>
                            @error('CustomerID')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Billing Period -->
                        <div>
                            <label for="BillingPeriod" class="block text-sm font-medium text-gray-700">Billing Period <span class="text-red-500">*</span></label>
                            <input type="text" id="BillingPeriod" name="BillingPeriod" value="{{ old('BillingPeriod', $nextPeriod) }}" 
                                   class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                                   required>
                            @error('BillingPeriod')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Billing Date -->
                        <div>
                            <label for="BillingDate" class="block text-sm font-medium text-gray-700">Billing Date <span class="text-red-500">*</span></label>
                            <input type="date" id="BillingDate" name="BillingDate" value="{{ old('BillingDate', now()->format('Y-m-d')) }}" 
                                   class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                                   required>
                            @error('BillingDate')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Due Date -->
                        <div>
                            <label for="DueDate" class="block text-sm font-medium text-gray-700">Due Date <span class="text-red-500">*</span></label>
                            <input type="date" id="DueDate" name="DueDate" value="{{ old('DueDate', now()->addDays(14)->format('Y-m-d')) }}" 
                                   class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                                   required>
                            @error('DueDate')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Previous Reading -->
                        <div>
                            <label for="PrvReading" class="block text-sm font-medium text-gray-700">Previous Reading</label>
                            <input type="number" step="0.01" id="PrvReading" name="PrvReading" value="{{ old('PrvReading') }}" 
                                   class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                            @error('PrvReading')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Current Reading -->
                        <div>
                            <label for="CurReading" class="block text-sm font-medium text-gray-700">Current Reading</label>
                            <input type="number" step="0.01" id="CurReading" name="CurReading" value="{{ old('CurReading') }}" 
                                   class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                            @error('CurReading')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Total Bill -->
                        <div class="col-span-2">
                            <label for="TotalBill" class="block text-sm font-medium text-gray-700">Total Amount <span class="text-red-500">*</span></label>
                            <div class="mt-1 relative rounded-md shadow-sm">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="text-gray-500 sm:text-sm">$</span>
                                </div>
                                <input type="number" step="0.01" id="TotalBill" name="TotalBill" value="{{ old('TotalBill') }}" 
                                       class="focus:ring-indigo-500 focus:border-indigo-500 block w-full pl-7 pr-12 sm:text-sm border-gray-300 rounded-md"
                                       required>
                            </div>
                            @error('TotalBill')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Notes -->
                        <div class="col-span-2">
                            <label for="Notes" class="block text-sm font-medium text-gray-700">Notes</label>
                            <textarea id="Notes" name="Notes" rows="3" 
                                      class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm py-2 px-3 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">{{ old('Notes') }}</textarea>
                            @error('Notes')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>

                    <!-- Hidden Fields -->
                    <input type="hidden" name="BillType" value="RENT">
                    <input type="hidden" name="BalanceBF" value="0">
                    <input type="hidden" name="TotalPayments" value="0">
                    <input type="hidden" name="BalanceCF" value="0">
                    <input type="hidden" name="BillQuality" value="E">

                    <!-- Form Actions -->
                    <div class="mt-8 flex justify-end space-x-3">
                        <a href="{{ route('bills.rent.index') }}" 
                           class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            Cancel
                        </a>
                        <button type="submit" 
                                class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            Create Bill
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Auto-format billing period input (YYYYMM)
    document.getElementById('BillingPeriod').addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '');
        if (value.length > 6) value = value.substring(0, 6);
        if (value.length > 4) {
            value = value.substring(0, 4) + value.substring(4, 6);
        }
        e.target.value = value;
    });
</script>
@endpush
@endsection
