@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1>Rent Service Bills</h1>
                <div class="d-flex gap-2">
                    <a href="{{ route('bills.rent.process') }}" class="btn btn-primary">
                        <i class="bi bi-plus-circle me-1"></i> Process Bills
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <form method="GET" action="{{ route('bills.rent.index') }}">
                        <div class="mb-3">
                            <label for="billing_period" class="form-label">Billing Period</label>
                            <select name="billing_period" id="billing_period" class="form-select">
                                <option value="">All Periods</option>
                                @foreach($billingPeriods as $period)
                                    <option value="{{ $period }}" {{ $billingPeriod == $period ? 'selected' : '' }}>
                                        {{ \Carbon\Carbon::createFromFormat('Y-m', $period)->format('F Y') }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <button type="submit" class="btn btn-outline-primary btn-sm">Filter</button>
                        <a href="{{ route('bills.rent.index') }}" class="btn btn-outline-secondary btn-sm">Clear</a>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Bills Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">
                        Rent Service Bills
                        @if($billingPeriod)
                            - {{ \Carbon\Carbon::createFromFormat('Y-m', $billingPeriod)->format('F Y') }}
                        @endif
                    </h5>
                </div>
                <div class="card-body">
                    @if($bills->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Bill ID</th>
                                        <th>Customer</th>
                                        <th>Unit</th>
                                        <th>Property</th>
                                        <th>Billing Period</th>
                                        <th>Billing Date</th>
                                        <th>Current Charges</th>
                                        <th>Previous Balance</th>
                                        <th>Total Payable</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($bills as $bill)
                                    <tr>
                                        <td>
                                            <strong>{{ $bill->BillID }}</strong>
                                        </td>
                                        <td>
                                            {{ $bill->customer->CustomerName ?? 'N/A' }}
                                            <br>
                                            <small class="text-muted">{{ $bill->customer->AccountNo ?? '' }}</small>
                                        </td>
                                        <td>{{ $bill->unit->UnitIdentity ?? 'N/A' }}</td>
                                        <td>{{ $bill->unit->property->PropName ?? 'N/A' }}</td>
                                        <td>
                                            @if($bill->BillingPeriod)
                                                {{ \Carbon\Carbon::createFromFormat('Ym', $bill->BillingPeriod)->format('F Y') }}
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td>{{ $bill->BillingDate ? \Carbon\Carbon::parse($bill->BillingDate)->format('M d, Y') : 'N/A' }}</td>
                                        <td class="text-end">{{ number_format($bill->CurrentCharges, 2) }}</td>
                                        <td class="text-end">{{ number_format($bill->PreviousBalance, 2) }}</td>
                                        <td class="text-end">
                                            <strong>{{ number_format($bill->TotalPayable, 2) }}</strong>
                                        </td>
                                        <td>
                                            @php
                                                $statusClass = match($bill->BillStatus) {
                                                    'OPEN' => 'bg-warning',
                                                    'PAID' => 'bg-success',
                                                    'OVERDUE' => 'bg-danger',
                                                    default => 'bg-secondary'
                                                };
                                            @endphp
                                            <span class="badge {{ $statusClass }}">
                                                {{ $bill->BillStatus ?? 'UNKNOWN' }}
                                            </span>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('bills.rent.show', $bill->BillID) }}" 
                                                   class="btn btn-sm btn-outline-primary" 
                                                   data-bs-toggle="tooltip" 
                                                   title="View Bill">
                                                    <i class="bi bi-eye"></i>
                                                </a>
                                                <a href="{{ route('bills.rent.print', $bill->BillID) }}" 
                                                   class="btn btn-sm btn-outline-secondary" 
                                                   data-bs-toggle="tooltip" 
                                                   title="Print Bill">
                                                    <i class="bi bi-printer"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        @if($bills->hasPages())
                            <div class="d-flex justify-content-between align-items-center mt-4">
                                <div class="text-muted small">
                                    Showing {{ $bills->firstItem() ?? 0 }} to {{ $bills->lastItem() ?? 0 }} of {{ $bills->total() }} entries
                                </div>
                                <div>
                                    {{ $bills->links() }}
                                </div>
                            </div>
                        @endif
                    @else
                        <div class="text-center py-5">
                            <i class="bi bi-file-earmark-text display-1 text-muted"></i>
                            <h5 class="mt-3 text-muted">No rent service bills found</h5>
                            <p class="text-muted">
                                @if($billingPeriod)
                                    No bills found for the selected billing period.
                                @else
                                    No rent service bills have been generated yet.
                                @endif
                            </p>
                            <a href="{{ route('bills.rent.process') }}" class="btn btn-primary">
                                <i class="bi bi-plus-circle me-1"></i> Generate Bills
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Initialize tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl)
    });
</script>
@endpush
