<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rent Service Bill - {{ $bill->BillID }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background: #fff;
        }
        
        .invoice-container {
            max-width: 800px;
            margin: 0 auto;
            border: 1px solid #ddd;
            padding: 20px;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        
        .company-info {
            flex: 1;
        }
        
        .company-info h2 {
            margin: 0;
            color: #333;
        }
        
        .company-info p {
            margin: 5px 0;
            color: #666;
        }
        
        .bill-info {
            text-align: right;
            flex: 1;
        }
        
        .bill-info h3 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }
        
        .bill-info p {
            margin: 5px 0;
            color: #666;
        }
        
        .customer-section {
            margin: 20px 0;
            padding: 15px;
            background: #f9f9f9;
            border-radius: 5px;
        }
        
        .customer-section h4 {
            margin: 0 0 10px 0;
            color: #333;
        }
        
        .customer-details {
            display: flex;
            gap: 30px;
        }
        
        .customer-details div {
            flex: 1;
        }
        
        .customer-details p {
            margin: 5px 0;
            color: #666;
        }
        
        .bill-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        
        .bill-table th,
        .bill-table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        
        .bill-table th {
            background: #f5f5f5;
            font-weight: bold;
            color: #333;
        }
        
        .bill-table .amount {
            text-align: right;
        }
        
        .totals-section {
            margin-top: 20px;
            padding: 15px;
            background: #f9f9f9;
            border-radius: 5px;
        }
        
        .totals-row {
            display: flex;
            justify-content: space-between;
            margin: 5px 0;
        }
        
        .totals-row.total {
            font-weight: bold;
            font-size: 18px;
            border-top: 2px solid #333;
            padding-top: 10px;
            margin-top: 10px;
        }
        
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            text-align: center;
            color: #666;
            font-size: 12px;
        }
        
        .status-badge {
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: bold;
            text-transform: uppercase;
        }
        
        .status-open {
            background: #fff3cd;
            color: #856404;
        }
        
        .status-paid {
            background: #d4edda;
            color: #155724;
        }
        
        .status-overdue {
            background: #f8d7da;
            color: #721c24;
        }
    </style>
</head>
<body>
    <div class="invoice-container">
        <!-- Header -->
        <div class="header">
            <div class="company-info">
                <h2>{{ session('CompanyName') ?? 'Property Management' }}</h2>
                <p>{{ session('CompanyAddress') ?? 'Company Address' }}</p>
                <p>{{ session('CompanyPhone') ?? 'Phone: +254 XXX XXX XXX' }}</p>
                <p>{{ session('CompanyEmail') ?? 'Email: info@company.com' }}</p>
            </div>
            <div class="bill-info">
                <h3>RENT SERVICE BILL</h3>
                <p><strong>Bill ID:</strong> {{ $bill->BillID }}</p>
                <p><strong>Status:</strong> 
                    <span class="status-badge status-{{ strtolower($bill->BillStatus ?? 'open') }}">
                        {{ $bill->BillStatus ?? 'OPEN' }}
                    </span>
                </p>
                <p><strong>Billing Date:</strong> {{ $bill->BillingDate ? \Carbon\Carbon::parse($bill->BillingDate)->format('M d, Y') : 'N/A' }}</p>
                @if($bill->DueDate)
                <p><strong>Due Date:</strong> {{ \Carbon\Carbon::parse($bill->DueDate)->format('M d, Y') }}</p>
                @endif
            </div>
        </div>

        <!-- Customer Information -->
        <div class="customer-section">
            <h4>Customer Information</h4>
            <div class="customer-details">
                <div>
                    <p><strong>Name:</strong> {{ $customer->CustomerName ?? 'N/A' }}</p>
                    <p><strong>Account No:</strong> {{ $customer->AccountNo ?? 'N/A' }}</p>
                    <p><strong>Phone:</strong> {{ $customer->TelNo ?? 'N/A' }}</p>
                    <p><strong>Email:</strong> {{ $customer->Email ?? 'N/A' }}</p>
                </div>
                <div>
                    <p><strong>Unit:</strong> {{ $bill->unit->UnitIdentity ?? 'N/A' }}</p>
                    <p><strong>Property:</strong> {{ $bill->unit->property->PropName ?? 'N/A' }}</p>
                    <p><strong>Billing Period:</strong> 
                        @if($bill->BillingPeriod)
                            {{ \Carbon\Carbon::createFromFormat('Ym', $bill->BillingPeriod)->format('F Y') }}
                        @else
                            N/A
                        @endif
                    </p>
                </div>
            </div>
        </div>

        <!-- Bill Items -->
        <table class="bill-table">
            <thead>
                <tr>
                    <th>Description</th>
                    <th>Quantity</th>
                    <th>Unit Price</th>
                    <th class="amount">Amount</th>
                </tr>
            </thead>
            <tbody>
                @if($bill->lines && $bill->lines->count() > 0)
                    @foreach($bill->lines as $line)
                    <tr>
                        <td>{{ $line->ItemName }}</td>
                        <td>{{ number_format($line->Units, 2) }}</td>
                        <td>{{ number_format($line->UnitPrice, 2) }}</td>
                        <td class="amount">{{ number_format($line->LineAmount, 2) }}</td>
                    </tr>
                    @endforeach
                @else
                    <tr>
                        <td colspan="4" style="text-align: center; padding: 20px;">
                            No line items found for this bill.
                        </td>
                    </tr>
                @endif
            </tbody>
        </table>

        <!-- Totals -->
        <div class="totals-section">
            <div class="totals-row">
                <span>Previous Balance:</span>
                <span>{{ number_format($bill->PreviousBalance ?? 0, 2) }}</span>
            </div>
            <div class="totals-row">
                <span>Current Charges:</span>
                <span>{{ number_format($bill->CurrentCharges ?? 0, 2) }}</span>
            </div>
            <div class="totals-row total">
                <span>Total Payable:</span>
                <span>{{ number_format($bill->TotalPayable ?? 0, 2) }}</span>
            </div>
        </div>

        <!-- Footer -->
        <div class="footer">
            <p>This is a computer-generated bill and does not require a signature.</p>
            <p>Generated on {{ \Carbon\Carbon::now()->format('M d, Y H:i') }} by {{ $bill->CreatedBy ?? 'System' }}</p>
            <p>For inquiries, please contact the property management office.</p>
        </div>
    </div>
</body>
</html>
