@extends('layouts.app')

@push('styles')
<style>
    .invoice-card {
        border: 1px solid #e2e8f0;
        border-radius: 1rem;
        overflow: hidden;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    }
    .invoice-card:hover {
        box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    }
    .invoice-header {
        background: linear-gradient(135deg, #1e40af 0%, #1e3a8a 100%);
        color: white;
        padding: 1.5rem 2rem;
        position: relative;
        overflow: hidden;
    }
    .invoice-header::before {
        content: '';
        position: absolute;
        top: 0;
        right: 0;
        width: 200px;
        height: 200px;
        background: radial-gradient(circle, rgba(250, 204, 21, 0.1) 0%, transparent 70%);
        border-radius: 50%;
        transform: translate(50%, -50%);
    }
    .invoice-header::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 150px;
        height: 150px;
        background: radial-gradient(circle, rgba(250, 204, 21, 0.08) 0%, transparent 70%);
        border-radius: 50%;
        transform: translate(-30%, 30%);
    }
    .status-badge {
        padding: 0.35rem 0.75rem;
        border-radius: 9999px;
        font-size: 0.75rem;
        font-weight: 600;
        text-transform: capitalize;
        display: inline-flex;
        align-items: center;
        gap: 0.25rem;
    }
    .status-paid {
        background-color: #d1fae5;
        color: #065f46;
    }
    .status-unpaid {
        background-color: #fee2e2;
        color: #b91c1c;
    }
    .status-overdue {
        background-color: #fef3c7;
        color: #92400e;
    }
    .status-partial {
        background-color: #dbeafe;
        color: #1e40af;
    }
    .action-btn {
        width: 32px;
        height: 32px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        border-radius: 50%;
    }
    .amount-cell {
        font-family: 'Inter', 'Segoe UI', system-ui, -apple-system, sans-serif;
        font-weight: 700;
        letter-spacing: -0.025em;
        color: #1e40af;
        font-size: 0.95rem;
    }
    .empty-state {
        padding: 4rem 2rem;
        text-align: center;
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        border-radius: 1rem;
        margin: 2rem 0;
        border: 2px dashed #cbd5e1;
    }
    .empty-state i {
        font-size: 3rem;
        color: #94a3b8;
        margin-bottom: 1.5rem;
    }
    .table-header {
        background: linear-gradient(135deg, #1e40af 0%, #1e3a8a 100%);
        position: relative;
        overflow: hidden;
    }
    .table-header::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 2px;
        background: linear-gradient(90deg, #fbbf24 0%, #f59e0b 50%, #fbbf24 100%);
    }
    .table-header::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 1px;
        background: rgba(251, 191, 36, 0.3);
    }
    .table-header th {
        color: white;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        position: relative;
        z-index: 1;
    }
    .table-header th:hover {
        background: rgba(255, 255, 255, 0.1);
    }
    .table-row:hover {
        background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
    }
    .table-data {
        font-size: 0.75rem;
    }
    .table-data-small {
        font-size: 0.65rem;
    }
    .filter-select {
        background: white;
        border: 2px solid #e2e8f0;
        color: #000000;
    }
    .filter-select:focus {
        border-color: #1e40af;
        box-shadow: 0 0 0 3px rgba(30, 64, 175, 0.1);
    }
    .btn-primary {
        background: linear-gradient(135deg, #1e40af 0%, #1e3a8a 100%);
        border: none;
        color: white !important;
    }
    .btn-primary:hover {
        background: linear-gradient(135deg, #1e3a8a 0%, #1e2f5f 100%);
        box-shadow: 0 4px 12px rgba(30, 64, 175, 0.3);
    }
    .btn-success {
        background: linear-gradient(135deg, #16a34a 0%, #15803d 100%);
        border: none;
    }
    .btn-success:hover {
        background: linear-gradient(135deg, #15803d 0%, #166534 100%);
        box-shadow: 0 4px 12px rgba(22, 163, 74, 0.3);
    }
    .invoice-number {
        background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
        padding: 0.25rem 0.5rem;
        border-radius: 0.375rem;
        border-left: 3px solid #1e40af;
    }
    .customer-info {
        position: relative;
    }
    .customer-info::before {
        content: '';
        position: absolute;
        left: -8px;
        top: 50%;
        transform: translateY(-50%);
        width: 4px;
        height: 70%;
        background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%);
        border-radius: 2px;
    }
    .amount-display {
        background: linear-gradient(135deg, #f0f9ff 0%, #dbeafe 100%);
        padding: 0.5rem 0.75rem;
        border-radius: 0.5rem;
        border: 1px solid #bfdbfe;
        position: relative;
        overflow: hidden;
    }
    .amount-display::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.4), transparent);
        animation: shimmer 2s infinite;
    }
    .property-cell {
        background: linear-gradient(135deg, #fef3c7 0%, #fde68a 20%, transparent 20%);
        padding: 0.25rem 0.5rem;
        border-radius: 0.375rem;
    }

    @keyframes shimmer {
        0% { transform: translateX(-100%); }
        100% { transform: translateX(200%); }
    }

    /* Stats cards styling */
    .stats-card {
        border: none;
        border-radius: 1rem;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        transition: all 0.3s ease;
    }
    .stats-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 10px 25px -3px rgba(0, 0, 0, 0.1);
    }
    .stats-icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.25rem;
    }
    .stats-primary { background: rgba(30, 64, 175, 0.1); color: #1e40af; }
    .stats-warning { background: rgba(245, 158, 11, 0.1); color: #d97706; }
    .stats-success { background: rgba(22, 163, 74, 0.1); color: #15803d; }

    /* Enhanced customer avatar */
    .customer-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: linear-gradient(135deg, #1e40af 0%, #3b82f6 100%);
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 600;
        font-size: 0.9rem;
        border: 2px solid rgba(255, 255, 255, 0.2);
    }

    /* Reading badges */
    .reading-badge {
        padding: 0.375rem 0.75rem;
        border-radius: 6px;
        font-size: 0.8rem;
        font-weight: 500;
        display: inline-flex;
        align-items: center;
        gap: 0.375rem;
        margin-bottom: 0.375rem;
    }
    .reading-badge.electricity {
        background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
        color: #92400e;
        border: 1px solid #fbbf24;
    }
    .reading-badge.water {
        background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%);
        color: #1e40af;
        border: 1px solid #93c5fd;
    }

    /* Responsive table improvements */
    @media (max-width: 768px) {
        .table-responsive {
            font-size: 0.875rem;
        }
        .table-responsive th,
        .table-responsive td {
            padding: 0.5rem;
        }
        .table-responsive .dropdown-menu {
            min-width: 160px;
        }
        .invoice-header {
            padding: 1rem;
        }
        .invoice-header h1 {
            font-size: 1.5rem;
        }
        .stats-card {
            margin-bottom: 1rem;
        }
        .stats-card p {
            font-size: 1.25rem;
        }
    }

    /* Smaller table font sizes */
    .table-responsive th {
        font-size: 0.75rem !important;
        font-weight: 600;
    }
    .table-responsive td {
        font-size: 0.8rem !important;
    }
    .customer-info .table-data {
        font-size: 0.75rem !important;
    }
    .customer-info .table-data-small {
        font-size: 0.7rem !important;
    }
    .property-cell {
        font-size: 0.75rem !important;
    }
    .property-cell .text-xs {
        font-size: 0.65rem !important;
    }
    .btn-primary {
        font-size: 0.75rem !important;
    }
</style>
@endpush

@section('content')
<div class="py-6">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="invoice-card">
            <div class="invoice-header">
                <div class="flex flex-col md:flex-row md:items-center md:justify-between space-y-4 md:space-y-0">
                    <div class="flex flex-col space-y-3 sm:flex-row sm:items-center sm:space-y-0 sm:space-x-4">
                        <div>
                            <h1 class="text-3xl font-bold flex items-center">
                                <i class="fas fa-cash-coin mr-3"></i>
                                Process Rent & Services
                            </h1>
                            <p class="text-blue-100 mt-1">Generate bills for unprocessed tenants</p>
                        </div>

                        <div class="flex items-center space-x-3">
                            <form action="{{ route('bills.rent.process') }}" method="GET" class="flex items-center space-x-2">
                                <div class="relative">
                                    <select name="property" class="filter-select block w-48 pl-3 pr-10 py-2 text-sm rounded-md leading-tight" onchange="this.form.submit()">
                                        <option value="">All Properties</option>
                                        @if(isset($properties))
                                            @foreach($properties as $property)
                                                <option value="{{ $property->PropID }}" {{ request('property') == $property->PropID ? 'selected' : '' }}>
                                                    {{ $property->PropName }}
                                                </option>
                                            @endforeach
                                        @endif
                                    </select>
                                    <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-blue-500">
                                        <i class="fas fa-building"></i>
                                    </div>
                                </div>
                                <input type="hidden" name="period" value="{{ $period }}">
                            </form>

                            <form action="{{ route('bills.rent.process') }}" method="GET" class="flex items-center space-x-2">
                                <div class="relative">
                                    <select name="period" class="filter-select block w-40 pl-3 pr-10 py-2 text-sm rounded-md leading-tight" onchange="this.form.submit()">
                                        @foreach($allPeriods as $periodOption)
                                            <option value="{{ $periodOption['value'] }}" {{ $periodOption['value'] == $period ? 'selected' : '' }}>
                                                {{ $periodOption['label'] }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-blue-500">
                                        <i class="fas fa-calendar-alt"></i>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <a href="{{ route('bills.rent.index') }}" class="btn-primary inline-flex items-center px-6 py-3 text-sm font-medium rounded-md shadow-sm transition-all duration-200">
                        <i class="fas fa-list mr-2"></i> View All Bills
                    </a>
                </div>
            </div>

            <!-- Stats Cards -->
            <div class="px-6 py-6">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
                    <div class="stats-card p-6">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm font-medium text-gray-600 uppercase tracking-wide">Total Unprocessed</p>
                                <p class="text-2xl font-bold text-gray-900">{{ number_format($unprocessedServices->total()) }}</p>
                            </div>
                            <div class="stats-icon stats-primary">
                                <i class="fas fa-list-check"></i>
                            </div>
                        </div>
                    </div>

                    <div class="stats-card p-6">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm font-medium text-gray-600 uppercase tracking-wide">Current Period</p>
                                <p class="text-2xl font-bold text-gray-900">{{ \Carbon\Carbon::parse($period)->format('M Y') }}</p>
                            </div>
                            <div class="stats-icon stats-warning">
                                <i class="fas fa-calendar-alt"></i>
                            </div>
                        </div>
                    </div>

                    <div class="stats-card p-6">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm font-medium text-gray-600 uppercase tracking-wide">Quick Actions</p>
                                <div class="flex space-x-2 mt-2">
                                    <a href="{{ route('invoices.rent.index') }}" class="btn-primary inline-flex items-center px-3 py-1 text-xs font-medium rounded">
                                        <i class="fas fa-list mr-1"></i> View Invoices
                                    </a>
                                    <button type="button" class="btn-success inline-flex items-center px-3 py-1 text-xs font-medium rounded" data-bs-toggle="modal" data-bs-target="#bulkActionsModal">
                                        <i class="fas fa-bolt mr-1"></i> Process Bills
                                    </button>
                                </div>
                            </div>
                            <div class="stats-icon stats-success">
                                <i class="fas fa-bolt"></i>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Main Content Card -->
                <div class="bg-white rounded-lg shadow-sm overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray-200">
                        <div class="flex flex-col md:flex-row md:items-center md:justify-between space-y-4 md:space-y-0">
                            <div>
                                <h3 class="text-lg font-semibold text-gray-900 flex items-center">
                                    <i class="fas fa-users mr-2 text-blue-600"></i>
                                    Unprocessed Tenants
                                </h3>
                                <p class="text-sm text-gray-600 mt-1">Generate bills for tenants without current period bills</p>
                            </div>
                            <div class="flex items-center space-x-3">
                                <div class="relative">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <i class="fas fa-search text-gray-400"></i>
                                    </div>
                                    <input type="text" id="searchInput" class="block w-full pl-10 pr-3 py-2 border border-gray-300 rounded-md leading-5 bg-white placeholder-gray-500 focus:outline-none focus:placeholder-gray-400 focus:ring-1 focus:ring-blue-500 focus:border-blue-500 sm:text-sm" placeholder="Search tenants...">
                                </div>
                            </div>
                        </div>
                    </div>
                    @if (session('status'))
                    <div class="alert alert-success alert-dismissible fade show d-flex align-items-center mb-4" role="alert">
                        <i class="bi bi-check-circle-fill me-2" style="font-size: 1.25rem;"></i>
                        <div class="flex-grow-1">
                            <strong>Success!</strong> {{ session('status') }}
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
                
                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show d-flex align-items-center mb-4" role="alert">
                        <i class="bi bi-exclamation-triangle-fill me-2" style="font-size: 1.25rem;"></i>
                        <div class="flex-grow-1">
                            <strong>Error!</strong> Please check the form for errors.
                            <ul class="mb-0 mt-2">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                    @if($unprocessedServices->isEmpty())
                        <div class="empty-state">
                            <div class="mb-4">
                                <i class="fas fa-receipt text-4xl text-blue-500 opacity-80"></i>
                            </div>
                            <h4 class="mb-3">No Unprocessed Bills Found</h4>
                            <p class="text-gray-600 mb-4">
                                There are no unprocessed rent services for
                                <span class="font-bold text-blue-600">{{ \Carbon\Carbon::createFromFormat('Y-m', $period)->format('F Y') }}</span>.
                            </p>
                            <div class="flex flex-col sm:flex-row justify-center gap-3 mb-4">
                                <a href="{{ route('bills.rent.create', ['period' => $period]) }}" class="btn-primary inline-flex items-center px-4 py-2 text-sm font-medium rounded-md">
                                    <i class="fas fa-plus-circle mr-2"></i> Create New Bill
                                </a>
                                <a href="{{ route('bills.rent.index') }}" class="btn btn-outline-primary inline-flex items-center px-4 py-2 text-sm font-medium rounded-md">
                                    <i class="fas fa-list mr-2"></i> View All Bills
                                </a>
                            </div>
                            <div class="flex items-center justify-center">
                                <a href="{{ route('bills.rent.process', ['period' => \Carbon\Carbon::parse($period)->subMonth()->format('Y-m')] ) }}"
                                   class="btn btn-outline-secondary inline-flex items-center px-3 py-1 text-xs font-medium rounded mr-2">
                                    <i class="fas fa-chevron-left mr-1"></i> Previous Month
                                </a>
                                <span class="text-gray-500 mx-2">{{ \Carbon\Carbon::parse($period)->format('M Y') }}</span>
                                <a href="{{ route('bills.rent.process', ['period' => \Carbon\Carbon::parse($period)->addMonth()->format('Y-m')] ) }}"
                                   class="btn btn-outline-secondary inline-flex items-center px-3 py-1 text-xs font-medium rounded ml-2">
                                    Next Month <i class="fas fa-chevron-right ml-1"></i>
                                </a>
                            </div>
                        </div>
                    @else
                        <div class="px-6 pb-6">
                            <table class="min-w-full divide-y divide-gray-200 rounded-lg overflow-hidden shadow-sm">
                                <thead class="table-header">
                                    <tr>
                                        <th scope="col" class="px-6 py-4 text-left text-xs uppercase tracking-wider">#</th>
                                        <th scope="col" class="px-6 py-4 text-left text-xs uppercase tracking-wider">Tenant</th>
                                        <th scope="col" class="px-6 py-4 text-left text-xs uppercase tracking-wider">Unit Details</th>
                                        <th scope="col" class="px-6 py-4 text-left text-xs uppercase tracking-wider">Unit Identity</th>
                                        <th scope="col" class="px-6 py-4 text-right text-xs uppercase tracking-wider pr-8">Actions</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-100">
                                    @foreach($unprocessedServices as $service)
                                    <tr class="table-row hover:shadow-md transition-all duration-200">
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600 font-medium table-data">
                                            {{ $loop->iteration }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <div class="customer-info pl-4">
                                                <div class="text-sm font-semibold text-gray-900 table-data">
                                                    {{ $service->CustomerName }}
                                                </div>
                                                <div class="text-xs text-gray-500 flex items-center mt-1 table-data-small">
                                                    <i class="fas fa-id-card mr-1 text-blue-400"></i>
                                                    {{ $service->AccountNo }}
                                                </div>
                                            </div>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            @if($service->unit)
                                                <div class="property-cell text-sm font-medium text-gray-900 flex items-center px-3 py-2 rounded">
                                                    <i class="fas fa-building mr-2 text-blue-500"></i>
                                                    {{ $service->unit->UnitIdentity ?? 'N/A' }}
                                                    <div class="text-xs text-gray-600 mt-1">{{ $service->unit->property->PropName ?? 'N/A' }}</div>
                                                </div>
                                            @else
                                                <span class="text-gray-500">No unit assigned</span>
                                            @endif
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <div class="text-center">
                                                @if($service->unit)
                                                    <div class="inline-flex items-center justify-center w-16 h-16 bg-gradient-to-br from-blue-500 to-blue-600 text-white rounded-lg shadow-sm">
                                                        <span class="text-sm font-bold">{{ $service->unit->UnitIdentity ?? 'N/A' }}</span>
                                                    </div>
                                                @else
                                                    <span class="text-gray-500">No unit assigned</span>
                                                @endif
                                            </div>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium pr-8">
                                            <form action="{{ route('bills.rent.generate-individual') }}" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to generate a bill for {{ $service->CustomerName }}?')">
                                                @csrf
                                                <input type="hidden" name="customer_id" value="{{ $service->CustomerID }}">
                                                <input type="hidden" name="period" value="{{ $period }}">
                                                <button type="submit"
                                                       class="btn-primary inline-flex items-center px-3 py-2 text-xs font-medium rounded-md shadow-sm"
                                                       data-bs-toggle="tooltip"
                                                       data-bs-placement="top"
                                                       title="Generate bill for {{ $service->CustomerName }}">
                                                    <i class="fas fa-file-plus mr-1"></i> Create Bill
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>

                            @if($unprocessedServices->hasPages())
                                <div class="flex justify-between items-center mt-6 px-3">
                                    <div class="text-gray-500 text-sm">
                                        Showing {{ $unprocessedServices->firstItem() ?? 0 }} to {{ $unprocessedServices->lastItem() ?? 0 }} of {{ $unprocessedServices->count() }} entries
                                    </div>
                                    <div>
                                        {{ $unprocessedServices->links() }}
                                    </div>
                                </div>
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bulk Actions Modal -->
<div class="modal fade" id="bulkActionsModal" tabindex="-1" aria-labelledby="bulkActionsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="bulkActionsModalLabel">
                    <i class="bi bi-lightning me-2"></i> Bulk Process Bills
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('bills.rent.generate-all') }}" method="POST" id="bulkProcessForm">
                @csrf
                <input type="hidden" name="period" value="{{ $period }}">
                <div class="modal-body">
                    <div class="alert alert-info">
                        <i class="bi bi-info-circle me-2"></i>
                        You are about to generate bills for all unprocessed tenants ({{ $unprocessedServices->count() }}) for {{ \Carbon\Carbon::parse($period)->format('F Y') }}.
                    </div>
                    
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="billing_date" class="form-label">Billing Date</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-calendar3"></i></span>
                                <input type="date" name="billing_date" id="billing_date" class="form-control" required 
                                       value="{{ now()->format('Y-m-d') }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label for="due_date" class="form-label">Due Date</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-calendar-check"></i></span>
                                <input type="date" name="due_date" id="due_date" class="form-control" required
                                       value="{{ now()->addDays(14)->format('Y-m-d') }}">
                            </div>
                        </div>
                    </div>
                            <div class="form-group">
                                <label for="notes">Notes (Optional)</label>
                                <textarea name="notes" id="notes" class="form-control" rows="2"></textarea>
                            </div>
                            <div class="form-check mt-4 mb-3">
                        <input class="form-check-input" type="checkbox" id="confirmBulk" name="confirmBulk" required>
                        <label class="form-check-label" for="confirmBulk">
                            I confirm that I want to generate bills for all unprocessed tenants ({{ $unprocessedServices->total() }}).
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                        <i class="bi bi-x-lg me-1"></i> Cancel
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-lightning me-1"></i> Generate All Bills
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@push('scripts')
<script>
    // Initialize tooltips
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize Bootstrap tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
        
        // Search functionality
        const searchInput = document.getElementById('searchInput');
        const customerRows = document.querySelectorAll('.customer-row');
        
        if (searchInput) {
            searchInput.addEventListener('input', function() {
                const searchTerm = this.value.toLowerCase();
                
                customerRows.forEach(row => {
                    const text = row.textContent.toLowerCase();
                    if (text.includes(searchTerm)) {
                        row.style.display = '';
                    } else {
                        row.style.display = 'none';
                    }
                });
            });
        }
        
        // Auto-submit bulk form when dates change
        const billingDateInput = document.getElementById('billing_date');
        const dueDateInput = document.getElementById('due_date');
        
        if (billingDateInput && dueDateInput) {
            billingDateInput.addEventListener('change', validateBulkDates);
            dueDateInput.addEventListener('change', validateBulkDates);
            
            function validateBulkDates() {
                const billingDate = new Date(billingDateInput.value);
                const dueDate = new Date(dueDateInput.value);
                
                if (billingDate > dueDate) {
                    dueDateInput.setCustomValidity('Due date must be on or after billing date');
                } else {
                    dueDateInput.setCustomValidity('');
                }
            }
        }
    });
    
    // Show loading state on bulk form submit
    document.getElementById('bulkProcessForm')?.addEventListener('submit', function() {
        const submitBtn = this.querySelector('button[type="submit"]');
        if (submitBtn) {
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>Processing...';
        }
    });
</script>
@endpush

@endsection

@push('scripts')
<script>
    // Set minimum due date to be same as billing date
    document.getElementById('billing_date').addEventListener('change', function() {
        const dueDate = document.getElementById('due_date');
        if (new Date(dueDate.value) < new Date(this.value)) {
            dueDate.value = this.value;
        }
        dueDate.min = this.value;
    });
</script>
@endpush
