@extends('layouts.app')

@section('title', 'Recovery of Electricity Charges')

@section('content')
<style>
    body {
        font-family: Arial, Helvetica, sans-serif;
        font-size: 12px;
        color: #000;
    }

    .container {
        width: 800px;
        margin: auto;
        border: 1px solid #000;
        padding: 10px;
    }

    .header {
        text-align: center;
        border-bottom: 2px solid #000;
        padding-bottom: 5px;
    }

    .header h2 {
        margin: 5px 0;
        letter-spacing: 1px;
    }

    .section-title {
        background: #000;
        color: #fff;
        padding: 5px;
        font-weight: bold;
        text-transform: uppercase;
        text-align: center;
        margin-bottom: 5px;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 0;
    }

    td, th {
        padding: 5px;
        vertical-align: top;
    }

    th {
        background: #f0f0f0;
        text-align: left;
    }

    .right { text-align: right; }
    .center { text-align: center; }

    .total-box {
        background: #e6e6e6;
        font-weight: bold;
        border-top: 1px solid #000;
    }

    .payable-box {
        background: #e6e6e6;
        border: 1px solid #000;
        padding: 6px;
        font-weight: bold;
        text-align: center;
        margin: 10px 60px;
    }

    .footer {
        margin-top: 10px;
        font-size: 11px;
    }

    .black-strip {
        background: #000;
        color: #fff;
        padding: 6px 10px;
        font-weight: bold;
        margin-top: 10px;
    }

    .powered {
        font-size: 10px;
        text-align: right;
        margin-top: 5px;
    }

    .detach {
        border-top: 2px dashed #000;
        margin-top: 15px;
        padding-top: 10px;
    }

</style>

<div class="container">

    <!-- HEADER -->
    <div class="header">
        <table>
            <tr>
                <th><h2>THE WATERMARK BUSINESS PARK</h2></th>
                <th> <div class="section-title">Recovery of Electricity Charges</div></th>
            </tr>
        </table>
        
       
    </div>

    <!-- TO / BILL INFO -->
    <table>
        <tr>
            <td width="60%">
                <b>TO</b><br>
                Eurofits E.A Ltd<br>
                P.O Box 12345<br>
                BAY COURT<br>
                Watermark Business Park<br>
                Ndoto Road, Karen<br>
                Nairobi
            </td>
            <td width="40%">
                <table>
                    <tr>
                        <td class="bold">Number of Meters</td>
                        <td class="right">2</td>
                    </tr>
                    <tr>
                        <td class="bold">Billing Date</td>
                        <td class="right">10-Feb-2026</td>
                    </tr>
                    <tr>
                        <td class="bold">Billing Period</td>
                        <td class="right">Feb-2026</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <!-- MAIN CONTENT -->
    <div style="display: flex; margin-top: 20px;">

        <!-- CONSUMPTION DATA -->
        <div style="flex: 2; margin-right: 10px;">
            <div class="section-title">CONSUMPTION DATA</div>
            <table>
                <thead>
                    <tr>
                        <th>Account Number</th>
                        <th>Meter Number</th>
                        <th>Suite</th>
                        <th>Reading Date</th>
                        <th class="right">Previous Reading</th>
                        <th class="right">Current Reading</th>
                        <th class="right">Cons (Kwh)</th>
                    </tr>
                </thead>
                <tbody>
                    {{-- Dummy meter data --}}
                    @php
                        $meters = [
                            ['AccountNo'=>'AC1001','EMeterNo'=>'MTR001','Suite'=>'101','ReadingDate'=>'2026-02-05','PrevReading'=>1200,'CurrentReading'=>1350,'Consumption'=>150],
                            ['AccountNo'=>'AC1002','EMeterNo'=>'MTR002','Suite'=>'102','ReadingDate'=>'2026-02-05','PrevReading'=>980,'CurrentReading'=>1100,'Consumption'=>120],
                        ];
                    @endphp

                    @foreach($meters as $m)
                    <tr>
                        <td>{{ $m['AccountNo'] }}</td>
                        <td>{{ $m['EMeterNo'] }}</td>
                        <td>{{ $m['Suite'] }}</td>
                        <td>{{ \Carbon\Carbon::parse($m['ReadingDate'])->format('d-M-Y') }}</td>
                        <td class="right">{{ number_format($m['PrevReading'],2) }}</td>
                        <td class="right">{{ number_format($m['CurrentReading'],2) }}</td>
                        <td class="right">{{ number_format($m['Consumption'],2) }}</td>
                    </tr>
                    @endforeach

                  

                    {{-- Total --}}
                    @php
                        $totalConsumption = collect($meters)->sum('Consumption');
                        $totalBill = $totalConsumption*20;
                    @endphp
                    <tr class="total-box">
                        <td colspan="5" class="right">Total Amount</td>
                        <td colspan="2" class="right">Ksh {{ number_format($totalBill,2) }}</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- BILLING DETAILS -->
        <div style="flex: 1;">
            <div class="section-title">BILLING DETAILS</div>
            <table>
                @php
                    $billingDetails = [
                        ['Description'=>'Fixed Charge','Amount'=>600],
                        ['Description'=>'Consumption','Amount'=>$totalConsumption*20],
                        ['Description'=>'Max Demand KVA','Amount'=>1955.60],
                        ['Description'=>'Fuel Energy Cost','Amount'=>2682.72],
                        ['Description'=>'Forex Exchange Adj.','Amount'=>2384.90],
                        ['Description'=>'Inflation Adj.','Amount'=>213.84],
                        ['Description'=>'ERC Levy','Amount'=>51.84],
                        ['Description'=>'REP Levy','Amount'=>666.79],
                        ['Description'=>'WARMA LEVY','Amount'=>9.39],
                        ['Description'=>'VAT @ 16%','Amount'=>2971.87],
                    ];
                    $totalBilling = collect($billingDetails)->sum('Amount');
                @endphp
                <tr>
                    <th>Description</th>
                    <th class="right">Amount Kshs</th>
                </tr>
                @foreach($billingDetails as $d)
                <tr>
                    <td>{{ $d['Description'] }}</td>
                    <td class="right">{{ number_format($d['Amount'],2) }}</td>
                </tr>
                @endforeach
                <tr class="total-box">
                    <td>TOTAL CURRENT BILL</td>
                    <td class="right">{{ number_format($totalBilling,2) }}</td>
                </tr>
            </table>
        </div>
    </div>

    {{-- Payable Box --}}
    <div class="payable-box">
        TOTAL AMOUNT PAYABLE : &nbsp;&nbsp; Kshs {{ number_format($totalBill + $totalBilling,2) }}
    </div>

    {{-- Footer --}}
    <div class="footer">
        <p><b>The net account balance as at 10-Feb-2026 is Kshs {{ number_format($totalBill + $totalBilling,2) }}</b></p>
        <p>Cheques to be made payable to: <b>Hass Consult Real Estate Ltd - Watermark</b></p>
    </div>

    <div class="black-strip">
        Cheques to be made payable to : HassConsult Real Estate Ltd - Watermark
    </div>

    <div class="powered">
        Powered by Mijics · a SULIS Product &nbsp; | &nbsp; +254 20 387 2607 &nbsp; sulis@sulis.co.ke
    </div>

    {{-- DETACHABLE SLIP --}}
    <div class="detach">
        <table width="100%">
            <tr>
                <td class="section-title" style="width:50%;">To be attached to payment</td>
                <td class="section-title right" style="width:50%;">THE WATERMARK BUSINESS PARK</td>
            </tr>
        </table>
        <table style="margin-top:10px;">
            <tr>
                <td width="60%">
                    <b>Eurofits E.A Ltd</b><br>
                    C/O Eurofits E.A Ltd<br>
                    BAY COURT<br>
                    Watermark Business Park<br>
                    Ndege Road, Karen
                </td>
                <td width="40%">
                    <table>
                        <tr>
                            <td class="bold">BAY COURT</td>
                        </tr>
                        <tr>
                            <td>Number of Meters</td>
                            <td class="right">2</td>
                        </tr>
                        <tr>
                            <td class="bold">Amount Due</td>
                            <td class="right bold">Kshs {{ number_format($totalBill + $totalBilling,2) }}</td>
                        </tr>
                        <tr>
                            <td>Due Date</td>
                            <td class="right">17-Feb-2026</td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>

</div>

@endsection
