@extends('layouts.app')

@push('styles')
<style>
    .invoice-card {
        border: 1px solid #e2e8f0;
        border-radius: 1rem;
        overflow: hidden;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    }
    .invoice-card:hover {
        box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    }
    .invoice-header {
        background: linear-gradient(135deg, #1e40af 0%, #1e3a8a 100%);
        color: white;
        padding: 0.5rem 2rem;
        position: relative;
        overflow: hidden;
    }
    .invoice-header::before {
        content: '';
        position: absolute;
        top: 0;
        right: 0;
        width: 200px;
        height: 200px;
        background: radial-gradient(circle, rgba(250, 204, 21, 0.1) 0%, transparent 70%);
        border-radius: 50%;
        transform: translate(50%, -50%);
    }
    .invoice-header::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 150px;
        height: 150px;
        background: radial-gradient(circle, rgba(250, 204, 21, 0.08) 0%, transparent 70%);
        border-radius: 50%;
        transform: translate(-30%, 30%);
    }
    .status-badge {
        padding: 0.35rem 0.75rem;
        border-radius: 9999px;
        font-size: 0.75rem;
        font-weight: 600;
        text-transform: capitalize;
        display: inline-flex;
        align-items: center;
        gap: 0.25rem;
    }
    .status-paid {
        background-color: #d1fae5;
        color: #065f46;
    }
    .status-unpaid {
        background-color: #fee2e2;
        color: #b91c1c;
    }
    .status-overdue {
        background-color: #fef3c7;
        color: #92400e;
    }
    .status-partial {
        background-color: #dbeafe;
        color: #1e40af;
    }
    .action-btn {
        width: 32px;
        height: 32px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        border-radius: 50%;
    }
    .amount-cell {
        font-family: 'Inter', 'Segoe UI', system-ui, -apple-system, sans-serif;
        font-weight: 700;
        letter-spacing: -0.025em;
        color: #1e40af;
        font-size: 0.95rem;
    }
    .empty-state {
        padding: 4rem 2rem;
        text-align: center;
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        border-radius: 1rem;
        margin: 2rem 0;
        border: 2px dashed #cbd5e1;
    }
    .empty-state i {
        font-size: 3rem;
        color: #94a3b8;
        margin-bottom: 1.5rem;
    }
    .table-header {
        background: linear-gradient(135deg, #1e40af 0%, #1e3a8a 100%);
        position: relative;
        overflow: hidden;
    }
    .table-header::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 2px;
        background: linear-gradient(90deg, #fbbf24 0%, #f59e0b 50%, #fbbf24 100%);
    }
    .table-header::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 1px;
        background: rgba(251, 191, 36, 0.3);
    }
    .table-header th {
        color: white;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        position: relative;
        z-index: 1;
    }
    .table-header th:hover {
        background: rgba(255, 255, 255, 0.1);
    }
    .table-row:hover {
        background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
    }
    .table-data {
        font-size: 0.75rem;
    }
    .table-data-small {
        font-size: 0.65rem;
    }
    .filter-select {
        background: white;
        border: 2px solid #e2e8f0;
        color: #000000;
    }
    .filter-select:focus {
        border-color: #1e40af;
        box-shadow: 0 0 0 3px rgba(30, 64, 175, 0.1);
    }
    .btn-primary {
        background: linear-gradient(135deg, #1e40af 0%, #1e3a8a 100%);
        border: none;
    }
    .btn-primary:hover {
        background: linear-gradient(135deg, #1e3a8a 0%, #1e2f5f 100%);
        box-shadow: 0 4px 12px rgba(30, 64, 175, 0.3);
    }
    .btn-success {
        background: linear-gradient(135deg, #16a34a 0%, #15803d 100%);
        border: none;
    }
    .btn-success:hover {
        background: linear-gradient(135deg, #15803d 0%, #166534 100%);
        box-shadow: 0 4px 12px rgba(22, 163, 74, 0.3);
    }
    .invoice-number {
        background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
        padding: 0.25rem 0.5rem;
        border-radius: 0.375rem;
        border-left: 3px solid #1e40af;
    }
    .customer-info {
        position: relative;
    }
    .customer-info::before {
        content: '';
        position: absolute;
        left: -8px;
        top: 50%;
        transform: translateY(-50%);
        width: 4px;
        height: 70%;
        background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%);
        border-radius: 2px;
    }
    .amount-display {
        background: linear-gradient(135deg, #f0f9ff 0%, #dbeafe 100%);
        padding: 0.5rem 0.75rem;
        border-radius: 0.5rem;
        border: 1px solid #bfdbfe;
        position: relative;
        overflow: hidden;
    }
    .amount-display::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.4), transparent);
        animation: shimmer 2s infinite;
    }
    .property-cell {
        background: linear-gradient(135deg, #fef3c7 0%, #fde68a 20%, transparent 20%);
        padding: 0.25rem 0.5rem;
        border-radius: 0.375rem;
    }

    @keyframes shimmer {
        0% { transform: translateX(-100%); }
        100% { transform: translateX(200%); }
    }
    
    /* Responsive table improvements */
    @media (max-width: 768px) {
        .table-responsive {
            font-size: 0.875rem;
        }
        .table-responsive th,
        .table-responsive td {
            padding: 0.5rem;
        }
        .table-responsive .dropdown-menu {
            min-width: 160px;
        }
        .invoice-header {
            padding: 1.5rem;
        }
        .invoice-header h1 {
            font-size: 1.875rem;
        }
    }
</style>
@endpush

@push('scripts')
<script>
    function toggleSendAllButton() {
        const periodSelect = document.getElementById('periodSelect');
        const sendAllBtn = document.getElementById('sendAllBtn');
        
        // Submit the form to apply the filter
        periodSelect.form.submit();
    }
    
    document.addEventListener('DOMContentLoaded', function() {
        const sendAllBtn = document.getElementById('sendAllBtn');
        const periodForm = document.getElementById('periodForm');
        
        // Create a hidden form for the send-all action
        const sendAllForm = document.createElement('form');
        sendAllForm.method = 'POST';
        sendAllForm.action = '{{ route("bills.utility.send-all") }}';
        sendAllForm.style.display = 'none';
        
        // Add CSRF token
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
        sendAllForm.appendChild(csrfToken);
        
        // Add period input
        const periodInput = document.createElement('input');
        periodInput.type = 'hidden';
        periodInput.name = 'period';
        periodInput.value = document.getElementById('periodSelect').value;
        sendAllForm.appendChild(periodInput);
        
        // Add form to the document
        document.body.appendChild(sendAllForm);
        
        if (sendAllBtn) {
            sendAllBtn.addEventListener('click', function(e) {
                e.preventDefault();
                if (confirm('Are you sure you want to send all bills for the selected period? This may take a while.')) {
                    // Update the period value before submission
                    sendAllForm.querySelector('input[name="period"]').value = document.getElementById('periodSelect').value;
                    sendAllForm.submit();
                }
            });
        }
    });
    
    // Function to toggle dropdown visibility
    function toggleDropdown(dropdownId) {
        const dropdown = document.getElementById(dropdownId);
        const isHidden = dropdown.classList.contains('hidden');
        
        // Close all dropdowns first
        document.querySelectorAll('[id^="dropdown-"]').forEach(el => {
            el.classList.add('hidden');
            el.classList.remove('show');
        });
        
        // Open the clicked dropdown if it was hidden
        if (isHidden) {
            dropdown.classList.remove('hidden');
            // Trigger animation
            setTimeout(() => {
                dropdown.classList.add('show');
            }, 10);
        }
    }
    
    // Function to show loading dialog
    function showLoadingDialog() {
        document.getElementById('loadingDialog').classList.remove('hidden');
        document.body.classList.add('overflow-hidden');
    }
    
    // Function to hide loading dialog
    function hideLoadingDialog() {
        document.getElementById('loadingDialog').classList.add('hidden');
        document.body.classList.remove('overflow-hidden');
    }
    document.addEventListener('click', function(event) {
        // Close dropdowns when clicking outside
        if (!event.target.closest('.dropdown-container')) {
            document.querySelectorAll('[id^="dropdown-"]').forEach(el => {
                el.classList.remove('show');
                // Add delay before hiding to allow animation to complete
                setTimeout(() => {
                    if (!el.classList.contains('show')) {
                        el.classList.add('hidden');
                    }
                }, 200);
            });
        }
    });
    
    // Handle Send Bill forms in dropdowns
    document.addEventListener('DOMContentLoaded', function() {
        const sendBillForms = document.querySelectorAll('.dropdown-item-form');
        sendBillForms.forEach(form => {
            form.addEventListener('submit', function(e) {
                e.preventDefault();
                showLoadingDialog();
                
                // Update loading dialog content for single bill
                const loadingTitle = document.querySelector('#loadingDialog h3');
                const loadingSubtitle = document.querySelector('#loadingDialog .text-blue-100.text-sm');
                const loadingText = document.querySelector('#loadingDialog .text-gray-800.font-semibold.text-lg');
                const loadingSubtext = document.querySelector('#loadingDialog .text-gray-600.text-sm');
                const infoText = document.querySelector('#loadingDialog .text-blue-600.text-xs');

                if (loadingTitle) loadingTitle.textContent = 'Sending Email';
                if (loadingSubtitle) loadingSubtitle.textContent = 'Processing your request...';
                if (loadingText) loadingText.textContent = 'Sending Bill to Customer';
                if (loadingSubtext) loadingSubtext.textContent = 'Please wait while we generate and send your invoice';
                if (infoText) infoText.textContent = 'Generating PDF and sending email...';
                
                // Submit the form after showing loading dialog
                setTimeout(() => {
                    form.submit();
                }, 100);
            });
        });
    });
    
    // Initialize tooltips
    document.addEventListener('DOMContentLoaded', function() {
        const tooltipElements = document.querySelectorAll('[data-tooltip]');
        tooltipElements.forEach(el => {
            const tooltip = document.createElement('div');
            tooltip.className = 'hidden md:block absolute z-10 py-1 px-2 text-xs font-medium text-white bg-gray-900 rounded-md shadow-lg opacity-0 group-hover:opacity-100 transition-opacity duration-200';
            tooltip.textContent = el.getAttribute('data-tooltip');
            
            const wrapper = document.createElement('div');
            wrapper.className = 'relative group';
            wrapper.appendChild(el.cloneNode(true));
            wrapper.appendChild(tooltip);
            
            el.parentNode.replaceChild(wrapper, el);
            
            // Position tooltip
            wrapper.addEventListener('mouseenter', () => {
                const rect = wrapper.getBoundingClientRect();
                tooltip.style.top = `${rect.top - 30}px`;
                tooltip.style.left = `${rect.left + (rect.width / 2) - (tooltip.offsetWidth / 2)}px`;
                tooltip.classList.remove('opacity-0');
                tooltip.classList.add('opacity-100');
            });
            
            wrapper.addEventListener('mouseleave', () => {
                tooltip.classList.remove('opacity-100');
                tooltip.classList.add('opacity-0');
            });
        });
    });
</script>
@endpush

@section('content')
<div class="py-6">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="invoice-card">
            <div class="invoice-header">
                <div class="flex flex-col md:flex-row md:items-center md:justify-between space-y-4 md:space-y-0">
                    <div class="flex flex-col space-y-3 sm:flex-row sm:items-center sm:space-y-0 sm:space-x-4">
                        <div>
                            <h1 class="text-3xl font-bold flex items-center">
                                <i class="fas fa-file-invoice-dollar mr-3"></i>
                                Utility Bills
                            </h1>
                            <p class="text-blue-100 mt-1">Manage and send utility bills to customers</p>
                        </div>

                        <div class="flex items-center space-x-3">
                            <form id="periodForm" method="GET" action="{{ route('bills.utility.index') }}" class="flex items-center space-x-2">
                                <div class="relative">
                                    <select name="period" id="periodSelect" onchange="toggleSendAllButton()" class="filter-select block w-48 pl-3 pr-10 py-2 text-sm rounded-md leading-tight">
                                        @foreach($billingPeriods as $key => $period)
                                            <option value="{{ $key }}" {{ $selectedPeriod == $key ? 'selected' : '' }}>{{ $period }}</option>
                                        @endforeach
                                    </select>
                                    <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-blue-500">
                                        <i class="fas fa-calendar-alt"></i>
                                    </div>
                                </div>
                                <noscript>
                                    <button type="submit" class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                        <i class="fas fa-filter mr-1"></i> Filter
                                    </button>
                                </noscript>
                            </form>

                            <button type="button" id="sendAllBtn" class="btn-success inline-flex items-center px-4 py-2 text-sm font-medium rounded-md shadow-sm disabled:opacity-50 disabled:cursor-not-allowed transition-colors duration-150" {{ $selectedPeriod == 'all' || !$selectedPeriod ? 'disabled' : '' }}>
                                <i class="fas fa-paper-plane mr-2"></i> Send All
                            </button>
                        </div>
                    </div>

                    <a href="{{ route('bills.utility.process') }}" class="btn-primary inline-flex items-center px-6 py-3 text-sm font-medium rounded-md shadow-sm transition-all duration-200">
                        <i class="fas fa-plus-circle mr-2"></i> Process New Bill
                    </a>
                </div>
            </div>

                <div class="table-responsive">
                    <table class="min-w-full divide-y divide-gray-200 rounded-lg overflow-hidden shadow-sm">
                        <thead class="table-header">
                            <tr>
                                <th scope="col" class="px-6 py-4 text-left text-xs uppercase tracking-wider">#</th>
                                <th scope="col" class="px-6 py-4 text-left text-xs uppercase tracking-wider">Bill #</th>
                                <th scope="col" class="px-6 py-4 text-left text-xs uppercase tracking-wider">Customer</th>
                                <th scope="px-6 py-4 text-left text-xs uppercase tracking-wider hidden md:table-cell">Period</th>
                                <th scope="col" class="px-6 py-4 text-left text-xs uppercase tracking-wider">Amount</th>
                                <th scope="col" class="px-6 py-4 text-left text-xs uppercase tracking-wider">Status</th>
                                <th scope="col" class="px-6 py-4 text-right text-xs uppercase tracking-wider pr-8">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-100">
                            @forelse ($bills as $bill)
                            <tr class="table-row hover:shadow-md transition-all duration-200">
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600 font-medium table-data">
                                    {{ $loop->iteration }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="invoice-number">
                                        <div class="text-sm font-bold text-gray-900 table-data">
                                            UTL-{{ str_pad($bill->BillID, 5, '0', STR_PAD_LEFT) }}
                                        </div>
                                        <div class="text-xs text-gray-500 flex items-center mt-1 table-data-small">
                                            <i class="fas fa-calendar mr-1 text-blue-400"></i>
                                            {{ \Carbon\Carbon::parse($bill->BillingDate)->format('M d, Y') }}
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="customer-info pl-4">
                                        <div class="text-sm font-semibold text-gray-900 table-data">
                                            {{ $bill->CustomerName }}
                                        </div>
                                        <div class="text-xs text-gray-500 flex items-center mt-1 table-data-small">
                                            <i class="fas fa-envelope mr-1 text-blue-400"></i>
                                            {{ $bill->CustomerEmail }}
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap hidden md:table-cell">
                                    <div class="period-info">
                                        <div class="text-sm font-semibold text-gray-900 table-data">
                                            {{ $bill->BillingPeriod }}
                                        </div>
                                        <div class="text-xs text-gray-500 flex items-center mt-1 table-data-small">
                                            <i class="fas fa-clock mr-1 text-orange-500"></i>
                                            Due: {{ \Carbon\Carbon::parse($bill->DueDate)->format('M d, Y') }}
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap amount-cell">
                                    <div class="amount-display">
                                        <div class="flex items-center">
                                            <span class="text-yellow-600 mr-1 font-bold table-data">KES</span>
                                            <span class="text-blue-700 table-data">{{ number_format($bill->TotalBill, 2) }}</span>
                                        </div>
                                        @if($bill->BalanceCF > 0)
                                            <div class="text-xs text-red-500 mt-1">Balance: {{ number_format($bill->BalanceCF, 2) }} KES</div>
                                        @endif
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($bill->BalanceCF <= 0)
                                        <span class="status-badge status-paid">
                                            <i class="fas fa-check-circle mr-1"></i>
                                            Paid
                                        </span>
                                    @elseif(\Carbon\Carbon::parse($bill->DueDate)->isPast())
                                        <span class="status-badge status-overdue">
                                            <i class="fas fa-exclamation-triangle mr-1"></i>
                                            Overdue
                                        </span>
                                    @else
                                        <span class="status-badge status-unpaid">
                                            <i class="fas fa-clock mr-1"></i>
                                            Pending
                                        </span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium pr-8 table-actions">
                                    <div class="dropdown-container relative">
                                        <button type="button"
                                                class="action-btn bg-gradient-to-r from-blue-600 to-blue-700 text-yellow-400 hover:from-blue-700 hover:to-blue-800 inline-flex items-center justify-center w-8 h-8 rounded-full shadow-md hover:shadow-lg transition-all duration-200 transform hover:scale-105 border border-blue-500"
                                                onclick="toggleDropdown('dropdown-{{ $bill->BillID }}')"
                                                data-tooltip="Actions">
                                            <i class="fas fa-chevron-down text-sm"></i>
                                        </button>

                                        <div id="dropdown-{{ $bill->BillID }}" class="dropdown-menu hidden absolute right-0 z-50 w-48 origin-top-right bg-white divide-y divide-gray-100 rounded-lg shadow-xl ring-1 ring-black ring-opacity-5 focus:outline-none border border-gray-200" style="right: 0; left: auto; min-width: 180px; top: 100%; margin-top: 0; z-index: 9999; position: absolute;">
                                            <div class="py-1">
                                                <a href="{{ route('bills.utility.show', $bill->BillID) }}"
                                                   class="dropdown-item flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gradient-to-r hover:from-blue-50 hover:to-blue-100 hover:text-blue-700 transition-all duration-150">
                                                    <i class="fas fa-eye mr-3 h-4 w-4 text-blue-500"></i>
                                                    View Details
                                                </a>
                                                <a href="{{ route('bills.utility.download', $bill->BillID) }}"
                                                   class="dropdown-item flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gradient-to-r hover:from-green-50 hover:to-green-100 hover:text-green-700 transition-all duration-150"
                                                   target="_blank" rel="noopener noreferrer">
                                                    <i class="fas fa-download mr-3 h-4 w-4 text-green-500"></i>
                                                    Download Bill
                                                </a>
                                                <form action="{{ route('bills.utility.send', $bill->BillID) }}" method="POST" class="dropdown-item-form">
                                                    @csrf
                                                    <button type="submit"
                                                            class="dropdown-item flex items-center w-full px-4 py-2 text-sm text-gray-700 hover:bg-gradient-to-r hover:from-purple-50 hover:to-purple-100 hover:text-purple-700 transition-all duration-150">
                                                        <i class="fas fa-paper-plane mr-3 h-4 w-4 text-purple-500"></i>
                                                        Send Bill
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="px-6 py-12 text-center">
                                    <div class="empty-state">
                                        <div class="inline-flex items-center justify-center w-20 h-20 bg-blue-100 rounded-full mb-4">
                                            <i class="fas fa-file-invoice-dollar text-3xl text-blue-500"></i>
                                        </div>
                                        <h3 class="text-xl font-bold text-gray-900 mb-2">No utility bills found</h3>
                                        <p class="text-sm text-gray-600 max-w-md mx-auto mb-6">Get started by processing your first utility bill or adjust your filters to see existing bills.</p>
                                        <a href="{{ route('bills.utility.process') }}" class="btn-primary inline-flex items-center px-6 py-3 text-sm font-medium rounded-md shadow-sm">
                                            <i class="fas fa-plus-circle mr-2"></i> Process New Bill
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                @if($bills->hasPages())
                <div class="mt-6 px-6 pb-6">
                    {{ $bills->links() }}
                </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Loading Dialog -->
<div id="loadingDialog" class="fixed inset-0 bg-black bg-opacity-50 overflow-y-auto h-full w-full hidden z-50 backdrop-blur-sm">
    <div class="relative top-20 mx-auto p-0 border-0 rounded-2xl shadow-2xl bg-white max-w-md w-full mx-4 transform transition-all animate-pulse">
        <!-- Modal Header with Gradient -->
        <div class="bg-gradient-to-r from-blue-600 to-blue-700 rounded-t-2xl px-6 py-5 border-b border-blue-800">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-white bg-opacity-20 rounded-full p-3 mr-4 animate-bounce">
                        <i class="fas fa-paper-plane text-white text-xl"></i>
                    </div>
                    <div>
                        <h3 class="text-xl font-bold text-white mb-1">Sending Email</h3>
                        <p class="text-blue-100 text-sm">Processing your request...</p>
                    </div>
                </div>
                <div class="animate-spin rounded-full h-8 w-8 border-2 border-white border-t-transparent"></div>
            </div>
        </div>

        <!-- Modal Body -->
        <div class="px-6 py-8 bg-gradient-to-b from-white to-gray-50">
            <div class="flex flex-col items-center space-y-4">
                <!-- Main Spinner -->
                <div class="relative">
                    <div class="w-16 h-16 border-4 border-blue-200 rounded-full animate-spin"></div>
                    <div class="absolute top-0 left-0 w-16 h-16 border-4 border-blue-600 rounded-full animate-spin border-t-transparent"></div>
                    <div class="absolute top-2 left-2 w-12 h-12 border-4 border-blue-300 rounded-full animate-spin border-b-transparent"></div>
                </div>

                <!-- Status Text -->
                <div class="text-center space-y-2">
                    <p class="text-gray-800 font-semibold text-lg">Sending Bill to Customer</p>
                    <p class="text-gray-600 text-sm">Please wait while we generate and send your invoice</p>
                    <div class="flex items-center justify-center space-x-2 mt-3">
                        <div class="w-2 h-2 bg-blue-600 rounded-full animate-pulse"></div>
                        <div class="w-2 h-2 bg-blue-600 rounded-full animate-pulse" style="animation-delay: 0.2s"></div>
                        <div class="w-2 h-2 bg-blue-600 rounded-full animate-pulse" style="animation-delay: 0.4s"></div>
                    </div>
                </div>

                <!-- Progress Bar -->
                <div class="w-full bg-gray-200 rounded-full h-2 overflow-hidden">
                    <div class="bg-gradient-to-r from-blue-500 to-blue-600 h-2 rounded-full animate-pulse" style="width: 60%; animation: shimmer 2s infinite;"></div>
                </div>

                <!-- Additional Info -->
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 w-full">
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-info-circle text-blue-600"></i>
                        <div class="text-sm">
                            <p class="text-blue-800 font-medium">This may take a few moments</p>
                            <p class="text-blue-600 text-xs">Generating PDF and sending email...</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Footer -->
        <div class="px-6 py-4 bg-gray-100 rounded-b-2xl border-t border-gray-200">
            <div class="flex items-center justify-between">
                <p class="text-xs text-gray-500">
                    <i class="fas fa-lock mr-1"></i>
                    Secure transaction in progress
                </p>
                <div class="flex items-center space-x-1">
                    <div class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></div>
                    <span class="text-xs text-green-600 font-medium">Active</span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Custom CSS for animations -->
<style>
    @keyframes shimmer {
        0% { transform: translateX(-100%); }
        100% { transform: translateX(200%); }
    }
    .animate-shimmer {
        animation: shimmer 2s infinite;
    }
    
    /* Responsive table improvements */
    @media (max-width: 768px) {
        .table-responsive {
            font-size: 0.875rem;
        }
        .table-responsive th,
        .table-responsive td {
            padding: 0.5rem;
        }
        .table-responsive .dropdown-menu {
            min-width: 160px;
        }
    }
</style>

@endsection
