@extends('layouts.app')

@push('scripts')
<script>
    function toggleSendAllButton() {
        const periodSelect = document.getElementById('periodSelect');
        const sendAllBtn = document.getElementById('sendAllBtn');

        // Submit the form to apply the filter
        periodSelect.form.submit();
    }

    document.addEventListener('DOMContentLoaded', function() {
        const sendAllBtn = document.getElementById('sendAllBtn');
        const periodForm = document.getElementById('periodForm');

        // Create a hidden form for the send-all action
        const sendAllForm = document.createElement('form');
        sendAllForm.method = 'POST';
        sendAllForm.action = '{{ route("bills.water.send-all") }}';
        sendAllForm.style.display = 'none';

        // Add CSRF token
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
        sendAllForm.appendChild(csrfToken);

        // Add period input
        const periodInput = document.createElement('input');
        periodInput.type = 'hidden';
        periodInput.name = 'period';
        periodInput.value = document.getElementById('periodSelect').value;
        sendAllForm.appendChild(periodInput);

        // Add form to the document
        document.body.appendChild(sendAllForm);

        if (sendAllBtn) {
            sendAllBtn.addEventListener('click', function(e) {
                e.preventDefault();
                if (confirm('Are you sure you want to send all water bills for the selected period? This may take a while.')) {
                    // Update the period value before submission
                    sendAllForm.querySelector('input[name="period"]').value = document.getElementById('periodSelect').value;
                    sendAllForm.submit();
                }
            });
        }
    });
</script>
@endpush

@section('content')
<div class="py-6">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 bg-white border-b border-gray-200">
                <!-- Header Section -->
                <div class="bg-white rounded-lg shadow-sm mb-8 p-6 border border-gray-100">
                    <div class="flex flex-col md:flex-row md:items-center md:justify-between space-y-4 md:space-y-0">
                        <div class="flex flex-col space-y-3 sm:flex-row sm:items-center sm:space-y-0 sm:space-x-4">
                            <h1 class="text-2xl font-bold text-gray-800 flex items-center">
                                <i class="fas fa-tint text-blue-600 mr-2"></i>
                                Water Bills
                            </h1>

                            <div class="flex items-center space-x-3">
                                <form id="periodForm" method="GET" action="{{ route('bills.water.index') }}" class="flex items-center space-x-2">
                                    <div class="relative">
                                        <select name="period" id="periodSelect" onchange="toggleSendAllButton()" class="block w-48 pl-3 pr-10 py-2 text-sm border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 bg-white">
                                            @foreach($billingPeriods as $key => $period)
                                                <option value="{{ $key }}" {{ $selectedPeriod == $key ? 'selected' : '' }}>{{ $period }}</option>
                                            @endforeach
                                        </select>
                                        <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-700">
                                            <i class="fas fa-chevron-down text-sm"></i>
                                        </div>
                                    </div>
                                    <noscript>
                                        <button type="submit" class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                            <i class="fas fa-filter mr-1"></i> Filter
                                        </button>
                                    </noscript>
                                </form>

                                <button type="button" id="sendAllBtn" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 disabled:opacity-50 disabled:cursor-not-allowed transition-colors duration-150" {{ $selectedPeriod == 'all' || !$selectedPeriod ? 'disabled' : '' }}>
                                    <i class="fas fa-paper-plane mr-2"></i> Send All
                                </button>
                            </div>
                        </div>

                        <a href="{{ route('bills.water.process') }}" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors duration-150">
                            <i class="fas fa-plus-circle mr-2"></i> Process New Bill
                        </a>
                    </div>
                </div>

                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Bill #</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Customer</th>
                                <!-- <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Property</th> -->
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Period</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse ($bills as $bill)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">WTR-{{ str_pad($bill->BillID, 5, '0', STR_PAD_LEFT) }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <div class="font-medium">{{ $bill->CustomerName }}</div>
                                    <div class="text-gray-500 text-xs">{{ $bill->CustomerEmail }}</div>
                                </td>
                                <!-- <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ $bill->PropertyName ?? 'N/A' }}
                                </td> -->
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ $bill->BillingPeriod }}
                                    <div class="text-xs text-gray-500">Due: {{ \Carbon\Carbon::parse($bill->DueDate)->format('M d, Y') }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ number_format($bill->TotalBill, 2) }} KES
                                    @if($bill->BalanceCF > 0)
                                        <div class="text-xs text-red-500">Balance: {{ number_format($bill->BalanceCF, 2) }} KES</div>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($bill->BalanceCF <= 0)
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                            Paid
                                        </span>
                                    @elseif(\Carbon\Carbon::parse($bill->DueDate)->isPast())
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800">
                                            Overdue
                                        </span>
                                    @else
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                            Pending
                                        </span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <a href="{{ route('bills.water.show', $bill->BillID) }}" class="text-indigo-600 hover:text-indigo-900">View</a>
                                    <a href="{{ route('bills.water.download', $bill->BillID) }}" target="_blank" class="ml-2 text-blue-600 hover:text-blue-900">Print</a>
                                    <form action="{{ route('bills.water.send', $bill->BillID) }}" method="POST" class="inline-block ml-2">
                                        @csrf
                                        <button type="submit" class="text-green-600 hover:text-green-900 focus:outline-none" onclick="return confirm('Are you sure you want to send this water bill to the customer?')">
                                            Send
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="px-6 py-4 text-center text-sm text-gray-500">
                                    No water bills found.
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                @if($bills->hasPages())
                <div class="mt-4">
                    {{ $bills->links() }}
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
