@csrf

<div class="row mb-3">
    <div class="col-md-6">
        <label for="BlockName" class="form-label">Block Name *</label>
        <input type="text" class="form-control @error('BlockName') is-invalid @enderror" 
               id="BlockName" name="BlockName" 
               value="{{ old('BlockName', $block->BlockName ?? '') }}" required>
        @error('BlockName')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
    
    <div class="col-md-6">
        <label for="BlockCode" class="form-label">Block Code *</label>
        <input type="text" class="form-control @error('BlockCode') is-invalid @enderror" 
               id="BlockCode" name="BlockCode" 
               value="{{ old('BlockCode', $block->BlockCode ?? '') }}" required>
        <small class="form-text text-muted">Short code for the block (e.g., BLDG-A)</small>
        @error('BlockCode')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
</div>

<div class="row mb-3">
    <div class="col-md-6">
        <label for="Floors" class="form-label">Number of Floors *</label>
        <input type="number" class="form-control @error('Floors') is-invalid @enderror" 
               id="Floors" name="Floors" min="1" max="100" 
               value="{{ old('Floors', $block->Floors ?? '1') }}" required>
        @error('Floors')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
    
    <div class="col-md-6">
        <label for="UnitsPerFloor" class="form-label">Units per Floor *</label>
        <input type="number" class="form-control @error('UnitsPerFloor') is-invalid @enderror" 
               id="UnitsPerFloor" name="UnitsPerFloor" min="1" max="100" 
               value="{{ old('UnitsPerFloor', $block->UnitsPerFloor ?? '1') }}" required>
        @error('UnitsPerFloor')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
</div>

<div class="mb-3">
    <div class="form-check">
        <input class="form-check-input" type="checkbox" id="HasLift" name="HasLift" 
               value="1" @if(old('HasLift', $block->HasLift ?? false)) checked @endif>
        <label class="form-check-label" for="HasLift">
            Has Elevator/Lift
        </label>
    </div>
</div>

<div class="mb-3">
    <label for="BlockStatus" class="form-label">Status *</label>
    <select class="form-select @error('BlockStatus') is-invalid @enderror" 
            id="BlockStatus" name="BlockStatus" required>
        <option value="Active" @if(old('BlockStatus', $block->BlockStatus ?? '') === 'Active') selected @endif>Active</option>
        <option value="Inactive" @if(old('BlockStatus', $block->BlockStatus ?? '') === 'Inactive') selected @endif>Inactive</option>
    </select>
    @error('BlockStatus')
        <div class="invalid-feedback">{{ $message }}</div>
    @enderror
</div>

<div class="mb-3">
    <label for="Description" class="form-label">Description</label>
    <textarea class="form-control @error('Description') is-invalid @enderror" 
              id="Description" name="Description" rows="3">{{ old('Description', $block->Description ?? '') }}</textarea>
    @error('Description')
        <div class="invalid-feedback">{{ $message }}</div>
    @enderror
</div>
