@extends('layouts.app')

@section('title', 'Add New Block - ' . $property->PropName)

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('properties.index') }}">Properties</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('properties.blocks.index', $property->PropID) }}">{{ $property->PropName }} Blocks</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Add New Block</li>
                </ol>
            </nav>
            <h1>Add New Block - {{ $property->PropName }}</h1>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('properties.blocks.store', $property->PropID) }}" method="POST">
                @include('blocks._form')
                
                <div class="d-flex justify-content-between mt-4">
                    <a href="{{ route('properties.blocks.index', $property->PropID) }}" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left"></i> Cancel
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Save Block
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
