@extends('layouts.app')

@section('title', 'Edit Block - ' . $block->BlockName)

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('properties.index') }}">Properties</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('properties.blocks.index', $property->PropID) }}">{{ $property->PropName }} Blocks</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Edit {{ $block->BlockName }}</li>
                </ol>
            </nav>
            <h1>Edit Block - {{ $block->BlockName }}</h1>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('properties.blocks.update', ['property' => $property->PropID, 'block' => $block->BlockID]) }}" method="POST">
                @csrf
                @method('PUT')
                @include('blocks._form')
                
                <div class="d-flex justify-content-between mt-4">
                    <a href="{{ route('properties.blocks.show', ['property' => $property->PropID, 'block' => $block->BlockID]) }}" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left"></i> Cancel
                    </a>
                    <div>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Update Block
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
