@extends('layouts.app')

@section('title', 'Blocks - ' . $property->PropName)

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col">
            <h1>Blocks - {{ $property->PropName }}</h1>
        </div>
        <div class="col-auto">
            <a href="{{ route('properties.blocks.create', $property->PropID) }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add Block
            </a>
            <a href="{{ route('properties.index') }}" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left"></i> Back to Properties
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>Block Name</th>
                            <th>Code</th>
                            <th>Floors</th>
                            <th>Units/Floor</th>
                            <th>Total Units</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($blocks as $block)
                            <tr>
                                <td>{{ $block->BlockName }}</td>
                                <td>{{ $block->BlockCode }}</td>
                                <td>{{ $block->Floors }}</td>
                                <td>{{ $block->UnitsPerFloor }}</td>
                                <td>{{ $block->Floors * $block->UnitsPerFloor }}</td>
                                <td>
                                    <span class="badge bg-{{ $block->BlockStatus === 'Active' ? 'success' : 'secondary' }}">
                                        {{ $block->BlockStatus }}
                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="{{ route('properties.blocks.show', ['property' => $property->PropID, 'block' => $block->BlockID]) }}" 
                                           class="btn btn-sm btn-outline-primary" 
                                           title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('properties.blocks.edit', ['property' => $property->PropID, 'block' => $block->BlockID]) }}" 
                                           class="btn btn-sm btn-outline-secondary" 
                                           title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('properties.blocks.destroy', ['property' => $property->PropID, 'block' => $block->BlockID]) }}" 
                                              method="POST" 
                                              class="d-inline"
                                              onsubmit="return confirm('Are you sure you want to delete this block? This action cannot be undone.');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center">No blocks found. <a href="{{ route('properties.blocks.create', $property->PropID) }}">Create one now</a>.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($blocks->hasPages())
            <div class="card-footer">
                {{ $blocks->links() }}
            </div>
        @endif
    </div>
</div>
@endsection
