<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Block Report - {{ $block->BlockName }}</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 10px; }
        .header { text-align: center; margin-bottom: 20px; }
        .header h1 { margin: 0; color: #1e3a8a; font-size: 18px; }
        .logo { max-width: 100px; max-height: 50px; margin-bottom: 10px; }
        .section { margin-bottom: 15px; page-break-inside: avoid; }
        .section-title { 
            background-color: #1e3a8a; 
            color: white; 
            padding: 5px 10px; 
            font-weight: bold; 
            margin-bottom: 10px;
            font-size: 12px;
        }
        table { width: 100%; border-collapse: collapse; margin-bottom: 10px; font-size: 9px; }
        th { background-color: #f3f4f6; text-align: left; padding: 5px; border: 1px solid #e5e7eb; }
        td { padding: 4px; border: 1px solid #e5e7eb; }
        .summary-box { 
            background: #f8fafc; 
            border: 1px solid #e2e8f0; 
            padding: 10px; 
            margin-bottom: 10px; 
            border-radius: 4px;
        }
        .status-badge {
            display: inline-block;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 9px;
            font-weight: 600;
            text-transform: uppercase;
        }
        .status-occupied { background-color: #dcfce7; color: #166534; }
        .status-vacant { background-color: #fef3c7; color: #92400e; }
        .status-maintenance { background-color: #fee2e2; color: #991b1b; }
        .footer { 
            position: fixed; 
            bottom: 0; 
            left: 0; 
            right: 0; 
            text-align: center; 
            font-size: 8px; 
            color: #6b7280;
            border-top: 1px solid #e5e7eb;
            padding: 3px 0;
        }
        .page-break { page-break-after: always; }
    </style>
</head>
<body>
    <div class="header">
        @if(file_exists(public_path('logo/sulis.jpg')))
            <img src="{{ public_path('logo/sulis.jpg') }}" alt="Logo" class="logo">
        @endif
        <h1>BLOCK REPORT</h1>
        <div style="display: flex; justify-content: space-between; max-width: 600px; margin: 0 auto; text-align: left; font-size: 9px;">
            <div style="flex: 1;">
                <p><strong>Property:</strong> {{ $property->PropertyName }}</p>
                <p><strong>Location:</strong> {{ $property->City ?? 'N/A' }}</p>
            </div>
            <div style="flex: 1;">
                <p><strong>Block:</strong> {{ $block->BlockName }} ({{ $block->BlockCode }})</p>
                <p><strong>Generated:</strong> {{ now()->format('M j, Y h:i A') }}</p>
            </div>
        </div>
    </div>

    <div class="section">
        <div class="section-title">Block Information & Occupancy Overview</div>
        <div style="display: flex; flex-wrap: nowrap; gap: 15px; margin-bottom: 10px;">
            <div class="summary-box" style="flex: 1;">
                <h3 style="margin-top: 0; font-size: 11px; color: #1e3a8a; border-bottom: 1px solid #e2e8f0; padding-bottom: 5px;">Block Details</h3>
                <table style="margin: 0; font-size: 9px; border: none;">
                    <tr>
                        <td style="width: 40%; border: none; padding: 2px 0;"><strong>Block Name:</strong></td>
                        <td style="border: none; padding: 2px 0;">{{ $block->BlockName }}</td>
                    </tr>
                    <tr>
                        <td style="border: none; padding: 2px 0;"><strong>Block Code:</strong></td>
                        <td style="border: none; padding: 2px 0;">{{ $block->BlockCode }}</td>
                    </tr>
                    <tr>
                        <td style="border: none; padding: 2px 0;"><strong>Floors:</strong></td>
                        <td style="border: none; padding: 2px 0;">{{ $block->Floors }}</td>
                    </tr>
                    <tr>
                        <td style="border: none; padding: 2px 0;"><strong>Total Units:</strong></td>
                        <td style="border: none; padding: 2px 0;">{{ $total_units }}</td>
                    </tr>
                </table>
            </div>
            
            <div class="summary-box" style="flex: 1;">
                <h3 style="margin-top: 0; font-size: 11px; color: #1e3a8a; border-bottom: 1px solid #e2e8f0; padding-bottom: 5px;">Occupancy Overview</h3>
                <table style="margin: 0; font-size: 9px; border: none;">
                    <tr>
                        <td style="border: none; padding: 2px 0;"><strong>Occupied:</strong></td>
                        <td style="border: none; padding: 2px 0; text-align: right;">
                            {{ $units->where('OccupationStatus', 'Occupied')->count() }} 
                            ({{ $total_units > 0 ? number_format(($units->where('OccupationStatus', 'Occupied')->count() / $total_units) * 100, 1) : 0 }}%)
                        </td>
                    </tr>
                    <tr>
                        <td style="border: none; padding: 2px 0;"><strong>Vacant:</strong></td>
                        <td style="border: none; padding: 2px 0; text-align: right;">
                            {{ $units->where('OccupationStatus', 'Vacant')->count() }}
                            ({{ $total_units > 0 ? number_format(($units->where('OccupationStatus', 'Vacant')->count() / $total_units) * 100, 1) : 0 }}%)
                        </td>
                    </tr>
                    <tr>
                        <td style="border: none; padding: 2px 0;"><strong>Under Maintenance:</strong></td>
                        <td style="border: none; padding: 2px 0; text-align: right;">
                            {{ $units->where('OccupationStatus', 'Under Maintenance')->count() }}
                            ({{ $total_units > 0 ? number_format(($units->where('OccupationStatus', 'Under Maintenance')->count() / $total_units) * 100, 1) : 0 }}%)
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

    <!-- Financial Overview -->
    <div class="section">
        <div class="section-title">Financial Overview</div>
        <div style="display: flex; justify-content: space-between; margin-bottom: 15px; gap: 15px;">
            <div style="flex: 1; background-color: #f0f7ff; padding: 12px; border-radius: 5px; border-left: 4px solid #1e3a8a; min-width: 0;">
                <div style="font-size: 9px; color: #4b5563; margin-bottom: 5px;">Total Billed</div>
                <div style="font-size: 14px; font-weight: bold; color: #1e3a8a; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">Ksh {{ number_format($paymentSummary['total_billed'] ?? 0, 2) }}</div>
            </div>
            <div style="flex: 1; background-color: #f0fdf4; padding: 12px; border-radius: 5px; border-left: 4px solid #166534; min-width: 0;">
                <div style="font-size: 9px; color: #4b5563; margin-bottom: 5px;">Total Received</div>
                <div style="font-size: 14px; font-weight: bold; color: #166534; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">Ksh {{ number_format($paymentSummary['total_paid'] ?? 0, 2) }}</div>
            </div>
            <div style="flex: 1; background-color: #fffbeb; padding: 12px; border-radius: 5px; border-left: 4px solid #92400e; min-width: 0;">
                <div style="font-size: 9px; color: #4b5563; margin-bottom: 5px;">Pending Payments</div>
                <div style="font-size: 14px; font-weight: bold; color: #92400e; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">{{ $paymentSummary['pending_payments'] ?? 0 }} <span style="font-size: 10px; font-weight: normal;">bills</span></div>
            </div>
        </div>

        <!-- Recent Payments -->
        @if(isset($recentPayments) && count($recentPayments) > 0)
        <div style="margin-top: 15px;">
            <div style="font-weight: bold; margin-bottom: 5px; font-size: 10px; color: #1e3a8a;">RECENT PAYMENTS</div>
            <table>
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Unit</th>
                        <th>Amount</th>
                        <th>Receipt #</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($recentPayments as $payment)
                    <tr>
                        <td>{{ \Carbon\Carbon::parse($payment->PaymentDate)->format('M j, Y') }}</td>
                        <td>{{ $payment->UnitIdentity ?? 'N/A' }}</td>
                        <td>Ksh {{ number_format($payment->TotalPayment, 2) }}</td>
                        <td>{{ $payment->ReceiptNo ?? 'N/A' }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @endif
    </div>

    <!-- Block Statistics -->
    <div class="section">
        <div class="section-title">Block Statistics</div>
        <div style="display: flex; gap: 20px; margin-bottom: 15px;">
            <div style="flex: 1;">
                <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                    <span style="font-size: 9px;">Occupancy Rate</span>
                    <span style="font-weight: bold; font-size: 11px;">{{ number_format($occupancyRate, 1) }}%</span>
                </div>
                <div style="height: 8px; background-color: #e5e7eb; border-radius: 4px; overflow: hidden;">
                    <div style="height: 100%; width: {{ $occupancyRate }}%; background: linear-gradient(90deg, #1e3a8a, #3b82f6);"></div>
                </div>
                <div style="font-size: 9px; color: #6b7280; margin-top: 3px;">
                    {{ $occupiedUnits ?? 0 }} of {{ $total_units }} units occupied
                </div>
            </div>
        </div>
        
        <div style="display: flex; gap: 15px; margin-top: 15px;">
            <div style="flex: 1; text-align: center; padding: 10px; background-color: #f9fafb; border-radius: 5px;">
                <div style="font-size: 9px; color: #6b7280; margin-bottom: 5px;">Total Units</div>
                <div style="font-size: 24px; font-weight: bold; color: #1e3a8a;">{{ $total_units }}</div>
            </div>
            <div style="flex: 1; text-align: center; padding: 10px; background-color: #f9fafb; border-radius: 5px;">
                <div style="font-size: 9px; color: #6b7280; margin-bottom: 5px;">Occupied Units</div>
                <div style="font-size: 24px; font-weight: bold; color: #166534;">{{ $occupiedUnits ?? 0 }}</div>
            </div>
            <div style="flex: 1; text-align: center; padding: 10px; background-color: #f9fafb; border-radius: 5px;">
                <div style="font-size: 9px; color: #6b7280; margin-bottom: 5px;">Vacant Units</div>
                <div style="font-size: 24px; font-weight: bold; color: #92400e;">{{ $total_units - ($occupiedUnits ?? 0) }}</div>
            </div>
        </div>
    </div>

    <!-- Unit Directory -->
    <div class="section">
        <div class="section-title">Unit Directory</div>
        <table>
            <thead>
                <tr>
                    <th style="width: 10%;">Unit ID</th>
                    <th style="width: 20%;">Unit Name</th>
                    <th style="width: 10%;">Floor</th>
                    <th style="width: 15%;">Status</th>
                    <th style="width: 15%;">Monthly Rent</th>
                    <th style="width: 30%;">Details</th>
                </tr>
            </thead>
            <tbody>
                @foreach($units as $unit)
                    <tr>
                        <td>{{ $unit->UnitID }}</td>
                        <td><strong>{{ $unit->UnitIdentity }}</strong></td>
                        <td>{{ $unit->FloorNo }}</td>
                        <td>
                            @php
                                $statusClass = match($unit->OccupationStatus) {
                                    'Occupied' => 'status-occupied',
                                    'Vacant' => 'status-vacant',
                                    'Under Maintenance' => 'status-maintenance',
                                    default => ''
                                };
                            @endphp
                            <span class="status-badge {{ $statusClass }}">{{ $unit->OccupationStatus }}</span>
                        </td>
                        <td style="text-align: right;">KSh {{ number_format($unit->MonthlyRent, 2) }}</td>
                        <td>
                            @if($unit->UnitDesc)
                                <div style="font-size: 8px; color: #6b7280;">{{ Str::limit($unit->UnitDesc, 50) }}</div>
                            @else
                                <span style="color: #9ca3af; font-style: italic; font-size: 8px;">No description</span>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <div class="footer">
        <p>Report generated on {{ now()->format('F j, Y \a\t h:i A') }} • Page <span class="page-number"></span></p>
    </div>

    <script type="text/php">
        if (isset($pdf)) {
            $text = "Page {PAGE_NUM} of {PAGE_COUNT}";
            $size = 8;
            $font = $fontMetrics->getFont("DejaVu Sans");
            $width = $fontMetrics->get_text_width($text, $font, $size) / 2;
            $x = ($pdf->get_width() - $width) / 2;
            $y = $pdf->get_height() - 15;
            $pdf->page_text($x, $y, $text, $font, $size);
        }
    </script>
</body>
</html>
