@extends('layouts.app')
@section('content')
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Block Report - {{ $block->BlockName }}</title>
    <style>
        @page { margin: 1cm; }
        body { 
            font-family: 'Arial', sans-serif; 
            font-size: 12px; 
            color: #333;
            line-height: 1.4;
        }
        .header { 
            text-align: center; 
            margin-bottom: 20px;
            border-bottom: 3px solid #1e3a8a;
            padding-bottom: 15px;
        }
        .header h1 { 
            margin: 5px 0; 
            font-size: 24px; 
            color: #1e3a8a;
            font-weight: 700;
        }
        .header p { 
            margin: 3px 0; 
            color: #4b5563;
            font-size: 13px;
        }
        .section { 
            margin-bottom: 25px;
            page-break-inside: avoid;
        }
        .section-title { 
            background-color: #1e3a8a; 
            color: white;
            padding: 8px 12px; 
            font-weight: 600; 
            margin: 15px 0 10px;
            border-radius: 4px;
            font-size: 14px;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            margin: 10px 0 20px;
            font-size: 11px;
        }
        th { 
            background-color: #f0f4f8; 
            color: #1e3a8a;
            text-align: left; 
            padding: 10px 8px; 
            border: 1px solid #d1d5db;
            font-weight: 600;
        }
        td { 
            padding: 8px; 
            border: 1px solid #e5e7eb;
            vertical-align: top;
        }
        tr:nth-child(even) {
            background-color: #f9fafb;
        }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        .summary-box { 
            display: inline-block; 
            width: 48%; 
            margin-right: 2%;
            margin-bottom: 15px;
            vertical-align: top;
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            padding: 10px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.05);
        }
        .summary-box h3 {
            margin: 0 0 10px 0;
            padding-bottom: 5px;
            border-bottom: 1px solid #e2e8f0;
            color: #1e3a8a;
            font-size: 13px;
        }
        .footer { 
            margin-top: 40px; 
            text-align: center; 
            font-size: 10px; 
            color: #6b7280;
            border-top: 1px solid #e5e7eb;
            padding-top: 10px;
            font-style: italic;
        }
        .logo {
            max-width: 200px;
            margin: 0 auto 10px;
            display: block;
        }
        .status-badge {
            display: inline-block;
            padding: 3px 8px;
            border-radius: 12px;
            font-size: 10px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        .status-occupied { background-color: #dcfce7; color: #166534; }
        .status-vacant { background-color: #fef3c7; color: #92400e; }
        .status-maintenance { background-color: #fee2e2; color: #991b1b; }
        .highlight-box {
            background: #f0f9ff;
            border-left: 4px solid #0ea5e9;
            padding: 12px;
            margin: 15px 0;
            border-radius: 0 4px 4px 0;
        }
    </style>
</head>
<body>
    <div class="header">
        @if(file_exists(public_path('logo/sulis.jpg')))
            <img src="{{ asset('logo/sulispmslogo.png') }}" alt="Logo" class="logo">
        @else
            <div style="text-align: center; padding: 10px; background: #f3f4f6; border: 1px dashed #d1d5db; border-radius: 4px; margin-bottom: 10px;">
                <p style="color: #6b7280; font-style: italic; margin: 0;">Logo not found</p>
            </div>
        @endif
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <h1>BLOCK REPORT</h1>
            <a href="{{ route('properties.blocks.export-pdf', ['property' => $property->PropID, 'block' => $block->BlockID]) }}" 
               class="export-pdf-btn" 
               style="background-color: #1e3a8a; color: white; padding: 8px 16px; border-radius: 4px; text-decoration: none; font-size: 14px; display: inline-flex; align-items: center; gap: 8px;"
               target="_blank">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                    <polyline points="7 10 12 15 17 10"></polyline>
                    <line x1="12" y1="15" x2="12" y2="3"></line>
                </svg>
                Export as PDF
            </a>
        </div>
        <div style="display: flex; justify-content: space-between; max-width: 600px; margin: 0 auto; text-align: left;">
            <div style="flex: 1;">
                <p><strong>Property:</strong> {{ $property->PropertyName }}</p>
                <p><strong>Location:</strong> {{ $property->City ?? 'N/A' }}</p>
            </div>
            <div style="flex: 1;">
                <p><strong>Block:</strong> {{ $block->BlockName }} ({{ $block->BlockCode }})</p>
                <p><strong>Generated:</strong> {{ now()->format('M j, Y h:i A') }}</p>
            </div>
        </div>
    </div>
    
  

    <div class="section">
        <div class="section-title">Block Information & Occupancy Overview</div>
        <div style="display: flex; flex-wrap: nowrap; gap: 20px;">
            <div class="summary-box" style="flex: 1;">
                <h3>Block Details</h3>
                <table style="margin: 0;">
                    <tr>
                        <td style="width: 40%; border: none; padding: 4px 0;"><strong>Block Name:</strong></td>
                        <td style="border: none; padding: 4px 0;">{{ $block->BlockName }}</td>
                    </tr>
                    <tr>
                        <td style="border: none; padding: 4px 0;"><strong>Block Code:</strong></td>
                        <td style="border: none; padding: 4px 0;">{{ $block->BlockCode }}</td>
                    </tr>
                    <tr>
                        <td style="border: none; padding: 4px 0;"><strong>Description:</strong></td>
                        <td style="border: none; padding: 4px 0;">{{ $block->Description ?: 'N/A' }}</td>
                    </tr>
                    <tr>
                        <td style="border: none; padding: 4px 0;"><strong>Floors:</strong></td>
                        <td style="border: none; padding: 4px 0;">{{ $block->Floors }}</td>
                    </tr>
                    <tr>
                        <td style="border: none; padding: 4px 0;"><strong>Units/Floor:</strong></td>
                        <td style="border: none; padding: 4px 0;">{{ $block->UnitsPerFloor }}</td>
                    </tr>
                    <tr>
                        <td style="border: none; padding: 4px 0;"><strong>Total Capacity:</strong></td>
                        <td style="border: none; padding: 4px 0;"><strong>{{ $block->Floors * $block->UnitsPerFloor }} units</strong></td>
                    </tr>
                </table>
            </div>
            
            <div class="summary-box" style="flex: 1;">
                <h3>Occupancy Overview</h3>
                <table style="margin: 0;">
                    <tr>
                        <td style="border: none; padding: 4px 0;"><strong>Total Units:</strong></td>
                        <td style="border: none; padding: 4px 0; text-align: right;">{{ $total_units }}</td>
                    </tr>
                    <tr>
                        <td style="border: none; padding: 4px 0;"><strong>Occupied:</strong></td>
                        <td style="border: none; padding: 4px 0; text-align: right;">
                            {{ $block->units->where('OccupationStatus', 'Occupied')->count() }} 
                            <span style="color: #6b7280; font-size: 90%;">
                                ({{ $total_units > 0 ? number_format(($block->units->where('OccupationStatus', 'Occupied')->count() / $total_units) * 100, 1) : 0 }}%)
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td style="border: none; padding: 4px 0;"><strong>Vacant:</strong></td>
                        <td style="border: none; padding: 4px 0; text-align: right;">
                            {{ $block->units->where('OccupationStatus', 'Vacant')->count() }}
                            <span style="color: #6b7280; font-size: 90%;">
                                ({{ $total_units > 0 ? number_format(($block->units->where('OccupationStatus', 'Vacant')->count() / $total_units) * 100, 1) : 0 }}%)
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td style="border: none; padding: 4px 0;"><strong>Under Maintenance:</strong></td>
                        <td style="border: none; padding: 4px 0; text-align: right;">
                            {{ $block->units->where('OccupationStatus', 'Under Maintenance')->count() }}
                            <span style="color: #6b7280; font-size: 90%;">
                                ({{ $total_units > 0 ? number_format(($block->units->where('OccupationStatus', 'Under Maintenance')->count() / $total_units) * 100, 1) : 0 }}%)
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td style="border: none; padding: 4px 0;"><strong>Occupancy Rate:</strong></td>
                        <td style="border: none; padding: 4px 0; text-align: right;">
                            <strong>{{ number_format($occupancy_rate, 1) }}%</strong>
                        </td>
                    </tr>
                </table>
                
                <div style="margin-top: 10px; background: #f1f5f9; border-radius: 4px; height: 8px; overflow: hidden;">
                    @php
                        $occupiedPct = $total_units > 0 ? ($block->units->where('OccupationStatus', 'Occupied')->count() / $total_units) * 100 : 0;
                    @endphp
                    <div style="width: {{ $occupiedPct }}%; height: 100%; background: linear-gradient(90deg, #1e3a8a, #3b82f6);"></div>
                </div>
                <div style="display: flex; justify-content: space-between; margin-top: 3px; font-size: 9px; color: #6b7280;">
                    <span>0%</span>
                    <span>50%</span>
                    <span>100%</span>
                </div>
            </div>
            
            
        </div>
    </div>

    <div class="section">
        <div style="display: flex; gap: 20px; align-items: flex-start;">
            <div style="flex: 2;">
                <div class="section-title" style="font-size: 14px; margin-bottom: 10px;">Unit Directory</div>
        <table>
            <thead>
                <tr>
                    <th style="width: 10%;">Unit ID</th>
                    <th style="width: 25%;">Unit Name</th>
                    <th style="width: 10%;">Floor</th>
                    <th style="width: 15%;">Status</th>
                    <th style="width: 15%;">Monthly Rent</th>
                    <th style="width: 25%;">Details</th>
                </tr>
            </thead>
            <tbody>
                @forelse($units as $unit)
                    <tr>
                        <td>{{ $unit->UnitID }}</td>
                        <td><strong>{{ $unit->UnitIdentity }}</strong></td>
                        <td>{{ $unit->FloorNo }}</td>
                        <td>
                            @php
                                $statusClass = match($unit->OccupationStatus) {
                                    'Occupied' => 'status-occupied',
                                    'Vacant' => 'status-vacant',
                                    'Under Maintenance' => 'status-maintenance',
                                    default => ''
                                };
                            @endphp
                            <span class="status-badge {{ $statusClass }}">{{ $unit->OccupationStatus }}</span>
                        </td>
                        <td class="text-right">KSh {{ number_format($unit->MonthlyRent, 2) }}</td>
                        <td>
                            @if($unit->UnitDesc)
                                <div style="font-size: 10px; color: #6b7280;">{{ Str::limit($unit->UnitDesc, 50) }}</div>
                            @else
                                <span style="color: #9ca3af; font-style: italic;">No description</span>
                            @endif
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" style="text-align: center; padding: 20px 0;">No units found for this block.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
        
        @if($units->hasPages())
        <div class="pagination" style="margin-top: 20px; display: flex; justify-content: center; gap: 10px;">
            @if($units->onFirstPage())
                <span style="padding: 5px 10px; border: 1px solid #e2e8f0; color: #94a3b8; border-radius: 4px;">Previous</span>
            @else
                <a href="{{ $units->previousPageUrl() }}" style="padding: 5px 10px; border: 1px solid #1e3a8a; color: #1e3a8a; text-decoration: none; border-radius: 4px;">Previous</a>
            @endif
            
            @foreach(range(1, $units->lastPage()) as $page)
                @if($page == $units->currentPage())
                    <span style="padding: 5px 10px; background: #1e3a8a; color: white; border-radius: 4px;">{{ $page }}</span>
                @else
                    <a href="{{ $units->url($page) }}" style="padding: 5px 10px; border: 1px solid #e2e8f0; color: #1e3a8a; text-decoration: none; border-radius: 4px;">{{ $page }}</a>
                @endif
            @endforeach
            
            @if($units->hasMorePages())
                <a href="{{ $units->nextPageUrl() }}" style="padding: 5px 10px; border: 1px solid #1e3a8a; color: #1e3a8a; text-decoration: none; border-radius: 4px;">Next</a>
            @else
                <span style="padding: 5px 10px; border: 1px solid #e2e8f0; color: #94a3b8; border-radius: 4px;">Next</span>
            @endif
        </div>
        @endif
            </div>

            @if($block->units->isNotEmpty())
            <div style="flex: 1;">
                <div class="section-title" style="font-size: 14px; margin-bottom: 10px;">Summary Statistics</div>
        <div style="display: flex; flex-wrap: wrap; gap: 15px; margin-bottom: 20px;">
            <div style="flex: 1; min-width: 200px; background: #f8fafc; border: 1px solid #e2e8f0; border-radius: 6px; padding: 15px;">
                <div style="font-size: 12px; color: #4b5563; margin-bottom: 5px;">AVERAGE MONTHLY RENT</div>
                <div style="font-size: 24px; font-weight: 700; color: #1e3a8a;">
                    KSh {{ number_format($block->units->avg('MonthlyRent'), 2) }}
                </div>
                <div style="font-size: 10px; color: #6b7280; margin-top: 3px;">
                    across {{ $block->units->count() }} units
                </div>
            </div>
            
            <div style="flex: 1; min-width: 200px; background: #f8fafc; border: 1px solid #e2e8f0; border-radius: 6px; padding: 15px;">
                <div style="font-size: 12px; color: #4b5563; margin-bottom: 5px;">TEST</div>
                <div style="font-size: 24px; font-weight: 700; color: #1e3a8a;">
                    KSh {{ number_format($block->units->where('OccupationStatus', 'Occupied')->sum('MonthlyRent'), 2) }}
                </div>
                <div style="font-size: 10px; color: #6b7280; margin-top: 3px;">
                    potential monthly revenue
                </div>
            </div>
            
            <div style="flex: 1; min-width: 200px; background: #f8fafc; border: 1px solid #e2e8f0; border-radius: 6px; padding: 15px;">
                <div style="font-size: 12px; color: #4b5563; margin-bottom: 5px;">VACANCY RATE</div>
                <div style="font-size: 24px; font-weight: 700; color: #1e3a8a;">
                    {{ number_format(100 - $occupancy_rate, 1) }}%
                </div>
                <div style="font-size: 10px; color: #6b7280; margin-top: 3px;">
                    {{ $block->units->where('OccupationStatus', 'Vacant')->count() }} units available
                </div>
            </div>
            @endif
        </div>
    </div>

    <!-- <div class="footer">
        <p>Report generated on {{ now()->format('F j, Y \a\t h:i A') }} by {{ auth()->user()->name ?? 'System' }} • {{ config('app.name') }}</p>
        <p style="font-size: 9px; color: #9ca3af; margin-top: 3px;">
            This is a computer-generated report. Please verify critical information.
        </p>
    </div> -->
</body>
</html>
@endSection()
