@extends('layouts.app')

@section('title', $block->BlockName . ' - ' . $property->PropName)

@section('content')
<style>
    .sulis-card {
        border: none;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        transition: transform 0.3s ease, box-shadow 0.3s ease, border-color 0.3s ease;
        margin-bottom: 25px;
        border-top: 4px solid #0056b3;
        overflow: hidden;
    }
    .sulis-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 15px rgba(0, 0, 0, 0.1);
    }
    .sulis-card .card-header {
        background: linear-gradient(135deg, #f8f9fa, #e9ecef);
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        font-weight: 600;
        color: #0056b3;
        padding: 1.25rem 1.5rem;
        border-top-left-radius: 8px !important;
        border-top-right-radius: 8px !important;
    }
    .card-body {
        padding: 1.75rem 1.5rem;
    }
    
    .list-group-item {
        border-left: none;
        border-right: none;
        padding: 1rem 1.5rem;
        transition: all 0.2s ease;
        border-bottom: 1px solid rgba(0, 0, 0, 0.03);
    }
    .list-group-item:hover {
        background-color: #f8f9fa;
        padding-left: 25px;
    }
    .btn-sulis {
        background: #0056b3;
        color: white;
        border: none;
        padding: 8px 16px;
        transition: all 0.3s ease;
    }
    .btn-sulis:hover {
        background: #003d82;
        color: #FFD700;
        transform: translateY(-2px);
    }
    .progress {
        height: 8px;
        border-radius: 4px;
    }
    .progress-bar {
        background: linear-gradient(90deg, #0056b3, #003d82);
    }
    .badge-sulis {
        background: #FFD700;
        color: #000;
        font-weight: 500;
        padding: 5px 10px;
        border-radius: 4px;
    }
    .breadcrumb {
        background: #f1f3f5;
        padding: 0.85rem 1.5rem;
        border-radius: 8px;
        margin-bottom: 1.5rem !important;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.03);
    }
    .breadcrumb-item a {
        color: #0056b3;
        text-decoration: none;
    }
    .breadcrumb-item.active {
        color: #6c757d;
    }
    .feature-icon {
        width: 3rem;
        height: 3rem;
        border-radius: 0.75rem;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 1rem;
    }
    .feature-card {
        transition: all 0.3s ease;
        height: 100%;
    }
    .feature-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
    }
</style>

<div class="container-fluid">
    <div class="row mb-4">
        <div class="col">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-3">
                    <li class="breadcrumb-item"><a href="{{ route('properties.index') }}"><i class="fas fa-home me-1"></i>Properties</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('properties.blocks.index', $property->PropID) }}">{{ $property->PropName }} Blocks</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ $block->BlockName }}</li>
                </ol>
            </nav>
            <div class="d-flex justify-content-between align-items-center mb-4 pt-2">
                <div>
                    <h1 class="h3 mb-0">{{ $block->BlockName }} <span class="badge badge-sulis">{{ $block->BlockCode }}</span></h1>
                    <p class="text-muted mb-0">{{ $property->PropName }}</p>
                </div>
                <div class="btn-group">
                    <a href="{{ route('properties.blocks.edit', ['property' => $property->PropID, 'block' => $block->BlockID]) }}" 
                       class="btn btn-sulis me-2">
                        <i class="fas fa-edit me-1"></i> Edit Block
                    </a>
                    <a href="{{ route('properties.blocks.index', $property->PropID) }}" 
                       class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left me-1"></i> Back to Blocks
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i> {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <div class="row">
        <div class="col-lg-8">
            <!-- Bills & Payments Overview -->
            <div class="sulis-card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0"><i class="fas fa-file-invoice-dollar me-2" style="color: #0056b3;"></i>Bills & Payments</h5>
                    <span class="badge bg-{{ $block->BlockStatus === 'Active' ? 'success' : 'secondary' }} rounded-pill">
                        <i class="fas fa-{{ $block->BlockStatus === 'Active' ? 'check' : 'pause' }}-circle me-1"></i> {{ $block->BlockStatus }}
                    </span>
                </div>
                <div class="card-body">
                    <!-- Summary Cards -->
                    <div class="row g-4 mb-4">
                        <div class="col-md-4">
                            <div class="card border-0 bg-soft-primary h-100">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h6 class="text-muted small mb-1">Total Billed</h6>
                                            <h4 class="mb-0">Ksh {{ number_format($paymentSummary['total_billed'], 2) }}</h4>
                                        </div>
                                        <div class="bg-primary bg-opacity-10 p-3 rounded">
                                            <i class="fas fa-file-invoice text-primary"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card border-0 bg-soft-success h-100">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h6 class="text-muted small mb-1">Total Received</h6>
                                            <h4 class="mb-0">Ksh {{ number_format($paymentSummary['total_paid'], 2) }}</h4>
                                        </div>
                                        <div class="bg-success bg-opacity-10 p-3 rounded">
                                            <i class="fas fa-check-circle text-success"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card border-0 bg-soft-warning h-100">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h6 class="text-muted small mb-1">Pending Payments</h6>
                                            <h4 class="mb-0">{{ $paymentSummary['pending_payments'] }} <small class="text-muted">bills</small></h4>
                                        </div>
                                        <div class="bg-warning bg-opacity-10 p-3 rounded">
                                            <i class="fas fa-clock text-warning"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Recent Bills -->
                    <div class="mb-4">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h6 class="mb-0">Recent Bills</h6>
                            <a href="{{ route('invoices.rent.index') }}?block_id={{ $block->BlockID }}" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-list me-1"></i> View All
                            </a>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-sm table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>Bill #</th>
                                        <th>Unit</th>
                                        <th>Amount</th>
                                        <th>Due Date</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($recentBills as $bill)
                                    <tr>
                                        <td>#{{ $bill->BillID }}</td>
                                        <td>{{ $bill->UnitIdentity ?? 'N/A' }}</td>
                                        <td>Ksh {{ number_format($bill->TotalAmount, 2) }}</td>
                                        <td>{{ \Carbon\Carbon::parse($bill->DueDate ?? $bill->BillingDate)->format('M d, Y') }}</td>
                                        <td>
                                            @php
                                                $statusClass = [
                                                    'paid' => 'success',
                                                    'overdue' => 'danger',
                                                    'pending' => 'warning',
                                                    'partial' => 'info'
                                                ][strtolower($bill->BillStatus)] ?? 'secondary';
                                            @endphp
                                            <span class="badge bg-{{ $statusClass }}">
                                                {{ ucfirst(strtolower($bill->BillStatus)) }}
                                            </span>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="5" class="text-center text-muted py-3">No bills found for this block</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Recent Payments -->
                    <div>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h6 class="mb-0">Recent Payments</h6>
                            <a href="{{ route('payments.index') }}?block_id={{ $block->BlockID }}" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-list me-1"></i> View All
                            </a>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-sm table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>Payment #</th>
                                        <th>Unit</th>
                                        <th>Bill #</th>
                                        <th>Amount</th>
                                        <th>Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($recentPayments as $payment)
                                    <tr>
                                        <td>#{{ $payment->id }}</td>
                                        <td>{{ $payment->UnitIdentity ?? 'N/A' }}</td>
                                        <td>#{{ $payment->bill_number }}</td>
                                        <td>Ksh {{ number_format($payment->amount, 2) }}</td>
                                        <td>{{ \Carbon\Carbon::parse($payment->payment_date)->format('M d, Y') }}</td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="5" class="text-center text-muted py-3">No payment records found</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Maintenance Requests -->
            <div class="sulis-card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0"><i class="fas fa-tools me-2" style="color: #dc3545;"></i>Maintenance Requests</h5>
                    <a href="{{ route('maintenance-requests.index') }}?block_id={{ $block->BlockID }}" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="card-body">
                    @if($recentMaintenanceRequests->isEmpty())
                        <div class="text-center py-4">
                            <i class="fas fa-tools fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No recent maintenance requests found</p>
                        </div>
                    @else
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Unit</th>
                                        <th>Issue</th>
                                        <th>Status</th>
                                        <th>Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($recentMaintenanceRequests as $request)
                                    <tr>
                                        <td>{{ $request->unit->UnitIdentity ?? 'N/A' }}</td>
                                        <td>{{ $request->title }}</td>
                                        <td>
                                            @php
                                                $statusClass = [
                                                    'Pending' => 'bg-secondary',
                                                    'In Progress' => 'bg-warning text-dark',
                                                    'Scheduled' => 'bg-info',
                                                    'Completed' => 'bg-success',
                                                    'Cancelled' => 'bg-danger',
                                                ][$request->status] ?? 'bg-secondary';
                                            @endphp
                                            <span class="badge {{ $statusClass }}">{{ $request->status }}</span>
                                        </td>
                                        <td>{{ $request->created_at->diffForHumans() }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @endif
                    <div class="text-end mt-3">
                        <a href="{{ route('maintenance-requests.create') }}?block_id={{ $block->BlockID }}" class="btn btn-sm btn-outline-primary">
                            <i class="fas fa-plus me-1"></i> New Request
                        </a>
                    </div>
                </div>
            </div>

            <!-- Upcoming Rent Due -->
            <div class="sulis-card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0"><i class="fas fa-calendar-alt me-2" style="color: #28a745;"></i>Upcoming Rent Due</h5>
                </div>
                <div class="card-body p-0">
                    @if($upcomingRentDues->isEmpty())
                        <div class="text-center py-4">
                            <i class="fas fa-check-circle fa-2x text-success mb-2"></i>
                            <p class="mb-0 text-muted">No upcoming rent dues</p>
                        </div>
                    @else
                        <div class="list-group list-group-flush">
                            @foreach($upcomingRentDues as $rentDue)
                                <div class="list-group-item">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h6 class="mb-0">{{ $rentDue->unit }}</h6>
                                            <small class="text-muted">{{ $rentDue->dueText }}</small>
                                        </div>
                                        <div class="text-end">
                                            <div class="fw-bold">Ksh {{ $rentDue->amount }}</div>
                                            <span class="badge {{ $rentDue->badgeClass }}">
                                                {{ $rentDue->status }}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="card-footer text-center">
                            <a href="{{ route('payments.index') }}?block_id={{ $block->BlockID }}" class="text-primary">
                                <i class="fas fa-list me-1"></i> View All Payments
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="sulis-card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0"><i class="fas fa-bolt me-2" style="color: #FFD700;"></i>Quick Actions</h5>
                </div>
                <div class="list-group list-group-flush">
                    <a href="{{ route('properties.blocks.units.create', ['property' => $property->PropID, 'block' => $block->BlockID]) }}" 
                       class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                        <span><i class="fas fa-plus-circle me-2" style="color: #28a745;"></i> Add Unit to Block</span>
                        <span class="badge bg-primary rounded-pill">{{ $block->units_count ?? 0 }}/{{ $block->Floors * $block->UnitsPerFloor }}</span>
                    </a>
                    <a href="{{ route('properties.blocks.export-pdf', ['property' => $property->PropID, 'block' => $block->BlockID]) }}" 
                       class="list-group-item list-group-item-action" target="_blank">
                        <i class="fas fa-file-pdf me-2" style="color: #dc3545;"></i> Generate Block Report
                    </a>
                    <a href="{{ route('properties.blocks.units.index', ['property' => $property->PropID, 'block' => $block->BlockID]) }}" 
                       class="list-group-item list-group-item-action">
                        <i class="fas fa-list-ul me-2" style="color: #17a2b8;"></i> View All Units
                    </a>
                </div>
            </div>

            <div class="sulis-card">
                <div class="card-header">
                    <h5 class="card-title mb-0"><i class="fas fa-chart-pie me-2" style="color: #0056b3;"></i>Block Statistics</h5>
                </div>
                <div class="card-body">
                    <div class="mb-4 pt-2">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <h6 class="mb-0">Occupancy Rate</h6>
                            <span class="fw-bold">75%</span>
                        </div>
                        <div class="progress mb-3">
                            <div class="progress-bar" role="progressbar" style="width: 75%;" 
                                 aria-valuenow="75" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                        
                        <div class="d-flex justify-content-between text-center py-3">
                            <div>
                                <div class="text-muted small">Total Units</div>
                                <div class="fw-bold">{{ $block->Floors * $block->UnitsPerFloor }}</div>
                            </div>
                            <div class="vr mx-2"></div>
                            <div>
                                <div class="text-muted small">Occupied</div>
                                <div class="fw-bold text-success">{{ round(($block->Floors * $block->UnitsPerFloor) * 0.75) }}</div>
                            </div>
                            <div class="vr mx-2"></div>
                            <div>
                                <div class="text-muted small">Vacant</div>
                                <div class="fw-bold text-warning">{{ round(($block->Floors * $block->UnitsPerFloor) * 0.25) }}</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="d-grid pt-2">
                        <a href="#" class="btn btn-outline-primary mb-3">
                            <i class="fas fa-chart-line me-2"></i>View Detailed Analytics
                        </a>
                    </div>

                    <!-- Quick Stats -->
                    <div class="row g-3 mt-2">
                        <div class="col-6">
                            <div class="card feature-card border-0 shadow-sm h-100">
                                <div class="card-body text-center">
                                    <div class="feature-icon bg-soft-primary text-primary mx-auto">
                                        <i class="fas fa-users fs-4"></i>
                                    </div>
                                    <h5 class="h5 mb-1">{{ $block->units_count ?? 0 }}</h5>
                                    <p class="text-muted small mb-0">Total Tenants</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="card feature-card border-0 shadow-sm h-100">
                                <div class="card-body text-center">
                                    <div class="feature-icon bg-soft-success text-success mx-auto">
                                        <i class="fas fa-shield-alt fs-4"></i>
                                    </div>
                                    <h5 class="h5 mb-1">3</h5>
                                    <p class="text-muted small mb-0">Security Staff</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="card feature-card border-0 shadow-sm h-100">
                                <div class="card-body text-center">
                                    <div class="feature-icon bg-soft-warning text-warning mx-auto">
                                        <i class="fas fa-tools fs-4"></i>
                                    </div>
                                    <h5 class="h5 mb-1">2</h5>
                                    <p class="text-muted small mb-0">Active Issues</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="card feature-card border-0 shadow-sm h-100">
                                <div class="card-body text-center">
                                    <div class="feature-icon bg-soft-info text-info mx-auto">
                                        <i class="fas fa-file-invoice-dollar fs-4"></i>
                                    </div>
                                    <h5 class="h5 mb-1">5</h5>
                                    <p class="text-muted small mb-0">Pending Invoices</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
