@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8 space-y-6">
    <!-- Company Information Card -->
    <div class="bg-white shadow-lg rounded-lg overflow-hidden">
        <div class="bg-gradient-to-r from-sulis-blue to-sulis-blue-dark px-6 py-4">
            <h1 class="text-2xl font-bold text-white">
                <i class="fas fa-building mr-2"></i>Company Information
            </h1>
            <p class="text-sulis-yellow mt-1">Manage your company details and contact information</p>
        </div>

        <form action="{{ url('company/update-info') }}" method="POST" enctype="multipart/form-data" class="p-6">
            @csrf
            @method('PATCH')

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Company Name -->
                <div class="md:col-span-2">
                    <label for="company_name" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-building mr-2 text-sulis-blue"></i>Official Company Name
                    </label>
                    <input type="text"
                           name="CompanyName"
                           id="company_name"
                           value="{{ $company->CompanyName }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-sulis-blue focus:border-transparent"
                           required>
                </div>

                <!-- Contact Person -->
                <div>
                    <label for="contact_person" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-user mr-2 text-sulis-blue"></i>Primary Contact Person
                    </label>
                    <input type="text"
                           name="ContactPerson"
                           id="contact_person"
                           value="{{ $company->ContactPerson }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-sulis-blue focus:border-transparent">
                </div>

                <!-- Email -->
                <div>
                    <label for="company_email" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-envelope mr-2 text-sulis-blue"></i>Business Email Address
                    </label>
                    <input type="email"
                           name="Email"
                           id="company_email"
                           value="{{ $company->Email }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-sulis-blue focus:border-transparent">
                </div>

                <!-- Telephone -->
                <div>
                    <label for="telephone" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-phone mr-2 text-sulis-blue"></i>Business Telephone Number
                    </label>
                    <input type="tel"
                           name="TelNo"
                           id="telephone"
                           value="{{ $company->TelNo }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-sulis-blue focus:border-transparent">
                </div>

                <!-- Address 1 -->
                <div>
                    <label for="address1" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-map-marker-alt mr-2 text-sulis-blue"></i>Business Address Line 1
                    </label>
                    <input type="text"
                           name="Address1"
                           id="address1"
                           value="{{ $company->Address1 }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-sulis-blue focus:border-transparent"
                           placeholder="Street address, P.O. box, company name">
                </div>

                <!-- Address 2 -->
                <div>
                    <label for="address2" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-map-marker-alt mr-2 text-sulis-blue"></i>Business Address Line 2
                    </label>
                    <input type="text"
                           name="Address2"
                           id="address2"
                           value="{{ $company->Address2 }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-sulis-blue focus:border-transparent"
                           placeholder="Apartment, suite, unit, building, floor">
                </div>

                <!-- Cheque Payable To -->
                <div>
                    <label for="cheque_payable_to" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-money-check mr-2 text-sulis-blue"></i>Cheque Payable To
                    </label>
                    <input type="text"
                           name="ChequePayableTo"
                           id="cheque_payable_to"
                           value="{{ $company->ChequePayableTo }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-sulis-blue focus:border-transparent"
                           placeholder="Name to appear on cheques (e.g., company name or authorized signatory)">
                </div>
            </div>

            <!-- Logo Section at Bottom -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-6 pt-6 border-t border-gray-200">
                <!-- Current Logo Display -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-image mr-2 text-sulis-blue"></i>Current Company Logo
                    </label>
                    <div class="flex items-center space-x-4 p-4 border border-gray-200 rounded-md bg-gray-50">
                        @if($company->CompanyLogo && file_exists(public_path('logo/' . $company->CompanyLogo)))
                            <img src="{{ asset('logo/' . $company->CompanyLogo) }}" 
                                 alt="Company Logo" 
                                 class="w-16 h-16 object-contain rounded border">
                            <div>
                                <p class="text-sm font-medium text-gray-900">{{ $company->CompanyLogo }}</p>
                                <p class="text-xs text-gray-500">Current logo file</p>
                            </div>
                        @else
                            <div class="w-16 h-16 bg-gray-200 rounded border flex items-center justify-center">
                                <i class="fas fa-building text-gray-400 text-2xl"></i>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-gray-900">No logo uploaded</p>
                                <p class="text-xs text-gray-500">Upload a logo below</p>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Logo Upload -->
                <div>
                    <label for="company_logo" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-upload mr-2 text-sulis-blue"></i>Upload New Logo
                    </label>
                    <div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-md hover:border-sulis-blue transition-colors">
                        <div class="space-y-1 text-center">
                            <i class="fas fa-cloud-upload-alt text-gray-400 text-3xl mb-2"></i>
                            <div class="flex text-sm text-gray-600">
                                <label for="company_logo" class="relative cursor-pointer bg-white rounded-md font-medium text-sulis-blue hover:text-sulis-blue-dark focus-within:outline-none focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-sulis-blue">
                                    <span>Upload a file</span>
                                    <input id="company_logo" 
                                           name="CompanyLogo" 
                                           type="file" 
                                           accept="image/*"
                                           class="sr-only">
                                </label>
                                <p class="pl-1">or drag and drop</p>
                            </div>
                            <p class="text-xs text-gray-500">
                                PNG, JPG, GIF up to 2MB
                            </p>
                        </div>
                    </div>
                    <p class="mt-2 text-sm text-gray-500">
                        Recommended: 200x200px, square format. Will be displayed in sidebar and reports.
                    </p>
                </div>
            </div>

            <!-- Save Button -->
            <div class="flex justify-end mt-6 pt-4 border-t border-gray-200">
                <button type="submit"
                        class="px-6 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-sulis-blue hover:bg-sulis-blue-dark focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-sulis-yellow">
                    <i class="fas fa-save mr-2"></i>Save Company Information & Logo
                </button>
            </div>
        </form>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Main Settings Card -->
        <div class="bg-white shadow-lg rounded-lg overflow-hidden">
            <!-- Header -->
            <div class="bg-gradient-to-r from-sulis-blue to-sulis-blue-dark px-6 py-4">
                <h1 class="text-2xl font-bold text-white">
                    <i class="fas fa-envelope mr-2"></i>Email & SMS Templates Configuration
                </h1>
                <p class="text-sulis-yellow mt-1">Configure automated email and SMS message templates for bill notifications and customer communications</p>
            </div>

            <!-- Form -->
            <form action="{{ route('company.settings.update') }}" method="POST" class="p-6 space-y-6">
                @csrf
            
            <!-- Email Subject Template -->
            <div>
                <label for="email_subject_template" class="block text-sm font-medium text-gray-700 mb-2">
                    <i class="fas fa-heading mr-2 text-sulis-blue"></i>Bill Notification Email Subject Line
                    @if($company->email_subject_template)
                        <span class="text-xs text-green-600 ml-2">(Saved)</span>
                    @else
                        <span class="text-xs text-gray-500 ml-2">(Default)</span>
                    @endif
                </label>
                <input type="text" 
                       name="email_subject_template" 
                       id="email_subject_template" 
                       value="{{ $company->email_subject_template ?? $defaultSubjectTemplate }}"
                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-sulis-blue focus:border-transparent"
                       placeholder="Enter email subject template">
                <p class="mt-2 text-sm text-gray-500">
                    Available variables: <code class="bg-gray-100 px-1 py-0.5 rounded">{bill_id}</code>, 
                    <code class="bg-gray-100 px-1 py-0.5 rounded">{billing_period}</code>, 
                    <code class="bg-gray-100 px-1 py-0.5 rounded">{company_name}</code>
                </p>
            </div>

            <!-- Email Message Template -->
            <div>
                <label for="email_message_template" class="block text-sm font-medium text-gray-700 mb-2">
                    <i class="fas fa-envelope mr-2 text-sulis-blue"></i>Bill Notification Email Message Body
                    @if($company->email_message_template)
                        <span class="text-xs text-green-600 ml-2">(Saved)</span>
                    @else
                        <span class="text-xs text-gray-500 ml-2">(Default)</span>
                    @endif
                </label>
                <textarea name="email_message_template" 
                          id="email_message_template" 
                          rows="8"
                          class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-sulis-blue focus:border-transparent"
                          placeholder="Enter email message template">{{ $company->email_message_template ?? $defaultEmailTemplate }}</textarea>
                <p class="mt-2 text-sm text-gray-500">
                    Available variables: 
                    <code class="bg-gray-100 px-1 py-0.5 rounded">{customer_name}</code>, 
                    <code class="bg-gray-100 px-1 py-0.5 rounded">{bill_id}</code>, 
                    <code class="bg-gray-100 px-1 py-0.5 rounded">{billing_period}</code>, 
                    <code class="bg-gray-100 px-1 py-0.5 rounded">{account_number}</code>, 
                    <code class="bg-gray-100 px-1 py-0.5 rounded">{total_amount}</code>, 
                    <code class="bg-gray-100 px-1 py-0.5 rounded">{company_name}</code>
                </p>
            </div>

            <!-- SMS Message Template -->
            <div>
                <label for="sms_message_template" class="block text-sm font-medium text-gray-700 mb-2">
                    <i class="fas fa-sms mr-2 text-sulis-blue"></i>Bill Notification SMS Message
                    @if($company->sms_message_template)
                        <span class="text-xs text-green-600 ml-2">(Saved)</span>
                    @else
                        <span class="text-xs text-gray-500 ml-2">(Default)</span>
                    @endif
                </label>
                <textarea name="sms_message_template" 
                          id="sms_message_template" 
                          rows="4"
                          class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-sulis-blue focus:border-transparent"
                          placeholder="Enter SMS message template">{{ $company->sms_message_template ?? $defaultSmsTemplate }}</textarea>
                <p class="mt-2 text-sm text-gray-500">
                    Available variables: 
                    <code class="bg-gray-100 px-1 py-0.5 rounded">{customer_name}</code>, 
                    <code class="bg-gray-100 px-1 py-0.5 rounded">{bill_id}</code>, 
                    <code class="bg-gray-100 px-1 py-0.5 rounded">{billing_period}</code>, 
                    <code class="bg-gray-100 px-1 py-0.5 rounded">{account_number}</code>, 
                    <code class="bg-gray-100 px-1 py-0.5 rounded">{total_amount}</code>, 
                    <code class="bg-gray-100 px-1 py-0.5 rounded">{company_name}</code>
                </p>
            </div>

            <!-- Action Buttons -->
            <div class="flex justify-end space-x-3 pt-4 border-t border-gray-200">
                <a href="{{ route('dashboard') }}" 
                   class="px-4 py-2 border border-gray-300 rounded-md text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-sulis-blue">
                    Cancel
                </a>
                <button type="submit" 
                        class="px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-sulis-blue hover:bg-sulis-blue-dark focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-sulis-yellow">
                    <i class="fas fa-save mr-2"></i>Save Email & SMS Templates
                </button>
            </div>
        </form>
    </div>

    <!-- Preview Section - Separate Card -->
    <div class="bg-white shadow-lg rounded-lg overflow-hidden">
        <div class="bg-gradient-to-r from-sulis-yellow to-sulis-yellow-dark px-6 py-4">
            <h2 class="text-xl font-bold text-sulis-blue">
                <i class="fas fa-eye mr-2"></i>Live Template Preview
            </h2>
            <p class="text-sulis-gray mt-1">Preview how your customized email and SMS templates will appear to customers with sample data</p>
        </div>

        <div class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <p class="text-sm font-medium text-gray-700 mb-2">Email Subject Line Preview:</p>
                    <div class="bg-white p-3 rounded border border-gray-200 text-sm">
                        <span id="subject-preview">{{ $company->email_subject_template ?? $defaultSubjectTemplate }}</span>
                    </div>
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-700 mb-2">SMS Preview:</p>
                    <div class="bg-white p-3 rounded border border-gray-200 text-sm">
                        <span id="sms-preview">{{ $company->sms_message_template ?? $defaultSmsTemplate }}</span>
                    </div>
                </div>
            </div>
            <div class="mt-4">
                <p class="text-sm font-medium text-gray-700 mb-2">Email Message Body Preview:</p>
                <div class="bg-white p-3 rounded border border-gray-200 text-sm whitespace-pre-line">
                    <span id="email-preview">{{ $company->email_message_template ?? $defaultEmailTemplate }}</span>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const emailTextarea = document.getElementById('email_message_template');
    const smsTextarea = document.getElementById('sms_message_template');
    const subjectInput = document.getElementById('email_subject_template');
    const emailPreview = document.getElementById('email-preview');
    const smsPreview = document.getElementById('sms-preview');
    const subjectPreview = document.getElementById('subject-preview');

    // Sample data for preview
    const sampleData = {
        customer_name: 'John Doe',
        bill_id: '20250501033',
        billing_period: '202505',
        account_number: 'CUST-12345',
        total_amount: 'KES 89,000.00',
        company_name: '{{ config("app.name") }}'
    };

    function updatePreview() {
        // Update email preview
        let emailText = emailTextarea.value;
        Object.keys(sampleData).forEach(key => {
            emailText = emailText.replace(new RegExp('{' + key + '}', 'g'), sampleData[key]);
        });
        emailPreview.textContent = emailText;

        // Update SMS preview
        let smsText = smsTextarea.value;
        Object.keys(sampleData).forEach(key => {
            smsText = smsText.replace(new RegExp('{' + key + '}', 'g'), sampleData[key]);
        });
        smsPreview.textContent = smsText;

        // Update subject preview
        let subjectText = subjectInput.value;
        Object.keys(sampleData).forEach(key => {
            subjectText = subjectText.replace(new RegExp('{' + key + '}', 'g'), sampleData[key]);
        });
        subjectPreview.textContent = subjectText;
    }

    // Add event listeners
    emailTextarea.addEventListener('input', updatePreview);
    smsTextarea.addEventListener('input', updatePreview);
    subjectInput.addEventListener('input', updatePreview);

    // Logo upload feedback
    const logoInput = document.getElementById('company_logo');
    const uploadArea = logoInput.closest('.border-dashed');
    const uploadText = uploadArea.querySelector('.space-y-1');

    logoInput.addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            // Create or update file info display
            let fileInfo = uploadArea.querySelector('.file-info');
            if (!fileInfo) {
                fileInfo = document.createElement('div');
                fileInfo.className = 'file-info mt-3 p-3 bg-green-50 border border-green-200 rounded-md';
                uploadArea.appendChild(fileInfo);
            }

            // Format file size
            const sizeInMB = (file.size / (1024 * 1024)).toFixed(2);
            
            fileInfo.innerHTML = `
                <div class="flex items-center text-green-800">
                    <i class="fas fa-check-circle mr-2"></i>
                    <div>
                        <p class="text-sm font-medium">${file.name}</p>
                        <p class="text-xs text-green-600">${sizeInMB} MB • ${file.type}</p>
                    </div>
                </div>
            `;

            // Change upload area styling to indicate file selected
            uploadArea.classList.remove('border-gray-300', 'hover:border-sulis-blue');
            uploadArea.classList.add('border-green-400', 'bg-green-50');
            
            // Update the upload text
            const uploadLabel = uploadText.querySelector('span');
            if (uploadLabel) {
                uploadLabel.textContent = 'File selected!';
                uploadLabel.classList.remove('text-sulis-blue');
                uploadLabel.classList.add('text-green-800');
            }
        } else {
            // Reset if no file selected
            const fileInfo = uploadArea.querySelector('.file-info');
            if (fileInfo) {
                fileInfo.remove();
            }
            
            uploadArea.classList.remove('border-green-400', 'bg-green-50');
            uploadArea.classList.add('border-gray-300', 'hover:border-sulis-blue');
            
            const uploadLabel = uploadText.querySelector('span');
            if (uploadLabel) {
                uploadLabel.textContent = 'Upload a file';
                uploadLabel.classList.remove('text-green-800');
                uploadLabel.classList.add('text-sulis-blue');
            }
        }
    });

    // Initialize preview
    updatePreview();
});
</script>
@endpush
</div>
@endsection
