@extends('layouts.app')

@section('content')
<style>
.sulis-bg-primary {
    background-color: #0056b3 !important;
}
.sulis-bg-accent {
    background-color: #FFD700 !important;
}
.sulis-text-primary {
    color: #0056b3 !important;
}
.sulis-text-accent {
    color: #FFD700 !important;
}
.sulis-card {
    border: 1px solid rgba(0, 86, 179, 0.1);
    border-radius: 0.75rem;
    transition: all 0.3s ease;
    overflow: hidden;
}
.sulis-card:hover {
    box-shadow: 0 0.5rem 1.5rem rgba(0, 86, 179, 0.08);
    transform: translateY(-2px);
}
.sulis-btn-primary {
    background-color: #0056b3 !important;
    border-color: #0056b3 !important;
    color: white !important;
    transition: all 0.3s ease !important;
}
.sulis-btn-primary:hover {
    background-color: #004494 !important;
    border-color: #004494 !important;
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(0, 86, 179, 0.3);
}
.sulis-btn-accent {
    background-color: #FFD700 !important;
    border-color: #FFD700 !important;
    color: #212529 !important;
    transition: all 0.3s ease !important;
}
.sulis-btn-accent:hover {
    background-color: #FFC107 !important;
    border-color: #FFC107 !important;
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(255, 215, 0, 0.3);
}
.form-control:focus {
    border-color: #0056b3 !important;
    box-shadow: 0 0 0 0.2rem rgba(0, 86, 179, 0.25) !important;
}
.form-label {
    color: #0056b3 !important;
    font-weight: 600;
}
</style>

<div class="container mx-auto px-4 py-8" style="background: linear-gradient(135deg, #f8fafd 0%, #fffbeb 100%); min-height: 100vh;">
    <div class="sulis-card shadow-lg p-6 mb-8">
        <div class="flex justify-between items-center mb-6 pb-4 border-bottom" style="border-bottom: 2px solid #FFD700;">
            <div>
                <h2 class="text-3xl font-bold sulis-text-primary mb-2">
                    <i class="fas fa-plus-circle me-3"></i>Assign Services to {{ $customer->CustomerName }}
                </h2>
                <p class="text-muted">Add new services to customer account with pricing and quantity details</p>
            </div>
            <a href="{{ route('customers.services', $customer) }}" 
               class="btn sulis-btn-accent px-4 py-2 rounded-lg text-decoration-none">
                <i class="fas fa-arrow-left me-2"></i> Back to Services
            </a>
        </div>

        <!-- Assign New Service Form -->
        <div class="card border-0 shadow-sm mb-6" style="background: linear-gradient(135deg, #ffffff 0%, #fef9e7 100%);">
            <div class="card-header sulis-bg-primary text-white py-3 px-4">
                <h4 class="mb-0">
                    <i class="fas fa-tasks me-2"></i>Assign New Service
                </h4>
            </div>
            <div class="card-body p-4">
                <form action="{{ route('customers.services.store', $customer) }}" method="POST" class="needs-validation" novalidate>
                    @csrf
                    
                    <div class="row g-4">
                        <div class="col-md-6">
                            <label for="service_id" class="form-label">
                                <i class="fas fa-concierge-bell me-2"></i>Service
                            </label>
                            <select name="service_id" id="service_id" class="form-select form-control-lg" required>
                                <option value="">Select a service</option>
                                @foreach($services as $service)
                                    @if(!in_array($service->IDService, $assignedServices))
                                        <option value="{{ $service->IDService }}" data-price="{{ $service->Price }}">
                                            {{ $service->ServiceName }}
                                        </option>
                                    @endif
                                @endforeach
                            </select>
                            <div class="invalid-feedback">
                                Please select a service.
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label for="price" class="form-label">
                                <i class="fas fa-tag me-2"></i>Unit Price
                            </label>
                            <div class="input-group input-group-lg">
                                <span class="input-group-text" style="background-color: #0056b3; color: white;">
                                    {{ config('app.currency_symbol', 'Ksh. ') }}
                                </span>
                                <input type="text" name="price" id="price" readonly
                                       class="form-control bg-light" 
                                       placeholder="0.00" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label for="quantity" class="form-label">
                                <i class="fas fa-cubes me-2"></i>Quantity
                            </label>
                            <div class="input-group input-group-lg">
                                <input type="number" step="1" min="1" name="quantity" id="quantity" 
                                       class="form-control" value="1" required>
                                <span class="input-group-text">units</span>
                            </div>
                            <div class="invalid-feedback">
                                Please enter a valid quantity (minimum 1).
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label for="total" class="form-label">
                                <i class="fas fa-calculator me-2"></i>Total Amount
                            </label>
                            <div class="input-group input-group-lg">
                                <span class="input-group-text sulis-bg-accent" style="background-color: #FFD700; color: #212529;">
                                    {{ config('app.currency_symbol', 'Ksh. ') }}
                                </span>
                                <input type="text" name="total" id="total" readonly
                                       class="form-control bg-light fw-bold" 
                                       placeholder="0.00">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label for="start_date" class="form-label">
                                <i class="fas fa-calendar-alt me-2"></i>Start Date
                            </label>
                            <input type="date" name="start_date" id="start_date" 
                                   class="form-control form-control-lg" 
                                   value="{{ now()->format('Y-m-d') }}" required>
                            <div class="invalid-feedback">
                                Please select a start date.
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label for="end_date" class="form-label">
                                <i class="fas fa-calendar-check me-2"></i>End Date (Optional)
                            </label>
                            <input type="date" name="end_date" id="end_date" 
                                   class="form-control form-control-lg">
                        </div>

                        <div class="col-12">
                            <label for="notes" class="form-label">
                                <i class="fas fa-sticky-note me-2"></i>Notes
                            </label>
                            <textarea name="notes" id="notes" rows="3" 
                                      class="form-control form-control-lg" 
                                      placeholder="Add any additional notes or special instructions..."></textarea>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end mt-4 pt-3 border-top" style="border-top: 1px solid #e9ecef;">
                        <button type="submit" class="btn sulis-btn-primary btn-lg px-5 py-2">
                            <i class="fas fa-plus me-2"></i> Assign Service
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Current Services -->
        <div class="card border-0 shadow-sm" style="background: linear-gradient(135deg, #ffffff 0%, #fef9e7 100%);">
            <div class="card-header sulis-bg-primary text-white py-3 px-4">
                <h4 class="mb-0">
                    <i class="fas fa-list me-2"></i>Current Services
                </h4>
            </div>
            <div class="card-body">
                @if($customer->propServices->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th><i class="fas fa-concierge-bell me-2"></i>Service</th>
                                    <th><i class="fas fa-tag me-2"></i>Unit Price</th>
                                    <th><i class="fas fa-cubes me-2"></i>Quantity</th>
                                    <th><i class="fas fa-calendar-alt me-2"></i>Duration</th>
                                    <th><i class="fas fa-sticky-note me-2"></i>Notes</th>
                                    <th><i class="fas fa-cog me-2"></i>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($customer->propServices as $service)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div>
                                                    <h6 class="mb-0">{{ $service->ServiceName }}</h6>
                                                    @if($service->pivot->IsActive)
                                                        <span class="badge bg-success">
                                                            <i class="fas fa-check-circle me-1"></i> Active
                                                        </span>
                                                    @else
                                                        <span class="badge bg-warning text-dark">
                                                            <i class="fas fa-exclamation-triangle me-1"></i> Inactive
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </td>
                                        <td class="fw-medium">{{ number_format($service->pivot->Price, 2) }} {{ config('app.currency', 'Ksh.') }}</td>
                                        <td>{{ $service->pivot->Quantity ?? 1 }}</td>
                                        <td>
                                            <small>
                                                {{ \Carbon\Carbon::parse($service->pivot->StartDate)->format('M d, Y') }}
                                                @if($service->pivot->EndDate)
                                                    - {{ \Carbon\Carbon::parse($service->pivot->EndDate)->format('M d, Y') }}
                                                @else
                                                    - No end date
                                                @endif
                                            </small>
                                        </td>
                                        <td>
                                            @if($service->pivot->Notes)
                                                <small class="text-muted">{{ $service->pivot->Notes }}</small>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            <form action="{{ route('customers.services.destroy', [$customer, $service]) }}" method="POST" class="d-inline" 
                                                  onsubmit="return confirm('Are you sure you want to remove this service from the customer?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="text-center py-8">
                        <i class="fas fa-inbox text-4xl text-muted mb-3"></i>
                        <h5 class="text-muted">No services assigned yet</h5>
                        <p class="text-muted">Get started by assigning a new service to this customer.</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Function to calculate total
    function calculateTotal() {
        const price = parseFloat(document.getElementById('price').value) || 0;
        const quantity = parseInt(document.getElementById('quantity').value) || 0;
        const total = price * quantity;
        document.getElementById('total').value = total.toFixed(2);
    }

    // Auto-fill price when service is selected
    document.getElementById('service_id').addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex];
        if (this.value && selectedOption) {
            // Get price from data-price attribute
            const price = selectedOption.getAttribute('data-price');
            if (price) {
                document.getElementById('price').value = parseFloat(price).toFixed(2);
                calculateTotal(); // Calculate total after setting price
            }
        } else {
            document.getElementById('price').value = '';
            calculateTotal(); // Calculate total after clearing price
        }
    });

    // Calculate total when quantity changes
    document.getElementById('quantity').addEventListener('input', calculateTotal);

    // Initial calculation on page load
    document.addEventListener('DOMContentLoaded', function() {
        calculateTotal();
    });
</script>
@endpush
@endsection
