@extends('layouts.app')

@section('content')
<style>
.sulis-bg-primary {
    background-color: #0056b3 !important;
}
.sulis-bg-accent {
    background-color: #FFD700 !important;
}
.sulis-text-primary {
    color: #0056b3 !important;
}
.sulis-text-accent {
    color: #FFD700 !important;
}
.sulis-card {
    border: 1px solid rgba(0, 86, 179, 0.1);
    border-radius: 0.75rem;
    transition: all 0.3s ease;
    overflow: hidden;
}
.sulis-card:hover {
    box-shadow: 0 0.5rem 1.5rem rgba(0, 86, 179, 0.08);
    transform: translateY(-2px);
}
.sulis-btn-primary {
    background-color: #0056b3 !important;
    border-color: #0056b3 !important;
    color: white !important;
    transition: all 0.3s ease !important;
}
.sulis-btn-primary:hover {
    background-color: #004494 !important;
    border-color: #004494 !important;
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(0, 86, 179, 0.3);
}
.sulis-btn-accent {
    background-color: #FFD700 !important;
    border-color: #FFD700 !important;
    color: #212529 !important;
    transition: all 0.3s ease !important;
}
.sulis-btn-accent:hover {
    background-color: #FFC107 !important;
    border-color: #FFC107 !important;
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(255, 215, 0, 0.3);
}
.form-label {
    font-weight: 600;
    color: #0056b3;
}
.form-control:focus {
    border-color: #0056b3;
    box-shadow: 0 0 0 0.2rem rgba(0, 86, 179, 0.25);
}
.form-check-input:checked {
    background-color: #0056b3;
    border-color: #0056b3;
}
</style>

<div class="container-fluid py-4">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="mb-1 sulis-text-primary">
                <i class="bi bi-pencil-square me-2"></i>Edit Service Assignment
            </h4>
            <p class="text-muted mb-0">
                <i class="bi bi-person me-1"></i>Customer: {{ $customer->CustomerName }}
                <span class="mx-2">|</span>
                <i class="bi bi-grid-1x2 me-1"></i>Service: {{ $service->ServiceName }}
            </p>
        </div>
        <a href="{{ route('customers.show', $customer) }}" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-1"></i> Back to Customer
        </a>
    </div>

    <!-- Edit Form -->
    <div class="row">
        <div class="col-lg-8">
            <div class="card sulis-card shadow-sm">
                <div class="card-header sulis-bg-primary text-white">
                    <h6 class="mb-0">
                        <i class="bi bi-gear me-2"></i>Service Assignment Details
                    </h6>
                </div>
                <div class="card-body p-4">
                    <form method="POST" action="{{ route('customers.services.update', [$customer, $service]) }}">
                        @csrf
                        @method('PUT')
                        
                        <div class="row g-3">
                            <!-- Service Name (Read-only) -->
                            <div class="col-md-6">
                                <label class="form-label">Service Name</label>
                                <input type="text" class="form-control" value="{{ $service->ServiceName }}" readonly>
                            </div>
                            
                            <!-- Price (Read-only) -->
                            <div class="col-md-6">
                                <label class="form-label">Price</label>
                                <div class="input-group">
                                    <span class="input-group-text">{{ config('app.currency', 'Ksh.') }}</span>
                                    <input type="number" 
                                           class="form-control" 
                                           value="{{ $pivot->Price }}"
                                           step="0.01" 
                                           min="0" 
                                           readonly>
                                </div>
                            </div>
                            
                            <!-- Start Date (Read-only) -->
                            <div class="col-md-6">
                                <label class="form-label">Start Date</label>
                                <input type="date" 
                                       class="form-control" 
                                       value="{{ is_string($pivot->StartDate) ? \Carbon\Carbon::parse($pivot->StartDate)->format('Y-m-d') : $pivot->StartDate->format('Y-m-d') }}"
                                       readonly>
                            </div>
                            
                            <!-- End Date (Read-only) -->
                            <div class="col-md-6">
                                <label class="form-label">End Date (Optional)</label>
                                <input type="date" 
                                       class="form-control" 
                                       value="{{ $pivot->EndDate ? (is_string($pivot->EndDate) ? \Carbon\Carbon::parse($pivot->EndDate)->format('Y-m-d') : $pivot->EndDate->format('Y-m-d')) : '' }}"
                                       readonly>
                            </div>
                            
                            <!-- Quantity (Editable) -->
                            <div class="col-md-6">
                                <label for="quantity" class="form-label">Quantity</label>
                                <input type="number" 
                                       id="quantity" 
                                       name="quantity" 
                                       class="form-control" 
                                       value="{{ $pivot->Quantity ?? 1 }}"
                                       step="1" 
                                       min="1" 
                                       required>
                                @error('quantity')
                                    <div class="text-danger small mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <!-- Active Status (Read-only) -->
                            <div class="col-md-6">
                                <label class="form-label">Active Status</label>
                                <div class="form-control-plaintext">
                                    @if($pivot->IsActive)
                                        <span class="badge bg-success">
                                            <i class="bi bi-check-circle me-1"></i> Active
                                        </span>
                                    @else
                                        <span class="badge bg-warning text-dark">
                                            <i class="bi bi-exclamation-triangle me-1"></i> Inactive
                                        </span>
                                    @endif
                                </div>
                            </div>
                            
                            <!-- Notes (Read-only) -->
                            <div class="col-12">
                                <label class="form-label">Notes</label>
                                <textarea class="form-control" 
                                          rows="3" 
                                          readonly>{{ $pivot->Notes ?? '' }}</textarea>
                            </div>
                        </div>
                        
                        <!-- Form Actions -->
                        <div class="d-flex justify-content-between mt-4 pt-3 border-top">
                            <a href="{{ route('customers.show', $customer) }}" class="btn btn-outline-secondary">
                                <i class="bi bi-x-circle me-1"></i> Cancel
                            </a>
                            <div>
                                <button type="submit" class="btn sulis-btn-primary">
                                    <i class="bi bi-check-circle me-1"></i> Update Service
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <!-- Sidebar Info -->
        <div class="col-lg-4">
            <!-- Current Assignment Info -->
            <div class="card sulis-card shadow-sm mb-3">
                <div class="card-header sulis-bg-accent text-dark">
                    <h6 class="mb-0">
                        <i class="bi bi-info-circle me-2"></i>Current Assignment
                    </h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <small class="text-muted">Customer</small>
                        <div class="fw-bold">{{ $customer->CustomerName }}</div>
                        <div class="text-muted small">{{ $customer->AccountNo }}</div>
                    </div>
                    <div class="mb-3">
                        <small class="text-muted">Service</small>
                        <div class="fw-bold">{{ $service->ServiceName }}</div>
                    </div>
                    <div class="mb-3">
                        <small class="text-muted">Current Price</small>
                        <div class="fw-bold sulis-text-primary">{{ number_format($pivot->Price, 2) }} {{ config('app.currency', 'Ksh.') }}</div>
                    </div>
                    <div class="mb-3">
                        <small class="text-muted">Status</small>
                        <div>
                            @if($pivot->IsActive)
                                <span class="badge bg-success">
                                    <i class="bi bi-check-circle me-1"></i> Active
                                </span>
                            @else
                                <span class="badge bg-warning text-dark">
                                    <i class="bi bi-exclamation-triangle me-1"></i> Inactive
                                </span>
                            @endif
                        </div>
                    </div>
                    @if($pivot->StartDate)
                        <div class="mb-3">
                            <small class="text-muted">Service Period</small>
                            <div class="small">
                                {{ is_string($pivot->StartDate) ? \Carbon\Carbon::parse($pivot->StartDate)->format('M d, Y') : $pivot->StartDate->format('M d, Y') }}
                                @if($pivot->EndDate)
                                    - {{ is_string($pivot->EndDate) ? \Carbon\Carbon::parse($pivot->EndDate)->format('M d, Y') : $pivot->EndDate->format('M d, Y') }}
                                @else
                                    - Ongoing
                                @endif
                            </div>
                        </div>
                    @endif
                </div>
            </div>
            
            <!-- Help Card -->
            <div class="card border-0 bg-light">
                <div class="card-body">
                    <h6 class="card-title">
                        <i class="bi bi-question-circle me-2"></i>Help & Tips
                    </h6>
                    <ul class="small text-muted mb-0">
                        <li>Only the quantity can be modified for existing service assignments</li>
                        <li>Quantity changes will affect future bill calculations</li>
                        <li>Contact administrator if you need to modify other service details</li>
                        <li>Use the delete option to remove a service assignment completely</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
