@extends('customers.layout')

@section('customer-content')
    <style>
        .sulis-bg-primary {
            background-color: #0056b3 !important;
        }
        .sulis-text-primary {
            color: #0056b3 !important;
        }
        .sulis-bg-accent {
            background-color: #FFD700 !important;
        }
        .sulis-text-accent {
            color: #FFD700 !important;
        }
        .sulis-card {
            border: 1px solid rgba(0, 86, 179, 0.1);
            border-radius: 0.75rem;
            transition: all 0.3s ease;
            overflow: hidden;
            box-shadow: 0 0.125rem 0.25rem rgba(0, 86, 179, 0.075);
        }
        .sulis-card:hover {
            box-shadow: 0 0.5rem 1.5rem rgba(0, 86, 179, 0.15);
            transform: translateY(-2px);
        }
        .sulis-section-title {
            position: relative;
            padding-bottom: 0.75rem;
            font-weight: 600;
            color: #0056b3 !important;
            font-size: 0.9rem;
            letter-spacing: 0.5px;
        }
        .sulis-section-title:after {
            content: '';
            position: absolute;
            left: 0;
            bottom: 0;
            width: 40px;
            height: 3px;
            background: #FFD700;
        }
        
        /* Enhanced button hover effects */
        .btn.sulis-bg-primary {
            background-color: #0056b3 !important;
            border-color: #0056b3 !important;
            color: white !important;
            transition: all 0.3s ease !important;
        }
        .btn.sulis-bg-primary:hover {
            background-color: #004494 !important;
            border-color: #004494 !important;
            color: white !important;
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(0, 86, 179, 0.3);
        }
        .btn.sulis-bg-accent {
            background-color: #FFD700 !important;
            border-color: #FFD700 !important;
            color: #212529 !important;
            transition: all 0.3s ease !important;
        }
        .btn.sulis-bg-accent:hover {
            background-color: #FFC107 !important;
            border-color: #FFC107 !important;
            color: #212529 !important;
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(255, 215, 0, 0.3);
        }
        
        /* Professional table styling */
        .table thead th {
            background: linear-gradient(135deg, #0056b3 0%, #004494 100%);
            color: white;
            border: none;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 0.75rem;
            letter-spacing: 0.5px;
        }
        .table tbody tr:hover {
            background-color: rgba(0, 86, 179, 0.05);
        }
        
        /* Tab styling */
        .nav-tabs .nav-link.sulis-tab-active {
            background-color: #0056b3 !important;
            color: white !important;
            border-color: #0056b3 !important;
        }
        .nav-tabs .nav-link:hover {
            background-color: rgba(0, 86, 179, 0.1) !important;
            color: #0056b3 !important;
        }
        
        /* Badge styling */
        .sulis-badge-active {
            background-color: #28a745 !important;
            color: white !important;
        }
        .sulis-badge-inactive {
            background-color: #FFD700 !important;
            color: #212529 !important;
        }
        
        /* Info card styling */
        .info-card {
            background: linear-gradient(135deg, #ffffff 0%, #fef9e7 100%);
            border-left: 4px solid #0056b3;
            transition: all 0.3s ease;
        }
        .info-card:hover {
            transform: translateY(-1px);
            box-shadow: 0 0.25rem 0.5rem rgba(0, 86, 179, 0.1);
        }
        
        /* Background gradient */
        body {
            background: linear-gradient(135deg, #f8fafd 0%, #fffbeb 100%);
        }
        
        /* Icon styling */
        .sulis-icon {
            color: #0056b3;
            font-size: 1.25rem;
        }
        
        /* Status indicators */
        .status-active {
            color: #28a745;
        }
        .status-inactive {
            color: #FFD700;
        }
    </style>

    <div class="card sulis-card shadow-sm mb-4 overflow-hidden" style="border-radius: 0.75rem;">
        <!-- Card Header -->
        <div class="sulis-bg-primary py-3 px-4">
            <div class="d-flex flex-wrap justify-content-between align-items-center">
                <div class="mb-2 mb-md-0">
                    <h4 class="mb-1 text-white">
                        <i class="bi bi-person-badge me-2"></i>Customer Information
                    </h4>
                    <p class="text-white-50 mb-0 small">
                        <i class="bi bi-info-circle me-1"></i>Detailed customer profile and account information
                    </p>
                </div>
                <div class="d-flex flex-wrap gap-2">
                    <a href="{{ route('customers.statement', $customer) }}" class="btn btn-sm btn-outline-light">
                        <i class="bi bi-file-earmark-text me-1"></i>
                        View Statement
                    </a>
                    <a href="{{ route('customers.edit', $customer->CustomerID) }}" class="btn btn-sm sulis-bg-accent text-dark border-0">
                        <i class="bi bi-pencil-square me-1"></i>
                        Edit
                    </a>
                    @if($customer->AccountStatus === 'A')
                        <form action="{{ route('customers.deactivate', $customer->CustomerID) }}" method="POST" class="d-inline">
                            @csrf
                            @method('POST')
                            <button type="submit" class="btn btn-sm btn-warning" onclick="return confirm('Are you sure you want to deactivate this customer?')">
                                <i class="bi bi-lock me-1"></i>
                                Deactivate
                            </button>
                        </form>
                    @else
                        <button type="button" class="btn btn-sm btn-success" onclick="confirmActivation('{{ route('customers.activate', $customer->CustomerID) }}')">
                            <i class="bi bi-unlock me-1"></i>
                            Activate
                        </button>
                    @endif
                </div>
            </div>
        </div>
        
        <!-- Card Body -->
        <div class="card-body p-0">
            <div class="row g-0">
                <!-- Left Column - Customer Details -->
                <div class="col-lg-8 p-4">
                    <div class="row g-3">
                        <!-- Name and Status -->
                        <div class="col-12 mb-4">
                            <div class="d-flex flex-wrap align-items-center mb-3">
                                <h2 class="h3 mb-0 me-3 sulis-text-primary" style="font-weight: 600;">{{ $customer->CustomerName }}</h2>
                                <div class="d-flex flex-wrap gap-2">
                                    <span class="badge rounded-pill {{ $customer->AccountStatus === 'A' ? 'sulis-bg-accent text-dark' : 'bg-danger' }} px-3 py-2">
                                        <i class="bi {{ $customer->AccountStatus === 'A' ? 'bi-check-circle' : 'bi-x-circle' }} me-1"></i>
                                        {{ $customer->AccountStatus === 'A' ? 'Active' : 'Inactive' }}
                                    </span>
                                    <span class="badge rounded-pill sulis-bg-primary text-white px-3 py-2">
                                        <i class="bi bi-person-badge me-1"></i>
                                        {{ ucfirst(strtolower($customer->AccountType)) }}
                                    </span>
                                </div>
                            </div>
                            @if($customer->TenantName)
                                <p class="text-muted mb-0 mt-1">
                                    <i class="bi bi-person-workspace me-1"></i>Tenant: {{ $customer->TenantName }}
                                </p>
                            @endif
                        </div>
                        
                        <!-- Account Info -->
                        <div class="col-md-6">
                            <div class="card h-100 border-0 shadow-sm">
                                <div class="card-body">
                                    <h6 class="sulis-section-title text-uppercase small mb-3">
                                        <i class="bi bi-credit-card me-1"></i>Account Details
                                    </h6>
                                    <ul class="list-unstyled mb-0">
                                        <li class="mb-3">
                                            <div class="small text-muted">AccountNo</div>
                                            <div>{{ $customer->AccountNo }}</div>
                                        </li>
                                        @if($customer->ClientCode)
                                            <li>
                                                <div class="small text-muted">ClientCode</div>
                                                <div><code>{{ $customer->ClientCode }}</code></div>
                                            </li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Contact Info -->
                        <div class="col-md-6">
                            <div class="card h-100 border-0 shadow-sm">
                                <div class="card-body">
                                    <h6 class="sulis-section-title text-uppercase small mb-3">
                                        <i class="bi bi-telephone me-1"></i>Contact Information
                                    </h6>
                                    <ul class="list-unstyled mb-0">
                                        <li class="mb-2">
                                            <div class="d-flex align-items-center">
                                                <i class="bi bi-telephone text-muted me-2" style="width: 24px;"></i>
                                                <div>
                                                    <div class="small text-muted">TelNo</div>
                                                    <a href="tel:{{ $customer->TelNo }}" class="text-decoration-none">{{ $customer->TelNo }}</a>
                                                </div>
                                            </div>
                                        </li>
                                        @if($customer->Email)
                                            <li class="mt-3">
                                                <div class="d-flex align-items-center">
                                                    <i class="bi bi-envelope text-muted me-2" style="width: 24px;"></i>
                                                    <div>
                                                        <div class="small text-muted">Email</div>
                                                        <a href="mailto:{{ $customer->Email }}" class="text-decoration-none text-break">{{ $customer->Email }}</a>
                                                    </div>
                                                </div>
                                            </li>
                                        @endif
                                        @if($customer->MobileNo)
                                            <li class="mt-3">
                                                <div class="d-flex align-items-center">
                                                    <i class="bi bi-phone text-muted me-2" style="width: 24px;"></i>
                                                    <div>
                                                        <div class="small text-muted">MobileNo</div>
                                                        <a href="tel:{{ $customer->MobileNo }}" class="text-decoration-none">{{ $customer->MobileNo }}</a>
                                                    </div>
                                                </div>
                                            </li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Address -->
                        <div class="col-12">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-body">
                                    <h6 class="sulis-section-title text-uppercase small mb-3">
                                        <i class="bi bi-geo-alt me-1"></i>Address
                                    </h6>
                                    <div class="address-details">
                                        @if($customer->Address1)
                                            <div class="mb-2">
                                                <div class="small text-muted">Address1</div>
                                                <div>{{ $customer->Address1 }}</div>
                                            </div>
                                        @endif
                                        @if($customer->Address2)
                                            <div class="mb-2">
                                                <div class="small text-muted">Address2</div>
                                                <div>{{ $customer->Address2 }}</div>
                                            </div>
                                        @endif
                                        @if($customer->Address3)
                                            <div class="mb-2">
                                                <div class="small text-muted">Address3</div>
                                                <div>{{ $customer->Address3 }}</div>
                                            </div>
                                        @endif
                                        @if($customer->PostCode)
                                            <div class="mb-2">
                                                <div class="small text-muted">PostCode</div>
                                                <div>{{ $customer->PostCode }}</div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Right Column - Property & Meters -->
                <div class="col-lg-4 p-0" style="background-color: #f8fafd; border-left: 1px solid rgba(0,0,0,0.05);">
                    <div class="p-4">
                        @if($customer->unit)
                            <div class="card border-0 shadow-sm mb-4">
                                <div class="card-body">
                                    <h6 class="sulis-section-title text-uppercase small mb-3">
                                        <i class="bi bi-house-door me-1"></i>Current Unit
                                    </h6>
                                <h5 class="h6 mb-1">
                                    <a href="{{ route('properties.show', $customer->unit->property->PropID) }}" class="text-decoration-none">
                                        {{ $customer->unit->property->PropName }}
                                    </a>
                                </h5>
                                <p class="mb-1">
                                    <i class="bi bi-grid-1x2 me-1 text-muted"></i>
                                    Unit {{ $customer->unit->UnitIdentity }}
                                </p>
                                <p class="text-muted small mb-0">
                                    <i class="bi bi-geo-alt me-1"></i>
                                    {{ $customer->unit->property->City }}
                                </p>
                            </div>
                        </div>
                    @endif
                    
                        </div>
                        <!-- Contract Details -->
                        <div class="card border-0 shadow-sm mb-4">
                        <div class="card-body">
                            <h6 class="sulis-section-title text-uppercase small mb-3">
                                <i class="bi bi-file-earmark-text me-1"></i>Contract
                            </h6>
                            <div class="d-flex justify-content-between mb-2">
                                <span class="text-muted small">Contract Date</span>
                                <span class="fw-medium">
                                    {{ $customer->ContractDate ? $customer->ContractDate->format('M d, Y') : 'Not specified' }}
                                </span>
                            </div>
                            <div class="d-flex justify-content-between">
                                <span class="text-muted small">Deposit</span>
                                <span class="fw-medium">
                                    {{ $customer->Deposit ? 'Ksh ' . number_format($customer->Deposit, 2) : 'None' }}
                                </span>
                            </div>
                            @if($customer->DepositDate)
                                <div class="text-end">
                                    <small class="text-muted">Paid on {{ $customer->DepositDate->format('M d, Y') }}</small>
                                </div>
                            @endif
                        </div>
                    </div>
                    
                        <!-- Meter Information -->
                        <div class="card border-0 shadow-sm mb-4">
                        <div class="card-body">
                            <h6 class="sulis-section-title text-uppercase small mb-3">
                                <i class="bi bi-speedometer2 me-1"></i>Meter Information
                            </h6>
                            @if($customer->WMeterNo || $customer->EMeterNo)
                                <div class="mb-3">
                                    @if($customer->WMeterNo)
                                        <div class="d-flex justify-content-between mb-2">
                                            <span class="text-muted small">Water Meter</span>
                                            <span class="fw-medium">{{ $customer->WMeterNo }}</span>
                                        </div>
                                        @if($customer->WInitialReading)
                                            <div class="text-end">
                                                <small class="text-muted">Initial: {{ $customer->WInitialReading }}</small>
                                            </div>
                                        @endif
                                    @endif
                                </div>
                                <div>
                                    @if($customer->EMeterNo)
                                        <div class="d-flex justify-content-between mb-2">
                                            <span class="text-muted small">Electricity Meter</span>
                                            <span class="fw-medium">{{ $customer->EMeterNo }}</span>
                                        </div>
                                        @if($customer->EInitialReading)
                                            <div class="text-end">
                                                <small class="text-muted">Initial: {{ $customer->EInitialReading }}</small>
                                            </div>
                                        @endif
                                    @endif
                                </div>
                            @else
                                <p class="text-muted small mb-0">No meter information available</p>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
         
    </div>

    <style>
        .nav-tabs {
            border-bottom: 1px solid rgba(0, 86, 179, 0.1);
        }
        .nav-tabs .nav-link {
            color: #6c757d;
            border: none;
            padding: 0.75rem 1.25rem;
            font-weight: 500;
            position: relative;
            margin-bottom: -1px;
            transition: all 0.2s ease;
            border-radius: 0;
        }
        .nav-tabs .nav-link:hover {
            color: #0056b3;
            background-color: rgba(0, 86, 179, 0.05);
            border-color: transparent;
        }
        .nav-tabs .nav-link.active {
            color: #0056b3;
            background-color: #fff;
            border: none;
            border-bottom: 3px solid #FFD700;
            font-weight: 600;
        }
        .nav-tabs .nav-link .badge {
            font-weight: 500;
            padding: 0.25em 0.6em;
            font-size: 75%;
            line-height: 1.2;
        }
        .tab-content {
            background: #fff;
            border-radius: 0 0 0.5rem 0.5rem;
        }
        .tab-pane {
            padding: 1.5rem;
        }
    </style>

    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white p-0">
            <ul class="nav nav-tabs px-3" id="customerTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active d-flex align-items-center" id="services-tab" data-bs-toggle="tab" data-bs-target="#services" type="button" role="tab" aria-controls="services" aria-selected="true">
                        <i class="bi bi-grid-1x2 me-2"></i>
                        <span>Services</span>
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link d-flex align-items-center" id="bills-tab" data-bs-toggle="tab" data-bs-target="#bills" type="button" role="tab" aria-controls="bills" aria-selected="false">
                        <i class="bi bi-receipt me-2"></i>
                        <span>Bills</span>
                        @if($customer->bills->count() > 0)
                            <span class="badge sulis-bg-accent text-dark ms-2">{{ $customer->bills->count() }}</span>
                        @endif
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link d-flex align-items-center" id="payments-tab" data-bs-toggle="tab" data-bs-target="#payments" type="button" role="tab" aria-controls="payments" aria-selected="false">
                        <i class="bi bi-credit-card me-2"></i>
                        <span>Payments</span>
                        @if($customer->payments->count() > 0)
                            <span class="badge sulis-bg-accent text-dark ms-2">{{ $customer->payments->count() }}</span>
                        @endif
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link d-flex align-items-center" id="history-tab" data-bs-toggle="tab" data-bs-target="#history" type="button" role="tab" aria-controls="history" aria-selected="false">
                        <i class="bi bi-clock-history me-2"></i>
                        <span>History</span>
                        @if($customer->unitAssignments->count() > 0)
                            <span class="badge sulis-bg-accent text-dark ms-2">{{ $customer->unitAssignments->count() }}</span>
                        @endif
                    </button>
                </li>
            </ul>
        </div>
        
        <div class="tab-content" id="customerTabsContent">
            <!-- Services Tab -->
            <div class="tab-pane fade show active p-4" id="services" role="tabpanel" aria-labelledby="services-tab">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h5 class="mb-0 text-muted">Customer Services</h5>
                    <a href="{{ route('customers.services.assign', $customer) }}" class="btn btn-sm sulis-bg-primary text-white">
                        <i class="bi bi-plus-circle me-1"></i> Assign Service
                    </a>
                </div>
            
            @if($customer->propServices->count() > 0)
                <div class="list-group mb-4">
                    @foreach($customer->propServices as $service)
                        <div class="list-group-item">
                            <div class="d-flex justify-content-between align-items-start">
                                <div class="flex-grow-1 me-3">
                                    <div class="d-flex align-items-center mb-1">
                                        <h6 class="mb-0 me-2">{{ $service->ServiceName }}</h6>
                                        @if($service->pivot->IsActive)
                                            <span class="badge bg-success">
                                                <i class="bi bi-check-circle me-1"></i> Active
                                            </span>
                                        @else
                                            <span class="badge bg-warning text-dark">
                                                <i class="bi bi-exclamation-triangle me-1"></i> Inactive
                                            </span>
                                        @endif
                                    </div>
                                    <div class="row g-2">
                                        <div class="col-md-3">
                                            <div class="d-flex align-items-center text-muted small">
                                                <i class="bi bi-currency-dollar me-2"></i>
                                                <span>{{ number_format($service->pivot->Price, 2) }} {{ config('app.currency', 'Ksh.') }}</span>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="d-flex align-items-center text-muted small">
                                                <i class="bi bi-box me-2"></i>
                                                <span>Quantity: {{ $service->pivot->Quantity ?? 1 }}</span>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="d-flex align-items-center text-muted small">
                                                <i class="bi bi-calendar3 me-2"></i>
                                                <span>{{ \Carbon\Carbon::parse($service->pivot->StartDate)->format('M d, Y') }}
                                                @if($service->pivot->EndDate)
                                                    - {{ \Carbon\Carbon::parse($service->pivot->EndDate)->format('M d, Y') }}
                                                @else
                                                    - No end date
                                                @endif
                                                </span>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="d-flex align-items-center small">
                                                <i class="bi bi-calculator me-2 sulis-text-primary"></i>
                                                <span class="fw-bold sulis-text-primary">Total: {{ number_format(($service->pivot->Price * ($service->pivot->Quantity ?? 1)), 2) }} {{ config('app.currency', 'Ksh.') }}</span>
                                            </div>
                                        </div>
                                    </div>
                                    @if($service->pivot->Notes)
                                        <div class="mt-2">
                                            <p class="text-muted small mb-0">
                                                <strong>Notes:</strong> {{ $service->pivot->Notes }}
                                            </p>
                                        </div>
                                    @endif
                                </div>
                                <div class="flex-shrink-0">
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('customers.services.edit', [$customer, $service]) }}" class="btn btn-sm btn-outline-primary">
                                            <i class="bi bi-pencil me-1"></i> Edit
                                        </a>
                                        <button type="button" class="btn btn-sm btn-outline-danger" onclick="confirmDeleteService('{{ route('customers.services.destroy', [$customer, $service]) }}')">
                                            <i class="bi bi-trash me-1"></i> Delete
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center p-5 bg-light rounded-3">
                    <i class="bi bi-inbox text-muted" style="font-size: 2.5rem; opacity: 0.7;"></i>
                    <h5 class="mt-3 text-muted">No services assigned</h5>
                    <p class="text-muted mb-4">Get started by assigning a new service to this customer.</p>
                    <a href="{{ route('customers.services.assign', $customer) }}" class="btn sulis-bg-primary text-white">
                        <i class="bi bi-plus-circle me-1"></i> Assign Service
                    </a>
                </div>
            @endif
                </div>
        
            <!-- Bills Tab -->
            <div class="tab-pane fade" id="bills" role="tabpanel" aria-labelledby="bills-tab">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <h5 class="mb-0 text-muted">Billing History</h5>
                        <p class="text-muted small mb-0">View and manage customer bills and invoices</p>
                    </div>
                    <div class="d-flex gap-2">
                        <!-- <button class="btn btn-sm btn-outline-secondary">
                            <i class="bi bi-download me-1"></i> Export
                        </button>
                        <a href="#" class="btn btn-sm sulis-bg-primary text-white">
                            <i class="bi bi-plus-circle me-1"></i> New Bill
                        </a> -->
                    </div>
                </div>
            
            @if($customer->bills->count() > 0)
                <style>
                    .bills-table {
                        --bs-table-bg: transparent;
                        --bs-table-striped-bg: rgba(0, 86, 179, 0.02);
                        --bs-table-hover-bg: rgba(0, 86, 179, 0.05);
                    }
                    .bills-table thead th {
                        background-color: #f8fafd;
                        border-bottom-width: 1px;
                        color: #ffffffff;
                        font-weight: 600;
                        text-transform: uppercase;
                        font-size: 0.75rem;
                        letter-spacing: 0.5px;
                        padding: 0.9rem 1.25rem;
                    }
                    .bills-table tbody td {
                        padding: 1rem 1.25rem;
                        vertical-align: middle;
                        border-top: 1px solid #f1f5f9;
                        color: #4a5568;
                    }
                    .bills-table tbody tr:first-child td {
                        border-top: none;
                    }
                    .bills-table .badge {
                        padding: 0.35em 0.65em;
                        font-size: 0.75em;
                        font-weight: 500;
                        border-radius: 4px;
                    }
                    .btn-table-action {
                        width: 30px;
                        height: 30px;
                        display: inline-flex;
                        align-items: center;
                        justify-content: center;
                        padding: 0;
                        border-radius: 6px;
                        transition: all 0.2s;
                    }
                    .btn-table-action:hover {
                        transform: translateY(-1px);
                    }
                </style>

                <div class="border rounded-3 overflow-hidden">
                    <div class="table-responsive">
                        <table class="table table-hover bills-table mb-0">
                            <thead>
                                <tr>
                                    <th class="ps-4">Bill #</th>
                                    <th>Billing Date</th>
                                    <th>Period</th>
                                    <th class="text-end pe-4">Amount (Ksh)</th>
                                    <th>Due Date</th>
                                    <th class="text-end pe-4">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($customer->bills as $bill)
                                    <tr>
                                        <td class="fw-medium ps-4">{{ $bill->BillNo ?: $bill->BillID }}</td>
                                        <td>{{ $bill->BillingDate ? \Carbon\Carbon::parse($bill->BillingDate)->format('M d, Y') : 'N/A' }}</td>
                                        <td>{{ $bill->formatted_billing_period }}</td>
                                        <td class="text-end fw-medium pe-4">{{ number_format($bill->TotalBill, 2) }}</td>
                                        <td>
                                           
                                            @if($bill->DueDate < now())
                                                <span class="badge bg-danger bg-opacity-10 text-danger">
                                                    <i class="bi bi-exclamation-triangle me-1"></i> Overdue
                                                </span>
                                            @else
                                                <span class="badge bg-warning bg-opacity-10 text-danger">
                                                    <i class="bi bi-clock-history me-1"></i> {{$bill->DueDate}}
                                                </span>
                                            @endif
                                        </td>
                                        <td class="text-end pe-4">
                                            <div class="dropdown">
                                                <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" id="billActions{{ $bill->BillID }}" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <i class="bi bi-three-dots-vertical"></i>
                                                </button>
                                                <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="billActions{{ $bill->BillID }}">
                                                    <li>
                                                        <a class="dropdown-item" href="{{ route('bills.utility.show', $bill->BillID) }}" title="View Bill">
                                                            <i class="bi bi-eye me-2"></i> View Bill
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="{{ route('bills.utility.download', $bill->BillID) }}" title="Print Bill" target="_blank">
                                                            <i class="bi bi-printer me-2"></i> Print
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="{{ route('bills.utility.download', $bill->BillID) }}?download=1" title="Download PDF" download>
                                                            <i class="bi bi-download me-2"></i> Download PDF
                                                        </a>
                                                    </li>
                                                    <li><hr class="dropdown-divider"></li>
                                                    <li>
                                                        <a class="dropdown-item text-danger" href="#" title="Void Bill" onclick="alert('Void Bill feature is coming soon!'); return false;">
                                                            <i class="bi bi-x-circle me-2"></i> Void Bill
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            @else
                <div class="text-center p-5 bg-light rounded-3 border border-dashed">
                    <div class="bg-white d-inline-flex p-3 rounded-circle mb-3">
                        <i class="bi bi-receipt text-muted" style="font-size: 2rem; opacity: 0.8;"></i>
                    </div>
                    <h5 class="text-muted mb-2">No Bills Found</h5>
                    <p class="text-muted mb-4">There are no bills for this customer yet. Create a new bill to get started.</p>
                    <!-- <a href="#" class="btn sulis-bg-primary text-white">
                        <i class="bi bi-plus-circle me-1"></i> Create New Bill
                    </a> -->
                </div>
            @endif
            </div>
        
        <!-- Payments Tab Content -->
        <div id="payments" class="tab-pane fade">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0">Payment History</h5>
                <!-- <a href="#" class="btn btn-sm btn-primary">
                    <i class="bi bi-plus-circle me-1"></i> Record Payment
                </a> -->
            </div>
            
            @if($customer->payments->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Receipt #</th>
                                <th>Date</th>
                                <th>Payment Method</th>
                                <th class="text-end">Amount</th>
                                <th>Reference</th>
                                <th class="text-end">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($customer->payments as $payment)
                                <tr>
                                    <td>{{ $payment->ReceiptNo }}</td>
                                    <td>{{ \Carbon\Carbon::parse($payment->PaymentDate)->format('M d, Y') }}</td>
                                    <td>{{ $payment->PaymentMethod }}</td>
                                    <td class="text-end">Ksh {{ number_format($payment->Amount, 2) }}</td>
                                    <td>{{ $payment->ReferenceNo ?? 'N/A' }}</td>
                                    <td class="text-end">
                                        <div class="btn-group btn-group-sm">
                                            <a href="#" class="btn btn-sm btn-outline-primary">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            <a href="#" class="btn btn-sm btn-outline-secondary">
                                                <i class="bi bi-printer"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center p-5 bg-light rounded">
                    <i class="bi bi-cash-coin text-muted" style="font-size: 2.5rem;"></i>
                    <h5 class="mt-2">No payments found</h5>
                    <p class="text-muted">Get started by recording a new payment.</p>
                    <!-- <a href="#" class="btn btn-primary">
                        <i class="bi bi-plus-circle me-1"></i> Record Payment
                    </a> -->
                </div>
            @endif
            </div>
        
        <!-- Assignment History Tab Content -->
        <div id="history" class="tab-pane fade">
            <h3 class="text-lg font-medium text-gray-900 mb-4">Unit Assignment History</h3>
            
            @if($customer->unitAssignments->count() > 0)
                <div class="flow-root">
                    <ul class="-mb-8">
                        @foreach($customer->unitAssignments as $index => $assignment)
                            <li>
                                <div class="relative pb-8">
                                    @if($index !== $customer->unitAssignments->count() - 1)
                                        <span class="absolute top-4 left-4 -ml-px h-full w-0.5 bg-gray-200" aria-hidden="true"></span>
                                    @endif
                                    <div class="relative flex space-x-3">
                                        <div>
                                            @if($assignment->status === 'active')
                                                <span class="h-8 w-8 rounded-full bg-green-500 flex items-center justify-center ring-8 ring-white">
                                                    <svg class="h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
                                                    </svg>
                                                </span>
                                            @elseif($assignment->status === 'terminated')
                                                <span class="h-8 w-8 rounded-full bg-red-500 flex items-center justify-center ring-8 ring-white">
                                                    <svg class="h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                        <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" />
                                                    </svg>
                                                </span>
                                            @else
                                                <span class="h-8 w-8 rounded-full bg-yellow-500 flex items-center justify-center ring-8 ring-white">
                                                    <svg class="h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                                    </svg>
                                                </span>
                                            @endif
                                        </div>
                                        <div class="min-w-0 flex-1 pt-1.5 flex justify-between space-x-4">
                                            <div>
                                                <p class="text-sm text-gray-500">
                                                    @if($assignment->status === 'active')
                                                        Assigned to 
                                                    @elseif($assignment->status === 'terminated')
                                                        Unassigned from 
                                                    @else
                                                        Transferred from 
                                                    @endif
                                                    <a href="{{ route('properties.units.edit', [$assignment->unit->property->PropID, $assignment->unit->UnitID]) }}" class="font-medium text-gray-900">
                                                        {{ $assignment->unit->UnitIdentity }}
                                                    </a>
                                                    @if($assignment->status === 'active')
                                                        on {{ $assignment->start_date->format('M d, Y') }}
                                                    @else
                                                        on {{ $assignment->end_date?->format('M d, Y') ?? 'N/A' }}
                                                    @endif
                                                </p>
                                                @if($assignment->notes)
                                                    <p class="mt-1 text-sm text-gray-500">{{ $assignment->notes }}</p>
                                                @endif
                                            </div>
                                            <div class="text-right text-sm whitespace-nowrap text-gray-500">
                                                @if($assignment->status === 'active')
                                                    <time datetime="{{ $assignment->start_date->toIso8601String() }}">
                                                        {{ $assignment->start_date->diffForHumans() }}
                                                    </time>
                                                @else
                                                    <time datetime="{{ $assignment->end_date?->toIso8601String() }}">
                                                        {{ $assignment->end_date?->diffForHumans() }}
                                                    </time>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
            @else
                <div class="text-center py-12 bg-gray-50 rounded-lg">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                    </svg>
                    <h3 class="mt-2 text-sm font-medium text-gray-900">No assignment history</h3>
                    <p class="mt-1 text-sm text-gray-500">This customer has not been assigned to any units yet.</p>
                </div>
            @endif
        </div>
    </div>

    @push('scripts')
    <script>
        // Initialize Bootstrap tabs
        var tabEl = document.querySelector('button[data-bs-toggle="tab"]');
        if (tabEl) {
            tabEl.addEventListener('shown.bs.tab', function (event) {
                // Handle tab change if needed
            });
        }
        
        function confirmActivation(activateUrl) {
            Swal.fire({
                title: 'Are you sure you want to activate this customer?',
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#28a745',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Yes, activate',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Create a form and submit it
                    const form = document.createElement('form');
                    form.method = 'POST';
                    form.action = activateUrl;
                    
                    // Add CSRF token
                    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
                    const csrfInput = document.createElement('input');
                    csrfInput.type = 'hidden';
                    csrfInput.name = '_token';
                    csrfInput.value = csrfToken;
                    form.appendChild(csrfInput);
                    
                    // Add POST method
                    const methodInput = document.createElement('input');
                    methodInput.type = 'hidden';
                    methodInput.name = '_method';
                    methodInput.value = 'POST';
                    form.appendChild(methodInput);
                    
                    document.body.appendChild(form);
                    form.submit();
                }
            });
        }
        
        function confirmDeleteService(deleteUrl) {
            Swal.fire({
                title: 'Are you sure you want to remove this service?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Yes, delete',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Create a form and submit it
                    const form = document.createElement('form');
                    form.method = 'POST';
                    form.action = deleteUrl;
                    
                    // Add CSRF token
                    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
                    const csrfInput = document.createElement('input');
                    csrfInput.type = 'hidden';
                    csrfInput.name = '_token';
                    csrfInput.value = csrfToken;
                    form.appendChild(csrfInput);
                    
                    // Add DELETE method
                    const methodInput = document.createElement('input');
                    methodInput.type = 'hidden';
                    methodInput.name = '_method';
                    methodInput.value = 'DELETE';
                    form.appendChild(methodInput);
                    
                    document.body.appendChild(form);
                    form.submit();
                }
            });
        }
    </script>
    @endpush
@endsection
