@extends('layouts.app')

@section('header')
    <div class="flex items-center">
        <h1 class="text-2xl font-semibold text-gray-900">Dashboard Overview</h1>
    </div>
@endsection

@section('content')
<div class="py-4 md:py-6">
    <!-- Stats Overview -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
        <!-- Total Properties -->
        <div class="relative bg-white rounded-lg shadow p-6 transition-all duration-300 hover:shadow-xl hover:-translate-y-0.5 transform hover:scale-[1.01] hover:border-l-4 hover:border-indigo-500 group overflow-hidden cursor-pointer">
            <div class="absolute inset-0 bg-gradient-to-br from-indigo-50 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-indigo-100 text-indigo-600 mr-4 transition-all duration-300 group-hover:scale-110 group-hover:shadow-md">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                    </svg>
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-500">Total Properties</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ $stats['total_properties'] ?? 0 }}</p>
                    <p class="text-xs text-green-600 mt-1">+{{ $stats['properties_change'] ?? 0 }}% from last month</p>
                </div>
            </div>
        </div>

        <!-- Total Bills -->
        <div class="relative bg-white rounded-lg shadow p-6 transition-all duration-300 hover:shadow-xl hover:-translate-y-0.5 transform hover:scale-[1.01] hover:border-l-4 hover:border-blue-500 group overflow-hidden cursor-pointer">
            <div class="absolute inset-0 bg-gradient-to-br from-blue-50 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-blue-100 text-blue-600 mr-4 transition-all duration-300 group-hover:scale-110 group-hover:shadow-md">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
                    </svg>
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-500">Total Utility Bills</p>
                    <p class="text-2xl font-semibold text-gray-900">Ksh {{ number_format($stats['total_bills'] ?? 0) }}</p>
                    <p class="text-xs {{ ($stats['bills_change'] ?? 0) >= 0 ? 'text-green-600' : 'text-red-600' }} mt-1">
                        {{ ($stats['bills_change'] ?? 0) >= 0 ? '+' : '' }}{{ $stats['bills_change'] ?? 0 }}% from last month
                    </p>
                </div>
            </div>
        </div>

        <!-- Monthly Revenue -->
        <div class="relative bg-white rounded-lg shadow p-6 transition-all duration-300 hover:shadow-xl hover:-translate-y-0.5 transform hover:scale-[1.01] hover:border-l-4 hover:border-indigo-500 group overflow-hidden cursor-pointer">
            <div class="absolute inset-0 bg-gradient-to-br from-indigo-50 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-yellow-100 text-yellow-600 mr-4 transition-all duration-300 group-hover:scale-110 group-hover:shadow-md">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-500">Monthly Payments</p>
                    <p class="text-2xl font-semibold text-gray-900">Ksh {{ number_format($stats['monthly_payments'] ?? 0) }}</p>
                    <p class="text-xs {{ ($stats['payment_change'] ?? 0) >= 0 ? 'text-green-600' : 'text-red-600' }} mt-1">
                        {{ ($stats['payment_change'] ?? 0) >= 0 ? '+' : '' }}{{ $stats['payment_change'] ?? 0 }}% from last month
                    </p>
                </div>
            </div>
        </div>

        <!-- Monthly Rent and Service -->
        <div class="relative bg-white rounded-lg shadow p-6 transition-all duration-300 hover:shadow-xl hover:-translate-y-0.5 transform hover:scale-[1.01] hover:border-l-4 hover:border-indigo-500 group overflow-hidden cursor-pointer">
            <div class="absolute inset-0 bg-gradient-to-br from-indigo-50 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-green-100 text-green-600 mr-4 transition-all duration-300 group-hover:scale-110 group-hover:shadow-md">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-500">Monthly Rent and Service Bill</p>
                    <p class="text-2xl font-semibold text-gray-900">Ksh {{ number_format($stats['total_rent'] ?? 0) }}</p>
                    <p class="text-xs {{ ($stats['rent_change'] ?? 0) >= 0 ? 'text-green-600' : 'text-red-600' }} mt-1">
                        {{ ($stats['rent_change'] ?? 0) >= 0 ? '+' : '' }}{{ $stats['rent_change'] ?? 0 }}% from last month
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content Area -->
    <!-- Property Statistics and Quick Actions Row -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-6">
        <!-- Property Statistics -->
        <div class="lg:col-span-2">
            <div class="bg-white rounded-lg shadow overflow-hidden h-full">
                <div class="px-6 py-4 border-b border-gray-200">
                    <div class="flex justify-between items-center">
                        <h3 class="text-lg font-medium text-gray-900">Property Portfolio</h3>
                        <a href="{{ route('properties.index') }}" class="text-sm font-medium text-indigo-600 hover:text-indigo-500">View All Properties</a>
                    </div>
                </div>
                <div class="p-6">
                    <!-- Property Cards Grid -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        @php
                            $displayProperties = array_slice($stats['recent_properties'], 0, 4);
                        @endphp
                        @forelse($displayProperties as $property)
                            <div class="relative bg-white border border-gray-200 rounded-lg overflow-hidden transition-all duration-300 transform hover:scale-[1.01] hover:shadow-md group cursor-pointer">
                                <div class="absolute inset-0 bg-gradient-to-br from-indigo-50 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                                <div class="p-4 relative">
                                    <div class="flex justify-between items-start">
                                        <div>
                                            <h4 class="font-medium text-gray-900 flex items-center group-hover:text-indigo-600 transition-colors duration-300">
                                                <i class="fas fa-home text-indigo-500 mr-2 transition-transform duration-300 group-hover:scale-110"></i>
                                                <span class="relative group-hover:translate-x-1 transition-transform duration-300">
                                                    {{ $property['name'] }}
                                                </span>
                                            </h4>
                                            <p class="text-sm text-gray-500 mt-1 group-hover:text-gray-700 transition-colors duration-300">
                                                <i class="fas fa-map-marker-alt text-red-400 mr-1 transition-transform duration-300 group-hover:scale-110"></i>
                                                <span class="relative group-hover:translate-x-1 transition-transform duration-300">
                                                    {{ $property['location'] }}
                                                </span>
                                            </p>
                                        </div>
                                        <div class="text-right">
                                            <div class="text-lg font-bold {{ $property['occupancy_rate'] >= 80 ? 'text-green-600' : ($property['occupancy_rate'] >= 50 ? 'text-blue-600' : 'text-yellow-600') }}">
                                                {{ $property['occupancy_rate'] }}%
                                            </div>
                                            <div class="text-xs font-medium text-gray-500 bg-gray-100 px-2 py-0.5 rounded-full">
                                                <i class="fas fa-users mr-1"></i> occupancy
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="mt-4 grid grid-cols-2 gap-3">
                                        <div class="bg-gray-50 p-2 rounded group-hover:bg-white group-hover:shadow-sm transition-all duration-300">
                                            <p class="text-xs text-gray-500">Units</p>
                                            <p class="font-medium">{{ $property['units_occupied'] ?? 0 }}/{{ $property['units_total'] ?? 0 }}</p>
                                        </div>
                                        <div class="bg-gray-50 p-2 rounded">
                                            <p class="text-xs text-gray-500">Monthly Rent</p>
                                            <p class="font-medium">Ksh {{ number_format($property['rent'] ?? 0) }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="bg-gray-50 px-4 py-2 flex justify-end space-x-2 z-10 relative">
                                    <a href="{{ route('properties.show', ['property' => $property['PropID']]) }}" class="inline-flex items-center px-3 py-1.5 border border-transparent text-xs font-medium rounded shadow-sm text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none">
                                        Manage
                                    </a>
                                </div>
                            </div>
                        @empty
                            <div class="col-span-2 text-center py-8">
                                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                </svg>
                                <h3 class="mt-2 text-sm font-medium text-gray-900">No properties</h3>
                                <p class="mt-1 text-sm text-gray-500">Get started by adding a new property.</p>
                                <div class="mt-4">
                                    <a href="{{ route('properties.create') }}" class="inline-flex items-center px-4 py-2 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none">
                                        <svg class="-ml-1 mr-2 h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z" clip-rule="evenodd" />
                                        </svg>
                                        New Property
                                    </a>
                                </div>
                            </div>
                        @endforelse
                        
                        @if(count($stats['recent_properties']) > 4)
                            <!-- Removed duplicate 'View All Properties' button -->
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="lg:col-span-1">
            <div class="bg-white rounded-lg shadow overflow-hidden h-full">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-medium text-gray-900">Quick Actions</h3>
                </div>
                <div class="p-4 space-y-3">
                    <a href="{{ route('properties.create') }}" class="relative flex items-center p-3 border border-gray-200 rounded-lg overflow-hidden group transition-all duration-300 hover:shadow-md hover:-translate-y-0.5 transform hover:scale-[1.01] cursor-pointer">
                        <div class="absolute inset-0 bg-gradient-to-br from-indigo-50 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                        <div class="p-2 rounded-full bg-indigo-100 text-indigo-600 mr-3 transition-all duration-300 group-hover:scale-110 group-hover:shadow-sm z-10">
                            <i class="fas fa-plus transition-transform duration-300 group-hover:rotate-90"></i>
                        </div>
                        <span class="text-sm font-medium text-gray-700 group-hover:text-indigo-600 transition-colors duration-300 relative group-hover:translate-x-1">Add New Property</span>
                        <i class="fas fa-chevron-right text-xs text-gray-400 ml-auto transition-all duration-300 transform group-hover:translate-x-1 group-hover:text-indigo-500"></i>
                    </a>
                    <a href="{{ route('payments.create') }}" class="relative flex items-center p-3 border border-gray-200 rounded-lg overflow-hidden group transition-all duration-300 hover:shadow-md hover:-translate-y-0.5 transform hover:scale-[1.01] cursor-pointer">
                        <div class="absolute inset-0 bg-gradient-to-br from-green-50 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                        <div class="p-2 rounded-full bg-green-100 text-green-600 mr-3 transition-all duration-300 group-hover:scale-110 group-hover:shadow-sm z-10">
                            <i class="fas fa-file-invoice-dollar transition-transform duration-300 group-hover:scale-110"></i>
                        </div>
                        <span class="text-sm font-medium text-gray-700 group-hover:text-green-600 transition-colors duration-300 relative group-hover:translate-x-1">Record Payment</span>
                        <i class="fas fa-chevron-right text-xs text-gray-400 ml-auto transition-all duration-300 transform group-hover:translate-x-1 group-hover:text-green-500"></i>
                    </a>
                    <a href="#" 
                       x-data="{ open: false }" 
                       @click.prevent="open = true" 
                       class="relative flex items-center p-3 border border-gray-200 rounded-lg overflow-hidden group transition-all duration-300 hover:shadow-md hover:-translate-y-0.5 transform hover:scale-[1.01] cursor-pointer">
                        <div class="absolute inset-0 bg-gradient-to-br from-yellow-50 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                        <div class="p-2 rounded-full bg-yellow-100 text-yellow-600 mr-3 transition-all duration-300 group-hover:scale-110 group-hover:shadow-sm z-10">
                            <i class="fas fa-tools transition-transform duration-300 group-hover:rotate-12"></i>
                        </div>
                        <span class="text-sm font-medium text-gray-700 group-hover:text-yellow-600 transition-colors duration-300 relative group-hover:translate-x-1">Maintenance Request</span>
                        <i class="fas fa-chevron-right text-xs text-gray-400 ml-auto transition-all duration-300 transform group-hover:translate-x-1 group-hover:text-yellow-500"></i>
                        
                        <!-- Maintenance Request Modal -->
                        <div x-show="open" 
                             class="fixed inset-0 z-50 overflow-y-auto" 
                             aria-labelledby="modal-title" 
                             x-ref="dialog" 
                             aria-modal="true">
                            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                                <div x-show="open" 
                                     x-transition:enter="ease-out duration-300" 
                                     x-transition:enter-start="opacity-0" 
                                     x-transition:enter-end="opacity-100" 
                                     x-transition:leave="ease-in duration-200" 
                                     x-transition:leave-start="opacity-100" 
                                     x-transition:leave-end="opacity-0" 
                                     class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" 
                                     @click="open = false">
                                </div>

                                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                                <div x-show="open" 
                                     x-transition:enter="ease-out duration-300" 
                                     x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" 
                                     x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100" 
                                     x-transition:leave="ease-in duration-200" 
                                     x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100" 
                                     x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" 
                                     class="inline-block align-bottom bg-white rounded-lg px-4 pt-5 pb-4 text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full sm:p-6">
                                    <div>
                                        <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-yellow-100">
                                            <i class="fas fa-tools text-yellow-600"></i>
                                        </div>
                                        <div class="mt-3 text-center sm:mt-5">
                                            <h3 class="text-lg leading-6 font-medium text-gray-900" id="modal-title">
                                                Submit Maintenance Request
                                            </h3>
                                            <div class="mt-2">
                                                <p class="text-sm text-gray-500">
                                                    Please select a property to report a maintenance issue.
                                                </p>
                                                <div class="mt-4">
                                                    <select class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
                                                        <option>Select a property</option>
                                                        @foreach($stats['recent_properties'] as $property)
                                                            <option value="{{ $property['PropID'] }}">{{ $property['name'] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="mt-4">
                                                    <label for="issue" class="block text-sm font-medium text-gray-700 text-left">Issue Description</label>
                                                    <textarea id="issue" rows="3" class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-5 sm:mt-6 sm:grid sm:grid-cols-2 sm:gap-3 sm:grid-flow-row-dense">
                                        <button type="button" class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-indigo-600 text-base font-medium text-white hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:col-start-2 sm:text-sm">
                                            Submit Request
                                        </button>
                                        <button type="button" @click="open = false" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:mt-0 sm:col-start-1 sm:text-sm">
                                            Cancel
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                    <a href="#" 
                       x-data="{ open: false }" 
                       @click.prevent="open = true" 
                       class="relative flex items-center p-3 border border-gray-200 rounded-lg overflow-hidden group transition-all duration-300 hover:shadow-md hover:-translate-y-0.5 transform hover:scale-[1.01] cursor-pointer">
                        <div class="absolute inset-0 bg-gradient-to-br from-blue-50 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                        <div class="p-2 rounded-full bg-blue-100 text-blue-600 mr-3 transition-all duration-300 group-hover:scale-110 group-hover:shadow-sm z-10">
                            <i class="fas fa-envelope transition-transform duration-300 group-hover:scale-110"></i>
                        </div>
                        <span class="text-sm font-medium text-gray-700 group-hover:text-blue-600 transition-colors duration-300 relative group-hover:translate-x-1">Bulk Message</span>
                        <i class="fas fa-chevron-right text-xs text-gray-400 ml-auto transition-all duration-300 transform group-hover:translate-x-1 group-hover:text-blue-500"></i>
                        
                        <!-- Bulk Message Modal -->
                        <div x-show="open" 
                             class="fixed inset-0 z-50 overflow-y-auto" 
                             aria-labelledby="modal-title" 
                             x-ref="dialog" 
                             aria-modal="true">
                            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                                <div x-show="open" 
                                     x-transition:enter="ease-out duration-300" 
                                     x-transition:enter-start="opacity-0" 
                                     x-transition:enter-end="opacity-100" 
                                     x-transition:leave="ease-in duration-200" 
                                     x-transition:leave-start="opacity-100" 
                                     x-transition:leave-end="opacity-0" 
                                     class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" 
                                     @click="open = false">
                                </div>

                                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                                <div x-show="open" 
                                     x-transition:enter="ease-out duration-300" 
                                     x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" 
                                     x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100" 
                                     x-transition:leave="ease-in duration-200" 
                                     x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100" 
                                     x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" 
                                     class="inline-block align-bottom bg-white rounded-lg px-4 pt-5 pb-4 text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full sm:p-6">
                                    <div>
                                        <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-blue-100">
                                            <i class="fas fa-envelope text-blue-600"></i>
                                        </div>
                                        <div class="mt-3 text-center sm:mt-5">
                                            <h3 class="text-lg leading-6 font-medium text-gray-900" id="modal-title">
                                                Send Bulk Message
                                            </h3>
                                            <div class="mt-2">
                                                <p class="text-sm text-gray-500">
                                                    Send a message to multiple tenants at once.
                                                </p>
                                                <div class="mt-4">
                                                    <label for="message" class="block text-sm font-medium text-gray-700 text-left">Message</label>
                                                    <textarea id="message" rows="4" class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"></textarea>
                                                </div>
                                                <div class="mt-4">
                                                    <label class="block text-sm font-medium text-gray-700 text-left mb-2">Recipients</label>
                                                    <div class="space-y-2">
                                                        <div class="flex items-start">
                                                            <div class="flex items-center h-5">
                                                                <input id="all-tenants" name="recipients" type="checkbox" class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 rounded">
                                                            </div>
                                                            <div class="ml-3 text-sm">
                                                                <label for="all-tenants" class="font-medium text-gray-700">All Tenants</label>
                                                            </div>
                                                        </div>
                                                        <div class="flex items-start">
                                                            <div class="flex items-center h-5">
                                                                <input id="property-owners" name="recipients" type="checkbox" class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 rounded">
                                                            </div>
                                                            <div class="ml-3 text-sm">
                                                                <label for="property-owners" class="font-medium text-gray-700">Property Owners</label>
                                                            </div>
                                                        </div>
                                                        <div class="flex items-start">
                                                            <div class="flex items-center h-5">
                                                                <input id="custom" name="recipients" type="checkbox" class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 rounded">
                                                            </div>
                                                            <div class="ml-3 text-sm">
                                                                <label for="custom" class="font-medium text-gray-700">Custom List</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-5 sm:mt-6 sm:grid sm:grid-cols-2 sm:gap-3 sm:grid-flow-row-dense">
                                        <button type="button" class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-indigo-600 text-base font-medium text-white hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:col-start-2 sm:text-sm">
                                            Send Message
                                        </button>
                                        <button type="button" @click="open = false" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:mt-0 sm:col-start-1 sm:text-sm">
                                            Cancel
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Payments Full Width -->
    <div class="bg-white rounded-lg shadow-sm border border-gray-100 overflow-hidden mb-8 transition-all duration-300 hover:shadow-md">
        <div class="px-6 py-4 border-b border-gray-100 bg-gradient-to-r from-slate-50 to-white">
            <div class="flex justify-between items-center">
                <h3 class="text-lg font-semibold text-slate-800 flex items-center">
                    <i class="fas fa-credit-card text-slate-500 mr-2 text-base"></i>
                    <span>Recent Payments</span>
                </h3>
                <a href="{{ route('payments.index') }}" class="text-sm font-medium text-slate-600 hover:text-sulis-primary transition-colors duration-200 flex items-center group">
                    View All
                    <i class="fas fa-chevron-right text-xs ml-1 transition-transform duration-200 group-hover:translate-x-1"></i>
                </a>
            </div>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-100">
                <thead class="bg-slate-50">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider border-b border-slate-100">Customer</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider border-b border-slate-100">Payment #</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider border-b border-slate-100">Amount</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider border-b border-slate-100">Date</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider border-b border-slate-100">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-slate-100">
                    @forelse($stats['recent_payments'] as $payment)
                        <tr class="hover:bg-slate-50/80 transition-colors duration-150">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <div class="flex-shrink-0 h-10 w-10 rounded-full bg-slate-100 flex items-center justify-center text-slate-500 mr-3">
                                        <i class="fas fa-user text-sm"></i>
                                    </div>
                                    <div>
                                        <div class="text-sm font-medium text-slate-800">{{ $payment->customer->CustomerName ?? 'N/A' }}</div>
                                        <div class="text-xs text-slate-500">{{ $payment->customer->PhoneNumber ?? '' }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-2.5 py-1 text-xs font-medium text-slate-700 bg-slate-100 rounded-full">#{{ $payment->PaymentID }}</span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-slate-900">Ksh {{ number_format($payment->TotalPayment, 2) }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm text-slate-600">{{ \Carbon\Carbon::parse($payment->PaymentDate)->format('M d, Y') }}</div>
                                <div class="text-xs text-slate-400">{{ \Carbon\Carbon::parse($payment->PaymentDate)->diffForHumans() }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @php
                                    $statusClass = [
                                        'Completed' => 'bg-green-50 text-green-700',
                                        'Pending' => 'bg-yellow-50 text-yellow-700',
                                        'Failed' => 'bg-red-50 text-red-700',
                                        'Refunded' => 'bg-blue-50 text-blue-700',
                                    ][$payment->PaymentStatus ?? 'Completed'] ?? 'bg-gray-50 text-gray-700';
                                @endphp
                                <span class="px-3 py-1 inline-flex text-xs leading-4 font-medium rounded-full {{ $statusClass }}">
                                    <i class="fas {{ $payment->PaymentStatus === 'Completed' ? 'fa-check-circle' : 'fa-clock' }} mr-1.5"></i>
                                    {{ $payment->PaymentStatus ?? 'Completed' }}
                                </span>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-6 py-12 text-center">
                                <div class="text-slate-400">
                                    <i class="fas fa-receipt text-3xl mb-2"></i>
                                    <p class="text-sm font-medium text-slate-500">No recent payments found</p>
                                    <p class="text-xs text-slate-400 mt-1">Payments will appear here when available</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Main Content Grid -->
    <div class="grid grid-cols-1 gap-6 mb-6">
        <!-- Recent Bills Full Width -->
        <div class="bg-white rounded-lg shadow-sm border border-gray-100 overflow-hidden transition-all duration-300 hover:shadow-md">
            <div class="px-6 py-4 border-b border-gray-100 bg-gradient-to-r from-slate-50 to-white">
                <div class="flex justify-between items-center">
                    <h3 class="text-lg font-semibold text-slate-800 flex items-center">
                        <i class="fas fa-file-invoice-dollar text-slate-500 mr-2 text-base"></i>
                        <span>Recent Rent Bills</span>
                    </h3>
                    <a href="{{ route('invoices.rent.index') }}" class="text-sm font-medium text-slate-600 hover:text-sulis-primary transition-colors duration-200 flex items-center group">
                        View Details
                        <i class="fas fa-chevron-right ml-1 text-xs group-hover:translate-x-1 transition-transform duration-200"></i>
                    </a>
                </div>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-100">
                    <thead class="bg-slate-50">
                        <tr>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider border-b border-slate-100">Bill #</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider border-b border-slate-100">Customer</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider border-b border-slate-100">Type</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider border-b border-slate-100">Amount</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider border-b border-slate-100">Due Date</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider border-b border-slate-100">Status</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-slate-100">
                        @forelse($stats['recent_bills'] as $bill)
                            @php
                                $isOverdue = isset($bill['due_date']) && \Carbon\Carbon::parse($bill['due_date'])->isPast() && $bill['status'] !== 'Paid';
                                $statusClass = [
                                    'Paid' => 'bg-green-50 text-green-700',
                                    'Overdue' => 'bg-red-50 text-red-700',
                                    'Pending' => 'bg-yellow-50 text-yellow-700',
                                    'Draft' => 'bg-gray-50 text-gray-700',
                                ][$isOverdue ? 'Overdue' : $bill['status']] ?? 'bg-blue-50 text-blue-700';
                                
                                $statusIcon = [
                                    'Paid' => 'fa-check-circle',
                                    'Overdue' => 'fa-exclamation-circle',
                                    'Pending' => 'fa-clock',
                                    'Draft' => 'fa-file-alt',
                                ][$isOverdue ? 'Overdue' : $bill['status']] ?? 'fa-file-invoice';
                            @endphp
                            
                            <tr class="hover:bg-slate-50/80 transition-colors duration-150 {{ $isOverdue ? 'bg-red-50/30' : '' }}">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <span class="px-2.5 py-1 text-xs font-medium text-slate-700 bg-slate-100 rounded-full">#{{ $bill['id'] }}</span>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-slate-800">{{ $bill['customer_name'] ?? 'N/A' }}</div>
                                    <div class="text-xs text-slate-500">{{ $bill['customer_phone'] ?? '' }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="text-sm text-slate-600">{{ $bill['type'] ?? 'N/A' }}</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-slate-900">Ksh {{ number_format($bill['amount'] ?? 0, 2) }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex flex-col">
                                        <span class="text-sm {{ $isOverdue ? 'text-red-600 font-medium' : 'text-slate-600' }}">
                                            {{ $bill['due_date'] ?? 'N/A' }}
                                        </span>
                                        @if(isset($bill['due_date']))
                                            <span class="text-xs {{ $isOverdue ? 'text-red-500' : 'text-slate-400' }}">
                                                {{ \Carbon\Carbon::parse($bill['due_date'])->diffForHumans() }}
                                            </span>
                                        @endif
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-3 py-1 inline-flex items-center text-xs leading-4 font-medium rounded-full {{ $statusClass }}">
                                        <i class="fas {{ $statusIcon }} mr-1.5"></i>
                                        {{ $isOverdue ? 'Overdue' : ($bill['status'] ?? 'N/A') }}
                                    </span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="px-6 py-12 text-center">
                                    <div class="text-slate-400">
                                        <i class="fas fa-file-invoice text-3xl mb-2"></i>
                                        <p class="text-sm font-medium text-slate-500">No recent bills found</p>
                                        <p class="text-xs text-slate-400 mt-1">Bills will appear here when available</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        </div>

       
    </div>
</div>
@endsection
