<!DOCTYPE html>
<html>
<head>
    <title>{{ config('app.name') }} - Invoice Notification</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            line-height: 1.6; 
            color: #333; 
            max-width: 600px; 
            margin: 0 auto; 
            padding: 20px;
            background-color: #f9f9f9;
        }
        .email-container {
            background-color: #ffffff;
            border-radius: 8px;
            padding: 30px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        .header { 
            text-align: center; 
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 1px solid #eaeaea;
        }
        .logo {
            max-width: 200px;
            margin-bottom: 15px;
        }
        .content { 
            margin: 25px 0;
            line-height: 1.7;
            color: #444;
        }
        .footer { 
            margin-top: 30px; 
            font-size: 12px; 
            color: #777; 
            border-top: 1px solid #eaeaea; 
            padding-top: 15px;
            text-align: center;
        }
        .button {
            display: inline-block; 
            padding: 12px 25px; 
            background-color: #4CAF50; 
            color: white; 
            text-decoration: none; 
            border-radius: 4px;
            margin: 20px 0;
            font-weight: bold;
        }
        .signature {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eaeaea;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="header">
            <img src="{{ asset('logo/sulispmslogo.png') }}" alt="SulisMallHC Logo" class="logo">
            <h2 style="color: #2c3e50; margin: 10px 0 5px 0;">SulisMallHC</h2>
            <p style="color: #7f8c8d; margin: 0;">Your Trusted Property Management Partner</p>
        </div>

        <div class="content">
            <p>{!! $customMessage !!}</p>
        </div>

        <div class="footer">
            <p>&copy; {{ date('Y') }} SulisMallHC. All rights reserved.</p>
            
            @if(isset($bill->customer->CustomerEmail) && $bill->customer->CustomerEmail)
                <p style="margin-top: 5px; color: #95a5a6;">
                    This email was sent to {{ $bill->customer->CustomerEmail }}. 
                    @if(isset($bill->customer->CustomerID))
                        <br>Customer ID: {{ $bill->customer->CustomerID }}
                    @endif
                </p>
            @endif
    </div>
</body>
</html>
