<!DOCTYPE html>
<html>
<head>
    <title>Account Statement - {{ $company['name'] }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #0000FF;
        }
        .content {
            margin: 20px 0;
        }
        .footer {
            margin-top: 30px;
            padding-top: 10px;
            border-top: 1px solid #eee;
            font-size: 0.9em;
            color: #666;
        }
        .button {
            display: inline-block;
            padding: 10px 20px;
            background-color: #0000FF;
            color: white !important;
            text-decoration: none;
            border-radius: 4px;
            margin: 10px 0;
        }
        .details {
            background-color: #f9f9f9;
            padding: 15px;
            border-radius: 4px;
            margin: 15px 0;
        }
        .detail-row {
            margin: 8px 0;
        }
        .detail-label {
            font-weight: bold;
            color: #0000FF;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1 style="color: #0000FF;">{{ $company['name'] }}</h1>
    </div>
    
    <div class="content">
        <h2>Account Statement</h2>
        
        <p>Dear {{ $customer->CustomerName }},</p>
        
        <p>Please find attached your account statement for the period from 
        {{ $startDate->format('F j, Y') }} to {{ $endDate->format('F j, Y') }}.</p>
        
        <div class="details">
            <div class="detail-row">
                <span class="detail-label">Account Number:</span> {{ $customer->AccountNo }}
            </div>
            <div class="detail-row">
                <span class="detail-label">Statement Period:</span> {{ $startDate->format('F j, Y') }} - {{ $endDate->format('F j, Y') }}
            </div>
            <div class="detail-row">
                <span class="detail-label">Opening Balance:</span> {{ number_format($statement['summary']['opening_balance'], 2) }}
            </div>
            <div class="detail-row">
                <span class="detail-label">Total Debits:</span> {{ number_format($statement['summary']['total_debits'], 2) }}
            </div>
            <div class="detail-row">
                <span class="detail-label">Total Credits:</span> {{ number_format($statement['summary']['total_credits'], 2) }}
            </div>
            <div class="detail-row" style="font-weight: bold; font-size: 1.1em;">
                <span class="detail-label">Closing Balance:</span> {{ number_format($statement['summary']['closing_balance'], 2) }}
            </div>
        </div>
        
        <p>If you have any questions about this statement, please don't hesitate to contact us.</p>
        
        <p>Thank you for your business!</p>
        
        <p>Regards,<br>
        <strong>{{ $company['name'] }}</strong><br>
        {{ $company['address'] }}<br>
        Phone: {{ $company['phone'] }}<br>
        Email: {{ $company['email'] }}</p>
    </div>
    
    <div class="footer">
        <p>© {{ date('Y') }} {{ $company['name'] }}. All rights reserved.</p>
    </div>
</body>
</html>
