@extends('layouts.app')

@section('content')
<div class="container-fluid">
     <!-- Page Header -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">Bulk Invoices</h1>
            <p class="mb-0">Manage and track all utility invoices in one place</p>
        </div>
        <div class="d-flex">
            <a href="{{ route('invoices.bulk.create') }}" class="btn btn-primary shadow-sm">
                <i class="fas fa-plus-circle mr-2"></i>Create Invoice
            </a>
        </div>
    </div>

    <!-- Invoice List Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-column flex-md-row justify-content-between align-items-center bg-white">
            <h6 class="m-0 font-weight-bold text-white">Invoice List</h6>
            <div class="mt-3 mt-md-0 d-flex flex-column flex-md-row">
                <!-- Property Filter -->
                <form class="d-flex mb-2 mb-md-0 mr-3" action="{{ route('invoices.bulk.index') }}" method="GET">
                    <select name="property_id" class="form-control border-0 bg-light small" onchange="this.form.submit()">
                        <option value="">All Properties</option>
                        @foreach($properties as $id => $name)
                            <option value="{{ $id }}" {{ request('property_id') == $id ? 'selected' : '' }}>
                                {{ $name }}
                            </option>
                        @endforeach
                    </select>
                    <input type="hidden" name="search" value="{{ request('search') }}">
                    <input type="hidden" name="cons_type" value="{{ request('cons_type') }}">
                </form>

                <!-- Consumption Type Filter -->
                <form class="d-flex mb-2 mb-md-0 mr-3" action="{{ route('invoices.bulk.index') }}" method="GET">
                    <select name="cons_type" class="form-control border-0 bg-light small" onchange="this.form.submit()">
                        <option value="">All Types</option>
                        @foreach($consumptionTypes as $type)
                            <option value="{{ $type->tID }}" {{ request('cons_type') == $type->tID ? 'selected' : '' }}>
                                {{ $type->ConsTypeDescription ?? $type->ConsType }}
                            </option>
                        @endforeach
                    </select>
                    <input type="hidden" name="search" value="{{ request('search') }}">
                    <input type="hidden" name="property_id" value="{{ request('property_id') }}">
                </form>

                <!-- Search Form -->
                <form class="d-flex mb-2 mb-md-0" action="{{ route('invoices.bulk.index') }}" method="GET">
                    <div class="input-group">
                        <input type="text"
                               class="form-control border-0 bg-light small"
                               placeholder="Search invoices..."
                               name="search"
                               value="{{ request('search') }}"
                               aria-label="Search">
                        <div class="input-group-append">
                            <button class="btn btn-primary" type="submit">
                                <i class="fas fa-search fa-sm"></i>
                            </button>
                        </div>
                    </div>
                    <input type="hidden" name="property_id" value="{{ request('property_id') }}">
                    <input type="hidden" name="cons_type" value="{{ request('cons_type') }}">
                </form>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="invoices-table">
                    <thead class="border-bottom">
                        <tr>
                            <th class="text-nowrap">
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'InvoiceNo', 'direction' => request('sort') == 'InvoiceNo' && request('direction') == 'asc' ? 'desc' : 'asc']) }}" class="text-dark text-decoration-none">
                                    Invoice 
                                    @if(request('sort') == 'InvoiceNo')
                                        <i class="fas fa-sort-{{ request('direction') == 'asc' ? 'up' : 'down' }}"></i>
                                    @else
                                        <i class="fas fa-sort"></i>
                                    @endif
                                </a>
                            </th>
                            <th>
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'PropName', 'direction' => request('sort') == 'PropName' && request('direction') == 'asc' ? 'desc' : 'asc']) }}" class="text-dark text-decoration-none">
                                    Property
                                    @if(request('sort') == 'PropName')
                                        <i class="fas fa-sort-{{ request('direction') == 'asc' ? 'up' : 'down' }}"></i>
                                    @else
                                        <i class="fas fa-sort"></i>
                                    @endif
                                </a>
                            </th>
                            <th class="text-nowrap">Billing Period</th>
                            <th>Consumption Type</th>
                            <th class="text-right">
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'InvoiceAmount', 'direction' => request('sort') == 'InvoiceAmount' && request('direction') == 'asc' ? 'desc' : 'asc']) }}" class="text-dark text-decoration-none">
                                    Amount
                                    @if(request('sort') == 'InvoiceAmount')
                                        <i class="fas fa-sort-{{ request('direction') == 'asc' ? 'up' : 'down' }}"></i>
                                    @else
                                        <i class="fas fa-sort"></i>
                                    @endif
                                </a>
                            </th>
                            <th>Status</th>
                            <th class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($invoices as $invoice)
                        <tr class="align-middle hover:bg-gray-50 transition-colors">
                            <td class="font-weight-bold text-primary">{{ $invoice->InvoiceNo }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="flex-shrink-0 mr-3">
                                        <i class="fas fa-building text-muted"></i>
                                    </div>
                                    <div class="property-info">
                                        <div class="property-name">{{ $invoice->property->PropName ?? 'N/A' }}</div>
                                        <div class="property-code">{{ $invoice->property->PropCode ?? '' }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="text-nowrap">
                                <div class="d-flex flex-column">
                                    <span>{{ $invoice->BillingPeriod }}</span>
                                    <small class="text-muted">Due: {{ $invoice->DueDate->format('M d, Y') }}</small>
                                </div>
                            </td>
                            <td>
                                @php
                                    $consTypeData = \DB::table('tblconstype')->where('tID', $invoice->ConsType)->first();
                                    echo $consTypeData ? ($consTypeData->ConsTypeDescription ?? $consTypeData->ConsType) : 'N/A';
                                @endphp
                            </td>
                            <td class="text-right">
                                <div class="amount-display">KSh {{ number_format($invoice->InvoiceAmount, 0) }}</div>
                                @if($invoice->is_paid)
                                    <div class="text-success small mt-1">
                                        <i class="fas fa-check-circle"></i> Paid on {{ $invoice->updated_at->format('M d, Y') }}
                                    </div>
                                @endif
                            </td>
                            <td>
                                @if($invoice->is_paid)
                                    <span class="badge badge-success-light">
                                        <i class="fas fa-check-circle mr-1"></i> Paid
                                    </span>
                                @elseif($invoice->DueDate->isPast())
                                    <span class="badge badge-danger-light">
                                        <i class="fas fa-exclamation-circle mr-1"></i> Overdue
                                    </span>
                                @else
                                    <span class="badge badge-warning-light">
                                        <i class="fas fa-clock mr-1"></i> Pending
                                    </span>
                                @endif
                            </td>
                            <td class="text-center">
                    <div class="d-flex justify-content-center">
                                    <a href="{{ route('invoices.bulk.show', $invoice->BulkInvoiceID) }}" 
                                       class="btn btn-sm btn-icon btn-outline-primary mr-2" 
                                       data-toggle="tooltip" 
                                       data-placement="top" 
                                       title="View Details">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('invoices.bulk.print', $invoice->BulkInvoiceID) }}" 
                                       class="btn btn-sm btn-icon btn-outline-secondary mr-2" 
                                       target="_blank"
                                       data-toggle="tooltip" 
                                       data-placement="top" 
                                       title="Print Invoice">
                                        <i class="fas fa-print"></i>
                                    </a>
                                    <a href="{{ route('invoices.bulk.edit', $invoice->BulkInvoiceID) }}"
                                       class="btn btn-sm btn-icon btn-outline-warning"
                                       data-toggle="tooltip" 
                                       data-placement="top" 
                                       title="Edit Invoice">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center">
                                <div class="empty-state">
                                    <div class="empty-state-icon">
                                        <i class="fas fa-file-invoice fa-4x"></i>
                                    </div>
                                    <h5 class="empty-state-title">No Invoices Found</h5>
                                    <p class="empty-state-text">
                                        @if(request('search') || request('property_id') || request('cons_type'))
                                            No invoices match your search criteria. Try adjusting your filters.
                                        @else
                                            You don't have any utility invoices yet.
                                        @endif
                                    </p>
                                    <a href="{{ route('invoices.bulk.create') }}" class="btn btn-primary">
                                        <i class="fas fa-plus-circle mr-2"></i>Create Your First Invoice
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            @if($invoices->hasPages())
            <div class="pagination-container">
                <div class="mb-3 mb-md-0">
                    <p class="pagination-info mb-0">
                        Showing <span class="font-weight-bold">{{ $invoices->firstItem() }}</span> to 
                        <span class="font-weight-bold">{{ $invoices->lastItem() }}</span> of 
                        <span class="font-weight-bold">{{ $invoices->total() }}</span> entries
                    </p>
                </div>
                <nav aria-label="Page navigation">
                    {{ $invoices->withQueryString()->links() }}
                </nav>
            </div>
            @endif
        </div>
    </div>

@endsection

@push('styles')
<style>
    /* Professional Header Styling */
    .professional-header {
        position: relative;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 3rem 0 4rem 0;
        margin: -1rem -1rem 3rem -1rem;
        overflow: hidden;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    }

    .header-background {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        z-index: 1;
    }

    .header-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.3);
        z-index: 2;
    }

    .header-pattern {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-image: radial-gradient(circle at 20% 80%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
                          radial-gradient(circle at 80% 20%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
                          radial-gradient(circle at 40% 40%, rgba(255, 255, 255, 0.05) 0%, transparent 50%);
        z-index: 3;
    }

    .professional-header .container-fluid {
        position: relative;
        z-index: 4;
    }

    .header-content {
        padding-right: 2rem;
    }

    .header-badge {
        display: inline-flex;
        align-items: center;
        background: rgba(255, 255, 255, 0.2);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.3);
        border-radius: 50px;
        padding: 0.5rem 1rem;
        margin-bottom: 1.5rem;
        font-size: 0.875rem;
        font-weight: 600;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    }

    .header-badge i {
        margin-right: 0.5rem;
        color: #fbbf24;
    }

    .header-title {
        font-size: 3rem;
        font-weight: 800;
        margin-bottom: 1rem;
        line-height: 1.1;
        letter-spacing: -0.02em;
        text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }

    .header-icon {
        color: #fbbf24;
        margin-right: 0.75rem;
        filter: drop-shadow(0 2px 4px rgba(0, 0, 0, 0.1));
    }

    .header-subtitle {
        font-size: 1.25rem;
        line-height: 1.6;
        opacity: 0.95;
        margin-bottom: 2rem;
        font-weight: 400;
        max-width: 600px;
    }

    .header-features {
        display: flex;
        flex-wrap: wrap;
        gap: 1rem;
        margin-top: 2rem;
    }

    .feature-item {
        display: flex;
        align-items: center;
        background: rgba(255, 255, 255, 0.15);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
        border-radius: 0.5rem;
        padding: 0.75rem 1rem;
        font-size: 0.875rem;
        font-weight: 600;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        transition: all 0.3s ease;
    }

    .feature-item:hover {
        background: rgba(255, 255, 255, 0.25);
        transform: translateY(-2px);
    }

    .feature-item i {
        margin-right: 0.5rem;
        color: #fbbf24;
        font-size: 1rem;
    }

    .header-actions-section {
        display: flex;
        flex-direction: column;
        align-items: flex-end;
        gap: 2rem;
    }

    .quick-actions {
        margin-bottom: 1rem;
    }

    .btn-create-main {
        display: inline-flex;
        align-items: center;
        background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%);
        color: #92400e;
        border: none;
        border-radius: 0.75rem;
        padding: 1rem 2rem;
        font-weight: 700;
        font-size: 1rem;
        text-decoration: none;
        box-shadow: 0 8px 25px rgba(245, 158, 11, 0.3);
        transition: all 0.3s ease;
        min-width: 280px;
        justify-content: center;
    }

    .btn-create-main:hover {
        background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        transform: translateY(-3px);
        box-shadow: 0 12px 35px rgba(245, 158, 11, 0.4);
        color: #92400e;
    }

    .btn-icon-large {
        width: 48px;
        height: 48px;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.2);
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 1rem;
        font-size: 1.25rem;
        backdrop-filter: blur(10px);
    }

    .btn-content {
        text-align: left;
    }

    .btn-title {
        font-size: 1.125rem;
        font-weight: 700;
        margin-bottom: 0.125rem;
        display: block;
    }

    .btn-subtitle {
        font-size: 0.875rem;
        opacity: 0.9;
        font-weight: 500;
    }

    .stats-overview {
        display: flex;
        gap: 1rem;
        flex-wrap: wrap;
        justify-content: flex-end;
    }

    .stat-card {
        background: rgba(255, 255, 255, 0.15);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
        border-radius: 0.75rem;
        padding: 1.25rem;
        min-width: 120px;
        text-align: center;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        transition: all 0.3s ease;
    }

    .stat-card:hover {
        background: rgba(255, 255, 255, 0.25);
        transform: translateY(-2px);
    }

    .stat-icon {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.2);
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 0.75rem;
        font-size: 1.125rem;
        backdrop-filter: blur(10px);
    }

    .stat-icon.success {
        background: rgba(34, 197, 94, 0.3);
        color: #16a34a;
    }

    .stat-content {
        color: white;
    }

    .stat-number {
        font-size: 2rem;
        font-weight: 800;
        display: block;
        margin-bottom: 0.25rem;
        text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }

    .stat-label {
        font-size: 0.875rem;
        font-weight: 600;
        opacity: 0.9;
        text-transform: uppercase;
        letter-spacing: 0.05em;
    }

    /* Decorative Elements */
    .header-decoration {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 100px;
        overflow: hidden;
        z-index: 3;
    }

    .decoration-circle {
        position: absolute;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.1);
        backdrop-filter: blur(20px);
    }

    .circle-1 {
        width: 200px;
        height: 200px;
        top: -100px;
        right: 10%;
        animation: float 6s ease-in-out infinite;
    }

    .circle-2 {
        width: 150px;
        height: 150px;
        bottom: -75px;
        left: 15%;
        animation: float 8s ease-in-out infinite reverse;
    }

    .decoration-dots {
        position: absolute;
        bottom: 20px;
        left: 50%;
        transform: translateX(-50%);
        display: flex;
        gap: 0.5rem;
    }

    .decoration-dots span {
        width: 6px;
        height: 6px;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.4);
        animation: pulse 2s ease-in-out infinite;
    }

    .decoration-dots span:nth-child(2) { animation-delay: 0.5s; }
    .decoration-dots span:nth-child(3) { animation-delay: 1s; }

    @keyframes float {
        0%, 100% { transform: translateY(0px) rotate(0deg); }
        50% { transform: translateY(-20px) rotate(180deg); }
    }

    @keyframes pulse {
        0%, 100% { opacity: 0.4; transform: scale(1); }
        50% { opacity: 1; transform: scale(1.2); }
    }

    /* Responsive Header */
    @media (max-width: 992px) {
        .professional-header {
            padding: 2rem 0 3rem 0;
        }

        .header-title {
            font-size: 2.5rem;
        }

        .header-actions-section {
            align-items: center;
            margin-top: 2rem;
        }

        .stats-overview {
            justify-content: center;
        }

        .btn-create-main {
            min-width: 250px;
        }
    }

    @media (max-width: 768px) {
        .professional-header {
            padding: 2rem 0;
            text-align: center;
        }

        .header-content {
            padding-right: 0;
            text-align: center;
        }

        .header-title {
            font-size: 2rem;
        }

        .header-features {
            justify-content: center;
        }

        .header-actions-section {
            align-items: center;
        }

        .stats-overview {
            justify-content: center;
        }

        .stat-card {
            min-width: 100px;
        }

        .btn-create-main {
            min-width: 220px;
        }

        .circle-1, .circle-2 {
            display: none;
        }
    }

    /* Professional Color Palette */
    :root {
        --primary-color: #1a365d;
        --primary-light: #2d3748;
        --secondary-color: #3182ce;
        --accent-color: #e53e3e;
        --success-color: #38a169;
        --warning-color: #d69e2e;
        --danger-color: #e53e3e;
        --light-bg: #f7fafc;
        --border-color: #e2e8f0;
        --text-primary: #2d3748;
        --text-secondary: #718096;
        --shadow-sm: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
        --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
    }

    /* Page Header Enhancement */
    .page-header {
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-light) 100%);
        color: white;
        padding: 2rem 0;
        margin: -1rem -1rem 2rem -1rem;
        border-radius: 0 0 1rem 1rem;
        box-shadow: var(--shadow-md);
    }

    .page-header h1 {
        font-size: 2.25rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
        letter-spacing: -0.025em;
    }

    .page-header p {
        font-size: 1.125rem;
        opacity: 0.9;
        margin-bottom: 0;
        font-weight: 400;
    }

    /* Card Styling - Professional Look */
    .card {
        border: none;
        border-radius: 0.75rem;
        box-shadow: var(--shadow-lg);
        overflow: hidden;
        background: white;
        margin-bottom: 2rem;
    }

    .card-header {
        background: linear-gradient(135deg, #0000fe 0%, #ffff01 50%, #0000fe 100%);
        color: white;
        padding: 1.5rem 2rem;
        border-bottom: none;
        border-radius: 0.75rem 0.75rem 0 0;
        position: relative;
        overflow: hidden;
    }

    .card-header::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(45deg, rgba(255, 255, 255, 0.1) 0%, transparent 50%);
        pointer-events: none;
    }

    .card-header h6 {
        font-weight: 700;
        font-size: 1.25rem;
        letter-spacing: 0.025em;
        text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        margin: 0;
        position: relative;
        z-index: 1;
    }

    .card-header .d-flex {
        position: relative;
        z-index: 1;
    }

    .card-body {
        padding: 0;
    }

    /* Table Professional Styling */
    .table-responsive {
        border-radius: 0 0 0.75rem 0.75rem;
        overflow: hidden;
    }

    .table {
        margin-bottom: 0;
        font-size: 0.875rem;
        font-weight: 500;
    }

    .table thead th {
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        border: none;
        border-bottom: 2px solid var(--primary-color);
        font-weight: 700;
        text-transform: uppercase;
        font-size: 0.75rem;
        letter-spacing: 0.05em;
        color: var(--text-primary);
        padding: 1.25rem 1rem;
        white-space: nowrap;
        position: sticky;
        top: 0;
        z-index: 10;
    }

    .table thead th a {
        color: var(--text-primary);
        text-decoration: none;
        font-weight: 700;
    }

    .table thead th a:hover {
        color: var(--secondary-color);
    }

    .table tbody td {
        padding: 1.25rem 1rem;
        vertical-align: middle;
        border: 1px solid #f1f5f9;
        border-top: none;
        color: var(--text-primary);
        font-weight: 500;
    }

    .table tbody tr {
        transition: all 0.2s ease;
        border-bottom: 1px solid #f1f5f9;
    }

    .table tbody tr:hover {
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        transform: translateY(-1px);
        box-shadow: var(--shadow-md);
    }

    .table tbody tr:last-child {
        border-bottom: none;
    }

    /* Form Controls - Professional Styling */
    .form-control, .form-select {
        border: 2px solid #e2e8f0;
        border-radius: 0.5rem;
        padding: 0.75rem 1rem;
        font-size: 0.875rem;
        font-weight: 500;
        color: var(--text-primary);
        background-color: #f8fafc;
        transition: all 0.2s ease;
    }

    .form-control:focus, .form-select:focus {
        border-color: var(--secondary-color);
        box-shadow: 0 0 0 3px rgba(49, 130, 206, 0.1);
        background-color: white;
        transform: translateY(-1px);
    }

    .input-group-text {
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-light) 100%);
        color: white;
        border: none;
        border-radius: 0 0.5rem 0.5rem 0;
        font-weight: 600;
    }

    /* Button Styling - Professional */
    .btn {
        font-weight: 600;
        letter-spacing: 0.025em;
        border-radius: 0.5rem;
        padding: 0.75rem 1.5rem;
        transition: all 0.2s ease;
        box-shadow: var(--shadow-sm);
    }

    .btn:hover {
        transform: translateY(-1px);
        box-shadow: var(--shadow-md);
    }

    .btn-primary {
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-light) 100%);
        border: none;
        color: white;
    }

    .btn-primary:hover {
        background: linear-gradient(135deg, var(--primary-light) 0%, var(--primary-color) 100%);
    }

    .btn-outline-primary {
        border: 2px solid var(--secondary-color);
        color: var(--secondary-color);
        background: transparent;
    }

    .btn-outline-primary:hover {
        background: var(--secondary-color);
        border-color: var(--secondary-color);
        color: white;
    }

    .btn-outline-secondary {
        border: 2px solid var(--text-secondary);
        color: var(--text-secondary);
    }

    .btn-outline-secondary:hover {
        background: var(--text-secondary);
        color: white;
    }

    .btn-outline-warning {
        border: 2px solid var(--warning-color);
        color: var(--warning-color);
    }

    .btn-outline-warning:hover {
        background: var(--warning-color);
        color: white;
    }

    /* Icon Buttons - Professional */
    .btn-icon {
        width: 40px;
        height: 40px;
        padding: 0;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        border-radius: 50% !important;
        box-shadow: var(--shadow-sm);
        transition: all 0.2s ease;
    }

    .btn-icon:hover {
        transform: scale(1.05);
        box-shadow: var(--shadow-md);
    }

    .btn-sm.btn-icon {
        width: 32px;
        height: 32px;
    }

    /* Badge Styling - Professional */
    .badge {
        font-size: 0.75rem;
        font-weight: 700;
        letter-spacing: 0.025em;
        padding: 0.5rem 0.875rem;
        border-radius: 9999px;
        box-shadow: var(--shadow-sm);
        border: 1px solid transparent;
    }

    .badge-success-light {
        background: linear-gradient(135deg, #c6f6d5 0%, #9ae6b4 100%);
        color: #22543d;
        border-color: #68d391;
    }

    .badge-warning-light {
        background: linear-gradient(135deg, #fef5e7 0%, #fde68a 100%);
        color: #744210;
        border-color: #f6ad55;
    }

    .badge-danger-light {
        background: linear-gradient(135deg, #fed7d7 0%, #fca5a5 100%);
        color: #742a2a;
        border-color: #fc8181;
    }

    /* Typography Improvements */
    .font-weight-bold {
        font-weight: 700 !important;
    }

    .text-primary {
        color: var(--primary-color) !important;
    }

    .text-muted {
        color: var(--text-secondary) !important;
    }

    /* Property Display Enhancement */
    .property-info {
        line-height: 1.4;
    }

    .property-name {
        font-weight: 600;
        color: var(--text-primary);
        margin-bottom: 0.125rem;
    }

    .property-code {
        font-size: 0.75rem;
        color: var(--text-secondary);
        font-weight: 500;
    }

    /* Amount Display */
    .amount-display {
        font-size: 1rem;
        font-weight: 700;
        color: var(--primary-color);
    }

    /* Status Indicators */
    .status-indicator {
        display: inline-block;
        width: 8px;
        height: 8px;
        border-radius: 50%;
        margin-right: 0.5rem;
        box-shadow: var(--shadow-sm);
    }

    /* Pagination Styling */
    .pagination-container {
        background: var(--light-bg);
        padding: 1.5rem 2rem;
        border-top: 2px solid var(--border-color);
        border-radius: 0 0 0.75rem 0.75rem;
    }

    .pagination-info {
        font-weight: 600;
        color: var(--text-secondary);
        font-size: 0.875rem;
    }

    /* Empty State Enhancement */
    .empty-state {
        padding: 4rem 2rem;
        text-align: center;
    }

    .empty-state-icon {
        color: var(--text-secondary);
        opacity: 0.5;
        margin-bottom: 1.5rem;
    }

    .empty-state h5 {
        font-weight: 700;
        color: var(--text-primary);
        margin-bottom: 1rem;
    }

    .empty-state p {
        color: var(--text-secondary);
        font-size: 1.125rem;
        margin-bottom: 2rem;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .page-header {
            padding: 1.5rem 0;
            margin: -1rem -1rem 1.5rem -1rem;
        }

        .page-header h1 {
            font-size: 1.875rem;
        }

        .card-header {
            padding: 1rem 1.5rem;
            flex-direction: column;
            align-items: flex-start !important;
        }

        .card-header .d-flex {
            width: 100%;
            justify-content: space-between;
            margin-top: 1rem;
        }

        .table-responsive {
            border-radius: 0;
        }

        .table {
            font-size: 0.8rem;
        }

        .table thead th,
        .table tbody td {
            padding: 0.75rem 0.5rem;
        }

        .btn {
            padding: 0.5rem 1rem;
            font-size: 0.875rem;
        }

        .btn-icon {
            width: 36px;
            height: 36px;
        }

        .pagination-container {
            padding: 1rem 1.5rem;
        }
    }

    /* Loading States */
    .loading-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(255, 255, 255, 0.8);
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 1000;
    }

    /* Animation Enhancements */
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .card {
        animation: fadeIn 0.3s ease-out;
    }

    .table tbody tr {
        animation: fadeIn 0.2s ease-out;
        animation-fill-mode: both;
    }

    .table tbody tr:nth-child(1) { animation-delay: 0.05s; }
    .table tbody tr:nth-child(2) { animation-delay: 0.1s; }
    .table tbody tr:nth-child(3) { animation-delay: 0.15s; }
    .table tbody tr:nth-child(4) { animation-delay: 0.2s; }
    .table tbody tr:nth-child(5) { animation-delay: 0.25s; }

    /* Focus States for Accessibility */
    .btn:focus,
    .form-control:focus,
    .form-select:focus {
        outline: none;
        box-shadow: 0 0 0 3px rgba(49, 130, 206, 0.1);
    }

    /* Print Styles */
    @media print {
        .card {
            box-shadow: none;
            border: 1px solid #ddd;
        }

        .btn,
        .card-header .d-flex {
            display: none !important;
        }
    }
</style>
@endpush

@push('scripts')
<script>
    $(document).ready(function() {
        // Initialize tooltips
        $('[data-toggle="tooltip"]').tooltip({
            trigger: 'hover',
            placement: 'top'
        });
        
        // Add loading state to form submit buttons
        $('form').on('submit', function() {
            const $submitBtn = $(this).find('button[type="submit"]');
            if ($submitBtn.length) {
                $submitBtn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm mr-2" role="status" aria-hidden="true"></span>Processing...');
            }
        });
        
        // Prevent double-clicks on buttons with a small delay
        $('a.btn, button').on('click', function(e) {
            const $btn = $(this);
            if ($btn.attr('type') === 'submit' || $btn.closest('form').length) {
                return; // Let the form submit handler handle this
            }
            
            if ($btn.data('clicked')) {
                e.preventDefault();
                e.stopImmediatePropagation();
                return false;
            }
            
            $btn.data('clicked', true);
            setTimeout(() => {
                $btn.removeData('clicked');
            }, 1000);
        });
        
        // Make table rows clickable
        $('tr[data-href]').on('click', function() {
            window.location.href = $(this).data('href');
        });
    });
</script>
@endpush