<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Bulk Invoice #{{ $invoice->InvoiceNo }}</title>
    <style>
        /* Base Styles */
        :root {
            --sulis-primary: #1a3e72;    /* Dark blue from logo */
            --sulis-secondary: #00a651;  /* Green from logo */
            --sulis-accent: #f7931e;     /* Orange from logo */
            --sulis-light: #e6f0f9;      /* Light blue background */
        }
        
        @page {
            margin: 1.5cm 1cm;
            size: A4 portrait;
        }
        
        body {
            font-family: 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.5;
            color: #333;
            font-size: 12px;
            margin: 0;
            padding: 0;
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }
        
        /* Layout */
        .container {
            max-width: 100%;
            padding: 0 20px;
        }
        
        /* Header */
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 15px;
            border-bottom: 2px solid var(--sulis-secondary);
            position: relative;
        }
        
        /* Logo */
        .logo-container {
            margin-bottom: 10px;
            text-align: center;
        }
        
        .logo {
            max-width: 200px;
            max-height: 100px;
            object-fit: contain;
        }
        
        .company-name-logo {
            background: linear-gradient(135deg, var(--sulis-primary), var(--sulis-secondary));
            color: white;
            width: 100px;
            height: 100px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 48px;
            font-weight: bold;
            margin: 0 auto;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        
        .header h1 {
            color: var(--sulis-primary);
            margin: 0 0 10px 0;
            font-size: 24px;
            text-align: center;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .header p {
            margin: 5px 0;
            color: #666;
            font-size: 12px;
        }
        
        /* Invoice Info */
        .invoice-header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 25px;
        }
        
        .invoice-info, .billing-info {
            width: 48%;
        }
        
        .info-box {
            background: #ffffff;
            border: 1px solid #e0e0e0;
            border-radius: 6px;
            padding: 18px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        
        .info-box h3 {
            margin-top: 0;
            color: var(--sulis-primary);
            font-size: 15px;
            margin-bottom: 15px;
            padding-bottom: 8px;
            border-bottom: 2px solid var(--sulis-secondary);
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .info-row {
            display: flex;
            margin-bottom: 10px;
            font-size: 13px;
            line-height: 1.4;
        }
        
        .info-label {
            font-weight: 600;
            min-width: 120px;
            color: #495057;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        
        th {
            background-color: var(--sulis-primary);
            color: white;
            border: 1px solid var(--sulis-primary);
            padding: 10px 12px;
            text-align: left;
            font-weight: 600;
            font-size: 11px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        td {
            padding: 10px;
            border: 1px solid #dee2e6;
            vertical-align: top;
            font-size: 11px;
        }
        
        tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        
        /* Totals */
        .totals-table {
            width: 300px;
            margin-left: auto;
            margin-top: 10px;
        }
        
        .totals-table td {
            text-align: right;
            border: none;
            padding: 5px 10px;
        }
        
        .totals-table tr:last-child td {
            font-weight: bold;
            font-size: 13px;
            border-top: 2px solid #dee2e6;
        }
        
        /* Footer */
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background-color: #f8f9fa;
            padding: 15px 20px;
            border-top: 2px solid #dee2e6;
            text-align: center;
            font-size: 10px;
            color: #6c757d;
        }
        
        .footer p {
            margin: 3px 0;
        }
        
        /* Status Badge */
        .status-badge {
            display: inline-block;
            padding: 3px 8px;
            border-radius: 3px;
            font-size: 10px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .status-pending {
            background-color: var(--sulis-accent);
            color: white;
        }
        
        .status-paid {
            background-color: var(--sulis-secondary);
            color: white;
        }
        
        /* Utility Classes */
        .text-right {
            text-align: right;
            font-weight: 600;
            color: var(--sulis-primary);
        }
        
        .text-center {
            text-align: center;
        }
        
        .text-uppercase {
            text-transform: uppercase;
        }
        
        .mb-0 {
            margin-bottom: 0;
        }
        
        .mt-4 {
            margin-top: 1.5rem;
        }
        
        .pb-2 {
            padding-bottom: 0.5rem;
        }
        
        /* Print Specific Styles */
        @media print {
            body {
                font-size: 11px;
            }
            
            .header {
                margin-bottom: 20px;
            }
            
            .info-box {
                page-break-inside: avoid;
            }
            
            table {
                page-break-inside: auto;
            }
            
            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }
            
            thead {
                display: table-header-group;
            }
            
            tfoot {
                display: table-footer-group;
            }
            
            .no-print {
                display: none !important;
            }
            
            .footer {
                position: fixed;
                bottom: 0;
            }
            
            @page {
                margin: 1.5cm 1cm;
            }
        }
        @media print {
            .no-print {
                display: none !important;
            }
            body {
                font-size: 11pt;
            }
            .container {
                width: 100%;
                margin: 0;
                padding: 0;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header with Logo and Company Info -->
        <div class="header">
            <div class="logo-container">
            
                @php
                    $logoName = $invoice->company?->CompanyLogo;
                    $logoPath = $logoName ? public_path('logo' . DIRECTORY_SEPARATOR . $logoName) : '';
                    $logoPath = str_replace(['/', '\\'], DIRECTORY_SEPARATOR, $logoPath);
                    // Use direct URL instead of asset() to avoid any path issues
                    $logoUrl = $logoName ? url('/logo/' . $logoName) : '';
                @endphp
                
                @if($invoice->company && $invoice->company->CompanyLogo && file_exists($logoPath))
                    <!-- Debug: Logo Path: {{ $logoPath }} -->
                    <!-- Debug: Logo URL: {{ $logoUrl }} -->
                    <img src="{{ $logoUrl }}" alt="{{ $invoice->company->CompanyName }}" class="logo" style="max-width: 200px; max-height: 100px;">
                @else
                    <!-- Debug: Fallback to company initial -->
                    <div class="company-name-logo" style="background-color: #0056b3; color: white; width: 100px; height: 100px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 48px; font-weight: bold; margin: 0 auto;">
                        {{ substr($invoice->company->CompanyName ?? 'Bulk Utility', 0, 1) }}
                    </div>
                @endif
            </div>
            <h1>BULK INVOICE</h1>
            <div class="company-details">
                <p class="mb-0"><strong>{{ $invoice->company->CompanyName ?? 'Bulk Utility Services' }}</strong></p>
                <p class="mb-0">{{ $invoice->company->CompanyAddress ?? 'P.O. Box 00000, Nairobi, Kenya' }}</p>
                <p class="mb-0">{{ $invoice->company->CompanyEmail ? 'Email: ' . $invoice->company->CompanyEmail : 'Email: info@company.com' }} | {{ $invoice->company->CompanyPhone ? 'Tel: ' . $invoice->company->CompanyPhone : 'Tel: +254 20 000 0000' }}</p>
                <p>{{ $invoice->company->CompanyVATNo ? 'VAT No: ' . $invoice->company->CompanyVATNo : 'VAT No: P00000000000' }} | {{ $invoice->company->CompanyPIN ? 'PIN: ' . $invoice->company->CompanyPIN : 'PIN: P00000000000' }}</p>
            </div>
        </div>

        <!-- Invoice and Billing Info -->
        <div class="invoice-header mt-4">
            <div class="row">
                <!-- Bill To Section -->
                <div class="col-md-6">
                    <div class="info-box h-100">
                        <h3>Bill To</h3>
                        <div class="info-row">
                            <div class="info-label">Property:</div>
                            <div>{{ $invoice->property->PropName ?? 'N/A' }}</div>
                        </div>
                        @if($invoice->property->PropAddress)
                        <div class="info-row">
                            <div class="info-label">Address:</div>
                            <div>{{ $invoice->property->PropAddress }}</div>
                        </div>
                        @endif
                        @if($invoice->property->PropCity || $invoice->property->PropCountry)
                        <div class="info-row">
                            <div class="info-label">Location:</div>
                            <div>{{ $invoice->property->PropCity ?? '' }}{{ $invoice->property->PropCity && $invoice->property->PropCountry ? ', ' : '' }}{{ $invoice->property->PropCountry ?? '' }}</div>
                        </div>
                        @endif
                        @if($invoice->property->PropPostalCode)
                        <div class="info-row">
                            <div class="info-label">Postal Code:</div>
                            <div>{{ $invoice->property->PropPostalCode }}</div>
                        </div>
                        @endif
                    </div>
                </div>
                
                <!-- Invoice Details Section -->
                <div class="col-md-6">
                    <div class="info-box h-100">
                        <h3>Invoice Details</h3>
                        <div class="info-row">
                            <div class="info-label">Invoice #:</div>
                            <div><strong>{{ $invoice->InvoiceNo }}</strong></div>
                        </div>
                        <div class="info-row">
                            <div class="info-label">Date:</div>
                            <div>{{ $invoice->InvoiceDate->format('F j, Y') }}</div>
                        </div>
                        <div class="info-row">
                            <div class="info-label">Due Date:</div>
                            <div class="{{ $invoice->DueDate->isPast() && $invoice->Status !== 'Paid' ? 'text-danger' : '' }}">
                                {{ $invoice->DueDate->format('F j, Y') }}
                                @if($invoice->DueDate->isPast() && $invoice->Status !== 'Paid')
                                    <span class="status-badge status-pending ms-2">Overdue</span>
                                @endif
                            </div>
                        </div>
                        <div class="info-row">
                            <div class="info-label">Status:</div>
                            <div>
                                @if($invoice->Status === 'Paid')
                                    <span class="status-badge status-paid">Paid</span>
                                @else
                                    <span class="status-badge status-pending">Pending</span>
                                @endif
                            </div>
                        </div>
                        <div class="info-row">
                            <div class="info-label">Billing Period:</div>
                            <div>{{ $invoice->BillingPeriod }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Meter Readings -->
        @if($invoice->PreviousReading1 !== null || $invoice->CurrentReading1 !== null)
        <div class="info-box mt-4">
            <h3>Meter Readings</h3>
            <table>
                <thead>
                    <tr>
                        <th>Meter</th>
                        <th>Previous Reading</th>
                        <th>Current Reading</th>
                        <th>Consumption (kWh)</th>
                        <th>Rate (KSh)</th>
                        <th>Amount (KSh)</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $totalConsumption = 0;
                        $totalAmount = 0;
                    @endphp
                    
                    @if($invoice->PreviousReading1 !== null || $invoice->CurrentReading1 !== null)
                        @php
                            $consumption = ($invoice->PreviousReading1 !== null && $invoice->CurrentReading1 !== null) 
                                ? $invoice->CurrentReading1 - $invoice->PreviousReading1 
                                : 0;
                            $rate = $invoice->bulkInvoiceLines->where('BulkLineDesc', 'like', '%consumption%')->first()->BulkLineUnitPrice ?? 0;
                            $amount = $consumption * $rate;
                            $totalConsumption += $consumption;
                            $totalAmount += $amount;
                        @endphp
                        <tr>
                            <td>Meter 1</td>
                            <td>{{ number_format($invoice->PreviousReading1 ?? 0, 2) }}</td>
                            <td>{{ number_format($invoice->CurrentReading1 ?? 0, 2) }}</td>
                            <td class="text-right">{{ number_format($consumption, 2) }}</td>
                            <td class="text-right">{{ number_format($rate, 2) }}</td>
                            <td class="text-right">{{ number_format($amount, 2) }}</td>
                        </tr>
                    @endif
                    
                    @if($invoice->PreviousReading2 !== null || $invoice->CurrentReading2 !== null)
                        @php
                            $consumption = ($invoice->PreviousReading2 !== null && $invoice->CurrentReading2 !== null) 
                                ? $invoice->CurrentReading2 - $invoice->PreviousReading2 
                                : 0;
                            $rate = $invoice->bulkInvoiceLines->where('BulkLineDesc', 'like', '%consumption%')->first()->BulkLineUnitPrice ?? 0;
                            $amount = $consumption * $rate;
                            $totalConsumption += $consumption;
                            $totalAmount += $amount;
                        @endphp
                        <tr>
                            <td>Meter 2</td>
                            <td>{{ number_format($invoice->PreviousReading2 ?? 0, 2) }}</td>
                            <td>{{ number_format($invoice->CurrentReading2 ?? 0, 2) }}</td>
                            <td class="text-right">{{ number_format($consumption, 2) }}</td>
                            <td class="text-right">{{ number_format($rate, 2) }}</td>
                            <td class="text-right">{{ number_format($amount, 2) }}</td>
                        </tr>
                    @endif
                    
                    @if(($invoice->PreviousReading1 !== null || $invoice->CurrentReading1 !== null) && 
                        ($invoice->PreviousReading2 !== null || $invoice->CurrentReading2 !== null))
                        <tr>
                            <td colspan="3" class="text-right"><strong>Total:</strong></td>
                            <td class="text-right"><strong>{{ number_format($totalConsumption, 2) }}</strong></td>
                            <td></td>
                            <td class="text-right"><strong>{{ number_format($totalAmount, 2) }}</strong></td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
        @endif

        <!-- Invoice Items -->
        <div class="info-box mt-4">
            <h3>Invoice Items</h3>
            <table>
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Description</th>
                        <th class="text-right">Quantity</th>
                        <th class="text-right">Unit Price (KSh)</th>
                        <th class="text-right">Amount (KSh)</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $subtotal = 0;
                        $hasQuantity = $invoice->bulkInvoiceLines->contains(function($item) {
                            return isset($item->BulkLineQty) && $item->BulkLineQty > 0;
                        });
                    @endphp
                    
                    @forelse($invoice->bulkInvoiceLines as $line)
                        @php
                            $quantity = $hasQuantity ? ($line->BulkLineQty ?? 1) : 1;
                            $unitPrice = $line->BulkLineUnitPrice;
                            $amount = $line->BulkLineAmount;
                            $subtotal += $amount;
                        @endphp
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $line->BulkLineDesc }}</td>
                            <td class="text-right">{{ $hasQuantity ? number_format($quantity, 2) : 'N/A' }}</td>
                            <td class="text-right">{{ number_format($unitPrice, 4) }}</td>
                            <td class="text-right">{{ number_format($amount, 2) }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center py-3">No line items found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
            
            <!-- Totals -->
            <div class="mt-4">
                <table class="totals-table">
                    <tr>
                        <td>Subtotal:</td>
                        <td>KSh {{ number_format($subtotal, 2) }}</td>
                    </tr>
                    @if($invoice->FixedAmount > 0)
                    <tr>
                        <td>Fixed Charges:</td>
                        <td>KSh {{ number_format($invoice->FixedAmount, 2) }}</td>
                    </tr>
                    @endif
                    @if($invoice->ConsAmount > 0)
                    <tr>
                        <td>Consumption ({{ $totalConsumption ?? 0 }} kWh):</td>
                        <td>KSh {{ number_format($invoice->ConsAmount, 2) }}</td>
                    </tr>
                    @endif
                    <tr>
                        <td><strong>Total Amount:</strong></td>
                        <td><strong>KSh {{ number_format($invoice->InvoiceAmount, 2) }}</strong></td>
                    </tr>
                    <tr>
                        <td>Amount Due:</td>
                        <td class="{{ $invoice->Status === 'Paid' ? 'text-success' : 'text-danger' }}">
                            <strong>KSh {{ number_format($invoice->Status === 'Paid' ? 0 : $invoice->InvoiceAmount, 2) }}</strong>
                        </td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- Additional Information -->
        @if($invoice->InvoiceComments)
        <div class="info-box mt-4">
            <h3>Additional Information</h3>
            <div style="white-space: pre-line;">{{ $invoice->InvoiceComments }}</div>
        </div>
        @endif
        
        <!-- Payment Instructions -->
        <div class="info-box mt-4">
            <h3>Payment Instructions</h3>
            <p>Please make payment using one of the following methods:</p>
            <p><strong>Bank Transfer:</strong></p>
            <p><strong>Bank:</strong> {{ $invoice->company->CompanyBank ?? 'Bank Name' }}</p>
            <p><strong>Account Name:</strong> {{ $invoice->company->CompanyName ?? 'Company Name' }}</p>
            <p><strong>Account Number:</strong> {{ $invoice->company->CompanyAccount ?? '1234567890' }}</p>
            <p><strong>Branch:</strong> {{ $invoice->company->CompanyBranch ?? 'Main Branch' }}</p>
            @if($invoice->company->CompanySwift)
            <p><strong>SWIFT Code:</strong> {{ $invoice->company->CompanySwift }}</p>
            @endif
            <p class="mt-3">Please quote your invoice number as the payment reference.</p>
            <p><strong>M-Pesa Paybill:</strong> {{ $invoice->company->CompanyPaybill ?? 'Business Number: 000000, Account: Invoice Number' }}</p>
        </div>

        <!-- Footer -->
        <div class="footer no-print">
            <p class="mb-1"><strong>{{ $invoice->company->CompanyName ?? 'Bulk Utility Services' }}</strong> | {{ $invoice->company->CompanyAddress ?? 'P.O. Box 00000, Nairobi, Kenya' }}</p>
            <p class="mb-1">{{ $invoice->company->CompanyPhone ? 'Customer Service: ' . $invoice->company->CompanyPhone : 'Customer Service: Contact us for support' }} | {{ $invoice->company->CompanyEmail ? 'Email: ' . $invoice->company->CompanyEmail : 'Email: info@company.com' }} | {{ $invoice->company->CompanyWebsite ? 'Website: ' . $invoice->company->CompanyWebsite : 'Website: www.company.com' }}</p>
            <p class="mb-0">This is a computer-generated invoice. No signature required.</p>
        </div>

        <!-- Print and close buttons are not needed in PDF -->
        <style>
            @media print {
                body { 
                    font-size: 10pt !important;
                    line-height: 1.2 !important;
                }
                .header, .billing-info, .invoice-info, table {
                    margin-bottom: 10px !important;
                }
                .footer {
                    position: fixed;
                    bottom: 0;
                    width: 100%;
                }
            }
        </style>
    </div>

    <script type="text/php">
        if (isset($pdf)) {
            // This will be executed when generating PDF
            $pdf->page_script('print(true);');
        } else {
            // Fallback for direct HTML view (shouldn't happen with our controller)
            window.onload = function() { window.print(); };
        }
    </script>
</body>
</html>
