@extends('layouts.app')

@section('content')
<div class="container-fluid">

    <div class="row">
        <div class="col-md-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-primary">Invoice Details</h6>
                    <span class="badge badge-{{ $invoice->DueDate->isPast() ? 'danger' : 'success' }}">
                        {{ $invoice->DueDate->isPast() ? 'Overdue' : 'Due ' . $invoice->DueDate->diffForHumans() }}
                    </span>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h6>Billed To:</h6>
                            <strong>{{ $invoice->company->CompanyName ?? 'N/A' }}</strong><br>
                            {{ $invoice->property->PropName ?? 'N/A' }}<br>
                            <small class="text-muted">Billing Period: {{ $invoice->BillingPeriod }}</small>
                        </div>
                        <div class="col-md-6 text-md-right">
                            <h6>Invoice Details:</h6>
                            <strong>Invoice #:</strong> {{ $invoice->InvoiceNo }}<br>
                            <strong>Date:</strong> {{ $invoice->InvoiceDate->format('F j, Y') }}<br>
                            <strong>Due Date:</strong> {{ $invoice->DueDate->format('F j, Y') }}<br>
                            <strong>Consumption Type:</strong> 
                            @php
                                $consTypeData = \DB::table('tblconstype')->where('tID', $invoice->ConsType)->first();
                                echo $consTypeData ? ($consTypeData->ConsTypeDescription ?? $consTypeData->ConsType) : 'N/A';
                            @endphp
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Description</th>
                                    <th>Unit Price</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($invoice->bulkInvoiceLines as $line)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $line->BulkLineDesc }}</td>
                                    <td class="text-right">{{ number_format($line->BulkLineUnitPrice, 4) }}</td>
                                    <td class="text-right">{{ number_format($line->BulkLineAmount, 2) }}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="4" class="text-center">No line items found.</td>
                                </tr>
                                @endforelse
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="3" class="text-right">Subtotal:</th>
                                    <th class="text-right">{{ number_format($invoice->bulkInvoiceLines->sum('BulkLineAmount'), 2) }}</th>
                                </tr>
                                <tr>
                                    <th colspan="3" class="text-right">Total:</th>
                                    <th class="text-right">{{ number_format($invoice->InvoiceAmount, 2) }}</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                    @if($invoice->InvoiceComments)
                    <div class="mt-4">
                        <h6>Comments:</h6>
                        <p class="text-muted">{{ $invoice->InvoiceComments }}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Meter Readings</h6>
                </div>
                <div class="card-body">
                    @if($invoice->PreviousReading1 !== null || $invoice->CurrentReading1 !== null)
                    <div class="mb-3">
                        <h6>Meter 1</h6>
                        <div class="row">
                            <div class="col-6">
                                <small class="text-muted">Previous Reading</small>
                                <p>{{ $invoice->PreviousReading1 ?? 'N/A' }}</p>
                            </div>
                            <div class="col-6">
                                <small class="text-muted">Current Reading</small>
                                <p>{{ $invoice->CurrentReading1 ?? 'N/A' }}</p>
                            </div>
                        </div>
                        @if($invoice->PreviousReading1 !== null && $invoice->CurrentReading1 !== null)
                        <div class="alert alert-info p-2">
                            <small>Consumption: {{ $invoice->CurrentReading1 - $invoice->PreviousReading1 }}</small>
                        </div>
                        @endif
                    </div>
                    @endif

                    @if($invoice->PreviousReading2 !== null || $invoice->CurrentReading2 !== null)
                    <div>
                        <h6>Meter 2</h6>
                        <div class="row">
                            <div class="col-6">
                                <small class="text-muted">Previous Reading</small>
                                <p>{{ $invoice->PreviousReading2 ?? 'N/A' }}</p>
                            </div>
                            <div class="col-6">
                                <small class="text-muted">Current Reading</small>
                                <p>{{ $invoice->CurrentReading2 ?? 'N/A' }}</p>
                            </div>
                        </div>
                        @if($invoice->PreviousReading2 !== null && $invoice->CurrentReading2 !== null)
                        <div class="alert alert-info p-2">
                            <small>Consumption: {{ $invoice->CurrentReading2 - $invoice->PreviousReading2 }}</small>
                        </div>
                        @endif
                    </div>
                    @endif
                </div>
            </div>

            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Actions</h6>
                </div>
                <div class="card-body">
                    <div class="list-group">
                        <a href="{{ route('invoices.bulk.edit', $invoice->BulkInvoiceID) }}" 
                           class="list-group-item list-group-item-action list-group-item-primary">
                            <i class="fas fa-edit fa-fw me-2"></i> Edit Invoice
                        </a>
                        <a href="{{ route('invoices.bulk.print', $invoice->BulkInvoiceID) }}" 
                           class="list-group-item list-group-item-action list-group-item-info"
                           target="_blank">
                            <i class="fas fa-print fa-fw me-2"></i> Print Invoice
                        </a>
                        <!-- <a href="#" 
                           class="list-group-item list-group-item-action"
                           onclick="alert('Duplicate functionality coming soon')">
                            <i class="fas fa-copy fa-fw me-2"></i> Duplicate Invoice
                        </a> -->
                        {{-- <a href="#" 
                           class="list-group-item list-group-item-action"
                           onclick="alert('Email functionality coming soon')">
                            <i class="fas fa-envelope fa-fw me-2"></i> Email to Customer
                        </a> --}}
                        <!-- <form action="{{ route('invoices.bulk.destroy', $invoice->BulkInvoiceID) }}" 
                              method="POST" onsubmit="return confirm('Are you sure you want to delete this invoice?');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="list-group-item list-group-item-action text-danger">
                                <i class="fas fa-trash fa-fw mr-2"></i> Delete Invoice
                            </button>
                        </form> -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .table th, .table td {
        vertical-align: middle;
    }
    .badge {
        font-size: 0.8rem;
        padding: 0.35em 0.65em;
    }
</style>
@endpush

@push('modals')
<!-- Add Line Item Modal -->
<div class="modal fade" id="addLineItemModal" tabindex="-1" role="dialog" aria-labelledby="addLineItemModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form action="{{ route('invoices.bulk.lines.store', $invoice->BulkInvoiceID) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="addLineItemModalLabel">Add Line Item</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <input type="text" class="form-control" id="BulkLineDesc" name="BulkLineDesc" required>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="quantity" class="form-label">Quantity</label>
                                <input type="number" class="form-control" id="BulkLineQty" name="BulkLineQty" value="1" min="1" step="0.01" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="unit_price" class="form-label">Unit Price</label>
                                <div class="input-group">
                                    <span class="input-group-text">KES</span>
                                    <input type="number" class="form-control" id="BulkLineUnitPrice" name="BulkLineUnitPrice" min="0" step="0.01" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="amount" class="form-label">Amount</label>
                        <div class="input-group">
                            <span class="input-group-text">KES</span>
                            <input type="number" class="form-control" id="BulkLineAmount" name="BulkLineAmount" readonly>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add Line Item</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endpush

@push('scripts')
<script>
    // Calculate amount when quantity or unit price changes
    document.addEventListener('DOMContentLoaded', function() {
        const quantityInput = document.getElementById('BulkLineQty');
        const unitPriceInput = document.getElementById('BulkLineUnitPrice');
        const amountInput = document.getElementById('BulkLineAmount');

        function calculateAmount() {
            const quantity = parseFloat(quantityInput.value) || 0;
            const unitPrice = parseFloat(unitPriceInput.value) || 0;
            amountInput.value = (quantity * unitPrice).toFixed(2);
        }

        quantityInput.addEventListener('input', calculateAmount);
        unitPriceInput.addEventListener('input', calculateAmount);
    });
</script>
@endpush