@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="bg-white rounded-lg shadow-md p-6">
        <h2 class="text-2xl font-semibold text-gray-800 mb-6">Generate Bulk Rent Invoices</h2>
        
        <form action="{{ route('invoices.rent.bulk-store') }}" method="POST" class="space-y-6">
            @csrf
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Billing Period -->
                <div class="space-y-2">
                    <label for="billing_period" class="block text-sm font-medium text-gray-700">Billing Period *</label>
                    <input type="month" name="billing_period" id="billing_period" required 
                           value="{{ old('billing_period', $billingPeriod) }}"
                           class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-sulis-blue focus:border-sulis-blue sm:text-sm rounded-md">
                </div>
                
                <!-- Billing Date -->
                <div class="space-y-2">
                    <label for="billing_date" class="block text-sm font-medium text-gray-700">Billing Date *</label>
                    <input type="date" name="billing_date" id="billing_date" required 
                           value="{{ old('billing_date', $billingDate) }}"
                           class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-sulis-blue focus:border-sulis-blue sm:text-sm rounded-md">
                </div>
                
                <!-- Due Date -->
                <div class="space-y-2">
                    <label for="due_date" class="block text-sm font-medium text-gray-700">Due Date *</label>
                    <input type="date" name="due_date" id="due_date" required 
                           value="{{ old('due_date', $dueDate) }}"
                           class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-sulis-blue focus:border-sulis-blue sm:text-sm rounded-md">
                </div>
            </div>
            
            <!-- Units Table -->
            <div class="mt-8">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Select Units</h3>
                <div class="bg-white shadow overflow-hidden sm:rounded-md">
                    <ul class="divide-y divide-gray-200">
                        @foreach($units as $unit)
                            <li class="px-4 py-4 sm:px-6">
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center">
                                        <input id="unit-{{ $unit->UnitID }}" name="unit_ids[]" type="checkbox" 
                                               value="{{ $unit->UnitID }}" 
                                               class="h-4 w-4 text-sulis-blue focus:ring-sulis-blue border-gray-300 rounded" checked>
                                        <label for="unit-{{ $unit->UnitID }}" class="ml-3">
                                            <span class="block text-sm font-medium text-gray-900">
                                                {{ $unit->UnitIdentity }} - {{ $unit->property->PropertyName ?? 'N/A' }}
                                            </span>
                                            <span class="block text-sm text-gray-500">
                                                {{ $unit->customer->CustomerName ?? 'No tenant' }} - 
                                                KSh {{ number_format($unit->MonthlyRent ?? 0, 2) }}/month
                                                @if($unit->customer && $unit->customer->Email)
                                                    <br>Email: {{ $unit->customer->Email }}
                                                @endif
                                            </span>
                                        </label>
                                    </div>
                                    <div class="text-right">
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                            {{ $unit->customer ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                                            {{ $unit->customer ? 'Occupied' : 'No Tenant' }}
                                        </span>
                                    </div>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
                
                @if($units->isEmpty())
                    <div class="text-center py-8">
                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <h3 class="mt-2 text-sm font-medium text-gray-900">No units available</h3>
                        <p class="mt-1 text-sm text-gray-500">There are no occupied units to generate invoices for.</p>
                    </div>
                @endif
            </div>
            
            <!-- Form Actions -->
            <div class="pt-6 flex justify-between items-center">
                <a href="{{ route('invoices.rent.index') }}" 
                   class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-sulis-blue">
                    Cancel
                </a>
                
                @if(!$units->isEmpty())
                    <button type="submit" 
                            class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-sulis-blue hover:bg-sulis-blue-dark focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-sulis-blue">
                        <svg class="-ml-1 mr-2 h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M4 4a2 2 0 012-2h4.586A2 2 0 0112 2.586L15.414 6A2 2 0 0116 7.414V16a2 2 0 01-2 2H6a2 2 0 01-2-2V4zm2 0v12h8V8h-3a1 1 0 01-1-1V4H6zm7 3a1 1 0 10-2 0v2H9a1 1 0 100 2h2v2a1 1 0 102 0v-2h2a1 1 0 100-2h-2V7z" clip-rule="evenodd" />
                        </svg>
                        Generate Invoices
                    </button>
                @endif
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Select all checkboxes
        const checkboxes = document.querySelectorAll('input[type="checkbox"]');
        
        // Select all button
        const selectAllBtn = document.getElementById('select-all');
        if (selectAllBtn) {
            selectAllBtn.addEventListener('click', function(e) {
                e.preventDefault();
                const allChecked = Array.from(checkboxes).every(checkbox => checkbox.checked);
                checkboxes.forEach(checkbox => {
                    checkbox.checked = !allChecked;
                });
                this.textContent = allChecked ? 'Select All' : 'Deselect All';
            });
        }
        
        // Update due date when billing date changes
        const billingDateInput = document.getElementById('billing_date');
        const dueDateInput = document.getElementById('due_date');
        
        if (billingDateInput && dueDateInput) {
            billingDateInput.addEventListener('change', function() {
                const billingDate = new Date(this.value);
                const dueDate = new Date(billingDate);
                dueDate.setDate(dueDate.getDate() + 7); // Default to 7 days after billing date
                
                // Format date as YYYY-MM-DD
                const formattedDueDate = dueDate.toISOString().split('T')[0];
                dueDateInput.value = formattedDueDate;
                
                // Ensure due date is not before billing date
                dueDateInput.min = this.value;
            });
        }
    });
</script>
@endpush
@endsection
