@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="bg-white rounded-lg shadow-md p-6">
        <h2 class="text-2xl font-semibold text-gray-800 mb-6">Create New Rent Invoice</h2>
        
        <form action="{{ route('invoices.rent.store') }}" method="POST" class="space-y-6">
            @csrf
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Customer Selection -->
                <div class="space-y-2">
                    <label for="CustomerID" class="block text-sm font-medium text-gray-700">Customer *</label>
                    <select name="CustomerID" id="CustomerID" required 
                            class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-sulis-blue focus:border-sulis-blue sm:text-sm rounded-md">
                        <option value="">Select Customer</option>
                        @foreach($customers as $customer)
                            <option value="{{ $customer->CustomerID }}">
                                {{ $customer->CustomerName }} ({{ $customer->PhoneNumber ?? 'No phone' }})
                            </option>
                        @endforeach
                    </select>
                </div>
                
                <!-- Unit Selection -->
                <div class="space-y-2">
                    <label for="UnitID" class="block text-sm font-medium text-gray-700">Unit *</label>
                    <select name="UnitID" id="UnitID" required 
                            class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-sulis-blue focus:border-sulis-blue sm:text-sm rounded-md">
                        <option value="">Select Unit</option>
                        @foreach($units as $unit)
                            <option value="{{ $unit->UnitID }}" data-rental-amount="{{ $unit->MonthlyRent ?? 0 }}">
                                {{ $unit->UnitIdentity }} - {{ $unit->property->PropertyName ?? 'N/A' }}
                            </option>
                        @endforeach
                    </select>
                </div>
                
                <!-- Billing Period -->
                <div class="space-y-2">
                    <label for="BillingPeriod" class="block text-sm font-medium text-gray-700">Billing Period *</label>
                    <input type="month" name="BillingPeriod" id="BillingPeriod" required 
                           value="{{ old('BillingPeriod', $billingPeriod) }}"
                           class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-sulis-blue focus:border-sulis-blue sm:text-sm rounded-md">
                </div>
                
                <!-- Billing Date -->
                <div class="space-y-2">
                    <label for="BillingDate" class="block text-sm font-medium text-gray-700">Billing Date *</label>
                    <input type="date" name="BillingDate" id="BillingDate" required 
                           value="{{ old('BillingDate', now()->format('Y-m-d')) }}"
                           class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-sulis-blue focus:border-sulis-blue sm:text-sm rounded-md">
                </div>
                
                <!-- Due Date -->
                <div class="space-y-2">
                    <label for="DueDate" class="block text-sm font-medium text-gray-700">Due Date *</label>
                    <input type="date" name="DueDate" id="DueDate" required 
                           value="{{ old('DueDate', now()->addDays(7)->format('Y-m-d')) }}"
                           class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-sulis-blue focus:border-sulis-blue sm:text-sm rounded-md">
                </div>
                
                <!-- Current Charges -->
                <div class="space-y-2">
                    <label for="CurrentCharges" class="block text-sm font-medium text-gray-700">Current Charges *</label>
                    <div class="mt-1 relative rounded-md shadow-sm">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <span class="text-gray-500 sm:text-sm">KSh</span>
                        </div>
                        <input type="number" step="0.01" min="0" name="CurrentCharges" id="CurrentCharges" required 
                               value="{{ old('CurrentCharges', '0.00') }}" 
                               class="focus:ring-sulis-blue focus:border-sulis-blue block w-full pl-16 pr-12 sm:text-sm border-gray-300 rounded-md">
                    </div>
                </div>
                
                <!-- Previous Balance -->
                <div class="space-y-2">
                    <label for="PreviousBalance" class="block text-sm font-medium text-gray-700">Previous Balance *</label>
                    <div class="mt-1 relative rounded-md shadow-sm">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <span class="text-gray-500 sm:text-sm">KSh</span>
                        </div>
                        <input type="number" step="0.01" min="0" name="PreviousBalance" id="PreviousBalance" required 
                               value="{{ old('PreviousBalance', '0.00') }}" 
                               class="focus:ring-sulis-blue focus:border-sulis-blue block w-full pl-16 pr-12 sm:text-sm border-gray-300 rounded-md">
                    </div>
                </div>
                
                <!-- Total Amount -->
                <div class="space-y-2">
                    <label for="TotalAmount" class="block text-sm font-medium text-gray-700">Total Amount *</label>
                    <div class="mt-1 relative rounded-md shadow-sm">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <span class="text-gray-500 sm:text-sm">KSh</span>
                        </div>
                        <input type="number" step="0.01" min="0" name="TotalAmount" id="TotalAmount" required 
                               value="{{ old('TotalAmount', '0.00') }}" 
                               class="focus:ring-sulis-blue focus:border-sulis-blue block w-full pl-16 pr-12 sm:text-sm border-gray-300 rounded-md font-semibold" readonly>
                    </div>
                </div>
                
                <!-- Status -->
                <div class="space-y-2">
                    <label for="BillStatus" class="block text-sm font-medium text-gray-700">Status *</label>
                    <select name="BillStatus" id="BillStatus" required 
                            class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-sulis-blue focus:border-sulis-blue sm:text-sm rounded-md">
                        <option value="unpaid" {{ old('BillStatus') == 'unpaid' ? 'selected' : '' }}>Unpaid</option>
                        <option value="paid" {{ old('BillStatus') == 'paid' ? 'selected' : '' }}>Paid</option>
                        <option value="overdue" {{ old('BillStatus') == 'overdue' ? 'selected' : '' }}>Overdue</option>
                    </select>
                </div>
            </div>
            
            <!-- Form Actions -->
            <div class="pt-6 flex justify-end space-x-3">
                <a href="{{ route('invoices.rent.index') }}" 
                   class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-sulis-blue">
                    Cancel
                </a>
                <button type="submit" 
                        class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-sulis-blue hover:bg-sulis-blue-dark focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-sulis-blue">
                    Create Invoice
                </button>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const currentChargesInput = document.getElementById('CurrentCharges');
        const previousBalanceInput = document.getElementById('PreviousBalance');
        const totalAmountInput = document.getElementById('TotalAmount');
        const unitSelect = document.getElementById('UnitID');
        
        // Auto-calculate total when current charges or previous balance changes
        function calculateTotal() {
            const currentCharges = parseFloat(currentChargesInput.value) || 0;
            const previousBalance = parseFloat(previousBalanceInput.value) || 0;
            const total = (currentCharges + previousBalance).toFixed(2);
            totalAmountInput.value = total;
        }
        
        // Set current charges to unit's rental amount when unit is selected
        if (unitSelect) {
            unitSelect.addEventListener('change', function() {
                const selectedOption = this.options[this.selectedIndex];
                const rentalAmount = selectedOption.getAttribute('data-rental-amount');
                if (rentalAmount) {
                    currentChargesInput.value = parseFloat(rentalAmount).toFixed(2);
                    calculateTotal();
                }
            });
        }
        
        // Add event listeners
        currentChargesInput.addEventListener('input', calculateTotal);
        previousBalanceInput.addEventListener('input', calculateTotal);
        
        // Initial calculation
        calculateTotal();
    });
</script>
@endpush
@endsection
