<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $invoice->BillID ?? 'Billing Report'}}</title>
    <style>
        /* company info  */
        table {
            width: 100%;
            border-collapse: collapse;
        }


        td {
            vertical-align: top;
            padding: 10px;
        }


        .company-info {
            text-align: left;
            width: 50%;
            font-size: 12px;
            padding: 0px 2px;
        }


        .company-info,
        p {
            font-size: 14px;
            padding-top: 1px;
            margin: 0;
            padding: 0;
        }


        .logo {
            text-align: right;
            width: 50%;
            padding-right: 20px;
        }


        img {
            max-width: 250px;
            height: auto;
        }



        /* header1  */
        table {
            width: 100%;
            border-collapse: collapse;
        }



        .empty-box {
            width: 50%;
            border: 1px solid black;
            background-color: white;
        }


        .title-bar {
            width: 50%;
            background-color: black;
            color: white;
            font-weight: bold;
            border: 1px solid black;
            padding: 10px;
        }



        .container {
            width: 100%;
        }


        .rowCustomer {
            display: table;
            width: 100%;
        }


        .column {
            display: table-cell;
            width: 50%;
            vertical-align: top;
        }


        .table {
            width: 100%;
            border-collapse: collapse;
            border: 1px solid #000;
        }


        .td {
            padding: 10px;
            border: 1px solid #000;
            text-align: center;
        }


        .rightCustomerTable {
            padding-left: 10px;


        }


        .leftCustomerTable {
            font-size: 6px;


        }


        .rightCustomerTable,
        td {
            font-size: 14px;
            padding: 0px 3px;
        }


        .consumption-title-bar {
            width: 100%;
            background-color: black;
            color: white;
            font-weight: bold;
            padding: 6px;
            margin-top: 10px;
        }


        .rowBillingConsumption {
            display: table;
            width: 100%;
        }


        .consumptionDataBody {
            width: 50%;
            height: 100px;
            overflow: hidden;
        }



        .consumptionDataBody th,
        .billingDetailsBody th {
            font-size: 12px;
            text-align: center;
            padding: 8px;
        }


        .consumptionDataBody td,
        .billingDetailsBody td {
            font-size: 14px;
            text-align: center;
            padding: 8px;
        }


        .myheading {
            font-size: 12px;
            text-align: center;
            /* padding: 0px 3px; */
            /* padding: 8px; */
        }


        .billinedata {
            font-size: 12px;
            padding-top: 4px;
            text-align: right;
            
        }


        .total-payment {
            /* width: 100%; */
            background-color: #e1e1e1;
            color: black;
            font-weight: bold;
            padding: 6px; 
             margin-top: 10px;
            font-size: 12px;
            text-align: center
                /* border: 1px solid black; */
        }


        .headingDivider {
            width: 100%;
            border: 1px solid black;
        }


        .containerCheque {
            width: 100%;
            background-color: black;
            text-align: start;
            padding: 10px;
            color: #fff;
        }


        .footer {
            text-align: center;
            margin-top: 14px;
            font-size: 10px;
        }


        .hrFooter {
            border: none;
            border-top: 2px dotted black;
            margin: 10px 0;
        }
    </style>
</head>


<body>


    <table>
        <tr>
            <td class="company-info" >
                <p style="font-size: 16px;margin: 0; padding: 0;"><strong>C/o</strong></p>
                <p style="font-size: 16px;margin: 0;padding: 0;"><strong>HassConsult Limited</strong></p>
                <p style="font-size: 16px;margin: 0;padding: 0;">P.O. Box 14090-00800 Nairobi</p>
                <p style="font-size: 16px;margin: 0;padding: 0;">Tel: +254 20 4446914</p>
                <p style="font-size: 16px;margin: 0;padding: 0;">Email: info@hassconsult.co.ke</p>
            </td>
            <td class="logo">
                <img src="{{ public_path('images/watermarklogo.png') }}" alt="The Watermark Business Park Logo">
            </td>
        </tr>
    </table>


    <!-- Black Title Bar -->
    <table>
        <tr>
            <td class="empty-box"></td>
            <td class="title-bar">Recovery of Electricity Charges</td>
        </tr>
    </table>


    <div class="container">
        <table style="border: 1px solid black; width: 50%; padding-top: 4px;">
            <tr>
                <td>To</td>
            </tr>
        </table>
        <div class="rowCustomer">


            <div class="column ">


                <table class="table leftCustomerTable">
                    <tr>
                        <td>
                            <span>{{ $customer->TenantName ?? 'N/A' }}</span><br>
                            <span>C/O {{ $customer->CustomerName ?? 'N/A' }}</span><br>
                            <span> {{ $customer->TelNo ?? 'N/A' }} ,
                                {{ $customer->Address1 ?? 'N/A' }} ,
                                {{ $customer->Address2 ?? 'N/A' }}</span><br>
                            <span>Watermark Business Park</span><br>
                            <span>Ndege Road, Karen</span><br>
                            <span>Nairobi</span>
                        </td>
                    </tr>
                </table>
            </div>


            <div class="column">
                <table class="table rightCustomerTable"
                    style=" margin-top: 0px; width: 100%; border-collapse: collapse;">
                    <tr>
                        <td style="padding: 1px 10px;">BILL No.</td>
                        <td style="padding: 1px 10px;"><strong>{{ $invoice->BillID ?? 'N/A' }}</strong></td>
                    </tr>
                    <tr>
                        <td style="padding: 1px 10px;">Account No.</td>
                        <td style="padding: 1px 10px;"><strong>{{ $customer->AccountNo ?? 'N/A' }}</strong></td>
                    </tr>
                    <tr>
                    <tr>
                        <td style="padding: 1px 10px;">Meter No</td>
                        <td style="padding: 1px 10px;"><strong>{{ $customer->EMeterNo ?? 'N/A' }}</strong></td>
                    </tr>
                    <tr>
                        <td style="padding: 1px 10px;">Billing Date</td>
                        <td style="padding: 1px 10px;"><strong>{{ $invoice->BillingDate ?? 'N/A' }}</strong></td>
                    </tr>
                    <tr>
                        <td style="padding: 1px 10px;">Billing Period</td>
                        <td style="padding: 1px 10px;">
                            <strong>{{ $invoice->BillingPeriod ? \Carbon\Carbon::createFromFormat('Ym', $invoice->BillingPeriod)->format('M Y') : 'N/A' }}</strong>
                        </td>
                    </tr>
                    <tr>
                        <td style="height: 8px;"></td>
                        <td style="height: 8px; vertical-align: bottom;"><strong> </strong></td>
                    </tr>
                </table>
            </div>


        </div>
    </div>


    <!-- consumption billing  -->


    <table style="margin-top: 4px;">
        <tr>
            <td class="consumption-title-bar">CONSUMPTION DATA</td>
            <td class="consumption-title-bar">BILLING DETAILS</td>
        </tr>
    </table>


    <!--  billing  data  -->
    <div class="container">
        <div class="rowBillingConsumption">


            <table style="width: 100%;">
                <tr>
                    <th class="myheading" style="text-align: right; padding-right: 15px;">Description</th>
                    <th class="myheading" style="text-align: right; padding-right: 15px;">Units</th>
                    <th class="myheading" style="text-align: right; padding-right: 15px;">Unit Price</th>
                    <th class="myheading" style="text-align: right; padding-right: 15px;">Amount (Kshs)</th>
                </tr>
                <tbody>
                    <tr>
                        <td colspan="16">
                            <hr style="height: 1px; background-color: black;">
                        </td>
                    </tr>




                    @php 
                        // Calculate total from line items
                        $totalBillAmount = $invoice->lines->sum('LineAmount') ?? 0;
                        $totalAmount = $totalBillAmount; // For backward compatibility
                    @endphp
                    @if(isset($invoice->lines) && count($invoice->lines) > 0)
                        @foreach($invoice->lines as $billLine)
                            <tr>
                                <td style="text-align: right; padding-right: 15px;">{{ $billLine->ItemName ?? 'N/A' }}</td>
                                <td style="text-align: right; padding-right: 15px;">{{ number_format($billLine->Units ?? 0, 2) }}</td>
                                <td style="text-align: right; padding-right: 15px;">{{ number_format($billLine->UnitPrice ?? 0, 2) }}</td>
                                <td style="text-align: right; padding-right: 15px;">{{ number_format($billLine->LineAmount ?? 0, 2) }}</td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="16" style="text-align: center;">No billing details available</td>
                        </tr>
                    @endif


                    
                    <tr>
                        <td colspan="8"></td>
                        <td colspan="8">
                            <hr style="height: 1px; background-color: black; margin-left: 0;">
                        </td>
                    </tr>
                    <tr>
                        <td colspan="12"></td>
                        <td colspan="2" style="text-align: right; padding-right: 10px;"><strong>TOTAL CURRENT BILL:</strong></td>
                        <td colspan="2" style="text-align: right; padding-right: 20px;">
                            <strong>{{ number_format($totalBillAmount, 2) }}</strong>
                        </td>
                    </tr>
                    
                    <tr>
                        <td colspan="8"></td>
                        <td colspan="8">
                            <hr style="height: 1px; background-color: black; margin-left: 0;">
                        </td>
                    </tr>
                    
                </tbody>
            </table>
        </div>


    </div>
    <div class="row">
        <div class="emptyPaymentBox"></div>
        <table style="padding-bottom: 5px; margin-top: 20px; width: 70%; border-collapse: collapse; margin-left: auto;">
            <tr>
                <td class="total-payment">TOTAL AMOUNT PAYABLE :</td>
                <td class="total-payment" style="text-align: right; padding-right: 20px;">{{ number_format($totalBillAmount, 2) }}</td>
            </tr>
        </table>
    </div>


    <hr class="headingDivider">
    <p style="font-size: 12px;font-size: 14px;">The net account balance as at <b>{{ $invoice->BillingDate ?? 'N/A' }} </b>is <b>Kshs {{ number_format($totalBillAmount, 2) }}</b> .</p>
    <p style="font-size: 12px;margin-top:10px;font-size: 14px">Please pay this amount on or before <b>{{ $invoice->DueDate ?? 'N/A' }}</b> to avoid disconnection.</p>


    <hr class="headingDivider">


    <div class="containerCheque">Cheques to be made payable to : {{ $company->cheque_payable_to ?? 'HassConsult Real Estate Ltd - Watermark' }}</div>



    <!-- Footer -->
    <div class="footer">
        <p>Powered by SPMS - a SULIS Product | +254 20 387 2607 | sulis@sulis.co.ke</p>
    </div>
    <hr class="headingDivider">
    <div class="hrFooter">
    </div>


    <table class="table" style="align-content: space-between">
        <tr>
            <td class="consumption-title-bar">To be attached to payment</td>
            <td class="consumption-title-bar" style="font-weight: 900;text-align: end">THE WATERMARK BUSINESS PARK</td>
        </tr>
    </table>


    <div class="rowCustomer">


        <div class="column ">


            <table class="table leftCustomerTable" style="border: none; ">
                <tr>
                    <td>
                        <br>
                        <span style="font-size: 12px;"><b>{{$customer->TenantName ?? 'N/A'}}</b></span><br>
                        <span style="font-size: 12px;"><b>{{ $customer->CustomerName ?? 'N/A' }}</b></span><br>
                        <span style="font-size: 12px;"> {{ $customer->TelNo ?? 'N/A' }} ,
                            {{ $customer->Address1 ?? 'N/A' }} ,
                            {{ $customer->Address2 ?? 'N/A' }}</span><br>
                        <span style="font-size: 12px;">Watermark Business Park</span><br>
                        <span style="font-size: 12px;">Ndege Road, Karen</span>
                    </td>
                </tr>
            </table>
        </div>


        <div class="column">
            <table class="table rightCustomerTable"
                style=" margin-top: 14px; width: 100%; border-collapse: collapse; border: none;">


                <tr>
                    <td style="padding: 0px 10px;font-size: 12px;">BILL No.</td>
                    <td style="padding: 0px 10px;font-size: 12px;"><strong>{{ $invoice->BillID ?? 'N/A' }}</strong></td>
                </tr>
                <tr>
                    <td style="padding: 0px 10px;font-size: 12px;">Account No.</td>
                    <td style="padding: 0px 10px;font-size: 12px;"><strong>{{ $customer->AccountNo ?? 'N/A' }}</strong></td>
                </tr>
                <tr>
                    <td style="padding: 0px 10px;font-size: 12px;">Meter No</td>
                    <td style="padding: 0px 10px;font-size: 12px;"><strong>{{ $customer->EMeterNo ?? 'N/A' }}</strong></td>
                </tr>
                <tr>
                    <td style="padding: 0px 10px;font-size: 12px;">Amount Due </td>
                    <td style="padding: 0px 10px;font-size: 12px;"><strong>Kshs {{ number_format($totalAmount,2 ) }}</strong></td>
                </tr>
                <tr>
                    <td style="padding: 0px 10px;font-size: 12px;">Due Date</td>
                    <td style="padding: 0px 10px;font-size: 12px;"><strong>{{ $invoice->DueDate ?? 'N/A' }}</strong></td>
                </tr>
                <tr>
                    <td style="height: 8px;"></td>
                    <td style="height: 8px; vertical-align: bottom;"><strong> </strong></td>
                </tr>
            </table>
        </div>
    </div>
</body>


</html>
