@extends('layouts.app')

@section('title', 'View Bill #' . $invoice->BillID)

@push('styles')
<style>
    .invoice-card {
        transition: all 0.3s ease;
        border: 1px solid #e2e8f0;
        border-radius: 1rem;
        overflow: hidden;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    }
    .invoice-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    }
    .invoice-header {
        background: linear-gradient(135deg, #1e40af 0%, #1e3a8a 100%);
        color: white;
        /* padding-left:24px; */
        padding: 1.5rem 2rem;
        position: relative;
        overflow: hidden;
    }
    .invoice-header::before {
        content: '';
        position: absolute;
        top: 0;
        right: 0;
        width: 200px;
        height: 200px;
        background: radial-gradient(circle, rgba(250, 204, 21, 0.1) 0%, transparent 70%);
        border-radius: 50%;
        transform: translate(50%, -50%);
    }
    .invoice-header::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 150px;
        height: 150px;
        background: radial-gradient(circle, rgba(250, 204, 21, 0.08) 0%, transparent 70%);
        border-radius: 50%;
        transform: translate(-30%, 30%);
    }
    .status-badge {
        padding: 0.5rem 1rem;
        border-radius: 9999px;
        font-size: 0.875rem;
        font-weight: 600;
        text-transform: capitalize;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
    }
    .status-paid {
        background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
        color: #065f46;
        border: 1px solid #6ee7b7;
    }
    .status-unpaid {
        background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
        color: #b91c1c;
        border: 1px solid #fca5a5;
    }
    .status-partial {
        background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
        color: #92400e;
        border: 1px solid #fbbf24;
    }
    .info-card {
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        border: 1px solid #e2e8f0;
        border-radius: 0.75rem;
        padding: 1.5rem;
        margin-bottom: 1rem;
        position: relative;
        overflow: hidden;
    }
    .info-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 4px;
        height: 100%;
        background: linear-gradient(135deg, #1e40af 0%, #1e3a8a 100%);
    }
    .bill-table {
        border-radius: 0.75rem;
        overflow: hidden;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
    }
    .bill-table thead {
        background: linear-gradient(135deg, #1e40af 0%, #1e3a8a 100%);
        color: white;
    }
    .bill-table thead th {
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        font-size: 0.875rem;
        border: none;
        padding: 1rem;
    }
    .bill-table tbody tr:hover {
        background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
        transform: scale(1.01);
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        transition: all 0.2s ease;
    }
    .amount-cell {
        font-family: 'Inter', 'Segoe UI', system-ui, -apple-system, sans-serif;
        font-weight: 700;
        color: #1e40af;
    }
    .total-row {
        background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
        font-weight: 700;
    }
    .btn-primary {
        background: linear-gradient(135deg, #1e40af 0%, #1e3a8a 100%);
        border: none;
        transition: all 0.2s;
    }
    .btn-primary:hover {
        background: linear-gradient(135deg, #1e3a8a 0%, #1e2f5f 100%);
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(30, 64, 175, 0.3);
    }
    .btn-success {
        background: linear-gradient(135deg, #16a34a 0%, #15803d 100%);
        border: none;
        transition: all 0.2s;
    }
    .btn-success:hover {
        background: linear-gradient(135deg, #15803d 0%, #166534 100%);
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(22, 163, 74, 0.3);
    }
    .btn-warning {
        background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        border: none;
        transition: all 0.2s;
    }
    .btn-warning:hover {
        background: linear-gradient(135deg, #d97706 0%, #b45309 100%);
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(245, 158, 11, 0.3);
    }
    .btn-info {
        background: linear-gradient(135deg, #0891b2 0%, #0e7490 100%);
        border: none;
        transition: all 0.2s;
    }
    .btn-info:hover {
        background: linear-gradient(135deg, #0e7490 0%, #155e75 100%);
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(8, 145, 178, 0.3);
    }
    .action-button {
        border-radius: 0.5rem;
        font-weight: 600;
        padding: 0.75rem 1rem;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 0.5rem;
        text-decoration: none;
        transition: all 0.2s ease;
    }
    .payment-history-table {
        font-size: 0.875rem;
    }
    .payment-history-table thead {
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    }
    .payment-history-table th {
        font-weight: 600;
        color: #374151;
        border-bottom: 2px solid #e5e7eb;
    }
    @media print {
        body * {
            visibility: hidden;
        }
        .invoice-card, .invoice-card * {
            visibility: visible;
        }
        .invoice-card {
            position: absolute;
            left: 0;
            top: 0;
            width: 100%;
        }
        .no-print, .no-print * {
            display: none !important;
        }
    }
</style>
@endpush

@section('content')
<div class="container mx-auto px-4 py-6">
    <!-- Page Header -->
    <div class="invoice-card bg-white mb-6">
        <div class="invoice-header flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
            <div class="flex-1 relative z-10">
                <h1 class="text-3xl font-bold text-white mb-2 flex items-center">
                    <i class="fas fa-file-invoice mr-3 text-yellow-400"></i>
                    Bill Details #{{ $invoice->BillID }}
                </h1>
                <p class="text-blue-100 text-sm flex items-center">
                    <i class="fas fa-calendar mr-2 text-yellow-400"></i>
                    Billing Period: {{ $invoice->BillingPeriod }}
                </p>
            </div>
            <div class="flex items-center space-x-3 relative z-10">
                <a href="{{ route('invoices.rent.index') }}" class="btn btn-secondary action-button">
                    <i class="fas fa-arrow-left"></i> Back to Bills
                </a>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <div class="lg:col-span-2 space-y-6">
            <!-- Customer & Bill Details -->
            <div class="invoice-card bg-white">
                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Bill To -->
                        <div class="info-card">
                            <h6 class="text-lg font-bold text-gray-900 mb-4 flex items-center">
                                <i class="fas fa-user mr-2 text-blue-500"></i>
                                Bill To:
                            </h6>
                            <div class="space-y-2">
                                <p class="font-semibold text-gray-900">{{ $invoice->customer->CustomerName ?? 'N/A' }}</p>
                                <p class="text-sm text-gray-600">{{ $invoice->customer->Address1 ?? '' }}</p>
                                <p class="text-sm text-gray-600">{{ $invoice->customer->Address2 ?? '' }}</p>
                                <p class="text-sm text-gray-600">{{ $invoice->customer->City ?? '' }}, {{ $invoice->customer->PostalCode ?? '' }}</p>
                                <div class="flex items-center space-x-4 text-sm text-gray-600">
                                    <span class="flex items-center">
                                        <i class="fas fa-phone mr-1 text-yellow-500"></i>
                                        {{ $invoice->customer->Phone ?? '' }}
                                    </span>
                                    <span class="flex items-center">
                                        <i class="fas fa-envelope mr-1 text-blue-500"></i>
                                        {{ $invoice->customer->Email ?? '' }}
                                    </span>
                                </div>
                            </div>
                        </div>

                        <!-- Bill Details -->
                        <div class="info-card">
                            <h6 class="text-lg font-bold text-gray-900 mb-4 flex items-center">
                                <i class="fas fa-info-circle mr-2 text-blue-500"></i>
                                Bill Details:
                            </h6>
                            <div class="space-y-2">
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-600">Bill #:</span>
                                    <span class="font-semibold text-gray-900">{{ $invoice->BillID }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-600">Account #:</span>
                                    <span class="font-semibold text-gray-900">{{ $invoice->customer->AccountNo ?? 'N/A' }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-600">Meter #:</span>
                                    <span class="font-semibold text-gray-900">{{ $invoice->customer->EMeterNo ?? 'N/A' }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-600">Bill Date:</span>
                                    <span class="font-semibold text-gray-900">{{ \Carbon\Carbon::parse($invoice->BillDate)->format('M d, Y') }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-sm text-gray-600">Due Date:</span>
                                    <span class="font-semibold text-gray-900">{{ \Carbon\Carbon::parse($invoice->DueDate)->format('M d, Y') }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Bill Items Table -->
                    <div class="mt-6">
                        <h6 class="text-lg font-bold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-list mr-2 text-blue-500"></i>
                            Bill Items
                        </h6>
                        <div class="overflow-x-auto">
                            <table class="bill-table table table-bordered w-full">
                                <thead>
                                    <tr>
                                        <th class="text-left">#</th>
                                        <th class="text-left">Description</th>
                                        <th class="text-right">Units</th>
                                        <th class="text-right">Rate</th>
                                        <th class="text-right">Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($invoice->lines as $index => $line)
                                        <tr>
                                            <td class="py-3">{{ $index + 1 }}</td>
                                            <td class="py-3 font-medium">{{ $line->ItemName }}</td>
                                            <td class="py-3 text-right">{{ number_format($line->Units, 2) }}</td>
                                            <td class="py-3 text-right">{{ number_format($line->UnitPrice, 2) }}</td>
                                            <td class="py-3 text-right amount-cell">{{ number_format($line->LineAmount, 2) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    @php
                                        $calculatedSubtotal = $invoice->lines->sum('LineAmount');
                                        $previousBalance = $invoice->PreviousBalance ?? 0;
                                        $totalDue = $calculatedSubtotal + $previousBalance;
                                    @endphp
                                    <tr>
                                        <td colspan="4" class="py-3 text-right font-semibold">Subtotal:</td>
                                        <td class="py-3 text-right amount-cell">{{ number_format($calculatedSubtotal, 2) }}</td>
                                    </tr>
                                    <tr>
                                        <td colspan="4" class="py-3 text-right font-semibold">Previous Balance:</td>
                                        <td class="py-3 text-right amount-cell">{{ number_format($previousBalance, 2) }}</td>
                                    </tr>
                                    <tr class="total-row">
                                        <td colspan="4" class="py-3 text-right font-bold text-lg">Total Due:</td>
                                        <td class="py-3 text-right font-bold text-lg amount-cell">{{ number_format($totalDue, 2) }}</td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="lg:col-span-1 space-y-6">
            <!-- Payment History -->
            <div class="invoice-card bg-white">
                <div class="p-6">
                    <h6 class="text-lg font-bold text-gray-900 mb-4 flex items-center">
                        <i class="fas fa-history mr-2 text-blue-500"></i>
                        Payment History
                    </h6>
                    @if($payments && $payments->count() > 0)
                        <div class="overflow-x-auto">
                            <table class="payment-history-table table table-sm">
                                <thead>
                                    <tr>
                                        <th class="p-2">Date</th>
                                        <th class="p-2">Receipt #</th>
                                        <th class="text-right p-2">Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($payments as $payment)
                                        <tr class="hover:bg-gray-50">
                                            <td class="p-2">{{ $payment->PaymentDate ? \Carbon\Carbon::parse($payment->PaymentDate)->format('M d, Y') : 'N/A' }}</td>
                                            <td class="p-2">{{ $payment->ReceiptNo ?? 'N/A' }}</td>
                                            <td class="text-right p-2 font-semibold">KES {{ number_format($payment->TotalPayment, 2) }}</td>
                                        </tr>
                                    @endforeach
                                    <tr class="bg-gray-100">
                                        <td colspan="2" class="font-bold p-2">Total Paid:</td>
                                        <td class="text-right font-bold p-2">KES {{ number_format($totalPaid, 2) }}</td>
                                    </tr>
                                    <tr class="{{ $balance <= 0 ? 'bg-green-50' : 'bg-yellow-50' }}">
                                        <td colspan="2" class="font-bold p-2">Balance:</td>
                                        <td class="text-right font-bold p-2">
                                            KES {{ number_format($balance, 2) }}
                                            @if($balance <= 0)
                                                <span class="ml-2 px-2 py-1 text-xs rounded-full bg-green-100 text-green-800">Paid</span>
                                            @elseif($totalPaid > 0)
                                                <span class="ml-2 px-2 py-1 text-xs rounded-full bg-yellow-100 text-yellow-800">Partial</span>
                                            @else
                                                <span class="ml-2 px-2 py-1 text-xs rounded-full bg-red-100 text-red-800">Unpaid</span>
                                            @endif
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-8">
                            <i class="fas fa-receipt text-4xl text-gray-300 mb-4"></i>
                            <p class="text-gray-500 mb-4">No payment history found for this bill.</p>
                            
                        </div>
                    @endif
                </div>
            </div>

            <!-- Actions -->
            <div class="invoice-card bg-white">
                <div class="p-6">
                    <h6 class="text-lg font-bold text-gray-900 mb-4 flex items-center">
                        <i class="fas fa-cog mr-2 text-blue-500"></i>
                        Actions
                    </h6>
                    <div class="space-y-3">
                        <button type="button" class="btn btn-success action-button w-full" data-bs-toggle="modal" data-bs-target="#recordPaymentModal">
                            <i class="fas fa-money-bill-wave"></i> Record Payment
                        </button>
                        <button type="button" class="btn btn-warning action-button w-full" data-bs-toggle="modal" data-bs-target="#sendBillModal">
                            <i class="fas fa-paper-plane"></i> Send Bill to Customer
                        </button>
                        <button type="button" class="btn btn-info action-button w-full" data-bs-toggle="modal" data-bs-target="#addAdjustmentModal">
                            <i class="fas fa-adjust"></i> Add Adjustment
                        </button>
                        <a href="{{ route('invoices.rent.print', $invoice->BillID) }}" class="btn btn-primary action-button w-full" target="_blank">
                            <i class="fas fa-print"></i> Print Bill
                        </a>
                      
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Loading Dialog -->
<div id="loadingDialog" class="fixed inset-0 bg-black bg-opacity-50 overflow-y-auto h-full w-full hidden z-50 backdrop-blur-sm">
    <div class="relative top-20 mx-auto p-0 border-0 rounded-2xl shadow-2xl bg-white max-w-md w-full mx-4 transform transition-all animate-pulse">
        <!-- Modal Header with Gradient -->
        <div class="bg-gradient-to-r from-blue-600 to-blue-700 rounded-t-2xl px-6 py-5 border-b border-blue-800">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-white bg-opacity-20 rounded-full p-3 mr-4 animate-bounce">
                        <i class="fas fa-paper-plane text-white text-xl"></i>
                    </div>
                    <div>
                        <h3 class="text-xl font-bold text-white mb-1">Sending Email</h3>
                        <p class="text-blue-100 text-sm">Processing your request...</p>
                    </div>
                </div>
                <div class="animate-spin rounded-full h-8 w-8 border-2 border-white border-t-transparent"></div>
            </div>
        </div>
        
        <!-- Modal Body -->
        <div class="px-6 py-8 bg-gradient-to-b from-white to-gray-50">
            <div class="flex flex-col items-center space-y-4">
                <!-- Main Spinner -->
                <div class="relative">
                    <div class="w-16 h-16 border-4 border-blue-200 rounded-full animate-spin"></div>
                    <div class="absolute top-0 left-0 w-16 h-16 border-4 border-blue-600 rounded-full animate-spin border-t-transparent"></div>
                    <div class="absolute top-2 left-2 w-12 h-12 border-4 border-blue-300 rounded-full animate-spin border-b-transparent"></div>
                </div>
                
                <!-- Status Text -->
                <div class="text-center space-y-2">
                    <p class="text-gray-800 font-semibold text-lg">Sending Bill to Customer</p>
                    <p class="text-gray-600 text-sm">Please wait while we generate and send your invoice</p>
                    <div class="flex items-center justify-center space-x-2 mt-3">
                        <div class="w-2 h-2 bg-blue-600 rounded-full animate-pulse"></div>
                        <div class="w-2 h-2 bg-blue-600 rounded-full animate-pulse" style="animation-delay: 0.2s"></div>
                        <div class="w-2 h-2 bg-blue-600 rounded-full animate-pulse" style="animation-delay: 0.4s"></div>
                    </div>
                </div>
                
                <!-- Progress Bar -->
                <div class="w-full bg-gray-200 rounded-full h-2 overflow-hidden">
                    <div class="bg-gradient-to-r from-blue-500 to-blue-600 h-2 rounded-full animate-pulse" style="width: 60%; animation: shimmer 2s infinite;"></div>
                </div>
                
                <!-- Additional Info -->
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 w-full">
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-info-circle text-blue-600"></i>
                        <div class="text-sm">
                            <p class="text-blue-800 font-medium">This may take a few moments</p>
                            <p class="text-blue-600 text-xs">Generating PDF and sending email...</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Modal Footer -->
        <div class="px-6 py-4 bg-gray-100 rounded-b-2xl border-t border-gray-200">
            <div class="flex items-center justify-between">
                <p class="text-xs text-gray-500">
                    <i class="fas fa-lock mr-1"></i>
                    Secure transaction in progress
                </p>
                <div class="flex items-center space-x-1">
                    <div class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></div>
                    <span class="text-xs text-green-600 font-medium">Active</span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Custom CSS for animations -->
<style>
    @keyframes shimmer {
        0% { transform: translateX(-100%); }
        100% { transform: translateX(200%); }
    }
    .animate-shimmer {
        animation: shimmer 2s infinite;
    }
</style>

@push('scripts')
<script>
    // Function to show loading dialog
    function showLoadingDialog() {
        document.getElementById('loadingDialog').classList.remove('hidden');
        document.body.classList.add('overflow-hidden');
    }
    
    // Function to hide loading dialog
    function hideLoadingDialog() {
        document.getElementById('loadingDialog').classList.add('hidden');
        document.body.classList.remove('overflow-hidden');
    }
    
    document.addEventListener('DOMContentLoaded', function() {
        console.log('DOM fully loaded');
        
        // Initialize modal
        const sendBillModal = new bootstrap.Modal(document.getElementById('sendBillModal'));
        
        // Fetch company subject template when modal is shown
        const modalElement = document.getElementById('sendBillModal');
        if (modalElement) {
            modalElement.addEventListener('shown.bs.modal', function () {
                console.log('Modal is shown - fetching company subject template');
                
                // Prepare template variables
                const variables = {
                    'customer_name': '{{ $invoice->customer->CustomerName ?? "Valued Customer" }}',
                    'bill_id': '{{ $invoice->BillID }}',
                    'billing_period': '{{ $invoice->BillingPeriod }}',
                    'account_number': '{{ $invoice->customer->AccountNo ?? "N/A" }}',
                    'total_amount': 'KES {{ number_format($invoice->TotalAmount, 2) }}',
                    'company_name': '{{ config("app.name") }}'
                };
                
                // Fetch company subject template
                fetch('{{ route("company.templates") }}')
                    .then(response => response.json())
                    .then(data => {
                        if (data.error) {
                            console.error('Error fetching templates:', data.error);
                            document.getElementById('emailSubject').value = 'Bill #{{ $invoice->BillID }} - {{ config("app.name") }}';
                            return;
                        }
                        
                        // Use company subject template with variables replaced
                        let subject = data.email_subject || 'Bill #{bill_id} - {company_name}';
                        
                        // Replace variables
                        for (const [key, value] of Object.entries(variables)) {
                            const placeholder = `{${key}}`;
                            subject = subject.replace(new RegExp(placeholder, 'g'), value);
                        }
                        
                        document.getElementById('emailSubject').value = subject;
                        console.log('Subject template loaded:', subject);
                    })
                    .catch(error => {
                        console.error('Error fetching templates:', error);
                        document.getElementById('emailSubject').value = 'Bill #{{ $invoice->BillID }} - {{ config("app.name") }}';
                    });
            });
            
            modalElement.addEventListener('hidden.bs.modal', function () {
                console.log('Modal is hidden');
            });
        }
        
        // Handle Send Bill form submission
        const sendBillForm = document.getElementById('sendBillForm');
        if (sendBillForm) {
            sendBillForm.addEventListener('submit', function(e) {
                e.preventDefault();
                
                // Close the modal first
                const modal = bootstrap.Modal.getInstance(document.getElementById('sendBillModal'));
                if (modal) {
                    modal.hide();
                }
                
                // Show loading dialog
                showLoadingDialog();
                
                // Submit the form after showing loading dialog
                setTimeout(() => {
                    sendBillForm.submit();
                }, 300);
            });
        }
    });
</script>
@endpush

<!-- Record Payment Modal -->
<div class="modal fade" id="recordPaymentModal" tabindex="-1" role="dialog" aria-labelledby="recordPaymentModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-to-r from-green-500 to-green-600 text-white">
                <h5 class="modal-title" id="recordPaymentModalLabel">
                    <i class="fas fa-money-bill-wave mr-2"></i> Record Payment
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('payments.store') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="paymentAmount" class="form-label fw-semibold">Amount</label>
                        <div class="input-group">
                            <span class="input-group-text bg-light">KES</span>
                            <input type="number" step="0.01" class="form-control" id="paymentAmount" name="amount" required>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="paymentDate" class="form-label fw-semibold">Payment Date</label>
                        <input type="date" class="form-control" id="paymentDate" name="payment_date" value="{{ date('Y-m-d') }}" required>
                    </div>
                    <div class="mb-3">
                        <label for="paymentMethod" class="form-label fw-semibold">Payment Method</label>
                        <select class="form-select" id="paymentMethod" name="payment_method" required>
                            <option value="cash">Cash</option>
                            <option value="mpesa">MPESA</option>
                            <option value="bank_transfer">Bank Transfer</option>
                            <option value="cheque">Cheque</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="referenceNo" class="form-label fw-semibold">Reference No.</label>
                        <input type="text" class="form-control" id="referenceNo" name="reference_number" placeholder="Enter reference number">
                    </div>
                    <div class="mb-3">
                        <label for="notes" class="form-label fw-semibold">Notes</label>
                        <textarea class="form-control" id="notes" name="notes" rows="2" placeholder="Additional notes..."></textarea>
                    </div>
                    <input type="hidden" name="customer_id" value="{{ $invoice->CustomerID }}">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-save mr-2"></i> Record Payment
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Send Bill Modal -->
<div class="modal fade" id="sendBillModal" tabindex="-1" role="dialog" aria-labelledby="sendBillModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-to-r from-yellow-500 to-orange-500 text-white">
                <h5 class="modal-title" id="sendBillModalLabel">
                    <i class="fas fa-paper-plane mr-2"></i> Send Bill to Customer
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="sendBillForm" name="sendBillForm" action="{{ route('invoices.rent.send', $invoice->BillID) }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="sendTo" class="form-label fw-semibold">Send To</label>
                        <div class="input-group">
                            <span class="input-group-text bg-light">
                                <i class="fas fa-envelope text-blue-500"></i>
                            </span>
                            <input type="email" class="form-control" id="sendTo" name="email" value="{{ $invoice->customer->CustomerEmail ?? ($invoice->customer->Email ?? '') }}" required>
                        </div>
                        @if(empty($invoice->customer->CustomerEmail) && empty($invoice->customer->Email))
                            <div class="alert alert-warning mt-2">
                                <i class="fas fa-exclamation-triangle mr-2"></i>
                                No email address found for this customer. Please add an email address to send the bill.
                            </div>
                        @endif
                    </div>
                    <div class="mb-3">
                        <label for="emailSubject" class="form-label fw-semibold">Subject</label>
                        <textarea class="form-control" id="emailSubject" name="subject" rows="2" placeholder="Loading..." readonly></textarea>
                        <small class="text-muted">Using company email template</small>
                    </div>
                    <input type="hidden" name="message" value="Dear {{ $invoice->customer->CustomerName ?? 'Valued Customer' }},

Please find attached your bill #{{ $invoice->BillID }} for {{ $invoice->BillingPeriod }}.

Account Number: {{ $invoice->customer->AccountNo ?? 'N/A' }}

Thank you for your business.

Best regards,
{{ config('app.name') }}">
                    <input type="hidden" name="include_pdf" value="1">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="sendBillButton">
                        <span id="sendBillButtonText">Send Bill</span>
                        <span class="spinner-border spinner-border-sm d-none" id="sendBillSpinner" role="status" aria-hidden="true"></span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Add Adjustment Modal -->
<div class="modal fade" id="addAdjustmentModal" tabindex="-1" role="dialog" aria-labelledby="addAdjustmentModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-to-r from-blue-500 to-indigo-600 text-white">
                <h5 class="modal-title" id="addAdjustmentModalLabel">
                    <i class="fas fa-adjust mr-2"></i> Add Adjustment
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('invoices.rent.adjustment', $invoice->BillID) }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="adjustmentType" class="form-label fw-semibold">Adjustment Type</label>
                        <select class="form-select" id="adjustmentType" name="type" required>
                            <option value="discount">Discount</option>
                            <option value="surcharge">Surcharge</option>
                            <option value="penalty">Penalty</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="adjustmentAmount" class="form-label fw-semibold">Amount</label>
                        <div class="input-group">
                            <span class="input-group-text bg-light">KES</span>
                            <input type="number" step="0.01" class="form-control" id="adjustmentAmount" name="amount" required>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="adjustmentReason" class="form-label fw-semibold">Reason</label>
                        <input type="text" class="form-control" id="adjustmentReason" name="reason" placeholder="Enter adjustment reason" required>
                    </div>
                    <div class="mb-3">
                        <label for="adjustmentNotes" class="form-label fw-semibold">Notes</label>
                        <textarea class="form-control" id="adjustmentNotes" name="notes" rows="2" placeholder="Additional notes..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-info">
                        <i class="fas fa-save mr-2"></i> Add Adjustment
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
