<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
        <link href="https://fonts.bunny.net/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.3.3/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/2.3.6/css/dataTables.bootstrap5.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/scroller/2.4.3/css/scroller.bootstrap5.css">
    <!-- SweetAlert2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <script>
        // Initialize Alpine.js store after Alpine is loaded
        document.addEventListener('alpine:init', () => {
                // Initialize closed on small screens, open on large screens
            const isLargeScreen = window.innerWidth >= 768;
            
            Alpine.store('sidebar', {
                open: isLargeScreen, // false on small screens, true on large screens
                touchStartX: 0,
                touchEndX: 0,
                isDragging: false,
                
                init() {
                    // Handle click outside to close sidebar on mobile
                    const handleClickOutside = (e) => {
                        const sidebar = document.querySelector('.sidebar-container');
                        const menuButton = document.querySelector('.mobile-menu-button');
                        
                        if (window.innerWidth >= 768) return;
                        if (!this.open) return;
                        
                        const isClickInside = sidebar.contains(e.target) || menuButton.contains(e.target);
                        
                        if (!isClickInside) {
                            this.close();
                        }
                    };
                    
                    // Add event listener with proper cleanup
                    document.addEventListener('click', handleClickOutside);
                    
                    // Cleanup function
                    this.cleanup = () => {
                        document.removeEventListener('click', handleClickOutside);
                    };
                    
                    // Enhanced touch handling for swipe gestures
                let touchStartX = 0;
                let touchStartTime = 0;
                const swipeThreshold = 50; // Minimum distance to trigger swipe
                const swipeTimeThreshold = 300; // Maximum time for swipe in ms

                document.addEventListener('touchstart', (e) => {
                    if (window.innerWidth >= 768) return;
                    touchStartX = e.touches[0].clientX;
                    touchStartTime = Date.now();
                    this.isDragging = true;
                    
                    // Add transition class for smooth animation
                    const sidebar = document.querySelector('.sidebar-container');
                    if (sidebar) {
                        sidebar.classList.add('transition-transform', 'duration-300', 'ease-in-out');
                    }
                }, { passive: true });
                
                document.addEventListener('touchmove', (e) => {
                    if (!this.isDragging || window.innerWidth >= 768) return;
                    
                    const currentX = e.touches[0].clientX;
                    const diff = touchStartX - currentX;
                    
                    // Only allow left swipes when closed, right swipes when open
                    if ((!this.open && diff > 0) || (this.open && diff < 0)) {
                        return;
                    }
                    
                    // Calculate transform based on swipe distance
                    const transform = this.open ? Math.min(0, -diff) : Math.max(-this.$refs.sidebar.offsetWidth, -this.$refs.sidebar.offsetWidth + diff);
                    this.$refs.sidebar.style.transform = `translateX(${transform}px)`;
                    
                    // Add overlay opacity based on swipe progress
                    const overlay = document.querySelector('.sidebar-overlay');
                    if (overlay) {
                        const opacity = Math.min(0.5, Math.abs(transform) / this.$refs.sidebar.offsetWidth * 0.5);
                        overlay.style.opacity = opacity;
                    }
                }, { passive: false });
                
                document.addEventListener('touchend', () => {
                    if (!this.isDragging || window.innerWidth >= 768) {
                        this.isDragging = false;
                        return;
                    }
                    
                    const touchEndTime = Date.now();
                    const timeDiff = touchEndTime - touchStartTime;
                    const diff = touchStartX - this.touchEndX;
                    
                    // Reset transform
                    this.$refs.sidebar.style.transform = '';
                    
                    // Check if it's a valid swipe
                    if (timeDiff > swipeTimeThreshold) {
                        this.isDragging = false;
                        return;
                    }
                    
                    // Swipe right to open
                    if (diff < -swipeThreshold && !this.open) {
                        this.open = true;
                    } 
                    // Swipe left to close
                    else if (diff > swipeThreshold && this.open) {
                        this.close();
                    }
                    
                    this.isDragging = false;
                }, { passive: true });
                    
                    // Close sidebar when route changes on mobile
                    window.addEventListener('popstate', () => {
                        if (window.innerWidth < 768) {
                            this.close();
                        }
                    });
                },
                
                toggle() {
                    this.open = !this.open;
                    // Add/remove overflow hidden to body when mobile menu is open
                    if (window.innerWidth < 768) {
                        document.body.style.overflow = this.open ? 'hidden' : '';
                    }
                },
                
                close() {
                    if (window.innerWidth < 768) {
                        this.open = false;
                        document.body.style.overflow = '';
                        // Remove the overlay if it exists
                        const overlay = document.querySelector('.sidebar-overlay');
                        if (overlay) {
                            overlay.remove();
                        }
                    }
                },
                
                // Cleanup function to remove event listeners
                cleanup() {
                    // This will be set in the init function
                },
                
                handleResize() {
                    const isNowLargeScreen = window.innerWidth >= 768;
                    const wasLargeScreen = this.open && window.innerWidth >= 768;
                    
                    // If switching to large screen, ensure sidebar is open
                    if (isNowLargeScreen) {
                        this.open = true;
                        document.body.style.overflow = '';
                    } 
                    // If switching to small screen and sidebar was closed, keep it closed
                    else if (!isNowLargeScreen && !this.open) {
                        this.open = false;
                    }
                    
                    // Force update the DOM to reflect the changes
                    this.$nextTick(() => {
                        // This ensures the DOM updates with the new state
                        this.$el.getBoundingClientRect();
                    });
                }
            });
            
            // Debounced resize handler
            let resizeTimer;
            const handleResize = () => {
                clearTimeout(resizeTimer);
                resizeTimer = setTimeout(() => {
                    Alpine.store('sidebar').handleResize();
                }, 100);
            };
            
            window.addEventListener('resize', handleResize);
            
            // Cleanup resize listener
            Alpine.store('sidebar').cleanup = () => {
                window.removeEventListener('resize', handleResize);
            };
        });
        
        // Close sidebar when clicking on a navigation link on mobile
        document.addEventListener('alpine:initialized', () => {
            document.querySelectorAll('a[href^="/"]').forEach(link => {
                link.addEventListener('click', () => {
                    if (window.innerWidth < 768) {
                        Alpine.store('sidebar').close();
                    }
                });
            });
        });
    </script>
    
    @stack('styles')
    
    <!-- Custom scrollbar styles -->
    <style>
    /* Custom scrollbar with primary color */
    ::-webkit-scrollbar {
        width: 12px;
        height: 12px; /* For horizontal scrollbar */
    }

    ::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 10px;
    }

    ::-webkit-scrollbar-thumb {
        background: #0d6efd; /* Bootstrap primary color */
        border-radius: 10px;
        border: 2px solid #f1f1f1;
    }

    ::-webkit-scrollbar-thumb:hover {
        background: #0b5ed7; /* Darker primary color on hover */
    }

    /* Firefox scrollbar */
    * {
        scrollbar-width: thin;
        scrollbar-color: #0d6efd #f1f1f1;
    }
    </style>
    </head>
    <body class="font-sans antialiased bg-sulis-gray-50" x-data="{}" x-init="$store.sidebar.init()">
        <div class="min-h-screen flex flex-col md:flex-row">
            <!-- Mobile menu button -->
            <div class="md:hidden bg-sulis-blue p-2 fixed top-0 left-0 right-0 z-40 flex items-center justify-between">
                <button @click="$store.sidebar.toggle()" 
                        class="mobile-menu-button p-2 rounded-md text-white hover:bg-sulis-blue-dark focus:outline-none focus:ring-2 focus:ring-sulis-yellow focus:ring-offset-2"
                        :aria-expanded="$store.sidebar.open"
                        aria-label="Toggle navigation">
                    <svg class="h-6 w-6 transition-transform duration-200" 
                         :class="{'rotate-90': $store.sidebar.open}" 
                         fill="none" 
                         viewBox="0 0 24 24" 
                         stroke="currentColor">
                        <path x-show="!$store.sidebar.open" 
                              class="inline-flex" 
                              stroke-linecap="round" 
                              stroke-linejoin="round" 
                              stroke-width="2" 
                              d="M4 6h16M4 12h16M4 18h16" />
                        <path x-show="$store.sidebar.open" 
                              class="inline-flex" 
                              stroke-linecap="round" 
                              stroke-linejoin="round" 
                              stroke-width="2" 
                              d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
                <div class="text-white font-semibold px-2">
                    {{ config('app.name', 'PropertyMgt') }}
                </div>
                <div class="w-10"></div> <!-- Spacer for centering -->
            </div>

            <!-- Enhanced overlay with better touch handling -->
            <div x-show="$store.sidebar.open && window.innerWidth < 768" 
                 x-transition:enter="transition-opacity duration-200 ease-in-out"
                 x-transition:enter-start="opacity-0"
                 x-transition:enter-end="opacity-50"
                 x-transition:leave="transition-opacity duration-200 ease-in-out"
                 x-transition:leave-start="opacity-50"
                 x-transition:leave-end="opacity-0"
                 class="sidebar-overlay fixed inset-0 z-20 bg-black bg-opacity-50 backdrop-blur-sm"
                 @click="$store.sidebar.close()"
                 @touchmove.prevent
                 aria-hidden="true">
            </div>

            <!-- Sidebar with enhanced transitions and touch support -->
            <div x-ref="sidebar"
                 x-show="$store.sidebar.open || window.innerWidth >= 768"
                 x-transition:enter="transition-transform duration-300 ease-in-out"
                 x-transition:enter-start="-translate-x-full"
                 x-transition:enter-end="translate-x-0"
                 x-transition:leave="transition-transform duration-300 ease-in-out"
                 x-transition:leave-start="translate-x-0"
                 x-transition:leave-end="-translate-x-full"
                 :class="{
                     'fixed inset-y-0 left-0 z-30 w-72 flex flex-col bg-sulis-blue shadow-lg transform': true,
                     'md:relative': true,
                     'translate-x-0': $store.sidebar.open || window.innerWidth >= 768,
                     '-translate-x-full': !$store.sidebar.open && window.innerWidth < 768
                 }"
                 :class="{
                    '-translate-x-full md:translate-x-0': !$store.sidebar.open, 
                    'translate-x-0': $store.sidebar.open
                }"
                 @keydown.escape.window="if (window.innerWidth < 768) $store.sidebar.close()">
                @include('layouts.components.sidebar')
            </div>

            <!-- Main Content -->
            <div class="flex-1 flex flex-col h-screen overflow-hidden transition-all duration-300 ease-in-out"
                 :class="{'ml-0': !$store.sidebar.open && window.innerWidth < 768, 'md:ml-0': $store.sidebar.open && window.innerWidth >= 768}">
                <!-- Top Navigation -->
                 @include('layouts.components.header')

                <!-- Page Content -->
                <main class="flex-1 overflow-y-auto focus:outline-none bg-sulis-gray-50">
                    <div class="py-4 md:py-6">
                        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                            @if (session('status'))
                                <div class="mb-4 font-medium text-sm text-green-600">
                                </div>
                            @endif

                            @if (session('error'))
                                <div class="mb-6 bg-red-50 border-l-4 border-red-400 p-4 rounded-md">
                                    <div class="flex">
                                        <div class="flex-shrink-0">
                                            <svg class="h-5 w-5 text-red-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414-1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                                            </svg>
                                        </div>
                                        <div class="ml-3">
                                            <p class="text-sm text-red-700">
                                                {{ session('error') }}
                                            </p>
                                        </div>
                                        <div class="ml-auto pl-3">
                                            <div class="-mx-1.5 -my-1.5">
                                                <button type="button" class="inline-flex rounded-md p-1.5 text-red-500 hover:bg-red-100 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-600">
                                                    <span class="sr-only">Dismiss</span>
                                                    <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                        <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" />
                                                    </svg>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                            
                            @yield('content')
                        </div>
                    </div>
                </main>

                <!-- Footer -->
                <!-- <div class="flex-shrink-0">
                    <x-footer />
                </div> -->
            </div>
        </div>

        <!-- Scripts -->
        <!-- jQuery (required for Bootstrap) -->
        <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
        
        <!-- SweetAlert2 -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        
        @if (session('success'))
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                Swal.fire({
                    icon: 'success',
                    title: 'Success!',
                    text: '{{ session('success') }}',
                    confirmButtonColor: '#0000FF',
                    confirmButtonText: 'OK'
                });
            });
        </script>
        @endif
        
        @if (session('sweet_alert'))
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                Swal.fire({
                    icon: '{{ session('sweet_alert.icon') }}',
                    title: '{{ session('sweet_alert.title') }}',
                    text: '{{ session('sweet_alert.text') }}',
                    confirmButtonText: '{{ session('sweet_alert.confirmButtonText') }}'
                });
            });
        </script>
        @endif
        
        <!-- Toastr CSS -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
        
        <!-- Alpine.js with Collapse plugin -->
        <script defer src="https://unpkg.com/@alpinejs/collapse@3.x.x/dist/cdn.min.js"></script>
        <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
        <script>
            document.addEventListener('alpine:init', () => {
                // Initialize any Alpine.js components here if needed
            });
        </script>
        
        <!-- Bootstrap JS Bundle with Popper -->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
        
        <!-- Toastr JS -->
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
        
        <!-- Custom scripts -->
        @stack('scripts')
        
        <script>
            // Handle close button for success messages
            document.addEventListener('DOMContentLoaded', function() {
                const closeButtons = document.querySelectorAll('[data-dismiss="alert"]');
                closeButtons.forEach(button => {
                    button.addEventListener('click', function() {
                        this.closest('.bg-green-100').style.display = 'none';
                    });
                });
            });

            // Initialize Alpine.js
            document.addEventListener('alpine:init', () => {
                Alpine.data('app', () => ({
                    mobileMenuOpen: false,
                    init() {
                        // Close mobile menu when screen is resized to desktop
                        const handleResize = () => {
                            if (window.innerWidth >= 768) {
                                this.mobileMenuOpen = false;
                            }
                        };
                        
                        window.addEventListener('resize', handleResize);
                        
                        // Clean up event listener
                        this.$watch('mobileMenuOpen', () => {
                            if (this.mobileMenuOpen) {
                                document.body.classList.add('overflow-hidden');
                            } else {
                                document.body.classList.remove('overflow-hidden');
                            }
                        });
                        
                        // Close mobile menu when clicking on a nav link
                        document.querySelectorAll('a[href^="/"]').forEach(link => {
                            link.addEventListener('click', () => {
                                if (window.innerWidth < 768) {
                                    this.mobileMenuOpen = false;
                                }
                            });
                        });
                    }
                }));
            });
        </script>
    </body>
</html>
