  <header class="bg-white shadow-sm z-10 sticky top-0 flex-shrink-0 border-b border-gray-100 transition-all duration-300 hover:shadow-md">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-16">
            <!-- Mobile menu button (visible on mobile only) -->
            <div class="flex items-center md:hidden">
                <button @click="$dispatch('toggle-sidebar')" class="p-2 rounded-md text-gray-700 hover:text-sulis-blue focus:outline-none focus:ring-2 focus:ring-sulis-yellow">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path x-show="!$store.sidebar.open" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path x-show="$store.sidebar.open" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>

            <!-- Logo / Branding -->
            <div class="flex-shrink-0 flex items-center">
                <h1 class="text-xl font-semibold text-gray-800 flex items-center">
                    <i class="fas fa-building text-sulis-blue mr-2 text-xl"></i>
                    <span class="text-gray-700">{{ Auth::user()->company->CompanyName ?? 'Company' }}</span>
                </h1>
            </div>

            <!-- Right side navigation -->
            <div class="flex items-center space-x-6">
                <!-- Notification Bell -->
                <button class="p-1 rounded-full text-gray-500 hover:text-sulis-blue focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-sulis-yellow transition-colors duration-200">
                    <span class="sr-only">View notifications</span>
                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9" />
                    </svg>
                </button>

                <!-- User Profile Dropdown -->
                <x-dropdown align="right" width="48">
                    <x-slot name="trigger">
                        <button class="flex items-center text-sm font-medium text-gray-700 hover:text-sulis-blue focus:outline-none transition-all duration-200 group">
                            <div class="flex items-center space-x-2">
                                <span class="inline-flex items-center justify-center h-9 w-9 rounded-full bg-sulis-yellow text-sulis-blue font-semibold text-sm transform transition-transform group-hover:scale-105">
                                    {{ strtoupper(substr(Auth::user()->name, 0, 1)) }}
                                </span>
                                <div class="hidden md:flex flex-col items-start">
                                    <span class="text-sm font-medium text-gray-800">{{ Auth::user()->name }}</span>
                                    <span class="text-xs text-gray-500">{{ Auth::user()->email }}</span>
                                </div>
                                <svg class="ml-1 h-4 w-4 text-gray-400 group-hover:text-sulis-blue transition-colors" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                </svg>
                            </div>
                        </button>
                    </x-slot>

                    <x-slot name="content">
                        <div class="px-4 py-3 border-b border-gray-100">
                            <p class="text-sm text-gray-500">Signed in as</p>
                            <p class="text-sm font-medium text-gray-900 truncate">{{ Auth::user()->email }}</p>
                        </div>
                        
                        <x-dropdown-link :href="route('profile.edit')" class="group">
                            <i class="fas fa-user-circle mr-2 text-gray-400 group-hover:text-sulis-blue"></i>
                            {{ __('Profile Settings') }}
                        </x-dropdown-link>
                        
                        <div class="border-t border-gray-100"></div>
                        
                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <x-dropdown-link 
                                :href="route('logout')"
                                onclick="event.preventDefault(); this.closest('form').submit();"
                                class="group text-red-600 hover:bg-red-50"
                            >
                                <i class="fas fa-sign-out-alt mr-2"></i>
                                {{ __('Sign out') }}
                            </x-dropdown-link>
                        </form>
                    </x-slot>
                </x-dropdown>
            </div>
        </div>
    </div>
</header>