@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h1 class="h3 mb-0">
                    <i class="fas fa-tools me-2"></i>Maintenance Requests
                </h1>
                <div>
                    <a href="{{ route('maintenance-requests.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus me-1"></i> New Request
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            @if($maintenanceRequests->isEmpty())
                <div class="text-center py-5">
                    <i class="fas fa-tools fa-4x text-muted mb-3"></i>
                    <h4 class="text-muted">No maintenance requests found</h4>
                    <p class="text-muted">Create your first maintenance request by clicking the button above.</p>
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>ID</th>
                                <th>Unit</th>
                                <th>Customer</th>
                                <th>Title</th>
                                <th>Status</th>
                                <th>Assigned To</th>
                                <th>Created</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($maintenanceRequests as $request)
                                <tr>
                                    <td>#{{ $request->request_id }}</td>
                                    <td>{{ $request->unit->UnitIdentity ?? 'N/A' }}</td>
                                    <td>{{ $request->customer->CustomerName ?? 'N/A' }}</td>
                                    <td>{{ $request->title }}</td>
                                    <td>
                                        @php
                                            $statusClass = [
                                                'Pending' => 'badge bg-warning',
                                                'In Progress' => 'badge bg-info',
                                                'Completed' => 'badge bg-success',
                                                'Cancelled' => 'badge bg-danger',
                                            ][$request->status] ?? 'badge bg-secondary';
                                        @endphp
                                        <span class="{{ $statusClass }}">{{ $request->status }}</span>
                                    </td>
                                    <td>{{ $request->technician->name ?? 'Unassigned' }}</td>
                                    <td>{{ $request->created_at->format('M d, Y') }}</td>
                                    <td>
                                        <a href="{{ route('maintenance-requests.show', $request->request_id) }}" 
                                           class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <div class="mt-4">
                    {{ $maintenanceRequests->links() }}
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
