@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h1 class="h3 mb-0">
                    <i class="fas fa-tools me-2"></i>Maintenance Request #{{ $maintenanceRequest->request_id }}
                </h1>
                <div>
                    <a href="{{ route('maintenance-requests.edit', $maintenanceRequest->request_id) }}" class="btn btn-primary">
                        <i class="fas fa-edit me-1"></i> Edit
                    </a>
                    <a href="{{ route('maintenance-requests.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-1"></i> Back to List
                    </a>
                </div>
            </div>
            <nav aria-label="breadcrumb" class="mt-2">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('maintenance-requests.index') }}">Maintenance Requests</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Request #{{ $maintenanceRequest->request_id }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Request Details</h5>
                </div>
                <div class="card-body">
                    <h4 class="mb-3">{{ $maintenanceRequest->title }}</h4>
                    <p class="text-muted">{{ $maintenanceRequest->description }}</p>
                    
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h6 class="text-muted">Request Information</h6>
                            <ul class="list-unstyled">
                                <li class="mb-2">
                                    <strong>Category:</strong> 
                                    <span class="badge bg-info">{{ $maintenanceRequest->category ?? 'N/A' }}</span>
                                </li>
                                <li class="mb-2">
                                    <strong>Priority:</strong> 
                                    @php
                                        $priorityClass = [
                                            'low' => 'bg-secondary',
                                            'medium' => 'bg-warning',
                                            'high' => 'bg-danger'
                                        ][$maintenanceRequest->priority] ?? 'bg-secondary';
                                    @endphp
                                    <span class="badge {{ $priorityClass }}">
                                        {{ ucfirst($maintenanceRequest->priority ?? 'N/A') }}
                                    </span>
                                </li>
                                <li class="mb-2">
                                    <strong>Status:</strong> 
                                    @php
                                        $statusClass = [
                                            'pending' => 'bg-secondary',
                                            'in_progress' => 'bg-primary',
                                            'completed' => 'bg-success',
                                            'cancelled' => 'bg-danger'
                                        ][$maintenanceRequest->status] ?? 'bg-secondary';
                                    @endphp
                                    <span class="badge {{ $statusClass }}">
                                        {{ ucfirst(str_replace('_', ' ', $maintenanceRequest->status ?? 'N/A')) }}
                                    </span>
                                </li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h6 class="text-muted">Location</h6>
                            <ul class="list-unstyled">
                                <li class="mb-2"><strong>Property:</strong> {{ $maintenanceRequest->property->PropName ?? 'N/A' }}</li>
                                <li class="mb-2"><strong>Block:</strong> {{ $maintenanceRequest->block->BlockName ?? 'N/A' }}</li>
                                <li class="mb-2"><strong>Unit:</strong> {{ $maintenanceRequest->unit->UnitIdentity ?? 'N/A' }}</li>
                            </ul>
                        </div>
                    </div>

                    @if($maintenanceRequest->assigned_technician_id)
                        <div class="mt-4">
                            <h6 class="text-muted">Assigned Technician</h6>
                            <div class="d-flex align-items-center">
                                <div class="avatar avatar-md me-3">
                                    <span class="avatar-text bg-primary">
                                        {{ substr($maintenanceRequest->technician->name ?? 'T', 0, 1) }}
                                    </span>
                                </div>
                                <div>
                                    <h6 class="mb-0">{{ $maintenanceRequest->technician->name ?? 'N/A' }}</h6>
                                    <small class="text-muted">Assigned on: {{ $maintenanceRequest->assigned_date ? \Carbon\Carbon::parse($maintenanceRequest->assigned_date)->format('M d, Y') : 'N/A' }}</small>
                                </div>
                            </div>
                        </div>
                    @endif

                    @if($maintenanceRequest->resolution_notes)
                        <div class="mt-4">
                            <h6 class="text-muted">Resolution Notes</h6>
                            <div class="p-3 bg-light rounded">
                                {{ $maintenanceRequest->resolution_notes }}
                            </div>
                        </div>
                    @endif
                </div>
                <div class="card-footer bg-light">
                    <small class="text-muted">
                        Created by {{ $maintenanceRequest->creator->name ?? 'System' }} 
                        on {{ $maintenanceRequest->created_at->format('M d, Y \a\t h:i A') }}
                        @if($maintenanceRequest->updated_at != $maintenanceRequest->created_at)
                            <br>Last updated on {{ $maintenanceRequest->updated_at->format('M d, Y \a\t h:i A') }}
                        @endif
                    </small>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Customer Information</h5>
                </div>
                <div class="card-body">
                    @if($maintenanceRequest->customer)
                        <div class="text-center mb-3">
                            <div class="avatar avatar-xxl mb-2">
                                <span class="avatar-text bg-primary">
                                    {{ substr($maintenanceRequest->customer->CustomerName, 0, 1) }}
                                </span>
                            </div>
                            <h5>{{ $maintenanceRequest->customer->CustomerName }}</h5>
                            <p class="text-muted">
                                <i class="fas fa-phone-alt me-1"></i> {{ $maintenanceRequest->customer->Phone1 ?? 'N/A' }}
                                @if($maintenanceRequest->customer->Phone2)
                                    <br><i class="fas fa-mobile-alt me-1"></i> {{ $maintenanceRequest->customer->Phone2 }}
                                @endif
                            </p>
                        </div>
                        <div class="border-top pt-3">
                            <h6>Contact Information</h6>
                            <ul class="list-unstyled">
                                <li class="mb-2">
                                    <i class="fas fa-envelope me-2 text-muted"></i>
                                    {{ $maintenanceRequest->customer->Email ?? 'N/A' }}
                                </li>
                                <li class="mb-2">
                                    <i class="fas fa-map-marker-alt me-2 text-muted"></i>
                                    {{ $maintenanceRequest->customer->Address1 ?? 'N/A' }}
                                </li>
                            </ul>
                        </div>
                    @else
                        <div class="text-center text-muted py-4">
                            <i class="fas fa-user-slash fa-2x mb-3"></i>
                            <p class="mb-0">No customer information available</p>
                        </div>
                    @endif
                </div>
            </div>

            @if($maintenanceRequest->attachment_path)
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Attachments</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-paperclip fa-2x text-muted me-3"></i>
                            <div>
                                <a href="{{ asset('storage/' . $maintenanceRequest->attachment_path) }}" target="_blank" class="d-block">
                                    View Attachment
                                </a>
                                <small class="text-muted">
                                    {{ pathinfo($maintenanceRequest->attachment_path, PATHINFO_EXTENSION) | strtoupper }} File
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            <!-- Upcoming Rent Due -->
            <div class="card shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0">Upcoming Rent Due</h5>
                </div>
                <div class="card-body p-0">
                    @if($upcomingRentDues->isEmpty())
                        <div class="text-center py-4">
                            <i class="fas fa-check-circle fa-2x text-success mb-2"></i>
                            <p class="mb-0 text-muted">No upcoming rent dues</p>
                        </div>
                    @else
                        <div class="list-group list-group-flush">
                            @foreach($upcomingRentDues as $rentDue)
                                <div class="list-group-item list-group-item-action">
                                    <div class="d-flex w-100 justify-content-between align-items-center">
                                        <h6 class="mb-1">{{ $rentDue->unit }}</h6>
                                        <span class="badge {{ $rentDue->badgeClass }}">{{ $rentDue->status }}</span>
                                    </div>
                                    <p class="mb-1 text-muted">{{ $rentDue->dueText }}</p>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="fw-bold">Ksh {{ $rentDue->amount }}</span>
                                        <a href="{{ route('payments.create', ['bill_id' => $rentDue->billId]) }}" class="btn btn-sm btn-outline-primary">
                                            Pay Now
                                        </a>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
                @if($upcomingRentDues->isNotEmpty())
                    <div class="card-footer bg-light text-center">
                        <a href="{{ route('rent-payments.index', ['unit_id' => $maintenanceRequest->unit_id]) }}" class="text-primary">
                            View All Rent Payments
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
