@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-users"></i> Meter Readers Management
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('meter-readers.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Add Meter Reader
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Username</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Assigned Property</th>
                                    <th>Created</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($meterReaders as $meterReader)
                                    <tr>
                                        <td>{{ $meterReader->id }}</td>
                                        <td>{{ $meterReader->first_name }} {{ $meterReader->last_name }}</td>
                                        <td>{{ $meterReader->username }}</td>
                                        <td>{{ $meterReader->email }}</td>
                                        <td>{{ $meterReader->phone_number }}</td>
                                        <td>
                                            @if($meterReader->property)
                                                {{ $meterReader->property->PropName }}
                                            @else
                                                <span class="text-muted">Not Assigned</span>
                                            @endif
                                        </td>
                                        <td>{{ $meterReader->created_at->format('d-M-Y') }}</td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('meter-readers.show', $meterReader) }}" class="btn btn-info btn-sm" title="View">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('meter-readers.edit', $meterReader) }}" class="btn btn-warning btn-sm" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('meter-readers.destroy', $meterReader) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this meter reader?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm" title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">
                                            <div class="py-4">
                                                <i class="fas fa-users fa-3x text-muted mb-3"></i>
                                                <h5 class="text-muted">No Meter Readers Found</h5>
                                                <p class="text-muted mb-3">Get started by creating your first meter reader.</p>
                                                <a href="{{ route('meter-readers.create') }}" class="btn btn-primary">
                                                    <i class="fas fa-plus"></i> Add First Meter Reader
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    @if($meterReaders->hasPages())
                        <div class="d-flex justify-content-center mt-3">
                            {{ $meterReaders->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
